// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/sample/report/ReportTesterTemplate_handler_service.proto

package istio_mixer_adapter_sample_report

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Request message for HandleReport method.
type HandleReportRequest struct {
	// 'report' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleReportRequest) Reset()      { *m = HandleReportRequest{} }
func (*HandleReportRequest) ProtoMessage() {}
func (*HandleReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{0}
}
func (m *HandleReportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HandleReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleReportRequest.Merge(m, src)
}
func (m *HandleReportRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleReportRequest proto.InternalMessageInfo

// Contains instance payload for 'report' template. This is passed to infrastructure backends during request-time
// through HandleReportService.HandleReport.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name            string                    `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	Value           *v1beta1.Value            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions      map[string]*v1beta1.Value `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive  int64                     `protobuf:"varint,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	BoolPrimitive   bool                      `protobuf:"varint,4,opt,name=boolPrimitive,proto3" json:"boolPrimitive,omitempty"`
	DoublePrimitive float64                   `protobuf:"fixed64,5,opt,name=doublePrimitive,proto3" json:"doublePrimitive,omitempty"`
	StringPrimitive string                    `protobuf:"bytes,6,opt,name=stringPrimitive,proto3" json:"stringPrimitive,omitempty"`
	Int64Map        map[string]int64          `protobuf:"bytes,7,rep,name=int64Map,proto3" json:"int64Map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	TimeStamp       *v1beta1.TimeStamp        `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration        *v1beta1.Duration         `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	Res1            *Res1Msg                  `protobuf:"bytes,11,opt,name=res1,proto3" json:"res1,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{1}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

type Res1Msg struct {
	Value           *v1beta1.Value            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions      map[string]*v1beta1.Value `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive  int64                     `protobuf:"varint,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	BoolPrimitive   bool                      `protobuf:"varint,4,opt,name=boolPrimitive,proto3" json:"boolPrimitive,omitempty"`
	DoublePrimitive float64                   `protobuf:"fixed64,5,opt,name=doublePrimitive,proto3" json:"doublePrimitive,omitempty"`
	StringPrimitive string                    `protobuf:"bytes,6,opt,name=stringPrimitive,proto3" json:"stringPrimitive,omitempty"`
	Int64Map        map[string]int64          `protobuf:"bytes,7,rep,name=int64Map,proto3" json:"int64Map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	TimeStamp       *v1beta1.TimeStamp        `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration        *v1beta1.Duration         `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	Res2            *Res2Msg                  `protobuf:"bytes,11,opt,name=res2,proto3" json:"res2,omitempty"`
	Res2Map         map[string]*Res2Msg       `protobuf:"bytes,12,rep,name=res2_map,json=res2Map,proto3" json:"res2_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Res1Msg) Reset()      { *m = Res1Msg{} }
func (*Res1Msg) ProtoMessage() {}
func (*Res1Msg) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{2}
}
func (m *Res1Msg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res1Msg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res1Msg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res1Msg.Merge(m, src)
}
func (m *Res1Msg) XXX_Size() int {
	return m.Size()
}
func (m *Res1Msg) XXX_DiscardUnknown() {
	xxx_messageInfo_Res1Msg.DiscardUnknown(m)
}

var xxx_messageInfo_Res1Msg proto.InternalMessageInfo

type Res2Msg struct {
	Value          *v1beta1.Value            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions     map[string]*v1beta1.Value `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive int64                     `protobuf:"varint,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	TimeStamp      *v1beta1.TimeStamp        `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration       *v1beta1.Duration         `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	IpAddr         *v1beta1.IPAddress        `protobuf:"bytes,11,opt,name=ip_addr,json=ipAddr,proto3" json:"ip_addr,omitempty"`
	DnsName        *v1beta1.DNSName          `protobuf:"bytes,12,opt,name=dns_name,json=dnsName,proto3" json:"dns_name,omitempty"`
	EmailAddr      *v1beta1.EmailAddress     `protobuf:"bytes,13,opt,name=email_addr,json=emailAddr,proto3" json:"email_addr,omitempty"`
	Uri            *v1beta1.Uri              `protobuf:"bytes,14,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (m *Res2Msg) Reset()      { *m = Res2Msg{} }
func (*Res2Msg) ProtoMessage() {}
func (*Res2Msg) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{3}
}
func (m *Res2Msg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res2Msg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res2Msg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res2Msg.Merge(m, src)
}
func (m *Res2Msg) XXX_Size() int {
	return m.Size()
}
func (m *Res2Msg) XXX_DiscardUnknown() {
	xxx_messageInfo_Res2Msg.DiscardUnknown(m)
}

var xxx_messageInfo_Res2Msg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'report' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	Value      v1beta1.ValueType            `protobuf:"varint,1,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType" json:"value,omitempty"`
	Dimensions map[string]v1beta1.ValueType `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
	Res1       *Res1Type                    `protobuf:"bytes,11,opt,name=res1,proto3" json:"res1,omitempty"`
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{4}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

type Res1Type struct {
	Value      v1beta1.ValueType            `protobuf:"varint,1,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType" json:"value,omitempty"`
	Dimensions map[string]v1beta1.ValueType `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
	Res2       *Res2Type                    `protobuf:"bytes,11,opt,name=res2,proto3" json:"res2,omitempty"`
	Res2Map    map[string]*Res2Type         `protobuf:"bytes,12,rep,name=res2_map,json=res2Map,proto3" json:"res2_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Res1Type) Reset()      { *m = Res1Type{} }
func (*Res1Type) ProtoMessage() {}
func (*Res1Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{5}
}
func (m *Res1Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res1Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res1Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res1Type.Merge(m, src)
}
func (m *Res1Type) XXX_Size() int {
	return m.Size()
}
func (m *Res1Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Res1Type.DiscardUnknown(m)
}

var xxx_messageInfo_Res1Type proto.InternalMessageInfo

type Res2Type struct {
	Value      v1beta1.ValueType            `protobuf:"varint,1,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType" json:"value,omitempty"`
	Dimensions map[string]v1beta1.ValueType `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Res2Type) Reset()      { *m = Res2Type{} }
func (*Res2Type) ProtoMessage() {}
func (*Res2Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{6}
}
func (m *Res2Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res2Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res2Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res2Type.Merge(m, src)
}
func (m *Res2Type) XXX_Size() int {
	return m.Size()
}
func (m *Res2Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Res2Type.DiscardUnknown(m)
}

var xxx_messageInfo_Res2Type proto.InternalMessageInfo

// Represents instance configuration schema for 'report' template.
type InstanceParam struct {
	Value           string             `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions      map[string]string  `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive  string             `protobuf:"bytes,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	BoolPrimitive   string             `protobuf:"bytes,4,opt,name=boolPrimitive,proto3" json:"boolPrimitive,omitempty"`
	DoublePrimitive string             `protobuf:"bytes,5,opt,name=doublePrimitive,proto3" json:"doublePrimitive,omitempty"`
	StringPrimitive string             `protobuf:"bytes,6,opt,name=stringPrimitive,proto3" json:"stringPrimitive,omitempty"`
	Int64Map        map[string]string  `protobuf:"bytes,7,rep,name=int64Map,proto3" json:"int64Map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	TimeStamp       string             `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration        string             `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	Res1            *Res1InstanceParam `protobuf:"bytes,11,opt,name=res1,proto3" json:"res1,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{7}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

type Res1InstanceParam struct {
	Value           string                        `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions      map[string]string             `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive  string                        `protobuf:"bytes,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	BoolPrimitive   string                        `protobuf:"bytes,4,opt,name=boolPrimitive,proto3" json:"boolPrimitive,omitempty"`
	DoublePrimitive string                        `protobuf:"bytes,5,opt,name=doublePrimitive,proto3" json:"doublePrimitive,omitempty"`
	StringPrimitive string                        `protobuf:"bytes,6,opt,name=stringPrimitive,proto3" json:"stringPrimitive,omitempty"`
	Int64Map        map[string]string             `protobuf:"bytes,7,rep,name=int64Map,proto3" json:"int64Map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	TimeStamp       string                        `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration        string                        `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	Res2            *Res2InstanceParam            `protobuf:"bytes,11,opt,name=res2,proto3" json:"res2,omitempty"`
	Res2Map         map[string]*Res2InstanceParam `protobuf:"bytes,12,rep,name=res2_map,json=res2Map,proto3" json:"res2_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Res1InstanceParam) Reset()      { *m = Res1InstanceParam{} }
func (*Res1InstanceParam) ProtoMessage() {}
func (*Res1InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{8}
}
func (m *Res1InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res1InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res1InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res1InstanceParam.Merge(m, src)
}
func (m *Res1InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *Res1InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_Res1InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_Res1InstanceParam proto.InternalMessageInfo

type Res2InstanceParam struct {
	Value          string            `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Dimensions     map[string]string `protobuf:"bytes,2,rep,name=dimensions,proto3" json:"dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Int64Primitive string            `protobuf:"bytes,3,opt,name=int64Primitive,proto3" json:"int64Primitive,omitempty"`
	TimeStamp      string            `protobuf:"bytes,9,opt,name=timeStamp,proto3" json:"timeStamp,omitempty"`
	Duration       string            `protobuf:"bytes,10,opt,name=duration,proto3" json:"duration,omitempty"`
	IpAddr         string            `protobuf:"bytes,11,opt,name=ip_addr,json=ipAddr,proto3" json:"ip_addr,omitempty"`
	DnsName        string            `protobuf:"bytes,12,opt,name=dns_name,json=dnsName,proto3" json:"dns_name,omitempty"`
	EmailAddr      string            `protobuf:"bytes,13,opt,name=email_addr,json=emailAddr,proto3" json:"email_addr,omitempty"`
	Uri            string            `protobuf:"bytes,14,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (m *Res2InstanceParam) Reset()      { *m = Res2InstanceParam{} }
func (*Res2InstanceParam) ProtoMessage() {}
func (*Res2InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_82f812d69f2a727f, []int{9}
}
func (m *Res2InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Res2InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Res2InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Res2InstanceParam.Merge(m, src)
}
func (m *Res2InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *Res2InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_Res2InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_Res2InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleReportRequest)(nil), "istio.mixer.adapter.sample.report.HandleReportRequest")
	proto.RegisterType((*InstanceMsg)(nil), "istio.mixer.adapter.sample.report.InstanceMsg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "istio.mixer.adapter.sample.report.InstanceMsg.DimensionsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "istio.mixer.adapter.sample.report.InstanceMsg.Int64MapEntry")
	proto.RegisterType((*Res1Msg)(nil), "istio.mixer.adapter.sample.report.Res1Msg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "istio.mixer.adapter.sample.report.Res1Msg.DimensionsEntry")
	proto.RegisterMapType((map[string]int64)(nil), "istio.mixer.adapter.sample.report.Res1Msg.Int64MapEntry")
	proto.RegisterMapType((map[string]*Res2Msg)(nil), "istio.mixer.adapter.sample.report.Res1Msg.Res2MapEntry")
	proto.RegisterType((*Res2Msg)(nil), "istio.mixer.adapter.sample.report.Res2Msg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "istio.mixer.adapter.sample.report.Res2Msg.DimensionsEntry")
	proto.RegisterType((*Type)(nil), "istio.mixer.adapter.sample.report.Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "istio.mixer.adapter.sample.report.Type.DimensionsEntry")
	proto.RegisterType((*Res1Type)(nil), "istio.mixer.adapter.sample.report.Res1Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "istio.mixer.adapter.sample.report.Res1Type.DimensionsEntry")
	proto.RegisterMapType((map[string]*Res2Type)(nil), "istio.mixer.adapter.sample.report.Res1Type.Res2MapEntry")
	proto.RegisterType((*Res2Type)(nil), "istio.mixer.adapter.sample.report.Res2Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "istio.mixer.adapter.sample.report.Res2Type.DimensionsEntry")
	proto.RegisterType((*InstanceParam)(nil), "istio.mixer.adapter.sample.report.InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.adapter.sample.report.InstanceParam.DimensionsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.adapter.sample.report.InstanceParam.Int64MapEntry")
	proto.RegisterType((*Res1InstanceParam)(nil), "istio.mixer.adapter.sample.report.Res1InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.adapter.sample.report.Res1InstanceParam.DimensionsEntry")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.adapter.sample.report.Res1InstanceParam.Int64MapEntry")
	proto.RegisterMapType((map[string]*Res2InstanceParam)(nil), "istio.mixer.adapter.sample.report.Res1InstanceParam.Res2MapEntry")
	proto.RegisterType((*Res2InstanceParam)(nil), "istio.mixer.adapter.sample.report.Res2InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "istio.mixer.adapter.sample.report.Res2InstanceParam.DimensionsEntry")
}

func init() {
	proto.RegisterFile("mixer/template/sample/report/ReportTesterTemplate_handler_service.proto", fileDescriptor_82f812d69f2a727f)
}

var fileDescriptor_82f812d69f2a727f = []byte{
	// 1244 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0xdd, 0x6f, 0xdb, 0x54,
	0x14, 0x8f, 0x93, 0x36, 0x89, 0x6f, 0x3f, 0x36, 0x2e, 0x45, 0xb8, 0x81, 0x79, 0x25, 0x42, 0x28,
	0x62, 0xc8, 0x56, 0xcd, 0x36, 0xaa, 0x96, 0x95, 0x75, 0x74, 0x62, 0x45, 0xac, 0xaa, 0xdc, 0xf2,
	0xa1, 0x82, 0x1a, 0xdc, 0xfa, 0x36, 0x5c, 0xe1, 0x2f, 0xec, 0x9b, 0xb2, 0xbc, 0x21, 0x24, 0xc4,
	0x1b, 0x42, 0x9a, 0x78, 0xe7, 0x91, 0x37, 0x1e, 0x79, 0x80, 0x3f, 0x60, 0xe2, 0xa9, 0xe2, 0xa9,
	0x2f, 0x48, 0x24, 0xdd, 0x03, 0x8f, 0x7b, 0x44, 0x42, 0x20, 0xe4, 0x6b, 0x3b, 0xb6, 0x13, 0x67,
	0xb5, 0xd3, 0x85, 0x6e, 0x4f, 0xb1, 0x9d, 0xdf, 0x39, 0xf7, 0x9c, 0xdf, 0xfd, 0x9d, 0x7b, 0x8e,
	0x0d, 0xde, 0xd2, 0xf1, 0x1d, 0x64, 0x8b, 0x04, 0xe9, 0x96, 0xa6, 0x10, 0x24, 0x3a, 0x8a, 0x6e,
	0x69, 0x48, 0xb4, 0x91, 0x65, 0xda, 0x44, 0x94, 0xe9, 0xcf, 0x16, 0x72, 0x08, 0xb2, 0xb7, 0x7c,
	0x48, 0xfd, 0x13, 0xc5, 0x50, 0x35, 0x64, 0xd7, 0x1d, 0x64, 0x1f, 0xe0, 0x3d, 0x24, 0x58, 0xb6,
	0x49, 0x4c, 0xf8, 0x02, 0x76, 0x08, 0x36, 0x05, 0xea, 0x4e, 0x50, 0x54, 0xc5, 0x22, 0xc8, 0x16,
	0x3c, 0x6f, 0x82, 0xe7, 0xad, 0x32, 0xd3, 0x30, 0x1b, 0x26, 0x45, 0x8b, 0xee, 0x95, 0x67, 0x58,
	0x79, 0xc5, 0x8b, 0xc0, 0x37, 0x11, 0x75, 0x53, 0x45, 0x9a, 0x78, 0x30, 0xbf, 0x8b, 0x88, 0x32,
	0x2f, 0xa2, 0x3b, 0x04, 0x19, 0x0e, 0x36, 0x0d, 0xc7, 0x47, 0xcf, 0x36, 0x4c, 0xb3, 0xa1, 0x21,
	0x91, 0xde, 0xed, 0x36, 0xf7, 0x45, 0xc5, 0x68, 0xf9, 0x7f, 0xd5, 0x1e, 0xe6, 0xc8, 0x0b, 0xc1,
	0x47, 0x5e, 0xb4, 0x4c, 0x0d, 0xef, 0xb5, 0xba, 0x7f, 0x1e, 0x28, 0x5a, 0x13, 0xd5, 0x49, 0xcb,
	0x42, 0xc1, 0x2a, 0x3d, 0x80, 0xf0, 0xaf, 0xea, 0xcf, 0x0c, 0x78, 0xfa, 0x16, 0x65, 0xc0, 0x23,
	0x47, 0x46, 0x9f, 0x35, 0x91, 0x43, 0xe0, 0x3b, 0x80, 0xc5, 0x86, 0x43, 0x14, 0x63, 0x0f, 0x39,
	0x1c, 0x33, 0x57, 0xa8, 0x4d, 0x48, 0x82, 0x70, 0x22, 0x27, 0xc2, 0x9a, 0x6f, 0x73, 0xdb, 0x69,
	0xc8, 0xa1, 0x03, 0xb8, 0x04, 0xa6, 0x7d, 0x7c, 0x7d, 0xcf, 0x34, 0xf6, 0x71, 0x83, 0xcb, 0xcf,
	0x31, 0xb5, 0x09, 0x69, 0x46, 0xf0, 0xf2, 0x17, 0x82, 0xfc, 0x85, 0x15, 0xa3, 0x25, 0x4f, 0xf9,
	0xd8, 0x37, 0x29, 0x14, 0xce, 0x82, 0xb2, 0x8a, 0xd4, 0xa6, 0x55, 0xc7, 0x2a, 0x57, 0x98, 0x63,
	0x6a, 0xac, 0x5c, 0xa2, 0xf7, 0x6b, 0x6a, 0xf5, 0xeb, 0x22, 0x98, 0x88, 0x2c, 0x09, 0x9f, 0x01,
	0x63, 0x86, 0xa2, 0x23, 0xee, 0xc7, 0x5f, 0x7f, 0xa9, 0x52, 0x24, 0xbd, 0x85, 0xf3, 0x60, 0x9c,
	0x72, 0xc2, 0x31, 0x74, 0xd5, 0xe7, 0xfc, 0x44, 0x3c, 0x56, 0x04, 0x9f, 0x15, 0xe1, 0x3d, 0x17,
	0x22, 0x7b, 0x48, 0xb8, 0x03, 0x80, 0x8a, 0x75, 0x7f, 0xb3, 0xb8, 0x3c, 0x25, 0x60, 0x39, 0x1b,
	0x01, 0xc2, 0x6a, 0xd7, 0xc1, 0x4d, 0x83, 0xd8, 0x2d, 0x39, 0xe2, 0x11, 0xbe, 0x04, 0xa6, 0xb1,
	0x41, 0xae, 0x5e, 0xde, 0xb0, 0xb1, 0x8e, 0x09, 0x3e, 0x40, 0x34, 0xb5, 0x82, 0xdc, 0xf3, 0x14,
	0xbe, 0x08, 0xa6, 0x76, 0x4d, 0x53, 0x0b, 0x61, 0x63, 0x73, 0x4c, 0xad, 0x2c, 0xc7, 0x1f, 0xc2,
	0x1a, 0x38, 0xa7, 0x9a, 0xcd, 0x5d, 0x0d, 0x85, 0xb8, 0xf1, 0x39, 0xa6, 0xc6, 0xc8, 0xbd, 0x8f,
	0x5d, 0xa4, 0x43, 0x6c, 0x6c, 0x34, 0x42, 0x64, 0x91, 0x32, 0xd5, 0xfb, 0x18, 0x7e, 0x00, 0xca,
	0x34, 0x96, 0xdb, 0x8a, 0xc5, 0x95, 0x68, 0xfe, 0xaf, 0x67, 0xcc, 0x7f, 0xcd, 0x37, 0xf7, 0xb2,
	0xef, 0x7a, 0x83, 0xd7, 0x00, 0x4b, 0xb0, 0x8e, 0x36, 0x89, 0xa2, 0x5b, 0x1c, 0x4b, 0xb7, 0xe4,
	0x62, 0xf2, 0x96, 0x6c, 0x05, 0x30, 0x39, 0xb4, 0x80, 0x8b, 0xa0, 0xac, 0x36, 0x6d, 0x85, 0x60,
	0xd3, 0xe0, 0x00, 0xb5, 0xe6, 0x93, 0xad, 0x57, 0x7d, 0x94, 0xdc, 0xc5, 0xc3, 0x65, 0x30, 0x66,
	0x23, 0x67, 0x9e, 0x9b, 0xa0, 0x76, 0x2f, 0xa7, 0x48, 0x48, 0x46, 0xce, 0xbc, 0xab, 0x66, 0x6a,
	0x57, 0xd9, 0x06, 0xe7, 0x7a, 0x76, 0x15, 0x9e, 0x07, 0x85, 0x4f, 0x51, 0x8b, 0x4a, 0x8b, 0x95,
	0xdd, 0xcb, 0x50, 0x6e, 0xf9, 0xb4, 0x72, 0x5b, 0xcc, 0x2f, 0x30, 0x95, 0x25, 0x30, 0x15, 0x63,
	0x2c, 0xc1, 0xf3, 0x4c, 0xd4, 0x73, 0x21, 0x62, 0x5c, 0xfd, 0xbe, 0x04, 0x4a, 0x7e, 0xa8, 0xc3,
	0xc8, 0x7d, 0x3b, 0x41, 0xee, 0x8b, 0xe9, 0xd9, 0x79, 0xc2, 0xa5, 0xbe, 0xd5, 0x27, 0xf5, 0x85,
	0x0c, 0xb9, 0x3f, 0xb6, 0x32, 0x97, 0xb2, 0xc9, 0x5c, 0x0a, 0x64, 0x2e, 0x41, 0x19, 0x94, 0xdd,
	0xdf, 0xba, 0xae, 0x58, 0xdc, 0x24, 0x25, 0xe4, 0xb5, 0x0c, 0x84, 0x50, 0x5f, 0x01, 0x1f, 0x25,
	0xdb, 0xbb, 0x7b, 0x6c, 0x4b, 0xa7, 0xb2, 0x0f, 0x26, 0xa3, 0x11, 0x27, 0xd8, 0x5e, 0x8f, 0x47,
	0x95, 0x85, 0xcf, 0x48, 0x89, 0xfe, 0x3d, 0x46, 0x4b, 0x54, 0xfa, 0xff, 0x4b, 0x54, 0x7a, 0x54,
	0x25, 0x7a, 0x86, 0x92, 0x5e, 0x00, 0x25, 0x6c, 0xd5, 0x15, 0x55, 0xb5, 0x7d, 0x55, 0x0f, 0x58,
	0x78, 0x6d, 0x63, 0x45, 0x55, 0x6d, 0xe4, 0x38, 0x72, 0x11, 0x5b, 0xee, 0x25, 0x5c, 0x00, 0x65,
	0xd5, 0x70, 0xea, 0x74, 0x30, 0x98, 0xa4, 0xa6, 0x17, 0x06, 0xac, 0xba, 0xbe, 0xb9, 0xae, 0xe8,
	0x48, 0x2e, 0xa9, 0x86, 0xe3, 0x5e, 0xc0, 0x15, 0x00, 0x90, 0xae, 0x60, 0xcd, 0x5b, 0x76, 0x8a,
	0xda, 0x56, 0x93, 0x6d, 0x6f, 0xba, 0xb8, 0x60, 0x65, 0x16, 0x05, 0x77, 0xf0, 0x12, 0x28, 0x34,
	0x6d, 0xcc, 0x4d, 0x53, 0xdb, 0xd9, 0x64, 0xdb, 0x77, 0x6d, 0x2c, 0xbb, 0xa8, 0x51, 0x96, 0x48,
	0xf5, 0xa7, 0x3c, 0x18, 0xdb, 0x6a, 0x59, 0x08, 0x5e, 0x89, 0x4a, 0x6f, 0x7a, 0x10, 0x8d, 0xd4,
	0xde, 0xc5, 0x07, 0xf2, 0x7b, 0x3f, 0x41, 0x7e, 0x69, 0x0e, 0x05, 0xd7, 0xc7, 0x43, 0xb5, 0xf7,
	0x46, 0xac, 0x25, 0x5f, 0x4a, 0x79, 0xce, 0xd0, 0xd0, 0xbc, 0x9e, 0xbc, 0x93, 0x86, 0xb5, 0x2b,
	0x51, 0xd6, 0x52, 0x67, 0x4d, 0x99, 0xfb, 0xa7, 0x00, 0xca, 0xc1, 0x92, 0xc3, 0xb2, 0xf7, 0x61,
	0x02, 0x7b, 0x4b, 0x19, 0x52, 0x4d, 0xc1, 0xa0, 0x94, 0x8d, 0x41, 0xa9, 0xcb, 0xa0, 0x04, 0x37,
	0xfb, 0x8e, 0xfb, 0x85, 0x2c, 0xb1, 0x25, 0x9f, 0xf7, 0x23, 0xde, 0x96, 0x4a, 0xe3, 0xc4, 0x63,
	0x7b, 0x25, 0x5e, 0x29, 0x99, 0x88, 0x89, 0xec, 0xff, 0xbf, 0x0c, 0xdd, 0x7f, 0xe9, 0x8c, 0xf6,
	0x5f, 0x3a, 0x69, 0xff, 0x47, 0x5e, 0x00, 0x5f, 0x8d, 0xbb, 0xed, 0xd5, 0x9b, 0xeb, 0x37, 0x14,
	0x5b, 0xd1, 0xc3, 0x66, 0xea, 0x2d, 0xe0, 0x27, 0xf9, 0x71, 0x42, 0x92, 0xd7, 0x33, 0xbc, 0x33,
	0x50, 0xdf, 0x43, 0xf4, 0x29, 0x36, 0xdd, 0x28, 0xc9, 0xa6, 0x1c, 0x25, 0xd9, 0xd3, 0x8c, 0x92,
	0xdb, 0x7d, 0xa3, 0xe4, 0x72, 0x66, 0x06, 0x06, 0x0d, 0x94, 0xcf, 0xf7, 0x76, 0x5f, 0x36, 0xda,
	0x5c, 0x2b, 0x3d, 0xcd, 0x95, 0x8d, 0x34, 0xcf, 0x5b, 0xb1, 0x33, 0xf6, 0x72, 0xca, 0xe2, 0x8e,
	0x45, 0xe5, 0x1f, 0xb6, 0xd7, 0xd2, 0x68, 0x2d, 0x36, 0x6b, 0xb1, 0xa7, 0x19, 0xd4, 0xa2, 0xc6,
	0xd5, 0x76, 0x11, 0x3c, 0xd5, 0x17, 0xd7, 0x00, 0x2d, 0xaa, 0x09, 0x5a, 0x5c, 0x1d, 0x26, 0xef,
	0x27, 0x5c, 0x8f, 0x3b, 0x7d, 0x7a, 0xbc, 0x31, 0x14, 0x0b, 0xa3, 0xd2, 0xa4, 0x94, 0x4d, 0x93,
	0x52, 0xbf, 0x26, 0x25, 0xf8, 0x51, 0x5f, 0xfb, 0x5a, 0x19, 0x2a, 0xc7, 0xe4, 0x3e, 0x76, 0x86,
	0x8a, 0xaf, 0x58, 0x27, 0xf6, 0xb8, 0xb7, 0xe3, 0x3d, 0x6e, 0x38, 0x1a, 0x23, 0x35, 0xf6, 0x5d,
	0x81, 0xd6, 0x98, 0x34, 0xe2, 0x1a, 0x93, 0x1e, 0x7d, 0x8d, 0x0d, 0xaf, 0xc4, 0x67, 0xe3, 0xaf,
	0x16, 0x6c, 0xf7, 0xcd, 0x61, 0xb6, 0xe7, 0xcd, 0x81, 0x0d, 0x5f, 0x0d, 0x2e, 0xf4, 0xbd, 0x1a,
	0xb0, 0xd1, 0xb1, 0xff, 0x7c, 0x38, 0xf6, 0xb3, 0xde, 0x6c, 0x7f, 0x3a, 0x19, 0x49, 0xdf, 0xf4,
	0x7c, 0xa7, 0xdd, 0xf4, 0xbe, 0x56, 0xc3, 0xcf, 0xc1, 0x64, 0xf4, 0x31, 0xbc, 0x9a, 0x82, 0xff,
	0x84, 0xef, 0xbd, 0x15, 0x31, 0xd1, 0x8e, 0x7e, 0x74, 0xee, 0x0e, 0x07, 0x81, 0x85, 0xd3, 0xd4,
	0xc8, 0x8d, 0xf5, 0x7b, 0x6d, 0x3e, 0x77, 0xd8, 0xe6, 0x73, 0x47, 0x6d, 0x3e, 0xf7, 0xa0, 0xcd,
	0xe7, 0xbe, 0xe8, 0xf0, 0xcc, 0x0f, 0x1d, 0x3e, 0x77, 0xaf, 0xc3, 0x33, 0x87, 0x1d, 0x9e, 0x39,
	0xea, 0xf0, 0xcc, 0x1f, 0x1d, 0x9e, 0xf9, 0xb3, 0xc3, 0xe7, 0x1e, 0x74, 0x78, 0xe6, 0xdb, 0x63,
	0x3e, 0x77, 0x78, 0xcc, 0xe7, 0x8e, 0x8e, 0xf9, 0xdc, 0x5f, 0xbf, 0xdd, 0xbf, 0x9b, 0x67, 0xbe,
	0xfc, 0xfd, 0xfe, 0xdd, 0x7c, 0xd1, 0x0b, 0x6a, 0xb7, 0x48, 0x3f, 0x01, 0xbf, 0xfa, 0x5f, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xd1, 0x7e, 0x49, 0x8c, 0xc2, 0x17, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleReportServiceClient is the client API for HandleReportService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleReportServiceClient interface {
	// HandleReport is called by Mixer at request-time to deliver 'report' instances to the backend.
	HandleReport(ctx context.Context, in *HandleReportRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error)
}

type handleReportServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleReportServiceClient(cc *grpc.ClientConn) HandleReportServiceClient {
	return &handleReportServiceClient{cc}
}

func (c *handleReportServiceClient) HandleReport(ctx context.Context, in *HandleReportRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error) {
	out := new(v1beta11.ReportResult)
	err := c.cc.Invoke(ctx, "/istio.mixer.adapter.sample.report.HandleReportService/HandleReport", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleReportServiceServer is the server API for HandleReportService service.
type HandleReportServiceServer interface {
	// HandleReport is called by Mixer at request-time to deliver 'report' instances to the backend.
	HandleReport(context.Context, *HandleReportRequest) (*v1beta11.ReportResult, error)
}

// UnimplementedHandleReportServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHandleReportServiceServer struct {
}

func (*UnimplementedHandleReportServiceServer) HandleReport(ctx context.Context, req *HandleReportRequest) (*v1beta11.ReportResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleReport not implemented")
}

func RegisterHandleReportServiceServer(s *grpc.Server, srv HandleReportServiceServer) {
	s.RegisterService(&_HandleReportService_serviceDesc, srv)
}

func _HandleReportService_HandleReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleReportServiceServer).HandleReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.adapter.sample.report.HandleReportService/HandleReport",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleReportServiceServer).HandleReport(ctx, req.(*HandleReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleReportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mixer.adapter.sample.report.HandleReportService",
	HandlerType: (*HandleReportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleReport",
			Handler:    _HandleReportService_HandleReport_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/sample/report/ReportTesterTemplate_handler_service.proto",
}

func (m *HandleReportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleReportRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleReportRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DedupId) > 0 {
		i -= len(m.DedupId)
		copy(dAtA[i:], m.DedupId)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AdapterConfig != nil {
		{
			size, err := m.AdapterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Instances) > 0 {
		for iNdEx := len(m.Instances) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Instances[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x93
		i--
		dAtA[i] = 0xe4
		i--
		dAtA[i] = 0xd2
		i--
		dAtA[i] = 0xfa
	}
	if m.Res1 != nil {
		{
			size, err := m.Res1.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Duration != nil {
		{
			size, err := m.Duration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.TimeStamp != nil {
		{
			size, err := m.TimeStamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Int64Map) > 0 {
		keysForInt64Map := make([]string, 0, len(m.Int64Map))
		for k := range m.Int64Map {
			keysForInt64Map = append(keysForInt64Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
		for iNdEx := len(keysForInt64Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Int64Map[string(keysForInt64Map[iNdEx])]
			baseI := i
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForInt64Map[iNdEx])
			copy(dAtA[i:], keysForInt64Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForInt64Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.StringPrimitive) > 0 {
		i -= len(m.StringPrimitive)
		copy(dAtA[i:], m.StringPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.StringPrimitive)))
		i--
		dAtA[i] = 0x32
	}
	if m.DoublePrimitive != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoublePrimitive))))
		i--
		dAtA[i] = 0x29
	}
	if m.BoolPrimitive {
		i--
		if m.BoolPrimitive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Int64Primitive != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Int64Primitive))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Res1Msg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res1Msg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res1Msg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Res2Map) > 0 {
		keysForRes2Map := make([]string, 0, len(m.Res2Map))
		for k := range m.Res2Map {
			keysForRes2Map = append(keysForRes2Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
		for iNdEx := len(keysForRes2Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Res2Map[string(keysForRes2Map[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForRes2Map[iNdEx])
			copy(dAtA[i:], keysForRes2Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForRes2Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Res2 != nil {
		{
			size, err := m.Res2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Duration != nil {
		{
			size, err := m.Duration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.TimeStamp != nil {
		{
			size, err := m.TimeStamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Int64Map) > 0 {
		keysForInt64Map := make([]string, 0, len(m.Int64Map))
		for k := range m.Int64Map {
			keysForInt64Map = append(keysForInt64Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
		for iNdEx := len(keysForInt64Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Int64Map[string(keysForInt64Map[iNdEx])]
			baseI := i
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForInt64Map[iNdEx])
			copy(dAtA[i:], keysForInt64Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForInt64Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.StringPrimitive) > 0 {
		i -= len(m.StringPrimitive)
		copy(dAtA[i:], m.StringPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.StringPrimitive)))
		i--
		dAtA[i] = 0x32
	}
	if m.DoublePrimitive != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoublePrimitive))))
		i--
		dAtA[i] = 0x29
	}
	if m.BoolPrimitive {
		i--
		if m.BoolPrimitive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.Int64Primitive != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Int64Primitive))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Res2Msg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res2Msg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res2Msg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Uri != nil {
		{
			size, err := m.Uri.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x72
	}
	if m.EmailAddr != nil {
		{
			size, err := m.EmailAddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6a
	}
	if m.DnsName != nil {
		{
			size, err := m.DnsName.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x62
	}
	if m.IpAddr != nil {
		{
			size, err := m.IpAddr.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Duration != nil {
		{
			size, err := m.Duration.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.TimeStamp != nil {
		{
			size, err := m.TimeStamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.Int64Primitive != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Int64Primitive))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != nil {
		{
			size, err := m.Value.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Res1 != nil {
		{
			size, err := m.Res1.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Res1Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res1Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res1Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Res2Map) > 0 {
		keysForRes2Map := make([]string, 0, len(m.Res2Map))
		for k := range m.Res2Map {
			keysForRes2Map = append(keysForRes2Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
		for iNdEx := len(keysForRes2Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Res2Map[string(keysForRes2Map[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForRes2Map[iNdEx])
			copy(dAtA[i:], keysForRes2Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForRes2Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Res2 != nil {
		{
			size, err := m.Res2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Res2Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res2Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res2Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Value != 0 {
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(m.Value))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Res1 != nil {
		{
			size, err := m.Res1.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Duration) > 0 {
		i -= len(m.Duration)
		copy(dAtA[i:], m.Duration)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Duration)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TimeStamp) > 0 {
		i -= len(m.TimeStamp)
		copy(dAtA[i:], m.TimeStamp)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.TimeStamp)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Int64Map) > 0 {
		keysForInt64Map := make([]string, 0, len(m.Int64Map))
		for k := range m.Int64Map {
			keysForInt64Map = append(keysForInt64Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
		for iNdEx := len(keysForInt64Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Int64Map[string(keysForInt64Map[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForInt64Map[iNdEx])
			copy(dAtA[i:], keysForInt64Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForInt64Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.StringPrimitive) > 0 {
		i -= len(m.StringPrimitive)
		copy(dAtA[i:], m.StringPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.StringPrimitive)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.DoublePrimitive) > 0 {
		i -= len(m.DoublePrimitive)
		copy(dAtA[i:], m.DoublePrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.DoublePrimitive)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.BoolPrimitive) > 0 {
		i -= len(m.BoolPrimitive)
		copy(dAtA[i:], m.BoolPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.BoolPrimitive)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Int64Primitive) > 0 {
		i -= len(m.Int64Primitive)
		copy(dAtA[i:], m.Int64Primitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Int64Primitive)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Res1InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res1InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res1InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Res2Map) > 0 {
		keysForRes2Map := make([]string, 0, len(m.Res2Map))
		for k := range m.Res2Map {
			keysForRes2Map = append(keysForRes2Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
		for iNdEx := len(keysForRes2Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Res2Map[string(keysForRes2Map[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForRes2Map[iNdEx])
			copy(dAtA[i:], keysForRes2Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForRes2Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Res2 != nil {
		{
			size, err := m.Res2.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Duration) > 0 {
		i -= len(m.Duration)
		copy(dAtA[i:], m.Duration)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Duration)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TimeStamp) > 0 {
		i -= len(m.TimeStamp)
		copy(dAtA[i:], m.TimeStamp)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.TimeStamp)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Int64Map) > 0 {
		keysForInt64Map := make([]string, 0, len(m.Int64Map))
		for k := range m.Int64Map {
			keysForInt64Map = append(keysForInt64Map, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
		for iNdEx := len(keysForInt64Map) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Int64Map[string(keysForInt64Map[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForInt64Map[iNdEx])
			copy(dAtA[i:], keysForInt64Map[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForInt64Map[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.StringPrimitive) > 0 {
		i -= len(m.StringPrimitive)
		copy(dAtA[i:], m.StringPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.StringPrimitive)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.DoublePrimitive) > 0 {
		i -= len(m.DoublePrimitive)
		copy(dAtA[i:], m.DoublePrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.DoublePrimitive)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.BoolPrimitive) > 0 {
		i -= len(m.BoolPrimitive)
		copy(dAtA[i:], m.BoolPrimitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.BoolPrimitive)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Int64Primitive) > 0 {
		i -= len(m.Int64Primitive)
		copy(dAtA[i:], m.Int64Primitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Int64Primitive)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Res2InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Res2InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Res2InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Uri) > 0 {
		i -= len(m.Uri)
		copy(dAtA[i:], m.Uri)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Uri)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.EmailAddr) > 0 {
		i -= len(m.EmailAddr)
		copy(dAtA[i:], m.EmailAddr)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.EmailAddr)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.DnsName) > 0 {
		i -= len(m.DnsName)
		copy(dAtA[i:], m.DnsName)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.DnsName)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.IpAddr) > 0 {
		i -= len(m.IpAddr)
		copy(dAtA[i:], m.IpAddr)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.IpAddr)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.Duration) > 0 {
		i -= len(m.Duration)
		copy(dAtA[i:], m.Duration)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Duration)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.TimeStamp) > 0 {
		i -= len(m.TimeStamp)
		copy(dAtA[i:], m.TimeStamp)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.TimeStamp)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Int64Primitive) > 0 {
		i -= len(m.Int64Primitive)
		copy(dAtA[i:], m.Int64Primitive)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Int64Primitive)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Dimensions) > 0 {
		keysForDimensions := make([]string, 0, len(m.Dimensions))
		for k := range m.Dimensions {
			keysForDimensions = append(keysForDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
		for iNdEx := len(keysForDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Dimensions[string(keysForDimensions[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForDimensions[iNdEx])
			copy(dAtA[i:], keysForDimensions[iNdEx])
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(keysForDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintReportTesterTemplateHandlerService(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintReportTesterTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	offset -= sovReportTesterTemplateHandlerService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HandleReportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Int64Primitive != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Int64Primitive))
	}
	if m.BoolPrimitive {
		n += 2
	}
	if m.DoublePrimitive != 0 {
		n += 9
	}
	l = len(m.StringPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Int64Map) > 0 {
		for k, v := range m.Int64Map {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + sovReportTesterTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.TimeStamp != nil {
		l = m.TimeStamp.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Duration != nil {
		l = m.Duration.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Res1 != nil {
		l = m.Res1.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Res1Msg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Int64Primitive != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Int64Primitive))
	}
	if m.BoolPrimitive {
		n += 2
	}
	if m.DoublePrimitive != 0 {
		n += 9
	}
	l = len(m.StringPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Int64Map) > 0 {
		for k, v := range m.Int64Map {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + sovReportTesterTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.TimeStamp != nil {
		l = m.TimeStamp.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Duration != nil {
		l = m.Duration.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Res2 != nil {
		l = m.Res2.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Res2Map) > 0 {
		for k, v := range m.Res2Map {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Res2Msg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Int64Primitive != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Int64Primitive))
	}
	if m.TimeStamp != nil {
		l = m.TimeStamp.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Duration != nil {
		l = m.Duration.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.IpAddr != nil {
		l = m.IpAddr.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.DnsName != nil {
		l = m.DnsName.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.EmailAddr != nil {
		l = m.EmailAddr.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Uri != nil {
		l = m.Uri.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Value))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + sovReportTesterTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Res1 != nil {
		l = m.Res1.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Res1Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Value))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + sovReportTesterTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Res2 != nil {
		l = m.Res2.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Res2Map) > 0 {
		for k, v := range m.Res2Map {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Res2Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Value != 0 {
		n += 1 + sovReportTesterTemplateHandlerService(uint64(m.Value))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + sovReportTesterTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovReportTesterTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Int64Primitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.BoolPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.DoublePrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.StringPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Int64Map) > 0 {
		for k, v := range m.Int64Map {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovReportTesterTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.TimeStamp)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.Duration)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Res1 != nil {
		l = m.Res1.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Res1InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovReportTesterTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Int64Primitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.BoolPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.DoublePrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.StringPrimitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Int64Map) > 0 {
		for k, v := range m.Int64Map {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovReportTesterTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.TimeStamp)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.Duration)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if m.Res2 != nil {
		l = m.Res2.Size()
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Res2Map) > 0 {
		for k, v := range m.Res2Map {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovReportTesterTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Res2InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	if len(m.Dimensions) > 0 {
		for k, v := range m.Dimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovReportTesterTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovReportTesterTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovReportTesterTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Int64Primitive)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.TimeStamp)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.Duration)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.IpAddr)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.DnsName)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.EmailAddr)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	l = len(m.Uri)
	if l > 0 {
		n += 1 + l + sovReportTesterTemplateHandlerService(uint64(l))
	}
	return n
}

func sovReportTesterTemplateHandlerService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozReportTesterTemplateHandlerService(x uint64) (n int) {
	return sovReportTesterTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleReportRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInstances := "[]*InstanceMsg{"
	for _, f := range this.Instances {
		repeatedStringForInstances += strings.Replace(f.String(), "InstanceMsg", "InstanceMsg", 1) + ","
	}
	repeatedStringForInstances += "}"
	s := strings.Join([]string{`&HandleReportRequest{`,
		`Instances:` + repeatedStringForInstances + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]*v1beta1.Value{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	keysForInt64Map := make([]string, 0, len(this.Int64Map))
	for k, _ := range this.Int64Map {
		keysForInt64Map = append(keysForInt64Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
	mapStringForInt64Map := "map[string]int64{"
	for _, k := range keysForInt64Map {
		mapStringForInt64Map += fmt.Sprintf("%v: %v,", k, this.Int64Map[k])
	}
	mapStringForInt64Map += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`Value:` + strings.Replace(fmt.Sprintf("%v", this.Value), "Value", "v1beta1.Value", 1) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`BoolPrimitive:` + fmt.Sprintf("%v", this.BoolPrimitive) + `,`,
		`DoublePrimitive:` + fmt.Sprintf("%v", this.DoublePrimitive) + `,`,
		`StringPrimitive:` + fmt.Sprintf("%v", this.StringPrimitive) + `,`,
		`Int64Map:` + mapStringForInt64Map + `,`,
		`TimeStamp:` + strings.Replace(fmt.Sprintf("%v", this.TimeStamp), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`Duration:` + strings.Replace(fmt.Sprintf("%v", this.Duration), "Duration", "v1beta1.Duration", 1) + `,`,
		`Res1:` + strings.Replace(this.Res1.String(), "Res1Msg", "Res1Msg", 1) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res1Msg) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]*v1beta1.Value{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	keysForInt64Map := make([]string, 0, len(this.Int64Map))
	for k, _ := range this.Int64Map {
		keysForInt64Map = append(keysForInt64Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
	mapStringForInt64Map := "map[string]int64{"
	for _, k := range keysForInt64Map {
		mapStringForInt64Map += fmt.Sprintf("%v: %v,", k, this.Int64Map[k])
	}
	mapStringForInt64Map += "}"
	keysForRes2Map := make([]string, 0, len(this.Res2Map))
	for k, _ := range this.Res2Map {
		keysForRes2Map = append(keysForRes2Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
	mapStringForRes2Map := "map[string]*Res2Msg{"
	for _, k := range keysForRes2Map {
		mapStringForRes2Map += fmt.Sprintf("%v: %v,", k, this.Res2Map[k])
	}
	mapStringForRes2Map += "}"
	s := strings.Join([]string{`&Res1Msg{`,
		`Value:` + strings.Replace(fmt.Sprintf("%v", this.Value), "Value", "v1beta1.Value", 1) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`BoolPrimitive:` + fmt.Sprintf("%v", this.BoolPrimitive) + `,`,
		`DoublePrimitive:` + fmt.Sprintf("%v", this.DoublePrimitive) + `,`,
		`StringPrimitive:` + fmt.Sprintf("%v", this.StringPrimitive) + `,`,
		`Int64Map:` + mapStringForInt64Map + `,`,
		`TimeStamp:` + strings.Replace(fmt.Sprintf("%v", this.TimeStamp), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`Duration:` + strings.Replace(fmt.Sprintf("%v", this.Duration), "Duration", "v1beta1.Duration", 1) + `,`,
		`Res2:` + strings.Replace(this.Res2.String(), "Res2Msg", "Res2Msg", 1) + `,`,
		`Res2Map:` + mapStringForRes2Map + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res2Msg) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]*v1beta1.Value{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&Res2Msg{`,
		`Value:` + strings.Replace(fmt.Sprintf("%v", this.Value), "Value", "v1beta1.Value", 1) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`TimeStamp:` + strings.Replace(fmt.Sprintf("%v", this.TimeStamp), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`Duration:` + strings.Replace(fmt.Sprintf("%v", this.Duration), "Duration", "v1beta1.Duration", 1) + `,`,
		`IpAddr:` + strings.Replace(fmt.Sprintf("%v", this.IpAddr), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DnsName:` + strings.Replace(fmt.Sprintf("%v", this.DnsName), "DNSName", "v1beta1.DNSName", 1) + `,`,
		`EmailAddr:` + strings.Replace(fmt.Sprintf("%v", this.EmailAddr), "EmailAddress", "v1beta1.EmailAddress", 1) + `,`,
		`Uri:` + strings.Replace(fmt.Sprintf("%v", this.Uri), "Uri", "v1beta1.Uri", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]v1beta1.ValueType{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&Type{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Res1:` + strings.Replace(this.Res1.String(), "Res1Type", "Res1Type", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res1Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]v1beta1.ValueType{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	keysForRes2Map := make([]string, 0, len(this.Res2Map))
	for k, _ := range this.Res2Map {
		keysForRes2Map = append(keysForRes2Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
	mapStringForRes2Map := "map[string]*Res2Type{"
	for _, k := range keysForRes2Map {
		mapStringForRes2Map += fmt.Sprintf("%v: %v,", k, this.Res2Map[k])
	}
	mapStringForRes2Map += "}"
	s := strings.Join([]string{`&Res1Type{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Res2:` + strings.Replace(this.Res2.String(), "Res2Type", "Res2Type", 1) + `,`,
		`Res2Map:` + mapStringForRes2Map + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res2Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]v1beta1.ValueType{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&Res2Type{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]string{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	keysForInt64Map := make([]string, 0, len(this.Int64Map))
	for k, _ := range this.Int64Map {
		keysForInt64Map = append(keysForInt64Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
	mapStringForInt64Map := "map[string]string{"
	for _, k := range keysForInt64Map {
		mapStringForInt64Map += fmt.Sprintf("%v: %v,", k, this.Int64Map[k])
	}
	mapStringForInt64Map += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`BoolPrimitive:` + fmt.Sprintf("%v", this.BoolPrimitive) + `,`,
		`DoublePrimitive:` + fmt.Sprintf("%v", this.DoublePrimitive) + `,`,
		`StringPrimitive:` + fmt.Sprintf("%v", this.StringPrimitive) + `,`,
		`Int64Map:` + mapStringForInt64Map + `,`,
		`TimeStamp:` + fmt.Sprintf("%v", this.TimeStamp) + `,`,
		`Duration:` + fmt.Sprintf("%v", this.Duration) + `,`,
		`Res1:` + strings.Replace(this.Res1.String(), "Res1InstanceParam", "Res1InstanceParam", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res1InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]string{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	keysForInt64Map := make([]string, 0, len(this.Int64Map))
	for k, _ := range this.Int64Map {
		keysForInt64Map = append(keysForInt64Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForInt64Map)
	mapStringForInt64Map := "map[string]string{"
	for _, k := range keysForInt64Map {
		mapStringForInt64Map += fmt.Sprintf("%v: %v,", k, this.Int64Map[k])
	}
	mapStringForInt64Map += "}"
	keysForRes2Map := make([]string, 0, len(this.Res2Map))
	for k, _ := range this.Res2Map {
		keysForRes2Map = append(keysForRes2Map, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForRes2Map)
	mapStringForRes2Map := "map[string]*Res2InstanceParam{"
	for _, k := range keysForRes2Map {
		mapStringForRes2Map += fmt.Sprintf("%v: %v,", k, this.Res2Map[k])
	}
	mapStringForRes2Map += "}"
	s := strings.Join([]string{`&Res1InstanceParam{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`BoolPrimitive:` + fmt.Sprintf("%v", this.BoolPrimitive) + `,`,
		`DoublePrimitive:` + fmt.Sprintf("%v", this.DoublePrimitive) + `,`,
		`StringPrimitive:` + fmt.Sprintf("%v", this.StringPrimitive) + `,`,
		`Int64Map:` + mapStringForInt64Map + `,`,
		`TimeStamp:` + fmt.Sprintf("%v", this.TimeStamp) + `,`,
		`Duration:` + fmt.Sprintf("%v", this.Duration) + `,`,
		`Res2:` + strings.Replace(this.Res2.String(), "Res2InstanceParam", "Res2InstanceParam", 1) + `,`,
		`Res2Map:` + mapStringForRes2Map + `,`,
		`}`,
	}, "")
	return s
}
func (this *Res2InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForDimensions := make([]string, 0, len(this.Dimensions))
	for k, _ := range this.Dimensions {
		keysForDimensions = append(keysForDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForDimensions)
	mapStringForDimensions := "map[string]string{"
	for _, k := range keysForDimensions {
		mapStringForDimensions += fmt.Sprintf("%v: %v,", k, this.Dimensions[k])
	}
	mapStringForDimensions += "}"
	s := strings.Join([]string{`&Res2InstanceParam{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Dimensions:` + mapStringForDimensions + `,`,
		`Int64Primitive:` + fmt.Sprintf("%v", this.Int64Primitive) + `,`,
		`TimeStamp:` + fmt.Sprintf("%v", this.TimeStamp) + `,`,
		`Duration:` + fmt.Sprintf("%v", this.Duration) + `,`,
		`IpAddr:` + fmt.Sprintf("%v", this.IpAddr) + `,`,
		`DnsName:` + fmt.Sprintf("%v", this.DnsName) + `,`,
		`EmailAddr:` + fmt.Sprintf("%v", this.EmailAddr) + `,`,
		`Uri:` + fmt.Sprintf("%v", this.Uri) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringReportTesterTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleReportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleReportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleReportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &v1beta1.Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			m.Int64Primitive = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Int64Primitive |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolPrimitive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BoolPrimitive = bool(v != 0)
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoublePrimitive", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.DoublePrimitive = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64Map == nil {
				m.Int64Map = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64Map[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeStamp == nil {
				m.TimeStamp = &v1beta1.TimeStamp{}
			}
			if err := m.TimeStamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Duration == nil {
				m.Duration = &v1beta1.Duration{}
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res1 == nil {
				m.Res1 = &Res1Msg{}
			}
			if err := m.Res1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res1Msg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res1Msg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res1Msg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &v1beta1.Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			m.Int64Primitive = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Int64Primitive |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolPrimitive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BoolPrimitive = bool(v != 0)
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoublePrimitive", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.DoublePrimitive = float64(math.Float64frombits(v))
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64Map == nil {
				m.Int64Map = make(map[string]int64)
			}
			var mapkey string
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= int64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64Map[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeStamp == nil {
				m.TimeStamp = &v1beta1.TimeStamp{}
			}
			if err := m.TimeStamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Duration == nil {
				m.Duration = &v1beta1.Duration{}
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2 == nil {
				m.Res2 = &Res2Msg{}
			}
			if err := m.Res2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2Map == nil {
				m.Res2Map = make(map[string]*Res2Msg)
			}
			var mapkey string
			var mapvalue *Res2Msg
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Res2Msg{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Res2Map[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res2Msg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res2Msg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res2Msg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &v1beta1.Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			m.Int64Primitive = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Int64Primitive |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TimeStamp == nil {
				m.TimeStamp = &v1beta1.TimeStamp{}
			}
			if err := m.TimeStamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Duration == nil {
				m.Duration = &v1beta1.Duration{}
			}
			if err := m.Duration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpAddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IpAddr == nil {
				m.IpAddr = &v1beta1.IPAddress{}
			}
			if err := m.IpAddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsName", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsName == nil {
				m.DnsName = &v1beta1.DNSName{}
			}
			if err := m.DnsName.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailAddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EmailAddr == nil {
				m.EmailAddr = &v1beta1.EmailAddress{}
			}
			if err := m.EmailAddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Uri == nil {
				m.Uri = &v1beta1.Uri{}
			}
			if err := m.Uri.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= v1beta1.ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res1 == nil {
				m.Res1 = &Res1Type{}
			}
			if err := m.Res1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res1Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res1Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res1Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= v1beta1.ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2 == nil {
				m.Res2 = &Res2Type{}
			}
			if err := m.Res2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2Map == nil {
				m.Res2Map = make(map[string]*Res2Type)
			}
			var mapkey string
			var mapvalue *Res2Type
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Res2Type{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Res2Map[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res2Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res2Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res2Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			m.Value = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Value |= v1beta1.ValueType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Int64Primitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BoolPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoublePrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DoublePrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64Map == nil {
				m.Int64Map = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64Map[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeStamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Duration = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res1 == nil {
				m.Res1 = &Res1InstanceParam{}
			}
			if err := m.Res1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res1InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res1InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res1InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Int64Primitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BoolPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoublePrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DoublePrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringPrimitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StringPrimitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64Map == nil {
				m.Int64Map = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64Map[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeStamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Duration = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2 == nil {
				m.Res2 = &Res2InstanceParam{}
			}
			if err := m.Res2.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Res2Map", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Res2Map == nil {
				m.Res2Map = make(map[string]*Res2InstanceParam)
			}
			var mapkey string
			var mapvalue *Res2InstanceParam
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Res2InstanceParam{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Res2Map[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Res2InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Res2InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Res2InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Dimensions == nil {
				m.Dimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowReportTesterTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthReportTesterTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Dimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Primitive", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Int64Primitive = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeStamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TimeStamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Duration = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IpAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IpAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DnsName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailAddr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EmailAddr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Uri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Uri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReportTesterTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReportTesterTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipReportTesterTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowReportTesterTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReportTesterTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthReportTesterTemplateHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthReportTesterTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowReportTesterTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipReportTesterTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthReportTesterTemplateHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthReportTesterTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowReportTesterTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)
