// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// THIS FILE IS AUTOMATICALLY GENERATED.

package istio_mixer_adapter_sample_myapa

import (
	"context"
	"net"
	"time"

	"istio.io/istio/mixer/pkg/adapter"
)

// Fully qualified name of the template
const TemplateName = "myapa"

// Instance is constructed by Mixer for the 'myapa' template.
//
// myapa template is ..
type Instance struct {
	// Name of the instance as specified in configuration.
	Name string

	Int64Primitive int64

	BoolPrimitive bool

	DoublePrimitive float64

	StringPrimitive string

	DimensionsFixedInt64ValueDType map[string]int64

	TimeStamp time.Time

	Duration time.Duration

	Res3Map map[string]*Resource3

	OptionalIP net.IP

	Email adapter.EmailAddress
}

// Output struct is returned by the attribute producing adapters that handle this template.
type Output struct {
	fieldsSet map[string]bool

	Int64Primitive int64

	BoolPrimitive bool

	DoublePrimitive float64

	StringPrimitive string

	TimeStamp time.Time

	Duration time.Duration

	Email adapter.EmailAddress

	OutIp net.IP

	OutStrMap map[string]string
}

func NewOutput() *Output {
	return &Output{fieldsSet: make(map[string]bool)}
}

func (o *Output) SetInt64Primitive(val int64) {
	o.fieldsSet["int64Primitive"] = true
	o.Int64Primitive = val
}

func (o *Output) SetBoolPrimitive(val bool) {
	o.fieldsSet["boolPrimitive"] = true
	o.BoolPrimitive = val
}

func (o *Output) SetDoublePrimitive(val float64) {
	o.fieldsSet["doublePrimitive"] = true
	o.DoublePrimitive = val
}

func (o *Output) SetStringPrimitive(val string) {
	o.fieldsSet["stringPrimitive"] = true
	o.StringPrimitive = val
}

func (o *Output) SetTimeStamp(val time.Time) {
	o.fieldsSet["timeStamp"] = true
	o.TimeStamp = val
}

func (o *Output) SetDuration(val time.Duration) {
	o.fieldsSet["duration"] = true
	o.Duration = val
}

func (o *Output) SetEmail(val adapter.EmailAddress) {
	o.fieldsSet["email"] = true
	o.Email = val
}

func (o *Output) SetOutIp(val net.IP) {
	o.fieldsSet["out_ip"] = true
	o.OutIp = val
}

func (o *Output) SetOutStrMap(val map[string]string) {
	o.fieldsSet["out_str_map"] = true
	o.OutStrMap = val
}

func (o *Output) WasSet(field string) bool {
	_, found := o.fieldsSet[field]
	return found
}

type Resource1 struct {
	Str string

	SelfRefRes1 *Resource1

	ResRef2 *Resource2
}

type Resource2 struct {
	Str string

	Res3 *Resource3

	Res3Map map[string]*Resource3
}

// resource3 comment
type Resource3 struct {
	Int64Primitive int64

	BoolPrimitive bool

	DoublePrimitive float64

	StringPrimitive string

	DimensionsFixedInt64ValueDType map[string]int64

	TimeStamp time.Time

	Duration time.Duration
}

// HandlerBuilder must be implemented by adapters if they want to
// process data associated with the 'myapa' template.
//
// Mixer uses this interface to call into the adapter at configuration time to configure
// it with adapter-specific configuration as well as all template-specific type information.
type HandlerBuilder interface {
	adapter.HandlerBuilder
}

// Handler must be implemented by adapter code if it wants to
// process data associated with the 'myapa' template.
//
// Mixer uses this interface to call into the adapter at request time in order to dispatch
// created instances to the adapter. Adapters take the incoming instances and do what they
// need to achieve their primary function.
type Handler interface {
	adapter.Handler

	// HandleMyApa is called by Mixer at request time to deliver instances to
	// to an adapter.
	GenerateMyApaAttributes(context.Context, *Instance) (*Output, error)
}
