// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/logentry/template_handler_service.proto

// The `logentry` template represents an individual entry within a log.
//
// Example config:
//
// ```yaml
// apiVersion: "config.istio.io/v1alpha2"
// kind: instance
// metadata:
//   name: accesslog
//   namespace: istio-system
// spec:
//   compiledTemplate: logentry
//   params:
//     severity: '"Default"'
//     timestamp: request.time
//     variables:
//       sourceIp: source.ip | ip("0.0.0.0")
//       destinationIp: destination.ip | ip("0.0.0.0")
//       sourceUser: source.principal | ""
//       method: request.method | ""
//       url: request.path | ""
//       protocol: request.scheme | "http"
//       responseCode: response.code | 0
//       responseSize: response.size | 0
//       requestSize: request.size | 0
//       latency: response.duration | "0ms"
//     monitored_resource_type: '"UNSPECIFIED"'
// ```
//
// The `logentry` template represents an individual entry within a log.
//
// When writing the configuration, the value for the fields associated with this template can either be a
// literal or an [expression](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/). Please note that if the datatype of a field is not istio.policy.v1beta1.Value,
// then the expression's [inferred type](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/#type-checking) must match the datatype of the field.

package logentry

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Request message for HandleLogEntry method.
type HandleLogEntryRequest struct {
	// 'logentry' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleLogEntryRequest) Reset()      { *m = HandleLogEntryRequest{} }
func (*HandleLogEntryRequest) ProtoMessage() {}
func (*HandleLogEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dd05b0c423ac040, []int{0}
}
func (m *HandleLogEntryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleLogEntryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HandleLogEntryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleLogEntryRequest.Merge(m, src)
}
func (m *HandleLogEntryRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleLogEntryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleLogEntryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleLogEntryRequest proto.InternalMessageInfo

// Contains instance payload for 'logentry' template. This is passed to infrastructure backends during request-time
// through HandleLogEntryService.HandleLogEntry.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Variables that are delivered for each log entry.
	Variables map[string]*v1beta1.Value `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Timestamp is the time value for the log entry
	Timestamp *v1beta1.TimeStamp `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Severity indicates the importance of the log entry.
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Optional. An expression to compute the type of the monitored resource this log entry is being recorded on.
	// If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceType string `protobuf:"bytes,4,opt,name=monitored_resource_type,json=monitoredResourceType,proto3" json:"monitored_resource_type,omitempty"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]*v1beta1.Value `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions,proto3" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dd05b0c423ac040, []int{1}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'logentry' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	// Variables that are delivered for each log entry.
	Variables map[string]v1beta1.ValueType `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]v1beta1.ValueType `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions,proto3" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dd05b0c423ac040, []int{2}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

// Represents instance configuration schema for 'logentry' template.
type InstanceParam struct {
	// Variables that are delivered for each log entry.
	Variables map[string]string `protobuf:"bytes,1,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Timestamp is the time value for the log entry
	Timestamp string `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Severity indicates the importance of the log entry.
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Optional. An expression to compute the type of the monitored resource this log entry is being recorded on.
	// If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceType string `protobuf:"bytes,4,opt,name=monitored_resource_type,json=monitoredResourceType,proto3" json:"monitored_resource_type,omitempty"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]string `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions,proto3" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_9dd05b0c423ac040, []int{3}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleLogEntryRequest)(nil), "logentry.HandleLogEntryRequest")
	proto.RegisterType((*InstanceMsg)(nil), "logentry.InstanceMsg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "logentry.InstanceMsg.MonitoredResourceDimensionsEntry")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "logentry.InstanceMsg.VariablesEntry")
	proto.RegisterType((*Type)(nil), "logentry.Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "logentry.Type.MonitoredResourceDimensionsEntry")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "logentry.Type.VariablesEntry")
	proto.RegisterType((*InstanceParam)(nil), "logentry.InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "logentry.InstanceParam.MonitoredResourceDimensionsEntry")
	proto.RegisterMapType((map[string]string)(nil), "logentry.InstanceParam.VariablesEntry")
}

func init() {
	proto.RegisterFile("mixer/template/logentry/template_handler_service.proto", fileDescriptor_9dd05b0c423ac040)
}

var fileDescriptor_9dd05b0c423ac040 = []byte{
	// 743 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x4f, 0x6b, 0xdb, 0x48,
	0x14, 0x97, 0x6c, 0x67, 0x37, 0x9e, 0x10, 0xb3, 0x0c, 0x31, 0xeb, 0x38, 0x9b, 0x89, 0x31, 0xcb,
	0xe2, 0xc3, 0x22, 0x91, 0x84, 0x0d, 0x61, 0xd3, 0x1e, 0x9a, 0xa6, 0xd0, 0x40, 0x53, 0x82, 0x12,
	0x02, 0x3d, 0x14, 0x23, 0x5b, 0x2f, 0xea, 0x10, 0x49, 0xa3, 0x4a, 0x63, 0x13, 0xb5, 0x3d, 0x94,
	0x9e, 0x7a, 0x2c, 0xe4, 0x2b, 0xf4, 0xd0, 0x5b, 0xbf, 0x40, 0xa1, 0xd7, 0xd0, 0x53, 0x68, 0x2f,
	0xb9, 0x14, 0x6a, 0x25, 0x87, 0x1e, 0x73, 0xec, 0xb1, 0x78, 0x24, 0xcb, 0x8e, 0x63, 0xa7, 0x26,
	0x69, 0x6f, 0x1a, 0xbd, 0xdf, 0xcc, 0xbc, 0xdf, 0x9f, 0xe1, 0xa1, 0x25, 0x9b, 0xee, 0x83, 0xa7,
	0x72, 0xb0, 0x5d, 0x4b, 0xe7, 0xa0, 0x5a, 0xcc, 0x04, 0x87, 0x7b, 0x41, 0xf2, 0xa7, 0xfa, 0x48,
	0x77, 0x0c, 0x0b, 0xbc, 0xaa, 0x0f, 0x5e, 0x93, 0xd6, 0x41, 0x71, 0x3d, 0xc6, 0x19, 0x1e, 0xef,
	0x00, 0x8b, 0x53, 0x26, 0x33, 0x99, 0xf8, 0xa9, 0xb6, 0xbf, 0xa2, 0x7a, 0xf1, 0xdf, 0xe8, 0x5c,
	0xdd, 0xd0, 0x5d, 0x0e, 0x9e, 0x6a, 0x33, 0x03, 0x2c, 0xb5, 0x39, 0x5f, 0x03, 0xae, 0xcf, 0xab,
	0xb0, 0xcf, 0xc1, 0xf1, 0x29, 0x73, 0xfc, 0x18, 0x3d, 0x6d, 0x32, 0x66, 0x5a, 0xa0, 0x8a, 0x55,
	0xad, 0xb1, 0xab, 0xea, 0x4e, 0x10, 0x97, 0x2a, 0x97, 0x1d, 0xe4, 0x81, 0xcb, 0x3c, 0x1e, 0x23,
	0xe7, 0x5c, 0x66, 0xd1, 0x7a, 0x90, 0x14, 0x9b, 0xba, 0xd5, 0x80, 0x2a, 0x0f, 0x5c, 0xe8, 0xdc,
	0xd2, 0x07, 0xe8, 0x96, 0xca, 0xaf, 0x65, 0x94, 0xbf, 0x2b, 0x88, 0xde, 0x63, 0xe6, 0x9d, 0x36,
	0x2f, 0x0d, 0x1e, 0x37, 0xc0, 0xe7, 0x78, 0x11, 0x65, 0xa9, 0xe3, 0x73, 0xdd, 0xa9, 0x83, 0x5f,
	0x90, 0x4b, 0xe9, 0xca, 0xc4, 0x42, 0x5e, 0xe9, 0x90, 0x57, 0xd6, 0xe3, 0xd2, 0x86, 0x6f, 0x6a,
	0x5d, 0x1c, 0x5e, 0x41, 0xb9, 0xb8, 0xe1, 0x6a, 0x9d, 0x39, 0xbb, 0xd4, 0x2c, 0xa4, 0x4a, 0x72,
	0x65, 0x62, 0x61, 0x4a, 0x89, 0x88, 0x2a, 0x1d, 0xa2, 0xca, 0x2d, 0x27, 0xd0, 0x26, 0x63, 0xec,
	0x6d, 0x01, 0xc5, 0xd3, 0x68, 0xdc, 0x00, 0xa3, 0xe1, 0x56, 0xa9, 0x51, 0x48, 0x97, 0xe4, 0x4a,
	0x56, 0xfb, 0x5d, 0xac, 0xd7, 0x8d, 0xf2, 0xfb, 0x0c, 0x9a, 0xe8, 0xb9, 0x12, 0xe7, 0x51, 0xc6,
	0xd1, 0x6d, 0x28, 0xbc, 0xfd, 0xf0, 0xae, 0x2c, 0x90, 0x62, 0x89, 0x57, 0x51, 0xb6, 0xa9, 0x7b,
	0x54, 0xaf, 0x59, 0x49, 0xcf, 0x7f, 0x0f, 0xec, 0x59, 0xd9, 0xe9, 0xc0, 0x22, 0xce, 0xdd, 0x6d,
	0xf8, 0x26, 0xca, 0x72, 0x6a, 0x83, 0xcf, 0x75, 0xdb, 0x8d, 0xbb, 0x9f, 0x53, 0xa8, 0xcf, 0x29,
	0x53, 0x22, 0x19, 0x95, 0x58, 0x46, 0x65, 0x9b, 0xda, 0xb0, 0xd5, 0x86, 0x69, 0xdd, 0x1d, 0xb8,
	0x88, 0xc6, 0x7d, 0x68, 0x82, 0x47, 0x79, 0x10, 0x93, 0x48, 0xd6, 0x78, 0x09, 0xfd, 0x69, 0x33,
	0x87, 0x72, 0xe6, 0x81, 0x51, 0xf5, 0xc0, 0x67, 0x0d, 0xaf, 0x1e, 0x19, 0x55, 0xc8, 0x08, 0x68,
	0x3e, 0x29, 0x6b, 0x71, 0x75, 0x3b, 0x70, 0x01, 0x3f, 0x41, 0xb3, 0x03, 0xf6, 0x19, 0xd4, 0x8e,
	0xc3, 0x54, 0x18, 0x13, 0x54, 0x97, 0x06, 0x53, 0xdd, 0xe8, 0x3f, 0x73, 0x2d, 0xd9, 0x18, 0x91,
	0x9f, 0xb1, 0x87, 0x23, 0x8a, 0x0f, 0x50, 0xee, 0xbc, 0x56, 0xf8, 0x0f, 0x94, 0xde, 0x83, 0xa0,
	0x20, 0x8b, 0x8e, 0xdb, 0x9f, 0x78, 0x1e, 0x8d, 0x89, 0xcc, 0xc5, 0x72, 0xcd, 0x0c, 0x96, 0x6b,
	0xa7, 0x0d, 0xd1, 0x22, 0xe4, 0xff, 0xa9, 0x65, 0xb9, 0xb8, 0x87, 0x4a, 0x3f, 0xea, 0xed, 0xa7,
	0x5d, 0x56, 0x7e, 0x99, 0x46, 0x19, 0x21, 0xe6, 0xca, 0xc5, 0x8c, 0xcc, 0x76, 0x85, 0x6b, 0x43,
	0x2e, 0x09, 0x87, 0x3f, 0x9a, 0x13, 0x6a, 0xdf, 0x81, 0xd7, 0xb3, 0xe0, 0xe1, 0x08, 0x16, 0xfc,
	0xd7, 0xab, 0x4a, 0x6e, 0x58, 0x62, 0x85, 0x2a, 0xed, 0x8e, 0x7a, 0x6d, 0x60, 0x57, 0xb2, 0xe1,
	0xea, 0x17, 0x96, 0x3f, 0xa5, 0xd1, 0x64, 0x27, 0xa0, 0x9b, 0xba, 0xa7, 0xdb, 0x78, 0xed, 0xa2,
	0x27, 0xff, 0x5c, 0x0c, 0xb3, 0xc0, 0x5e, 0x62, 0xce, 0x5f, 0xfd, 0x2f, 0x37, 0xfb, 0xab, 0x1f,
	0xe6, 0xb3, 0xd1, 0xe2, 0xb0, 0x3c, 0x8c, 0xcb, 0xf5, 0x72, 0x71, 0x63, 0x84, 0x5c, 0x4c, 0xf5,
	0xda, 0x94, 0xed, 0xb5, 0xfd, 0xfe, 0x95, 0x6c, 0x1f, 0x7a, 0xde, 0xc2, 0xd3, 0xfe, 0x41, 0xb2,
	0x15, 0xcd, 0x4d, 0x5c, 0x43, 0xb9, 0xf3, 0x05, 0x3c, 0xd7, 0xd5, 0x63, 0xe0, 0xec, 0x29, 0xaa,
	0x71, 0x9a, 0xc4, 0x08, 0x54, 0xe2, 0x29, 0xa1, 0x88, 0x11, 0x98, 0x44, 0x4b, 0x13, 0x23, 0x50,
	0x03, 0xbf, 0x61, 0xf1, 0xd5, 0xcd, 0xc3, 0x16, 0x91, 0x8e, 0x5a, 0x44, 0x3a, 0x6e, 0x11, 0xe9,
	0xac, 0x45, 0xa4, 0xe7, 0x21, 0x91, 0xdf, 0x84, 0x44, 0x3a, 0x0c, 0x89, 0x7c, 0x14, 0x12, 0xf9,
	0x38, 0x24, 0xf2, 0x97, 0x90, 0xc8, 0x5f, 0x43, 0x22, 0x9d, 0x85, 0x44, 0x7e, 0x75, 0x42, 0xa4,
	0xa3, 0x13, 0x22, 0x1d, 0x9f, 0x10, 0xe9, 0xdb, 0xc7, 0xd3, 0x83, 0x94, 0xfc, 0xe2, 0xf3, 0xe9,
	0x41, 0x2a, 0x99, 0xee, 0xb5, 0xdf, 0xc4, 0xa4, 0x5a, 0xfc, 0x1e, 0x00, 0x00, 0xff, 0xff, 0xa0,
	0x28, 0xd6, 0x5e, 0x28, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleLogEntryServiceClient is the client API for HandleLogEntryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleLogEntryServiceClient interface {
	// HandleLogEntry is called by Mixer at request-time to deliver 'logentry' instances to the backend.
	HandleLogEntry(ctx context.Context, in *HandleLogEntryRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error)
}

type handleLogEntryServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleLogEntryServiceClient(cc *grpc.ClientConn) HandleLogEntryServiceClient {
	return &handleLogEntryServiceClient{cc}
}

func (c *handleLogEntryServiceClient) HandleLogEntry(ctx context.Context, in *HandleLogEntryRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error) {
	out := new(v1beta11.ReportResult)
	err := c.cc.Invoke(ctx, "/logentry.HandleLogEntryService/HandleLogEntry", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleLogEntryServiceServer is the server API for HandleLogEntryService service.
type HandleLogEntryServiceServer interface {
	// HandleLogEntry is called by Mixer at request-time to deliver 'logentry' instances to the backend.
	HandleLogEntry(context.Context, *HandleLogEntryRequest) (*v1beta11.ReportResult, error)
}

// UnimplementedHandleLogEntryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHandleLogEntryServiceServer struct {
}

func (*UnimplementedHandleLogEntryServiceServer) HandleLogEntry(ctx context.Context, req *HandleLogEntryRequest) (*v1beta11.ReportResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleLogEntry not implemented")
}

func RegisterHandleLogEntryServiceServer(s *grpc.Server, srv HandleLogEntryServiceServer) {
	s.RegisterService(&_HandleLogEntryService_serviceDesc, srv)
}

func _HandleLogEntryService_HandleLogEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleLogEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleLogEntryServiceServer).HandleLogEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/logentry.HandleLogEntryService/HandleLogEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleLogEntryServiceServer).HandleLogEntry(ctx, req.(*HandleLogEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleLogEntryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "logentry.HandleLogEntryService",
	HandlerType: (*HandleLogEntryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleLogEntry",
			Handler:    _HandleLogEntryService_HandleLogEntry_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/logentry/template_handler_service.proto",
}

func (m *HandleLogEntryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleLogEntryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleLogEntryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DedupId) > 0 {
		i -= len(m.DedupId)
		copy(dAtA[i:], m.DedupId)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AdapterConfig != nil {
		{
			size, err := m.AdapterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Instances) > 0 {
		for iNdEx := len(m.Instances) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Instances[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x93
		i--
		dAtA[i] = 0xe4
		i--
		dAtA[i] = 0xd2
		i--
		dAtA[i] = 0xfa
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		keysForMonitoredResourceDimensions := make([]string, 0, len(m.MonitoredResourceDimensions))
		for k := range m.MonitoredResourceDimensions {
			keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
		for iNdEx := len(keysForMonitoredResourceDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.MonitoredResourceDimensions[string(keysForMonitoredResourceDimensions[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForMonitoredResourceDimensions[iNdEx])
			copy(dAtA[i:], keysForMonitoredResourceDimensions[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForMonitoredResourceDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.MonitoredResourceType) > 0 {
		i -= len(m.MonitoredResourceType)
		copy(dAtA[i:], m.MonitoredResourceType)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.MonitoredResourceType)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Severity) > 0 {
		i -= len(m.Severity)
		copy(dAtA[i:], m.Severity)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Severity)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Variables) > 0 {
		keysForVariables := make([]string, 0, len(m.Variables))
		for k := range m.Variables {
			keysForVariables = append(keysForVariables, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
		for iNdEx := len(keysForVariables) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Variables[string(keysForVariables[iNdEx])]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(keysForVariables[iNdEx])
			copy(dAtA[i:], keysForVariables[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForVariables[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MonitoredResourceDimensions) > 0 {
		keysForMonitoredResourceDimensions := make([]string, 0, len(m.MonitoredResourceDimensions))
		for k := range m.MonitoredResourceDimensions {
			keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
		for iNdEx := len(keysForMonitoredResourceDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.MonitoredResourceDimensions[string(keysForMonitoredResourceDimensions[iNdEx])]
			baseI := i
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForMonitoredResourceDimensions[iNdEx])
			copy(dAtA[i:], keysForMonitoredResourceDimensions[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForMonitoredResourceDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Variables) > 0 {
		keysForVariables := make([]string, 0, len(m.Variables))
		for k := range m.Variables {
			keysForVariables = append(keysForVariables, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
		for iNdEx := len(keysForVariables) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Variables[string(keysForVariables[iNdEx])]
			baseI := i
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v))
			i--
			dAtA[i] = 0x10
			i -= len(keysForVariables[iNdEx])
			copy(dAtA[i:], keysForVariables[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForVariables[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.MonitoredResourceDimensions) > 0 {
		keysForMonitoredResourceDimensions := make([]string, 0, len(m.MonitoredResourceDimensions))
		for k := range m.MonitoredResourceDimensions {
			keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
		for iNdEx := len(keysForMonitoredResourceDimensions) - 1; iNdEx >= 0; iNdEx-- {
			v := m.MonitoredResourceDimensions[string(keysForMonitoredResourceDimensions[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForMonitoredResourceDimensions[iNdEx])
			copy(dAtA[i:], keysForMonitoredResourceDimensions[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForMonitoredResourceDimensions[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.MonitoredResourceType) > 0 {
		i -= len(m.MonitoredResourceType)
		copy(dAtA[i:], m.MonitoredResourceType)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.MonitoredResourceType)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Severity) > 0 {
		i -= len(m.Severity)
		copy(dAtA[i:], m.Severity)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Severity)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Timestamp) > 0 {
		i -= len(m.Timestamp)
		copy(dAtA[i:], m.Timestamp)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Timestamp)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Variables) > 0 {
		keysForVariables := make([]string, 0, len(m.Variables))
		for k := range m.Variables {
			keysForVariables = append(keysForVariables, string(k))
		}
		github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
		for iNdEx := len(keysForVariables) - 1; iNdEx >= 0; iNdEx-- {
			v := m.Variables[string(keysForVariables[iNdEx])]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(keysForVariables[iNdEx])
			copy(dAtA[i:], keysForVariables[iNdEx])
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(keysForVariables[iNdEx])))
			i--
			dAtA[i] = 0xa
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	offset -= sovTemplateHandlerService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HandleLogEntryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.MonitoredResourceType)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.MonitoredResourceType)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleLogEntryRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInstances := "[]*InstanceMsg{"
	for _, f := range this.Instances {
		repeatedStringForInstances += strings.Replace(f.String(), "InstanceMsg", "InstanceMsg", 1) + ","
	}
	repeatedStringForInstances += "}"
	s := strings.Join([]string{`&HandleLogEntryRequest{`,
		`Instances:` + repeatedStringForInstances + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]*v1beta1.Value{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]*v1beta1.Value{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`Variables:` + mapStringForVariables + `,`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`Severity:` + fmt.Sprintf("%v", this.Severity) + `,`,
		`MonitoredResourceType:` + fmt.Sprintf("%v", this.MonitoredResourceType) + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]v1beta1.ValueType{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]v1beta1.ValueType{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&Type{`,
		`Variables:` + mapStringForVariables + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]string{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]string{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`Variables:` + mapStringForVariables + `,`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`Severity:` + fmt.Sprintf("%v", this.Severity) + `,`,
		`MonitoredResourceType:` + fmt.Sprintf("%v", this.MonitoredResourceType) + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleLogEntryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleLogEntryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleLogEntryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &v1beta1.TimeStamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MonitoredResourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MonitoredResourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthTemplateHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)
