// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/edge/template_handler_service.proto

// The `edge` template represents an edge in the mesh graph.
//
// The `edge` template represents an edge in the mesh graph
//
// When writing the configuration, the value for the fields associated
// with this template can either be a literal or an
// [expression](https://istio.io/docs/reference/config/policy-and-telemetry/expression-language/). Please
// note that if the datatype of a field is not
// istio.mixer.adapter.model.v1beta1.Value, then the expression's
// [inferred type](https://istio.io/docs/reference/config/policy-and-telemetry/expression-language/#type-checking)
// must match the datatype of the field.
//
// Example config:
// ```yaml
// apiVersion: "config.istio.io/v1alpha2"
// kind: instance
// metadata:
//   name: default
//   namespace: istio-system
// spec:
//   compiledTemplate: edge
//   params:
//     timestamp: request.time
//     sourceUid: source.uid | "Unknown"
//     sourceOwner: source.owner | "Unknown"
//     sourceWorkloadName: source.workload.name | "Unknown"
//     sourceWorkloadNamespace: source.workload.namespace | "Unknown"
//     destinationUid: destination.uid | "Unknown"
//     destinationOwner: destination.owner | "Unknown"
//     destinationWorkloadName: destination.workload.name | "Unknown"
//     destinationWorkloadNamespace: destination.workload.namespace | "Unknown"
//     destinationServiceName: destination.service.name | "Unknown"
//     destinationServiceNamespace: destination.service.namespace | "Unknown"
//     apiProtocol: api.protocol | "Unknown"
//     contextProtocol: context.protocol | "Unknown"
// ```

package edge

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Request message for HandleEdge method.
type HandleEdgeRequest struct {
	// 'edge' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleEdgeRequest) Reset()      { *m = HandleEdgeRequest{} }
func (*HandleEdgeRequest) ProtoMessage() {}
func (*HandleEdgeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_25b8933f47ebaac7, []int{0}
}
func (m *HandleEdgeRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleEdgeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *HandleEdgeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleEdgeRequest.Merge(m, src)
}
func (m *HandleEdgeRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleEdgeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleEdgeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleEdgeRequest proto.InternalMessageInfo

// Contains instance payload for 'edge' template. This is passed to infrastructure backends during request-time
// through HandleEdgeService.HandleEdge.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp of the edge
	Timestamp *v1beta1.TimeStamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Namespace of the source workload
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	// Name of the source workload
	SourceWorkloadName string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	// Owner of the source workload (often k8s deployment)
	SourceOwner string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	// UID of the source workload
	SourceUid string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Namespace of the destination workload
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	// Name of the destination workload
	DestinationWorkloadName string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	// Owner of the destination workload (often k8s deployment)
	DestinationOwner string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	// UID of the destination workload
	DestinationUid string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Namespace of the destination Service
	DestinationServiceNamespace string `protobuf:"bytes,24,opt,name=destination_service_namespace,json=destinationServiceNamespace,proto3" json:"destination_service_namespace,omitempty"`
	// Name of the destination Service
	DestinationServiceName string `protobuf:"bytes,25,opt,name=destination_service_name,json=destinationServiceName,proto3" json:"destination_service_name,omitempty"`
	// Protocol used for communication (http, tcp)
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	// The protocol type of the API call (http, https, grpc)
	ApiProtocol string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_25b8933f47ebaac7, []int{1}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'edge' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_25b8933f47ebaac7, []int{2}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

// Represents instance configuration schema for 'edge' template.
type InstanceParam struct {
	// Timestamp of the edge
	Timestamp string `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Namespace of the source workload
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	// Name of the source workload
	SourceWorkloadName string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	// Owner of the source workload (often k8s deployment)
	SourceOwner string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	// UID of the source workload
	SourceUid string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Namespace of the destination workload
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	// Name of the destination workload
	DestinationWorkloadName string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	// Owner of the destination workload (often k8s deployment)
	DestinationOwner string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	// UID of the destination workload
	DestinationUid string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Namespace of the destination Service
	DestinationServiceNamespace string `protobuf:"bytes,24,opt,name=destination_service_namespace,json=destinationServiceNamespace,proto3" json:"destination_service_namespace,omitempty"`
	// Name of the destination Service
	DestinationServiceName string `protobuf:"bytes,25,opt,name=destination_service_name,json=destinationServiceName,proto3" json:"destination_service_name,omitempty"`
	// Protocol used for communication (http, tcp)
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	// The protocol type of the API call (http, https, grpc)
	ApiProtocol string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_25b8933f47ebaac7, []int{3}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleEdgeRequest)(nil), "edge.HandleEdgeRequest")
	proto.RegisterType((*InstanceMsg)(nil), "edge.InstanceMsg")
	proto.RegisterType((*Type)(nil), "edge.Type")
	proto.RegisterType((*InstanceParam)(nil), "edge.InstanceParam")
}

func init() {
	proto.RegisterFile("mixer/template/edge/template_handler_service.proto", fileDescriptor_25b8933f47ebaac7)
}

var fileDescriptor_25b8933f47ebaac7 = []byte{
	// 707 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x95, 0x3d, 0x6f, 0xd4, 0x4c,
	0x10, 0xc7, 0xed, 0xbc, 0x3d, 0xcf, 0xed, 0xe5, 0x75, 0x75, 0x49, 0x7c, 0x79, 0x92, 0x4d, 0x9e,
	0x6b, 0x38, 0x04, 0xb2, 0xc9, 0xd1, 0xa0, 0x20, 0x0a, 0x02, 0x48, 0x44, 0xe2, 0x25, 0xba, 0x04,
	0x28, 0xad, 0x8d, 0x3d, 0x31, 0xab, 0xd8, 0x5e, 0x63, 0xef, 0x25, 0xb9, 0x0e, 0xf8, 0x04, 0x48,
	0x69, 0xf9, 0x00, 0x74, 0x94, 0x34, 0x7c, 0x80, 0x88, 0x2a, 0xa2, 0x4a, 0x83, 0xc4, 0x39, 0x29,
	0x28, 0x53, 0x52, 0x22, 0xaf, 0xf7, 0x72, 0x16, 0x49, 0xe8, 0xe8, 0xd2, 0xdd, 0xce, 0xfc, 0xfe,
	0xb3, 0xf3, 0x97, 0xe7, 0x76, 0x50, 0x23, 0x60, 0xbb, 0x10, 0x5b, 0x02, 0x82, 0xc8, 0xa7, 0x02,
	0x2c, 0x70, 0x3d, 0x38, 0x3d, 0xd9, 0x2f, 0x69, 0xe8, 0xfa, 0x10, 0xdb, 0x09, 0xc4, 0xdb, 0xcc,
	0x01, 0x33, 0x8a, 0xb9, 0xe0, 0x78, 0x20, 0x83, 0x66, 0x2a, 0x1e, 0xf7, 0xb8, 0x0c, 0x58, 0xd9,
	0xaf, 0x3c, 0x37, 0x73, 0x3d, 0xaf, 0x47, 0x5d, 0x1a, 0x09, 0x88, 0xad, 0x80, 0xbb, 0xe0, 0x5b,
	0xdb, 0x8b, 0x1b, 0x20, 0xe8, 0xa2, 0x05, 0xbb, 0x02, 0xc2, 0x84, 0xf1, 0x30, 0x51, 0x74, 0xd5,
	0xe3, 0xdc, 0xf3, 0xc1, 0x92, 0xa7, 0x8d, 0xd6, 0xa6, 0x45, 0xc3, 0xb6, 0x4a, 0xd5, 0xff, 0x54,
	0x28, 0x86, 0x88, 0xc7, 0xa2, 0x5b, 0x24, 0xe2, 0x3e, 0x73, 0xda, 0xa7, 0x49, 0xd1, 0x8e, 0x54,
	0xa7, 0xb5, 0xf7, 0x3a, 0x9a, 0x78, 0x28, 0x3d, 0x3c, 0x70, 0x3d, 0x68, 0xc2, 0xab, 0x16, 0x24,
	0x02, 0x5b, 0xa8, 0xc4, 0xc2, 0x44, 0xd0, 0xd0, 0x81, 0xc4, 0xd0, 0x17, 0xfa, 0xeb, 0xe5, 0xc6,
	0x84, 0x99, 0x79, 0x32, 0x57, 0x54, 0xf8, 0x71, 0xe2, 0x35, 0x7b, 0x0c, 0xbe, 0x8d, 0x46, 0x55,
	0x1f, 0xb6, 0xc3, 0xc3, 0x4d, 0xe6, 0x19, 0x7d, 0x0b, 0x7a, 0xbd, 0xdc, 0xa8, 0x98, 0x79, 0xff,
	0x66, 0xb7, 0x7f, 0xf3, 0x6e, 0xd8, 0x6e, 0x8e, 0x28, 0xf6, 0x9e, 0x44, 0x71, 0x15, 0xfd, 0xeb,
	0x82, 0xdb, 0x8a, 0x6c, 0xe6, 0x1a, 0xfd, 0x0b, 0x7a, 0xbd, 0xd4, 0xfc, 0x47, 0x9e, 0x57, 0xdc,
	0xda, 0xa7, 0x41, 0x54, 0x2e, 0x5c, 0x89, 0x27, 0xd1, 0x40, 0x48, 0x03, 0x30, 0x3e, 0x7e, 0xf9,
	0x5c, 0x93, 0xa4, 0x3c, 0xe2, 0x3b, 0xa8, 0x24, 0x58, 0x00, 0x89, 0xa0, 0x41, 0x64, 0xe8, 0xf2,
	0xe6, 0x79, 0x93, 0x25, 0x82, 0x71, 0x33, 0xb7, 0x6e, 0x2a, 0xeb, 0xe6, 0x3a, 0x0b, 0x60, 0x2d,
	0xc3, 0x9a, 0x3d, 0x05, 0x5e, 0x42, 0xd5, 0x84, 0xb7, 0x62, 0x07, 0xec, 0x1d, 0x1e, 0x6f, 0xf9,
	0x9c, 0xba, 0x76, 0x56, 0x36, 0x89, 0xa8, 0x03, 0x06, 0x92, 0xf7, 0x4c, 0xe7, 0xc0, 0x0b, 0x95,
	0x7f, 0xd2, 0x4d, 0xe3, 0x1b, 0xa8, 0x72, 0x9e, 0xd6, 0x28, 0x4b, 0x19, 0x3e, 0x2b, 0xc3, 0xff,
	0xa3, 0x61, 0xa5, 0xe0, 0x3b, 0x21, 0xc4, 0xc6, 0xb0, 0x24, 0xcb, 0x79, 0xec, 0x69, 0x16, 0xc2,
	0x73, 0x08, 0x29, 0xa4, 0xc5, 0x5c, 0x63, 0x44, 0x02, 0xa5, 0x3c, 0xf2, 0x8c, 0xb9, 0xf8, 0x3e,
	0x22, 0x2e, 0x24, 0x82, 0x85, 0x54, 0x30, 0x1e, 0x9e, 0xd7, 0x74, 0x45, 0x4a, 0x66, 0x0b, 0xd4,
	0xd9, 0xce, 0x97, 0x50, 0xf5, 0xc2, 0x2a, 0xc6, 0x64, 0xee, 0xfa, 0x82, 0x02, 0xf8, 0x1a, 0x9a,
	0x28, 0x6a, 0x73, 0x23, 0x53, 0x52, 0x33, 0x5e, 0x48, 0xe4, 0x6e, 0xae, 0xa0, 0xb1, 0x22, 0x9c,
	0x59, 0x9a, 0x96, 0xe8, 0x68, 0x21, 0x9c, 0xf9, 0x5a, 0x46, 0x73, 0x45, 0x50, 0xfd, 0xa7, 0x0a,
	0xb6, 0x0c, 0x29, 0xfb, 0xaf, 0x00, 0xad, 0xe5, 0x4c, 0xcf, 0xd5, 0x2d, 0x64, 0x5c, 0x54, 0xc3,
	0xa8, 0x4a, 0xf9, 0xd4, 0xf9, 0x72, 0x7c, 0x15, 0x8d, 0x3b, 0x3c, 0x14, 0xb0, 0x2b, 0x6c, 0x39,
	0xad, 0x0e, 0xf7, 0x0d, 0x22, 0x15, 0x63, 0x2a, 0xbe, 0xaa, 0xc2, 0xd9, 0x27, 0xa4, 0x11, 0xeb,
	0x61, 0xf3, 0xf9, 0x27, 0xa4, 0x11, 0xeb, 0x22, 0xb5, 0x21, 0x34, 0xb0, 0xde, 0x8e, 0xa0, 0xf6,
	0x66, 0x10, 0x8d, 0x74, 0x27, 0x78, 0x95, 0xc6, 0x34, 0xc0, 0xb3, 0xbf, 0x0f, 0x6b, 0xe9, 0x72,
	0x16, 0x2f, 0x67, 0xf1, 0x2f, 0xce, 0x62, 0x63, 0xab, 0xf8, 0xc6, 0xab, 0x6b, 0xf0, 0x73, 0x84,
	0x7a, 0x41, 0x3c, 0x9d, 0x3f, 0xef, 0x67, 0x56, 0xc1, 0x8c, 0xa5, 0xde, 0x51, 0xb9, 0x6c, 0x4c,
	0xf5, 0x70, 0x9b, 0x72, 0xd9, 0x9c, 0x3e, 0xaa, 0x4d, 0xb9, 0x6c, 0x9a, 0x90, 0xb4, 0x7c, 0xb1,
	0xfc, 0x68, 0xbf, 0x43, 0xb4, 0x83, 0x0e, 0xd1, 0x0e, 0x3b, 0x44, 0x3b, 0xe9, 0x10, 0xed, 0x75,
	0x4a, 0xf4, 0x0f, 0x29, 0xd1, 0xf6, 0x53, 0xa2, 0x1f, 0xa4, 0x44, 0x3f, 0x4c, 0x89, 0xfe, 0x3d,
	0x25, 0xfa, 0x8f, 0x94, 0x68, 0x27, 0x29, 0xd1, 0xdf, 0x1d, 0x11, 0xed, 0xe0, 0x88, 0x68, 0x87,
	0x47, 0x44, 0xfb, 0xf9, 0xf5, 0x78, 0xaf, 0x4f, 0x7f, 0xfb, 0xed, 0x78, 0xaf, 0x4f, 0xee, 0xd0,
	0x8d, 0x21, 0xe9, 0xeb, 0xe6, 0xaf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xfc, 0xd5, 0x58, 0xc4, 0x86,
	0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleEdgeServiceClient is the client API for HandleEdgeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleEdgeServiceClient interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error)
}

type handleEdgeServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleEdgeServiceClient(cc *grpc.ClientConn) HandleEdgeServiceClient {
	return &handleEdgeServiceClient{cc}
}

func (c *handleEdgeServiceClient) HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error) {
	out := new(v1beta11.ReportResult)
	err := c.cc.Invoke(ctx, "/edge.HandleEdgeService/HandleEdge", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleEdgeServiceServer is the server API for HandleEdgeService service.
type HandleEdgeServiceServer interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(context.Context, *HandleEdgeRequest) (*v1beta11.ReportResult, error)
}

// UnimplementedHandleEdgeServiceServer can be embedded to have forward compatible implementations.
type UnimplementedHandleEdgeServiceServer struct {
}

func (*UnimplementedHandleEdgeServiceServer) HandleEdge(ctx context.Context, req *HandleEdgeRequest) (*v1beta11.ReportResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleEdge not implemented")
}

func RegisterHandleEdgeServiceServer(s *grpc.Server, srv HandleEdgeServiceServer) {
	s.RegisterService(&_HandleEdgeService_serviceDesc, srv)
}

func _HandleEdgeService_HandleEdge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleEdgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/edge.HandleEdgeService/HandleEdge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, req.(*HandleEdgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleEdgeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "edge.HandleEdgeService",
	HandlerType: (*HandleEdgeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleEdge",
			Handler:    _HandleEdgeService_HandleEdge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/edge/template_handler_service.proto",
}

func (m *HandleEdgeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleEdgeRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleEdgeRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.DedupId) > 0 {
		i -= len(m.DedupId)
		copy(dAtA[i:], m.DedupId)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.AdapterConfig != nil {
		{
			size, err := m.AdapterConfig.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.Instances) > 0 {
		for iNdEx := len(m.Instances) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Instances[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceMsg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x93
		i--
		dAtA[i] = 0xe4
		i--
		dAtA[i] = 0xd2
		i--
		dAtA[i] = 0xfa
	}
	if len(m.ApiProtocol) > 0 {
		i -= len(m.ApiProtocol)
		copy(dAtA[i:], m.ApiProtocol)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.ContextProtocol) > 0 {
		i -= len(m.ContextProtocol)
		copy(dAtA[i:], m.ContextProtocol)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if len(m.DestinationServiceName) > 0 {
		i -= len(m.DestinationServiceName)
		copy(dAtA[i:], m.DestinationServiceName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if len(m.DestinationServiceNamespace) > 0 {
		i -= len(m.DestinationServiceNamespace)
		copy(dAtA[i:], m.DestinationServiceNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if len(m.DestinationUid) > 0 {
		i -= len(m.DestinationUid)
		copy(dAtA[i:], m.DestinationUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if len(m.DestinationOwner) > 0 {
		i -= len(m.DestinationOwner)
		copy(dAtA[i:], m.DestinationOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.DestinationWorkloadName) > 0 {
		i -= len(m.DestinationWorkloadName)
		copy(dAtA[i:], m.DestinationWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		i -= len(m.DestinationWorkloadNamespace)
		copy(dAtA[i:], m.DestinationWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.SourceUid) > 0 {
		i -= len(m.SourceUid)
		copy(dAtA[i:], m.SourceUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.SourceOwner) > 0 {
		i -= len(m.SourceOwner)
		copy(dAtA[i:], m.SourceOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.SourceWorkloadName) > 0 {
		i -= len(m.SourceWorkloadName)
		copy(dAtA[i:], m.SourceWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		i -= len(m.SourceWorkloadNamespace)
		copy(dAtA[i:], m.SourceWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i--
		dAtA[i] = 0x52
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Type) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *InstanceParam) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ApiProtocol) > 0 {
		i -= len(m.ApiProtocol)
		copy(dAtA[i:], m.ApiProtocol)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.ContextProtocol) > 0 {
		i -= len(m.ContextProtocol)
		copy(dAtA[i:], m.ContextProtocol)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf2
	}
	if len(m.DestinationServiceName) > 0 {
		i -= len(m.DestinationServiceName)
		copy(dAtA[i:], m.DestinationServiceName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xca
	}
	if len(m.DestinationServiceNamespace) > 0 {
		i -= len(m.DestinationServiceNamespace)
		copy(dAtA[i:], m.DestinationServiceNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationServiceNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc2
	}
	if len(m.DestinationUid) > 0 {
		i -= len(m.DestinationUid)
		copy(dAtA[i:], m.DestinationUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xba
	}
	if len(m.DestinationOwner) > 0 {
		i -= len(m.DestinationOwner)
		copy(dAtA[i:], m.DestinationOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if len(m.DestinationWorkloadName) > 0 {
		i -= len(m.DestinationWorkloadName)
		copy(dAtA[i:], m.DestinationWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xaa
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		i -= len(m.DestinationWorkloadNamespace)
		copy(dAtA[i:], m.DestinationWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if len(m.SourceUid) > 0 {
		i -= len(m.SourceUid)
		copy(dAtA[i:], m.SourceUid)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.SourceOwner) > 0 {
		i -= len(m.SourceOwner)
		copy(dAtA[i:], m.SourceOwner)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.SourceWorkloadName) > 0 {
		i -= len(m.SourceWorkloadName)
		copy(dAtA[i:], m.SourceWorkloadName)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		i -= len(m.SourceWorkloadNamespace)
		copy(dAtA[i:], m.SourceWorkloadNamespace)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Timestamp) > 0 {
		i -= len(m.Timestamp)
		copy(dAtA[i:], m.Timestamp)
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Timestamp)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	offset -= sovTemplateHandlerService(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *HandleEdgeRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationServiceName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleEdgeRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInstances := "[]*InstanceMsg{"
	for _, f := range this.Instances {
		repeatedStringForInstances += strings.Replace(f.String(), "InstanceMsg", "InstanceMsg", 1) + ","
	}
	repeatedStringForInstances += "}"
	s := strings.Join([]string{`&HandleEdgeRequest{`,
		`Instances:` + repeatedStringForInstances + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceMsg{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationServiceNamespace:` + fmt.Sprintf("%v", this.DestinationServiceNamespace) + `,`,
		`DestinationServiceName:` + fmt.Sprintf("%v", this.DestinationServiceName) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceParam{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`DestinationServiceNamespace:` + fmt.Sprintf("%v", this.DestinationServiceNamespace) + `,`,
		`DestinationServiceName:` + fmt.Sprintf("%v", this.DestinationServiceName) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleEdgeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleEdgeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleEdgeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &v1beta1.TimeStamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthTemplateHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)
