// Code generated for package test by go-bindata DO NOT EDIT. (@generated)
// sources:
// ../../../testdata/config/attributes.yaml
// ../../../template/apikey/template.yaml
// ../../../template/authorization/template.yaml
// ../../../template/checknothing/template.yaml
// ../../../template/listentry/template.yaml
// ../../../template/logentry/template.yaml
// ../../../template/metric/template.yaml
// ../../../template/quota/template.yaml
// ../../../template/reportnothing/template.yaml
// ../../../template/tracespan/tracespan.yaml
// ../../../test/spyAdapter/template/apa/tmpl.yaml
// ../../../test/spyAdapter/template/checkoutput/tmpl.yaml
package test

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// Mode return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _TestdataConfigAttributesYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: istio-proxy
  namespace: istio-system
spec:
  attributes:
    origin.ip:
      valueType: IP_ADDRESS
    origin.uid:
      valueType: STRING
    origin.user:
      valueType: STRING
    request.headers:
      valueType: STRING_MAP
    request.id:
      valueType: STRING
    request.host:
      valueType: STRING
    request.method:
      valueType: STRING
    request.path:
      valueType: STRING
    request.url_path:
      valueType: STRING
    request.query_params:
      valueType: STRING_MAP
    request.reason:
      valueType: STRING
    request.referer:
      valueType: STRING
    request.scheme:
      valueType: STRING
    request.total_size:
      valueType: INT64
    request.size:
      valueType: INT64
    request.time:
      valueType: TIMESTAMP
    request.useragent:
      valueType: STRING
    response.code:
      valueType: INT64
    response.duration:
      valueType: DURATION
    response.headers:
      valueType: STRING_MAP
    response.total_size:
      valueType: INT64
    response.size:
      valueType: INT64
    response.time:
      valueType: TIMESTAMP
    response.grpc_status:
      valueType: STRING
    response.grpc_message:
      valueType: STRING
    source.uid:
      valueType: STRING
    source.user: # DEPRECATED
      valueType: STRING
    source.principal:
      valueType: STRING
    destination.uid:
      valueType: STRING
    destination.principal:
      valueType: STRING
    destination.port:
      valueType: INT64
    connection.event:
      valueType: STRING
    connection.id:
      valueType: STRING
    connection.received.bytes:
      valueType: INT64
    connection.received.bytes_total:
      valueType: INT64
    connection.sent.bytes:
      valueType: INT64
    connection.sent.bytes_total:
      valueType: INT64
    connection.duration:
      valueType: DURATION
    connection.mtls:
      valueType: BOOL
    connection.requested_server_name:
      valueType: STRING
    context.protocol:
      valueType: STRING
    context.proxy_error_code:
      valueType: STRING
    context.timestamp:
      valueType: TIMESTAMP
    context.time:
      valueType: TIMESTAMP
    # Deprecated, kept for compatibility
    context.reporter.local:
      valueType: BOOL
    context.reporter.kind:
      valueType: STRING
    context.reporter.uid:
      valueType: STRING
    api.service:
      valueType: STRING
    api.version:
      valueType: STRING
    api.operation:
      valueType: STRING
    api.protocol:
      valueType: STRING
    request.auth.principal:
      valueType: STRING
    request.auth.audiences:
      valueType: STRING
    request.auth.presenter:
      valueType: STRING
    request.auth.claims:
      valueType: STRING_MAP
    request.auth.raw_claims:
      valueType: STRING
    request.api_key:
      valueType: STRING
    rbac.permissive.response_code:
      valueType: STRING
    rbac.permissive.effective_policy_id:
      valueType: STRING
    check.error_code:
      valueType: INT64
    check.error_message:
      valueType: STRING
    check.cache_hit:
      valueType: BOOL
    quota.cache_hit:
      valueType: BOOL
---
apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: kubernetes
  namespace: istio-system
spec:
   attributes:
      source.ip:
        valueType: IP_ADDRESS
      source.labels:
        valueType: STRING_MAP
      source.name:
        valueType: STRING
      source.namespace:
        valueType: STRING
      source.owner:
        valueType: STRING
      source.serviceAccount:
        valueType: STRING
      source.services:
        valueType: STRING
      source.workload.uid:
        valueType: STRING
      source.workload.name:
        valueType: STRING
      source.workload.namespace:
        valueType: STRING
      destination.ip:
        valueType: IP_ADDRESS
      destination.labels:
        valueType: STRING_MAP
      destination.metadata:
        valueType: STRING_MAP
      destination.name:
        valueType: STRING
      destination.namespace:
        valueType: STRING
      destination.owner:
        valueType: STRING
      destination.service.uid:
        valueType: STRING
      destination.service.name:
        valueType: STRING
      destination.service.namespace:
        valueType: STRING
      destination.service.host:
        valueType: STRING
      destination.serviceAccount:
        valueType: STRING
      destination.workload.uid:
        valueType: STRING
      destination.workload.name:
        valueType: STRING
      destination.workload.namespace:
        valueType: STRING
      destination.container.name:
        valueType: STRING
`)

func TestdataConfigAttributesYamlBytes() ([]byte, error) {
	return _TestdataConfigAttributesYaml, nil
}

func TestdataConfigAttributesYaml() (*asset, error) {
	bytes, err := TestdataConfigAttributesYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../testdata/config/attributes.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateApikeyTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/apikey/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/apikey/template.yaml -n apikey
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: apikey
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateApikeyTemplateYamlBytes() ([]byte, error) {
	return _TemplateApikeyTemplateYaml, nil
}

func TemplateApikeyTemplateYaml() (*asset, error) {
	bytes, err := TemplateApikeyTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/apikey/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateAuthorizationTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/authorization/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/authorization/template.yaml -n authorization
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: authorization
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateAuthorizationTemplateYamlBytes() ([]byte, error) {
	return _TemplateAuthorizationTemplateYaml, nil
}

func TemplateAuthorizationTemplateYaml() (*asset, error) {
	bytes, err := TemplateAuthorizationTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/authorization/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateChecknothingTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/checknothing/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/checknothing/template.yaml -n checknothing
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: checknothing
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateChecknothingTemplateYamlBytes() ([]byte, error) {
	return _TemplateChecknothingTemplateYaml, nil
}

func TemplateChecknothingTemplateYaml() (*asset, error) {
	bytes, err := TemplateChecknothingTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/checknothing/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateListentryTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/listentry/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/listentry/template.yaml -n listentry
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: listentry
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateListentryTemplateYamlBytes() ([]byte, error) {
	return _TemplateListentryTemplateYaml, nil
}

func TemplateListentryTemplateYaml() (*asset, error) {
	bytes, err := TemplateListentryTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/listentry/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateLogentryTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/logentry/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/logentry/template.yaml -n logentry
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: logentry
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateLogentryTemplateYamlBytes() ([]byte, error) {
	return _TemplateLogentryTemplateYaml, nil
}

func TemplateLogentryTemplateYaml() (*asset, error) {
	bytes, err := TemplateLogentryTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/logentry/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateMetricTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/metric/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/metric/template.yaml -n metric
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: metric
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateMetricTemplateYamlBytes() ([]byte, error) {
	return _TemplateMetricTemplateYaml, nil
}

func TemplateMetricTemplateYaml() (*asset, error) {
	bytes, err := TemplateMetricTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/metric/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateQuotaTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/quota/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/quota/template.yaml -n quota
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: quota
  namespace: istio-system
spec:
  descriptor: "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"
---
`)

func TemplateQuotaTemplateYamlBytes() ([]byte, error) {
	return _TemplateQuotaTemplateYaml, nil
}

func TemplateQuotaTemplateYaml() (*asset, error) {
	bytes, err := TemplateQuotaTemplateYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "../../../template/quota/template.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _TemplateReportnothingTemplateYaml = []byte(`# this config is created through command
# mixgen template -d $REPO_ROOT/mixer/template/reportnothing/template_handler_service.descriptor_set -o $REPO_ROOT/mixer/template/reportnothing/template.yaml -n reportnothing
apiVersion: "config.istio.io/v1alpha2"
kind: template
metadata:
  name: reportnothing
  namespace: istio-system
spec:
  descriptor: "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