// Copyright Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by pilot/pkg/config/kube/crd/codegen/types.go. DO NOT EDIT!

package crd

// This file contains Go definitions for Custom Resource Definition kinds
// to adhere to the idiomatic use of k8s API machinery.
// These definitions are synthesized from Istio configuration type descriptors
// as declared in the Istio config model.

import (
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"

	"istio.io/istio/pkg/config/schema/collection"
	"istio.io/istio/pkg/config/schema/collections"
	"istio.io/istio/pkg/config/schema/resource"
)

type SchemaType struct {
	Schema     collection.Schema
	Object     IstioObject
	Collection IstioObjectList
}

// SupportedSchemas for all supported types.
var SupportedSchemas = collection.NewSchemasBuilder().
	MustAdd(collections.Mock).
	MustAdd(collections.IstioAuthenticationV1Alpha1Meshpolicies).
	MustAdd(collections.IstioAuthenticationV1Alpha1Policies).
	MustAdd(collections.IstioConfigV1Alpha2Httpapispecbindings).
	MustAdd(collections.IstioConfigV1Alpha2Httpapispecs).
	MustAdd(collections.IstioMixerV1ConfigClientQuotaspecbindings).
	MustAdd(collections.IstioMixerV1ConfigClientQuotaspecs).
	MustAdd(collections.IstioNetworkingV1Alpha3Destinationrules).
	MustAdd(collections.IstioNetworkingV1Alpha3Envoyfilters).
	MustAdd(collections.IstioNetworkingV1Alpha3Gateways).
	MustAdd(collections.IstioNetworkingV1Alpha3Serviceentries).
	MustAdd(collections.IstioNetworkingV1Alpha3Sidecars).
	MustAdd(collections.IstioNetworkingV1Alpha3Virtualservices).
	MustAdd(collections.IstioRbacV1Alpha1Clusterrbacconfigs).
	MustAdd(collections.IstioRbacV1Alpha1Rbacconfigs).
	MustAdd(collections.IstioRbacV1Alpha1Servicerolebindings).
	MustAdd(collections.IstioRbacV1Alpha1Serviceroles).
	MustAdd(collections.IstioSecurityV1Beta1Authorizationpolicies).
	MustAdd(collections.IstioSecurityV1Beta1Peerauthentications).
	MustAdd(collections.IstioSecurityV1Beta1Requestauthentications).
	Build()

// SupportedTypes maps kind to the resource information for the type.
var SupportedTypes = map[resource.GroupVersionKind]SchemaType{
	collections.Mock.Resource().GroupVersionKind(): {
		Schema: collections.Mock,
		Object: &Mock{
			TypeMeta: metav1.TypeMeta{
				Kind:       "MockConfig",
				APIVersion: collections.Mock.Resource().APIVersion(),
			},
		},
		Collection: &MockList{},
	},
	collections.IstioAuthenticationV1Alpha1Meshpolicies.Resource().GroupVersionKind(): {
		Schema: collections.IstioAuthenticationV1Alpha1Meshpolicies,
		Object: &IstioAuthenticationV1Alpha1Meshpolicies{
			TypeMeta: metav1.TypeMeta{
				Kind:       "MeshPolicy",
				APIVersion: collections.IstioAuthenticationV1Alpha1Meshpolicies.Resource().APIVersion(),
			},
		},
		Collection: &IstioAuthenticationV1Alpha1MeshpoliciesList{},
	},
	collections.IstioAuthenticationV1Alpha1Policies.Resource().GroupVersionKind(): {
		Schema: collections.IstioAuthenticationV1Alpha1Policies,
		Object: &IstioAuthenticationV1Alpha1Policies{
			TypeMeta: metav1.TypeMeta{
				Kind:       "Policy",
				APIVersion: collections.IstioAuthenticationV1Alpha1Policies.Resource().APIVersion(),
			},
		},
		Collection: &IstioAuthenticationV1Alpha1PoliciesList{},
	},
	collections.IstioConfigV1Alpha2Httpapispecbindings.Resource().GroupVersionKind(): {
		Schema: collections.IstioConfigV1Alpha2Httpapispecbindings,
		Object: &IstioConfigV1Alpha2Httpapispecbindings{
			TypeMeta: metav1.TypeMeta{
				Kind:       "HTTPAPISpecBinding",
				APIVersion: collections.IstioConfigV1Alpha2Httpapispecbindings.Resource().APIVersion(),
			},
		},
		Collection: &IstioConfigV1Alpha2HttpapispecbindingsList{},
	},
	collections.IstioConfigV1Alpha2Httpapispecs.Resource().GroupVersionKind(): {
		Schema: collections.IstioConfigV1Alpha2Httpapispecs,
		Object: &IstioConfigV1Alpha2Httpapispecs{
			TypeMeta: metav1.TypeMeta{
				Kind:       "HTTPAPISpec",
				APIVersion: collections.IstioConfigV1Alpha2Httpapispecs.Resource().APIVersion(),
			},
		},
		Collection: &IstioConfigV1Alpha2HttpapispecsList{},
	},
	collections.IstioMixerV1ConfigClientQuotaspecbindings.Resource().GroupVersionKind(): {
		Schema: collections.IstioMixerV1ConfigClientQuotaspecbindings,
		Object: &IstioMixerV1ConfigClientQuotaspecbindings{
			TypeMeta: metav1.TypeMeta{
				Kind:       "QuotaSpecBinding",
				APIVersion: collections.IstioMixerV1ConfigClientQuotaspecbindings.Resource().APIVersion(),
			},
		},
		Collection: &IstioMixerV1ConfigClientQuotaspecbindingsList{},
	},
	collections.IstioMixerV1ConfigClientQuotaspecs.Resource().GroupVersionKind(): {
		Schema: collections.IstioMixerV1ConfigClientQuotaspecs,
		Object: &IstioMixerV1ConfigClientQuotaspecs{
			TypeMeta: metav1.TypeMeta{
				Kind:       "QuotaSpec",
				APIVersion: collections.IstioMixerV1ConfigClientQuotaspecs.Resource().APIVersion(),
			},
		},
		Collection: &IstioMixerV1ConfigClientQuotaspecsList{},
	},
	collections.IstioNetworkingV1Alpha3Destinationrules.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Destinationrules,
		Object: &IstioNetworkingV1Alpha3Destinationrules{
			TypeMeta: metav1.TypeMeta{
				Kind:       "DestinationRule",
				APIVersion: collections.IstioNetworkingV1Alpha3Destinationrules.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3DestinationrulesList{},
	},
	collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Envoyfilters,
		Object: &IstioNetworkingV1Alpha3Envoyfilters{
			TypeMeta: metav1.TypeMeta{
				Kind:       "EnvoyFilter",
				APIVersion: collections.IstioNetworkingV1Alpha3Envoyfilters.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3EnvoyfiltersList{},
	},
	collections.IstioNetworkingV1Alpha3Gateways.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Gateways,
		Object: &IstioNetworkingV1Alpha3Gateways{
			TypeMeta: metav1.TypeMeta{
				Kind:       "Gateway",
				APIVersion: collections.IstioNetworkingV1Alpha3Gateways.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3GatewaysList{},
	},
	collections.IstioNetworkingV1Alpha3Serviceentries.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Serviceentries,
		Object: &IstioNetworkingV1Alpha3Serviceentries{
			TypeMeta: metav1.TypeMeta{
				Kind:       "ServiceEntry",
				APIVersion: collections.IstioNetworkingV1Alpha3Serviceentries.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3ServiceentriesList{},
	},
	collections.IstioNetworkingV1Alpha3Sidecars.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Sidecars,
		Object: &IstioNetworkingV1Alpha3Sidecars{
			TypeMeta: metav1.TypeMeta{
				Kind:       "Sidecar",
				APIVersion: collections.IstioNetworkingV1Alpha3Sidecars.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3SidecarsList{},
	},
	collections.IstioNetworkingV1Alpha3Virtualservices.Resource().GroupVersionKind(): {
		Schema: collections.IstioNetworkingV1Alpha3Virtualservices,
		Object: &IstioNetworkingV1Alpha3Virtualservices{
			TypeMeta: metav1.TypeMeta{
				Kind:       "VirtualService",
				APIVersion: collections.IstioNetworkingV1Alpha3Virtualservices.Resource().APIVersion(),
			},
		},
		Collection: &IstioNetworkingV1Alpha3VirtualservicesList{},
	},
	collections.IstioRbacV1Alpha1Clusterrbacconfigs.Resource().GroupVersionKind(): {
		Schema: collections.IstioRbacV1Alpha1Clusterrbacconfigs,
		Object: &IstioRbacV1Alpha1Clusterrbacconfigs{
			TypeMeta: metav1.TypeMeta{
				Kind:       "ClusterRbacConfig",
				APIVersion: collections.IstioRbacV1Alpha1Clusterrbacconfigs.Resource().APIVersion(),
			},
		},
		Collection: &IstioRbacV1Alpha1ClusterrbacconfigsList{},
	},
	collections.IstioRbacV1Alpha1Rbacconfigs.Resource().GroupVersionKind(): {
		Schema: collections.IstioRbacV1Alpha1Rbacconfigs,
		Object: &IstioRbacV1Alpha1Rbacconfigs{
			TypeMeta: metav1.TypeMeta{
				Kind:       "RbacConfig",
				APIVersion: collections.IstioRbacV1Alpha1Rbacconfigs.Resource().APIVersion(),
			},
		},
		Collection: &IstioRbacV1Alpha1RbacconfigsList{},
	},
	collections.IstioRbacV1Alpha1Servicerolebindings.Resource().GroupVersionKind(): {
		Schema: collections.IstioRbacV1Alpha1Servicerolebindings,
		Object: &IstioRbacV1Alpha1Servicerolebindings{
			TypeMeta: metav1.TypeMeta{
				Kind:       "ServiceRoleBinding",
				APIVersion: collections.IstioRbacV1Alpha1Servicerolebindings.Resource().APIVersion(),
			},
		},
		Collection: &IstioRbacV1Alpha1ServicerolebindingsList{},
	},
	collections.IstioRbacV1Alpha1Serviceroles.Resource().GroupVersionKind(): {
		Schema: collections.IstioRbacV1Alpha1Serviceroles,
		Object: &IstioRbacV1Alpha1Serviceroles{
			TypeMeta: metav1.TypeMeta{
				Kind:       "ServiceRole",
				APIVersion: collections.IstioRbacV1Alpha1Serviceroles.Resource().APIVersion(),
			},
		},
		Collection: &IstioRbacV1Alpha1ServicerolesList{},
	},
	collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().GroupVersionKind(): {
		Schema: collections.IstioSecurityV1Beta1Authorizationpolicies,
		Object: &IstioSecurityV1Beta1Authorizationpolicies{
			TypeMeta: metav1.TypeMeta{
				Kind:       "AuthorizationPolicy",
				APIVersion: collections.IstioSecurityV1Beta1Authorizationpolicies.Resource().APIVersion(),
			},
		},
		Collection: &IstioSecurityV1Beta1AuthorizationpoliciesList{},
	},
	collections.IstioSecurityV1Beta1Peerauthentications.Resource().GroupVersionKind(): {
		Schema: collections.IstioSecurityV1Beta1Peerauthentications,
		Object: &IstioSecurityV1Beta1Peerauthentications{
			TypeMeta: metav1.TypeMeta{
				Kind:       "PeerAuthentication",
				APIVersion: collections.IstioSecurityV1Beta1Peerauthentications.Resource().APIVersion(),
			},
		},
		Collection: &IstioSecurityV1Beta1PeerauthenticationsList{},
	},
	collections.IstioSecurityV1Beta1Requestauthentications.Resource().GroupVersionKind(): {
		Schema: collections.IstioSecurityV1Beta1Requestauthentications,
		Object: &IstioSecurityV1Beta1Requestauthentications{
			TypeMeta: metav1.TypeMeta{
				Kind:       "RequestAuthentication",
				APIVersion: collections.IstioSecurityV1Beta1Requestauthentications.Resource().APIVersion(),
			},
		},
		Collection: &IstioSecurityV1Beta1RequestauthenticationsList{},
	},
}

// Mock is the generic Kubernetes API Object wrapper
type Mock struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *Mock) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *Mock) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *Mock) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *Mock) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// MockList is the generic Kubernetes API list wrapper
type MockList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []Mock `json:"items"`
}

// GetItems from a wrapper
func (in *MockList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Mock) DeepCopyInto(out *Mock) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Mock.
func (in *Mock) DeepCopy() *Mock {
	if in == nil {
		return nil
	}
	out := new(Mock)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Mock) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MockList) DeepCopyInto(out *MockList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Mock, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MockList.
func (in *MockList) DeepCopy() *MockList {
	if in == nil {
		return nil
	}
	out := new(MockList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MockList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioAuthenticationV1Alpha1Meshpolicies is the generic Kubernetes API Object wrapper
type IstioAuthenticationV1Alpha1Meshpolicies struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioAuthenticationV1Alpha1Meshpolicies) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioAuthenticationV1Alpha1Meshpolicies) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioAuthenticationV1Alpha1Meshpolicies) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioAuthenticationV1Alpha1Meshpolicies) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioAuthenticationV1Alpha1MeshpoliciesList is the generic Kubernetes API list wrapper
type IstioAuthenticationV1Alpha1MeshpoliciesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioAuthenticationV1Alpha1Meshpolicies `json:"items"`
}

// GetItems from a wrapper
func (in *IstioAuthenticationV1Alpha1MeshpoliciesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioAuthenticationV1Alpha1Meshpolicies) DeepCopyInto(out *IstioAuthenticationV1Alpha1Meshpolicies) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioAuthenticationV1Alpha1Meshpolicies.
func (in *IstioAuthenticationV1Alpha1Meshpolicies) DeepCopy() *IstioAuthenticationV1Alpha1Meshpolicies {
	if in == nil {
		return nil
	}
	out := new(IstioAuthenticationV1Alpha1Meshpolicies)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioAuthenticationV1Alpha1Meshpolicies) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioAuthenticationV1Alpha1MeshpoliciesList) DeepCopyInto(out *IstioAuthenticationV1Alpha1MeshpoliciesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioAuthenticationV1Alpha1Meshpolicies, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioAuthenticationV1Alpha1MeshpoliciesList.
func (in *IstioAuthenticationV1Alpha1MeshpoliciesList) DeepCopy() *IstioAuthenticationV1Alpha1MeshpoliciesList {
	if in == nil {
		return nil
	}
	out := new(IstioAuthenticationV1Alpha1MeshpoliciesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioAuthenticationV1Alpha1MeshpoliciesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioAuthenticationV1Alpha1Policies is the generic Kubernetes API Object wrapper
type IstioAuthenticationV1Alpha1Policies struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioAuthenticationV1Alpha1Policies) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioAuthenticationV1Alpha1Policies) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioAuthenticationV1Alpha1Policies) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioAuthenticationV1Alpha1Policies) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioAuthenticationV1Alpha1PoliciesList is the generic Kubernetes API list wrapper
type IstioAuthenticationV1Alpha1PoliciesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioAuthenticationV1Alpha1Policies `json:"items"`
}

// GetItems from a wrapper
func (in *IstioAuthenticationV1Alpha1PoliciesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioAuthenticationV1Alpha1Policies) DeepCopyInto(out *IstioAuthenticationV1Alpha1Policies) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioAuthenticationV1Alpha1Policies.
func (in *IstioAuthenticationV1Alpha1Policies) DeepCopy() *IstioAuthenticationV1Alpha1Policies {
	if in == nil {
		return nil
	}
	out := new(IstioAuthenticationV1Alpha1Policies)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioAuthenticationV1Alpha1Policies) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioAuthenticationV1Alpha1PoliciesList) DeepCopyInto(out *IstioAuthenticationV1Alpha1PoliciesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioAuthenticationV1Alpha1Policies, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioAuthenticationV1Alpha1PoliciesList.
func (in *IstioAuthenticationV1Alpha1PoliciesList) DeepCopy() *IstioAuthenticationV1Alpha1PoliciesList {
	if in == nil {
		return nil
	}
	out := new(IstioAuthenticationV1Alpha1PoliciesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioAuthenticationV1Alpha1PoliciesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioConfigV1Alpha2Httpapispecbindings is the generic Kubernetes API Object wrapper
type IstioConfigV1Alpha2Httpapispecbindings struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioConfigV1Alpha2Httpapispecbindings) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioConfigV1Alpha2Httpapispecbindings) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioConfigV1Alpha2Httpapispecbindings) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioConfigV1Alpha2Httpapispecbindings) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioConfigV1Alpha2HttpapispecbindingsList is the generic Kubernetes API list wrapper
type IstioConfigV1Alpha2HttpapispecbindingsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioConfigV1Alpha2Httpapispecbindings `json:"items"`
}

// GetItems from a wrapper
func (in *IstioConfigV1Alpha2HttpapispecbindingsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioConfigV1Alpha2Httpapispecbindings) DeepCopyInto(out *IstioConfigV1Alpha2Httpapispecbindings) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioConfigV1Alpha2Httpapispecbindings.
func (in *IstioConfigV1Alpha2Httpapispecbindings) DeepCopy() *IstioConfigV1Alpha2Httpapispecbindings {
	if in == nil {
		return nil
	}
	out := new(IstioConfigV1Alpha2Httpapispecbindings)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioConfigV1Alpha2Httpapispecbindings) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioConfigV1Alpha2HttpapispecbindingsList) DeepCopyInto(out *IstioConfigV1Alpha2HttpapispecbindingsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioConfigV1Alpha2Httpapispecbindings, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioConfigV1Alpha2HttpapispecbindingsList.
func (in *IstioConfigV1Alpha2HttpapispecbindingsList) DeepCopy() *IstioConfigV1Alpha2HttpapispecbindingsList {
	if in == nil {
		return nil
	}
	out := new(IstioConfigV1Alpha2HttpapispecbindingsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioConfigV1Alpha2HttpapispecbindingsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioConfigV1Alpha2Httpapispecs is the generic Kubernetes API Object wrapper
type IstioConfigV1Alpha2Httpapispecs struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioConfigV1Alpha2Httpapispecs) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioConfigV1Alpha2Httpapispecs) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioConfigV1Alpha2Httpapispecs) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioConfigV1Alpha2Httpapispecs) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioConfigV1Alpha2HttpapispecsList is the generic Kubernetes API list wrapper
type IstioConfigV1Alpha2HttpapispecsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioConfigV1Alpha2Httpapispecs `json:"items"`
}

// GetItems from a wrapper
func (in *IstioConfigV1Alpha2HttpapispecsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioConfigV1Alpha2Httpapispecs) DeepCopyInto(out *IstioConfigV1Alpha2Httpapispecs) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioConfigV1Alpha2Httpapispecs.
func (in *IstioConfigV1Alpha2Httpapispecs) DeepCopy() *IstioConfigV1Alpha2Httpapispecs {
	if in == nil {
		return nil
	}
	out := new(IstioConfigV1Alpha2Httpapispecs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioConfigV1Alpha2Httpapispecs) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioConfigV1Alpha2HttpapispecsList) DeepCopyInto(out *IstioConfigV1Alpha2HttpapispecsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioConfigV1Alpha2Httpapispecs, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioConfigV1Alpha2HttpapispecsList.
func (in *IstioConfigV1Alpha2HttpapispecsList) DeepCopy() *IstioConfigV1Alpha2HttpapispecsList {
	if in == nil {
		return nil
	}
	out := new(IstioConfigV1Alpha2HttpapispecsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioConfigV1Alpha2HttpapispecsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioMixerV1ConfigClientQuotaspecbindings is the generic Kubernetes API Object wrapper
type IstioMixerV1ConfigClientQuotaspecbindings struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecbindings) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecbindings) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecbindings) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecbindings) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioMixerV1ConfigClientQuotaspecbindingsList is the generic Kubernetes API list wrapper
type IstioMixerV1ConfigClientQuotaspecbindingsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioMixerV1ConfigClientQuotaspecbindings `json:"items"`
}

// GetItems from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecbindingsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioMixerV1ConfigClientQuotaspecbindings) DeepCopyInto(out *IstioMixerV1ConfigClientQuotaspecbindings) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioMixerV1ConfigClientQuotaspecbindings.
func (in *IstioMixerV1ConfigClientQuotaspecbindings) DeepCopy() *IstioMixerV1ConfigClientQuotaspecbindings {
	if in == nil {
		return nil
	}
	out := new(IstioMixerV1ConfigClientQuotaspecbindings)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioMixerV1ConfigClientQuotaspecbindings) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioMixerV1ConfigClientQuotaspecbindingsList) DeepCopyInto(out *IstioMixerV1ConfigClientQuotaspecbindingsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioMixerV1ConfigClientQuotaspecbindings, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioMixerV1ConfigClientQuotaspecbindingsList.
func (in *IstioMixerV1ConfigClientQuotaspecbindingsList) DeepCopy() *IstioMixerV1ConfigClientQuotaspecbindingsList {
	if in == nil {
		return nil
	}
	out := new(IstioMixerV1ConfigClientQuotaspecbindingsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioMixerV1ConfigClientQuotaspecbindingsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioMixerV1ConfigClientQuotaspecs is the generic Kubernetes API Object wrapper
type IstioMixerV1ConfigClientQuotaspecs struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecs) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecs) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecs) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecs) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioMixerV1ConfigClientQuotaspecsList is the generic Kubernetes API list wrapper
type IstioMixerV1ConfigClientQuotaspecsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioMixerV1ConfigClientQuotaspecs `json:"items"`
}

// GetItems from a wrapper
func (in *IstioMixerV1ConfigClientQuotaspecsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioMixerV1ConfigClientQuotaspecs) DeepCopyInto(out *IstioMixerV1ConfigClientQuotaspecs) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioMixerV1ConfigClientQuotaspecs.
func (in *IstioMixerV1ConfigClientQuotaspecs) DeepCopy() *IstioMixerV1ConfigClientQuotaspecs {
	if in == nil {
		return nil
	}
	out := new(IstioMixerV1ConfigClientQuotaspecs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioMixerV1ConfigClientQuotaspecs) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioMixerV1ConfigClientQuotaspecsList) DeepCopyInto(out *IstioMixerV1ConfigClientQuotaspecsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioMixerV1ConfigClientQuotaspecs, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioMixerV1ConfigClientQuotaspecsList.
func (in *IstioMixerV1ConfigClientQuotaspecsList) DeepCopy() *IstioMixerV1ConfigClientQuotaspecsList {
	if in == nil {
		return nil
	}
	out := new(IstioMixerV1ConfigClientQuotaspecsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioMixerV1ConfigClientQuotaspecsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Destinationrules is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Destinationrules struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Destinationrules) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Destinationrules) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Destinationrules) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Destinationrules) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3DestinationrulesList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3DestinationrulesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Destinationrules `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3DestinationrulesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Destinationrules) DeepCopyInto(out *IstioNetworkingV1Alpha3Destinationrules) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Destinationrules.
func (in *IstioNetworkingV1Alpha3Destinationrules) DeepCopy() *IstioNetworkingV1Alpha3Destinationrules {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Destinationrules)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Destinationrules) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3DestinationrulesList) DeepCopyInto(out *IstioNetworkingV1Alpha3DestinationrulesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Destinationrules, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3DestinationrulesList.
func (in *IstioNetworkingV1Alpha3DestinationrulesList) DeepCopy() *IstioNetworkingV1Alpha3DestinationrulesList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3DestinationrulesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3DestinationrulesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Envoyfilters is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Envoyfilters struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Envoyfilters) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Envoyfilters) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Envoyfilters) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Envoyfilters) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3EnvoyfiltersList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3EnvoyfiltersList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Envoyfilters `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3EnvoyfiltersList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Envoyfilters) DeepCopyInto(out *IstioNetworkingV1Alpha3Envoyfilters) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Envoyfilters.
func (in *IstioNetworkingV1Alpha3Envoyfilters) DeepCopy() *IstioNetworkingV1Alpha3Envoyfilters {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Envoyfilters)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Envoyfilters) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3EnvoyfiltersList) DeepCopyInto(out *IstioNetworkingV1Alpha3EnvoyfiltersList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Envoyfilters, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3EnvoyfiltersList.
func (in *IstioNetworkingV1Alpha3EnvoyfiltersList) DeepCopy() *IstioNetworkingV1Alpha3EnvoyfiltersList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3EnvoyfiltersList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3EnvoyfiltersList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Gateways is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Gateways struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Gateways) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Gateways) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Gateways) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Gateways) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3GatewaysList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3GatewaysList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Gateways `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3GatewaysList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Gateways) DeepCopyInto(out *IstioNetworkingV1Alpha3Gateways) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Gateways.
func (in *IstioNetworkingV1Alpha3Gateways) DeepCopy() *IstioNetworkingV1Alpha3Gateways {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Gateways)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Gateways) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3GatewaysList) DeepCopyInto(out *IstioNetworkingV1Alpha3GatewaysList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Gateways, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3GatewaysList.
func (in *IstioNetworkingV1Alpha3GatewaysList) DeepCopy() *IstioNetworkingV1Alpha3GatewaysList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3GatewaysList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3GatewaysList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Serviceentries is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Serviceentries struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Serviceentries) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Serviceentries) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Serviceentries) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Serviceentries) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3ServiceentriesList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3ServiceentriesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Serviceentries `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3ServiceentriesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Serviceentries) DeepCopyInto(out *IstioNetworkingV1Alpha3Serviceentries) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Serviceentries.
func (in *IstioNetworkingV1Alpha3Serviceentries) DeepCopy() *IstioNetworkingV1Alpha3Serviceentries {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Serviceentries)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Serviceentries) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3ServiceentriesList) DeepCopyInto(out *IstioNetworkingV1Alpha3ServiceentriesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Serviceentries, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3ServiceentriesList.
func (in *IstioNetworkingV1Alpha3ServiceentriesList) DeepCopy() *IstioNetworkingV1Alpha3ServiceentriesList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3ServiceentriesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3ServiceentriesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Sidecars is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Sidecars struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Sidecars) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Sidecars) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Sidecars) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Sidecars) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3SidecarsList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3SidecarsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Sidecars `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3SidecarsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Sidecars) DeepCopyInto(out *IstioNetworkingV1Alpha3Sidecars) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Sidecars.
func (in *IstioNetworkingV1Alpha3Sidecars) DeepCopy() *IstioNetworkingV1Alpha3Sidecars {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Sidecars)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Sidecars) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3SidecarsList) DeepCopyInto(out *IstioNetworkingV1Alpha3SidecarsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Sidecars, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3SidecarsList.
func (in *IstioNetworkingV1Alpha3SidecarsList) DeepCopy() *IstioNetworkingV1Alpha3SidecarsList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3SidecarsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3SidecarsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioNetworkingV1Alpha3Virtualservices is the generic Kubernetes API Object wrapper
type IstioNetworkingV1Alpha3Virtualservices struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioNetworkingV1Alpha3Virtualservices) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioNetworkingV1Alpha3Virtualservices) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioNetworkingV1Alpha3Virtualservices) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioNetworkingV1Alpha3Virtualservices) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioNetworkingV1Alpha3VirtualservicesList is the generic Kubernetes API list wrapper
type IstioNetworkingV1Alpha3VirtualservicesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioNetworkingV1Alpha3Virtualservices `json:"items"`
}

// GetItems from a wrapper
func (in *IstioNetworkingV1Alpha3VirtualservicesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3Virtualservices) DeepCopyInto(out *IstioNetworkingV1Alpha3Virtualservices) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3Virtualservices.
func (in *IstioNetworkingV1Alpha3Virtualservices) DeepCopy() *IstioNetworkingV1Alpha3Virtualservices {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3Virtualservices)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3Virtualservices) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioNetworkingV1Alpha3VirtualservicesList) DeepCopyInto(out *IstioNetworkingV1Alpha3VirtualservicesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioNetworkingV1Alpha3Virtualservices, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioNetworkingV1Alpha3VirtualservicesList.
func (in *IstioNetworkingV1Alpha3VirtualservicesList) DeepCopy() *IstioNetworkingV1Alpha3VirtualservicesList {
	if in == nil {
		return nil
	}
	out := new(IstioNetworkingV1Alpha3VirtualservicesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioNetworkingV1Alpha3VirtualservicesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioRbacV1Alpha1Clusterrbacconfigs is the generic Kubernetes API Object wrapper
type IstioRbacV1Alpha1Clusterrbacconfigs struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioRbacV1Alpha1ClusterrbacconfigsList is the generic Kubernetes API list wrapper
type IstioRbacV1Alpha1ClusterrbacconfigsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioRbacV1Alpha1Clusterrbacconfigs `json:"items"`
}

// GetItems from a wrapper
func (in *IstioRbacV1Alpha1ClusterrbacconfigsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) DeepCopyInto(out *IstioRbacV1Alpha1Clusterrbacconfigs) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1Clusterrbacconfigs.
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) DeepCopy() *IstioRbacV1Alpha1Clusterrbacconfigs {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1Clusterrbacconfigs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1Clusterrbacconfigs) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1ClusterrbacconfigsList) DeepCopyInto(out *IstioRbacV1Alpha1ClusterrbacconfigsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioRbacV1Alpha1Clusterrbacconfigs, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1ClusterrbacconfigsList.
func (in *IstioRbacV1Alpha1ClusterrbacconfigsList) DeepCopy() *IstioRbacV1Alpha1ClusterrbacconfigsList {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1ClusterrbacconfigsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1ClusterrbacconfigsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioRbacV1Alpha1Rbacconfigs is the generic Kubernetes API Object wrapper
type IstioRbacV1Alpha1Rbacconfigs struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioRbacV1Alpha1Rbacconfigs) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioRbacV1Alpha1Rbacconfigs) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioRbacV1Alpha1Rbacconfigs) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioRbacV1Alpha1Rbacconfigs) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioRbacV1Alpha1RbacconfigsList is the generic Kubernetes API list wrapper
type IstioRbacV1Alpha1RbacconfigsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioRbacV1Alpha1Rbacconfigs `json:"items"`
}

// GetItems from a wrapper
func (in *IstioRbacV1Alpha1RbacconfigsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1Rbacconfigs) DeepCopyInto(out *IstioRbacV1Alpha1Rbacconfigs) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1Rbacconfigs.
func (in *IstioRbacV1Alpha1Rbacconfigs) DeepCopy() *IstioRbacV1Alpha1Rbacconfigs {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1Rbacconfigs)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1Rbacconfigs) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1RbacconfigsList) DeepCopyInto(out *IstioRbacV1Alpha1RbacconfigsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioRbacV1Alpha1Rbacconfigs, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1RbacconfigsList.
func (in *IstioRbacV1Alpha1RbacconfigsList) DeepCopy() *IstioRbacV1Alpha1RbacconfigsList {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1RbacconfigsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1RbacconfigsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioRbacV1Alpha1Servicerolebindings is the generic Kubernetes API Object wrapper
type IstioRbacV1Alpha1Servicerolebindings struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioRbacV1Alpha1Servicerolebindings) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioRbacV1Alpha1Servicerolebindings) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioRbacV1Alpha1Servicerolebindings) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioRbacV1Alpha1Servicerolebindings) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioRbacV1Alpha1ServicerolebindingsList is the generic Kubernetes API list wrapper
type IstioRbacV1Alpha1ServicerolebindingsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioRbacV1Alpha1Servicerolebindings `json:"items"`
}

// GetItems from a wrapper
func (in *IstioRbacV1Alpha1ServicerolebindingsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1Servicerolebindings) DeepCopyInto(out *IstioRbacV1Alpha1Servicerolebindings) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1Servicerolebindings.
func (in *IstioRbacV1Alpha1Servicerolebindings) DeepCopy() *IstioRbacV1Alpha1Servicerolebindings {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1Servicerolebindings)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1Servicerolebindings) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1ServicerolebindingsList) DeepCopyInto(out *IstioRbacV1Alpha1ServicerolebindingsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioRbacV1Alpha1Servicerolebindings, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1ServicerolebindingsList.
func (in *IstioRbacV1Alpha1ServicerolebindingsList) DeepCopy() *IstioRbacV1Alpha1ServicerolebindingsList {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1ServicerolebindingsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1ServicerolebindingsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioRbacV1Alpha1Serviceroles is the generic Kubernetes API Object wrapper
type IstioRbacV1Alpha1Serviceroles struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioRbacV1Alpha1Serviceroles) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioRbacV1Alpha1Serviceroles) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioRbacV1Alpha1Serviceroles) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioRbacV1Alpha1Serviceroles) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioRbacV1Alpha1ServicerolesList is the generic Kubernetes API list wrapper
type IstioRbacV1Alpha1ServicerolesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioRbacV1Alpha1Serviceroles `json:"items"`
}

// GetItems from a wrapper
func (in *IstioRbacV1Alpha1ServicerolesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1Serviceroles) DeepCopyInto(out *IstioRbacV1Alpha1Serviceroles) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1Serviceroles.
func (in *IstioRbacV1Alpha1Serviceroles) DeepCopy() *IstioRbacV1Alpha1Serviceroles {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1Serviceroles)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1Serviceroles) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioRbacV1Alpha1ServicerolesList) DeepCopyInto(out *IstioRbacV1Alpha1ServicerolesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioRbacV1Alpha1Serviceroles, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioRbacV1Alpha1ServicerolesList.
func (in *IstioRbacV1Alpha1ServicerolesList) DeepCopy() *IstioRbacV1Alpha1ServicerolesList {
	if in == nil {
		return nil
	}
	out := new(IstioRbacV1Alpha1ServicerolesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioRbacV1Alpha1ServicerolesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioSecurityV1Beta1Authorizationpolicies is the generic Kubernetes API Object wrapper
type IstioSecurityV1Beta1Authorizationpolicies struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioSecurityV1Beta1Authorizationpolicies) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioSecurityV1Beta1Authorizationpolicies) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioSecurityV1Beta1Authorizationpolicies) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioSecurityV1Beta1Authorizationpolicies) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioSecurityV1Beta1AuthorizationpoliciesList is the generic Kubernetes API list wrapper
type IstioSecurityV1Beta1AuthorizationpoliciesList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioSecurityV1Beta1Authorizationpolicies `json:"items"`
}

// GetItems from a wrapper
func (in *IstioSecurityV1Beta1AuthorizationpoliciesList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1Authorizationpolicies) DeepCopyInto(out *IstioSecurityV1Beta1Authorizationpolicies) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1Authorizationpolicies.
func (in *IstioSecurityV1Beta1Authorizationpolicies) DeepCopy() *IstioSecurityV1Beta1Authorizationpolicies {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1Authorizationpolicies)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1Authorizationpolicies) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1AuthorizationpoliciesList) DeepCopyInto(out *IstioSecurityV1Beta1AuthorizationpoliciesList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioSecurityV1Beta1Authorizationpolicies, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1AuthorizationpoliciesList.
func (in *IstioSecurityV1Beta1AuthorizationpoliciesList) DeepCopy() *IstioSecurityV1Beta1AuthorizationpoliciesList {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1AuthorizationpoliciesList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1AuthorizationpoliciesList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioSecurityV1Beta1Peerauthentications is the generic Kubernetes API Object wrapper
type IstioSecurityV1Beta1Peerauthentications struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioSecurityV1Beta1Peerauthentications) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioSecurityV1Beta1Peerauthentications) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioSecurityV1Beta1Peerauthentications) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioSecurityV1Beta1Peerauthentications) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioSecurityV1Beta1PeerauthenticationsList is the generic Kubernetes API list wrapper
type IstioSecurityV1Beta1PeerauthenticationsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioSecurityV1Beta1Peerauthentications `json:"items"`
}

// GetItems from a wrapper
func (in *IstioSecurityV1Beta1PeerauthenticationsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1Peerauthentications) DeepCopyInto(out *IstioSecurityV1Beta1Peerauthentications) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1Peerauthentications.
func (in *IstioSecurityV1Beta1Peerauthentications) DeepCopy() *IstioSecurityV1Beta1Peerauthentications {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1Peerauthentications)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1Peerauthentications) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1PeerauthenticationsList) DeepCopyInto(out *IstioSecurityV1Beta1PeerauthenticationsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioSecurityV1Beta1Peerauthentications, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1PeerauthenticationsList.
func (in *IstioSecurityV1Beta1PeerauthenticationsList) DeepCopy() *IstioSecurityV1Beta1PeerauthenticationsList {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1PeerauthenticationsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1PeerauthenticationsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// IstioSecurityV1Beta1Requestauthentications is the generic Kubernetes API Object wrapper
type IstioSecurityV1Beta1Requestauthentications struct {
	metav1.TypeMeta   `json:",inline"`
	metav1.ObjectMeta `json:"metadata"`
	Spec              map[string]interface{} `json:"spec"`
}

// GetSpec from a wrapper
func (in *IstioSecurityV1Beta1Requestauthentications) GetSpec() map[string]interface{} {
	return in.Spec
}

// SetSpec for a wrapper
func (in *IstioSecurityV1Beta1Requestauthentications) SetSpec(spec map[string]interface{}) {
	in.Spec = spec
}

// GetObjectMeta from a wrapper
func (in *IstioSecurityV1Beta1Requestauthentications) GetObjectMeta() metav1.ObjectMeta {
	return in.ObjectMeta
}

// SetObjectMeta for a wrapper
func (in *IstioSecurityV1Beta1Requestauthentications) SetObjectMeta(metadata metav1.ObjectMeta) {
	in.ObjectMeta = metadata
}

// IstioSecurityV1Beta1RequestauthenticationsList is the generic Kubernetes API list wrapper
type IstioSecurityV1Beta1RequestauthenticationsList struct {
	metav1.TypeMeta `json:",inline"`
	metav1.ListMeta `json:"metadata"`
	Items           []IstioSecurityV1Beta1Requestauthentications `json:"items"`
}

// GetItems from a wrapper
func (in *IstioSecurityV1Beta1RequestauthenticationsList) GetItems() []IstioObject {
	out := make([]IstioObject, len(in.Items))
	for i := range in.Items {
		out[i] = &in.Items[i]
	}
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1Requestauthentications) DeepCopyInto(out *IstioSecurityV1Beta1Requestauthentications) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1Requestauthentications.
func (in *IstioSecurityV1Beta1Requestauthentications) DeepCopy() *IstioSecurityV1Beta1Requestauthentications {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1Requestauthentications)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1Requestauthentications) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IstioSecurityV1Beta1RequestauthenticationsList) DeepCopyInto(out *IstioSecurityV1Beta1RequestauthenticationsList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]IstioSecurityV1Beta1Requestauthentications, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IstioSecurityV1Beta1RequestauthenticationsList.
func (in *IstioSecurityV1Beta1RequestauthenticationsList) DeepCopy() *IstioSecurityV1Beta1RequestauthenticationsList {
	if in == nil {
		return nil
	}
	out := new(IstioSecurityV1Beta1RequestauthenticationsList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *IstioSecurityV1Beta1RequestauthenticationsList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}

	return nil
}
