// Code generated by protoc-gen-go. DO NOT EDIT.
// source: pkg/apis/istio/v1alpha2/istiocontrolplane_types.proto

// IstioControlPlane is a schema for both defining and customizing Istio control plane installations.
// Running the operator with an empty user defined InstallSpec results in an control plane with default values, using the
// default charts.
//
// The simplest install specialization is to point the user InstallSpec profile to a different values file, for
// example an Istio minimal control plane, which will use the values associated with the minimal control plane profile for
// Istio.
//
// Deeper customization is possible at three levels:
//
// 1. New APIs defined in this file
//
//     Feature API: this API groups an Istio install by features and allows enabling/disabling the features, selecting base
//     control plane profiles, as well as some additional high level settings that are feature specific. Each feature contains
//     one or more components, which correspond to Istio components (Pods) in the cluster.
//
//     k8s API: this API is a pass through to k8s resource settings for Istio k8s resources. It allows customizing Istio k8s
//     resources like Affinity, Resource requests/limits, PodDisruptionBudgetSpec, Selectors etc. in a more consistent and
//     k8s specific way compared to values.yaml. See KubernetesResourcesSpec in this file for details.
//
// 1. values.yaml
//
//     The entirety of values.yaml settings is accessible through InstallSpec (see CommonComponentSpec/Values).
//     This API will gradually be deprecated and values there will be moved either into CRDs that are used to directly
//     configure components or, in the case of k8s settings, will be replaced by the new API above.
//
// 1. k8s resource overlays
//
//     Once a manifest is rendered from InstallSpec, a further customization can be applied by specifying k8s resource
//     overlays. The concept is similar to kustomize, where JSON patches are applied for object paths. This allows
//     customization at the lowest level and eliminates the need to create ad-hoc template parameters, or edit templates.
//
// Here are a few example uses:
//
// 1. Default Istio install
//
//     ```
//     spec:
//     ```
//
// 1. Default minimal profile install
//
//     ```
//     spec:
//       profile: minimal
//     ```
//
// 1. Default install with telemetry disabled
//
//     ```
//     spec:
//       telemetry:
//         enabled: false
//     ```
//
// 1. Default install with each feature installed to different namespace and security components in separate namespaces
//
//     ```
//     spec:
//       traffic_management:
//         components:
//           namespace: istio-traffic-management
//       policy:
//         components:
//           namespace: istio-policy
//       telemetry:
//         components:
//           namespace: istio-telemetry
//       config_management:
//         components:
//           namespace: istio-config-management
//       security:
//         components:
//           citadel:
//             namespace: istio-citadel
//           cert_manager:
//             namespace: istio-cert-manager
//           node_agent:
//             namespace: istio-node-agent
//     ```
//
// 1. Default install with specialized k8s settings for pilot
//
//     ```
//     spec:
//       traffic_management:
//         components:
//           pilot:
//             k8s:
//               resources:
//                 limits:
//                   cpu: 444m
//                   memory: 333Mi
//                 requests:
//                   cpu: 222m
//                   memory: 111Mi
//               readinessProbe:
//                 failureThreshold: 44
//                 initialDelaySeconds: 11
//                 periodSeconds: 22
//                 successThreshold: 33
//     ```
//
// 1. Default install with values.yaml customizations for proxy
//
//     ```
//     spec:
//       traffic_management:
//         components:
//           proxy:
//             values:
//             - global.proxy.enableCoreDump: true
//             - global.proxy.dnsRefreshRate: 10s
//     ```
//
// 1. Default install with modification to container flag in galley
//
//     ```
//     spec:
//       configuration_management:
//         components:
//           galley:
//             k8s:
//               overlays:
//               - apiVersion: extensions/v1beta1
//                 kind: Deployment
//                 name: istio-galley
//                 patches:
//                 - path: spec.template.spec.containers.[name:galley].command.[--livenessProbeInterval]
//                   value: --livenessProbeInterval=123s
//     ```

package v1alpha2

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	v2beta1 "k8s.io/api/autoscaling/v2beta1"
	v1 "k8s.io/api/core/v1"
	v11 "k8s.io/apimachinery/pkg/apis/meta/v1"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type InstallStatus_Status int32

const (
	InstallStatus_NONE        InstallStatus_Status = 0
	InstallStatus_UPDATING    InstallStatus_Status = 1
	InstallStatus_HEALTHY     InstallStatus_Status = 2
	InstallStatus_ERROR       InstallStatus_Status = 3
	InstallStatus_RECONCILING InstallStatus_Status = 4
)

var InstallStatus_Status_name = map[int32]string{
	0: "NONE",
	1: "UPDATING",
	2: "HEALTHY",
	3: "ERROR",
	4: "RECONCILING",
}

var InstallStatus_Status_value = map[string]int32{
	"NONE":        0,
	"UPDATING":    1,
	"HEALTHY":     2,
	"ERROR":       3,
	"RECONCILING": 4,
}

func (x InstallStatus_Status) String() string {
	return proto.EnumName(InstallStatus_Status_name, int32(x))
}

func (InstallStatus_Status) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{28, 0}
}

// IstioControlPlane is a CustomResourceDefinition (CRD) describing an Istio control plane.
type IstioControlPlane struct {
	// Spec defines the desired state of IstioControlPlane.
	Spec *IstioControlPlaneSpec `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	// Status reports the status of the Istio control plane.
	Status     *InstallStatus `protobuf:"bytes,4,opt,name=status,proto3" json:"status,omitempty"`
	Kind       string         `protobuf:"bytes,5,opt,name=kind,proto3" json:"kind,omitempty"`
	ApiVersion string         `protobuf:"bytes,6,opt,name=apiVersion,proto3" json:"apiVersion,omitempty"`
	v11.ObjectMeta `json:"metadata,omitempty" protobuf:"bytes,7,opt,name=metadata"`
	v11.TypeMeta `json:",inline"`
	Placeholder          string   `protobuf:"bytes,111,opt,name=placeholder,proto3" json:"placeholder,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IstioControlPlane) Reset()         { *m = IstioControlPlane{} }
func (m *IstioControlPlane) String() string { return proto.CompactTextString(m) }
func (*IstioControlPlane) ProtoMessage()    {}
func (*IstioControlPlane) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{0}
}

func (m *IstioControlPlane) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioControlPlane.Unmarshal(m, b)
}
func (m *IstioControlPlane) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioControlPlane.Marshal(b, m, deterministic)
}
func (m *IstioControlPlane) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioControlPlane.Merge(m, src)
}
func (m *IstioControlPlane) XXX_Size() int {
	return xxx_messageInfo_IstioControlPlane.Size(m)
}
func (m *IstioControlPlane) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioControlPlane.DiscardUnknown(m)
}

var xxx_messageInfo_IstioControlPlane proto.InternalMessageInfo

func (m *IstioControlPlane) GetSpec() *IstioControlPlaneSpec {
	if m != nil {
		return m.Spec
	}
	return nil
}

func (m *IstioControlPlane) GetStatus() *InstallStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *IstioControlPlane) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *IstioControlPlane) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *IstioControlPlane) GetPlaceholder() string {
	if m != nil {
		return m.Placeholder
	}
	return ""
}

// IstioControlPlaneSpec defines the desired state of IstioControlPlane.
// The spec is a used to define a customization of the default profile values that are supplied with each Istio release.
// It is grouped at the top level by feature, where behavior of Istio functional areas is specified.
// Each feature contains components, where k8s resource level defaults can be overridden.
// Because the spec is a customization API, specifying an empty InstallSpec results in a default Istio control plane.
type IstioControlPlaneSpec struct {
	// Default namespace if feature or component namespaces are not set.
	DefaultNamespace string `protobuf:"bytes,5,opt,name=default_namespace,json=defaultNamespace,proto3" json:"default_namespace,omitempty"`
	// Base feature containing resources like CRDs, namespaces etc.
	Base *BaseFeatureSpec `protobuf:"bytes,20,opt,name=base,proto3" json:"base,omitempty"`
	// Selection and configuration of core Istio features.
	TrafficManagement *TrafficManagementFeatureSpec `protobuf:"bytes,25,opt,name=traffic_management,json=trafficManagement,proto3" json:"traffic_management,omitempty"`
	Policy            *PolicyFeatureSpec            `protobuf:"bytes,26,opt,name=policy,proto3" json:"policy,omitempty"`
	Telemetry         *TelemetryFeatureSpec         `protobuf:"bytes,27,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	Security          *SecurityFeatureSpec          `protobuf:"bytes,28,opt,name=security,proto3" json:"security,omitempty"`
	ConfigManagement  *ConfigManagementFeatureSpec  `protobuf:"bytes,29,opt,name=config_management,json=configManagement,proto3" json:"config_management,omitempty"`
	AutoInjection     *AutoInjectionFeatureSpec     `protobuf:"bytes,30,opt,name=auto_injection,json=autoInjection,proto3" json:"auto_injection,omitempty"`
	Gateways          *GatewayFeatureSpec           `protobuf:"bytes,31,opt,name=gateways,proto3" json:"gateways,omitempty"`
	Cni               *CNIFeatureSpec               `protobuf:"bytes,32,opt,name=cni,proto3" json:"cni,omitempty"`
	CoreDNS           *CoreDNSFeatureSpec           `protobuf:"bytes,33,opt,name=coreDNS,proto3" json:"coreDNS,omitempty"`
	// Overrides for default global values.yaml.
	Values map[string]interface{} `protobuf:"bytes,50,opt,name=values,proto3" json:"values,omitempty"`
	// Unvalidated overrides for default global values.yaml.
	UnvalidatedValues map[string]interface{} `protobuf:"bytes,51,opt,name=unvalidatedValues,proto3" json:"unvalidatedValues,omitempty"`
	// Path or name for the profile e.g.
	//     - minimal (looks in profiles dir for a file called minimal.yaml)
	//     - /tmp/istio/install/values/custom/custom-install.yaml (local file path)
	// default profile is used if this field is unset.
	Profile string `protobuf:"bytes,100,opt,name=profile,proto3" json:"profile,omitempty"`
	// Path for the install package. e.g.
	//     - /tmp/istio-installer/nightly (local file path)
	InstallPackagePath string `protobuf:"bytes,102,opt,name=install_package_path,json=installPackagePath,proto3" json:"install_package_path,omitempty"`
	// Root for docker image paths e.g. docker.io/istio-release.
	// Releases are published to docker hub under 'istio' project.
	// Daily builds from prow are on gcr.io, and nightly builds from circle on docker.io/istionightly
	Hub string `protobuf:"bytes,110,opt,name=hub,proto3" json:"hub,omitempty"`
	// Version tag for docker images e.g. 1.0.6
	Tag                  string   `protobuf:"bytes,111,opt,name=tag,proto3" json:"tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IstioControlPlaneSpec) Reset()         { *m = IstioControlPlaneSpec{} }
func (m *IstioControlPlaneSpec) String() string { return proto.CompactTextString(m) }
func (*IstioControlPlaneSpec) ProtoMessage()    {}
func (*IstioControlPlaneSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{1}
}

func (m *IstioControlPlaneSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IstioControlPlaneSpec.Unmarshal(m, b)
}
func (m *IstioControlPlaneSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IstioControlPlaneSpec.Marshal(b, m, deterministic)
}
func (m *IstioControlPlaneSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IstioControlPlaneSpec.Merge(m, src)
}
func (m *IstioControlPlaneSpec) XXX_Size() int {
	return xxx_messageInfo_IstioControlPlaneSpec.Size(m)
}
func (m *IstioControlPlaneSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IstioControlPlaneSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IstioControlPlaneSpec proto.InternalMessageInfo

func (m *IstioControlPlaneSpec) GetDefaultNamespace() string {
	if m != nil {
		return m.DefaultNamespace
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetBase() *BaseFeatureSpec {
	if m != nil {
		return m.Base
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetTrafficManagement() *TrafficManagementFeatureSpec {
	if m != nil {
		return m.TrafficManagement
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetPolicy() *PolicyFeatureSpec {
	if m != nil {
		return m.Policy
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetTelemetry() *TelemetryFeatureSpec {
	if m != nil {
		return m.Telemetry
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetSecurity() *SecurityFeatureSpec {
	if m != nil {
		return m.Security
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetConfigManagement() *ConfigManagementFeatureSpec {
	if m != nil {
		return m.ConfigManagement
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetAutoInjection() *AutoInjectionFeatureSpec {
	if m != nil {
		return m.AutoInjection
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetGateways() *GatewayFeatureSpec {
	if m != nil {
		return m.Gateways
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetCni() *CNIFeatureSpec {
	if m != nil {
		return m.Cni
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetCoreDNS() *CoreDNSFeatureSpec {
	if m != nil {
		return m.CoreDNS
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetValues() map[string]interface{} {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetUnvalidatedValues() map[string]interface{} {
	if m != nil {
		return m.UnvalidatedValues
	}
	return nil
}

func (m *IstioControlPlaneSpec) GetProfile() string {
	if m != nil {
		return m.Profile
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetInstallPackagePath() string {
	if m != nil {
		return m.InstallPackagePath
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetHub() string {
	if m != nil {
		return m.Hub
	}
	return ""
}

func (m *IstioControlPlaneSpec) GetTag() string {
	if m != nil {
		return m.Tag
	}
	return ""
}

// Base feature settings.
type BaseFeatureSpec struct {
	// Selects whether base feature is installed. Required for all Istio installs.
	// Should only be disabled when generating partial Istio installation YAMLs.
	Enabled              *BoolValueForPB         `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *BaseFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *BaseFeatureSpec) Reset()         { *m = BaseFeatureSpec{} }
func (m *BaseFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*BaseFeatureSpec) ProtoMessage()    {}
func (*BaseFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{2}
}

func (m *BaseFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BaseFeatureSpec.Unmarshal(m, b)
}
func (m *BaseFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BaseFeatureSpec.Marshal(b, m, deterministic)
}
func (m *BaseFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseFeatureSpec.Merge(m, src)
}
func (m *BaseFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_BaseFeatureSpec.Size(m)
}
func (m *BaseFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BaseFeatureSpec proto.InternalMessageInfo

func (m *BaseFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *BaseFeatureSpec) GetComponents() *BaseFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type BaseFeatureSpec_Components struct {
	Base                 *BaseComponentSpec `protobuf:"bytes,20,opt,name=base,proto3" json:"base,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *BaseFeatureSpec_Components) Reset()         { *m = BaseFeatureSpec_Components{} }
func (m *BaseFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*BaseFeatureSpec_Components) ProtoMessage()    {}
func (*BaseFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{2, 0}
}

func (m *BaseFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BaseFeatureSpec_Components.Unmarshal(m, b)
}
func (m *BaseFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BaseFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *BaseFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseFeatureSpec_Components.Merge(m, src)
}
func (m *BaseFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_BaseFeatureSpec_Components.Size(m)
}
func (m *BaseFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_BaseFeatureSpec_Components proto.InternalMessageInfo

func (m *BaseFeatureSpec_Components) GetBase() *BaseComponentSpec {
	if m != nil {
		return m.Base
	}
	return nil
}

// Configuration options for traffic management.
type TrafficManagementFeatureSpec struct {
	// Selects whether traffic management is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *BoolValueForPB                      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *TrafficManagementFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *TrafficManagementFeatureSpec) Reset()         { *m = TrafficManagementFeatureSpec{} }
func (m *TrafficManagementFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*TrafficManagementFeatureSpec) ProtoMessage()    {}
func (*TrafficManagementFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{3}
}

func (m *TrafficManagementFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Unmarshal(m, b)
}
func (m *TrafficManagementFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Marshal(b, m, deterministic)
}
func (m *TrafficManagementFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficManagementFeatureSpec.Merge(m, src)
}
func (m *TrafficManagementFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_TrafficManagementFeatureSpec.Size(m)
}
func (m *TrafficManagementFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficManagementFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficManagementFeatureSpec proto.InternalMessageInfo

func (m *TrafficManagementFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TrafficManagementFeatureSpec) GetComponents() *TrafficManagementFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type TrafficManagementFeatureSpec_Components struct {
	// Namespace that all traffic management components are installed into.
	Namespace            string              `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Pilot                *PilotComponentSpec `protobuf:"bytes,20,opt,name=pilot,proto3" json:"pilot,omitempty"`
	Proxy                *ProxyComponentSpec `protobuf:"bytes,21,opt,name=proxy,proto3" json:"proxy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *TrafficManagementFeatureSpec_Components) Reset() {
	*m = TrafficManagementFeatureSpec_Components{}
}
func (m *TrafficManagementFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*TrafficManagementFeatureSpec_Components) ProtoMessage()    {}
func (*TrafficManagementFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{3, 0}
}

func (m *TrafficManagementFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Unmarshal(m, b)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TrafficManagementFeatureSpec_Components.Merge(m, src)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_TrafficManagementFeatureSpec_Components.Size(m)
}
func (m *TrafficManagementFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_TrafficManagementFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_TrafficManagementFeatureSpec_Components proto.InternalMessageInfo

func (m *TrafficManagementFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TrafficManagementFeatureSpec_Components) GetPilot() *PilotComponentSpec {
	if m != nil {
		return m.Pilot
	}
	return nil
}

func (m *TrafficManagementFeatureSpec_Components) GetProxy() *ProxyComponentSpec {
	if m != nil {
		return m.Proxy
	}
	return nil
}

// Configuration options for the policy feature.
type PolicyFeatureSpec struct {
	// Selects whether policy is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *BoolValueForPB           `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *PolicyFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *PolicyFeatureSpec) Reset()         { *m = PolicyFeatureSpec{} }
func (m *PolicyFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*PolicyFeatureSpec) ProtoMessage()    {}
func (*PolicyFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{4}
}

func (m *PolicyFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyFeatureSpec.Unmarshal(m, b)
}
func (m *PolicyFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyFeatureSpec.Marshal(b, m, deterministic)
}
func (m *PolicyFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyFeatureSpec.Merge(m, src)
}
func (m *PolicyFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_PolicyFeatureSpec.Size(m)
}
func (m *PolicyFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyFeatureSpec proto.InternalMessageInfo

func (m *PolicyFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PolicyFeatureSpec) GetComponents() *PolicyFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type PolicyFeatureSpec_Components struct {
	// Namespace that all policy components are installed into.
	Namespace            string               `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Policy               *PolicyComponentSpec `protobuf:"bytes,20,opt,name=policy,proto3" json:"policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *PolicyFeatureSpec_Components) Reset()         { *m = PolicyFeatureSpec_Components{} }
func (m *PolicyFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*PolicyFeatureSpec_Components) ProtoMessage()    {}
func (*PolicyFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{4, 0}
}

func (m *PolicyFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Unmarshal(m, b)
}
func (m *PolicyFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *PolicyFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyFeatureSpec_Components.Merge(m, src)
}
func (m *PolicyFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_PolicyFeatureSpec_Components.Size(m)
}
func (m *PolicyFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyFeatureSpec_Components proto.InternalMessageInfo

func (m *PolicyFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PolicyFeatureSpec_Components) GetPolicy() *PolicyComponentSpec {
	if m != nil {
		return m.Policy
	}
	return nil
}

// Configuration options for the telemetry feature.
type TelemetryFeatureSpec struct {
	// Selects whether telemetry is installed.
	// Must be enabled to enable any sub-component.
	Enabled              *BoolValueForPB              `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *TelemetryFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *TelemetryFeatureSpec) Reset()         { *m = TelemetryFeatureSpec{} }
func (m *TelemetryFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*TelemetryFeatureSpec) ProtoMessage()    {}
func (*TelemetryFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{5}
}

func (m *TelemetryFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryFeatureSpec.Unmarshal(m, b)
}
func (m *TelemetryFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryFeatureSpec.Marshal(b, m, deterministic)
}
func (m *TelemetryFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryFeatureSpec.Merge(m, src)
}
func (m *TelemetryFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_TelemetryFeatureSpec.Size(m)
}
func (m *TelemetryFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryFeatureSpec proto.InternalMessageInfo

func (m *TelemetryFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TelemetryFeatureSpec) GetComponents() *TelemetryFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

// Component specific config.
type TelemetryFeatureSpec_Components struct {
	// Namespace that all telemetry components are installed into.
	Namespace            string                  `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Telemetry            *TelemetryComponentSpec `protobuf:"bytes,20,opt,name=telemetry,proto3" json:"telemetry,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *TelemetryFeatureSpec_Components) Reset()         { *m = TelemetryFeatureSpec_Components{} }
func (m *TelemetryFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*TelemetryFeatureSpec_Components) ProtoMessage()    {}
func (*TelemetryFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{5, 0}
}

func (m *TelemetryFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Unmarshal(m, b)
}
func (m *TelemetryFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *TelemetryFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryFeatureSpec_Components.Merge(m, src)
}
func (m *TelemetryFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_TelemetryFeatureSpec_Components.Size(m)
}
func (m *TelemetryFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryFeatureSpec_Components proto.InternalMessageInfo

func (m *TelemetryFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TelemetryFeatureSpec_Components) GetTelemetry() *TelemetryComponentSpec {
	if m != nil {
		return m.Telemetry
	}
	return nil
}

// Configuration options for security feature.
type SecurityFeatureSpec struct {
	// Selects whether security feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB             `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *SecurityFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SecurityFeatureSpec) Reset()         { *m = SecurityFeatureSpec{} }
func (m *SecurityFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*SecurityFeatureSpec) ProtoMessage()    {}
func (*SecurityFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{6}
}

func (m *SecurityFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityFeatureSpec.Unmarshal(m, b)
}
func (m *SecurityFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityFeatureSpec.Marshal(b, m, deterministic)
}
func (m *SecurityFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityFeatureSpec.Merge(m, src)
}
func (m *SecurityFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_SecurityFeatureSpec.Size(m)
}
func (m *SecurityFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityFeatureSpec proto.InternalMessageInfo

func (m *SecurityFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *SecurityFeatureSpec) GetComponents() *SecurityFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type SecurityFeatureSpec_Components struct {
	// Namespace that security components are installed into.
	Namespace            string                    `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Citadel              *CitadelComponentSpec     `protobuf:"bytes,20,opt,name=citadel,proto3" json:"citadel,omitempty"`
	CertManager          *CertManagerComponentSpec `protobuf:"bytes,21,opt,name=cert_manager,json=certManager,proto3" json:"cert_manager,omitempty"`
	NodeAgent            *NodeAgentComponentSpec   `protobuf:"bytes,22,opt,name=node_agent,json=nodeAgent,proto3" json:"node_agent,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *SecurityFeatureSpec_Components) Reset()         { *m = SecurityFeatureSpec_Components{} }
func (m *SecurityFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*SecurityFeatureSpec_Components) ProtoMessage()    {}
func (*SecurityFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{6, 0}
}

func (m *SecurityFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Unmarshal(m, b)
}
func (m *SecurityFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *SecurityFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityFeatureSpec_Components.Merge(m, src)
}
func (m *SecurityFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_SecurityFeatureSpec_Components.Size(m)
}
func (m *SecurityFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityFeatureSpec_Components proto.InternalMessageInfo

func (m *SecurityFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SecurityFeatureSpec_Components) GetCitadel() *CitadelComponentSpec {
	if m != nil {
		return m.Citadel
	}
	return nil
}

func (m *SecurityFeatureSpec_Components) GetCertManager() *CertManagerComponentSpec {
	if m != nil {
		return m.CertManager
	}
	return nil
}

func (m *SecurityFeatureSpec_Components) GetNodeAgent() *NodeAgentComponentSpec {
	if m != nil {
		return m.NodeAgent
	}
	return nil
}

// Configuration options for configuration management feature.
type ConfigManagementFeatureSpec struct {
	// Selects whether config management feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB                     `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *ConfigManagementFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *ConfigManagementFeatureSpec) Reset()         { *m = ConfigManagementFeatureSpec{} }
func (m *ConfigManagementFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*ConfigManagementFeatureSpec) ProtoMessage()    {}
func (*ConfigManagementFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{7}
}

func (m *ConfigManagementFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Unmarshal(m, b)
}
func (m *ConfigManagementFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Marshal(b, m, deterministic)
}
func (m *ConfigManagementFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigManagementFeatureSpec.Merge(m, src)
}
func (m *ConfigManagementFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_ConfigManagementFeatureSpec.Size(m)
}
func (m *ConfigManagementFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigManagementFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigManagementFeatureSpec proto.InternalMessageInfo

func (m *ConfigManagementFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *ConfigManagementFeatureSpec) GetComponents() *ConfigManagementFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type ConfigManagementFeatureSpec_Components struct {
	// Namespace that security components are installed into.
	Namespace            string               `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Galley               *GalleyComponentSpec `protobuf:"bytes,20,opt,name=galley,proto3" json:"galley,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ConfigManagementFeatureSpec_Components) Reset() {
	*m = ConfigManagementFeatureSpec_Components{}
}
func (m *ConfigManagementFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*ConfigManagementFeatureSpec_Components) ProtoMessage()    {}
func (*ConfigManagementFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{7, 0}
}

func (m *ConfigManagementFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Unmarshal(m, b)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigManagementFeatureSpec_Components.Merge(m, src)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_ConfigManagementFeatureSpec_Components.Size(m)
}
func (m *ConfigManagementFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigManagementFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigManagementFeatureSpec_Components proto.InternalMessageInfo

func (m *ConfigManagementFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ConfigManagementFeatureSpec_Components) GetGalley() *GalleyComponentSpec {
	if m != nil {
		return m.Galley
	}
	return nil
}

// Configuration options for auto injection feature.
type AutoInjectionFeatureSpec struct {
	// Selects whether auto injection feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB                  `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *AutoInjectionFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *AutoInjectionFeatureSpec) Reset()         { *m = AutoInjectionFeatureSpec{} }
func (m *AutoInjectionFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*AutoInjectionFeatureSpec) ProtoMessage()    {}
func (*AutoInjectionFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{8}
}

func (m *AutoInjectionFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Unmarshal(m, b)
}
func (m *AutoInjectionFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Marshal(b, m, deterministic)
}
func (m *AutoInjectionFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoInjectionFeatureSpec.Merge(m, src)
}
func (m *AutoInjectionFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_AutoInjectionFeatureSpec.Size(m)
}
func (m *AutoInjectionFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoInjectionFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_AutoInjectionFeatureSpec proto.InternalMessageInfo

func (m *AutoInjectionFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *AutoInjectionFeatureSpec) GetComponents() *AutoInjectionFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type AutoInjectionFeatureSpec_Components struct {
	// Namespace that auto injections components are installed into.
	Namespace            string                        `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Injector             *SidecarInjectorComponentSpec `protobuf:"bytes,20,opt,name=injector,proto3" json:"injector,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *AutoInjectionFeatureSpec_Components) Reset()         { *m = AutoInjectionFeatureSpec_Components{} }
func (m *AutoInjectionFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*AutoInjectionFeatureSpec_Components) ProtoMessage()    {}
func (*AutoInjectionFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{8, 0}
}

func (m *AutoInjectionFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Unmarshal(m, b)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutoInjectionFeatureSpec_Components.Merge(m, src)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_AutoInjectionFeatureSpec_Components.Size(m)
}
func (m *AutoInjectionFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_AutoInjectionFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_AutoInjectionFeatureSpec_Components proto.InternalMessageInfo

func (m *AutoInjectionFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *AutoInjectionFeatureSpec_Components) GetInjector() *SidecarInjectorComponentSpec {
	if m != nil {
		return m.Injector
	}
	return nil
}

// Configuration options for gateway feature.
type GatewayFeatureSpec struct {
	// Selects whether gateway feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB            `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *GatewayFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *GatewayFeatureSpec) Reset()         { *m = GatewayFeatureSpec{} }
func (m *GatewayFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*GatewayFeatureSpec) ProtoMessage()    {}
func (*GatewayFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{9}
}

func (m *GatewayFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayFeatureSpec.Unmarshal(m, b)
}
func (m *GatewayFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayFeatureSpec.Marshal(b, m, deterministic)
}
func (m *GatewayFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayFeatureSpec.Merge(m, src)
}
func (m *GatewayFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_GatewayFeatureSpec.Size(m)
}
func (m *GatewayFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayFeatureSpec proto.InternalMessageInfo

func (m *GatewayFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *GatewayFeatureSpec) GetComponents() *GatewayFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type GatewayFeatureSpec_Components struct {
	// Namespace that auto injections components are installed into.
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Ingress/egress gateway configuration.
	IngressGateway       *IngressGatewayComponentSpec `protobuf:"bytes,31,opt,name=ingress_gateway,json=ingressGateway,proto3" json:"ingress_gateway,omitempty"`
	EgressGateway        *EgressGatewayComponentSpec  `protobuf:"bytes,32,opt,name=egress_gateway,json=egressGateway,proto3" json:"egress_gateway,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *GatewayFeatureSpec_Components) Reset()         { *m = GatewayFeatureSpec_Components{} }
func (m *GatewayFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*GatewayFeatureSpec_Components) ProtoMessage()    {}
func (*GatewayFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{9, 0}
}

func (m *GatewayFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Unmarshal(m, b)
}
func (m *GatewayFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *GatewayFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GatewayFeatureSpec_Components.Merge(m, src)
}
func (m *GatewayFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_GatewayFeatureSpec_Components.Size(m)
}
func (m *GatewayFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_GatewayFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_GatewayFeatureSpec_Components proto.InternalMessageInfo

func (m *GatewayFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GatewayFeatureSpec_Components) GetIngressGateway() *IngressGatewayComponentSpec {
	if m != nil {
		return m.IngressGateway
	}
	return nil
}

func (m *GatewayFeatureSpec_Components) GetEgressGateway() *EgressGatewayComponentSpec {
	if m != nil {
		return m.EgressGateway
	}
	return nil
}

// Configuration options for cni feature.
type CNIFeatureSpec struct {
	// Selects whether CNI feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB        `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *CNIFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *CNIFeatureSpec) Reset()         { *m = CNIFeatureSpec{} }
func (m *CNIFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*CNIFeatureSpec) ProtoMessage()    {}
func (*CNIFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{10}
}

func (m *CNIFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CNIFeatureSpec.Unmarshal(m, b)
}
func (m *CNIFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CNIFeatureSpec.Marshal(b, m, deterministic)
}
func (m *CNIFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CNIFeatureSpec.Merge(m, src)
}
func (m *CNIFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_CNIFeatureSpec.Size(m)
}
func (m *CNIFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CNIFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CNIFeatureSpec proto.InternalMessageInfo

func (m *CNIFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CNIFeatureSpec) GetComponents() *CNIFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type CNIFeatureSpec_Components struct {
	// Namespace that cni components are installed into.
	Namespace            string            `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	Cni                  *CNIComponentSpec `protobuf:"bytes,20,opt,name=cni,proto3" json:"cni,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *CNIFeatureSpec_Components) Reset()         { *m = CNIFeatureSpec_Components{} }
func (m *CNIFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*CNIFeatureSpec_Components) ProtoMessage()    {}
func (*CNIFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{10, 0}
}

func (m *CNIFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CNIFeatureSpec_Components.Unmarshal(m, b)
}
func (m *CNIFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CNIFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *CNIFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CNIFeatureSpec_Components.Merge(m, src)
}
func (m *CNIFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_CNIFeatureSpec_Components.Size(m)
}
func (m *CNIFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_CNIFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_CNIFeatureSpec_Components proto.InternalMessageInfo

func (m *CNIFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CNIFeatureSpec_Components) GetCni() *CNIComponentSpec {
	if m != nil {
		return m.Cni
	}
	return nil
}

// Configuration options for CoreDNS feature.
type CoreDNSFeatureSpec struct {
	// Selects whether CoreDNS feature is installed. Must be set for any sub-component to be installed.
	Enabled              *BoolValueForPB            `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Components           *CoreDNSFeatureSpec_Components `protobuf:"bytes,50,opt,name=components,proto3" json:"components,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *CoreDNSFeatureSpec) Reset()         { *m = CoreDNSFeatureSpec{} }
func (m *CoreDNSFeatureSpec) String() string { return proto.CompactTextString(m) }
func (*CoreDNSFeatureSpec) ProtoMessage()    {}
func (*CoreDNSFeatureSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{11}
}

func (m *CoreDNSFeatureSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoreDNSFeatureSpec.Unmarshal(m, b)
}
func (m *CoreDNSFeatureSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoreDNSFeatureSpec.Marshal(b, m, deterministic)
}
func (m *CoreDNSFeatureSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoreDNSFeatureSpec.Merge(m, src)
}
func (m *CoreDNSFeatureSpec) XXX_Size() int {
	return xxx_messageInfo_CoreDNSFeatureSpec.Size(m)
}
func (m *CoreDNSFeatureSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CoreDNSFeatureSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CoreDNSFeatureSpec proto.InternalMessageInfo

func (m *CoreDNSFeatureSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CoreDNSFeatureSpec) GetComponents() *CoreDNSFeatureSpec_Components {
	if m != nil {
		return m.Components
	}
	return nil
}

type CoreDNSFeatureSpec_Components struct {
	// Namespace that CoreDNS components are installed into.
	Namespace            string                `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	CoreDNS              *CoreDNSComponentSpec `protobuf:"bytes,20,opt,name=coreDNS,proto3" json:"coreDNS,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CoreDNSFeatureSpec_Components) Reset()         { *m = CoreDNSFeatureSpec_Components{} }
func (m *CoreDNSFeatureSpec_Components) String() string { return proto.CompactTextString(m) }
func (*CoreDNSFeatureSpec_Components) ProtoMessage()    {}
func (*CoreDNSFeatureSpec_Components) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{11, 0}
}

func (m *CoreDNSFeatureSpec_Components) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoreDNSFeatureSpec_Components.Unmarshal(m, b)
}
func (m *CoreDNSFeatureSpec_Components) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoreDNSFeatureSpec_Components.Marshal(b, m, deterministic)
}
func (m *CoreDNSFeatureSpec_Components) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoreDNSFeatureSpec_Components.Merge(m, src)
}
func (m *CoreDNSFeatureSpec_Components) XXX_Size() int {
	return xxx_messageInfo_CoreDNSFeatureSpec_Components.Size(m)
}
func (m *CoreDNSFeatureSpec_Components) XXX_DiscardUnknown() {
	xxx_messageInfo_CoreDNSFeatureSpec_Components.DiscardUnknown(m)
}

var xxx_messageInfo_CoreDNSFeatureSpec_Components proto.InternalMessageInfo

func (m *CoreDNSFeatureSpec_Components) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CoreDNSFeatureSpec_Components) GetCoreDNS() *CoreDNSComponentSpec {
	if m != nil {
		return m.CoreDNS
	}
	return nil
}

// Configuration options for the base component.
type BaseComponentSpec struct {
	Enabled              *BoolValueForPB `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *BaseComponentSpec) Reset()         { *m = BaseComponentSpec{} }
func (m *BaseComponentSpec) String() string { return proto.CompactTextString(m) }
func (*BaseComponentSpec) ProtoMessage()    {}
func (*BaseComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{12}
}

func (m *BaseComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BaseComponentSpec.Unmarshal(m, b)
}
func (m *BaseComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BaseComponentSpec.Marshal(b, m, deterministic)
}
func (m *BaseComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BaseComponentSpec.Merge(m, src)
}
func (m *BaseComponentSpec) XXX_Size() int {
	return xxx_messageInfo_BaseComponentSpec.Size(m)
}
func (m *BaseComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_BaseComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_BaseComponentSpec proto.InternalMessageInfo

func (m *BaseComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

// Configuration options for the pilot component.
type PilotComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PilotComponentSpec) Reset()         { *m = PilotComponentSpec{} }
func (m *PilotComponentSpec) String() string { return proto.CompactTextString(m) }
func (*PilotComponentSpec) ProtoMessage()    {}
func (*PilotComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{13}
}

func (m *PilotComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PilotComponentSpec.Unmarshal(m, b)
}
func (m *PilotComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PilotComponentSpec.Marshal(b, m, deterministic)
}
func (m *PilotComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PilotComponentSpec.Merge(m, src)
}
func (m *PilotComponentSpec) XXX_Size() int {
	return xxx_messageInfo_PilotComponentSpec.Size(m)
}
func (m *PilotComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PilotComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PilotComponentSpec proto.InternalMessageInfo

func (m *PilotComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PilotComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PilotComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the proxy.
type ProxyComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *ProxyComponentSpec) Reset()         { *m = ProxyComponentSpec{} }
func (m *ProxyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*ProxyComponentSpec) ProtoMessage()    {}
func (*ProxyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{14}
}

func (m *ProxyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ProxyComponentSpec.Unmarshal(m, b)
}
func (m *ProxyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ProxyComponentSpec.Marshal(b, m, deterministic)
}
func (m *ProxyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyComponentSpec.Merge(m, src)
}
func (m *ProxyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_ProxyComponentSpec.Size(m)
}
func (m *ProxyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyComponentSpec proto.InternalMessageInfo

func (m *ProxyComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *ProxyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *ProxyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the sidecar injector component.
type SidecarInjectorComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *SidecarInjectorComponentSpec) Reset()         { *m = SidecarInjectorComponentSpec{} }
func (m *SidecarInjectorComponentSpec) String() string { return proto.CompactTextString(m) }
func (*SidecarInjectorComponentSpec) ProtoMessage()    {}
func (*SidecarInjectorComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{15}
}

func (m *SidecarInjectorComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Unmarshal(m, b)
}
func (m *SidecarInjectorComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Marshal(b, m, deterministic)
}
func (m *SidecarInjectorComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SidecarInjectorComponentSpec.Merge(m, src)
}
func (m *SidecarInjectorComponentSpec) XXX_Size() int {
	return xxx_messageInfo_SidecarInjectorComponentSpec.Size(m)
}
func (m *SidecarInjectorComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_SidecarInjectorComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_SidecarInjectorComponentSpec proto.InternalMessageInfo

func (m *SidecarInjectorComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *SidecarInjectorComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *SidecarInjectorComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the policy enforcement component.
type PolicyComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *PolicyComponentSpec) Reset()         { *m = PolicyComponentSpec{} }
func (m *PolicyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*PolicyComponentSpec) ProtoMessage()    {}
func (*PolicyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{16}
}

func (m *PolicyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PolicyComponentSpec.Unmarshal(m, b)
}
func (m *PolicyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PolicyComponentSpec.Marshal(b, m, deterministic)
}
func (m *PolicyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PolicyComponentSpec.Merge(m, src)
}
func (m *PolicyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_PolicyComponentSpec.Size(m)
}
func (m *PolicyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PolicyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PolicyComponentSpec proto.InternalMessageInfo

func (m *PolicyComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *PolicyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *PolicyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for the telemetry component.
type TelemetryComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *TelemetryComponentSpec) Reset()         { *m = TelemetryComponentSpec{} }
func (m *TelemetryComponentSpec) String() string { return proto.CompactTextString(m) }
func (*TelemetryComponentSpec) ProtoMessage()    {}
func (*TelemetryComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{17}
}

func (m *TelemetryComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TelemetryComponentSpec.Unmarshal(m, b)
}
func (m *TelemetryComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TelemetryComponentSpec.Marshal(b, m, deterministic)
}
func (m *TelemetryComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TelemetryComponentSpec.Merge(m, src)
}
func (m *TelemetryComponentSpec) XXX_Size() int {
	return xxx_messageInfo_TelemetryComponentSpec.Size(m)
}
func (m *TelemetryComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_TelemetryComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_TelemetryComponentSpec proto.InternalMessageInfo

func (m *TelemetryComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *TelemetryComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *TelemetryComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for Citadel component.
type CitadelComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CitadelComponentSpec) Reset()         { *m = CitadelComponentSpec{} }
func (m *CitadelComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CitadelComponentSpec) ProtoMessage()    {}
func (*CitadelComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{18}
}

func (m *CitadelComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CitadelComponentSpec.Unmarshal(m, b)
}
func (m *CitadelComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CitadelComponentSpec.Marshal(b, m, deterministic)
}
func (m *CitadelComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CitadelComponentSpec.Merge(m, src)
}
func (m *CitadelComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CitadelComponentSpec.Size(m)
}
func (m *CitadelComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CitadelComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CitadelComponentSpec proto.InternalMessageInfo

func (m *CitadelComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CitadelComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CitadelComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for certificate manager component.
type CertManagerComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CertManagerComponentSpec) Reset()         { *m = CertManagerComponentSpec{} }
func (m *CertManagerComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CertManagerComponentSpec) ProtoMessage()    {}
func (*CertManagerComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{19}
}

func (m *CertManagerComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CertManagerComponentSpec.Unmarshal(m, b)
}
func (m *CertManagerComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CertManagerComponentSpec.Marshal(b, m, deterministic)
}
func (m *CertManagerComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertManagerComponentSpec.Merge(m, src)
}
func (m *CertManagerComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CertManagerComponentSpec.Size(m)
}
func (m *CertManagerComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CertManagerComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CertManagerComponentSpec proto.InternalMessageInfo

func (m *CertManagerComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CertManagerComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CertManagerComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for node agent component.
type NodeAgentComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *NodeAgentComponentSpec) Reset()         { *m = NodeAgentComponentSpec{} }
func (m *NodeAgentComponentSpec) String() string { return proto.CompactTextString(m) }
func (*NodeAgentComponentSpec) ProtoMessage()    {}
func (*NodeAgentComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{20}
}

func (m *NodeAgentComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NodeAgentComponentSpec.Unmarshal(m, b)
}
func (m *NodeAgentComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NodeAgentComponentSpec.Marshal(b, m, deterministic)
}
func (m *NodeAgentComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NodeAgentComponentSpec.Merge(m, src)
}
func (m *NodeAgentComponentSpec) XXX_Size() int {
	return xxx_messageInfo_NodeAgentComponentSpec.Size(m)
}
func (m *NodeAgentComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_NodeAgentComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_NodeAgentComponentSpec proto.InternalMessageInfo

func (m *NodeAgentComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *NodeAgentComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *NodeAgentComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for galley component.
type GalleyComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *GalleyComponentSpec) Reset()         { *m = GalleyComponentSpec{} }
func (m *GalleyComponentSpec) String() string { return proto.CompactTextString(m) }
func (*GalleyComponentSpec) ProtoMessage()    {}
func (*GalleyComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{21}
}

func (m *GalleyComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GalleyComponentSpec.Unmarshal(m, b)
}
func (m *GalleyComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GalleyComponentSpec.Marshal(b, m, deterministic)
}
func (m *GalleyComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GalleyComponentSpec.Merge(m, src)
}
func (m *GalleyComponentSpec) XXX_Size() int {
	return xxx_messageInfo_GalleyComponentSpec.Size(m)
}
func (m *GalleyComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_GalleyComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_GalleyComponentSpec proto.InternalMessageInfo

func (m *GalleyComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *GalleyComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *GalleyComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for ingress gateways.
type IngressGatewayComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *IngressGatewayComponentSpec) Reset()         { *m = IngressGatewayComponentSpec{} }
func (m *IngressGatewayComponentSpec) String() string { return proto.CompactTextString(m) }
func (*IngressGatewayComponentSpec) ProtoMessage()    {}
func (*IngressGatewayComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{22}
}

func (m *IngressGatewayComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IngressGatewayComponentSpec.Unmarshal(m, b)
}
func (m *IngressGatewayComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IngressGatewayComponentSpec.Marshal(b, m, deterministic)
}
func (m *IngressGatewayComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IngressGatewayComponentSpec.Merge(m, src)
}
func (m *IngressGatewayComponentSpec) XXX_Size() int {
	return xxx_messageInfo_IngressGatewayComponentSpec.Size(m)
}
func (m *IngressGatewayComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_IngressGatewayComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_IngressGatewayComponentSpec proto.InternalMessageInfo

func (m *IngressGatewayComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *IngressGatewayComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *IngressGatewayComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for egress gateways.
type EgressGatewayComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *EgressGatewayComponentSpec) Reset()         { *m = EgressGatewayComponentSpec{} }
func (m *EgressGatewayComponentSpec) String() string { return proto.CompactTextString(m) }
func (*EgressGatewayComponentSpec) ProtoMessage()    {}
func (*EgressGatewayComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{23}
}

func (m *EgressGatewayComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EgressGatewayComponentSpec.Unmarshal(m, b)
}
func (m *EgressGatewayComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EgressGatewayComponentSpec.Marshal(b, m, deterministic)
}
func (m *EgressGatewayComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EgressGatewayComponentSpec.Merge(m, src)
}
func (m *EgressGatewayComponentSpec) XXX_Size() int {
	return xxx_messageInfo_EgressGatewayComponentSpec.Size(m)
}
func (m *EgressGatewayComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_EgressGatewayComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_EgressGatewayComponentSpec proto.InternalMessageInfo

func (m *EgressGatewayComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *EgressGatewayComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *EgressGatewayComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for cni component.
type CNIComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CNIComponentSpec) Reset()         { *m = CNIComponentSpec{} }
func (m *CNIComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CNIComponentSpec) ProtoMessage()    {}
func (*CNIComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{24}
}

func (m *CNIComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CNIComponentSpec.Unmarshal(m, b)
}
func (m *CNIComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CNIComponentSpec.Marshal(b, m, deterministic)
}
func (m *CNIComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CNIComponentSpec.Merge(m, src)
}
func (m *CNIComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CNIComponentSpec.Size(m)
}
func (m *CNIComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CNIComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CNIComponentSpec proto.InternalMessageInfo

func (m *CNIComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CNIComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CNIComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// Configuration options for CoreDNS component.
type CoreDNSComponentSpec struct {
	Enabled              *BoolValueForPB      `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	Namespace            string                   `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	K8S                  *KubernetesResourcesSpec `protobuf:"bytes,80,opt,name=k8s,proto3" json:"k8s,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *CoreDNSComponentSpec) Reset()         { *m = CoreDNSComponentSpec{} }
func (m *CoreDNSComponentSpec) String() string { return proto.CompactTextString(m) }
func (*CoreDNSComponentSpec) ProtoMessage()    {}
func (*CoreDNSComponentSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{25}
}

func (m *CoreDNSComponentSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CoreDNSComponentSpec.Unmarshal(m, b)
}
func (m *CoreDNSComponentSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CoreDNSComponentSpec.Marshal(b, m, deterministic)
}
func (m *CoreDNSComponentSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CoreDNSComponentSpec.Merge(m, src)
}
func (m *CoreDNSComponentSpec) XXX_Size() int {
	return xxx_messageInfo_CoreDNSComponentSpec.Size(m)
}
func (m *CoreDNSComponentSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_CoreDNSComponentSpec.DiscardUnknown(m)
}

var xxx_messageInfo_CoreDNSComponentSpec proto.InternalMessageInfo

func (m *CoreDNSComponentSpec) GetEnabled() *BoolValueForPB {
	if m != nil {
		return m.Enabled
	}
	return nil
}

func (m *CoreDNSComponentSpec) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *CoreDNSComponentSpec) GetK8S() *KubernetesResourcesSpec {
	if m != nil {
		return m.K8S
	}
	return nil
}

// KubernetesResourcesConfig is a common set of k8s resource configs for components.
type KubernetesResourcesSpec struct {
	// k8s affinity.
	// https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#affinity-and-anti-affinity
	Affinity *v1.Affinity `protobuf:"bytes,1,opt,name=affinity,proto3" json:"affinity,omitempty"`
	// Deployment environment variables.
	// https://kubernetes.io/docs/tasks/inject-data-application/define-environment-variable-container/
	Env []*v1.EnvVar `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	// k8s HorizontalPodAutoscaler settings.
	// https://kubernetes.io/docs/tasks/run-application/horizontal-pod-autoscale/
	HpaSpec *v2beta1.HorizontalPodAutoscalerSpec `protobuf:"bytes,3,opt,name=hpa_spec,json=hpaSpec,proto3" json:"hpa_spec,omitempty"`
	// k8s imagePullPolicy.
	// https://kubernetes.io/docs/concepts/containers/images/
	ImagePullPolicy string `protobuf:"bytes,4,opt,name=image_pull_policy,json=imagePullPolicy,proto3" json:"image_pull_policy,omitempty"`
	// k8s nodeSelector.
	// https://kubernetes.io/docs/concepts/configuration/assign-pod-node/#nodeselector
	NodeSelector map[string]string `protobuf:"bytes,5,rep,name=node_selector,json=nodeSelector,proto3" json:"node_selector,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s PodDisruptionBudget settings.
	// https://kubernetes.io/docs/concepts/workloads/pods/disruptions/#how-disruption-budgets-work
	PodDisruptionBudget *PodDisruptionBudgetSpec `protobuf:"bytes,6,opt,name=pod_disruption_budget,json=podDisruptionBudget,proto3" json:"pod_disruption_budget,omitempty"`
	// k8s pod annotations.
	// https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/
	PodAnnotations map[string]string `protobuf:"bytes,7,rep,name=pod_annotations,json=podAnnotations,proto3" json:"pod_annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// k8s priority_class_name. Default for all resources unless overridden.
	// https://kubernetes.io/docs/concepts/configuration/pod-priority-preemption/#priorityclass
	PriorityClassName string `protobuf:"bytes,8,opt,name=priority_class_name,json=priorityClassName,proto3" json:"priority_class_name,omitempty"`
	// k8s readinessProbe settings.
	// https://kubernetes.io/docs/tasks/configure-pod-container/configure-liveness-readiness-probes/
	// k8s.io.api.core.v1.Probe readiness_probe = 9;
	ReadinessProbe *ReadinessProbe `protobuf:"bytes,9,opt,name=readiness_probe,json=readinessProbe,proto3" json:"readiness_probe,omitempty"`
	// k8s Deployment replicas setting.
	// https://kubernetes.io/docs/concepts/workloads/controllers/deployment/
	ReplicaCount uint32 `protobuf:"varint,10,opt,name=replica_count,json=replicaCount,proto3" json:"replica_count,omitempty"`
	// k8s resources settings.
	// https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/#resource-requests-and-limits-of-pod-and-container
	Resources *Resources `protobuf:"bytes,11,opt,name=resources,proto3" json:"resources,omitempty"`
	// k8s Service settings.
	// https://kubernetes.io/docs/concepts/services-networking/service/
	Service *v1.ServiceSpec `protobuf:"bytes,12,opt,name=service,proto3" json:"service,omitempty"`
	// k8s deployment strategy.
	// https://kubernetes.io/docs/concepts/workloads/controllers/deployment/
	Strategy *DeploymentStrategy `protobuf:"bytes,13,opt,name=strategy,proto3" json:"strategy,omitempty"`
	// k8s toleration
	// https://kubernetes.io/docs/concepts/configuration/taint-and-toleration/
	Tolerations []*v1.Toleration `protobuf:"bytes,14,rep,name=tolerations,proto3" json:"tolerations,omitempty"`
	// Overlays for k8s resources in rendered manifests.
	Overlays             []*K8SObjectOverlay `protobuf:"bytes,100,rep,name=overlays,proto3" json:"overlays,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *KubernetesResourcesSpec) Reset()         { *m = KubernetesResourcesSpec{} }
func (m *KubernetesResourcesSpec) String() string { return proto.CompactTextString(m) }
func (*KubernetesResourcesSpec) ProtoMessage()    {}
func (*KubernetesResourcesSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{26}
}

func (m *KubernetesResourcesSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KubernetesResourcesSpec.Unmarshal(m, b)
}
func (m *KubernetesResourcesSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KubernetesResourcesSpec.Marshal(b, m, deterministic)
}
func (m *KubernetesResourcesSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KubernetesResourcesSpec.Merge(m, src)
}
func (m *KubernetesResourcesSpec) XXX_Size() int {
	return xxx_messageInfo_KubernetesResourcesSpec.Size(m)
}
func (m *KubernetesResourcesSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_KubernetesResourcesSpec.DiscardUnknown(m)
}

var xxx_messageInfo_KubernetesResourcesSpec proto.InternalMessageInfo

func (m *KubernetesResourcesSpec) GetAffinity() *v1.Affinity {
	if m != nil {
		return m.Affinity
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetEnv() []*v1.EnvVar {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetHpaSpec() *v2beta1.HorizontalPodAutoscalerSpec {
	if m != nil {
		return m.HpaSpec
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetImagePullPolicy() string {
	if m != nil {
		return m.ImagePullPolicy
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetNodeSelector() map[string]string {
	if m != nil {
		return m.NodeSelector
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodDisruptionBudget() *PodDisruptionBudgetSpec {
	if m != nil {
		return m.PodDisruptionBudget
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPodAnnotations() map[string]string {
	if m != nil {
		return m.PodAnnotations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetPriorityClassName() string {
	if m != nil {
		return m.PriorityClassName
	}
	return ""
}

func (m *KubernetesResourcesSpec) GetReadinessProbe() *ReadinessProbe {
	if m != nil {
		return m.ReadinessProbe
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetReplicaCount() uint32 {
	if m != nil {
		return m.ReplicaCount
	}
	return 0
}

func (m *KubernetesResourcesSpec) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetService() *v1.ServiceSpec {
	if m != nil {
		return m.Service
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetStrategy() *DeploymentStrategy {
	if m != nil {
		return m.Strategy
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetTolerations() []*v1.Toleration {
	if m != nil {
		return m.Tolerations
	}
	return nil
}

func (m *KubernetesResourcesSpec) GetOverlays() []*K8SObjectOverlay {
	if m != nil {
		return m.Overlays
	}
	return nil
}

// Patch for an existing k8s resource.
type K8SObjectOverlay struct {
	// Resource API version.
	ApiVersion string `protobuf:"bytes,1,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	// Resource kind.
	Kind string `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	// Name of resource.
	// Namespace is always the component namespace.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// List of patches to apply to resource.
	Patches              []*K8SObjectOverlay_PathValue `protobuf:"bytes,4,rep,name=patches,proto3" json:"patches,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *K8SObjectOverlay) Reset()         { *m = K8SObjectOverlay{} }
func (m *K8SObjectOverlay) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay) ProtoMessage()    {}
func (*K8SObjectOverlay) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{27}
}

func (m *K8SObjectOverlay) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay.Unmarshal(m, b)
}
func (m *K8SObjectOverlay) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay.Merge(m, src)
}
func (m *K8SObjectOverlay) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay.Size(m)
}
func (m *K8SObjectOverlay) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay proto.InternalMessageInfo

func (m *K8SObjectOverlay) GetApiVersion() string {
	if m != nil {
		return m.ApiVersion
	}
	return ""
}

func (m *K8SObjectOverlay) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

func (m *K8SObjectOverlay) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *K8SObjectOverlay) GetPatches() []*K8SObjectOverlay_PathValue {
	if m != nil {
		return m.Patches
	}
	return nil
}

type K8SObjectOverlay_PathValue struct {
	// Path of the form a.b:c.e.:f
	// Where b:c is a list element selector of the form key:value and :f is a list selector of the form :value.
	// All path intermediate nodes must exist.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Value to add, delete or replace.
	// For add, the path should be a new leaf.
	// For delete, value should be unset.
	// For replace, path should reference an existing node.
	// All values are strings but are converted into appropriate type based on schema.
	Value                interface{} `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *K8SObjectOverlay_PathValue) Reset()         { *m = K8SObjectOverlay_PathValue{} }
func (m *K8SObjectOverlay_PathValue) String() string { return proto.CompactTextString(m) }
func (*K8SObjectOverlay_PathValue) ProtoMessage()    {}
func (*K8SObjectOverlay_PathValue) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{27, 0}
}

func (m *K8SObjectOverlay_PathValue) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Unmarshal(m, b)
}
func (m *K8SObjectOverlay_PathValue) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Marshal(b, m, deterministic)
}
func (m *K8SObjectOverlay_PathValue) XXX_Merge(src proto.Message) {
	xxx_messageInfo_K8SObjectOverlay_PathValue.Merge(m, src)
}
func (m *K8SObjectOverlay_PathValue) XXX_Size() int {
	return xxx_messageInfo_K8SObjectOverlay_PathValue.Size(m)
}
func (m *K8SObjectOverlay_PathValue) XXX_DiscardUnknown() {
	xxx_messageInfo_K8SObjectOverlay_PathValue.DiscardUnknown(m)
}

var xxx_messageInfo_K8SObjectOverlay_PathValue proto.InternalMessageInfo

func (m *K8SObjectOverlay_PathValue) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *K8SObjectOverlay_PathValue) GetValue() interface{} {
	if m != nil {
		return m.Value
	}
	return nil
}

// Observed state of IstioControlPlane.
type InstallStatus struct {
	Status               map[string]*InstallStatus_VersionStatus `protobuf:"bytes,1,rep,name=status,proto3" json:"status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *InstallStatus) Reset()         { *m = InstallStatus{} }
func (m *InstallStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus) ProtoMessage()    {}
func (*InstallStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{28}
}

func (m *InstallStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus.Unmarshal(m, b)
}
func (m *InstallStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus.Merge(m, src)
}
func (m *InstallStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus.Size(m)
}
func (m *InstallStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus proto.InternalMessageInfo

func (m *InstallStatus) GetStatus() map[string]*InstallStatus_VersionStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

type InstallStatus_VersionStatus struct {
	Version              string               `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	Status               InstallStatus_Status `protobuf:"varint,2,opt,name=status,proto3,enum=v1alpha2.InstallStatus_Status" json:"status,omitempty"`
	StatusString         string               `protobuf:"bytes,3,opt,name=statusString,proto3" json:"statusString,omitempty"`
	Error                string               `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *InstallStatus_VersionStatus) Reset()         { *m = InstallStatus_VersionStatus{} }
func (m *InstallStatus_VersionStatus) String() string { return proto.CompactTextString(m) }
func (*InstallStatus_VersionStatus) ProtoMessage()    {}
func (*InstallStatus_VersionStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{28, 0}
}

func (m *InstallStatus_VersionStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InstallStatus_VersionStatus.Unmarshal(m, b)
}
func (m *InstallStatus_VersionStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InstallStatus_VersionStatus.Marshal(b, m, deterministic)
}
func (m *InstallStatus_VersionStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstallStatus_VersionStatus.Merge(m, src)
}
func (m *InstallStatus_VersionStatus) XXX_Size() int {
	return xxx_messageInfo_InstallStatus_VersionStatus.Size(m)
}
func (m *InstallStatus_VersionStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_InstallStatus_VersionStatus.DiscardUnknown(m)
}

var xxx_messageInfo_InstallStatus_VersionStatus proto.InternalMessageInfo

func (m *InstallStatus_VersionStatus) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *InstallStatus_VersionStatus) GetStatus() InstallStatus_Status {
	if m != nil {
		return m.Status
	}
	return InstallStatus_NONE
}

func (m *InstallStatus_VersionStatus) GetStatusString() string {
	if m != nil {
		return m.StatusString
	}
	return ""
}

func (m *InstallStatus_VersionStatus) GetError() string {
	if m != nil {
		return m.Error
	}
	return ""
}

// Mirrors k8s.io.api.core.v1.ResourceRequirements for unmarshaling.
type Resources struct {
	Limits               map[string]string `protobuf:"bytes,1,rep,name=limits,proto3" json:"limits,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Requests             map[string]string `protobuf:"bytes,2,rep,name=requests,proto3" json:"requests,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{29}
}

func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (m *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(m, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetLimits() map[string]string {
	if m != nil {
		return m.Limits
	}
	return nil
}

func (m *Resources) GetRequests() map[string]string {
	if m != nil {
		return m.Requests
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.Probe for unmarshaling
type ReadinessProbe struct {
	Exec                 *ExecAction      `protobuf:"bytes,1,opt,name=exec,proto3" json:"exec,omitempty"`
	HttpGet              *HTTPGetAction   `protobuf:"bytes,2,opt,name=httpGet,proto3" json:"httpGet,omitempty"`
	TcpSocket            *TCPSocketAction `protobuf:"bytes,3,opt,name=tcpSocket,proto3" json:"tcpSocket,omitempty"`
	InitialDelaySeconds  int32            `protobuf:"varint,4,opt,name=initialDelaySeconds,proto3" json:"initialDelaySeconds,omitempty"`
	TimeoutSeconds       int32            `protobuf:"varint,5,opt,name=timeoutSeconds,proto3" json:"timeoutSeconds,omitempty"`
	PeriodSeconds        int32            `protobuf:"varint,6,opt,name=periodSeconds,proto3" json:"periodSeconds,omitempty"`
	SuccessThreshold     int32            `protobuf:"varint,7,opt,name=successThreshold,proto3" json:"successThreshold,omitempty"`
	FailureThreshold     int32            `protobuf:"varint,8,opt,name=failureThreshold,proto3" json:"failureThreshold,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ReadinessProbe) Reset()         { *m = ReadinessProbe{} }
func (m *ReadinessProbe) String() string { return proto.CompactTextString(m) }
func (*ReadinessProbe) ProtoMessage()    {}
func (*ReadinessProbe) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{30}
}

func (m *ReadinessProbe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadinessProbe.Unmarshal(m, b)
}
func (m *ReadinessProbe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadinessProbe.Marshal(b, m, deterministic)
}
func (m *ReadinessProbe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadinessProbe.Merge(m, src)
}
func (m *ReadinessProbe) XXX_Size() int {
	return xxx_messageInfo_ReadinessProbe.Size(m)
}
func (m *ReadinessProbe) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadinessProbe.DiscardUnknown(m)
}

var xxx_messageInfo_ReadinessProbe proto.InternalMessageInfo

func (m *ReadinessProbe) GetExec() *ExecAction {
	if m != nil {
		return m.Exec
	}
	return nil
}

func (m *ReadinessProbe) GetHttpGet() *HTTPGetAction {
	if m != nil {
		return m.HttpGet
	}
	return nil
}

func (m *ReadinessProbe) GetTcpSocket() *TCPSocketAction {
	if m != nil {
		return m.TcpSocket
	}
	return nil
}

func (m *ReadinessProbe) GetInitialDelaySeconds() int32 {
	if m != nil {
		return m.InitialDelaySeconds
	}
	return 0
}

func (m *ReadinessProbe) GetTimeoutSeconds() int32 {
	if m != nil {
		return m.TimeoutSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetPeriodSeconds() int32 {
	if m != nil {
		return m.PeriodSeconds
	}
	return 0
}

func (m *ReadinessProbe) GetSuccessThreshold() int32 {
	if m != nil {
		return m.SuccessThreshold
	}
	return 0
}

func (m *ReadinessProbe) GetFailureThreshold() int32 {
	if m != nil {
		return m.FailureThreshold
	}
	return 0
}

// Mirrors k8s.io.api.core.v1.ExecAction for unmarshaling
type ExecAction struct {
	Command              []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExecAction) Reset()         { *m = ExecAction{} }
func (m *ExecAction) String() string { return proto.CompactTextString(m) }
func (*ExecAction) ProtoMessage()    {}
func (*ExecAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{31}
}

func (m *ExecAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExecAction.Unmarshal(m, b)
}
func (m *ExecAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExecAction.Marshal(b, m, deterministic)
}
func (m *ExecAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExecAction.Merge(m, src)
}
func (m *ExecAction) XXX_Size() int {
	return xxx_messageInfo_ExecAction.Size(m)
}
func (m *ExecAction) XXX_DiscardUnknown() {
	xxx_messageInfo_ExecAction.DiscardUnknown(m)
}

var xxx_messageInfo_ExecAction proto.InternalMessageInfo

func (m *ExecAction) GetCommand() []string {
	if m != nil {
		return m.Command
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.HTTPGetAction for unmarshaling
type HTTPGetAction struct {
	Path                 string                `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Port                 *IntOrStringForPB `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	Scheme               string                `protobuf:"bytes,4,opt,name=scheme,proto3" json:"scheme,omitempty"`
	HttpHeaders          []*HTTPHeader         `protobuf:"bytes,5,rep,name=httpHeaders,proto3" json:"httpHeaders,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *HTTPGetAction) Reset()         { *m = HTTPGetAction{} }
func (m *HTTPGetAction) String() string { return proto.CompactTextString(m) }
func (*HTTPGetAction) ProtoMessage()    {}
func (*HTTPGetAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{32}
}

func (m *HTTPGetAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPGetAction.Unmarshal(m, b)
}
func (m *HTTPGetAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPGetAction.Marshal(b, m, deterministic)
}
func (m *HTTPGetAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPGetAction.Merge(m, src)
}
func (m *HTTPGetAction) XXX_Size() int {
	return xxx_messageInfo_HTTPGetAction.Size(m)
}
func (m *HTTPGetAction) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPGetAction.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPGetAction proto.InternalMessageInfo

func (m *HTTPGetAction) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPGetAction) GetPort() *IntOrStringForPB {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *HTTPGetAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *HTTPGetAction) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *HTTPGetAction) GetHttpHeaders() []*HTTPHeader {
	if m != nil {
		return m.HttpHeaders
	}
	return nil
}

// Mirrors k8s.io.api.core.v1.HTTPHeader for unmarshaling
type HTTPHeader struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HTTPHeader) Reset()         { *m = HTTPHeader{} }
func (m *HTTPHeader) String() string { return proto.CompactTextString(m) }
func (*HTTPHeader) ProtoMessage()    {}
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{33}
}

func (m *HTTPHeader) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HTTPHeader.Unmarshal(m, b)
}
func (m *HTTPHeader) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HTTPHeader.Marshal(b, m, deterministic)
}
func (m *HTTPHeader) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPHeader.Merge(m, src)
}
func (m *HTTPHeader) XXX_Size() int {
	return xxx_messageInfo_HTTPHeader.Size(m)
}
func (m *HTTPHeader) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPHeader.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPHeader proto.InternalMessageInfo

func (m *HTTPHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HTTPHeader) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Mirrors k8s.io.api.core.v1.TCPSocketAction for unmarshaling
type TCPSocketAction struct {
	Port                 *IntOrStringForPB `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	Host                 string                `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TCPSocketAction) Reset()         { *m = TCPSocketAction{} }
func (m *TCPSocketAction) String() string { return proto.CompactTextString(m) }
func (*TCPSocketAction) ProtoMessage()    {}
func (*TCPSocketAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{34}
}

func (m *TCPSocketAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TCPSocketAction.Unmarshal(m, b)
}
func (m *TCPSocketAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TCPSocketAction.Marshal(b, m, deterministic)
}
func (m *TCPSocketAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPSocketAction.Merge(m, src)
}
func (m *TCPSocketAction) XXX_Size() int {
	return xxx_messageInfo_TCPSocketAction.Size(m)
}
func (m *TCPSocketAction) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPSocketAction.DiscardUnknown(m)
}

var xxx_messageInfo_TCPSocketAction proto.InternalMessageInfo

func (m *TCPSocketAction) GetPort() *IntOrStringForPB {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TCPSocketAction) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// Mirrors k8s.io.api.policy.v1beta1.PodDisruptionBudget for unmarshaling.
type PodDisruptionBudgetSpec struct {
	MinAvailable         uint32             `protobuf:"varint,1,opt,name=minAvailable,proto3" json:"minAvailable,omitempty"`
	Selector             *v11.LabelSelector `protobuf:"bytes,2,opt,name=selector,proto3" json:"selector,omitempty"`
	MaxUnavailable       uint32             `protobuf:"varint,3,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *PodDisruptionBudgetSpec) Reset()         { *m = PodDisruptionBudgetSpec{} }
func (m *PodDisruptionBudgetSpec) String() string { return proto.CompactTextString(m) }
func (*PodDisruptionBudgetSpec) ProtoMessage()    {}
func (*PodDisruptionBudgetSpec) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{35}
}

func (m *PodDisruptionBudgetSpec) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Unmarshal(m, b)
}
func (m *PodDisruptionBudgetSpec) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Marshal(b, m, deterministic)
}
func (m *PodDisruptionBudgetSpec) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PodDisruptionBudgetSpec.Merge(m, src)
}
func (m *PodDisruptionBudgetSpec) XXX_Size() int {
	return xxx_messageInfo_PodDisruptionBudgetSpec.Size(m)
}
func (m *PodDisruptionBudgetSpec) XXX_DiscardUnknown() {
	xxx_messageInfo_PodDisruptionBudgetSpec.DiscardUnknown(m)
}

var xxx_messageInfo_PodDisruptionBudgetSpec proto.InternalMessageInfo

func (m *PodDisruptionBudgetSpec) GetMinAvailable() uint32 {
	if m != nil {
		return m.MinAvailable
	}
	return 0
}

func (m *PodDisruptionBudgetSpec) GetSelector() *v11.LabelSelector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (m *PodDisruptionBudgetSpec) GetMaxUnavailable() uint32 {
	if m != nil {
		return m.MaxUnavailable
	}
	return 0
}

// Mirrors k8s.io.api.apps.v1.DeploymentStrategy for unmarshaling.
type DeploymentStrategy struct {
	Type                 string                   `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	RollingUpdate        *RollingUpdateDeployment `protobuf:"bytes,2,opt,name=rollingUpdate,proto3" json:"rollingUpdate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *DeploymentStrategy) Reset()         { *m = DeploymentStrategy{} }
func (m *DeploymentStrategy) String() string { return proto.CompactTextString(m) }
func (*DeploymentStrategy) ProtoMessage()    {}
func (*DeploymentStrategy) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{36}
}

func (m *DeploymentStrategy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeploymentStrategy.Unmarshal(m, b)
}
func (m *DeploymentStrategy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeploymentStrategy.Marshal(b, m, deterministic)
}
func (m *DeploymentStrategy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeploymentStrategy.Merge(m, src)
}
func (m *DeploymentStrategy) XXX_Size() int {
	return xxx_messageInfo_DeploymentStrategy.Size(m)
}
func (m *DeploymentStrategy) XXX_DiscardUnknown() {
	xxx_messageInfo_DeploymentStrategy.DiscardUnknown(m)
}

var xxx_messageInfo_DeploymentStrategy proto.InternalMessageInfo

func (m *DeploymentStrategy) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *DeploymentStrategy) GetRollingUpdate() *RollingUpdateDeployment {
	if m != nil {
		return m.RollingUpdate
	}
	return nil
}

// Mirrors k8s.io.api.apps.v1.RollingUpdateDeployment for unmarshaling.
type RollingUpdateDeployment struct {
	MaxUnavailable       *IntOrStringForPB `protobuf:"bytes,1,opt,name=maxUnavailable,proto3" json:"maxUnavailable,omitempty"`
	MaxSurge             *IntOrStringForPB `protobuf:"bytes,2,opt,name=maxSurge,proto3" json:"maxSurge,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *RollingUpdateDeployment) Reset()         { *m = RollingUpdateDeployment{} }
func (m *RollingUpdateDeployment) String() string { return proto.CompactTextString(m) }
func (*RollingUpdateDeployment) ProtoMessage()    {}
func (*RollingUpdateDeployment) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{37}
}

func (m *RollingUpdateDeployment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RollingUpdateDeployment.Unmarshal(m, b)
}
func (m *RollingUpdateDeployment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RollingUpdateDeployment.Marshal(b, m, deterministic)
}
func (m *RollingUpdateDeployment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RollingUpdateDeployment.Merge(m, src)
}
func (m *RollingUpdateDeployment) XXX_Size() int {
	return xxx_messageInfo_RollingUpdateDeployment.Size(m)
}
func (m *RollingUpdateDeployment) XXX_DiscardUnknown() {
	xxx_messageInfo_RollingUpdateDeployment.DiscardUnknown(m)
}

var xxx_messageInfo_RollingUpdateDeployment proto.InternalMessageInfo

func (m *RollingUpdateDeployment) GetMaxUnavailable() *IntOrStringForPB {
	if m != nil {
		return m.MaxUnavailable
	}
	return nil
}

func (m *RollingUpdateDeployment) GetMaxSurge() *IntOrStringForPB {
	if m != nil {
		return m.MaxSurge
	}
	return nil
}

type ObjectMeta struct {
	// From k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta
	Name                 string   `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	Namespace            string   `protobuf:"bytes,6,opt,name=namespace,proto3" json:"namespace,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ObjectMeta) Reset()         { *m = ObjectMeta{} }
func (m *ObjectMeta) String() string { return proto.CompactTextString(m) }
func (*ObjectMeta) ProtoMessage()    {}
func (*ObjectMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_daac92937abd81a4, []int{38}
}

func (m *ObjectMeta) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ObjectMeta.Unmarshal(m, b)
}
func (m *ObjectMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ObjectMeta.Marshal(b, m, deterministic)
}
func (m *ObjectMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ObjectMeta.Merge(m, src)
}
func (m *ObjectMeta) XXX_Size() int {
	return xxx_messageInfo_ObjectMeta.Size(m)
}
func (m *ObjectMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_ObjectMeta.DiscardUnknown(m)
}

var xxx_messageInfo_ObjectMeta proto.InternalMessageInfo

func (m *ObjectMeta) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ObjectMeta) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}





func init() {
	proto.RegisterEnum("v1alpha2.InstallStatus_Status", InstallStatus_Status_name, InstallStatus_Status_value)
	proto.RegisterType((*IstioControlPlane)(nil), "v1alpha2.IstioControlPlane")
	proto.RegisterType((*IstioControlPlaneSpec)(nil), "v1alpha2.IstioControlPlaneSpec")
	proto.RegisterType((*BaseFeatureSpec)(nil), "v1alpha2.BaseFeatureSpec")
	proto.RegisterType((*BaseFeatureSpec_Components)(nil), "v1alpha2.BaseFeatureSpec.Components")
	proto.RegisterType((*TrafficManagementFeatureSpec)(nil), "v1alpha2.TrafficManagementFeatureSpec")
	proto.RegisterType((*TrafficManagementFeatureSpec_Components)(nil), "v1alpha2.TrafficManagementFeatureSpec.Components")
	proto.RegisterType((*PolicyFeatureSpec)(nil), "v1alpha2.PolicyFeatureSpec")
	proto.RegisterType((*PolicyFeatureSpec_Components)(nil), "v1alpha2.PolicyFeatureSpec.Components")
	proto.RegisterType((*TelemetryFeatureSpec)(nil), "v1alpha2.TelemetryFeatureSpec")
	proto.RegisterType((*TelemetryFeatureSpec_Components)(nil), "v1alpha2.TelemetryFeatureSpec.Components")
	proto.RegisterType((*SecurityFeatureSpec)(nil), "v1alpha2.SecurityFeatureSpec")
	proto.RegisterType((*SecurityFeatureSpec_Components)(nil), "v1alpha2.SecurityFeatureSpec.Components")
	proto.RegisterType((*ConfigManagementFeatureSpec)(nil), "v1alpha2.ConfigManagementFeatureSpec")
	proto.RegisterType((*ConfigManagementFeatureSpec_Components)(nil), "v1alpha2.ConfigManagementFeatureSpec.Components")
	proto.RegisterType((*AutoInjectionFeatureSpec)(nil), "v1alpha2.AutoInjectionFeatureSpec")
	proto.RegisterType((*AutoInjectionFeatureSpec_Components)(nil), "v1alpha2.AutoInjectionFeatureSpec.Components")
	proto.RegisterType((*GatewayFeatureSpec)(nil), "v1alpha2.GatewayFeatureSpec")
	proto.RegisterType((*GatewayFeatureSpec_Components)(nil), "v1alpha2.GatewayFeatureSpec.Components")
	proto.RegisterType((*CNIFeatureSpec)(nil), "v1alpha2.CNIFeatureSpec")
	proto.RegisterType((*CNIFeatureSpec_Components)(nil), "v1alpha2.CNIFeatureSpec.Components")
	proto.RegisterType((*CoreDNSFeatureSpec)(nil), "v1alpha2.CoreDNSFeatureSpec")
	proto.RegisterType((*CoreDNSFeatureSpec_Components)(nil), "v1alpha2.CoreDNSFeatureSpec.Components")
	proto.RegisterType((*BaseComponentSpec)(nil), "v1alpha2.BaseComponentSpec")
	proto.RegisterType((*PilotComponentSpec)(nil), "v1alpha2.PilotComponentSpec")
	proto.RegisterType((*ProxyComponentSpec)(nil), "v1alpha2.ProxyComponentSpec")
	proto.RegisterType((*SidecarInjectorComponentSpec)(nil), "v1alpha2.SidecarInjectorComponentSpec")
	proto.RegisterType((*PolicyComponentSpec)(nil), "v1alpha2.PolicyComponentSpec")
	proto.RegisterType((*TelemetryComponentSpec)(nil), "v1alpha2.TelemetryComponentSpec")
	proto.RegisterType((*CitadelComponentSpec)(nil), "v1alpha2.CitadelComponentSpec")
	proto.RegisterType((*CertManagerComponentSpec)(nil), "v1alpha2.CertManagerComponentSpec")
	proto.RegisterType((*NodeAgentComponentSpec)(nil), "v1alpha2.NodeAgentComponentSpec")
	proto.RegisterType((*GalleyComponentSpec)(nil), "v1alpha2.GalleyComponentSpec")
	proto.RegisterType((*IngressGatewayComponentSpec)(nil), "v1alpha2.IngressGatewayComponentSpec")
	proto.RegisterType((*EgressGatewayComponentSpec)(nil), "v1alpha2.EgressGatewayComponentSpec")
	proto.RegisterType((*CNIComponentSpec)(nil), "v1alpha2.CNIComponentSpec")
	proto.RegisterType((*CoreDNSComponentSpec)(nil), "v1alpha2.CoreDNSComponentSpec")
	proto.RegisterType((*KubernetesResourcesSpec)(nil), "v1alpha2.KubernetesResourcesSpec")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.KubernetesResourcesSpec.NodeSelectorEntry")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.KubernetesResourcesSpec.PodAnnotationsEntry")
	proto.RegisterType((*K8SObjectOverlay)(nil), "v1alpha2.k8sObjectOverlay")
	proto.RegisterType((*K8SObjectOverlay_PathValue)(nil), "v1alpha2.k8sObjectOverlay.PathValue")
	proto.RegisterType((*InstallStatus)(nil), "v1alpha2.InstallStatus")
	proto.RegisterMapType((map[string]*InstallStatus_VersionStatus)(nil), "v1alpha2.InstallStatus.StatusEntry")
	proto.RegisterType((*InstallStatus_VersionStatus)(nil), "v1alpha2.InstallStatus.VersionStatus")
	proto.RegisterType((*Resources)(nil), "v1alpha2.Resources")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.Resources.LimitsEntry")
	proto.RegisterMapType((map[string]string)(nil), "v1alpha2.Resources.RequestsEntry")
	proto.RegisterType((*ReadinessProbe)(nil), "v1alpha2.ReadinessProbe")
	proto.RegisterType((*ExecAction)(nil), "v1alpha2.ExecAction")
	proto.RegisterType((*HTTPGetAction)(nil), "v1alpha2.HTTPGetAction")
	proto.RegisterType((*HTTPHeader)(nil), "v1alpha2.HTTPHeader")
	proto.RegisterType((*TCPSocketAction)(nil), "v1alpha2.TCPSocketAction")
	proto.RegisterType((*PodDisruptionBudgetSpec)(nil), "v1alpha2.PodDisruptionBudgetSpec")
	proto.RegisterType((*DeploymentStrategy)(nil), "v1alpha2.DeploymentStrategy")
	proto.RegisterType((*RollingUpdateDeployment)(nil), "v1alpha2.RollingUpdateDeployment")
	proto.RegisterType((*ObjectMeta)(nil), "v1alpha2.ObjectMeta")
}

func init() {
	proto.RegisterFile("pkg/apis/istio/v1alpha2/istiocontrolplane_types.proto", fileDescriptor_daac92937abd81a4)
}

var fileDescriptor_daac92937abd81a4 = []byte{
	// 2607 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x5a, 0x4d, 0x70, 0x1c, 0x47,
	0xf5, 0xff, 0xcf, 0xea, 0x6b, 0xf5, 0xe4, 0xd5, 0x47, 0x5b, 0xb1, 0x27, 0x6b, 0xc7, 0x56, 0x26,
	0x89, 0xff, 0x26, 0x90, 0xdd, 0xd8, 0x22, 0x8e, 0x12, 0x93, 0x0f, 0x79, 0x2d, 0xcb, 0xaa, 0xd8,
	0xab, 0x65, 0x24, 0xbb, 0x92, 0x0b, 0x4b, 0xef, 0x4c, 0x6b, 0x77, 0xa2, 0xd9, 0xe9, 0x49, 0x4f,
	0xef, 0xc6, 0xcb, 0x1d, 0x0e, 0xdc, 0xe0, 0xc2, 0x81, 0xa2, 0x80, 0xa2, 0x28, 0xe0, 0xc4, 0x8d,
	0x0b, 0x55, 0x5c, 0xb9, 0xc1, 0x85, 0x3b, 0x47, 0x0e, 0x70, 0xe6, 0x92, 0x2a, 0x8a, 0xea, 0x8f,
	0xf9, 0xda, 0x9d, 0x55, 0x2c, 0x15, 0x54, 0x89, 0x93, 0x7a, 0xde, 0xfb, 0xbd, 0xd7, 0xef, 0xbd,
	0xee, 0xf7, 0xfa, 0xf5, 0xb6, 0xe0, 0xad, 0xf0, 0xb8, 0x5b, 0xc7, 0xa1, 0x17, 0xd5, 0xbd, 0x88,
	0x7b, 0xb4, 0x3e, 0xbc, 0x85, 0xfd, 0xb0, 0x87, 0x6f, 0xab, 0x4f, 0x87, 0x06, 0x9c, 0x51, 0x3f,
	0xf4, 0x71, 0x40, 0xda, 0x7c, 0x14, 0x92, 0xa8, 0x16, 0x32, 0xca, 0x29, 0x2a, 0xc7, 0xb8, 0xaa,
	0x75, 0xbc, 0x15, 0xd5, 0x3c, 0x2a, 0x74, 0xd4, 0x1d, 0xca, 0x48, 0x7d, 0x78, 0xab, 0xde, 0x25,
	0x01, 0x61, 0x98, 0x13, 0x57, 0xa1, 0xab, 0xb5, 0x0c, 0x06, 0x0f, 0x38, 0x8d, 0x1c, 0xec, 0x7b,
	0x41, 0xb7, 0x3e, 0xbc, 0xdd, 0x21, 0x1c, 0x4f, 0xe2, 0xbf, 0x9e, 0xe2, 0xfb, 0xd8, 0xe9, 0x79,
	0x01, 0x61, 0xa3, 0x7a, 0x62, 0x68, 0x9f, 0x70, 0x5c, 0x34, 0xcb, 0x87, 0x5d, 0x8f, 0xf7, 0x06,
	0x9d, 0x9a, 0x43, 0xfb, 0xf5, 0x2e, 0xed, 0xd2, 0xba, 0x24, 0x77, 0x06, 0x47, 0xe9, 0xa0, 0x4b,
	0x69, 0xd7, 0x27, 0xe9, 0xf7, 0xe7, 0x0c, 0x87, 0x21, 0x61, 0xda, 0x2b, 0xeb, 0xcf, 0x06, 0xac,
	0xed, 0x09, 0xbf, 0x1b, 0xca, 0xef, 0x96, 0xf0, 0x1b, 0x6d, 0xc2, 0x6c, 0x14, 0x12, 0xc7, 0x9c,
	0xd9, 0x30, 0x6e, 0x2e, 0xdd, 0xbe, 0x5e, 0x8b, 0x5d, 0xaf, 0x4d, 0x40, 0x0f, 0x42, 0xe2, 0xd8,
	0x12, 0x8c, 0xea, 0x30, 0x1f, 0x71, 0xcc, 0x07, 0x91, 0x39, 0x2b, 0xc5, 0x2e, 0x67, 0xc4, 0x82,
	0x88, 0x63, 0xdf, 0x3f, 0x90, 0x6c, 0x5b, 0xc3, 0x10, 0x82, 0xd9, 0x63, 0x2f, 0x70, 0xcd, 0xb9,
	0x0d, 0xe3, 0xe6, 0xa2, 0x2d, 0xc7, 0xe8, 0x1a, 0x00, 0x0e, 0xbd, 0xa7, 0x84, 0x45, 0x1e, 0x0d,
	0xcc, 0x79, 0xc9, 0xc9, 0x50, 0xd0, 0x06, 0x2c, 0x85, 0x3e, 0x76, 0x48, 0x8f, 0xfa, 0x2e, 0x61,
	0x26, 0x95, 0x80, 0x2c, 0xc9, 0xfa, 0xed, 0x02, 0xbc, 0x50, 0x68, 0x26, 0xfa, 0x2a, 0xac, 0xb9,
	0xe4, 0x08, 0x0f, 0x7c, 0xde, 0x0e, 0x70, 0x9f, 0x44, 0x21, 0x76, 0x88, 0x9e, 0x7c, 0x55, 0x33,
	0x9a, 0x31, 0x1d, 0xbd, 0x01, 0xb3, 0x1d, 0x1c, 0x11, 0x73, 0x5d, 0xfa, 0xf2, 0x62, 0xea, 0xcb,
	0x3d, 0x1c, 0x91, 0x07, 0x04, 0xf3, 0x01, 0xd3, 0xce, 0x0b, 0x18, 0x7a, 0x02, 0x88, 0x33, 0x7c,
	0x74, 0xe4, 0x39, 0xed, 0x3e, 0x0e, 0x70, 0x97, 0xf4, 0x49, 0xc0, 0xcd, 0x17, 0xa5, 0xf0, 0x8d,
	0x54, 0xf8, 0x50, 0x61, 0x1e, 0x27, 0x90, 0xac, 0xa6, 0x35, 0x3e, 0xce, 0x45, 0x9b, 0x30, 0x1f,
	0x52, 0xdf, 0x73, 0x46, 0x66, 0x55, 0xaa, 0xba, 0x92, 0xaa, 0x6a, 0x49, 0x7a, 0x56, 0x5e, 0x43,
	0xd1, 0x37, 0x60, 0x91, 0x13, 0x9f, 0xf4, 0x09, 0x67, 0x23, 0xf3, 0x8a, 0x94, 0xbb, 0x96, 0x31,
	0x21, 0x66, 0x65, 0x45, 0x53, 0x01, 0xf4, 0x0e, 0x94, 0x23, 0xe2, 0x0c, 0x98, 0xc7, 0x47, 0xe6,
	0x55, 0x29, 0xfc, 0x52, 0x2a, 0x7c, 0xa0, 0x39, 0x59, 0xd9, 0x04, 0x8e, 0x6c, 0x58, 0x73, 0x68,
	0x70, 0xe4, 0x75, 0xb3, 0x31, 0x78, 0x49, 0xea, 0x78, 0x2d, 0xd5, 0xd1, 0x90, 0x90, 0xe2, 0x10,
	0xac, 0x3a, 0x63, 0x4c, 0xb4, 0x07, 0xcb, 0x22, 0x7f, 0xda, 0x5e, 0xf0, 0x29, 0x71, 0xb8, 0xd8,
	0x14, 0xd7, 0xa4, 0x42, 0x2b, 0x55, 0xb8, 0x3d, 0xe0, 0x74, 0x2f, 0x66, 0x67, 0xb5, 0x55, 0x70,
	0x96, 0x83, 0xb6, 0xa0, 0xdc, 0xc5, 0x9c, 0x7c, 0x8e, 0x47, 0x91, 0x79, 0x5d, 0x2a, 0xb9, 0x9a,
	0x2a, 0xd9, 0x55, 0x9c, 0x9c, 0x63, 0x31, 0x1a, 0xbd, 0x0e, 0x33, 0x4e, 0xe0, 0x99, 0x1b, 0x52,
	0xc8, 0xcc, 0xb8, 0xd2, 0xdc, 0xcb, 0x0a, 0x08, 0x10, 0xba, 0x03, 0x0b, 0xa2, 0x28, 0xdc, 0x6f,
	0x1e, 0x98, 0x2f, 0x8f, 0x4f, 0xd2, 0x50, 0x8c, 0xac, 0x4c, 0x0c, 0x46, 0x5b, 0x30, 0x3f, 0xc4,
	0xfe, 0x80, 0x44, 0xe6, 0x6d, 0x29, 0xb6, 0x91, 0x59, 0xb2, 0x51, 0x48, 0x1e, 0xe3, 0xf0, 0x80,
	0x33, 0x2f, 0xe8, 0xee, 0x05, 0x9c, 0xb0, 0x23, 0xec, 0x10, 0x5b, 0xe3, 0x51, 0x13, 0xd6, 0x06,
	0xc1, 0x10, 0xfb, 0x9e, 0x2b, 0x4a, 0xc3, 0x53, 0xa5, 0x64, 0xf3, 0x39, 0x95, 0x4c, 0x8a, 0x22,
	0x13, 0x16, 0x42, 0x46, 0x8f, 0x3c, 0x9f, 0x98, 0xae, 0xcc, 0x8e, 0xf8, 0x13, 0xbd, 0x09, 0xeb,
	0x9e, 0x4a, 0xe5, 0x76, 0x88, 0x9d, 0x63, 0xdc, 0x25, 0xed, 0x10, 0xf3, 0x9e, 0x79, 0x24, 0x61,
	0x48, 0xf3, 0x5a, 0x8a, 0xd5, 0xc2, 0xbc, 0x87, 0x56, 0x61, 0xa6, 0x37, 0xe8, 0x98, 0x81, 0x04,
	0x88, 0xa1, 0xa0, 0x70, 0xdc, 0xd5, 0x99, 0x2b, 0x86, 0xd6, 0x9f, 0x0c, 0x58, 0x19, 0xcb, 0x2a,
	0x11, 0x45, 0x12, 0xe0, 0x8e, 0x4f, 0x5c, 0xd3, 0x18, 0x8f, 0xa2, 0xf0, 0xe4, 0x1e, 0xa5, 0xbe,
	0x34, 0xf7, 0x01, 0x65, 0xad, 0x7b, 0x76, 0x0c, 0x46, 0xf7, 0x01, 0x1c, 0xda, 0x0f, 0x69, 0x40,
	0x02, 0x1e, 0x47, 0xf2, 0xd5, 0xa9, 0xc9, 0x5b, 0x6b, 0x24, 0x58, 0x3b, 0x23, 0x57, 0x7d, 0x0f,
	0x20, 0xe5, 0xa0, 0x7a, 0xae, 0x14, 0x5c, 0xc9, 0x6b, 0x4b, 0x70, 0x69, 0x31, 0xb0, 0xfe, 0x50,
	0x82, 0xab, 0x27, 0x65, 0xfa, 0x99, 0xbd, 0xfb, 0x66, 0x81, 0x77, 0xb7, 0x9e, 0xaf, 0xba, 0x4c,
	0x73, 0xf5, 0x87, 0x46, 0xce, 0xd7, 0xab, 0xb0, 0x98, 0xd6, 0x46, 0x43, 0xae, 0x51, 0x4a, 0x40,
	0xb7, 0x61, 0x2e, 0xf4, 0x7c, 0xca, 0x75, 0x28, 0x32, 0x56, 0xb7, 0x04, 0x39, 0x1f, 0x0b, 0x05,
	0x95, 0x32, 0x8c, 0x3e, 0x1b, 0x99, 0x2f, 0x4c, 0xc8, 0x08, 0xf2, 0xb8, 0x8c, 0xa0, 0x59, 0xff,
	0x34, 0x60, 0x6d, 0xa2, 0xbe, 0x9d, 0x39, 0x6a, 0x0f, 0x0a, 0xa2, 0x76, 0xe3, 0x84, 0x42, 0x3a,
	0x2d, 0x54, 0xf8, 0x14, 0x91, 0x7a, 0x2b, 0x29, 0xdc, 0xeb, 0xe3, 0x35, 0x54, 0xcd, 0x97, 0xf7,
	0x5b, 0x83, 0xad, 0xef, 0x96, 0x60, 0xbd, 0xa8, 0x40, 0x9f, 0xd9, 0xf7, 0xbd, 0x02, 0xdf, 0xbf,
	0x72, 0xf2, 0x61, 0x30, 0xcd, 0xfd, 0x4f, 0x4f, 0xe1, 0xfe, 0xfb, 0xd9, 0x23, 0x68, 0x7d, 0xa2,
	0x14, 0xc5, 0xac, 0x7c, 0x10, 0x52, 0x11, 0xeb, 0x7b, 0x33, 0x70, 0xb1, 0xe0, 0xac, 0x39, 0x73,
	0x18, 0x1e, 0x16, 0x84, 0xe1, 0xe6, 0x89, 0xc7, 0xda, 0xb4, 0x28, 0xfc, 0xe3, 0x34, 0xf9, 0xb2,
	0x05, 0x0b, 0x8e, 0xc7, 0xb1, 0x4b, 0x7c, 0x1d, 0x84, 0xcc, 0x39, 0xdc, 0x50, 0x8c, 0x7c, 0x08,
	0x62, 0x38, 0xda, 0x81, 0x0b, 0x0e, 0x61, 0x5c, 0x1f, 0xa4, 0x4c, 0x27, 0x4f, 0xe6, 0xd0, 0x6b,
	0x10, 0xc6, 0x55, 0xa2, 0xb3, 0xbc, 0x8a, 0x25, 0x27, 0xe5, 0xa0, 0x0f, 0x00, 0x02, 0xea, 0x92,
	0x36, 0xee, 0x8a, 0xa3, 0xf8, 0xd2, 0xf8, 0x42, 0x34, 0xa9, 0x4b, 0xb6, 0x05, 0x6b, 0x6c, 0x21,
	0x82, 0x98, 0x6e, 0x7d, 0xbf, 0x04, 0x57, 0x4e, 0x38, 0xb0, 0xcf, 0xbc, 0x20, 0xad, 0x82, 0x05,
	0x79, 0xf3, 0xb9, 0x7a, 0x84, 0xff, 0x50, 0x76, 0x76, 0xb1, 0xef, 0x93, 0x82, 0xec, 0xdc, 0x95,
	0xf4, 0xb1, 0xec, 0x54, 0x60, 0xeb, 0x07, 0x25, 0x30, 0xa7, 0x35, 0x1b, 0x67, 0x8e, 0xc4, 0xe3,
	0x82, 0x48, 0xbc, 0xf1, 0xe5, 0xcd, 0xcd, 0xb4, 0x30, 0x04, 0xa7, 0x08, 0xc3, 0x3d, 0x28, 0xab,
	0xb6, 0x8a, 0x32, 0x1d, 0x88, 0x4c, 0x59, 0x3c, 0xf0, 0x5c, 0xe2, 0x60, 0xb6, 0xa7, 0x01, 0xf9,
	0x88, 0x24, 0x72, 0xd6, 0x5f, 0x4b, 0x80, 0x26, 0x7b, 0xa7, 0x33, 0x47, 0x63, 0xb7, 0x20, 0x1a,
	0xff, 0x7f, 0x52, 0x97, 0x36, 0x2d, 0x0e, 0x7f, 0x3c, 0x4d, 0x9e, 0x36, 0x61, 0xc5, 0x0b, 0xba,
	0x8c, 0x44, 0x51, 0x5b, 0xf7, 0x7c, 0xba, 0x41, 0x7c, 0x2d, 0x7b, 0x87, 0x91, 0x00, 0x6d, 0x41,
	0x3e, 0x1c, 0xcb, 0x5e, 0x8e, 0x89, 0x3e, 0x82, 0x65, 0x92, 0x57, 0xb7, 0x31, 0xde, 0x89, 0xec,
	0x4c, 0xd7, 0x56, 0x21, 0x59, 0x9e, 0xf5, 0x37, 0x03, 0x96, 0xf3, 0x8d, 0xe6, 0x99, 0xa3, 0xdb,
	0x28, 0x88, 0xee, 0x2b, 0xd3, 0xda, 0xd9, 0x69, 0x91, 0xfd, 0xf8, 0x14, 0x81, 0xfd, 0x9a, 0x6a,
	0x9c, 0xd5, 0xe6, 0xaa, 0xe6, 0x66, 0xca, 0xfb, 0x2c, 0x60, 0xd6, 0x17, 0x06, 0xa0, 0xc9, 0x16,
	0xf9, 0xbf, 0xb5, 0x97, 0x26, 0x67, 0x9a, 0xe6, 0xb1, 0x7b, 0xca, 0x92, 0xaf, 0xdb, 0xff, 0xc9,
	0x92, 0xaf, 0x18, 0xe3, 0x25, 0x5f, 0x51, 0xad, 0x8f, 0x60, 0x6d, 0xa2, 0xa1, 0x3c, 0xab, 0xef,
	0xd6, 0x4f, 0x0d, 0x40, 0x93, 0x3d, 0xd9, 0x99, 0x43, 0x99, 0xf3, 0xb9, 0x34, 0xee, 0xf3, 0x26,
	0xcc, 0x1c, 0x6f, 0x45, 0x66, 0x4b, 0x6a, 0x7c, 0x39, 0xd5, 0xf8, 0xd1, 0xa0, 0x43, 0x58, 0x40,
	0x38, 0x89, 0x6c, 0x12, 0xd1, 0x01, 0x73, 0x48, 0xa4, 0x16, 0xfb, 0x78, 0x2b, 0x52, 0x16, 0x4e,
	0x74, 0x80, 0xe7, 0xc9, 0xc2, 0xdf, 0x18, 0x70, 0xf5, 0xa4, 0x2a, 0x78, 0x9e, 0x6c, 0xfd, 0x99,
	0x01, 0x17, 0x0b, 0x1a, 0xcb, 0xf3, 0x64, 0xe2, 0x2f, 0x0c, 0xb8, 0x54, 0xdc, 0xf9, 0x9d, 0x27,
	0x2b, 0x7f, 0x6e, 0xc0, 0x7a, 0x51, 0x6b, 0x76, 0x9e, 0x6c, 0xfc, 0xa5, 0x01, 0xe6, 0xb4, 0xfe,
	0xef, 0xbc, 0xad, 0x78, 0x71, 0x8b, 0x79, 0xde, 0x52, 0xa7, 0xa0, 0xeb, 0x3b, 0x4f, 0x26, 0xfe,
	0xda, 0x80, 0x2b, 0x27, 0xf4, 0x1f, 0xe7, 0xc9, 0xd4, 0x5f, 0x19, 0x50, 0xdd, 0xf9, 0x9f, 0xb0,
	0xf4, 0x27, 0x06, 0xac, 0x8e, 0xf7, 0x21, 0xe7, 0xae, 0x12, 0x15, 0x74, 0x0c, 0xe7, 0xc9, 0xc6,
	0xbf, 0x94, 0xe1, 0xf2, 0x14, 0x00, 0xda, 0x82, 0x32, 0x3e, 0x3a, 0xf2, 0x02, 0x8f, 0x8f, 0x12,
	0x3b, 0xd5, 0x2b, 0x47, 0x0d, 0x87, 0x5e, 0x4d, 0xb4, 0x3d, 0xb5, 0xe1, 0xad, 0xda, 0xb6, 0xc6,
	0xd8, 0x09, 0x5a, 0x74, 0x8d, 0x24, 0x18, 0x9a, 0xa5, 0x8d, 0x19, 0xd9, 0x35, 0x16, 0x08, 0xed,
	0x04, 0xc3, 0xa7, 0x98, 0xd9, 0x02, 0x86, 0x9e, 0x42, 0xb9, 0x17, 0xe2, 0x76, 0xe6, 0xc1, 0xe2,
	0x6e, 0x56, 0x24, 0xf3, 0xfa, 0x52, 0xd3, 0xaf, 0x2f, 0xb5, 0x87, 0x94, 0x79, 0xdf, 0xa1, 0x01,
	0xc7, 0x7e, 0x8b, 0xba, 0xdb, 0x1a, 0x40, 0x98, 0xea, 0xc7, 0x7a, 0x21, 0x96, 0xf6, 0xbf, 0x0e,
	0x6b, 0x5e, 0x5f, 0xfe, 0xc4, 0x39, 0xf0, 0xfd, 0xb6, 0xfe, 0x35, 0x67, 0x56, 0x86, 0x6d, 0x45,
	0x32, 0x5a, 0x03, 0xdf, 0x57, 0x67, 0x2e, 0xfa, 0x18, 0x2a, 0xf2, 0x9e, 0x1d, 0x11, 0x5f, 0x5d,
	0xa7, 0xe6, 0xa4, 0xed, 0x9b, 0x5f, 0x1a, 0x46, 0x79, 0x05, 0x3f, 0xd0, 0x52, 0x3b, 0x01, 0x67,
	0x23, 0xfb, 0x42, 0x90, 0x21, 0xa1, 0x27, 0xf0, 0x42, 0x48, 0xdd, 0xb6, 0xeb, 0x45, 0x6c, 0x10,
	0x8a, 0x3b, 0x60, 0xbb, 0x33, 0x70, 0xbb, 0x84, 0xcb, 0xb7, 0x91, 0xdc, 0x42, 0xb5, 0xa8, 0x7b,
	0x3f, 0x41, 0xdd, 0x93, 0x20, 0xe9, 0xd0, 0xc5, 0x70, 0x92, 0x81, 0xbe, 0x05, 0x2b, 0x42, 0x2d,
	0x0e, 0x02, 0xca, 0xb1, 0xa0, 0x47, 0xe6, 0x82, 0x34, 0xf9, 0xad, 0x2f, 0x37, 0x59, 0xc4, 0x2c,
	0x95, 0x53, 0x46, 0x2f, 0x87, 0x39, 0x22, 0xaa, 0xc1, 0xc5, 0x90, 0x79, 0x94, 0x79, 0x7c, 0xd4,
	0x76, 0x7c, 0x1c, 0x45, 0xf2, 0xc9, 0xc5, 0x2c, 0xcb, 0xf0, 0xad, 0xc5, 0xac, 0x86, 0xe0, 0x34,
	0x71, 0x9f, 0xa0, 0x6d, 0x58, 0x61, 0x04, 0xbb, 0x5e, 0x20, 0x2e, 0x4d, 0x21, 0xa3, 0x1d, 0x62,
	0x2e, 0x8e, 0xff, 0xda, 0x6e, 0xc7, 0x80, 0x96, 0xe0, 0xdb, 0xcb, 0x2c, 0xf7, 0x8d, 0x5e, 0x81,
	0x0a, 0x23, 0xa1, 0xef, 0x39, 0xb8, 0xed, 0xd0, 0x41, 0xc0, 0x4d, 0xd8, 0x30, 0x6e, 0x56, 0xec,
	0x0b, 0x9a, 0xd8, 0x10, 0x34, 0x74, 0x0b, 0x16, 0x59, 0xec, 0x8c, 0xb9, 0x24, 0x67, 0xb8, 0x98,
	0x9d, 0x41, 0xb3, 0xec, 0x14, 0x85, 0xde, 0x81, 0x85, 0x88, 0xb0, 0xa1, 0xe7, 0x10, 0xf3, 0x82,
	0x7e, 0x0f, 0x2b, 0xd8, 0x91, 0x07, 0x0a, 0xa2, 0xb6, 0x90, 0xc6, 0x8b, 0x14, 0x88, 0x38, 0xc3,
	0x9c, 0x74, 0x47, 0x66, 0x65, 0x3c, 0x55, 0xef, 0x93, 0xd0, 0xa7, 0xa3, 0xbe, 0xc8, 0x6a, 0x8d,
	0xb1, 0x13, 0x34, 0xfa, 0x10, 0x96, 0x38, 0xf5, 0x09, 0xd3, 0x6b, 0xb3, 0x2c, 0xd7, 0xe6, 0x5a,
	0xd1, 0xc4, 0x87, 0x09, 0xcc, 0xce, 0x8a, 0xa0, 0x3b, 0x50, 0xa6, 0x43, 0xc2, 0x7c, 0x3c, 0x8a,
	0x4c, 0x57, 0x67, 0x52, 0x32, 0xf7, 0xf1, 0x56, 0xb4, 0xdf, 0x11, 0x2d, 0xed, 0xbe, 0x82, 0xd8,
	0x09, 0xb6, 0xfa, 0x01, 0xac, 0x4d, 0xec, 0x49, 0xb4, 0x0a, 0x33, 0xc7, 0x64, 0xa4, 0x6f, 0x3b,
	0x62, 0x88, 0xd6, 0x61, 0x4e, 0x3e, 0x3f, 0xe8, 0x42, 0xa2, 0x3e, 0xde, 0x2d, 0x6d, 0x19, 0xd5,
	0x6d, 0xd1, 0x89, 0x4e, 0xec, 0x90, 0xd3, 0xa8, 0xb0, 0xfe, 0x6e, 0xc0, 0xea, 0xb8, 0x89, 0xe8,
	0x3a, 0x2c, 0xe1, 0xd0, 0x6b, 0x0f, 0xf5, 0xdb, 0xa0, 0x31, 0xf1, 0x36, 0x18, 0xbf, 0x27, 0x96,
	0x32, 0xef, 0x89, 0x08, 0x66, 0xe5, 0xc6, 0x9b, 0x51, 0x34, 0x31, 0x46, 0xef, 0xc3, 0x42, 0x88,
	0xb9, 0xd3, 0x23, 0x91, 0x39, 0x2b, 0x03, 0xf3, 0xea, 0xf4, 0xc0, 0xd4, 0x5a, 0x98, 0xf7, 0x64,
	0x31, 0xb5, 0x63, 0xa1, 0x6a, 0x13, 0x16, 0x13, 0xaa, 0x98, 0x40, 0x3e, 0x81, 0x28, 0x73, 0xe4,
	0x18, 0xbd, 0x91, 0x75, 0x2c, 0xf7, 0x10, 0x2a, 0xca, 0x73, 0xfa, 0xf6, 0xa2, 0x50, 0xd6, 0x8f,
	0x66, 0xa0, 0x92, 0x7b, 0x21, 0x45, 0x77, 0x93, 0xa7, 0x54, 0x43, 0x1a, 0xf8, 0xca, 0x94, 0xa7,
	0xd4, 0x9a, 0xfa, 0xa3, 0x52, 0x50, 0x8b, 0x54, 0x7f, 0x6c, 0x40, 0x45, 0x87, 0x44, 0xab, 0x33,
	0x61, 0x21, 0x1f, 0xb5, 0xf8, 0x13, 0xdd, 0x49, 0x26, 0x12, 0xa6, 0x2e, 0x67, 0x2f, 0xab, 0x45,
	0x13, 0x25, 0x4f, 0xb7, 0x16, 0x5c, 0x50, 0x23, 0xf5, 0x9c, 0xa4, 0xc3, 0x9b, 0xa3, 0x89, 0xe5,
	0x25, 0x8c, 0x51, 0xa6, 0x6b, 0xa6, 0xfa, 0xa8, 0x7e, 0x1b, 0x96, 0x32, 0x46, 0x17, 0xec, 0x8a,
	0xbb, 0xf9, 0xe0, 0xbd, 0x36, 0xcd, 0xa2, 0x9c, 0x8b, 0xd9, 0xcd, 0xb3, 0x07, 0xf3, 0xda, 0xef,
	0x32, 0xcc, 0x36, 0xf7, 0x9b, 0x3b, 0xab, 0xff, 0x87, 0x2e, 0x40, 0xf9, 0x49, 0xeb, 0xfe, 0xf6,
	0xe1, 0x5e, 0x73, 0x77, 0xd5, 0x40, 0x4b, 0xb0, 0xf0, 0x70, 0x67, 0xfb, 0xd1, 0xe1, 0xc3, 0x4f,
	0x56, 0x4b, 0x68, 0x11, 0xe6, 0x76, 0x6c, 0x7b, 0xdf, 0x5e, 0x9d, 0x41, 0x2b, 0xb0, 0x64, 0xef,
	0x34, 0xf6, 0x9b, 0x8d, 0xbd, 0x47, 0x02, 0x38, 0x6b, 0x7d, 0x61, 0xc0, 0x62, 0x52, 0x13, 0xd0,
	0xdb, 0x30, 0xef, 0x7b, 0x7d, 0x8f, 0xc7, 0xab, 0x72, 0xbd, 0xa0, 0x70, 0xd4, 0x1e, 0x49, 0x84,
	0x5e, 0x11, 0x05, 0x47, 0xef, 0x41, 0x99, 0x91, 0xcf, 0x06, 0x24, 0xe2, 0x91, 0x3e, 0xd4, 0x5e,
	0x2e, 0x12, 0xb5, 0x35, 0x46, 0x09, 0x27, 0x22, 0xd5, 0x77, 0x60, 0x29, 0xa3, 0xf5, 0x54, 0xb9,
	0x78, 0x17, 0x2a, 0x39, 0xad, 0xa7, 0xca, 0xc2, 0x7f, 0x95, 0x60, 0x39, 0x5f, 0x73, 0xd1, 0x4d,
	0x98, 0x25, 0xcf, 0x88, 0xa3, 0xcf, 0xf3, 0xf5, 0xcc, 0xcf, 0x59, 0xcf, 0x88, 0xb3, 0x2d, 0x7f,
	0xa3, 0xb4, 0x25, 0x02, 0xdd, 0x82, 0x85, 0x1e, 0xe7, 0xe1, 0x2e, 0xe1, 0x93, 0x59, 0xf0, 0xf0,
	0xf0, 0xb0, 0xb5, 0x4b, 0xb8, 0xc6, 0xc7, 0x38, 0xf4, 0x36, 0x2c, 0x72, 0x27, 0x3c, 0xa0, 0xce,
	0x31, 0xe1, 0xfa, 0x24, 0xcf, 0xbc, 0xbb, 0x1f, 0x36, 0x5a, 0x8a, 0xa5, 0xc5, 0x52, 0x2c, 0x7a,
	0x13, 0x2e, 0x8a, 0xc6, 0xc1, 0xc3, 0xfe, 0x7d, 0xe2, 0xe3, 0xd1, 0x01, 0x71, 0x68, 0xe0, 0xaa,
	0x7f, 0x43, 0x98, 0xb3, 0x8b, 0x58, 0xe8, 0x06, 0x2c, 0x73, 0xaf, 0x4f, 0xe8, 0x80, 0xc7, 0xe0,
	0x39, 0x09, 0x1e, 0xa3, 0xa2, 0x57, 0xa1, 0x12, 0x12, 0xe6, 0x51, 0x37, 0x86, 0xcd, 0x4b, 0x58,
	0x9e, 0x88, 0x5e, 0x87, 0xd5, 0x68, 0xe0, 0x38, 0x24, 0x8a, 0x0e, 0x7b, 0x8c, 0x44, 0x3d, 0xea,
	0xbb, 0xe6, 0x82, 0x04, 0x4e, 0xd0, 0x05, 0xf6, 0x08, 0x7b, 0xfe, 0x80, 0x91, 0x14, 0x5b, 0x56,
	0xd8, 0x71, 0xba, 0x75, 0x03, 0x20, 0x8d, 0xab, 0xc8, 0x62, 0x87, 0xf6, 0xfb, 0x38, 0x70, 0xe5,
	0xfe, 0x5b, 0xb4, 0xe3, 0x4f, 0xeb, 0xf7, 0x06, 0x54, 0x72, 0x31, 0x2d, 0xac, 0x4a, 0xb7, 0x61,
	0x36, 0xa4, 0x2c, 0x5e, 0x8e, 0x6b, 0x13, 0x45, 0x69, 0x9f, 0xa9, 0xc4, 0x55, 0x5d, 0xa3, 0xc4,
	0x0a, 0x3d, 0x3d, 0x1a, 0xf1, 0xb8, 0x7c, 0x8a, 0x31, 0xba, 0x04, 0xf3, 0x91, 0xd3, 0x23, 0x7d,
	0xa2, 0x13, 0x5b, 0x7f, 0xa1, 0x3b, 0xb0, 0x24, 0x56, 0xf2, 0x21, 0xc1, 0x2e, 0x61, 0x91, 0xee,
	0x80, 0xd6, 0xf3, 0xab, 0xae, 0x98, 0x76, 0x16, 0x68, 0xdd, 0x01, 0x48, 0x59, 0x49, 0xc1, 0x36,
	0x32, 0x05, 0xbb, 0x70, 0x8b, 0x5a, 0x9f, 0xc0, 0xca, 0xd8, 0x9e, 0x48, 0x5c, 0x34, 0xce, 0xe0,
	0x62, 0x29, 0x75, 0xd1, 0xfa, 0x9d, 0x01, 0x97, 0xa7, 0xb4, 0x53, 0xa2, 0xf4, 0xf5, 0xbd, 0x60,
	0x7b, 0x88, 0x3d, 0x5f, 0xb4, 0xd5, 0x72, 0xae, 0x8a, 0x9d, 0xa3, 0xa1, 0x7d, 0x28, 0x27, 0x9d,
	0xa0, 0x0a, 0xf7, 0x66, 0xe6, 0xe8, 0x4e, 0xfe, 0xc1, 0xa7, 0x16, 0x1e, 0x77, 0x05, 0x21, 0xaa,
	0xf5, 0x09, 0xc7, 0xe2, 0x30, 0x7f, 0x84, 0x3b, 0xc4, 0x8f, 0x8f, 0x5e, 0x3b, 0x51, 0x22, 0xf6,
	0x6b, 0x1f, 0x3f, 0x7b, 0x12, 0xe0, 0x64, 0xda, 0x19, 0x39, 0xed, 0x18, 0xd5, 0xfa, 0x0c, 0xd0,
	0x64, 0x5b, 0x21, 0x5c, 0xe4, 0xa3, 0x30, 0x89, 0xa9, 0x18, 0xa3, 0x5d, 0xa8, 0x30, 0xea, 0x8b,
	0xae, 0xf8, 0x49, 0xe8, 0x62, 0x1e, 0x97, 0xdb, 0x6c, 0x61, 0xca, 0xb2, 0x53, 0xad, 0x76, 0x5e,
	0x4e, 0x5c, 0xa3, 0x2e, 0x4f, 0x81, 0xa2, 0x07, 0x13, 0x66, 0x3f, 0xdf, 0xca, 0x8c, 0x49, 0xa1,
	0x77, 0xa1, 0xdc, 0xc7, 0xcf, 0x0e, 0x06, 0xac, 0x4b, 0x9e, 0x73, 0xfb, 0x26, 0x78, 0xeb, 0x7d,
	0x00, 0x75, 0xa2, 0x3f, 0x26, 0x1c, 0x27, 0xdb, 0x6b, 0x2e, 0xb3, 0xbd, 0x72, 0xf7, 0xa2, 0xf9,
	0xb1, 0x7b, 0x91, 0x65, 0xc2, 0xa5, 0xe2, 0x7f, 0x9d, 0xb0, 0x56, 0xa0, 0x92, 0x3b, 0xcf, 0xad,
	0x4b, 0xb0, 0x5e, 0x64, 0x8c, 0xb5, 0x0e, 0x68, 0xf2, 0x5e, 0xd6, 0x99, 0x97, 0xff, 0x81, 0xb5,
	0xf9, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x78, 0x04, 0x2c, 0x12, 0x90, 0x26, 0x00, 0x00,
}
