package gorgonia

// Code generated by genapi, which is a API generation tool for Gorgonia. DO NOT EDIT.

// Abs performs a pointwise abs.
func Abs(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(absOpType, a), a) }

// Sign performs a pointwise sign.
func Sign(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(signOpType, a), a) }

// Ceil performs a pointwise ceil.
func Ceil(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(ceilOpType, a), a) }

// Floor performs a pointwise floor.
func Floor(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(floorOpType, a), a) }

// Sin performs a pointwise sin.
func Sin(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(sinOpType, a), a) }

// Cos performs a pointwise cos.
func Cos(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(cosOpType, a), a) }

// Exp performs a pointwise exp.
func Exp(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(expOpType, a), a) }

// Log performs a pointwise log.
func Log(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(lnOpType, a), a) }

// Log2 performs a pointwise log2.
func Log2(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(log2OpType, a), a) }

// Neg performs a pointwise neg.
func Neg(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(negOpType, a), a) }

// Square performs a pointwise square.
func Square(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(squareOpType, a), a) }

// Sqrt performs a pointwise sqrt.
func Sqrt(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(sqrtOpType, a), a) }

// Inverse performs a pointwise inverse.
func Inverse(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(inverseOpType, a), a) }

// InverseSqrt performs a pointwise inversesqrt.
func InverseSqrt(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(inverseSqrtOpType, a), a) }

// Cube performs a pointwise cube.
func Cube(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(cubeOpType, a), a) }

// Tanh performs a pointwise tanh.
func Tanh(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(tanhOpType, a), a) }

// Sigmoid performs a pointwise sigmoid.
func Sigmoid(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(sigmoidOpType, a), a) }

// Log1p performs a pointwise log1p.
func Log1p(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(log1pOpType, a), a) }

// Expm1 performs a pointwise expm1.
func Expm1(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(expm1OpType, a), a) }

// Softplus performs a pointwise softplus.
func Softplus(a *Node) (*Node, error) { return unaryOpNode(newElemUnaryOp(softplusOpType, a), a) }

// Add performs a pointwise add operation.
func Add(a, b *Node) (*Node, error) { return binOpNode(newElemBinOp(addOpType, a, b), a, b) }

// Sub performs a pointwise sub operation.
func Sub(a, b *Node) (*Node, error) { return binOpNode(newElemBinOp(subOpType, a, b), a, b) }

// HadamardProd performs a pointwise hadamardprod operation.
func HadamardProd(a, b *Node) (*Node, error) { return binOpNode(newElemBinOp(mulOpType, a, b), a, b) }

// HadamardDiv performs a pointwise hadamarddiv operation.
func HadamardDiv(a, b *Node) (*Node, error) { return binOpNode(newElemBinOp(divOpType, a, b), a, b) }

// Pow performs a pointwise pow operation.
func Pow(a, b *Node) (*Node, error) { return binOpNode(newElemBinOp(powOpType, a, b), a, b) }

// Lt performs a pointwise lt operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Lt(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(ltOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

// Gt performs a pointwise gt operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Gt(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(gtOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

// Lte performs a pointwise lte operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Lte(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(lteOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

// Gte performs a pointwise gte operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Gte(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(gteOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

// Eq performs a pointwise eq operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Eq(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(eqOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

// Ne performs a pointwise ne operation.
// retSame indicates if the data type of the return value should be the same as the input data type. It defaults to Bool otherwise.
func Ne(a, b *Node, retSame bool) (*Node, error) {
	op := newElemBinOp(neOpType, a, b)
	op.retSame = retSame
	return binOpNode(op, a, b)
}

//Add performs a add. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastAdd(a, b *Node, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Add(a2, b2)
}

//Sub performs a sub. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastSub(a, b *Node, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Sub(a2, b2)
}

//HadamardProd performs a hadamardprod. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastHadamardProd(a, b *Node, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return HadamardProd(a2, b2)
}

//HadamardDiv performs a hadamarddiv. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastHadamardDiv(a, b *Node, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return HadamardDiv(a2, b2)
}

//Pow performs a pow. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastPow(a, b *Node, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Pow(a2, b2)
}

//Lt performs a lt. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastLt(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Lt(a2, b2, retSame)
}

//Gt performs a gt. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastGt(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Gt(a2, b2, retSame)
}

//Lte performs a lte. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastLte(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Lte(a2, b2, retSame)
}

//Gte performs a gte. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastGte(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Gte(a2, b2, retSame)
}

//Eq performs a eq. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastEq(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Eq(a2, b2, retSame)
}

//Ne performs a ne. The operation is precomposed with a broadcast such that the shapes matches before operations commence.
func BroadcastNe(a, b *Node, retSame bool, leftPattern, rightPattern []byte) (*Node, error) {
	a2, b2, err := Broadcast(a, b, NewBroadcastPattern(leftPattern, rightPattern))
	if err != nil {
		return nil, err
	}
	return Ne(a2, b2, retSame)
}
