/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;

public final class IntVector
implements Cloneable {
    private int[] m_values;
    private int m_size;
    private static final int COPY_THRESHOLD = 10;

    public IntVector() {
        this(5);
    }

    public IntVector(int initCapacity) {
        this.m_values = new int[initCapacity];
    }

    public int get(int index) {
        if (index > this.m_size - 1) {
            throw new IndexOutOfBoundsException("get[" + index + "] on vector of size " + this.m_size);
        }
        return this.m_values[index];
    }

    public int[] values() {
        if (this.m_size == 0) {
            return IConstants.EMPTY_INT_ARRAY;
        }
        int size = this.m_size;
        int[] result = new int[size];
        if (size < 10) {
            for (int i = 0; i < size; ++i) {
                result[i] = this.m_values[i];
            }
        } else {
            System.arraycopy(this.m_values, 0, result, 0, size);
        }
        return result;
    }

    public int size() {
        return this.m_size;
    }

    public Object clone() {
        try {
            IntVector _clone = (IntVector)super.clone();
            if (this.m_size < 10) {
                int[] _clone_values = _clone.m_values = new int[this.m_values.length];
                for (int i = 0; i < this.m_size; ++i) {
                    _clone_values[i] = this.m_values[i];
                }
            } else {
                _clone.m_values = (int[])this.m_values.clone();
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer(super.toString() + ", size " + this.m_size + ": ");
        for (int i = 0; i < this.m_size; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.m_values[i]);
        }
        return s.toString();
    }

    public int set(int index, int value) {
        if (index > this.m_size - 1) {
            throw new IndexOutOfBoundsException("get[" + index + "] on vector of size " + this.m_size);
        }
        int current_value = this.m_values[index];
        this.m_values[index] = value;
        return current_value;
    }

    public void add(int value) {
        int capacity = this.m_values.length;
        if (capacity == this.m_size) {
            int[] values = new int[1 + (capacity << 1)];
            if (capacity < 10) {
                for (int i = 0; i < capacity; ++i) {
                    values[i] = this.m_values[i];
                }
            } else {
                System.arraycopy(this.m_values, 0, values, 0, capacity);
            }
            this.m_values = values;
        }
        this.m_values[this.m_size++] = value;
    }
}

