
/**
 * @file /magma/engine/config/global/keys.h
 *
 * @brief	A collection of keys that define access rules, default values and other parameters needed when loading the global configuration.
 */

#ifndef MAGMA_OPIONS_GLOBAL_KEYS_H
#define MAGMA_OPIONS_GLOBAL_KEYS_H

/* HIGH: Add support for collections and validators. Here's an example:
	{
		.store = (void *)&(magma.security.trusted),
		.norm.type = M_TYPE_COLLECTION,
		.norm.val.binary = false,
		.name = "magma.security.trusted",
		.description = "If enabled, the Magma daemon configuration will be dumped to the log file (or console) after being loaded.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
		.validator = "MIN:MAX"
		.validator = "OPT1|OPT2|OPT3"
	}, */


magma_keys_t magma_keys[] = {
	{
		.store = (void *)&(magma.system.domain),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.system.domain",
		.description = "The default domain name used for new user email registration and for user logins that don't specify a domain.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.storage.root),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.storage.root",
		.description = "The root portion of the storage server directory paths.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.storage.active),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.storage.default",
		.description = "The default server used by the legacy mail code base for storing new messages.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},

	{
		.store = (void *)&(magma.storage.tank),
		.norm.type = M_TYPE_NULLER,
		.norm.val.st = NULL,
		.name = "magma.storage.tank",
		.description = "The location used by the storage tanks.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.system.daemonize),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.system.daemonize",
		.description = "If enabled, the Magma daemon will fork a background process and release the console session.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.worker_threads),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 8,
		.name = "magma.system.worker_threads",
		.description = "The number of worker threads the system should spawn.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.network_buffer),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_CONNECTION_BUFFER_SIZE,
		.name = "magma.system.network_buffer",
		.description = "The size of the network connection buffer.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.impersonate_user),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.system.impersonate_user",
		.description = "If provided, the Magma daemon will run using the specified user.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.root_directory),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.system.root_directory",
		.description = "If a value is provided the Magma daemon will use this as the directory root.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.library.file),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = "magmad.so",
		.name = "magma.library.file",
		.description = "Specifies the location of the Magma shared library. By default this library is named magmad.so and stored in the same directory as the daemon executable.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	// QUESTION: What is the point of this?
	{
		.store = (void *)&(magma.library.unload),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.library.unload",
		.description = "If enabled, the Magma daemon will unload the magmad.so symbols at exit.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.core_dump_size_limit),
		.norm.type = M_TYPE_UINT64,
		.norm.val.u64 = 64ULL << 30,
		.name = "magma.log.core_dump_size_limit",
		.description = "Use this setting to adjust the core dump size limit from the default value of 64GB.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.secure.minimum_password_length),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 8,
		.name = "magma.secure.minimum_password_length",
		.description = "The minimum number of characters a valid password must contain. Any password less than this length will return an automatic error, without being processed.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.secure.salt),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.secure.salt",
		.description = "The string added to hash operations to improve security",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.secure.memory.enable),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.secure.memory.enable",
		.description = "If enabled, a pool of memory will allocated for secure storage. Data stored using the secure memory pool will never be written to disk.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.secure.memory.length),
		.norm.type = M_TYPE_UINT64,
		.norm.val.u64 = 32768,
		.name = "magma.secure.memory.length",
		.description = "The size of the secure memory pool.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cryptography.seed_length),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_CRYPTOGRAPHY_SEED_SIZE,
		.name = "magma.iface.cryptography.seed_length",
		.description = "The amount of data used to seed the random number generator.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cryptography.dhparams_rotate),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.iface.cryptography.dhparams_rotate",
		.description = "Controls whether fresh DH group parameters should be generated at launch and then periodically rotated.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cryptography.dhparams_large_keys),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.iface.cryptography.dhparams_large_keys",
		.description = "Controls whether the ephemeral DHE ciphersuites should use 2048 or 4096 bit session keys.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.secure.sessions),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.secure.sessions",
		.description = "The string used to encrypt session tokens.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.web.portal.safeguard),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.web.portal.safeguard",
		.description = "Control whether the portal security safe guard against insecure transports is enabled.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.web.tls_redirect),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.ns = NULL,
		.name = "magma.web.tls_redirect",
		.description = "Specifies an optional TLS hostname and/or port for redirecting secure-only web requests.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.allow_cross_domain),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.http.allow_cross_domain",
		.description = "Provide the necessary headers in response to OPTION requests to allow cross domain JSON-RPC requests.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.close),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.http.close",
		.description = "Automatically close HTTP connections after each request?",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.pages),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = MAGMA_RESOURCE_PAGES,
		.name = "magma.http.pages",
		.description = "The static web content directory.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.templates),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = MAGMA_RESOURCE_TEMPLATES,
		.name = "magma.http.templates",
		.description = "The web application template directory.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.fonts),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = MAGMA_RESOURCE_FONTS,
		.name = "magma.http.fonts",
		.description = "The web fonts directory.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.http.session_timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 86400,
		.name = "magma.http.session_timeout",
		.description = "The number of seconds until a session cookie expires.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.web.portal.indent),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.web.portal.indent",
		.description = "Should the portal JSON-RPC responses be formatted?",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.web.statistics),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.web.statistics",
		.description = "Controls whether or not the statistics page is enabled.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.web.registration),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.web.registration",
		.description = "Controls whether or not the new user registration page is enabled.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.admin.contact),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.ns = NULL,
		.name = "magma.admin.contact",
		.description = "Set a contact email address for the general web contact form.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.admin.abuse),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.ns = NULL,
		.name = "magma.admin.abuse",
		.description = "Set a contact email address for the web abuse contact form.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.output.file),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.output.file",
		.description = "Control whether log messages are sent to a file or the console.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.output.path),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = MAGMA_LOGS,
		.name = "magma.output.path",
		.description = "If log files are enabled, this will control where they are stored.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.content),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.content",
		.description = "Record the web content files loaded at launch.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.time),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.time",
		.description = "Record the local system time with every log entry.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.file),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.file",
		.description = "Record the source file with every log entry.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.function),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.function",
		.description = "Record the source function with every log entry.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.line),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.line",
		.description = "Record the source line number with every log entry.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.stack),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.stack",
		.description = "Record a stack trace with every log entry.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.config.output_config),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.config.output_config",
		.description = "If enabled, the Magma daemon configuration will be dumped to the log file (or console) after being loaded.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.config.output_resource_limits),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.config.output_resource_limits",
		.description = "If enabled, the Magma daemon output the system resource limits, along with any errors encountered while trying to increase them.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.http),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.http",
		.description = "Record the details of each HTTP request.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.log.imap),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.log.imap",
		.description = "Record the IMAP commands executed.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.database.host),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.iface.database.host",
		.description = "The IP or FQDN of your database host.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.iface.database.schema),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.iface.database.schema",
		.description = "The name of the database schema containing the tables required by the Magma daemon.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.iface.database.user),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.iface.database.user",
		.description = "The user account used by the Magma daemon to access the database.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.iface.database.password),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.iface.database.password",
		.description = "The password used by the Magma daemon to access the database.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.database.port),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 3306,
		.name = "magma.iface.database.port",
		.description = "The port used by the database server.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.database.socket_path),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.iface.database.socket_path",
		.description = "The path of the UNIX socket to be used by Magma for local database sessions.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.database.pool.connections),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 4,
		.name = "magma.iface.database.pool.connections",
		.description = "The size of the Magma daemon database connection pool.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.database.pool.timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 60,
		.name = "magma.iface.database.pool.timeout",
		.description = "The number of seconds the Magma daemon will wait for a free database connection before giving up.",
		.file = true,
		.database = false,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.spool),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = "/tmp/magma/",
		.name = "magma.spool",
		.description = "The directory used to hold temporary files.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.virus.available),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.iface.virus.available",
		.description = "Determines whether the anti-virus library is loaded.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.virus.signatures),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = MAGMA_RESOURCE_VIRUS,
		.name = "magma.iface.virus.signatures",
		.description = "The location of the anti-virus signatures.",
		.file = true,
		.database = true,
		.overwrite = false,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.enable_core_dumps),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = false,
		.name = "magma.system.enable_core_dumps",
		.description = "If enabled, fatal errors will leave behind a core dump for post-mortem analysis.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.increase_resource_limits),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.binary = true,
		.name = "magma.system.increase_resource_limits",
		.description = "If enabled, the Magma daemon will increase the system resource limits assigned to the daemon process.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.system.thread_stack_size),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_THREAD_STACK_SIZE,
		.name = "magma.system.thread_stack_size",
		.description = "The amount of memory allocated to hold the thread stacks.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.wrap_line_length),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_SMTP_LINE_WRAP_LENGTH,
		.name = "magma.smtp.wrap_line_length",
		.description = "When formatting email messages attempt to wrap lines longer than this length.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.recipient_limit),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_SMTP_RECIPIENT_LIMIT,
		.name = "magma.smtp.recipient_limit",
		.description = "The maximum number of recipients for an inbound/outbound message.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.relay_limit),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_SMTP_RELAY_LIMIT,
		.name = "magma.smtp.relay_limit",
		.description = "The number of SMTP relay hops allowed before assuming a message is stuck in a loop and discarding it.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.blacklists.domain),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.smtp.blacklist",
		.description = "The domain name used to query a realtime blacklist.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.message_length_limit),
		.norm.type = M_TYPE_UINT64,
		.norm.val.u64 = MAGMA_SMTP_MAX_MESSAGE_SIZE,
		.name = "magma.smtp.message_length_limit",
		.description = "The global size maximum for messages accepted via SMTP.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.address_length_limit),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_SMTP_MAX_ADDRESS_SIZE,
		.name = "magma.smtp.address_length_limit",
		.description = "The maximum size of a valid email address.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.helo_length_limit),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_SMTP_MAX_HELO_SIZE,
		.name = "magma.smtp.helo_length_limit",
		.description = "The maximum size of the hostname parameter provided with the HELO/EHLO command.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.smtp.bypass_addr),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.ns = NULL,
		.name = "magma.smtp.bypass_addr",
		.description = "Set a contact email address for the web abuse contact form.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.dkim.enabled),
		.norm.type = M_TYPE_BOOLEAN,
		.norm.val.ns = false,
		.name = "magma.dkim.enabled",
		.description = "Specifies whether dkim signing will be enabled.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.dkim.selector),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.dkim.selector",
		.description = "The name of the selector to be reported in the message signature.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.dkim.domain),
		.norm.type = M_TYPE_NULLER,
		.norm.val.ns = NULL,
		.name = "magma.dkim.domain",
		.description = "The domain doing the signing, and whose DNS will be queried by the verifier for key and policy data.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.dkim.key),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.dkim.key",
		.description = "The location of the PEM or DER-encoded DKIM private key.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.dime.key),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.dime.key",
		.description = "The location for the PEM encoded Dark Internet Mail Environment (DIME) Primary Organizational Key (POK).",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.dime.signet),
		.norm.type = M_TYPE_STRINGER,
		.norm.val.st = NULL,
		.name = "magma.dime.signet",
		.description = "The location for the PEM encoded Dark Internet Mail Environment (DIME) Organizational Signet.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = true
	},
	{
		.store = (void *)&(magma.iface.spf.pool.connections),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 4,
		.name = "magma.iface.spf.pool.connections",
		.description = "The size of the Magma daemon SPF request context pool.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.spf.pool.timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 60,
		.name = "magma.iface.spf.pool.timeout",
		.description = "The number of seconds the Magma daemon will wait for a free SPF request context before giving up.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cache.pool.connections),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 4,
		.name = "magma.iface.cache.pool.connections",
		.description = "The size of the Magma daemon cache connection pool.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cache.pool.timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 60,
		.name = "magma.iface.cache.pool.timeout",
		.description = "The number of seconds the Magma daemon will wait for a free cache connection before giving up.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cache.timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_CACHE_SOCKET_TIMEOUT,
		.name = "magma.iface.cache.timeout",
		.description = "The number of seconds to wait before a TCP send or receive operation times out.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.iface.cache.retry),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = MAGMA_CACHE_SERVER_RETRY,
		.name = "magma.iface.cache.retry",
		.description = "The number of seconds between dead caching server connection attempts.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
	{
		.store = (void *)&(magma.relay.timeout),
		.norm.type = M_TYPE_UINT32,
		.norm.val.u32 = 60,
		.name = "magma.relay.timeout",
		.description = "The network timeout used by mail relay network connections.",
		.file = true,
		.database = true,
		.overwrite = true,
		.set = false,
		.required = false
	},
};

#endif
