#include "magma.open.check.h"
#include "magma.open.symbols.h"
// Our macro for declaring external symbol binding points
void (*memcached_free_d)(memcached_st *ptr) = NULL;
const char * (*memcached_lib_version_d)(void) = NULL;
memcached_st * (*memcached_create_d)(memcached_st *ptr) = NULL;
memcached_return_t (*memcached_flush_d)(memcached_st *ptr, time_t expiration) = NULL;
const char * (*memcached_strerror_d)(const memcached_st *ptr, memcached_return_t rc) = NULL;
memcached_return_t (*memcached_behavior_set_d)(memcached_st *ptr, const memcached_behavior_t flag, uint64_t data) = NULL;
memcached_return_t (*memcached_delete_d)(memcached_st *ptr, const char *key, size_t key_length, time_t expiration) = NULL;
memcached_return_t (*memcached_server_add_with_weight_d)(memcached_st *ptr, const char *hostname, in_port_t port, uint32_t weight) = NULL;
memcached_return_t (*memcached_decrement_d)(memcached_st *ptr, const char *key, size_t key_length, uint32_t offset, uint64_t *value) = NULL;
memcached_return_t (*memcached_increment_d)(memcached_st *ptr, const char *key, size_t key_length, uint32_t offset, uint64_t *value) = NULL;
char * (*memcached_get_d)(memcached_st *ptr, const char *key, size_t key_length, size_t *value_length, uint32_t *flags, memcached_return_t *error) = NULL;
memcached_return_t (*memcached_add_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags) = NULL;
memcached_return_t (*memcached_set_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags) = NULL;
memcached_return_t (*memcached_append_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags) = NULL;
memcached_return_t (*memcached_prepend_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags) = NULL;
memcached_return_t (*memcached_replace_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags) = NULL;
memcached_return_t (*memcached_cas_d)(memcached_st *ptr, const char *key, size_t key_length, const char *value, size_t value_length, time_t expiration, uint32_t flags, uint64_t cas) = NULL;
memcached_return_t (*memcached_decrement_with_initial_d)(memcached_st *ptr, const char *key, size_t key_length, uint64_t offset, uint64_t initial, time_t expiration, uint64_t *value) = NULL;
memcached_return_t (*memcached_increment_with_initial_d)(memcached_st *ptr, const char *key, size_t key_length, uint64_t offset, uint64_t initial, time_t expiration, uint64_t *value) = NULL;
const char * (*BZ2_bzlibVersion_d)(void) = NULL;
int (*BZ2_bzBuffToBuffDecompress_d)(char *dest, unsigned int *destLen, char *source, unsigned int sourceLen, int small, int verbosity) = NULL;
int (*BZ2_bzBuffToBuffCompress_d)(char *dest, unsigned int *destLen, char *source, unsigned int sourceLen, int blockSize100k, int verbosity, int workFactor) = NULL;
void (*cl_shutdown_d)(void) = NULL;
const char * (*cl_retver_d)(void) = NULL;
cl_error_t (*cl_init_d)(unsigned int initoptions) = NULL;
const char * (*cl_strerror_d)(int clerror) = NULL;
struct cl_engine * (*cl_engine_new_d)(void) = NULL;
cl_error_t (*cl_statfree_d)(struct cl_stat *dbstat) = NULL;
cl_error_t (*cl_engine_free_d)(struct cl_engine *engine) = NULL;
cl_error_t (*cl_engine_compile_d)(struct cl_engine *engine) = NULL;
int (*cl_statchkdir_d)(const struct cl_stat *dbstat) = NULL;
cl_error_t (*cl_statinidir_d)(const char *dirname, struct cl_stat *dbstat) = NULL;
cl_error_t (*cl_countsigs_d)(const char *path, unsigned int countoptions, unsigned int *sigs) = NULL;
cl_error_t (*cl_engine_set_num_d)(struct cl_engine *engine, enum cl_engine_field field, long long num) = NULL;
cl_error_t (*cl_engine_set_str_d)(struct cl_engine *engine, enum cl_engine_field field, const char *str) = NULL;
cl_error_t (*cl_load_d)(const char *path, struct cl_engine *engine, unsigned int *signo, unsigned int dboptions) = NULL;
cl_error_t (*cl_scandesc_d)(int desc, const char *filename, const char **virname, unsigned long int *scanned, const struct cl_engine *engine, struct cl_scan_options *scanoptions) = NULL;
DKIM_STAT (*dkim_eoh_d)(DKIM *dkim) = NULL;
void (*dkim_close_d)(DKIM_LIB *lib) = NULL;
uint32_t (*dkim_libversion_d)(void) = NULL;
DKIM_STAT (*dkim_free_d)(DKIM *dkim) = NULL;
const char * (*dkim_geterror_d)(DKIM *dkim) = NULL;
DKIM_STAT (*dkim_eom_d)(DKIM *dkim, _Bool *testkey) = NULL;
const char * (*dkim_getresultstr_d)(DKIM_STAT result) = NULL;
DKIM_STAT (*dkim_body_d)(DKIM *dkim, u_char *buf, size_t len) = NULL;
DKIM_STAT (*dkim_header_d)(DKIM *dkim, u_char *hdr, size_t len) = NULL;
void (*dkim_mfree_d)(DKIM_LIB *libhandle, void *closure, void *ptr) = NULL;
DKIM_STAT (*dkim_chunk_d)(DKIM *dkim, unsigned char *chunkp, size_t len) = NULL;
DKIM_STAT (*dkim_getsighdrx_d)(DKIM *dkim, u_char *buf, size_t len, size_t initial) = NULL;
int (*dkim_test_dns_put_d)(DKIM *dkim, int class, int type, int prec, u_char *name, u_char *data) = NULL;
DKIM * (*dkim_verify_d)(DKIM_LIB *libhandle, const unsigned char *id, void *memclosure, DKIM_STAT *statp) = NULL;
DKIM_LIB * (*dkim_init_d)(void *(*mallocf)(void *closure, size_t nbytes), void (*freef)(void *closure, void *p)) = NULL;
DKIM * (*dkim_sign_d)(DKIM_LIB *libhandle, const unsigned char *id, void *memclosure, const dkim_sigkey_t secretkey, const unsigned char *selector, const unsigned char *domain, dkim_canon_t hdr_canon_alg, dkim_canon_t body_canon_alg, dkim_alg_t sign_alg,	off_t length, DKIM_STAT *statp) = NULL;
FT_Error (*FT_Done_FreeType_d)(FT_Library library) = NULL;
FT_Error (*FT_Init_FreeType_d)(FT_Library *alibrary) = NULL;
void (*FT_Library_Version_d)(FT_Library library, FT_Int *amajor, FT_Int *aminor, FT_Int *apatch) = NULL;
void (*gdFree_d)(void *m) = NULL;
const char * (*gdVersionString_d)(void) = NULL;
void (*gdImageDestroy_d)(gdImagePtr im) = NULL;
gdImagePtr (*gdImageCreate_d)(int sx, int sy) = NULL;
void * (*gdImageGifPtr_d)(gdImagePtr im, int *size) = NULL;
int (*gdImageColorResolve_d)(gdImagePtr im, int r, int g, int b) = NULL;
void * (*gdImageJpegPtr_d)(gdImagePtr im, int *size, int quality) = NULL;
void (*gdImageSetPixel_d)(gdImagePtr im, int x, int y, int color) = NULL;
char * (*gdImageStringFT_d)(gdImage * im, int *brect, int fg, char *fontlist, double ptsize, double angle, int x, int y, char *string) = NULL;
const char * (*jpeg_version_d)(void) = NULL;
const char * (*lzo_version_string_d)(void) = NULL;
int (*__lzo_init_v2_d)(unsigned, int, int, int, int, int, int, int, int, int) = NULL;
lzo_uint32 (*lzo_adler32_d)(lzo_uint32 _adler, const lzo_bytep _buf, lzo_uint _len) = NULL;
int (*lzo1x_1_compress_d)(const lzo_byte *src, lzo_uint src_len, lzo_byte *dst, lzo_uintp dst_len, lzo_voidp wrkmem) = NULL;
int (*lzo1x_decompress_safe_d)(const lzo_byte *src, lzo_uint src_len, lzo_byte *dst, lzo_uintp dst_len, lzo_voidp wrkmem) = NULL;
void (*mysql_server_end_d)(void) = NULL;
void (*mysql_thread_end_d)(void) = NULL;
int (*mysql_ping_d)(MYSQL *mysql) = NULL;
void (*mysql_close_d)(MYSQL *mysql) = NULL;
my_bool (*mysql_thread_init_d)(void) = NULL;
MYSQL * (*mysql_init_d)(MYSQL *mysql) = NULL;
unsigned int (*mysql_thread_safe_d)(void) = NULL;
int (*mysql_stmt_fetch_d)(MYSQL_STMT *stmt) = NULL;
my_bool (*mysql_stmt_close_d)(MYSQL_STMT *) = NULL;
unsigned int (*mysql_errno_d)(MYSQL *mysql) = NULL;
const char * (*mysql_error_d)(MYSQL *mysql) = NULL;
int (*mysql_stmt_execute_d)(MYSQL_STMT *stmt) = NULL;
my_bool (*mariadb_connection_d)(MYSQL *mysql) = NULL;
void (*mysql_free_result_d)(MYSQL_RES *result) = NULL;
my_bool (*mysql_stmt_reset_d)(MYSQL_STMT *stmt) = NULL;
my_ulonglong (*mysql_insert_id_d)(MYSQL *mysql) = NULL;
char * (*mysql_get_server_info_d)(MYSQL *mysql) = NULL;
unsigned long (*mysql_thread_id_d)(MYSQL *mysql) = NULL;
MYSQL_STMT * (*mysql_stmt_init_d)(MYSQL * mysql) = NULL;
const char * (*mysql_get_connector_info_d)(void) = NULL;
MYSQL_ROW (*mysql_fetch_row_d)(MYSQL_RES *result) = NULL;
unsigned long (*mysql_get_client_version_d)(void) = NULL;
MYSQL_RES * (*mysql_store_result_d)(MYSQL * mysql) = NULL;
int (*mysql_stmt_store_result_d)(MYSQL_STMT *stmt) = NULL;
my_ulonglong (*mysql_affected_rows_d)(MYSQL *mysql) = NULL;
my_ulonglong (*mysql_num_rows_d)(MYSQL_RES *result) = NULL;
unsigned int (*mysql_stmt_errno_d)(MYSQL_STMT *stmt) = NULL;
const char * (*mysql_stmt_error_d)(MYSQL_STMT * stmt) = NULL;
my_bool (*mysql_stmt_free_result_d)(MYSQL_STMT *stmt) = NULL;
unsigned int (*mysql_num_fields_d)(MYSQL_RES *result) = NULL;
my_ulonglong (*mysql_stmt_num_rows_d)(MYSQL_STMT *stmt) = NULL;
MYSQL_FIELD * (*mysql_fetch_field_d)(MYSQL_RES * result) = NULL;
const char * (*mysql_character_set_name_d)(MYSQL *mysql) = NULL;
my_ulonglong (*mysql_stmt_insert_id_d)(MYSQL_STMT *stmt) = NULL;
my_ulonglong (*mysql_stmt_affected_rows_d)(MYSQL_STMT *stmt) = NULL;
MYSQL_RES * (*mysql_stmt_result_metadata_d)(MYSQL_STMT * stmt) = NULL;
int (*mysql_server_init_d)(int argc, char **argv, char **groups) = NULL;
int (*mysql_set_character_set_d)(MYSQL *mysql, const char *csname) = NULL;
my_bool (*mysql_stmt_bind_param_d)(MYSQL_STMT *stmt, MYSQL_BIND *bind) = NULL;
my_bool (*mysql_stmt_bind_result_d)(MYSQL_STMT *stmt, MYSQL_BIND *bind) = NULL;
int (*mysql_options_d)(MYSQL *mysql, enum mysql_option option, const void *arg) = NULL;
int (*mysql_real_query_d)(MYSQL *mysql, const char *query, unsigned long length) = NULL;
int (*mysql_stmt_prepare_d)(MYSQL_STMT *stmt, const char *query, unsigned long length) = NULL;
unsigned long (*mysql_escape_string_d)(char *to, const char *from, unsigned long length) = NULL;
my_bool (*mysql_stmt_attr_set_d)(MYSQL_STMT *stmt, enum enum_stmt_attr_type attr_type, const void *attr) = NULL;
MYSQL * (*mysql_real_connect_d)(MYSQL * mysql, const char *name, const char *user, const char *passwd, const char *db, unsigned int port, const char *unix_socket, unsigned long client_flag) = NULL;
DH * (*DH_new_d)(void) = NULL;
char **SSL_version_str_d = NULL;
RSA * (*RSA_new_d)(void) = NULL;
void (*DH_free_d)(DH *dh) = NULL;
int (*BIO_free_d)(BIO *a) = NULL;
int (*RAND_status_d)(void) = NULL;
void (*RSA_free_d)(RSA *r) = NULL;
void (*EVP_cleanup_d)(void) = NULL;
void (*OBJ_cleanup_d)(void) = NULL;
void (*BN_free_d)(BIGNUM *a) = NULL;
void (*RAND_cleanup_d)(void) = NULL;
void (*SSL_free_d)(SSL *ssl) = NULL;
int (*SSL_accept_d)(SSL *ssl) = NULL;
void *(*sk_pop_d)(_STACK *st) = NULL;
BN_CTX * (*BN_CTX_new_d)(void) = NULL;
int (*SSL_connect_d)(SSL *ssl) = NULL;
EC_KEY * (*EC_KEY_new_d)(void) = NULL;
void (*CRYPTO_free_d) (void *) = NULL;
void (*ENGINE_cleanup_d)(void) = NULL;
int (*SHA1_Init_d)(SHA_CTX *c) = NULL;
void (*BIO_free_all_d)(BIO *a) = NULL;
int (*CRYPTO_num_locks_d)(void) = NULL;
int (*SSL_library_init_d)(void) = NULL;
int (*SSL_want_d)(const SSL *s) = NULL;
int (*SSL_shutdown_d)(SSL *ssl) = NULL;
void (*ERR_clear_error_d)(void) = NULL;
int (*sk_num_d)(const _STACK *) = NULL;
void (*BIO_sock_cleanup_d)(void) = NULL;
void (*ERR_free_strings_d)(void) = NULL;
SSL * (*SSL_new_d)(SSL_CTX * ctx) = NULL;
const EVP_MD * (*EVP_md4_d)(void) = NULL;
const EVP_MD * (*EVP_md5_d)(void) = NULL;
const EVP_MD * (*EVP_sha_d)(void) = NULL;
void (*COMP_zlib_cleanup_d)(void) = NULL;
int (*SSL_get_fd_d)(const SSL *s) = NULL;
int (*SSL_do_handshake_d)(SSL *s) = NULL;
void (*BN_CTX_free_d)(BN_CTX *ctx) = NULL;
const EVP_MD * (*EVP_sha1_d)(void) = NULL;
void (*EC_KEY_free_d)(EC_KEY *key) = NULL;
int (*SSL_get_rfd_d)(const SSL *s) = NULL;
EVP_PKEY * (*EVP_PKEY_new_d)(void) = NULL;
void (*BN_CTX_start_d)(BN_CTX *ctx) = NULL;
const char * (*OBJ_nid2sn_d)(int n) = NULL;
int (*SHA256_Init_d)(SHA256_CTX *c) = NULL;
int (*SHA512_Init_d)(SHA512_CTX *c) = NULL;
int (*SSL_set_fd_d)(SSL *s, int fd) = NULL;
const EVP_MD * (*EVP_sha224_d)(void) = NULL;
const EVP_MD * (*EVP_sha256_d)(void) = NULL;
const EVP_MD * (*EVP_sha384_d)(void) = NULL;
const EVP_MD * (*EVP_sha512_d)(void) = NULL;
void (*OBJ_NAME_cleanup_d)(int type) = NULL;
void (*SSL_CTX_free_d)(SSL_CTX *ctx) = NULL;
int (*SSL_pending_d)(const SSL *ssl) = NULL;
int (*BN_num_bits_d)(const BIGNUM *) = NULL;
int (*X509_get_ext_count_d) (X509 *x) = NULL;
RSA * (*RSAPublicKey_dup_d)(RSA *rsa) = NULL;
char * (*BN_bn2dec_d)(const BIGNUM *a) = NULL;
char * (*BN_bn2hex_d)(const BIGNUM *a) = NULL;
int (*EVP_MD_size_d)(const EVP_MD *md) = NULL;
unsigned long (*ERR_get_error_d)(void) = NULL;
void (*CONF_modules_unload_d)(int all) = NULL;
void (*HMAC_CTX_init_d)(HMAC_CTX *ctx) = NULL;
void (*SSL_load_error_strings_d)(void) = NULL;
int (*EVP_MD_type_d)(const EVP_MD *md) = NULL;
void (*ECDSA_SIG_free_d)(ECDSA_SIG *a) = NULL;
X509_STORE * (*X509_STORE_new_d)(void) = NULL;
void (*SSL_set_accept_state_d)(SSL *s) = NULL;
void (*SSL_set_connect_state_d)(SSL *s) = NULL;
unsigned long (*ERR_peek_error_d)(void) = NULL;
const EVP_MD * (*EVP_ripemd160_d)(void) = NULL;
const char * (*SSLeay_version_d)(int t) = NULL;
void (*ERR_load_crypto_strings_d)(void) = NULL;
void (*ERR_print_errors_fp_d)(FILE *fp) = NULL;
BIO * (*SSL_get_wbio_d)(const SSL * ssl) = NULL;
void (*EC_GROUP_free_d)(EC_GROUP *group) = NULL;
void (*EC_POINT_free_d)(EC_POINT *point) = NULL;
void (*X509_STORE_free_d)(X509_STORE *v) = NULL;
int (*SSL_get_read_ahead_d)(const SSL *s) = NULL;
int (*DH_check_d)(const DH *dh, int *ret) = NULL;
int (*EC_KEY_generate_key_d)(EC_KEY *key) = NULL;
void (*ASN1_STRING_TABLE_cleanup_d)(void) = NULL;
void (*HMAC_CTX_cleanup_d)(HMAC_CTX *ctx) = NULL;
int (*SSL_get_shutdown_d)(const SSL *ssl) = NULL;
void * (*sk_value_d)(const _STACK *, int) = NULL;
void (*CRYPTO_cleanup_all_ex_data_d)(void) = NULL;
void (*EVP_MD_CTX_init_d)(EVP_MD_CTX *ctx) = NULL;
OCSP_REQUEST * (*OCSP_REQUEST_new_d)(void) = NULL;
int (*EC_KEY_check_key_d)(const EC_KEY *key) = NULL;
int (*EVP_MD_CTX_cleanup_d)(EVP_MD_CTX *ctx) = NULL;
void (*OCSP_REQUEST_free_d)(OCSP_REQUEST *a) = NULL;
const EVP_CIPHER * (*EVP_aes_256_gcm_d)(void) = NULL;
const EVP_CIPHER * (*EVP_aes_256_cbc_d)(void) = NULL;
int (*SSL_peek_d)(SSL *ssl,void *buf,int num) = NULL;
void (*SSL_set_read_ahead_d)(SSL *s, int yes) = NULL;
EVP_CIPHER_CTX * (*EVP_CIPHER_CTX_new_d)(void) = NULL;
int (*X509_verify_cert_d)(X509_STORE_CTX *ctx) = NULL;
void (*EC_GROUP_clear_free_d)(EC_GROUP *group) = NULL;
void (*OCSP_RESPONSE_free_d)(OCSP_RESPONSE *a) = NULL;
X509_STORE_CTX * (*X509_STORE_CTX_new_d)(void) = NULL;
X509_NAME * (*X509_get_subject_name_d)(X509 *a) = NULL;
EC_KEY * (*EC_KEY_new_by_curve_name_d)(int nid) = NULL;
int (*BN_hex2bn_d)(BIGNUM **a, const char *str) = NULL;
int (*SSL_read_d)(SSL *ssl, void *buf, int num) = NULL;
int (*i2d_X509_d)(X509 *a, unsigned char **out) = NULL;
const char * (*SSL_get_version_d)(const SSL *s) = NULL;
int (*RAND_bytes_d)(unsigned char *buf, int num) = NULL;
void (*EVP_CIPHER_CTX_init_d)(EVP_CIPHER_CTX *a) = NULL;
void (*OCSP_BASICRESP_free_d)(OCSP_BASICRESP *a) = NULL;
void (*EVP_CIPHER_CTX_free_d)(EVP_CIPHER_CTX *a) = NULL;
X509_LOOKUP_METHOD * (*X509_LOOKUP_file_d)(void) = NULL;
int (*BN_cmp_d)(const BIGNUM *a, const BIGNUM *b) = NULL;
const SSL_METHOD * (*TLSv1_server_method_d)(void) = NULL;
int (*EVP_CIPHER_nid_d)(const EVP_CIPHER *cipher) = NULL;
void (*OPENSSL_add_all_algorithms_noconf_d)(void) = NULL;
int (*SSL_get_error_d)(const SSL *s,int ret_code) = NULL;
const SSL_METHOD * (*SSLv23_client_method_d)(void) = NULL;
const SSL_METHOD * (*SSLv23_server_method_d)(void) = NULL;
X509 * (*SSL_get_peer_certificate_d)(const SSL *s) = NULL;
int (*EVP_CIPHER_CTX_cleanup_d)(EVP_CIPHER_CTX *a) = NULL;
const char * (*OCSP_response_status_str_d)(long s) = NULL;
int (*OCSP_response_status_d)(OCSP_RESPONSE *resp) = NULL;
int (*SHA1_Final_d)(unsigned char *md, SHA_CTX *c) = NULL;
void (*X509_STORE_CTX_free_d)(X509_STORE_CTX *ctx) = NULL;
BIO * (*BIO_new_socket_d)(int sock, int close_flag) = NULL;
EC_GROUP * (*EC_GROUP_new_by_curve_name_d)(int nid) = NULL;
EC_POINT * (*EC_POINT_new_d)(const EC_GROUP *group) = NULL;
int (*BN_bn2bin_d)(const BIGNUM *, unsigned char *) = NULL;
BIO * (*BIO_new_fp_d)(FILE *stream, int close_flag) = NULL;
X509_EXTENSION * (*X509_get_ext_d) (X509 *x, int loc) = NULL;
SSL_CTX * (*SSL_CTX_new_d)(const SSL_METHOD * method) = NULL;
void (*SSL_set_bio_d)(SSL *ssl, BIO *rbio, BIO *wbio) = NULL;
unsigned char * (*ASN1_STRING_data_d)(ASN1_STRING *x) = NULL;
int (*BN_bn2mpi_d)(const BIGNUM *a, unsigned char *to) = NULL;
int (*SSL_CTX_check_private_key_d)(const SSL_CTX *ctx) = NULL;
int (*SSL_write_d)(SSL *ssl, const void *buf, int num) = NULL;
void (*sk_pop_free_d)(_STACK *st, void(*func)(void *)) = NULL;
int (*X509_STORE_CTX_get_error_d)(X509_STORE_CTX *ctx) = NULL;
int (*EVP_CIPHER_iv_length_d)(const EVP_CIPHER *cipher) = NULL;
const char * (*X509_verify_cert_error_string_d)(long n) = NULL;
int (*SHA256_Final_d)(unsigned char *md, SHA256_CTX *c) = NULL;
int (*SHA512_Final_d)(unsigned char *md, SHA512_CTX *c) = NULL;
int (*X509_check_issued_d)(X509 *issuer, X509 *subject) = NULL;
int (*EVP_CIPHER_block_size_d)(const EVP_CIPHER *cipher) = NULL;
int (*EVP_CIPHER_key_length_d)(const EVP_CIPHER *cipher) = NULL;
const EC_GROUP * (*EC_KEY_get0_group_d)(const EC_KEY *key) = NULL;
const EVP_MD * (*EVP_get_digestbyname_d)(const char *name) = NULL;
long (*SSL_ctrl_d)(SSL *s, int cmd, long larg, void *parg) = NULL;
int (*i2o_ECPublicKey_d)(EC_KEY *key, unsigned char **out) = NULL;
int (*SSL_CTX_set_cipher_list_d)(SSL_CTX *,const char *str) = NULL;
int (*i2d_ECPrivateKey_d)(EC_KEY *key, unsigned char **out) = NULL;
const SSL_CIPHER * (*SSL_get_current_cipher_d)(const SSL *s) = NULL;
char * (*SSL_CIPHER_get_version_d)(const SSL_CIPHER *cipher) = NULL;
int (*EVP_CIPHER_CTX_iv_length_d)(const EVP_CIPHER_CTX *ctx) = NULL;
int (*EVP_DigestInit_d)(EVP_MD_CTX *ctx, const EVP_MD *type) = NULL;
int (*X509_STORE_CTX_get_error_depth_d)(X509_STORE_CTX *ctx) = NULL;
int (*EC_KEY_set_group_d)(EC_KEY *key, const EC_GROUP *group) = NULL;
int (*EVP_CIPHER_CTX_block_size_d)(const EVP_CIPHER_CTX *ctx) = NULL;
int (*EVP_CIPHER_CTX_key_length_d)(const EVP_CIPHER_CTX *ctx) = NULL;
int (*RAND_load_file_d)(const char *filename, long max_bytes) = NULL;
void (*ERR_remove_thread_state_d)(const CRYPTO_THREADID *tid) = NULL;
unsigned long (*EVP_CIPHER_flags_d)(const EVP_CIPHER *cipher) = NULL;
int (*i2d_OCSP_CERTID_d)(OCSP_CERTID *a, unsigned char **out) = NULL;
struct stack_st_OPENSSL_STRING * (*X509_get1_ocsp_d)(X509 *x) = NULL;
void (*X509_email_free_d)(struct stack_st_OPENSSL_STRING *sk) = NULL;
const BIGNUM * (*EC_KEY_get0_private_key_d)(const EC_KEY *key) = NULL;
const EVP_CIPHER * (*EVP_get_cipherbyname_d)(const char *name) = NULL;
int (*EVP_PKEY_set1_RSA_d)(EVP_PKEY *pkey, struct rsa_st *key) = NULL;
int (*SHA1_Update_d)(SHA_CTX *c, const void *data, size_t len) = NULL;
const char * (*SSL_CIPHER_get_name_d)(const SSL_CIPHER *cipher) = NULL;
const EC_POINT * (*EC_KEY_get0_public_key_d)(const EC_KEY *key) = NULL;
int (*EC_GROUP_precompute_mult_d)(EC_GROUP *group, BN_CTX *ctx) = NULL;
int (*EC_KEY_set_private_key_d)(EC_KEY *key, const BIGNUM *prv) = NULL;
int (*EVP_CIPHER_CTX_set_padding_d)(EVP_CIPHER_CTX *c, int pad) = NULL;
long (*SSL_CTX_callback_ctrl_d)(SSL_CTX *, int, void (*)(void)) = NULL;
char * (*X509_NAME_oneline_d)(X509_NAME *a, char *buf, int len) = NULL;
size_t (*BUF_strlcat_d)(char *dst, const char *src, size_t siz) = NULL;
int (*OCSP_check_nonce_d)(OCSP_REQUEST *req, OCSP_BASICRESP *bs) = NULL;
STACK_OF(SSL_COMP) * (*SSL_COMP_get_compression_methods_d)(void) = NULL;
int (*BIO_vprintf_d)(BIO *bio, const char *format, va_list args) = NULL;
int (*EC_KEY_set_public_key_d)(EC_KEY *key, const EC_POINT *pub) = NULL;
ASN1_STRING * (*X509_NAME_ENTRY_get_data_d)(X509_NAME_ENTRY *ne) = NULL;
int (*i2d_ECDSA_SIG_d)(const ECDSA_SIG *sig, unsigned char **pp) = NULL;
X509 * (*X509_STORE_CTX_get_current_cert_d)(X509_STORE_CTX *ctx) = NULL;
int (*SSL_CIPHER_get_bits_d)(const SSL_CIPHER *c, int *alg_bits) = NULL;
int (*i2d_OCSP_RESPONSE_d)(OCSP_RESPONSE *a, unsigned char **out) = NULL;
struct stack_st_X509 * (*SSL_get_peer_cert_chain_d)(const SSL *s) = NULL;
unsigned long (*EVP_CIPHER_CTX_flags_d)(const EVP_CIPHER_CTX *ctx) = NULL;
OCSP_BASICRESP * (*OCSP_response_get1_basic_d)(OCSP_RESPONSE *resp) = NULL;
void (*CRYPTO_set_id_callback_d)(unsigned long(*id_function)(void)) = NULL;
int (*SHA256_Update_d)(SHA256_CTX *c, const void *data, size_t len) = NULL;
int (*SHA512_Update_d)(SHA512_CTX *c, const void *data, size_t len) = NULL;
int (*X509_STORE_set_flags_d)(X509_STORE *ctx, unsigned long flags) = NULL;
point_conversion_form_t (*EC_KEY_get_conv_form_d)(const EC_KEY *key) = NULL;
long (*SSL_CTX_ctrl_d)(SSL_CTX *ctx, int cmd, long larg, void *parg) = NULL;
void (*ERR_error_string_n_d)(unsigned long e, char *buf, size_t len) = NULL;
BIGNUM * (*ASN1_INTEGER_to_BN_d)(const ASN1_INTEGER *ai, BIGNUM *bn) = NULL;
X509_NAME_ENTRY * (*X509_NAME_get_entry_d)(X509_NAME *name, int loc) = NULL;
int (*OCSP_REQ_CTX_set1_req_d)(OCSP_REQ_CTX *rctx, OCSP_REQUEST *req) = NULL;
BIGNUM * (*BN_mpi2bn_d)(const unsigned char *s, int len, BIGNUM *ret) = NULL;
BIGNUM * (*BN_bin2bn_d)(const unsigned char *s, int len, BIGNUM *ret) = NULL;
int (*EVP_DigestUpdate_d)(EVP_MD_CTX *ctx, const void *d, size_t cnt) = NULL;
int (*OCSP_sendreq_nbio_d)(OCSP_RESPONSE **presp, OCSP_REQ_CTX *rctx) = NULL;
int (*HMAC_Final_d)(HMAC_CTX *ctx, unsigned char *md, unsigned int *len) = NULL;
int (*OCSP_REQUEST_print_d)(BIO *bp, OCSP_REQUEST *a, unsigned long flags) = NULL;
int (*HMAC_Update_d)(HMAC_CTX *ctx, const unsigned char *data, size_t len) = NULL;
int (*X509_NAME_get_index_by_NID_d)(X509_NAME *name, int nid, int lastpos) = NULL;
int (*SSL_CTX_use_certificate_chain_file_d)(SSL_CTX *ctx, const char *file) = NULL;
int (*ASN1_GENERALIZEDTIME_print_d)(BIO *fp, const ASN1_GENERALIZEDTIME *a) = NULL;
OCSP_ONEREQ * (*OCSP_request_add0_id_d)(OCSP_REQUEST *req, OCSP_CERTID *cid) = NULL;
void (*EC_KEY_set_conv_form_d)(EC_KEY *eckey, point_conversion_form_t cform) = NULL;
int (*OCSP_RESPONSE_print_d)(BIO *bp, OCSP_RESPONSE *o, unsigned long flags) = NULL;
int (*EVP_DigestFinal_d)(EVP_MD_CTX *ctx, unsigned char *md, unsigned int *s) = NULL;
int (*EVP_DigestInit_ex_d)(EVP_MD_CTX *ctx, const EVP_MD *type, ENGINE *impl) = NULL;
int (*SSL_CTX_use_PrivateKey_file_d)(SSL_CTX *ctx, const char *file, int type) = NULL;
X509_LOOKUP * (*X509_STORE_add_lookup_d)(X509_STORE *v, X509_LOOKUP_METHOD *m) = NULL;
int (*EVP_CIPHER_CTX_ctrl_d)(EVP_CIPHER_CTX *ctx, int type, int arg, void *ptr) = NULL;
int (*X509_NAME_get_text_by_NID_d)(X509_NAME *name, int nid, char *buf,int len) = NULL;
EC_KEY * (*o2i_ECPublicKey_d)(EC_KEY **key, const unsigned char **in, long len) = NULL;
int (*OCSP_request_add1_nonce_d)(OCSP_REQUEST *req, unsigned char *val, int len) = NULL;
int (*EVP_DigestFinal_ex_d)(EVP_MD_CTX *ctx, unsigned char *md, unsigned int *s) = NULL;
int (*EVP_EncryptFinal_ex_d)(EVP_CIPHER_CTX *ctx, unsigned char *out, int *outl) = NULL;
EC_KEY * (*d2i_ECPrivateKey_d)(EC_KEY **key, const unsigned char **in, long len) = NULL;
unsigned char * (*SHA512_d)(const unsigned char *d, size_t n, unsigned char *md) = NULL;
int (*EVP_DecryptFinal_ex_d)(EVP_CIPHER_CTX *ctx, unsigned char *outm, int *outl) = NULL;
void (*EC_GROUP_set_point_conversion_form_d)(EC_GROUP *, point_conversion_form_t) = NULL;
void (*ED25519_keypair_d)(uint8_t out_public_key[32], uint8_t out_private_key[64]) = NULL;
void (*ERR_put_error_d)(int lib, int func, int reason, const char *file, int line) = NULL;
OCSP_CERTID * (*OCSP_cert_to_id_d)(const EVP_MD *dgst, X509 *subject, X509 *issuer) = NULL;
ECDSA_SIG * (*d2i_ECDSA_SIG_d)(ECDSA_SIG **sig, const unsigned char **pp, long len) = NULL;
int (*DH_generate_parameters_ex_d)(DH *dh, int prime_len,int generator, BN_GENCB *cb) = NULL;
ECDSA_SIG * (*ECDSA_do_sign_d)(const unsigned char *dgst, int dgst_len, EC_KEY *eckey) = NULL;
int (*X509_STORE_load_locations_d)(X509_STORE *ctx, const char *file, const char *path) = NULL;
void (*SSL_CTX_set_verify_d)(SSL_CTX *ctx, int mode, int (*cb) (int, X509_STORE_CTX *)) = NULL;
EC_POINT * (*EC_POINT_hex2point_d)(const EC_GROUP *, const char *, EC_POINT *, BN_CTX *) = NULL;
int (*CRYPTO_set_locked_mem_functions_d)(void *(*m) (size_t), void (*free_func) (void *)) = NULL;
int (*OCSP_REQ_CTX_add1_header_d)(OCSP_REQ_CTX *rctx, const char *name, const char *value) = NULL;
void (*X509_STORE_CTX_set_chain_d)(struct x509_store_ctx_st *ctx, struct stack_st_X509 *sk) = NULL;
int (*SSL_CTX_load_verify_locations_d)(SSL_CTX *ctx, const char *CAfile, const char *CApath) = NULL;
OCSP_RESPONSE * (*d2i_OCSP_RESPONSE_d)(OCSP_RESPONSE **a, const unsigned char **in, long len) = NULL;
int (*OCSP_parse_url_d)(const char *url, char **phost, char **pport, char **ppath, int *pssl) = NULL;
int (*HMAC_Init_ex_d)(HMAC_CTX *ctx, const void *key, int len, const EVP_MD *md, ENGINE *impl) = NULL;
OCSP_REQ_CTX * (*OCSP_sendreq_new_d)(BIO *io, const char *path, OCSP_REQUEST *req, int maxline) = NULL;
int (*EC_POINT_cmp_d)(const EC_GROUP *group, const EC_POINT *a, const EC_POINT *b, BN_CTX *ctx) = NULL;
void (*SSL_CTX_set_tmp_dh_callback_d)(SSL_CTX *ctx, DH *(*dh)(SSL *ssl,int is_export, int keylength))  = NULL;
int (*ECDSA_do_verify_d)(const unsigned char *dgst, int dgst_len, const ECDSA_SIG *sig, EC_KEY *eckey) = NULL;
int (*X509_check_host_d)(X509 *x, const char *chk, size_t chklen, unsigned int flags, char **peername) = NULL;
int (*CRYPTO_set_mem_functions_d)(void *(*m) (size_t), void *(*r) (void *, size_t), void (*f) (void *)) = NULL;
int (*X509_STORE_CTX_init_d)(X509_STORE_CTX *ctx, X509_STORE *store, X509 *x509, STACK_OF(X509) *chain) = NULL;
unsigned long (*ERR_peek_error_line_data_d)(const char **file, int *line, const char **data, int *flags) = NULL;
char * (*EC_POINT_point2hex_d)(const EC_GROUP *, const EC_POINT *, point_conversion_form_t form, BN_CTX *) = NULL;
int (*OCSP_basic_verify_d)(OCSP_BASICRESP *bs, STACK_OF(X509) *certs, X509_STORE *st, unsigned long flags) = NULL;
void (*CRYPTO_set_locking_callback_d)(void(*locking_function)(int mode, int n, const char *file, int line)) = NULL;
int (*EVP_VerifyFinal_d)(EVP_MD_CTX *ctx, const unsigned char *sigbuf, unsigned int siglen, EVP_PKEY *pkey) = NULL;
void (*SSL_CTX_set_tmp_ecdh_callback_d)(SSL_CTX *ctx, EC_KEY *(*ecdh)(SSL *ssl,int is_export, int keylength)) = NULL;
int (*EVP_DecryptUpdate_d)(EVP_CIPHER_CTX *ctx, unsigned char *out, int *outl, const unsigned char *in, int inl) = NULL;
int (*EVP_EncryptUpdate_d)(EVP_CIPHER_CTX *ctx, unsigned char *out, int *outl, const unsigned char *in, int inl) = NULL;
int (*OCSP_check_validity_d)(ASN1_GENERALIZEDTIME *thisupd, ASN1_GENERALIZEDTIME *nextupd, long sec, long maxsec) = NULL;
int (*ED25519_sign_d)(uint8_t *out_sig, const uint8_t *message, size_t message_len, const uint8_t private_key[64]) = NULL;
int (*EC_POINT_oct2point_d)(const EC_GROUP *group, EC_POINT *p, const unsigned char *buf, size_t len, BN_CTX *ctx) = NULL;
void (*ED25519_keypair_from_seed_d)(uint8_t out_public_key[32], uint8_t out_private_key[64], const uint8_t seed[32]) = NULL;
int (*EVP_Digest_d)(const void *data, size_t count, unsigned char *md, unsigned int *size, const EVP_MD *type, ENGINE *impl) = NULL;
int (*ED25519_verify_d)(const uint8_t *message, size_t message_len, const uint8_t signature[64], const uint8_t public_key[32]) = NULL;
int (*EVP_DecryptInit_ex_d)(EVP_CIPHER_CTX *ctx, const EVP_CIPHER *cipher, ENGINE *impl, const unsigned char *key, const unsigned char *iv) = NULL;
int (*EVP_EncryptInit_ex_d)(EVP_CIPHER_CTX *ctx, const EVP_CIPHER *cipher, ENGINE *impl, const unsigned char *key, const unsigned char *iv) = NULL;
int (*EC_POINT_mul_d)(const EC_GROUP *group, EC_POINT *r, const BIGNUM *g_scalar, const EC_POINT *point, const BIGNUM *p_scalar, BN_CTX *ctx) = NULL;
size_t (*EC_POINT_point2oct_d)(const EC_GROUP *group, const EC_POINT *p, point_conversion_form_t form, unsigned char *buf, size_t len, BN_CTX *ctx) = NULL;
int (*ECDH_compute_key_d)(void *out, size_t outlen, const EC_POINT *pub_key, EC_KEY *ecdh, void *(*KDF)(const void *in, size_t inlen, void *out, size_t *outlen)) = NULL;
int (*OCSP_resp_find_status_d)(OCSP_BASICRESP *bs, OCSP_CERTID *id, int *status, int *reason, ASN1_GENERALIZEDTIME **revtime, ASN1_GENERALIZEDTIME **thisupd, ASN1_GENERALIZEDTIME **nextupd) = NULL;
png_uint_32 (*png_access_version_number_d)(void) = NULL;
void (*SPF_server_free_d)(SPF_server_t *sp) = NULL;
void (*SPF_request_free_d)(SPF_request_t *sr) = NULL;
void (*SPF_response_free_d)(SPF_response_t *rp) = NULL;
const char * (*SPF_strreason_d)(SPF_reason_t reason) = NULL;
const char * (*SPF_strresult_d)(SPF_result_t result) = NULL;
const char * (*SPF_strerror_d)(SPF_errcode_t spf_err) = NULL;
SPF_reason_t (*SPF_response_reason_d)(SPF_response_t *rp) = NULL;
SPF_result_t (*SPF_response_result_d)(SPF_response_t *rp) = NULL;
SPF_request_t * (*SPF_request_new_d)(SPF_server_t * spf_server) = NULL;
void (*SPF_get_lib_version_d)(int *major, int *minor, int *patch) = NULL;
int (*SPF_request_set_env_from_d)(SPF_request_t *sr, const char *from) = NULL;
SPF_server_t * (*SPF_server_new_d)(SPF_server_dnstype_t dnstype, int debug) = NULL;
SPF_errcode_t (*SPF_request_set_helo_dom_d)(SPF_request_t *sr, const char *dom) = NULL;
SPF_errcode_t	(*SPF_request_set_ipv4_d)(SPF_request_t *sr, struct in_addr addr) = NULL;
SPF_errcode_t	(*SPF_request_set_ipv6_d)(SPF_request_t *sr, struct in6_addr addr) = NULL;
SPF_dns_server_t * (*SPF_dns_zone_new_d)(SPF_dns_server_t *layer_below, const char *name, int debug) = NULL;
SPF_errcode_t (*SPF_request_query_mailfrom_d)(SPF_request_t *spf_request, SPF_response_t **spf_responsep) = NULL;
SPF_errcode_t (*SPF_dns_zone_add_str_d)(SPF_dns_server_t *spf_dns_server, const char *domain, ns_type rr_type, SPF_dns_stat_t herrno, const char *data) = NULL;
char **tcversion_d = NULL;
TCHDB * (*tchdbnew_d)(void) = NULL;
void (*tcfree_d)(void *ptr) = NULL;
void (*tchdbdel_d)(TCHDB *hdb) = NULL;
bool (*tchdbsync_d)(TCHDB *hdb) = NULL;
int (*tchdbecode_d)(TCHDB *hdb) = NULL;
void (*tcndbdel_d)(TCNDB *tree) = NULL;
bool (*tchdbclose_d)(TCHDB *hdb) = NULL;
void (*tclistdel_d)(TCLIST *list) = NULL;
TCNDB * (*tcndbdup_d)(TCNDB *ndb) = NULL;
void (*tctreeclear_d)(TCTREE *tree) = NULL;
bool (*tchdbsetmutex_d)(TCHDB *hdb) = NULL;
uint64_t (*tchdbfsiz_d)(TCHDB *hdb) = NULL;
uint64_t (*tchdbrnum_d)(TCHDB *hdb) = NULL;
uint64_t (*tcndbrnum_d)(TCNDB *ndb) = NULL;
void (*tcndbiterinit_d)(TCNDB *ndb) = NULL;
char * (*tcndbiternext2_d)(TCNDB *ndb) = NULL;
int (*tclistnum_d)(const TCLIST *list) = NULL;
const char * (*tchdberrmsg_d)(int ecode) = NULL;
const char * (*tchdbpath_d)(TCHDB * hdb) = NULL;
TCLIST * (*tctreekeys_d)(const TCTREE * tree) = NULL;
TCLIST * (*tctreevals_d)(const TCTREE * tree) = NULL;
TCNDB * (*tcndbnew2_d)(TCCMP cmp, void *cmpop) = NULL;
bool (*tchdbdefrag_d)(TCHDB *hdb, int64_t step) = NULL;
bool (*tchdbsetdfunit_d)(TCHDB *hdb, int32_t dfunit) = NULL;
bool (*tchdbout_d)(TCHDB *hdb, const void *kbuf, int ksiz) = NULL;
bool (*tcndbout_d)(TCNDB *ndb, const void *kbuf, int ksiz) = NULL;
bool (*tchdbopen_d)(TCHDB *hdb, const char *path, int omode) = NULL;
const void * (*tclistval_d)(const TCLIST * list, int index, int *sp) = NULL;
void * (*tchdbget_d)(TCHDB * hdb, const void *kbuf, int ksiz, int *sp) = NULL;
void * (*tcndbget3_d)(TCNDB *ndb, const void *kbuf, int ksiz, int *sp) = NULL;
void * (*tcndbget_d)(TCNDB * ndb, const void *kbuf, int ksiz, int *sp) = NULL;
TCLIST * (*tcndbfwmkeys_d)(TCNDB * ndb, const void *pbuf, int psiz, int max) = NULL;
bool (*tchdbtune_d)(TCHDB *hdb, int64_t bnum, int8_t apow, int8_t fpow, uint8_t opts) = NULL;
bool (*tchdboptimize_d)(TCHDB *hdb, int64_t bnum, int8_t apow, int8_t fpow, uint8_t opts) = NULL;
bool (*tcndbputkeep_d)(TCNDB *ndb, const void *kbuf, int ksiz, const void *vbuf, int vsiz) = NULL;
bool (*tchdbputasync_d)(TCHDB *hdb, const void *kbuf, int ksiz, const void *vbuf, int vsiz) = NULL;
json_t * (*json_null_d)(void) = NULL;
json_t * (*json_true_d)(void) = NULL;
json_t * (*json_array_d)(void) = NULL;
json_t * (*json_false_d)(void) = NULL;
json_t * (*json_object_d)(void) = NULL;
void (*json_decref_d)(json_t *json) = NULL;
void (*json_delete_d)(json_t *json) = NULL;
json_t * (*json_real_d)(double value) = NULL;
json_t * (*json_copy_d)(json_t *value) = NULL;
const char * (*jansson_version_d)(void) = NULL;
json_t * (*json_incref_d)(json_t *json) = NULL;
int (*json_array_clear_d)(json_t *array) = NULL;
int (*json_object_clear_d)(json_t *object) = NULL;
json_t * (*json_deep_copy_d)(json_t *value) = NULL;
json_t * (*json_integer_d)(json_int_t value) = NULL;
void * (*json_object_iter_d)(json_t *object) = NULL;
json_t * (*json_string_d)(const char *value) = NULL;
json_t * (*json_pack_d)(const char *fmt, ...) = NULL;
double (*json_real_value_d)(const json_t *real) = NULL;
size_t (*json_array_size_d)(const json_t *array) = NULL;
const char * (*json_type_string_d)(json_t *json) = NULL;
json_t * (*json_object_iter_value_d)(void *iter) = NULL;
double (*json_number_value_d)(const json_t *json) = NULL;
const char * (*json_object_iter_key_d)(void *iter) = NULL;
size_t (*json_object_size_d)(const json_t *object) = NULL;
int (*json_real_set_d)(json_t *real, double value) = NULL;
int (*json_equal_d)(json_t *value1, json_t *value2) = NULL;
json_t * (*json_string_nocheck_d)(const char *value) = NULL;
int (*json_array_remove_d)(json_t *array, size_t index) = NULL;
int (*json_array_append_d)(json_t *array, json_t *value) = NULL;
int (*json_array_extend_d)(json_t *array, json_t *other) = NULL;
char * (*json_dumps_d)(const json_t *json, size_t flags) = NULL;
int (*json_unpack_d)(json_t *root, const char *fmt, ...) = NULL;
json_int_t (*json_integer_value_d)(const json_t *integer) = NULL;
int (*json_object_del_d)(json_t *object, const char *key) = NULL;
const char * (*json_string_value_d)(const json_t *string) = NULL;
int (*json_object_update_d)(json_t *object, json_t *other) = NULL;
int (*json_string_set_d)(json_t *string, const char *value) = NULL;
int (*json_array_append_new_d)(json_t *array, json_t *value) = NULL;
int (*json_integer_set_d)(json_t *integer, json_int_t value) = NULL;
void * (*json_object_iter_next_d)(json_t *object, void *iter) = NULL;
json_t * (*json_array_get_d)(const json_t *array, size_t index) = NULL;
void * (*json_object_iter_at_d)(json_t *object, const char *key) = NULL;
int (*json_array_set_d)(json_t *array, size_t index, json_t *value) = NULL;
int (*json_dumpf_d)(const json_t *json, FILE *output, size_t flags) = NULL;
int (*json_string_set_nocheck_d)(json_t *string, const char *value) = NULL;
json_t * (*json_object_get_d)(const json_t *object, const char *key) = NULL;
int (*json_array_insert_d)(json_t *array, size_t index, json_t *value) = NULL;
int (*json_array_set_new_d)(json_t *array, size_t index, json_t *value) = NULL;
json_t * (*json_loadf_d)(FILE *input, size_t flags, json_error_t *error) = NULL;
int (*json_object_iter_set_d)(json_t *object, void *iter, json_t *value) = NULL;
int (*json_object_set_d)(json_t *object, const char *key, json_t *value) = NULL;
int (*json_array_insert_new_d)(json_t *array, size_t index, json_t *value) = NULL;
int (*json_dump_file_d)(const json_t *json, const char *path, size_t flags) = NULL;
int (*json_object_iter_set_new_d)(json_t *object, void *iter, json_t *value) = NULL;
int (*json_object_set_new_d)(json_t *object, const char *key, json_t *value) = NULL;
void (*json_set_alloc_funcs_d)(json_malloc_t malloc_fn, json_free_t free_fn) = NULL;
json_t * (*json_loads_d)(const char *input, size_t flags, json_error_t *error) = NULL;
int (*json_object_set_nocheck_d)(json_t *object, const char *key, json_t *value) = NULL;
json_t * (*json_load_file_d)(const char *path, size_t flags, json_error_t *error) = NULL;
json_t * (*json_pack_ex_d)(json_error_t *error, size_t flags, const char *fmt, ...) = NULL;
int (*json_object_set_new_nocheck_d)(json_t *object, const char *key, json_t *value) = NULL;
json_t * (*json_vpack_ex_d)(json_error_t *error, size_t flags, const char *fmt, va_list ap) = NULL;
int (*json_unpack_ex_d)(json_t *root, json_error_t *error, size_t flags, const char *fmt, ...) = NULL;
int (*json_vunpack_ex_d)(json_t *root, json_error_t *error, size_t flags, const char *fmt, va_list ap) = NULL;
const char * (*utf8proc_version_d)(void) = NULL;
const char * (*utf8proc_errmsg_d)(utf8proc_ssize_t errcode) = NULL;
const char * (*utf8proc_category_string_d)(utf8proc_int32_t c) = NULL;
utf8proc_category_t (*utf8proc_category_d)(utf8proc_int32_t c) = NULL;
const utf8proc_property_t * (*utf8proc_get_property_d)(utf8proc_int32_t uc) = NULL;
utf8proc_ssize_t (*utf8proc_iterate_d)(const utf8proc_uint8_t *str, utf8proc_ssize_t strlen, utf8proc_int32_t *codepoint_ref) = NULL;
char **xmlParserVersion_d = NULL;
void (*xmlInitParser_d)(void) = NULL;
void (*xmlMemoryDump_d)(void) = NULL;
void (*xmlCleanupParser_d)(void) = NULL;
void (*xmlCleanupGlobals_d)(void) = NULL;
void (*xmlFreeDoc_d)(xmlDocPtr doc) = NULL;
void (*xmlFreeNode_d)(xmlNodePtr cur) = NULL;
xmlBufferPtr (*xmlBufferCreate_d)(void) = NULL;
void (*xmlBufferFree_d)(xmlBufferPtr buf) = NULL;
xmlParserCtxtPtr (*xmlNewParserCtxt_d)(void) = NULL;
int (*xmlBufferLength_d)(const xmlBuffer *buf) = NULL;
void (*xmlFreeParserCtxt_d)(xmlParserCtxtPtr ctx) = NULL;
void (*xmlXPathFreeObject_d)(xmlXPathObjectPtr obj) = NULL;
void (*xmlXPathFreeContext_d)(xmlXPathContextPtr ctx) = NULL;
xmlXPathContextPtr (*xmlXPathNewContext_d)(xmlDocPtr doc) = NULL;
const xmlChar * (*xmlBufferContent_d)(const xmlBuffer *buf) = NULL;
xmlNodePtr (*xmlNewNode_d)(xmlNsPtr ns, const xmlChar *name) = NULL;
xmlNodePtr (*xmlAddSibling_d)(xmlNodePtr cur, xmlNodePtr elem) = NULL;
void (*xmlNodeSetContent_d)(xmlNodePtr cur, const xmlChar *content) = NULL;
int (*xmlNodeBufGetContent_d)(xmlBufferPtr buffer, const xmlNode *cur) = NULL;
xmlChar * (*xmlEncodeEntitiesReentrant_d)(xmlDocPtr doc, const xmlChar * input) = NULL;
void (*xmlDocDumpFormatMemory_d)(xmlDocPtr cur, xmlChar **mem, int *size, int format) = NULL;
xmlAttrPtr (*xmlSetProp_d)(xmlNodePtr node, const xmlChar *name, const xmlChar *value) = NULL;
xmlXPathObjectPtr (*xmlXPathEvalExpression_d)(const xmlChar *xpath, xmlXPathContextPtr ctx) = NULL;
int (*xmlXPathRegisterNs_d)(xmlXPathContextPtr ctxt, const xmlChar *prefix, const xmlChar *ns_uri) = NULL;
xmlDocPtr (*xmlCtxtReadMemory_d)(xmlParserCtxtPtr ctxt, const char *buffer, int size, const char *url, const char *encoding, int options) = NULL;
const char * (*zlibVersion_d)(void) = NULL;
uLong (*compressBound_d)(uLong sourceLen) = NULL;
int (*uncompress_d)(Bytef *dest, uLongf *destLen, const Bytef *source, uLong sourceLen) = NULL;
int (*compress2_d)(Bytef *dest, uLongf *destLen, const Bytef *source, uLong sourceLen, int level) = NULL;
const char * symbols_check_assign(void) {
memcached_free_d = &memcached_free;
memcached_lib_version_d = &memcached_lib_version;
memcached_create_d = &memcached_create;
memcached_flush_d = &memcached_flush;
memcached_strerror_d = &memcached_strerror;
memcached_behavior_set_d = &memcached_behavior_set;
memcached_delete_d = &memcached_delete;
memcached_server_add_with_weight_d = &memcached_server_add_with_weight;
memcached_decrement_d = &memcached_decrement;
memcached_increment_d = &memcached_increment;
memcached_get_d = &memcached_get;
memcached_add_d = &memcached_add;
memcached_set_d = &memcached_set;
memcached_append_d = &memcached_append;
memcached_prepend_d = &memcached_prepend;
memcached_replace_d = &memcached_replace;
memcached_cas_d = &memcached_cas;
memcached_decrement_with_initial_d = &memcached_decrement_with_initial;
memcached_increment_with_initial_d = &memcached_increment_with_initial;
BZ2_bzlibVersion_d = &BZ2_bzlibVersion;
BZ2_bzBuffToBuffDecompress_d = &BZ2_bzBuffToBuffDecompress;
BZ2_bzBuffToBuffCompress_d = &BZ2_bzBuffToBuffCompress;
cl_shutdown_d = &cl_shutdown;
cl_retver_d = &cl_retver;
cl_init_d = &cl_init;
cl_strerror_d = &cl_strerror;
cl_engine_new_d = &cl_engine_new;
cl_statfree_d = &cl_statfree;
cl_engine_free_d = &cl_engine_free;
cl_engine_compile_d = &cl_engine_compile;
cl_statchkdir_d = &cl_statchkdir;
cl_statinidir_d = &cl_statinidir;
cl_countsigs_d = &cl_countsigs;
cl_engine_set_num_d = &cl_engine_set_num;
cl_engine_set_str_d = &cl_engine_set_str;
cl_load_d = &cl_load;
cl_scandesc_d = &cl_scandesc;
dkim_eoh_d = &dkim_eoh;
dkim_close_d = &dkim_close;
dkim_libversion_d = &dkim_libversion;
dkim_free_d = &dkim_free;
dkim_geterror_d = &dkim_geterror;
dkim_eom_d = &dkim_eom;
dkim_getresultstr_d = &dkim_getresultstr;
dkim_body_d = &dkim_body;
dkim_header_d = &dkim_header;
dkim_mfree_d = &dkim_mfree;
dkim_chunk_d = &dkim_chunk;
dkim_getsighdrx_d = &dkim_getsighdr;
dkim_test_dns_put_d = &dkim_test_dns_put;
dkim_verify_d = &dkim_verify;
dkim_init_d = &dkim_init;
dkim_sign_d = &dkim_sign;
FT_Done_FreeType_d = &FT_Done_FreeType;
FT_Init_FreeType_d = &FT_Init_FreeType;
FT_Library_Version_d = &FT_Library_Version;
gdFree_d = &gdFree;
gdVersionString_d = &gdVersionString;
gdImageDestroy_d = &gdImageDestroy;
gdImageCreate_d = &gdImageCreate;
gdImageGifPtr_d = &gdImageGifPtr;
gdImageColorResolve_d = &gdImageColorResolve;
gdImageJpegPtr_d = &gdImageJpegPtr;
gdImageSetPixel_d = &gdImageSetPixel;
gdImageStringFT_d = &gdImageStringFT;
jpeg_version_d = &jpeg_version;
lzo_version_string_d = &lzo_version_string;
__lzo_init_v2_d = &__lzo_init_v2;
lzo_adler32_d = &lzo_adler32;
lzo1x_1_compress_d = &lzo1x_1_compress;
lzo1x_decompress_safe_d = &lzo1x_decompress_safe;
mysql_server_end_d = &mysql_server_end;
mysql_thread_end_d = &mysql_thread_end;
mysql_ping_d = &mysql_ping;
mysql_close_d = &mysql_close;
mysql_thread_init_d = &mysql_thread_init;
mysql_init_d = &mysql_init;
mysql_thread_safe_d = &mysql_thread_safe;
mysql_stmt_fetch_d = &mysql_stmt_fetch;
mysql_stmt_close_d = &mysql_stmt_close;
mysql_errno_d = &mysql_errno;
mysql_error_d = &mysql_error;
mysql_stmt_execute_d = &mysql_stmt_execute;
mariadb_connection_d = &mariadb_connection;
mysql_free_result_d = &mysql_free_result;
mysql_stmt_reset_d = &mysql_stmt_reset;
mysql_insert_id_d = &mysql_insert_id;
mysql_get_server_info_d = &mysql_get_server_info;
mysql_thread_id_d = &mysql_thread_id;
mysql_stmt_init_d = &mysql_stmt_init;
mysql_get_connector_info_d = &mysql_get_connector_info;
mysql_fetch_row_d = &mysql_fetch_row;
mysql_get_client_version_d = &mysql_get_client_version;
mysql_store_result_d = &mysql_store_result;
mysql_stmt_store_result_d = &mysql_stmt_store_result;
mysql_affected_rows_d = &mysql_affected_rows;
mysql_num_rows_d = &mysql_num_rows;
mysql_stmt_errno_d = &mysql_stmt_errno;
mysql_stmt_error_d = &mysql_stmt_error;
mysql_stmt_free_result_d = &mysql_stmt_free_result;
mysql_num_fields_d = &mysql_num_fields;
mysql_stmt_num_rows_d = &mysql_stmt_num_rows;
mysql_fetch_field_d = &mysql_fetch_field;
mysql_character_set_name_d = &mysql_character_set_name;
mysql_stmt_insert_id_d = &mysql_stmt_insert_id;
mysql_stmt_affected_rows_d = &mysql_stmt_affected_rows;
mysql_stmt_result_metadata_d = &mysql_stmt_result_metadata;
mysql_server_init_d = &mysql_server_init;
mysql_set_character_set_d = &mysql_set_character_set;
mysql_stmt_bind_param_d = &mysql_stmt_bind_param;
mysql_stmt_bind_result_d = &mysql_stmt_bind_result;
mysql_options_d = &mysql_options;
mysql_real_query_d = &mysql_real_query;
mysql_stmt_prepare_d = &mysql_stmt_prepare;
mysql_escape_string_d = &mysql_escape_string;
mysql_stmt_attr_set_d = &mysql_stmt_attr_set;
mysql_real_connect_d = &mysql_real_connect;
DH_new_d = &DH_new;
RSA_new_d = &RSA_new;
DH_free_d = &DH_free;
BIO_free_d = &BIO_free;
RAND_status_d = &RAND_status;
RSA_free_d = &RSA_free;
EVP_cleanup_d = &EVP_cleanup;
OBJ_cleanup_d = &OBJ_cleanup;
BN_free_d = &BN_free;
RAND_cleanup_d = &RAND_cleanup;
SSL_free_d = &SSL_free;
SSL_accept_d = &SSL_accept;
sk_pop_d = &sk_pop;
BN_CTX_new_d = &BN_CTX_new;
SSL_connect_d = &SSL_connect;
EC_KEY_new_d = &EC_KEY_new;
CRYPTO_free_d = &CRYPTO_free;
ENGINE_cleanup_d = &ENGINE_cleanup;
SHA1_Init_d = &SHA1_Init;
BIO_free_all_d = &BIO_free_all;
CRYPTO_num_locks_d = &CRYPTO_num_locks;
SSL_library_init_d = &SSL_library_init;
SSL_want_d = &SSL_want;
SSL_shutdown_d = &SSL_shutdown;
ERR_clear_error_d = &ERR_clear_error;
sk_num_d = &sk_num;
BIO_sock_cleanup_d = &BIO_sock_cleanup;
ERR_free_strings_d = &ERR_free_strings;
SSL_new_d = &SSL_new;
EVP_md4_d = &EVP_md4;
EVP_md5_d = &EVP_md5;
EVP_sha_d = &EVP_sha;
COMP_zlib_cleanup_d = &COMP_zlib_cleanup;
SSL_get_fd_d = &SSL_get_fd;
SSL_do_handshake_d = &SSL_do_handshake;
BN_CTX_free_d = &BN_CTX_free;
EVP_sha1_d = &EVP_sha1;
EC_KEY_free_d = &EC_KEY_free;
SSL_get_rfd_d = &SSL_get_rfd;
EVP_PKEY_new_d = &EVP_PKEY_new;
BN_CTX_start_d = &BN_CTX_start;
OBJ_nid2sn_d = &OBJ_nid2sn;
SHA256_Init_d = &SHA256_Init;
SHA512_Init_d = &SHA512_Init;
SSL_set_fd_d = &SSL_set_fd;
EVP_sha224_d = &EVP_sha224;
EVP_sha256_d = &EVP_sha256;
EVP_sha384_d = &EVP_sha384;
EVP_sha512_d = &EVP_sha512;
OBJ_NAME_cleanup_d = &OBJ_NAME_cleanup;
SSL_CTX_free_d = &SSL_CTX_free;
SSL_pending_d = &SSL_pending;
BN_num_bits_d = &BN_num_bits;
X509_get_ext_count_d = &X509_get_ext_count;
RSAPublicKey_dup_d = &RSAPublicKey_dup;
BN_bn2dec_d = &BN_bn2dec;
BN_bn2hex_d = &BN_bn2hex;
EVP_MD_size_d = &EVP_MD_size;
ERR_get_error_d = &ERR_get_error;
CONF_modules_unload_d = &CONF_modules_unload;
HMAC_CTX_init_d = &HMAC_CTX_init;
SSL_load_error_strings_d = &SSL_load_error_strings;
EVP_MD_type_d = &EVP_MD_type;
ECDSA_SIG_free_d = &ECDSA_SIG_free;
X509_STORE_new_d = &X509_STORE_new;
SSL_set_accept_state_d = &SSL_set_accept_state;
SSL_set_connect_state_d = &SSL_set_connect_state;
ERR_peek_error_d = &ERR_peek_error;
EVP_ripemd160_d = &EVP_ripemd160;
SSLeay_version_d = &SSLeay_version;
ERR_load_crypto_strings_d = &ERR_load_crypto_strings;
ERR_print_errors_fp_d = &ERR_print_errors_fp;
SSL_get_wbio_d = &SSL_get_wbio;
EC_GROUP_free_d = &EC_GROUP_free;
EC_POINT_free_d = &EC_POINT_free;
X509_STORE_free_d = &X509_STORE_free;
SSL_get_read_ahead_d = &SSL_get_read_ahead;
DH_check_d = &DH_check;
EC_KEY_generate_key_d = &EC_KEY_generate_key;
ASN1_STRING_TABLE_cleanup_d = &ASN1_STRING_TABLE_cleanup;
HMAC_CTX_cleanup_d = &HMAC_CTX_cleanup;
SSL_get_shutdown_d = &SSL_get_shutdown;
sk_value_d = &sk_value;
CRYPTO_cleanup_all_ex_data_d = &CRYPTO_cleanup_all_ex_data;
EVP_MD_CTX_init_d = &EVP_MD_CTX_init;
OCSP_REQUEST_new_d = &OCSP_REQUEST_new;
EC_KEY_check_key_d = &EC_KEY_check_key;
EVP_MD_CTX_cleanup_d = &EVP_MD_CTX_cleanup;
OCSP_REQUEST_free_d = &OCSP_REQUEST_free;
EVP_aes_256_gcm_d = &EVP_aes_256_gcm;
EVP_aes_256_cbc_d = &EVP_aes_256_cbc;
SSL_peek_d = &SSL_peek;
SSL_set_read_ahead_d = &SSL_set_read_ahead;
EVP_CIPHER_CTX_new_d = &EVP_CIPHER_CTX_new;
X509_verify_cert_d = &X509_verify_cert;
EC_GROUP_clear_free_d = &EC_GROUP_clear_free;
OCSP_RESPONSE_free_d = &OCSP_RESPONSE_free;
X509_STORE_CTX_new_d = &X509_STORE_CTX_new;
X509_get_subject_name_d = &X509_get_subject_name;
EC_KEY_new_by_curve_name_d = &EC_KEY_new_by_curve_name;
BN_hex2bn_d = &BN_hex2bn;
SSL_read_d = &SSL_read;
i2d_X509_d = &i2d_X509;
SSL_get_version_d = &SSL_get_version;
RAND_bytes_d = &RAND_bytes;
EVP_CIPHER_CTX_init_d = &EVP_CIPHER_CTX_init;
OCSP_BASICRESP_free_d = &OCSP_BASICRESP_free;
EVP_CIPHER_CTX_free_d = &EVP_CIPHER_CTX_free;
X509_LOOKUP_file_d = &X509_LOOKUP_file;
BN_cmp_d = &BN_cmp;
TLSv1_server_method_d = &TLSv1_server_method;
EVP_CIPHER_nid_d = &EVP_CIPHER_nid;
OPENSSL_add_all_algorithms_noconf_d = &OPENSSL_add_all_algorithms_noconf;
SSL_get_error_d = &SSL_get_error;
SSLv23_client_method_d = &SSLv23_client_method;
SSLv23_server_method_d = &SSLv23_server_method;
SSL_get_peer_certificate_d = &SSL_get_peer_certificate;
EVP_CIPHER_CTX_cleanup_d = &EVP_CIPHER_CTX_cleanup;
OCSP_response_status_str_d = &OCSP_response_status_str;
OCSP_response_status_d = &OCSP_response_status;
SHA1_Final_d = &SHA1_Final;
X509_STORE_CTX_free_d = &X509_STORE_CTX_free;
BIO_new_socket_d = &BIO_new_socket;
EC_GROUP_new_by_curve_name_d = &EC_GROUP_new_by_curve_name;
EC_POINT_new_d = &EC_POINT_new;
BN_bn2bin_d = &BN_bn2bin;
BIO_new_fp_d = &BIO_new_fp;
X509_get_ext_d = &X509_get_ext;
SSL_CTX_new_d = &SSL_CTX_new;
SSL_set_bio_d = &SSL_set_bio;
ASN1_STRING_data_d = &ASN1_STRING_data;
BN_bn2mpi_d = &BN_bn2mpi;
SSL_CTX_check_private_key_d = &SSL_CTX_check_private_key;
SSL_write_d = &SSL_write;
sk_pop_free_d = &sk_pop_free;
X509_STORE_CTX_get_error_d = &X509_STORE_CTX_get_error;
EVP_CIPHER_iv_length_d = &EVP_CIPHER_iv_length;
X509_verify_cert_error_string_d = &X509_verify_cert_error_string;
SHA256_Final_d = &SHA256_Final;
SHA512_Final_d = &SHA512_Final;
X509_check_issued_d = &X509_check_issued;
EVP_CIPHER_block_size_d = &EVP_CIPHER_block_size;
EVP_CIPHER_key_length_d = &EVP_CIPHER_key_length;
EC_KEY_get0_group_d = &EC_KEY_get0_group;
EVP_get_digestbyname_d = &EVP_get_digestbyname;
SSL_ctrl_d = &SSL_ctrl;
i2o_ECPublicKey_d = &i2o_ECPublicKey;
SSL_CTX_set_cipher_list_d = &SSL_CTX_set_cipher_list;
i2d_ECPrivateKey_d = &i2d_ECPrivateKey;
SSL_get_current_cipher_d = &SSL_get_current_cipher;
SSL_CIPHER_get_version_d = &SSL_CIPHER_get_version;
EVP_CIPHER_CTX_iv_length_d = &EVP_CIPHER_CTX_iv_length;
EVP_DigestInit_d = &EVP_DigestInit;
X509_STORE_CTX_get_error_depth_d = &X509_STORE_CTX_get_error_depth;
EC_KEY_set_group_d = &EC_KEY_set_group;
EVP_CIPHER_CTX_block_size_d = &EVP_CIPHER_CTX_block_size;
EVP_CIPHER_CTX_key_length_d = &EVP_CIPHER_CTX_key_length;
RAND_load_file_d = &RAND_load_file;
ERR_remove_thread_state_d = &ERR_remove_thread_state;
EVP_CIPHER_flags_d = &EVP_CIPHER_flags;
i2d_OCSP_CERTID_d = &i2d_OCSP_CERTID;
X509_get1_ocsp_d = &X509_get1_ocsp;
X509_email_free_d = &X509_email_free;
EC_KEY_get0_private_key_d = &EC_KEY_get0_private_key;
EVP_get_cipherbyname_d = &EVP_get_cipherbyname;
EVP_PKEY_set1_RSA_d = &EVP_PKEY_set1_RSA;
SHA1_Update_d = &SHA1_Update;
SSL_CIPHER_get_name_d = &SSL_CIPHER_get_name;
EC_KEY_get0_public_key_d = &EC_KEY_get0_public_key;
EC_GROUP_precompute_mult_d = &EC_GROUP_precompute_mult;
EC_KEY_set_private_key_d = &EC_KEY_set_private_key;
EVP_CIPHER_CTX_set_padding_d = &EVP_CIPHER_CTX_set_padding;
SSL_CTX_callback_ctrl_d = &SSL_CTX_callback_ctrl;
X509_NAME_oneline_d = &X509_NAME_oneline;
BUF_strlcat_d = &BUF_strlcat;
OCSP_check_nonce_d = &OCSP_check_nonce;
SSL_COMP_get_compression_methods_d = &SSL_COMP_get_compression_methods;
BIO_vprintf_d = &BIO_vprintf;
EC_KEY_set_public_key_d = &EC_KEY_set_public_key;
X509_NAME_ENTRY_get_data_d = &X509_NAME_ENTRY_get_data;
i2d_ECDSA_SIG_d = &i2d_ECDSA_SIG;
X509_STORE_CTX_get_current_cert_d = &X509_STORE_CTX_get_current_cert;
SSL_CIPHER_get_bits_d = &SSL_CIPHER_get_bits;
i2d_OCSP_RESPONSE_d = &i2d_OCSP_RESPONSE;
SSL_get_peer_cert_chain_d = &SSL_get_peer_cert_chain;
EVP_CIPHER_CTX_flags_d = &EVP_CIPHER_CTX_flags;
OCSP_response_get1_basic_d = &OCSP_response_get1_basic;
CRYPTO_set_id_callback_d = &CRYPTO_set_id_callback;
SHA256_Update_d = &SHA256_Update;
SHA512_Update_d = &SHA512_Update;
X509_STORE_set_flags_d = &X509_STORE_set_flags;
EC_KEY_get_conv_form_d = &EC_KEY_get_conv_form;
SSL_CTX_ctrl_d = &SSL_CTX_ctrl;
ERR_error_string_n_d = &ERR_error_string_n;
ASN1_INTEGER_to_BN_d = &ASN1_INTEGER_to_BN;
X509_NAME_get_entry_d = &X509_NAME_get_entry;
OCSP_REQ_CTX_set1_req_d = &OCSP_REQ_CTX_set1_req;
BN_mpi2bn_d = &BN_mpi2bn;
BN_bin2bn_d = &BN_bin2bn;
EVP_DigestUpdate_d = &EVP_DigestUpdate;
OCSP_sendreq_nbio_d = &OCSP_sendreq_nbio;
HMAC_Final_d = &HMAC_Final;
OCSP_REQUEST_print_d = &OCSP_REQUEST_print;
HMAC_Update_d = &HMAC_Update;
X509_NAME_get_index_by_NID_d = &X509_NAME_get_index_by_NID;
SSL_CTX_use_certificate_chain_file_d = &SSL_CTX_use_certificate_chain_file;
ASN1_GENERALIZEDTIME_print_d = &ASN1_GENERALIZEDTIME_print;
OCSP_request_add0_id_d = &OCSP_request_add0_id;
EC_KEY_set_conv_form_d = &EC_KEY_set_conv_form;
OCSP_RESPONSE_print_d = &OCSP_RESPONSE_print;
EVP_DigestFinal_d = &EVP_DigestFinal;
EVP_DigestInit_ex_d = &EVP_DigestInit_ex;
SSL_CTX_use_PrivateKey_file_d = &SSL_CTX_use_PrivateKey_file;
X509_STORE_add_lookup_d = &X509_STORE_add_lookup;
EVP_CIPHER_CTX_ctrl_d = &EVP_CIPHER_CTX_ctrl;
X509_NAME_get_text_by_NID_d = &X509_NAME_get_text_by_NID;
o2i_ECPublicKey_d = &o2i_ECPublicKey;
OCSP_request_add1_nonce_d = &OCSP_request_add1_nonce;
EVP_DigestFinal_ex_d = &EVP_DigestFinal_ex;
EVP_EncryptFinal_ex_d = &EVP_EncryptFinal_ex;
d2i_ECPrivateKey_d = &d2i_ECPrivateKey;
SHA512_d = &SHA512;
EVP_DecryptFinal_ex_d = &EVP_DecryptFinal_ex;
EC_GROUP_set_point_conversion_form_d = &EC_GROUP_set_point_conversion_form;
ED25519_keypair_d = &ED25519_keypair;
ERR_put_error_d = &ERR_put_error;
OCSP_cert_to_id_d = &OCSP_cert_to_id;
d2i_ECDSA_SIG_d = &d2i_ECDSA_SIG;
DH_generate_parameters_ex_d = &DH_generate_parameters_ex;
ECDSA_do_sign_d = &ECDSA_do_sign;
X509_STORE_load_locations_d = &X509_STORE_load_locations;
SSL_CTX_set_verify_d = &SSL_CTX_set_verify;
EC_POINT_hex2point_d = &EC_POINT_hex2point;
CRYPTO_set_locked_mem_functions_d = &CRYPTO_set_locked_mem_functions;
OCSP_REQ_CTX_add1_header_d = &OCSP_REQ_CTX_add1_header;
X509_STORE_CTX_set_chain_d = &X509_STORE_CTX_set_chain;
SSL_CTX_load_verify_locations_d = &SSL_CTX_load_verify_locations;
d2i_OCSP_RESPONSE_d = &d2i_OCSP_RESPONSE;
OCSP_parse_url_d = &OCSP_parse_url;
HMAC_Init_ex_d = &HMAC_Init_ex;
OCSP_sendreq_new_d = &OCSP_sendreq_new;
EC_POINT_cmp_d = &EC_POINT_cmp;
SSL_CTX_set_tmp_dh_callback_d = &SSL_CTX_set_tmp_dh_callback;
ECDSA_do_verify_d = &ECDSA_do_verify;
X509_check_host_d = &X509_check_host;
CRYPTO_set_mem_functions_d = &CRYPTO_set_mem_functions;
X509_STORE_CTX_init_d = &X509_STORE_CTX_init;
ERR_peek_error_line_data_d = &ERR_peek_error_line_data;
EC_POINT_point2hex_d = &EC_POINT_point2hex;
OCSP_basic_verify_d = &OCSP_basic_verify;
CRYPTO_set_locking_callback_d = &CRYPTO_set_locking_callback;
EVP_VerifyFinal_d = &EVP_VerifyFinal;
SSL_CTX_set_tmp_ecdh_callback_d = &SSL_CTX_set_tmp_ecdh_callback;
EVP_DecryptUpdate_d = &EVP_DecryptUpdate;
EVP_EncryptUpdate_d = &EVP_EncryptUpdate;
OCSP_check_validity_d = &OCSP_check_validity;
ED25519_sign_d = &ED25519_sign;
EC_POINT_oct2point_d = &EC_POINT_oct2point;
ED25519_keypair_from_seed_d = &ED25519_keypair_from_seed;
EVP_Digest_d = &EVP_Digest;
ED25519_verify_d = &ED25519_verify;
EVP_DecryptInit_ex_d = &EVP_DecryptInit_ex;
EVP_EncryptInit_ex_d = &EVP_EncryptInit_ex;
EC_POINT_mul_d = &EC_POINT_mul;
EC_POINT_point2oct_d = &EC_POINT_point2oct;
ECDH_compute_key_d = &ECDH_compute_key;
OCSP_resp_find_status_d = &OCSP_resp_find_status;
png_access_version_number_d = &png_access_version_number;
SPF_server_free_d = &SPF_server_free;
SPF_request_free_d = &SPF_request_free;
SPF_response_free_d = &SPF_response_free;
SPF_strreason_d = &SPF_strreason;
SPF_strresult_d = &SPF_strresult;
SPF_strerror_d = &SPF_strerror;
SPF_response_reason_d = &SPF_response_reason;
SPF_response_result_d = &SPF_response_result;
SPF_request_new_d = &SPF_request_new;
SPF_get_lib_version_d = &SPF_get_lib_version;
SPF_request_set_env_from_d = &SPF_request_set_env_from;
SPF_server_new_d = &SPF_server_new;
SPF_request_set_helo_dom_d = &SPF_request_set_helo_dom;
SPF_request_set_ipv4_d = &SPF_request_set_ipv4;
SPF_request_set_ipv6_d = &SPF_request_set_ipv6;
SPF_dns_zone_new_d = &SPF_dns_zone_new;
SPF_request_query_mailfrom_d = &SPF_request_query_mailfrom;
SPF_dns_zone_add_str_d = &SPF_dns_zone_add_str;
tchdbnew_d = &tchdbnew;
tcfree_d = &tcfree;
tchdbdel_d = &tchdbdel;
tchdbsync_d = &tchdbsync;
tchdbecode_d = &tchdbecode;
tcndbdel_d = &tcndbdel;
tchdbclose_d = &tchdbclose;
tclistdel_d = &tclistdel;
tcndbdup_d = &tcndbdup;
tctreeclear_d = &tctreeclear;
tchdbsetmutex_d = &tchdbsetmutex;
tchdbfsiz_d = &tchdbfsiz;
tchdbrnum_d = &tchdbrnum;
tcndbrnum_d = &tcndbrnum;
tcndbiterinit_d = &tcndbiterinit;
tcndbiternext2_d = &tcndbiternext2;
tclistnum_d = &tclistnum;
tchdberrmsg_d = &tchdberrmsg;
tchdbpath_d = &tchdbpath;
tctreekeys_d = &tctreekeys;
tctreevals_d = &tctreevals;
tcndbnew2_d = &tcndbnew2;
tchdbdefrag_d = &tchdbdefrag;
tchdbsetdfunit_d = &tchdbsetdfunit;
tchdbout_d = &tchdbout;
tcndbout_d = &tcndbout;
tchdbopen_d = &tchdbopen;
tclistval_d = &tclistval;
tchdbget_d = &tchdbget;
tcndbget3_d = &tcndbget3;
tcndbget_d = &tcndbget;
tcndbfwmkeys_d = &tcndbfwmkeys;
tchdbtune_d = &tchdbtune;
tchdboptimize_d = &tchdboptimize;
tcndbputkeep_d = &tcndbputkeep;
tchdbputasync_d = &tchdbputasync;
json_null_d = &json_null;
json_true_d = &json_true;
json_array_d = &json_array;
json_false_d = &json_false;
json_object_d = &json_object;
json_decref_d = &json_decref;
json_delete_d = &json_delete;
json_real_d = &json_real;
json_copy_d = &json_copy;
jansson_version_d = &jansson_version;
json_incref_d = &json_incref;
json_array_clear_d = &json_array_clear;
json_object_clear_d = &json_object_clear;
json_deep_copy_d = &json_deep_copy;
json_integer_d = &json_integer;
json_object_iter_d = &json_object_iter;
json_string_d = &json_string;
json_pack_d = &json_pack;
json_real_value_d = &json_real_value;
json_array_size_d = &json_array_size;
json_type_string_d = &json_type_string;
json_object_iter_value_d = &json_object_iter_value;
json_number_value_d = &json_number_value;
json_object_iter_key_d = &json_object_iter_key;
json_object_size_d = &json_object_size;
json_real_set_d = &json_real_set;
json_equal_d = &json_equal;
json_string_nocheck_d = &json_string_nocheck;
json_array_remove_d = &json_array_remove;
json_array_append_d = &json_array_append;
json_array_extend_d = &json_array_extend;
json_dumps_d = &json_dumps;
json_unpack_d = &json_unpack;
json_integer_value_d = &json_integer_value;
json_object_del_d = &json_object_del;
json_string_value_d = &json_string_value;
json_object_update_d = &json_object_update;
json_string_set_d = &json_string_set;
json_array_append_new_d = &json_array_append_new;
json_integer_set_d = &json_integer_set;
json_object_iter_next_d = &json_object_iter_next;
json_array_get_d = &json_array_get;
json_object_iter_at_d = &json_object_iter_at;
json_array_set_d = &json_array_set;
json_dumpf_d = &json_dumpf;
json_string_set_nocheck_d = &json_string_set_nocheck;
json_object_get_d = &json_object_get;
json_array_insert_d = &json_array_insert;
json_array_set_new_d = &json_array_set_new;
json_loadf_d = &json_loadf;
json_object_iter_set_d = &json_object_iter_set;
json_object_set_d = &json_object_set;
json_array_insert_new_d = &json_array_insert_new;
json_dump_file_d = &json_dump_file;
json_object_iter_set_new_d = &json_object_iter_set_new;
json_object_set_new_d = &json_object_set_new;
json_set_alloc_funcs_d = &json_set_alloc_funcs;
json_loads_d = &json_loads;
json_object_set_nocheck_d = &json_object_set_nocheck;
json_load_file_d = &json_load_file;
json_pack_ex_d = &json_pack_ex;
json_object_set_new_nocheck_d = &json_object_set_new_nocheck;
json_vpack_ex_d = &json_vpack_ex;
json_unpack_ex_d = &json_unpack_ex;
json_vunpack_ex_d = &json_vunpack_ex;
utf8proc_version_d = &utf8proc_version;
utf8proc_errmsg_d = &utf8proc_errmsg;
utf8proc_category_string_d = &utf8proc_category_string;
utf8proc_category_d = &utf8proc_category;
utf8proc_get_property_d = &utf8proc_get_property;
utf8proc_iterate_d = &utf8proc_iterate;
xmlInitParser_d = &xmlInitParser;
xmlMemoryDump_d = &xmlMemoryDump;
xmlCleanupParser_d = &xmlCleanupParser;
xmlCleanupGlobals_d = &xmlCleanupGlobals;
xmlFreeDoc_d = &xmlFreeDoc;
xmlFreeNode_d = &xmlFreeNode;
xmlBufferCreate_d = &xmlBufferCreate;
xmlBufferFree_d = &xmlBufferFree;
xmlNewParserCtxt_d = &xmlNewParserCtxt;
xmlBufferLength_d = &xmlBufferLength;
xmlFreeParserCtxt_d = &xmlFreeParserCtxt;
xmlXPathFreeObject_d = &xmlXPathFreeObject;
xmlXPathFreeContext_d = &xmlXPathFreeContext;
xmlXPathNewContext_d = &xmlXPathNewContext;
xmlBufferContent_d = &xmlBufferContent;
xmlNewNode_d = &xmlNewNode;
xmlAddSibling_d = &xmlAddSibling;
xmlNodeSetContent_d = &xmlNodeSetContent;
xmlNodeBufGetContent_d = &xmlNodeBufGetContent;
xmlEncodeEntitiesReentrant_d = &xmlEncodeEntitiesReentrant;
xmlDocDumpFormatMemory_d = &xmlDocDumpFormatMemory;
xmlSetProp_d = &xmlSetProp;
xmlXPathEvalExpression_d = &xmlXPathEvalExpression;
xmlXPathRegisterNs_d = &xmlXPathRegisterNs;
xmlCtxtReadMemory_d = &xmlCtxtReadMemory;
zlibVersion_d = &zlibVersion;
compressBound_d = &compressBound;
uncompress_d = &uncompress;
compress2_d = &compress2;
return NULL;
}
const char * symbols_check_load(void *magma) {
if ((*(void **)&(memcached_free_d) = dlsym(magma, "memcached_free")) == NULL) return "memcached_free";
if ((*(void **)&(memcached_lib_version_d) = dlsym(magma, "memcached_lib_version")) == NULL) return "memcached_lib_version";
if ((*(void **)&(memcached_create_d) = dlsym(magma, "memcached_create")) == NULL) return "memcached_create";
if ((*(void **)&(memcached_flush_d) = dlsym(magma, "memcached_flush")) == NULL) return "memcached_flush";
if ((*(void **)&(memcached_strerror_d) = dlsym(magma, "memcached_strerror")) == NULL) return "memcached_strerror";
if ((*(void **)&(memcached_behavior_set_d) = dlsym(magma, "memcached_behavior_set")) == NULL) return "memcached_behavior_set";
if ((*(void **)&(memcached_delete_d) = dlsym(magma, "memcached_delete")) == NULL) return "memcached_delete";
if ((*(void **)&(memcached_server_add_with_weight_d) = dlsym(magma, "memcached_server_add_with_weight")) == NULL) return "memcached_server_add_with_weight";
if ((*(void **)&(memcached_decrement_d) = dlsym(magma, "memcached_decrement")) == NULL) return "memcached_decrement";
if ((*(void **)&(memcached_increment_d) = dlsym(magma, "memcached_increment")) == NULL) return "memcached_increment";
if ((*(void **)&(memcached_get_d) = dlsym(magma, "memcached_get")) == NULL) return "memcached_get";
if ((*(void **)&(memcached_add_d) = dlsym(magma, "memcached_add")) == NULL) return "memcached_add";
if ((*(void **)&(memcached_set_d) = dlsym(magma, "memcached_set")) == NULL) return "memcached_set";
if ((*(void **)&(memcached_append_d) = dlsym(magma, "memcached_append")) == NULL) return "memcached_append";
if ((*(void **)&(memcached_prepend_d) = dlsym(magma, "memcached_prepend")) == NULL) return "memcached_prepend";
if ((*(void **)&(memcached_replace_d) = dlsym(magma, "memcached_replace")) == NULL) return "memcached_replace";
if ((*(void **)&(memcached_cas_d) = dlsym(magma, "memcached_cas")) == NULL) return "memcached_cas";
if ((*(void **)&(memcached_decrement_with_initial_d) = dlsym(magma, "memcached_decrement_with_initial")) == NULL) return "memcached_decrement_with_initial";
if ((*(void **)&(memcached_increment_with_initial_d) = dlsym(magma, "memcached_increment_with_initial")) == NULL) return "memcached_increment_with_initial";
if ((*(void **)&(BZ2_bzlibVersion_d) = dlsym(magma, "BZ2_bzlibVersion")) == NULL) return "BZ2_bzlibVersion";
if ((*(void **)&(BZ2_bzBuffToBuffDecompress_d) = dlsym(magma, "BZ2_bzBuffToBuffDecompress")) == NULL) return "BZ2_bzBuffToBuffDecompress";
if ((*(void **)&(BZ2_bzBuffToBuffCompress_d) = dlsym(magma, "BZ2_bzBuffToBuffCompress")) == NULL) return "BZ2_bzBuffToBuffCompress";
if ((*(void **)&(cl_shutdown_d) = dlsym(magma, "cl_shutdown")) == NULL) return "cl_shutdown";
if ((*(void **)&(cl_retver_d) = dlsym(magma, "cl_retver")) == NULL) return "cl_retver";
if ((*(void **)&(cl_init_d) = dlsym(magma, "cl_init")) == NULL) return "cl_init";
if ((*(void **)&(cl_strerror_d) = dlsym(magma, "cl_strerror")) == NULL) return "cl_strerror";
if ((*(void **)&(cl_engine_new_d) = dlsym(magma, "cl_engine_new")) == NULL) return "cl_engine_new";
if ((*(void **)&(cl_statfree_d) = dlsym(magma, "cl_statfree")) == NULL) return "cl_statfree";
if ((*(void **)&(cl_engine_free_d) = dlsym(magma, "cl_engine_free")) == NULL) return "cl_engine_free";
if ((*(void **)&(cl_engine_compile_d) = dlsym(magma, "cl_engine_compile")) == NULL) return "cl_engine_compile";
if ((*(void **)&(cl_statchkdir_d) = dlsym(magma, "cl_statchkdir")) == NULL) return "cl_statchkdir";
if ((*(void **)&(cl_statinidir_d) = dlsym(magma, "cl_statinidir")) == NULL) return "cl_statinidir";
if ((*(void **)&(cl_countsigs_d) = dlsym(magma, "cl_countsigs")) == NULL) return "cl_countsigs";
if ((*(void **)&(cl_engine_set_num_d) = dlsym(magma, "cl_engine_set_num")) == NULL) return "cl_engine_set_num";
if ((*(void **)&(cl_engine_set_str_d) = dlsym(magma, "cl_engine_set_str")) == NULL) return "cl_engine_set_str";
if ((*(void **)&(cl_load_d) = dlsym(magma, "cl_load")) == NULL) return "cl_load";
if ((*(void **)&(cl_scandesc_d) = dlsym(magma, "cl_scandesc")) == NULL) return "cl_scandesc";
if ((*(void **)&(dkim_eoh_d) = dlsym(magma, "dkim_eoh")) == NULL) return "dkim_eoh";
if ((*(void **)&(dkim_close_d) = dlsym(magma, "dkim_close")) == NULL) return "dkim_close";
if ((*(void **)&(dkim_libversion_d) = dlsym(magma, "dkim_libversion")) == NULL) return "dkim_libversion";
if ((*(void **)&(dkim_free_d) = dlsym(magma, "dkim_free")) == NULL) return "dkim_free";
if ((*(void **)&(dkim_geterror_d) = dlsym(magma, "dkim_geterror")) == NULL) return "dkim_geterror";
if ((*(void **)&(dkim_eom_d) = dlsym(magma, "dkim_eom")) == NULL) return "dkim_eom";
if ((*(void **)&(dkim_getresultstr_d) = dlsym(magma, "dkim_getresultstr")) == NULL) return "dkim_getresultstr";
if ((*(void **)&(dkim_body_d) = dlsym(magma, "dkim_body")) == NULL) return "dkim_body";
if ((*(void **)&(dkim_header_d) = dlsym(magma, "dkim_header")) == NULL) return "dkim_header";
if ((*(void **)&(dkim_mfree_d) = dlsym(magma, "dkim_mfree")) == NULL) return "dkim_mfree";
if ((*(void **)&(dkim_chunk_d) = dlsym(magma, "dkim_chunk")) == NULL) return "dkim_chunk";
if ((*(void **)&(dkim_getsighdrx_d) = dlsym(magma, "dkim_getsighdr")) == NULL) return "dkim_getsighdr";
if ((*(void **)&(dkim_test_dns_put_d) = dlsym(magma, "dkim_test_dns_put")) == NULL) return "dkim_test_dns_put";
if ((*(void **)&(dkim_verify_d) = dlsym(magma, "dkim_verify")) == NULL) return "dkim_verify";
if ((*(void **)&(dkim_init_d) = dlsym(magma, "dkim_init")) == NULL) return "dkim_init";
if ((*(void **)&(dkim_sign_d) = dlsym(magma, "dkim_sign")) == NULL) return "dkim_sign";
if ((*(void **)&(FT_Done_FreeType_d) = dlsym(magma, "FT_Done_FreeType")) == NULL) return "FT_Done_FreeType";
if ((*(void **)&(FT_Init_FreeType_d) = dlsym(magma, "FT_Init_FreeType")) == NULL) return "FT_Init_FreeType";
if ((*(void **)&(FT_Library_Version_d) = dlsym(magma, "FT_Library_Version")) == NULL) return "FT_Library_Version";
if ((*(void **)&(gdFree_d) = dlsym(magma, "gdFree")) == NULL) return "gdFree";
if ((*(void **)&(gdVersionString_d) = dlsym(magma, "gdVersionString")) == NULL) return "gdVersionString";
if ((*(void **)&(gdImageDestroy_d) = dlsym(magma, "gdImageDestroy")) == NULL) return "gdImageDestroy";
if ((*(void **)&(gdImageCreate_d) = dlsym(magma, "gdImageCreate")) == NULL) return "gdImageCreate";
if ((*(void **)&(gdImageGifPtr_d) = dlsym(magma, "gdImageGifPtr")) == NULL) return "gdImageGifPtr";
if ((*(void **)&(gdImageColorResolve_d) = dlsym(magma, "gdImageColorResolve")) == NULL) return "gdImageColorResolve";
if ((*(void **)&(gdImageJpegPtr_d) = dlsym(magma, "gdImageJpegPtr")) == NULL) return "gdImageJpegPtr";
if ((*(void **)&(gdImageSetPixel_d) = dlsym(magma, "gdImageSetPixel")) == NULL) return "gdImageSetPixel";
if ((*(void **)&(gdImageStringFT_d) = dlsym(magma, "gdImageStringFT")) == NULL) return "gdImageStringFT";
if ((*(void **)&(jpeg_version_d) = dlsym(magma, "jpeg_version")) == NULL) return "jpeg_version";
if ((*(void **)&(lzo_version_string_d) = dlsym(magma, "lzo_version_string")) == NULL) return "lzo_version_string";
if ((*(void **)&(__lzo_init_v2_d) = dlsym(magma, "__lzo_init_v2")) == NULL) return "__lzo_init_v2";
if ((*(void **)&(lzo_adler32_d) = dlsym(magma, "lzo_adler32")) == NULL) return "lzo_adler32";
if ((*(void **)&(lzo1x_1_compress_d) = dlsym(magma, "lzo1x_1_compress")) == NULL) return "lzo1x_1_compress";
if ((*(void **)&(lzo1x_decompress_safe_d) = dlsym(magma, "lzo1x_decompress_safe")) == NULL) return "lzo1x_decompress_safe";
if ((*(void **)&(mysql_server_end_d) = dlsym(magma, "mysql_server_end")) == NULL) return "mysql_server_end";
if ((*(void **)&(mysql_thread_end_d) = dlsym(magma, "mysql_thread_end")) == NULL) return "mysql_thread_end";
if ((*(void **)&(mysql_ping_d) = dlsym(magma, "mysql_ping")) == NULL) return "mysql_ping";
if ((*(void **)&(mysql_close_d) = dlsym(magma, "mysql_close")) == NULL) return "mysql_close";
if ((*(void **)&(mysql_thread_init_d) = dlsym(magma, "mysql_thread_init")) == NULL) return "mysql_thread_init";
if ((*(void **)&(mysql_init_d) = dlsym(magma, "mysql_init")) == NULL) return "mysql_init";
if ((*(void **)&(mysql_thread_safe_d) = dlsym(magma, "mysql_thread_safe")) == NULL) return "mysql_thread_safe";
if ((*(void **)&(mysql_stmt_fetch_d) = dlsym(magma, "mysql_stmt_fetch")) == NULL) return "mysql_stmt_fetch";
if ((*(void **)&(mysql_stmt_close_d) = dlsym(magma, "mysql_stmt_close")) == NULL) return "mysql_stmt_close";
if ((*(void **)&(mysql_errno_d) = dlsym(magma, "mysql_errno")) == NULL) return "mysql_errno";
if ((*(void **)&(mysql_error_d) = dlsym(magma, "mysql_error")) == NULL) return "mysql_error";
if ((*(void **)&(mysql_stmt_execute_d) = dlsym(magma, "mysql_stmt_execute")) == NULL) return "mysql_stmt_execute";
if ((*(void **)&(mariadb_connection_d) = dlsym(magma, "mariadb_connection")) == NULL) return "mariadb_connection";
if ((*(void **)&(mysql_free_result_d) = dlsym(magma, "mysql_free_result")) == NULL) return "mysql_free_result";
if ((*(void **)&(mysql_stmt_reset_d) = dlsym(magma, "mysql_stmt_reset")) == NULL) return "mysql_stmt_reset";
if ((*(void **)&(mysql_insert_id_d) = dlsym(magma, "mysql_insert_id")) == NULL) return "mysql_insert_id";
if ((*(void **)&(mysql_get_server_info_d) = dlsym(magma, "mysql_get_server_info")) == NULL) return "mysql_get_server_info";
if ((*(void **)&(mysql_thread_id_d) = dlsym(magma, "mysql_thread_id")) == NULL) return "mysql_thread_id";
if ((*(void **)&(mysql_stmt_init_d) = dlsym(magma, "mysql_stmt_init")) == NULL) return "mysql_stmt_init";
if ((*(void **)&(mysql_get_connector_info_d) = dlsym(magma, "mysql_get_connector_info")) == NULL) return "mysql_get_connector_info";
if ((*(void **)&(mysql_fetch_row_d) = dlsym(magma, "mysql_fetch_row")) == NULL) return "mysql_fetch_row";
if ((*(void **)&(mysql_get_client_version_d) = dlsym(magma, "mysql_get_client_version")) == NULL) return "mysql_get_client_version";
if ((*(void **)&(mysql_store_result_d) = dlsym(magma, "mysql_store_result")) == NULL) return "mysql_store_result";
if ((*(void **)&(mysql_stmt_store_result_d) = dlsym(magma, "mysql_stmt_store_result")) == NULL) return "mysql_stmt_store_result";
if ((*(void **)&(mysql_affected_rows_d) = dlsym(magma, "mysql_affected_rows")) == NULL) return "mysql_affected_rows";
if ((*(void **)&(mysql_num_rows_d) = dlsym(magma, "mysql_num_rows")) == NULL) return "mysql_num_rows";
if ((*(void **)&(mysql_stmt_errno_d) = dlsym(magma, "mysql_stmt_errno")) == NULL) return "mysql_stmt_errno";
if ((*(void **)&(mysql_stmt_error_d) = dlsym(magma, "mysql_stmt_error")) == NULL) return "mysql_stmt_error";
if ((*(void **)&(mysql_stmt_free_result_d) = dlsym(magma, "mysql_stmt_free_result")) == NULL) return "mysql_stmt_free_result";
if ((*(void **)&(mysql_num_fields_d) = dlsym(magma, "mysql_num_fields")) == NULL) return "mysql_num_fields";
if ((*(void **)&(mysql_stmt_num_rows_d) = dlsym(magma, "mysql_stmt_num_rows")) == NULL) return "mysql_stmt_num_rows";
if ((*(void **)&(mysql_fetch_field_d) = dlsym(magma, "mysql_fetch_field")) == NULL) return "mysql_fetch_field";
if ((*(void **)&(mysql_character_set_name_d) = dlsym(magma, "mysql_character_set_name")) == NULL) return "mysql_character_set_name";
if ((*(void **)&(mysql_stmt_insert_id_d) = dlsym(magma, "mysql_stmt_insert_id")) == NULL) return "mysql_stmt_insert_id";
if ((*(void **)&(mysql_stmt_affected_rows_d) = dlsym(magma, "mysql_stmt_affected_rows")) == NULL) return "mysql_stmt_affected_rows";
if ((*(void **)&(mysql_stmt_result_metadata_d) = dlsym(magma, "mysql_stmt_result_metadata")) == NULL) return "mysql_stmt_result_metadata";
if ((*(void **)&(mysql_server_init_d) = dlsym(magma, "mysql_server_init")) == NULL) return "mysql_server_init";
if ((*(void **)&(mysql_set_character_set_d) = dlsym(magma, "mysql_set_character_set")) == NULL) return "mysql_set_character_set";
if ((*(void **)&(mysql_stmt_bind_param_d) = dlsym(magma, "mysql_stmt_bind_param")) == NULL) return "mysql_stmt_bind_param";
if ((*(void **)&(mysql_stmt_bind_result_d) = dlsym(magma, "mysql_stmt_bind_result")) == NULL) return "mysql_stmt_bind_result";
if ((*(void **)&(mysql_options_d) = dlsym(magma, "mysql_options")) == NULL) return "mysql_options";
if ((*(void **)&(mysql_real_query_d) = dlsym(magma, "mysql_real_query")) == NULL) return "mysql_real_query";
if ((*(void **)&(mysql_stmt_prepare_d) = dlsym(magma, "mysql_stmt_prepare")) == NULL) return "mysql_stmt_prepare";
if ((*(void **)&(mysql_escape_string_d) = dlsym(magma, "mysql_escape_string")) == NULL) return "mysql_escape_string";
if ((*(void **)&(mysql_stmt_attr_set_d) = dlsym(magma, "mysql_stmt_attr_set")) == NULL) return "mysql_stmt_attr_set";
if ((*(void **)&(mysql_real_connect_d) = dlsym(magma, "mysql_real_connect")) == NULL) return "mysql_real_connect";
if ((*(void **)&(DH_new_d) = dlsym(magma, "DH_new")) == NULL) return "DH_new";
if ((*(void **)&(RSA_new_d) = dlsym(magma, "RSA_new")) == NULL) return "RSA_new";
if ((*(void **)&(DH_free_d) = dlsym(magma, "DH_free")) == NULL) return "DH_free";
if ((*(void **)&(BIO_free_d) = dlsym(magma, "BIO_free")) == NULL) return "BIO_free";
if ((*(void **)&(RAND_status_d) = dlsym(magma, "RAND_status")) == NULL) return "RAND_status";
if ((*(void **)&(RSA_free_d) = dlsym(magma, "RSA_free")) == NULL) return "RSA_free";
if ((*(void **)&(EVP_cleanup_d) = dlsym(magma, "EVP_cleanup")) == NULL) return "EVP_cleanup";
if ((*(void **)&(OBJ_cleanup_d) = dlsym(magma, "OBJ_cleanup")) == NULL) return "OBJ_cleanup";
if ((*(void **)&(BN_free_d) = dlsym(magma, "BN_free")) == NULL) return "BN_free";
if ((*(void **)&(RAND_cleanup_d) = dlsym(magma, "RAND_cleanup")) == NULL) return "RAND_cleanup";
if ((*(void **)&(SSL_free_d) = dlsym(magma, "SSL_free")) == NULL) return "SSL_free";
if ((*(void **)&(SSL_accept_d) = dlsym(magma, "SSL_accept")) == NULL) return "SSL_accept";
if ((*(void **)&(sk_pop_d) = dlsym(magma, "sk_pop")) == NULL) return "sk_pop";
if ((*(void **)&(BN_CTX_new_d) = dlsym(magma, "BN_CTX_new")) == NULL) return "BN_CTX_new";
if ((*(void **)&(SSL_connect_d) = dlsym(magma, "SSL_connect")) == NULL) return "SSL_connect";
if ((*(void **)&(EC_KEY_new_d) = dlsym(magma, "EC_KEY_new")) == NULL) return "EC_KEY_new";
if ((*(void **)&(CRYPTO_free_d) = dlsym(magma, "CRYPTO_free")) == NULL) return "CRYPTO_free";
if ((*(void **)&(ENGINE_cleanup_d) = dlsym(magma, "ENGINE_cleanup")) == NULL) return "ENGINE_cleanup";
if ((*(void **)&(SHA1_Init_d) = dlsym(magma, "SHA1_Init")) == NULL) return "SHA1_Init";
if ((*(void **)&(BIO_free_all_d) = dlsym(magma, "BIO_free_all")) == NULL) return "BIO_free_all";
if ((*(void **)&(CRYPTO_num_locks_d) = dlsym(magma, "CRYPTO_num_locks")) == NULL) return "CRYPTO_num_locks";
if ((*(void **)&(SSL_library_init_d) = dlsym(magma, "SSL_library_init")) == NULL) return "SSL_library_init";
if ((*(void **)&(SSL_want_d) = dlsym(magma, "SSL_want")) == NULL) return "SSL_want";
if ((*(void **)&(SSL_shutdown_d) = dlsym(magma, "SSL_shutdown")) == NULL) return "SSL_shutdown";
if ((*(void **)&(ERR_clear_error_d) = dlsym(magma, "ERR_clear_error")) == NULL) return "ERR_clear_error";
if ((*(void **)&(sk_num_d) = dlsym(magma, "sk_num")) == NULL) return "sk_num";
if ((*(void **)&(BIO_sock_cleanup_d) = dlsym(magma, "BIO_sock_cleanup")) == NULL) return "BIO_sock_cleanup";
if ((*(void **)&(ERR_free_strings_d) = dlsym(magma, "ERR_free_strings")) == NULL) return "ERR_free_strings";
if ((*(void **)&(SSL_new_d) = dlsym(magma, "SSL_new")) == NULL) return "SSL_new";
if ((*(void **)&(EVP_md4_d) = dlsym(magma, "EVP_md4")) == NULL) return "EVP_md4";
if ((*(void **)&(EVP_md5_d) = dlsym(magma, "EVP_md5")) == NULL) return "EVP_md5";
if ((*(void **)&(EVP_sha_d) = dlsym(magma, "EVP_sha")) == NULL) return "EVP_sha";
if ((*(void **)&(COMP_zlib_cleanup_d) = dlsym(magma, "COMP_zlib_cleanup")) == NULL) return "COMP_zlib_cleanup";
if ((*(void **)&(SSL_get_fd_d) = dlsym(magma, "SSL_get_fd")) == NULL) return "SSL_get_fd";
if ((*(void **)&(SSL_do_handshake_d) = dlsym(magma, "SSL_do_handshake")) == NULL) return "SSL_do_handshake";
if ((*(void **)&(BN_CTX_free_d) = dlsym(magma, "BN_CTX_free")) == NULL) return "BN_CTX_free";
if ((*(void **)&(EVP_sha1_d) = dlsym(magma, "EVP_sha1")) == NULL) return "EVP_sha1";
if ((*(void **)&(EC_KEY_free_d) = dlsym(magma, "EC_KEY_free")) == NULL) return "EC_KEY_free";
if ((*(void **)&(SSL_get_rfd_d) = dlsym(magma, "SSL_get_rfd")) == NULL) return "SSL_get_rfd";
if ((*(void **)&(EVP_PKEY_new_d) = dlsym(magma, "EVP_PKEY_new")) == NULL) return "EVP_PKEY_new";
if ((*(void **)&(BN_CTX_start_d) = dlsym(magma, "BN_CTX_start")) == NULL) return "BN_CTX_start";
if ((*(void **)&(OBJ_nid2sn_d) = dlsym(magma, "OBJ_nid2sn")) == NULL) return "OBJ_nid2sn";
if ((*(void **)&(SHA256_Init_d) = dlsym(magma, "SHA256_Init")) == NULL) return "SHA256_Init";
if ((*(void **)&(SHA512_Init_d) = dlsym(magma, "SHA512_Init")) == NULL) return "SHA512_Init";
if ((*(void **)&(SSL_set_fd_d) = dlsym(magma, "SSL_set_fd")) == NULL) return "SSL_set_fd";
if ((*(void **)&(EVP_sha224_d) = dlsym(magma, "EVP_sha224")) == NULL) return "EVP_sha224";
if ((*(void **)&(EVP_sha256_d) = dlsym(magma, "EVP_sha256")) == NULL) return "EVP_sha256";
if ((*(void **)&(EVP_sha384_d) = dlsym(magma, "EVP_sha384")) == NULL) return "EVP_sha384";
if ((*(void **)&(EVP_sha512_d) = dlsym(magma, "EVP_sha512")) == NULL) return "EVP_sha512";
if ((*(void **)&(OBJ_NAME_cleanup_d) = dlsym(magma, "OBJ_NAME_cleanup")) == NULL) return "OBJ_NAME_cleanup";
if ((*(void **)&(SSL_CTX_free_d) = dlsym(magma, "SSL_CTX_free")) == NULL) return "SSL_CTX_free";
if ((*(void **)&(SSL_pending_d) = dlsym(magma, "SSL_pending")) == NULL) return "SSL_pending";
if ((*(void **)&(BN_num_bits_d) = dlsym(magma, "BN_num_bits")) == NULL) return "BN_num_bits";
if ((*(void **)&(X509_get_ext_count_d) = dlsym(magma, "X509_get_ext_count")) == NULL) return "X509_get_ext_count";
if ((*(void **)&(RSAPublicKey_dup_d) = dlsym(magma, "RSAPublicKey_dup")) == NULL) return "RSAPublicKey_dup";
if ((*(void **)&(BN_bn2dec_d) = dlsym(magma, "BN_bn2dec")) == NULL) return "BN_bn2dec";
if ((*(void **)&(BN_bn2hex_d) = dlsym(magma, "BN_bn2hex")) == NULL) return "BN_bn2hex";
if ((*(void **)&(EVP_MD_size_d) = dlsym(magma, "EVP_MD_size")) == NULL) return "EVP_MD_size";
if ((*(void **)&(ERR_get_error_d) = dlsym(magma, "ERR_get_error")) == NULL) return "ERR_get_error";
if ((*(void **)&(CONF_modules_unload_d) = dlsym(magma, "CONF_modules_unload")) == NULL) return "CONF_modules_unload";
if ((*(void **)&(HMAC_CTX_init_d) = dlsym(magma, "HMAC_CTX_init")) == NULL) return "HMAC_CTX_init";
if ((*(void **)&(SSL_load_error_strings_d) = dlsym(magma, "SSL_load_error_strings")) == NULL) return "SSL_load_error_strings";
if ((*(void **)&(EVP_MD_type_d) = dlsym(magma, "EVP_MD_type")) == NULL) return "EVP_MD_type";
if ((*(void **)&(ECDSA_SIG_free_d) = dlsym(magma, "ECDSA_SIG_free")) == NULL) return "ECDSA_SIG_free";
if ((*(void **)&(X509_STORE_new_d) = dlsym(magma, "X509_STORE_new")) == NULL) return "X509_STORE_new";
if ((*(void **)&(SSL_set_accept_state_d) = dlsym(magma, "SSL_set_accept_state")) == NULL) return "SSL_set_accept_state";
if ((*(void **)&(SSL_set_connect_state_d) = dlsym(magma, "SSL_set_connect_state")) == NULL) return "SSL_set_connect_state";
if ((*(void **)&(ERR_peek_error_d) = dlsym(magma, "ERR_peek_error")) == NULL) return "ERR_peek_error";
if ((*(void **)&(EVP_ripemd160_d) = dlsym(magma, "EVP_ripemd160")) == NULL) return "EVP_ripemd160";
if ((*(void **)&(SSLeay_version_d) = dlsym(magma, "SSLeay_version")) == NULL) return "SSLeay_version";
if ((*(void **)&(ERR_load_crypto_strings_d) = dlsym(magma, "ERR_load_crypto_strings")) == NULL) return "ERR_load_crypto_strings";
if ((*(void **)&(ERR_print_errors_fp_d) = dlsym(magma, "ERR_print_errors_fp")) == NULL) return "ERR_print_errors_fp";
if ((*(void **)&(SSL_get_wbio_d) = dlsym(magma, "SSL_get_wbio")) == NULL) return "SSL_get_wbio";
if ((*(void **)&(EC_GROUP_free_d) = dlsym(magma, "EC_GROUP_free")) == NULL) return "EC_GROUP_free";
if ((*(void **)&(EC_POINT_free_d) = dlsym(magma, "EC_POINT_free")) == NULL) return "EC_POINT_free";
if ((*(void **)&(X509_STORE_free_d) = dlsym(magma, "X509_STORE_free")) == NULL) return "X509_STORE_free";
if ((*(void **)&(SSL_get_read_ahead_d) = dlsym(magma, "SSL_get_read_ahead")) == NULL) return "SSL_get_read_ahead";
if ((*(void **)&(DH_check_d) = dlsym(magma, "DH_check")) == NULL) return "DH_check";
if ((*(void **)&(EC_KEY_generate_key_d) = dlsym(magma, "EC_KEY_generate_key")) == NULL) return "EC_KEY_generate_key";
if ((*(void **)&(ASN1_STRING_TABLE_cleanup_d) = dlsym(magma, "ASN1_STRING_TABLE_cleanup")) == NULL) return "ASN1_STRING_TABLE_cleanup";
if ((*(void **)&(HMAC_CTX_cleanup_d) = dlsym(magma, "HMAC_CTX_cleanup")) == NULL) return "HMAC_CTX_cleanup";
if ((*(void **)&(SSL_get_shutdown_d) = dlsym(magma, "SSL_get_shutdown")) == NULL) return "SSL_get_shutdown";
if ((*(void **)&(sk_value_d) = dlsym(magma, "sk_value")) == NULL) return "sk_value";
if ((*(void **)&(CRYPTO_cleanup_all_ex_data_d) = dlsym(magma, "CRYPTO_cleanup_all_ex_data")) == NULL) return "CRYPTO_cleanup_all_ex_data";
if ((*(void **)&(EVP_MD_CTX_init_d) = dlsym(magma, "EVP_MD_CTX_init")) == NULL) return "EVP_MD_CTX_init";
if ((*(void **)&(OCSP_REQUEST_new_d) = dlsym(magma, "OCSP_REQUEST_new")) == NULL) return "OCSP_REQUEST_new";
if ((*(void **)&(EC_KEY_check_key_d) = dlsym(magma, "EC_KEY_check_key")) == NULL) return "EC_KEY_check_key";
if ((*(void **)&(EVP_MD_CTX_cleanup_d) = dlsym(magma, "EVP_MD_CTX_cleanup")) == NULL) return "EVP_MD_CTX_cleanup";
if ((*(void **)&(OCSP_REQUEST_free_d) = dlsym(magma, "OCSP_REQUEST_free")) == NULL) return "OCSP_REQUEST_free";
if ((*(void **)&(EVP_aes_256_gcm_d) = dlsym(magma, "EVP_aes_256_gcm")) == NULL) return "EVP_aes_256_gcm";
if ((*(void **)&(EVP_aes_256_cbc_d) = dlsym(magma, "EVP_aes_256_cbc")) == NULL) return "EVP_aes_256_cbc";
if ((*(void **)&(SSL_peek_d) = dlsym(magma, "SSL_peek")) == NULL) return "SSL_peek";
if ((*(void **)&(SSL_set_read_ahead_d) = dlsym(magma, "SSL_set_read_ahead")) == NULL) return "SSL_set_read_ahead";
if ((*(void **)&(EVP_CIPHER_CTX_new_d) = dlsym(magma, "EVP_CIPHER_CTX_new")) == NULL) return "EVP_CIPHER_CTX_new";
if ((*(void **)&(X509_verify_cert_d) = dlsym(magma, "X509_verify_cert")) == NULL) return "X509_verify_cert";
if ((*(void **)&(EC_GROUP_clear_free_d) = dlsym(magma, "EC_GROUP_clear_free")) == NULL) return "EC_GROUP_clear_free";
if ((*(void **)&(OCSP_RESPONSE_free_d) = dlsym(magma, "OCSP_RESPONSE_free")) == NULL) return "OCSP_RESPONSE_free";
if ((*(void **)&(X509_STORE_CTX_new_d) = dlsym(magma, "X509_STORE_CTX_new")) == NULL) return "X509_STORE_CTX_new";
if ((*(void **)&(X509_get_subject_name_d) = dlsym(magma, "X509_get_subject_name")) == NULL) return "X509_get_subject_name";
if ((*(void **)&(EC_KEY_new_by_curve_name_d) = dlsym(magma, "EC_KEY_new_by_curve_name")) == NULL) return "EC_KEY_new_by_curve_name";
if ((*(void **)&(BN_hex2bn_d) = dlsym(magma, "BN_hex2bn")) == NULL) return "BN_hex2bn";
if ((*(void **)&(SSL_read_d) = dlsym(magma, "SSL_read")) == NULL) return "SSL_read";
if ((*(void **)&(i2d_X509_d) = dlsym(magma, "i2d_X509")) == NULL) return "i2d_X509";
if ((*(void **)&(SSL_get_version_d) = dlsym(magma, "SSL_get_version")) == NULL) return "SSL_get_version";
if ((*(void **)&(RAND_bytes_d) = dlsym(magma, "RAND_bytes")) == NULL) return "RAND_bytes";
if ((*(void **)&(EVP_CIPHER_CTX_init_d) = dlsym(magma, "EVP_CIPHER_CTX_init")) == NULL) return "EVP_CIPHER_CTX_init";
if ((*(void **)&(OCSP_BASICRESP_free_d) = dlsym(magma, "OCSP_BASICRESP_free")) == NULL) return "OCSP_BASICRESP_free";
if ((*(void **)&(EVP_CIPHER_CTX_free_d) = dlsym(magma, "EVP_CIPHER_CTX_free")) == NULL) return "EVP_CIPHER_CTX_free";
if ((*(void **)&(X509_LOOKUP_file_d) = dlsym(magma, "X509_LOOKUP_file")) == NULL) return "X509_LOOKUP_file";
if ((*(void **)&(BN_cmp_d) = dlsym(magma, "BN_cmp")) == NULL) return "BN_cmp";
if ((*(void **)&(TLSv1_server_method_d) = dlsym(magma, "TLSv1_server_method")) == NULL) return "TLSv1_server_method";
if ((*(void **)&(EVP_CIPHER_nid_d) = dlsym(magma, "EVP_CIPHER_nid")) == NULL) return "EVP_CIPHER_nid";
if ((*(void **)&(OPENSSL_add_all_algorithms_noconf_d) = dlsym(magma, "OPENSSL_add_all_algorithms_noconf")) == NULL) return "OPENSSL_add_all_algorithms_noconf";
if ((*(void **)&(SSL_get_error_d) = dlsym(magma, "SSL_get_error")) == NULL) return "SSL_get_error";
if ((*(void **)&(SSLv23_client_method_d) = dlsym(magma, "SSLv23_client_method")) == NULL) return "SSLv23_client_method";
if ((*(void **)&(SSLv23_server_method_d) = dlsym(magma, "SSLv23_server_method")) == NULL) return "SSLv23_server_method";
if ((*(void **)&(SSL_get_peer_certificate_d) = dlsym(magma, "SSL_get_peer_certificate")) == NULL) return "SSL_get_peer_certificate";
if ((*(void **)&(EVP_CIPHER_CTX_cleanup_d) = dlsym(magma, "EVP_CIPHER_CTX_cleanup")) == NULL) return "EVP_CIPHER_CTX_cleanup";
if ((*(void **)&(OCSP_response_status_str_d) = dlsym(magma, "OCSP_response_status_str")) == NULL) return "OCSP_response_status_str";
if ((*(void **)&(OCSP_response_status_d) = dlsym(magma, "OCSP_response_status")) == NULL) return "OCSP_response_status";
if ((*(void **)&(SHA1_Final_d) = dlsym(magma, "SHA1_Final")) == NULL) return "SHA1_Final";
if ((*(void **)&(X509_STORE_CTX_free_d) = dlsym(magma, "X509_STORE_CTX_free")) == NULL) return "X509_STORE_CTX_free";
if ((*(void **)&(BIO_new_socket_d) = dlsym(magma, "BIO_new_socket")) == NULL) return "BIO_new_socket";
if ((*(void **)&(EC_GROUP_new_by_curve_name_d) = dlsym(magma, "EC_GROUP_new_by_curve_name")) == NULL) return "EC_GROUP_new_by_curve_name";
if ((*(void **)&(EC_POINT_new_d) = dlsym(magma, "EC_POINT_new")) == NULL) return "EC_POINT_new";
if ((*(void **)&(BN_bn2bin_d) = dlsym(magma, "BN_bn2bin")) == NULL) return "BN_bn2bin";
if ((*(void **)&(BIO_new_fp_d) = dlsym(magma, "BIO_new_fp")) == NULL) return "BIO_new_fp";
if ((*(void **)&(X509_get_ext_d) = dlsym(magma, "X509_get_ext")) == NULL) return "X509_get_ext";
if ((*(void **)&(SSL_CTX_new_d) = dlsym(magma, "SSL_CTX_new")) == NULL) return "SSL_CTX_new";
if ((*(void **)&(SSL_set_bio_d) = dlsym(magma, "SSL_set_bio")) == NULL) return "SSL_set_bio";
if ((*(void **)&(ASN1_STRING_data_d) = dlsym(magma, "ASN1_STRING_data")) == NULL) return "ASN1_STRING_data";
if ((*(void **)&(BN_bn2mpi_d) = dlsym(magma, "BN_bn2mpi")) == NULL) return "BN_bn2mpi";
if ((*(void **)&(SSL_CTX_check_private_key_d) = dlsym(magma, "SSL_CTX_check_private_key")) == NULL) return "SSL_CTX_check_private_key";
if ((*(void **)&(SSL_write_d) = dlsym(magma, "SSL_write")) == NULL) return "SSL_write";
if ((*(void **)&(sk_pop_free_d) = dlsym(magma, "sk_pop_free")) == NULL) return "sk_pop_free";
if ((*(void **)&(X509_STORE_CTX_get_error_d) = dlsym(magma, "X509_STORE_CTX_get_error")) == NULL) return "X509_STORE_CTX_get_error";
if ((*(void **)&(EVP_CIPHER_iv_length_d) = dlsym(magma, "EVP_CIPHER_iv_length")) == NULL) return "EVP_CIPHER_iv_length";
if ((*(void **)&(X509_verify_cert_error_string_d) = dlsym(magma, "X509_verify_cert_error_string")) == NULL) return "X509_verify_cert_error_string";
if ((*(void **)&(SHA256_Final_d) = dlsym(magma, "SHA256_Final")) == NULL) return "SHA256_Final";
if ((*(void **)&(SHA512_Final_d) = dlsym(magma, "SHA512_Final")) == NULL) return "SHA512_Final";
if ((*(void **)&(X509_check_issued_d) = dlsym(magma, "X509_check_issued")) == NULL) return "X509_check_issued";
if ((*(void **)&(EVP_CIPHER_block_size_d) = dlsym(magma, "EVP_CIPHER_block_size")) == NULL) return "EVP_CIPHER_block_size";
if ((*(void **)&(EVP_CIPHER_key_length_d) = dlsym(magma, "EVP_CIPHER_key_length")) == NULL) return "EVP_CIPHER_key_length";
if ((*(void **)&(EC_KEY_get0_group_d) = dlsym(magma, "EC_KEY_get0_group")) == NULL) return "EC_KEY_get0_group";
if ((*(void **)&(EVP_get_digestbyname_d) = dlsym(magma, "EVP_get_digestbyname")) == NULL) return "EVP_get_digestbyname";
if ((*(void **)&(SSL_ctrl_d) = dlsym(magma, "SSL_ctrl")) == NULL) return "SSL_ctrl";
if ((*(void **)&(i2o_ECPublicKey_d) = dlsym(magma, "i2o_ECPublicKey")) == NULL) return "i2o_ECPublicKey";
if ((*(void **)&(SSL_CTX_set_cipher_list_d) = dlsym(magma, "SSL_CTX_set_cipher_list")) == NULL) return "SSL_CTX_set_cipher_list";
if ((*(void **)&(i2d_ECPrivateKey_d) = dlsym(magma, "i2d_ECPrivateKey")) == NULL) return "i2d_ECPrivateKey";
if ((*(void **)&(SSL_get_current_cipher_d) = dlsym(magma, "SSL_get_current_cipher")) == NULL) return "SSL_get_current_cipher";
if ((*(void **)&(SSL_CIPHER_get_version_d) = dlsym(magma, "SSL_CIPHER_get_version")) == NULL) return "SSL_CIPHER_get_version";
if ((*(void **)&(EVP_CIPHER_CTX_iv_length_d) = dlsym(magma, "EVP_CIPHER_CTX_iv_length")) == NULL) return "EVP_CIPHER_CTX_iv_length";
if ((*(void **)&(EVP_DigestInit_d) = dlsym(magma, "EVP_DigestInit")) == NULL) return "EVP_DigestInit";
if ((*(void **)&(X509_STORE_CTX_get_error_depth_d) = dlsym(magma, "X509_STORE_CTX_get_error_depth")) == NULL) return "X509_STORE_CTX_get_error_depth";
if ((*(void **)&(EC_KEY_set_group_d) = dlsym(magma, "EC_KEY_set_group")) == NULL) return "EC_KEY_set_group";
if ((*(void **)&(EVP_CIPHER_CTX_block_size_d) = dlsym(magma, "EVP_CIPHER_CTX_block_size")) == NULL) return "EVP_CIPHER_CTX_block_size";
if ((*(void **)&(EVP_CIPHER_CTX_key_length_d) = dlsym(magma, "EVP_CIPHER_CTX_key_length")) == NULL) return "EVP_CIPHER_CTX_key_length";
if ((*(void **)&(RAND_load_file_d) = dlsym(magma, "RAND_load_file")) == NULL) return "RAND_load_file";
if ((*(void **)&(ERR_remove_thread_state_d) = dlsym(magma, "ERR_remove_thread_state")) == NULL) return "ERR_remove_thread_state";
if ((*(void **)&(EVP_CIPHER_flags_d) = dlsym(magma, "EVP_CIPHER_flags")) == NULL) return "EVP_CIPHER_flags";
if ((*(void **)&(i2d_OCSP_CERTID_d) = dlsym(magma, "i2d_OCSP_CERTID")) == NULL) return "i2d_OCSP_CERTID";
if ((*(void **)&(X509_get1_ocsp_d) = dlsym(magma, "X509_get1_ocsp")) == NULL) return "X509_get1_ocsp";
if ((*(void **)&(X509_email_free_d) = dlsym(magma, "X509_email_free")) == NULL) return "X509_email_free";
if ((*(void **)&(EC_KEY_get0_private_key_d) = dlsym(magma, "EC_KEY_get0_private_key")) == NULL) return "EC_KEY_get0_private_key";
if ((*(void **)&(EVP_get_cipherbyname_d) = dlsym(magma, "EVP_get_cipherbyname")) == NULL) return "EVP_get_cipherbyname";
if ((*(void **)&(EVP_PKEY_set1_RSA_d) = dlsym(magma, "EVP_PKEY_set1_RSA")) == NULL) return "EVP_PKEY_set1_RSA";
if ((*(void **)&(SHA1_Update_d) = dlsym(magma, "SHA1_Update")) == NULL) return "SHA1_Update";
if ((*(void **)&(SSL_CIPHER_get_name_d) = dlsym(magma, "SSL_CIPHER_get_name")) == NULL) return "SSL_CIPHER_get_name";
if ((*(void **)&(EC_KEY_get0_public_key_d) = dlsym(magma, "EC_KEY_get0_public_key")) == NULL) return "EC_KEY_get0_public_key";
if ((*(void **)&(EC_GROUP_precompute_mult_d) = dlsym(magma, "EC_GROUP_precompute_mult")) == NULL) return "EC_GROUP_precompute_mult";
if ((*(void **)&(EC_KEY_set_private_key_d) = dlsym(magma, "EC_KEY_set_private_key")) == NULL) return "EC_KEY_set_private_key";
if ((*(void **)&(EVP_CIPHER_CTX_set_padding_d) = dlsym(magma, "EVP_CIPHER_CTX_set_padding")) == NULL) return "EVP_CIPHER_CTX_set_padding";
if ((*(void **)&(SSL_CTX_callback_ctrl_d) = dlsym(magma, "SSL_CTX_callback_ctrl")) == NULL) return "SSL_CTX_callback_ctrl";
if ((*(void **)&(X509_NAME_oneline_d) = dlsym(magma, "X509_NAME_oneline")) == NULL) return "X509_NAME_oneline";
if ((*(void **)&(BUF_strlcat_d) = dlsym(magma, "BUF_strlcat")) == NULL) return "BUF_strlcat";
if ((*(void **)&(OCSP_check_nonce_d) = dlsym(magma, "OCSP_check_nonce")) == NULL) return "OCSP_check_nonce";
if ((*(void **)&(SSL_COMP_get_compression_methods_d) = dlsym(magma, "SSL_COMP_get_compression_methods")) == NULL) return "SSL_COMP_get_compression_methods";
if ((*(void **)&(BIO_vprintf_d) = dlsym(magma, "BIO_vprintf")) == NULL) return "BIO_vprintf";
if ((*(void **)&(EC_KEY_set_public_key_d) = dlsym(magma, "EC_KEY_set_public_key")) == NULL) return "EC_KEY_set_public_key";
if ((*(void **)&(X509_NAME_ENTRY_get_data_d) = dlsym(magma, "X509_NAME_ENTRY_get_data")) == NULL) return "X509_NAME_ENTRY_get_data";
if ((*(void **)&(i2d_ECDSA_SIG_d) = dlsym(magma, "i2d_ECDSA_SIG")) == NULL) return "i2d_ECDSA_SIG";
if ((*(void **)&(X509_STORE_CTX_get_current_cert_d) = dlsym(magma, "X509_STORE_CTX_get_current_cert")) == NULL) return "X509_STORE_CTX_get_current_cert";
if ((*(void **)&(SSL_CIPHER_get_bits_d) = dlsym(magma, "SSL_CIPHER_get_bits")) == NULL) return "SSL_CIPHER_get_bits";
if ((*(void **)&(i2d_OCSP_RESPONSE_d) = dlsym(magma, "i2d_OCSP_RESPONSE")) == NULL) return "i2d_OCSP_RESPONSE";
if ((*(void **)&(SSL_get_peer_cert_chain_d) = dlsym(magma, "SSL_get_peer_cert_chain")) == NULL) return "SSL_get_peer_cert_chain";
if ((*(void **)&(EVP_CIPHER_CTX_flags_d) = dlsym(magma, "EVP_CIPHER_CTX_flags")) == NULL) return "EVP_CIPHER_CTX_flags";
if ((*(void **)&(OCSP_response_get1_basic_d) = dlsym(magma, "OCSP_response_get1_basic")) == NULL) return "OCSP_response_get1_basic";
if ((*(void **)&(CRYPTO_set_id_callback_d) = dlsym(magma, "CRYPTO_set_id_callback")) == NULL) return "CRYPTO_set_id_callback";
if ((*(void **)&(SHA256_Update_d) = dlsym(magma, "SHA256_Update")) == NULL) return "SHA256_Update";
if ((*(void **)&(SHA512_Update_d) = dlsym(magma, "SHA512_Update")) == NULL) return "SHA512_Update";
if ((*(void **)&(X509_STORE_set_flags_d) = dlsym(magma, "X509_STORE_set_flags")) == NULL) return "X509_STORE_set_flags";
if ((*(void **)&(EC_KEY_get_conv_form_d) = dlsym(magma, "EC_KEY_get_conv_form")) == NULL) return "EC_KEY_get_conv_form";
if ((*(void **)&(SSL_CTX_ctrl_d) = dlsym(magma, "SSL_CTX_ctrl")) == NULL) return "SSL_CTX_ctrl";
if ((*(void **)&(ERR_error_string_n_d) = dlsym(magma, "ERR_error_string_n")) == NULL) return "ERR_error_string_n";
if ((*(void **)&(ASN1_INTEGER_to_BN_d) = dlsym(magma, "ASN1_INTEGER_to_BN")) == NULL) return "ASN1_INTEGER_to_BN";
if ((*(void **)&(X509_NAME_get_entry_d) = dlsym(magma, "X509_NAME_get_entry")) == NULL) return "X509_NAME_get_entry";
if ((*(void **)&(OCSP_REQ_CTX_set1_req_d) = dlsym(magma, "OCSP_REQ_CTX_set1_req")) == NULL) return "OCSP_REQ_CTX_set1_req";
if ((*(void **)&(BN_mpi2bn_d) = dlsym(magma, "BN_mpi2bn")) == NULL) return "BN_mpi2bn";
if ((*(void **)&(BN_bin2bn_d) = dlsym(magma, "BN_bin2bn")) == NULL) return "BN_bin2bn";
if ((*(void **)&(EVP_DigestUpdate_d) = dlsym(magma, "EVP_DigestUpdate")) == NULL) return "EVP_DigestUpdate";
if ((*(void **)&(OCSP_sendreq_nbio_d) = dlsym(magma, "OCSP_sendreq_nbio")) == NULL) return "OCSP_sendreq_nbio";
if ((*(void **)&(HMAC_Final_d) = dlsym(magma, "HMAC_Final")) == NULL) return "HMAC_Final";
if ((*(void **)&(OCSP_REQUEST_print_d) = dlsym(magma, "OCSP_REQUEST_print")) == NULL) return "OCSP_REQUEST_print";
if ((*(void **)&(HMAC_Update_d) = dlsym(magma, "HMAC_Update")) == NULL) return "HMAC_Update";
if ((*(void **)&(X509_NAME_get_index_by_NID_d) = dlsym(magma, "X509_NAME_get_index_by_NID")) == NULL) return "X509_NAME_get_index_by_NID";
if ((*(void **)&(SSL_CTX_use_certificate_chain_file_d) = dlsym(magma, "SSL_CTX_use_certificate_chain_file")) == NULL) return "SSL_CTX_use_certificate_chain_file";
if ((*(void **)&(ASN1_GENERALIZEDTIME_print_d) = dlsym(magma, "ASN1_GENERALIZEDTIME_print")) == NULL) return "ASN1_GENERALIZEDTIME_print";
if ((*(void **)&(OCSP_request_add0_id_d) = dlsym(magma, "OCSP_request_add0_id")) == NULL) return "OCSP_request_add0_id";
if ((*(void **)&(EC_KEY_set_conv_form_d) = dlsym(magma, "EC_KEY_set_conv_form")) == NULL) return "EC_KEY_set_conv_form";
if ((*(void **)&(OCSP_RESPONSE_print_d) = dlsym(magma, "OCSP_RESPONSE_print")) == NULL) return "OCSP_RESPONSE_print";
if ((*(void **)&(EVP_DigestFinal_d) = dlsym(magma, "EVP_DigestFinal")) == NULL) return "EVP_DigestFinal";
if ((*(void **)&(EVP_DigestInit_ex_d) = dlsym(magma, "EVP_DigestInit_ex")) == NULL) return "EVP_DigestInit_ex";
if ((*(void **)&(SSL_CTX_use_PrivateKey_file_d) = dlsym(magma, "SSL_CTX_use_PrivateKey_file")) == NULL) return "SSL_CTX_use_PrivateKey_file";
if ((*(void **)&(X509_STORE_add_lookup_d) = dlsym(magma, "X509_STORE_add_lookup")) == NULL) return "X509_STORE_add_lookup";
if ((*(void **)&(EVP_CIPHER_CTX_ctrl_d) = dlsym(magma, "EVP_CIPHER_CTX_ctrl")) == NULL) return "EVP_CIPHER_CTX_ctrl";
if ((*(void **)&(X509_NAME_get_text_by_NID_d) = dlsym(magma, "X509_NAME_get_text_by_NID")) == NULL) return "X509_NAME_get_text_by_NID";
if ((*(void **)&(o2i_ECPublicKey_d) = dlsym(magma, "o2i_ECPublicKey")) == NULL) return "o2i_ECPublicKey";
if ((*(void **)&(OCSP_request_add1_nonce_d) = dlsym(magma, "OCSP_request_add1_nonce")) == NULL) return "OCSP_request_add1_nonce";
if ((*(void **)&(EVP_DigestFinal_ex_d) = dlsym(magma, "EVP_DigestFinal_ex")) == NULL) return "EVP_DigestFinal_ex";
if ((*(void **)&(EVP_EncryptFinal_ex_d) = dlsym(magma, "EVP_EncryptFinal_ex")) == NULL) return "EVP_EncryptFinal_ex";
if ((*(void **)&(d2i_ECPrivateKey_d) = dlsym(magma, "d2i_ECPrivateKey")) == NULL) return "d2i_ECPrivateKey";
if ((*(void **)&(SHA512_d) = dlsym(magma, "SHA512")) == NULL) return "SHA512";
if ((*(void **)&(EVP_DecryptFinal_ex_d) = dlsym(magma, "EVP_DecryptFinal_ex")) == NULL) return "EVP_DecryptFinal_ex";
if ((*(void **)&(EC_GROUP_set_point_conversion_form_d) = dlsym(magma, "EC_GROUP_set_point_conversion_form")) == NULL) return "EC_GROUP_set_point_conversion_form";
if ((*(void **)&(ED25519_keypair_d) = dlsym(magma, "ED25519_keypair")) == NULL) return "ED25519_keypair";
if ((*(void **)&(ERR_put_error_d) = dlsym(magma, "ERR_put_error")) == NULL) return "ERR_put_error";
if ((*(void **)&(OCSP_cert_to_id_d) = dlsym(magma, "OCSP_cert_to_id")) == NULL) return "OCSP_cert_to_id";
if ((*(void **)&(d2i_ECDSA_SIG_d) = dlsym(magma, "d2i_ECDSA_SIG")) == NULL) return "d2i_ECDSA_SIG";
if ((*(void **)&(DH_generate_parameters_ex_d) = dlsym(magma, "DH_generate_parameters_ex")) == NULL) return "DH_generate_parameters_ex";
if ((*(void **)&(ECDSA_do_sign_d) = dlsym(magma, "ECDSA_do_sign")) == NULL) return "ECDSA_do_sign";
if ((*(void **)&(X509_STORE_load_locations_d) = dlsym(magma, "X509_STORE_load_locations")) == NULL) return "X509_STORE_load_locations";
if ((*(void **)&(SSL_CTX_set_verify_d) = dlsym(magma, "SSL_CTX_set_verify")) == NULL) return "SSL_CTX_set_verify";
if ((*(void **)&(EC_POINT_hex2point_d) = dlsym(magma, "EC_POINT_hex2point")) == NULL) return "EC_POINT_hex2point";
if ((*(void **)&(CRYPTO_set_locked_mem_functions_d) = dlsym(magma, "CRYPTO_set_locked_mem_functions")) == NULL) return "CRYPTO_set_locked_mem_functions";
if ((*(void **)&(OCSP_REQ_CTX_add1_header_d) = dlsym(magma, "OCSP_REQ_CTX_add1_header")) == NULL) return "OCSP_REQ_CTX_add1_header";
if ((*(void **)&(X509_STORE_CTX_set_chain_d) = dlsym(magma, "X509_STORE_CTX_set_chain")) == NULL) return "X509_STORE_CTX_set_chain";
if ((*(void **)&(SSL_CTX_load_verify_locations_d) = dlsym(magma, "SSL_CTX_load_verify_locations")) == NULL) return "SSL_CTX_load_verify_locations";
if ((*(void **)&(d2i_OCSP_RESPONSE_d) = dlsym(magma, "d2i_OCSP_RESPONSE")) == NULL) return "d2i_OCSP_RESPONSE";
if ((*(void **)&(OCSP_parse_url_d) = dlsym(magma, "OCSP_parse_url")) == NULL) return "OCSP_parse_url";
if ((*(void **)&(HMAC_Init_ex_d) = dlsym(magma, "HMAC_Init_ex")) == NULL) return "HMAC_Init_ex";
if ((*(void **)&(OCSP_sendreq_new_d) = dlsym(magma, "OCSP_sendreq_new")) == NULL) return "OCSP_sendreq_new";
if ((*(void **)&(EC_POINT_cmp_d) = dlsym(magma, "EC_POINT_cmp")) == NULL) return "EC_POINT_cmp";
if ((*(void **)&(SSL_CTX_set_tmp_dh_callback_d) = dlsym(magma, "SSL_CTX_set_tmp_dh_callback")) == NULL) return "SSL_CTX_set_tmp_dh_callback";
if ((*(void **)&(ECDSA_do_verify_d) = dlsym(magma, "ECDSA_do_verify")) == NULL) return "ECDSA_do_verify";
if ((*(void **)&(X509_check_host_d) = dlsym(magma, "X509_check_host")) == NULL) return "X509_check_host";
if ((*(void **)&(CRYPTO_set_mem_functions_d) = dlsym(magma, "CRYPTO_set_mem_functions")) == NULL) return "CRYPTO_set_mem_functions";
if ((*(void **)&(X509_STORE_CTX_init_d) = dlsym(magma, "X509_STORE_CTX_init")) == NULL) return "X509_STORE_CTX_init";
if ((*(void **)&(ERR_peek_error_line_data_d) = dlsym(magma, "ERR_peek_error_line_data")) == NULL) return "ERR_peek_error_line_data";
if ((*(void **)&(EC_POINT_point2hex_d) = dlsym(magma, "EC_POINT_point2hex")) == NULL) return "EC_POINT_point2hex";
if ((*(void **)&(OCSP_basic_verify_d) = dlsym(magma, "OCSP_basic_verify")) == NULL) return "OCSP_basic_verify";
if ((*(void **)&(CRYPTO_set_locking_callback_d) = dlsym(magma, "CRYPTO_set_locking_callback")) == NULL) return "CRYPTO_set_locking_callback";
if ((*(void **)&(EVP_VerifyFinal_d) = dlsym(magma, "EVP_VerifyFinal")) == NULL) return "EVP_VerifyFinal";
if ((*(void **)&(SSL_CTX_set_tmp_ecdh_callback_d) = dlsym(magma, "SSL_CTX_set_tmp_ecdh_callback")) == NULL) return "SSL_CTX_set_tmp_ecdh_callback";
if ((*(void **)&(EVP_DecryptUpdate_d) = dlsym(magma, "EVP_DecryptUpdate")) == NULL) return "EVP_DecryptUpdate";
if ((*(void **)&(EVP_EncryptUpdate_d) = dlsym(magma, "EVP_EncryptUpdate")) == NULL) return "EVP_EncryptUpdate";
if ((*(void **)&(OCSP_check_validity_d) = dlsym(magma, "OCSP_check_validity")) == NULL) return "OCSP_check_validity";
if ((*(void **)&(ED25519_sign_d) = dlsym(magma, "ED25519_sign")) == NULL) return "ED25519_sign";
if ((*(void **)&(EC_POINT_oct2point_d) = dlsym(magma, "EC_POINT_oct2point")) == NULL) return "EC_POINT_oct2point";
if ((*(void **)&(ED25519_keypair_from_seed_d) = dlsym(magma, "ED25519_keypair_from_seed")) == NULL) return "ED25519_keypair_from_seed";
if ((*(void **)&(EVP_Digest_d) = dlsym(magma, "EVP_Digest")) == NULL) return "EVP_Digest";
if ((*(void **)&(ED25519_verify_d) = dlsym(magma, "ED25519_verify")) == NULL) return "ED25519_verify";
if ((*(void **)&(EVP_DecryptInit_ex_d) = dlsym(magma, "EVP_DecryptInit_ex")) == NULL) return "EVP_DecryptInit_ex";
if ((*(void **)&(EVP_EncryptInit_ex_d) = dlsym(magma, "EVP_EncryptInit_ex")) == NULL) return "EVP_EncryptInit_ex";
if ((*(void **)&(EC_POINT_mul_d) = dlsym(magma, "EC_POINT_mul")) == NULL) return "EC_POINT_mul";
if ((*(void **)&(EC_POINT_point2oct_d) = dlsym(magma, "EC_POINT_point2oct")) == NULL) return "EC_POINT_point2oct";
if ((*(void **)&(ECDH_compute_key_d) = dlsym(magma, "ECDH_compute_key")) == NULL) return "ECDH_compute_key";
if ((*(void **)&(OCSP_resp_find_status_d) = dlsym(magma, "OCSP_resp_find_status")) == NULL) return "OCSP_resp_find_status";
if ((*(void **)&(png_access_version_number_d) = dlsym(magma, "png_access_version_number")) == NULL) return "png_access_version_number";
if ((*(void **)&(SPF_server_free_d) = dlsym(magma, "SPF_server_free")) == NULL) return "SPF_server_free";
if ((*(void **)&(SPF_request_free_d) = dlsym(magma, "SPF_request_free")) == NULL) return "SPF_request_free";
if ((*(void **)&(SPF_response_free_d) = dlsym(magma, "SPF_response_free")) == NULL) return "SPF_response_free";
if ((*(void **)&(SPF_strreason_d) = dlsym(magma, "SPF_strreason")) == NULL) return "SPF_strreason";
if ((*(void **)&(SPF_strresult_d) = dlsym(magma, "SPF_strresult")) == NULL) return "SPF_strresult";
if ((*(void **)&(SPF_strerror_d) = dlsym(magma, "SPF_strerror")) == NULL) return "SPF_strerror";
if ((*(void **)&(SPF_response_reason_d) = dlsym(magma, "SPF_response_reason")) == NULL) return "SPF_response_reason";
if ((*(void **)&(SPF_response_result_d) = dlsym(magma, "SPF_response_result")) == NULL) return "SPF_response_result";
if ((*(void **)&(SPF_request_new_d) = dlsym(magma, "SPF_request_new")) == NULL) return "SPF_request_new";
if ((*(void **)&(SPF_get_lib_version_d) = dlsym(magma, "SPF_get_lib_version")) == NULL) return "SPF_get_lib_version";
if ((*(void **)&(SPF_request_set_env_from_d) = dlsym(magma, "SPF_request_set_env_from")) == NULL) return "SPF_request_set_env_from";
if ((*(void **)&(SPF_server_new_d) = dlsym(magma, "SPF_server_new")) == NULL) return "SPF_server_new";
if ((*(void **)&(SPF_request_set_helo_dom_d) = dlsym(magma, "SPF_request_set_helo_dom")) == NULL) return "SPF_request_set_helo_dom";
if ((*(void **)&(SPF_request_set_ipv4_d) = dlsym(magma, "SPF_request_set_ipv4")) == NULL) return "SPF_request_set_ipv4";
if ((*(void **)&(SPF_request_set_ipv6_d) = dlsym(magma, "SPF_request_set_ipv6")) == NULL) return "SPF_request_set_ipv6";
if ((*(void **)&(SPF_dns_zone_new_d) = dlsym(magma, "SPF_dns_zone_new")) == NULL) return "SPF_dns_zone_new";
if ((*(void **)&(SPF_request_query_mailfrom_d) = dlsym(magma, "SPF_request_query_mailfrom")) == NULL) return "SPF_request_query_mailfrom";
if ((*(void **)&(SPF_dns_zone_add_str_d) = dlsym(magma, "SPF_dns_zone_add_str")) == NULL) return "SPF_dns_zone_add_str";
if ((*(void **)&(tchdbnew_d) = dlsym(magma, "tchdbnew")) == NULL) return "tchdbnew";
if ((*(void **)&(tcfree_d) = dlsym(magma, "tcfree")) == NULL) return "tcfree";
if ((*(void **)&(tchdbdel_d) = dlsym(magma, "tchdbdel")) == NULL) return "tchdbdel";
if ((*(void **)&(tchdbsync_d) = dlsym(magma, "tchdbsync")) == NULL) return "tchdbsync";
if ((*(void **)&(tchdbecode_d) = dlsym(magma, "tchdbecode")) == NULL) return "tchdbecode";
if ((*(void **)&(tcndbdel_d) = dlsym(magma, "tcndbdel")) == NULL) return "tcndbdel";
if ((*(void **)&(tchdbclose_d) = dlsym(magma, "tchdbclose")) == NULL) return "tchdbclose";
if ((*(void **)&(tclistdel_d) = dlsym(magma, "tclistdel")) == NULL) return "tclistdel";
if ((*(void **)&(tcndbdup_d) = dlsym(magma, "tcndbdup")) == NULL) return "tcndbdup";
if ((*(void **)&(tctreeclear_d) = dlsym(magma, "tctreeclear")) == NULL) return "tctreeclear";
if ((*(void **)&(tchdbsetmutex_d) = dlsym(magma, "tchdbsetmutex")) == NULL) return "tchdbsetmutex";
if ((*(void **)&(tchdbfsiz_d) = dlsym(magma, "tchdbfsiz")) == NULL) return "tchdbfsiz";
if ((*(void **)&(tchdbrnum_d) = dlsym(magma, "tchdbrnum")) == NULL) return "tchdbrnum";
if ((*(void **)&(tcndbrnum_d) = dlsym(magma, "tcndbrnum")) == NULL) return "tcndbrnum";
if ((*(void **)&(tcndbiterinit_d) = dlsym(magma, "tcndbiterinit")) == NULL) return "tcndbiterinit";
if ((*(void **)&(tcndbiternext2_d) = dlsym(magma, "tcndbiternext2")) == NULL) return "tcndbiternext2";
if ((*(void **)&(tclistnum_d) = dlsym(magma, "tclistnum")) == NULL) return "tclistnum";
if ((*(void **)&(tchdberrmsg_d) = dlsym(magma, "tchdberrmsg")) == NULL) return "tchdberrmsg";
if ((*(void **)&(tchdbpath_d) = dlsym(magma, "tchdbpath")) == NULL) return "tchdbpath";
if ((*(void **)&(tctreekeys_d) = dlsym(magma, "tctreekeys")) == NULL) return "tctreekeys";
if ((*(void **)&(tctreevals_d) = dlsym(magma, "tctreevals")) == NULL) return "tctreevals";
if ((*(void **)&(tcndbnew2_d) = dlsym(magma, "tcndbnew2")) == NULL) return "tcndbnew2";
if ((*(void **)&(tchdbdefrag_d) = dlsym(magma, "tchdbdefrag")) == NULL) return "tchdbdefrag";
if ((*(void **)&(tchdbsetdfunit_d) = dlsym(magma, "tchdbsetdfunit")) == NULL) return "tchdbsetdfunit";
if ((*(void **)&(tchdbout_d) = dlsym(magma, "tchdbout")) == NULL) return "tchdbout";
if ((*(void **)&(tcndbout_d) = dlsym(magma, "tcndbout")) == NULL) return "tcndbout";
if ((*(void **)&(tchdbopen_d) = dlsym(magma, "tchdbopen")) == NULL) return "tchdbopen";
if ((*(void **)&(tclistval_d) = dlsym(magma, "tclistval")) == NULL) return "tclistval";
if ((*(void **)&(tchdbget_d) = dlsym(magma, "tchdbget")) == NULL) return "tchdbget";
if ((*(void **)&(tcndbget3_d) = dlsym(magma, "tcndbget3")) == NULL) return "tcndbget3";
if ((*(void **)&(tcndbget_d) = dlsym(magma, "tcndbget")) == NULL) return "tcndbget";
if ((*(void **)&(tcndbfwmkeys_d) = dlsym(magma, "tcndbfwmkeys")) == NULL) return "tcndbfwmkeys";
if ((*(void **)&(tchdbtune_d) = dlsym(magma, "tchdbtune")) == NULL) return "tchdbtune";
if ((*(void **)&(tchdboptimize_d) = dlsym(magma, "tchdboptimize")) == NULL) return "tchdboptimize";
if ((*(void **)&(tcndbputkeep_d) = dlsym(magma, "tcndbputkeep")) == NULL) return "tcndbputkeep";
if ((*(void **)&(tchdbputasync_d) = dlsym(magma, "tchdbputasync")) == NULL) return "tchdbputasync";
if ((*(void **)&(json_null_d) = dlsym(magma, "json_null")) == NULL) return "json_null";
if ((*(void **)&(json_true_d) = dlsym(magma, "json_true")) == NULL) return "json_true";
if ((*(void **)&(json_array_d) = dlsym(magma, "json_array")) == NULL) return "json_array";
if ((*(void **)&(json_false_d) = dlsym(magma, "json_false")) == NULL) return "json_false";
if ((*(void **)&(json_object_d) = dlsym(magma, "json_object")) == NULL) return "json_object";
if ((*(void **)&(json_decref_d) = dlsym(magma, "json_decref")) == NULL) return "json_decref";
if ((*(void **)&(json_delete_d) = dlsym(magma, "json_delete")) == NULL) return "json_delete";
if ((*(void **)&(json_real_d) = dlsym(magma, "json_real")) == NULL) return "json_real";
if ((*(void **)&(json_copy_d) = dlsym(magma, "json_copy")) == NULL) return "json_copy";
if ((*(void **)&(jansson_version_d) = dlsym(magma, "jansson_version")) == NULL) return "jansson_version";
if ((*(void **)&(json_incref_d) = dlsym(magma, "json_incref")) == NULL) return "json_incref";
if ((*(void **)&(json_array_clear_d) = dlsym(magma, "json_array_clear")) == NULL) return "json_array_clear";
if ((*(void **)&(json_object_clear_d) = dlsym(magma, "json_object_clear")) == NULL) return "json_object_clear";
if ((*(void **)&(json_deep_copy_d) = dlsym(magma, "json_deep_copy")) == NULL) return "json_deep_copy";
if ((*(void **)&(json_integer_d) = dlsym(magma, "json_integer")) == NULL) return "json_integer";
if ((*(void **)&(json_object_iter_d) = dlsym(magma, "json_object_iter")) == NULL) return "json_object_iter";
if ((*(void **)&(json_string_d) = dlsym(magma, "json_string")) == NULL) return "json_string";
if ((*(void **)&(json_pack_d) = dlsym(magma, "json_pack")) == NULL) return "json_pack";
if ((*(void **)&(json_real_value_d) = dlsym(magma, "json_real_value")) == NULL) return "json_real_value";
if ((*(void **)&(json_array_size_d) = dlsym(magma, "json_array_size")) == NULL) return "json_array_size";
if ((*(void **)&(json_type_string_d) = dlsym(magma, "json_type_string")) == NULL) return "json_type_string";
if ((*(void **)&(json_object_iter_value_d) = dlsym(magma, "json_object_iter_value")) == NULL) return "json_object_iter_value";
if ((*(void **)&(json_number_value_d) = dlsym(magma, "json_number_value")) == NULL) return "json_number_value";
if ((*(void **)&(json_object_iter_key_d) = dlsym(magma, "json_object_iter_key")) == NULL) return "json_object_iter_key";
if ((*(void **)&(json_object_size_d) = dlsym(magma, "json_object_size")) == NULL) return "json_object_size";
if ((*(void **)&(json_real_set_d) = dlsym(magma, "json_real_set")) == NULL) return "json_real_set";
if ((*(void **)&(json_equal_d) = dlsym(magma, "json_equal")) == NULL) return "json_equal";
if ((*(void **)&(json_string_nocheck_d) = dlsym(magma, "json_string_nocheck")) == NULL) return "json_string_nocheck";
if ((*(void **)&(json_array_remove_d) = dlsym(magma, "json_array_remove")) == NULL) return "json_array_remove";
if ((*(void **)&(json_array_append_d) = dlsym(magma, "json_array_append")) == NULL) return "json_array_append";
if ((*(void **)&(json_array_extend_d) = dlsym(magma, "json_array_extend")) == NULL) return "json_array_extend";
if ((*(void **)&(json_dumps_d) = dlsym(magma, "json_dumps")) == NULL) return "json_dumps";
if ((*(void **)&(json_unpack_d) = dlsym(magma, "json_unpack")) == NULL) return "json_unpack";
if ((*(void **)&(json_integer_value_d) = dlsym(magma, "json_integer_value")) == NULL) return "json_integer_value";
if ((*(void **)&(json_object_del_d) = dlsym(magma, "json_object_del")) == NULL) return "json_object_del";
if ((*(void **)&(json_string_value_d) = dlsym(magma, "json_string_value")) == NULL) return "json_string_value";
if ((*(void **)&(json_object_update_d) = dlsym(magma, "json_object_update")) == NULL) return "json_object_update";
if ((*(void **)&(json_string_set_d) = dlsym(magma, "json_string_set")) == NULL) return "json_string_set";
if ((*(void **)&(json_array_append_new_d) = dlsym(magma, "json_array_append_new")) == NULL) return "json_array_append_new";
if ((*(void **)&(json_integer_set_d) = dlsym(magma, "json_integer_set")) == NULL) return "json_integer_set";
if ((*(void **)&(json_object_iter_next_d) = dlsym(magma, "json_object_iter_next")) == NULL) return "json_object_iter_next";
if ((*(void **)&(json_array_get_d) = dlsym(magma, "json_array_get")) == NULL) return "json_array_get";
if ((*(void **)&(json_object_iter_at_d) = dlsym(magma, "json_object_iter_at")) == NULL) return "json_object_iter_at";
if ((*(void **)&(json_array_set_d) = dlsym(magma, "json_array_set")) == NULL) return "json_array_set";
if ((*(void **)&(json_dumpf_d) = dlsym(magma, "json_dumpf")) == NULL) return "json_dumpf";
if ((*(void **)&(json_string_set_nocheck_d) = dlsym(magma, "json_string_set_nocheck")) == NULL) return "json_string_set_nocheck";
if ((*(void **)&(json_object_get_d) = dlsym(magma, "json_object_get")) == NULL) return "json_object_get";
if ((*(void **)&(json_array_insert_d) = dlsym(magma, "json_array_insert")) == NULL) return "json_array_insert";
if ((*(void **)&(json_array_set_new_d) = dlsym(magma, "json_array_set_new")) == NULL) return "json_array_set_new";
if ((*(void **)&(json_loadf_d) = dlsym(magma, "json_loadf")) == NULL) return "json_loadf";
if ((*(void **)&(json_object_iter_set_d) = dlsym(magma, "json_object_iter_set")) == NULL) return "json_object_iter_set";
if ((*(void **)&(json_object_set_d) = dlsym(magma, "json_object_set")) == NULL) return "json_object_set";
if ((*(void **)&(json_array_insert_new_d) = dlsym(magma, "json_array_insert_new")) == NULL) return "json_array_insert_new";
if ((*(void **)&(json_dump_file_d) = dlsym(magma, "json_dump_file")) == NULL) return "json_dump_file";
if ((*(void **)&(json_object_iter_set_new_d) = dlsym(magma, "json_object_iter_set_new")) == NULL) return "json_object_iter_set_new";
if ((*(void **)&(json_object_set_new_d) = dlsym(magma, "json_object_set_new")) == NULL) return "json_object_set_new";
if ((*(void **)&(json_set_alloc_funcs_d) = dlsym(magma, "json_set_alloc_funcs")) == NULL) return "json_set_alloc_funcs";
if ((*(void **)&(json_loads_d) = dlsym(magma, "json_loads")) == NULL) return "json_loads";
if ((*(void **)&(json_object_set_nocheck_d) = dlsym(magma, "json_object_set_nocheck")) == NULL) return "json_object_set_nocheck";
if ((*(void **)&(json_load_file_d) = dlsym(magma, "json_load_file")) == NULL) return "json_load_file";
if ((*(void **)&(json_pack_ex_d) = dlsym(magma, "json_pack_ex")) == NULL) return "json_pack_ex";
if ((*(void **)&(json_object_set_new_nocheck_d) = dlsym(magma, "json_object_set_new_nocheck")) == NULL) return "json_object_set_new_nocheck";
if ((*(void **)&(json_vpack_ex_d) = dlsym(magma, "json_vpack_ex")) == NULL) return "json_vpack_ex";
if ((*(void **)&(json_unpack_ex_d) = dlsym(magma, "json_unpack_ex")) == NULL) return "json_unpack_ex";
if ((*(void **)&(json_vunpack_ex_d) = dlsym(magma, "json_vunpack_ex")) == NULL) return "json_vunpack_ex";
if ((*(void **)&(utf8proc_version_d) = dlsym(magma, "utf8proc_version")) == NULL) return "utf8proc_version";
if ((*(void **)&(utf8proc_errmsg_d) = dlsym(magma, "utf8proc_errmsg")) == NULL) return "utf8proc_errmsg";
if ((*(void **)&(utf8proc_category_string_d) = dlsym(magma, "utf8proc_category_string")) == NULL) return "utf8proc_category_string";
if ((*(void **)&(utf8proc_category_d) = dlsym(magma, "utf8proc_category")) == NULL) return "utf8proc_category";
if ((*(void **)&(utf8proc_get_property_d) = dlsym(magma, "utf8proc_get_property")) == NULL) return "utf8proc_get_property";
if ((*(void **)&(utf8proc_iterate_d) = dlsym(magma, "utf8proc_iterate")) == NULL) return "utf8proc_iterate";
if ((*(void **)&(xmlInitParser_d) = dlsym(magma, "xmlInitParser")) == NULL) return "xmlInitParser";
if ((*(void **)&(xmlMemoryDump_d) = dlsym(magma, "xmlMemoryDump")) == NULL) return "xmlMemoryDump";
if ((*(void **)&(xmlCleanupParser_d) = dlsym(magma, "xmlCleanupParser")) == NULL) return "xmlCleanupParser";
if ((*(void **)&(xmlCleanupGlobals_d) = dlsym(magma, "xmlCleanupGlobals")) == NULL) return "xmlCleanupGlobals";
if ((*(void **)&(xmlFreeDoc_d) = dlsym(magma, "xmlFreeDoc")) == NULL) return "xmlFreeDoc";
if ((*(void **)&(xmlFreeNode_d) = dlsym(magma, "xmlFreeNode")) == NULL) return "xmlFreeNode";
if ((*(void **)&(xmlBufferCreate_d) = dlsym(magma, "xmlBufferCreate")) == NULL) return "xmlBufferCreate";
if ((*(void **)&(xmlBufferFree_d) = dlsym(magma, "xmlBufferFree")) == NULL) return "xmlBufferFree";
if ((*(void **)&(xmlNewParserCtxt_d) = dlsym(magma, "xmlNewParserCtxt")) == NULL) return "xmlNewParserCtxt";
if ((*(void **)&(xmlBufferLength_d) = dlsym(magma, "xmlBufferLength")) == NULL) return "xmlBufferLength";
if ((*(void **)&(xmlFreeParserCtxt_d) = dlsym(magma, "xmlFreeParserCtxt")) == NULL) return "xmlFreeParserCtxt";
if ((*(void **)&(xmlXPathFreeObject_d) = dlsym(magma, "xmlXPathFreeObject")) == NULL) return "xmlXPathFreeObject";
if ((*(void **)&(xmlXPathFreeContext_d) = dlsym(magma, "xmlXPathFreeContext")) == NULL) return "xmlXPathFreeContext";
if ((*(void **)&(xmlXPathNewContext_d) = dlsym(magma, "xmlXPathNewContext")) == NULL) return "xmlXPathNewContext";
if ((*(void **)&(xmlBufferContent_d) = dlsym(magma, "xmlBufferContent")) == NULL) return "xmlBufferContent";
if ((*(void **)&(xmlNewNode_d) = dlsym(magma, "xmlNewNode")) == NULL) return "xmlNewNode";
if ((*(void **)&(xmlAddSibling_d) = dlsym(magma, "xmlAddSibling")) == NULL) return "xmlAddSibling";
if ((*(void **)&(xmlNodeSetContent_d) = dlsym(magma, "xmlNodeSetContent")) == NULL) return "xmlNodeSetContent";
if ((*(void **)&(xmlNodeBufGetContent_d) = dlsym(magma, "xmlNodeBufGetContent")) == NULL) return "xmlNodeBufGetContent";
if ((*(void **)&(xmlEncodeEntitiesReentrant_d) = dlsym(magma, "xmlEncodeEntitiesReentrant")) == NULL) return "xmlEncodeEntitiesReentrant";
if ((*(void **)&(xmlDocDumpFormatMemory_d) = dlsym(magma, "xmlDocDumpFormatMemory")) == NULL) return "xmlDocDumpFormatMemory";
if ((*(void **)&(xmlSetProp_d) = dlsym(magma, "xmlSetProp")) == NULL) return "xmlSetProp";
if ((*(void **)&(xmlXPathEvalExpression_d) = dlsym(magma, "xmlXPathEvalExpression")) == NULL) return "xmlXPathEvalExpression";
if ((*(void **)&(xmlXPathRegisterNs_d) = dlsym(magma, "xmlXPathRegisterNs")) == NULL) return "xmlXPathRegisterNs";
if ((*(void **)&(xmlCtxtReadMemory_d) = dlsym(magma, "xmlCtxtReadMemory")) == NULL) return "xmlCtxtReadMemory";
if ((*(void **)&(zlibVersion_d) = dlsym(magma, "zlibVersion")) == NULL) return "zlibVersion";
if ((*(void **)&(compressBound_d) = dlsym(magma, "compressBound")) == NULL) return "compressBound";
if ((*(void **)&(uncompress_d) = dlsym(magma, "uncompress")) == NULL) return "uncompress";
if ((*(void **)&(compress2_d) = dlsym(magma, "compress2")) == NULL) return "compress2";
return NULL;
}
