import { Service } from "../service.ts";
export class Locale extends Service {
    async get() {
        let path = '/locale';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getContinents() {
        let path = '/locale/continents';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getCountries() {
        let path = '/locale/countries';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getCountriesEU() {
        let path = '/locale/countries/eu';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getCountriesPhones() {
        let path = '/locale/countries/phones';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getCurrencies() {
        let path = '/locale/currencies';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9jYWxlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibG9jYWxlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxPQUFPLEVBQUUsTUFBTSxlQUFlLENBQUM7QUFHeEMsTUFBTSxPQUFPLE1BQU8sU0FBUSxPQUFPO0lBZS9CLEtBQUssQ0FBQyxHQUFHO1FBQ0wsSUFBSSxJQUFJLEdBQUcsU0FBUyxDQUFDO1FBRXJCLE9BQU8sTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQy9CLGNBQWMsRUFBRSxrQkFBa0I7U0FDdEMsRUFDRCxFQUNGLENBQUMsQ0FBQztJQUNYLENBQUM7SUFXRCxLQUFLLENBQUMsYUFBYTtRQUNmLElBQUksSUFBSSxHQUFHLG9CQUFvQixDQUFDO1FBRWhDLE9BQU8sTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQy9CLGNBQWMsRUFBRSxrQkFBa0I7U0FDdEMsRUFDRCxFQUNGLENBQUMsQ0FBQztJQUNYLENBQUM7SUFXRCxLQUFLLENBQUMsWUFBWTtRQUNkLElBQUksSUFBSSxHQUFHLG1CQUFtQixDQUFDO1FBRS9CLE9BQU8sTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQy9CLGNBQWMsRUFBRSxrQkFBa0I7U0FDdEMsRUFDRCxFQUNGLENBQUMsQ0FBQztJQUNYLENBQUM7SUFXRCxLQUFLLENBQUMsY0FBYztRQUNoQixJQUFJLElBQUksR0FBRyxzQkFBc0IsQ0FBQztRQUVsQyxPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0QsRUFDRixDQUFDLENBQUM7SUFDWCxDQUFDO0lBV0QsS0FBSyxDQUFDLGtCQUFrQjtRQUNwQixJQUFJLElBQUksR0FBRywwQkFBMEIsQ0FBQztRQUV0QyxPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0QsRUFDRixDQUFDLENBQUM7SUFDWCxDQUFDO0lBWUQsS0FBSyxDQUFDLGFBQWE7UUFDZixJQUFJLElBQUksR0FBRyxvQkFBb0IsQ0FBQztRQUVoQyxPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0QsRUFDRixDQUFDLENBQUM7SUFDWCxDQUFDO0NBQ0oifQ==