import { Service } from "../service.ts";
export class Avatars extends Service {
    async getBrowser(code, width = 100, height = 100, quality = 100) {
        let path = '/avatars/browsers/{code}'.replace(new RegExp('{code}', 'g'), code);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'width': width,
            'height': height,
            'quality': quality
        });
    }
    async getCreditCard(code, width = 100, height = 100, quality = 100) {
        let path = '/avatars/credit-cards/{code}'.replace(new RegExp('{code}', 'g'), code);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'width': width,
            'height': height,
            'quality': quality
        });
    }
    async getFavicon(url) {
        let path = '/avatars/favicon';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'url': url
        });
    }
    async getFlag(code, width = 100, height = 100, quality = 100) {
        let path = '/avatars/flags/{code}'.replace(new RegExp('{code}', 'g'), code);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'width': width,
            'height': height,
            'quality': quality
        });
    }
    async getImage(url, width = 400, height = 400) {
        let path = '/avatars/image';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'url': url,
            'width': width,
            'height': height
        });
    }
    async getQR(text, size = 400, margin = 1, download = 0) {
        let path = '/avatars/qr';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'text': text,
            'size': size,
            'margin': margin,
            'download': download
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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