import { Service } from "../service.ts";
export class Storage extends Service {
    async listFiles(search = '', limit = 25, offset = 0, orderType = 'ASC') {
        let path = '/storage/files';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'search': search,
            'limit': limit,
            'offset': offset,
            'orderType': orderType
        });
    }
    async createFile(file, read, write) {
        let path = '/storage/files';
        return await this.client.call('post', path, {
            'content-type': 'multipart/form-data',
        }, {
            'file': file,
            'read': read,
            'write': write
        });
    }
    async getFile(fileId) {
        let path = '/storage/files/{fileId}'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async updateFile(fileId, read, write) {
        let path = '/storage/files/{fileId}'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('put', path, {
            'content-type': 'application/json',
        }, {
            'read': read,
            'write': write
        });
    }
    async deleteFile(fileId) {
        let path = '/storage/files/{fileId}'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getFileDownload(fileId) {
        let path = '/storage/files/{fileId}/download'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getFilePreview(fileId, width = 0, height = 0, quality = 100, background = '', output = '') {
        let path = '/storage/files/{fileId}/preview'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'width': width,
            'height': height,
            'quality': quality,
            'background': background,
            'output': output
        });
    }
    async getFileView(fileId, as = '') {
        let path = '/storage/files/{fileId}/view'.replace(new RegExp('{fileId}', 'g'), fileId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'as': as
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RvcmFnZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInN0b3JhZ2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUFFLE9BQU8sRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUd4QyxNQUFNLE9BQU8sT0FBUSxTQUFRLE9BQU87SUFnQmhDLEtBQUssQ0FBQyxTQUFTLENBQUMsU0FBaUIsRUFBRSxFQUFFLFFBQWdCLEVBQUUsRUFBRSxTQUFpQixDQUFDLEVBQUUsWUFBb0IsS0FBSztRQUNsRyxJQUFJLElBQUksR0FBRyxnQkFBZ0IsQ0FBQztRQUU1QixPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0Q7WUFDQyxRQUFRLEVBQUUsTUFBTTtZQUNoQixPQUFPLEVBQUUsS0FBSztZQUNkLFFBQVEsRUFBRSxNQUFNO1lBQ2hCLFdBQVcsRUFBRSxTQUFTO1NBQ3pCLENBQUMsQ0FBQztJQUNYLENBQUM7SUFlRCxLQUFLLENBQUMsVUFBVSxDQUFDLElBQWlCLEVBQUUsSUFBZ0IsRUFBRSxLQUFpQjtRQUNuRSxJQUFJLElBQUksR0FBRyxnQkFBZ0IsQ0FBQztRQUU1QixPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLElBQUksRUFBRTtZQUNoQyxjQUFjLEVBQUUscUJBQXFCO1NBQ3pDLEVBQ0Q7WUFDQyxNQUFNLEVBQUUsSUFBSTtZQUNaLE1BQU0sRUFBRSxJQUFJO1lBQ1osT0FBTyxFQUFFLEtBQUs7U0FDakIsQ0FBQyxDQUFDO0lBQ1gsQ0FBQztJQVlELEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBYztRQUN4QixJQUFJLElBQUksR0FBRyx5QkFBeUIsQ0FBQyxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBRWxGLE9BQU8sTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQy9CLGNBQWMsRUFBRSxrQkFBa0I7U0FDdEMsRUFDRCxFQUNGLENBQUMsQ0FBQztJQUNYLENBQUM7SUFjRCxLQUFLLENBQUMsVUFBVSxDQUFDLE1BQWMsRUFBRSxJQUFnQixFQUFFLEtBQWlCO1FBQ2hFLElBQUksSUFBSSxHQUFHLHlCQUF5QixDQUFDLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFFbEYsT0FBTyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssRUFBRSxJQUFJLEVBQUU7WUFDL0IsY0FBYyxFQUFFLGtCQUFrQjtTQUN0QyxFQUNEO1lBQ0MsTUFBTSxFQUFFLElBQUk7WUFDWixPQUFPLEVBQUUsS0FBSztTQUNqQixDQUFDLENBQUM7SUFDWCxDQUFDO0lBWUQsS0FBSyxDQUFDLFVBQVUsQ0FBQyxNQUFjO1FBQzNCLElBQUksSUFBSSxHQUFHLHlCQUF5QixDQUFDLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUM7UUFFbEYsT0FBTyxNQUFNLElBQUksQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxJQUFJLEVBQUU7WUFDbEMsY0FBYyxFQUFFLGtCQUFrQjtTQUN0QyxFQUNELEVBQ0YsQ0FBQyxDQUFDO0lBQ1gsQ0FBQztJQWFELEtBQUssQ0FBQyxlQUFlLENBQUMsTUFBYztRQUNoQyxJQUFJLElBQUksR0FBRyxrQ0FBa0MsQ0FBQyxPQUFPLENBQUMsSUFBSSxNQUFNLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBRTNGLE9BQU8sTUFBTSxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFO1lBQy9CLGNBQWMsRUFBRSxrQkFBa0I7U0FDdEMsRUFDRCxFQUNGLENBQUMsQ0FBQztJQUNYLENBQUM7SUFtQkQsS0FBSyxDQUFDLGNBQWMsQ0FBQyxNQUFjLEVBQUUsUUFBZ0IsQ0FBQyxFQUFFLFNBQWlCLENBQUMsRUFBRSxVQUFrQixHQUFHLEVBQUUsYUFBcUIsRUFBRSxFQUFFLFNBQWlCLEVBQUU7UUFDM0ksSUFBSSxJQUFJLEdBQUcsaUNBQWlDLENBQUMsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUUxRixPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0Q7WUFDQyxPQUFPLEVBQUUsS0FBSztZQUNkLFFBQVEsRUFBRSxNQUFNO1lBQ2hCLFNBQVMsRUFBRSxPQUFPO1lBQ2xCLFlBQVksRUFBRSxVQUFVO1lBQ3hCLFFBQVEsRUFBRSxNQUFNO1NBQ25CLENBQUMsQ0FBQztJQUNYLENBQUM7SUFhRCxLQUFLLENBQUMsV0FBVyxDQUFDLE1BQWMsRUFBRSxLQUFhLEVBQUU7UUFDN0MsSUFBSSxJQUFJLEdBQUcsOEJBQThCLENBQUMsT0FBTyxDQUFDLElBQUksTUFBTSxDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsRUFBRSxNQUFNLENBQUMsQ0FBQztRQUV2RixPQUFPLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFLElBQUksRUFBRTtZQUMvQixjQUFjLEVBQUUsa0JBQWtCO1NBQ3RDLEVBQ0Q7WUFDQyxJQUFJLEVBQUUsRUFBRTtTQUNYLENBQUMsQ0FBQztJQUNYLENBQUM7Q0FDSiJ9