import { Service } from "../service.ts";
export class Database extends Service {
    async listCollections(search = '', limit = 25, offset = 0, orderType = 'ASC') {
        let path = '/database/collections';
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'search': search,
            'limit': limit,
            'offset': offset,
            'orderType': orderType
        });
    }
    async createCollection(name, read, write, rules) {
        let path = '/database/collections';
        return await this.client.call('post', path, {
            'content-type': 'application/json',
        }, {
            'name': name,
            'read': read,
            'write': write,
            'rules': rules
        });
    }
    async getCollection(collectionId) {
        let path = '/database/collections/{collectionId}'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async updateCollection(collectionId, name, read, write, rules = []) {
        let path = '/database/collections/{collectionId}'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('put', path, {
            'content-type': 'application/json',
        }, {
            'name': name,
            'read': read,
            'write': write,
            'rules': rules
        });
    }
    async deleteCollection(collectionId) {
        let path = '/database/collections/{collectionId}'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async listDocuments(collectionId, filters = [], offset = 0, limit = 50, orderField = '$id', orderType = 'ASC', orderCast = 'string', search = '', first = 0, last = 0) {
        let path = '/database/collections/{collectionId}/documents'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {
            'filters': filters,
            'offset': offset,
            'limit': limit,
            'orderField': orderField,
            'orderType': orderType,
            'orderCast': orderCast,
            'search': search,
            'first': first,
            'last': last
        });
    }
    async createDocument(collectionId, data, read, write, parentDocument = '', parentProperty = '', parentPropertyType = 'assign') {
        let path = '/database/collections/{collectionId}/documents'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('post', path, {
            'content-type': 'application/json',
        }, {
            'data': data,
            'read': read,
            'write': write,
            'parentDocument': parentDocument,
            'parentProperty': parentProperty,
            'parentPropertyType': parentPropertyType
        });
    }
    async getDocument(collectionId, documentId) {
        let path = '/database/collections/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}', 'g'), collectionId).replace(new RegExp('{documentId}', 'g'), documentId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
    async updateDocument(collectionId, documentId, data, read, write) {
        let path = '/database/collections/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}', 'g'), collectionId).replace(new RegExp('{documentId}', 'g'), documentId);
        return await this.client.call('patch', path, {
            'content-type': 'application/json',
        }, {
            'data': data,
            'read': read,
            'write': write
        });
    }
    async deleteDocument(collectionId, documentId) {
        let path = '/database/collections/{collectionId}/documents/{documentId}'.replace(new RegExp('{collectionId}', 'g'), collectionId).replace(new RegExp('{documentId}', 'g'), documentId);
        return await this.client.call('delete', path, {
            'content-type': 'application/json',
        }, {});
    }
    async getCollectionLogs(collectionId) {
        let path = '/database/collections/{collectionId}/logs'.replace(new RegExp('{collectionId}', 'g'), collectionId);
        return await this.client.call('get', path, {
            'content-type': 'application/json',
        }, {});
    }
}
//# sourceMappingURL=data:application/json;base64,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