<?php

/**
 * List Of World Currencies.
 *
 * Source:
 * https://gist.github.com/GoGross/19b254a4210d3d72b3dfc1e808116af3
 */

return [
    [
        'symbol' => '$',
        'name' => 'US Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'USD',
        'namePlural' => 'US dollars',
        'locations' => ['US'],
    ],
    [
        'symbol' => '€',
        'name' => 'Euro',
        'symbolNative' => '€',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'EUR',
        'namePlural' => 'euros',
        'locations' => [],
    ],
    [
        'symbol' => '£',
        'name' => 'British Pound Sterling',
        'symbolNative' => '£',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'GBP',
        'namePlural' => 'British pounds sterling',
        'locations' => [],
    ],
    [
        'symbol' => 'CA$',
        'name' => 'Canadian Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'CAD',
        'namePlural' => 'Canadian dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'AED',
        'name' => 'United Arab Emirates Dirham',
        'symbolNative' => 'د.إ.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'AED',
        'namePlural' => 'UAE dirhams',
        'locations' => [],
    ],
    [
        'symbol' => 'Af',
        'name' => 'Afghan Afghani',
        'symbolNative' => '؋',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'AFN',
        'namePlural' => 'Afghan Afghanis',
        'locations' => [],
    ],
    [
        'symbol' => 'ALL',
        'name' => 'Albanian Lek',
        'symbolNative' => 'Lek',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'ALL',
        'namePlural' => 'Albanian lekë',
        'locations' => [],
    ],
    [
        'symbol' => 'AMD',
        'name' => 'Armenian Dram',
        'symbolNative' => 'դր.',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'AMD',
        'namePlural' => 'Armenian drams',
        'locations' => [],
    ],
    [
        'symbol' => 'AR$',
        'name' => 'Argentine Peso',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'ARS',
        'namePlural' => 'Argentine pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'AU$',
        'name' => 'Australian Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'AUD',
        'namePlural' => 'Australian dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'man.',
        'name' => 'Azerbaijani Manat',
        'symbolNative' => 'ман.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'AZN',
        'namePlural' => 'Azerbaijani manats',
        'locations' => [],
    ],
    [
        'symbol' => 'KM',
        'name' => 'Bosnia-Herzegovina Convertible Mark',
        'symbolNative' => 'KM',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BAM',
        'namePlural' => 'Bosnia-Herzegovina convertible marks',
        'locations' => [],
    ],
    [
        'symbol' => 'Tk',
        'name' => 'Bangladeshi Taka',
        'symbolNative' => '৳',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BDT',
        'namePlural' => 'Bangladeshi takas',
        'locations' => [],
    ],
    [
        'symbol' => 'BGN',
        'name' => 'Bulgarian Lev',
        'symbolNative' => 'лв.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BGN',
        'namePlural' => 'Bulgarian leva',
        'locations' => [],
    ],
    [
        'symbol' => 'BD',
        'name' => 'Bahraini Dinar',
        'symbolNative' => 'د.ب.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'BHD',
        'namePlural' => 'Bahraini dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'FBu',
        'name' => 'Burundian Franc',
        'symbolNative' => 'FBu',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'BIF',
        'namePlural' => 'Burundian francs',
        'locations' => [],
    ],
    [
        'symbol' => 'BN$',
        'name' => 'Brunei Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BND',
        'namePlural' => 'Brunei dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'Bs',
        'name' => 'Bolivian Boliviano',
        'symbolNative' => 'Bs',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BOB',
        'namePlural' => 'Bolivian bolivianos',
        'locations' => [],
    ],
    [
        'symbol' => 'R$',
        'name' => 'Brazilian Real',
        'symbolNative' => 'R$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BRL',
        'namePlural' => 'Brazilian reals',
        'locations' => [],
    ],
    [
        'symbol' => 'BWP',
        'name' => 'Botswanan Pula',
        'symbolNative' => 'P',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BWP',
        'namePlural' => 'Botswanan pulas',
        'locations' => [],
    ],
    [
        'symbol' => 'BYR',
        'name' => 'Belarusian Ruble',
        'symbolNative' => 'BYR',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'BYR',
        'namePlural' => 'Belarusian rubles',
        'locations' => [],
    ],
    [
        'symbol' => 'BZ$',
        'name' => 'Belize Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'BZD',
        'namePlural' => 'Belize dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'CDF',
        'name' => 'Congolese Franc',
        'symbolNative' => 'FrCD',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'CDF',
        'namePlural' => 'Congolese francs',
        'locations' => [],
    ],
    [
        'symbol' => 'CHF',
        'name' => 'Swiss Franc',
        'symbolNative' => 'CHF',
        'decimalDigits' => 2,
        'rounding' => 0.05000000000000000277555756156289135105907917022705078125,
        'code' => 'CHF',
        'namePlural' => 'Swiss francs',
        'locations' => [],
    ],
    [
        'symbol' => 'CL$',
        'name' => 'Chilean Peso',
        'symbolNative' => '$',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'CLP',
        'namePlural' => 'Chilean pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'CN¥',
        'name' => 'Chinese Yuan',
        'symbolNative' => 'CN¥',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'CNY',
        'namePlural' => 'Chinese yuan',
        'locations' => [],
    ],
    [
        'symbol' => 'CO$',
        'name' => 'Colombian Peso',
        'symbolNative' => '$',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'COP',
        'namePlural' => 'Colombian pesos',
        'locations' => [],
    ],
    [
        'symbol' => '₡',
        'name' => 'Costa Rican Colón',
        'symbolNative' => '₡',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'CRC',
        'namePlural' => 'Costa Rican colóns',
        'locations' => [],
    ],
    [
        'symbol' => 'CV$',
        'name' => 'Cape Verdean Escudo',
        'symbolNative' => 'CV$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'CVE',
        'namePlural' => 'Cape Verdean escudos',
        'locations' => [],
    ],
    [
        'symbol' => 'Kč',
        'name' => 'Czech Republic Koruna',
        'symbolNative' => 'Kč',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'CZK',
        'namePlural' => 'Czech Republic korunas',
        'locations' => [],
    ],
    [
        'symbol' => 'Fdj',
        'name' => 'Djiboutian Franc',
        'symbolNative' => 'Fdj',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'DJF',
        'namePlural' => 'Djiboutian francs',
        'locations' => [],
    ],
    [
        'symbol' => 'Dkr',
        'name' => 'Danish Krone',
        'symbolNative' => 'kr',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'DKK',
        'namePlural' => 'Danish kroner',
        'locations' => [],
    ],
    [
        'symbol' => 'RD$',
        'name' => 'Dominican Peso',
        'symbolNative' => 'RD$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'DOP',
        'namePlural' => 'Dominican pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'DA',
        'name' => 'Algerian Dinar',
        'symbolNative' => 'د.ج.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'DZD',
        'namePlural' => 'Algerian dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'Ekr',
        'name' => 'Estonian Kroon',
        'symbolNative' => 'kr',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'EEK',
        'namePlural' => 'Estonian kroons',
        'locations' => [],
    ],
    [
        'symbol' => 'EGP',
        'name' => 'Egyptian Pound',
        'symbolNative' => 'ج.م.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'EGP',
        'namePlural' => 'Egyptian pounds',
        'locations' => [],
    ],
    [
        'symbol' => 'Nfk',
        'name' => 'Eritrean Nakfa',
        'symbolNative' => 'Nfk',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'ERN',
        'namePlural' => 'Eritrean nakfas',
        'locations' => [],
    ],
    [
        'symbol' => 'Br',
        'name' => 'Ethiopian Birr',
        'symbolNative' => 'Br',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'ETB',
        'namePlural' => 'Ethiopian birrs',
        'locations' => [],
    ],
    [
        'symbol' => 'GEL',
        'name' => 'Georgian Lari',
        'symbolNative' => 'GEL',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'GEL',
        'namePlural' => 'Georgian laris',
        'locations' => [],
    ],
    [
        'symbol' => 'GH₵',
        'name' => 'Ghanaian Cedi',
        'symbolNative' => 'GH₵',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'GHS',
        'namePlural' => 'Ghanaian cedis',
        'locations' => [],
    ],
    [
        'symbol' => 'FG',
        'name' => 'Guinean Franc',
        'symbolNative' => 'FG',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'GNF',
        'namePlural' => 'Guinean francs',
        'locations' => [],
    ],
    [
        'symbol' => 'GTQ',
        'name' => 'Guatemalan Quetzal',
        'symbolNative' => 'Q',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'GTQ',
        'namePlural' => 'Guatemalan quetzals',
        'locations' => [],
    ],
    [
        'symbol' => 'HK$',
        'name' => 'Hong Kong Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'HKD',
        'namePlural' => 'Hong Kong dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'HNL',
        'name' => 'Honduran Lempira',
        'symbolNative' => 'L',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'HNL',
        'namePlural' => 'Honduran lempiras',
        'locations' => [],
    ],
    [
        'symbol' => 'kn',
        'name' => 'Croatian Kuna',
        'symbolNative' => 'kn',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'HRK',
        'namePlural' => 'Croatian kunas',
        'locations' => [],
    ],
    [
        'symbol' => 'Ft',
        'name' => 'Hungarian Forint',
        'symbolNative' => 'Ft',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'HUF',
        'namePlural' => 'Hungarian forints',
        'locations' => [],
    ],
    [
        'symbol' => 'Rp',
        'name' => 'Indonesian Rupiah',
        'symbolNative' => 'Rp',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'IDR',
        'namePlural' => 'Indonesian rupiahs',
        'locations' => [],
    ],
    [
        'symbol' => '₪',
        'name' => 'Israeli New Sheqel',
        'symbolNative' => '₪',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'ILS',
        'namePlural' => 'Israeli new sheqels',
        'locations' => ['IL'],
    ],
    [
        'symbol' => 'Rs',
        'name' => 'Indian Rupee',
        'symbolNative' => '₹',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'INR',
        'namePlural' => 'Indian Rupees',
        'locations' => ['IN'],
    ],
    [
        'symbol' => 'IQD',
        'name' => 'Iraqi Dinar',
        'symbolNative' => 'د.ع.‏',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'IQD',
        'namePlural' => 'Iraqi dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'IRR',
        'name' => 'Iranian Rial',
        'symbolNative' => '﷼',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'IRR',
        'namePlural' => 'Iranian rials',
        'locations' => [],
    ],
    [
        'symbol' => 'Ikr',
        'name' => 'Icelandic Króna',
        'symbolNative' => 'kr',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'ISK',
        'namePlural' => 'Icelandic krónur',
        'locations' => [],
    ],
    [
        'symbol' => 'J$',
        'name' => 'Jamaican Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'JMD',
        'namePlural' => 'Jamaican dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'JD',
        'name' => 'Jordanian Dinar',
        'symbolNative' => 'د.أ.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'JOD',
        'namePlural' => 'Jordanian dinars',
        'locations' => [],
    ],
    [
        'symbol' => '¥',
        'name' => 'Japanese Yen',
        'symbolNative' => '￥',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'JPY',
        'namePlural' => 'Japanese yen',
        'locations' => [],
    ],
    [
        'symbol' => 'Ksh',
        'name' => 'Kenyan Shilling',
        'symbolNative' => 'Ksh',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'KES',
        'namePlural' => 'Kenyan shillings',
        'locations' => [],
    ],
    [
        'symbol' => 'KHR',
        'name' => 'Cambodian Riel',
        'symbolNative' => '៛',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'KHR',
        'namePlural' => 'Cambodian riels',
        'locations' => [],
    ],
    [
        'symbol' => 'CF',
        'name' => 'Comorian Franc',
        'symbolNative' => 'FC',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'KMF',
        'namePlural' => 'Comorian francs',
        'locations' => [],
    ],
    [
        'symbol' => '₩',
        'name' => 'South Korean Won',
        'symbolNative' => '₩',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'KRW',
        'namePlural' => 'South Korean won',
        'locations' => [],
    ],
    [
        'symbol' => 'KD',
        'name' => 'Kuwaiti Dinar',
        'symbolNative' => 'د.ك.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'KWD',
        'namePlural' => 'Kuwaiti dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'KZT',
        'name' => 'Kazakhstani Tenge',
        'symbolNative' => 'тңг.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'KZT',
        'namePlural' => 'Kazakhstani tenges',
        'locations' => [],
    ],
    [
        'symbol' => 'SLRs',
        'name' => 'Sri Lankan Rupee',
        'symbolNative' => 'SL Re',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'LKR',
        'namePlural' => 'Sri Lankan rupees',
        'locations' => [],
    ],
    [
        'symbol' => 'Lt',
        'name' => 'Lithuanian Litas',
        'symbolNative' => 'Lt',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'LTL',
        'namePlural' => 'Lithuanian litai',
        'locations' => [],
    ],
    [
        'symbol' => 'Ls',
        'name' => 'Latvian Lats',
        'symbolNative' => 'Ls',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'LVL',
        'namePlural' => 'Latvian lati',
        'locations' => [],
    ],
    [
        'symbol' => 'LD',
        'name' => 'Libyan Dinar',
        'symbolNative' => 'د.ل.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'LYD',
        'namePlural' => 'Libyan dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'MAD',
        'name' => 'Moroccan Dirham',
        'symbolNative' => 'د.م.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MAD',
        'namePlural' => 'Moroccan dirhams',
        'locations' => [],
    ],
    [
        'symbol' => 'MDL',
        'name' => 'Moldovan Leu',
        'symbolNative' => 'MDL',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MDL',
        'namePlural' => 'Moldovan lei',
        'locations' => [],
    ],
    [
        'symbol' => 'MGA',
        'name' => 'Malagasy Ariary',
        'symbolNative' => 'MGA',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'MGA',
        'namePlural' => 'Malagasy Ariaries',
        'locations' => [],
    ],
    [
        'symbol' => 'MKD',
        'name' => 'Macedonian Denar',
        'symbolNative' => 'MKD',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MKD',
        'namePlural' => 'Macedonian denari',
        'locations' => [],
    ],
    [
        'symbol' => 'MMK',
        'name' => 'Myanma Kyat',
        'symbolNative' => 'K',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'MMK',
        'namePlural' => 'Myanma kyats',
        'locations' => [],
    ],
    [
        'symbol' => 'MOP$',
        'name' => 'Macanese Pataca',
        'symbolNative' => 'MOP$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MOP',
        'namePlural' => 'Macanese patacas',
        'locations' => [],
    ],
    [
        'symbol' => 'MURs',
        'name' => 'Mauritian Rupee',
        'symbolNative' => 'MURs',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'MUR',
        'namePlural' => 'Mauritian rupees',
        'locations' => [],
    ],
    [
        'symbol' => 'MX$',
        'name' => 'Mexican Peso',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MXN',
        'namePlural' => 'Mexican pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'RM',
        'name' => 'Malaysian Ringgit',
        'symbolNative' => 'RM',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MYR',
        'namePlural' => 'Malaysian ringgits',
        'locations' => [],
    ],
    [
        'symbol' => 'MTn',
        'name' => 'Mozambican Metical',
        'symbolNative' => 'MTn',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'MZN',
        'namePlural' => 'Mozambican meticals',
        'locations' => [],
    ],
    [
        'symbol' => 'N$',
        'name' => 'Namibian Dollar',
        'symbolNative' => 'N$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NAD',
        'namePlural' => 'Namibian dollars',
        'locations' => [],
    ],
    [
        'symbol' => '₦',
        'name' => 'Nigerian Naira',
        'symbolNative' => '₦',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NGN',
        'namePlural' => 'Nigerian nairas',
        'locations' => [],
    ],
    [
        'symbol' => 'C$',
        'name' => 'Nicaraguan Córdoba',
        'symbolNative' => 'C$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NIO',
        'namePlural' => 'Nicaraguan córdobas',
        'locations' => [],
    ],
    [
        'symbol' => 'Nkr',
        'name' => 'Norwegian Krone',
        'symbolNative' => 'kr',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NOK',
        'namePlural' => 'Norwegian kroner',
        'locations' => [],
    ],
    [
        'symbol' => 'NPRs',
        'name' => 'Nepalese Rupee',
        'symbolNative' => 'नेरू',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NPR',
        'namePlural' => 'Nepalese rupees',
        'locations' => [],
    ],
    [
        'symbol' => 'NZ$',
        'name' => 'New Zealand Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'NZD',
        'namePlural' => 'New Zealand dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'OMR',
        'name' => 'Omani Rial',
        'symbolNative' => 'ر.ع.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'OMR',
        'namePlural' => 'Omani rials',
        'locations' => [],
    ],
    [
        'symbol' => 'B/.',
        'name' => 'Panamanian Balboa',
        'symbolNative' => 'B/.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'PAB',
        'namePlural' => 'Panamanian balboas',
        'locations' => [],
    ],
    [
        'symbol' => 'S/.',
        'name' => 'Peruvian Nuevo Sol',
        'symbolNative' => 'S/.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'PEN',
        'namePlural' => 'Peruvian nuevos soles',
        'locations' => [],
    ],
    [
        'symbol' => '₱',
        'name' => 'Philippine Peso',
        'symbolNative' => '₱',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'PHP',
        'namePlural' => 'Philippine pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'PKRs',
        'name' => 'Pakistani Rupee',
        'symbolNative' => '₨',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'PKR',
        'namePlural' => 'Pakistani rupees',
        'locations' => [],
    ],
    [
        'symbol' => 'zł',
        'name' => 'Polish Zloty',
        'symbolNative' => 'zł',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'PLN',
        'namePlural' => 'Polish zlotys',
        'locations' => [],
    ],
    [
        'symbol' => '₲',
        'name' => 'Paraguayan Guarani',
        'symbolNative' => '₲',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'PYG',
        'namePlural' => 'Paraguayan guaranis',
        'locations' => [],
    ],
    [
        'symbol' => 'QR',
        'name' => 'Qatari Rial',
        'symbolNative' => 'ر.ق.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'QAR',
        'namePlural' => 'Qatari rials',
        'locations' => [],
    ],
    [
        'symbol' => 'RON',
        'name' => 'Romanian Leu',
        'symbolNative' => 'RON',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'RON',
        'namePlural' => 'Romanian lei',
        'locations' => [],
    ],
    [
        'symbol' => 'din.',
        'name' => 'Serbian Dinar',
        'symbolNative' => 'дин.',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'RSD',
        'namePlural' => 'Serbian dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'RUB',
        'name' => 'Russian Ruble',
        'symbolNative' => 'руб.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'RUB',
        'namePlural' => 'Russian rubles',
        'locations' => [],
    ],
    [
        'symbol' => 'RWF',
        'name' => 'Rwandan Franc',
        'symbolNative' => 'FR',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'RWF',
        'namePlural' => 'Rwandan francs',
        'locations' => [],
    ],
    [
        'symbol' => 'SR',
        'name' => 'Saudi Riyal',
        'symbolNative' => 'ر.س.‏',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'SAR',
        'namePlural' => 'Saudi riyals',
        'locations' => [],
    ],
    [
        'symbol' => 'SDG',
        'name' => 'Sudanese Pound',
        'symbolNative' => 'SDG',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'SDG',
        'namePlural' => 'Sudanese pounds',
        'locations' => [],
    ],
    [
        'symbol' => 'Skr',
        'name' => 'Swedish Krona',
        'symbolNative' => 'kr',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'SEK',
        'namePlural' => 'Swedish kronor',
        'locations' => [],
    ],
    [
        'symbol' => 'S$',
        'name' => 'Singapore Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'SGD',
        'namePlural' => 'Singapore dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'Ssh',
        'name' => 'Somali Shilling',
        'symbolNative' => 'Ssh',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'SOS',
        'namePlural' => 'Somali shillings',
        'locations' => [],
    ],
    [
        'symbol' => 'SY£',
        'name' => 'Syrian Pound',
        'symbolNative' => 'ل.س.‏',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'SYP',
        'namePlural' => 'Syrian pounds',
        'locations' => [],
    ],
    [
        'symbol' => '฿',
        'name' => 'Thai Baht',
        'symbolNative' => '฿',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'THB',
        'namePlural' => 'Thai baht',
        'locations' => [],
    ],
    [
        'symbol' => 'DT',
        'name' => 'Tunisian Dinar',
        'symbolNative' => 'د.ت.‏',
        'decimalDigits' => 3,
        'rounding' => 0,
        'code' => 'TND',
        'namePlural' => 'Tunisian dinars',
        'locations' => [],
    ],
    [
        'symbol' => 'T$',
        'name' => 'Tongan Paʻanga',
        'symbolNative' => 'T$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'TOP',
        'namePlural' => 'Tongan paʻanga',
        'locations' => [],
    ],
    [
        'symbol' => 'TL',
        'name' => 'Turkish Lira',
        'symbolNative' => 'TL',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'TRY',
        'namePlural' => 'Turkish Lira',
        'locations' => [],
    ],
    [
        'symbol' => 'TT$',
        'name' => 'Trinidad and Tobago Dollar',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'TTD',
        'namePlural' => 'Trinidad and Tobago dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'NT$',
        'name' => 'New Taiwan Dollar',
        'symbolNative' => 'NT$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'TWD',
        'namePlural' => 'New Taiwan dollars',
        'locations' => [],
    ],
    [
        'symbol' => 'TSh',
        'name' => 'Tanzanian Shilling',
        'symbolNative' => 'TSh',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'TZS',
        'namePlural' => 'Tanzanian shillings',
        'locations' => [],
    ],
    [
        'symbol' => '₴',
        'name' => 'Ukrainian Hryvnia',
        'symbolNative' => '₴',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'UAH',
        'namePlural' => 'Ukrainian hryvnias',
        'locations' => [],
    ],
    [
        'symbol' => 'USh',
        'name' => 'Ugandan Shilling',
        'symbolNative' => 'USh',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'UGX',
        'namePlural' => 'Ugandan shillings',
        'locations' => [],
    ],
    [
        'symbol' => '$U',
        'name' => 'Uruguayan Peso',
        'symbolNative' => '$',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'UYU',
        'namePlural' => 'Uruguayan pesos',
        'locations' => [],
    ],
    [
        'symbol' => 'UZS',
        'name' => 'Uzbekistan Som',
        'symbolNative' => 'UZS',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'UZS',
        'namePlural' => 'Uzbekistan som',
        'locations' => [],
    ],
    [
        'symbol' => 'Bs.F.',
        'name' => 'Venezuelan Bolívar',
        'symbolNative' => 'Bs.F.',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'VEF',
        'namePlural' => 'Venezuelan bolívars',
        'locations' => [],
    ],
    [
        'symbol' => '₫',
        'name' => 'Vietnamese Dong',
        'symbolNative' => '₫',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'VND',
        'namePlural' => 'Vietnamese dong',
        'locations' => [],
    ],
    [
        'symbol' => 'FCFA',
        'name' => 'CFA Franc BEAC',
        'symbolNative' => 'FCFA',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'XAF',
        'namePlural' => 'CFA francs BEAC',
        'locations' => [],
    ],
    [
        'symbol' => 'CFA',
        'name' => 'CFA Franc BCEAO',
        'symbolNative' => 'CFA',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'XOF',
        'namePlural' => 'CFA francs BCEAO',
        'locations' => [],
    ],
    [
        'symbol' => 'YR',
        'name' => 'Yemeni Rial',
        'symbolNative' => 'ر.ي.‏',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'YER',
        'namePlural' => 'Yemeni rials',
        'locations' => [],
    ],
    [
        'symbol' => 'R',
        'name' => 'South African Rand',
        'symbolNative' => 'R',
        'decimalDigits' => 2,
        'rounding' => 0,
        'code' => 'ZAR',
        'namePlural' => 'South African rand',
        'locations' => [],
    ],
    [
        'symbol' => 'ZK',
        'name' => 'Zambian Kwacha',
        'symbolNative' => 'ZK',
        'decimalDigits' => 0,
        'rounding' => 0,
        'code' => 'ZMK',
        'namePlural' => 'Zambian kwachas',
        'locations' => [],
    ],
];
