<?php

global $request;

use Utopia\Config\Config;
use Appwrite\Database\Database;

$providers = Config::getParam('providers');

$collections = [
    'console' => [
        '$id' => 'console',
        '$collection' => 'projects',
        '$permissions' => ['read' => ['*']],
        'name' => 'Appwrite',
        'description' => 'Appwrite core engine',
        'logo' => '',
        'teamId' => -1,
        'webhooks' => [],
        'keys' => [],
        'platforms' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Production',
                'type' => 'web',
                'hostname' => 'appwrite.io',
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Development',
                'type' => 'web',
                'hostname' => 'appwrite.test',
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Localhost',
                'type' => 'web',
                'hostname' => 'localhost',
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_PLATFORMS,
                'name' => 'Current Host',
                'type' => 'web',
                'hostname' => parse_url('https://'.$request->getServer('HTTP_HOST'), PHP_URL_HOST),
            ],
        ],
        'legalName' => '',
        'legalCountry' => '',
        'legalState' => '',
        'legalCity' => '',
        'legalAddress' => '',
        'legalTaxId' => '',
        'authWhitelistEmails' => (!empty($request->getServer('_APP_CONSOLE_WHITELIST_EMAILS', null))) ? explode(',', $request->getServer('_APP_CONSOLE_WHITELIST_EMAILS', null)) : [],
        'authWhitelistIPs' => (!empty($request->getServer('_APP_CONSOLE_WHITELIST_IPS', null))) ? explode(',', $request->getServer('_APP_CONSOLE_WHITELIST_IPS', null)) : [],
        'authWhitelistDomains' => (!empty($request->getServer('_APP_CONSOLE_WHITELIST_DOMAINS', null))) ? explode(',', $request->getServer('_APP_CONSOLE_WHITELIST_DOMAINS', null)) : [],
    ],
    Database::SYSTEM_COLLECTION_COLLECTIONS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Collections',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Updated',
                'key' => 'dateUpdated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Structure',
                'key' => 'structure',
                'type' => 'boolean',
                'default' => false,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Rules',
                'key' => 'rules',
                'type' => 'document',
                'default' => [],
                'required' => true,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_RULES],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_RULES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_RULES,
        '$permissions' => ['read' => ['*']],
        'name' => 'Collections Rule',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Label',
                'key' => 'label',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Key',
                'key' => 'key',
                'type' => 'key',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Default',
                'key' => 'default',
                'type' => 'wildcard',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Required',
                'key' => 'required',
                'type' => 'boolean',
                'default' => true,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Array',
                'key' => 'array',
                'type' => 'boolean',
                'default' => true,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'list',
                'key' => 'list',
                'type' => 'text',
                //'default' => '',
                'required' => false,
                'array' => true,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_USERS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_USERS,
        '$permissions' => ['read' => ['*']],
        'name' => 'User',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Email',
                'key' => 'email',
                'type' => 'email',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => 'numeric',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Password',
                'key' => 'password',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Password Update Date',
                'key' => 'password-update',
                'type' => 'numeric',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Prefs',
                'key' => 'prefs',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Registration Date',
                'key' => 'registration',
                'type' => 'numeric',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Email Verification Status',
                'key' => 'emailVerification',
                'type' => 'boolean',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Reset',
                'key' => 'reset',
                'type' => 'boolean',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tokens',
                'key' => 'tokens',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_TOKENS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Memberships',
                'key' => 'memberships',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_MEMBERSHIPS],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TOKENS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TOKENS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Token',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => 'numeric',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Expire',
                'key' => 'expire',
                'type' => 'numeric',
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User Agent',
                'key' => 'userAgent',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'IP',
                'key' => 'ip',
                'type' => 'ip',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_MEMBERSHIPS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_MEMBERSHIPS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Membership',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Team ID',
                'key' => 'teamId',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'User ID',
                'key' => 'userId',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Roles',
                'key' => 'roles',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Invited',
                'key' => 'invited',
                'type' => 'numeric',
                'default' => 0,
                'required' => false, //FIXME SHOULD BE REQUIRED
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Joined',
                'key' => 'joined',
                'type' => 'numeric',
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Confirm',
                'key' => 'confirm',
                'type' => 'boolean',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TEAMS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TEAMS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Team',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Sum',
                'key' => 'sum',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_PROJECTS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_PROJECTS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Project',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Description',
                'key' => 'description',
                'type' => 'text',
                'default' => null,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Logo',
                'key' => 'logo',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'URL',
                'key' => 'url',
                'type' => 'url',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Team ID',
                'key' => 'teamId',
                'type' => 'text',
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Name',
                'key' => 'legalName',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Country',
                'key' => 'legalCountry',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal State',
                'key' => 'legalState',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal City',
                'key' => 'legalCity',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Address',
                'key' => 'legalAddress',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Legal Tax ID',
                'key' => 'legalTaxId',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Webhooks',
                'key' => 'webhooks',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_WEBHOOKS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'API Keys',
                'key' => 'keys',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_KEYS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Tasks',
                'key' => 'tasks',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_TASKS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Platforms',
                'key' => 'platforms',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_PLATFORMS],
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domains',
                'key' => 'domains',
                'type' => 'document',
                'default' => [],
                'required' => false,
                'array' => true,
                'list' => [Database::SYSTEM_COLLECTION_DOMAINS],
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_WEBHOOKS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_WEBHOOKS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Webhook',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Events',
                'key' => 'events',
                'type' => 'text',
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'URL',
                'key' => 'url',
                'type' => 'url',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Security',
                'key' => 'security',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP User',
                'key' => 'httpUser',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Password',
                'key' => 'httpPass',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_KEYS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_KEYS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Key',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Scopes',
                'key' => 'scopes',
                'type' => 'text',
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Secret',
                'key' => 'secret',
                'type' => 'text',
                'default' => '',
                'required' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_TASKS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_TASKS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Task',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Status',
                'key' => 'status',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Updated',
                'key' => 'updated',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Schedule',
                'key' => 'schedule',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Previous',
                'key' => 'previous',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Next',
                'key' => 'next',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Duration',
                'key' => 'duration',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Delay',
                'key' => 'delay',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Security',
                'key' => 'security',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Method',
                'key' => 'httpMethod',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP URL',
                'key' => 'httpUrl',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Headers',
                'key' => 'httpHeaders',
                'type' => 'text',
                'default' => null,
                'required' => false,
                'array' => true,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP User',
                'key' => 'httpUser',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'HTTP Password',
                'key' => 'httpPass',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Log',
                'key' => 'log',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Failures',
                'key' => 'failures',
                'type' => 'numeric',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_PLATFORMS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_PLATFORMS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Platform',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Type',
                'key' => 'type',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Updated',
                'key' => 'dateUpdated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Key',
                'key' => 'key',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Store',
                'key' => 'store',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Hostname',
                'key' => 'hostname',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_DOMAINS => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_DOMAINS,
        '$permissions' => ['read' => ['*']],
        'name' => 'Domains',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domain',
                'key' => 'domain',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Updated',
                'key' => 'updated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Top Level Domain',
                'key' => 'tld',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Registerable Domain',
                'key' => 'registerable',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Verification',
                'key' => 'verification',
                'type' => 'boolean',
                'default' => false,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Certificate ID',
                'key' => 'certificateId',
                'type' => 'key',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_CERTIFICATES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_CERTIFICATES,
        '$permissions' => ['read' => ['*']],
        'name' => 'Certificates',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Domain',
                'key' => 'domain',
                'type' => 'text',
                'default' => null,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Issue Date',
                'key' => 'issueDate',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Renew Date',
                'key' => 'renewDate',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Attempts',
                'key' => 'attempts',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Log',
                'key' => 'log',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
    Database::SYSTEM_COLLECTION_FILES => [
        '$collection' => Database::SYSTEM_COLLECTION_COLLECTIONS,
        '$id' => Database::SYSTEM_COLLECTION_FILES,
        '$permissions' => ['read' => ['*']],
        'name' => 'File',
        'structure' => true,
        'rules' => [
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Date Created',
                'key' => 'dateCreated',
                'type' => 'numeric',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Folder ID',
                'key' => 'folderId',
                'type' => 'key',
                'default' => 0,
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Name',
                'key' => 'name',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Path',
                'key' => 'path',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Signature',
                'key' => 'signature',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Mime Type',
                'key' => 'mimeType',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Original Size',
                'key' => 'sizeOriginal',
                'type' => 'numeric',
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Actual Size',
                'key' => 'sizeActual',
                'type' => 'numeric',
                'default' => 0,
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Algorithm',
                'key' => 'algorithm',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Token',
                'key' => 'token',
                'type' => 'text',
                'default' => '',
                'required' => true,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'Comment',
                'key' => 'comment',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Version',
                'key' => 'fileOpenSSLVersion',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Cipher',
                'key' => 'fileOpenSSLCipher',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL Tag',
                'key' => 'fileOpenSSLTag',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
            [
                '$collection' => Database::SYSTEM_COLLECTION_RULES,
                'label' => 'File OpenSSL IV',
                'key' => 'fileOpenSSLIV',
                'type' => 'text',
                'default' => '',
                'required' => false,
                'array' => false,
            ],
        ],
    ],
];

/*
 * Add enabled OAuth2 providers to default data rules
 */
foreach ($providers as $index => $provider) {
    if (!$provider['enabled']) {
        continue;
    }

    $collections[Database::SYSTEM_COLLECTION_PROJECTS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.ucfirst($index).' ID',
        'key' => 'usersOauth2'.ucfirst($index).'Appid',
        'type' => 'text',
        'default' => '',
        'required' => false,
        'array' => false,
    ];

    $collections[Database::SYSTEM_COLLECTION_PROJECTS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.ucfirst($index).' Secret',
        'key' => 'usersOauth2'.ucfirst($index).'Secret',
        'type' => 'text',
        'default' => '',
        'required' => false,
        'array' => false,
    ];

    $collections[Database::SYSTEM_COLLECTION_USERS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.ucfirst($index).' ID',
        'key' => 'oauth2'.ucfirst($index),
        'type' => 'text',
        'default' => '',
        'required' => false,
        'array' => false,
    ];

    $collections[Database::SYSTEM_COLLECTION_USERS]['rules'][] = [
        '$collection' => Database::SYSTEM_COLLECTION_RULES,
        'label' => 'OAuth2 '.ucfirst($index).' Access Token',
        'key' => 'oauth2'.ucfirst($index).'AccessToken',
        'type' => 'text',
        'default' => '',
        'required' => false,
        'array' => false,
    ];
}

return $collections;