<?php

const APP_PLATFORM_SERVER = 'server';
const APP_PLATFORM_CLIENT = 'client';
const APP_PLATFORM_CONSOLE = 'console';

return [
    APP_PLATFORM_CLIENT => [
        'key' => APP_PLATFORM_CLIENT,
        'name' => 'Client',
        'description' => 'Client libraries for integrating with '.APP_NAME.' to build client-based applications and websites. Read the [getting started for web](/docs/getting-started-for-web) or [getting started for Flutter](/docs/getting-started-for-flutter) tutorials to start building your first application.',
        'enabled' => true,
        'beta' => false,
        'languages' => [ // TODO change key to 'sdks'
            [
                'key' => 'web',
                'name' => 'Web',
                'version' => '1.1.0',
                'url' => 'https://github.com/appwrite/sdk-for-js',
                'enabled' => true,
                'beta' => false,
                'family' => APP_PLATFORM_CLIENT,
                'prism' => 'javascript',
                'source' => realpath(__DIR__ . '/../sdks/client-web'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-js.git',
                'gitRepoName' => 'sdk-for-js',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'flutter',
                'name' => 'Flutter',
                'version' => '0.2.2',
                'url' => 'https://github.com/appwrite/sdk-for-flutter',
                'enabled' => true,
                'beta' => true,
                'family' => APP_PLATFORM_CLIENT,
                'prism' => 'dart',
                'source' => realpath(__DIR__ . '/../sdks/client-flutter'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-flutter.git',
                'gitRepoName' => 'sdk-for-flutter',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'swift',
                'name' => 'Swift',
                'url' => '',
                'enabled' => false,
                'beta' => false,
                'family' => APP_PLATFORM_CLIENT,
                'prism' => 'swift',
                'source' => false,
                'gitUrl' => 'git@github.com:appwrite/sdk-for-swift.git',
                'gitRepoName' => 'sdk-for-swift',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'objective-c',
                'name' => 'Objective C',
                'url' => '',
                'enabled' => false,
                'beta' => false,
                'family' => APP_PLATFORM_CLIENT,
                'prism' => '',
                'source' => false,
                'gitUrl' => 'git@github.com:appwrite/sdk-for-objective-c.git',
                'gitRepoName' => 'sdk-for-objective-c',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'kotlin',
                'name' => 'Kotlin',
                'url' => '',
                'enabled' => false,
                'beta' => false,
                'family' => APP_PLATFORM_CLIENT,
                'prism' => 'kotlin',
                'source' => false,
                'gitUrl' => 'git@github.com:appwrite/sdk-for-kotlin.git',
                'gitRepoName' => 'sdk-for-kotlin',
                'gitUserName' => 'appwrite',
            ],
            // [
            //     'key' => 'java',
            //     'name' => 'Java',
            //     'url' => '',
            //     'enabled' => false,
            //     'beta' => false,
            //     'family' => APP_PLATFORM_CLIENT,
            //     'prism' => 'java',
            //     'source' => false,
            //     'gitUrl' => 'git@github.com:appwrite/sdk-for-java.git',
            //     'gitRepoName' => 'sdk-for-java',
            //     'gitUserName' => 'appwrite',
            // ],
        ],
    ],
    
    APP_PLATFORM_CONSOLE => [
        'key' => APP_PLATFORM_CONSOLE,
        'name' => 'Console',
        'enabled' => false,
        'beta' => false,
        'languages' => [ // TODO change key to 'sdks'
            [
                'key' => 'web',
                'name' => 'Console',
                'version' => '1.0.0',
                'url' => 'https://github.com/appwrite/sdk-for-console',
                'enabled' => true,
                'beta' => false,
                'family' => APP_PLATFORM_CONSOLE,
                'prism' => 'console',
                'source' => realpath(__DIR__ . '/../sdks/console-web'),
                'gitUrl' => null,
                'gitRepoName' => 'sdk-for-console',
                'gitUserName' => 'appwrite',
            ],
        ],
    ],

    APP_PLATFORM_SERVER => [
        'key' => APP_PLATFORM_SERVER,
        'name' => 'Server',
        'description' => 'Libraries for integrating with '.APP_NAME.' to build server side integrations. Read the [getting started for server](/docs/getting-started-for-server) tutorial to start building your first server integration.',
        'enabled' => true,
        'beta' => false,
        'languages' => [ // TODO change key to 'sdks'
            [
                'key' => 'nodejs',
                'name' => 'Node.js',
                'version' => '1.1.0',
                'url' => 'https://github.com/appwrite/sdk-for-node',
                'enabled' => true,
                'beta' => false,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'javascript',
                'source' => realpath(__DIR__ . '/../sdks/server-nodejs'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-node.git',
                'gitRepoName' => 'sdk-for-node',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'deno',
                'name' => 'Deno',
                'version' => '0.0.1',
                'url' => 'https://github.com/appwrite/sdk-for-deno',
                'enabled' => false,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'typescript',
                'source' => realpath(__DIR__ . '/../sdks/server-deno'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-deno.git',
                'gitRepoName' => 'sdk-for-deno',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'php',
                'name' => 'PHP',
                'version' => '1.1.0',
                'url' => 'https://github.com/appwrite/sdk-for-php',
                'enabled' => true,
                'beta' => false,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'php',
                'source' => realpath(__DIR__ . '/../sdks/server-php'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-php.git',
                'gitRepoName' => 'sdk-for-php',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'python',
                'name' => 'Python',
                'version' => '0.0.5',
                'url' => 'https://github.com/appwrite/sdk-for-python',
                'enabled' => true,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'python',
                'source' => realpath(__DIR__ . '/../sdks/server-python'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-python.git',
                'gitRepoName' => 'sdk-for-python',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'ruby',
                'name' => 'Ruby',
                'version' => '1.0.11',
                'url' => 'https://github.com/appwrite/sdk-for-ruby',
                'enabled' => true,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'ruby',
                'source' => realpath(__DIR__ . '/../sdks/server-ruby'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-ruby.git',
                'gitRepoName' => 'sdk-for-ruby',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'go',
                'name' => 'Go',
                'version' => '0.0.7',
                'url' => 'https://github.com/appwrite/sdk-for-go',
                'enabled' => false,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'go',
                'source' => realpath(__DIR__ . '/../sdks/server-go'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-go.git',
                'gitRepoName' => 'sdk-for-go',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'java',
                'name' => 'Java',
                'version' => '0.0.2',
                'url' => 'https://github.com/appwrite/sdk-for-java',
                'enabled' => false,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'java',
                'source' => realpath(__DIR__ . '/../sdks/server-java'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-java.git',
                'gitRepoName' => 'sdk-for-java',
                'gitUserName' => 'appwrite',
            ],
            [
                'key' => 'dart',
                'name' => 'Dart',
                'version' => '0.0.1',
                'url' => 'https://github.com/appwrite/sdk-for-dart',
                'enabled' => false,
                'beta' => true,
                'family' => APP_PLATFORM_SERVER,
                'prism' => 'java',
                'source' => realpath(__DIR__ . '/../sdks/server-dart'),
                'gitUrl' => 'git@github.com:appwrite/sdk-for-dart.git',
                'gitRepoName' => 'sdk-for-dart',
                'gitUserName' => 'appwrite',
            ],
        ],
    ],
];
