// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: policy/v1beta1/cfg.proto

/*
Package v1beta1 is a generated protocol buffer package.

It is generated from these files:
	policy/v1beta1/cfg.proto

It has these top-level messages:
	AttributeManifest
	Rule
	Action
	Instance
	Handler
	Connection
*/
package v1beta1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Header operation type.
type Rule_HeaderOperationTemplate_Operation int32

const (
	Rule_HeaderOperationTemplate_REPLACE Rule_HeaderOperationTemplate_Operation = 0
	Rule_HeaderOperationTemplate_REMOVE  Rule_HeaderOperationTemplate_Operation = 1
	Rule_HeaderOperationTemplate_APPEND  Rule_HeaderOperationTemplate_Operation = 2
)

var Rule_HeaderOperationTemplate_Operation_name = map[int32]string{
	0: "REPLACE",
	1: "REMOVE",
	2: "APPEND",
}
var Rule_HeaderOperationTemplate_Operation_value = map[string]int32{
	"REPLACE": 0,
	"REMOVE":  1,
	"APPEND":  2,
}

func (x Rule_HeaderOperationTemplate_Operation) String() string {
	return proto.EnumName(Rule_HeaderOperationTemplate_Operation_name, int32(x))
}
func (Rule_HeaderOperationTemplate_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorCfg, []int{1, 0, 0}
}

// AttributeManifest describes a set of Attributes produced by some component
// of an Istio deployment.
type AttributeManifest struct {
	// Optional. The revision of this document. Assigned by server.
	Revision string `protobuf:"bytes,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// Required. Name of the component producing these attributes. This can be
	// the proxy (with the canonical name "istio-proxy") or the name of an
	// `attributes` kind adapter in Mixer.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The set of attributes this Istio component will be responsible for producing at runtime.
	// We map from attribute name to the attribute's specification. The name of an attribute,
	// which is how attributes are referred to in aspect configuration, must conform to:
	//
	//     Name = IDENT { SEPARATOR IDENT };
	//
	// Where `IDENT` must match the regular expression `[a-z][a-z0-9]+` and `SEPARATOR` must
	// match the regular expression `[\.-]`.
	//
	// Attribute names must be unique within a single Istio deployment. The set of canonical
	// attributes are described at https://istio.io/docs/reference/attribute-vocabulary.html.
	// Attributes not in that list should be named with a component-specific suffix such as
	// request.count-my.component.
	Attributes map[string]*AttributeManifest_AttributeInfo `protobuf:"bytes,3,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AttributeManifest) Reset()                    { *m = AttributeManifest{} }
func (m *AttributeManifest) String() string            { return proto.CompactTextString(m) }
func (*AttributeManifest) ProtoMessage()               {}
func (*AttributeManifest) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{0} }

func (m *AttributeManifest) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func (m *AttributeManifest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttributeManifest) GetAttributes() map[string]*AttributeManifest_AttributeInfo {
	if m != nil {
		return m.Attributes
	}
	return nil
}

// AttributeInfo describes the schema of an Istio `Attribute`.
//
// # Istio Attributes
//
// Istio uses `attributes` to describe runtime activities of Istio services.
// An Istio attribute carries a specific piece of information about an activity,
// such as the error code of an API request, the latency of an API request, or the
// original IP address of a TCP connection. The attributes are often generated
// and consumed by different services. For example, a frontend service can
// generate an authenticated user attribute and pass it to a backend service for
// access control purpose.
//
// To simplify the system and improve developer experience, Istio uses
// shared attribute definitions across all components. For example, the same
// authenticated user attribute will be used for logging, monitoring, analytics,
// billing, access control, auditing. Many Istio components provide their
// functionality by collecting, generating, and operating on attributes.
// For example, the proxy collects the error code attribute, and the logging
// stores it into a log.
//
// # Design
//
// Each Istio attribute must conform to an `AttributeInfo` in an
// `AttributeManifest` in the current Istio deployment at runtime. An
// [`AttributeInfo`][istio.policy.v1beta1] is used to define an attribute's
// metadata: the type of its value and a detailed description that explains
// the semantics of the attribute type. Each attribute's name is globally unique;
// in other words an attribute name can only appear once across all manifests.
//
// The runtime presentation of an attribute is intentionally left out of this
// specification, because passing attribute using JSON, XML, or Protocol Buffers
// does not change the semantics of the attribute. Different implementations
// can choose different representations based on their needs.
//
// # HTTP Mapping
//
// Because many systems already have REST APIs, it makes sense to define a
// standard HTTP mapping for Istio attributes that are compatible with typical
// REST APIs. The design is to map one attribute to one HTTP header, the
// attribute name and value becomes the HTTP header name and value. The actual
// encoding scheme will be decided later.
type AttributeManifest_AttributeInfo struct {
	// Optional. A human-readable description of the attribute's purpose.
	Description string `protobuf:"bytes,1,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The type of data carried by this attribute.
	ValueType ValueType `protobuf:"varint,2,opt,name=value_type,json=valueType,proto3,enum=istio.policy.v1beta1.ValueType" json:"value_type,omitempty"`
}

func (m *AttributeManifest_AttributeInfo) Reset()         { *m = AttributeManifest_AttributeInfo{} }
func (m *AttributeManifest_AttributeInfo) String() string { return proto.CompactTextString(m) }
func (*AttributeManifest_AttributeInfo) ProtoMessage()    {}
func (*AttributeManifest_AttributeInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorCfg, []int{0, 0}
}

func (m *AttributeManifest_AttributeInfo) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AttributeManifest_AttributeInfo) GetValueType() ValueType {
	if m != nil {
		return m.ValueType
	}
	return VALUE_TYPE_UNSPECIFIED
}

// A Rule is a selector and a set of intentions to be executed when the
// selector is `true`
//
// The following example instructs Mixer to invoke 'prometheus-handler' handler for all services and pass it the
// instance constructed using the 'RequestCountByService' instance.
//
// ```yaml
// - match: destination.service == "*"
//   actions:
//   - handler: prometheus-handler
//     instances:
//     - RequestCountByService
// ```
type Rule struct {
	// Required. Match is an attribute based predicate. When Mixer receives a
	// request it evaluates the match expression and executes all the associated `actions`
	// if the match evaluates to true.
	//
	// A few example match:
	//
	// * an empty match evaluates to `true`
	// * `true`, a boolean literal; a rule with this match will always be executed
	// * `destination.service == ratings*` selects any request targeting a service whose
	// name starts with "ratings"
	// * `attr1 == "20" && attr2 == "30"` logical AND, OR, and NOT are also available
	Match string `protobuf:"bytes,1,opt,name=match,proto3" json:"match,omitempty"`
	// Optional. The actions that will be executed when match evaluates to `true`.
	Actions []*Action `protobuf:"bytes,2,rep,name=actions" json:"actions,omitempty"`
	// Optional. Templatized operations on the request headers using attributes produced by the
	// rule actions.
	RequestHeaderOperations []*Rule_HeaderOperationTemplate `protobuf:"bytes,3,rep,name=request_header_operations,json=requestHeaderOperations" json:"request_header_operations,omitempty"`
	// Optional. Templatized operations on the response headers using attributes produced by the
	// rule actions.
	ResponseHeaderOperations []*Rule_HeaderOperationTemplate `protobuf:"bytes,4,rep,name=response_header_operations,json=responseHeaderOperations" json:"response_header_operations,omitempty"`
}

func (m *Rule) Reset()                    { *m = Rule{} }
func (m *Rule) String() string            { return proto.CompactTextString(m) }
func (*Rule) ProtoMessage()               {}
func (*Rule) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{1} }

func (m *Rule) GetMatch() string {
	if m != nil {
		return m.Match
	}
	return ""
}

func (m *Rule) GetActions() []*Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

func (m *Rule) GetRequestHeaderOperations() []*Rule_HeaderOperationTemplate {
	if m != nil {
		return m.RequestHeaderOperations
	}
	return nil
}

func (m *Rule) GetResponseHeaderOperations() []*Rule_HeaderOperationTemplate {
	if m != nil {
		return m.ResponseHeaderOperations
	}
	return nil
}

// A template for an HTTP header manipulation.
type Rule_HeaderOperationTemplate struct {
	// Required. Header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Header values to replace or append.
	Values []string `protobuf:"bytes,2,rep,name=values" json:"values,omitempty"`
	// Optional. Header operation type. Default operation is to replace the value of the header by name.
	Operation Rule_HeaderOperationTemplate_Operation `protobuf:"varint,3,opt,name=operation,proto3,enum=istio.policy.v1beta1.Rule_HeaderOperationTemplate_Operation" json:"operation,omitempty"`
}

func (m *Rule_HeaderOperationTemplate) Reset()         { *m = Rule_HeaderOperationTemplate{} }
func (m *Rule_HeaderOperationTemplate) String() string { return proto.CompactTextString(m) }
func (*Rule_HeaderOperationTemplate) ProtoMessage()    {}
func (*Rule_HeaderOperationTemplate) Descriptor() ([]byte, []int) {
	return fileDescriptorCfg, []int{1, 0}
}

func (m *Rule_HeaderOperationTemplate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Rule_HeaderOperationTemplate) GetValues() []string {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *Rule_HeaderOperationTemplate) GetOperation() Rule_HeaderOperationTemplate_Operation {
	if m != nil {
		return m.Operation
	}
	return Rule_HeaderOperationTemplate_REPLACE
}

// Action describes which [Handler][istio.policy.v1beta1.Handler] to invoke and what data to pass to it for processing.
//
// The following example instructs Mixer to invoke 'prometheus-handler' handler and pass it the object
// constructed using the instance 'RequestCountByService'.
//
// ```yaml
//   handler: prometheus-handler
//   instances:
//   - RequestCountByService
// ```
type Action struct {
	// Required. Fully qualified name of the handler to invoke.
	// Must match the `name` of a [Handler][istio.policy.v1beta1.Handler.name].
	Handler string `protobuf:"bytes,2,opt,name=handler,proto3" json:"handler,omitempty"`
	// Required. Each value must match the fully qualified name of the
	// [Instance][istio.policy.v1beta1.Instance.name]s.
	// Referenced instances are evaluated by resolving the attributes/literals for all the fields.
	// The constructed objects are then passed to the `handler` referenced within this action.
	Instances []string `protobuf:"bytes,3,rep,name=instances" json:"instances,omitempty"`
	// Optional. A handle to refer to the results of the action.
	Name string `protobuf:"bytes,4,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *Action) Reset()                    { *m = Action{} }
func (m *Action) String() string            { return proto.CompactTextString(m) }
func (*Action) ProtoMessage()               {}
func (*Action) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{2} }

func (m *Action) GetHandler() string {
	if m != nil {
		return m.Handler
	}
	return ""
}

func (m *Action) GetInstances() []string {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *Action) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// An Instance tells Mixer how to create instances for particular template.
//
// Instance is defined by the operator. Instance is defined relative to a known
// template. Their purpose is to tell Mixer how to use attributes or literals to produce
// instances of the specified template at runtime.
//
// The following example instructs Mixer to construct an instance associated with template
// 'istio.mixer.adapter.metric.Metric'. It provides a mapping from the template's fields to expressions.
// Instances produced with this instance can be referenced by [Actions][istio.policy.v1beta1.Action] using name
// 'RequestCountByService'
//
// ```yaml
// - name: RequestCountByService
//   template: istio.mixer.adapter.metric.Metric
//   params:
//     value: 1
//     dimensions:
//       source: source.service
//       destination_ip: destination.ip
// ```
type Instance struct {
	// Required. The name of this instance
	//
	// Must be unique amongst other Instances in scope. Used by [Action][istio.policy.v1beta1.Action] to refer
	// to an instance produced by this instance.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the compiled in template this instance creates instances for. For referencing non compiled-in
	// templates, use the `template` field instead.
	//
	// The value must match the name of the available template Mixer is built with.
	CompiledTemplate string `protobuf:"bytes,67794676,opt,name=compiled_template,json=compiledTemplate,proto3" json:"compiled_template,omitempty"`
	// Required. The name of the template this instance creates instances for. For referencing compiled-in
	// templates, use the `compiled_template` field instead.
	//
	// The value must match the name of the available template in scope.
	Template string `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Required. Depends on referenced template. Struct representation of a
	// proto defined by the template; this varies depending on the value of field `template`.
	Params interface{} `protobuf:"bytes,3,opt,name=params" json:"params,omitempty"`
}

func (m *Instance) Reset()                    { *m = Instance{} }
func (m *Instance) String() string            { return proto.CompactTextString(m) }
func (*Instance) ProtoMessage()               {}
func (*Instance) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{3} }

func (m *Instance) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Instance) GetCompiledTemplate() string {
	if m != nil {
		return m.CompiledTemplate
	}
	return ""
}

func (m *Instance) GetTemplate() string {
	if m != nil {
		return m.Template
	}
	return ""
}

func (m *Instance) GetParams() interface{} {
	if m != nil {
		return m.Params
	}
	return nil
}

// Handler allows the operator to configure a specific adapter implementation.
// Each adapter implementation defines its own `params` proto.
//
// In the following example we define a `metrics` handler for the `prometheus` adapter.
// The example is in the form of a kubernetes resource:
// * The `metadata.name` is the name of the handler
// * The `kind` refers to the adapter name
// * The `spec` block represents adapter-specific configuration as well as the connection information
//
// ```yaml
// # Sample-1: No connection specified (for compiled in adapters)
// # Note: if connection information is not specified, the adapter configuration is directly inside
// # `spec` block. This is going to be DEPRECATED in favor of Sample-2
// apiVersion: "config.istio.io/v1alpha2"
// kind: prometheus
// metadata:
//   name: handler
//   namespace: istio-system
// spec:
//   metrics:
//   - name: request_count
//     instance_name: requestcount.metric.istio-system
//     kind: COUNTER
//     label_names:
//     - source_service
//     - source_version
//     - destination_service
//     - destination_version
// ---
// # Sample-2: With connection information (for out-of-process adapters)
// # Note: Unlike sample-1, the adapter configuration is parallel to `connection` and is nested inside `param` block.
// apiVersion: "config.istio.io/v1alpha2"
// kind: prometheus
// metadata:
//   name: handler
//   namespace: istio-system
// spec:
//   param:
//     metrics:
//     - name: request_count
//       instance_name: requestcount.metric.istio-system
//       kind: COUNTER
//       label_names:
//       - source_service
//       - source_version
//       - destination_service
//       - destination_version
//   connection:
//     address: localhost:8090
// ---
// ```
type Handler struct {
	// Required. Must be unique in the entire mixer configuration. Used by [Actions][istio.policy.v1beta1.Action.handler]
	// to refer to this handler.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the compiled in adapter this handler instantiates. For referencing non compiled-in
	// adapters, use the `adapter` field instead.
	//
	// The value must match the name of the available adapter Mixer is built with. An adapter's name is typically a
	// constant in its code.
	CompiledAdapter string `protobuf:"bytes,67794676,opt,name=compiled_adapter,json=compiledAdapter,proto3" json:"compiled_adapter,omitempty"`
	// Required. The name of a specific adapter implementation. For referencing compiled-in
	// adapters, use the `compiled_adapter` field instead.
	//
	// An adapter's implementation name is typically a constant in its code.
	Adapter string `protobuf:"bytes,2,opt,name=adapter,proto3" json:"adapter,omitempty"`
	// Optional. Depends on adapter implementation. Struct representation of a
	// proto defined by the adapter implementation; this varies depending on the value of field `adapter`.
	Params interface{} `protobuf:"bytes,3,opt,name=params" json:"params,omitempty"`
	// Optional. Information on how to connect to the out-of-process adapter.
	// This is used if the adapter is not compiled into Mixer binary and is running as a separate process.
	Connection *Connection `protobuf:"bytes,4,opt,name=connection" json:"connection,omitempty"`
}

func (m *Handler) Reset()                    { *m = Handler{} }
func (m *Handler) String() string            { return proto.CompactTextString(m) }
func (*Handler) ProtoMessage()               {}
func (*Handler) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{4} }

func (m *Handler) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Handler) GetCompiledAdapter() string {
	if m != nil {
		return m.CompiledAdapter
	}
	return ""
}

func (m *Handler) GetAdapter() string {
	if m != nil {
		return m.Adapter
	}
	return ""
}

func (m *Handler) GetParams() interface{} {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *Handler) GetConnection() *Connection {
	if m != nil {
		return m.Connection
	}
	return nil
}

// Connection allows the operator to specify the endpoint for out-of-process infrastructure backend.
// Connection is part of the handler custom resource and is specified alongside adapter specific configuration.
type Connection struct {
	// The address of the backend.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
}

func (m *Connection) Reset()                    { *m = Connection{} }
func (m *Connection) String() string            { return proto.CompactTextString(m) }
func (*Connection) ProtoMessage()               {}
func (*Connection) Descriptor() ([]byte, []int) { return fileDescriptorCfg, []int{5} }

func (m *Connection) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func init() {
	proto.RegisterType((*AttributeManifest)(nil), "istio.policy.v1beta1.AttributeManifest")
	proto.RegisterType((*AttributeManifest_AttributeInfo)(nil), "istio.policy.v1beta1.AttributeManifest.AttributeInfo")
	proto.RegisterType((*Rule)(nil), "istio.policy.v1beta1.Rule")
	proto.RegisterType((*Rule_HeaderOperationTemplate)(nil), "istio.policy.v1beta1.Rule.HeaderOperationTemplate")
	proto.RegisterType((*Action)(nil), "istio.policy.v1beta1.Action")
	proto.RegisterType((*Instance)(nil), "istio.policy.v1beta1.Instance")
	proto.RegisterType((*Handler)(nil), "istio.policy.v1beta1.Handler")
	proto.RegisterType((*Connection)(nil), "istio.policy.v1beta1.Connection")
	proto.RegisterEnum("istio.policy.v1beta1.Rule_HeaderOperationTemplate_Operation", Rule_HeaderOperationTemplate_Operation_name, Rule_HeaderOperationTemplate_Operation_value)
}

func init() { proto.RegisterFile("policy/v1beta1/cfg.proto", fileDescriptorCfg) }

var fileDescriptorCfg = []byte{
	// 667 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xcd, 0x6e, 0xd3, 0x4a,
	0x14, 0xbe, 0x4e, 0xd2, 0xa4, 0x3e, 0xd1, 0xbd, 0x4d, 0x47, 0xd5, 0xad, 0xaf, 0x6f, 0x51, 0x23,
	0x2f, 0x50, 0x17, 0xc8, 0xa6, 0x41, 0xfc, 0x08, 0x21, 0x44, 0x28, 0x91, 0x5a, 0x41, 0x69, 0x35,
	0x54, 0x45, 0xea, 0x26, 0x9a, 0x38, 0x27, 0xad, 0x85, 0x63, 0xbb, 0x33, 0x93, 0x48, 0x79, 0x00,
	0x76, 0xbc, 0x01, 0x4f, 0xc0, 0xf3, 0xb0, 0xe1, 0x25, 0xd8, 0xf1, 0x00, 0xc8, 0x33, 0xfe, 0x09,
	0xc1, 0x5d, 0x94, 0xdd, 0x9c, 0x73, 0xbe, 0xf3, 0x9d, 0xef, 0x7c, 0x1e, 0x0f, 0x58, 0x49, 0x1c,
	0x06, 0xfe, 0xc2, 0x9b, 0xef, 0x8f, 0x50, 0xb2, 0x7d, 0xcf, 0x9f, 0x5c, 0xba, 0x09, 0x8f, 0x65,
	0x4c, 0xb6, 0x02, 0x21, 0x83, 0xd8, 0xd5, 0x75, 0x37, 0xab, 0xdb, 0x3b, 0x97, 0x71, 0x7c, 0x19,
	0xa2, 0xa7, 0x30, 0xa3, 0xd9, 0xc4, 0x13, 0x92, 0xcf, 0x7c, 0xa9, 0x7b, 0xec, 0xdd, 0x15, 0xb6,
	0x39, 0x0b, 0x67, 0x38, 0x94, 0x8b, 0x04, 0x35, 0xc0, 0xf9, 0x58, 0x87, 0xcd, 0xbe, 0x94, 0x3c,
	0x18, 0xcd, 0x24, 0x1e, 0xb3, 0x28, 0x98, 0xa0, 0x90, 0xc4, 0x86, 0x75, 0x8e, 0xf3, 0x40, 0x04,
	0x71, 0x64, 0x19, 0x5d, 0x63, 0xcf, 0xa4, 0x45, 0x4c, 0x08, 0x34, 0x22, 0x36, 0x45, 0xab, 0xa6,
	0xf2, 0xea, 0x4c, 0xde, 0x03, 0xb0, 0x9c, 0x44, 0x58, 0xf5, 0x6e, 0x7d, 0xaf, 0xdd, 0x7b, 0xec,
	0x56, 0xe9, 0x75, 0x7f, 0x1b, 0x56, 0x66, 0xc4, 0x20, 0x92, 0x7c, 0x41, 0x97, 0xa8, 0xec, 0x6b,
	0xf8, 0xbb, 0x28, 0x1f, 0x45, 0x93, 0x98, 0x74, 0xa1, 0x3d, 0x46, 0xe1, 0xf3, 0x20, 0x91, 0xa5,
	0xb8, 0xe5, 0x14, 0x79, 0x0e, 0x50, 0x6e, 0xa9, 0x54, 0xfe, 0xd3, 0xdb, 0xad, 0xd6, 0x72, 0x9e,
	0xe2, 0xce, 0x16, 0x09, 0x52, 0x73, 0x9e, 0x1f, 0x6d, 0x09, 0x1b, 0x2b, 0x8a, 0x48, 0x07, 0xea,
	0x1f, 0x70, 0x91, 0x0d, 0x4b, 0x8f, 0xe4, 0x35, 0xac, 0xa9, 0x0e, 0xc5, 0xdf, 0xee, 0x3d, 0xbc,
	0xf5, 0xae, 0xe9, 0x32, 0x54, 0x73, 0x3c, 0xad, 0x3d, 0x31, 0x9c, 0x4f, 0x0d, 0x68, 0xd0, 0x59,
	0x88, 0x64, 0x0b, 0xd6, 0xa6, 0x4c, 0xfa, 0x57, 0xd9, 0x34, 0x1d, 0x90, 0x47, 0xd0, 0x62, 0x7e,
	0xba, 0x9e, 0xb0, 0x6a, 0xca, 0xdd, 0x9d, 0x1b, 0x26, 0x2a, 0x10, 0xcd, 0xc1, 0x24, 0x82, 0xff,
	0x38, 0x5e, 0xcf, 0x50, 0xc8, 0xe1, 0x15, 0xb2, 0x31, 0xf2, 0x61, 0x9c, 0x20, 0x67, 0x9a, 0x49,
	0x7f, 0xa7, 0x5e, 0x35, 0x53, 0x2a, 0xc6, 0x3d, 0x54, 0x3d, 0x27, 0x79, 0xcb, 0x19, 0x4e, 0x93,
	0x90, 0x49, 0xa4, 0xdb, 0x19, 0xe9, 0x4a, 0x5d, 0x90, 0x04, 0x6c, 0x8e, 0x22, 0x89, 0x23, 0x81,
	0x15, 0x03, 0x1b, 0x7f, 0x3c, 0xd0, 0xca, 0x59, 0x57, 0x27, 0xda, 0x5f, 0x0d, 0xd8, 0xbe, 0xa1,
	0xab, 0xb8, 0xaa, 0xc6, 0xd2, 0x55, 0xfd, 0x17, 0x9a, 0xca, 0x75, 0x6d, 0xa4, 0x49, 0xb3, 0x88,
	0x5c, 0x80, 0x59, 0x28, 0xb5, 0xea, 0xea, 0xd6, 0x3c, 0xbb, 0xbd, 0x50, 0xb7, 0xc8, 0xd0, 0x92,
	0xce, 0xb9, 0x0f, 0x66, 0x91, 0x27, 0x6d, 0x68, 0xd1, 0xc1, 0xe9, 0x9b, 0xfe, 0xc1, 0xa0, 0xf3,
	0x17, 0x01, 0x68, 0xd2, 0xc1, 0xf1, 0xc9, 0xf9, 0xa0, 0x63, 0xa4, 0xe7, 0xfe, 0xe9, 0xe9, 0xe0,
	0xed, 0xab, 0x4e, 0xcd, 0x39, 0x83, 0xa6, 0xfe, 0x94, 0xc4, 0x82, 0xd6, 0x15, 0x8b, 0xc6, 0x21,
	0xf2, 0xec, 0x8f, 0xcb, 0x43, 0xb2, 0x03, 0x66, 0x10, 0x09, 0xc9, 0x22, 0x3f, 0xfb, 0xe7, 0x4c,
	0x5a, 0x26, 0x8a, 0xdd, 0x1b, 0xe5, 0xee, 0xce, 0x67, 0x03, 0xd6, 0x8f, 0x32, 0x44, 0xa5, 0x39,
	0x2e, 0x6c, 0xfa, 0xf1, 0x34, 0x09, 0x42, 0x1c, 0x0f, 0x65, 0xb6, 0x92, 0xf5, 0xe3, 0xfb, 0x97,
	0xae, 0xc2, 0x74, 0xf2, 0x5a, 0x61, 0xb0, 0x0d, 0xeb, 0x05, 0x4c, 0xab, 0x2b, 0x62, 0xe2, 0x41,
	0x33, 0x61, 0x9c, 0x4d, 0x85, 0x72, 0xb3, 0xdd, 0xdb, 0x76, 0xf5, 0x4b, 0xe5, 0xe6, 0x2f, 0x95,
	0xfb, 0x4e, 0xbd, 0x54, 0x34, 0x83, 0x39, 0xdf, 0x0c, 0x68, 0x1d, 0x66, 0xbb, 0x55, 0x89, 0xbb,
	0x07, 0x85, 0x80, 0x21, 0x1b, 0xb3, 0x44, 0x22, 0x2f, 0xb5, 0x6d, 0xe4, 0xa5, 0xbe, 0xae, 0xa4,
	0xbe, 0xe5, 0xa0, 0xcc, 0xb7, 0x2c, 0xbc, 0xb5, 0x30, 0xf2, 0x02, 0xc0, 0x8f, 0xa3, 0x08, 0xd5,
	0x07, 0x51, 0x86, 0xb6, 0x7b, 0xdd, 0xea, 0xbb, 0x71, 0x50, 0xe0, 0xe8, 0x52, 0x8f, 0x73, 0x17,
	0xa0, 0xac, 0x68, 0x69, 0x63, 0x8e, 0x42, 0x94, 0xd2, 0x54, 0xf8, 0xf2, 0xce, 0xc5, 0xff, 0x9a,
	0x36, 0x88, 0x3d, 0x96, 0x04, 0xde, 0xaf, 0xaf, 0xf7, 0xa8, 0xa9, 0x14, 0x3e, 0xf8, 0x19, 0x00,
	0x00, 0xff, 0xff, 0x09, 0xa6, 0x8b, 0x9b, 0x24, 0x06, 0x00, 0x00,
}
