// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mesh/v1alpha1/config.proto

/*
	Package v1alpha1 is a generated protocol buffer package.

	It is generated from these files:
		mesh/v1alpha1/config.proto

	It has these top-level messages:
		ProxyConfig
		MeshConfig
*/
package v1alpha1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// AuthenticationPolicy defines authentication policy. It can be set for
// different scopes (mesh, service …), and the most narrow scope with
// non-INHERIT value will be used.
// Mesh policy cannot be INHERIT.
type AuthenticationPolicy int32

const (
	// Do not encrypt Envoy to Envoy traffic.
	AuthenticationPolicy_NONE AuthenticationPolicy = 0
	// Envoy to Envoy traffic is wrapped into mutual TLS connections.
	AuthenticationPolicy_MUTUAL_TLS AuthenticationPolicy = 1
	// Use the policy defined by the parent scope. Should not be used for mesh
	// policy.
	AuthenticationPolicy_INHERIT AuthenticationPolicy = 1000
)

var AuthenticationPolicy_name = map[int32]string{
	0:    "NONE",
	1:    "MUTUAL_TLS",
	1000: "INHERIT",
}
var AuthenticationPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
	"INHERIT":    1000,
}

func (x AuthenticationPolicy) String() string {
	return proto.EnumName(AuthenticationPolicy_name, int32(x))
}
func (AuthenticationPolicy) EnumDescriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

// The mode used to redirect inbound traffic to Envoy.
// This setting has no effect on outbound traffic: iptables REDIRECT is always used for
// outbound connections.
type ProxyConfig_InboundInterceptionMode int32

const (
	// The REDIRECT mode uses iptables REDIRECT to NAT and redirect to Envoy. This mode loses
	// source IP addresses during redirection.
	ProxyConfig_REDIRECT ProxyConfig_InboundInterceptionMode = 0
	// The TPROXY mode uses iptables TPROXY to redirect to Envoy. This mode preserves both the
	// source and destination IP addresses and ports, so that they can be used for advanced
	// filtering and manipulation. This mode also configures the sidecar to run with the
	// CAP_NET_ADMIN capability, which is required to use TPROXY.
	ProxyConfig_TPROXY ProxyConfig_InboundInterceptionMode = 1
)

var ProxyConfig_InboundInterceptionMode_name = map[int32]string{
	0: "REDIRECT",
	1: "TPROXY",
}
var ProxyConfig_InboundInterceptionMode_value = map[string]int32{
	"REDIRECT": 0,
	"TPROXY":   1,
}

func (x ProxyConfig_InboundInterceptionMode) String() string {
	return proto.EnumName(ProxyConfig_InboundInterceptionMode_name, int32(x))
}
func (ProxyConfig_InboundInterceptionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0}
}

type MeshConfig_IngressControllerMode int32

const (
	// Disables Istio ingress controller.
	MeshConfig_OFF MeshConfig_IngressControllerMode = 0
	// Istio ingress controller will act on ingress resources that do not
	// contain any annotation or whose annotations match the value
	// specified in the ingress_class parameter described earlier. Use this
	// mode if Istio ingress controller will be the default ingress
	// controller for the entire kubernetes cluster.
	MeshConfig_DEFAULT MeshConfig_IngressControllerMode = 1
	// Istio ingress controller will only act on ingress resources whose
	// annotations match the value specified in the ingress_class parameter
	// described earlier. Use this mode if Istio ingress controller will be
	// a secondary ingress controller (e.g., in addition to a
	// cloud-provided ingress controller).
	MeshConfig_STRICT MeshConfig_IngressControllerMode = 2
)

var MeshConfig_IngressControllerMode_name = map[int32]string{
	0: "OFF",
	1: "DEFAULT",
	2: "STRICT",
}
var MeshConfig_IngressControllerMode_value = map[string]int32{
	"OFF":     0,
	"DEFAULT": 1,
	"STRICT":  2,
}

func (x MeshConfig_IngressControllerMode) String() string {
	return proto.EnumName(MeshConfig_IngressControllerMode_name, int32(x))
}
func (MeshConfig_IngressControllerMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{1, 0}
}

// TODO AuthPolicy needs to be removed and merged with AuthPolicy defined above
type MeshConfig_AuthPolicy int32

const (
	// Do not encrypt Envoy to Envoy traffic.
	MeshConfig_NONE MeshConfig_AuthPolicy = 0
	// Envoy to Envoy traffic is wrapped into mutual TLS connections.
	MeshConfig_MUTUAL_TLS MeshConfig_AuthPolicy = 1
)

var MeshConfig_AuthPolicy_name = map[int32]string{
	0: "NONE",
	1: "MUTUAL_TLS",
}
var MeshConfig_AuthPolicy_value = map[string]int32{
	"NONE":       0,
	"MUTUAL_TLS": 1,
}

func (x MeshConfig_AuthPolicy) String() string {
	return proto.EnumName(MeshConfig_AuthPolicy_name, int32(x))
}
func (MeshConfig_AuthPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{1, 1}
}

type MeshConfig_OutboundTrafficPolicy_Mode int32

const (
	// outbound traffic will be restricted to services defined in the service registry as well as those defined
	// through ServiceEntries
	MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY MeshConfig_OutboundTrafficPolicy_Mode = 0
	// outbound traffic to unknown destinations will be allowed
	MeshConfig_OutboundTrafficPolicy_ALLOW_ANY MeshConfig_OutboundTrafficPolicy_Mode = 1
	// not implemented. outbound traffic will be restricted to destinations defined in VirtualServices only
	MeshConfig_OutboundTrafficPolicy_VIRTUAL_SERVICE_ONLY MeshConfig_OutboundTrafficPolicy_Mode = 2
)

var MeshConfig_OutboundTrafficPolicy_Mode_name = map[int32]string{
	0: "REGISTRY_ONLY",
	1: "ALLOW_ANY",
	2: "VIRTUAL_SERVICE_ONLY",
}
var MeshConfig_OutboundTrafficPolicy_Mode_value = map[string]int32{
	"REGISTRY_ONLY":        0,
	"ALLOW_ANY":            1,
	"VIRTUAL_SERVICE_ONLY": 2,
}

func (x MeshConfig_OutboundTrafficPolicy_Mode) String() string {
	return proto.EnumName(MeshConfig_OutboundTrafficPolicy_Mode_name, int32(x))
}
func (MeshConfig_OutboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{1, 0, 0}
}

// ProxyConfig defines variables for individual Envoy instances.
type ProxyConfig struct {
	// Path to the generated configuration file directory.
	// Proxy agent generates the actual configuration and stores it in this directory.
	ConfigPath string `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3" json:"config_path,omitempty"`
	// Path to the proxy binary
	BinaryPath string `protobuf:"bytes,2,opt,name=binary_path,json=binaryPath,proto3" json:"binary_path,omitempty"`
	// Service cluster defines the name for the service_cluster that is
	// shared by all Envoy instances. This setting corresponds to
	// _--service-cluster_ flag in Envoy.  In a typical Envoy deployment, the
	// _service-cluster_ flag is used to identify the caller, for
	// source-based routing scenarios.
	//
	// Since Istio does not assign a local service/service version to each
	// Envoy instance, the name is same for all of them.  However, the
	// source/caller's identity (e.g., IP address) is encoded in the
	// _--service-node_ flag when launching Envoy.  When the RDS service
	// receives API calls from Envoy, it uses the value of the _service-node_
	// flag to compute routes that are relative to the service instances
	// located at that IP address.
	ServiceCluster string `protobuf:"bytes,3,opt,name=service_cluster,json=serviceCluster,proto3" json:"service_cluster,omitempty"`
	// The time in seconds that Envoy will drain connections during a hot
	// restart. MUST be >=1s (e.g., _1s/1m/1h_)
	DrainDuration *google_protobuf.Duration `protobuf:"bytes,4,opt,name=drain_duration,json=drainDuration" json:"drain_duration,omitempty"`
	// The time in seconds that Envoy will wait before shutting down the
	// parent process during a hot restart. MUST be >=1s (e.g., _1s/1m/1h_).
	// MUST BE greater than _drain_duration_ parameter.
	ParentShutdownDuration *google_protobuf.Duration `protobuf:"bytes,5,opt,name=parent_shutdown_duration,json=parentShutdownDuration" json:"parent_shutdown_duration,omitempty"`
	// Address of the discovery service exposing xDS with mTLS connection.
	DiscoveryAddress string `protobuf:"bytes,6,opt,name=discovery_address,json=discoveryAddress,proto3" json:"discovery_address,omitempty"`
	// Polling interval for service discovery (used by EDS, CDS, LDS, but not RDS). (MUST BE >=1ms)
	DiscoveryRefreshDelay *google_protobuf.Duration `protobuf:"bytes,7,opt,name=discovery_refresh_delay,json=discoveryRefreshDelay" json:"discovery_refresh_delay,omitempty"`
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	ZipkinAddress string `protobuf:"bytes,8,opt,name=zipkin_address,json=zipkinAddress,proto3" json:"zipkin_address,omitempty"`
	// Connection timeout used by Envoy for supporting services. (MUST BE >=1ms)
	ConnectTimeout *google_protobuf.Duration `protobuf:"bytes,9,opt,name=connect_timeout,json=connectTimeout" json:"connect_timeout,omitempty"`
	// IP Address and Port of a statsd UDP listener (e.g. _10.75.241.127:9125_).
	StatsdUdpAddress string `protobuf:"bytes,10,opt,name=statsd_udp_address,json=statsdUdpAddress,proto3" json:"statsd_udp_address,omitempty"`
	// Port on which Envoy should listen for administrative commands.
	ProxyAdminPort int32 `protobuf:"varint,11,opt,name=proxy_admin_port,json=proxyAdminPort,proto3" json:"proxy_admin_port,omitempty"`
	// The availability zone where this Envoy instance is running. When running
	// Envoy as a sidecar in Kubernetes, this flag must be one of the availability
	// zones assigned to a node using failure-domain.beta.kubernetes.io/zone annotation.
	AvailabilityZone string `protobuf:"bytes,12,opt,name=availability_zone,json=availabilityZone,proto3" json:"availability_zone,omitempty"`
	// Authentication policy defines the global switch to control authentication
	// for Envoy-to-Envoy communication for istio components Mixer and Pilot.
	ControlPlaneAuthPolicy AuthenticationPolicy `protobuf:"varint,13,opt,name=control_plane_auth_policy,json=controlPlaneAuthPolicy,proto3,enum=istio.mesh.v1alpha1.AuthenticationPolicy" json:"control_plane_auth_policy,omitempty"`
	// File path of custom proxy configuration, currently used by proxies
	// in front of Mixer and Pilot.
	CustomConfigFile string `protobuf:"bytes,14,opt,name=custom_config_file,json=customConfigFile,proto3" json:"custom_config_file,omitempty"`
	// Maximum length of name field in Envoy's metrics. The length of the name field
	// is determined by the length of a name field in a service and the set of labels that
	// comprise a particular version of the service. The default value is set to 189 characters.
	// Envoy's internal metrics take up 67 characters, for a total of 256 character name per metric.
	// Increase the value of this field if you find that the metrics from Envoys are truncated.
	StatNameLength int32 `protobuf:"varint,15,opt,name=stat_name_length,json=statNameLength,proto3" json:"stat_name_length,omitempty"`
	// The number of worker threads to run. Default value is number of cores on the machine.
	Concurrency int32 `protobuf:"varint,16,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	// Path to the proxy bootstrap template file
	ProxyBootstrapTemplatePath string `protobuf:"bytes,17,opt,name=proxy_bootstrap_template_path,json=proxyBootstrapTemplatePath,proto3" json:"proxy_bootstrap_template_path,omitempty"`
	// The mode used to redirect inbound traffic to Envoy.
	InterceptionMode ProxyConfig_InboundInterceptionMode `protobuf:"varint,18,opt,name=interception_mode,json=interceptionMode,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode" json:"interception_mode,omitempty"`
}

func (m *ProxyConfig) Reset()                    { *m = ProxyConfig{} }
func (m *ProxyConfig) String() string            { return proto.CompactTextString(m) }
func (*ProxyConfig) ProtoMessage()               {}
func (*ProxyConfig) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

func (m *ProxyConfig) GetConfigPath() string {
	if m != nil {
		return m.ConfigPath
	}
	return ""
}

func (m *ProxyConfig) GetBinaryPath() string {
	if m != nil {
		return m.BinaryPath
	}
	return ""
}

func (m *ProxyConfig) GetServiceCluster() string {
	if m != nil {
		return m.ServiceCluster
	}
	return ""
}

func (m *ProxyConfig) GetDrainDuration() *google_protobuf.Duration {
	if m != nil {
		return m.DrainDuration
	}
	return nil
}

func (m *ProxyConfig) GetParentShutdownDuration() *google_protobuf.Duration {
	if m != nil {
		return m.ParentShutdownDuration
	}
	return nil
}

func (m *ProxyConfig) GetDiscoveryAddress() string {
	if m != nil {
		return m.DiscoveryAddress
	}
	return ""
}

func (m *ProxyConfig) GetDiscoveryRefreshDelay() *google_protobuf.Duration {
	if m != nil {
		return m.DiscoveryRefreshDelay
	}
	return nil
}

func (m *ProxyConfig) GetZipkinAddress() string {
	if m != nil {
		return m.ZipkinAddress
	}
	return ""
}

func (m *ProxyConfig) GetConnectTimeout() *google_protobuf.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *ProxyConfig) GetStatsdUdpAddress() string {
	if m != nil {
		return m.StatsdUdpAddress
	}
	return ""
}

func (m *ProxyConfig) GetProxyAdminPort() int32 {
	if m != nil {
		return m.ProxyAdminPort
	}
	return 0
}

func (m *ProxyConfig) GetAvailabilityZone() string {
	if m != nil {
		return m.AvailabilityZone
	}
	return ""
}

func (m *ProxyConfig) GetControlPlaneAuthPolicy() AuthenticationPolicy {
	if m != nil {
		return m.ControlPlaneAuthPolicy
	}
	return AuthenticationPolicy_NONE
}

func (m *ProxyConfig) GetCustomConfigFile() string {
	if m != nil {
		return m.CustomConfigFile
	}
	return ""
}

func (m *ProxyConfig) GetStatNameLength() int32 {
	if m != nil {
		return m.StatNameLength
	}
	return 0
}

func (m *ProxyConfig) GetConcurrency() int32 {
	if m != nil {
		return m.Concurrency
	}
	return 0
}

func (m *ProxyConfig) GetProxyBootstrapTemplatePath() string {
	if m != nil {
		return m.ProxyBootstrapTemplatePath
	}
	return ""
}

func (m *ProxyConfig) GetInterceptionMode() ProxyConfig_InboundInterceptionMode {
	if m != nil {
		return m.InterceptionMode
	}
	return ProxyConfig_REDIRECT
}

// MeshConfig defines mesh-wide variables shared by all Envoy instances in the
// Istio service mesh.
//
// NOTE: This configuration type should be used for the low-level global
// configuration, such as component addresses and port numbers. It should not
// be used for the features of the mesh that can be scoped by service or by
// namespace. Some of the fields in the mesh config are going to be deprecated
// and replaced with several individual configuration types (for example,
// tracing configuration).
type MeshConfig struct {
	// Address of the server that will be used by the proxies for policy
	// check calls. By using different names for mixerCheckServer and
	// mixerReportServer, it is possible to have one set of mixer servers handle
	// policy check calls while another set of mixer servers handle telemetry
	// calls.
	//
	// NOTE: Omitting mixerCheckServer while specifying mixerReportServer is
	// equivalent to setting disablePolicyChecks to true.
	MixerCheckServer string `protobuf:"bytes,1,opt,name=mixer_check_server,json=mixerCheckServer,proto3" json:"mixer_check_server,omitempty"`
	// Address of the server that will be used by the proxies for policy report
	// calls.
	MixerReportServer string `protobuf:"bytes,2,opt,name=mixer_report_server,json=mixerReportServer,proto3" json:"mixer_report_server,omitempty"`
	// Disable policy checks by the mixer service. Default
	// is false, i.e. mixer policy check is enabled by default.
	DisablePolicyChecks bool `protobuf:"varint,3,opt,name=disable_policy_checks,json=disablePolicyChecks,proto3" json:"disable_policy_checks,omitempty"`
	// Port on which Envoy should listen for incoming connections from
	// other services.
	ProxyListenPort int32 `protobuf:"varint,4,opt,name=proxy_listen_port,json=proxyListenPort,proto3" json:"proxy_listen_port,omitempty"`
	// Port on which Envoy should listen for HTTP PROXY requests if set.
	ProxyHttpPort int32 `protobuf:"varint,5,opt,name=proxy_http_port,json=proxyHttpPort,proto3" json:"proxy_http_port,omitempty"`
	// Connection timeout used by Envoy. (MUST BE >=1ms)
	ConnectTimeout *google_protobuf.Duration `protobuf:"bytes,6,opt,name=connect_timeout,json=connectTimeout" json:"connect_timeout,omitempty"`
	// Class of ingress resources to be processed by Istio ingress
	// controller.  This corresponds to the value of
	// "kubernetes.io/ingress.class" annotation.
	IngressClass string `protobuf:"bytes,7,opt,name=ingress_class,json=ingressClass,proto3" json:"ingress_class,omitempty"`
	// Name of the kubernetes service used for the istio ingress controller.
	IngressService string `protobuf:"bytes,8,opt,name=ingress_service,json=ingressService,proto3" json:"ingress_service,omitempty"`
	// Defines whether to use Istio ingress controller for annotated or all ingress resources.
	IngressControllerMode MeshConfig_IngressControllerMode `protobuf:"varint,9,opt,name=ingress_controller_mode,json=ingressControllerMode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_IngressControllerMode" json:"ingress_controller_mode,omitempty"`
	// Authentication policy defines the global switch to control authentication
	// for Envoy-to-Envoy communication.
	// Use authentication_policy instead.
	AuthPolicy MeshConfig_AuthPolicy `protobuf:"varint,10,opt,name=auth_policy,json=authPolicy,proto3,enum=istio.mesh.v1alpha1.MeshConfig_AuthPolicy" json:"auth_policy,omitempty"`
	// Polling interval for RDS (MUST BE >=1ms)
	RdsRefreshDelay *google_protobuf.Duration `protobuf:"bytes,11,opt,name=rds_refresh_delay,json=rdsRefreshDelay" json:"rds_refresh_delay,omitempty"`
	// Flag to control generation of trace spans and request IDs.
	// Requires a trace span collector defined in the proxy configuration.
	EnableTracing bool `protobuf:"varint,12,opt,name=enable_tracing,json=enableTracing,proto3" json:"enable_tracing,omitempty"`
	// File address for the proxy access log (e.g. /dev/stdout).
	// Empty value disables access logging.
	AccessLogFile string `protobuf:"bytes,13,opt,name=access_log_file,json=accessLogFile,proto3" json:"access_log_file,omitempty"`
	// Default proxy config used by the proxy injection mechanism operating in the mesh
	// (e.g. Kubernetes admission controller)
	// In case of Kubernetes, the proxy config is applied once during the injection process,
	// and remain constant for the duration of the pod. The rest of the mesh config can be changed
	// at runtime and config gets distributed dynamically.
	DefaultConfig *ProxyConfig `protobuf:"bytes,14,opt,name=default_config,json=defaultConfig" json:"default_config,omitempty"`
	// DEPRECATED. Mixer address. This option will be removed soon. Please
	// use mixer_check and mixer_report.
	MixerAddress string `protobuf:"bytes,16,opt,name=mixer_address,json=mixerAddress,proto3" json:"mixer_address,omitempty"`
	// Set the default behavior of the sidecar for handling outbound traffic from the application.
	// While the default mode should work out of the box, if your application uses one or more external services that
	// are not known apriori, setting the policy to ALLOW_ANY will cause the sidecars to route traffic to the any
	// requested destination.
	// Users are strongly encouraged to use ServiceEntries to explicitly declare any external dependencies,
	// instead of using allow_any.
	OutboundTrafficPolicy *MeshConfig_OutboundTrafficPolicy `protobuf:"bytes,17,opt,name=outbound_traffic_policy,json=outboundTrafficPolicy" json:"outbound_traffic_policy,omitempty"`
	// Enables clide side policy checks.
	EnableClientSidePolicyCheck bool `protobuf:"varint,19,opt,name=enable_client_side_policy_check,json=enableClientSidePolicyCheck,proto3" json:"enable_client_side_policy_check,omitempty"`
	// Unix Domain Socket through which envoy communicates with NodeAgent SDS to get key/cert for mTLS.
	// Use secret-mount files instead of SDS if set to empty.
	SdsUdsPath string `protobuf:"bytes,20,opt,name=sds_uds_path,json=sdsUdsPath,proto3" json:"sds_uds_path,omitempty"`
	// Polling interval for SDS (MUST BE >=1ms)
	SdsRefreshDelay *google_protobuf.Duration `protobuf:"bytes,21,opt,name=sds_refresh_delay,json=sdsRefreshDelay" json:"sds_refresh_delay,omitempty"`
}

func (m *MeshConfig) Reset()                    { *m = MeshConfig{} }
func (m *MeshConfig) String() string            { return proto.CompactTextString(m) }
func (*MeshConfig) ProtoMessage()               {}
func (*MeshConfig) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{1} }

func (m *MeshConfig) GetMixerCheckServer() string {
	if m != nil {
		return m.MixerCheckServer
	}
	return ""
}

func (m *MeshConfig) GetMixerReportServer() string {
	if m != nil {
		return m.MixerReportServer
	}
	return ""
}

func (m *MeshConfig) GetDisablePolicyChecks() bool {
	if m != nil {
		return m.DisablePolicyChecks
	}
	return false
}

func (m *MeshConfig) GetProxyListenPort() int32 {
	if m != nil {
		return m.ProxyListenPort
	}
	return 0
}

func (m *MeshConfig) GetProxyHttpPort() int32 {
	if m != nil {
		return m.ProxyHttpPort
	}
	return 0
}

func (m *MeshConfig) GetConnectTimeout() *google_protobuf.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

func (m *MeshConfig) GetIngressClass() string {
	if m != nil {
		return m.IngressClass
	}
	return ""
}

func (m *MeshConfig) GetIngressService() string {
	if m != nil {
		return m.IngressService
	}
	return ""
}

func (m *MeshConfig) GetIngressControllerMode() MeshConfig_IngressControllerMode {
	if m != nil {
		return m.IngressControllerMode
	}
	return MeshConfig_OFF
}

func (m *MeshConfig) GetAuthPolicy() MeshConfig_AuthPolicy {
	if m != nil {
		return m.AuthPolicy
	}
	return MeshConfig_NONE
}

func (m *MeshConfig) GetRdsRefreshDelay() *google_protobuf.Duration {
	if m != nil {
		return m.RdsRefreshDelay
	}
	return nil
}

func (m *MeshConfig) GetEnableTracing() bool {
	if m != nil {
		return m.EnableTracing
	}
	return false
}

func (m *MeshConfig) GetAccessLogFile() string {
	if m != nil {
		return m.AccessLogFile
	}
	return ""
}

func (m *MeshConfig) GetDefaultConfig() *ProxyConfig {
	if m != nil {
		return m.DefaultConfig
	}
	return nil
}

func (m *MeshConfig) GetMixerAddress() string {
	if m != nil {
		return m.MixerAddress
	}
	return ""
}

func (m *MeshConfig) GetOutboundTrafficPolicy() *MeshConfig_OutboundTrafficPolicy {
	if m != nil {
		return m.OutboundTrafficPolicy
	}
	return nil
}

func (m *MeshConfig) GetEnableClientSidePolicyCheck() bool {
	if m != nil {
		return m.EnableClientSidePolicyCheck
	}
	return false
}

func (m *MeshConfig) GetSdsUdsPath() string {
	if m != nil {
		return m.SdsUdsPath
	}
	return ""
}

func (m *MeshConfig) GetSdsRefreshDelay() *google_protobuf.Duration {
	if m != nil {
		return m.SdsRefreshDelay
	}
	return nil
}

type MeshConfig_OutboundTrafficPolicy struct {
	Mode MeshConfig_OutboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode" json:"mode,omitempty"`
}

func (m *MeshConfig_OutboundTrafficPolicy) Reset()         { *m = MeshConfig_OutboundTrafficPolicy{} }
func (m *MeshConfig_OutboundTrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*MeshConfig_OutboundTrafficPolicy) ProtoMessage()    {}
func (*MeshConfig_OutboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{1, 0}
}

func (m *MeshConfig_OutboundTrafficPolicy) GetMode() MeshConfig_OutboundTrafficPolicy_Mode {
	if m != nil {
		return m.Mode
	}
	return MeshConfig_OutboundTrafficPolicy_REGISTRY_ONLY
}

func init() {
	proto.RegisterType((*ProxyConfig)(nil), "istio.mesh.v1alpha1.ProxyConfig")
	proto.RegisterType((*MeshConfig)(nil), "istio.mesh.v1alpha1.MeshConfig")
	proto.RegisterType((*MeshConfig_OutboundTrafficPolicy)(nil), "istio.mesh.v1alpha1.MeshConfig.OutboundTrafficPolicy")
	proto.RegisterEnum("istio.mesh.v1alpha1.AuthenticationPolicy", AuthenticationPolicy_name, AuthenticationPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode", ProxyConfig_InboundInterceptionMode_name, ProxyConfig_InboundInterceptionMode_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_IngressControllerMode", MeshConfig_IngressControllerMode_name, MeshConfig_IngressControllerMode_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_AuthPolicy", MeshConfig_AuthPolicy_name, MeshConfig_AuthPolicy_value)
	proto.RegisterEnum("istio.mesh.v1alpha1.MeshConfig_OutboundTrafficPolicy_Mode", MeshConfig_OutboundTrafficPolicy_Mode_name, MeshConfig_OutboundTrafficPolicy_Mode_value)
}
func (m *ProxyConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProxyConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ConfigPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ConfigPath)))
		i += copy(dAtA[i:], m.ConfigPath)
	}
	if len(m.BinaryPath) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.BinaryPath)))
		i += copy(dAtA[i:], m.BinaryPath)
	}
	if len(m.ServiceCluster) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ServiceCluster)))
		i += copy(dAtA[i:], m.ServiceCluster)
	}
	if m.DrainDuration != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.DrainDuration.Size()))
		n1, err := m.DrainDuration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.ParentShutdownDuration != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ParentShutdownDuration.Size()))
		n2, err := m.ParentShutdownDuration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.DiscoveryAddress) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.DiscoveryAddress)))
		i += copy(dAtA[i:], m.DiscoveryAddress)
	}
	if m.DiscoveryRefreshDelay != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.DiscoveryRefreshDelay.Size()))
		n3, err := m.DiscoveryRefreshDelay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.ZipkinAddress) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ZipkinAddress)))
		i += copy(dAtA[i:], m.ZipkinAddress)
	}
	if m.ConnectTimeout != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ConnectTimeout.Size()))
		n4, err := m.ConnectTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.StatsdUdpAddress) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.StatsdUdpAddress)))
		i += copy(dAtA[i:], m.StatsdUdpAddress)
	}
	if m.ProxyAdminPort != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyAdminPort))
	}
	if len(m.AvailabilityZone) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AvailabilityZone)))
		i += copy(dAtA[i:], m.AvailabilityZone)
	}
	if m.ControlPlaneAuthPolicy != 0 {
		dAtA[i] = 0x68
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ControlPlaneAuthPolicy))
	}
	if len(m.CustomConfigFile) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.CustomConfigFile)))
		i += copy(dAtA[i:], m.CustomConfigFile)
	}
	if m.StatNameLength != 0 {
		dAtA[i] = 0x78
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.StatNameLength))
	}
	if m.Concurrency != 0 {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Concurrency))
	}
	if len(m.ProxyBootstrapTemplatePath) > 0 {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ProxyBootstrapTemplatePath)))
		i += copy(dAtA[i:], m.ProxyBootstrapTemplatePath)
	}
	if m.InterceptionMode != 0 {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.InterceptionMode))
	}
	return i, nil
}

func (m *MeshConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.MixerCheckServer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerCheckServer)))
		i += copy(dAtA[i:], m.MixerCheckServer)
	}
	if len(m.MixerReportServer) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerReportServer)))
		i += copy(dAtA[i:], m.MixerReportServer)
	}
	if m.DisablePolicyChecks {
		dAtA[i] = 0x18
		i++
		if m.DisablePolicyChecks {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.ProxyListenPort != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyListenPort))
	}
	if m.ProxyHttpPort != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ProxyHttpPort))
	}
	if m.ConnectTimeout != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ConnectTimeout.Size()))
		n5, err := m.ConnectTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.IngressClass) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressClass)))
		i += copy(dAtA[i:], m.IngressClass)
	}
	if len(m.IngressService) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngressService)))
		i += copy(dAtA[i:], m.IngressService)
	}
	if m.IngressControllerMode != 0 {
		dAtA[i] = 0x48
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.IngressControllerMode))
	}
	if m.AuthPolicy != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.AuthPolicy))
	}
	if m.RdsRefreshDelay != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.RdsRefreshDelay.Size()))
		n6, err := m.RdsRefreshDelay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.EnableTracing {
		dAtA[i] = 0x60
		i++
		if m.EnableTracing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.AccessLogFile) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessLogFile)))
		i += copy(dAtA[i:], m.AccessLogFile)
	}
	if m.DefaultConfig != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.DefaultConfig.Size()))
		n7, err := m.DefaultConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if len(m.MixerAddress) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.MixerAddress)))
		i += copy(dAtA[i:], m.MixerAddress)
	}
	if m.OutboundTrafficPolicy != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.OutboundTrafficPolicy.Size()))
		n8, err := m.OutboundTrafficPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.EnableClientSidePolicyCheck {
		dAtA[i] = 0x98
		i++
		dAtA[i] = 0x1
		i++
		if m.EnableClientSidePolicyCheck {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SdsUdsPath) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.SdsUdsPath)))
		i += copy(dAtA[i:], m.SdsUdsPath)
	}
	if m.SdsRefreshDelay != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.SdsRefreshDelay.Size()))
		n9, err := m.SdsRefreshDelay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *MeshConfig_OutboundTrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MeshConfig_OutboundTrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Mode))
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ProxyConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.ConfigPath)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.BinaryPath)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ServiceCluster)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DrainDuration != nil {
		l = m.DrainDuration.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.ParentShutdownDuration != nil {
		l = m.ParentShutdownDuration.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.DiscoveryAddress)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DiscoveryRefreshDelay != nil {
		l = m.DiscoveryRefreshDelay.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ZipkinAddress)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.StatsdUdpAddress)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.ProxyAdminPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyAdminPort))
	}
	l = len(m.AvailabilityZone)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.ControlPlaneAuthPolicy != 0 {
		n += 1 + sovConfig(uint64(m.ControlPlaneAuthPolicy))
	}
	l = len(m.CustomConfigFile)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.StatNameLength != 0 {
		n += 1 + sovConfig(uint64(m.StatNameLength))
	}
	if m.Concurrency != 0 {
		n += 2 + sovConfig(uint64(m.Concurrency))
	}
	l = len(m.ProxyBootstrapTemplatePath)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.InterceptionMode != 0 {
		n += 2 + sovConfig(uint64(m.InterceptionMode))
	}
	return n
}

func (m *MeshConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.MixerCheckServer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.MixerReportServer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DisablePolicyChecks {
		n += 2
	}
	if m.ProxyListenPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyListenPort))
	}
	if m.ProxyHttpPort != 0 {
		n += 1 + sovConfig(uint64(m.ProxyHttpPort))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressClass)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.IngressService)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IngressControllerMode != 0 {
		n += 1 + sovConfig(uint64(m.IngressControllerMode))
	}
	if m.AuthPolicy != 0 {
		n += 1 + sovConfig(uint64(m.AuthPolicy))
	}
	if m.RdsRefreshDelay != nil {
		l = m.RdsRefreshDelay.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.EnableTracing {
		n += 2
	}
	l = len(m.AccessLogFile)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.DefaultConfig != nil {
		l = m.DefaultConfig.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.MixerAddress)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.OutboundTrafficPolicy != nil {
		l = m.OutboundTrafficPolicy.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.EnableClientSidePolicyCheck {
		n += 3
	}
	l = len(m.SdsUdsPath)
	if l > 0 {
		n += 2 + l + sovConfig(uint64(l))
	}
	if m.SdsRefreshDelay != nil {
		l = m.SdsRefreshDelay.Size()
		n += 2 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *MeshConfig_OutboundTrafficPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovConfig(uint64(m.Mode))
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ProxyConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConfigPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinaryPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinaryPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceCluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceCluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DrainDuration == nil {
				m.DrainDuration = &google_protobuf.Duration{}
			}
			if err := m.DrainDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentShutdownDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ParentShutdownDuration == nil {
				m.ParentShutdownDuration = &google_protobuf.Duration{}
			}
			if err := m.ParentShutdownDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DiscoveryAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscoveryRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DiscoveryRefreshDelay == nil {
				m.DiscoveryRefreshDelay = &google_protobuf.Duration{}
			}
			if err := m.DiscoveryRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZipkinAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ZipkinAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &google_protobuf.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsdUdpAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsdUdpAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyAdminPort", wireType)
			}
			m.ProxyAdminPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyAdminPort |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvailabilityZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AvailabilityZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ControlPlaneAuthPolicy", wireType)
			}
			m.ControlPlaneAuthPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ControlPlaneAuthPolicy |= (AuthenticationPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomConfigFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomConfigFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatNameLength", wireType)
			}
			m.StatNameLength = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StatNameLength |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Concurrency", wireType)
			}
			m.Concurrency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Concurrency |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyBootstrapTemplatePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyBootstrapTemplatePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InterceptionMode", wireType)
			}
			m.InterceptionMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InterceptionMode |= (ProxyConfig_InboundInterceptionMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MeshConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MeshConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerCheckServer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerCheckServer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerReportServer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerReportServer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisablePolicyChecks", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DisablePolicyChecks = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyListenPort", wireType)
			}
			m.ProxyListenPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyListenPort |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyHttpPort", wireType)
			}
			m.ProxyHttpPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProxyHttpPort |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &google_protobuf.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressService", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngressService = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngressControllerMode", wireType)
			}
			m.IngressControllerMode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IngressControllerMode |= (MeshConfig_IngressControllerMode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuthPolicy", wireType)
			}
			m.AuthPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AuthPolicy |= (MeshConfig_AuthPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RdsRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RdsRefreshDelay == nil {
				m.RdsRefreshDelay = &google_protobuf.Duration{}
			}
			if err := m.RdsRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTracing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTracing = bool(v != 0)
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogFile", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogFile = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultConfig == nil {
				m.DefaultConfig = &ProxyConfig{}
			}
			if err := m.DefaultConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MixerAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MixerAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutboundTrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutboundTrafficPolicy == nil {
				m.OutboundTrafficPolicy = &MeshConfig_OutboundTrafficPolicy{}
			}
			if err := m.OutboundTrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableClientSidePolicyCheck", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableClientSidePolicyCheck = bool(v != 0)
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsUdsPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SdsUdsPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsRefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SdsRefreshDelay == nil {
				m.SdsRefreshDelay = &google_protobuf.Duration{}
			}
			if err := m.SdsRefreshDelay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MeshConfig_OutboundTrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutboundTrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (MeshConfig_OutboundTrafficPolicy_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mesh/v1alpha1/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 1227 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0xc1, 0x6e, 0xdb, 0x46,
	0x13, 0x36, 0x1d, 0xc5, 0x96, 0x47, 0x96, 0x4c, 0xad, 0xe3, 0x98, 0xf1, 0x8f, 0xdf, 0x11, 0x1c,
	0x34, 0x75, 0xd3, 0x40, 0x46, 0x1c, 0x14, 0x68, 0x7b, 0x28, 0x2a, 0xcb, 0x72, 0xa2, 0x40, 0x91,
	0x5c, 0x8a, 0x4e, 0xeb, 0x5c, 0x16, 0x2b, 0x72, 0x65, 0x2d, 0x42, 0x71, 0x09, 0xee, 0xd2, 0x8d,
	0x72, 0xed, 0xe3, 0xf4, 0x1d, 0x7a, 0xee, 0xb1, 0x8f, 0x50, 0xe4, 0xd4, 0xc7, 0x28, 0x38, 0x4b,
	0xc9, 0x4a, 0xaa, 0x40, 0x68, 0x8f, 0xfa, 0xf6, 0x9b, 0x99, 0xdd, 0x99, 0xf9, 0x3e, 0x0a, 0xf6,
	0xc6, 0x5c, 0x8d, 0x8e, 0xae, 0x9f, 0xb0, 0x30, 0x1e, 0xb1, 0x27, 0x47, 0xbe, 0x8c, 0x86, 0xe2,
	0xaa, 0x1e, 0x27, 0x52, 0x4b, 0xb2, 0x2d, 0x94, 0x16, 0xb2, 0x9e, 0x31, 0xea, 0x53, 0xc6, 0xde,
	0xfe, 0x95, 0x94, 0x57, 0x21, 0x3f, 0x42, 0xca, 0x20, 0x1d, 0x1e, 0x05, 0x69, 0xc2, 0xb4, 0x90,
	0x91, 0x09, 0x3a, 0xf8, 0xad, 0x08, 0xa5, 0xf3, 0x44, 0xbe, 0x9d, 0x34, 0x31, 0x15, 0xb9, 0x0f,
	0x25, 0x93, 0x94, 0xc6, 0x4c, 0x8f, 0x1c, 0xab, 0x66, 0x1d, 0x6e, 0xb8, 0x60, 0xa0, 0x73, 0xa6,
	0x47, 0x19, 0x61, 0x20, 0x22, 0x96, 0x4c, 0x0c, 0x61, 0xd5, 0x10, 0x0c, 0x84, 0x84, 0xcf, 0x61,
	0x4b, 0xf1, 0xe4, 0x5a, 0xf8, 0x9c, 0xfa, 0x61, 0xaa, 0x34, 0x4f, 0x9c, 0x5b, 0x48, 0xaa, 0xe4,
	0x70, 0xd3, 0xa0, 0xe4, 0x7b, 0xa8, 0x04, 0x09, 0x13, 0x11, 0x9d, 0x5e, 0xc9, 0x29, 0xd4, 0xac,
	0xc3, 0xd2, 0xf1, 0xbd, 0xba, 0xb9, 0x73, 0x7d, 0x7a, 0xe7, 0xfa, 0x69, 0x4e, 0x70, 0xcb, 0x18,
	0x30, 0xfd, 0x49, 0xfa, 0xe0, 0xc4, 0x2c, 0xe1, 0x91, 0xa6, 0x6a, 0x94, 0xea, 0x40, 0xfe, 0x3c,
	0x97, 0xeb, 0xf6, 0xb2, 0x5c, 0x77, 0x4d, 0x68, 0x3f, 0x8f, 0x9c, 0x25, 0xfd, 0x12, 0xaa, 0x81,
	0x50, 0xbe, 0xbc, 0xe6, 0xc9, 0x84, 0xb2, 0x20, 0x48, 0xb8, 0x52, 0xce, 0x1a, 0xbe, 0xc0, 0x9e,
	0x1d, 0x34, 0x0c, 0x4e, 0x7e, 0x80, 0xdd, 0x1b, 0x72, 0xc2, 0x87, 0x09, 0x57, 0x23, 0x1a, 0xf0,
	0x90, 0x4d, 0x9c, 0xf5, 0x65, 0x17, 0xd8, 0x99, 0x45, 0xba, 0x26, 0xf0, 0x34, 0x8b, 0x23, 0x9f,
	0x41, 0xe5, 0x9d, 0x88, 0xdf, 0x88, 0x68, 0x56, 0xbc, 0x88, 0xc5, 0xcb, 0x06, 0x9d, 0x56, 0x3e,
	0x81, 0x2d, 0x5f, 0x46, 0x11, 0xf7, 0x35, 0xd5, 0x62, 0xcc, 0x65, 0xaa, 0x9d, 0x8d, 0x65, 0x15,
	0x2b, 0x79, 0x84, 0x67, 0x02, 0xc8, 0x63, 0x20, 0x4a, 0x33, 0xad, 0x02, 0x9a, 0x06, 0xf1, 0xac,
	0x1c, 0x98, 0xb7, 0x9a, 0x93, 0x8b, 0x20, 0x9e, 0x56, 0x3c, 0x04, 0x3b, 0xce, 0x36, 0x85, 0xb2,
	0x60, 0x2c, 0x22, 0x1a, 0xcb, 0x44, 0x3b, 0xa5, 0x9a, 0x75, 0x78, 0xdb, 0xad, 0x20, 0xde, 0xc8,
	0xe0, 0x73, 0x99, 0xe8, 0xac, 0x85, 0xec, 0x9a, 0x89, 0x90, 0x0d, 0x44, 0x28, 0xf4, 0x84, 0xbe,
	0x93, 0x11, 0x77, 0x36, 0x4d, 0xda, 0xf9, 0x83, 0xd7, 0x32, 0xe2, 0x24, 0x80, 0x7b, 0xbe, 0x8c,
	0x74, 0x22, 0x43, 0x1a, 0x87, 0x2c, 0xe2, 0x94, 0xa5, 0x7a, 0x44, 0x63, 0x19, 0x0a, 0x7f, 0xe2,
	0x94, 0x6b, 0xd6, 0x61, 0xe5, 0xf8, 0x8b, 0xfa, 0x82, 0xd5, 0xae, 0x37, 0x52, 0x3d, 0xe2, 0x91,
	0x16, 0x3e, 0x3e, 0xee, 0x1c, 0x03, 0xdc, 0xbb, 0x79, 0xae, 0xf3, 0x2c, 0x55, 0xc6, 0x30, 0x78,
	0xf6, 0x54, 0x3f, 0x55, 0x5a, 0x8e, 0x69, 0xbe, 0xde, 0x43, 0x11, 0x72, 0xa7, 0x62, 0xee, 0x64,
	0x4e, 0x8c, 0x02, 0xce, 0x44, 0xc8, 0xb3, 0xa7, 0x66, 0xcf, 0xa7, 0x11, 0x1b, 0x73, 0x1a, 0xf2,
	0xe8, 0x4a, 0x8f, 0x9c, 0x2d, 0xf3, 0xd4, 0x0c, 0xef, 0xb2, 0x31, 0xef, 0x20, 0x4a, 0x6a, 0xa8,
	0x17, 0x3f, 0x4d, 0x12, 0x1e, 0xf9, 0x13, 0xc7, 0x46, 0xd2, 0x3c, 0x44, 0x1a, 0xf0, 0x7f, 0xd3,
	0xb6, 0x81, 0x94, 0x5a, 0xe9, 0x84, 0xc5, 0x54, 0xf3, 0x71, 0x1c, 0x32, 0xcd, 0x8d, 0x84, 0xaa,
	0x78, 0x89, 0x3d, 0x24, 0x9d, 0x4c, 0x39, 0x5e, 0x4e, 0x41, 0x49, 0x71, 0xa8, 0x8a, 0x48, 0xf3,
	0xc4, 0xe7, 0x71, 0xf6, 0x54, 0x3a, 0x96, 0x01, 0x77, 0x08, 0xb6, 0xe6, 0xeb, 0x85, 0xad, 0x99,
	0x53, 0x74, 0xbd, 0x1d, 0x0d, 0x64, 0x1a, 0x05, 0xed, 0xb9, 0x04, 0x2f, 0x65, 0xc0, 0x5d, 0x5b,
	0x7c, 0x84, 0x1c, 0x3c, 0x85, 0xdd, 0x4f, 0x90, 0xc9, 0x26, 0x14, 0xdd, 0xd6, 0x69, 0xdb, 0x6d,
	0x35, 0x3d, 0x7b, 0x85, 0x00, 0xac, 0x79, 0xe7, 0x6e, 0xef, 0xa7, 0x4b, 0xdb, 0x3a, 0xf8, 0xa5,
	0x04, 0xf0, 0x92, 0xab, 0x51, 0xee, 0x1f, 0x8f, 0x81, 0x8c, 0xc5, 0x5b, 0x9e, 0x50, 0x7f, 0xc4,
	0xfd, 0x37, 0x34, 0x93, 0x3c, 0x4f, 0x72, 0x1b, 0xb1, 0xf1, 0xa4, 0x99, 0x1d, 0xf4, 0x11, 0x27,
	0x75, 0xd8, 0x36, 0xec, 0x84, 0x67, 0xeb, 0x34, 0xa5, 0x1b, 0x53, 0xa9, 0xe2, 0x91, 0x8b, 0x27,
	0x39, 0xff, 0x18, 0x32, 0xd1, 0xb0, 0x41, 0xc8, 0xf3, 0x05, 0x31, 0x65, 0x14, 0x3a, 0x4c, 0xd1,
	0xdd, 0xce, 0x0f, 0xcd, 0xcc, 0xb1, 0x90, 0x22, 0x8f, 0xa0, 0x6a, 0xfa, 0x1f, 0x0a, 0xa5, 0x79,
	0xbe, 0xb7, 0x05, 0x9c, 0xd3, 0x16, 0x1e, 0x74, 0x10, 0xc7, 0xc5, 0x7d, 0x08, 0x06, 0xa2, 0x23,
	0xad, 0x63, 0xc3, 0xbc, 0x8d, 0xcc, 0x32, 0xc2, 0xcf, 0xb5, 0x8e, 0x91, 0xb7, 0x40, 0x7c, 0x6b,
	0xff, 0x56, 0x7c, 0x0f, 0xa0, 0x2c, 0xa2, 0xab, 0x4c, 0x59, 0xd4, 0x0f, 0x99, 0x52, 0x68, 0x18,
	0x1b, 0xee, 0x66, 0x0e, 0x36, 0x33, 0x2c, 0x33, 0xd3, 0x29, 0x29, 0x77, 0xcf, 0xdc, 0x0d, 0x2a,
	0x39, 0xdc, 0x37, 0x28, 0x19, 0xc3, 0xee, 0x2c, 0x9b, 0x51, 0x40, 0xc8, 0x13, 0xb3, 0x28, 0x1b,
	0xb8, 0x28, 0x5f, 0x2d, 0x5c, 0x94, 0x9b, 0xc9, 0xd5, 0xdb, 0x79, 0xdd, 0x59, 0x34, 0x6e, 0xc9,
	0x8e, 0x58, 0x04, 0x93, 0x1e, 0x94, 0xe6, 0x65, 0x0a, 0x58, 0xe2, 0xd1, 0xb2, 0x12, 0x37, 0x7a,
	0x3c, 0x59, 0x75, 0x2c, 0x17, 0xd8, 0x8d, 0x3e, 0x5b, 0x50, 0x4d, 0x02, 0xf5, 0x91, 0x85, 0x96,
	0x96, 0xf5, 0x74, 0x2b, 0x09, 0xd4, 0xc7, 0xe6, 0xc9, 0x23, 0xdc, 0x0f, 0x9d, 0x30, 0x5f, 0x44,
	0x57, 0x68, 0x3b, 0x45, 0xb7, 0x6c, 0x50, 0xcf, 0x80, 0xd9, 0x9c, 0x99, 0xef, 0x67, 0xcd, 0x0a,
	0x65, 0x6e, 0x05, 0x65, 0x63, 0xb2, 0x06, 0xee, 0x48, 0xe3, 0x03, 0xcf, 0xa0, 0x12, 0xf0, 0x21,
	0x4b, 0x43, 0x9d, 0xdb, 0x06, 0x3a, 0x46, 0xe9, 0xb8, 0xb6, 0x4c, 0x75, 0x6e, 0x39, 0x8f, 0xcb,
	0x65, 0xf1, 0x00, 0xca, 0x66, 0xd1, 0xa7, 0x26, 0x6b, 0x9b, 0x61, 0x23, 0x38, 0x35, 0xd8, 0x31,
	0xec, 0xca, 0x54, 0xa3, 0x00, 0xb3, 0xeb, 0x0f, 0x87, 0xc2, 0x9f, 0x36, 0xb8, 0x8a, 0x65, 0x97,
	0xce, 0xb0, 0x97, 0x87, 0x7b, 0x26, 0x3a, 0xf7, 0xc4, 0x1d, 0xb9, 0x08, 0x26, 0xa7, 0x70, 0x3f,
	0xef, 0x95, 0x1f, 0x0a, 0xfc, 0x88, 0x8a, 0xe0, 0x43, 0x5d, 0x39, 0xdb, 0xd8, 0xbc, 0xff, 0x19,
	0x5a, 0x13, 0x59, 0x7d, 0x11, 0xcc, 0xeb, 0x8b, 0xd4, 0x60, 0x53, 0x05, 0x8a, 0xa6, 0x81, 0x32,
	0x6e, 0x76, 0xc7, 0xfc, 0x21, 0x50, 0x81, 0xba, 0x08, 0x14, 0xba, 0x57, 0x0b, 0xaa, 0xea, 0x1f,
	0xa3, 0xdd, 0x59, 0x3a, 0x5a, 0xf5, 0xe1, 0x68, 0xf7, 0x7e, 0xb5, 0x60, 0x67, 0xe1, 0xfb, 0x48,
	0x17, 0x0a, 0xb8, 0xe8, 0x16, 0x6e, 0xe1, 0xb7, 0xff, 0xa9, 0x49, 0x75, 0xdc, 0x76, 0xcc, 0x73,
	0x70, 0x02, 0x05, 0x5c, 0xf2, 0x2a, 0x94, 0xdd, 0xd6, 0xb3, 0x76, 0xdf, 0x73, 0x2f, 0x69, 0xaf,
	0xdb, 0xb9, 0xb4, 0x57, 0x48, 0x19, 0x36, 0x1a, 0x9d, 0x4e, 0xef, 0x47, 0xda, 0xe8, 0x5e, 0xda,
	0x16, 0x71, 0xe0, 0xce, 0xab, 0xb6, 0xeb, 0x5d, 0x34, 0x3a, 0xb4, 0xdf, 0x72, 0x5f, 0xb5, 0x9b,
	0x2d, 0x43, 0x5c, 0x3d, 0xf8, 0x06, 0x76, 0x16, 0x0a, 0x8a, 0xac, 0xc3, 0xad, 0xde, 0xd9, 0x99,
	0xbd, 0x42, 0x4a, 0xb0, 0x7e, 0xda, 0x3a, 0x6b, 0x5c, 0x74, 0x3c, 0xdb, 0xca, 0x1c, 0xb5, 0xef,
	0xb9, 0xed, 0xa6, 0x67, 0xaf, 0x1e, 0x3c, 0x04, 0x98, 0xfb, 0x70, 0x15, 0xa1, 0xd0, 0xed, 0x75,
	0x5b, 0xf6, 0x0a, 0xa9, 0x00, 0xbc, 0xbc, 0xc0, 0x5a, 0x5e, 0xa7, 0x6f, 0x5b, 0x2f, 0x0a, 0xc5,
	0x2d, 0xdb, 0x7e, 0x51, 0x28, 0x12, 0x7b, 0xfb, 0xd1, 0x77, 0x70, 0x67, 0xd1, 0xe7, 0xf0, 0xd3,
	0xd1, 0x64, 0x13, 0xd6, 0xdb, 0xdd, 0xe7, 0x2d, 0xb7, 0xed, 0xd9, 0x7f, 0xad, 0x9f, 0x1c, 0xfe,
	0xfe, 0x7e, 0xdf, 0xfa, 0xe3, 0xfd, 0xbe, 0xf5, 0xe7, 0xfb, 0x7d, 0xeb, 0xf5, 0x9e, 0xe9, 0xa0,
	0x90, 0x47, 0x2c, 0x16, 0x47, 0x1f, 0xfc, 0xe5, 0x1c, 0xac, 0xe1, 0xa8, 0x9e, 0xfe, 0x1d, 0x00,
	0x00, 0xff, 0xff, 0x45, 0x30, 0x41, 0xa7, 0x8a, 0x0a, 0x00, 0x00,
}
