// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/bootstrap/v2/bootstrap.proto

package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import v23 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
import auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
import core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import v2 "github.com/envoyproxy/go-control-plane/envoy/config/metrics/v2"
import v2alpha "github.com/envoyproxy/go-control-plane/envoy/config/overload/v2alpha"
import v22 "github.com/envoyproxy/go-control-plane/envoy/config/ratelimit/v2"
import v21 "github.com/envoyproxy/go-control-plane/envoy/config/trace/v2"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import time "time"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Bootstrap :ref:`configuration overview <config_overview_v2_bootstrap>`.
type Bootstrap struct {
	// Node identity to present to the management server and for instance
	// identification purposes (e.g. in generated headers).
	Node *core.Node `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
	// Statically specified resources.
	StaticResources *Bootstrap_StaticResources `protobuf:"bytes,2,opt,name=static_resources,json=staticResources" json:"static_resources,omitempty"`
	// xDS configuration sources.
	DynamicResources *Bootstrap_DynamicResources `protobuf:"bytes,3,opt,name=dynamic_resources,json=dynamicResources" json:"dynamic_resources,omitempty"`
	// Configuration for the cluster manager which owns all upstream clusters
	// within the server.
	ClusterManager *ClusterManager `protobuf:"bytes,4,opt,name=cluster_manager,json=clusterManager" json:"cluster_manager,omitempty"`
	// Health discovery service config option.
	// (:ref:`core.ApiConfigSource <envoy_api_msg_core.ApiConfigSource>`)
	HdsConfig *core.ApiConfigSource `protobuf:"bytes,14,opt,name=hds_config,json=hdsConfig" json:"hds_config,omitempty"`
	// Optional file system path to search for startup flag files.
	FlagsPath string `protobuf:"bytes,5,opt,name=flags_path,json=flagsPath,proto3" json:"flags_path,omitempty"`
	// Optional set of stats sinks.
	StatsSinks []*v2.StatsSink `protobuf:"bytes,6,rep,name=stats_sinks,json=statsSinks" json:"stats_sinks,omitempty"`
	// Configuration for internal processing of stats.
	StatsConfig *v2.StatsConfig `protobuf:"bytes,13,opt,name=stats_config,json=statsConfig" json:"stats_config,omitempty"`
	// Optional duration between flushes to configured stats sinks. For
	// performance reasons Envoy latches counters and only flushes counters and
	// gauges at a periodic interval. If not specified the default is 5000ms (5
	// seconds).
	StatsFlushInterval *time.Duration `protobuf:"bytes,7,opt,name=stats_flush_interval,json=statsFlushInterval,stdduration" json:"stats_flush_interval,omitempty"`
	// Optional watchdog configuration.
	Watchdog *Watchdog `protobuf:"bytes,8,opt,name=watchdog" json:"watchdog,omitempty"`
	// Configuration for an external tracing provider. If not specified, no
	// tracing will be performed.
	Tracing *v21.Tracing `protobuf:"bytes,9,opt,name=tracing" json:"tracing,omitempty"`
	// Configuration for an external rate limit service provider. If not
	// specified, any calls to the rate limit service will immediately return
	// success.
	RateLimitService *v22.RateLimitServiceConfig `protobuf:"bytes,10,opt,name=rate_limit_service,json=rateLimitService" json:"rate_limit_service,omitempty"`
	// Configuration for the runtime configuration provider. If not specified, a
	// “null” provider will be used which will result in all defaults being used.
	Runtime *Runtime `protobuf:"bytes,11,opt,name=runtime" json:"runtime,omitempty"`
	// Configuration for the local administration HTTP server.
	Admin Admin `protobuf:"bytes,12,opt,name=admin" json:"admin"`
	// Optional overload manager configuration.
	OverloadManager      *v2alpha.OverloadManager `protobuf:"bytes,15,opt,name=overload_manager,json=overloadManager" json:"overload_manager,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Bootstrap) Reset()         { *m = Bootstrap{} }
func (m *Bootstrap) String() string { return proto.CompactTextString(m) }
func (*Bootstrap) ProtoMessage()    {}
func (*Bootstrap) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{0}
}
func (m *Bootstrap) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bootstrap) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap.Merge(dst, src)
}
func (m *Bootstrap) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap proto.InternalMessageInfo

func (m *Bootstrap) GetNode() *core.Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *Bootstrap) GetStaticResources() *Bootstrap_StaticResources {
	if m != nil {
		return m.StaticResources
	}
	return nil
}

func (m *Bootstrap) GetDynamicResources() *Bootstrap_DynamicResources {
	if m != nil {
		return m.DynamicResources
	}
	return nil
}

func (m *Bootstrap) GetClusterManager() *ClusterManager {
	if m != nil {
		return m.ClusterManager
	}
	return nil
}

func (m *Bootstrap) GetHdsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.HdsConfig
	}
	return nil
}

func (m *Bootstrap) GetFlagsPath() string {
	if m != nil {
		return m.FlagsPath
	}
	return ""
}

func (m *Bootstrap) GetStatsSinks() []*v2.StatsSink {
	if m != nil {
		return m.StatsSinks
	}
	return nil
}

func (m *Bootstrap) GetStatsConfig() *v2.StatsConfig {
	if m != nil {
		return m.StatsConfig
	}
	return nil
}

func (m *Bootstrap) GetStatsFlushInterval() *time.Duration {
	if m != nil {
		return m.StatsFlushInterval
	}
	return nil
}

func (m *Bootstrap) GetWatchdog() *Watchdog {
	if m != nil {
		return m.Watchdog
	}
	return nil
}

func (m *Bootstrap) GetTracing() *v21.Tracing {
	if m != nil {
		return m.Tracing
	}
	return nil
}

func (m *Bootstrap) GetRateLimitService() *v22.RateLimitServiceConfig {
	if m != nil {
		return m.RateLimitService
	}
	return nil
}

func (m *Bootstrap) GetRuntime() *Runtime {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *Bootstrap) GetAdmin() Admin {
	if m != nil {
		return m.Admin
	}
	return Admin{}
}

func (m *Bootstrap) GetOverloadManager() *v2alpha.OverloadManager {
	if m != nil {
		return m.OverloadManager
	}
	return nil
}

type Bootstrap_StaticResources struct {
	// Static :ref:`Listeners <envoy_api_msg_Listener>`. These listeners are
	// available regardless of LDS configuration.
	Listeners []v23.Listener `protobuf:"bytes,1,rep,name=listeners" json:"listeners"`
	// If a network based configuration source is specified for :ref:`cds_config
	// <envoy_api_field_config.bootstrap.v2.Bootstrap.DynamicResources.cds_config>`, it's necessary
	// to have some initial cluster definitions available to allow Envoy to know
	// how to speak to the management server. These cluster definitions may not
	// use :ref:`EDS <arch_overview_dynamic_config_sds>` (i.e. they should be static
	// IP or DNS-based).
	Clusters []v23.Cluster `protobuf:"bytes,2,rep,name=clusters" json:"clusters"`
	// [#not-implemented-hide:]
	Secrets              []auth.Secret `protobuf:"bytes,3,rep,name=secrets" json:"secrets"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Bootstrap_StaticResources) Reset()         { *m = Bootstrap_StaticResources{} }
func (m *Bootstrap_StaticResources) String() string { return proto.CompactTextString(m) }
func (*Bootstrap_StaticResources) ProtoMessage()    {}
func (*Bootstrap_StaticResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{0, 0}
}
func (m *Bootstrap_StaticResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap_StaticResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap_StaticResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bootstrap_StaticResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap_StaticResources.Merge(dst, src)
}
func (m *Bootstrap_StaticResources) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap_StaticResources) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap_StaticResources.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap_StaticResources proto.InternalMessageInfo

func (m *Bootstrap_StaticResources) GetListeners() []v23.Listener {
	if m != nil {
		return m.Listeners
	}
	return nil
}

func (m *Bootstrap_StaticResources) GetClusters() []v23.Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *Bootstrap_StaticResources) GetSecrets() []auth.Secret {
	if m != nil {
		return m.Secrets
	}
	return nil
}

type Bootstrap_DynamicResources struct {
	// All :ref:`Listeners <envoy_api_msg_Listener>` are provided by a single
	// :ref:`LDS <arch_overview_dynamic_config_lds>` configuration source.
	LdsConfig *core.ConfigSource `protobuf:"bytes,1,opt,name=lds_config,json=ldsConfig" json:"lds_config,omitempty"`
	// All post-bootstrap :ref:`Cluster <envoy_api_msg_Cluster>` definitions are
	// provided by a single :ref:`CDS <arch_overview_dynamic_config_cds>`
	// configuration source.
	CdsConfig *core.ConfigSource `protobuf:"bytes,2,opt,name=cds_config,json=cdsConfig" json:"cds_config,omitempty"`
	// A single :ref:`ADS <config_overview_v2_ads>` source may be optionally
	// specified. This must have :ref:`api_type
	// <envoy_api_field_core.ApiConfigSource.api_type>` :ref:`GRPC
	// <envoy_api_enum_value_core.ApiConfigSource.ApiType.GRPC>`. Only
	// :ref:`ConfigSources <envoy_api_msg_core.ConfigSource>` that have
	// the :ref:`ads <envoy_api_field_core.ConfigSource.ads>` field set will be
	// streamed on the ADS channel.
	AdsConfig *core.ApiConfigSource `protobuf:"bytes,3,opt,name=ads_config,json=adsConfig" json:"ads_config,omitempty"`
	// [#not-implemented-hide:] Hide from docs.
	DeprecatedV1         *Bootstrap_DynamicResources_DeprecatedV1 `protobuf:"bytes,4,opt,name=deprecated_v1,json=deprecatedV1" json:"deprecated_v1,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}                                 `json:"-"`
	XXX_unrecognized     []byte                                   `json:"-"`
	XXX_sizecache        int32                                    `json:"-"`
}

func (m *Bootstrap_DynamicResources) Reset()         { *m = Bootstrap_DynamicResources{} }
func (m *Bootstrap_DynamicResources) String() string { return proto.CompactTextString(m) }
func (*Bootstrap_DynamicResources) ProtoMessage()    {}
func (*Bootstrap_DynamicResources) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{0, 1}
}
func (m *Bootstrap_DynamicResources) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap_DynamicResources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap_DynamicResources.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bootstrap_DynamicResources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap_DynamicResources.Merge(dst, src)
}
func (m *Bootstrap_DynamicResources) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap_DynamicResources) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap_DynamicResources.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap_DynamicResources proto.InternalMessageInfo

func (m *Bootstrap_DynamicResources) GetLdsConfig() *core.ConfigSource {
	if m != nil {
		return m.LdsConfig
	}
	return nil
}

func (m *Bootstrap_DynamicResources) GetCdsConfig() *core.ConfigSource {
	if m != nil {
		return m.CdsConfig
	}
	return nil
}

func (m *Bootstrap_DynamicResources) GetAdsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.AdsConfig
	}
	return nil
}

// Deprecated: Do not use.
func (m *Bootstrap_DynamicResources) GetDeprecatedV1() *Bootstrap_DynamicResources_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

// [#not-implemented-hide:] Hide from docs.
type Bootstrap_DynamicResources_DeprecatedV1 struct {
	// This is the global :ref:`SDS <arch_overview_dynamic_config_sds>` config
	// when using v1 REST for :ref:`CDS
	// <arch_overview_dynamic_config_cds>`/:ref:`EDS
	// <arch_overview_dynamic_config_sds>`.
	SdsConfig            *core.ConfigSource `protobuf:"bytes,1,opt,name=sds_config,json=sdsConfig" json:"sds_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Bootstrap_DynamicResources_DeprecatedV1) Reset() {
	*m = Bootstrap_DynamicResources_DeprecatedV1{}
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*Bootstrap_DynamicResources_DeprecatedV1) ProtoMessage()    {}
func (*Bootstrap_DynamicResources_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{0, 1, 0}
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Bootstrap_DynamicResources_DeprecatedV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Bootstrap_DynamicResources_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Bootstrap_DynamicResources_DeprecatedV1.Merge(dst, src)
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_Bootstrap_DynamicResources_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_Bootstrap_DynamicResources_DeprecatedV1 proto.InternalMessageInfo

func (m *Bootstrap_DynamicResources_DeprecatedV1) GetSdsConfig() *core.ConfigSource {
	if m != nil {
		return m.SdsConfig
	}
	return nil
}

// Administration interface :ref:`operations documentation
// <operations_admin_interface>`.
type Admin struct {
	// The path to write the access log for the administration server. If no
	// access log is desired specify ‘/dev/null’.
	AccessLogPath string `protobuf:"bytes,1,opt,name=access_log_path,json=accessLogPath,proto3" json:"access_log_path,omitempty"`
	// The cpu profiler output path for the administration server. If no profile
	// path is specified, the default is ‘/var/log/envoy/envoy.prof’.
	ProfilePath string `protobuf:"bytes,2,opt,name=profile_path,json=profilePath,proto3" json:"profile_path,omitempty"`
	// The TCP address that the administration server will listen on.
	Address              core.Address `protobuf:"bytes,3,opt,name=address" json:"address"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *Admin) Reset()         { *m = Admin{} }
func (m *Admin) String() string { return proto.CompactTextString(m) }
func (*Admin) ProtoMessage()    {}
func (*Admin) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{1}
}
func (m *Admin) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Admin) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Admin.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Admin) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Admin.Merge(dst, src)
}
func (m *Admin) XXX_Size() int {
	return m.Size()
}
func (m *Admin) XXX_DiscardUnknown() {
	xxx_messageInfo_Admin.DiscardUnknown(m)
}

var xxx_messageInfo_Admin proto.InternalMessageInfo

func (m *Admin) GetAccessLogPath() string {
	if m != nil {
		return m.AccessLogPath
	}
	return ""
}

func (m *Admin) GetProfilePath() string {
	if m != nil {
		return m.ProfilePath
	}
	return ""
}

func (m *Admin) GetAddress() core.Address {
	if m != nil {
		return m.Address
	}
	return core.Address{}
}

// Cluster manager :ref:`architecture overview <arch_overview_cluster_manager>`.
type ClusterManager struct {
	// Name of the local cluster (i.e., the cluster that owns the Envoy running
	// this configuration). In order to enable :ref:`zone aware routing
	// <arch_overview_load_balancing_zone_aware_routing>` this option must be set.
	// If *local_cluster_name* is defined then :ref:`clusters
	// <config_cluster_manager_clusters>` must be defined in the :ref:`Bootstrap
	// static cluster resources
	// <envoy_api_field_config.bootstrap.v2.Bootstrap.StaticResources.clusters>`. This is unrelated to
	// the :option:`--service-cluster` option which does not `affect zone aware
	// routing <https://github.com/envoyproxy/envoy/issues/774>`_.
	LocalClusterName string `protobuf:"bytes,1,opt,name=local_cluster_name,json=localClusterName,proto3" json:"local_cluster_name,omitempty"`
	// Optional global configuration for outlier detection.
	OutlierDetection *ClusterManager_OutlierDetection `protobuf:"bytes,2,opt,name=outlier_detection,json=outlierDetection" json:"outlier_detection,omitempty"`
	// Optional configuration used to bind newly established upstream connections.
	// This may be overridden on a per-cluster basis by upstream_bind_config in the cds_config.
	UpstreamBindConfig *core.BindConfig `protobuf:"bytes,3,opt,name=upstream_bind_config,json=upstreamBindConfig" json:"upstream_bind_config,omitempty"`
	// A management server endpoint to stream load stats to via
	// *StreamLoadStats*. This must have :ref:`api_type
	// <envoy_api_field_core.ApiConfigSource.api_type>` :ref:`GRPC
	// <envoy_api_enum_value_core.ApiConfigSource.ApiType.GRPC>`.
	LoadStatsConfig      *core.ApiConfigSource `protobuf:"bytes,4,opt,name=load_stats_config,json=loadStatsConfig" json:"load_stats_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *ClusterManager) Reset()         { *m = ClusterManager{} }
func (m *ClusterManager) String() string { return proto.CompactTextString(m) }
func (*ClusterManager) ProtoMessage()    {}
func (*ClusterManager) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{2}
}
func (m *ClusterManager) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterManager) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterManager.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterManager) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterManager.Merge(dst, src)
}
func (m *ClusterManager) XXX_Size() int {
	return m.Size()
}
func (m *ClusterManager) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterManager.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterManager proto.InternalMessageInfo

func (m *ClusterManager) GetLocalClusterName() string {
	if m != nil {
		return m.LocalClusterName
	}
	return ""
}

func (m *ClusterManager) GetOutlierDetection() *ClusterManager_OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *ClusterManager) GetUpstreamBindConfig() *core.BindConfig {
	if m != nil {
		return m.UpstreamBindConfig
	}
	return nil
}

func (m *ClusterManager) GetLoadStatsConfig() *core.ApiConfigSource {
	if m != nil {
		return m.LoadStatsConfig
	}
	return nil
}

type ClusterManager_OutlierDetection struct {
	// Specifies the path to the outlier event log.
	EventLogPath         string   `protobuf:"bytes,1,opt,name=event_log_path,json=eventLogPath,proto3" json:"event_log_path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ClusterManager_OutlierDetection) Reset()         { *m = ClusterManager_OutlierDetection{} }
func (m *ClusterManager_OutlierDetection) String() string { return proto.CompactTextString(m) }
func (*ClusterManager_OutlierDetection) ProtoMessage()    {}
func (*ClusterManager_OutlierDetection) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{2, 0}
}
func (m *ClusterManager_OutlierDetection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ClusterManager_OutlierDetection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ClusterManager_OutlierDetection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *ClusterManager_OutlierDetection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ClusterManager_OutlierDetection.Merge(dst, src)
}
func (m *ClusterManager_OutlierDetection) XXX_Size() int {
	return m.Size()
}
func (m *ClusterManager_OutlierDetection) XXX_DiscardUnknown() {
	xxx_messageInfo_ClusterManager_OutlierDetection.DiscardUnknown(m)
}

var xxx_messageInfo_ClusterManager_OutlierDetection proto.InternalMessageInfo

func (m *ClusterManager_OutlierDetection) GetEventLogPath() string {
	if m != nil {
		return m.EventLogPath
	}
	return ""
}

// Envoy process watchdog configuration. When configured, this monitors for
// nonresponsive threads and kills the process after the configured thresholds.
type Watchdog struct {
	// The duration after which Envoy counts a nonresponsive thread in the
	// *server.watchdog_miss* statistic. If not specified the default is 200ms.
	MissTimeout *types.Duration `protobuf:"bytes,1,opt,name=miss_timeout,json=missTimeout" json:"miss_timeout,omitempty"`
	// The duration after which Envoy counts a nonresponsive thread in the
	// *server.watchdog_mega_miss* statistic. If not specified the default is
	// 1000ms.
	MegamissTimeout *types.Duration `protobuf:"bytes,2,opt,name=megamiss_timeout,json=megamissTimeout" json:"megamiss_timeout,omitempty"`
	// If a watched thread has been nonresponsive for this duration, assume a
	// programming error and kill the entire Envoy process. Set to 0 to disable
	// kill behavior. If not specified the default is 0 (disabled).
	KillTimeout *types.Duration `protobuf:"bytes,3,opt,name=kill_timeout,json=killTimeout" json:"kill_timeout,omitempty"`
	// If at least two watched threads have been nonresponsive for at least this
	// duration assume a true deadlock and kill the entire Envoy process. Set to 0
	// to disable this behavior. If not specified the default is 0 (disabled).
	MultikillTimeout     *types.Duration `protobuf:"bytes,4,opt,name=multikill_timeout,json=multikillTimeout" json:"multikill_timeout,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Watchdog) Reset()         { *m = Watchdog{} }
func (m *Watchdog) String() string { return proto.CompactTextString(m) }
func (*Watchdog) ProtoMessage()    {}
func (*Watchdog) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{3}
}
func (m *Watchdog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Watchdog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Watchdog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Watchdog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Watchdog.Merge(dst, src)
}
func (m *Watchdog) XXX_Size() int {
	return m.Size()
}
func (m *Watchdog) XXX_DiscardUnknown() {
	xxx_messageInfo_Watchdog.DiscardUnknown(m)
}

var xxx_messageInfo_Watchdog proto.InternalMessageInfo

func (m *Watchdog) GetMissTimeout() *types.Duration {
	if m != nil {
		return m.MissTimeout
	}
	return nil
}

func (m *Watchdog) GetMegamissTimeout() *types.Duration {
	if m != nil {
		return m.MegamissTimeout
	}
	return nil
}

func (m *Watchdog) GetKillTimeout() *types.Duration {
	if m != nil {
		return m.KillTimeout
	}
	return nil
}

func (m *Watchdog) GetMultikillTimeout() *types.Duration {
	if m != nil {
		return m.MultikillTimeout
	}
	return nil
}

// Runtime :ref:`configuration overview <config_runtime>`.
type Runtime struct {
	// The implementation assumes that the file system tree is accessed via a
	// symbolic link. An atomic link swap is used when a new tree should be
	// switched to. This parameter specifies the path to the symbolic link. Envoy
	// will watch the location for changes and reload the file system tree when
	// they happen.
	SymlinkRoot string `protobuf:"bytes,1,opt,name=symlink_root,json=symlinkRoot,proto3" json:"symlink_root,omitempty"`
	// Specifies the subdirectory to load within the root directory. This is
	// useful if multiple systems share the same delivery mechanism. Envoy
	// configuration elements can be contained in a dedicated subdirectory.
	Subdirectory string `protobuf:"bytes,2,opt,name=subdirectory,proto3" json:"subdirectory,omitempty"`
	// Specifies an optional subdirectory to load within the root directory. If
	// specified and the directory exists, configuration values within this
	// directory will override those found in the primary subdirectory. This is
	// useful when Envoy is deployed across many different types of servers.
	// Sometimes it is useful to have a per service cluster directory for runtime
	// configuration. See below for exactly how the override directory is used.
	OverrideSubdirectory string   `protobuf:"bytes,3,opt,name=override_subdirectory,json=overrideSubdirectory,proto3" json:"override_subdirectory,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Runtime) Reset()         { *m = Runtime{} }
func (m *Runtime) String() string { return proto.CompactTextString(m) }
func (*Runtime) ProtoMessage()    {}
func (*Runtime) Descriptor() ([]byte, []int) {
	return fileDescriptor_bootstrap_afd983df223cd175, []int{4}
}
func (m *Runtime) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Runtime) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Runtime.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Runtime) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Runtime.Merge(dst, src)
}
func (m *Runtime) XXX_Size() int {
	return m.Size()
}
func (m *Runtime) XXX_DiscardUnknown() {
	xxx_messageInfo_Runtime.DiscardUnknown(m)
}

var xxx_messageInfo_Runtime proto.InternalMessageInfo

func (m *Runtime) GetSymlinkRoot() string {
	if m != nil {
		return m.SymlinkRoot
	}
	return ""
}

func (m *Runtime) GetSubdirectory() string {
	if m != nil {
		return m.Subdirectory
	}
	return ""
}

func (m *Runtime) GetOverrideSubdirectory() string {
	if m != nil {
		return m.OverrideSubdirectory
	}
	return ""
}

func init() {
	proto.RegisterType((*Bootstrap)(nil), "envoy.config.bootstrap.v2.Bootstrap")
	proto.RegisterType((*Bootstrap_StaticResources)(nil), "envoy.config.bootstrap.v2.Bootstrap.StaticResources")
	proto.RegisterType((*Bootstrap_DynamicResources)(nil), "envoy.config.bootstrap.v2.Bootstrap.DynamicResources")
	proto.RegisterType((*Bootstrap_DynamicResources_DeprecatedV1)(nil), "envoy.config.bootstrap.v2.Bootstrap.DynamicResources.DeprecatedV1")
	proto.RegisterType((*Admin)(nil), "envoy.config.bootstrap.v2.Admin")
	proto.RegisterType((*ClusterManager)(nil), "envoy.config.bootstrap.v2.ClusterManager")
	proto.RegisterType((*ClusterManager_OutlierDetection)(nil), "envoy.config.bootstrap.v2.ClusterManager.OutlierDetection")
	proto.RegisterType((*Watchdog)(nil), "envoy.config.bootstrap.v2.Watchdog")
	proto.RegisterType((*Runtime)(nil), "envoy.config.bootstrap.v2.Runtime")
}
func (m *Bootstrap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Node.Size()))
		n1, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.StaticResources != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.StaticResources.Size()))
		n2, err := m.StaticResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DynamicResources != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.DynamicResources.Size()))
		n3, err := m.DynamicResources.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ClusterManager != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.ClusterManager.Size()))
		n4, err := m.ClusterManager.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.FlagsPath) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.FlagsPath)))
		i += copy(dAtA[i:], m.FlagsPath)
	}
	if len(m.StatsSinks) > 0 {
		for _, msg := range m.StatsSinks {
			dAtA[i] = 0x32
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.StatsFlushInterval != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StatsFlushInterval)))
		n5, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.StatsFlushInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.Watchdog != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Watchdog.Size()))
		n6, err := m.Watchdog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Tracing != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Tracing.Size()))
		n7, err := m.Tracing.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.RateLimitService != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.RateLimitService.Size()))
		n8, err := m.RateLimitService.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Runtime != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.Runtime.Size()))
		n9, err := m.Runtime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	dAtA[i] = 0x62
	i++
	i = encodeVarintBootstrap(dAtA, i, uint64(m.Admin.Size()))
	n10, err := m.Admin.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	if m.StatsConfig != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.StatsConfig.Size()))
		n11, err := m.StatsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.HdsConfig != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.HdsConfig.Size()))
		n12, err := m.HdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.OverloadManager != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.OverloadManager.Size()))
		n13, err := m.OverloadManager.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bootstrap_StaticResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap_StaticResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Listeners) > 0 {
		for _, msg := range m.Listeners {
			dAtA[i] = 0xa
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Clusters) > 0 {
		for _, msg := range m.Clusters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Secrets) > 0 {
		for _, msg := range m.Secrets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBootstrap(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bootstrap_DynamicResources) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap_DynamicResources) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.LdsConfig.Size()))
		n14, err := m.LdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.CdsConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.CdsConfig.Size()))
		n15, err := m.CdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.AdsConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.AdsConfig.Size()))
		n16, err := m.AdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n17, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Bootstrap_DynamicResources_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Bootstrap_DynamicResources_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.SdsConfig.Size()))
		n18, err := m.SdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Admin) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Admin) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AccessLogPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.AccessLogPath)))
		i += copy(dAtA[i:], m.AccessLogPath)
	}
	if len(m.ProfilePath) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.ProfilePath)))
		i += copy(dAtA[i:], m.ProfilePath)
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintBootstrap(dAtA, i, uint64(m.Address.Size()))
	n19, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterManager) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterManager) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LocalClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.LocalClusterName)))
		i += copy(dAtA[i:], m.LocalClusterName)
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.OutlierDetection.Size()))
		n20, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.UpstreamBindConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.UpstreamBindConfig.Size()))
		n21, err := m.UpstreamBindConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.LoadStatsConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.LoadStatsConfig.Size()))
		n22, err := m.LoadStatsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *ClusterManager_OutlierDetection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterManager_OutlierDetection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.EventLogPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.EventLogPath)))
		i += copy(dAtA[i:], m.EventLogPath)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Watchdog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Watchdog) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MissTimeout != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MissTimeout.Size()))
		n23, err := m.MissTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.MegamissTimeout != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MegamissTimeout.Size()))
		n24, err := m.MegamissTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.KillTimeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.KillTimeout.Size()))
		n25, err := m.KillTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.MultikillTimeout != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(m.MultikillTimeout.Size()))
		n26, err := m.MultikillTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Runtime) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Runtime) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SymlinkRoot) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.SymlinkRoot)))
		i += copy(dAtA[i:], m.SymlinkRoot)
	}
	if len(m.Subdirectory) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.Subdirectory)))
		i += copy(dAtA[i:], m.Subdirectory)
	}
	if len(m.OverrideSubdirectory) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBootstrap(dAtA, i, uint64(len(m.OverrideSubdirectory)))
		i += copy(dAtA[i:], m.OverrideSubdirectory)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintBootstrap(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Bootstrap) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.StaticResources != nil {
		l = m.StaticResources.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.DynamicResources != nil {
		l = m.DynamicResources.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.ClusterManager != nil {
		l = m.ClusterManager.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.FlagsPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if len(m.StatsSinks) > 0 {
		for _, e := range m.StatsSinks {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.StatsFlushInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.StatsFlushInterval)
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Watchdog != nil {
		l = m.Watchdog.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Tracing != nil {
		l = m.Tracing.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.RateLimitService != nil {
		l = m.RateLimitService.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.Runtime != nil {
		l = m.Runtime.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = m.Admin.Size()
	n += 1 + l + sovBootstrap(uint64(l))
	if m.StatsConfig != nil {
		l = m.StatsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.HdsConfig != nil {
		l = m.HdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.OverloadManager != nil {
		l = m.OverloadManager.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bootstrap_StaticResources) Size() (n int) {
	var l int
	_ = l
	if len(m.Listeners) > 0 {
		for _, e := range m.Listeners {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 1 + l + sovBootstrap(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bootstrap_DynamicResources) Size() (n int) {
	var l int
	_ = l
	if m.LdsConfig != nil {
		l = m.LdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.CdsConfig != nil {
		l = m.CdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.AdsConfig != nil {
		l = m.AdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Bootstrap_DynamicResources_DeprecatedV1) Size() (n int) {
	var l int
	_ = l
	if m.SdsConfig != nil {
		l = m.SdsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Admin) Size() (n int) {
	var l int
	_ = l
	l = len(m.AccessLogPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.ProfilePath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = m.Address.Size()
	n += 1 + l + sovBootstrap(uint64(l))
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterManager) Size() (n int) {
	var l int
	_ = l
	l = len(m.LocalClusterName)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.UpstreamBindConfig != nil {
		l = m.UpstreamBindConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.LoadStatsConfig != nil {
		l = m.LoadStatsConfig.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ClusterManager_OutlierDetection) Size() (n int) {
	var l int
	_ = l
	l = len(m.EventLogPath)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Watchdog) Size() (n int) {
	var l int
	_ = l
	if m.MissTimeout != nil {
		l = m.MissTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.MegamissTimeout != nil {
		l = m.MegamissTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.KillTimeout != nil {
		l = m.KillTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.MultikillTimeout != nil {
		l = m.MultikillTimeout.Size()
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Runtime) Size() (n int) {
	var l int
	_ = l
	l = len(m.SymlinkRoot)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.Subdirectory)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	l = len(m.OverrideSubdirectory)
	if l > 0 {
		n += 1 + l + sovBootstrap(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovBootstrap(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBootstrap(x uint64) (n int) {
	return sovBootstrap(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Bootstrap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Bootstrap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Bootstrap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &core.Node{}
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StaticResources == nil {
				m.StaticResources = &Bootstrap_StaticResources{}
			}
			if err := m.StaticResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicResources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DynamicResources == nil {
				m.DynamicResources = &Bootstrap_DynamicResources{}
			}
			if err := m.DynamicResources.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterManager", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ClusterManager == nil {
				m.ClusterManager = &ClusterManager{}
			}
			if err := m.ClusterManager.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlagsPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FlagsPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsSinks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsSinks = append(m.StatsSinks, &v2.StatsSink{})
			if err := m.StatsSinks[len(m.StatsSinks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsFlushInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsFlushInterval == nil {
				m.StatsFlushInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.StatsFlushInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Watchdog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Watchdog == nil {
				m.Watchdog = &Watchdog{}
			}
			if err := m.Watchdog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tracing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tracing == nil {
				m.Tracing = &v21.Tracing{}
			}
			if err := m.Tracing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimitService", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RateLimitService == nil {
				m.RateLimitService = &v22.RateLimitServiceConfig{}
			}
			if err := m.RateLimitService.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runtime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Runtime == nil {
				m.Runtime = &Runtime{}
			}
			if err := m.Runtime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Admin", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Admin.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StatsConfig == nil {
				m.StatsConfig = &v2.StatsConfig{}
			}
			if err := m.StatsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HdsConfig == nil {
				m.HdsConfig = &core.ApiConfigSource{}
			}
			if err := m.HdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverloadManager", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OverloadManager == nil {
				m.OverloadManager = &v2alpha.OverloadManager{}
			}
			if err := m.OverloadManager.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bootstrap_StaticResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Listeners = append(m.Listeners, v23.Listener{})
			if err := m.Listeners[len(m.Listeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, v23.Cluster{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, auth.Secret{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bootstrap_DynamicResources) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DynamicResources: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DynamicResources: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LdsConfig == nil {
				m.LdsConfig = &core.ConfigSource{}
			}
			if err := m.LdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CdsConfig == nil {
				m.CdsConfig = &core.ConfigSource{}
			}
			if err := m.CdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdsConfig == nil {
				m.AdsConfig = &core.ApiConfigSource{}
			}
			if err := m.AdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Bootstrap_DynamicResources_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Bootstrap_DynamicResources_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SdsConfig == nil {
				m.SdsConfig = &core.ConfigSource{}
			}
			if err := m.SdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Admin) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Admin: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Admin: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessLogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessLogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProfilePath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProfilePath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterManager) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterManager: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterManager: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LocalClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &ClusterManager_OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamBindConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamBindConfig == nil {
				m.UpstreamBindConfig = &core.BindConfig{}
			}
			if err := m.UpstreamBindConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadStatsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadStatsConfig == nil {
				m.LoadStatsConfig = &core.ApiConfigSource{}
			}
			if err := m.LoadStatsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterManager_OutlierDetection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventLogPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EventLogPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Watchdog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Watchdog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Watchdog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MissTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MissTimeout == nil {
				m.MissTimeout = &types.Duration{}
			}
			if err := m.MissTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MegamissTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MegamissTimeout == nil {
				m.MegamissTimeout = &types.Duration{}
			}
			if err := m.MegamissTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KillTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.KillTimeout == nil {
				m.KillTimeout = &types.Duration{}
			}
			if err := m.KillTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MultikillTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MultikillTimeout == nil {
				m.MultikillTimeout = &types.Duration{}
			}
			if err := m.MultikillTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Runtime) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Runtime: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Runtime: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SymlinkRoot", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SymlinkRoot = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subdirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subdirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverrideSubdirectory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBootstrap
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OverrideSubdirectory = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBootstrap(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBootstrap
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBootstrap(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBootstrap
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBootstrap
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBootstrap
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBootstrap
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBootstrap(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBootstrap = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBootstrap   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("envoy/config/bootstrap/v2/bootstrap.proto", fileDescriptor_bootstrap_afd983df223cd175)
}

var fileDescriptor_bootstrap_afd983df223cd175 = []byte{
	// 1235 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0x67, 0x6d, 0xa7, 0x89, 0x9f, 0x9d, 0xd8, 0x19, 0xa5, 0xed, 0xd6, 0xa2, 0x49, 0xea, 0x16,
	0xa9, 0x15, 0xd5, 0x5a, 0x71, 0x41, 0x94, 0xaa, 0x2a, 0xaa, 0x1b, 0x15, 0x21, 0x95, 0x14, 0x36,
	0x15, 0x08, 0x2e, 0xab, 0xf1, 0xee, 0x64, 0x3d, 0xca, 0xee, 0x8e, 0x35, 0x33, 0x5e, 0x94, 0x2b,
	0x47, 0x4e, 0x08, 0x71, 0xe0, 0xce, 0x8d, 0x8f, 0xc0, 0x09, 0x6e, 0x3d, 0xf2, 0x09, 0x00, 0xf5,
	0xc6, 0xb7, 0x40, 0xf3, 0x67, 0xd7, 0x59, 0xc7, 0x4d, 0x03, 0xb7, 0x9d, 0xf7, 0x7e, 0xbf, 0xdf,
	0xcc, 0xbc, 0x79, 0x7f, 0x16, 0xee, 0x90, 0x2c, 0x67, 0x27, 0x83, 0x90, 0x65, 0x47, 0x34, 0x1e,
	0x8c, 0x19, 0x93, 0x42, 0x72, 0x3c, 0x1d, 0xe4, 0xc3, 0xf9, 0xc2, 0x9b, 0x72, 0x26, 0x19, 0xba,
	0xa6, 0xa1, 0x9e, 0x81, 0x7a, 0x73, 0x6f, 0x3e, 0xec, 0xed, 0x18, 0x15, 0x3c, 0xa5, 0x8a, 0x18,
	0x32, 0x4e, 0x06, 0x38, 0x8a, 0x38, 0x11, 0xc2, 0x70, 0x7b, 0x6f, 0x9f, 0x05, 0x8c, 0xb1, 0x20,
	0x4b, 0xbd, 0x78, 0x26, 0x27, 0x83, 0x90, 0x70, 0x69, 0xbd, 0xef, 0x9c, 0xe5, 0x9a, 0x33, 0x04,
	0x82, 0xcd, 0x78, 0x58, 0x88, 0x5c, 0xa9, 0xc2, 0x22, 0xb1, 0xd4, 0x9e, 0x94, 0xf6, 0x1b, 0x95,
	0x9b, 0x4b, 0x8e, 0x43, 0xa2, 0x00, 0xfa, 0xc3, 0x42, 0x6e, 0x56, 0x20, 0x29, 0x91, 0x9c, 0x86,
	0x42, 0x81, 0x84, 0xc4, 0xb2, 0xd0, 0xb9, 0x5b, 0x01, 0xb1, 0x9c, 0xf0, 0x84, 0xe1, 0x68, 0x90,
	0x0f, 0x71, 0x32, 0x9d, 0xe0, 0xd2, 0xb0, 0x54, 0x92, 0x63, 0x49, 0x12, 0x9a, 0x52, 0xa9, 0x44,
	0x79, 0x52, 0x48, 0x6e, 0xc7, 0x8c, 0xc5, 0x09, 0x19, 0xe8, 0xd5, 0x78, 0x76, 0x34, 0x88, 0x66,
	0x1c, 0x4b, 0xca, 0x32, 0xeb, 0xbf, 0x9a, 0xe3, 0x84, 0x46, 0x58, 0x92, 0x41, 0xf1, 0x61, 0x1d,
	0x5b, 0x31, 0x8b, 0x99, 0xfe, 0x1c, 0xa8, 0x2f, 0x63, 0xed, 0xff, 0xb2, 0x0e, 0xcd, 0x51, 0xf1,
	0x5c, 0xe8, 0x5d, 0x68, 0x64, 0x2c, 0x22, 0xae, 0xb3, 0xeb, 0xdc, 0x6e, 0x0d, 0xaf, 0x7a, 0xe6,
	0x55, 0xf1, 0x94, 0x7a, 0xf9, 0xd0, 0x53, 0xd1, 0xf5, 0x0e, 0x58, 0x44, 0x7c, 0x0d, 0x42, 0x01,
	0x74, 0xd5, 0x5d, 0x69, 0x18, 0x70, 0x62, 0xa2, 0x2d, 0xdc, 0x9a, 0x26, 0xbe, 0xe7, 0xbd, 0x36,
	0x1d, 0xbc, 0x72, 0x33, 0xef, 0x50, 0x93, 0xfd, 0x82, 0xeb, 0x77, 0x44, 0xd5, 0x80, 0xc6, 0xb0,
	0x19, 0x9d, 0x64, 0x38, 0xad, 0xec, 0x50, 0xd7, 0x3b, 0xbc, 0x7f, 0xa1, 0x1d, 0xf6, 0x0d, 0x7b,
	0xbe, 0x45, 0x37, 0x5a, 0xb0, 0x20, 0x1f, 0x3a, 0x61, 0x32, 0x13, 0x92, 0xf0, 0x20, 0xc5, 0x19,
	0x8e, 0x09, 0x77, 0x1b, 0x7a, 0x87, 0x3b, 0xe7, 0xec, 0xf0, 0xc4, 0x30, 0x3e, 0x35, 0x04, 0x7f,
	0x23, 0xac, 0xac, 0xd1, 0x75, 0x80, 0xa3, 0x04, 0xc7, 0x22, 0x98, 0x62, 0x39, 0x71, 0x57, 0x76,
	0x9d, 0xdb, 0x4d, 0xbf, 0xa9, 0x2d, 0x9f, 0x61, 0x39, 0x41, 0x4f, 0xa0, 0xa5, 0x73, 0x24, 0x10,
	0x34, 0x3b, 0x16, 0xee, 0xa5, 0xdd, 0xfa, 0xed, 0xd6, 0xb0, 0x5f, 0xdd, 0xce, 0xe6, 0x93, 0xda,
	0x4c, 0x85, 0x49, 0x1c, 0xd2, 0xec, 0xd8, 0x07, 0x51, 0x7c, 0x0a, 0xf4, 0x39, 0x6c, 0x19, 0x91,
	0xa3, 0x64, 0x26, 0x26, 0x01, 0xcd, 0x24, 0xe1, 0x39, 0x4e, 0xdc, 0x55, 0x7d, 0xf8, 0x6b, 0x9e,
	0xc9, 0x12, 0xaf, 0xc8, 0x12, 0x6f, 0xdf, 0x66, 0xc9, 0xa8, 0xf1, 0xd3, 0x5f, 0x3b, 0x8e, 0x8f,
	0x34, 0xf9, 0xa9, 0xe2, 0x7e, 0x62, 0xa9, 0xe8, 0x23, 0x58, 0xfb, 0x06, 0xcb, 0x70, 0x12, 0xb1,
	0xd8, 0x5d, 0xd3, 0x32, 0x37, 0xcf, 0x89, 0xc1, 0x97, 0x16, 0xea, 0x97, 0x24, 0x74, 0x1f, 0x56,
	0x55, 0x85, 0xd0, 0x2c, 0x76, 0x9b, 0x9a, 0xbf, 0x5d, 0xe5, 0x9b, 0xf2, 0xc9, 0x87, 0xde, 0x0b,
	0x83, 0xf2, 0x0b, 0x38, 0x0a, 0x00, 0xa9, 0x74, 0x0f, 0x74, 0xbe, 0x07, 0x82, 0xf0, 0x9c, 0x86,
	0xc4, 0x05, 0x2d, 0xb2, 0x57, 0x15, 0x29, 0xcb, 0x42, 0x09, 0xf9, 0x58, 0x92, 0x67, 0x6a, 0x71,
	0x68, 0x28, 0x4f, 0x34, 0xc6, 0xef, 0xf2, 0x05, 0x3b, 0x7a, 0x08, 0xab, 0x7c, 0x96, 0x49, 0x9a,
	0x12, 0xb7, 0xa5, 0x55, 0xfb, 0xe7, 0x5c, 0xcd, 0x37, 0x48, 0xbf, 0xa0, 0xa0, 0xa7, 0xb0, 0x82,
	0xa3, 0x94, 0x66, 0x6e, 0x5b, 0x73, 0x77, 0xcf, 0xe1, 0x3e, 0x56, 0xb8, 0xd1, 0xc6, 0xcb, 0x3f,
	0x77, 0xde, 0xfa, 0xf5, 0x9f, 0xdf, 0xea, 0x2b, 0xdf, 0x39, 0xb5, 0xae, 0xe3, 0x1b, 0x3a, 0xfa,
	0x18, 0xda, 0xe6, 0xd1, 0x0c, 0xd3, 0x5d, 0xd7, 0x72, 0xb7, 0xce, 0x7f, 0x7a, 0x7b, 0x27, 0x93,
	0x33, 0x66, 0x81, 0x1e, 0x03, 0x4c, 0xa2, 0x52, 0x66, 0xa3, 0x72, 0xa3, 0xd3, 0xd5, 0xfa, 0x78,
	0x4a, 0x0d, 0xe3, 0x50, 0xa7, 0xbb, 0xdf, 0x9c, 0x44, 0x85, 0xc4, 0x57, 0xd0, 0x2d, 0xda, 0x4f,
	0x99, 0xf9, 0x1d, 0x2d, 0xe4, 0x55, 0xcf, 0x53, 0x36, 0x29, 0xdb, 0xb5, 0xbc, 0xe7, 0xd6, 0x50,
	0xa4, 0x7f, 0x87, 0x55, 0x0d, 0xbd, 0xdf, 0x1d, 0xe8, 0x2c, 0x14, 0x37, 0x7a, 0x00, 0xcd, 0x84,
	0x0a, 0x49, 0x32, 0xc2, 0x85, 0xeb, 0xe8, 0x94, 0xbf, 0x52, 0x3d, 0xf0, 0x33, 0xeb, 0x1e, 0x35,
	0x54, 0xf0, 0xfc, 0x39, 0x1c, 0x7d, 0x00, 0x6b, 0xb6, 0xc2, 0x54, 0x83, 0x51, 0xd4, 0xcb, 0x55,
	0xaa, 0xad, 0x47, 0xcb, 0x2c, 0xc1, 0xe8, 0x43, 0x58, 0x15, 0x24, 0xe4, 0x44, 0xaa, 0xb6, 0x51,
	0xd7, 0x75, 0x51, 0xe1, 0xa9, 0x69, 0xe2, 0x1d, 0x6a, 0x84, 0xe5, 0x16, 0xf8, 0xde, 0x0f, 0x75,
	0xe8, 0x2e, 0xb6, 0x0f, 0xf4, 0x08, 0x20, 0x99, 0x87, 0xdd, 0x34, 0xc9, 0x9d, 0x25, 0x61, 0xaf,
	0xc6, 0x3c, 0x29, 0x63, 0xfe, 0x08, 0x20, 0x9c, 0xf3, 0x6b, 0x17, 0xe4, 0x87, 0xd1, 0xa9, 0x67,
	0xc7, 0x73, 0x7e, 0xfd, 0xe2, 0xcf, 0x8e, 0x4b, 0x89, 0x63, 0x58, 0x8f, 0xc8, 0x94, 0x93, 0x10,
	0x4b, 0x12, 0x05, 0xf9, 0x9e, 0xed, 0x76, 0xa3, 0xff, 0xd5, 0x4f, 0xbd, 0xfd, 0x52, 0xea, 0x8b,
	0xbd, 0x51, 0xcd, 0x75, 0xfc, 0x76, 0x74, 0xca, 0xd2, 0x3b, 0x80, 0xf6, 0x69, 0x84, 0xba, 0xbf,
	0xf8, 0xef, 0xf1, 0x13, 0xc5, 0xe1, 0xfb, 0x3f, 0x3b, 0xb0, 0xa2, 0x0b, 0x0c, 0xed, 0x41, 0x07,
	0x87, 0x21, 0x11, 0x22, 0x48, 0x58, 0x6c, 0xfa, 0xac, 0x92, 0x6b, 0x8e, 0x9a, 0xaa, 0xea, 0x1a,
	0xbc, 0xb6, 0xeb, 0xf8, 0xeb, 0x06, 0xf1, 0x8c, 0xc5, 0xba, 0xed, 0xde, 0x80, 0xf6, 0x94, 0xb3,
	0x23, 0x9a, 0x10, 0x83, 0xaf, 0xe9, 0xbe, 0xdc, 0xb2, 0x36, 0x0d, 0xd9, 0x87, 0x55, 0xfb, 0x6b,
	0x62, 0x83, 0xdb, 0x5b, 0x16, 0x5c, 0x83, 0x38, 0x53, 0xe3, 0x05, 0xb5, 0xff, 0x6d, 0x1d, 0x36,
	0xaa, 0x13, 0x02, 0xdd, 0x05, 0x94, 0xb0, 0x10, 0x27, 0x41, 0x31, 0x6b, 0x32, 0x9c, 0x9a, 0x29,
	0xdb, 0xf4, 0xbb, 0xda, 0x63, 0x09, 0x07, 0x38, 0x25, 0x28, 0x86, 0x4d, 0x36, 0x93, 0x09, 0x25,
	0x3c, 0x88, 0x88, 0x24, 0xa1, 0xea, 0xdb, 0x36, 0x5b, 0x1e, 0x5c, 0x78, 0x2a, 0x79, 0xcf, 0x8d,
	0xc4, 0x7e, 0xa1, 0xe0, 0x77, 0xd9, 0x82, 0x05, 0x3d, 0x87, 0xad, 0xd9, 0x54, 0x48, 0x4e, 0x70,
	0x1a, 0x8c, 0x69, 0x16, 0x55, 0x33, 0xeb, 0xfa, 0x92, 0xcb, 0x8f, 0x68, 0x16, 0xd9, 0x86, 0x84,
	0x0a, 0xea, 0xdc, 0x86, 0x0e, 0x60, 0x53, 0x37, 0x94, 0x4a, 0x97, 0x6b, 0x5c, 0x38, 0x4f, 0x3b,
	0x8a, 0x7c, 0xaa, 0xe9, 0xf5, 0xee, 0x43, 0x77, 0xf1, 0x1a, 0xe8, 0x16, 0x6c, 0x90, 0x9c, 0x64,
	0x72, 0xe1, 0xe5, 0xfd, 0xb6, 0xb6, 0xda, 0xd7, 0xee, 0xff, 0x58, 0x83, 0xb5, 0x62, 0x44, 0xa1,
	0x87, 0xd0, 0x4e, 0xa9, 0x10, 0x81, 0x6a, 0xe6, 0x6c, 0x26, 0x6d, 0xe6, 0xbd, 0x7e, 0x48, 0xfa,
	0x2d, 0x05, 0x7f, 0x61, 0xd0, 0x68, 0x1f, 0xba, 0x29, 0x89, 0x71, 0x45, 0xa1, 0xf6, 0x26, 0x85,
	0x4e, 0x41, 0x29, 0x54, 0x1e, 0x42, 0xfb, 0x98, 0x26, 0x49, 0xa9, 0x50, 0x7f, 0xe3, 0x19, 0x14,
	0xbc, 0x60, 0x3f, 0x85, 0xcd, 0x74, 0x96, 0x48, 0x5a, 0x91, 0x68, 0xbc, 0x49, 0xa2, 0x5b, 0x72,
	0xac, 0x4e, 0xff, 0x7b, 0x07, 0x56, 0xed, 0x78, 0x43, 0x77, 0xa1, 0x2d, 0x4e, 0xd2, 0x84, 0x66,
	0xc7, 0x01, 0x67, 0x4c, 0x9e, 0x2d, 0xa0, 0x96, 0x75, 0xfb, 0x8c, 0x49, 0xd4, 0x87, 0xb6, 0x98,
	0x8d, 0x23, 0xca, 0x49, 0x28, 0x19, 0x3f, 0xb1, 0xe5, 0x53, 0xb1, 0xa1, 0x7b, 0x70, 0x59, 0xcd,
	0x02, 0x4e, 0x23, 0x12, 0x54, 0xc0, 0x75, 0x0d, 0xde, 0x2a, 0x9c, 0x87, 0xa7, 0x7c, 0xa3, 0xee,
	0xcb, 0x57, 0xdb, 0xce, 0x1f, 0xaf, 0xb6, 0x9d, 0xbf, 0x5f, 0x6d, 0x3b, 0x5f, 0xd7, 0xf2, 0xe1,
	0xf8, 0x92, 0xbe, 0xc9, 0xbd, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xa8, 0x48, 0xaf, 0x59, 0x80,
	0x0c, 0x00, 0x00,
}
