// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/cluster/outlier_detection.proto

package cluster

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// See the :ref:`architecture overview <arch_overview_outlier_detection>` for
// more information on outlier detection.
type OutlierDetection struct {
	// The number of consecutive 5xx responses before a consecutive 5xx ejection
	// occurs. Defaults to 5.
	Consecutive_5Xx *types.UInt32Value `protobuf:"bytes,1,opt,name=consecutive_5xx,json=consecutive5xx" json:"consecutive_5xx,omitempty"`
	// The time interval between ejection analysis sweeps. This can result in
	// both new ejections as well as hosts being returned to service. Defaults
	// to 10000ms or 10s.
	Interval *types.Duration `protobuf:"bytes,2,opt,name=interval" json:"interval,omitempty"`
	// The base time that a host is ejected for. The real time is equal to the
	// base time multiplied by the number of times the host has been ejected.
	// Defaults to 30000ms or 30s.
	BaseEjectionTime *types.Duration `protobuf:"bytes,3,opt,name=base_ejection_time,json=baseEjectionTime" json:"base_ejection_time,omitempty"`
	// The maximum % of an upstream cluster that can be ejected due to outlier
	// detection. Defaults to 10% but will eject at least one host regardless of the value.
	MaxEjectionPercent *types.UInt32Value `protobuf:"bytes,4,opt,name=max_ejection_percent,json=maxEjectionPercent" json:"max_ejection_percent,omitempty"`
	// The % chance that a host will be actually ejected when an outlier status
	// is detected through consecutive 5xx. This setting can be used to disable
	// ejection or to ramp it up slowly. Defaults to 100.
	EnforcingConsecutive_5Xx *types.UInt32Value `protobuf:"bytes,5,opt,name=enforcing_consecutive_5xx,json=enforcingConsecutive5xx" json:"enforcing_consecutive_5xx,omitempty"`
	// The % chance that a host will be actually ejected when an outlier status
	// is detected through success rate statistics. This setting can be used to
	// disable ejection or to ramp it up slowly. Defaults to 100.
	EnforcingSuccessRate *types.UInt32Value `protobuf:"bytes,6,opt,name=enforcing_success_rate,json=enforcingSuccessRate" json:"enforcing_success_rate,omitempty"`
	// The number of hosts in a cluster that must have enough request volume to
	// detect success rate outliers. If the number of hosts is less than this
	// setting, outlier detection via success rate statistics is not performed
	// for any host in the cluster. Defaults to 5.
	SuccessRateMinimumHosts *types.UInt32Value `protobuf:"bytes,7,opt,name=success_rate_minimum_hosts,json=successRateMinimumHosts" json:"success_rate_minimum_hosts,omitempty"`
	// The minimum number of total requests that must be collected in one
	// interval (as defined by the interval duration above) to include this host
	// in success rate based outlier detection. If the volume is lower than this
	// setting, outlier detection via success rate statistics is not performed
	// for that host. Defaults to 100.
	SuccessRateRequestVolume *types.UInt32Value `protobuf:"bytes,8,opt,name=success_rate_request_volume,json=successRateRequestVolume" json:"success_rate_request_volume,omitempty"`
	// This factor is used to determine the ejection threshold for success rate
	// outlier ejection. The ejection threshold is the difference between the
	// mean success rate, and the product of this factor and the standard
	// deviation of the mean success rate: mean - (stdev *
	// success_rate_stdev_factor). This factor is divided by a thousand to get a
	// double. That is, if the desired factor is 1.9, the runtime value should
	// be 1900. Defaults to 1900.
	SuccessRateStdevFactor *types.UInt32Value `protobuf:"bytes,9,opt,name=success_rate_stdev_factor,json=successRateStdevFactor" json:"success_rate_stdev_factor,omitempty"`
	// The number of consecutive gateway failures (502, 503, 504 status or
	// connection errors that are mapped to one of those status codes) before a
	// consecutive gateway failure ejection occurs. Defaults to 5.
	ConsecutiveGatewayFailure *types.UInt32Value `protobuf:"bytes,10,opt,name=consecutive_gateway_failure,json=consecutiveGatewayFailure" json:"consecutive_gateway_failure,omitempty"`
	// The % chance that a host will be actually ejected when an outlier status
	// is detected through consecutive gateway failures. This setting can be
	// used to disable ejection or to ramp it up slowly. Defaults to 0.
	EnforcingConsecutiveGatewayFailure *types.UInt32Value `protobuf:"bytes,11,opt,name=enforcing_consecutive_gateway_failure,json=enforcingConsecutiveGatewayFailure" json:"enforcing_consecutive_gateway_failure,omitempty"`
	XXX_NoUnkeyedLiteral               struct{}           `json:"-"`
	XXX_unrecognized                   []byte             `json:"-"`
	XXX_sizecache                      int32              `json:"-"`
}

func (m *OutlierDetection) Reset()         { *m = OutlierDetection{} }
func (m *OutlierDetection) String() string { return proto.CompactTextString(m) }
func (*OutlierDetection) ProtoMessage()    {}
func (*OutlierDetection) Descriptor() ([]byte, []int) {
	return fileDescriptor_outlier_detection_ca1bd929cef49cfa, []int{0}
}
func (m *OutlierDetection) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OutlierDetection) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OutlierDetection.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *OutlierDetection) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OutlierDetection.Merge(dst, src)
}
func (m *OutlierDetection) XXX_Size() int {
	return m.Size()
}
func (m *OutlierDetection) XXX_DiscardUnknown() {
	xxx_messageInfo_OutlierDetection.DiscardUnknown(m)
}

var xxx_messageInfo_OutlierDetection proto.InternalMessageInfo

func (m *OutlierDetection) GetConsecutive_5Xx() *types.UInt32Value {
	if m != nil {
		return m.Consecutive_5Xx
	}
	return nil
}

func (m *OutlierDetection) GetInterval() *types.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *OutlierDetection) GetBaseEjectionTime() *types.Duration {
	if m != nil {
		return m.BaseEjectionTime
	}
	return nil
}

func (m *OutlierDetection) GetMaxEjectionPercent() *types.UInt32Value {
	if m != nil {
		return m.MaxEjectionPercent
	}
	return nil
}

func (m *OutlierDetection) GetEnforcingConsecutive_5Xx() *types.UInt32Value {
	if m != nil {
		return m.EnforcingConsecutive_5Xx
	}
	return nil
}

func (m *OutlierDetection) GetEnforcingSuccessRate() *types.UInt32Value {
	if m != nil {
		return m.EnforcingSuccessRate
	}
	return nil
}

func (m *OutlierDetection) GetSuccessRateMinimumHosts() *types.UInt32Value {
	if m != nil {
		return m.SuccessRateMinimumHosts
	}
	return nil
}

func (m *OutlierDetection) GetSuccessRateRequestVolume() *types.UInt32Value {
	if m != nil {
		return m.SuccessRateRequestVolume
	}
	return nil
}

func (m *OutlierDetection) GetSuccessRateStdevFactor() *types.UInt32Value {
	if m != nil {
		return m.SuccessRateStdevFactor
	}
	return nil
}

func (m *OutlierDetection) GetConsecutiveGatewayFailure() *types.UInt32Value {
	if m != nil {
		return m.ConsecutiveGatewayFailure
	}
	return nil
}

func (m *OutlierDetection) GetEnforcingConsecutiveGatewayFailure() *types.UInt32Value {
	if m != nil {
		return m.EnforcingConsecutiveGatewayFailure
	}
	return nil
}

func init() {
	proto.RegisterType((*OutlierDetection)(nil), "envoy.api.v2.cluster.OutlierDetection")
}
func (this *OutlierDetection) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*OutlierDetection)
	if !ok {
		that2, ok := that.(OutlierDetection)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Consecutive_5Xx.Equal(that1.Consecutive_5Xx) {
		return false
	}
	if !this.Interval.Equal(that1.Interval) {
		return false
	}
	if !this.BaseEjectionTime.Equal(that1.BaseEjectionTime) {
		return false
	}
	if !this.MaxEjectionPercent.Equal(that1.MaxEjectionPercent) {
		return false
	}
	if !this.EnforcingConsecutive_5Xx.Equal(that1.EnforcingConsecutive_5Xx) {
		return false
	}
	if !this.EnforcingSuccessRate.Equal(that1.EnforcingSuccessRate) {
		return false
	}
	if !this.SuccessRateMinimumHosts.Equal(that1.SuccessRateMinimumHosts) {
		return false
	}
	if !this.SuccessRateRequestVolume.Equal(that1.SuccessRateRequestVolume) {
		return false
	}
	if !this.SuccessRateStdevFactor.Equal(that1.SuccessRateStdevFactor) {
		return false
	}
	if !this.ConsecutiveGatewayFailure.Equal(that1.ConsecutiveGatewayFailure) {
		return false
	}
	if !this.EnforcingConsecutiveGatewayFailure.Equal(that1.EnforcingConsecutiveGatewayFailure) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (m *OutlierDetection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierDetection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Consecutive_5Xx != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.Consecutive_5Xx.Size()))
		n1, err := m.Consecutive_5Xx.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Interval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.Interval.Size()))
		n2, err := m.Interval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.BaseEjectionTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.BaseEjectionTime.Size()))
		n3, err := m.BaseEjectionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.MaxEjectionPercent != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.MaxEjectionPercent.Size()))
		n4, err := m.MaxEjectionPercent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.EnforcingConsecutive_5Xx != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.EnforcingConsecutive_5Xx.Size()))
		n5, err := m.EnforcingConsecutive_5Xx.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.EnforcingSuccessRate != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.EnforcingSuccessRate.Size()))
		n6, err := m.EnforcingSuccessRate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.SuccessRateMinimumHosts != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.SuccessRateMinimumHosts.Size()))
		n7, err := m.SuccessRateMinimumHosts.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.SuccessRateRequestVolume != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.SuccessRateRequestVolume.Size()))
		n8, err := m.SuccessRateRequestVolume.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.SuccessRateStdevFactor != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.SuccessRateStdevFactor.Size()))
		n9, err := m.SuccessRateStdevFactor.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.ConsecutiveGatewayFailure != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.ConsecutiveGatewayFailure.Size()))
		n10, err := m.ConsecutiveGatewayFailure.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.EnforcingConsecutiveGatewayFailure != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintOutlierDetection(dAtA, i, uint64(m.EnforcingConsecutiveGatewayFailure.Size()))
		n11, err := m.EnforcingConsecutiveGatewayFailure.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintOutlierDetection(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *OutlierDetection) Size() (n int) {
	var l int
	_ = l
	if m.Consecutive_5Xx != nil {
		l = m.Consecutive_5Xx.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.BaseEjectionTime != nil {
		l = m.BaseEjectionTime.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.MaxEjectionPercent != nil {
		l = m.MaxEjectionPercent.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.EnforcingConsecutive_5Xx != nil {
		l = m.EnforcingConsecutive_5Xx.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.EnforcingSuccessRate != nil {
		l = m.EnforcingSuccessRate.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.SuccessRateMinimumHosts != nil {
		l = m.SuccessRateMinimumHosts.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.SuccessRateRequestVolume != nil {
		l = m.SuccessRateRequestVolume.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.SuccessRateStdevFactor != nil {
		l = m.SuccessRateStdevFactor.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.ConsecutiveGatewayFailure != nil {
		l = m.ConsecutiveGatewayFailure.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.EnforcingConsecutiveGatewayFailure != nil {
		l = m.EnforcingConsecutiveGatewayFailure.Size()
		n += 1 + l + sovOutlierDetection(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovOutlierDetection(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozOutlierDetection(x uint64) (n int) {
	return sovOutlierDetection(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *OutlierDetection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowOutlierDetection
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Consecutive_5Xx", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Consecutive_5Xx == nil {
				m.Consecutive_5Xx = &types.UInt32Value{}
			}
			if err := m.Consecutive_5Xx.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &types.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseEjectionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseEjectionTime == nil {
				m.BaseEjectionTime = &types.Duration{}
			}
			if err := m.BaseEjectionTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxEjectionPercent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxEjectionPercent == nil {
				m.MaxEjectionPercent = &types.UInt32Value{}
			}
			if err := m.MaxEjectionPercent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcingConsecutive_5Xx", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnforcingConsecutive_5Xx == nil {
				m.EnforcingConsecutive_5Xx = &types.UInt32Value{}
			}
			if err := m.EnforcingConsecutive_5Xx.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcingSuccessRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnforcingSuccessRate == nil {
				m.EnforcingSuccessRate = &types.UInt32Value{}
			}
			if err := m.EnforcingSuccessRate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuccessRateMinimumHosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuccessRateMinimumHosts == nil {
				m.SuccessRateMinimumHosts = &types.UInt32Value{}
			}
			if err := m.SuccessRateMinimumHosts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuccessRateRequestVolume", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuccessRateRequestVolume == nil {
				m.SuccessRateRequestVolume = &types.UInt32Value{}
			}
			if err := m.SuccessRateRequestVolume.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuccessRateStdevFactor", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuccessRateStdevFactor == nil {
				m.SuccessRateStdevFactor = &types.UInt32Value{}
			}
			if err := m.SuccessRateStdevFactor.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveGatewayFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsecutiveGatewayFailure == nil {
				m.ConsecutiveGatewayFailure = &types.UInt32Value{}
			}
			if err := m.ConsecutiveGatewayFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnforcingConsecutiveGatewayFailure", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EnforcingConsecutiveGatewayFailure == nil {
				m.EnforcingConsecutiveGatewayFailure = &types.UInt32Value{}
			}
			if err := m.EnforcingConsecutiveGatewayFailure.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipOutlierDetection(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthOutlierDetection
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipOutlierDetection(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowOutlierDetection
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowOutlierDetection
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthOutlierDetection
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowOutlierDetection
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipOutlierDetection(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthOutlierDetection = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowOutlierDetection   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("envoy/api/v2/cluster/outlier_detection.proto", fileDescriptor_outlier_detection_ca1bd929cef49cfa)
}

var fileDescriptor_outlier_detection_ca1bd929cef49cfa = []byte{
	// 537 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x94, 0xcb, 0x6e, 0xd3, 0x4c,
	0x14, 0xc7, 0x3f, 0xa7, 0xf7, 0xa9, 0xf4, 0x51, 0x8d, 0xa2, 0x66, 0xd2, 0xa2, 0x08, 0x55, 0x42,
	0x82, 0x0a, 0xd9, 0x52, 0xaa, 0x3e, 0x40, 0xd3, 0xa6, 0xc0, 0x82, 0x8b, 0x12, 0x08, 0x42, 0x80,
	0x46, 0x13, 0xe7, 0xc4, 0x0c, 0xb2, 0x3d, 0x66, 0x2e, 0xae, 0xcb, 0x13, 0xa1, 0x3e, 0x02, 0x2b,
	0x96, 0x2c, 0x79, 0x04, 0x94, 0x1d, 0xcf, 0xc0, 0x06, 0xd9, 0x93, 0x8b, 0xd3, 0x56, 0x22, 0xd9,
	0x8d, 0x3c, 0xf3, 0xfb, 0xfd, 0x8f, 0xcf, 0x1c, 0x0d, 0x7a, 0x04, 0x71, 0x2a, 0x2e, 0x3d, 0x96,
	0x70, 0x2f, 0x6d, 0x7a, 0x7e, 0x68, 0x94, 0x06, 0xe9, 0x09, 0xa3, 0x43, 0x0e, 0x92, 0x0e, 0x40,
	0x83, 0xaf, 0xb9, 0x88, 0xdd, 0x44, 0x0a, 0x2d, 0x70, 0xb5, 0x38, 0xed, 0xb2, 0x84, 0xbb, 0x69,
	0xd3, 0x1d, 0x9f, 0xde, 0x6b, 0x04, 0x42, 0x04, 0x21, 0x78, 0xc5, 0x99, 0xbe, 0x19, 0x7a, 0x03,
	0x23, 0xd9, 0x8c, 0xba, 0xb9, 0x7f, 0x21, 0x59, 0x92, 0x80, 0x54, 0xe3, 0xfd, 0x5a, 0xca, 0x42,
	0x3e, 0x60, 0x1a, 0xbc, 0xc9, 0x62, 0xbc, 0x51, 0x0d, 0x44, 0x20, 0x8a, 0xa5, 0x97, 0xaf, 0xec,
	0xd7, 0x83, 0x3f, 0x1b, 0x68, 0xe7, 0x85, 0x2d, 0xf0, 0x6c, 0x52, 0x1f, 0x6e, 0xa3, 0x3b, 0xbe,
	0x88, 0x15, 0xf8, 0x46, 0xf3, 0x14, 0xe8, 0x71, 0x96, 0x11, 0xe7, 0x9e, 0xf3, 0x60, 0xbb, 0x79,
	0xd7, 0xb5, 0xe9, 0xee, 0x24, 0xdd, 0x7d, 0xfd, 0x34, 0xd6, 0x47, 0xcd, 0x1e, 0x0b, 0x0d, 0x74,
	0xfe, 0x2f, 0x41, 0xc7, 0x59, 0x86, 0x4f, 0xd0, 0x26, 0x8f, 0x35, 0xc8, 0x94, 0x85, 0xa4, 0x52,
	0xf0, 0xf5, 0x1b, 0xfc, 0xd9, 0xf8, 0xef, 0x5a, 0xe8, 0xdb, 0xef, 0xef, 0x2b, 0x6b, 0x57, 0x4e,
	0xe5, 0xf0, 0xbf, 0xce, 0x14, 0xc3, 0x5d, 0x84, 0xfb, 0x4c, 0x01, 0x85, 0x4f, 0xb6, 0x34, 0xaa,
	0x79, 0x04, 0x64, 0x65, 0x19, 0xd9, 0x4e, 0x2e, 0x68, 0x8f, 0xf9, 0x57, 0x3c, 0x02, 0xfc, 0x16,
	0x55, 0x23, 0x96, 0xcd, 0x9c, 0x09, 0x48, 0x1f, 0x62, 0x4d, 0x56, 0xff, 0xfd, 0x8f, 0xad, 0xad,
	0xdc, 0xbc, 0x7a, 0x58, 0x21, 0x83, 0x0e, 0x8e, 0x58, 0x36, 0xf1, 0xbe, 0xb4, 0x0a, 0xec, 0xa3,
	0x3a, 0xc4, 0x43, 0x21, 0x7d, 0x1e, 0x07, 0xf4, 0x7a, 0x0f, 0xd7, 0x96, 0xf3, 0xd7, 0xa6, 0xa6,
	0xd3, 0xf9, 0xbe, 0x7e, 0x40, 0xbb, 0xb3, 0x10, 0x65, 0x7c, 0x1f, 0x94, 0xa2, 0x92, 0x69, 0x20,
	0xeb, 0xcb, 0x25, 0x54, 0xa7, 0x9a, 0xae, 0xb5, 0x74, 0x98, 0xce, 0xdb, 0xb3, 0x57, 0x96, 0xd2,
	0x88, 0xc7, 0x3c, 0x32, 0x11, 0xfd, 0x28, 0x94, 0x56, 0x64, 0x63, 0x81, 0x41, 0xa8, 0xa9, 0x99,
	0xee, 0x99, 0xa5, 0x9f, 0xe4, 0x30, 0x7e, 0x87, 0xf6, 0xe7, 0xd4, 0x12, 0x3e, 0x1b, 0x50, 0x9a,
	0xa6, 0x22, 0x34, 0x11, 0x90, 0xcd, 0x05, 0xdc, 0xa4, 0xe4, 0xee, 0x58, 0xbc, 0x57, 0xd0, 0xf8,
	0x0d, 0xaa, 0xcf, 0xc9, 0x95, 0x1e, 0x40, 0x4a, 0x87, 0xcc, 0xd7, 0x42, 0x92, 0xad, 0x05, 0xd4,
	0xbb, 0x25, 0x75, 0x37, 0x87, 0xcf, 0x0b, 0x16, 0xbf, 0x47, 0xfb, 0xe5, 0xab, 0x0c, 0x98, 0x86,
	0x0b, 0x76, 0x49, 0x87, 0x8c, 0x87, 0x46, 0x02, 0x41, 0x0b, 0xa8, 0xeb, 0x25, 0xc1, 0x63, 0xcb,
	0x9f, 0x5b, 0x1c, 0x7f, 0x41, 0xf7, 0x6f, 0x1f, 0x99, 0xeb, 0x39, 0xdb, 0xcb, 0x5d, 0xee, 0xc1,
	0x6d, 0xe3, 0x33, 0x9f, 0xdd, 0x7a, 0xf8, 0x75, 0xd4, 0x70, 0x7e, 0x8c, 0x1a, 0xce, 0xcf, 0x51,
	0xc3, 0xf9, 0x35, 0x6a, 0x38, 0x57, 0x95, 0xdd, 0x76, 0xf1, 0x2a, 0x9d, 0x24, 0xdc, 0xed, 0x35,
	0xdd, 0x53, 0xfb, 0x2a, 0x3d, 0xef, 0xf6, 0xd7, 0x8b, 0xbc, 0xa3, 0xbf, 0x01, 0x00, 0x00, 0xff,
	0xff, 0xd4, 0x46, 0xcd, 0x39, 0xe4, 0x04, 0x00, 0x00,
}
