// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/auth/cert.proto

package auth

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import _ "github.com/gogo/protobuf/gogoproto"
import types "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type TlsParameters_TlsProtocol int32

const (
	// Envoy will choose the optimal TLS version.
	TlsParameters_TLS_AUTO TlsParameters_TlsProtocol = 0
	// TLS 1.0
	TlsParameters_TLSv1_0 TlsParameters_TlsProtocol = 1
	// TLS 1.1
	TlsParameters_TLSv1_1 TlsParameters_TlsProtocol = 2
	// TLS 1.2
	TlsParameters_TLSv1_2 TlsParameters_TlsProtocol = 3
	// TLS 1.3
	TlsParameters_TLSv1_3 TlsParameters_TlsProtocol = 4
)

var TlsParameters_TlsProtocol_name = map[int32]string{
	0: "TLS_AUTO",
	1: "TLSv1_0",
	2: "TLSv1_1",
	3: "TLSv1_2",
	4: "TLSv1_3",
}
var TlsParameters_TlsProtocol_value = map[string]int32{
	"TLS_AUTO": 0,
	"TLSv1_0":  1,
	"TLSv1_1":  2,
	"TLSv1_2":  3,
	"TLSv1_3":  4,
}

func (x TlsParameters_TlsProtocol) String() string {
	return proto.EnumName(TlsParameters_TlsProtocol_name, int32(x))
}
func (TlsParameters_TlsProtocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{0, 0}
}

type TlsParameters struct {
	// Minimum TLS protocol version.
	TlsMinimumProtocolVersion TlsParameters_TlsProtocol `protobuf:"varint,1,opt,name=tls_minimum_protocol_version,json=tlsMinimumProtocolVersion,proto3,enum=envoy.api.v2.auth.TlsParameters_TlsProtocol" json:"tls_minimum_protocol_version,omitempty"`
	// Maximum TLS protocol version.
	TlsMaximumProtocolVersion TlsParameters_TlsProtocol `protobuf:"varint,2,opt,name=tls_maximum_protocol_version,json=tlsMaximumProtocolVersion,proto3,enum=envoy.api.v2.auth.TlsParameters_TlsProtocol" json:"tls_maximum_protocol_version,omitempty"`
	// If specified, the TLS listener will only support the specified `cipher list
	// <https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration>`_.
	// If not specified, the default list:
	//
	// .. code-block:: none
	//
	//   [ECDHE-ECDSA-AES128-GCM-SHA256|ECDHE-ECDSA-CHACHA20-POLY1305]
	//   [ECDHE-RSA-AES128-GCM-SHA256|ECDHE-RSA-CHACHA20-POLY1305]
	//   ECDHE-ECDSA-AES128-SHA
	//   ECDHE-RSA-AES128-SHA
	//   AES128-GCM-SHA256
	//   AES128-SHA
	//   ECDHE-ECDSA-AES256-GCM-SHA384
	//   ECDHE-RSA-AES256-GCM-SHA384
	//   ECDHE-ECDSA-AES256-SHA
	//   ECDHE-RSA-AES256-SHA
	//   AES256-GCM-SHA384
	//   AES256-SHA
	//
	// will be used.
	CipherSuites []string `protobuf:"bytes,3,rep,name=cipher_suites,json=cipherSuites" json:"cipher_suites,omitempty"`
	// If specified, the TLS connection will only support the specified ECDH
	// curves. If not specified, the default curves (X25519, P-256) will be used.
	EcdhCurves           []string `protobuf:"bytes,4,rep,name=ecdh_curves,json=ecdhCurves" json:"ecdh_curves,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TlsParameters) Reset()         { *m = TlsParameters{} }
func (m *TlsParameters) String() string { return proto.CompactTextString(m) }
func (*TlsParameters) ProtoMessage()    {}
func (*TlsParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{0}
}
func (m *TlsParameters) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsParameters.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TlsParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsParameters.Merge(dst, src)
}
func (m *TlsParameters) XXX_Size() int {
	return m.Size()
}
func (m *TlsParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsParameters.DiscardUnknown(m)
}

var xxx_messageInfo_TlsParameters proto.InternalMessageInfo

func (m *TlsParameters) GetTlsMinimumProtocolVersion() TlsParameters_TlsProtocol {
	if m != nil {
		return m.TlsMinimumProtocolVersion
	}
	return TlsParameters_TLS_AUTO
}

func (m *TlsParameters) GetTlsMaximumProtocolVersion() TlsParameters_TlsProtocol {
	if m != nil {
		return m.TlsMaximumProtocolVersion
	}
	return TlsParameters_TLS_AUTO
}

func (m *TlsParameters) GetCipherSuites() []string {
	if m != nil {
		return m.CipherSuites
	}
	return nil
}

func (m *TlsParameters) GetEcdhCurves() []string {
	if m != nil {
		return m.EcdhCurves
	}
	return nil
}

type TlsCertificate struct {
	// The TLS certificate chain.
	CertificateChain *core.DataSource `protobuf:"bytes,1,opt,name=certificate_chain,json=certificateChain" json:"certificate_chain,omitempty"`
	// The TLS private key.
	PrivateKey *core.DataSource `protobuf:"bytes,2,opt,name=private_key,json=privateKey" json:"private_key,omitempty"`
	// [#not-implemented-hide:]
	Password *core.DataSource `protobuf:"bytes,3,opt,name=password" json:"password,omitempty"`
	// [#not-implemented-hide:]
	OcspStaple *core.DataSource `protobuf:"bytes,4,opt,name=ocsp_staple,json=ocspStaple" json:"ocsp_staple,omitempty"`
	// [#not-implemented-hide:]
	SignedCertificateTimestamp []*core.DataSource `protobuf:"bytes,5,rep,name=signed_certificate_timestamp,json=signedCertificateTimestamp" json:"signed_certificate_timestamp,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}           `json:"-"`
	XXX_unrecognized           []byte             `json:"-"`
	XXX_sizecache              int32              `json:"-"`
}

func (m *TlsCertificate) Reset()         { *m = TlsCertificate{} }
func (m *TlsCertificate) String() string { return proto.CompactTextString(m) }
func (*TlsCertificate) ProtoMessage()    {}
func (*TlsCertificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{1}
}
func (m *TlsCertificate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsCertificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsCertificate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TlsCertificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsCertificate.Merge(dst, src)
}
func (m *TlsCertificate) XXX_Size() int {
	return m.Size()
}
func (m *TlsCertificate) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsCertificate.DiscardUnknown(m)
}

var xxx_messageInfo_TlsCertificate proto.InternalMessageInfo

func (m *TlsCertificate) GetCertificateChain() *core.DataSource {
	if m != nil {
		return m.CertificateChain
	}
	return nil
}

func (m *TlsCertificate) GetPrivateKey() *core.DataSource {
	if m != nil {
		return m.PrivateKey
	}
	return nil
}

func (m *TlsCertificate) GetPassword() *core.DataSource {
	if m != nil {
		return m.Password
	}
	return nil
}

func (m *TlsCertificate) GetOcspStaple() *core.DataSource {
	if m != nil {
		return m.OcspStaple
	}
	return nil
}

func (m *TlsCertificate) GetSignedCertificateTimestamp() []*core.DataSource {
	if m != nil {
		return m.SignedCertificateTimestamp
	}
	return nil
}

type TlsSessionTicketKeys struct {
	// Keys for encrypting and decrypting TLS session tickets. The
	// first key in the array contains the key to encrypt all new sessions created by this context.
	// All keys are candidates for decrypting received tickets. This allows for easy rotation of keys
	// by, for example, putting the new key first, and the previous key second.
	//
	// If :ref:`session_ticket_keys <envoy_api_field_auth.DownstreamTlsContext.session_ticket_keys>`
	// is not specified, the TLS library will still support resuming sessions via tickets, but it will
	// use an internally-generated and managed key, so sessions cannot be resumed across hot restarts
	// or on different hosts.
	//
	// Each key must contain exactly 80 bytes of cryptographically-secure random data. For
	// example, the output of ``openssl rand 80``.
	//
	// .. attention::
	//
	//   Using this feature has serious security considerations and risks. Improper handling of keys
	//   may result in loss of secrecy in connections, even if ciphers supporting perfect forward
	//   secrecy are used. See https://www.imperialviolet.org/2013/06/27/botchingpfs.html for some
	//   discussion. To minimize the risk, you must:
	//
	//   * Keep the session ticket keys at least as secure as your TLS certificate private keys
	//   * Rotate session ticket keys at least daily, and preferably hourly
	//   * Always generate keys using a cryptographically-secure random data source
	Keys                 []*core.DataSource `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *TlsSessionTicketKeys) Reset()         { *m = TlsSessionTicketKeys{} }
func (m *TlsSessionTicketKeys) String() string { return proto.CompactTextString(m) }
func (*TlsSessionTicketKeys) ProtoMessage()    {}
func (*TlsSessionTicketKeys) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{2}
}
func (m *TlsSessionTicketKeys) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TlsSessionTicketKeys) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TlsSessionTicketKeys.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *TlsSessionTicketKeys) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TlsSessionTicketKeys.Merge(dst, src)
}
func (m *TlsSessionTicketKeys) XXX_Size() int {
	return m.Size()
}
func (m *TlsSessionTicketKeys) XXX_DiscardUnknown() {
	xxx_messageInfo_TlsSessionTicketKeys.DiscardUnknown(m)
}

var xxx_messageInfo_TlsSessionTicketKeys proto.InternalMessageInfo

func (m *TlsSessionTicketKeys) GetKeys() []*core.DataSource {
	if m != nil {
		return m.Keys
	}
	return nil
}

type CertificateValidationContext struct {
	// TLS certificate data containing certificate authority certificates to use in verifying
	// a presented peer certificate (e.g. server certificate for clusters or client certificate
	// for listeners). If not specified and a peer certificate is presented it will not be
	// verified. By default, a client certificate is optional, unless one of the additional
	// options (:ref:`require_client_certificate
	// <envoy_api_field_auth.DownstreamTlsContext.require_client_certificate>`,
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>`,
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>`, or
	// :ref:`verify_subject_alt_name
	// <envoy_api_field_auth.CertificateValidationContext.verify_subject_alt_name>`) is also
	// specified.
	//
	// See :ref:`the TLS overview <arch_overview_ssl_enabling_verification>` for a list of common
	// system CA locations.
	TrustedCa *core.DataSource `protobuf:"bytes,1,opt,name=trusted_ca,json=trustedCa" json:"trusted_ca,omitempty"`
	// An optional list of base64-encoded SHA-256 hashes. If specified, Envoy will verify that the
	// SHA-256 of the DER-encoded Subject Public Key Information (SPKI) of the presented certificate
	// matches one of the specified values.
	//
	// A base64-encoded SHA-256 of the Subject Public Key Information (SPKI) of the certificate
	// can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -noout -pubkey \
	//     | openssl pkey -pubin -outform DER \
	//     | openssl dgst -sha256 -binary \
	//     | openssl enc -base64
	//   NvqYIYSbgK2vCJpQhObf77vv+bQWtc5ek5RIOwPiC9A=
	//
	// This is the format used in HTTP Public Key Pinning.
	//
	// When both:
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>` and
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>` are specified,
	// a hash matching value from either of the lists will result in the certificate being accepted.
	//
	// .. attention::
	//
	//   This option is preferred over :ref:`verify_certificate_hash
	//   <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>`,
	//   because SPKI is tied to a private key, so it doesn't change when the certificate
	//   is renewed using the same private key.
	VerifyCertificateSpki []string `protobuf:"bytes,3,rep,name=verify_certificate_spki,json=verifyCertificateSpki" json:"verify_certificate_spki,omitempty"`
	// An optional list of hex-encoded SHA-256 hashes. If specified, Envoy will verify that
	// the SHA-256 of the DER-encoded presented certificate matches one of the specified values.
	//
	// A hex-encoded SHA-256 of the certificate can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -outform DER | openssl dgst -sha256 | cut -d" " -f2
	//   df6ff72fe9116521268f6f2dd4966f51df479883fe7037b39f75916ac3049d1a
	//
	// A long hex-encoded and colon-separated SHA-256 (a.k.a. "fingerprint") of the certificate
	// can be generated with the following command:
	//
	// .. code-block:: bash
	//
	//   $ openssl x509 -in path/to/client.crt -noout -fingerprint -sha256 | cut -d"=" -f2
	//   DF:6F:F7:2F:E9:11:65:21:26:8F:6F:2D:D4:96:6F:51:DF:47:98:83:FE:70:37:B3:9F:75:91:6A:C3:04:9D:1A
	//
	// Both of those formats are acceptable.
	//
	// When both:
	// :ref:`verify_certificate_hash
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_hash>` and
	// :ref:`verify_certificate_spki
	// <envoy_api_field_auth.CertificateValidationContext.verify_certificate_spki>` are specified,
	// a hash matching value from either of the lists will result in the certificate being accepted.
	VerifyCertificateHash []string `protobuf:"bytes,2,rep,name=verify_certificate_hash,json=verifyCertificateHash" json:"verify_certificate_hash,omitempty"`
	// An optional list of Subject Alternative Names. If specified, Envoy will verify that the
	// Subject Alternative Name of the presented certificate matches one of the specified values.
	//
	// .. attention::
	//
	//   Subject Alternative Names are easily spoofable and verifying only them is insecure,
	//   therefore this option must be used together with :ref:`trusted_ca
	//   <envoy_api_field_auth.CertificateValidationContext.trusted_ca>`.
	VerifySubjectAltName []string `protobuf:"bytes,4,rep,name=verify_subject_alt_name,json=verifySubjectAltName" json:"verify_subject_alt_name,omitempty"`
	// [#not-implemented-hide:] Must present a signed time-stamped OCSP response.
	RequireOcspStaple *types.BoolValue `protobuf:"bytes,5,opt,name=require_ocsp_staple,json=requireOcspStaple" json:"require_ocsp_staple,omitempty"`
	// [#not-implemented-hide:] Must present signed certificate time-stamp.
	RequireSignedCertificateTimestamp *types.BoolValue `protobuf:"bytes,6,opt,name=require_signed_certificate_timestamp,json=requireSignedCertificateTimestamp" json:"require_signed_certificate_timestamp,omitempty"`
	// An optional `certificate revocation list
	// <http://https://en.wikipedia.org/wiki/Certificate_revocation_list>`_
	// (in PEM format). If specified, Envoy will verify that the presented peer
	// certificate has not been revoked by this CRL. If this DataSource contains
	// multiple CRLs, all of them will be used.
	Crl *core.DataSource `protobuf:"bytes,7,opt,name=crl" json:"crl,omitempty"`
	// If specified, Envoy will not reject expired certificates.
	AllowExpiredCertificate bool     `protobuf:"varint,8,opt,name=allow_expired_certificate,json=allowExpiredCertificate,proto3" json:"allow_expired_certificate,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *CertificateValidationContext) Reset()         { *m = CertificateValidationContext{} }
func (m *CertificateValidationContext) String() string { return proto.CompactTextString(m) }
func (*CertificateValidationContext) ProtoMessage()    {}
func (*CertificateValidationContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{3}
}
func (m *CertificateValidationContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CertificateValidationContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CertificateValidationContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CertificateValidationContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CertificateValidationContext.Merge(dst, src)
}
func (m *CertificateValidationContext) XXX_Size() int {
	return m.Size()
}
func (m *CertificateValidationContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CertificateValidationContext.DiscardUnknown(m)
}

var xxx_messageInfo_CertificateValidationContext proto.InternalMessageInfo

func (m *CertificateValidationContext) GetTrustedCa() *core.DataSource {
	if m != nil {
		return m.TrustedCa
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifyCertificateSpki() []string {
	if m != nil {
		return m.VerifyCertificateSpki
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifyCertificateHash() []string {
	if m != nil {
		return m.VerifyCertificateHash
	}
	return nil
}

func (m *CertificateValidationContext) GetVerifySubjectAltName() []string {
	if m != nil {
		return m.VerifySubjectAltName
	}
	return nil
}

func (m *CertificateValidationContext) GetRequireOcspStaple() *types.BoolValue {
	if m != nil {
		return m.RequireOcspStaple
	}
	return nil
}

func (m *CertificateValidationContext) GetRequireSignedCertificateTimestamp() *types.BoolValue {
	if m != nil {
		return m.RequireSignedCertificateTimestamp
	}
	return nil
}

func (m *CertificateValidationContext) GetCrl() *core.DataSource {
	if m != nil {
		return m.Crl
	}
	return nil
}

func (m *CertificateValidationContext) GetAllowExpiredCertificate() bool {
	if m != nil {
		return m.AllowExpiredCertificate
	}
	return false
}

// TLS context shared by both client and server TLS contexts.
type CommonTlsContext struct {
	// TLS protocol versions, cipher suites etc.
	TlsParams *TlsParameters `protobuf:"bytes,1,opt,name=tls_params,json=tlsParams" json:"tls_params,omitempty"`
	// Multiple TLS certificates can be associated with the same context.
	// E.g. to allow both RSA and ECDSA certificates, two TLS certificates can be configured.
	//
	// .. attention::
	//
	//   Although this is a list, currently only a single certificate is supported. This will be
	//   relaxed in the future.
	TlsCertificates []*TlsCertificate `protobuf:"bytes,2,rep,name=tls_certificates,json=tlsCertificates" json:"tls_certificates,omitempty"`
	// [#not-implemented-hide:]
	TlsCertificateSdsSecretConfigs []*SdsSecretConfig `protobuf:"bytes,6,rep,name=tls_certificate_sds_secret_configs,json=tlsCertificateSdsSecretConfigs" json:"tls_certificate_sds_secret_configs,omitempty"`
	// Types that are valid to be assigned to ValidationContextType:
	//	*CommonTlsContext_ValidationContext
	//	*CommonTlsContext_ValidationContextSdsSecretConfig
	ValidationContextType isCommonTlsContext_ValidationContextType `protobuf_oneof:"validation_context_type"`
	// Supplies the list of ALPN protocols that the listener should expose. In
	// practice this is likely to be set to one of two values (see the
	// :ref:`codec_type <config_http_conn_man_codec_type>` parameter in the HTTP connection
	// manager for more information):
	//
	// * "h2,http/1.1" If the listener is going to support both HTTP/2 and HTTP/1.1.
	// * "http/1.1" If the listener is only going to support HTTP/1.1.
	//
	// There is no default for this parameter. If empty, Envoy will not expose ALPN.
	AlpnProtocols []string `protobuf:"bytes,4,rep,name=alpn_protocols,json=alpnProtocols" json:"alpn_protocols,omitempty"`
	// [#not-implemented-hide:]
	DeprecatedV1         *CommonTlsContext_DeprecatedV1 `protobuf:"bytes,5,opt,name=deprecated_v1,json=deprecatedV1" json:"deprecated_v1,omitempty"` // Deprecated: Do not use.
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *CommonTlsContext) Reset()         { *m = CommonTlsContext{} }
func (m *CommonTlsContext) String() string { return proto.CompactTextString(m) }
func (*CommonTlsContext) ProtoMessage()    {}
func (*CommonTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{4}
}
func (m *CommonTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommonTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommonTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CommonTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonTlsContext.Merge(dst, src)
}
func (m *CommonTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *CommonTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_CommonTlsContext proto.InternalMessageInfo

type isCommonTlsContext_ValidationContextType interface {
	isCommonTlsContext_ValidationContextType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type CommonTlsContext_ValidationContext struct {
	ValidationContext *CertificateValidationContext `protobuf:"bytes,3,opt,name=validation_context,json=validationContext,oneof"`
}
type CommonTlsContext_ValidationContextSdsSecretConfig struct {
	ValidationContextSdsSecretConfig *SdsSecretConfig `protobuf:"bytes,7,opt,name=validation_context_sds_secret_config,json=validationContextSdsSecretConfig,oneof"`
}

func (*CommonTlsContext_ValidationContext) isCommonTlsContext_ValidationContextType()                {}
func (*CommonTlsContext_ValidationContextSdsSecretConfig) isCommonTlsContext_ValidationContextType() {}

func (m *CommonTlsContext) GetValidationContextType() isCommonTlsContext_ValidationContextType {
	if m != nil {
		return m.ValidationContextType
	}
	return nil
}

func (m *CommonTlsContext) GetTlsParams() *TlsParameters {
	if m != nil {
		return m.TlsParams
	}
	return nil
}

func (m *CommonTlsContext) GetTlsCertificates() []*TlsCertificate {
	if m != nil {
		return m.TlsCertificates
	}
	return nil
}

func (m *CommonTlsContext) GetTlsCertificateSdsSecretConfigs() []*SdsSecretConfig {
	if m != nil {
		return m.TlsCertificateSdsSecretConfigs
	}
	return nil
}

func (m *CommonTlsContext) GetValidationContext() *CertificateValidationContext {
	if x, ok := m.GetValidationContextType().(*CommonTlsContext_ValidationContext); ok {
		return x.ValidationContext
	}
	return nil
}

func (m *CommonTlsContext) GetValidationContextSdsSecretConfig() *SdsSecretConfig {
	if x, ok := m.GetValidationContextType().(*CommonTlsContext_ValidationContextSdsSecretConfig); ok {
		return x.ValidationContextSdsSecretConfig
	}
	return nil
}

func (m *CommonTlsContext) GetAlpnProtocols() []string {
	if m != nil {
		return m.AlpnProtocols
	}
	return nil
}

// Deprecated: Do not use.
func (m *CommonTlsContext) GetDeprecatedV1() *CommonTlsContext_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CommonTlsContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CommonTlsContext_OneofMarshaler, _CommonTlsContext_OneofUnmarshaler, _CommonTlsContext_OneofSizer, []interface{}{
		(*CommonTlsContext_ValidationContext)(nil),
		(*CommonTlsContext_ValidationContextSdsSecretConfig)(nil),
	}
}

func _CommonTlsContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CommonTlsContext)
	// validation_context_type
	switch x := m.ValidationContextType.(type) {
	case *CommonTlsContext_ValidationContext:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContext); err != nil {
			return err
		}
	case *CommonTlsContext_ValidationContextSdsSecretConfig:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContextSdsSecretConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CommonTlsContext.ValidationContextType has unexpected type %T", x)
	}
	return nil
}

func _CommonTlsContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CommonTlsContext)
	switch tag {
	case 3: // validation_context_type.validation_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CertificateValidationContext)
		err := b.DecodeMessage(msg)
		m.ValidationContextType = &CommonTlsContext_ValidationContext{msg}
		return true, err
	case 7: // validation_context_type.validation_context_sds_secret_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdsSecretConfig)
		err := b.DecodeMessage(msg)
		m.ValidationContextType = &CommonTlsContext_ValidationContextSdsSecretConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CommonTlsContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CommonTlsContext)
	// validation_context_type
	switch x := m.ValidationContextType.(type) {
	case *CommonTlsContext_ValidationContext:
		s := proto.Size(x.ValidationContext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CommonTlsContext_ValidationContextSdsSecretConfig:
		s := proto.Size(x.ValidationContextSdsSecretConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// These fields are deprecated and only are used during the interim v1 -> v2
// transition period for internal purposes. They should not be used outside of
// the Envoy binary. [#not-implemented-hide:]
type CommonTlsContext_DeprecatedV1 struct {
	AltAlpnProtocols     string   `protobuf:"bytes,1,opt,name=alt_alpn_protocols,json=altAlpnProtocols,proto3" json:"alt_alpn_protocols,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CommonTlsContext_DeprecatedV1) Reset()         { *m = CommonTlsContext_DeprecatedV1{} }
func (m *CommonTlsContext_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*CommonTlsContext_DeprecatedV1) ProtoMessage()    {}
func (*CommonTlsContext_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{4, 0}
}
func (m *CommonTlsContext_DeprecatedV1) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommonTlsContext_DeprecatedV1) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommonTlsContext_DeprecatedV1.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *CommonTlsContext_DeprecatedV1) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonTlsContext_DeprecatedV1.Merge(dst, src)
}
func (m *CommonTlsContext_DeprecatedV1) XXX_Size() int {
	return m.Size()
}
func (m *CommonTlsContext_DeprecatedV1) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonTlsContext_DeprecatedV1.DiscardUnknown(m)
}

var xxx_messageInfo_CommonTlsContext_DeprecatedV1 proto.InternalMessageInfo

func (m *CommonTlsContext_DeprecatedV1) GetAltAlpnProtocols() string {
	if m != nil {
		return m.AltAlpnProtocols
	}
	return ""
}

type UpstreamTlsContext struct {
	// Common TLS context settings.
	CommonTlsContext *CommonTlsContext `protobuf:"bytes,1,opt,name=common_tls_context,json=commonTlsContext" json:"common_tls_context,omitempty"`
	// SNI string to use when creating TLS backend connections.
	Sni string `protobuf:"bytes,2,opt,name=sni,proto3" json:"sni,omitempty"`
	// If true, server-initiated TLS renegotiation will be allowed.
	//
	// .. attention::
	//
	//   TLS renegotiation is considered insecure and shouldn't be used unless absolutely necessary.
	AllowRenegotiation   bool     `protobuf:"varint,3,opt,name=allow_renegotiation,json=allowRenegotiation,proto3" json:"allow_renegotiation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpstreamTlsContext) Reset()         { *m = UpstreamTlsContext{} }
func (m *UpstreamTlsContext) String() string { return proto.CompactTextString(m) }
func (*UpstreamTlsContext) ProtoMessage()    {}
func (*UpstreamTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{5}
}
func (m *UpstreamTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpstreamTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpstreamTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *UpstreamTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpstreamTlsContext.Merge(dst, src)
}
func (m *UpstreamTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *UpstreamTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_UpstreamTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_UpstreamTlsContext proto.InternalMessageInfo

func (m *UpstreamTlsContext) GetCommonTlsContext() *CommonTlsContext {
	if m != nil {
		return m.CommonTlsContext
	}
	return nil
}

func (m *UpstreamTlsContext) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

func (m *UpstreamTlsContext) GetAllowRenegotiation() bool {
	if m != nil {
		return m.AllowRenegotiation
	}
	return false
}

type DownstreamTlsContext struct {
	// Common TLS context settings.
	CommonTlsContext *CommonTlsContext `protobuf:"bytes,1,opt,name=common_tls_context,json=commonTlsContext" json:"common_tls_context,omitempty"`
	// If specified, Envoy will reject connections without a valid client
	// certificate.
	RequireClientCertificate *types.BoolValue `protobuf:"bytes,2,opt,name=require_client_certificate,json=requireClientCertificate" json:"require_client_certificate,omitempty"`
	// If specified, Envoy will reject connections without a valid and matching SNI.
	// [#not-implemented-hide:]
	RequireSni *types.BoolValue `protobuf:"bytes,3,opt,name=require_sni,json=requireSni" json:"require_sni,omitempty"`
	// Types that are valid to be assigned to SessionTicketKeysType:
	//	*DownstreamTlsContext_SessionTicketKeys
	//	*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig
	SessionTicketKeysType isDownstreamTlsContext_SessionTicketKeysType `protobuf_oneof:"session_ticket_keys_type"`
	XXX_NoUnkeyedLiteral  struct{}                                     `json:"-"`
	XXX_unrecognized      []byte                                       `json:"-"`
	XXX_sizecache         int32                                        `json:"-"`
}

func (m *DownstreamTlsContext) Reset()         { *m = DownstreamTlsContext{} }
func (m *DownstreamTlsContext) String() string { return proto.CompactTextString(m) }
func (*DownstreamTlsContext) ProtoMessage()    {}
func (*DownstreamTlsContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{6}
}
func (m *DownstreamTlsContext) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DownstreamTlsContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DownstreamTlsContext.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *DownstreamTlsContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DownstreamTlsContext.Merge(dst, src)
}
func (m *DownstreamTlsContext) XXX_Size() int {
	return m.Size()
}
func (m *DownstreamTlsContext) XXX_DiscardUnknown() {
	xxx_messageInfo_DownstreamTlsContext.DiscardUnknown(m)
}

var xxx_messageInfo_DownstreamTlsContext proto.InternalMessageInfo

type isDownstreamTlsContext_SessionTicketKeysType interface {
	isDownstreamTlsContext_SessionTicketKeysType()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type DownstreamTlsContext_SessionTicketKeys struct {
	SessionTicketKeys *TlsSessionTicketKeys `protobuf:"bytes,4,opt,name=session_ticket_keys,json=sessionTicketKeys,oneof"`
}
type DownstreamTlsContext_SessionTicketKeysSdsSecretConfig struct {
	SessionTicketKeysSdsSecretConfig *SdsSecretConfig `protobuf:"bytes,5,opt,name=session_ticket_keys_sds_secret_config,json=sessionTicketKeysSdsSecretConfig,oneof"`
}

func (*DownstreamTlsContext_SessionTicketKeys) isDownstreamTlsContext_SessionTicketKeysType() {}
func (*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) isDownstreamTlsContext_SessionTicketKeysType() {
}

func (m *DownstreamTlsContext) GetSessionTicketKeysType() isDownstreamTlsContext_SessionTicketKeysType {
	if m != nil {
		return m.SessionTicketKeysType
	}
	return nil
}

func (m *DownstreamTlsContext) GetCommonTlsContext() *CommonTlsContext {
	if m != nil {
		return m.CommonTlsContext
	}
	return nil
}

func (m *DownstreamTlsContext) GetRequireClientCertificate() *types.BoolValue {
	if m != nil {
		return m.RequireClientCertificate
	}
	return nil
}

func (m *DownstreamTlsContext) GetRequireSni() *types.BoolValue {
	if m != nil {
		return m.RequireSni
	}
	return nil
}

func (m *DownstreamTlsContext) GetSessionTicketKeys() *TlsSessionTicketKeys {
	if x, ok := m.GetSessionTicketKeysType().(*DownstreamTlsContext_SessionTicketKeys); ok {
		return x.SessionTicketKeys
	}
	return nil
}

func (m *DownstreamTlsContext) GetSessionTicketKeysSdsSecretConfig() *SdsSecretConfig {
	if x, ok := m.GetSessionTicketKeysType().(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig); ok {
		return x.SessionTicketKeysSdsSecretConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DownstreamTlsContext) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DownstreamTlsContext_OneofMarshaler, _DownstreamTlsContext_OneofUnmarshaler, _DownstreamTlsContext_OneofSizer, []interface{}{
		(*DownstreamTlsContext_SessionTicketKeys)(nil),
		(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)(nil),
	}
}

func _DownstreamTlsContext_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DownstreamTlsContext)
	// session_ticket_keys_type
	switch x := m.SessionTicketKeysType.(type) {
	case *DownstreamTlsContext_SessionTicketKeys:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeys); err != nil {
			return err
		}
	case *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeysSdsSecretConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DownstreamTlsContext.SessionTicketKeysType has unexpected type %T", x)
	}
	return nil
}

func _DownstreamTlsContext_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DownstreamTlsContext)
	switch tag {
	case 4: // session_ticket_keys_type.session_ticket_keys
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsSessionTicketKeys)
		err := b.DecodeMessage(msg)
		m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeys{msg}
		return true, err
	case 5: // session_ticket_keys_type.session_ticket_keys_sds_secret_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SdsSecretConfig)
		err := b.DecodeMessage(msg)
		m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeysSdsSecretConfig{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DownstreamTlsContext_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DownstreamTlsContext)
	// session_ticket_keys_type
	switch x := m.SessionTicketKeysType.(type) {
	case *DownstreamTlsContext_SessionTicketKeys:
		s := proto.Size(x.SessionTicketKeys)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig:
		s := proto.Size(x.SessionTicketKeysSdsSecretConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// [#proto-status: experimental]
// [#not-implemented-hide:]
type SdsSecretConfig struct {
	// Name (FQDN, UUID, SPKI, SHA256, etc.) by which the secret can be uniquely referred to.
	// When both name and config are specified, then secret can be fetched and/or reloaded via SDS.
	// When only name is specified, then secret will be loaded from static resources [V2-API-DIFF].
	Name                 string             `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	SdsConfig            *core.ConfigSource `protobuf:"bytes,2,opt,name=sds_config,json=sdsConfig" json:"sds_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SdsSecretConfig) Reset()         { *m = SdsSecretConfig{} }
func (m *SdsSecretConfig) String() string { return proto.CompactTextString(m) }
func (*SdsSecretConfig) ProtoMessage()    {}
func (*SdsSecretConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{7}
}
func (m *SdsSecretConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SdsSecretConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SdsSecretConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *SdsSecretConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SdsSecretConfig.Merge(dst, src)
}
func (m *SdsSecretConfig) XXX_Size() int {
	return m.Size()
}
func (m *SdsSecretConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SdsSecretConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SdsSecretConfig proto.InternalMessageInfo

func (m *SdsSecretConfig) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SdsSecretConfig) GetSdsConfig() *core.ConfigSource {
	if m != nil {
		return m.SdsConfig
	}
	return nil
}

// [#proto-status: experimental]
// [#not-implemented-hide:]
type Secret struct {
	// Name (FQDN, UUID, SPKI, SHA256, etc.) by which the secret can be uniquely referred to.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Types that are valid to be assigned to Type:
	//	*Secret_TlsCertificate
	//	*Secret_SessionTicketKeys
	//	*Secret_ValidationContext
	Type                 isSecret_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_cert_fc672aebbb250fdd, []int{8}
}
func (m *Secret) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (dst *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(dst, src)
}
func (m *Secret) XXX_Size() int {
	return m.Size()
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

type isSecret_Type interface {
	isSecret_Type()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Secret_TlsCertificate struct {
	TlsCertificate *TlsCertificate `protobuf:"bytes,2,opt,name=tls_certificate,json=tlsCertificate,oneof"`
}
type Secret_SessionTicketKeys struct {
	SessionTicketKeys *TlsSessionTicketKeys `protobuf:"bytes,3,opt,name=session_ticket_keys,json=sessionTicketKeys,oneof"`
}
type Secret_ValidationContext struct {
	ValidationContext *CertificateValidationContext `protobuf:"bytes,4,opt,name=validation_context,json=validationContext,oneof"`
}

func (*Secret_TlsCertificate) isSecret_Type()    {}
func (*Secret_SessionTicketKeys) isSecret_Type() {}
func (*Secret_ValidationContext) isSecret_Type() {}

func (m *Secret) GetType() isSecret_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *Secret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret) GetTlsCertificate() *TlsCertificate {
	if x, ok := m.GetType().(*Secret_TlsCertificate); ok {
		return x.TlsCertificate
	}
	return nil
}

func (m *Secret) GetSessionTicketKeys() *TlsSessionTicketKeys {
	if x, ok := m.GetType().(*Secret_SessionTicketKeys); ok {
		return x.SessionTicketKeys
	}
	return nil
}

func (m *Secret) GetValidationContext() *CertificateValidationContext {
	if x, ok := m.GetType().(*Secret_ValidationContext); ok {
		return x.ValidationContext
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Secret) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Secret_OneofMarshaler, _Secret_OneofUnmarshaler, _Secret_OneofSizer, []interface{}{
		(*Secret_TlsCertificate)(nil),
		(*Secret_SessionTicketKeys)(nil),
		(*Secret_ValidationContext)(nil),
	}
}

func _Secret_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Secret)
	// type
	switch x := m.Type.(type) {
	case *Secret_TlsCertificate:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TlsCertificate); err != nil {
			return err
		}
	case *Secret_SessionTicketKeys:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SessionTicketKeys); err != nil {
			return err
		}
	case *Secret_ValidationContext:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ValidationContext); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Secret.Type has unexpected type %T", x)
	}
	return nil
}

func _Secret_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Secret)
	switch tag {
	case 2: // type.tls_certificate
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsCertificate)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_TlsCertificate{msg}
		return true, err
	case 3: // type.session_ticket_keys
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TlsSessionTicketKeys)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_SessionTicketKeys{msg}
		return true, err
	case 4: // type.validation_context
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CertificateValidationContext)
		err := b.DecodeMessage(msg)
		m.Type = &Secret_ValidationContext{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Secret_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Secret)
	// type
	switch x := m.Type.(type) {
	case *Secret_TlsCertificate:
		s := proto.Size(x.TlsCertificate)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Secret_SessionTicketKeys:
		s := proto.Size(x.SessionTicketKeys)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Secret_ValidationContext:
		s := proto.Size(x.ValidationContext)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*TlsParameters)(nil), "envoy.api.v2.auth.TlsParameters")
	proto.RegisterType((*TlsCertificate)(nil), "envoy.api.v2.auth.TlsCertificate")
	proto.RegisterType((*TlsSessionTicketKeys)(nil), "envoy.api.v2.auth.TlsSessionTicketKeys")
	proto.RegisterType((*CertificateValidationContext)(nil), "envoy.api.v2.auth.CertificateValidationContext")
	proto.RegisterType((*CommonTlsContext)(nil), "envoy.api.v2.auth.CommonTlsContext")
	proto.RegisterType((*CommonTlsContext_DeprecatedV1)(nil), "envoy.api.v2.auth.CommonTlsContext.DeprecatedV1")
	proto.RegisterType((*UpstreamTlsContext)(nil), "envoy.api.v2.auth.UpstreamTlsContext")
	proto.RegisterType((*DownstreamTlsContext)(nil), "envoy.api.v2.auth.DownstreamTlsContext")
	proto.RegisterType((*SdsSecretConfig)(nil), "envoy.api.v2.auth.SdsSecretConfig")
	proto.RegisterType((*Secret)(nil), "envoy.api.v2.auth.Secret")
	proto.RegisterEnum("envoy.api.v2.auth.TlsParameters_TlsProtocol", TlsParameters_TlsProtocol_name, TlsParameters_TlsProtocol_value)
}
func (this *TlsParameters) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsParameters)
	if !ok {
		that2, ok := that.(TlsParameters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TlsMinimumProtocolVersion != that1.TlsMinimumProtocolVersion {
		return false
	}
	if this.TlsMaximumProtocolVersion != that1.TlsMaximumProtocolVersion {
		return false
	}
	if len(this.CipherSuites) != len(that1.CipherSuites) {
		return false
	}
	for i := range this.CipherSuites {
		if this.CipherSuites[i] != that1.CipherSuites[i] {
			return false
		}
	}
	if len(this.EcdhCurves) != len(that1.EcdhCurves) {
		return false
	}
	for i := range this.EcdhCurves {
		if this.EcdhCurves[i] != that1.EcdhCurves[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TlsCertificate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsCertificate)
	if !ok {
		that2, ok := that.(TlsCertificate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CertificateChain.Equal(that1.CertificateChain) {
		return false
	}
	if !this.PrivateKey.Equal(that1.PrivateKey) {
		return false
	}
	if !this.Password.Equal(that1.Password) {
		return false
	}
	if !this.OcspStaple.Equal(that1.OcspStaple) {
		return false
	}
	if len(this.SignedCertificateTimestamp) != len(that1.SignedCertificateTimestamp) {
		return false
	}
	for i := range this.SignedCertificateTimestamp {
		if !this.SignedCertificateTimestamp[i].Equal(that1.SignedCertificateTimestamp[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *TlsSessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TlsSessionTicketKeys)
	if !ok {
		that2, ok := that.(TlsSessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if !this.Keys[i].Equal(that1.Keys[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CertificateValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CertificateValidationContext)
	if !ok {
		that2, ok := that.(CertificateValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TrustedCa.Equal(that1.TrustedCa) {
		return false
	}
	if len(this.VerifyCertificateSpki) != len(that1.VerifyCertificateSpki) {
		return false
	}
	for i := range this.VerifyCertificateSpki {
		if this.VerifyCertificateSpki[i] != that1.VerifyCertificateSpki[i] {
			return false
		}
	}
	if len(this.VerifyCertificateHash) != len(that1.VerifyCertificateHash) {
		return false
	}
	for i := range this.VerifyCertificateHash {
		if this.VerifyCertificateHash[i] != that1.VerifyCertificateHash[i] {
			return false
		}
	}
	if len(this.VerifySubjectAltName) != len(that1.VerifySubjectAltName) {
		return false
	}
	for i := range this.VerifySubjectAltName {
		if this.VerifySubjectAltName[i] != that1.VerifySubjectAltName[i] {
			return false
		}
	}
	if !this.RequireOcspStaple.Equal(that1.RequireOcspStaple) {
		return false
	}
	if !this.RequireSignedCertificateTimestamp.Equal(that1.RequireSignedCertificateTimestamp) {
		return false
	}
	if !this.Crl.Equal(that1.Crl) {
		return false
	}
	if this.AllowExpiredCertificate != that1.AllowExpiredCertificate {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommonTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext)
	if !ok {
		that2, ok := that.(CommonTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TlsParams.Equal(that1.TlsParams) {
		return false
	}
	if len(this.TlsCertificates) != len(that1.TlsCertificates) {
		return false
	}
	for i := range this.TlsCertificates {
		if !this.TlsCertificates[i].Equal(that1.TlsCertificates[i]) {
			return false
		}
	}
	if len(this.TlsCertificateSdsSecretConfigs) != len(that1.TlsCertificateSdsSecretConfigs) {
		return false
	}
	for i := range this.TlsCertificateSdsSecretConfigs {
		if !this.TlsCertificateSdsSecretConfigs[i].Equal(that1.TlsCertificateSdsSecretConfigs[i]) {
			return false
		}
	}
	if that1.ValidationContextType == nil {
		if this.ValidationContextType != nil {
			return false
		}
	} else if this.ValidationContextType == nil {
		return false
	} else if !this.ValidationContextType.Equal(that1.ValidationContextType) {
		return false
	}
	if len(this.AlpnProtocols) != len(that1.AlpnProtocols) {
		return false
	}
	for i := range this.AlpnProtocols {
		if this.AlpnProtocols[i] != that1.AlpnProtocols[i] {
			return false
		}
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CommonTlsContext_ValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_ValidationContext)
	if !ok {
		that2, ok := that.(CommonTlsContext_ValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContext.Equal(that1.ValidationContext) {
		return false
	}
	return true
}
func (this *CommonTlsContext_ValidationContextSdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_ValidationContextSdsSecretConfig)
	if !ok {
		that2, ok := that.(CommonTlsContext_ValidationContextSdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContextSdsSecretConfig.Equal(that1.ValidationContextSdsSecretConfig) {
		return false
	}
	return true
}
func (this *CommonTlsContext_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CommonTlsContext_DeprecatedV1)
	if !ok {
		that2, ok := that.(CommonTlsContext_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.AltAlpnProtocols != that1.AltAlpnProtocols {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *UpstreamTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*UpstreamTlsContext)
	if !ok {
		that2, ok := that.(UpstreamTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CommonTlsContext.Equal(that1.CommonTlsContext) {
		return false
	}
	if this.Sni != that1.Sni {
		return false
	}
	if this.AllowRenegotiation != that1.AllowRenegotiation {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext)
	if !ok {
		that2, ok := that.(DownstreamTlsContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.CommonTlsContext.Equal(that1.CommonTlsContext) {
		return false
	}
	if !this.RequireClientCertificate.Equal(that1.RequireClientCertificate) {
		return false
	}
	if !this.RequireSni.Equal(that1.RequireSni) {
		return false
	}
	if that1.SessionTicketKeysType == nil {
		if this.SessionTicketKeysType != nil {
			return false
		}
	} else if this.SessionTicketKeysType == nil {
		return false
	} else if !this.SessionTicketKeysType.Equal(that1.SessionTicketKeysType) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext_SessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext_SessionTicketKeys)
	if !ok {
		that2, ok := that.(DownstreamTlsContext_SessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeys.Equal(that1.SessionTicketKeys) {
		return false
	}
	return true
}
func (this *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)
	if !ok {
		that2, ok := that.(DownstreamTlsContext_SessionTicketKeysSdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeysSdsSecretConfig.Equal(that1.SessionTicketKeysSdsSecretConfig) {
		return false
	}
	return true
}
func (this *SdsSecretConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SdsSecretConfig)
	if !ok {
		that2, ok := that.(SdsSecretConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.SdsConfig.Equal(that1.SdsConfig) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Secret) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret)
	if !ok {
		that2, ok := that.(Secret)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if that1.Type == nil {
		if this.Type != nil {
			return false
		}
	} else if this.Type == nil {
		return false
	} else if !this.Type.Equal(that1.Type) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Secret_TlsCertificate) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_TlsCertificate)
	if !ok {
		that2, ok := that.(Secret_TlsCertificate)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TlsCertificate.Equal(that1.TlsCertificate) {
		return false
	}
	return true
}
func (this *Secret_SessionTicketKeys) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_SessionTicketKeys)
	if !ok {
		that2, ok := that.(Secret_SessionTicketKeys)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.SessionTicketKeys.Equal(that1.SessionTicketKeys) {
		return false
	}
	return true
}
func (this *Secret_ValidationContext) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Secret_ValidationContext)
	if !ok {
		that2, ok := that.(Secret_ValidationContext)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ValidationContext.Equal(that1.ValidationContext) {
		return false
	}
	return true
}
func (m *TlsParameters) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsParameters) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TlsMinimumProtocolVersion != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsMinimumProtocolVersion))
	}
	if m.TlsMaximumProtocolVersion != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsMaximumProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.EcdhCurves) > 0 {
		for _, s := range m.EcdhCurves {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TlsCertificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsCertificate) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CertificateChain != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CertificateChain.Size()))
		n1, err := m.CertificateChain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.PrivateKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.PrivateKey.Size()))
		n2, err := m.PrivateKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.Password != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.Password.Size()))
		n3, err := m.Password.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.OcspStaple != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.OcspStaple.Size()))
		n4, err := m.OcspStaple.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if len(m.SignedCertificateTimestamp) > 0 {
		for _, msg := range m.SignedCertificateTimestamp {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TlsSessionTicketKeys) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TlsSessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0xa
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CertificateValidationContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CertificateValidationContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TrustedCa != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TrustedCa.Size()))
		n5, err := m.TrustedCa.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.VerifySubjectAltName) > 0 {
		for _, s := range m.VerifySubjectAltName {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.RequireOcspStaple != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireOcspStaple.Size()))
		n6, err := m.RequireOcspStaple.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.RequireSignedCertificateTimestamp != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireSignedCertificateTimestamp.Size()))
		n7, err := m.RequireSignedCertificateTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Crl != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.Crl.Size()))
		n8, err := m.Crl.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.AllowExpiredCertificate {
		dAtA[i] = 0x40
		i++
		if m.AllowExpiredCertificate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommonTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommonTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TlsParams != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsParams.Size()))
		n9, err := m.TlsParams.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.TlsCertificates) > 0 {
		for _, msg := range m.TlsCertificates {
			dAtA[i] = 0x12
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ValidationContextType != nil {
		nn10, err := m.ValidationContextType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn10
	}
	if len(m.AlpnProtocols) > 0 {
		for _, s := range m.AlpnProtocols {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n11, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if len(m.TlsCertificateSdsSecretConfigs) > 0 {
		for _, msg := range m.TlsCertificateSdsSecretConfigs {
			dAtA[i] = 0x32
			i++
			i = encodeVarintCert(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *CommonTlsContext_ValidationContext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContext != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContext.Size()))
		n12, err := m.ValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *CommonTlsContext_ValidationContextSdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContextSdsSecretConfig != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContextSdsSecretConfig.Size()))
		n13, err := m.ValidationContextSdsSecretConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *CommonTlsContext_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommonTlsContext_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AltAlpnProtocols) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.AltAlpnProtocols)))
		i += copy(dAtA[i:], m.AltAlpnProtocols)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *UpstreamTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CommonTlsContext.Size()))
		n14, err := m.CommonTlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if len(m.Sni) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Sni)))
		i += copy(dAtA[i:], m.Sni)
	}
	if m.AllowRenegotiation {
		dAtA[i] = 0x18
		i++
		if m.AllowRenegotiation {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownstreamTlsContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DownstreamTlsContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.CommonTlsContext.Size()))
		n15, err := m.CommonTlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.RequireClientCertificate != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireClientCertificate.Size()))
		n16, err := m.RequireClientCertificate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.RequireSni != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.RequireSni.Size()))
		n17, err := m.RequireSni.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.SessionTicketKeysType != nil {
		nn18, err := m.SessionTicketKeysType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn18
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *DownstreamTlsContext_SessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeys != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeys.Size()))
		n19, err := m.SessionTicketKeys.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}
func (m *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeysSdsSecretConfig != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeysSdsSecretConfig.Size()))
		n20, err := m.SessionTicketKeysSdsSecretConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	return i, nil
}
func (m *SdsSecretConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SdsSecretConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.SdsConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SdsConfig.Size()))
		n21, err := m.SdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Secret) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Secret) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCert(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Type != nil {
		nn22, err := m.Type.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn22
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Secret_TlsCertificate) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TlsCertificate != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.TlsCertificate.Size()))
		n23, err := m.TlsCertificate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}
func (m *Secret_SessionTicketKeys) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SessionTicketKeys != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.SessionTicketKeys.Size()))
		n24, err := m.SessionTicketKeys.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}
func (m *Secret_ValidationContext) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ValidationContext != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintCert(dAtA, i, uint64(m.ValidationContext.Size()))
		n25, err := m.ValidationContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	return i, nil
}
func encodeVarintCert(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *TlsParameters) Size() (n int) {
	var l int
	_ = l
	if m.TlsMinimumProtocolVersion != 0 {
		n += 1 + sovCert(uint64(m.TlsMinimumProtocolVersion))
	}
	if m.TlsMaximumProtocolVersion != 0 {
		n += 1 + sovCert(uint64(m.TlsMaximumProtocolVersion))
	}
	if len(m.CipherSuites) > 0 {
		for _, s := range m.CipherSuites {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.EcdhCurves) > 0 {
		for _, s := range m.EcdhCurves {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TlsCertificate) Size() (n int) {
	var l int
	_ = l
	if m.CertificateChain != nil {
		l = m.CertificateChain.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.PrivateKey != nil {
		l = m.PrivateKey.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Password != nil {
		l = m.Password.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.OcspStaple != nil {
		l = m.OcspStaple.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.SignedCertificateTimestamp) > 0 {
		for _, e := range m.SignedCertificateTimestamp {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TlsSessionTicketKeys) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CertificateValidationContext) Size() (n int) {
	var l int
	_ = l
	if m.TrustedCa != nil {
		l = m.TrustedCa.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.VerifyCertificateHash) > 0 {
		for _, s := range m.VerifyCertificateHash {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.VerifyCertificateSpki) > 0 {
		for _, s := range m.VerifyCertificateSpki {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if len(m.VerifySubjectAltName) > 0 {
		for _, s := range m.VerifySubjectAltName {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.RequireOcspStaple != nil {
		l = m.RequireOcspStaple.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireSignedCertificateTimestamp != nil {
		l = m.RequireSignedCertificateTimestamp.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Crl != nil {
		l = m.Crl.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.AllowExpiredCertificate {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommonTlsContext) Size() (n int) {
	var l int
	_ = l
	if m.TlsParams != nil {
		l = m.TlsParams.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.TlsCertificates) > 0 {
		for _, e := range m.TlsCertificates {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.ValidationContextType != nil {
		n += m.ValidationContextType.Size()
	}
	if len(m.AlpnProtocols) > 0 {
		for _, s := range m.AlpnProtocols {
			l = len(s)
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if len(m.TlsCertificateSdsSecretConfigs) > 0 {
		for _, e := range m.TlsCertificateSdsSecretConfigs {
			l = e.Size()
			n += 1 + l + sovCert(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CommonTlsContext_ValidationContext) Size() (n int) {
	var l int
	_ = l
	if m.ValidationContext != nil {
		l = m.ValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *CommonTlsContext_ValidationContextSdsSecretConfig) Size() (n int) {
	var l int
	_ = l
	if m.ValidationContextSdsSecretConfig != nil {
		l = m.ValidationContextSdsSecretConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *CommonTlsContext_DeprecatedV1) Size() (n int) {
	var l int
	_ = l
	l = len(m.AltAlpnProtocols)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *UpstreamTlsContext) Size() (n int) {
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		l = m.CommonTlsContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.AllowRenegotiation {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownstreamTlsContext) Size() (n int) {
	var l int
	_ = l
	if m.CommonTlsContext != nil {
		l = m.CommonTlsContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireClientCertificate != nil {
		l = m.RequireClientCertificate.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.RequireSni != nil {
		l = m.RequireSni.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.SessionTicketKeysType != nil {
		n += m.SessionTicketKeysType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DownstreamTlsContext_SessionTicketKeys) Size() (n int) {
	var l int
	_ = l
	if m.SessionTicketKeys != nil {
		l = m.SessionTicketKeys.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *DownstreamTlsContext_SessionTicketKeysSdsSecretConfig) Size() (n int) {
	var l int
	_ = l
	if m.SessionTicketKeysSdsSecretConfig != nil {
		l = m.SessionTicketKeysSdsSecretConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *SdsSecretConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.SdsConfig != nil {
		l = m.SdsConfig.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Secret) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCert(uint64(l))
	}
	if m.Type != nil {
		n += m.Type.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Secret_TlsCertificate) Size() (n int) {
	var l int
	_ = l
	if m.TlsCertificate != nil {
		l = m.TlsCertificate.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *Secret_SessionTicketKeys) Size() (n int) {
	var l int
	_ = l
	if m.SessionTicketKeys != nil {
		l = m.SessionTicketKeys.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}
func (m *Secret_ValidationContext) Size() (n int) {
	var l int
	_ = l
	if m.ValidationContext != nil {
		l = m.ValidationContext.Size()
		n += 1 + l + sovCert(uint64(l))
	}
	return n
}

func sovCert(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCert(x uint64) (n int) {
	return sovCert(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TlsParameters) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsParameters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsParameters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsMinimumProtocolVersion", wireType)
			}
			m.TlsMinimumProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TlsMinimumProtocolVersion |= (TlsParameters_TlsProtocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsMaximumProtocolVersion", wireType)
			}
			m.TlsMaximumProtocolVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TlsMaximumProtocolVersion |= (TlsParameters_TlsProtocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CipherSuites", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CipherSuites = append(m.CipherSuites, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EcdhCurves", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EcdhCurves = append(m.EcdhCurves, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TlsCertificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsCertificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsCertificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificateChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CertificateChain == nil {
				m.CertificateChain = &core.DataSource{}
			}
			if err := m.CertificateChain.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrivateKey == nil {
				m.PrivateKey = &core.DataSource{}
			}
			if err := m.PrivateKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Password == nil {
				m.Password = &core.DataSource{}
			}
			if err := m.Password.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OcspStaple", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OcspStaple == nil {
				m.OcspStaple = &core.DataSource{}
			}
			if err := m.OcspStaple.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SignedCertificateTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SignedCertificateTimestamp = append(m.SignedCertificateTimestamp, &core.DataSource{})
			if err := m.SignedCertificateTimestamp[len(m.SignedCertificateTimestamp)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TlsSessionTicketKeys) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TlsSessionTicketKeys: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TlsSessionTicketKeys: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, &core.DataSource{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CertificateValidationContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CertificateValidationContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CertificateValidationContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustedCa", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrustedCa == nil {
				m.TrustedCa = &core.DataSource{}
			}
			if err := m.TrustedCa.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateHash", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateHash = append(m.VerifyCertificateHash, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifyCertificateSpki", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifyCertificateSpki = append(m.VerifyCertificateSpki, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VerifySubjectAltName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VerifySubjectAltName = append(m.VerifySubjectAltName, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireOcspStaple", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireOcspStaple == nil {
				m.RequireOcspStaple = &types.BoolValue{}
			}
			if err := m.RequireOcspStaple.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireSignedCertificateTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireSignedCertificateTimestamp == nil {
				m.RequireSignedCertificateTimestamp = &types.BoolValue{}
			}
			if err := m.RequireSignedCertificateTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Crl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Crl == nil {
				m.Crl = &core.DataSource{}
			}
			if err := m.Crl.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowExpiredCertificate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowExpiredCertificate = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommonTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsParams", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsParams == nil {
				m.TlsParams = &TlsParameters{}
			}
			if err := m.TlsParams.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCertificates = append(m.TlsCertificates, &TlsCertificate{})
			if err := m.TlsCertificates[len(m.TlsCertificates)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CertificateValidationContext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ValidationContextType = &CommonTlsContext_ValidationContext{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlpnProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AlpnProtocols = append(m.AlpnProtocols, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &CommonTlsContext_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificateSdsSecretConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCertificateSdsSecretConfigs = append(m.TlsCertificateSdsSecretConfigs, &SdsSecretConfig{})
			if err := m.TlsCertificateSdsSecretConfigs[len(m.TlsCertificateSdsSecretConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContextSdsSecretConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SdsSecretConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ValidationContextType = &CommonTlsContext_ValidationContextSdsSecretConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommonTlsContext_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AltAlpnProtocols", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AltAlpnProtocols = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonTlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonTlsContext == nil {
				m.CommonTlsContext = &CommonTlsContext{}
			}
			if err := m.CommonTlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowRenegotiation", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowRenegotiation = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DownstreamTlsContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DownstreamTlsContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DownstreamTlsContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonTlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonTlsContext == nil {
				m.CommonTlsContext = &CommonTlsContext{}
			}
			if err := m.CommonTlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireClientCertificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireClientCertificate == nil {
				m.RequireClientCertificate = &types.BoolValue{}
			}
			if err := m.RequireClientCertificate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireSni", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequireSni == nil {
				m.RequireSni = &types.BoolValue{}
			}
			if err := m.RequireSni.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsSessionTicketKeys{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeys{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeysSdsSecretConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SdsSecretConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.SessionTicketKeysType = &DownstreamTlsContext_SessionTicketKeysSdsSecretConfig{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SdsSecretConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SdsSecretConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SdsSecretConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SdsConfig == nil {
				m.SdsConfig = &core.ConfigSource{}
			}
			if err := m.SdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Secret) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCert
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Secret: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Secret: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCertificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsCertificate{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_TlsCertificate{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionTicketKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TlsSessionTicketKeys{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_SessionTicketKeys{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidationContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCert
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCert
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CertificateValidationContext{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Type = &Secret_ValidationContext{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCert(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCert
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCert(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCert
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCert
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCert
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCert
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCert(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCert = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCert   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/auth/cert.proto", fileDescriptor_cert_fc672aebbb250fdd) }

var fileDescriptor_cert_fc672aebbb250fdd = []byte{
	// 1252 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0x31, 0x73, 0x1b, 0x45,
	0x14, 0xf6, 0x49, 0xb2, 0x23, 0x3f, 0xd9, 0xce, 0x79, 0x63, 0xf0, 0x45, 0x63, 0x1c, 0x45, 0x49,
	0x06, 0x17, 0x1e, 0x29, 0x76, 0x86, 0x02, 0x08, 0x81, 0x48, 0x61, 0xc6, 0x43, 0x02, 0x81, 0x93,
	0xe2, 0x49, 0x68, 0x96, 0xf5, 0x69, 0x2d, 0x2d, 0x3e, 0xdd, 0x1d, 0xbb, 0xab, 0x73, 0xd4, 0xf2,
	0x13, 0x52, 0xf3, 0x03, 0xe8, 0xe8, 0x28, 0xa8, 0x28, 0x69, 0x98, 0xc9, 0x4f, 0x60, 0xdc, 0xd1,
	0x50, 0xd3, 0xc1, 0xec, 0xee, 0x49, 0x3e, 0x49, 0x97, 0x58, 0xcc, 0x64, 0xe8, 0x6e, 0xf7, 0xbd,
	0xf7, 0xbd, 0xa7, 0xb7, 0xdf, 0xfb, 0x9e, 0x60, 0x8b, 0x06, 0x71, 0x38, 0xac, 0x93, 0x88, 0xd5,
	0xe3, 0xfd, 0x3a, 0x19, 0xc8, 0x5e, 0xdd, 0xa3, 0x5c, 0xd6, 0x22, 0x1e, 0xca, 0x10, 0xad, 0x6b,
	0x6b, 0x8d, 0x44, 0xac, 0x16, 0xef, 0xd7, 0x94, 0xb5, 0x3c, 0x19, 0xe0, 0x85, 0x9c, 0xd6, 0x8f,
	0x88, 0xa0, 0x26, 0xa0, 0x7c, 0x6b, 0xd6, 0xea, 0x85, 0xc1, 0x31, 0xeb, 0x62, 0x11, 0x0e, 0xb8,
	0x37, 0x72, 0xdb, 0xee, 0x86, 0x61, 0xd7, 0xa7, 0x75, 0x7d, 0x3a, 0x1a, 0x1c, 0xd7, 0x4f, 0x39,
	0x89, 0x22, 0xca, 0x45, 0x62, 0xdf, 0x8c, 0x89, 0xcf, 0x3a, 0x44, 0xd2, 0xfa, 0xe8, 0x23, 0x31,
	0x6c, 0x74, 0xc3, 0x6e, 0xa8, 0x3f, 0xeb, 0xea, 0xcb, 0xdc, 0x56, 0x7f, 0xc8, 0xc3, 0x6a, 0xdb,
	0x17, 0x5f, 0x12, 0x4e, 0xfa, 0x54, 0x52, 0x2e, 0xd0, 0x10, 0xb6, 0xa4, 0x2f, 0x70, 0x9f, 0x05,
	0xac, 0x3f, 0xe8, 0x63, 0xed, 0xe6, 0x85, 0x3e, 0x8e, 0x29, 0x17, 0x2c, 0x0c, 0x1c, 0xab, 0x62,
	0xed, 0xac, 0xed, 0xef, 0xd6, 0x66, 0x7e, 0x5f, 0x6d, 0x02, 0x47, 0x9f, 0x92, 0xd8, 0x06, 0xfc,
	0xf2, 0xe7, 0xaf, 0xf9, 0xc5, 0xef, 0xad, 0x9c, 0x6d, 0xb9, 0x57, 0xa5, 0x2f, 0x3e, 0x37, 0xe0,
	0x23, 0xfb, 0xa1, 0x81, 0x1e, 0xa7, 0x26, 0xcf, 0xb3, 0x53, 0xe7, 0xde, 0x44, 0x6a, 0x03, 0x3e,
	0x9d, 0xfa, 0x06, 0xac, 0x7a, 0x2c, 0xea, 0x51, 0x8e, 0xc5, 0x80, 0x49, 0x2a, 0x9c, 0x7c, 0x25,
	0xbf, 0xb3, 0xec, 0xae, 0x98, 0xcb, 0x96, 0xbe, 0x43, 0xd7, 0xa0, 0x44, 0xbd, 0x4e, 0x0f, 0x7b,
	0x03, 0x1e, 0x53, 0xe1, 0x14, 0xb4, 0x0b, 0xa8, 0xab, 0xa6, 0xbe, 0xa9, 0x3e, 0x86, 0x52, 0x2a,
	0x37, 0x5a, 0x81, 0x62, 0xfb, 0x51, 0x0b, 0xdf, 0x7f, 0xd2, 0x7e, 0x6c, 0x2f, 0xa0, 0x12, 0x5c,
	0x6a, 0x3f, 0x6a, 0xc5, 0x7b, 0xf8, 0xb6, 0x6d, 0x9d, 0x1f, 0xf6, 0xec, 0xdc, 0xf9, 0x61, 0xdf,
	0xce, 0x9f, 0x1f, 0xee, 0xd8, 0x85, 0xea, 0xdf, 0x39, 0x58, 0x6b, 0xfb, 0xa2, 0x49, 0xb9, 0x64,
	0xc7, 0xcc, 0x23, 0x92, 0xa2, 0xcf, 0x60, 0xdd, 0x3b, 0x3f, 0x62, 0xaf, 0x47, 0x98, 0x79, 0x94,
	0xd2, 0xfe, 0x3b, 0x93, 0x9d, 0x51, 0x1c, 0xaa, 0x3d, 0x20, 0x92, 0xb4, 0x34, 0x81, 0x5c, 0x3b,
	0x15, 0xd7, 0x54, 0x61, 0xe8, 0x1e, 0x94, 0x22, 0xce, 0x62, 0x85, 0x73, 0x42, 0x87, 0xba, 0xbf,
	0x17, 0xa2, 0x40, 0x12, 0xf1, 0x90, 0x0e, 0xd1, 0xfb, 0x50, 0x8c, 0x88, 0x10, 0xa7, 0x21, 0xef,
	0x38, 0xf9, 0x79, 0x82, 0xc7, 0xee, 0x2a, 0x75, 0xe8, 0x89, 0x08, 0x0b, 0x49, 0x22, 0x9f, 0x3a,
	0x85, 0xb9, 0x52, 0xab, 0x88, 0x96, 0x0e, 0x40, 0x18, 0xb6, 0x04, 0xeb, 0x06, 0xb4, 0x83, 0xd3,
	0xdd, 0x90, 0xac, 0x4f, 0x85, 0x24, 0xfd, 0xc8, 0x59, 0xac, 0xe4, 0x2f, 0x06, 0x2c, 0x1b, 0x88,
	0x54, 0x7b, 0xdb, 0x23, 0x80, 0xea, 0x13, 0xd8, 0x68, 0xfb, 0xa2, 0x45, 0x85, 0xe2, 0x47, 0x9b,
	0x79, 0x27, 0x54, 0x3e, 0xa4, 0x43, 0x81, 0x3e, 0x82, 0xc2, 0x09, 0x1d, 0x0a, 0xc7, 0x9a, 0x23,
	0x41, 0xc2, 0xbe, 0x17, 0x56, 0xae, 0x68, 0xb9, 0x3a, 0xac, 0xfa, 0x7b, 0x01, 0xb6, 0x52, 0xf9,
	0x0e, 0xcd, 0x90, 0xb2, 0x30, 0x68, 0x86, 0x81, 0xa4, 0xcf, 0x25, 0xba, 0x0b, 0x20, 0xf9, 0x40,
	0x48, 0xf5, 0xcb, 0xc8, 0x7c, 0x0f, 0xbb, 0x9c, 0x04, 0x34, 0x09, 0x3a, 0x80, 0xcd, 0x98, 0x72,
	0x76, 0x3c, 0x9c, 0x68, 0x4b, 0x8f, 0x88, 0x9e, 0x93, 0x53, 0x74, 0x6d, 0xd8, 0xaa, 0xa2, 0xd2,
	0x0b, 0xab, 0x58, 0x5d, 0xe2, 0x85, 0xca, 0x27, 0x3b, 0xd8, 0x7d, 0xcb, 0x04, 0xa4, 0x8a, 0x3a,
	0x20, 0xa2, 0xf7, 0x0a, 0x24, 0x11, 0x9d, 0x30, 0x33, 0x1b, 0x53, 0x48, 0xbb, 0x3b, 0xbb, 0x19,
	0x48, 0xad, 0xe8, 0x84, 0xa1, 0xf7, 0xc6, 0x48, 0x62, 0x70, 0xf4, 0x2d, 0xf5, 0x24, 0x26, 0xbe,
	0xc4, 0x01, 0xe9, 0xd3, 0x64, 0x84, 0x36, 0x8c, 0xb9, 0x65, 0xac, 0xf7, 0x7d, 0xf9, 0x05, 0xe9,
	0x2b, 0xa2, 0x5f, 0xe1, 0xf4, 0xbb, 0x01, 0xe3, 0x14, 0xa7, 0x99, 0xb2, 0xa8, 0x3b, 0x52, 0xae,
	0x19, 0x1d, 0xac, 0x8d, 0x74, 0xb0, 0xd6, 0x08, 0x43, 0xff, 0x90, 0xf8, 0x03, 0xea, 0xae, 0x27,
	0x61, 0x8f, 0xcf, 0xd9, 0x72, 0x02, 0x37, 0x47, 0x58, 0xaf, 0x65, 0xcd, 0xd2, 0x85, 0xe0, 0xd7,
	0x13, 0x9c, 0xd6, 0x2b, 0x99, 0x83, 0xea, 0x90, 0xf7, 0xb8, 0xef, 0x5c, 0x9a, 0xe7, 0xe9, 0x94,
	0x27, 0xfa, 0x00, 0xae, 0x12, 0xdf, 0x0f, 0x4f, 0x31, 0x7d, 0x1e, 0x31, 0x3e, 0x59, 0x9c, 0x53,
	0xac, 0x58, 0x3b, 0x45, 0x77, 0x53, 0x3b, 0x7c, 0x6a, 0xec, 0xa9, 0xac, 0xd5, 0x97, 0x8b, 0x60,
	0x37, 0xc3, 0x7e, 0x3f, 0x0c, 0x94, 0x4e, 0x24, 0x1c, 0xfa, 0x18, 0x40, 0x09, 0x69, 0xa4, 0x24,
	0x51, 0x24, 0x1c, 0xaa, 0x5c, 0x24, 0x9b, 0xee, 0xb2, 0x4c, 0x8e, 0x02, 0x3d, 0x05, 0x5b, 0x01,
	0xa4, 0xea, 0x10, 0x9a, 0x3f, 0xa5, 0xfd, 0xeb, 0xd9, 0x30, 0xa9, 0x92, 0xce, 0x49, 0x6f, 0x5b,
	0xee, 0x65, 0x39, 0x61, 0x13, 0xe8, 0x1b, 0x40, 0xf1, 0x98, 0xf3, 0xd8, 0x33, 0x05, 0x27, 0xe2,
	0x51, 0xcf, 0xc0, 0x7e, 0xdd, 0xac, 0x1c, 0x2c, 0xb8, 0xeb, 0xf1, 0xcc, 0x00, 0xdd, 0x82, 0x35,
	0xe2, 0x47, 0xc1, 0x78, 0x7d, 0x8c, 0x84, 0x7a, 0x55, 0xdd, 0x8e, 0xb4, 0x59, 0xa0, 0x67, 0xb0,
	0xda, 0xa1, 0x11, 0xa7, 0x0a, 0xb9, 0x83, 0xe3, 0xbd, 0x84, 0x58, 0xb7, 0xb3, 0x6a, 0x98, 0xea,
	0x6f, 0xed, 0xc1, 0x38, 0xf0, 0x70, 0xaf, 0x91, 0x73, 0x2c, 0x77, 0xa5, 0x93, 0xba, 0x41, 0x01,
	0x54, 0xa7, 0xba, 0x87, 0x45, 0x47, 0x60, 0x41, 0x3d, 0x4e, 0x25, 0x36, 0x5b, 0x5d, 0x38, 0x4b,
	0xba, 0x9f, 0xd5, 0x8c, 0x7c, 0xad, 0x8e, 0x68, 0x69, 0xdf, 0xa6, 0x76, 0x75, 0xb7, 0x27, 0x9b,
	0x38, 0x65, 0x16, 0x48, 0xc2, 0xcd, 0xd9, 0x9e, 0xce, 0xa6, 0x4c, 0x18, 0x39, 0x47, 0xc6, 0x83,
	0x05, 0xb7, 0x32, 0xd3, 0xd8, 0x29, 0x9f, 0xf2, 0x5d, 0x58, 0x49, 0xf7, 0x01, 0xed, 0x02, 0x52,
	0x73, 0x3d, 0xd5, 0x7b, 0x45, 0xbe, 0x65, 0xd7, 0x26, 0xbe, 0xbc, 0x9f, 0x6e, 0x7f, 0xe3, 0x2a,
	0x6c, 0x66, 0xd4, 0x2c, 0x87, 0x11, 0xad, 0xfe, 0x6c, 0x01, 0x7a, 0x12, 0x09, 0xc9, 0x29, 0xe9,
	0xa7, 0x48, 0xfd, 0x15, 0x20, 0x4f, 0x3f, 0x04, 0xd6, 0xcd, 0x4d, 0x98, 0x63, 0xc8, 0x7d, 0x63,
	0x8e, 0x57, 0x73, 0x6d, 0x6f, 0x7a, 0x4e, 0xb6, 0x20, 0x2f, 0x02, 0xa6, 0xf7, 0xde, 0x72, 0x42,
	0x5b, 0x9e, 0xdf, 0xf9, 0xc7, 0x72, 0xd5, 0x35, 0xaa, 0xc3, 0x15, 0x33, 0x96, 0x9c, 0x06, 0xb4,
	0x1b, 0x4a, 0xa6, 0x6b, 0xd5, 0x5c, 0x2d, 0xba, 0x48, 0x9b, 0xdc, 0xb4, 0xa5, 0xfa, 0x57, 0x1e,
	0x36, 0x1e, 0x84, 0xa7, 0xc1, 0xff, 0x51, 0xfa, 0x53, 0x28, 0x8f, 0x14, 0xcd, 0xf3, 0x19, 0x0d,
	0xe4, 0x84, 0x68, 0xe4, 0x2e, 0xd4, 0x31, 0x27, 0x89, 0x6e, 0xea, 0xe0, 0xf4, 0x1f, 0x8c, 0x0f,
	0xa1, 0x34, 0xd6, 0xca, 0x80, 0x25, 0xa3, 0xf9, 0x3a, 0x28, 0x18, 0x49, 0x62, 0xc0, 0xd0, 0x33,
	0xb8, 0x22, 0xcc, 0xca, 0xc4, 0x52, 0xef, 0x4c, 0xac, 0x97, 0xa5, 0x59, 0xef, 0xef, 0x66, 0x6b,
	0xc7, 0xcc, 0x8e, 0x55, 0x73, 0x2d, 0x66, 0x16, 0xef, 0x00, 0x6e, 0x65, 0x40, 0x67, 0xd0, 0x7c,
	0xf1, 0xbf, 0xd0, 0x7c, 0x26, 0xcf, 0x94, 0x4f, 0xa3, 0x0c, 0x4e, 0x56, 0x5a, 0xcd, 0x54, 0x0a,
	0x97, 0xa7, 0xdc, 0x11, 0x82, 0x82, 0xde, 0x6c, 0x86, 0xf7, 0xfa, 0x1b, 0xdd, 0x03, 0x50, 0x55,
	0x26, 0xe5, 0x99, 0xb7, 0xb9, 0x96, 0xb1, 0x17, 0x0c, 0xc4, 0x68, 0xa9, 0x8b, 0x8e, 0x30, 0x17,
	0xd5, 0x9f, 0x72, 0xb0, 0x64, 0x92, 0x64, 0xc2, 0x3f, 0x82, 0xcb, 0x53, 0x72, 0x93, 0xe4, 0xb8,
	0x58, 0xab, 0x0f, 0x16, 0xdc, 0xb5, 0x49, 0x71, 0x79, 0xd5, 0x0b, 0xe6, 0xdf, 0xc0, 0x0b, 0x66,
	0x6b, 0x7f, 0xe1, 0xcd, 0x69, 0x7f, 0x63, 0x09, 0x0a, 0xea, 0x61, 0x1a, 0x6f, 0xff, 0x78, 0xb6,
	0x6d, 0xfd, 0x76, 0xb6, 0x6d, 0xbd, 0x3c, 0xdb, 0xb6, 0xfe, 0x38, 0xdb, 0xb6, 0xbe, 0x2e, 0x28,
	0xc4, 0xa3, 0x25, 0x4d, 0xdf, 0x3b, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0xab, 0x88, 0xc4, 0x71,
	0xbc, 0x0d, 0x00, 0x00,
}
