//  Copyright 2018 Istio Authors
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.

// Code generated by go-bindata.
// sources:
// testdata/authentication-v1alpha1-Policy-invalid.yaml
// testdata/authentication-v1alpha1-Policy-valid.yaml
// testdata/config-v1alpha2-DestinationPolicy-invalid-skipped.yaml
// testdata/config-v1alpha2-DestinationPolicy-valid-skipped.yaml
// testdata/config-v1alpha2-EgressRule-invalid-skipped.yaml
// testdata/config-v1alpha2-EgressRule-valid-skipped.yaml
// testdata/config-v1alpha2-HTTPAPISpec-invalid.yaml
// testdata/config-v1alpha2-HTTPAPISpec-valid.yaml
// testdata/config-v1alpha2-HTTPAPISpecBinding-invalid.yaml
// testdata/config-v1alpha2-HTTPAPISpecBinding-valid.yaml
// testdata/config-v1alpha2-QuotaSpec-invalid.yaml
// testdata/config-v1alpha2-QuotaSpec-valid.yaml
// testdata/config-v1alpha2-QuotaSpecBinding-invalid.yaml
// testdata/config-v1alpha2-QuotaSpecBinding-valid.yaml
// testdata/config-v1alpha2-RouteRule-invalid-skipped.yaml
// testdata/config-v1alpha2-RouteRule-valid-skipped.yaml
// testdata/config-v1alpha2-ServiceRole-invalid.yaml
// testdata/config-v1alpha2-ServiceRole-valid.yaml
// testdata/config-v1alpha2-ServiceRoleBinding-invalid.yaml
// testdata/config-v1alpha2-ServiceRoleBinding-valid.yaml
// testdata/config-v1alpha2-apikey-invalid.yaml
// testdata/config-v1alpha2-apikey-valid.yaml
// testdata/config-v1alpha2-attributemanifest-invalid.yaml
// testdata/config-v1alpha2-attributemanifest-valid.yaml
// testdata/config-v1alpha2-authorization-invalid.yaml
// testdata/config-v1alpha2-authorization-valid.yaml
// testdata/config-v1alpha2-checknothing-invalid.yaml
// testdata/config-v1alpha2-checknothing-valid.yaml
// testdata/config-v1alpha2-circonus-invalid.yaml
// testdata/config-v1alpha2-circonus-valid.yaml
// testdata/config-v1alpha2-denier-invalid.yaml
// testdata/config-v1alpha2-denier-valid.yaml
// testdata/config-v1alpha2-fluentd-invalid.yaml
// testdata/config-v1alpha2-fluentd-valid.yaml
// testdata/config-v1alpha2-kubernetes-invalid-skipped.yaml
// testdata/config-v1alpha2-kubernetes-valid.yaml
// testdata/config-v1alpha2-kubernetesenv-invalid.yaml
// testdata/config-v1alpha2-kubernetesenv-valid.yaml
// testdata/config-v1alpha2-listchecker-invalid.yaml
// testdata/config-v1alpha2-listchecker-valid.yaml
// testdata/config-v1alpha2-listentry-invalid.yaml
// testdata/config-v1alpha2-listentry-valid.yaml
// testdata/config-v1alpha2-logentry-invalid.yaml
// testdata/config-v1alpha2-logentry-valid.yaml
// testdata/config-v1alpha2-memquota-invalid.yaml
// testdata/config-v1alpha2-memquota-valid.yaml
// testdata/config-v1alpha2-metric-invalid.yaml
// testdata/config-v1alpha2-metric-valid.yaml
// testdata/config-v1alpha2-noop-invalid.yaml
// testdata/config-v1alpha2-noop-valid.yaml
// testdata/config-v1alpha2-opa-invalid.yaml
// testdata/config-v1alpha2-opa-valid.yaml
// testdata/config-v1alpha2-prometheus-invalid.yaml
// testdata/config-v1alpha2-prometheus-valid.yaml
// testdata/config-v1alpha2-quota-invalid.yaml
// testdata/config-v1alpha2-quota-valid.yaml
// testdata/config-v1alpha2-rbac-invalid.yaml
// testdata/config-v1alpha2-rbac-valid.yaml
// testdata/config-v1alpha2-reportnothing-invalid.yaml
// testdata/config-v1alpha2-reportnothing-valid.yaml
// testdata/config-v1alpha2-rule-invalid.yaml
// testdata/config-v1alpha2-rule-valid.yaml
// testdata/config-v1alpha2-servicecontrol-invalid.yaml
// testdata/config-v1alpha2-servicecontrol-valid.yaml
// testdata/config-v1alpha2-servicecontrolreport-invalid.yaml
// testdata/config-v1alpha2-servicecontrolreport-valid.yaml
// testdata/config-v1alpha2-solarwinds-invalid.yaml
// testdata/config-v1alpha2-solarwinds-valid.yaml
// testdata/config-v1alpha2-stackdriver-invalid.yaml
// testdata/config-v1alpha2-stackdriver-valid.yaml
// testdata/config-v1alpha2-statsd-invalid.yaml
// testdata/config-v1alpha2-statsd-valid.yaml
// testdata/config-v1alpha2-stdio-invalid.yaml
// testdata/config-v1alpha2-stdio-valid.yaml
// testdata/config-v1alpha2-tracespan-invalid.yaml
// testdata/config-v1alpha2-tracespan-valid.yaml
// testdata/networking-v1alpha3-DestinationRule-invalid.yaml
// testdata/networking-v1alpha3-DestinationRule-valid.yaml
// testdata/networking-v1alpha3-Gateway-invalid.yaml
// testdata/networking-v1alpha3-Gateway-valid.yaml
// testdata/networking-v1alpha3-ServiceEntry-invalid-skipped.yaml
// testdata/networking-v1alpha3-ServiceEntry-valid.yaml
// testdata/networking-v1alpha3-VirtualService-invalid.yaml
// testdata/networking-v1alpha3-VirtualService-valid.yaml
// DO NOT EDIT!

package galley

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _testdataAuthenticationV1alpha1PolicyInvalidYaml = []byte(`apiVersion: "authentication.istio.io/v1alpha1"
kind: "Policy"
metadata:
  name: invalid-authentication-policy
spec:
  targets:
  - name: "bad.target"
`)

func testdataAuthenticationV1alpha1PolicyInvalidYamlBytes() ([]byte, error) {
	return _testdataAuthenticationV1alpha1PolicyInvalidYaml, nil
}

func testdataAuthenticationV1alpha1PolicyInvalidYaml() (*asset, error) {
	bytes, err := testdataAuthenticationV1alpha1PolicyInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/authentication-v1alpha1-Policy-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataAuthenticationV1alpha1PolicyValidYaml = []byte(`apiVersion: "authentication.istio.io/v1alpha1"
kind: "Policy"
metadata:
  name: valid-authentication-policy
spec:
  targets:
  - name: good-target
`)

func testdataAuthenticationV1alpha1PolicyValidYamlBytes() ([]byte, error) {
	return _testdataAuthenticationV1alpha1PolicyValidYaml, nil
}

func testdataAuthenticationV1alpha1PolicyValidYaml() (*asset, error) {
	bytes, err := testdataAuthenticationV1alpha1PolicyValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/authentication-v1alpha1-Policy-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2DestinationpolicyInvalidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: DestinationPolicy
metadata:
  name: valid-destination-policy
spec:
`)

func testdataConfigV1alpha2DestinationpolicyInvalidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2DestinationpolicyInvalidSkippedYaml, nil
}

func testdataConfigV1alpha2DestinationpolicyInvalidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2DestinationpolicyInvalidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-DestinationPolicy-invalid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2DestinationpolicyValidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: DestinationPolicy
metadata:
  name: valid-destination-policy
spec:
  destination:
    name: reviews
  loadBalancing:
    name: RANDOM
`)

func testdataConfigV1alpha2DestinationpolicyValidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2DestinationpolicyValidSkippedYaml, nil
}

func testdataConfigV1alpha2DestinationpolicyValidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2DestinationpolicyValidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-DestinationPolicy-valid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2EgressruleInvalidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: EgressRule
metadata:
  name: invalid-egress-rule
spec:
`)

func testdataConfigV1alpha2EgressruleInvalidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2EgressruleInvalidSkippedYaml, nil
}

func testdataConfigV1alpha2EgressruleInvalidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2EgressruleInvalidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-EgressRule-invalid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2EgressruleValidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: EgressRule
metadata:
  name: valid-egress-rule
spec:
  destination:
      service: 91.198.174.192/27
  ports:
      - port: 443
        protocol: tcp
  use_egress_proxy: false
`)

func testdataConfigV1alpha2EgressruleValidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2EgressruleValidSkippedYaml, nil
}

func testdataConfigV1alpha2EgressruleValidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2EgressruleValidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-EgressRule-valid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2HttpapispecInvalidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: HTTPAPISpec
metadata:
  name: invalid-http-api-spec
spec:
  apiKeys:
  - query: key
  attributes:
    attributes:
      api.service:
        stringValue: bookinfo.endpoints.istio-manlinl.cloud.goog
      api.version:
        stringValue: v1
`)

func testdataConfigV1alpha2HttpapispecInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2HttpapispecInvalidYaml, nil
}

func testdataConfigV1alpha2HttpapispecInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2HttpapispecInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-HTTPAPISpec-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2HttpapispecValidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: HTTPAPISpec
metadata:
  name: valid-http-api-spec
spec:
  apiKeys:
  - query: key
  attributes:
    attributes:
      api.service:
        stringValue: bookinfo.endpoints.istio-manlinl.cloud.goog
      api.version:
        stringValue: v1
  patterns:
  - attributes:
      attributes:
        api.operation:
          stringValue: getProducts
    httpMethod: GET
    uriTemplate: /productpage
`)

func testdataConfigV1alpha2HttpapispecValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2HttpapispecValidYaml, nil
}

func testdataConfigV1alpha2HttpapispecValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2HttpapispecValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-HTTPAPISpec-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2HttpapispecbindingInvalidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: HTTPAPISpecBinding
metadata:
  name: invalid-http-api-spec-binding
spec:
`)

func testdataConfigV1alpha2HttpapispecbindingInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2HttpapispecbindingInvalidYaml, nil
}

func testdataConfigV1alpha2HttpapispecbindingInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2HttpapispecbindingInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-HTTPAPISpecBinding-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2HttpapispecbindingValidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: HTTPAPISpecBinding
metadata:
  name: valid-http-api-spec-binding
spec:
  apiSpecs:
  - name: productpage
    namespace: default
  services:
  - name: productpage
    namespace: default
`)

func testdataConfigV1alpha2HttpapispecbindingValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2HttpapispecbindingValidYaml, nil
}

func testdataConfigV1alpha2HttpapispecbindingValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2HttpapispecbindingValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-HTTPAPISpecBinding-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaspecInvalidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: QuotaSpec
metadata:
  name: invalid-quota-spec
spec:
`)

func testdataConfigV1alpha2QuotaspecInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaspecInvalidYaml, nil
}

func testdataConfigV1alpha2QuotaspecInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaspecInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-QuotaSpec-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaspecValidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: QuotaSpec
metadata:
  name: valid-quota-spec
spec:
  rules:
  - match:
    - clause:
        api.operation:
          exact: getProducts
    quotas:
    - charge: "1"
      quota: read-requests
`)

func testdataConfigV1alpha2QuotaspecValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaspecValidYaml, nil
}

func testdataConfigV1alpha2QuotaspecValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaspecValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-QuotaSpec-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaspecbindingInvalidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: QuotaSpecBinding
metadata:
  name: valid-quota-spec-binding
spec:
`)

func testdataConfigV1alpha2QuotaspecbindingInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaspecbindingInvalidYaml, nil
}

func testdataConfigV1alpha2QuotaspecbindingInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaspecbindingInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-QuotaSpecBinding-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaspecbindingValidYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: QuotaSpecBinding
metadata:
  name: valid-quota-spec-binding
spec:
  quotaSpecs:
  - name: bookinfo
    namespace: default
  services:
  - name: bookinfo
    namespace: default
`)

func testdataConfigV1alpha2QuotaspecbindingValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaspecbindingValidYaml, nil
}

func testdataConfigV1alpha2QuotaspecbindingValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaspecbindingValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-QuotaSpecBinding-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RouteruleInvalidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: RouteRule
metadata:
  name: valid-route-rule
spec:
  precedence: 2
  route:
  - labels:
      version: v2
`)

func testdataConfigV1alpha2RouteruleInvalidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RouteruleInvalidSkippedYaml, nil
}

func testdataConfigV1alpha2RouteruleInvalidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RouteruleInvalidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-RouteRule-invalid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RouteruleValidSkippedYaml = []byte(`apiVersion: config.istio.io/v1alpha2
kind: RouteRule
metadata:
  name: valid-route-rule
spec:
  destination:
    service: ratings.service.consul
  precedence: 2
  route:
  - labels:
      version: v2
`)

func testdataConfigV1alpha2RouteruleValidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RouteruleValidSkippedYaml, nil
}

func testdataConfigV1alpha2RouteruleValidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RouteruleValidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-RouteRule-valid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServiceroleInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: ServiceRole
metadata:
  name: products-viewer
spec:
  rules:

`)

func testdataConfigV1alpha2ServiceroleInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServiceroleInvalidYaml, nil
}

func testdataConfigV1alpha2ServiceroleInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServiceroleInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-ServiceRole-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServiceroleValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: ServiceRole
metadata:
  name: products-viewer
spec:
  rules:
  - services: ["products.svc.cluster.local"]
    methods: ["GET", "HEAD"]
    constraints:
    - key: "version"
      values: ["v1", "v2"]

`)

func testdataConfigV1alpha2ServiceroleValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServiceroleValidYaml, nil
}

func testdataConfigV1alpha2ServiceroleValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServiceroleValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-ServiceRole-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicerolebindingInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: ServiceRoleBinding
metadata:
  name: test-binding-products
spec:
  subjects:

`)

func testdataConfigV1alpha2ServicerolebindingInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicerolebindingInvalidYaml, nil
}

func testdataConfigV1alpha2ServicerolebindingInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicerolebindingInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-ServiceRoleBinding-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicerolebindingValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: ServiceRoleBinding
metadata:
  name: test-binding-products
spec:
  subjects:
  - user: "alice@yahoo.com"
  - properties:
      service: "reviews"
      namespace: "abc"
  roleRef:
    kind: ServiceRole
    name: "products-viewer"

`)

func testdataConfigV1alpha2ServicerolebindingValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicerolebindingValidYaml, nil
}

func testdataConfigV1alpha2ServicerolebindingValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicerolebindingValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-ServiceRoleBinding-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ApikeyInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: apikey
metadata:
  name: invalid-apikey
spec:
  badField: foo
`)

func testdataConfigV1alpha2ApikeyInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ApikeyInvalidYaml, nil
}

func testdataConfigV1alpha2ApikeyInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ApikeyInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-apikey-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ApikeyValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: apikey
metadata:
  name: valid-apikey
spec:
  api: api.service | ""
  api_version: api.version | ""
  api_operation : api.operation
  api_key : request.api_key
  timestamp : request.time
`)

func testdataConfigV1alpha2ApikeyValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ApikeyValidYaml, nil
}

func testdataConfigV1alpha2ApikeyValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ApikeyValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-apikey-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2AttributemanifestInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: valid-attribute-manifest
spec:
  attributes:
    origin.ip:
      valueType: IP_ADDRESS
    origin.uid:
      valueType: BAD_TYPE
    origin.user:
      valueType: STRING
    request.headers:
      valueType: STRING_MAP
    request.id:
      valueType: STRING
`)

func testdataConfigV1alpha2AttributemanifestInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2AttributemanifestInvalidYaml, nil
}

func testdataConfigV1alpha2AttributemanifestInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2AttributemanifestInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-attributemanifest-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2AttributemanifestValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: attributemanifest
metadata:
  name: valid-attribute-manifest
spec:
  attributes:
    origin.ip:
      valueType: IP_ADDRESS
    origin.uid:
      valueType: STRING
    origin.user:
      valueType: STRING
    request.headers:
      valueType: STRING_MAP
    request.id:
      valueType: STRING
    request.host:
      valueType: STRING
    request.method:
      valueType: STRING
    request.path:
      valueType: STRING
    request.reason:
      valueType: STRING
    request.referer:
      valueType: STRING
    request.scheme:
      valueType: STRING
    request.total_size:
      valueType: INT64
    request.size:
      valueType: INT64
    request.time:
      valueType: TIMESTAMP
    request.useragent:
      valueType: STRING
    response.code:
      valueType: INT64
    response.duration:
      valueType: DURATION
    response.headers:
      valueType: STRING_MAP
    response.total_size:
      valueType: INT64
    response.size:
      valueType: INT64
    response.time:
      valueType: TIMESTAMP
    source.uid:
      valueType: STRING
    source.user:
      valueType: STRING
    destination.uid:
      valueType: STRING
    connection.id:
      valueType: STRING
    connection.received.bytes:
      valueType: INT64
    connection.received.bytes_total:
      valueType: INT64
    connection.sent.bytes:
      valueType: INT64
    connection.sent.bytes_total:
      valueType: INT64
    connection.duration:
      valueType: DURATION
    connection.mtls:
      valueType: BOOL
    context.protocol:
      valueType: STRING
    context.timestamp:
      valueType: TIMESTAMP
    context.time:
      valueType: TIMESTAMP
    api.service:
      valueType: STRING
    api.version:
      valueType: STRING
    api.operation:
      valueType: STRING
    api.protocol:
      valueType: STRING
    request.auth.principal:
      valueType: STRING
    request.auth.audiences:
      valueType: STRING
    request.auth.presenter:
      valueType: STRING
    request.api_key:
      valueType: STRING
    source.ip:
      valueType: IP_ADDRESS
    source.labels:
      valueType: STRING_MAP
    source.name:
      valueType: STRING
    source.namespace:
      valueType: STRING
    source.service:
      valueType: STRING
    source.serviceAccount:
      valueType: STRING
    destination.ip:
      valueType: IP_ADDRESS
    destination.labels:
      valueType: STRING_MAP
    destination.name:
      valueType: STRING
    destination.namespace:
      valueType: STRING
    destination.service:
      valueType: STRING
    destination.serviceAccount:
      valueType: STRING
`)

func testdataConfigV1alpha2AttributemanifestValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2AttributemanifestValidYaml, nil
}

func testdataConfigV1alpha2AttributemanifestValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2AttributemanifestValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-attributemanifest-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2AuthorizationInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: authorization
metadata:
  name: invalid-authorization
spec:
  badField: foo
`)

func testdataConfigV1alpha2AuthorizationInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2AuthorizationInvalidYaml, nil
}

func testdataConfigV1alpha2AuthorizationInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2AuthorizationInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-authorization-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2AuthorizationValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: authorization
metadata:
  name: valid-authorization
spec:
  subject:
    user: request.auth.principal | ""
    groups: request.auth.principal | ""
    properties:
      service: source.service | ""
      namespace: source.namespace | ""
  action:
    namespace: destination.namespace | ""
    service: destination.service | ""
    method: request.method | ""
    path: request.path | ""
    properties:
      version: request.headers["version"] | ""
`)

func testdataConfigV1alpha2AuthorizationValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2AuthorizationValidYaml, nil
}

func testdataConfigV1alpha2AuthorizationValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2AuthorizationValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-authorization-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ChecknothingInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: checknothing
metadata:
  name: valid-check-nothing
spec:
  badField: foo
`)

func testdataConfigV1alpha2ChecknothingInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ChecknothingInvalidYaml, nil
}

func testdataConfigV1alpha2ChecknothingInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ChecknothingInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-checknothing-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ChecknothingValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: checknothing
metadata:
  name: valid-check-nothing
spec:
`)

func testdataConfigV1alpha2ChecknothingValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ChecknothingValidYaml, nil
}

func testdataConfigV1alpha2ChecknothingValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ChecknothingValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-checknothing-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2CirconusInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: circonus
metadata:
  name: invalid-circonus
spec:
  badField: foo
`)

func testdataConfigV1alpha2CirconusInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2CirconusInvalidYaml, nil
}

func testdataConfigV1alpha2CirconusInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2CirconusInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-circonus-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2CirconusValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: circonus
metadata:
  name: valid-circonus
spec:
  submission_url: "https://trap.noit.circonus.net/module/httptrap/myuuid/mysecret"
  submission_interval: "10s"
`)

func testdataConfigV1alpha2CirconusValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2CirconusValidYaml, nil
}

func testdataConfigV1alpha2CirconusValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2CirconusValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-circonus-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2DenierInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: denier
metadata:
  name: invalid-denyall
spec:
  badField: foo
`)

func testdataConfigV1alpha2DenierInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2DenierInvalidYaml, nil
}

func testdataConfigV1alpha2DenierInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2DenierInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-denier-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2DenierValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: denier
metadata:
  name: valid-denyall
spec:
  status:
    code: 7
    message: Not allowed
`)

func testdataConfigV1alpha2DenierValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2DenierValidYaml, nil
}

func testdataConfigV1alpha2DenierValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2DenierValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-denier-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2FluentdInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: fluentd
metadata:
  name: invalid-fluentd
spec:
  badField: foo
  address: "localhost:24224"
`)

func testdataConfigV1alpha2FluentdInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2FluentdInvalidYaml, nil
}

func testdataConfigV1alpha2FluentdInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2FluentdInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-fluentd-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2FluentdValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: fluentd
metadata:
  name: valid-fluentd
spec:
  address: "localhost:24224"
`)

func testdataConfigV1alpha2FluentdValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2FluentdValidYaml, nil
}

func testdataConfigV1alpha2FluentdValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2FluentdValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-fluentd-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2KubernetesInvalidSkippedYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: kubernetes
metadata:
  name: valid-kubernetes
spec:
  badField: foo
`)

func testdataConfigV1alpha2KubernetesInvalidSkippedYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2KubernetesInvalidSkippedYaml, nil
}

func testdataConfigV1alpha2KubernetesInvalidSkippedYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2KubernetesInvalidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-kubernetes-invalid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2KubernetesValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: kubernetes
metadata:
  name: valid-kubernetes
spec:
  # Pass the required attribute data to the adapter
  source_uid: source.uid | ""
  source_ip: source.ip | ip("0.0.0.0") # default to unspecified ip addr
  destination_uid: destination.uid | ""
  destination_ip: destination.ip | ip("0.0.0.0") # default to unspecified ip addr
  origin_uid: '""'
  origin_ip: ip("0.0.0.0") # default to unspecified ip addr
  attribute_bindings:
    # Fill the new attributes from the adapter produced output.
    # $out refers to an instance of OutputTemplate message
    #source.ip: $out.source_pod_ip | ip("0.0.0.0")
    # source.labels: $out.source_labels | emptyStringMap()
    #source.namespace: $out.source_namespace | "default"
    #source.service: $out.source_service | "unknown"
    #source.serviceAccount: $out.source_service_account_name | "unknown"
    destination.ip: $out.destination_pod_ip | ip("0.0.0.0")
    destination.labels: $out.destination_labels | emptyStringMap()
    destination.namespace: $out.destination_namespace | "default"
    destination.service: $out.destination_service | "unknown"
    #destination.serviceAccount: $out.destination_service_account_name | "unknown"
`)

func testdataConfigV1alpha2KubernetesValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2KubernetesValidYaml, nil
}

func testdataConfigV1alpha2KubernetesValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2KubernetesValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-kubernetes-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2KubernetesenvInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: kubernetesenv
metadata:
  name: valid-kubernetesenv
spec:
  badField: foo
`)

func testdataConfigV1alpha2KubernetesenvInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2KubernetesenvInvalidYaml, nil
}

func testdataConfigV1alpha2KubernetesenvInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2KubernetesenvInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-kubernetesenv-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2KubernetesenvValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: kubernetesenv
metadata:
  name: valid-kubernetesenv
spec:
`)

func testdataConfigV1alpha2KubernetesenvValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2KubernetesenvValidYaml, nil
}

func testdataConfigV1alpha2KubernetesenvValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2KubernetesenvValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-kubernetesenv-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ListcheckerInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: listchecker
metadata:
  name: invalid-listchecker
spec:
  badField: foo
`)

func testdataConfigV1alpha2ListcheckerInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ListcheckerInvalidYaml, nil
}

func testdataConfigV1alpha2ListcheckerInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ListcheckerInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-listchecker-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ListcheckerValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: listchecker
metadata:
  name: valid-listchecker
spec:
  overrides: ["v1", "v2"]  # overrides provide a static list
  blacklist: false
`)

func testdataConfigV1alpha2ListcheckerValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ListcheckerValidYaml, nil
}

func testdataConfigV1alpha2ListcheckerValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ListcheckerValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-listchecker-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ListentryInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: listentry
metadata:
  name: invalid-listentry
spec:
  badField: foo
`)

func testdataConfigV1alpha2ListentryInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ListentryInvalidYaml, nil
}

func testdataConfigV1alpha2ListentryInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ListentryInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-listentry-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ListentryValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: listentry
metadata:
  name: valid-listentry
spec:
  value: source.labels["version"]
`)

func testdataConfigV1alpha2ListentryValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ListentryValidYaml, nil
}

func testdataConfigV1alpha2ListentryValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ListentryValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-listentry-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2LogentryInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: logentry
metadata:
  name: invalid-logentry
spec:
  badField: foo
`)

func testdataConfigV1alpha2LogentryInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2LogentryInvalidYaml, nil
}

func testdataConfigV1alpha2LogentryInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2LogentryInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-logentry-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2LogentryValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: logentry
metadata:
  name: valid-logentry
spec:
  severity: '"Default"'
  timestamp: request.time
  variables:
    sourceIp: source.ip | ip("0.0.0.0")
    destinationIp: destination.ip | ip("0.0.0.0")
  monitored_resource_type: '"UNSPECIFIED"'
`)

func testdataConfigV1alpha2LogentryValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2LogentryValidYaml, nil
}

func testdataConfigV1alpha2LogentryValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2LogentryValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-logentry-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2MemquotaInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: memquota
metadata:
  name: valid-memquota
spec:
  badField: foo
`)

func testdataConfigV1alpha2MemquotaInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2MemquotaInvalidYaml, nil
}

func testdataConfigV1alpha2MemquotaInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2MemquotaInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-memquota-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2MemquotaValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: memquota
metadata:
  name: valid-memquota
spec:
  quotas:
  - name: requestcount.quota.istio-system
    maxAmount: 5000
    validDuration: 1s
    overrides:
    - dimensions:
        destination: ratings
        source: reviews
      maxAmount: 1
      validDuration: 1s
`)

func testdataConfigV1alpha2MemquotaValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2MemquotaValidYaml, nil
}

func testdataConfigV1alpha2MemquotaValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2MemquotaValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-memquota-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2MetricInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: metric
metadata:
  name: invalid-metric
spec:
  badField: foo
`)

func testdataConfigV1alpha2MetricInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2MetricInvalidYaml, nil
}

func testdataConfigV1alpha2MetricInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2MetricInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-metric-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2MetricValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: metric
metadata:
  name: valid-metric
spec:
  value: "1"
  dimensions:
    source_service: source.service | "unknown"
    source_version: source.labels["version"] | "unknown"
    destination_service: destination.service | "unknown"
    destination_version: destination.labels["version"] | "unknown"
    response_code: response.code | 200
  monitored_resource_type: '"UNSPECIFIED"'
`)

func testdataConfigV1alpha2MetricValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2MetricValidYaml, nil
}

func testdataConfigV1alpha2MetricValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2MetricValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-metric-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2NoopInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: noop
metadata:
  name: invalid-noop
spec:
  badField: foo
`)

func testdataConfigV1alpha2NoopInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2NoopInvalidYaml, nil
}

func testdataConfigV1alpha2NoopInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2NoopInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-noop-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2NoopValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: noop
metadata:
  name: valid-noop
`)

func testdataConfigV1alpha2NoopValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2NoopValidYaml, nil
}

func testdataConfigV1alpha2NoopValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2NoopValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-noop-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2OpaInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: opa
metadata:
  name: invalid-opa
spec:
  badField: foo
`)

func testdataConfigV1alpha2OpaInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2OpaInvalidYaml, nil
}

func testdataConfigV1alpha2OpaInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2OpaInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-opa-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2OpaValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: opa
metadata:
  name: valid-opa
spec:
  policy:
    - |+
      package mixerauthz
      import data.service_graph
      import data.org_chart

      # Deny request by default.
      default allow = false

      # Allow request if...
      allow {
          service_graph.allow  # service graph policy allows, and...
          org_chart.allow      # org chart policy allows.
      }
    - |+
      package org_chart

      parsed_path = p {
          trim(input.action.path, "/", trimmed)
          split(trimmed, "/", p)
      }

      employees = {
          "bob": {"manager": "janet", "roles": ["engineering"]},
          "alice": {"manager": "janet", "roles": ["engineering"]},
          "janet": {"roles": ["engineering"]},
          "ken": {"roles": ["hr"]},
      }

      # Allow access to non-sensitive APIs.
      allow { not is_sensitive_api }

      is_sensitive_api {
          parsed_path[0] = "reviews"
      }

      # Allow users access to sensitive APIs serving their own data.
      allow {
          parsed_path = ["reviews", user]
          input.subject.user = user
      }

      # Allow managers access to sensitive APIs serving their reports' data.
      allow {
          parsed_path = ["reviews", user]
          input.subject.user = employees[user].manager
      }

      # Allow HR to access all APIs.
      allow {
          is_hr
      }

      is_hr {
          employees[input.subject.user].roles[_] = "hr"
      }
    - |+
      package service_graph

      service_graph = {
          "landing_page": ["details", "reviews"],
          "reviews": ["ratings"],
      }

      default allow = false

      allow {
          input.action.properties.target = "landing_page"
      }

      allow {
          allowed_targets = service_graph[input.action.properties.source]
          input.action.properties.target = allowed_targets[_]
      }
  checkMethod: "data.mixerauthz.allow"
  failClose: true
`)

func testdataConfigV1alpha2OpaValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2OpaValidYaml, nil
}

func testdataConfigV1alpha2OpaValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2OpaValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-opa-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2PrometheusInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: prometheus
metadata:
  name: invalid-prometheus
spec:
  badField: foo
`)

func testdataConfigV1alpha2PrometheusInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2PrometheusInvalidYaml, nil
}

func testdataConfigV1alpha2PrometheusInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2PrometheusInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-prometheus-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2PrometheusValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: prometheus
metadata:
  name: valid-prometheus
spec:
  metrics:
  - name: request_count
    instance_name: requestcount.metric.istio-system
    kind: COUNTER
    label_names:
    - source_service
    - source_version
    - destination_service
    - destination_version
    - response_code
`)

func testdataConfigV1alpha2PrometheusValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2PrometheusValidYaml, nil
}

func testdataConfigV1alpha2PrometheusValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2PrometheusValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-prometheus-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: quota
metadata:
  name: invalid-quota
spec:
  badField: foo
`)

func testdataConfigV1alpha2QuotaInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaInvalidYaml, nil
}

func testdataConfigV1alpha2QuotaInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-quota-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2QuotaValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: quota
metadata:
  name: valid-quota
spec:
  dimensions:
    source: source.labels["app"] | source.service | "unknown"
    sourceVersion: source.labels["version"] | "unknown"
    destination: destination.labels["app"] | destination.service | "unknown"
    destinationVersion: destination.labels["version"] | "unknown"
`)

func testdataConfigV1alpha2QuotaValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2QuotaValidYaml, nil
}

func testdataConfigV1alpha2QuotaValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2QuotaValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-quota-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RbacInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: rbac
metadata:
 name: invalid-rbac
spec:
 badField: foo
`)

func testdataConfigV1alpha2RbacInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RbacInvalidYaml, nil
}

func testdataConfigV1alpha2RbacInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RbacInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-rbac-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RbacValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: rbac
metadata:
 name: valid-rbac
spec:
 config_store_url: "k8s://"
`)

func testdataConfigV1alpha2RbacValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RbacValidYaml, nil
}

func testdataConfigV1alpha2RbacValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RbacValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-rbac-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ReportnothingInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: reportnothing
metadata:
  name: invalid-reportnothing
spec:
  badField: foo
`)

func testdataConfigV1alpha2ReportnothingInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ReportnothingInvalidYaml, nil
}

func testdataConfigV1alpha2ReportnothingInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ReportnothingInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-reportnothing-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ReportnothingValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: reportnothing
metadata:
  name: valid-reportnothing
spec:
`)

func testdataConfigV1alpha2ReportnothingValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ReportnothingValidYaml, nil
}

func testdataConfigV1alpha2ReportnothingValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ReportnothingValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-reportnothing-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RuleInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: denier
metadata:
  name: handler-for-invalid-rule
spec:
  status:
    code: 7
    message: Not allowed
---
apiVersion: "config.istio.io/v1alpha2"
kind: checknothing
metadata:
  name: instance-for-invalid-rule
spec:
---
apiVersion: "config.istio.io/v1alpha2"
kind: rule
metadata:
  name: invalid-rule
spec:
  badField: foo
  match: request.headers["clnt"] == "abc"
  actions:
  - handler: handler-for-invalid-rule.denier
    instances:
    - instance-for-invalid-rule.checknothing
`)

func testdataConfigV1alpha2RuleInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RuleInvalidYaml, nil
}

func testdataConfigV1alpha2RuleInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RuleInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-rule-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2RuleValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: denier
metadata:
  name: handler-for-valid-rule
spec:
  status:
    code: 7
    message: Not allowed
---
apiVersion: "config.istio.io/v1alpha2"
kind: checknothing
metadata:
  name: instance-for-valid-rule
spec:
---
apiVersion: "config.istio.io/v1alpha2"
kind: rule
metadata:
  name: valid-rule
spec:
  match: request.headers["clnt"] == "abc"
  actions:
  - handler: handler-for-valid-rule.denier
    instances:
    - instance-for-valid-rule.checknothing
`)

func testdataConfigV1alpha2RuleValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2RuleValidYaml, nil
}

func testdataConfigV1alpha2RuleValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2RuleValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-rule-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicecontrolInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: servicecontrol
metadata:
  name: invalid-servicecontrol
spec:
  badField: foo
`)

func testdataConfigV1alpha2ServicecontrolInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicecontrolInvalidYaml, nil
}

func testdataConfigV1alpha2ServicecontrolInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicecontrolInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-servicecontrol-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicecontrolValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: servicecontrol
metadata:
  name: valid-servicecontrol
spec:
  runtime_config:
    check_cache_size: 200
    check_result_expiration: 60s
  credential_path: "/etc/token/token.json"
  service_configs:
    - mesh_service_name: "productpage.default.svc.cluster.local"
      google_service_name: "bookinfo.endpoints.istio-manlinl.cloud.goog"
      quotas:
        - name: read-requests.quota.istio-system
          google_quota_metric_name: read-requests
          expiration: 1m
`)

func testdataConfigV1alpha2ServicecontrolValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicecontrolValidYaml, nil
}

func testdataConfigV1alpha2ServicecontrolValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicecontrolValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-servicecontrol-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicecontrolreportInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: servicecontrolreport
metadata:
  name: invalid-servicecontrolreport
spec:
  badField: foo
`)

func testdataConfigV1alpha2ServicecontrolreportInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicecontrolreportInvalidYaml, nil
}

func testdataConfigV1alpha2ServicecontrolreportInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicecontrolreportInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-servicecontrolreport-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2ServicecontrolreportValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: servicecontrolreport
metadata:
  name: valid-servicecontrolreport
spec:
  api_version : api.version | ""
  api_operation : api.operation | ""
  api_protocol : api.protocol | ""
  api_service : api.service | ""
  api_key : request.api_key | ""
  request_time : request.time
  request_method : request.method
  request_path : request.path
  request_bytes: request.size
  response_time : response.time
  response_code : response.code | 520
  response_bytes : response.size | 0
`)

func testdataConfigV1alpha2ServicecontrolreportValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2ServicecontrolreportValidYaml, nil
}

func testdataConfigV1alpha2ServicecontrolreportValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2ServicecontrolreportValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-servicecontrolreport-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2SolarwindsInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: solarwinds
metadata:
  name: invalid-solarwinds
spec:
  badField: foo
`)

func testdataConfigV1alpha2SolarwindsInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2SolarwindsInvalidYaml, nil
}

func testdataConfigV1alpha2SolarwindsInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2SolarwindsInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-solarwinds-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2SolarwindsValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: solarwinds
metadata:
  name: valid-solarwinds
spec:
  appoptics_access_token: token
  papertrail_url: logs0.papertrailapp.com:8080
  papertrail_local_retention_duration: 1h
`)

func testdataConfigV1alpha2SolarwindsValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2SolarwindsValidYaml, nil
}

func testdataConfigV1alpha2SolarwindsValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2SolarwindsValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-solarwinds-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StackdriverInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: stackdriver
metadata:
  name: valid-stackdriver
spec:
  badField: foo
`)

func testdataConfigV1alpha2StackdriverInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StackdriverInvalidYaml, nil
}

func testdataConfigV1alpha2StackdriverInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StackdriverInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-stackdriver-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StackdriverValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: stackdriver
metadata:
  name: valid-stackdriver
spec:
  project_id: "foo"
  metricInfo:
    stackdriverrequestcount.metric.istio-system:
      kind: 2 # DELTA
      value: 2 # INT64
    stackdriverrequestduration.metric.istio-system:
      kind: 2 # DELTA
      value: 5 # DISTRIBUTION
      buckets:
        explicit_buckets:
          bounds: [0.005, 0.01, 0.025, 0.05, 0.1, 0.25, 0.5, 1, 2.5, 5, 10]
    stackdriverrequestsize.metric.istio-system:
      kind: 2 # DELTA
      value: 5 # DISTRIBUTION
      buckets:
        exponentialBuckets:
          numFiniteBuckets: 8
          scale: 1
          growthFactor: 10
    stackdriverresponsesize.metric.istio-system:
      kind: 2 # DELTA
      value: 5 # DISTRIBUTION
      buckets:
        exponentialBuckets:
          numFiniteBuckets: 8
          scale: 1
          growthFactor: 10
  logInfo:
    stackdriverglobalmr.logentry.istio-system:
      payloadTemplate: '{{or (.sourceIp) "-"}} - {{or (.sourceUser) "-"}} [{{or (.timestamp.Format "02/Jan/2006:15:04:05 -0700") "-"}}] "{{or (.method) "-"}} {{or (.url) "-"}} {{or (.protocol) "-"}}" {{or (.responseCode) "-"}} {{or (.responseSize) "-"}}'
      httpMapping:
        status: responseCode
        requestSize: requestSize
        responseSize: responseSize
        latency: latency
        localIp: sourceIp
        remoteIp: destinationIp
      sinkInfo:
        id: '<sink_id>'
        destination: '<sink_destination>'
        filter: '<log_filter>'
`)

func testdataConfigV1alpha2StackdriverValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StackdriverValidYaml, nil
}

func testdataConfigV1alpha2StackdriverValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StackdriverValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-stackdriver-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StatsdInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: statsd
metadata:
  name: valid-statsd
spec:
  badField: foo
`)

func testdataConfigV1alpha2StatsdInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StatsdInvalidYaml, nil
}

func testdataConfigV1alpha2StatsdInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StatsdInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-statsd-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StatsdValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: statsd
metadata:
  name: valid-statsd
spec:
  address: "localhost:8125"
  prefix: "service."
`)

func testdataConfigV1alpha2StatsdValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StatsdValidYaml, nil
}

func testdataConfigV1alpha2StatsdValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StatsdValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-statsd-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StdioInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: stdio
metadata:
  name: invalid-stdio
spec:
  badField: foo
`)

func testdataConfigV1alpha2StdioInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StdioInvalidYaml, nil
}

func testdataConfigV1alpha2StdioInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StdioInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-stdio-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2StdioValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: stdio
metadata:
  name: valid-stdio
spec:
  outputAsJson: true
`)

func testdataConfigV1alpha2StdioValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2StdioValidYaml, nil
}

func testdataConfigV1alpha2StdioValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2StdioValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-stdio-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2TracespanInvalidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: tracespan
metadata:
  name: valid-tracespan
spec:
  badField: foo
`)

func testdataConfigV1alpha2TracespanInvalidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2TracespanInvalidYaml, nil
}

func testdataConfigV1alpha2TracespanInvalidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2TracespanInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-tracespan-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataConfigV1alpha2TracespanValidYaml = []byte(`apiVersion: "config.istio.io/v1alpha2"
kind: tracespan
metadata:
  name: valid-tracespan
spec:
  traceId: request.headers["x-b3-traceid"]
  spanId: request.headers["x-b3-spanid"] | ""
  parentSpanId: request.headers["x-b3-parentspanid"] | ""
  spanName: request.path | "/"
  startTime: request.time
  endTime: response.time
  spanTags:
    http.method: request.method | ""
    http.status_code: response.code | 200
    http.url: request.path | ""
    request.size: request.size | 0
    response.size: response.size | 0
    source.ip: source.ip | ip("0.0.0.0")
    source.service: source.service | ""
    source.user: source.user | ""
    source.version: source.labels["version"] | ""
`)

func testdataConfigV1alpha2TracespanValidYamlBytes() ([]byte, error) {
	return _testdataConfigV1alpha2TracespanValidYaml, nil
}

func testdataConfigV1alpha2TracespanValidYaml() (*asset, error) {
	bytes, err := testdataConfigV1alpha2TracespanValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/config-v1alpha2-tracespan-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3DestinationruleInvalidYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: DestinationRule
metadata:
  name: invalid-destination-rule
spec:
  subsets:
    - name: v1
      labels:
        version: v1
    - name: v2
      labels:
        version: v2
`)

func testdataNetworkingV1alpha3DestinationruleInvalidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3DestinationruleInvalidYaml, nil
}

func testdataNetworkingV1alpha3DestinationruleInvalidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3DestinationruleInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-DestinationRule-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3DestinationruleValidYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: DestinationRule
metadata:
  name: valid-destination-rule
spec:
  host: c
  subsets:
    - name: v1
      labels:
        version: v1
    - name: v2
      labels:
        version: v2
`)

func testdataNetworkingV1alpha3DestinationruleValidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3DestinationruleValidYaml, nil
}

func testdataNetworkingV1alpha3DestinationruleValidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3DestinationruleValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-DestinationRule-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3GatewayInvalidYaml = []byte(`# Routes TCP traffic through the ingressgateway Gateway to service A.
apiVersion: networking.istio.io/v1alpha3
kind: Gateway
metadata:
  name: invalid-gateway
spec:
  selector:
    # DO NOT CHANGE THESE LABELS
    # The ingressgateway is defined in install/kubernetes/helm/istio/values.yaml
    # with these labels
    istio: ingressgateway
`)

func testdataNetworkingV1alpha3GatewayInvalidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3GatewayInvalidYaml, nil
}

func testdataNetworkingV1alpha3GatewayInvalidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3GatewayInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-Gateway-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3GatewayValidYaml = []byte(`# Routes TCP traffic through the ingressgateway Gateway to service A.
apiVersion: networking.istio.io/v1alpha3
kind: Gateway
metadata:
  name: valid-gateway
spec:
  selector:
    # DO NOT CHANGE THESE LABELS
    # The ingressgateway is defined in install/kubernetes/helm/istio/values.yaml
    # with these labels
    istio: ingressgateway
  servers:
  - port:
      number: 31400
      protocol: TCP
      name: tcp
    hosts:
    - a.istio-system.svc.cluster.local
`)

func testdataNetworkingV1alpha3GatewayValidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3GatewayValidYaml, nil
}

func testdataNetworkingV1alpha3GatewayValidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3GatewayValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-Gateway-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3ServiceentryInvalidSkippedYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: ServiceEntry
metadata:
  name: invalid-service-entry
spec:
  ports:
  - number: 80
    name: http
    protocol: HTTP
  discovery: DNS
  endpoints:
  # Rather than relying on an external host that might become unreachable (causing test failures)
  # we can mock the external endpoint using service t which has no sidecar.
  - address: t.istio-system.svc.cluster.local # TODO: this is brittle
    ports:
      http: 8080 # TODO test https
`)

func testdataNetworkingV1alpha3ServiceentryInvalidSkippedYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3ServiceentryInvalidSkippedYaml, nil
}

func testdataNetworkingV1alpha3ServiceentryInvalidSkippedYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3ServiceentryInvalidSkippedYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-ServiceEntry-invalid-skipped.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3ServiceentryValidYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: ServiceEntry
metadata:
  name: valid-service-entry
spec:
  hosts:
  - eu.bookinfo.com
  ports:
  - number: 80
    name: http
    protocol: HTTP
  resolution: DNS
  endpoints:
  # Rather than relying on an external host that might become unreachable (causing test failures)
  # we can mock the external endpoint using service t which has no sidecar.
  - address: t.istio-system.svc.cluster.local # TODO: this is brittle
    ports:
      http: 8080 # TODO test https
`)

func testdataNetworkingV1alpha3ServiceentryValidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3ServiceentryValidYaml, nil
}

func testdataNetworkingV1alpha3ServiceentryValidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3ServiceentryValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-ServiceEntry-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3VirtualserviceInvalidYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: VirtualService
metadata:
  name: invalid-virtual-service
spec:
  http:
    - route:
      - destination:
          host: c
          subset: v1
        weight: 75
      - destination:
          host: c
          subset: v2
        weight: 25
`)

func testdataNetworkingV1alpha3VirtualserviceInvalidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3VirtualserviceInvalidYaml, nil
}

func testdataNetworkingV1alpha3VirtualserviceInvalidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3VirtualserviceInvalidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-VirtualService-invalid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _testdataNetworkingV1alpha3VirtualserviceValidYaml = []byte(`apiVersion: networking.istio.io/v1alpha3
kind: VirtualService
metadata:
  name: valid-virtual-service
spec:
  hosts:
    - c
  http:
    - route:
      - destination:
          host: c
          subset: v1
        weight: 75
      - destination:
          host: c
          subset: v2
        weight: 25
`)

func testdataNetworkingV1alpha3VirtualserviceValidYamlBytes() ([]byte, error) {
	return _testdataNetworkingV1alpha3VirtualserviceValidYaml, nil
}

func testdataNetworkingV1alpha3VirtualserviceValidYaml() (*asset, error) {
	bytes, err := testdataNetworkingV1alpha3VirtualserviceValidYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "testdata/networking-v1alpha3-VirtualService-valid.yaml", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"testdata/authentication-v1alpha1-Policy-invalid.yaml":            testdataAuthenticationV1alpha1PolicyInvalidYaml,
	"testdata/authentication-v1alpha1-Policy-valid.yaml":              testdataAuthenticationV1alpha1PolicyValidYaml,
	"testdata/config-v1alpha2-DestinationPolicy-invalid-skipped.yaml": testdataConfigV1alpha2DestinationpolicyInvalidSkippedYaml,
	"testdata/config-v1alpha2-DestinationPolicy-valid-skipped.yaml":   testdataConfigV1alpha2DestinationpolicyValidSkippedYaml,
	"testdata/config-v1alpha2-EgressRule-invalid-skipped.yaml":        testdataConfigV1alpha2EgressruleInvalidSkippedYaml,
	"testdata/config-v1alpha2-EgressRule-valid-skipped.yaml":          testdataConfigV1alpha2EgressruleValidSkippedYaml,
	"testdata/config-v1alpha2-HTTPAPISpec-invalid.yaml":               testdataConfigV1alpha2HttpapispecInvalidYaml,
	"testdata/config-v1alpha2-HTTPAPISpec-valid.yaml":                 testdataConfigV1alpha2HttpapispecValidYaml,
	"testdata/config-v1alpha2-HTTPAPISpecBinding-invalid.yaml":        testdataConfigV1alpha2HttpapispecbindingInvalidYaml,
	"testdata/config-v1alpha2-HTTPAPISpecBinding-valid.yaml":          testdataConfigV1alpha2HttpapispecbindingValidYaml,
	"testdata/config-v1alpha2-QuotaSpec-invalid.yaml":                 testdataConfigV1alpha2QuotaspecInvalidYaml,
	"testdata/config-v1alpha2-QuotaSpec-valid.yaml":                   testdataConfigV1alpha2QuotaspecValidYaml,
	"testdata/config-v1alpha2-QuotaSpecBinding-invalid.yaml":          testdataConfigV1alpha2QuotaspecbindingInvalidYaml,
	"testdata/config-v1alpha2-QuotaSpecBinding-valid.yaml":            testdataConfigV1alpha2QuotaspecbindingValidYaml,
	"testdata/config-v1alpha2-RouteRule-invalid-skipped.yaml":         testdataConfigV1alpha2RouteruleInvalidSkippedYaml,
	"testdata/config-v1alpha2-RouteRule-valid-skipped.yaml":           testdataConfigV1alpha2RouteruleValidSkippedYaml,
	"testdata/config-v1alpha2-ServiceRole-invalid.yaml":               testdataConfigV1alpha2ServiceroleInvalidYaml,
	"testdata/config-v1alpha2-ServiceRole-valid.yaml":                 testdataConfigV1alpha2ServiceroleValidYaml,
	"testdata/config-v1alpha2-ServiceRoleBinding-invalid.yaml":        testdataConfigV1alpha2ServicerolebindingInvalidYaml,
	"testdata/config-v1alpha2-ServiceRoleBinding-valid.yaml":          testdataConfigV1alpha2ServicerolebindingValidYaml,
	"testdata/config-v1alpha2-apikey-invalid.yaml":                    testdataConfigV1alpha2ApikeyInvalidYaml,
	"testdata/config-v1alpha2-apikey-valid.yaml":                      testdataConfigV1alpha2ApikeyValidYaml,
	"testdata/config-v1alpha2-attributemanifest-invalid.yaml":         testdataConfigV1alpha2AttributemanifestInvalidYaml,
	"testdata/config-v1alpha2-attributemanifest-valid.yaml":           testdataConfigV1alpha2AttributemanifestValidYaml,
	"testdata/config-v1alpha2-authorization-invalid.yaml":             testdataConfigV1alpha2AuthorizationInvalidYaml,
	"testdata/config-v1alpha2-authorization-valid.yaml":               testdataConfigV1alpha2AuthorizationValidYaml,
	"testdata/config-v1alpha2-checknothing-invalid.yaml":              testdataConfigV1alpha2ChecknothingInvalidYaml,
	"testdata/config-v1alpha2-checknothing-valid.yaml":                testdataConfigV1alpha2ChecknothingValidYaml,
	"testdata/config-v1alpha2-circonus-invalid.yaml":                  testdataConfigV1alpha2CirconusInvalidYaml,
	"testdata/config-v1alpha2-circonus-valid.yaml":                    testdataConfigV1alpha2CirconusValidYaml,
	"testdata/config-v1alpha2-denier-invalid.yaml":                    testdataConfigV1alpha2DenierInvalidYaml,
	"testdata/config-v1alpha2-denier-valid.yaml":                      testdataConfigV1alpha2DenierValidYaml,
	"testdata/config-v1alpha2-fluentd-invalid.yaml":                   testdataConfigV1alpha2FluentdInvalidYaml,
	"testdata/config-v1alpha2-fluentd-valid.yaml":                     testdataConfigV1alpha2FluentdValidYaml,
	"testdata/config-v1alpha2-kubernetes-invalid-skipped.yaml":        testdataConfigV1alpha2KubernetesInvalidSkippedYaml,
	"testdata/config-v1alpha2-kubernetes-valid.yaml":                  testdataConfigV1alpha2KubernetesValidYaml,
	"testdata/config-v1alpha2-kubernetesenv-invalid.yaml":             testdataConfigV1alpha2KubernetesenvInvalidYaml,
	"testdata/config-v1alpha2-kubernetesenv-valid.yaml":               testdataConfigV1alpha2KubernetesenvValidYaml,
	"testdata/config-v1alpha2-listchecker-invalid.yaml":               testdataConfigV1alpha2ListcheckerInvalidYaml,
	"testdata/config-v1alpha2-listchecker-valid.yaml":                 testdataConfigV1alpha2ListcheckerValidYaml,
	"testdata/config-v1alpha2-listentry-invalid.yaml":                 testdataConfigV1alpha2ListentryInvalidYaml,
	"testdata/config-v1alpha2-listentry-valid.yaml":                   testdataConfigV1alpha2ListentryValidYaml,
	"testdata/config-v1alpha2-logentry-invalid.yaml":                  testdataConfigV1alpha2LogentryInvalidYaml,
	"testdata/config-v1alpha2-logentry-valid.yaml":                    testdataConfigV1alpha2LogentryValidYaml,
	"testdata/config-v1alpha2-memquota-invalid.yaml":                  testdataConfigV1alpha2MemquotaInvalidYaml,
	"testdata/config-v1alpha2-memquota-valid.yaml":                    testdataConfigV1alpha2MemquotaValidYaml,
	"testdata/config-v1alpha2-metric-invalid.yaml":                    testdataConfigV1alpha2MetricInvalidYaml,
	"testdata/config-v1alpha2-metric-valid.yaml":                      testdataConfigV1alpha2MetricValidYaml,
	"testdata/config-v1alpha2-noop-invalid.yaml":                      testdataConfigV1alpha2NoopInvalidYaml,
	"testdata/config-v1alpha2-noop-valid.yaml":                        testdataConfigV1alpha2NoopValidYaml,
	"testdata/config-v1alpha2-opa-invalid.yaml":                       testdataConfigV1alpha2OpaInvalidYaml,
	"testdata/config-v1alpha2-opa-valid.yaml":                         testdataConfigV1alpha2OpaValidYaml,
	"testdata/config-v1alpha2-prometheus-invalid.yaml":                testdataConfigV1alpha2PrometheusInvalidYaml,
	"testdata/config-v1alpha2-prometheus-valid.yaml":                  testdataConfigV1alpha2PrometheusValidYaml,
	"testdata/config-v1alpha2-quota-invalid.yaml":                     testdataConfigV1alpha2QuotaInvalidYaml,
	"testdata/config-v1alpha2-quota-valid.yaml":                       testdataConfigV1alpha2QuotaValidYaml,
	"testdata/config-v1alpha2-rbac-invalid.yaml":                      testdataConfigV1alpha2RbacInvalidYaml,
	"testdata/config-v1alpha2-rbac-valid.yaml":                        testdataConfigV1alpha2RbacValidYaml,
	"testdata/config-v1alpha2-reportnothing-invalid.yaml":             testdataConfigV1alpha2ReportnothingInvalidYaml,
	"testdata/config-v1alpha2-reportnothing-valid.yaml":               testdataConfigV1alpha2ReportnothingValidYaml,
	"testdata/config-v1alpha2-rule-invalid.yaml":                      testdataConfigV1alpha2RuleInvalidYaml,
	"testdata/config-v1alpha2-rule-valid.yaml":                        testdataConfigV1alpha2RuleValidYaml,
	"testdata/config-v1alpha2-servicecontrol-invalid.yaml":            testdataConfigV1alpha2ServicecontrolInvalidYaml,
	"testdata/config-v1alpha2-servicecontrol-valid.yaml":              testdataConfigV1alpha2ServicecontrolValidYaml,
	"testdata/config-v1alpha2-servicecontrolreport-invalid.yaml":      testdataConfigV1alpha2ServicecontrolreportInvalidYaml,
	"testdata/config-v1alpha2-servicecontrolreport-valid.yaml":        testdataConfigV1alpha2ServicecontrolreportValidYaml,
	"testdata/config-v1alpha2-solarwinds-invalid.yaml":                testdataConfigV1alpha2SolarwindsInvalidYaml,
	"testdata/config-v1alpha2-solarwinds-valid.yaml":                  testdataConfigV1alpha2SolarwindsValidYaml,
	"testdata/config-v1alpha2-stackdriver-invalid.yaml":               testdataConfigV1alpha2StackdriverInvalidYaml,
	"testdata/config-v1alpha2-stackdriver-valid.yaml":                 testdataConfigV1alpha2StackdriverValidYaml,
	"testdata/config-v1alpha2-statsd-invalid.yaml":                    testdataConfigV1alpha2StatsdInvalidYaml,
	"testdata/config-v1alpha2-statsd-valid.yaml":                      testdataConfigV1alpha2StatsdValidYaml,
	"testdata/config-v1alpha2-stdio-invalid.yaml":                     testdataConfigV1alpha2StdioInvalidYaml,
	"testdata/config-v1alpha2-stdio-valid.yaml":                       testdataConfigV1alpha2StdioValidYaml,
	"testdata/config-v1alpha2-tracespan-invalid.yaml":                 testdataConfigV1alpha2TracespanInvalidYaml,
	"testdata/config-v1alpha2-tracespan-valid.yaml":                   testdataConfigV1alpha2TracespanValidYaml,
	"testdata/networking-v1alpha3-DestinationRule-invalid.yaml":       testdataNetworkingV1alpha3DestinationruleInvalidYaml,
	"testdata/networking-v1alpha3-DestinationRule-valid.yaml":         testdataNetworkingV1alpha3DestinationruleValidYaml,
	"testdata/networking-v1alpha3-Gateway-invalid.yaml":               testdataNetworkingV1alpha3GatewayInvalidYaml,
	"testdata/networking-v1alpha3-Gateway-valid.yaml":                 testdataNetworkingV1alpha3GatewayValidYaml,
	"testdata/networking-v1alpha3-ServiceEntry-invalid-skipped.yaml":  testdataNetworkingV1alpha3ServiceentryInvalidSkippedYaml,
	"testdata/networking-v1alpha3-ServiceEntry-valid.yaml":            testdataNetworkingV1alpha3ServiceentryValidYaml,
	"testdata/networking-v1alpha3-VirtualService-invalid.yaml":        testdataNetworkingV1alpha3VirtualserviceInvalidYaml,
	"testdata/networking-v1alpha3-VirtualService-valid.yaml":          testdataNetworkingV1alpha3VirtualserviceValidYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"testdata": {nil, map[string]*bintree{
		"authentication-v1alpha1-Policy-invalid.yaml":            {testdataAuthenticationV1alpha1PolicyInvalidYaml, map[string]*bintree{}},
		"authentication-v1alpha1-Policy-valid.yaml":              {testdataAuthenticationV1alpha1PolicyValidYaml, map[string]*bintree{}},
		"config-v1alpha2-DestinationPolicy-invalid-skipped.yaml": {testdataConfigV1alpha2DestinationpolicyInvalidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-DestinationPolicy-valid-skipped.yaml":   {testdataConfigV1alpha2DestinationpolicyValidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-EgressRule-invalid-skipped.yaml":        {testdataConfigV1alpha2EgressruleInvalidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-EgressRule-valid-skipped.yaml":          {testdataConfigV1alpha2EgressruleValidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-HTTPAPISpec-invalid.yaml":               {testdataConfigV1alpha2HttpapispecInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-HTTPAPISpec-valid.yaml":                 {testdataConfigV1alpha2HttpapispecValidYaml, map[string]*bintree{}},
		"config-v1alpha2-HTTPAPISpecBinding-invalid.yaml":        {testdataConfigV1alpha2HttpapispecbindingInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-HTTPAPISpecBinding-valid.yaml":          {testdataConfigV1alpha2HttpapispecbindingValidYaml, map[string]*bintree{}},
		"config-v1alpha2-QuotaSpec-invalid.yaml":                 {testdataConfigV1alpha2QuotaspecInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-QuotaSpec-valid.yaml":                   {testdataConfigV1alpha2QuotaspecValidYaml, map[string]*bintree{}},
		"config-v1alpha2-QuotaSpecBinding-invalid.yaml":          {testdataConfigV1alpha2QuotaspecbindingInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-QuotaSpecBinding-valid.yaml":            {testdataConfigV1alpha2QuotaspecbindingValidYaml, map[string]*bintree{}},
		"config-v1alpha2-RouteRule-invalid-skipped.yaml":         {testdataConfigV1alpha2RouteruleInvalidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-RouteRule-valid-skipped.yaml":           {testdataConfigV1alpha2RouteruleValidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-ServiceRole-invalid.yaml":               {testdataConfigV1alpha2ServiceroleInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-ServiceRole-valid.yaml":                 {testdataConfigV1alpha2ServiceroleValidYaml, map[string]*bintree{}},
		"config-v1alpha2-ServiceRoleBinding-invalid.yaml":        {testdataConfigV1alpha2ServicerolebindingInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-ServiceRoleBinding-valid.yaml":          {testdataConfigV1alpha2ServicerolebindingValidYaml, map[string]*bintree{}},
		"config-v1alpha2-apikey-invalid.yaml":                    {testdataConfigV1alpha2ApikeyInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-apikey-valid.yaml":                      {testdataConfigV1alpha2ApikeyValidYaml, map[string]*bintree{}},
		"config-v1alpha2-attributemanifest-invalid.yaml":         {testdataConfigV1alpha2AttributemanifestInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-attributemanifest-valid.yaml":           {testdataConfigV1alpha2AttributemanifestValidYaml, map[string]*bintree{}},
		"config-v1alpha2-authorization-invalid.yaml":             {testdataConfigV1alpha2AuthorizationInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-authorization-valid.yaml":               {testdataConfigV1alpha2AuthorizationValidYaml, map[string]*bintree{}},
		"config-v1alpha2-checknothing-invalid.yaml":              {testdataConfigV1alpha2ChecknothingInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-checknothing-valid.yaml":                {testdataConfigV1alpha2ChecknothingValidYaml, map[string]*bintree{}},
		"config-v1alpha2-circonus-invalid.yaml":                  {testdataConfigV1alpha2CirconusInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-circonus-valid.yaml":                    {testdataConfigV1alpha2CirconusValidYaml, map[string]*bintree{}},
		"config-v1alpha2-denier-invalid.yaml":                    {testdataConfigV1alpha2DenierInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-denier-valid.yaml":                      {testdataConfigV1alpha2DenierValidYaml, map[string]*bintree{}},
		"config-v1alpha2-fluentd-invalid.yaml":                   {testdataConfigV1alpha2FluentdInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-fluentd-valid.yaml":                     {testdataConfigV1alpha2FluentdValidYaml, map[string]*bintree{}},
		"config-v1alpha2-kubernetes-invalid-skipped.yaml":        {testdataConfigV1alpha2KubernetesInvalidSkippedYaml, map[string]*bintree{}},
		"config-v1alpha2-kubernetes-valid.yaml":                  {testdataConfigV1alpha2KubernetesValidYaml, map[string]*bintree{}},
		"config-v1alpha2-kubernetesenv-invalid.yaml":             {testdataConfigV1alpha2KubernetesenvInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-kubernetesenv-valid.yaml":               {testdataConfigV1alpha2KubernetesenvValidYaml, map[string]*bintree{}},
		"config-v1alpha2-listchecker-invalid.yaml":               {testdataConfigV1alpha2ListcheckerInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-listchecker-valid.yaml":                 {testdataConfigV1alpha2ListcheckerValidYaml, map[string]*bintree{}},
		"config-v1alpha2-listentry-invalid.yaml":                 {testdataConfigV1alpha2ListentryInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-listentry-valid.yaml":                   {testdataConfigV1alpha2ListentryValidYaml, map[string]*bintree{}},
		"config-v1alpha2-logentry-invalid.yaml":                  {testdataConfigV1alpha2LogentryInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-logentry-valid.yaml":                    {testdataConfigV1alpha2LogentryValidYaml, map[string]*bintree{}},
		"config-v1alpha2-memquota-invalid.yaml":                  {testdataConfigV1alpha2MemquotaInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-memquota-valid.yaml":                    {testdataConfigV1alpha2MemquotaValidYaml, map[string]*bintree{}},
		"config-v1alpha2-metric-invalid.yaml":                    {testdataConfigV1alpha2MetricInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-metric-valid.yaml":                      {testdataConfigV1alpha2MetricValidYaml, map[string]*bintree{}},
		"config-v1alpha2-noop-invalid.yaml":                      {testdataConfigV1alpha2NoopInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-noop-valid.yaml":                        {testdataConfigV1alpha2NoopValidYaml, map[string]*bintree{}},
		"config-v1alpha2-opa-invalid.yaml":                       {testdataConfigV1alpha2OpaInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-opa-valid.yaml":                         {testdataConfigV1alpha2OpaValidYaml, map[string]*bintree{}},
		"config-v1alpha2-prometheus-invalid.yaml":                {testdataConfigV1alpha2PrometheusInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-prometheus-valid.yaml":                  {testdataConfigV1alpha2PrometheusValidYaml, map[string]*bintree{}},
		"config-v1alpha2-quota-invalid.yaml":                     {testdataConfigV1alpha2QuotaInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-quota-valid.yaml":                       {testdataConfigV1alpha2QuotaValidYaml, map[string]*bintree{}},
		"config-v1alpha2-rbac-invalid.yaml":                      {testdataConfigV1alpha2RbacInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-rbac-valid.yaml":                        {testdataConfigV1alpha2RbacValidYaml, map[string]*bintree{}},
		"config-v1alpha2-reportnothing-invalid.yaml":             {testdataConfigV1alpha2ReportnothingInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-reportnothing-valid.yaml":               {testdataConfigV1alpha2ReportnothingValidYaml, map[string]*bintree{}},
		"config-v1alpha2-rule-invalid.yaml":                      {testdataConfigV1alpha2RuleInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-rule-valid.yaml":                        {testdataConfigV1alpha2RuleValidYaml, map[string]*bintree{}},
		"config-v1alpha2-servicecontrol-invalid.yaml":            {testdataConfigV1alpha2ServicecontrolInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-servicecontrol-valid.yaml":              {testdataConfigV1alpha2ServicecontrolValidYaml, map[string]*bintree{}},
		"config-v1alpha2-servicecontrolreport-invalid.yaml":      {testdataConfigV1alpha2ServicecontrolreportInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-servicecontrolreport-valid.yaml":        {testdataConfigV1alpha2ServicecontrolreportValidYaml, map[string]*bintree{}},
		"config-v1alpha2-solarwinds-invalid.yaml":                {testdataConfigV1alpha2SolarwindsInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-solarwinds-valid.yaml":                  {testdataConfigV1alpha2SolarwindsValidYaml, map[string]*bintree{}},
		"config-v1alpha2-stackdriver-invalid.yaml":               {testdataConfigV1alpha2StackdriverInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-stackdriver-valid.yaml":                 {testdataConfigV1alpha2StackdriverValidYaml, map[string]*bintree{}},
		"config-v1alpha2-statsd-invalid.yaml":                    {testdataConfigV1alpha2StatsdInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-statsd-valid.yaml":                      {testdataConfigV1alpha2StatsdValidYaml, map[string]*bintree{}},
		"config-v1alpha2-stdio-invalid.yaml":                     {testdataConfigV1alpha2StdioInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-stdio-valid.yaml":                       {testdataConfigV1alpha2StdioValidYaml, map[string]*bintree{}},
		"config-v1alpha2-tracespan-invalid.yaml":                 {testdataConfigV1alpha2TracespanInvalidYaml, map[string]*bintree{}},
		"config-v1alpha2-tracespan-valid.yaml":                   {testdataConfigV1alpha2TracespanValidYaml, map[string]*bintree{}},
		"networking-v1alpha3-DestinationRule-invalid.yaml":       {testdataNetworkingV1alpha3DestinationruleInvalidYaml, map[string]*bintree{}},
		"networking-v1alpha3-DestinationRule-valid.yaml":         {testdataNetworkingV1alpha3DestinationruleValidYaml, map[string]*bintree{}},
		"networking-v1alpha3-Gateway-invalid.yaml":               {testdataNetworkingV1alpha3GatewayInvalidYaml, map[string]*bintree{}},
		"networking-v1alpha3-Gateway-valid.yaml":                 {testdataNetworkingV1alpha3GatewayValidYaml, map[string]*bintree{}},
		"networking-v1alpha3-ServiceEntry-invalid-skipped.yaml":  {testdataNetworkingV1alpha3ServiceentryInvalidSkippedYaml, map[string]*bintree{}},
		"networking-v1alpha3-ServiceEntry-valid.yaml":            {testdataNetworkingV1alpha3ServiceentryValidYaml, map[string]*bintree{}},
		"networking-v1alpha3-VirtualService-invalid.yaml":        {testdataNetworkingV1alpha3VirtualserviceInvalidYaml, map[string]*bintree{}},
		"networking-v1alpha3-VirtualService-valid.yaml":          {testdataNetworkingV1alpha3VirtualserviceValidYaml, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
