// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/edge/template_handler_service.proto

/*
	Package edge is a generated protocol buffer package.

	The `edge` template represents an edge in the mesh graph.

	The `edge` template represents an edge in the mesh graph

	When writing the configuration, the value for the fields associated
	with this template can either be a literal or an
	[expression](https://istio.io/docs/reference/config/mixer/expression-language.html). Please
	note that if the datatype of a field is not
	istio.mixer.adapter.model.v1beta1.Value, then the expression's
	[inferred
	type](https://istio.io/docs/reference/config/mixer/expression-language.html#type-checking)
	must match the datatype of the field.

	Example config:
	```yaml
	apiVersion: "config.istio.io/v1alpha2"
	kind: edge
	metadata:
	  name: default
	  namespace: istio-system
	spec:
	  timestamp: request.time
	  sourceUid: source.uid | "Unknown"
	  sourceOwner: source.owner | "Unknown"
	  sourceWorkloadName: source.workload.name | "Unknown"
	  sourceWorkloadNamespace: source.workload.namespace | "Unknown"
	  destinationUid: destination.uid | "Unknown"
	  destinationOwner: destination.owner | "Unknown"
	  destinationWorkloadName: destination.workload.name | "Unknown"
	  destinationWorkloadNamespace: destination.workload.namespace | "Unknown"
	  apiProtocol: api.protocol | "Unknown"
	  contextProtocol: context.protocol | "Unknown"
	```

	It is generated from these files:
		mixer/template/edge/template_handler_service.proto

	It has these top-level messages:
		HandleEdgeRequest
		InstanceMsg
		Type
		InstanceParam
*/
package edge

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleEdge method.
type HandleEdgeRequest struct {
	// 'edge' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleEdgeRequest) Reset()      { *m = HandleEdgeRequest{} }
func (*HandleEdgeRequest) ProtoMessage() {}
func (*HandleEdgeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{0}
}

// Contains instance payload for 'edge' template. This is passed to infrastructure backends during request-time
// through HandleEdgeService.HandleEdge.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp
	Timestamp *istio_policy_v1beta1.TimeStamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp,omitempty"`
	// Source of edge.
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	SourceWorkloadName      string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	SourceOwner             string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	SourceUid               string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Destination of edge
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	DestinationWorkloadName      string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	DestinationOwner             string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	DestinationUid               string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Protocol used
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	ApiProtocol     string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'edge' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTemplateHandlerService, []int{2} }

// Represents instance configuration schema for 'edge' template.
type InstanceParam struct {
	// Timestamp
	Timestamp string `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Source of edge.
	SourceWorkloadNamespace string `protobuf:"bytes,10,opt,name=source_workload_namespace,json=sourceWorkloadNamespace,proto3" json:"source_workload_namespace,omitempty"`
	SourceWorkloadName      string `protobuf:"bytes,11,opt,name=source_workload_name,json=sourceWorkloadName,proto3" json:"source_workload_name,omitempty"`
	SourceOwner             string `protobuf:"bytes,12,opt,name=source_owner,json=sourceOwner,proto3" json:"source_owner,omitempty"`
	SourceUid               string `protobuf:"bytes,13,opt,name=source_uid,json=sourceUid,proto3" json:"source_uid,omitempty"`
	// Destination of edge
	DestinationWorkloadNamespace string `protobuf:"bytes,20,opt,name=destination_workload_namespace,json=destinationWorkloadNamespace,proto3" json:"destination_workload_namespace,omitempty"`
	DestinationWorkloadName      string `protobuf:"bytes,21,opt,name=destination_workload_name,json=destinationWorkloadName,proto3" json:"destination_workload_name,omitempty"`
	DestinationOwner             string `protobuf:"bytes,22,opt,name=destination_owner,json=destinationOwner,proto3" json:"destination_owner,omitempty"`
	DestinationUid               string `protobuf:"bytes,23,opt,name=destination_uid,json=destinationUid,proto3" json:"destination_uid,omitempty"`
	// Protocol used
	ContextProtocol string `protobuf:"bytes,30,opt,name=context_protocol,json=contextProtocol,proto3" json:"context_protocol,omitempty"`
	ApiProtocol     string `protobuf:"bytes,31,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleEdgeRequest)(nil), "edge.HandleEdgeRequest")
	proto.RegisterType((*InstanceMsg)(nil), "edge.InstanceMsg")
	proto.RegisterType((*Type)(nil), "edge.Type")
	proto.RegisterType((*InstanceParam)(nil), "edge.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleEdgeService service

type HandleEdgeServiceClient interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleEdgeServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleEdgeServiceClient(cc *grpc.ClientConn) HandleEdgeServiceClient {
	return &handleEdgeServiceClient{cc}
}

func (c *handleEdgeServiceClient) HandleEdge(ctx context.Context, in *HandleEdgeRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/edge.HandleEdgeService/HandleEdge", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleEdgeService service

type HandleEdgeServiceServer interface {
	// HandleEdge is called by Mixer at request-time to deliver 'edge' instances to the backend.
	HandleEdge(context.Context, *HandleEdgeRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleEdgeServiceServer(s *grpc.Server, srv HandleEdgeServiceServer) {
	s.RegisterService(&_HandleEdgeService_serviceDesc, srv)
}

func _HandleEdgeService_HandleEdge_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleEdgeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/edge.HandleEdgeService/HandleEdge",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleEdgeServiceServer).HandleEdge(ctx, req.(*HandleEdgeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleEdgeService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "edge.HandleEdgeService",
	HandlerType: (*HandleEdgeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleEdge",
			Handler:    _HandleEdgeService_HandleEdge_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/edge/template_handler_service.proto",
}

func (m *HandleEdgeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleEdgeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Timestamp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.Timestamp.Size()))
		n2, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i += copy(dAtA[i:], m.SourceWorkloadNamespace)
	}
	if len(m.SourceWorkloadName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i += copy(dAtA[i:], m.SourceWorkloadName)
	}
	if len(m.SourceOwner) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i += copy(dAtA[i:], m.SourceOwner)
	}
	if len(m.SourceUid) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i += copy(dAtA[i:], m.SourceUid)
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i += copy(dAtA[i:], m.DestinationWorkloadNamespace)
	}
	if len(m.DestinationWorkloadName) > 0 {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i += copy(dAtA[i:], m.DestinationWorkloadName)
	}
	if len(m.DestinationOwner) > 0 {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i += copy(dAtA[i:], m.DestinationOwner)
	}
	if len(m.DestinationUid) > 0 {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i += copy(dAtA[i:], m.DestinationUid)
	}
	if len(m.ContextProtocol) > 0 {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i += copy(dAtA[i:], m.ContextProtocol)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Timestamp) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Timestamp)))
		i += copy(dAtA[i:], m.Timestamp)
	}
	if len(m.SourceWorkloadNamespace) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadNamespace)))
		i += copy(dAtA[i:], m.SourceWorkloadNamespace)
	}
	if len(m.SourceWorkloadName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceWorkloadName)))
		i += copy(dAtA[i:], m.SourceWorkloadName)
	}
	if len(m.SourceOwner) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceOwner)))
		i += copy(dAtA[i:], m.SourceOwner)
	}
	if len(m.SourceUid) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.SourceUid)))
		i += copy(dAtA[i:], m.SourceUid)
	}
	if len(m.DestinationWorkloadNamespace) > 0 {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadNamespace)))
		i += copy(dAtA[i:], m.DestinationWorkloadNamespace)
	}
	if len(m.DestinationWorkloadName) > 0 {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationWorkloadName)))
		i += copy(dAtA[i:], m.DestinationWorkloadName)
	}
	if len(m.DestinationOwner) > 0 {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationOwner)))
		i += copy(dAtA[i:], m.DestinationOwner)
	}
	if len(m.DestinationUid) > 0 {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DestinationUid)))
		i += copy(dAtA[i:], m.DestinationUid)
	}
	if len(m.ContextProtocol) > 0 {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ContextProtocol)))
		i += copy(dAtA[i:], m.ContextProtocol)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	return i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleEdgeRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadNamespace)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceWorkloadName)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceOwner)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.SourceUid)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadNamespace)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationWorkloadName)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationOwner)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DestinationUid)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ContextProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleEdgeRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleEdgeRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceMsg{`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "TimeStamp", "istio_policy_v1beta1.TimeStamp", 1) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Type{`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InstanceParam{`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`SourceWorkloadNamespace:` + fmt.Sprintf("%v", this.SourceWorkloadNamespace) + `,`,
		`SourceWorkloadName:` + fmt.Sprintf("%v", this.SourceWorkloadName) + `,`,
		`SourceOwner:` + fmt.Sprintf("%v", this.SourceOwner) + `,`,
		`SourceUid:` + fmt.Sprintf("%v", this.SourceUid) + `,`,
		`DestinationWorkloadNamespace:` + fmt.Sprintf("%v", this.DestinationWorkloadNamespace) + `,`,
		`DestinationWorkloadName:` + fmt.Sprintf("%v", this.DestinationWorkloadName) + `,`,
		`DestinationOwner:` + fmt.Sprintf("%v", this.DestinationOwner) + `,`,
		`DestinationUid:` + fmt.Sprintf("%v", this.DestinationUid) + `,`,
		`ContextProtocol:` + fmt.Sprintf("%v", this.ContextProtocol) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleEdgeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleEdgeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleEdgeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &istio_policy_v1beta1.TimeStamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadNamespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadNamespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationWorkloadName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationWorkloadName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationUid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationUid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContextProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ContextProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/template/edge/template_handler_service.proto", fileDescriptorTemplateHandlerService)
}

var fileDescriptorTemplateHandlerService = []byte{
	// 658 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x55, 0x3d, 0x6f, 0xd3, 0x50,
	0x14, 0xb5, 0xdb, 0xa8, 0x90, 0x97, 0x7e, 0x3e, 0xa5, 0xd4, 0xa9, 0xca, 0x6b, 0xc9, 0x42, 0x10,
	0xc8, 0xa6, 0x61, 0x2b, 0x42, 0xe2, 0x53, 0xa2, 0x03, 0x50, 0xb9, 0x05, 0x46, 0xeb, 0xd5, 0xbe,
	0x35, 0x4f, 0xb5, 0xfd, 0x8c, 0xfd, 0xd2, 0x36, 0x1b, 0x82, 0x3f, 0x80, 0xd4, 0x95, 0x1f, 0xc0,
	0xc6, 0x8c, 0xc4, 0x0f, 0xa8, 0x98, 0x2a, 0x26, 0x16, 0x24, 0x62, 0x3a, 0x30, 0x76, 0x64, 0x44,
	0x7e, 0x7e, 0x49, 0x2c, 0xda, 0xf2, 0x03, 0x10, 0x5b, 0xee, 0xb9, 0xe7, 0xdc, 0x77, 0x8f, 0x75,
	0x75, 0x82, 0xda, 0x21, 0xdb, 0x83, 0xc4, 0x12, 0x10, 0xc6, 0x01, 0x15, 0x60, 0x81, 0xe7, 0xc3,
	0xa0, 0x72, 0x5e, 0xd0, 0xc8, 0x0b, 0x20, 0x71, 0x52, 0x48, 0x76, 0x98, 0x0b, 0x66, 0x9c, 0x70,
	0xc1, 0x71, 0x25, 0x27, 0xcd, 0xd7, 0x7d, 0xee, 0x73, 0x09, 0x58, 0xf9, 0xaf, 0xa2, 0x37, 0x7f,
	0xad, 0x98, 0x47, 0x3d, 0x1a, 0x0b, 0x48, 0xac, 0x90, 0x7b, 0x10, 0x58, 0x3b, 0xcb, 0x9b, 0x20,
	0xe8, 0xb2, 0x05, 0x7b, 0x02, 0xa2, 0x94, 0xf1, 0x28, 0x55, 0xec, 0x86, 0xcf, 0xb9, 0x1f, 0x80,
	0x25, 0xab, 0xcd, 0xce, 0x96, 0x45, 0xa3, 0xae, 0x6a, 0xb5, 0xfe, 0x36, 0x28, 0x81, 0x98, 0x27,
	0xa2, 0x3f, 0x24, 0xe6, 0x01, 0x73, 0xbb, 0x83, 0xa6, 0xe8, 0xc6, 0x6a, 0xd3, 0xe6, 0x3b, 0x1d,
	0xcd, 0x3c, 0x94, 0x1e, 0x1e, 0x78, 0x3e, 0xd8, 0xf0, 0xb2, 0x03, 0xa9, 0xc0, 0x16, 0xaa, 0xb2,
	0x28, 0x15, 0x34, 0x72, 0x21, 0x35, 0xf4, 0xa5, 0xd1, 0x56, 0xad, 0x3d, 0x63, 0xe6, 0x9e, 0xcc,
	0x55, 0x05, 0x3f, 0x4a, 0x7d, 0x7b, 0xc8, 0xc1, 0x37, 0xd1, 0xa4, 0xda, 0xc3, 0x71, 0x79, 0xb4,
	0xc5, 0x7c, 0x63, 0x64, 0x49, 0x6f, 0xd5, 0xda, 0x75, 0xb3, 0xd8, 0xdf, 0xec, 0xef, 0x6f, 0xde,
	0x89, 0xba, 0xf6, 0x84, 0xe2, 0xde, 0x93, 0x54, 0xdc, 0x40, 0xe7, 0x3d, 0xf0, 0x3a, 0xb1, 0xc3,
	0x3c, 0x63, 0x74, 0x49, 0x6f, 0x55, 0xed, 0x73, 0xb2, 0x5e, 0xf5, 0x9a, 0x1f, 0x2b, 0xa8, 0x56,
	0x7a, 0x12, 0xdf, 0x42, 0x55, 0xc1, 0x42, 0x48, 0x05, 0x0d, 0x63, 0x43, 0x97, 0x4f, 0x2c, 0x9a,
	0x2c, 0x15, 0x8c, 0x9b, 0x85, 0x47, 0x53, 0x79, 0x34, 0x37, 0x58, 0x08, 0xeb, 0x39, 0xcd, 0x1e,
	0x2a, 0xf0, 0x0a, 0x6a, 0xa4, 0xbc, 0x93, 0xb8, 0xe0, 0xec, 0xf2, 0x64, 0x3b, 0xe0, 0xd4, 0x73,
	0x22, 0x1a, 0x42, 0x1a, 0x53, 0x17, 0x0c, 0x24, 0x9f, 0x9e, 0x2b, 0x08, 0xcf, 0x55, 0xff, 0x71,
	0xbf, 0x8d, 0xaf, 0xa3, 0xfa, 0x69, 0x5a, 0xa3, 0x26, 0x65, 0xf8, 0xa4, 0x0c, 0x5f, 0x42, 0xe3,
	0x4a, 0xc1, 0x77, 0x23, 0x48, 0x8c, 0x71, 0xc9, 0xac, 0x15, 0xd8, 0x93, 0x1c, 0xc2, 0x17, 0x11,
	0x52, 0x94, 0x0e, 0xf3, 0x8c, 0x09, 0x49, 0xa8, 0x16, 0xc8, 0x53, 0xe6, 0xe1, 0xfb, 0x88, 0x78,
	0x90, 0x0a, 0x16, 0x51, 0xc1, 0x78, 0x74, 0xda, 0xd2, 0x75, 0x29, 0x59, 0x28, 0xb1, 0x4e, 0x6e,
	0xbe, 0x82, 0x1a, 0x67, 0x4e, 0x31, 0x66, 0x0b, 0xd7, 0x67, 0x0c, 0xc0, 0x57, 0xd1, 0x4c, 0x59,
	0x5b, 0x18, 0xb9, 0x20, 0x35, 0xd3, 0xa5, 0x46, 0xe1, 0xe6, 0x32, 0x9a, 0x2a, 0x93, 0x73, 0x4b,
	0x73, 0x92, 0x3a, 0x59, 0x82, 0x73, 0x5f, 0x57, 0xd0, 0xb4, 0xcb, 0x23, 0x01, 0x7b, 0xc2, 0x91,
	0x87, 0xe1, 0xf2, 0xc0, 0x20, 0x92, 0x39, 0xa5, 0xf0, 0x35, 0x05, 0xe7, 0x1f, 0x91, 0xc6, 0x6c,
	0x48, 0x5b, 0x2c, 0x3e, 0x22, 0x8d, 0xd9, 0x80, 0x32, 0x8b, 0x2a, 0xd2, 0xca, 0x87, 0xcf, 0x9f,
	0x9a, 0xb2, 0x2b, 0xcb, 0xe6, 0x18, 0xaa, 0x6c, 0x74, 0x63, 0x68, 0xbe, 0xa9, 0xa0, 0x89, 0xfe,
	0x0d, 0xad, 0xd1, 0x84, 0x86, 0x78, 0xe1, 0xcf, 0x2b, 0xaa, 0xfe, 0x3f, 0x92, 0x7f, 0xfc, 0x48,
	0xda, 0xdb, 0xe5, 0x9c, 0x5b, 0x2f, 0xd2, 0x1a, 0x3f, 0x43, 0x68, 0x08, 0xe2, 0xb9, 0x22, 0xe2,
	0x4e, 0xc4, 0xe1, 0xbc, 0xa5, 0x22, 0x46, 0x06, 0xae, 0xa9, 0xc2, 0xcb, 0x94, 0x81, 0x3b, 0xc8,
	0x1b, 0x5b, 0x06, 0xae, 0x0d, 0x69, 0x27, 0x10, 0x77, 0x6f, 0x1f, 0xf4, 0x88, 0x76, 0xd8, 0x23,
	0xda, 0xd7, 0x1e, 0xd1, 0x8e, 0x7b, 0x44, 0x7b, 0x95, 0x11, 0xfd, 0x7d, 0x46, 0xb4, 0x83, 0x8c,
	0xe8, 0x87, 0x19, 0xd1, 0xbf, 0x67, 0x44, 0xff, 0x99, 0x11, 0xed, 0x38, 0x23, 0xfa, 0xdb, 0x1f,
	0x44, 0xfb, 0xf5, 0xe5, 0x68, 0x7f, 0x44, 0x7f, 0xfd, 0xed, 0x68, 0x7f, 0x44, 0xfe, 0x77, 0x6c,
	0x8e, 0x49, 0x2f, 0x37, 0x7e, 0x07, 0x00, 0x00, 0xff, 0xff, 0x5d, 0x7b, 0x76, 0x61, 0x7e, 0x06,
	0x00, 0x00,
}
