// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/signalfx/config/config.proto

/*
	Package config is a generated protocol buffer package.

	The `signalfx` adapter collects Istio metrics and trace spans and sends them
	to [SignalFx](https://signalfx.com).

	This adapter supports the [metric template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/metric/)
	and [tracespan template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/tracespan/).

	If sending trace spans, this adapter can make use of certain conventions in
	the tracespan format that is configured to send to this adapter.  Here is an
	example tracespan spec that will work well:

	```yaml
	apiVersion: config.istio.io/v1alpha2
	kind: tracespan
	metadata:
	  name: signalfx
	spec:
	  traceId: request.headers["x-b3-traceid"] | ""
	  spanId: request.headers["x-b3-spanid"] | ""
	  parentSpanId: request.headers["x-b3-parentspanid"] | ""
	  # If the path contains query parameters, they will be split off and put into
	  # tags such that the span name sent to SignalFx will consist only of the path
	  # itself.
	  spanName: request.path | "/"
	  startTime: request.time
	  endTime: response.time
	  # If this is >=500, the span will get an 'error' tag
	  httpStatusCode: response.code | 0
	  clientSpan: context.reporter.kind == "outbound"
	  # Span tags below that do not have comments are useful but optional and will
	  # be passed to SignalFx unmodified. The tags that have comments are interpreted
	  # in a special manner, but are still optional.
	  spanTags:
	    # This is used to determine whether the span pertains to the client or
	    # server side of the request.
	    context.reporter.local: context.reporter.local
	    # This gets put into the remoteEndpoint.ipv4 field
	    destination.ip: destination.ip | ip("0.0.0.0")
	    # This gets flattened out to individual tags of the form
	    # 'destination.labels.<key>: <value>'.
	    destination.labels: destination.labels
	    # This gets put into the remoteEndpoint.name field
	    destination.name: destination.name | "unknown"
	    destination.namespace: destination.namespace | "unknown"
	    request.host: request.host | ""
	    request.method: request.method | ""
	    request.path: request.path | ""
	    request.size: request.size | 0
	    request.useragent: request.useragent | ""
	    response.size: response.size | 0
	    # This gets put into the localEndpoint.name field
	    source.name: source.name | "unknown"
	    # This gets put into the localEndpoint.ipv4 field
	    source.ip: source.ip | ip("0.0.0.0")
	    source.namespace: source.namespace | "unknown"
	    # This gets flattened out to individual tags of the form
	    # 'source.labels.<key>: <value>'.
	    source.labels: source.labels
	    source.version: source.labels["version"] | "unknown"
	 ```

	It is generated from these files:
		mixer/adapter/signalfx/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"

import time "time"

import strconv "strconv"

import binary "encoding/binary"
import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Describes what kind of metric this is.
type Params_MetricConfig_Type int32

const (
	// None is the default and is invalid
	NONE Params_MetricConfig_Type = 0
	// Values with the same set of dimensions will be added together
	// as a continuously incrementing value.
	COUNTER Params_MetricConfig_Type = 1
	// A histogram distribution.  This will result in several metrics
	// emitted for each unique set of dimensions.
	HISTOGRAM Params_MetricConfig_Type = 2
)

var Params_MetricConfig_Type_name = map[int32]string{
	0: "NONE",
	1: "COUNTER",
	2: "HISTOGRAM",
}
var Params_MetricConfig_Type_value = map[string]int32{
	"NONE":      0,
	"COUNTER":   1,
	"HISTOGRAM": 2,
}

func (Params_MetricConfig_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0}
}

// Configuration format for the `signalfx` adapter.
type Params struct {
	// Required. The set of metrics to send to SignalFx. If an Istio metric is
	// configured to be sent to this adapter, it must have a corresponding
	// description here.
	Metrics []*Params_MetricConfig `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
	// Optional. The URL of the SignalFx ingest server to use.  Will default to
	// the global ingest server if not specified.
	IngestUrl string `protobuf:"bytes,2,opt,name=ingest_url,json=ingestUrl,proto3" json:"ingest_url,omitempty"`
	// Required. The access token for the SignalFx organization that should
	// receive the metrics.
	AccessToken string `protobuf:"bytes,3,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	// Optional. Specifies how frequently to send metrics to SignalFx.  Metrics
	// reported to this adapter are collected and reported as a timeseries.
	// This will be rounded to the nearest second and rounded values less than
	// one second are not valid. Defaults to 10 seconds if not specified.
	DatapointInterval time.Duration `protobuf:"bytes,4,opt,name=datapoint_interval,json=datapointInterval,stdduration" json:"datapoint_interval"`
	// Optional.  If set to false, metrics won't be sent (but trace spans will
	// be sent, unless otherwise disabled).
	EnableMetrics bool `protobuf:"varint,5,opt,name=enable_metrics,json=enableMetrics,proto3" json:"enable_metrics,omitempty"`
	// Optional.  If set to false, trace spans won't be sent (but metrics will
	// be sent, unless otherwise disabled).
	EnableTracing bool `protobuf:"varint,6,opt,name=enable_tracing,json=enableTracing,proto3" json:"enable_tracing,omitempty"`
	// Optional.  The number of trace spans that the adapter will buffer before
	// dropping them.  This defaults to 1000 spans but can be configured higher
	// if needed.  An error message will be logged if spans are dropped.
	TracingBufferSize uint32 `protobuf:"varint,7,opt,name=tracing_buffer_size,json=tracingBufferSize,proto3" json:"tracing_buffer_size,omitempty"`
	// Optional. The uniform probability ([0.0, 1.0]) that a given span gets
	// sampled if its parent was not already sampled.  Child spans will always
	// be sampled if their parent is.  If not provided, defaults to sending all
	// spans.
	TracingSampleProbability float64 `protobuf:"fixed64,8,opt,name=tracing_sample_probability,json=tracingSampleProbability,proto3" json:"tracing_sample_probability,omitempty"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

// Describes what metrics should be sent to SignalFx and in what form.
type Params_MetricConfig struct {
	// Required.  The name of the metric as it is sent to the adapter.  In
	// Kubernetes this is of the form "<name>.metric.<namespace>" where
	// "<name>" is the name field of the metric resource, and "<namespace>"
	// is the namespace of the metric resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The metric type of the metric
	Type Params_MetricConfig_Type `protobuf:"varint,4,opt,name=type,proto3,enum=adapter.signalfx.config.Params_MetricConfig_Type" json:"type,omitempty"`
}

func (m *Params_MetricConfig) Reset()                    { *m = Params_MetricConfig{} }
func (*Params_MetricConfig) ProtoMessage()               {}
func (*Params_MetricConfig) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0, 0} }

func init() {
	proto.RegisterType((*Params)(nil), "adapter.signalfx.config.Params")
	proto.RegisterType((*Params_MetricConfig)(nil), "adapter.signalfx.config.Params.MetricConfig")
	proto.RegisterEnum("adapter.signalfx.config.Params_MetricConfig_Type", Params_MetricConfig_Type_name, Params_MetricConfig_Type_value)
}
func (x Params_MetricConfig_Type) String() string {
	s, ok := Params_MetricConfig_Type_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IngestUrl) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.IngestUrl)))
		i += copy(dAtA[i:], m.IngestUrl)
	}
	if len(m.AccessToken) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.AccessToken)))
		i += copy(dAtA[i:], m.AccessToken)
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintConfig(dAtA, i, uint64(types.SizeOfStdDuration(m.DatapointInterval)))
	n1, err := types.StdDurationMarshalTo(m.DatapointInterval, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.EnableMetrics {
		dAtA[i] = 0x28
		i++
		if m.EnableMetrics {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.EnableTracing {
		dAtA[i] = 0x30
		i++
		if m.EnableTracing {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.TracingBufferSize != 0 {
		dAtA[i] = 0x38
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.TracingBufferSize))
	}
	if m.TracingSampleProbability != 0 {
		dAtA[i] = 0x41
		i++
		binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.TracingSampleProbability))))
		i += 8
	}
	return i, nil
}

func (m *Params_MetricConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Type != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Type))
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.IngestUrl)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.AccessToken)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = types.SizeOfStdDuration(m.DatapointInterval)
	n += 1 + l + sovConfig(uint64(l))
	if m.EnableMetrics {
		n += 2
	}
	if m.EnableTracing {
		n += 2
	}
	if m.TracingBufferSize != 0 {
		n += 1 + sovConfig(uint64(m.TracingBufferSize))
	}
	if m.TracingSampleProbability != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovConfig(uint64(m.Type))
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`Metrics:` + strings.Replace(fmt.Sprintf("%v", this.Metrics), "Params_MetricConfig", "Params_MetricConfig", 1) + `,`,
		`IngestUrl:` + fmt.Sprintf("%v", this.IngestUrl) + `,`,
		`AccessToken:` + fmt.Sprintf("%v", this.AccessToken) + `,`,
		`DatapointInterval:` + strings.Replace(strings.Replace(this.DatapointInterval.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`EnableMetrics:` + fmt.Sprintf("%v", this.EnableMetrics) + `,`,
		`EnableTracing:` + fmt.Sprintf("%v", this.EnableTracing) + `,`,
		`TracingBufferSize:` + fmt.Sprintf("%v", this.TracingBufferSize) + `,`,
		`TracingSampleProbability:` + fmt.Sprintf("%v", this.TracingSampleProbability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricConfig) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricConfig{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Params_MetricConfig{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IngestUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IngestUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatapointInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.DatapointInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableMetrics", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableMetrics = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnableTracing", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.EnableTracing = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TracingBufferSize", wireType)
			}
			m.TracingBufferSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TracingBufferSize |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field TracingSampleProbability", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.TracingSampleProbability = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Params_MetricConfig_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/signalfx/config/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 508 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x91, 0x3f, 0x6f, 0xd3, 0x4e,
	0x1c, 0xc6, 0x7d, 0xad, 0x7f, 0xf9, 0x73, 0x69, 0xaa, 0xf4, 0x7e, 0x48, 0x98, 0x48, 0x5c, 0x4d,
	0x25, 0x24, 0x0b, 0x55, 0x67, 0x11, 0x16, 0x06, 0x16, 0x52, 0x02, 0x74, 0x48, 0x52, 0x39, 0xe9,
	0xc2, 0x62, 0x9d, 0x93, 0x8b, 0x75, 0xc2, 0xf1, 0x59, 0xe7, 0x0b, 0x6a, 0x3a, 0xf1, 0x12, 0xd8,
	0xe0, 0x25, 0xf0, 0x22, 0x78, 0x01, 0x19, 0x3b, 0x32, 0x01, 0x31, 0x0b, 0x63, 0x5f, 0x02, 0xca,
	0x9d, 0x43, 0xbb, 0x30, 0x30, 0xf9, 0xee, 0x79, 0x3e, 0x8f, 0x7c, 0xcf, 0xf7, 0x0b, 0x1f, 0xcd,
	0xf9, 0x05, 0x93, 0x3e, 0x9d, 0xd2, 0x4c, 0x31, 0xe9, 0xe7, 0x3c, 0x4e, 0x69, 0x32, 0xbb, 0xf0,
	0x27, 0x22, 0x9d, 0xf1, 0xb8, 0xfc, 0x90, 0x4c, 0x0a, 0x25, 0xd0, 0xdd, 0x92, 0x22, 0x5b, 0x8a,
	0x18, 0xbb, 0x7d, 0x27, 0x16, 0xb1, 0xd0, 0x8c, 0xbf, 0x39, 0x19, 0xbc, 0x8d, 0x63, 0x21, 0xe2,
	0x84, 0xf9, 0xfa, 0x16, 0x2d, 0x66, 0xfe, 0x74, 0x21, 0xa9, 0xe2, 0x22, 0x35, 0xfe, 0xd1, 0x17,
	0x1b, 0x56, 0xce, 0xa8, 0xa4, 0xf3, 0x1c, 0xbd, 0x84, 0xd5, 0x39, 0x53, 0x92, 0x4f, 0x72, 0x07,
	0xb8, 0xbb, 0x5e, 0xa3, 0x73, 0x4c, 0xfe, 0xf2, 0x2f, 0x62, 0x12, 0xa4, 0xaf, 0xf1, 0x13, 0xad,
	0x05, 0xdb, 0x30, 0xba, 0x0f, 0x21, 0x4f, 0x63, 0x96, 0xab, 0x70, 0x21, 0x13, 0x67, 0xc7, 0x05,
	0x5e, 0x3d, 0xa8, 0x1b, 0xe5, 0x5c, 0x26, 0xe8, 0x01, 0xdc, 0xa3, 0x93, 0x09, 0xcb, 0xf3, 0x50,
	0x89, 0xb7, 0x2c, 0x75, 0x76, 0x35, 0xd0, 0x30, 0xda, 0x78, 0x23, 0xa1, 0x00, 0xa2, 0x29, 0x55,
	0x34, 0x13, 0x3c, 0x55, 0x21, 0x4f, 0x15, 0x93, 0xef, 0x68, 0xe2, 0xd8, 0x2e, 0xf0, 0x1a, 0x9d,
	0x7b, 0xc4, 0x34, 0x22, 0xdb, 0x46, 0xe4, 0x45, 0xd9, 0xa8, 0x5b, 0x5b, 0x7d, 0x3b, 0xb4, 0x3e,
	0x7d, 0x3f, 0x04, 0xc1, 0xc1, 0x9f, 0xf8, 0x69, 0x99, 0x46, 0x0f, 0xe1, 0x3e, 0x4b, 0x69, 0x94,
	0xb0, 0x70, 0x5b, 0xf2, 0x3f, 0x17, 0x78, 0xb5, 0xa0, 0x69, 0xd4, 0x7e, 0xf9, 0xf8, 0x1b, 0x4c,
	0x49, 0x3a, 0xe1, 0x69, 0xec, 0x54, 0x6e, 0x63, 0x63, 0x23, 0x22, 0x02, 0xff, 0x2f, 0xfd, 0x30,
	0x5a, 0xcc, 0x66, 0x4c, 0x86, 0x39, 0xbf, 0x64, 0x4e, 0xd5, 0x05, 0x5e, 0x33, 0x38, 0x28, 0xad,
	0xae, 0x76, 0x46, 0xfc, 0x92, 0xa1, 0x67, 0xb0, 0xbd, 0xe5, 0x73, 0x3a, 0xcf, 0x12, 0x16, 0x66,
	0x52, 0x44, 0x34, 0xe2, 0x09, 0x57, 0x4b, 0xa7, 0xe6, 0x02, 0x0f, 0x04, 0x4e, 0x49, 0x8c, 0x34,
	0x70, 0x76, 0xe3, 0xb7, 0x3f, 0x02, 0xb8, 0x77, 0x7b, 0xd6, 0x08, 0x41, 0x3b, 0xa5, 0x73, 0xe6,
	0x00, 0x3d, 0x3b, 0x7d, 0x46, 0x3d, 0x68, 0xab, 0x65, 0xc6, 0xf4, 0x98, 0xf6, 0x3b, 0x8f, 0xff,
	0x65, 0x77, 0x64, 0xbc, 0xcc, 0x58, 0xa0, 0xe3, 0x47, 0xc7, 0xd0, 0xde, 0xdc, 0x50, 0x0d, 0xda,
	0x83, 0xe1, 0xa0, 0xd7, 0xb2, 0x50, 0x03, 0x56, 0x4f, 0x86, 0xe7, 0x83, 0x71, 0x2f, 0x68, 0x01,
	0xd4, 0x84, 0xf5, 0xd7, 0xa7, 0xa3, 0xf1, 0xf0, 0x55, 0xf0, 0xbc, 0xdf, 0xda, 0xe9, 0x3e, 0x5d,
	0xad, 0xb1, 0x75, 0xb5, 0xc6, 0xd6, 0xd7, 0x35, 0xb6, 0xae, 0xd7, 0xd8, 0x7a, 0x5f, 0x60, 0xf0,
	0xb9, 0xc0, 0xd6, 0xaa, 0xc0, 0xe0, 0xaa, 0xc0, 0xe0, 0x47, 0x81, 0xc1, 0xaf, 0x02, 0x5b, 0xd7,
	0x05, 0x06, 0x1f, 0x7e, 0x62, 0xeb, 0x4d, 0xc5, 0x3c, 0x23, 0xaa, 0xe8, 0xfd, 0x3d, 0xf9, 0x1d,
	0x00, 0x00, 0xff, 0xff, 0x0d, 0x48, 0x5a, 0x09, 0xfc, 0x02, 0x00, 0x00,
}
