// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/config/client/quota.proto

package client

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Determines the quotas used for individual requests.
type QuotaSpec struct {
	// A list of Quota rules.
	Rules []*QuotaRule `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
}

func (m *QuotaSpec) Reset()                    { *m = QuotaSpec{} }
func (*QuotaSpec) ProtoMessage()               {}
func (*QuotaSpec) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{0} }

// Specifies a rule with list of matches and list of quotas.
// If any clause matched, the list of quotas will be used.
type QuotaRule struct {
	// If empty, match all request.
	// If any of match is true, it is matched.
	Match []*AttributeMatch `protobuf:"bytes,1,rep,name=match" json:"match,omitempty"`
	// The list of quotas to charge.
	Quotas []*Quota `protobuf:"bytes,2,rep,name=quotas" json:"quotas,omitempty"`
}

func (m *QuotaRule) Reset()                    { *m = QuotaRule{} }
func (*QuotaRule) ProtoMessage()               {}
func (*QuotaRule) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{1} }

// Describes how to match a given string in HTTP headers. Match is
// case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Regex
	MatchType isStringMatch_MatchType `protobuf_oneof:"match_type"`
}

func (m *StringMatch) Reset()                    { *m = StringMatch{} }
func (*StringMatch) ProtoMessage()               {}
func (*StringMatch) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{2} }

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StringMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StringMatch_OneofMarshaler, _StringMatch_OneofUnmarshaler, _StringMatch_OneofSizer, []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

func _StringMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Exact)
	case *StringMatch_Prefix:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Prefix)
	case *StringMatch_Regex:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("StringMatch.MatchType has unexpected type %T", x)
	}
	return nil
}

func _StringMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StringMatch)
	switch tag {
	case 1: // match_type.exact
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Exact{x}
		return true, err
	case 2: // match_type.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Prefix{x}
		return true, err
	case 3: // match_type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _StringMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Exact)))
		n += len(x.Exact)
	case *StringMatch_Prefix:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *StringMatch_Regex:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a match clause to match Istio attributes
type AttributeMatch struct {
	// Map of attribute names to StringMatch type.
	// Each map element specifies one condition to match.
	//
	// Example:
	//
	//   clause:
	//     source.uid:
	//       exact: SOURCE_UID
	//     request.http_method:
	//       exact: POST
	Clause map[string]*StringMatch `protobuf:"bytes,1,rep,name=clause" json:"clause,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *AttributeMatch) Reset()                    { *m = AttributeMatch{} }
func (*AttributeMatch) ProtoMessage()               {}
func (*AttributeMatch) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{3} }

// Specifies a quota to use with quota name and amount.
type Quota struct {
	// The quota name to charge
	Quota string `protobuf:"bytes,1,opt,name=quota,proto3" json:"quota,omitempty"`
	// The quota amount to charge
	Charge int64 `protobuf:"varint,2,opt,name=charge,proto3" json:"charge,omitempty"`
}

func (m *Quota) Reset()                    { *m = Quota{} }
func (*Quota) ProtoMessage()               {}
func (*Quota) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{4} }

// QuotaSpecBinding defines the binding between QuotaSpecs and one or more
// IstioService.
type QuotaSpecBinding struct {
	// REQUIRED. One or more services to map the listed QuotaSpec onto.
	Services []*IstioService `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// REQUIRED. One or more QuotaSpec references that should be mapped to
	// the specified service(s). The aggregate collection of match
	// conditions defined in the QuotaSpecs should not overlap.
	QuotaSpecs []*QuotaSpecBinding_QuotaSpecReference `protobuf:"bytes,2,rep,name=quota_specs,json=quotaSpecs" json:"quota_specs,omitempty"`
}

func (m *QuotaSpecBinding) Reset()                    { *m = QuotaSpecBinding{} }
func (*QuotaSpecBinding) ProtoMessage()               {}
func (*QuotaSpecBinding) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{5} }

// QuotaSpecReference uniquely identifies the QuotaSpec used in the
// Binding.
type QuotaSpecBinding_QuotaSpecReference struct {
	// REQUIRED. The short name of the QuotaSpec. This is the resource
	// name defined by the metadata name field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional namespace of the QuotaSpec. Defaults to the value of the
	// metadata namespace field.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *QuotaSpecBinding_QuotaSpecReference) Reset()      { *m = QuotaSpecBinding_QuotaSpecReference{} }
func (*QuotaSpecBinding_QuotaSpecReference) ProtoMessage() {}
func (*QuotaSpecBinding_QuotaSpecReference) Descriptor() ([]byte, []int) {
	return fileDescriptorQuota, []int{5, 0}
}

func init() {
	proto.RegisterType((*QuotaSpec)(nil), "istio.mixer.v1.config.client.QuotaSpec")
	proto.RegisterType((*QuotaRule)(nil), "istio.mixer.v1.config.client.QuotaRule")
	proto.RegisterType((*StringMatch)(nil), "istio.mixer.v1.config.client.StringMatch")
	proto.RegisterType((*AttributeMatch)(nil), "istio.mixer.v1.config.client.AttributeMatch")
	proto.RegisterType((*Quota)(nil), "istio.mixer.v1.config.client.Quota")
	proto.RegisterType((*QuotaSpecBinding)(nil), "istio.mixer.v1.config.client.QuotaSpecBinding")
	proto.RegisterType((*QuotaSpecBinding_QuotaSpecReference)(nil), "istio.mixer.v1.config.client.QuotaSpecBinding.QuotaSpecReference")
}
func (m *QuotaSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, msg := range m.Match {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Quotas) > 0 {
		for _, msg := range m.Quotas {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *StringMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MatchType != nil {
		nn1, err := m.MatchType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *StringMatch_Exact) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Exact)))
	i += copy(dAtA[i:], m.Exact)
	return i, nil
}
func (m *StringMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	return i, nil
}
func (m *StringMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *AttributeMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttributeMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Clause) > 0 {
		for k, _ := range m.Clause {
			dAtA[i] = 0xa
			i++
			v := m.Clause[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovQuota(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovQuota(uint64(len(k))) + msgSize
			i = encodeVarintQuota(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintQuota(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	return i, nil
}

func (m *Quota) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Quota) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Quota) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Quota)))
		i += copy(dAtA[i:], m.Quota)
	}
	if m.Charge != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintQuota(dAtA, i, uint64(m.Charge))
	}
	return i, nil
}

func (m *QuotaSpecBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpecBinding) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, msg := range m.Services {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.QuotaSpecs) > 0 {
		for _, msg := range m.QuotaSpecs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaSpecBinding_QuotaSpecReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaSpecBinding_QuotaSpecReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	return i, nil
}

func encodeVarintQuota(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *QuotaSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaRule) Size() (n int) {
	var l int
	_ = l
	if len(m.Match) > 0 {
		for _, e := range m.Match {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	if len(m.Quotas) > 0 {
		for _, e := range m.Quotas {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *StringMatch) Size() (n int) {
	var l int
	_ = l
	if m.MatchType != nil {
		n += m.MatchType.Size()
	}
	return n
}

func (m *StringMatch_Exact) Size() (n int) {
	var l int
	_ = l
	l = len(m.Exact)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *StringMatch_Prefix) Size() (n int) {
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *StringMatch_Regex) Size() (n int) {
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovQuota(uint64(l))
	return n
}
func (m *AttributeMatch) Size() (n int) {
	var l int
	_ = l
	if len(m.Clause) > 0 {
		for k, v := range m.Clause {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovQuota(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Quota) Size() (n int) {
	var l int
	_ = l
	l = len(m.Quota)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	if m.Charge != 0 {
		n += 1 + sovQuota(uint64(m.Charge))
	}
	return n
}

func (m *QuotaSpecBinding) Size() (n int) {
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, e := range m.Services {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	if len(m.QuotaSpecs) > 0 {
		for _, e := range m.QuotaSpecs {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaSpecBinding_QuotaSpecReference) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovQuota(uint64(l))
	}
	return n
}

func sovQuota(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuota(x uint64) (n int) {
	return sovQuota(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QuotaSpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaSpec{`,
		`Rules:` + strings.Replace(fmt.Sprintf("%v", this.Rules), "QuotaRule", "QuotaRule", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaRule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaRule{`,
		`Match:` + strings.Replace(fmt.Sprintf("%v", this.Match), "AttributeMatch", "AttributeMatch", 1) + `,`,
		`Quotas:` + strings.Replace(fmt.Sprintf("%v", this.Quotas), "Quota", "Quota", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch{`,
		`MatchType:` + fmt.Sprintf("%v", this.MatchType) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Exact) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Exact{`,
		`Exact:` + fmt.Sprintf("%v", this.Exact) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Prefix) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Prefix{`,
		`Prefix:` + fmt.Sprintf("%v", this.Prefix) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMatch_Regex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StringMatch_Regex{`,
		`Regex:` + fmt.Sprintf("%v", this.Regex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *AttributeMatch) String() string {
	if this == nil {
		return "nil"
	}
	keysForClause := make([]string, 0, len(this.Clause))
	for k, _ := range this.Clause {
		keysForClause = append(keysForClause, k)
	}
	sortkeys.Strings(keysForClause)
	mapStringForClause := "map[string]*StringMatch{"
	for _, k := range keysForClause {
		mapStringForClause += fmt.Sprintf("%v: %v,", k, this.Clause[k])
	}
	mapStringForClause += "}"
	s := strings.Join([]string{`&AttributeMatch{`,
		`Clause:` + mapStringForClause + `,`,
		`}`,
	}, "")
	return s
}
func (this *Quota) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Quota{`,
		`Quota:` + fmt.Sprintf("%v", this.Quota) + `,`,
		`Charge:` + fmt.Sprintf("%v", this.Charge) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaSpecBinding) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaSpecBinding{`,
		`Services:` + strings.Replace(fmt.Sprintf("%v", this.Services), "IstioService", "IstioService", 1) + `,`,
		`QuotaSpecs:` + strings.Replace(fmt.Sprintf("%v", this.QuotaSpecs), "QuotaSpecBinding_QuotaSpecReference", "QuotaSpecBinding_QuotaSpecReference", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaSpecBinding_QuotaSpecReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaSpecBinding_QuotaSpecReference{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQuota(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QuotaSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &QuotaRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Match = append(m.Match, &AttributeMatch{})
			if err := m.Match[len(m.Match)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Quotas = append(m.Quotas, &Quota{})
			if err := m.Quotas[len(m.Quotas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Exact{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttributeMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clause", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Clause == nil {
				m.Clause = make(map[string]*StringMatch)
			}
			var mapkey string
			var mapvalue *StringMatch
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQuota
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMatch{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQuota(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthQuota
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Clause[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Quota) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Quota: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Quota: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quota", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Quota = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Charge", wireType)
			}
			m.Charge = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Charge |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaSpecBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpecBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpecBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &IstioService{})
			if err := m.Services[len(m.Services)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QuotaSpecs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QuotaSpecs = append(m.QuotaSpecs, &QuotaSpecBinding_QuotaSpecReference{})
			if err := m.QuotaSpecs[len(m.QuotaSpecs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaSpecBinding_QuotaSpecReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaSpecReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaSpecReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuota(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuota
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuota(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuota = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuota   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/v1/config/client/quota.proto", fileDescriptorQuota) }

var fileDescriptorQuota = []byte{
	// 533 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x93, 0x4f, 0x6b, 0x13, 0x4f,
	0x18, 0xc7, 0x77, 0x93, 0xdf, 0x86, 0x5f, 0x9e, 0x88, 0x94, 0xa1, 0x94, 0x25, 0x94, 0xa1, 0x6c,
	0x05, 0xab, 0xc8, 0x2e, 0xad, 0x08, 0x45, 0x11, 0x69, 0xc4, 0xa2, 0x82, 0xa0, 0x53, 0xbc, 0x78,
	0x29, 0x9b, 0xe9, 0x93, 0xed, 0x60, 0xb2, 0xbb, 0x9d, 0x9d, 0x0d, 0xc9, 0xcd, 0x93, 0x27, 0x0f,
	0xbe, 0x0c, 0x5f, 0x4a, 0x8e, 0x3d, 0x7a, 0x34, 0xeb, 0xc5, 0x63, 0x5f, 0x82, 0xec, 0xcc, 0xa4,
	0x8d, 0xa8, 0xa1, 0x9e, 0xf6, 0x79, 0x9e, 0x7d, 0x3e, 0xdf, 0xe7, 0x0f, 0xcf, 0x40, 0x30, 0x12,
	0x13, 0x94, 0xd1, 0x78, 0x37, 0xe2, 0x59, 0x3a, 0x10, 0x49, 0xc4, 0x87, 0x02, 0x53, 0x15, 0x9d,
	0x95, 0x99, 0x8a, 0xc3, 0x5c, 0x66, 0x2a, 0x23, 0x9b, 0xa2, 0x50, 0x22, 0x0b, 0x75, 0x66, 0x38,
	0xde, 0x0d, 0x4d, 0x66, 0x68, 0x32, 0xbb, 0xeb, 0x49, 0x96, 0x64, 0x3a, 0x31, 0xaa, 0x2d, 0xc3,
	0x74, 0x6f, 0xfd, 0x45, 0xb7, 0x40, 0x39, 0x16, 0x1c, 0x4d, 0x56, 0xf0, 0x12, 0xda, 0x6f, 0xea,
	0x42, 0x47, 0x39, 0x72, 0xf2, 0x18, 0x3c, 0x59, 0x0e, 0xb1, 0xf0, 0xdd, 0xad, 0xe6, 0x4e, 0x67,
	0xef, 0x76, 0xb8, 0xaa, 0x6c, 0xa8, 0x39, 0x56, 0x0e, 0x91, 0x19, 0x2a, 0xf8, 0xe4, 0x5a, 0xb1,
	0x3a, 0x48, 0x7a, 0xe0, 0x8d, 0x62, 0xc5, 0x4f, 0xad, 0xd8, 0xbd, 0xd5, 0x62, 0x07, 0x4a, 0x49,
	0xd1, 0x2f, 0x15, 0xbe, 0xaa, 0x19, 0x66, 0x50, 0xf2, 0x08, 0x5a, 0x7a, 0x0d, 0x85, 0xdf, 0xd0,
	0x22, 0xdb, 0xd7, 0xe9, 0xc8, 0x22, 0x01, 0x42, 0xe7, 0x48, 0x49, 0x91, 0x26, 0x5a, 0x92, 0x6c,
	0x80, 0x87, 0x93, 0x98, 0x2b, 0xdf, 0xdd, 0x72, 0x77, 0xda, 0xcf, 0x1d, 0x66, 0x5c, 0xe2, 0x43,
	0x2b, 0x97, 0x38, 0x10, 0x13, 0xbf, 0x61, 0x7f, 0x58, 0xbf, 0x26, 0x24, 0x26, 0x38, 0xf1, 0x9b,
	0x0b, 0x42, 0xbb, 0xbd, 0x1b, 0x00, 0xba, 0xbd, 0x63, 0x35, 0xcd, 0x31, 0x98, 0xb9, 0x70, 0xf3,
	0xd7, 0xee, 0xc9, 0x6b, 0x68, 0xf1, 0x61, 0x5c, 0x16, 0x68, 0x67, 0xdf, 0xff, 0x97, 0xd9, 0xc3,
	0xa7, 0x1a, 0x7d, 0x96, 0x2a, 0x39, 0x65, 0x56, 0xa7, 0x7b, 0x02, 0x9d, 0xa5, 0x30, 0x59, 0x83,
	0xe6, 0x7b, 0x9c, 0x9a, 0x49, 0x58, 0x6d, 0x92, 0x27, 0xe0, 0x8d, 0xe3, 0x61, 0x89, 0x7a, 0x88,
	0xce, 0xde, 0x9d, 0xd5, 0x15, 0x97, 0xf6, 0xc2, 0x0c, 0xf7, 0xb0, 0xb1, 0xef, 0x06, 0x0f, 0xc0,
	0xd3, 0x2b, 0x24, 0xeb, 0xe0, 0xe9, 0x25, 0xda, 0x0a, 0xc6, 0x21, 0x1b, 0xd0, 0xe2, 0xa7, 0xb1,
	0x4c, 0x4c, 0x91, 0x26, 0xb3, 0x5e, 0xf0, 0xb1, 0x01, 0x6b, 0x97, 0x47, 0xd4, 0x13, 0xe9, 0x89,
	0x48, 0x13, 0x72, 0x08, 0xff, 0xdb, 0x4b, 0x5b, 0x9c, 0xd3, 0xdd, 0xd5, 0x3d, 0xbd, 0xa8, 0x7f,
	0x1e, 0x19, 0x84, 0x5d, 0xb2, 0xa4, 0x0f, 0x1d, 0x5d, 0xfd, 0xb8, 0xc8, 0x91, 0x2f, 0xee, 0xe0,
	0xe0, 0x1a, 0x77, 0xb0, 0xd4, 0xcc, 0x55, 0x80, 0xe1, 0x00, 0x25, 0xa6, 0x1c, 0x19, 0x9c, 0x2d,
	0x62, 0x45, 0xf7, 0x10, 0xc8, 0xef, 0x19, 0x84, 0xc0, 0x7f, 0x69, 0x3c, 0x42, 0xbb, 0x03, 0x6d,
	0x93, 0x4d, 0x68, 0xd7, 0xdf, 0x22, 0x8f, 0xb9, 0xd9, 0x42, 0x9b, 0x5d, 0x05, 0x7a, 0x6f, 0x67,
	0x73, 0xea, 0x9c, 0xcf, 0xa9, 0xf3, 0x75, 0x4e, 0x9d, 0x8b, 0x39, 0x75, 0x3e, 0x54, 0xd4, 0xfd,
	0x52, 0x51, 0x67, 0x56, 0x51, 0xf7, 0xbc, 0xa2, 0xee, 0xb7, 0x8a, 0xba, 0x3f, 0x2a, 0xea, 0x5c,
	0x54, 0xd4, 0xfd, 0xfc, 0x9d, 0x3a, 0xef, 0xb6, 0xcd, 0x1c, 0x22, 0x8b, 0xe2, 0x5c, 0x44, 0x7f,
	0x7e, 0xb1, 0xfd, 0x96, 0x7e, 0xaa, 0xf7, 0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0x84, 0xe2, 0xec,
	0x62, 0x2a, 0x04, 0x00, 0x00,
}
