// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/config/client/api_spec.proto

/*
	Package client is a generated protocol buffer package.

	It is generated from these files:
		mixer/v1/config/client/api_spec.proto
		mixer/v1/config/client/client_config.proto
		mixer/v1/config/client/quota.proto
		mixer/v1/config/client/service.proto

	It has these top-level messages:
		HTTPAPISpec
		HTTPAPISpecPattern
		APIKey
		HTTPAPISpecReference
		HTTPAPISpecBinding
		NetworkFailPolicy
		ServiceConfig
		TransportConfig
		HttpClientConfig
		TcpClientConfig
		QuotaSpec
		QuotaRule
		StringMatch
		AttributeMatch
		Quota
		QuotaSpecBinding
		IstioService
*/
package client

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import istio_mixer_v1 "istio.io/api/mixer/v1"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// HTTPAPISpec defines the canonical configuration for generating
// API-related attributes from HTTP requests based on the method and
// uri templated path matches. It is sufficient for defining the API
// surface of a service for the purposes of API attribute
// generation. It is not intended to represent auth, quota,
// documentation, or other information commonly found in other API
// specifications, e.g. OpenAPI.
//
// Existing standards that define operations (or methods) in terms of
// HTTP methods and paths can be normalized to this format for use in
// Istio. For example, a simple petstore API described by OpenAPIv2
// [here](https://github.com/googleapis/gnostic/blob/master/examples/v2.0/yaml/petstore-simple.yaml)
// can be represented with the following HTTPAPISpec.
//
// ```yaml
// apiVersion: config.istio.io/v1alpha2
// kind: HTTPAPISpec
// metadata:
//   name: petstore
//   namespace: default
// spec:
//   attributes:
//     api.service: petstore.swagger.io
//     api.version: 1.0.0
//   patterns:
//   - attributes:
//       api.operation: findPets
//     httpMethod: GET
//     uriTemplate: /api/pets
//   - attributes:
//       api.operation: addPet
//     httpMethod: POST
//     uriTemplate: /api/pets
//   - attributes:
//       api.operation: findPetById
//     httpMethod: GET
//     uriTemplate: /api/pets/{id}
//   - attributes:
//       api.operation: deletePet
//     httpMethod: DELETE
//     uriTemplate: /api/pets/{id}
//   api_keys:
//   - query: api-key
// ```
type HTTPAPISpec struct {
	// List of attributes that are generated when *any* of the HTTP
	// patterns match. This list typically includes the "api.service"
	// and "api.version" attributes.
	Attributes *istio_mixer_v1.Attributes `protobuf:"bytes,1,opt,name=attributes" json:"attributes,omitempty"`
	// List of HTTP patterns to match.
	Patterns []*HTTPAPISpecPattern `protobuf:"bytes,2,rep,name=patterns" json:"patterns,omitempty"`
	// List of APIKey that describes how to extract an API-KEY from an
	// HTTP request. The first API-Key match found in the list is used,
	// i.e. 'OR' semantics.
	//
	// The following default policies are used to generate the
	// `request.api_key` attribute if no explicit APIKey is defined.
	//
	//     `query: key, `query: api_key`, and then `header: x-api-key`
	//
	ApiKeys []*APIKey `protobuf:"bytes,3,rep,name=api_keys,json=apiKeys" json:"api_keys,omitempty"`
}

func (m *HTTPAPISpec) Reset()                    { *m = HTTPAPISpec{} }
func (*HTTPAPISpec) ProtoMessage()               {}
func (*HTTPAPISpec) Descriptor() ([]byte, []int) { return fileDescriptorApiSpec, []int{0} }

// HTTPAPISpecPattern defines a single pattern to match against
// incoming HTTP requests. The per-pattern list of attributes is
// generated if both the http_method and uri_template match. In
// addition, the top-level list of attributes in the HTTPAPISpec is also
// generated.
//
// ```yaml
// pattern:
// - attributes
//     api.operation: doFooBar
//   httpMethod: GET
//   uriTemplate: /foo/bar
// ```
type HTTPAPISpecPattern struct {
	// List of attributes that are generated if the HTTP request matches
	// the specified http_method and uri_template. This typically
	// includes the "api.operation" attribute.
	Attributes *istio_mixer_v1.Attributes `protobuf:"bytes,1,opt,name=attributes" json:"attributes,omitempty"`
	// HTTP request method to match against as defined by
	// [rfc7231](https://tools.ietf.org/html/rfc7231#page-21). For
	// example: GET, HEAD, POST, PUT, DELETE.
	HttpMethod string `protobuf:"bytes,2,opt,name=http_method,json=httpMethod,proto3" json:"http_method,omitempty"`
	// Types that are valid to be assigned to Pattern:
	//	*HTTPAPISpecPattern_UriTemplate
	//	*HTTPAPISpecPattern_Regex
	Pattern isHTTPAPISpecPattern_Pattern `protobuf_oneof:"pattern"`
}

func (m *HTTPAPISpecPattern) Reset()                    { *m = HTTPAPISpecPattern{} }
func (*HTTPAPISpecPattern) ProtoMessage()               {}
func (*HTTPAPISpecPattern) Descriptor() ([]byte, []int) { return fileDescriptorApiSpec, []int{1} }

type isHTTPAPISpecPattern_Pattern interface {
	isHTTPAPISpecPattern_Pattern()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HTTPAPISpecPattern_UriTemplate struct {
	UriTemplate string `protobuf:"bytes,3,opt,name=uri_template,json=uriTemplate,proto3,oneof"`
}
type HTTPAPISpecPattern_Regex struct {
	Regex string `protobuf:"bytes,4,opt,name=regex,proto3,oneof"`
}

func (*HTTPAPISpecPattern_UriTemplate) isHTTPAPISpecPattern_Pattern() {}
func (*HTTPAPISpecPattern_Regex) isHTTPAPISpecPattern_Pattern()       {}

func (m *HTTPAPISpecPattern) GetPattern() isHTTPAPISpecPattern_Pattern {
	if m != nil {
		return m.Pattern
	}
	return nil
}

func (m *HTTPAPISpecPattern) GetUriTemplate() string {
	if x, ok := m.GetPattern().(*HTTPAPISpecPattern_UriTemplate); ok {
		return x.UriTemplate
	}
	return ""
}

func (m *HTTPAPISpecPattern) GetRegex() string {
	if x, ok := m.GetPattern().(*HTTPAPISpecPattern_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HTTPAPISpecPattern) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HTTPAPISpecPattern_OneofMarshaler, _HTTPAPISpecPattern_OneofUnmarshaler, _HTTPAPISpecPattern_OneofSizer, []interface{}{
		(*HTTPAPISpecPattern_UriTemplate)(nil),
		(*HTTPAPISpecPattern_Regex)(nil),
	}
}

func _HTTPAPISpecPattern_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HTTPAPISpecPattern)
	// pattern
	switch x := m.Pattern.(type) {
	case *HTTPAPISpecPattern_UriTemplate:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.UriTemplate)
	case *HTTPAPISpecPattern_Regex:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("HTTPAPISpecPattern.Pattern has unexpected type %T", x)
	}
	return nil
}

func _HTTPAPISpecPattern_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HTTPAPISpecPattern)
	switch tag {
	case 3: // pattern.uri_template
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HTTPAPISpecPattern_UriTemplate{x}
		return true, err
	case 4: // pattern.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Pattern = &HTTPAPISpecPattern_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _HTTPAPISpecPattern_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HTTPAPISpecPattern)
	// pattern
	switch x := m.Pattern.(type) {
	case *HTTPAPISpecPattern_UriTemplate:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.UriTemplate)))
		n += len(x.UriTemplate)
	case *HTTPAPISpecPattern_Regex:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// APIKey defines the explicit configuration for generating the
// `request.api_key` attribute from HTTP requests.
//
// See https://swagger.io/docs/specification/authentication/api-keys
// for a general overview of API keys as defined by OpenAPI.
type APIKey struct {
	// Types that are valid to be assigned to Key:
	//	*APIKey_Query
	//	*APIKey_Header
	//	*APIKey_Cookie
	Key isAPIKey_Key `protobuf_oneof:"key"`
}

func (m *APIKey) Reset()                    { *m = APIKey{} }
func (*APIKey) ProtoMessage()               {}
func (*APIKey) Descriptor() ([]byte, []int) { return fileDescriptorApiSpec, []int{2} }

type isAPIKey_Key interface {
	isAPIKey_Key()
	MarshalTo([]byte) (int, error)
	Size() int
}

type APIKey_Query struct {
	Query string `protobuf:"bytes,1,opt,name=query,proto3,oneof"`
}
type APIKey_Header struct {
	Header string `protobuf:"bytes,2,opt,name=header,proto3,oneof"`
}
type APIKey_Cookie struct {
	Cookie string `protobuf:"bytes,3,opt,name=cookie,proto3,oneof"`
}

func (*APIKey_Query) isAPIKey_Key()  {}
func (*APIKey_Header) isAPIKey_Key() {}
func (*APIKey_Cookie) isAPIKey_Key() {}

func (m *APIKey) GetKey() isAPIKey_Key {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *APIKey) GetQuery() string {
	if x, ok := m.GetKey().(*APIKey_Query); ok {
		return x.Query
	}
	return ""
}

func (m *APIKey) GetHeader() string {
	if x, ok := m.GetKey().(*APIKey_Header); ok {
		return x.Header
	}
	return ""
}

func (m *APIKey) GetCookie() string {
	if x, ok := m.GetKey().(*APIKey_Cookie); ok {
		return x.Cookie
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*APIKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _APIKey_OneofMarshaler, _APIKey_OneofUnmarshaler, _APIKey_OneofSizer, []interface{}{
		(*APIKey_Query)(nil),
		(*APIKey_Header)(nil),
		(*APIKey_Cookie)(nil),
	}
}

func _APIKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*APIKey)
	// key
	switch x := m.Key.(type) {
	case *APIKey_Query:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Query)
	case *APIKey_Header:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Header)
	case *APIKey_Cookie:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Cookie)
	case nil:
	default:
		return fmt.Errorf("APIKey.Key has unexpected type %T", x)
	}
	return nil
}

func _APIKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*APIKey)
	switch tag {
	case 1: // key.query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Key = &APIKey_Query{x}
		return true, err
	case 2: // key.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Key = &APIKey_Header{x}
		return true, err
	case 3: // key.cookie
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Key = &APIKey_Cookie{x}
		return true, err
	default:
		return false, nil
	}
}

func _APIKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*APIKey)
	// key
	switch x := m.Key.(type) {
	case *APIKey_Query:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Query)))
		n += len(x.Query)
	case *APIKey_Header:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Header)))
		n += len(x.Header)
	case *APIKey_Cookie:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Cookie)))
		n += len(x.Cookie)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// HTTPAPISpecReference defines a reference to an HTTPAPISpec. This is
// typically used for establishing bindings between an HTTPAPISpec and an
// IstioService. For example, the following defines an
// HTTPAPISpecReference for service `foo` in namespace `bar`.
//
// ```yaml
// - name: foo
//   namespace: bar
// ```
type HTTPAPISpecReference struct {
	// REQUIRED. The short name of the HTTPAPISpec. This is the resource
	// name defined by the metadata name field.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional namespace of the HTTPAPISpec. Defaults to the encompassing
	// HTTPAPISpecBinding's metadata namespace field.
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *HTTPAPISpecReference) Reset()                    { *m = HTTPAPISpecReference{} }
func (*HTTPAPISpecReference) ProtoMessage()               {}
func (*HTTPAPISpecReference) Descriptor() ([]byte, []int) { return fileDescriptorApiSpec, []int{3} }

// HTTPAPISpecBinding defines the binding between HTTPAPISpecs and one or more
// IstioService. For example, the following establishes a binding
// between the HTTPAPISpec `petstore` and service `foo` in namespace `bar`.
//
// ```yaml
// apiVersion: config.istio.io/v1alpha2
// kind: HTTPAPISpecBinding
// metadata:
//   name: my-binding
//   namespace: default
// spec:
//   services:
//   - name: foo
//     namespace: bar
//   api_specs:
//   - name: petstore
//     namespace: default
// ```
type HTTPAPISpecBinding struct {
	// REQUIRED. One or more services to map the listed HTTPAPISpec onto.
	Services []*IstioService `protobuf:"bytes,1,rep,name=services" json:"services,omitempty"`
	// REQUIRED. One or more HTTPAPISpec references that should be mapped to
	// the specified service(s). The aggregate collection of match
	// conditions defined in the HTTPAPISpecs should not overlap.
	ApiSpecs []*HTTPAPISpecReference `protobuf:"bytes,2,rep,name=api_specs,json=apiSpecs" json:"api_specs,omitempty"`
}

func (m *HTTPAPISpecBinding) Reset()                    { *m = HTTPAPISpecBinding{} }
func (*HTTPAPISpecBinding) ProtoMessage()               {}
func (*HTTPAPISpecBinding) Descriptor() ([]byte, []int) { return fileDescriptorApiSpec, []int{4} }

func init() {
	proto.RegisterType((*HTTPAPISpec)(nil), "istio.mixer.v1.config.client.HTTPAPISpec")
	proto.RegisterType((*HTTPAPISpecPattern)(nil), "istio.mixer.v1.config.client.HTTPAPISpecPattern")
	proto.RegisterType((*APIKey)(nil), "istio.mixer.v1.config.client.APIKey")
	proto.RegisterType((*HTTPAPISpecReference)(nil), "istio.mixer.v1.config.client.HTTPAPISpecReference")
	proto.RegisterType((*HTTPAPISpecBinding)(nil), "istio.mixer.v1.config.client.HTTPAPISpecBinding")
}
func (m *HTTPAPISpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAPISpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Attributes != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApiSpec(dAtA, i, uint64(m.Attributes.Size()))
		n1, err := m.Attributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Patterns) > 0 {
		for _, msg := range m.Patterns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApiSpec(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ApiKeys) > 0 {
		for _, msg := range m.ApiKeys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApiSpec(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HTTPAPISpecPattern) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAPISpecPattern) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Attributes != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApiSpec(dAtA, i, uint64(m.Attributes.Size()))
		n2, err := m.Attributes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.HttpMethod) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApiSpec(dAtA, i, uint64(len(m.HttpMethod)))
		i += copy(dAtA[i:], m.HttpMethod)
	}
	if m.Pattern != nil {
		nn3, err := m.Pattern.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	return i, nil
}

func (m *HTTPAPISpecPattern_UriTemplate) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApiSpec(dAtA, i, uint64(len(m.UriTemplate)))
	i += copy(dAtA[i:], m.UriTemplate)
	return i, nil
}
func (m *HTTPAPISpecPattern_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *APIKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		nn4, err := m.Key.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	return i, nil
}

func (m *APIKey_Query) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Query)))
	i += copy(dAtA[i:], m.Query)
	return i, nil
}
func (m *APIKey_Header) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Header)))
	i += copy(dAtA[i:], m.Header)
	return i, nil
}
func (m *APIKey_Cookie) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Cookie)))
	i += copy(dAtA[i:], m.Cookie)
	return i, nil
}
func (m *HTTPAPISpecReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAPISpecReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApiSpec(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	return i, nil
}

func (m *HTTPAPISpecBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPAPISpecBinding) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, msg := range m.Services {
			dAtA[i] = 0xa
			i++
			i = encodeVarintApiSpec(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ApiSpecs) > 0 {
		for _, msg := range m.ApiSpecs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApiSpec(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintApiSpec(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HTTPAPISpec) Size() (n int) {
	var l int
	_ = l
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovApiSpec(uint64(l))
	}
	if len(m.Patterns) > 0 {
		for _, e := range m.Patterns {
			l = e.Size()
			n += 1 + l + sovApiSpec(uint64(l))
		}
	}
	if len(m.ApiKeys) > 0 {
		for _, e := range m.ApiKeys {
			l = e.Size()
			n += 1 + l + sovApiSpec(uint64(l))
		}
	}
	return n
}

func (m *HTTPAPISpecPattern) Size() (n int) {
	var l int
	_ = l
	if m.Attributes != nil {
		l = m.Attributes.Size()
		n += 1 + l + sovApiSpec(uint64(l))
	}
	l = len(m.HttpMethod)
	if l > 0 {
		n += 1 + l + sovApiSpec(uint64(l))
	}
	if m.Pattern != nil {
		n += m.Pattern.Size()
	}
	return n
}

func (m *HTTPAPISpecPattern_UriTemplate) Size() (n int) {
	var l int
	_ = l
	l = len(m.UriTemplate)
	n += 1 + l + sovApiSpec(uint64(l))
	return n
}
func (m *HTTPAPISpecPattern_Regex) Size() (n int) {
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovApiSpec(uint64(l))
	return n
}
func (m *APIKey) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		n += m.Key.Size()
	}
	return n
}

func (m *APIKey_Query) Size() (n int) {
	var l int
	_ = l
	l = len(m.Query)
	n += 1 + l + sovApiSpec(uint64(l))
	return n
}
func (m *APIKey_Header) Size() (n int) {
	var l int
	_ = l
	l = len(m.Header)
	n += 1 + l + sovApiSpec(uint64(l))
	return n
}
func (m *APIKey_Cookie) Size() (n int) {
	var l int
	_ = l
	l = len(m.Cookie)
	n += 1 + l + sovApiSpec(uint64(l))
	return n
}
func (m *HTTPAPISpecReference) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovApiSpec(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovApiSpec(uint64(l))
	}
	return n
}

func (m *HTTPAPISpecBinding) Size() (n int) {
	var l int
	_ = l
	if len(m.Services) > 0 {
		for _, e := range m.Services {
			l = e.Size()
			n += 1 + l + sovApiSpec(uint64(l))
		}
	}
	if len(m.ApiSpecs) > 0 {
		for _, e := range m.ApiSpecs {
			l = e.Size()
			n += 1 + l + sovApiSpec(uint64(l))
		}
	}
	return n
}

func sovApiSpec(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApiSpec(x uint64) (n int) {
	return sovApiSpec(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HTTPAPISpec) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpec{`,
		`Attributes:` + strings.Replace(fmt.Sprintf("%v", this.Attributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`Patterns:` + strings.Replace(fmt.Sprintf("%v", this.Patterns), "HTTPAPISpecPattern", "HTTPAPISpecPattern", 1) + `,`,
		`ApiKeys:` + strings.Replace(fmt.Sprintf("%v", this.ApiKeys), "APIKey", "APIKey", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPAPISpecPattern) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpecPattern{`,
		`Attributes:` + strings.Replace(fmt.Sprintf("%v", this.Attributes), "Attributes", "istio_mixer_v1.Attributes", 1) + `,`,
		`HttpMethod:` + fmt.Sprintf("%v", this.HttpMethod) + `,`,
		`Pattern:` + fmt.Sprintf("%v", this.Pattern) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPAPISpecPattern_UriTemplate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpecPattern_UriTemplate{`,
		`UriTemplate:` + fmt.Sprintf("%v", this.UriTemplate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPAPISpecPattern_Regex) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpecPattern_Regex{`,
		`Regex:` + fmt.Sprintf("%v", this.Regex) + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIKey) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&APIKey{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIKey_Query) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&APIKey_Query{`,
		`Query:` + fmt.Sprintf("%v", this.Query) + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIKey_Header) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&APIKey_Header{`,
		`Header:` + fmt.Sprintf("%v", this.Header) + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIKey_Cookie) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&APIKey_Cookie{`,
		`Cookie:` + fmt.Sprintf("%v", this.Cookie) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPAPISpecReference) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpecReference{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPAPISpecBinding) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPAPISpecBinding{`,
		`Services:` + strings.Replace(fmt.Sprintf("%v", this.Services), "IstioService", "IstioService", 1) + `,`,
		`ApiSpecs:` + strings.Replace(fmt.Sprintf("%v", this.ApiSpecs), "HTTPAPISpecReference", "HTTPAPISpecReference", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringApiSpec(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HTTPAPISpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPAPISpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPAPISpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Patterns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Patterns = append(m.Patterns, &HTTPAPISpecPattern{})
			if err := m.Patterns[len(m.Patterns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiKeys = append(m.ApiKeys, &APIKey{})
			if err := m.ApiKeys[len(m.ApiKeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiSpec(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApiSpec
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPAPISpecPattern) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPAPISpecPattern: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPAPISpecPattern: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = &istio_mixer_v1.Attributes{}
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpMethod", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpMethod = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UriTemplate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HTTPAPISpecPattern_UriTemplate{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = &HTTPAPISpecPattern_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiSpec(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApiSpec
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Query", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = &APIKey_Query{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = &APIKey_Header{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cookie", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = &APIKey_Cookie{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiSpec(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApiSpec
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPAPISpecReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPAPISpecReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPAPISpecReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiSpec(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApiSpec
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPAPISpecBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPAPISpecBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPAPISpecBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Services", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Services = append(m.Services, &IstioService{})
			if err := m.Services[len(m.Services)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiSpecs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApiSpec
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiSpecs = append(m.ApiSpecs, &HTTPAPISpecReference{})
			if err := m.ApiSpecs[len(m.ApiSpecs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApiSpec(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApiSpec
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApiSpec(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApiSpec
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApiSpec
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApiSpec
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApiSpec
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApiSpec(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApiSpec = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApiSpec   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/v1/config/client/api_spec.proto", fileDescriptorApiSpec) }

var fileDescriptorApiSpec = []byte{
	// 517 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x53, 0xbd, 0x6e, 0x13, 0x41,
	0x10, 0xbe, 0x8d, 0xf3, 0x63, 0x8f, 0xa9, 0x56, 0x11, 0x3a, 0xac, 0x68, 0xb1, 0x9c, 0x20, 0x59,
	0x14, 0x77, 0xc4, 0x74, 0x34, 0xc8, 0x2e, 0x90, 0xad, 0x80, 0xb0, 0x36, 0xa6, 0x81, 0xc2, 0xba,
	0x9c, 0x27, 0xf6, 0xca, 0xf1, 0xed, 0xb1, 0xb7, 0xb6, 0xe2, 0x8e, 0x47, 0xe0, 0x31, 0x68, 0x78,
	0x00, 0xde, 0x20, 0x65, 0xca, 0x94, 0xf8, 0x68, 0x28, 0xf3, 0x08, 0x68, 0x6f, 0x2f, 0xb6, 0xf9,
	0xb3, 0x90, 0xa8, 0xee, 0x66, 0xe6, 0x9b, 0xf9, 0xe6, 0x9b, 0x9d, 0x81, 0x47, 0x13, 0x71, 0x89,
	0xca, 0x9f, 0x1d, 0xfb, 0xa1, 0x8c, 0xce, 0xc5, 0xd0, 0x0f, 0x2f, 0x04, 0x46, 0xda, 0x0f, 0x62,
	0xd1, 0x4f, 0x62, 0x0c, 0xbd, 0x58, 0x49, 0x2d, 0xe9, 0x81, 0x48, 0xb4, 0x90, 0x5e, 0x06, 0xf6,
	0x66, 0xc7, 0x9e, 0x05, 0x7b, 0x16, 0x5c, 0xd9, 0x1f, 0xca, 0xa1, 0xcc, 0x80, 0xbe, 0xf9, 0xb3,
	0x39, 0x95, 0x07, 0xcb, 0xd2, 0x81, 0xd6, 0x4a, 0x9c, 0x4d, 0x35, 0x26, 0x79, 0xe8, 0xe8, 0x2f,
	0xac, 0x09, 0xaa, 0x99, 0x08, 0xd1, 0xa2, 0x6a, 0x37, 0x04, 0xca, 0xed, 0x5e, 0xaf, 0xdb, 0xec,
	0x76, 0x4e, 0x63, 0x0c, 0xe9, 0x33, 0x80, 0x55, 0x25, 0x97, 0x54, 0x49, 0xbd, 0xdc, 0xa8, 0x78,
	0xbf, 0x74, 0xd6, 0x5c, 0x22, 0xf8, 0x1a, 0x9a, 0xbe, 0x84, 0x62, 0x1c, 0x68, 0x8d, 0x2a, 0x4a,
	0xdc, 0xad, 0x6a, 0xa1, 0x5e, 0x6e, 0x3c, 0xf1, 0x36, 0x69, 0xf2, 0xd6, 0x88, 0xbb, 0x36, 0x91,
	0x2f, 0x2b, 0xd0, 0xe7, 0x50, 0x34, 0x03, 0x1a, 0xe3, 0x3c, 0x71, 0x0b, 0x59, 0xb5, 0xa3, 0xcd,
	0xd5, 0x9a, 0xdd, 0xce, 0x09, 0xce, 0xf9, 0x5e, 0x10, 0x8b, 0x13, 0x9c, 0x27, 0xb5, 0x2f, 0x04,
	0xe8, 0xef, 0x0c, 0xff, 0xa5, 0xf0, 0x21, 0x94, 0x47, 0x5a, 0xc7, 0xfd, 0x09, 0xea, 0x91, 0x1c,
	0xb8, 0x5b, 0x55, 0x52, 0x2f, 0x71, 0x30, 0xae, 0x57, 0x99, 0x87, 0x1e, 0xc2, 0xbd, 0xa9, 0x12,
	0x7d, 0x8d, 0x93, 0xf8, 0x22, 0xd0, 0xe8, 0x16, 0x0c, 0xa2, 0xed, 0xf0, 0xf2, 0x54, 0x89, 0x5e,
	0xee, 0xa4, 0xf7, 0x61, 0x47, 0xe1, 0x10, 0x2f, 0xdd, 0xed, 0x3c, 0x6a, 0xcd, 0x56, 0x09, 0xf6,
	0x72, 0xf5, 0xb5, 0x77, 0xb0, 0x6b, 0xe5, 0x18, 0xf0, 0xfb, 0x29, 0xaa, 0x79, 0xd6, 0x69, 0x06,
	0xce, 0x4c, 0xea, 0xc2, 0xee, 0x08, 0x83, 0x01, 0x2a, 0xdb, 0x45, 0xdb, 0xe1, 0xb9, 0x6d, 0x22,
	0xa1, 0x94, 0x63, 0xb1, 0x62, 0xcf, 0xed, 0xd6, 0x0e, 0x14, 0xc6, 0x38, 0xaf, 0xb5, 0x61, 0x7f,
	0x6d, 0x2e, 0x1c, 0xcf, 0x51, 0x61, 0x14, 0x22, 0xa5, 0xb0, 0x1d, 0x05, 0x13, 0xb4, 0x4c, 0x3c,
	0xfb, 0xa7, 0x07, 0x50, 0x32, 0xdf, 0x24, 0x0e, 0x42, 0xcc, 0xf5, 0xae, 0x1c, 0xb5, 0xcf, 0x3f,
	0x8f, 0xb8, 0x25, 0xa2, 0x81, 0x88, 0x86, 0xf4, 0x05, 0x14, 0xf3, 0x2d, 0x33, 0x03, 0x36, 0x4f,
	0xf7, 0x78, 0xf3, 0xd3, 0x75, 0x4c, 0xf0, 0xd4, 0xa6, 0xf0, 0x65, 0x2e, 0x7d, 0x0d, 0xa5, 0xbb,
	0x1b, 0xb9, 0xdb, 0xa8, 0xc6, 0x3f, 0x6f, 0xd4, 0x52, 0x17, 0x37, 0x7b, 0x64, 0x3c, 0x49, 0xeb,
	0xcd, 0xd5, 0x82, 0x39, 0xd7, 0x0b, 0xe6, 0xdc, 0x2c, 0x98, 0x73, 0xbb, 0x60, 0xce, 0x87, 0x94,
	0x91, 0x4f, 0x29, 0x73, 0xae, 0x52, 0x46, 0xae, 0x53, 0x46, 0xbe, 0xa6, 0x8c, 0x7c, 0x4f, 0x99,
	0x73, 0x9b, 0x32, 0xf2, 0xf1, 0x1b, 0x73, 0xde, 0x1e, 0x5a, 0x3a, 0x21, 0xcd, 0xb5, 0xfa, 0x7f,
	0x3e, 0xa9, 0xb3, 0xdd, 0xec, 0x96, 0x9e, 0xfe, 0x08, 0x00, 0x00, 0xff, 0xff, 0xd9, 0xe5, 0x31,
	0x31, 0xe9, 0x03, 0x00, 0x00,
}
