// Code generated by protoc-gen-validate
// source: envoy/config/filter/http/gzip/v2/gzip.proto
// DO NOT EDIT!!!

package v2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on Gzip with the rules defined in the proto
// definition for this message. If any rules are violated, an error is returned.
func (m *Gzip) Validate() error {
	if m == nil {
		return nil
	}

	if wrapper := m.GetMemoryLevel(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 9 {
			return GzipValidationError{
				Field:  "MemoryLevel",
				Reason: "value must be inside range [1, 9]",
			}
		}

	}

	if wrapper := m.GetContentLength(); wrapper != nil {

		if wrapper.GetValue() < 30 {
			return GzipValidationError{
				Field:  "ContentLength",
				Reason: "value must be greater than or equal to 30",
			}
		}

	}

	if _, ok := Gzip_CompressionLevel_Enum_name[int32(m.GetCompressionLevel())]; !ok {
		return GzipValidationError{
			Field:  "CompressionLevel",
			Reason: "value must be one of the defined enum values",
		}
	}

	if _, ok := Gzip_CompressionStrategy_name[int32(m.GetCompressionStrategy())]; !ok {
		return GzipValidationError{
			Field:  "CompressionStrategy",
			Reason: "value must be one of the defined enum values",
		}
	}

	if len(m.GetContentType()) > 50 {
		return GzipValidationError{
			Field:  "ContentType",
			Reason: "value must contain no more than 50 item(s)",
		}
	}

	// no validation rules for DisableOnEtagHeader

	// no validation rules for RemoveAcceptEncodingHeader

	if wrapper := m.GetWindowBits(); wrapper != nil {

		if val := wrapper.GetValue(); val < 9 || val > 15 {
			return GzipValidationError{
				Field:  "WindowBits",
				Reason: "value must be inside range [9, 15]",
			}
		}

	}

	return nil
}

// GzipValidationError is the validation error returned by Gzip.Validate if the
// designated constraints aren't met.
type GzipValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e GzipValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGzip.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = GzipValidationError{}

// Validate checks the field values on Gzip_CompressionLevel with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *Gzip_CompressionLevel) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// Gzip_CompressionLevelValidationError is the validation error returned by
// Gzip_CompressionLevel.Validate if the designated constraints aren't met.
type Gzip_CompressionLevelValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e Gzip_CompressionLevelValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGzip_CompressionLevel.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = Gzip_CompressionLevelValidationError{}
