// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/admin/v2alpha/config_dump.proto

package envoy_admin_v2alpha

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v22 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
import envoy_api_v23 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
import envoy_api_v24 "github.com/envoyproxy/go-control-plane/envoy/api/v2"
import envoy_config_bootstrap_v2 "github.com/envoyproxy/go-control-plane/envoy/config/bootstrap/v2"
import google_protobuf6 "github.com/gogo/protobuf/types"
import google_protobuf4 "github.com/gogo/protobuf/types"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The :ref:`/config_dump <operations_admin_interface_config_dump>` admin endpoint uses this wrapper
// message to maintain and serve arbitrary configuration information from any component in Envoy.
type ConfigDump struct {
	// This map is serialized and dumped in its entirety at the
	// :ref:`/config_dump <operations_admin_interface_config_dump>` endpoint.
	//
	// Keys are a short descriptor of the config object they map to. The following keys (and the
	// messages they map to) are currently supported:
	//
	// * *bootstrap*: :ref:`BootstrapConfigDump <envoy_api_msg_admin.v2alpha.BootstrapConfigDump>`
	// * *listeners*: :ref:`ListenersConfigDump <envoy_api_msg_admin.v2alpha.ListenersConfigDump>`
	// * *clusters*: :ref:`ClustersConfigDump <envoy_api_msg_admin.v2alpha.ClustersConfigDump>`
	// * *routes*:  :ref:`RoutesConfigDump <envoy_api_msg_admin.v2alpha.RoutesConfigDump>`
	Configs map[string]google_protobuf6.Any `protobuf:"bytes,1,rep,name=configs" json:"configs" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ConfigDump) Reset()                    { *m = ConfigDump{} }
func (m *ConfigDump) String() string            { return proto.CompactTextString(m) }
func (*ConfigDump) ProtoMessage()               {}
func (*ConfigDump) Descriptor() ([]byte, []int) { return fileDescriptorConfigDump, []int{0} }

func (m *ConfigDump) GetConfigs() map[string]google_protobuf6.Any {
	if m != nil {
		return m.Configs
	}
	return nil
}

// This message describes the bootstrap configuration that Envoy was started with. This includes
// any CLI overrides that were merged. Bootstrap configuration information can be used to recreate
// the static portions of an Envoy configuration by reusing the output as the bootstrap
// configuration for another Envoy.
type BootstrapConfigDump struct {
	Bootstrap envoy_config_bootstrap_v2.Bootstrap `protobuf:"bytes,1,opt,name=bootstrap" json:"bootstrap"`
	// The timestamp when the BootstrapConfig was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *BootstrapConfigDump) Reset()                    { *m = BootstrapConfigDump{} }
func (m *BootstrapConfigDump) String() string            { return proto.CompactTextString(m) }
func (*BootstrapConfigDump) ProtoMessage()               {}
func (*BootstrapConfigDump) Descriptor() ([]byte, []int) { return fileDescriptorConfigDump, []int{1} }

func (m *BootstrapConfigDump) GetBootstrap() envoy_config_bootstrap_v2.Bootstrap {
	if m != nil {
		return m.Bootstrap
	}
	return envoy_config_bootstrap_v2.Bootstrap{}
}

func (m *BootstrapConfigDump) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

// Envoy's listener manager fills this message with all currently known listeners. Listener
// configuration information can be used to recreate an Envoy configuration by populating all
// listeners as static listeners or by returning them in a LDS response.
type ListenersConfigDump struct {
	// This is the :ref:`version_info <envoy_api_field_DiscoveryResponse.version_info>` in the
	// last processed LDS discovery response. If there are only static bootstrap listeners, this field
	// will be "".
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The statically loaded listener configs.
	StaticListeners []ListenersConfigDump_StaticListener `protobuf:"bytes,2,rep,name=static_listeners,json=staticListeners" json:"static_listeners"`
	// The dynamically loaded active listeners. These are listeners that are available to service
	// data plane traffic.
	DynamicActiveListeners []ListenersConfigDump_DynamicListener `protobuf:"bytes,3,rep,name=dynamic_active_listeners,json=dynamicActiveListeners" json:"dynamic_active_listeners"`
	// The dynamically loaded warming listeners. These are listeners that are currently undergoing
	// warming in preparation to service data plane traffic. Note that if attempting to recreate an
	// Envoy configuration from a configuration dump, the warming listeners should generally be
	// discarded.
	DynamicWarmingListeners []ListenersConfigDump_DynamicListener `protobuf:"bytes,4,rep,name=dynamic_warming_listeners,json=dynamicWarmingListeners" json:"dynamic_warming_listeners"`
	// The dynamically loaded draining listeners. These are listeners that are currently undergoing
	// draining in preparation to stop servicing data plane traffic. Note that if attempting to
	// recreate an Envoy configuration from a configuration dump, the draining listeners should
	// generally be discarded.
	DynamicDrainingListeners []ListenersConfigDump_DynamicListener `protobuf:"bytes,5,rep,name=dynamic_draining_listeners,json=dynamicDrainingListeners" json:"dynamic_draining_listeners"`
}

func (m *ListenersConfigDump) Reset()                    { *m = ListenersConfigDump{} }
func (m *ListenersConfigDump) String() string            { return proto.CompactTextString(m) }
func (*ListenersConfigDump) ProtoMessage()               {}
func (*ListenersConfigDump) Descriptor() ([]byte, []int) { return fileDescriptorConfigDump, []int{2} }

func (m *ListenersConfigDump) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *ListenersConfigDump) GetStaticListeners() []ListenersConfigDump_StaticListener {
	if m != nil {
		return m.StaticListeners
	}
	return nil
}

func (m *ListenersConfigDump) GetDynamicActiveListeners() []ListenersConfigDump_DynamicListener {
	if m != nil {
		return m.DynamicActiveListeners
	}
	return nil
}

func (m *ListenersConfigDump) GetDynamicWarmingListeners() []ListenersConfigDump_DynamicListener {
	if m != nil {
		return m.DynamicWarmingListeners
	}
	return nil
}

func (m *ListenersConfigDump) GetDynamicDrainingListeners() []ListenersConfigDump_DynamicListener {
	if m != nil {
		return m.DynamicDrainingListeners
	}
	return nil
}

// Describes a statically loaded cluster.
type ListenersConfigDump_StaticListener struct {
	// The listener config.
	Listener *envoy_api_v23.Listener `protobuf:"bytes,1,opt,name=listener" json:"listener,omitempty"`
	// The timestamp when the Listener was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *ListenersConfigDump_StaticListener) Reset()         { *m = ListenersConfigDump_StaticListener{} }
func (m *ListenersConfigDump_StaticListener) String() string { return proto.CompactTextString(m) }
func (*ListenersConfigDump_StaticListener) ProtoMessage()    {}
func (*ListenersConfigDump_StaticListener) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{2, 0}
}

func (m *ListenersConfigDump_StaticListener) GetListener() *envoy_api_v23.Listener {
	if m != nil {
		return m.Listener
	}
	return nil
}

func (m *ListenersConfigDump_StaticListener) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

// Describes a dynamically loaded cluster via the LDS API.
type ListenersConfigDump_DynamicListener struct {
	// This is the per-resource version information. This version is currently taken from the
	// :ref:`version_info <envoy_api_field_DiscoveryResponse.version_info>` field at the time
	// that the listener was loaded. In the future, discrete per-listener versions may be supported
	// by the API.
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The listener config.
	Listener *envoy_api_v23.Listener `protobuf:"bytes,2,opt,name=listener" json:"listener,omitempty"`
	// The timestamp when the Listener was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *ListenersConfigDump_DynamicListener) Reset()         { *m = ListenersConfigDump_DynamicListener{} }
func (m *ListenersConfigDump_DynamicListener) String() string { return proto.CompactTextString(m) }
func (*ListenersConfigDump_DynamicListener) ProtoMessage()    {}
func (*ListenersConfigDump_DynamicListener) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{2, 1}
}

func (m *ListenersConfigDump_DynamicListener) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *ListenersConfigDump_DynamicListener) GetListener() *envoy_api_v23.Listener {
	if m != nil {
		return m.Listener
	}
	return nil
}

func (m *ListenersConfigDump_DynamicListener) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

// Envoy's cluster manager fills this message with all currently known clusters. Cluster
// configuration information can be used to recreate an Envoy configuration by populating all
// clusters as static clusters or by returning them in a CDS response.
type ClustersConfigDump struct {
	// This is the :ref:`version_info <envoy_api_field_DiscoveryResponse.version_info>` in the
	// last processed CDS discovery response. If there are only static bootstrap clusters, this field
	// will be "".
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The statically loaded cluster configs.
	StaticClusters []ClustersConfigDump_StaticCluster `protobuf:"bytes,2,rep,name=static_clusters,json=staticClusters" json:"static_clusters"`
	// The dynamically loaded active clusters. These are clusters that are available to service
	// data plane traffic.
	DynamicActiveClusters []ClustersConfigDump_DynamicCluster `protobuf:"bytes,3,rep,name=dynamic_active_clusters,json=dynamicActiveClusters" json:"dynamic_active_clusters"`
	// The dynamically loaded warming clusters. These are clusters that are currently undergoing
	// warming in preparation to service data plane traffic. Note that if attempting to recreate an
	// Envoy configuration from a configuration dump, the warming clusters should generally be
	// discarded.
	DynamicWarmingClusters []ClustersConfigDump_DynamicCluster `protobuf:"bytes,4,rep,name=dynamic_warming_clusters,json=dynamicWarmingClusters" json:"dynamic_warming_clusters"`
}

func (m *ClustersConfigDump) Reset()                    { *m = ClustersConfigDump{} }
func (m *ClustersConfigDump) String() string            { return proto.CompactTextString(m) }
func (*ClustersConfigDump) ProtoMessage()               {}
func (*ClustersConfigDump) Descriptor() ([]byte, []int) { return fileDescriptorConfigDump, []int{3} }

func (m *ClustersConfigDump) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *ClustersConfigDump) GetStaticClusters() []ClustersConfigDump_StaticCluster {
	if m != nil {
		return m.StaticClusters
	}
	return nil
}

func (m *ClustersConfigDump) GetDynamicActiveClusters() []ClustersConfigDump_DynamicCluster {
	if m != nil {
		return m.DynamicActiveClusters
	}
	return nil
}

func (m *ClustersConfigDump) GetDynamicWarmingClusters() []ClustersConfigDump_DynamicCluster {
	if m != nil {
		return m.DynamicWarmingClusters
	}
	return nil
}

// Describes a statically loaded cluster.
type ClustersConfigDump_StaticCluster struct {
	// The cluster config.
	Cluster *envoy_api_v22.Cluster `protobuf:"bytes,1,opt,name=cluster" json:"cluster,omitempty"`
	// The timestamp when the Cluster was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *ClustersConfigDump_StaticCluster) Reset()         { *m = ClustersConfigDump_StaticCluster{} }
func (m *ClustersConfigDump_StaticCluster) String() string { return proto.CompactTextString(m) }
func (*ClustersConfigDump_StaticCluster) ProtoMessage()    {}
func (*ClustersConfigDump_StaticCluster) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{3, 0}
}

func (m *ClustersConfigDump_StaticCluster) GetCluster() *envoy_api_v22.Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *ClustersConfigDump_StaticCluster) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

// Describes a dynamically loaded cluster via the CDS API.
type ClustersConfigDump_DynamicCluster struct {
	// This is the per-resource version information. This version is currently taken from the
	// :ref:`version_info <envoy_api_field_DiscoveryResponse.version_info>` field at the time
	// that the cluster was loaded. In the future, discrete per-cluster versions may be supported by
	// the API.
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The cluster config.
	Cluster *envoy_api_v22.Cluster `protobuf:"bytes,2,opt,name=cluster" json:"cluster,omitempty"`
	// The timestamp when the Cluster was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *ClustersConfigDump_DynamicCluster) Reset()         { *m = ClustersConfigDump_DynamicCluster{} }
func (m *ClustersConfigDump_DynamicCluster) String() string { return proto.CompactTextString(m) }
func (*ClustersConfigDump_DynamicCluster) ProtoMessage()    {}
func (*ClustersConfigDump_DynamicCluster) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{3, 1}
}

func (m *ClustersConfigDump_DynamicCluster) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *ClustersConfigDump_DynamicCluster) GetCluster() *envoy_api_v22.Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

func (m *ClustersConfigDump_DynamicCluster) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

// Envoy's RDS implementation fills this message with all currently loaded routes, as described by
// their RouteConfiguration objects. Static routes configured in the bootstrap configuration are
// separated from those configured dynamically via RDS. Route configuration information can be used
// to recreate an Envoy configuration by populating all routes as static routes or by returning them
// in RDS responses.
type RoutesConfigDump struct {
	// The statically loaded route configs.
	StaticRouteConfigs []RoutesConfigDump_StaticRouteConfig `protobuf:"bytes,2,rep,name=static_route_configs,json=staticRouteConfigs" json:"static_route_configs"`
	// The dynamically loaded route configs.
	DynamicRouteConfigs []RoutesConfigDump_DynamicRouteConfig `protobuf:"bytes,3,rep,name=dynamic_route_configs,json=dynamicRouteConfigs" json:"dynamic_route_configs"`
}

func (m *RoutesConfigDump) Reset()                    { *m = RoutesConfigDump{} }
func (m *RoutesConfigDump) String() string            { return proto.CompactTextString(m) }
func (*RoutesConfigDump) ProtoMessage()               {}
func (*RoutesConfigDump) Descriptor() ([]byte, []int) { return fileDescriptorConfigDump, []int{4} }

func (m *RoutesConfigDump) GetStaticRouteConfigs() []RoutesConfigDump_StaticRouteConfig {
	if m != nil {
		return m.StaticRouteConfigs
	}
	return nil
}

func (m *RoutesConfigDump) GetDynamicRouteConfigs() []RoutesConfigDump_DynamicRouteConfig {
	if m != nil {
		return m.DynamicRouteConfigs
	}
	return nil
}

type RoutesConfigDump_StaticRouteConfig struct {
	// The route config.
	RouteConfig *envoy_api_v24.RouteConfiguration `protobuf:"bytes,1,opt,name=route_config,json=routeConfig" json:"route_config,omitempty"`
	// The timestamp when the Route was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,2,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *RoutesConfigDump_StaticRouteConfig) Reset()         { *m = RoutesConfigDump_StaticRouteConfig{} }
func (m *RoutesConfigDump_StaticRouteConfig) String() string { return proto.CompactTextString(m) }
func (*RoutesConfigDump_StaticRouteConfig) ProtoMessage()    {}
func (*RoutesConfigDump_StaticRouteConfig) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{4, 0}
}

func (m *RoutesConfigDump_StaticRouteConfig) GetRouteConfig() *envoy_api_v24.RouteConfiguration {
	if m != nil {
		return m.RouteConfig
	}
	return nil
}

func (m *RoutesConfigDump_StaticRouteConfig) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

type RoutesConfigDump_DynamicRouteConfig struct {
	// This is the per-resource version information. This version is currently taken from the
	// :ref:`version_info <envoy_api_field_DiscoveryResponse.version_info>` field at the time that
	// the route configuration was loaded.
	VersionInfo string `protobuf:"bytes,1,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	// The route config.
	RouteConfig *envoy_api_v24.RouteConfiguration `protobuf:"bytes,2,opt,name=route_config,json=routeConfig" json:"route_config,omitempty"`
	// The timestamp when the Route was last updated.
	LastUpdated *google_protobuf4.Timestamp `protobuf:"bytes,3,opt,name=last_updated,json=lastUpdated" json:"last_updated,omitempty"`
}

func (m *RoutesConfigDump_DynamicRouteConfig) Reset()         { *m = RoutesConfigDump_DynamicRouteConfig{} }
func (m *RoutesConfigDump_DynamicRouteConfig) String() string { return proto.CompactTextString(m) }
func (*RoutesConfigDump_DynamicRouteConfig) ProtoMessage()    {}
func (*RoutesConfigDump_DynamicRouteConfig) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigDump, []int{4, 1}
}

func (m *RoutesConfigDump_DynamicRouteConfig) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

func (m *RoutesConfigDump_DynamicRouteConfig) GetRouteConfig() *envoy_api_v24.RouteConfiguration {
	if m != nil {
		return m.RouteConfig
	}
	return nil
}

func (m *RoutesConfigDump_DynamicRouteConfig) GetLastUpdated() *google_protobuf4.Timestamp {
	if m != nil {
		return m.LastUpdated
	}
	return nil
}

func init() {
	proto.RegisterType((*ConfigDump)(nil), "envoy.admin.v2alpha.ConfigDump")
	proto.RegisterType((*BootstrapConfigDump)(nil), "envoy.admin.v2alpha.BootstrapConfigDump")
	proto.RegisterType((*ListenersConfigDump)(nil), "envoy.admin.v2alpha.ListenersConfigDump")
	proto.RegisterType((*ListenersConfigDump_StaticListener)(nil), "envoy.admin.v2alpha.ListenersConfigDump.StaticListener")
	proto.RegisterType((*ListenersConfigDump_DynamicListener)(nil), "envoy.admin.v2alpha.ListenersConfigDump.DynamicListener")
	proto.RegisterType((*ClustersConfigDump)(nil), "envoy.admin.v2alpha.ClustersConfigDump")
	proto.RegisterType((*ClustersConfigDump_StaticCluster)(nil), "envoy.admin.v2alpha.ClustersConfigDump.StaticCluster")
	proto.RegisterType((*ClustersConfigDump_DynamicCluster)(nil), "envoy.admin.v2alpha.ClustersConfigDump.DynamicCluster")
	proto.RegisterType((*RoutesConfigDump)(nil), "envoy.admin.v2alpha.RoutesConfigDump")
	proto.RegisterType((*RoutesConfigDump_StaticRouteConfig)(nil), "envoy.admin.v2alpha.RoutesConfigDump.StaticRouteConfig")
	proto.RegisterType((*RoutesConfigDump_DynamicRouteConfig)(nil), "envoy.admin.v2alpha.RoutesConfigDump.DynamicRouteConfig")
}
func (m *ConfigDump) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigDump) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Configs) > 0 {
		for k, _ := range m.Configs {
			dAtA[i] = 0xa
			i++
			v := m.Configs[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovConfigDump(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovConfigDump(uint64(len(k))) + msgSize
			i = encodeVarintConfigDump(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64((&v).Size()))
			n1, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n1
		}
	}
	return i, nil
}

func (m *BootstrapConfigDump) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BootstrapConfigDump) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintConfigDump(dAtA, i, uint64(m.Bootstrap.Size()))
	n2, err := m.Bootstrap.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.LastUpdated != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n3, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *ListenersConfigDump) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenersConfigDump) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VersionInfo) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(len(m.VersionInfo)))
		i += copy(dAtA[i:], m.VersionInfo)
	}
	if len(m.StaticListeners) > 0 {
		for _, msg := range m.StaticListeners {
			dAtA[i] = 0x12
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicActiveListeners) > 0 {
		for _, msg := range m.DynamicActiveListeners {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicWarmingListeners) > 0 {
		for _, msg := range m.DynamicWarmingListeners {
			dAtA[i] = 0x22
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicDrainingListeners) > 0 {
		for _, msg := range m.DynamicDrainingListeners {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ListenersConfigDump_StaticListener) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenersConfigDump_StaticListener) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Listener != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.Listener.Size()))
		n4, err := m.Listener.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n5, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *ListenersConfigDump_DynamicListener) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenersConfigDump_DynamicListener) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VersionInfo) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(len(m.VersionInfo)))
		i += copy(dAtA[i:], m.VersionInfo)
	}
	if m.Listener != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.Listener.Size()))
		n6, err := m.Listener.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n7, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *ClustersConfigDump) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClustersConfigDump) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VersionInfo) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(len(m.VersionInfo)))
		i += copy(dAtA[i:], m.VersionInfo)
	}
	if len(m.StaticClusters) > 0 {
		for _, msg := range m.StaticClusters {
			dAtA[i] = 0x12
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicActiveClusters) > 0 {
		for _, msg := range m.DynamicActiveClusters {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicWarmingClusters) > 0 {
		for _, msg := range m.DynamicWarmingClusters {
			dAtA[i] = 0x22
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ClustersConfigDump_StaticCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClustersConfigDump_StaticCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Cluster != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.Cluster.Size()))
		n8, err := m.Cluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n9, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *ClustersConfigDump_DynamicCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClustersConfigDump_DynamicCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VersionInfo) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(len(m.VersionInfo)))
		i += copy(dAtA[i:], m.VersionInfo)
	}
	if m.Cluster != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.Cluster.Size()))
		n10, err := m.Cluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n11, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *RoutesConfigDump) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoutesConfigDump) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StaticRouteConfigs) > 0 {
		for _, msg := range m.StaticRouteConfigs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DynamicRouteConfigs) > 0 {
		for _, msg := range m.DynamicRouteConfigs {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintConfigDump(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RoutesConfigDump_StaticRouteConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoutesConfigDump_StaticRouteConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RouteConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.RouteConfig.Size()))
		n12, err := m.RouteConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n13, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func (m *RoutesConfigDump_DynamicRouteConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoutesConfigDump_DynamicRouteConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.VersionInfo) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(len(m.VersionInfo)))
		i += copy(dAtA[i:], m.VersionInfo)
	}
	if m.RouteConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.RouteConfig.Size()))
		n14, err := m.RouteConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.LastUpdated != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfigDump(dAtA, i, uint64(m.LastUpdated.Size()))
		n15, err := m.LastUpdated.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func encodeVarintConfigDump(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ConfigDump) Size() (n int) {
	var l int
	_ = l
	if len(m.Configs) > 0 {
		for k, v := range m.Configs {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovConfigDump(uint64(len(k))) + 1 + l + sovConfigDump(uint64(l))
			n += mapEntrySize + 1 + sovConfigDump(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *BootstrapConfigDump) Size() (n int) {
	var l int
	_ = l
	l = m.Bootstrap.Size()
	n += 1 + l + sovConfigDump(uint64(l))
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *ListenersConfigDump) Size() (n int) {
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if len(m.StaticListeners) > 0 {
		for _, e := range m.StaticListeners {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicActiveListeners) > 0 {
		for _, e := range m.DynamicActiveListeners {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicWarmingListeners) > 0 {
		for _, e := range m.DynamicWarmingListeners {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicDrainingListeners) > 0 {
		for _, e := range m.DynamicDrainingListeners {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	return n
}

func (m *ListenersConfigDump_StaticListener) Size() (n int) {
	var l int
	_ = l
	if m.Listener != nil {
		l = m.Listener.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *ListenersConfigDump_DynamicListener) Size() (n int) {
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.Listener != nil {
		l = m.Listener.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *ClustersConfigDump) Size() (n int) {
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if len(m.StaticClusters) > 0 {
		for _, e := range m.StaticClusters {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicActiveClusters) > 0 {
		for _, e := range m.DynamicActiveClusters {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicWarmingClusters) > 0 {
		for _, e := range m.DynamicWarmingClusters {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	return n
}

func (m *ClustersConfigDump_StaticCluster) Size() (n int) {
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *ClustersConfigDump_DynamicCluster) Size() (n int) {
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *RoutesConfigDump) Size() (n int) {
	var l int
	_ = l
	if len(m.StaticRouteConfigs) > 0 {
		for _, e := range m.StaticRouteConfigs {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	if len(m.DynamicRouteConfigs) > 0 {
		for _, e := range m.DynamicRouteConfigs {
			l = e.Size()
			n += 1 + l + sovConfigDump(uint64(l))
		}
	}
	return n
}

func (m *RoutesConfigDump_StaticRouteConfig) Size() (n int) {
	var l int
	_ = l
	if m.RouteConfig != nil {
		l = m.RouteConfig.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func (m *RoutesConfigDump_DynamicRouteConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.VersionInfo)
	if l > 0 {
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.RouteConfig != nil {
		l = m.RouteConfig.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	if m.LastUpdated != nil {
		l = m.LastUpdated.Size()
		n += 1 + l + sovConfigDump(uint64(l))
	}
	return n
}

func sovConfigDump(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfigDump(x uint64) (n int) {
	return sovConfigDump(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ConfigDump) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigDump: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigDump: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Configs == nil {
				m.Configs = make(map[string]google_protobuf6.Any)
			}
			var mapkey string
			mapvalue := &google_protobuf6.Any{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfigDump
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfigDump
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthConfigDump
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowConfigDump
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthConfigDump
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthConfigDump
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &google_protobuf6.Any{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipConfigDump(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthConfigDump
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Configs[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BootstrapConfigDump) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BootstrapConfigDump: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BootstrapConfigDump: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bootstrap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Bootstrap.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenersConfigDump) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenersConfigDump: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenersConfigDump: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticListeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StaticListeners = append(m.StaticListeners, ListenersConfigDump_StaticListener{})
			if err := m.StaticListeners[len(m.StaticListeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicActiveListeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicActiveListeners = append(m.DynamicActiveListeners, ListenersConfigDump_DynamicListener{})
			if err := m.DynamicActiveListeners[len(m.DynamicActiveListeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicWarmingListeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicWarmingListeners = append(m.DynamicWarmingListeners, ListenersConfigDump_DynamicListener{})
			if err := m.DynamicWarmingListeners[len(m.DynamicWarmingListeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicDrainingListeners", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicDrainingListeners = append(m.DynamicDrainingListeners, ListenersConfigDump_DynamicListener{})
			if err := m.DynamicDrainingListeners[len(m.DynamicDrainingListeners)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenersConfigDump_StaticListener) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticListener: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticListener: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listener", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Listener == nil {
				m.Listener = &envoy_api_v23.Listener{}
			}
			if err := m.Listener.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenersConfigDump_DynamicListener) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DynamicListener: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DynamicListener: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Listener", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Listener == nil {
				m.Listener = &envoy_api_v23.Listener{}
			}
			if err := m.Listener.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClustersConfigDump) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClustersConfigDump: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClustersConfigDump: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StaticClusters = append(m.StaticClusters, ClustersConfigDump_StaticCluster{})
			if err := m.StaticClusters[len(m.StaticClusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicActiveClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicActiveClusters = append(m.DynamicActiveClusters, ClustersConfigDump_DynamicCluster{})
			if err := m.DynamicActiveClusters[len(m.DynamicActiveClusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicWarmingClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicWarmingClusters = append(m.DynamicWarmingClusters, ClustersConfigDump_DynamicCluster{})
			if err := m.DynamicWarmingClusters[len(m.DynamicWarmingClusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClustersConfigDump_StaticCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cluster == nil {
				m.Cluster = &envoy_api_v22.Cluster{}
			}
			if err := m.Cluster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClustersConfigDump_DynamicCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DynamicCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DynamicCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cluster == nil {
				m.Cluster = &envoy_api_v22.Cluster{}
			}
			if err := m.Cluster.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoutesConfigDump) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoutesConfigDump: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoutesConfigDump: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StaticRouteConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StaticRouteConfigs = append(m.StaticRouteConfigs, RoutesConfigDump_StaticRouteConfig{})
			if err := m.StaticRouteConfigs[len(m.StaticRouteConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DynamicRouteConfigs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DynamicRouteConfigs = append(m.DynamicRouteConfigs, RoutesConfigDump_DynamicRouteConfig{})
			if err := m.DynamicRouteConfigs[len(m.DynamicRouteConfigs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoutesConfigDump_StaticRouteConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StaticRouteConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StaticRouteConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RouteConfig == nil {
				m.RouteConfig = &envoy_api_v24.RouteConfiguration{}
			}
			if err := m.RouteConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoutesConfigDump_DynamicRouteConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DynamicRouteConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DynamicRouteConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VersionInfo", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VersionInfo = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RouteConfig == nil {
				m.RouteConfig = &envoy_api_v24.RouteConfiguration{}
			}
			if err := m.RouteConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdated", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigDump
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LastUpdated == nil {
				m.LastUpdated = &google_protobuf4.Timestamp{}
			}
			if err := m.LastUpdated.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigDump(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigDump
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfigDump(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfigDump
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigDump
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfigDump
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfigDump
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfigDump(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfigDump = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfigDump   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/admin/v2alpha/config_dump.proto", fileDescriptorConfigDump) }

var fileDescriptorConfigDump = []byte{
	// 781 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xcf, 0x6f, 0xd3, 0x48,
	0x14, 0xc7, 0x77, 0x92, 0xb4, 0xdd, 0xbe, 0x64, 0xdb, 0xee, 0xa4, 0x4d, 0x53, 0x1f, 0xda, 0x6c,
	0xb5, 0x2b, 0x75, 0x57, 0x2b, 0x5b, 0x0a, 0x02, 0x2a, 0x24, 0x0e, 0xfd, 0x81, 0x04, 0x52, 0x0f,
	0xc8, 0x80, 0x38, 0x46, 0xd3, 0xd8, 0x49, 0x2d, 0x12, 0x8f, 0xe5, 0x19, 0x1b, 0x82, 0x90, 0x38,
	0xf0, 0x47, 0x70, 0xe3, 0xc2, 0x81, 0x0b, 0x27, 0xae, 0xdc, 0x51, 0x6f, 0xf0, 0x17, 0x20, 0xd4,
	0xbf, 0x04, 0xc5, 0x7e, 0xe3, 0xd8, 0x4e, 0xa8, 0x92, 0x36, 0xb7, 0xc9, 0x9b, 0x37, 0xef, 0xf3,
	0x9d, 0x37, 0xdf, 0xe7, 0xc0, 0x3f, 0xb6, 0x1b, 0xf2, 0x81, 0xc1, 0xac, 0xbe, 0xe3, 0x1a, 0x61,
	0x93, 0xf5, 0xbc, 0x33, 0x66, 0xb4, 0xb9, 0xdb, 0x71, 0xba, 0x2d, 0x2b, 0xe8, 0x7b, 0xba, 0xe7,
	0x73, 0xc9, 0x69, 0x35, 0x4a, 0xd3, 0xa3, 0x34, 0x1d, 0xd3, 0xb4, 0x1a, 0x9e, 0xf5, 0x1c, 0x23,
	0x6c, 0x1a, 0x6d, 0x4b, 0xc4, 0xc9, 0xb9, 0x78, 0xef, 0x17, 0x71, 0x3f, 0x89, 0xff, 0x1b, 0xc7,
	0x63, 0xaa, 0x71, 0xca, 0xb9, 0x14, 0xd2, 0x67, 0xde, 0x30, 0x29, 0xf9, 0x81, 0xa9, 0x5b, 0x5d,
	0xce, 0xbb, 0x3d, 0xdb, 0x88, 0x7e, 0x9d, 0x06, 0x1d, 0x83, 0xb9, 0x03, 0xdc, 0xda, 0xc9, 0x6f,
	0x49, 0xa7, 0x6f, 0x0b, 0xc9, 0xd4, 0x1d, 0xb4, 0xf5, 0x2e, 0xef, 0xf2, 0x68, 0x69, 0x0c, 0x57,
	0x71, 0x74, 0xf7, 0x23, 0x01, 0x38, 0x8a, 0xc8, 0xc7, 0x41, 0xdf, 0xa3, 0x27, 0xb0, 0x14, 0xeb,
	0x10, 0x75, 0xd2, 0x28, 0xee, 0x95, 0x9b, 0xff, 0xeb, 0x13, 0xae, 0xae, 0x8f, 0x4e, 0xe0, 0x52,
	0xdc, 0x73, 0xa5, 0x3f, 0x38, 0x2c, 0x9d, 0x7f, 0xdf, 0xf9, 0xcd, 0x54, 0x25, 0xb4, 0x87, 0x50,
	0x49, 0x6f, 0xd3, 0x35, 0x28, 0x3e, 0xb3, 0x07, 0x75, 0xd2, 0x20, 0x7b, 0xcb, 0xe6, 0x70, 0x49,
	0xff, 0x83, 0x85, 0x90, 0xf5, 0x02, 0xbb, 0x5e, 0x68, 0x90, 0xbd, 0x72, 0x73, 0x5d, 0x8f, 0x6f,
	0xa1, 0xab, 0x5b, 0xe8, 0x07, 0xee, 0xc0, 0x8c, 0x53, 0xee, 0x14, 0xf6, 0xc9, 0xee, 0x3b, 0x02,
	0xd5, 0x43, 0xd5, 0x94, 0x94, 0xee, 0xfb, 0xb0, 0x9c, 0xf4, 0x2a, 0xaa, 0x5f, 0x6e, 0xfe, 0x8d,
	0xca, 0x63, 0x31, 0xfa, 0xa8, 0x95, 0x61, 0x53, 0x4f, 0x4a, 0xa0, 0xe2, 0xd1, 0x61, 0x7a, 0x17,
	0x2a, 0x3d, 0x26, 0x64, 0x2b, 0xf0, 0x2c, 0x26, 0x6d, 0x0b, 0x85, 0x69, 0x63, 0xc2, 0x1e, 0xab,
	0xf6, 0x9a, 0xe5, 0x61, 0xfe, 0x93, 0x38, 0x7d, 0xf7, 0xcb, 0x22, 0x54, 0x4f, 0x1c, 0x21, 0x6d,
	0xd7, 0xf6, 0x45, 0x4a, 0xe0, 0x5f, 0x50, 0x09, 0x6d, 0x5f, 0x38, 0xdc, 0x6d, 0x39, 0x6e, 0x87,
	0x63, 0x0f, 0xca, 0x18, 0x7b, 0xe0, 0x76, 0x38, 0x3d, 0x83, 0x35, 0x21, 0x99, 0x74, 0xda, 0xad,
	0x9e, 0x2a, 0x50, 0x2f, 0x44, 0x8f, 0x70, 0x7b, 0xe2, 0x23, 0x4c, 0xc0, 0xe8, 0x8f, 0xa2, 0x02,
	0x6a, 0x07, 0x6f, 0xb7, 0x2a, 0x32, 0x51, 0x41, 0x5f, 0x40, 0xdd, 0x1a, 0xb8, 0xac, 0xef, 0xb4,
	0x5b, 0xac, 0x2d, 0x9d, 0xd0, 0x4e, 0x11, 0x8b, 0x11, 0x71, 0x7f, 0x6a, 0xe2, 0x71, 0x5c, 0x28,
	0x87, 0xac, 0x61, 0xfd, 0x83, 0xa8, 0xfc, 0x88, 0xfc, 0x12, 0xb6, 0x14, 0xf9, 0x39, 0xf3, 0xfb,
	0x8e, 0xdb, 0x4d, 0xa1, 0x4b, 0x73, 0x41, 0x6f, 0x22, 0xe0, 0x69, 0x5c, 0x7f, 0xc4, 0x7e, 0x05,
	0x9a, 0x62, 0x5b, 0x3e, 0x73, 0xdc, 0x2c, 0x7c, 0x61, 0x2e, 0x70, 0xd5, 0xd7, 0x63, 0x04, 0x24,
	0x27, 0xb5, 0x37, 0x04, 0x56, 0xb2, 0xaf, 0x43, 0x9b, 0xf0, 0xbb, 0xe2, 0xa3, 0x67, 0x6b, 0x0a,
	0xef, 0x39, 0x43, 0x9b, 0xaa, 0x4c, 0x33, 0xc9, 0xbb, 0xa6, 0x3d, 0xb5, 0x0f, 0x04, 0x56, 0x73,
	0xca, 0xa7, 0xb1, 0x66, 0x5a, 0x69, 0xe1, 0x8a, 0x4a, 0x8b, 0xb3, 0x0d, 0xd2, 0xa7, 0x05, 0xa0,
	0x47, 0xbd, 0x40, 0xc8, 0x99, 0xe7, 0xc8, 0x02, 0x34, 0x7c, 0xab, 0x8d, 0xe7, 0x71, 0x8c, 0x6e,
	0x4e, 0xfe, 0x96, 0x8d, 0x41, 0x70, 0x8a, 0x70, 0x03, 0x5f, 0x76, 0x45, 0xa4, 0x83, 0x82, 0x4a,
	0xd8, 0xcc, 0xcd, 0x50, 0x42, 0x8b, 0x47, 0xe8, 0xd6, 0xb4, 0x34, 0x7c, 0x8f, 0x2c, 0x6e, 0x23,
	0x33, 0x40, 0x09, 0x35, 0x1c, 0x4d, 0xae, 0x9a, 0x9f, 0x04, 0x5b, 0x9a, 0x03, 0xb6, 0x96, 0x1d,
	0x1e, 0x75, 0x4c, 0x7b, 0x0d, 0x7f, 0x64, 0x9a, 0x42, 0x0d, 0x58, 0x42, 0x30, 0x5a, 0x77, 0x23,
	0x6b, 0x08, 0xcc, 0x33, 0x55, 0xd6, 0x75, 0x8d, 0xfb, 0x9e, 0xc0, 0x4a, 0x56, 0xf1, 0x34, 0x56,
	0x48, 0xa9, 0x2c, 0x5c, 0x49, 0xe5, 0x8c, 0xa6, 0xfd, 0x5a, 0x82, 0x35, 0x93, 0x07, 0xd2, 0x4e,
	0x5b, 0x96, 0xc3, 0x3a, 0xfa, 0xd1, 0x1f, 0x6e, 0xb5, 0xd4, 0x1f, 0xec, 0x65, 0xdf, 0xf6, 0x7c,
	0x11, 0xb4, 0x64, 0x14, 0x8e, 0xa3, 0xf8, 0x60, 0x54, 0xe4, 0x37, 0x04, 0xf5, 0x41, 0xb9, 0x27,
	0x47, 0xbc, 0xec, 0xdb, 0x3e, 0x46, 0xc4, 0x6e, 0x8f, 0x23, 0xab, 0xd6, 0xd8, 0x8e, 0xd0, 0xde,
	0x12, 0xf8, 0x73, 0x4c, 0x23, 0x3d, 0x82, 0x4a, 0x5a, 0x01, 0x5a, 0xa5, 0x91, 0x7d, 0x84, 0xd4,
	0x81, 0xc0, 0x67, 0xd2, 0xe1, 0xae, 0x59, 0xf6, 0x53, 0x45, 0xae, 0xe9, 0x9c, 0xcf, 0x04, 0xe8,
	0xf8, 0x5d, 0xa6, 0x71, 0x4f, 0x5e, 0x7d, 0x61, 0x1e, 0xea, 0x67, 0x73, 0xd4, 0x61, 0xe5, 0xfc,
	0x62, 0x9b, 0x7c, 0xbb, 0xd8, 0x26, 0x3f, 0x2e, 0xb6, 0xc9, 0xe9, 0x62, 0x94, 0x7e, 0xe3, 0x67,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xa8, 0xf3, 0x64, 0xe5, 0xb7, 0x0a, 0x00, 0x00,
}
