// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/bypass/config/config.proto

/*
	Package config is a generated protocol buffer package.

	$title: Bypass
	$description: Adapter for connecting to gRPC based adapters as an inline adapter for some templates.
	The `bypass` adapter makes it possible to connect to gRPC based remote adapters using the inline adapter
	model.

	This adapter supports the following templates:
	[metric](https://istio.io/docs/reference/config/template/metric/).
	[checknothing](https://istio.io/docs/reference/config/template/checknothing/).
	[reportnothing](https://istio.io/docs/reference/config/template/reportnothing/).
	[quota](https://istio.io/docs/reference/config/template/quota/).

	Example configuration:
	```
	# sessionBased indicates whether the client should use the Infrastructure API of the backend
	# to create sessions. If set to true, the bypass adapter will first create a session.
	sessionBased: false

	# backendAddress is the remote adapter service backend address.
	backendAddress: localhost:4567

	# params is base64 encoded Any proto that should be passed to the remote backend as
	# configuration.
	params: RGFuJ3MgVG9vbHMgYXJlIGNvb2wh...
	```


	It is generated from these files:
		mixer/adapter/bypass/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import google_protobuf1 "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration format for the Bypass adapter.
type Params struct {
	// The backend address for the remote policy backend.
	BackendAddress string `protobuf:"bytes,1,opt,name=backend_address,json=backendAddress,proto3" json:"backend_address,omitempty"`
	// The actual config parameters to send to the remote backend.
	Params *google_protobuf1.Any `protobuf:"bytes,2,opt,name=params" json:"params,omitempty"`
	// Indicates whether the protocol is session based or not.
	SessionBased bool `protobuf:"varint,3,opt,name=session_based,json=sessionBased,proto3" json:"session_based,omitempty"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

func init() {
	proto.RegisterType((*Params)(nil), "adapter.bypass.config.Params")
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.BackendAddress) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.BackendAddress)))
		i += copy(dAtA[i:], m.BackendAddress)
	}
	if m.Params != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Params.Size()))
		n1, err := m.Params.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.SessionBased {
		dAtA[i] = 0x18
		i++
		if m.SessionBased {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	l = len(m.BackendAddress)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Params != nil {
		l = m.Params.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.SessionBased {
		n += 2
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`BackendAddress:` + fmt.Sprintf("%v", this.BackendAddress) + `,`,
		`Params:` + strings.Replace(fmt.Sprintf("%v", this.Params), "Any", "google_protobuf1.Any", 1) + `,`,
		`SessionBased:` + fmt.Sprintf("%v", this.SessionBased) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackendAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackendAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Params", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Params == nil {
				m.Params = &google_protobuf1.Any{}
			}
			if err := m.Params.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionBased", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SessionBased = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/bypass/config/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 265 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x34, 0x8f, 0x3f, 0x4e, 0xc3, 0x30,
	0x14, 0xc6, 0xfd, 0x40, 0x8a, 0x20, 0xfc, 0x93, 0xa2, 0x22, 0x85, 0x0e, 0x4f, 0x11, 0x0c, 0x64,
	0x40, 0xb6, 0x04, 0x0b, 0x6b, 0x7b, 0x02, 0x94, 0x91, 0xa5, 0x72, 0x6a, 0xd7, 0x8a, 0xa0, 0x76,
	0x64, 0x17, 0x89, 0x6c, 0x0c, 0x1c, 0x80, 0x63, 0x70, 0x94, 0x8e, 0x1d, 0x19, 0x89, 0x59, 0x18,
	0x7b, 0x04, 0xd4, 0xd8, 0x4c, 0xb6, 0x7f, 0xdf, 0xcf, 0xdf, 0xd3, 0x4b, 0xcb, 0x65, 0xf3, 0x2a,
	0x2d, 0xe3, 0x82, 0xb7, 0x2b, 0x69, 0x59, 0xdd, 0xb5, 0xdc, 0x39, 0x36, 0x37, 0x7a, 0xd1, 0xa8,
	0x78, 0xd0, 0xd6, 0x9a, 0x95, 0xc9, 0xce, 0xa3, 0x43, 0x83, 0x43, 0x43, 0x38, 0x1e, 0x29, 0xa3,
	0xcc, 0x60, 0xb0, 0xdd, 0x2d, 0xc8, 0xe3, 0x0b, 0x65, 0x8c, 0x7a, 0x96, 0x6c, 0x78, 0xd5, 0x2f,
	0x0b, 0xc6, 0x75, 0x17, 0xa2, 0xcb, 0x77, 0x48, 0x93, 0x07, 0x6e, 0xf9, 0xd2, 0x65, 0xd7, 0xe9,
	0x59, 0xcd, 0xe7, 0x4f, 0x52, 0x8b, 0x19, 0x17, 0xc2, 0x4a, 0xe7, 0x72, 0x28, 0xa0, 0x3c, 0xac,
	0x4e, 0x23, 0x9e, 0x04, 0x9a, 0xdd, 0xa4, 0x49, 0x3b, 0x7c, 0xc9, 0xf7, 0x0a, 0x28, 0x8f, 0x6e,
	0x47, 0x34, 0xf4, 0xd3, 0xff, 0x7e, 0x3a, 0xd1, 0x5d, 0x15, 0x9d, 0xec, 0x2a, 0x3d, 0x71, 0xd2,
	0xb9, 0xc6, 0xe8, 0x59, 0xcd, 0x9d, 0x14, 0xf9, 0x7e, 0x01, 0xe5, 0x41, 0x75, 0x1c, 0xe1, 0x74,
	0xc7, 0xa6, 0xf7, 0xeb, 0x1e, 0xc9, 0xa6, 0x47, 0xf2, 0xd5, 0x23, 0xd9, 0xf6, 0x48, 0xde, 0x3c,
	0xc2, 0xa7, 0x47, 0xb2, 0xf6, 0x08, 0x1b, 0x8f, 0xf0, 0xed, 0x11, 0x7e, 0x3d, 0x92, 0xad, 0x47,
	0xf8, 0xf8, 0x41, 0xf2, 0x98, 0x84, 0x8d, 0xeb, 0x64, 0x18, 0x7a, 0xf7, 0x17, 0x00, 0x00, 0xff,
	0xff, 0xee, 0xab, 0xf3, 0x2d, 0x3b, 0x01, 0x00, 0x00,
}
