//
//Copyright The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file was autogenerated by go-to-protobuf. Do not edit it manually!

// @generated by protoc-gen-es v1.8.0 with parameter "target=ts"
// @generated from file k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1/generated.proto (package k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1, syntax proto2)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto2 } from "@bufbuild/protobuf";
import { RawExtension } from "../../../../../apimachinery/pkg/runtime/generated_pb.js";
import { ListMeta, ObjectMeta, Status, Time } from "../../../../../apimachinery/pkg/apis/meta/v1/generated_pb.js";

/**
 * ConversionRequest describes the conversion request parameters.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionRequest
 */
export class ConversionRequest extends Message<ConversionRequest> {
  /**
   * uid is an identifier for the individual request/response. It allows distinguishing instances of requests which are
   * otherwise identical (parallel requests, etc).
   * The UID is meant to track the round trip (request/response) between the Kubernetes API server and the webhook, not the user request.
   * It is suitable for correlating log entries between the webhook and apiserver, for either auditing or debugging.
   *
   * @generated from field: optional string uid = 1;
   */
  uid?: string;

  /**
   * desiredAPIVersion is the version to convert given objects to. e.g. "myapi.example.com/v1"
   *
   * @generated from field: optional string desiredAPIVersion = 2;
   */
  desiredAPIVersion?: string;

  /**
   * objects is the list of custom resource objects to be converted.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.runtime.RawExtension objects = 3;
   */
  objects: RawExtension[] = [];

  constructor(data?: PartialMessage<ConversionRequest>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionRequest";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "desiredAPIVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "objects", kind: "message", T: RawExtension, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConversionRequest {
    return new ConversionRequest().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConversionRequest {
    return new ConversionRequest().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConversionRequest {
    return new ConversionRequest().fromJsonString(jsonString, options);
  }

  static equals(a: ConversionRequest | PlainMessage<ConversionRequest> | undefined, b: ConversionRequest | PlainMessage<ConversionRequest> | undefined): boolean {
    return proto2.util.equals(ConversionRequest, a, b);
  }
}

/**
 * ConversionResponse describes a conversion response.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionResponse
 */
export class ConversionResponse extends Message<ConversionResponse> {
  /**
   * uid is an identifier for the individual request/response.
   * This should be copied over from the corresponding `request.uid`.
   *
   * @generated from field: optional string uid = 1;
   */
  uid?: string;

  /**
   * convertedObjects is the list of converted version of `request.objects` if the `result` is successful, otherwise empty.
   * The webhook is expected to set `apiVersion` of these objects to the `request.desiredAPIVersion`. The list
   * must also have the same size as the input list with the same objects in the same order (equal kind, metadata.uid, metadata.name and metadata.namespace).
   * The webhook is allowed to mutate labels and annotations. Any other change to the metadata is silently ignored.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.runtime.RawExtension convertedObjects = 2;
   */
  convertedObjects: RawExtension[] = [];

  /**
   * result contains the result of conversion with extra details if the conversion failed. `result.status` determines if
   * the conversion failed or succeeded. The `result.status` field is required and represents the success or failure of the
   * conversion. A successful conversion must set `result.status` to `Success`. A failed conversion must set
   * `result.status` to `Failure` and provide more details in `result.message` and return http status 200. The `result.message`
   * will be used to construct an error message for the end user.
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Status result = 3;
   */
  result?: Status;

  constructor(data?: PartialMessage<ConversionResponse>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionResponse";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "convertedObjects", kind: "message", T: RawExtension, repeated: true },
    { no: 3, name: "result", kind: "message", T: Status, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConversionResponse {
    return new ConversionResponse().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConversionResponse {
    return new ConversionResponse().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConversionResponse {
    return new ConversionResponse().fromJsonString(jsonString, options);
  }

  static equals(a: ConversionResponse | PlainMessage<ConversionResponse> | undefined, b: ConversionResponse | PlainMessage<ConversionResponse> | undefined): boolean {
    return proto2.util.equals(ConversionResponse, a, b);
  }
}

/**
 * ConversionReview describes a conversion request/response.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionReview
 */
export class ConversionReview extends Message<ConversionReview> {
  /**
   * request describes the attributes for the conversion request.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionRequest request = 1;
   */
  request?: ConversionRequest;

  /**
   * response describes the attributes for the conversion response.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionResponse response = 2;
   */
  response?: ConversionResponse;

  constructor(data?: PartialMessage<ConversionReview>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ConversionReview";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "request", kind: "message", T: ConversionRequest, opt: true },
    { no: 2, name: "response", kind: "message", T: ConversionResponse, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConversionReview {
    return new ConversionReview().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConversionReview {
    return new ConversionReview().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConversionReview {
    return new ConversionReview().fromJsonString(jsonString, options);
  }

  static equals(a: ConversionReview | PlainMessage<ConversionReview> | undefined, b: ConversionReview | PlainMessage<ConversionReview> | undefined): boolean {
    return proto2.util.equals(ConversionReview, a, b);
  }
}

/**
 * CustomResourceColumnDefinition specifies a column for server side printing.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition
 */
export class CustomResourceColumnDefinition extends Message<CustomResourceColumnDefinition> {
  /**
   * name is a human readable name for the column.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * type is an OpenAPI type definition for this column.
   * See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
   *
   * @generated from field: optional string type = 2;
   */
  type?: string;

  /**
   * format is an optional OpenAPI type definition for this column. The 'name' format is applied
   * to the primary identifier column to assist in clients identifying column is the resource name.
   * See https://github.com/OAI/OpenAPI-Specification/blob/master/versions/2.0.md#data-types for details.
   * +optional
   *
   * @generated from field: optional string format = 3;
   */
  format?: string;

  /**
   * description is a human readable description of this column.
   * +optional
   *
   * @generated from field: optional string description = 4;
   */
  description?: string;

  /**
   * priority is an integer defining the relative importance of this column compared to others. Lower
   * numbers are considered higher priority. Columns that may be omitted in limited space scenarios
   * should be given a priority greater than 0.
   * +optional
   *
   * @generated from field: optional int32 priority = 5;
   */
  priority?: number;

  /**
   * jsonPath is a simple JSON path (i.e. with array notation) which is evaluated against
   * each custom resource to produce the value for this column.
   *
   * @generated from field: optional string jsonPath = 6;
   */
  jsonPath?: string;

  constructor(data?: PartialMessage<CustomResourceColumnDefinition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "format", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "description", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "priority", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 6, name: "jsonPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceColumnDefinition {
    return new CustomResourceColumnDefinition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceColumnDefinition {
    return new CustomResourceColumnDefinition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceColumnDefinition {
    return new CustomResourceColumnDefinition().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceColumnDefinition | PlainMessage<CustomResourceColumnDefinition> | undefined, b: CustomResourceColumnDefinition | PlainMessage<CustomResourceColumnDefinition> | undefined): boolean {
    return proto2.util.equals(CustomResourceColumnDefinition, a, b);
  }
}

/**
 * CustomResourceConversion describes how to convert different versions of a CR.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion
 */
export class CustomResourceConversion extends Message<CustomResourceConversion> {
  /**
   * strategy specifies how custom resources are converted between versions. Allowed values are:
   * - `"None"`: The converter only change the apiVersion and would not touch any other field in the custom resource.
   * - `"Webhook"`: API Server will call to an external webhook to do the conversion. Additional information
   *   is needed for this option. This requires spec.preserveUnknownFields to be false, and spec.conversion.webhook to be set.
   *
   * @generated from field: optional string strategy = 1;
   */
  strategy?: string;

  /**
   * webhook describes how to call the conversion webhook. Required when `strategy` is set to `"Webhook"`.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion webhook = 2;
   */
  webhook?: WebhookConversion;

  constructor(data?: PartialMessage<CustomResourceConversion>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "strategy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "webhook", kind: "message", T: WebhookConversion, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceConversion {
    return new CustomResourceConversion().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceConversion {
    return new CustomResourceConversion().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceConversion {
    return new CustomResourceConversion().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceConversion | PlainMessage<CustomResourceConversion> | undefined, b: CustomResourceConversion | PlainMessage<CustomResourceConversion> | undefined): boolean {
    return proto2.util.equals(CustomResourceConversion, a, b);
  }
}

/**
 * CustomResourceDefinition represents a resource that should be exposed on the API server.  Its name MUST be in the format
 * <.spec.name>.<.spec.group>.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition
 */
export class CustomResourceDefinition extends Message<CustomResourceDefinition> {
  /**
   * Standard object's metadata
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * spec describes how the user wants the resources to appear
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec spec = 2;
   */
  spec?: CustomResourceDefinitionSpec;

  /**
   * status indicates the actual state of the CustomResourceDefinition
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus status = 3;
   */
  status?: CustomResourceDefinitionStatus;

  constructor(data?: PartialMessage<CustomResourceDefinition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: CustomResourceDefinitionSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: CustomResourceDefinitionStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinition {
    return new CustomResourceDefinition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinition {
    return new CustomResourceDefinition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinition {
    return new CustomResourceDefinition().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinition | PlainMessage<CustomResourceDefinition> | undefined, b: CustomResourceDefinition | PlainMessage<CustomResourceDefinition> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinition, a, b);
  }
}

/**
 * CustomResourceDefinitionCondition contains details for the current condition of this pod.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition
 */
export class CustomResourceDefinitionCondition extends Message<CustomResourceDefinitionCondition> {
  /**
   * type is the type of the condition. Types include Established, NamesAccepted and Terminating.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * status is the status of the condition.
   * Can be True, False, Unknown.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * lastTransitionTime last time the condition transitioned from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;
   */
  lastTransitionTime?: Time;

  /**
   * reason is a unique, one-word, CamelCase reason for the condition's last transition.
   * +optional
   *
   * @generated from field: optional string reason = 4;
   */
  reason?: string;

  /**
   * message is a human-readable message indicating details about last transition.
   * +optional
   *
   * @generated from field: optional string message = 5;
   */
  message?: string;

  constructor(data?: PartialMessage<CustomResourceDefinitionCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionCondition {
    return new CustomResourceDefinitionCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionCondition {
    return new CustomResourceDefinitionCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionCondition {
    return new CustomResourceDefinitionCondition().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionCondition | PlainMessage<CustomResourceDefinitionCondition> | undefined, b: CustomResourceDefinitionCondition | PlainMessage<CustomResourceDefinitionCondition> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionCondition, a, b);
  }
}

/**
 * CustomResourceDefinitionList is a list of CustomResourceDefinition objects.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList
 */
export class CustomResourceDefinitionList extends Message<CustomResourceDefinitionList> {
  /**
   * Standard object's metadata
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items list individual CustomResourceDefinition objects
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition items = 2;
   */
  items: CustomResourceDefinition[] = [];

  constructor(data?: PartialMessage<CustomResourceDefinitionList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: CustomResourceDefinition, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionList {
    return new CustomResourceDefinitionList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionList {
    return new CustomResourceDefinitionList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionList {
    return new CustomResourceDefinitionList().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionList | PlainMessage<CustomResourceDefinitionList> | undefined, b: CustomResourceDefinitionList | PlainMessage<CustomResourceDefinitionList> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionList, a, b);
  }
}

/**
 * CustomResourceDefinitionNames indicates the names to serve this CustomResourceDefinition
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames
 */
export class CustomResourceDefinitionNames extends Message<CustomResourceDefinitionNames> {
  /**
   * plural is the plural name of the resource to serve.
   * The custom resources are served under `/apis/<group>/<version>/.../<plural>`.
   * Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
   * Must be all lowercase.
   *
   * @generated from field: optional string plural = 1;
   */
  plural?: string;

  /**
   * singular is the singular name of the resource. It must be all lowercase. Defaults to lowercased `kind`.
   * +optional
   *
   * @generated from field: optional string singular = 2;
   */
  singular?: string;

  /**
   * shortNames are short names for the resource, exposed in API discovery documents,
   * and used by clients to support invocations like `kubectl get <shortname>`.
   * It must be all lowercase.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string shortNames = 3;
   */
  shortNames: string[] = [];

  /**
   * kind is the serialized kind of the resource. It is normally CamelCase and singular.
   * Custom resource instances will use this value as the `kind` attribute in API calls.
   *
   * @generated from field: optional string kind = 4;
   */
  kind?: string;

  /**
   * listKind is the serialized kind of the list for this resource. Defaults to "`kind`List".
   * +optional
   *
   * @generated from field: optional string listKind = 5;
   */
  listKind?: string;

  /**
   * categories is a list of grouped resources this custom resource belongs to (e.g. 'all').
   * This is published in API discovery documents, and used by clients to support invocations like
   * `kubectl get all`.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string categories = 6;
   */
  categories: string[] = [];

  constructor(data?: PartialMessage<CustomResourceDefinitionNames>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "plural", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "singular", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "shortNames", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "listKind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "categories", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionNames {
    return new CustomResourceDefinitionNames().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionNames {
    return new CustomResourceDefinitionNames().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionNames {
    return new CustomResourceDefinitionNames().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionNames | PlainMessage<CustomResourceDefinitionNames> | undefined, b: CustomResourceDefinitionNames | PlainMessage<CustomResourceDefinitionNames> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionNames, a, b);
  }
}

/**
 * CustomResourceDefinitionSpec describes how a user wants their resource to appear
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec
 */
export class CustomResourceDefinitionSpec extends Message<CustomResourceDefinitionSpec> {
  /**
   * group is the API group of the defined custom resource.
   * The custom resources are served under `/apis/<group>/...`.
   * Must match the name of the CustomResourceDefinition (in the form `<names.plural>.<group>`).
   *
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * names specify the resource and kind names for the custom resource.
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames names = 3;
   */
  names?: CustomResourceDefinitionNames;

  /**
   * scope indicates whether the defined custom resource is cluster- or namespace-scoped.
   * Allowed values are `Cluster` and `Namespaced`.
   *
   * @generated from field: optional string scope = 4;
   */
  scope?: string;

  /**
   * versions is the list of all API versions of the defined custom resource.
   * Version names are used to compute the order in which served versions are listed in API discovery.
   * If the version string is "kube-like", it will sort above non "kube-like" version strings, which are ordered
   * lexicographically. "Kube-like" versions start with a "v", then are followed by a number (the major version),
   * then optionally the string "alpha" or "beta" and another number (the minor version). These are sorted first
   * by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing
   * major version, then minor version. An example sorted list of versions:
   * v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion versions = 7;
   */
  versions: CustomResourceDefinitionVersion[] = [];

  /**
   * conversion defines conversion settings for the CRD.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceConversion conversion = 9;
   */
  conversion?: CustomResourceConversion;

  /**
   * preserveUnknownFields indicates that object fields which are not specified
   * in the OpenAPI schema should be preserved when persisting to storage.
   * apiVersion, kind, metadata and known fields inside metadata are always preserved.
   * This field is deprecated in favor of setting `x-preserve-unknown-fields` to true in `spec.versions[*].schema.openAPIV3Schema`.
   * See https://kubernetes.io/docs/tasks/extend-kubernetes/custom-resources/custom-resource-definitions/#field-pruning for details.
   * +optional
   *
   * @generated from field: optional bool preserveUnknownFields = 10;
   */
  preserveUnknownFields?: boolean;

  constructor(data?: PartialMessage<CustomResourceDefinitionSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "names", kind: "message", T: CustomResourceDefinitionNames, opt: true },
    { no: 4, name: "scope", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "versions", kind: "message", T: CustomResourceDefinitionVersion, repeated: true },
    { no: 9, name: "conversion", kind: "message", T: CustomResourceConversion, opt: true },
    { no: 10, name: "preserveUnknownFields", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionSpec {
    return new CustomResourceDefinitionSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionSpec {
    return new CustomResourceDefinitionSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionSpec {
    return new CustomResourceDefinitionSpec().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionSpec | PlainMessage<CustomResourceDefinitionSpec> | undefined, b: CustomResourceDefinitionSpec | PlainMessage<CustomResourceDefinitionSpec> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionSpec, a, b);
  }
}

/**
 * CustomResourceDefinitionStatus indicates the state of the CustomResourceDefinition
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus
 */
export class CustomResourceDefinitionStatus extends Message<CustomResourceDefinitionStatus> {
  /**
   * conditions indicate state for particular aspects of a CustomResourceDefinition
   * +optional
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionCondition conditions = 1;
   */
  conditions: CustomResourceDefinitionCondition[] = [];

  /**
   * acceptedNames are the names that are actually being used to serve discovery.
   * They may be different than the names in spec.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionNames acceptedNames = 2;
   */
  acceptedNames?: CustomResourceDefinitionNames;

  /**
   * storedVersions lists all versions of CustomResources that were ever persisted. Tracking these
   * versions allows a migration path for stored versions in etcd. The field is mutable
   * so a migration controller can finish a migration to another version (ensuring
   * no old objects are left in storage), and then remove the rest of the
   * versions from this list.
   * Versions may not be removed from `spec.versions` while they exist in this list.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string storedVersions = 3;
   */
  storedVersions: string[] = [];

  constructor(data?: PartialMessage<CustomResourceDefinitionStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "conditions", kind: "message", T: CustomResourceDefinitionCondition, repeated: true },
    { no: 2, name: "acceptedNames", kind: "message", T: CustomResourceDefinitionNames, opt: true },
    { no: 3, name: "storedVersions", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionStatus {
    return new CustomResourceDefinitionStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionStatus {
    return new CustomResourceDefinitionStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionStatus {
    return new CustomResourceDefinitionStatus().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionStatus | PlainMessage<CustomResourceDefinitionStatus> | undefined, b: CustomResourceDefinitionStatus | PlainMessage<CustomResourceDefinitionStatus> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionStatus, a, b);
  }
}

/**
 * CustomResourceDefinitionVersion describes a version for CRD.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion
 */
export class CustomResourceDefinitionVersion extends Message<CustomResourceDefinitionVersion> {
  /**
   * name is the version name, e.g. “v1”, “v2beta1”, etc.
   * The custom resources are served under this version at `/apis/<group>/<version>/...` if `served` is true.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * served is a flag enabling/disabling this version from being served via REST APIs
   *
   * @generated from field: optional bool served = 2;
   */
  served?: boolean;

  /**
   * storage indicates this version should be used when persisting custom resources to storage.
   * There must be exactly one version with storage=true.
   *
   * @generated from field: optional bool storage = 3;
   */
  storage?: boolean;

  /**
   * deprecated indicates this version of the custom resource API is deprecated.
   * When set to true, API requests to this version receive a warning header in the server response.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool deprecated = 7;
   */
  deprecated?: boolean;

  /**
   * deprecationWarning overrides the default warning returned to API clients.
   * May only be set when `deprecated` is true.
   * The default warning indicates this version is deprecated and recommends use
   * of the newest served version of equal or greater stability, if one exists.
   * +optional
   *
   * @generated from field: optional string deprecationWarning = 8;
   */
  deprecationWarning?: string;

  /**
   * schema describes the schema used for validation, pruning, and defaulting of this version of the custom resource.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation schema = 4;
   */
  schema?: CustomResourceValidation;

  /**
   * subresources specify what subresources this version of the defined custom resource have.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources subresources = 5;
   */
  subresources?: CustomResourceSubresources;

  /**
   * additionalPrinterColumns specifies additional columns returned in Table output.
   * See https://kubernetes.io/docs/reference/using-api/api-concepts/#receiving-resources-as-tables for details.
   * If no columns are specified, a single column displaying the age of the custom resource is used.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceColumnDefinition additionalPrinterColumns = 6;
   */
  additionalPrinterColumns: CustomResourceColumnDefinition[] = [];

  /**
   * selectableFields specifies paths to fields that may be used as field selectors.
   * A maximum of 8 selectable fields are allowed.
   * See https://kubernetes.io/docs/concepts/overview/working-with-objects/field-selectors
   *
   * +featureGate=CustomResourceFieldSelectors
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField selectableFields = 9;
   */
  selectableFields: SelectableField[] = [];

  constructor(data?: PartialMessage<CustomResourceDefinitionVersion>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionVersion";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "served", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "storage", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "deprecated", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 8, name: "deprecationWarning", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "schema", kind: "message", T: CustomResourceValidation, opt: true },
    { no: 5, name: "subresources", kind: "message", T: CustomResourceSubresources, opt: true },
    { no: 6, name: "additionalPrinterColumns", kind: "message", T: CustomResourceColumnDefinition, repeated: true },
    { no: 9, name: "selectableFields", kind: "message", T: SelectableField, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceDefinitionVersion {
    return new CustomResourceDefinitionVersion().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceDefinitionVersion {
    return new CustomResourceDefinitionVersion().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceDefinitionVersion {
    return new CustomResourceDefinitionVersion().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceDefinitionVersion | PlainMessage<CustomResourceDefinitionVersion> | undefined, b: CustomResourceDefinitionVersion | PlainMessage<CustomResourceDefinitionVersion> | undefined): boolean {
    return proto2.util.equals(CustomResourceDefinitionVersion, a, b);
  }
}

/**
 * CustomResourceSubresourceScale defines how to serve the scale subresource for CustomResources.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale
 */
export class CustomResourceSubresourceScale extends Message<CustomResourceSubresourceScale> {
  /**
   * specReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `spec.replicas`.
   * Only JSON paths without the array notation are allowed.
   * Must be a JSON Path under `.spec`.
   * If there is no value under the given path in the custom resource, the `/scale` subresource will return an error on GET.
   *
   * @generated from field: optional string specReplicasPath = 1;
   */
  specReplicasPath?: string;

  /**
   * statusReplicasPath defines the JSON path inside of a custom resource that corresponds to Scale `status.replicas`.
   * Only JSON paths without the array notation are allowed.
   * Must be a JSON Path under `.status`.
   * If there is no value under the given path in the custom resource, the `status.replicas` value in the `/scale` subresource
   * will default to 0.
   *
   * @generated from field: optional string statusReplicasPath = 2;
   */
  statusReplicasPath?: string;

  /**
   * labelSelectorPath defines the JSON path inside of a custom resource that corresponds to Scale `status.selector`.
   * Only JSON paths without the array notation are allowed.
   * Must be a JSON Path under `.status` or `.spec`.
   * Must be set to work with HorizontalPodAutoscaler.
   * The field pointed by this JSON path must be a string field (not a complex selector struct)
   * which contains a serialized label selector in string form.
   * More info: https://kubernetes.io/docs/tasks/access-kubernetes-api/custom-resources/custom-resource-definitions#scale-subresource
   * If there is no value under the given path in the custom resource, the `status.selector` value in the `/scale`
   * subresource will default to the empty string.
   * +optional
   *
   * @generated from field: optional string labelSelectorPath = 3;
   */
  labelSelectorPath?: string;

  constructor(data?: PartialMessage<CustomResourceSubresourceScale>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "specReplicasPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "statusReplicasPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "labelSelectorPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceSubresourceScale {
    return new CustomResourceSubresourceScale().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceSubresourceScale {
    return new CustomResourceSubresourceScale().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceSubresourceScale {
    return new CustomResourceSubresourceScale().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceSubresourceScale | PlainMessage<CustomResourceSubresourceScale> | undefined, b: CustomResourceSubresourceScale | PlainMessage<CustomResourceSubresourceScale> | undefined): boolean {
    return proto2.util.equals(CustomResourceSubresourceScale, a, b);
  }
}

/**
 * CustomResourceSubresourceStatus defines how to serve the status subresource for CustomResources.
 * Status is represented by the `.status` JSON path inside of a CustomResource. When set,
 * * exposes a /status subresource for the custom resource
 * * PUT requests to the /status subresource take a custom resource object, and ignore changes to anything except the status stanza
 * * PUT/POST/PATCH requests to the custom resource ignore changes to the status stanza
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus
 */
export class CustomResourceSubresourceStatus extends Message<CustomResourceSubresourceStatus> {
  constructor(data?: PartialMessage<CustomResourceSubresourceStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceSubresourceStatus {
    return new CustomResourceSubresourceStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceSubresourceStatus {
    return new CustomResourceSubresourceStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceSubresourceStatus {
    return new CustomResourceSubresourceStatus().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceSubresourceStatus | PlainMessage<CustomResourceSubresourceStatus> | undefined, b: CustomResourceSubresourceStatus | PlainMessage<CustomResourceSubresourceStatus> | undefined): boolean {
    return proto2.util.equals(CustomResourceSubresourceStatus, a, b);
  }
}

/**
 * CustomResourceSubresources defines the status and scale subresources for CustomResources.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources
 */
export class CustomResourceSubresources extends Message<CustomResourceSubresources> {
  /**
   * status indicates the custom resource should serve a `/status` subresource.
   * When enabled:
   * 1. requests to the custom resource primary endpoint ignore changes to the `status` stanza of the object.
   * 2. requests to the custom resource `/status` subresource ignore changes to anything other than the `status` stanza of the object.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceStatus status = 1;
   */
  status?: CustomResourceSubresourceStatus;

  /**
   * scale indicates the custom resource should serve a `/scale` subresource that returns an `autoscaling/v1` Scale object.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresourceScale scale = 2;
   */
  scale?: CustomResourceSubresourceScale;

  constructor(data?: PartialMessage<CustomResourceSubresources>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceSubresources";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "status", kind: "message", T: CustomResourceSubresourceStatus, opt: true },
    { no: 2, name: "scale", kind: "message", T: CustomResourceSubresourceScale, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceSubresources {
    return new CustomResourceSubresources().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceSubresources {
    return new CustomResourceSubresources().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceSubresources {
    return new CustomResourceSubresources().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceSubresources | PlainMessage<CustomResourceSubresources> | undefined, b: CustomResourceSubresources | PlainMessage<CustomResourceSubresources> | undefined): boolean {
    return proto2.util.equals(CustomResourceSubresources, a, b);
  }
}

/**
 * CustomResourceValidation is a list of validation methods for CustomResources.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation
 */
export class CustomResourceValidation extends Message<CustomResourceValidation> {
  /**
   * openAPIV3Schema is the OpenAPI v3 schema to use for validation and pruning.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps openAPIV3Schema = 1;
   */
  openAPIV3Schema?: JSONSchemaProps;

  constructor(data?: PartialMessage<CustomResourceValidation>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceValidation";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "openAPIV3Schema", kind: "message", T: JSONSchemaProps, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CustomResourceValidation {
    return new CustomResourceValidation().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CustomResourceValidation {
    return new CustomResourceValidation().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CustomResourceValidation {
    return new CustomResourceValidation().fromJsonString(jsonString, options);
  }

  static equals(a: CustomResourceValidation | PlainMessage<CustomResourceValidation> | undefined, b: CustomResourceValidation | PlainMessage<CustomResourceValidation> | undefined): boolean {
    return proto2.util.equals(CustomResourceValidation, a, b);
  }
}

/**
 * ExternalDocumentation allows referencing an external resource for extended documentation.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation
 */
export class ExternalDocumentation extends Message<ExternalDocumentation> {
  /**
   * @generated from field: optional string description = 1;
   */
  description?: string;

  /**
   * @generated from field: optional string url = 2;
   */
  url?: string;

  constructor(data?: PartialMessage<ExternalDocumentation>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "description", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "url", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExternalDocumentation {
    return new ExternalDocumentation().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExternalDocumentation {
    return new ExternalDocumentation().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExternalDocumentation {
    return new ExternalDocumentation().fromJsonString(jsonString, options);
  }

  static equals(a: ExternalDocumentation | PlainMessage<ExternalDocumentation> | undefined, b: ExternalDocumentation | PlainMessage<ExternalDocumentation> | undefined): boolean {
    return proto2.util.equals(ExternalDocumentation, a, b);
  }
}

/**
 * JSON represents any valid JSON value.
 * These types are supported: bool, int64, float64, string, []interface{}, map[string]interface{} and nil.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON
 */
export class JSON extends Message<JSON> {
  /**
   * @generated from field: optional bytes raw = 1;
   */
  raw?: Uint8Array;

  constructor(data?: PartialMessage<JSON>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "raw", kind: "scalar", T: 12 /* ScalarType.BYTES */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JSON {
    return new JSON().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JSON {
    return new JSON().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JSON {
    return new JSON().fromJsonString(jsonString, options);
  }

  static equals(a: JSON | PlainMessage<JSON> | undefined, b: JSON | PlainMessage<JSON> | undefined): boolean {
    return proto2.util.equals(JSON, a, b);
  }
}

/**
 * JSONSchemaProps is a JSON-Schema following Specification Draft 4 (http://json-schema.org/).
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps
 */
export class JSONSchemaProps extends Message<JSONSchemaProps> {
  /**
   * @generated from field: optional string id = 1;
   */
  id?: string;

  /**
   * @generated from field: optional string schema = 2;
   */
  schema?: string;

  /**
   * @generated from field: optional string ref = 3;
   */
  ref?: string;

  /**
   * @generated from field: optional string description = 4;
   */
  description?: string;

  /**
   * @generated from field: optional string type = 5;
   */
  type?: string;

  /**
   * format is an OpenAPI v3 format string. Unknown formats are ignored. The following formats are validated:
   *
   * - bsonobjectid: a bson object ID, i.e. a 24 characters hex string
   * - uri: an URI as parsed by Golang net/url.ParseRequestURI
   * - email: an email address as parsed by Golang net/mail.ParseAddress
   * - hostname: a valid representation for an Internet host name, as defined by RFC 1034, section 3.1 [RFC1034].
   * - ipv4: an IPv4 IP as parsed by Golang net.ParseIP
   * - ipv6: an IPv6 IP as parsed by Golang net.ParseIP
   * - cidr: a CIDR as parsed by Golang net.ParseCIDR
   * - mac: a MAC address as parsed by Golang net.ParseMAC
   * - uuid: an UUID that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{4}-?[0-9a-f]{12}$
   * - uuid3: an UUID3 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?3[0-9a-f]{3}-?[0-9a-f]{4}-?[0-9a-f]{12}$
   * - uuid4: an UUID4 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?4[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$
   * - uuid5: an UUID5 that allows uppercase defined by the regex (?i)^[0-9a-f]{8}-?[0-9a-f]{4}-?5[0-9a-f]{3}-?[89ab][0-9a-f]{3}-?[0-9a-f]{12}$
   * - isbn: an ISBN10 or ISBN13 number string like "0321751043" or "978-0321751041"
   * - isbn10: an ISBN10 number string like "0321751043"
   * - isbn13: an ISBN13 number string like "978-0321751041"
   * - creditcard: a credit card number defined by the regex ^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\\d{3})\\d{11})$ with any non digit characters mixed in
   * - ssn: a U.S. social security number following the regex ^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$
   * - hexcolor: an hexadecimal color code like "#FFFFFF: following the regex ^#?([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$
   * - rgbcolor: an RGB color code like rgb like "rgb(255,255,2559"
   * - byte: base64 encoded binary data
   * - password: any kind of string
   * - date: a date string like "2006-01-02" as defined by full-date in RFC3339
   * - duration: a duration string like "22 ns" as parsed by Golang time.ParseDuration or compatible with Scala duration format
   * - datetime: a date time string like "2014-12-15T19:30:20.000Z" as defined by date-time in RFC3339.
   *
   * @generated from field: optional string format = 6;
   */
  format?: string;

  /**
   * @generated from field: optional string title = 7;
   */
  title?: string;

  /**
   * default is a default value for undefined object fields.
   * Defaulting is a beta feature under the CustomResourceDefaulting feature gate.
   * Defaulting requires spec.preserveUnknownFields to be false.
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON default = 8;
   */
  default?: JSON;

  /**
   * @generated from field: optional double maximum = 9;
   */
  maximum?: number;

  /**
   * @generated from field: optional bool exclusiveMaximum = 10;
   */
  exclusiveMaximum?: boolean;

  /**
   * @generated from field: optional double minimum = 11;
   */
  minimum?: number;

  /**
   * @generated from field: optional bool exclusiveMinimum = 12;
   */
  exclusiveMinimum?: boolean;

  /**
   * @generated from field: optional int64 maxLength = 13;
   */
  maxLength?: bigint;

  /**
   * @generated from field: optional int64 minLength = 14;
   */
  minLength?: bigint;

  /**
   * @generated from field: optional string pattern = 15;
   */
  pattern?: string;

  /**
   * @generated from field: optional int64 maxItems = 16;
   */
  maxItems?: bigint;

  /**
   * @generated from field: optional int64 minItems = 17;
   */
  minItems?: bigint;

  /**
   * @generated from field: optional bool uniqueItems = 18;
   */
  uniqueItems?: boolean;

  /**
   * @generated from field: optional double multipleOf = 19;
   */
  multipleOf?: number;

  /**
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON enum = 20;
   */
  enum: JSON[] = [];

  /**
   * @generated from field: optional int64 maxProperties = 21;
   */
  maxProperties?: bigint;

  /**
   * @generated from field: optional int64 minProperties = 22;
   */
  minProperties?: bigint;

  /**
   * +listType=atomic
   *
   * @generated from field: repeated string required = 23;
   */
  required: string[] = [];

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray items = 24;
   */
  items?: JSONSchemaPropsOrArray;

  /**
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps allOf = 25;
   */
  allOf: JSONSchemaProps[] = [];

  /**
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps oneOf = 26;
   */
  oneOf: JSONSchemaProps[] = [];

  /**
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps anyOf = 27;
   */
  anyOf: JSONSchemaProps[] = [];

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps not = 28;
   */
  not?: JSONSchemaProps;

  /**
   * @generated from field: map<string, k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps> properties = 29;
   */
  properties: { [key: string]: JSONSchemaProps } = {};

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool additionalProperties = 30;
   */
  additionalProperties?: JSONSchemaPropsOrBool;

  /**
   * @generated from field: map<string, k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps> patternProperties = 31;
   */
  patternProperties: { [key: string]: JSONSchemaProps } = {};

  /**
   * @generated from field: map<string, k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray> dependencies = 32;
   */
  dependencies: { [key: string]: JSONSchemaPropsOrStringArray } = {};

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool additionalItems = 33;
   */
  additionalItems?: JSONSchemaPropsOrBool;

  /**
   * @generated from field: map<string, k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps> definitions = 34;
   */
  definitions: { [key: string]: JSONSchemaProps } = {};

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ExternalDocumentation externalDocs = 35;
   */
  externalDocs?: ExternalDocumentation;

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSON example = 36;
   */
  example?: JSON;

  /**
   * @generated from field: optional bool nullable = 37;
   */
  nullable?: boolean;

  /**
   * x-kubernetes-preserve-unknown-fields stops the API server
   * decoding step from pruning fields which are not specified
   * in the validation schema. This affects fields recursively,
   * but switches back to normal pruning behaviour if nested
   * properties or additionalProperties are specified in the schema.
   * This can either be true or undefined. False is forbidden.
   *
   * @generated from field: optional bool xKubernetesPreserveUnknownFields = 38;
   */
  xKubernetesPreserveUnknownFields?: boolean;

  /**
   * x-kubernetes-embedded-resource defines that the value is an
   * embedded Kubernetes runtime.Object, with TypeMeta and
   * ObjectMeta. The type must be object. It is allowed to further
   * restrict the embedded object. kind, apiVersion and metadata
   * are validated automatically. x-kubernetes-preserve-unknown-fields
   * is allowed to be true, but does not have to be if the object
   * is fully specified (up to kind, apiVersion, metadata).
   *
   * @generated from field: optional bool xKubernetesEmbeddedResource = 39;
   */
  xKubernetesEmbeddedResource?: boolean;

  /**
   * x-kubernetes-int-or-string specifies that this value is
   * either an integer or a string. If this is true, an empty
   * type is allowed and type as child of anyOf is permitted
   * if following one of the following patterns:
   *
   * 1) anyOf:
   *    - type: integer
   *    - type: string
   * 2) allOf:
   *    - anyOf:
   *      - type: integer
   *      - type: string
   *    - ... zero or more
   *
   * @generated from field: optional bool xKubernetesIntOrString = 40;
   */
  xKubernetesIntOrString?: boolean;

  /**
   * x-kubernetes-list-map-keys annotates an array with the x-kubernetes-list-type `map` by specifying the keys used
   * as the index of the map.
   *
   * This tag MUST only be used on lists that have the "x-kubernetes-list-type"
   * extension set to "map". Also, the values specified for this attribute must
   * be a scalar typed field of the child structure (no nesting is supported).
   *
   * The properties specified must either be required or have a default value,
   * to ensure those properties are present for all list items.
   *
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string xKubernetesListMapKeys = 41;
   */
  xKubernetesListMapKeys: string[] = [];

  /**
   * x-kubernetes-list-type annotates an array to further describe its topology.
   * This extension must only be used on lists and may have 3 possible values:
   *
   * 1) `atomic`: the list is treated as a single entity, like a scalar.
   *      Atomic lists will be entirely replaced when updated. This extension
   *      may be used on any type of list (struct, scalar, ...).
   * 2) `set`:
   *      Sets are lists that must not have multiple items with the same value. Each
   *      value must be a scalar, an object with x-kubernetes-map-type `atomic` or an
   *      array with x-kubernetes-list-type `atomic`.
   * 3) `map`:
   *      These lists are like maps in that their elements have a non-index key
   *      used to identify them. Order is preserved upon merge. The map tag
   *      must only be used on a list with elements of type object.
   * Defaults to atomic for arrays.
   * +optional
   *
   * @generated from field: optional string xKubernetesListType = 42;
   */
  xKubernetesListType?: string;

  /**
   * x-kubernetes-map-type annotates an object to further describe its topology.
   * This extension must only be used when type is object and may have 2 possible values:
   *
   * 1) `granular`:
   *      These maps are actual maps (key-value pairs) and each fields are independent
   *      from each other (they can each be manipulated by separate actors). This is
   *      the default behaviour for all maps.
   * 2) `atomic`: the list is treated as a single entity, like a scalar.
   *      Atomic maps will be entirely replaced when updated.
   * +optional
   *
   * @generated from field: optional string xKubernetesMapType = 43;
   */
  xKubernetesMapType?: string;

  /**
   * x-kubernetes-validations describes a list of validation rules written in the CEL expression language.
   * +patchMergeKey=rule
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=rule
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule xKubernetesValidations = 44;
   */
  xKubernetesValidations: ValidationRule[] = [];

  constructor(data?: PartialMessage<JSONSchemaProps>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "id", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "schema", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "ref", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "description", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "format", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "title", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "default", kind: "message", T: JSON, opt: true },
    { no: 9, name: "maximum", kind: "scalar", T: 1 /* ScalarType.DOUBLE */, opt: true },
    { no: 10, name: "exclusiveMaximum", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 11, name: "minimum", kind: "scalar", T: 1 /* ScalarType.DOUBLE */, opt: true },
    { no: 12, name: "exclusiveMinimum", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 13, name: "maxLength", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 14, name: "minLength", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 15, name: "pattern", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 16, name: "maxItems", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 17, name: "minItems", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 18, name: "uniqueItems", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 19, name: "multipleOf", kind: "scalar", T: 1 /* ScalarType.DOUBLE */, opt: true },
    { no: 20, name: "enum", kind: "message", T: JSON, repeated: true },
    { no: 21, name: "maxProperties", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 22, name: "minProperties", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 23, name: "required", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 24, name: "items", kind: "message", T: JSONSchemaPropsOrArray, opt: true },
    { no: 25, name: "allOf", kind: "message", T: JSONSchemaProps, repeated: true },
    { no: 26, name: "oneOf", kind: "message", T: JSONSchemaProps, repeated: true },
    { no: 27, name: "anyOf", kind: "message", T: JSONSchemaProps, repeated: true },
    { no: 28, name: "not", kind: "message", T: JSONSchemaProps, opt: true },
    { no: 29, name: "properties", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: JSONSchemaProps} },
    { no: 30, name: "additionalProperties", kind: "message", T: JSONSchemaPropsOrBool, opt: true },
    { no: 31, name: "patternProperties", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: JSONSchemaProps} },
    { no: 32, name: "dependencies", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: JSONSchemaPropsOrStringArray} },
    { no: 33, name: "additionalItems", kind: "message", T: JSONSchemaPropsOrBool, opt: true },
    { no: 34, name: "definitions", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: JSONSchemaProps} },
    { no: 35, name: "externalDocs", kind: "message", T: ExternalDocumentation, opt: true },
    { no: 36, name: "example", kind: "message", T: JSON, opt: true },
    { no: 37, name: "nullable", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 38, name: "xKubernetesPreserveUnknownFields", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 39, name: "xKubernetesEmbeddedResource", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 40, name: "xKubernetesIntOrString", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 41, name: "xKubernetesListMapKeys", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 42, name: "xKubernetesListType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 43, name: "xKubernetesMapType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 44, name: "xKubernetesValidations", kind: "message", T: ValidationRule, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JSONSchemaProps {
    return new JSONSchemaProps().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JSONSchemaProps {
    return new JSONSchemaProps().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JSONSchemaProps {
    return new JSONSchemaProps().fromJsonString(jsonString, options);
  }

  static equals(a: JSONSchemaProps | PlainMessage<JSONSchemaProps> | undefined, b: JSONSchemaProps | PlainMessage<JSONSchemaProps> | undefined): boolean {
    return proto2.util.equals(JSONSchemaProps, a, b);
  }
}

/**
 * JSONSchemaPropsOrArray represents a value that can either be a JSONSchemaProps
 * or an array of JSONSchemaProps. Mainly here for serialization purposes.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray
 */
export class JSONSchemaPropsOrArray extends Message<JSONSchemaPropsOrArray> {
  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps schema = 1;
   */
  schema?: JSONSchemaProps;

  /**
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps jSONSchemas = 2;
   */
  jSONSchemas: JSONSchemaProps[] = [];

  constructor(data?: PartialMessage<JSONSchemaPropsOrArray>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrArray";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "schema", kind: "message", T: JSONSchemaProps, opt: true },
    { no: 2, name: "jSONSchemas", kind: "message", T: JSONSchemaProps, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JSONSchemaPropsOrArray {
    return new JSONSchemaPropsOrArray().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrArray {
    return new JSONSchemaPropsOrArray().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrArray {
    return new JSONSchemaPropsOrArray().fromJsonString(jsonString, options);
  }

  static equals(a: JSONSchemaPropsOrArray | PlainMessage<JSONSchemaPropsOrArray> | undefined, b: JSONSchemaPropsOrArray | PlainMessage<JSONSchemaPropsOrArray> | undefined): boolean {
    return proto2.util.equals(JSONSchemaPropsOrArray, a, b);
  }
}

/**
 * JSONSchemaPropsOrBool represents JSONSchemaProps or a boolean value.
 * Defaults to true for the boolean property.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool
 */
export class JSONSchemaPropsOrBool extends Message<JSONSchemaPropsOrBool> {
  /**
   * @generated from field: optional bool allows = 1;
   */
  allows?: boolean;

  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps schema = 2;
   */
  schema?: JSONSchemaProps;

  constructor(data?: PartialMessage<JSONSchemaPropsOrBool>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrBool";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "allows", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "schema", kind: "message", T: JSONSchemaProps, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JSONSchemaPropsOrBool {
    return new JSONSchemaPropsOrBool().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrBool {
    return new JSONSchemaPropsOrBool().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrBool {
    return new JSONSchemaPropsOrBool().fromJsonString(jsonString, options);
  }

  static equals(a: JSONSchemaPropsOrBool | PlainMessage<JSONSchemaPropsOrBool> | undefined, b: JSONSchemaPropsOrBool | PlainMessage<JSONSchemaPropsOrBool> | undefined): boolean {
    return proto2.util.equals(JSONSchemaPropsOrBool, a, b);
  }
}

/**
 * JSONSchemaPropsOrStringArray represents a JSONSchemaProps or a string array.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray
 */
export class JSONSchemaPropsOrStringArray extends Message<JSONSchemaPropsOrStringArray> {
  /**
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaProps schema = 1;
   */
  schema?: JSONSchemaProps;

  /**
   * +listType=atomic
   *
   * @generated from field: repeated string property = 2;
   */
  property: string[] = [];

  constructor(data?: PartialMessage<JSONSchemaPropsOrStringArray>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.JSONSchemaPropsOrStringArray";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "schema", kind: "message", T: JSONSchemaProps, opt: true },
    { no: 2, name: "property", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JSONSchemaPropsOrStringArray {
    return new JSONSchemaPropsOrStringArray().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrStringArray {
    return new JSONSchemaPropsOrStringArray().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JSONSchemaPropsOrStringArray {
    return new JSONSchemaPropsOrStringArray().fromJsonString(jsonString, options);
  }

  static equals(a: JSONSchemaPropsOrStringArray | PlainMessage<JSONSchemaPropsOrStringArray> | undefined, b: JSONSchemaPropsOrStringArray | PlainMessage<JSONSchemaPropsOrStringArray> | undefined): boolean {
    return proto2.util.equals(JSONSchemaPropsOrStringArray, a, b);
  }
}

/**
 * SelectableField specifies the JSON path of a field that may be used with field selectors.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField
 */
export class SelectableField extends Message<SelectableField> {
  /**
   * jsonPath is a simple JSON path which is evaluated against each custom resource to produce a
   * field selector value.
   * Only JSON paths without the array notation are allowed.
   * Must point to a field of type string, boolean or integer. Types with enum values
   * and strings with formats are allowed.
   * If jsonPath refers to absent field in a resource, the jsonPath evaluates to an empty string.
   * Must not point to metdata fields.
   * Required.
   *
   * @generated from field: optional string jsonPath = 1;
   */
  jsonPath?: string;

  constructor(data?: PartialMessage<SelectableField>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.SelectableField";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "jsonPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SelectableField {
    return new SelectableField().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SelectableField {
    return new SelectableField().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SelectableField {
    return new SelectableField().fromJsonString(jsonString, options);
  }

  static equals(a: SelectableField | PlainMessage<SelectableField> | undefined, b: SelectableField | PlainMessage<SelectableField> | undefined): boolean {
    return proto2.util.equals(SelectableField, a, b);
  }
}

/**
 * ServiceReference holds a reference to Service.legacy.k8s.io
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference
 */
export class ServiceReference extends Message<ServiceReference> {
  /**
   * namespace is the namespace of the service.
   * Required
   *
   * @generated from field: optional string namespace = 1;
   */
  namespace?: string;

  /**
   * name is the name of the service.
   * Required
   *
   * @generated from field: optional string name = 2;
   */
  name?: string;

  /**
   * path is an optional URL path at which the webhook will be contacted.
   * +optional
   *
   * @generated from field: optional string path = 3;
   */
  path?: string;

  /**
   * port is an optional service port at which the webhook will be contacted.
   * `port` should be a valid port number (1-65535, inclusive).
   * Defaults to 443 for backward compatibility.
   * +optional
   *
   * @generated from field: optional int32 port = 4;
   */
  port?: number;

  constructor(data?: PartialMessage<ServiceReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceReference {
    return new ServiceReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceReference {
    return new ServiceReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceReference {
    return new ServiceReference().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceReference | PlainMessage<ServiceReference> | undefined, b: ServiceReference | PlainMessage<ServiceReference> | undefined): boolean {
    return proto2.util.equals(ServiceReference, a, b);
  }
}

/**
 * ValidationRule describes a validation rule written in the CEL expression language.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule
 */
export class ValidationRule extends Message<ValidationRule> {
  /**
   * Rule represents the expression which will be evaluated by CEL.
   * ref: https://github.com/google/cel-spec
   * The Rule is scoped to the location of the x-kubernetes-validations extension in the schema.
   * The `self` variable in the CEL expression is bound to the scoped value.
   * Example:
   * - Rule scoped to the root of a resource with a status subresource: {"rule": "self.status.actual <= self.spec.maxDesired"}
   *
   * If the Rule is scoped to an object with properties, the accessible properties of the object are field selectable
   * via `self.field` and field presence can be checked via `has(self.field)`. Null valued fields are treated as
   * absent fields in CEL expressions.
   * If the Rule is scoped to an object with additionalProperties (i.e. a map) the value of the map
   * are accessible via `self[mapKey]`, map containment can be checked via `mapKey in self` and all entries of the map
   * are accessible via CEL macros and functions such as `self.all(...)`.
   * If the Rule is scoped to an array, the elements of the array are accessible via `self[i]` and also by macros and
   * functions.
   * If the Rule is scoped to a scalar, `self` is bound to the scalar value.
   * Examples:
   * - Rule scoped to a map of objects: {"rule": "self.components['Widget'].priority < 10"}
   * - Rule scoped to a list of integers: {"rule": "self.values.all(value, value >= 0 && value < 100)"}
   * - Rule scoped to a string value: {"rule": "self.startsWith('kube')"}
   *
   * The `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the
   * object and from any x-kubernetes-embedded-resource annotated objects. No other metadata properties are accessible.
   *
   * Unknown data preserved in custom resources via x-kubernetes-preserve-unknown-fields is not accessible in CEL
   * expressions. This includes:
   * - Unknown field values that are preserved by object schemas with x-kubernetes-preserve-unknown-fields.
   * - Object properties where the property schema is of an "unknown type". An "unknown type" is recursively defined as:
   *   - A schema with no type and x-kubernetes-preserve-unknown-fields set to true
   *   - An array where the items schema is of an "unknown type"
   *   - An object where the additionalProperties schema is of an "unknown type"
   *
   * Only property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible.
   * Accessible property names are escaped according to the following rules when accessed in the expression:
   * - '__' escapes to '__underscores__'
   * - '.' escapes to '__dot__'
   * - '-' escapes to '__dash__'
   * - '/' escapes to '__slash__'
   * - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:
   * 	  "true", "false", "null", "in", "as", "break", "const", "continue", "else", "for", "function", "if",
   * 	  "import", "let", "loop", "package", "namespace", "return".
   * Examples:
   *   - Rule accessing a property named "namespace": {"rule": "self.__namespace__ > 0"}
   *   - Rule accessing a property named "x-prop": {"rule": "self.x__dash__prop > 0"}
   *   - Rule accessing a property named "redact__d": {"rule": "self.redact__underscores__d > 0"}
   *
   * Equality on arrays with x-kubernetes-list-type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1].
   * Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:
   *   - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and
   *     non-intersecting elements in `Y` are appended, retaining their partial order.
   *   - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values
   *     are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with
   *     non-intersecting keys are appended, retaining their partial order.
   *
   * If `rule` makes use of the `oldSelf` variable it is implicitly a
   * `transition rule`.
   *
   * By default, the `oldSelf` variable is the same type as `self`.
   * When `optionalOldSelf` is true, the `oldSelf` variable is a CEL optional
   *  variable whose value() is the same type as `self`.
   * See the documentation for the `optionalOldSelf` field for details.
   *
   * Transition rules by default are applied only on UPDATE requests and are
   * skipped if an old value could not be found. You can opt a transition
   * rule into unconditional evaluation by setting `optionalOldSelf` to true.
   *
   * @generated from field: optional string rule = 1;
   */
  rule?: string;

  /**
   * Message represents the message displayed when validation fails. The message is required if the Rule contains
   * line breaks. The message must not contain line breaks.
   * If unset, the message is "failed rule: {Rule}".
   * e.g. "must be a URL with the host matching spec.host"
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  /**
   * MessageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails.
   * Since messageExpression is used as a failure message, it must evaluate to a string.
   * If both message and messageExpression are present on a rule, then messageExpression will be used if validation
   * fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced
   * as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string
   * that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and
   * the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged.
   * messageExpression has access to all the same variables as the rule; the only difference is the return type.
   * Example:
   * "x must be less than max ("+string(self.max)+")"
   * +optional
   *
   * @generated from field: optional string messageExpression = 3;
   */
  messageExpression?: string;

  /**
   * reason provides a machine-readable validation failure reason that is returned to the caller when a request fails this validation rule.
   * The HTTP status code returned to the caller will match the reason of the reason of the first failed validation rule.
   * The currently supported reasons are: "FieldValueInvalid", "FieldValueForbidden", "FieldValueRequired", "FieldValueDuplicate".
   * If not set, default to use "FieldValueInvalid".
   * All future added reasons must be accepted by clients when reading this value and unknown reasons should be treated as FieldValueInvalid.
   * +optional
   *
   * @generated from field: optional string reason = 4;
   */
  reason?: string;

  /**
   * fieldPath represents the field path returned when the validation fails.
   * It must be a relative JSON path (i.e. with array notation) scoped to the location of this x-kubernetes-validations extension in the schema and refer to an existing field.
   * e.g. when validation checks if a specific attribute `foo` under a map `testMap`, the fieldPath could be set to `.testMap.foo`
   * If the validation checks two lists must have unique attributes, the fieldPath could be set to either of the list: e.g. `.testList`
   * It does not support list numeric index.
   * It supports child operation to refer to an existing field currently. Refer to [JSONPath support in Kubernetes](https://kubernetes.io/docs/reference/kubectl/jsonpath/) for more info.
   * Numeric index of array is not supported.
   * For field name which contains special characters, use `['specialName']` to refer the field name.
   * e.g. for attribute `foo.34$` appears in a list `testList`, the fieldPath could be set to `.testList['foo.34$']`
   * +optional
   *
   * @generated from field: optional string fieldPath = 5;
   */
  fieldPath?: string;

  /**
   * optionalOldSelf is used to opt a transition rule into evaluation
   * even when the object is first created, or if the old object is
   * missing the value.
   *
   * When enabled `oldSelf` will be a CEL optional whose value will be
   * `None` if there is no old value, or when the object is initially created.
   *
   * You may check for presence of oldSelf using `oldSelf.hasValue()` and
   * unwrap it after checking using `oldSelf.value()`. Check the CEL
   * documentation for Optional types for more information:
   * https://pkg.go.dev/github.com/google/cel-go/cel#OptionalTypes
   *
   * May not be set unless `oldSelf` is used in `rule`.
   *
   * +featureGate=CRDValidationRatcheting
   * +optional
   *
   * @generated from field: optional bool optionalOldSelf = 6;
   */
  optionalOldSelf?: boolean;

  constructor(data?: PartialMessage<ValidationRule>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ValidationRule";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "rule", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "messageExpression", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "fieldPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "optionalOldSelf", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ValidationRule {
    return new ValidationRule().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ValidationRule {
    return new ValidationRule().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ValidationRule {
    return new ValidationRule().fromJsonString(jsonString, options);
  }

  static equals(a: ValidationRule | PlainMessage<ValidationRule> | undefined, b: ValidationRule | PlainMessage<ValidationRule> | undefined): boolean {
    return proto2.util.equals(ValidationRule, a, b);
  }
}

/**
 * WebhookClientConfig contains the information to make a TLS connection with the webhook.
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig
 */
export class WebhookClientConfig extends Message<WebhookClientConfig> {
  /**
   * url gives the location of the webhook, in standard URL form
   * (`scheme://host:port/path`). Exactly one of `url` or `service`
   * must be specified.
   *
   * The `host` should not refer to a service running in the cluster; use
   * the `service` field instead. The host might be resolved via external
   * DNS in some apiservers (e.g., `kube-apiserver` cannot resolve
   * in-cluster DNS as that would be a layering violation). `host` may
   * also be an IP address.
   *
   * Please note that using `localhost` or `127.0.0.1` as a `host` is
   * risky unless you take great care to run this webhook on all hosts
   * which run an apiserver which might need to make calls to this
   * webhook. Such installs are likely to be non-portable, i.e., not easy
   * to turn up in a new cluster.
   *
   * The scheme must be "https"; the URL must begin with "https://".
   *
   * A path is optional, and if present may be any string permissible in
   * a URL. You may use the path to pass an arbitrary string to the
   * webhook, for example, a cluster identifier.
   *
   * Attempting to use a user or basic auth e.g. "user:password@" is not
   * allowed. Fragments ("#...") and query parameters ("?...") are not
   * allowed, either.
   *
   * +optional
   *
   * @generated from field: optional string url = 3;
   */
  url?: string;

  /**
   * service is a reference to the service for this webhook. Either
   * service or url must be specified.
   *
   * If the webhook is running within the cluster, then you should use `service`.
   *
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.ServiceReference service = 1;
   */
  service?: ServiceReference;

  /**
   * caBundle is a PEM encoded CA bundle which will be used to validate the webhook's server certificate.
   * If unspecified, system trust roots on the apiserver are used.
   * +optional
   *
   * @generated from field: optional bytes caBundle = 2;
   */
  caBundle?: Uint8Array;

  constructor(data?: PartialMessage<WebhookClientConfig>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 3, name: "url", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 1, name: "service", kind: "message", T: ServiceReference, opt: true },
    { no: 2, name: "caBundle", kind: "scalar", T: 12 /* ScalarType.BYTES */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WebhookClientConfig {
    return new WebhookClientConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WebhookClientConfig {
    return new WebhookClientConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WebhookClientConfig {
    return new WebhookClientConfig().fromJsonString(jsonString, options);
  }

  static equals(a: WebhookClientConfig | PlainMessage<WebhookClientConfig> | undefined, b: WebhookClientConfig | PlainMessage<WebhookClientConfig> | undefined): boolean {
    return proto2.util.equals(WebhookClientConfig, a, b);
  }
}

/**
 * WebhookConversion describes how to call a conversion webhook
 *
 * @generated from message k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion
 */
export class WebhookConversion extends Message<WebhookConversion> {
  /**
   * clientConfig is the instructions for how to call the webhook if strategy is `Webhook`.
   * +optional
   *
   * @generated from field: optional k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookClientConfig clientConfig = 2;
   */
  clientConfig?: WebhookClientConfig;

  /**
   * conversionReviewVersions is an ordered list of preferred `ConversionReview`
   * versions the Webhook expects. The API server will use the first version in
   * the list which it supports. If none of the versions specified in this list
   * are supported by API server, conversion will fail for the custom resource.
   * If a persisted Webhook configuration specifies allowed versions and does not
   * include any versions known to the API Server, calls to the webhook will fail.
   * +listType=atomic
   *
   * @generated from field: repeated string conversionReviewVersions = 3;
   */
  conversionReviewVersions: string[] = [];

  constructor(data?: PartialMessage<WebhookConversion>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apiextensions_apiserver.pkg.apis.apiextensions.v1.WebhookConversion";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 2, name: "clientConfig", kind: "message", T: WebhookClientConfig, opt: true },
    { no: 3, name: "conversionReviewVersions", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WebhookConversion {
    return new WebhookConversion().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WebhookConversion {
    return new WebhookConversion().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WebhookConversion {
    return new WebhookConversion().fromJsonString(jsonString, options);
  }

  static equals(a: WebhookConversion | PlainMessage<WebhookConversion> | undefined, b: WebhookConversion | PlainMessage<WebhookConversion> | undefined): boolean {
    return proto2.util.equals(WebhookConversion, a, b);
  }
}

