//
//Copyright The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file was autogenerated by go-to-protobuf. Do not edit it manually!

// @generated by protoc-gen-es v1.8.0 with parameter "target=ts"
// @generated from file k8s.io/api/core/v1/generated.proto (package k8s.io.api.core.v1, syntax proto2)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto2 } from "@bufbuild/protobuf";
import { Condition, LabelSelector, ListMeta, MicroTime, ObjectMeta, OwnerReference, Time } from "../../../apimachinery/pkg/apis/meta/v1/generated_pb.js";
import { Quantity } from "../../../apimachinery/pkg/api/resource/generated_pb.js";
import { IntOrString } from "../../../apimachinery/pkg/util/intstr/generated_pb.js";
import { RawExtension } from "../../../apimachinery/pkg/runtime/generated_pb.js";

/**
 * Represents a Persistent Disk resource in AWS.
 *
 * An AWS EBS disk must exist before mounting to a container. The disk
 * must also be in the same AWS zone as the kubelet. An AWS EBS disk
 * can only be mounted as read/write once. AWS EBS volumes support
 * ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource
 */
export class AWSElasticBlockStoreVolumeSource extends Message<AWSElasticBlockStoreVolumeSource> {
  /**
   * volumeID is unique ID of the persistent disk resource in AWS (Amazon EBS volume).
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
   *
   * @generated from field: optional string volumeID = 1;
   */
  volumeID?: string;

  /**
   * fsType is the filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * partition is the partition in the volume that you want to mount.
   * If omitted, the default is to mount by volume name.
   * Examples: For volume /dev/sda1, you specify the partition as "1".
   * Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
   * +optional
   *
   * @generated from field: optional int32 partition = 3;
   */
  partition?: number;

  /**
   * readOnly value true will force the readOnly setting in VolumeMounts.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<AWSElasticBlockStoreVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "partition", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AWSElasticBlockStoreVolumeSource {
    return new AWSElasticBlockStoreVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AWSElasticBlockStoreVolumeSource {
    return new AWSElasticBlockStoreVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AWSElasticBlockStoreVolumeSource {
    return new AWSElasticBlockStoreVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: AWSElasticBlockStoreVolumeSource | PlainMessage<AWSElasticBlockStoreVolumeSource> | undefined, b: AWSElasticBlockStoreVolumeSource | PlainMessage<AWSElasticBlockStoreVolumeSource> | undefined): boolean {
    return proto2.util.equals(AWSElasticBlockStoreVolumeSource, a, b);
  }
}

/**
 * Affinity is a group of affinity scheduling rules.
 *
 * @generated from message k8s.io.api.core.v1.Affinity
 */
export class Affinity extends Message<Affinity> {
  /**
   * Describes node affinity scheduling rules for the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeAffinity nodeAffinity = 1;
   */
  nodeAffinity?: NodeAffinity;

  /**
   * Describes pod affinity scheduling rules (e.g. co-locate this pod in the same node, zone, etc. as some other pod(s)).
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodAffinity podAffinity = 2;
   */
  podAffinity?: PodAffinity;

  /**
   * Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in the same node, zone, etc. as some other pod(s)).
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodAntiAffinity podAntiAffinity = 3;
   */
  podAntiAffinity?: PodAntiAffinity;

  constructor(data?: PartialMessage<Affinity>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Affinity";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "nodeAffinity", kind: "message", T: NodeAffinity, opt: true },
    { no: 2, name: "podAffinity", kind: "message", T: PodAffinity, opt: true },
    { no: 3, name: "podAntiAffinity", kind: "message", T: PodAntiAffinity, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Affinity {
    return new Affinity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Affinity {
    return new Affinity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Affinity {
    return new Affinity().fromJsonString(jsonString, options);
  }

  static equals(a: Affinity | PlainMessage<Affinity> | undefined, b: Affinity | PlainMessage<Affinity> | undefined): boolean {
    return proto2.util.equals(Affinity, a, b);
  }
}

/**
 * AppArmorProfile defines a pod or container's AppArmor settings.
 * +union
 *
 * @generated from message k8s.io.api.core.v1.AppArmorProfile
 */
export class AppArmorProfile extends Message<AppArmorProfile> {
  /**
   * type indicates which kind of AppArmor profile will be applied.
   * Valid options are:
   *   Localhost - a profile pre-loaded on the node.
   *   RuntimeDefault - the container runtime's default profile.
   *   Unconfined - no AppArmor enforcement.
   * +unionDiscriminator
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * localhostProfile indicates a profile loaded on the node that should be used.
   * The profile must be preconfigured on the node to work.
   * Must match the loaded name of the profile.
   * Must be set if and only if type is "Localhost".
   * +optional
   *
   * @generated from field: optional string localhostProfile = 2;
   */
  localhostProfile?: string;

  constructor(data?: PartialMessage<AppArmorProfile>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AppArmorProfile";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "localhostProfile", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AppArmorProfile {
    return new AppArmorProfile().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AppArmorProfile {
    return new AppArmorProfile().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AppArmorProfile {
    return new AppArmorProfile().fromJsonString(jsonString, options);
  }

  static equals(a: AppArmorProfile | PlainMessage<AppArmorProfile> | undefined, b: AppArmorProfile | PlainMessage<AppArmorProfile> | undefined): boolean {
    return proto2.util.equals(AppArmorProfile, a, b);
  }
}

/**
 * AttachedVolume describes a volume attached to a node
 *
 * @generated from message k8s.io.api.core.v1.AttachedVolume
 */
export class AttachedVolume extends Message<AttachedVolume> {
  /**
   * Name of the attached volume
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * DevicePath represents the device path where the volume should be available
   *
   * @generated from field: optional string devicePath = 2;
   */
  devicePath?: string;

  constructor(data?: PartialMessage<AttachedVolume>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AttachedVolume";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "devicePath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AttachedVolume {
    return new AttachedVolume().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AttachedVolume {
    return new AttachedVolume().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AttachedVolume {
    return new AttachedVolume().fromJsonString(jsonString, options);
  }

  static equals(a: AttachedVolume | PlainMessage<AttachedVolume> | undefined, b: AttachedVolume | PlainMessage<AttachedVolume> | undefined): boolean {
    return proto2.util.equals(AttachedVolume, a, b);
  }
}

/**
 * AvoidPods describes pods that should avoid this node. This is the value for a
 * Node annotation with key scheduler.alpha.kubernetes.io/preferAvoidPods and
 * will eventually become a field of NodeStatus.
 *
 * @generated from message k8s.io.api.core.v1.AvoidPods
 */
export class AvoidPods extends Message<AvoidPods> {
  /**
   * Bounded-sized list of signatures of pods that should avoid this node, sorted
   * in timestamp order from oldest to newest. Size of the slice is unspecified.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PreferAvoidPodsEntry preferAvoidPods = 1;
   */
  preferAvoidPods: PreferAvoidPodsEntry[] = [];

  constructor(data?: PartialMessage<AvoidPods>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AvoidPods";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "preferAvoidPods", kind: "message", T: PreferAvoidPodsEntry, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AvoidPods {
    return new AvoidPods().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AvoidPods {
    return new AvoidPods().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AvoidPods {
    return new AvoidPods().fromJsonString(jsonString, options);
  }

  static equals(a: AvoidPods | PlainMessage<AvoidPods> | undefined, b: AvoidPods | PlainMessage<AvoidPods> | undefined): boolean {
    return proto2.util.equals(AvoidPods, a, b);
  }
}

/**
 * AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 *
 * @generated from message k8s.io.api.core.v1.AzureDiskVolumeSource
 */
export class AzureDiskVolumeSource extends Message<AzureDiskVolumeSource> {
  /**
   * diskName is the Name of the data disk in the blob storage
   *
   * @generated from field: optional string diskName = 1;
   */
  diskName?: string;

  /**
   * diskURI is the URI of data disk in the blob storage
   *
   * @generated from field: optional string diskURI = 2;
   */
  diskURI?: string;

  /**
   * cachingMode is the Host Caching mode: None, Read Only, Read Write.
   * +optional
   * +default=ref(AzureDataDiskCachingReadWrite)
   *
   * @generated from field: optional string cachingMode = 3;
   */
  cachingMode?: string;

  /**
   * fsType is Filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * +optional
   * +default="ext4"
   *
   * @generated from field: optional string fsType = 4;
   */
  fsType?: string;

  /**
   * readOnly Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   * +default=false
   *
   * @generated from field: optional bool readOnly = 5;
   */
  readOnly?: boolean;

  /**
   * kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
   * +default=ref(AzureSharedBlobDisk)
   *
   * @generated from field: optional string kind = 6;
   */
  kind?: string;

  constructor(data?: PartialMessage<AzureDiskVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AzureDiskVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "diskName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "diskURI", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "cachingMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 6, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AzureDiskVolumeSource {
    return new AzureDiskVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AzureDiskVolumeSource {
    return new AzureDiskVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AzureDiskVolumeSource {
    return new AzureDiskVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: AzureDiskVolumeSource | PlainMessage<AzureDiskVolumeSource> | undefined, b: AzureDiskVolumeSource | PlainMessage<AzureDiskVolumeSource> | undefined): boolean {
    return proto2.util.equals(AzureDiskVolumeSource, a, b);
  }
}

/**
 * AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 * @generated from message k8s.io.api.core.v1.AzureFilePersistentVolumeSource
 */
export class AzureFilePersistentVolumeSource extends Message<AzureFilePersistentVolumeSource> {
  /**
   * secretName is the name of secret that contains Azure Storage Account Name and Key
   *
   * @generated from field: optional string secretName = 1;
   */
  secretName?: string;

  /**
   * shareName is the azure Share Name
   *
   * @generated from field: optional string shareName = 2;
   */
  shareName?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * secretNamespace is the namespace of the secret that contains Azure Storage Account Name and Key
   * default is the same as the Pod
   * +optional
   *
   * @generated from field: optional string secretNamespace = 4;
   */
  secretNamespace?: string;

  constructor(data?: PartialMessage<AzureFilePersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AzureFilePersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "secretName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "shareName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "secretNamespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AzureFilePersistentVolumeSource {
    return new AzureFilePersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AzureFilePersistentVolumeSource {
    return new AzureFilePersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AzureFilePersistentVolumeSource {
    return new AzureFilePersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: AzureFilePersistentVolumeSource | PlainMessage<AzureFilePersistentVolumeSource> | undefined, b: AzureFilePersistentVolumeSource | PlainMessage<AzureFilePersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(AzureFilePersistentVolumeSource, a, b);
  }
}

/**
 * AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 * @generated from message k8s.io.api.core.v1.AzureFileVolumeSource
 */
export class AzureFileVolumeSource extends Message<AzureFileVolumeSource> {
  /**
   * secretName is the  name of secret that contains Azure Storage Account Name and Key
   *
   * @generated from field: optional string secretName = 1;
   */
  secretName?: string;

  /**
   * shareName is the azure share Name
   *
   * @generated from field: optional string shareName = 2;
   */
  shareName?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<AzureFileVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.AzureFileVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "secretName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "shareName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): AzureFileVolumeSource {
    return new AzureFileVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): AzureFileVolumeSource {
    return new AzureFileVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): AzureFileVolumeSource {
    return new AzureFileVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: AzureFileVolumeSource | PlainMessage<AzureFileVolumeSource> | undefined, b: AzureFileVolumeSource | PlainMessage<AzureFileVolumeSource> | undefined): boolean {
    return proto2.util.equals(AzureFileVolumeSource, a, b);
  }
}

/**
 * Binding ties one object to another; for example, a pod is bound to a node by a scheduler.
 * Deprecated in 1.7, please use the bindings subresource of pods instead.
 *
 * @generated from message k8s.io.api.core.v1.Binding
 */
export class Binding extends Message<Binding> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * The target object that you want to bind to the standard object.
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference target = 2;
   */
  target?: ObjectReference;

  constructor(data?: PartialMessage<Binding>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Binding";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "target", kind: "message", T: ObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Binding {
    return new Binding().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Binding {
    return new Binding().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Binding {
    return new Binding().fromJsonString(jsonString, options);
  }

  static equals(a: Binding | PlainMessage<Binding> | undefined, b: Binding | PlainMessage<Binding> | undefined): boolean {
    return proto2.util.equals(Binding, a, b);
  }
}

/**
 * Represents storage that is managed by an external CSI volume driver (Beta feature)
 *
 * @generated from message k8s.io.api.core.v1.CSIPersistentVolumeSource
 */
export class CSIPersistentVolumeSource extends Message<CSIPersistentVolumeSource> {
  /**
   * driver is the name of the driver to use for this volume.
   * Required.
   *
   * @generated from field: optional string driver = 1;
   */
  driver?: string;

  /**
   * volumeHandle is the unique volume name returned by the CSI volume
   * plugin’s CreateVolume to refer to the volume on all subsequent calls.
   * Required.
   *
   * @generated from field: optional string volumeHandle = 2;
   */
  volumeHandle?: string;

  /**
   * readOnly value to pass to ControllerPublishVolumeRequest.
   * Defaults to false (read/write).
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * fsType to mount. Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs".
   * +optional
   *
   * @generated from field: optional string fsType = 4;
   */
  fsType?: string;

  /**
   * volumeAttributes of the volume to publish.
   * +optional
   *
   * @generated from field: map<string, string> volumeAttributes = 5;
   */
  volumeAttributes: { [key: string]: string } = {};

  /**
   * controllerPublishSecretRef is a reference to the secret object containing
   * sensitive information to pass to the CSI driver to complete the CSI
   * ControllerPublishVolume and ControllerUnpublishVolume calls.
   * This field is optional, and may be empty if no secret is required. If the
   * secret object contains more than one secret, all secrets are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference controllerPublishSecretRef = 6;
   */
  controllerPublishSecretRef?: SecretReference;

  /**
   * nodeStageSecretRef is a reference to the secret object containing sensitive
   * information to pass to the CSI driver to complete the CSI NodeStageVolume
   * and NodeStageVolume and NodeUnstageVolume calls.
   * This field is optional, and may be empty if no secret is required. If the
   * secret object contains more than one secret, all secrets are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference nodeStageSecretRef = 7;
   */
  nodeStageSecretRef?: SecretReference;

  /**
   * nodePublishSecretRef is a reference to the secret object containing
   * sensitive information to pass to the CSI driver to complete the CSI
   * NodePublishVolume and NodeUnpublishVolume calls.
   * This field is optional, and may be empty if no secret is required. If the
   * secret object contains more than one secret, all secrets are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference nodePublishSecretRef = 8;
   */
  nodePublishSecretRef?: SecretReference;

  /**
   * controllerExpandSecretRef is a reference to the secret object containing
   * sensitive information to pass to the CSI driver to complete the CSI
   * ControllerExpandVolume call.
   * This field is optional, and may be empty if no secret is required. If the
   * secret object contains more than one secret, all secrets are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference controllerExpandSecretRef = 9;
   */
  controllerExpandSecretRef?: SecretReference;

  /**
   * nodeExpandSecretRef is a reference to the secret object containing
   * sensitive information to pass to the CSI driver to complete the CSI
   * NodeExpandVolume call.
   * This field is optional, may be omitted if no secret is required. If the
   * secret object contains more than one secret, all secrets are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference nodeExpandSecretRef = 10;
   */
  nodeExpandSecretRef?: SecretReference;

  constructor(data?: PartialMessage<CSIPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CSIPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "driver", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "volumeHandle", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "volumeAttributes", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 6, name: "controllerPublishSecretRef", kind: "message", T: SecretReference, opt: true },
    { no: 7, name: "nodeStageSecretRef", kind: "message", T: SecretReference, opt: true },
    { no: 8, name: "nodePublishSecretRef", kind: "message", T: SecretReference, opt: true },
    { no: 9, name: "controllerExpandSecretRef", kind: "message", T: SecretReference, opt: true },
    { no: 10, name: "nodeExpandSecretRef", kind: "message", T: SecretReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CSIPersistentVolumeSource {
    return new CSIPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CSIPersistentVolumeSource {
    return new CSIPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CSIPersistentVolumeSource {
    return new CSIPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CSIPersistentVolumeSource | PlainMessage<CSIPersistentVolumeSource> | undefined, b: CSIPersistentVolumeSource | PlainMessage<CSIPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(CSIPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a source location of a volume to mount, managed by an external CSI driver
 *
 * @generated from message k8s.io.api.core.v1.CSIVolumeSource
 */
export class CSIVolumeSource extends Message<CSIVolumeSource> {
  /**
   * driver is the name of the CSI driver that handles this volume.
   * Consult with your admin for the correct name as registered in the cluster.
   *
   * @generated from field: optional string driver = 1;
   */
  driver?: string;

  /**
   * readOnly specifies a read-only configuration for the volume.
   * Defaults to false (read/write).
   * +optional
   *
   * @generated from field: optional bool readOnly = 2;
   */
  readOnly?: boolean;

  /**
   * fsType to mount. Ex. "ext4", "xfs", "ntfs".
   * If not provided, the empty value is passed to the associated CSI driver
   * which will determine the default filesystem to apply.
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * volumeAttributes stores driver-specific properties that are passed to the CSI
   * driver. Consult your driver's documentation for supported values.
   * +optional
   *
   * @generated from field: map<string, string> volumeAttributes = 4;
   */
  volumeAttributes: { [key: string]: string } = {};

  /**
   * nodePublishSecretRef is a reference to the secret object containing
   * sensitive information to pass to the CSI driver to complete the CSI
   * NodePublishVolume and NodeUnpublishVolume calls.
   * This field is optional, and  may be empty if no secret is required. If the
   * secret object contains more than one secret, all secret references are passed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference nodePublishSecretRef = 5;
   */
  nodePublishSecretRef?: LocalObjectReference;

  constructor(data?: PartialMessage<CSIVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CSIVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "driver", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "volumeAttributes", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 5, name: "nodePublishSecretRef", kind: "message", T: LocalObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CSIVolumeSource {
    return new CSIVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CSIVolumeSource {
    return new CSIVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CSIVolumeSource {
    return new CSIVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CSIVolumeSource | PlainMessage<CSIVolumeSource> | undefined, b: CSIVolumeSource | PlainMessage<CSIVolumeSource> | undefined): boolean {
    return proto2.util.equals(CSIVolumeSource, a, b);
  }
}

/**
 * Adds and removes POSIX capabilities from running containers.
 *
 * @generated from message k8s.io.api.core.v1.Capabilities
 */
export class Capabilities extends Message<Capabilities> {
  /**
   * Added capabilities
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string add = 1;
   */
  add: string[] = [];

  /**
   * Removed capabilities
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string drop = 2;
   */
  drop: string[] = [];

  constructor(data?: PartialMessage<Capabilities>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Capabilities";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "add", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "drop", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Capabilities {
    return new Capabilities().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Capabilities {
    return new Capabilities().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Capabilities {
    return new Capabilities().fromJsonString(jsonString, options);
  }

  static equals(a: Capabilities | PlainMessage<Capabilities> | undefined, b: Capabilities | PlainMessage<Capabilities> | undefined): boolean {
    return proto2.util.equals(Capabilities, a, b);
  }
}

/**
 * Represents a Ceph Filesystem mount that lasts the lifetime of a pod
 * Cephfs volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.CephFSPersistentVolumeSource
 */
export class CephFSPersistentVolumeSource extends Message<CephFSPersistentVolumeSource> {
  /**
   * monitors is Required: Monitors is a collection of Ceph monitors
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +listType=atomic
   *
   * @generated from field: repeated string monitors = 1;
   */
  monitors: string[] = [];

  /**
   * path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
   * +optional
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * user is Optional: User is the rados user name, default is admin
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional string user = 3;
   */
  user?: string;

  /**
   * secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional string secretFile = 4;
   */
  secretFile?: string;

  /**
   * secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 5;
   */
  secretRef?: SecretReference;

  /**
   * readOnly is Optional: Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional bool readOnly = 6;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<CephFSPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CephFSPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "monitors", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "secretFile", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "secretRef", kind: "message", T: SecretReference, opt: true },
    { no: 6, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CephFSPersistentVolumeSource {
    return new CephFSPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CephFSPersistentVolumeSource {
    return new CephFSPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CephFSPersistentVolumeSource {
    return new CephFSPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CephFSPersistentVolumeSource | PlainMessage<CephFSPersistentVolumeSource> | undefined, b: CephFSPersistentVolumeSource | PlainMessage<CephFSPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(CephFSPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a Ceph Filesystem mount that lasts the lifetime of a pod
 * Cephfs volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.CephFSVolumeSource
 */
export class CephFSVolumeSource extends Message<CephFSVolumeSource> {
  /**
   * monitors is Required: Monitors is a collection of Ceph monitors
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +listType=atomic
   *
   * @generated from field: repeated string monitors = 1;
   */
  monitors: string[] = [];

  /**
   * path is Optional: Used as the mounted root, rather than the full Ceph tree, default is /
   * +optional
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * user is optional: User is the rados user name, default is admin
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional string user = 3;
   */
  user?: string;

  /**
   * secretFile is Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional string secretFile = 4;
   */
  secretFile?: string;

  /**
   * secretRef is Optional: SecretRef is reference to the authentication secret for User, default is empty.
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 5;
   */
  secretRef?: LocalObjectReference;

  /**
   * readOnly is Optional: Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional bool readOnly = 6;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<CephFSVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CephFSVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "monitors", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "secretFile", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
    { no: 6, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CephFSVolumeSource {
    return new CephFSVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CephFSVolumeSource {
    return new CephFSVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CephFSVolumeSource {
    return new CephFSVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CephFSVolumeSource | PlainMessage<CephFSVolumeSource> | undefined, b: CephFSVolumeSource | PlainMessage<CephFSVolumeSource> | undefined): boolean {
    return proto2.util.equals(CephFSVolumeSource, a, b);
  }
}

/**
 * Represents a cinder volume resource in Openstack.
 * A Cinder volume must exist before mounting to a container.
 * The volume must also be in the same region as the kubelet.
 * Cinder volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.CinderPersistentVolumeSource
 */
export class CinderPersistentVolumeSource extends Message<CinderPersistentVolumeSource> {
  /**
   * volumeID used to identify the volume in cinder.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   *
   * @generated from field: optional string volumeID = 1;
   */
  volumeID?: string;

  /**
   * fsType Filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * readOnly is Optional: Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * secretRef is Optional: points to a secret object containing parameters used to connect
   * to OpenStack.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 4;
   */
  secretRef?: SecretReference;

  constructor(data?: PartialMessage<CinderPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CinderPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "secretRef", kind: "message", T: SecretReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CinderPersistentVolumeSource {
    return new CinderPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CinderPersistentVolumeSource {
    return new CinderPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CinderPersistentVolumeSource {
    return new CinderPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CinderPersistentVolumeSource | PlainMessage<CinderPersistentVolumeSource> | undefined, b: CinderPersistentVolumeSource | PlainMessage<CinderPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(CinderPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a cinder volume resource in Openstack.
 * A Cinder volume must exist before mounting to a container.
 * The volume must also be in the same region as the kubelet.
 * Cinder volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.CinderVolumeSource
 */
export class CinderVolumeSource extends Message<CinderVolumeSource> {
  /**
   * volumeID used to identify the volume in cinder.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   *
   * @generated from field: optional string volumeID = 1;
   */
  volumeID?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * secretRef is optional: points to a secret object containing parameters used to connect
   * to OpenStack.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 4;
   */
  secretRef?: LocalObjectReference;

  constructor(data?: PartialMessage<CinderVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.CinderVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CinderVolumeSource {
    return new CinderVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CinderVolumeSource {
    return new CinderVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CinderVolumeSource {
    return new CinderVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: CinderVolumeSource | PlainMessage<CinderVolumeSource> | undefined, b: CinderVolumeSource | PlainMessage<CinderVolumeSource> | undefined): boolean {
    return proto2.util.equals(CinderVolumeSource, a, b);
  }
}

/**
 * ClientIPConfig represents the configurations of Client IP based session affinity.
 *
 * @generated from message k8s.io.api.core.v1.ClientIPConfig
 */
export class ClientIPConfig extends Message<ClientIPConfig> {
  /**
   * timeoutSeconds specifies the seconds of ClientIP type session sticky time.
   * The value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP".
   * Default value is 10800(for 3 hours).
   * +optional
   *
   * @generated from field: optional int32 timeoutSeconds = 1;
   */
  timeoutSeconds?: number;

  constructor(data?: PartialMessage<ClientIPConfig>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ClientIPConfig";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "timeoutSeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClientIPConfig {
    return new ClientIPConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClientIPConfig {
    return new ClientIPConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClientIPConfig {
    return new ClientIPConfig().fromJsonString(jsonString, options);
  }

  static equals(a: ClientIPConfig | PlainMessage<ClientIPConfig> | undefined, b: ClientIPConfig | PlainMessage<ClientIPConfig> | undefined): boolean {
    return proto2.util.equals(ClientIPConfig, a, b);
  }
}

/**
 * ClusterTrustBundleProjection describes how to select a set of
 * ClusterTrustBundle objects and project their contents into the pod
 * filesystem.
 *
 * @generated from message k8s.io.api.core.v1.ClusterTrustBundleProjection
 */
export class ClusterTrustBundleProjection extends Message<ClusterTrustBundleProjection> {
  /**
   * Select a single ClusterTrustBundle by object name.  Mutually-exclusive
   * with signerName and labelSelector.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Select all ClusterTrustBundles that match this signer name.
   * Mutually-exclusive with name.  The contents of all selected
   * ClusterTrustBundles will be unified and deduplicated.
   * +optional
   *
   * @generated from field: optional string signerName = 2;
   */
  signerName?: string;

  /**
   * Select all ClusterTrustBundles that match this label selector.  Only has
   * effect if signerName is set.  Mutually-exclusive with name.  If unset,
   * interpreted as "match nothing".  If set but empty, interpreted as "match
   * everything".
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector labelSelector = 3;
   */
  labelSelector?: LabelSelector;

  /**
   * If true, don't block pod startup if the referenced ClusterTrustBundle(s)
   * aren't available.  If using name, then the named ClusterTrustBundle is
   * allowed not to exist.  If using signerName, then the combination of
   * signerName and labelSelector is allowed to match zero
   * ClusterTrustBundles.
   * +optional
   *
   * @generated from field: optional bool optional = 5;
   */
  optional?: boolean;

  /**
   * Relative path from the volume root to write the bundle.
   *
   * @generated from field: optional string path = 4;
   */
  path?: string;

  constructor(data?: PartialMessage<ClusterTrustBundleProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ClusterTrustBundleProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "signerName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "labelSelector", kind: "message", T: LabelSelector, opt: true },
    { no: 5, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ClusterTrustBundleProjection {
    return new ClusterTrustBundleProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ClusterTrustBundleProjection {
    return new ClusterTrustBundleProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ClusterTrustBundleProjection {
    return new ClusterTrustBundleProjection().fromJsonString(jsonString, options);
  }

  static equals(a: ClusterTrustBundleProjection | PlainMessage<ClusterTrustBundleProjection> | undefined, b: ClusterTrustBundleProjection | PlainMessage<ClusterTrustBundleProjection> | undefined): boolean {
    return proto2.util.equals(ClusterTrustBundleProjection, a, b);
  }
}

/**
 * Information about the condition of a component.
 *
 * @generated from message k8s.io.api.core.v1.ComponentCondition
 */
export class ComponentCondition extends Message<ComponentCondition> {
  /**
   * Type of condition for a component.
   * Valid value: "Healthy"
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status of the condition for a component.
   * Valid values for "Healthy": "True", "False", or "Unknown".
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * Message about the condition for a component.
   * For example, information about a health check.
   * +optional
   *
   * @generated from field: optional string message = 3;
   */
  message?: string;

  /**
   * Condition error code for a component.
   * For example, a health check error code.
   * +optional
   *
   * @generated from field: optional string error = 4;
   */
  error?: string;

  constructor(data?: PartialMessage<ComponentCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ComponentCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "error", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ComponentCondition {
    return new ComponentCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ComponentCondition {
    return new ComponentCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ComponentCondition {
    return new ComponentCondition().fromJsonString(jsonString, options);
  }

  static equals(a: ComponentCondition | PlainMessage<ComponentCondition> | undefined, b: ComponentCondition | PlainMessage<ComponentCondition> | undefined): boolean {
    return proto2.util.equals(ComponentCondition, a, b);
  }
}

/**
 * ComponentStatus (and ComponentStatusList) holds the cluster validation info.
 * Deprecated: This API is deprecated in v1.19+
 *
 * @generated from message k8s.io.api.core.v1.ComponentStatus
 */
export class ComponentStatus extends Message<ComponentStatus> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * List of component conditions observed
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.ComponentCondition conditions = 2;
   */
  conditions: ComponentCondition[] = [];

  constructor(data?: PartialMessage<ComponentStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ComponentStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "conditions", kind: "message", T: ComponentCondition, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ComponentStatus {
    return new ComponentStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ComponentStatus {
    return new ComponentStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ComponentStatus {
    return new ComponentStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ComponentStatus | PlainMessage<ComponentStatus> | undefined, b: ComponentStatus | PlainMessage<ComponentStatus> | undefined): boolean {
    return proto2.util.equals(ComponentStatus, a, b);
  }
}

/**
 * Status of all the conditions for the component as a list of ComponentStatus objects.
 * Deprecated: This API is deprecated in v1.19+
 *
 * @generated from message k8s.io.api.core.v1.ComponentStatusList
 */
export class ComponentStatusList extends Message<ComponentStatusList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of ComponentStatus objects.
   *
   * @generated from field: repeated k8s.io.api.core.v1.ComponentStatus items = 2;
   */
  items: ComponentStatus[] = [];

  constructor(data?: PartialMessage<ComponentStatusList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ComponentStatusList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: ComponentStatus, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ComponentStatusList {
    return new ComponentStatusList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ComponentStatusList {
    return new ComponentStatusList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ComponentStatusList {
    return new ComponentStatusList().fromJsonString(jsonString, options);
  }

  static equals(a: ComponentStatusList | PlainMessage<ComponentStatusList> | undefined, b: ComponentStatusList | PlainMessage<ComponentStatusList> | undefined): boolean {
    return proto2.util.equals(ComponentStatusList, a, b);
  }
}

/**
 * ConfigMap holds configuration data for pods to consume.
 *
 * @generated from message k8s.io.api.core.v1.ConfigMap
 */
export class ConfigMap extends Message<ConfigMap> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Immutable, if set to true, ensures that data stored in the ConfigMap cannot
   * be updated (only object metadata can be modified).
   * If not set to true, the field can be modified at any time.
   * Defaulted to nil.
   * +optional
   *
   * @generated from field: optional bool immutable = 4;
   */
  immutable?: boolean;

  /**
   * Data contains the configuration data.
   * Each key must consist of alphanumeric characters, '-', '_' or '.'.
   * Values with non-UTF-8 byte sequences must use the BinaryData field.
   * The keys stored in Data must not overlap with the keys in
   * the BinaryData field, this is enforced during validation process.
   * +optional
   *
   * @generated from field: map<string, string> data = 2;
   */
  data: { [key: string]: string } = {};

  /**
   * BinaryData contains the binary data.
   * Each key must consist of alphanumeric characters, '-', '_' or '.'.
   * BinaryData can contain byte sequences that are not in the UTF-8 range.
   * The keys stored in BinaryData must not overlap with the ones in
   * the Data field, this is enforced during validation process.
   * Using this field will require 1.10+ apiserver and
   * kubelet.
   * +optional
   *
   * @generated from field: map<string, bytes> binaryData = 3;
   */
  binaryData: { [key: string]: Uint8Array } = {};

  constructor(data?: PartialMessage<ConfigMap>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMap";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 4, name: "immutable", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "data", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 3, name: "binaryData", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 12 /* ScalarType.BYTES */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMap {
    return new ConfigMap().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMap {
    return new ConfigMap().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMap {
    return new ConfigMap().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMap | PlainMessage<ConfigMap> | undefined, b: ConfigMap | PlainMessage<ConfigMap> | undefined): boolean {
    return proto2.util.equals(ConfigMap, a, b);
  }
}

/**
 * ConfigMapEnvSource selects a ConfigMap to populate the environment
 * variables with.
 *
 * The contents of the target ConfigMap's Data field will represent the
 * key-value pairs as environment variables.
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapEnvSource
 */
export class ConfigMapEnvSource extends Message<ConfigMapEnvSource> {
  /**
   * The ConfigMap to select from.
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * Specify whether the ConfigMap must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 2;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<ConfigMapEnvSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapEnvSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapEnvSource {
    return new ConfigMapEnvSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapEnvSource {
    return new ConfigMapEnvSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapEnvSource {
    return new ConfigMapEnvSource().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapEnvSource | PlainMessage<ConfigMapEnvSource> | undefined, b: ConfigMapEnvSource | PlainMessage<ConfigMapEnvSource> | undefined): boolean {
    return proto2.util.equals(ConfigMapEnvSource, a, b);
  }
}

/**
 * Selects a key from a ConfigMap.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapKeySelector
 */
export class ConfigMapKeySelector extends Message<ConfigMapKeySelector> {
  /**
   * The ConfigMap to select from.
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * The key to select.
   *
   * @generated from field: optional string key = 2;
   */
  key?: string;

  /**
   * Specify whether the ConfigMap or its key must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 3;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<ConfigMapKeySelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapKeySelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapKeySelector {
    return new ConfigMapKeySelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapKeySelector {
    return new ConfigMapKeySelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapKeySelector {
    return new ConfigMapKeySelector().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapKeySelector | PlainMessage<ConfigMapKeySelector> | undefined, b: ConfigMapKeySelector | PlainMessage<ConfigMapKeySelector> | undefined): boolean {
    return proto2.util.equals(ConfigMapKeySelector, a, b);
  }
}

/**
 * ConfigMapList is a resource containing a list of ConfigMap objects.
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapList
 */
export class ConfigMapList extends Message<ConfigMapList> {
  /**
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Items is the list of ConfigMaps.
   *
   * @generated from field: repeated k8s.io.api.core.v1.ConfigMap items = 2;
   */
  items: ConfigMap[] = [];

  constructor(data?: PartialMessage<ConfigMapList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: ConfigMap, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapList {
    return new ConfigMapList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapList {
    return new ConfigMapList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapList {
    return new ConfigMapList().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapList | PlainMessage<ConfigMapList> | undefined, b: ConfigMapList | PlainMessage<ConfigMapList> | undefined): boolean {
    return proto2.util.equals(ConfigMapList, a, b);
  }
}

/**
 * ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node.
 * This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapNodeConfigSource
 */
export class ConfigMapNodeConfigSource extends Message<ConfigMapNodeConfigSource> {
  /**
   * Namespace is the metadata.namespace of the referenced ConfigMap.
   * This field is required in all cases.
   *
   * @generated from field: optional string namespace = 1;
   */
  namespace?: string;

  /**
   * Name is the metadata.name of the referenced ConfigMap.
   * This field is required in all cases.
   *
   * @generated from field: optional string name = 2;
   */
  name?: string;

  /**
   * UID is the metadata.UID of the referenced ConfigMap.
   * This field is forbidden in Node.Spec, and required in Node.Status.
   * +optional
   *
   * @generated from field: optional string uid = 3;
   */
  uid?: string;

  /**
   * ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap.
   * This field is forbidden in Node.Spec, and required in Node.Status.
   * +optional
   *
   * @generated from field: optional string resourceVersion = 4;
   */
  resourceVersion?: string;

  /**
   * KubeletConfigKey declares which key of the referenced ConfigMap corresponds to the KubeletConfiguration structure
   * This field is required in all cases.
   *
   * @generated from field: optional string kubeletConfigKey = 5;
   */
  kubeletConfigKey?: string;

  constructor(data?: PartialMessage<ConfigMapNodeConfigSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapNodeConfigSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "kubeletConfigKey", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapNodeConfigSource {
    return new ConfigMapNodeConfigSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapNodeConfigSource {
    return new ConfigMapNodeConfigSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapNodeConfigSource {
    return new ConfigMapNodeConfigSource().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapNodeConfigSource | PlainMessage<ConfigMapNodeConfigSource> | undefined, b: ConfigMapNodeConfigSource | PlainMessage<ConfigMapNodeConfigSource> | undefined): boolean {
    return proto2.util.equals(ConfigMapNodeConfigSource, a, b);
  }
}

/**
 * Adapts a ConfigMap into a projected volume.
 *
 * The contents of the target ConfigMap's Data field will be presented in a
 * projected volume as files using the keys in the Data field as the file names,
 * unless the items element is populated with specific mappings of keys to paths.
 * Note that this is identical to a configmap volume source without the default
 * mode.
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapProjection
 */
export class ConfigMapProjection extends Message<ConfigMapProjection> {
  /**
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * items if unspecified, each key-value pair in the Data field of the referenced
   * ConfigMap will be projected into the volume as a file whose name is the
   * key and content is the value. If specified, the listed keys will be
   * projected into the specified paths, and unlisted keys will not be
   * present. If a key is specified which is not present in the ConfigMap,
   * the volume setup will error unless it is marked optional. Paths must be
   * relative and may not contain the '..' path or start with '..'.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.KeyToPath items = 2;
   */
  items: KeyToPath[] = [];

  /**
   * optional specify whether the ConfigMap or its keys must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 4;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<ConfigMapProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "items", kind: "message", T: KeyToPath, repeated: true },
    { no: 4, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapProjection {
    return new ConfigMapProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapProjection {
    return new ConfigMapProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapProjection {
    return new ConfigMapProjection().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapProjection | PlainMessage<ConfigMapProjection> | undefined, b: ConfigMapProjection | PlainMessage<ConfigMapProjection> | undefined): boolean {
    return proto2.util.equals(ConfigMapProjection, a, b);
  }
}

/**
 * Adapts a ConfigMap into a volume.
 *
 * The contents of the target ConfigMap's Data field will be presented in a
 * volume as files using the keys in the Data field as the file names, unless
 * the items element is populated with specific mappings of keys to paths.
 * ConfigMap volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.ConfigMapVolumeSource
 */
export class ConfigMapVolumeSource extends Message<ConfigMapVolumeSource> {
  /**
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * items if unspecified, each key-value pair in the Data field of the referenced
   * ConfigMap will be projected into the volume as a file whose name is the
   * key and content is the value. If specified, the listed keys will be
   * projected into the specified paths, and unlisted keys will not be
   * present. If a key is specified which is not present in the ConfigMap,
   * the volume setup will error unless it is marked optional. Paths must be
   * relative and may not contain the '..' path or start with '..'.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.KeyToPath items = 2;
   */
  items: KeyToPath[] = [];

  /**
   * defaultMode is optional: mode bits used to set permissions on created files by default.
   * Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
   * Defaults to 0644.
   * Directories within the path are not affected by this setting.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 defaultMode = 3;
   */
  defaultMode?: number;

  /**
   * optional specify whether the ConfigMap or its keys must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 4;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<ConfigMapVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ConfigMapVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "items", kind: "message", T: KeyToPath, repeated: true },
    { no: 3, name: "defaultMode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ConfigMapVolumeSource {
    return new ConfigMapVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ConfigMapVolumeSource {
    return new ConfigMapVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ConfigMapVolumeSource {
    return new ConfigMapVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ConfigMapVolumeSource | PlainMessage<ConfigMapVolumeSource> | undefined, b: ConfigMapVolumeSource | PlainMessage<ConfigMapVolumeSource> | undefined): boolean {
    return proto2.util.equals(ConfigMapVolumeSource, a, b);
  }
}

/**
 * A single application container that you want to run within a pod.
 *
 * @generated from message k8s.io.api.core.v1.Container
 */
export class Container extends Message<Container> {
  /**
   * Name of the container specified as a DNS_LABEL.
   * Each container in a pod must have a unique name (DNS_LABEL).
   * Cannot be updated.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Container image name.
   * More info: https://kubernetes.io/docs/concepts/containers/images
   * This field is optional to allow higher level config management to default or override
   * container images in workload controllers like Deployments and StatefulSets.
   * +optional
   *
   * @generated from field: optional string image = 2;
   */
  image?: string;

  /**
   * Entrypoint array. Not executed within a shell.
   * The container image's ENTRYPOINT is used if this is not provided.
   * Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
   * cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced
   * to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will
   * produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless
   * of whether the variable exists or not. Cannot be updated.
   * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string command = 3;
   */
  command: string[] = [];

  /**
   * Arguments to the entrypoint.
   * The container image's CMD is used if this is not provided.
   * Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
   * cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced
   * to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will
   * produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless
   * of whether the variable exists or not. Cannot be updated.
   * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string args = 4;
   */
  args: string[] = [];

  /**
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string workingDir = 5;
   */
  workingDir?: string;

  /**
   * List of ports to expose from the container. Not specifying a port here
   * DOES NOT prevent that port from being exposed. Any port which is
   * listening on the default "0.0.0.0" address inside a container will be
   * accessible from the network.
   * Modifying this array with strategic merge patch may corrupt the data.
   * For more information See https://github.com/kubernetes/kubernetes/issues/108255.
   * Cannot be updated.
   * +optional
   * +patchMergeKey=containerPort
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=containerPort
   * +listMapKey=protocol
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerPort ports = 6;
   */
  ports: ContainerPort[] = [];

  /**
   * List of sources to populate environment variables in the container.
   * The keys defined within a source must be a C_IDENTIFIER. All invalid keys
   * will be reported as an event when the container is starting. When a key exists in multiple
   * sources, the value associated with the last source will take precedence.
   * Values defined by an Env with a duplicate key will take precedence.
   * Cannot be updated.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EnvFromSource envFrom = 19;
   */
  envFrom: EnvFromSource[] = [];

  /**
   * List of environment variables to set in the container.
   * Cannot be updated.
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.EnvVar env = 7;
   */
  env: EnvVar[] = [];

  /**
   * Compute Resources required by this container.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceRequirements resources = 8;
   */
  resources?: ResourceRequirements;

  /**
   * Resources resize policy for the container.
   * +featureGate=InPlacePodVerticalScaling
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerResizePolicy resizePolicy = 23;
   */
  resizePolicy: ContainerResizePolicy[] = [];

  /**
   * RestartPolicy defines the restart behavior of individual containers in a pod.
   * This field may only be set for init containers, and the only allowed value is "Always".
   * For non-init containers or when this field is not specified,
   * the restart behavior is defined by the Pod's restart policy and the container type.
   * Setting the RestartPolicy as "Always" for the init container will have the following effect:
   * this init container will be continually restarted on
   * exit until all regular containers have terminated. Once all regular
   * containers have completed, all init containers with restartPolicy "Always"
   * will be shut down. This lifecycle differs from normal init containers and
   * is often referred to as a "sidecar" container. Although this init
   * container still starts in the init container sequence, it does not wait
   * for the container to complete before proceeding to the next init
   * container. Instead, the next init container starts immediately after this
   * init container is started, or after any startupProbe has successfully
   * completed.
   * +featureGate=SidecarContainers
   * +optional
   *
   * @generated from field: optional string restartPolicy = 24;
   */
  restartPolicy?: string;

  /**
   * Pod volumes to mount into the container's filesystem.
   * Cannot be updated.
   * +optional
   * +patchMergeKey=mountPath
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=mountPath
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeMount volumeMounts = 9;
   */
  volumeMounts: VolumeMount[] = [];

  /**
   * volumeDevices is the list of block devices to be used by the container.
   * +patchMergeKey=devicePath
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=devicePath
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeDevice volumeDevices = 21;
   */
  volumeDevices: VolumeDevice[] = [];

  /**
   * Periodic probe of container liveness.
   * Container will be restarted if the probe fails.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe livenessProbe = 10;
   */
  livenessProbe?: Probe;

  /**
   * Periodic probe of container service readiness.
   * Container will be removed from service endpoints if the probe fails.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe readinessProbe = 11;
   */
  readinessProbe?: Probe;

  /**
   * StartupProbe indicates that the Pod has successfully initialized.
   * If specified, no other probes are executed until this completes successfully.
   * If this probe fails, the Pod will be restarted, just as if the livenessProbe failed.
   * This can be used to provide different probe parameters at the beginning of a Pod's lifecycle,
   * when it might take a long time to load data or warm a cache, than during steady-state operation.
   * This cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe startupProbe = 22;
   */
  startupProbe?: Probe;

  /**
   * Actions that the management system should take in response to container lifecycle events.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Lifecycle lifecycle = 12;
   */
  lifecycle?: Lifecycle;

  /**
   * Optional: Path at which the file to which the container's termination message
   * will be written is mounted into the container's filesystem.
   * Message written is intended to be brief final status, such as an assertion failure message.
   * Will be truncated by the node if greater than 4096 bytes. The total message length across
   * all containers will be limited to 12kb.
   * Defaults to /dev/termination-log.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string terminationMessagePath = 13;
   */
  terminationMessagePath?: string;

  /**
   * Indicate how the termination message should be populated. File will use the contents of
   * terminationMessagePath to populate the container status message on both success and failure.
   * FallbackToLogsOnError will use the last chunk of container log output if the termination
   * message file is empty and the container exited with an error.
   * The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
   * Defaults to File.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string terminationMessagePolicy = 20;
   */
  terminationMessagePolicy?: string;

  /**
   * Image pull policy.
   * One of Always, Never, IfNotPresent.
   * Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
   * +optional
   *
   * @generated from field: optional string imagePullPolicy = 14;
   */
  imagePullPolicy?: string;

  /**
   * SecurityContext defines the security options the container should be run with.
   * If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
   * More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecurityContext securityContext = 15;
   */
  securityContext?: SecurityContext;

  /**
   * Whether this container should allocate a buffer for stdin in the container runtime. If this
   * is not set, reads from stdin in the container will always result in EOF.
   * Default is false.
   * +optional
   *
   * @generated from field: optional bool stdin = 16;
   */
  stdin?: boolean;

  /**
   * Whether the container runtime should close the stdin channel after it has been opened by
   * a single attach. When stdin is true the stdin stream will remain open across multiple attach
   * sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the
   * first client attaches to stdin, and then remains open and accepts data until the client disconnects,
   * at which time stdin is closed and remains closed until the container is restarted. If this
   * flag is false, a container processes that reads from stdin will never receive an EOF.
   * Default is false
   * +optional
   *
   * @generated from field: optional bool stdinOnce = 17;
   */
  stdinOnce?: boolean;

  /**
   * Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
   * Default is false.
   * +optional
   *
   * @generated from field: optional bool tty = 18;
   */
  tty?: boolean;

  constructor(data?: PartialMessage<Container>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Container";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "command", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "args", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 5, name: "workingDir", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "ports", kind: "message", T: ContainerPort, repeated: true },
    { no: 19, name: "envFrom", kind: "message", T: EnvFromSource, repeated: true },
    { no: 7, name: "env", kind: "message", T: EnvVar, repeated: true },
    { no: 8, name: "resources", kind: "message", T: ResourceRequirements, opt: true },
    { no: 23, name: "resizePolicy", kind: "message", T: ContainerResizePolicy, repeated: true },
    { no: 24, name: "restartPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "volumeMounts", kind: "message", T: VolumeMount, repeated: true },
    { no: 21, name: "volumeDevices", kind: "message", T: VolumeDevice, repeated: true },
    { no: 10, name: "livenessProbe", kind: "message", T: Probe, opt: true },
    { no: 11, name: "readinessProbe", kind: "message", T: Probe, opt: true },
    { no: 22, name: "startupProbe", kind: "message", T: Probe, opt: true },
    { no: 12, name: "lifecycle", kind: "message", T: Lifecycle, opt: true },
    { no: 13, name: "terminationMessagePath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 20, name: "terminationMessagePolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 14, name: "imagePullPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 15, name: "securityContext", kind: "message", T: SecurityContext, opt: true },
    { no: 16, name: "stdin", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 17, name: "stdinOnce", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 18, name: "tty", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Container {
    return new Container().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Container {
    return new Container().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Container {
    return new Container().fromJsonString(jsonString, options);
  }

  static equals(a: Container | PlainMessage<Container> | undefined, b: Container | PlainMessage<Container> | undefined): boolean {
    return proto2.util.equals(Container, a, b);
  }
}

/**
 * Describe a container image
 *
 * @generated from message k8s.io.api.core.v1.ContainerImage
 */
export class ContainerImage extends Message<ContainerImage> {
  /**
   * Names by which this image is known.
   * e.g. ["kubernetes.example/hyperkube:v1.0.7", "cloud-vendor.registry.example/cloud-vendor/hyperkube:v1.0.7"]
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string names = 1;
   */
  names: string[] = [];

  /**
   * The size of the image in bytes.
   * +optional
   *
   * @generated from field: optional int64 sizeBytes = 2;
   */
  sizeBytes?: bigint;

  constructor(data?: PartialMessage<ContainerImage>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerImage";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "names", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "sizeBytes", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerImage {
    return new ContainerImage().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerImage {
    return new ContainerImage().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerImage {
    return new ContainerImage().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerImage | PlainMessage<ContainerImage> | undefined, b: ContainerImage | PlainMessage<ContainerImage> | undefined): boolean {
    return proto2.util.equals(ContainerImage, a, b);
  }
}

/**
 * ContainerPort represents a network port in a single container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerPort
 */
export class ContainerPort extends Message<ContainerPort> {
  /**
   * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
   * named port in a pod must have a unique name. Name for the port that can be
   * referred to by services.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Number of port to expose on the host.
   * If specified, this must be a valid port number, 0 < x < 65536.
   * If HostNetwork is specified, this must match ContainerPort.
   * Most containers do not need this.
   * +optional
   *
   * @generated from field: optional int32 hostPort = 2;
   */
  hostPort?: number;

  /**
   * Number of port to expose on the pod's IP address.
   * This must be a valid port number, 0 < x < 65536.
   *
   * @generated from field: optional int32 containerPort = 3;
   */
  containerPort?: number;

  /**
   * Protocol for port. Must be UDP, TCP, or SCTP.
   * Defaults to "TCP".
   * +optional
   * +default="TCP"
   *
   * @generated from field: optional string protocol = 4;
   */
  protocol?: string;

  /**
   * What host IP to bind the external port to.
   * +optional
   *
   * @generated from field: optional string hostIP = 5;
   */
  hostIP?: string;

  constructor(data?: PartialMessage<ContainerPort>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerPort";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "hostPort", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "containerPort", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "protocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "hostIP", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerPort {
    return new ContainerPort().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerPort {
    return new ContainerPort().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerPort {
    return new ContainerPort().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerPort | PlainMessage<ContainerPort> | undefined, b: ContainerPort | PlainMessage<ContainerPort> | undefined): boolean {
    return proto2.util.equals(ContainerPort, a, b);
  }
}

/**
 * ContainerResizePolicy represents resource resize policy for the container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerResizePolicy
 */
export class ContainerResizePolicy extends Message<ContainerResizePolicy> {
  /**
   * Name of the resource to which this resource resize policy applies.
   * Supported values: cpu, memory.
   *
   * @generated from field: optional string resourceName = 1;
   */
  resourceName?: string;

  /**
   * Restart policy to apply when specified resource is resized.
   * If not specified, it defaults to NotRequired.
   *
   * @generated from field: optional string restartPolicy = 2;
   */
  restartPolicy?: string;

  constructor(data?: PartialMessage<ContainerResizePolicy>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerResizePolicy";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "resourceName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "restartPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerResizePolicy {
    return new ContainerResizePolicy().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerResizePolicy {
    return new ContainerResizePolicy().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerResizePolicy {
    return new ContainerResizePolicy().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerResizePolicy | PlainMessage<ContainerResizePolicy> | undefined, b: ContainerResizePolicy | PlainMessage<ContainerResizePolicy> | undefined): boolean {
    return proto2.util.equals(ContainerResizePolicy, a, b);
  }
}

/**
 * ContainerState holds a possible state of container.
 * Only one of its members may be specified.
 * If none of them is specified, the default one is ContainerStateWaiting.
 *
 * @generated from message k8s.io.api.core.v1.ContainerState
 */
export class ContainerState extends Message<ContainerState> {
  /**
   * Details about a waiting container
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerStateWaiting waiting = 1;
   */
  waiting?: ContainerStateWaiting;

  /**
   * Details about a running container
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerStateRunning running = 2;
   */
  running?: ContainerStateRunning;

  /**
   * Details about a terminated container
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerStateTerminated terminated = 3;
   */
  terminated?: ContainerStateTerminated;

  constructor(data?: PartialMessage<ContainerState>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerState";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "waiting", kind: "message", T: ContainerStateWaiting, opt: true },
    { no: 2, name: "running", kind: "message", T: ContainerStateRunning, opt: true },
    { no: 3, name: "terminated", kind: "message", T: ContainerStateTerminated, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerState {
    return new ContainerState().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerState {
    return new ContainerState().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerState {
    return new ContainerState().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerState | PlainMessage<ContainerState> | undefined, b: ContainerState | PlainMessage<ContainerState> | undefined): boolean {
    return proto2.util.equals(ContainerState, a, b);
  }
}

/**
 * ContainerStateRunning is a running state of a container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerStateRunning
 */
export class ContainerStateRunning extends Message<ContainerStateRunning> {
  /**
   * Time at which the container was last (re-)started
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time startedAt = 1;
   */
  startedAt?: Time;

  constructor(data?: PartialMessage<ContainerStateRunning>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerStateRunning";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "startedAt", kind: "message", T: Time, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerStateRunning {
    return new ContainerStateRunning().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerStateRunning {
    return new ContainerStateRunning().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerStateRunning {
    return new ContainerStateRunning().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerStateRunning | PlainMessage<ContainerStateRunning> | undefined, b: ContainerStateRunning | PlainMessage<ContainerStateRunning> | undefined): boolean {
    return proto2.util.equals(ContainerStateRunning, a, b);
  }
}

/**
 * ContainerStateTerminated is a terminated state of a container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerStateTerminated
 */
export class ContainerStateTerminated extends Message<ContainerStateTerminated> {
  /**
   * Exit status from the last termination of the container
   *
   * @generated from field: optional int32 exitCode = 1;
   */
  exitCode?: number;

  /**
   * Signal from the last termination of the container
   * +optional
   *
   * @generated from field: optional int32 signal = 2;
   */
  signal?: number;

  /**
   * (brief) reason from the last termination of the container
   * +optional
   *
   * @generated from field: optional string reason = 3;
   */
  reason?: string;

  /**
   * Message regarding the last termination of the container
   * +optional
   *
   * @generated from field: optional string message = 4;
   */
  message?: string;

  /**
   * Time at which previous execution of the container started
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time startedAt = 5;
   */
  startedAt?: Time;

  /**
   * Time at which the container last terminated
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time finishedAt = 6;
   */
  finishedAt?: Time;

  /**
   * Container's ID in the format '<type>://<container_id>'
   * +optional
   *
   * @generated from field: optional string containerID = 7;
   */
  containerID?: string;

  constructor(data?: PartialMessage<ContainerStateTerminated>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerStateTerminated";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "exitCode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "signal", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "startedAt", kind: "message", T: Time, opt: true },
    { no: 6, name: "finishedAt", kind: "message", T: Time, opt: true },
    { no: 7, name: "containerID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerStateTerminated {
    return new ContainerStateTerminated().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerStateTerminated {
    return new ContainerStateTerminated().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerStateTerminated {
    return new ContainerStateTerminated().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerStateTerminated | PlainMessage<ContainerStateTerminated> | undefined, b: ContainerStateTerminated | PlainMessage<ContainerStateTerminated> | undefined): boolean {
    return proto2.util.equals(ContainerStateTerminated, a, b);
  }
}

/**
 * ContainerStateWaiting is a waiting state of a container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerStateWaiting
 */
export class ContainerStateWaiting extends Message<ContainerStateWaiting> {
  /**
   * (brief) reason the container is not yet running.
   * +optional
   *
   * @generated from field: optional string reason = 1;
   */
  reason?: string;

  /**
   * Message regarding why the container is not yet running.
   * +optional
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  constructor(data?: PartialMessage<ContainerStateWaiting>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerStateWaiting";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerStateWaiting {
    return new ContainerStateWaiting().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerStateWaiting {
    return new ContainerStateWaiting().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerStateWaiting {
    return new ContainerStateWaiting().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerStateWaiting | PlainMessage<ContainerStateWaiting> | undefined, b: ContainerStateWaiting | PlainMessage<ContainerStateWaiting> | undefined): boolean {
    return proto2.util.equals(ContainerStateWaiting, a, b);
  }
}

/**
 * ContainerStatus contains details for the current status of this container.
 *
 * @generated from message k8s.io.api.core.v1.ContainerStatus
 */
export class ContainerStatus extends Message<ContainerStatus> {
  /**
   * Name is a DNS_LABEL representing the unique name of the container.
   * Each container in a pod must have a unique name across all container types.
   * Cannot be updated.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * State holds details about the container's current condition.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerState state = 2;
   */
  state?: ContainerState;

  /**
   * LastTerminationState holds the last termination state of the container to
   * help debug container crashes and restarts. This field is not
   * populated if the container is still running and RestartCount is 0.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerState lastState = 3;
   */
  lastState?: ContainerState;

  /**
   * Ready specifies whether the container is currently passing its readiness check.
   * The value will change as readiness probes keep executing. If no readiness
   * probes are specified, this field defaults to true once the container is
   * fully started (see Started field).
   *
   * The value is typically used to determine whether a container is ready to
   * accept traffic.
   *
   * @generated from field: optional bool ready = 4;
   */
  ready?: boolean;

  /**
   * RestartCount holds the number of times the container has been restarted.
   * Kubelet makes an effort to always increment the value, but there
   * are cases when the state may be lost due to node restarts and then the value
   * may be reset to 0. The value is never negative.
   *
   * @generated from field: optional int32 restartCount = 5;
   */
  restartCount?: number;

  /**
   * Image is the name of container image that the container is running.
   * The container image may not match the image used in the PodSpec,
   * as it may have been resolved by the runtime.
   * More info: https://kubernetes.io/docs/concepts/containers/images.
   *
   * @generated from field: optional string image = 6;
   */
  image?: string;

  /**
   * ImageID is the image ID of the container's image. The image ID may not
   * match the image ID of the image used in the PodSpec, as it may have been
   * resolved by the runtime.
   *
   * @generated from field: optional string imageID = 7;
   */
  imageID?: string;

  /**
   * ContainerID is the ID of the container in the format '<type>://<container_id>'.
   * Where type is a container runtime identifier, returned from Version call of CRI API
   * (for example "containerd").
   * +optional
   *
   * @generated from field: optional string containerID = 8;
   */
  containerID?: string;

  /**
   * Started indicates whether the container has finished its postStart lifecycle hook
   * and passed its startup probe.
   * Initialized as false, becomes true after startupProbe is considered
   * successful. Resets to false when the container is restarted, or if kubelet
   * loses state temporarily. In both cases, startup probes will run again.
   * Is always true when no startupProbe is defined and container is running and
   * has passed the postStart lifecycle hook. The null value must be treated the
   * same as false.
   * +optional
   *
   * @generated from field: optional bool started = 9;
   */
  started?: boolean;

  /**
   * AllocatedResources represents the compute resources allocated for this container by the
   * node. Kubelet sets this value to Container.Resources.Requests upon successful pod admission
   * and after successfully admitting desired pod resize.
   * +featureGate=InPlacePodVerticalScaling
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> allocatedResources = 10;
   */
  allocatedResources: { [key: string]: Quantity } = {};

  /**
   * Resources represents the compute resource requests and limits that have been successfully
   * enacted on the running container after it has been started or has been successfully resized.
   * +featureGate=InPlacePodVerticalScaling
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceRequirements resources = 11;
   */
  resources?: ResourceRequirements;

  /**
   * Status of volume mounts.
   * +optional
   * +patchMergeKey=mountPath
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=mountPath
   * +featureGate=RecursiveReadOnlyMounts
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeMountStatus volumeMounts = 12;
   */
  volumeMounts: VolumeMountStatus[] = [];

  /**
   * User represents user identity information initially attached to the first process of the container
   * +featureGate=SupplementalGroupsPolicy
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ContainerUser user = 13;
   */
  user?: ContainerUser;

  /**
   * AllocatedResourcesStatus represents the status of various resources
   * allocated for this Pod.
   * +featureGate=ResourceHealthStatus
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.ResourceStatus allocatedResourcesStatus = 14;
   */
  allocatedResourcesStatus: ResourceStatus[] = [];

  constructor(data?: PartialMessage<ContainerStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "state", kind: "message", T: ContainerState, opt: true },
    { no: 3, name: "lastState", kind: "message", T: ContainerState, opt: true },
    { no: 4, name: "ready", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "restartCount", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 6, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "imageID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "containerID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "started", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 10, name: "allocatedResources", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 11, name: "resources", kind: "message", T: ResourceRequirements, opt: true },
    { no: 12, name: "volumeMounts", kind: "message", T: VolumeMountStatus, repeated: true },
    { no: 13, name: "user", kind: "message", T: ContainerUser, opt: true },
    { no: 14, name: "allocatedResourcesStatus", kind: "message", T: ResourceStatus, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerStatus {
    return new ContainerStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerStatus {
    return new ContainerStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerStatus {
    return new ContainerStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerStatus | PlainMessage<ContainerStatus> | undefined, b: ContainerStatus | PlainMessage<ContainerStatus> | undefined): boolean {
    return proto2.util.equals(ContainerStatus, a, b);
  }
}

/**
 * ContainerUser represents user identity information
 *
 * @generated from message k8s.io.api.core.v1.ContainerUser
 */
export class ContainerUser extends Message<ContainerUser> {
  /**
   * Linux holds user identity information initially attached to the first process of the containers in Linux.
   * Note that the actual running identity can be changed if the process has enough privilege to do so.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LinuxContainerUser linux = 1;
   */
  linux?: LinuxContainerUser;

  constructor(data?: PartialMessage<ContainerUser>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ContainerUser";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "linux", kind: "message", T: LinuxContainerUser, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ContainerUser {
    return new ContainerUser().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ContainerUser {
    return new ContainerUser().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ContainerUser {
    return new ContainerUser().fromJsonString(jsonString, options);
  }

  static equals(a: ContainerUser | PlainMessage<ContainerUser> | undefined, b: ContainerUser | PlainMessage<ContainerUser> | undefined): boolean {
    return proto2.util.equals(ContainerUser, a, b);
  }
}

/**
 * DaemonEndpoint contains information about a single Daemon endpoint.
 *
 * @generated from message k8s.io.api.core.v1.DaemonEndpoint
 */
export class DaemonEndpoint extends Message<DaemonEndpoint> {
  /**
   * Port number of the given endpoint.
   *
   * @generated from field: optional int32 Port = 1;
   */
  Port?: number;

  constructor(data?: PartialMessage<DaemonEndpoint>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.DaemonEndpoint";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "Port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DaemonEndpoint {
    return new DaemonEndpoint().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DaemonEndpoint {
    return new DaemonEndpoint().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DaemonEndpoint {
    return new DaemonEndpoint().fromJsonString(jsonString, options);
  }

  static equals(a: DaemonEndpoint | PlainMessage<DaemonEndpoint> | undefined, b: DaemonEndpoint | PlainMessage<DaemonEndpoint> | undefined): boolean {
    return proto2.util.equals(DaemonEndpoint, a, b);
  }
}

/**
 * Represents downward API info for projecting into a projected volume.
 * Note that this is identical to a downwardAPI volume source without the default
 * mode.
 *
 * @generated from message k8s.io.api.core.v1.DownwardAPIProjection
 */
export class DownwardAPIProjection extends Message<DownwardAPIProjection> {
  /**
   * Items is a list of DownwardAPIVolume file
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.DownwardAPIVolumeFile items = 1;
   */
  items: DownwardAPIVolumeFile[] = [];

  constructor(data?: PartialMessage<DownwardAPIProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.DownwardAPIProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "items", kind: "message", T: DownwardAPIVolumeFile, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DownwardAPIProjection {
    return new DownwardAPIProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DownwardAPIProjection {
    return new DownwardAPIProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DownwardAPIProjection {
    return new DownwardAPIProjection().fromJsonString(jsonString, options);
  }

  static equals(a: DownwardAPIProjection | PlainMessage<DownwardAPIProjection> | undefined, b: DownwardAPIProjection | PlainMessage<DownwardAPIProjection> | undefined): boolean {
    return proto2.util.equals(DownwardAPIProjection, a, b);
  }
}

/**
 * DownwardAPIVolumeFile represents information to create the file containing the pod field
 *
 * @generated from message k8s.io.api.core.v1.DownwardAPIVolumeFile
 */
export class DownwardAPIVolumeFile extends Message<DownwardAPIVolumeFile> {
  /**
   * Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  /**
   * Required: Selects a field of the pod: only annotations, labels, name, namespace and uid are supported.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectFieldSelector fieldRef = 2;
   */
  fieldRef?: ObjectFieldSelector;

  /**
   * Selects a resource of the container: only resources limits and requests
   * (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceFieldSelector resourceFieldRef = 3;
   */
  resourceFieldRef?: ResourceFieldSelector;

  /**
   * Optional: mode bits used to set permissions on this file, must be an octal value
   * between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
   * If not specified, the volume defaultMode will be used.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 mode = 4;
   */
  mode?: number;

  constructor(data?: PartialMessage<DownwardAPIVolumeFile>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.DownwardAPIVolumeFile";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fieldRef", kind: "message", T: ObjectFieldSelector, opt: true },
    { no: 3, name: "resourceFieldRef", kind: "message", T: ResourceFieldSelector, opt: true },
    { no: 4, name: "mode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DownwardAPIVolumeFile {
    return new DownwardAPIVolumeFile().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DownwardAPIVolumeFile {
    return new DownwardAPIVolumeFile().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DownwardAPIVolumeFile {
    return new DownwardAPIVolumeFile().fromJsonString(jsonString, options);
  }

  static equals(a: DownwardAPIVolumeFile | PlainMessage<DownwardAPIVolumeFile> | undefined, b: DownwardAPIVolumeFile | PlainMessage<DownwardAPIVolumeFile> | undefined): boolean {
    return proto2.util.equals(DownwardAPIVolumeFile, a, b);
  }
}

/**
 * DownwardAPIVolumeSource represents a volume containing downward API info.
 * Downward API volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.DownwardAPIVolumeSource
 */
export class DownwardAPIVolumeSource extends Message<DownwardAPIVolumeSource> {
  /**
   * Items is a list of downward API volume file
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.DownwardAPIVolumeFile items = 1;
   */
  items: DownwardAPIVolumeFile[] = [];

  /**
   * Optional: mode bits to use on created files by default. Must be a
   * Optional: mode bits used to set permissions on created files by default.
   * Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
   * Defaults to 0644.
   * Directories within the path are not affected by this setting.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 defaultMode = 2;
   */
  defaultMode?: number;

  constructor(data?: PartialMessage<DownwardAPIVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.DownwardAPIVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "items", kind: "message", T: DownwardAPIVolumeFile, repeated: true },
    { no: 2, name: "defaultMode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DownwardAPIVolumeSource {
    return new DownwardAPIVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DownwardAPIVolumeSource {
    return new DownwardAPIVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DownwardAPIVolumeSource {
    return new DownwardAPIVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: DownwardAPIVolumeSource | PlainMessage<DownwardAPIVolumeSource> | undefined, b: DownwardAPIVolumeSource | PlainMessage<DownwardAPIVolumeSource> | undefined): boolean {
    return proto2.util.equals(DownwardAPIVolumeSource, a, b);
  }
}

/**
 * Represents an empty directory for a pod.
 * Empty directory volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.EmptyDirVolumeSource
 */
export class EmptyDirVolumeSource extends Message<EmptyDirVolumeSource> {
  /**
   * medium represents what type of storage medium should back this directory.
   * The default is "" which means to use the node's default medium.
   * Must be an empty string (default) or Memory.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
   * +optional
   *
   * @generated from field: optional string medium = 1;
   */
  medium?: string;

  /**
   * sizeLimit is the total amount of local storage required for this EmptyDir volume.
   * The size limit is also applicable for memory medium.
   * The maximum usage on memory medium EmptyDir would be the minimum value between
   * the SizeLimit specified here and the sum of memory limits of all containers in a pod.
   * The default is nil which means that the limit is undefined.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.api.resource.Quantity sizeLimit = 2;
   */
  sizeLimit?: Quantity;

  constructor(data?: PartialMessage<EmptyDirVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EmptyDirVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "medium", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "sizeLimit", kind: "message", T: Quantity, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EmptyDirVolumeSource {
    return new EmptyDirVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EmptyDirVolumeSource {
    return new EmptyDirVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EmptyDirVolumeSource {
    return new EmptyDirVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: EmptyDirVolumeSource | PlainMessage<EmptyDirVolumeSource> | undefined, b: EmptyDirVolumeSource | PlainMessage<EmptyDirVolumeSource> | undefined): boolean {
    return proto2.util.equals(EmptyDirVolumeSource, a, b);
  }
}

/**
 * EndpointAddress is a tuple that describes single IP address.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.EndpointAddress
 */
export class EndpointAddress extends Message<EndpointAddress> {
  /**
   * The IP of this endpoint.
   * May not be loopback (127.0.0.0/8 or ::1), link-local (169.254.0.0/16 or fe80::/10),
   * or link-local multicast (224.0.0.0/24 or ff02::/16).
   *
   * @generated from field: optional string ip = 1;
   */
  ip?: string;

  /**
   * The Hostname of this endpoint
   * +optional
   *
   * @generated from field: optional string hostname = 3;
   */
  hostname?: string;

  /**
   * Optional: Node hosting this endpoint. This can be used to determine endpoints local to a node.
   * +optional
   *
   * @generated from field: optional string nodeName = 4;
   */
  nodeName?: string;

  /**
   * Reference to object providing the endpoint.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference targetRef = 2;
   */
  targetRef?: ObjectReference;

  constructor(data?: PartialMessage<EndpointAddress>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EndpointAddress";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ip", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "hostname", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "nodeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "targetRef", kind: "message", T: ObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EndpointAddress {
    return new EndpointAddress().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EndpointAddress {
    return new EndpointAddress().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EndpointAddress {
    return new EndpointAddress().fromJsonString(jsonString, options);
  }

  static equals(a: EndpointAddress | PlainMessage<EndpointAddress> | undefined, b: EndpointAddress | PlainMessage<EndpointAddress> | undefined): boolean {
    return proto2.util.equals(EndpointAddress, a, b);
  }
}

/**
 * EndpointPort is a tuple that describes a single port.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.EndpointPort
 */
export class EndpointPort extends Message<EndpointPort> {
  /**
   * The name of this port.  This must match the 'name' field in the
   * corresponding ServicePort.
   * Must be a DNS_LABEL.
   * Optional only if one port is defined.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * The port number of the endpoint.
   *
   * @generated from field: optional int32 port = 2;
   */
  port?: number;

  /**
   * The IP protocol for this port.
   * Must be UDP, TCP, or SCTP.
   * Default is TCP.
   * +optional
   *
   * @generated from field: optional string protocol = 3;
   */
  protocol?: string;

  /**
   * The application protocol for this port.
   * This is used as a hint for implementations to offer richer behavior for protocols that they understand.
   * This field follows standard Kubernetes label syntax.
   * Valid values are either:
   *
   * * Un-prefixed protocol names - reserved for IANA standard service names (as per
   * RFC-6335 and https://www.iana.org/assignments/service-names).
   *
   * * Kubernetes-defined prefixed names:
   *   * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
   *   * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
   *   * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455
   *
   * * Other protocols should use implementation-defined prefixed names such as
   * mycompany.com/my-custom-protocol.
   * +optional
   *
   * @generated from field: optional string appProtocol = 4;
   */
  appProtocol?: string;

  constructor(data?: PartialMessage<EndpointPort>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EndpointPort";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "protocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "appProtocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EndpointPort {
    return new EndpointPort().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EndpointPort {
    return new EndpointPort().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EndpointPort {
    return new EndpointPort().fromJsonString(jsonString, options);
  }

  static equals(a: EndpointPort | PlainMessage<EndpointPort> | undefined, b: EndpointPort | PlainMessage<EndpointPort> | undefined): boolean {
    return proto2.util.equals(EndpointPort, a, b);
  }
}

/**
 * EndpointSubset is a group of addresses with a common set of ports. The
 * expanded set of endpoints is the Cartesian product of Addresses x Ports.
 * For example, given:
 *
 * 	{
 * 	  Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
 * 	  Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
 * 	}
 *
 * The resulting set of endpoints can be viewed as:
 *
 * 	a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
 * 	b: [ 10.10.1.1:309, 10.10.2.2:309 ]
 *
 * @generated from message k8s.io.api.core.v1.EndpointSubset
 */
export class EndpointSubset extends Message<EndpointSubset> {
  /**
   * IP addresses which offer the related ports that are marked as ready. These endpoints
   * should be considered safe for load balancers and clients to utilize.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EndpointAddress addresses = 1;
   */
  addresses: EndpointAddress[] = [];

  /**
   * IP addresses which offer the related ports but are not currently marked as ready
   * because they have not yet finished starting, have recently failed a readiness check,
   * or have recently failed a liveness check.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EndpointAddress notReadyAddresses = 2;
   */
  notReadyAddresses: EndpointAddress[] = [];

  /**
   * Port numbers available on the related IP addresses.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EndpointPort ports = 3;
   */
  ports: EndpointPort[] = [];

  constructor(data?: PartialMessage<EndpointSubset>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EndpointSubset";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "addresses", kind: "message", T: EndpointAddress, repeated: true },
    { no: 2, name: "notReadyAddresses", kind: "message", T: EndpointAddress, repeated: true },
    { no: 3, name: "ports", kind: "message", T: EndpointPort, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EndpointSubset {
    return new EndpointSubset().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EndpointSubset {
    return new EndpointSubset().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EndpointSubset {
    return new EndpointSubset().fromJsonString(jsonString, options);
  }

  static equals(a: EndpointSubset | PlainMessage<EndpointSubset> | undefined, b: EndpointSubset | PlainMessage<EndpointSubset> | undefined): boolean {
    return proto2.util.equals(EndpointSubset, a, b);
  }
}

/**
 * Endpoints is a collection of endpoints that implement the actual service. Example:
 *
 * 	 Name: "mysvc",
 * 	 Subsets: [
 * 	   {
 * 	     Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
 * 	     Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
 * 	   },
 * 	   {
 * 	     Addresses: [{"ip": "10.10.3.3"}],
 * 	     Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
 * 	   },
 * 	]
 *
 * @generated from message k8s.io.api.core.v1.Endpoints
 */
export class Endpoints extends Message<Endpoints> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * The set of all endpoints is the union of all subsets. Addresses are placed into
   * subsets according to the IPs they share. A single address with multiple ports,
   * some of which are ready and some of which are not (because they come from
   * different containers) will result in the address being displayed in different
   * subsets for the different ports. No address will appear in both Addresses and
   * NotReadyAddresses in the same subset.
   * Sets of addresses and ports that comprise a service.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EndpointSubset subsets = 2;
   */
  subsets: EndpointSubset[] = [];

  constructor(data?: PartialMessage<Endpoints>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Endpoints";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "subsets", kind: "message", T: EndpointSubset, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Endpoints {
    return new Endpoints().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Endpoints {
    return new Endpoints().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Endpoints {
    return new Endpoints().fromJsonString(jsonString, options);
  }

  static equals(a: Endpoints | PlainMessage<Endpoints> | undefined, b: Endpoints | PlainMessage<Endpoints> | undefined): boolean {
    return proto2.util.equals(Endpoints, a, b);
  }
}

/**
 * EndpointsList is a list of endpoints.
 *
 * @generated from message k8s.io.api.core.v1.EndpointsList
 */
export class EndpointsList extends Message<EndpointsList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of endpoints.
   *
   * @generated from field: repeated k8s.io.api.core.v1.Endpoints items = 2;
   */
  items: Endpoints[] = [];

  constructor(data?: PartialMessage<EndpointsList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EndpointsList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Endpoints, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EndpointsList {
    return new EndpointsList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EndpointsList {
    return new EndpointsList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EndpointsList {
    return new EndpointsList().fromJsonString(jsonString, options);
  }

  static equals(a: EndpointsList | PlainMessage<EndpointsList> | undefined, b: EndpointsList | PlainMessage<EndpointsList> | undefined): boolean {
    return proto2.util.equals(EndpointsList, a, b);
  }
}

/**
 * EnvFromSource represents the source of a set of ConfigMaps
 *
 * @generated from message k8s.io.api.core.v1.EnvFromSource
 */
export class EnvFromSource extends Message<EnvFromSource> {
  /**
   * An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
   * +optional
   *
   * @generated from field: optional string prefix = 1;
   */
  prefix?: string;

  /**
   * The ConfigMap to select from
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ConfigMapEnvSource configMapRef = 2;
   */
  configMapRef?: ConfigMapEnvSource;

  /**
   * The Secret to select from
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretEnvSource secretRef = 3;
   */
  secretRef?: SecretEnvSource;

  constructor(data?: PartialMessage<EnvFromSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EnvFromSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "prefix", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "configMapRef", kind: "message", T: ConfigMapEnvSource, opt: true },
    { no: 3, name: "secretRef", kind: "message", T: SecretEnvSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EnvFromSource {
    return new EnvFromSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EnvFromSource {
    return new EnvFromSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EnvFromSource {
    return new EnvFromSource().fromJsonString(jsonString, options);
  }

  static equals(a: EnvFromSource | PlainMessage<EnvFromSource> | undefined, b: EnvFromSource | PlainMessage<EnvFromSource> | undefined): boolean {
    return proto2.util.equals(EnvFromSource, a, b);
  }
}

/**
 * EnvVar represents an environment variable present in a Container.
 *
 * @generated from message k8s.io.api.core.v1.EnvVar
 */
export class EnvVar extends Message<EnvVar> {
  /**
   * Name of the environment variable. Must be a C_IDENTIFIER.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Variable references $(VAR_NAME) are expanded
   * using the previously defined environment variables in the container and
   * any service environment variables. If a variable cannot be resolved,
   * the reference in the input string will be unchanged. Double $$ are reduced
   * to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e.
   * "$$(VAR_NAME)" will produce the string literal "$(VAR_NAME)".
   * Escaped references will never be expanded, regardless of whether the variable
   * exists or not.
   * Defaults to "".
   * +optional
   *
   * @generated from field: optional string value = 2;
   */
  value?: string;

  /**
   * Source for the environment variable's value. Cannot be used if value is not empty.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.EnvVarSource valueFrom = 3;
   */
  valueFrom?: EnvVarSource;

  constructor(data?: PartialMessage<EnvVar>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EnvVar";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "valueFrom", kind: "message", T: EnvVarSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EnvVar {
    return new EnvVar().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EnvVar {
    return new EnvVar().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EnvVar {
    return new EnvVar().fromJsonString(jsonString, options);
  }

  static equals(a: EnvVar | PlainMessage<EnvVar> | undefined, b: EnvVar | PlainMessage<EnvVar> | undefined): boolean {
    return proto2.util.equals(EnvVar, a, b);
  }
}

/**
 * EnvVarSource represents a source for the value of an EnvVar.
 *
 * @generated from message k8s.io.api.core.v1.EnvVarSource
 */
export class EnvVarSource extends Message<EnvVarSource> {
  /**
   * Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`,
   * spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectFieldSelector fieldRef = 1;
   */
  fieldRef?: ObjectFieldSelector;

  /**
   * Selects a resource of the container: only resources limits and requests
   * (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceFieldSelector resourceFieldRef = 2;
   */
  resourceFieldRef?: ResourceFieldSelector;

  /**
   * Selects a key of a ConfigMap.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ConfigMapKeySelector configMapKeyRef = 3;
   */
  configMapKeyRef?: ConfigMapKeySelector;

  /**
   * Selects a key of a secret in the pod's namespace
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretKeySelector secretKeyRef = 4;
   */
  secretKeyRef?: SecretKeySelector;

  constructor(data?: PartialMessage<EnvVarSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EnvVarSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "fieldRef", kind: "message", T: ObjectFieldSelector, opt: true },
    { no: 2, name: "resourceFieldRef", kind: "message", T: ResourceFieldSelector, opt: true },
    { no: 3, name: "configMapKeyRef", kind: "message", T: ConfigMapKeySelector, opt: true },
    { no: 4, name: "secretKeyRef", kind: "message", T: SecretKeySelector, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EnvVarSource {
    return new EnvVarSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EnvVarSource {
    return new EnvVarSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EnvVarSource {
    return new EnvVarSource().fromJsonString(jsonString, options);
  }

  static equals(a: EnvVarSource | PlainMessage<EnvVarSource> | undefined, b: EnvVarSource | PlainMessage<EnvVarSource> | undefined): boolean {
    return proto2.util.equals(EnvVarSource, a, b);
  }
}

/**
 * An EphemeralContainer is a temporary container that you may add to an existing Pod for
 * user-initiated activities such as debugging. Ephemeral containers have no resource or
 * scheduling guarantees, and they will not be restarted when they exit or when a Pod is
 * removed or restarted. The kubelet may evict a Pod if an ephemeral container causes the
 * Pod to exceed its resource allocation.
 *
 * To add an ephemeral container, use the ephemeralcontainers subresource of an existing
 * Pod. Ephemeral containers may not be removed or restarted.
 *
 * @generated from message k8s.io.api.core.v1.EphemeralContainer
 */
export class EphemeralContainer extends Message<EphemeralContainer> {
  /**
   * Ephemeral containers have all of the fields of Container, plus additional fields
   * specific to ephemeral containers. Fields in common with Container are in the
   * following inlined struct so than an EphemeralContainer may easily be converted
   * to a Container.
   *
   * @generated from field: optional k8s.io.api.core.v1.EphemeralContainerCommon ephemeralContainerCommon = 1;
   */
  ephemeralContainerCommon?: EphemeralContainerCommon;

  /**
   * If set, the name of the container from PodSpec that this ephemeral container targets.
   * The ephemeral container will be run in the namespaces (IPC, PID, etc) of this container.
   * If not set then the ephemeral container uses the namespaces configured in the Pod spec.
   *
   * The container runtime must implement support for this feature. If the runtime does not
   * support namespace targeting then the result of setting this field is undefined.
   * +optional
   *
   * @generated from field: optional string targetContainerName = 2;
   */
  targetContainerName?: string;

  constructor(data?: PartialMessage<EphemeralContainer>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EphemeralContainer";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ephemeralContainerCommon", kind: "message", T: EphemeralContainerCommon, opt: true },
    { no: 2, name: "targetContainerName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EphemeralContainer {
    return new EphemeralContainer().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EphemeralContainer {
    return new EphemeralContainer().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EphemeralContainer {
    return new EphemeralContainer().fromJsonString(jsonString, options);
  }

  static equals(a: EphemeralContainer | PlainMessage<EphemeralContainer> | undefined, b: EphemeralContainer | PlainMessage<EphemeralContainer> | undefined): boolean {
    return proto2.util.equals(EphemeralContainer, a, b);
  }
}

/**
 * EphemeralContainerCommon is a copy of all fields in Container to be inlined in
 * EphemeralContainer. This separate type allows easy conversion from EphemeralContainer
 * to Container and allows separate documentation for the fields of EphemeralContainer.
 * When a new field is added to Container it must be added here as well.
 *
 * @generated from message k8s.io.api.core.v1.EphemeralContainerCommon
 */
export class EphemeralContainerCommon extends Message<EphemeralContainerCommon> {
  /**
   * Name of the ephemeral container specified as a DNS_LABEL.
   * This name must be unique among all containers, init containers and ephemeral containers.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Container image name.
   * More info: https://kubernetes.io/docs/concepts/containers/images
   *
   * @generated from field: optional string image = 2;
   */
  image?: string;

  /**
   * Entrypoint array. Not executed within a shell.
   * The image's ENTRYPOINT is used if this is not provided.
   * Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
   * cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced
   * to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will
   * produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless
   * of whether the variable exists or not. Cannot be updated.
   * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string command = 3;
   */
  command: string[] = [];

  /**
   * Arguments to the entrypoint.
   * The image's CMD is used if this is not provided.
   * Variable references $(VAR_NAME) are expanded using the container's environment. If a variable
   * cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced
   * to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. "$$(VAR_NAME)" will
   * produce the string literal "$(VAR_NAME)". Escaped references will never be expanded, regardless
   * of whether the variable exists or not. Cannot be updated.
   * More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string args = 4;
   */
  args: string[] = [];

  /**
   * Container's working directory.
   * If not specified, the container runtime's default will be used, which
   * might be configured in the container image.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string workingDir = 5;
   */
  workingDir?: string;

  /**
   * Ports are not allowed for ephemeral containers.
   * +optional
   * +patchMergeKey=containerPort
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=containerPort
   * +listMapKey=protocol
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerPort ports = 6;
   */
  ports: ContainerPort[] = [];

  /**
   * List of sources to populate environment variables in the container.
   * The keys defined within a source must be a C_IDENTIFIER. All invalid keys
   * will be reported as an event when the container is starting. When a key exists in multiple
   * sources, the value associated with the last source will take precedence.
   * Values defined by an Env with a duplicate key will take precedence.
   * Cannot be updated.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.EnvFromSource envFrom = 19;
   */
  envFrom: EnvFromSource[] = [];

  /**
   * List of environment variables to set in the container.
   * Cannot be updated.
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.EnvVar env = 7;
   */
  env: EnvVar[] = [];

  /**
   * Resources are not allowed for ephemeral containers. Ephemeral containers use spare resources
   * already allocated to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceRequirements resources = 8;
   */
  resources?: ResourceRequirements;

  /**
   * Resources resize policy for the container.
   * +featureGate=InPlacePodVerticalScaling
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerResizePolicy resizePolicy = 23;
   */
  resizePolicy: ContainerResizePolicy[] = [];

  /**
   * Restart policy for the container to manage the restart behavior of each
   * container within a pod.
   * This may only be set for init containers. You cannot set this field on
   * ephemeral containers.
   * +featureGate=SidecarContainers
   * +optional
   *
   * @generated from field: optional string restartPolicy = 24;
   */
  restartPolicy?: string;

  /**
   * Pod volumes to mount into the container's filesystem. Subpath mounts are not allowed for ephemeral containers.
   * Cannot be updated.
   * +optional
   * +patchMergeKey=mountPath
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=mountPath
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeMount volumeMounts = 9;
   */
  volumeMounts: VolumeMount[] = [];

  /**
   * volumeDevices is the list of block devices to be used by the container.
   * +patchMergeKey=devicePath
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=devicePath
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeDevice volumeDevices = 21;
   */
  volumeDevices: VolumeDevice[] = [];

  /**
   * Probes are not allowed for ephemeral containers.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe livenessProbe = 10;
   */
  livenessProbe?: Probe;

  /**
   * Probes are not allowed for ephemeral containers.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe readinessProbe = 11;
   */
  readinessProbe?: Probe;

  /**
   * Probes are not allowed for ephemeral containers.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Probe startupProbe = 22;
   */
  startupProbe?: Probe;

  /**
   * Lifecycle is not allowed for ephemeral containers.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Lifecycle lifecycle = 12;
   */
  lifecycle?: Lifecycle;

  /**
   * Optional: Path at which the file to which the container's termination message
   * will be written is mounted into the container's filesystem.
   * Message written is intended to be brief final status, such as an assertion failure message.
   * Will be truncated by the node if greater than 4096 bytes. The total message length across
   * all containers will be limited to 12kb.
   * Defaults to /dev/termination-log.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string terminationMessagePath = 13;
   */
  terminationMessagePath?: string;

  /**
   * Indicate how the termination message should be populated. File will use the contents of
   * terminationMessagePath to populate the container status message on both success and failure.
   * FallbackToLogsOnError will use the last chunk of container log output if the termination
   * message file is empty and the container exited with an error.
   * The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
   * Defaults to File.
   * Cannot be updated.
   * +optional
   *
   * @generated from field: optional string terminationMessagePolicy = 20;
   */
  terminationMessagePolicy?: string;

  /**
   * Image pull policy.
   * One of Always, Never, IfNotPresent.
   * Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/containers/images#updating-images
   * +optional
   *
   * @generated from field: optional string imagePullPolicy = 14;
   */
  imagePullPolicy?: string;

  /**
   * Optional: SecurityContext defines the security options the ephemeral container should be run with.
   * If set, the fields of SecurityContext override the equivalent fields of PodSecurityContext.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecurityContext securityContext = 15;
   */
  securityContext?: SecurityContext;

  /**
   * Whether this container should allocate a buffer for stdin in the container runtime. If this
   * is not set, reads from stdin in the container will always result in EOF.
   * Default is false.
   * +optional
   *
   * @generated from field: optional bool stdin = 16;
   */
  stdin?: boolean;

  /**
   * Whether the container runtime should close the stdin channel after it has been opened by
   * a single attach. When stdin is true the stdin stream will remain open across multiple attach
   * sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the
   * first client attaches to stdin, and then remains open and accepts data until the client disconnects,
   * at which time stdin is closed and remains closed until the container is restarted. If this
   * flag is false, a container processes that reads from stdin will never receive an EOF.
   * Default is false
   * +optional
   *
   * @generated from field: optional bool stdinOnce = 17;
   */
  stdinOnce?: boolean;

  /**
   * Whether this container should allocate a TTY for itself, also requires 'stdin' to be true.
   * Default is false.
   * +optional
   *
   * @generated from field: optional bool tty = 18;
   */
  tty?: boolean;

  constructor(data?: PartialMessage<EphemeralContainerCommon>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EphemeralContainerCommon";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "command", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "args", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 5, name: "workingDir", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "ports", kind: "message", T: ContainerPort, repeated: true },
    { no: 19, name: "envFrom", kind: "message", T: EnvFromSource, repeated: true },
    { no: 7, name: "env", kind: "message", T: EnvVar, repeated: true },
    { no: 8, name: "resources", kind: "message", T: ResourceRequirements, opt: true },
    { no: 23, name: "resizePolicy", kind: "message", T: ContainerResizePolicy, repeated: true },
    { no: 24, name: "restartPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "volumeMounts", kind: "message", T: VolumeMount, repeated: true },
    { no: 21, name: "volumeDevices", kind: "message", T: VolumeDevice, repeated: true },
    { no: 10, name: "livenessProbe", kind: "message", T: Probe, opt: true },
    { no: 11, name: "readinessProbe", kind: "message", T: Probe, opt: true },
    { no: 22, name: "startupProbe", kind: "message", T: Probe, opt: true },
    { no: 12, name: "lifecycle", kind: "message", T: Lifecycle, opt: true },
    { no: 13, name: "terminationMessagePath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 20, name: "terminationMessagePolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 14, name: "imagePullPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 15, name: "securityContext", kind: "message", T: SecurityContext, opt: true },
    { no: 16, name: "stdin", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 17, name: "stdinOnce", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 18, name: "tty", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EphemeralContainerCommon {
    return new EphemeralContainerCommon().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EphemeralContainerCommon {
    return new EphemeralContainerCommon().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EphemeralContainerCommon {
    return new EphemeralContainerCommon().fromJsonString(jsonString, options);
  }

  static equals(a: EphemeralContainerCommon | PlainMessage<EphemeralContainerCommon> | undefined, b: EphemeralContainerCommon | PlainMessage<EphemeralContainerCommon> | undefined): boolean {
    return proto2.util.equals(EphemeralContainerCommon, a, b);
  }
}

/**
 * Represents an ephemeral volume that is handled by a normal storage driver.
 *
 * @generated from message k8s.io.api.core.v1.EphemeralVolumeSource
 */
export class EphemeralVolumeSource extends Message<EphemeralVolumeSource> {
  /**
   * Will be used to create a stand-alone PVC to provision the volume.
   * The pod in which this EphemeralVolumeSource is embedded will be the
   * owner of the PVC, i.e. the PVC will be deleted together with the
   * pod.  The name of the PVC will be `<pod name>-<volume name>` where
   * `<volume name>` is the name from the `PodSpec.Volumes` array
   * entry. Pod validation will reject the pod if the concatenated name
   * is not valid for a PVC (for example, too long).
   *
   * An existing PVC with that name that is not owned by the pod
   * will *not* be used for the pod to avoid using an unrelated
   * volume by mistake. Starting the pod is then blocked until
   * the unrelated PVC is removed. If such a pre-created PVC is
   * meant to be used by the pod, the PVC has to updated with an
   * owner reference to the pod once the pod exists. Normally
   * this should not be necessary, but it may be useful when
   * manually reconstructing a broken cluster.
   *
   * This field is read-only and no changes will be made by Kubernetes
   * to the PVC after it has been created.
   *
   * Required, must not be nil.
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeClaimTemplate volumeClaimTemplate = 1;
   */
  volumeClaimTemplate?: PersistentVolumeClaimTemplate;

  constructor(data?: PartialMessage<EphemeralVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EphemeralVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeClaimTemplate", kind: "message", T: PersistentVolumeClaimTemplate, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EphemeralVolumeSource {
    return new EphemeralVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EphemeralVolumeSource {
    return new EphemeralVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EphemeralVolumeSource {
    return new EphemeralVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: EphemeralVolumeSource | PlainMessage<EphemeralVolumeSource> | undefined, b: EphemeralVolumeSource | PlainMessage<EphemeralVolumeSource> | undefined): boolean {
    return proto2.util.equals(EphemeralVolumeSource, a, b);
  }
}

/**
 * Event is a report of an event somewhere in the cluster.  Events
 * have a limited retention time and triggers and messages may evolve
 * with time.  Event consumers should not rely on the timing of an event
 * with a given Reason reflecting a consistent underlying trigger, or the
 * continued existence of events with that Reason.  Events should be
 * treated as informative, best-effort, supplemental data.
 *
 * @generated from message k8s.io.api.core.v1.Event
 */
export class Event extends Message<Event> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * The object that this event is about.
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference involvedObject = 2;
   */
  involvedObject?: ObjectReference;

  /**
   * This should be a short, machine understandable string that gives the reason
   * for the transition into the object's current status.
   * TODO: provide exact specification for format.
   * +optional
   *
   * @generated from field: optional string reason = 3;
   */
  reason?: string;

  /**
   * A human-readable description of the status of this operation.
   * TODO: decide on maximum length.
   * +optional
   *
   * @generated from field: optional string message = 4;
   */
  message?: string;

  /**
   * The component reporting this event. Should be a short machine understandable string.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.EventSource source = 5;
   */
  source?: EventSource;

  /**
   * The time at which the event was first recorded. (Time of server receipt is in TypeMeta.)
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time firstTimestamp = 6;
   */
  firstTimestamp?: Time;

  /**
   * The time at which the most recent occurrence of this event was recorded.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTimestamp = 7;
   */
  lastTimestamp?: Time;

  /**
   * The number of times this event has occurred.
   * +optional
   *
   * @generated from field: optional int32 count = 8;
   */
  count?: number;

  /**
   * Type of this event (Normal, Warning), new types could be added in the future
   * +optional
   *
   * @generated from field: optional string type = 9;
   */
  type?: string;

  /**
   * Time when this Event was first observed.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.MicroTime eventTime = 10;
   */
  eventTime?: MicroTime;

  /**
   * Data about the Event series this event represents or nil if it's a singleton Event.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.EventSeries series = 11;
   */
  series?: EventSeries;

  /**
   * What action was taken/failed regarding to the Regarding object.
   * +optional
   *
   * @generated from field: optional string action = 12;
   */
  action?: string;

  /**
   * Optional secondary object for more complex actions.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference related = 13;
   */
  related?: ObjectReference;

  /**
   * Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
   * +optional
   *
   * @generated from field: optional string reportingComponent = 14;
   */
  reportingComponent?: string;

  /**
   * ID of the controller instance, e.g. `kubelet-xyzf`.
   * +optional
   *
   * @generated from field: optional string reportingInstance = 15;
   */
  reportingInstance?: string;

  constructor(data?: PartialMessage<Event>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Event";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "involvedObject", kind: "message", T: ObjectReference, opt: true },
    { no: 3, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "source", kind: "message", T: EventSource, opt: true },
    { no: 6, name: "firstTimestamp", kind: "message", T: Time, opt: true },
    { no: 7, name: "lastTimestamp", kind: "message", T: Time, opt: true },
    { no: 8, name: "count", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 9, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "eventTime", kind: "message", T: MicroTime, opt: true },
    { no: 11, name: "series", kind: "message", T: EventSeries, opt: true },
    { no: 12, name: "action", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 13, name: "related", kind: "message", T: ObjectReference, opt: true },
    { no: 14, name: "reportingComponent", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 15, name: "reportingInstance", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Event {
    return new Event().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Event {
    return new Event().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Event {
    return new Event().fromJsonString(jsonString, options);
  }

  static equals(a: Event | PlainMessage<Event> | undefined, b: Event | PlainMessage<Event> | undefined): boolean {
    return proto2.util.equals(Event, a, b);
  }
}

/**
 * EventList is a list of events.
 *
 * @generated from message k8s.io.api.core.v1.EventList
 */
export class EventList extends Message<EventList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of events
   *
   * @generated from field: repeated k8s.io.api.core.v1.Event items = 2;
   */
  items: Event[] = [];

  constructor(data?: PartialMessage<EventList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EventList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Event, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EventList {
    return new EventList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EventList {
    return new EventList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EventList {
    return new EventList().fromJsonString(jsonString, options);
  }

  static equals(a: EventList | PlainMessage<EventList> | undefined, b: EventList | PlainMessage<EventList> | undefined): boolean {
    return proto2.util.equals(EventList, a, b);
  }
}

/**
 * EventSeries contain information on series of events, i.e. thing that was/is happening
 * continuously for some time.
 *
 * @generated from message k8s.io.api.core.v1.EventSeries
 */
export class EventSeries extends Message<EventSeries> {
  /**
   * Number of occurrences in this series up to the last heartbeat time
   *
   * @generated from field: optional int32 count = 1;
   */
  count?: number;

  /**
   * Time of the last occurrence observed
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.MicroTime lastObservedTime = 2;
   */
  lastObservedTime?: MicroTime;

  constructor(data?: PartialMessage<EventSeries>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EventSeries";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "count", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "lastObservedTime", kind: "message", T: MicroTime, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EventSeries {
    return new EventSeries().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EventSeries {
    return new EventSeries().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EventSeries {
    return new EventSeries().fromJsonString(jsonString, options);
  }

  static equals(a: EventSeries | PlainMessage<EventSeries> | undefined, b: EventSeries | PlainMessage<EventSeries> | undefined): boolean {
    return proto2.util.equals(EventSeries, a, b);
  }
}

/**
 * EventSource contains information for an event.
 *
 * @generated from message k8s.io.api.core.v1.EventSource
 */
export class EventSource extends Message<EventSource> {
  /**
   * Component from which the event is generated.
   * +optional
   *
   * @generated from field: optional string component = 1;
   */
  component?: string;

  /**
   * Node name on which the event is generated.
   * +optional
   *
   * @generated from field: optional string host = 2;
   */
  host?: string;

  constructor(data?: PartialMessage<EventSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.EventSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "component", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "host", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): EventSource {
    return new EventSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): EventSource {
    return new EventSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): EventSource {
    return new EventSource().fromJsonString(jsonString, options);
  }

  static equals(a: EventSource | PlainMessage<EventSource> | undefined, b: EventSource | PlainMessage<EventSource> | undefined): boolean {
    return proto2.util.equals(EventSource, a, b);
  }
}

/**
 * ExecAction describes a "run in container" action.
 *
 * @generated from message k8s.io.api.core.v1.ExecAction
 */
export class ExecAction extends Message<ExecAction> {
  /**
   * Command is the command line to execute inside the container, the working directory for the
   * command  is root ('/') in the container's filesystem. The command is simply exec'd, it is
   * not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use
   * a shell, you need to explicitly call out to that shell.
   * Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string command = 1;
   */
  command: string[] = [];

  constructor(data?: PartialMessage<ExecAction>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ExecAction";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "command", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ExecAction {
    return new ExecAction().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ExecAction {
    return new ExecAction().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ExecAction {
    return new ExecAction().fromJsonString(jsonString, options);
  }

  static equals(a: ExecAction | PlainMessage<ExecAction> | undefined, b: ExecAction | PlainMessage<ExecAction> | undefined): boolean {
    return proto2.util.equals(ExecAction, a, b);
  }
}

/**
 * Represents a Fibre Channel volume.
 * Fibre Channel volumes can only be mounted as read/write once.
 * Fibre Channel volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.FCVolumeSource
 */
export class FCVolumeSource extends Message<FCVolumeSource> {
  /**
   * targetWWNs is Optional: FC target worldwide names (WWNs)
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string targetWWNs = 1;
   */
  targetWWNs: string[] = [];

  /**
   * lun is Optional: FC target lun number
   * +optional
   *
   * @generated from field: optional int32 lun = 2;
   */
  lun?: number;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * readOnly is Optional: Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  /**
   * wwids Optional: FC volume world wide identifiers (wwids)
   * Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string wwids = 5;
   */
  wwids: string[] = [];

  constructor(data?: PartialMessage<FCVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.FCVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "targetWWNs", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "lun", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "wwids", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FCVolumeSource {
    return new FCVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FCVolumeSource {
    return new FCVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FCVolumeSource {
    return new FCVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: FCVolumeSource | PlainMessage<FCVolumeSource> | undefined, b: FCVolumeSource | PlainMessage<FCVolumeSource> | undefined): boolean {
    return proto2.util.equals(FCVolumeSource, a, b);
  }
}

/**
 * FlexPersistentVolumeSource represents a generic persistent volume resource that is
 * provisioned/attached using an exec based plugin.
 *
 * @generated from message k8s.io.api.core.v1.FlexPersistentVolumeSource
 */
export class FlexPersistentVolumeSource extends Message<FlexPersistentVolumeSource> {
  /**
   * driver is the name of the driver to use for this volume.
   *
   * @generated from field: optional string driver = 1;
   */
  driver?: string;

  /**
   * fsType is the Filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * secretRef is Optional: SecretRef is reference to the secret object containing
   * sensitive information to pass to the plugin scripts. This may be
   * empty if no secret object is specified. If the secret object
   * contains more than one secret, all secrets are passed to the plugin
   * scripts.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 3;
   */
  secretRef?: SecretReference;

  /**
   * readOnly is Optional: defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  /**
   * options is Optional: this field holds extra command options if any.
   * +optional
   *
   * @generated from field: map<string, string> options = 5;
   */
  options: { [key: string]: string } = {};

  constructor(data?: PartialMessage<FlexPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.FlexPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "driver", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "secretRef", kind: "message", T: SecretReference, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "options", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FlexPersistentVolumeSource {
    return new FlexPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FlexPersistentVolumeSource {
    return new FlexPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FlexPersistentVolumeSource {
    return new FlexPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: FlexPersistentVolumeSource | PlainMessage<FlexPersistentVolumeSource> | undefined, b: FlexPersistentVolumeSource | PlainMessage<FlexPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(FlexPersistentVolumeSource, a, b);
  }
}

/**
 * FlexVolume represents a generic volume resource that is
 * provisioned/attached using an exec based plugin.
 *
 * @generated from message k8s.io.api.core.v1.FlexVolumeSource
 */
export class FlexVolumeSource extends Message<FlexVolumeSource> {
  /**
   * driver is the name of the driver to use for this volume.
   *
   * @generated from field: optional string driver = 1;
   */
  driver?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * secretRef is Optional: secretRef is reference to the secret object containing
   * sensitive information to pass to the plugin scripts. This may be
   * empty if no secret object is specified. If the secret object
   * contains more than one secret, all secrets are passed to the plugin
   * scripts.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 3;
   */
  secretRef?: LocalObjectReference;

  /**
   * readOnly is Optional: defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  /**
   * options is Optional: this field holds extra command options if any.
   * +optional
   *
   * @generated from field: map<string, string> options = 5;
   */
  options: { [key: string]: string } = {};

  constructor(data?: PartialMessage<FlexVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.FlexVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "driver", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "options", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FlexVolumeSource {
    return new FlexVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FlexVolumeSource {
    return new FlexVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FlexVolumeSource {
    return new FlexVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: FlexVolumeSource | PlainMessage<FlexVolumeSource> | undefined, b: FlexVolumeSource | PlainMessage<FlexVolumeSource> | undefined): boolean {
    return proto2.util.equals(FlexVolumeSource, a, b);
  }
}

/**
 * Represents a Flocker volume mounted by the Flocker agent.
 * One and only one of datasetName and datasetUUID should be set.
 * Flocker volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.FlockerVolumeSource
 */
export class FlockerVolumeSource extends Message<FlockerVolumeSource> {
  /**
   * datasetName is Name of the dataset stored as metadata -> name on the dataset for Flocker
   * should be considered as deprecated
   * +optional
   *
   * @generated from field: optional string datasetName = 1;
   */
  datasetName?: string;

  /**
   * datasetUUID is the UUID of the dataset. This is unique identifier of a Flocker dataset
   * +optional
   *
   * @generated from field: optional string datasetUUID = 2;
   */
  datasetUUID?: string;

  constructor(data?: PartialMessage<FlockerVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.FlockerVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "datasetName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "datasetUUID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FlockerVolumeSource {
    return new FlockerVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FlockerVolumeSource {
    return new FlockerVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FlockerVolumeSource {
    return new FlockerVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: FlockerVolumeSource | PlainMessage<FlockerVolumeSource> | undefined, b: FlockerVolumeSource | PlainMessage<FlockerVolumeSource> | undefined): boolean {
    return proto2.util.equals(FlockerVolumeSource, a, b);
  }
}

/**
 * Represents a Persistent Disk resource in Google Compute Engine.
 *
 * A GCE PD must exist before mounting to a container. The disk must
 * also be in the same GCE project and zone as the kubelet. A GCE PD
 * can only be mounted as read/write once or read-only many times. GCE
 * PDs support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.GCEPersistentDiskVolumeSource
 */
export class GCEPersistentDiskVolumeSource extends Message<GCEPersistentDiskVolumeSource> {
  /**
   * pdName is unique name of the PD resource in GCE. Used to identify the disk in GCE.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   *
   * @generated from field: optional string pdName = 1;
   */
  pdName?: string;

  /**
   * fsType is filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * partition is the partition in the volume that you want to mount.
   * If omitted, the default is to mount by volume name.
   * Examples: For volume /dev/sda1, you specify the partition as "1".
   * Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   * +optional
   *
   * @generated from field: optional int32 partition = 3;
   */
  partition?: number;

  /**
   * readOnly here will force the ReadOnly setting in VolumeMounts.
   * Defaults to false.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<GCEPersistentDiskVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.GCEPersistentDiskVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "pdName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "partition", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GCEPersistentDiskVolumeSource {
    return new GCEPersistentDiskVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GCEPersistentDiskVolumeSource {
    return new GCEPersistentDiskVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GCEPersistentDiskVolumeSource {
    return new GCEPersistentDiskVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: GCEPersistentDiskVolumeSource | PlainMessage<GCEPersistentDiskVolumeSource> | undefined, b: GCEPersistentDiskVolumeSource | PlainMessage<GCEPersistentDiskVolumeSource> | undefined): boolean {
    return proto2.util.equals(GCEPersistentDiskVolumeSource, a, b);
  }
}

/**
 * @generated from message k8s.io.api.core.v1.GRPCAction
 */
export class GRPCAction extends Message<GRPCAction> {
  /**
   * Port number of the gRPC service. Number must be in the range 1 to 65535.
   *
   * @generated from field: optional int32 port = 1;
   */
  port?: number;

  /**
   * Service is the name of the service to place in the gRPC HealthCheckRequest
   * (see https://github.com/grpc/grpc/blob/master/doc/health-checking.md).
   *
   * If this is not specified, the default behavior is defined by gRPC.
   * +optional
   * +default=""
   *
   * @generated from field: optional string service = 2;
   */
  service?: string;

  constructor(data?: PartialMessage<GRPCAction>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.GRPCAction";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "service", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GRPCAction {
    return new GRPCAction().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GRPCAction {
    return new GRPCAction().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GRPCAction {
    return new GRPCAction().fromJsonString(jsonString, options);
  }

  static equals(a: GRPCAction | PlainMessage<GRPCAction> | undefined, b: GRPCAction | PlainMessage<GRPCAction> | undefined): boolean {
    return proto2.util.equals(GRPCAction, a, b);
  }
}

/**
 * Represents a volume that is populated with the contents of a git repository.
 * Git repo volumes do not support ownership management.
 * Git repo volumes support SELinux relabeling.
 *
 * DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an
 * EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir
 * into the Pod's container.
 *
 * @generated from message k8s.io.api.core.v1.GitRepoVolumeSource
 */
export class GitRepoVolumeSource extends Message<GitRepoVolumeSource> {
  /**
   * repository is the URL
   *
   * @generated from field: optional string repository = 1;
   */
  repository?: string;

  /**
   * revision is the commit hash for the specified revision.
   * +optional
   *
   * @generated from field: optional string revision = 2;
   */
  revision?: string;

  /**
   * directory is the target directory name.
   * Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the
   * git repository.  Otherwise, if specified, the volume will contain the git repository in
   * the subdirectory with the given name.
   * +optional
   *
   * @generated from field: optional string directory = 3;
   */
  directory?: string;

  constructor(data?: PartialMessage<GitRepoVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.GitRepoVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "repository", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "revision", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "directory", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GitRepoVolumeSource {
    return new GitRepoVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GitRepoVolumeSource {
    return new GitRepoVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GitRepoVolumeSource {
    return new GitRepoVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: GitRepoVolumeSource | PlainMessage<GitRepoVolumeSource> | undefined, b: GitRepoVolumeSource | PlainMessage<GitRepoVolumeSource> | undefined): boolean {
    return proto2.util.equals(GitRepoVolumeSource, a, b);
  }
}

/**
 * Represents a Glusterfs mount that lasts the lifetime of a pod.
 * Glusterfs volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.GlusterfsPersistentVolumeSource
 */
export class GlusterfsPersistentVolumeSource extends Message<GlusterfsPersistentVolumeSource> {
  /**
   * endpoints is the endpoint name that details Glusterfs topology.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   *
   * @generated from field: optional string endpoints = 1;
   */
  endpoints?: string;

  /**
   * path is the Glusterfs volume path.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * readOnly here will force the Glusterfs volume to be mounted with read-only permissions.
   * Defaults to false.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * endpointsNamespace is the namespace that contains Glusterfs endpoint.
   * If this field is empty, the EndpointNamespace defaults to the same namespace as the bound PVC.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   * +optional
   *
   * @generated from field: optional string endpointsNamespace = 4;
   */
  endpointsNamespace?: string;

  constructor(data?: PartialMessage<GlusterfsPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.GlusterfsPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "endpoints", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "endpointsNamespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GlusterfsPersistentVolumeSource {
    return new GlusterfsPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GlusterfsPersistentVolumeSource {
    return new GlusterfsPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GlusterfsPersistentVolumeSource {
    return new GlusterfsPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: GlusterfsPersistentVolumeSource | PlainMessage<GlusterfsPersistentVolumeSource> | undefined, b: GlusterfsPersistentVolumeSource | PlainMessage<GlusterfsPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(GlusterfsPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a Glusterfs mount that lasts the lifetime of a pod.
 * Glusterfs volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.GlusterfsVolumeSource
 */
export class GlusterfsVolumeSource extends Message<GlusterfsVolumeSource> {
  /**
   * endpoints is the endpoint name that details Glusterfs topology.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   *
   * @generated from field: optional string endpoints = 1;
   */
  endpoints?: string;

  /**
   * path is the Glusterfs volume path.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * readOnly here will force the Glusterfs volume to be mounted with read-only permissions.
   * Defaults to false.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<GlusterfsVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.GlusterfsVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "endpoints", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GlusterfsVolumeSource {
    return new GlusterfsVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GlusterfsVolumeSource {
    return new GlusterfsVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GlusterfsVolumeSource {
    return new GlusterfsVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: GlusterfsVolumeSource | PlainMessage<GlusterfsVolumeSource> | undefined, b: GlusterfsVolumeSource | PlainMessage<GlusterfsVolumeSource> | undefined): boolean {
    return proto2.util.equals(GlusterfsVolumeSource, a, b);
  }
}

/**
 * HTTPGetAction describes an action based on HTTP Get requests.
 *
 * @generated from message k8s.io.api.core.v1.HTTPGetAction
 */
export class HTTPGetAction extends Message<HTTPGetAction> {
  /**
   * Path to access on the HTTP server.
   * +optional
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  /**
   * Name or number of the port to access on the container.
   * Number must be in the range 1 to 65535.
   * Name must be an IANA_SVC_NAME.
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.util.intstr.IntOrString port = 2;
   */
  port?: IntOrString;

  /**
   * Host name to connect to, defaults to the pod IP. You probably want to set
   * "Host" in httpHeaders instead.
   * +optional
   *
   * @generated from field: optional string host = 3;
   */
  host?: string;

  /**
   * Scheme to use for connecting to the host.
   * Defaults to HTTP.
   * +optional
   *
   * @generated from field: optional string scheme = 4;
   */
  scheme?: string;

  /**
   * Custom headers to set in the request. HTTP allows repeated headers.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.HTTPHeader httpHeaders = 5;
   */
  httpHeaders: HTTPHeader[] = [];

  constructor(data?: PartialMessage<HTTPGetAction>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.HTTPGetAction";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "port", kind: "message", T: IntOrString, opt: true },
    { no: 3, name: "host", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "scheme", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "httpHeaders", kind: "message", T: HTTPHeader, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): HTTPGetAction {
    return new HTTPGetAction().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): HTTPGetAction {
    return new HTTPGetAction().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): HTTPGetAction {
    return new HTTPGetAction().fromJsonString(jsonString, options);
  }

  static equals(a: HTTPGetAction | PlainMessage<HTTPGetAction> | undefined, b: HTTPGetAction | PlainMessage<HTTPGetAction> | undefined): boolean {
    return proto2.util.equals(HTTPGetAction, a, b);
  }
}

/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 *
 * @generated from message k8s.io.api.core.v1.HTTPHeader
 */
export class HTTPHeader extends Message<HTTPHeader> {
  /**
   * The header field name.
   * This will be canonicalized upon output, so case-variant names will be understood as the same header.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * The header field value
   *
   * @generated from field: optional string value = 2;
   */
  value?: string;

  constructor(data?: PartialMessage<HTTPHeader>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.HTTPHeader";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): HTTPHeader {
    return new HTTPHeader().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): HTTPHeader {
    return new HTTPHeader().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): HTTPHeader {
    return new HTTPHeader().fromJsonString(jsonString, options);
  }

  static equals(a: HTTPHeader | PlainMessage<HTTPHeader> | undefined, b: HTTPHeader | PlainMessage<HTTPHeader> | undefined): boolean {
    return proto2.util.equals(HTTPHeader, a, b);
  }
}

/**
 * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the
 * pod's hosts file.
 *
 * @generated from message k8s.io.api.core.v1.HostAlias
 */
export class HostAlias extends Message<HostAlias> {
  /**
   * IP address of the host file entry.
   * +required
   *
   * @generated from field: optional string ip = 1;
   */
  ip?: string;

  /**
   * Hostnames for the above IP address.
   * +listType=atomic
   *
   * @generated from field: repeated string hostnames = 2;
   */
  hostnames: string[] = [];

  constructor(data?: PartialMessage<HostAlias>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.HostAlias";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ip", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "hostnames", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): HostAlias {
    return new HostAlias().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): HostAlias {
    return new HostAlias().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): HostAlias {
    return new HostAlias().fromJsonString(jsonString, options);
  }

  static equals(a: HostAlias | PlainMessage<HostAlias> | undefined, b: HostAlias | PlainMessage<HostAlias> | undefined): boolean {
    return proto2.util.equals(HostAlias, a, b);
  }
}

/**
 * HostIP represents a single IP address allocated to the host.
 *
 * @generated from message k8s.io.api.core.v1.HostIP
 */
export class HostIP extends Message<HostIP> {
  /**
   * IP is the IP address assigned to the host
   * +required
   *
   * @generated from field: optional string ip = 1;
   */
  ip?: string;

  constructor(data?: PartialMessage<HostIP>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.HostIP";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ip", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): HostIP {
    return new HostIP().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): HostIP {
    return new HostIP().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): HostIP {
    return new HostIP().fromJsonString(jsonString, options);
  }

  static equals(a: HostIP | PlainMessage<HostIP> | undefined, b: HostIP | PlainMessage<HostIP> | undefined): boolean {
    return proto2.util.equals(HostIP, a, b);
  }
}

/**
 * Represents a host path mapped into a pod.
 * Host path volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.HostPathVolumeSource
 */
export class HostPathVolumeSource extends Message<HostPathVolumeSource> {
  /**
   * path of the directory on the host.
   * If the path is a symlink, it will follow the link to the real path.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  /**
   * type for HostPath Volume
   * Defaults to ""
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
   * +optional
   *
   * @generated from field: optional string type = 2;
   */
  type?: string;

  constructor(data?: PartialMessage<HostPathVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.HostPathVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): HostPathVolumeSource {
    return new HostPathVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): HostPathVolumeSource {
    return new HostPathVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): HostPathVolumeSource {
    return new HostPathVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: HostPathVolumeSource | PlainMessage<HostPathVolumeSource> | undefined, b: HostPathVolumeSource | PlainMessage<HostPathVolumeSource> | undefined): boolean {
    return proto2.util.equals(HostPathVolumeSource, a, b);
  }
}

/**
 * ISCSIPersistentVolumeSource represents an ISCSI disk.
 * ISCSI volumes can only be mounted as read/write once.
 * ISCSI volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.ISCSIPersistentVolumeSource
 */
export class ISCSIPersistentVolumeSource extends Message<ISCSIPersistentVolumeSource> {
  /**
   * targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
   * is other than default (typically TCP ports 860 and 3260).
   *
   * @generated from field: optional string targetPortal = 1;
   */
  targetPortal?: string;

  /**
   * iqn is Target iSCSI Qualified Name.
   *
   * @generated from field: optional string iqn = 2;
   */
  iqn?: string;

  /**
   * lun is iSCSI Target Lun number.
   *
   * @generated from field: optional int32 lun = 3;
   */
  lun?: number;

  /**
   * iscsiInterface is the interface Name that uses an iSCSI transport.
   * Defaults to 'default' (tcp).
   * +optional
   * +default="default"
   *
   * @generated from field: optional string iscsiInterface = 4;
   */
  iscsiInterface?: string;

  /**
   * fsType is the filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 5;
   */
  fsType?: string;

  /**
   * readOnly here will force the ReadOnly setting in VolumeMounts.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool readOnly = 6;
   */
  readOnly?: boolean;

  /**
   * portals is the iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the port
   * is other than default (typically TCP ports 860 and 3260).
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string portals = 7;
   */
  portals: string[] = [];

  /**
   * chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
   * +optional
   *
   * @generated from field: optional bool chapAuthDiscovery = 8;
   */
  chapAuthDiscovery?: boolean;

  /**
   * chapAuthSession defines whether support iSCSI Session CHAP authentication
   * +optional
   *
   * @generated from field: optional bool chapAuthSession = 11;
   */
  chapAuthSession?: boolean;

  /**
   * secretRef is the CHAP Secret for iSCSI target and initiator authentication
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 10;
   */
  secretRef?: SecretReference;

  /**
   * initiatorName is the custom iSCSI Initiator Name.
   * If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
   * <target portal>:<volume name> will be created for the connection.
   * +optional
   *
   * @generated from field: optional string initiatorName = 12;
   */
  initiatorName?: string;

  constructor(data?: PartialMessage<ISCSIPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ISCSIPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "targetPortal", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "iqn", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lun", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "iscsiInterface", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "portals", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 8, name: "chapAuthDiscovery", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 11, name: "chapAuthSession", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 10, name: "secretRef", kind: "message", T: SecretReference, opt: true },
    { no: 12, name: "initiatorName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ISCSIPersistentVolumeSource {
    return new ISCSIPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ISCSIPersistentVolumeSource {
    return new ISCSIPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ISCSIPersistentVolumeSource {
    return new ISCSIPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ISCSIPersistentVolumeSource | PlainMessage<ISCSIPersistentVolumeSource> | undefined, b: ISCSIPersistentVolumeSource | PlainMessage<ISCSIPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(ISCSIPersistentVolumeSource, a, b);
  }
}

/**
 * Represents an ISCSI disk.
 * ISCSI volumes can only be mounted as read/write once.
 * ISCSI volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.ISCSIVolumeSource
 */
export class ISCSIVolumeSource extends Message<ISCSIVolumeSource> {
  /**
   * targetPortal is iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port
   * is other than default (typically TCP ports 860 and 3260).
   *
   * @generated from field: optional string targetPortal = 1;
   */
  targetPortal?: string;

  /**
   * iqn is the target iSCSI Qualified Name.
   *
   * @generated from field: optional string iqn = 2;
   */
  iqn?: string;

  /**
   * lun represents iSCSI Target Lun number.
   *
   * @generated from field: optional int32 lun = 3;
   */
  lun?: number;

  /**
   * iscsiInterface is the interface Name that uses an iSCSI transport.
   * Defaults to 'default' (tcp).
   * +optional
   * +default="default"
   *
   * @generated from field: optional string iscsiInterface = 4;
   */
  iscsiInterface?: string;

  /**
   * fsType is the filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 5;
   */
  fsType?: string;

  /**
   * readOnly here will force the ReadOnly setting in VolumeMounts.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool readOnly = 6;
   */
  readOnly?: boolean;

  /**
   * portals is the iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port
   * is other than default (typically TCP ports 860 and 3260).
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string portals = 7;
   */
  portals: string[] = [];

  /**
   * chapAuthDiscovery defines whether support iSCSI Discovery CHAP authentication
   * +optional
   *
   * @generated from field: optional bool chapAuthDiscovery = 8;
   */
  chapAuthDiscovery?: boolean;

  /**
   * chapAuthSession defines whether support iSCSI Session CHAP authentication
   * +optional
   *
   * @generated from field: optional bool chapAuthSession = 11;
   */
  chapAuthSession?: boolean;

  /**
   * secretRef is the CHAP Secret for iSCSI target and initiator authentication
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 10;
   */
  secretRef?: LocalObjectReference;

  /**
   * initiatorName is the custom iSCSI Initiator Name.
   * If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface
   * <target portal>:<volume name> will be created for the connection.
   * +optional
   *
   * @generated from field: optional string initiatorName = 12;
   */
  initiatorName?: string;

  constructor(data?: PartialMessage<ISCSIVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ISCSIVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "targetPortal", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "iqn", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lun", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "iscsiInterface", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "portals", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 8, name: "chapAuthDiscovery", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 11, name: "chapAuthSession", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 10, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
    { no: 12, name: "initiatorName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ISCSIVolumeSource {
    return new ISCSIVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ISCSIVolumeSource {
    return new ISCSIVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ISCSIVolumeSource {
    return new ISCSIVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ISCSIVolumeSource | PlainMessage<ISCSIVolumeSource> | undefined, b: ISCSIVolumeSource | PlainMessage<ISCSIVolumeSource> | undefined): boolean {
    return proto2.util.equals(ISCSIVolumeSource, a, b);
  }
}

/**
 * ImageVolumeSource represents a image volume resource.
 *
 * @generated from message k8s.io.api.core.v1.ImageVolumeSource
 */
export class ImageVolumeSource extends Message<ImageVolumeSource> {
  /**
   * Required: Image or artifact reference to be used.
   * Behaves in the same way as pod.spec.containers[*].image.
   * Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets.
   * More info: https://kubernetes.io/docs/concepts/containers/images
   * This field is optional to allow higher level config management to default or override
   * container images in workload controllers like Deployments and StatefulSets.
   * +optional
   *
   * @generated from field: optional string reference = 1;
   */
  reference?: string;

  /**
   * Policy for pulling OCI objects. Possible values are:
   * Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails.
   * Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present.
   * IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails.
   * Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
   * +optional
   *
   * @generated from field: optional string pullPolicy = 2;
   */
  pullPolicy?: string;

  constructor(data?: PartialMessage<ImageVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ImageVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "reference", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "pullPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ImageVolumeSource {
    return new ImageVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ImageVolumeSource {
    return new ImageVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ImageVolumeSource {
    return new ImageVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ImageVolumeSource | PlainMessage<ImageVolumeSource> | undefined, b: ImageVolumeSource | PlainMessage<ImageVolumeSource> | undefined): boolean {
    return proto2.util.equals(ImageVolumeSource, a, b);
  }
}

/**
 * Maps a string key to a path within a volume.
 *
 * @generated from message k8s.io.api.core.v1.KeyToPath
 */
export class KeyToPath extends Message<KeyToPath> {
  /**
   * key is the key to project.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * path is the relative path of the file to map the key to.
   * May not be an absolute path.
   * May not contain the path element '..'.
   * May not start with the string '..'.
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * mode is Optional: mode bits used to set permissions on this file.
   * Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
   * If not specified, the volume defaultMode will be used.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 mode = 3;
   */
  mode?: number;

  constructor(data?: PartialMessage<KeyToPath>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.KeyToPath";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "mode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): KeyToPath {
    return new KeyToPath().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): KeyToPath {
    return new KeyToPath().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): KeyToPath {
    return new KeyToPath().fromJsonString(jsonString, options);
  }

  static equals(a: KeyToPath | PlainMessage<KeyToPath> | undefined, b: KeyToPath | PlainMessage<KeyToPath> | undefined): boolean {
    return proto2.util.equals(KeyToPath, a, b);
  }
}

/**
 * Lifecycle describes actions that the management system should take in response to container lifecycle
 * events. For the PostStart and PreStop lifecycle handlers, management of the container blocks
 * until the action is complete, unless the container process fails, in which case the handler is aborted.
 *
 * @generated from message k8s.io.api.core.v1.Lifecycle
 */
export class Lifecycle extends Message<Lifecycle> {
  /**
   * PostStart is called immediately after a container is created. If the handler fails,
   * the container is terminated and restarted according to its restart policy.
   * Other management of the container blocks until the hook completes.
   * More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LifecycleHandler postStart = 1;
   */
  postStart?: LifecycleHandler;

  /**
   * PreStop is called immediately before a container is terminated due to an
   * API request or management event such as liveness/startup probe failure,
   * preemption, resource contention, etc. The handler is not called if the
   * container crashes or exits. The Pod's termination grace period countdown begins before the
   * PreStop hook is executed. Regardless of the outcome of the handler, the
   * container will eventually terminate within the Pod's termination grace
   * period (unless delayed by finalizers). Other management of the container blocks until the hook completes
   * or until the termination grace period is reached.
   * More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LifecycleHandler preStop = 2;
   */
  preStop?: LifecycleHandler;

  constructor(data?: PartialMessage<Lifecycle>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Lifecycle";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "postStart", kind: "message", T: LifecycleHandler, opt: true },
    { no: 2, name: "preStop", kind: "message", T: LifecycleHandler, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Lifecycle {
    return new Lifecycle().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Lifecycle {
    return new Lifecycle().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Lifecycle {
    return new Lifecycle().fromJsonString(jsonString, options);
  }

  static equals(a: Lifecycle | PlainMessage<Lifecycle> | undefined, b: Lifecycle | PlainMessage<Lifecycle> | undefined): boolean {
    return proto2.util.equals(Lifecycle, a, b);
  }
}

/**
 * LifecycleHandler defines a specific action that should be taken in a lifecycle
 * hook. One and only one of the fields, except TCPSocket must be specified.
 *
 * @generated from message k8s.io.api.core.v1.LifecycleHandler
 */
export class LifecycleHandler extends Message<LifecycleHandler> {
  /**
   * Exec specifies the action to take.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ExecAction exec = 1;
   */
  exec?: ExecAction;

  /**
   * HTTPGet specifies the http request to perform.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.HTTPGetAction httpGet = 2;
   */
  httpGet?: HTTPGetAction;

  /**
   * Deprecated. TCPSocket is NOT supported as a LifecycleHandler and kept
   * for the backward compatibility. There are no validation of this field and
   * lifecycle hooks will fail in runtime when tcp handler is specified.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.TCPSocketAction tcpSocket = 3;
   */
  tcpSocket?: TCPSocketAction;

  /**
   * Sleep represents the duration that the container should sleep before being terminated.
   * +featureGate=PodLifecycleSleepAction
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SleepAction sleep = 4;
   */
  sleep?: SleepAction;

  constructor(data?: PartialMessage<LifecycleHandler>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LifecycleHandler";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "exec", kind: "message", T: ExecAction, opt: true },
    { no: 2, name: "httpGet", kind: "message", T: HTTPGetAction, opt: true },
    { no: 3, name: "tcpSocket", kind: "message", T: TCPSocketAction, opt: true },
    { no: 4, name: "sleep", kind: "message", T: SleepAction, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LifecycleHandler {
    return new LifecycleHandler().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LifecycleHandler {
    return new LifecycleHandler().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LifecycleHandler {
    return new LifecycleHandler().fromJsonString(jsonString, options);
  }

  static equals(a: LifecycleHandler | PlainMessage<LifecycleHandler> | undefined, b: LifecycleHandler | PlainMessage<LifecycleHandler> | undefined): boolean {
    return proto2.util.equals(LifecycleHandler, a, b);
  }
}

/**
 * LimitRange sets resource usage limits for each kind of resource in a Namespace.
 *
 * @generated from message k8s.io.api.core.v1.LimitRange
 */
export class LimitRange extends Message<LimitRange> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the limits enforced.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LimitRangeSpec spec = 2;
   */
  spec?: LimitRangeSpec;

  constructor(data?: PartialMessage<LimitRange>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LimitRange";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: LimitRangeSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LimitRange {
    return new LimitRange().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LimitRange {
    return new LimitRange().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LimitRange {
    return new LimitRange().fromJsonString(jsonString, options);
  }

  static equals(a: LimitRange | PlainMessage<LimitRange> | undefined, b: LimitRange | PlainMessage<LimitRange> | undefined): boolean {
    return proto2.util.equals(LimitRange, a, b);
  }
}

/**
 * LimitRangeItem defines a min/max usage limit for any resource that matches on kind.
 *
 * @generated from message k8s.io.api.core.v1.LimitRangeItem
 */
export class LimitRangeItem extends Message<LimitRangeItem> {
  /**
   * Type of resource that this limit applies to.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Max usage constraints on this kind by resource name.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> max = 2;
   */
  max: { [key: string]: Quantity } = {};

  /**
   * Min usage constraints on this kind by resource name.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> min = 3;
   */
  min: { [key: string]: Quantity } = {};

  /**
   * Default resource requirement limit value by resource name if resource limit is omitted.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> default = 4;
   */
  default: { [key: string]: Quantity } = {};

  /**
   * DefaultRequest is the default resource requirement request value by resource name if resource request is omitted.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> defaultRequest = 5;
   */
  defaultRequest: { [key: string]: Quantity } = {};

  /**
   * MaxLimitRequestRatio if specified, the named resource must have a request and limit that are both non-zero where limit divided by request is less than or equal to the enumerated value; this represents the max burst for the named resource.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> maxLimitRequestRatio = 6;
   */
  maxLimitRequestRatio: { [key: string]: Quantity } = {};

  constructor(data?: PartialMessage<LimitRangeItem>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LimitRangeItem";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "max", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 3, name: "min", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 4, name: "default", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 5, name: "defaultRequest", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 6, name: "maxLimitRequestRatio", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LimitRangeItem {
    return new LimitRangeItem().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LimitRangeItem {
    return new LimitRangeItem().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LimitRangeItem {
    return new LimitRangeItem().fromJsonString(jsonString, options);
  }

  static equals(a: LimitRangeItem | PlainMessage<LimitRangeItem> | undefined, b: LimitRangeItem | PlainMessage<LimitRangeItem> | undefined): boolean {
    return proto2.util.equals(LimitRangeItem, a, b);
  }
}

/**
 * LimitRangeList is a list of LimitRange items.
 *
 * @generated from message k8s.io.api.core.v1.LimitRangeList
 */
export class LimitRangeList extends Message<LimitRangeList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Items is a list of LimitRange objects.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   *
   * @generated from field: repeated k8s.io.api.core.v1.LimitRange items = 2;
   */
  items: LimitRange[] = [];

  constructor(data?: PartialMessage<LimitRangeList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LimitRangeList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: LimitRange, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LimitRangeList {
    return new LimitRangeList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LimitRangeList {
    return new LimitRangeList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LimitRangeList {
    return new LimitRangeList().fromJsonString(jsonString, options);
  }

  static equals(a: LimitRangeList | PlainMessage<LimitRangeList> | undefined, b: LimitRangeList | PlainMessage<LimitRangeList> | undefined): boolean {
    return proto2.util.equals(LimitRangeList, a, b);
  }
}

/**
 * LimitRangeSpec defines a min/max usage limit for resources that match on kind.
 *
 * @generated from message k8s.io.api.core.v1.LimitRangeSpec
 */
export class LimitRangeSpec extends Message<LimitRangeSpec> {
  /**
   * Limits is the list of LimitRangeItem objects that are enforced.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.LimitRangeItem limits = 1;
   */
  limits: LimitRangeItem[] = [];

  constructor(data?: PartialMessage<LimitRangeSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LimitRangeSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "limits", kind: "message", T: LimitRangeItem, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LimitRangeSpec {
    return new LimitRangeSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LimitRangeSpec {
    return new LimitRangeSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LimitRangeSpec {
    return new LimitRangeSpec().fromJsonString(jsonString, options);
  }

  static equals(a: LimitRangeSpec | PlainMessage<LimitRangeSpec> | undefined, b: LimitRangeSpec | PlainMessage<LimitRangeSpec> | undefined): boolean {
    return proto2.util.equals(LimitRangeSpec, a, b);
  }
}

/**
 * LinuxContainerUser represents user identity information in Linux containers
 *
 * @generated from message k8s.io.api.core.v1.LinuxContainerUser
 */
export class LinuxContainerUser extends Message<LinuxContainerUser> {
  /**
   * UID is the primary uid initially attached to the first process in the container
   *
   * @generated from field: optional int64 uid = 1;
   */
  uid?: bigint;

  /**
   * GID is the primary gid initially attached to the first process in the container
   *
   * @generated from field: optional int64 gid = 2;
   */
  gid?: bigint;

  /**
   * SupplementalGroups are the supplemental groups initially attached to the first process in the container
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated int64 supplementalGroups = 3;
   */
  supplementalGroups: bigint[] = [];

  constructor(data?: PartialMessage<LinuxContainerUser>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LinuxContainerUser";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "uid", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "gid", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 3, name: "supplementalGroups", kind: "scalar", T: 3 /* ScalarType.INT64 */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LinuxContainerUser {
    return new LinuxContainerUser().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LinuxContainerUser {
    return new LinuxContainerUser().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LinuxContainerUser {
    return new LinuxContainerUser().fromJsonString(jsonString, options);
  }

  static equals(a: LinuxContainerUser | PlainMessage<LinuxContainerUser> | undefined, b: LinuxContainerUser | PlainMessage<LinuxContainerUser> | undefined): boolean {
    return proto2.util.equals(LinuxContainerUser, a, b);
  }
}

/**
 * List holds a list of objects, which may not be known by the server.
 *
 * @generated from message k8s.io.api.core.v1.List
 */
export class List extends Message<List> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of objects
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.runtime.RawExtension items = 2;
   */
  items: RawExtension[] = [];

  constructor(data?: PartialMessage<List>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.List";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: RawExtension, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): List {
    return new List().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): List {
    return new List().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): List {
    return new List().fromJsonString(jsonString, options);
  }

  static equals(a: List | PlainMessage<List> | undefined, b: List | PlainMessage<List> | undefined): boolean {
    return proto2.util.equals(List, a, b);
  }
}

/**
 * LoadBalancerIngress represents the status of a load-balancer ingress point:
 * traffic intended for the service should be sent to an ingress point.
 *
 * @generated from message k8s.io.api.core.v1.LoadBalancerIngress
 */
export class LoadBalancerIngress extends Message<LoadBalancerIngress> {
  /**
   * IP is set for load-balancer ingress points that are IP based
   * (typically GCE or OpenStack load-balancers)
   * +optional
   *
   * @generated from field: optional string ip = 1;
   */
  ip?: string;

  /**
   * Hostname is set for load-balancer ingress points that are DNS based
   * (typically AWS load-balancers)
   * +optional
   *
   * @generated from field: optional string hostname = 2;
   */
  hostname?: string;

  /**
   * IPMode specifies how the load-balancer IP behaves, and may only be specified when the ip field is specified.
   * Setting this to "VIP" indicates that traffic is delivered to the node with
   * the destination set to the load-balancer's IP and port.
   * Setting this to "Proxy" indicates that traffic is delivered to the node or pod with
   * the destination set to the node's IP and node port or the pod's IP and port.
   * Service implementations may use this information to adjust traffic routing.
   * +optional
   *
   * @generated from field: optional string ipMode = 3;
   */
  ipMode?: string;

  /**
   * Ports is a list of records of service ports
   * If used, every port defined in the service should have an entry in it
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.PortStatus ports = 4;
   */
  ports: PortStatus[] = [];

  constructor(data?: PartialMessage<LoadBalancerIngress>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LoadBalancerIngress";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ip", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "hostname", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "ipMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "ports", kind: "message", T: PortStatus, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerIngress {
    return new LoadBalancerIngress().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerIngress {
    return new LoadBalancerIngress().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerIngress {
    return new LoadBalancerIngress().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerIngress | PlainMessage<LoadBalancerIngress> | undefined, b: LoadBalancerIngress | PlainMessage<LoadBalancerIngress> | undefined): boolean {
    return proto2.util.equals(LoadBalancerIngress, a, b);
  }
}

/**
 * LoadBalancerStatus represents the status of a load-balancer.
 *
 * @generated from message k8s.io.api.core.v1.LoadBalancerStatus
 */
export class LoadBalancerStatus extends Message<LoadBalancerStatus> {
  /**
   * Ingress is a list containing ingress points for the load-balancer.
   * Traffic intended for the service should be sent to these ingress points.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.LoadBalancerIngress ingress = 1;
   */
  ingress: LoadBalancerIngress[] = [];

  constructor(data?: PartialMessage<LoadBalancerStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LoadBalancerStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ingress", kind: "message", T: LoadBalancerIngress, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LoadBalancerStatus {
    return new LoadBalancerStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LoadBalancerStatus {
    return new LoadBalancerStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LoadBalancerStatus {
    return new LoadBalancerStatus().fromJsonString(jsonString, options);
  }

  static equals(a: LoadBalancerStatus | PlainMessage<LoadBalancerStatus> | undefined, b: LoadBalancerStatus | PlainMessage<LoadBalancerStatus> | undefined): boolean {
    return proto2.util.equals(LoadBalancerStatus, a, b);
  }
}

/**
 * LocalObjectReference contains enough information to let you locate the
 * referenced object inside the same namespace.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.LocalObjectReference
 */
export class LocalObjectReference extends Message<LocalObjectReference> {
  /**
   * Name of the referent.
   * This field is effectively required, but due to backwards compatibility is
   * allowed to be empty. Instances of this type with an empty value here are
   * almost certainly wrong.
   * TODO: Add other useful fields. apiVersion, kind, uid?
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
   * +optional
   * +default=""
   * +kubebuilder:default=""
   * TODO: Drop `kubebuilder:default` when controller-gen doesn't need it https://github.com/kubernetes-sigs/kubebuilder/issues/3896.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  constructor(data?: PartialMessage<LocalObjectReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LocalObjectReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LocalObjectReference {
    return new LocalObjectReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LocalObjectReference {
    return new LocalObjectReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LocalObjectReference {
    return new LocalObjectReference().fromJsonString(jsonString, options);
  }

  static equals(a: LocalObjectReference | PlainMessage<LocalObjectReference> | undefined, b: LocalObjectReference | PlainMessage<LocalObjectReference> | undefined): boolean {
    return proto2.util.equals(LocalObjectReference, a, b);
  }
}

/**
 * Local represents directly-attached storage with node affinity (Beta feature)
 *
 * @generated from message k8s.io.api.core.v1.LocalVolumeSource
 */
export class LocalVolumeSource extends Message<LocalVolumeSource> {
  /**
   * path of the full path to the volume on the node.
   * It can be either a directory or block device (disk, partition, ...).
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  /**
   * fsType is the filesystem type to mount.
   * It applies only when the Path is a block device.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". The default value is to auto-select a filesystem if unspecified.
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  constructor(data?: PartialMessage<LocalVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.LocalVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LocalVolumeSource {
    return new LocalVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LocalVolumeSource {
    return new LocalVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LocalVolumeSource {
    return new LocalVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: LocalVolumeSource | PlainMessage<LocalVolumeSource> | undefined, b: LocalVolumeSource | PlainMessage<LocalVolumeSource> | undefined): boolean {
    return proto2.util.equals(LocalVolumeSource, a, b);
  }
}

/**
 * ModifyVolumeStatus represents the status object of ControllerModifyVolume operation
 *
 * @generated from message k8s.io.api.core.v1.ModifyVolumeStatus
 */
export class ModifyVolumeStatus extends Message<ModifyVolumeStatus> {
  /**
   * targetVolumeAttributesClassName is the name of the VolumeAttributesClass the PVC currently being reconciled
   *
   * @generated from field: optional string targetVolumeAttributesClassName = 1;
   */
  targetVolumeAttributesClassName?: string;

  /**
   * status is the status of the ControllerModifyVolume operation. It can be in any of following states:
   *  - Pending
   *    Pending indicates that the PersistentVolumeClaim cannot be modified due to unmet requirements, such as
   *    the specified VolumeAttributesClass not existing.
   *  - InProgress
   *    InProgress indicates that the volume is being modified.
   *  - Infeasible
   *   Infeasible indicates that the request has been rejected as invalid by the CSI driver. To
   * 	  resolve the error, a valid VolumeAttributesClass needs to be specified.
   * Note: New statuses can be added in the future. Consumers should check for unknown statuses and fail appropriately.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  constructor(data?: PartialMessage<ModifyVolumeStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ModifyVolumeStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "targetVolumeAttributesClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ModifyVolumeStatus {
    return new ModifyVolumeStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ModifyVolumeStatus {
    return new ModifyVolumeStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ModifyVolumeStatus {
    return new ModifyVolumeStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ModifyVolumeStatus | PlainMessage<ModifyVolumeStatus> | undefined, b: ModifyVolumeStatus | PlainMessage<ModifyVolumeStatus> | undefined): boolean {
    return proto2.util.equals(ModifyVolumeStatus, a, b);
  }
}

/**
 * Represents an NFS mount that lasts the lifetime of a pod.
 * NFS volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.NFSVolumeSource
 */
export class NFSVolumeSource extends Message<NFSVolumeSource> {
  /**
   * server is the hostname or IP address of the NFS server.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
   *
   * @generated from field: optional string server = 1;
   */
  server?: string;

  /**
   * path that is exported by the NFS server.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
   *
   * @generated from field: optional string path = 2;
   */
  path?: string;

  /**
   * readOnly here will force the NFS export to be mounted with read-only permissions.
   * Defaults to false.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<NFSVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NFSVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "server", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NFSVolumeSource {
    return new NFSVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NFSVolumeSource {
    return new NFSVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NFSVolumeSource {
    return new NFSVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: NFSVolumeSource | PlainMessage<NFSVolumeSource> | undefined, b: NFSVolumeSource | PlainMessage<NFSVolumeSource> | undefined): boolean {
    return proto2.util.equals(NFSVolumeSource, a, b);
  }
}

/**
 * Namespace provides a scope for Names.
 * Use of multiple namespaces is optional.
 *
 * @generated from message k8s.io.api.core.v1.Namespace
 */
export class Namespace extends Message<Namespace> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the behavior of the Namespace.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NamespaceSpec spec = 2;
   */
  spec?: NamespaceSpec;

  /**
   * Status describes the current status of a Namespace.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NamespaceStatus status = 3;
   */
  status?: NamespaceStatus;

  constructor(data?: PartialMessage<Namespace>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Namespace";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: NamespaceSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: NamespaceStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Namespace {
    return new Namespace().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Namespace {
    return new Namespace().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Namespace {
    return new Namespace().fromJsonString(jsonString, options);
  }

  static equals(a: Namespace | PlainMessage<Namespace> | undefined, b: Namespace | PlainMessage<Namespace> | undefined): boolean {
    return proto2.util.equals(Namespace, a, b);
  }
}

/**
 * NamespaceCondition contains details about state of namespace.
 *
 * @generated from message k8s.io.api.core.v1.NamespaceCondition
 */
export class NamespaceCondition extends Message<NamespaceCondition> {
  /**
   * Type of namespace controller condition.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status of the condition, one of True, False, Unknown.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * +optional
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * +optional
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<NamespaceCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NamespaceCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamespaceCondition {
    return new NamespaceCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamespaceCondition {
    return new NamespaceCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamespaceCondition {
    return new NamespaceCondition().fromJsonString(jsonString, options);
  }

  static equals(a: NamespaceCondition | PlainMessage<NamespaceCondition> | undefined, b: NamespaceCondition | PlainMessage<NamespaceCondition> | undefined): boolean {
    return proto2.util.equals(NamespaceCondition, a, b);
  }
}

/**
 * NamespaceList is a list of Namespaces.
 *
 * @generated from message k8s.io.api.core.v1.NamespaceList
 */
export class NamespaceList extends Message<NamespaceList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Items is the list of Namespace objects in the list.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
   *
   * @generated from field: repeated k8s.io.api.core.v1.Namespace items = 2;
   */
  items: Namespace[] = [];

  constructor(data?: PartialMessage<NamespaceList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NamespaceList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Namespace, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamespaceList {
    return new NamespaceList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamespaceList {
    return new NamespaceList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamespaceList {
    return new NamespaceList().fromJsonString(jsonString, options);
  }

  static equals(a: NamespaceList | PlainMessage<NamespaceList> | undefined, b: NamespaceList | PlainMessage<NamespaceList> | undefined): boolean {
    return proto2.util.equals(NamespaceList, a, b);
  }
}

/**
 * NamespaceSpec describes the attributes on a Namespace.
 *
 * @generated from message k8s.io.api.core.v1.NamespaceSpec
 */
export class NamespaceSpec extends Message<NamespaceSpec> {
  /**
   * Finalizers is an opaque list of values that must be empty to permanently remove object from storage.
   * More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string finalizers = 1;
   */
  finalizers: string[] = [];

  constructor(data?: PartialMessage<NamespaceSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NamespaceSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "finalizers", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamespaceSpec {
    return new NamespaceSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamespaceSpec {
    return new NamespaceSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamespaceSpec {
    return new NamespaceSpec().fromJsonString(jsonString, options);
  }

  static equals(a: NamespaceSpec | PlainMessage<NamespaceSpec> | undefined, b: NamespaceSpec | PlainMessage<NamespaceSpec> | undefined): boolean {
    return proto2.util.equals(NamespaceSpec, a, b);
  }
}

/**
 * NamespaceStatus is information about the current status of a Namespace.
 *
 * @generated from message k8s.io.api.core.v1.NamespaceStatus
 */
export class NamespaceStatus extends Message<NamespaceStatus> {
  /**
   * Phase is the current lifecycle phase of the namespace.
   * More info: https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
   * +optional
   *
   * @generated from field: optional string phase = 1;
   */
  phase?: string;

  /**
   * Represents the latest available observations of a namespace's current state.
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.NamespaceCondition conditions = 2;
   */
  conditions: NamespaceCondition[] = [];

  constructor(data?: PartialMessage<NamespaceStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NamespaceStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "phase", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "conditions", kind: "message", T: NamespaceCondition, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NamespaceStatus {
    return new NamespaceStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NamespaceStatus {
    return new NamespaceStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NamespaceStatus {
    return new NamespaceStatus().fromJsonString(jsonString, options);
  }

  static equals(a: NamespaceStatus | PlainMessage<NamespaceStatus> | undefined, b: NamespaceStatus | PlainMessage<NamespaceStatus> | undefined): boolean {
    return proto2.util.equals(NamespaceStatus, a, b);
  }
}

/**
 * Node is a worker node in Kubernetes.
 * Each node will have a unique identifier in the cache (i.e. in etcd).
 *
 * @generated from message k8s.io.api.core.v1.Node
 */
export class Node extends Message<Node> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the behavior of a node.
   * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeSpec spec = 2;
   */
  spec?: NodeSpec;

  /**
   * Most recently observed status of the node.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeStatus status = 3;
   */
  status?: NodeStatus;

  constructor(data?: PartialMessage<Node>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Node";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: NodeSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: NodeStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Node {
    return new Node().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Node {
    return new Node().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Node {
    return new Node().fromJsonString(jsonString, options);
  }

  static equals(a: Node | PlainMessage<Node> | undefined, b: Node | PlainMessage<Node> | undefined): boolean {
    return proto2.util.equals(Node, a, b);
  }
}

/**
 * NodeAddress contains information for the node's address.
 *
 * @generated from message k8s.io.api.core.v1.NodeAddress
 */
export class NodeAddress extends Message<NodeAddress> {
  /**
   * Node address type, one of Hostname, ExternalIP or InternalIP.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * The node address.
   *
   * @generated from field: optional string address = 2;
   */
  address?: string;

  constructor(data?: PartialMessage<NodeAddress>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeAddress";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "address", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeAddress {
    return new NodeAddress().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeAddress {
    return new NodeAddress().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeAddress {
    return new NodeAddress().fromJsonString(jsonString, options);
  }

  static equals(a: NodeAddress | PlainMessage<NodeAddress> | undefined, b: NodeAddress | PlainMessage<NodeAddress> | undefined): boolean {
    return proto2.util.equals(NodeAddress, a, b);
  }
}

/**
 * Node affinity is a group of node affinity scheduling rules.
 *
 * @generated from message k8s.io.api.core.v1.NodeAffinity
 */
export class NodeAffinity extends Message<NodeAffinity> {
  /**
   * If the affinity requirements specified by this field are not met at
   * scheduling time, the pod will not be scheduled onto the node.
   * If the affinity requirements specified by this field cease to be met
   * at some point during pod execution (e.g. due to an update), the system
   * may or may not try to eventually evict the pod from its node.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeSelector requiredDuringSchedulingIgnoredDuringExecution = 1;
   */
  requiredDuringSchedulingIgnoredDuringExecution?: NodeSelector;

  /**
   * The scheduler will prefer to schedule pods to nodes that satisfy
   * the affinity expressions specified by this field, but it may choose
   * a node that violates one or more of the expressions. The node that is
   * most preferred is the one with the greatest sum of weights, i.e.
   * for each node that meets all of the scheduling requirements (resource
   * request, requiredDuringScheduling affinity expressions, etc.),
   * compute a sum by iterating through the elements of this field and adding
   * "weight" to the sum if the node matches the corresponding matchExpressions; the
   * node(s) with the highest sum are the most preferred.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PreferredSchedulingTerm preferredDuringSchedulingIgnoredDuringExecution = 2;
   */
  preferredDuringSchedulingIgnoredDuringExecution: PreferredSchedulingTerm[] = [];

  constructor(data?: PartialMessage<NodeAffinity>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeAffinity";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "requiredDuringSchedulingIgnoredDuringExecution", kind: "message", T: NodeSelector, opt: true },
    { no: 2, name: "preferredDuringSchedulingIgnoredDuringExecution", kind: "message", T: PreferredSchedulingTerm, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeAffinity {
    return new NodeAffinity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeAffinity {
    return new NodeAffinity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeAffinity {
    return new NodeAffinity().fromJsonString(jsonString, options);
  }

  static equals(a: NodeAffinity | PlainMessage<NodeAffinity> | undefined, b: NodeAffinity | PlainMessage<NodeAffinity> | undefined): boolean {
    return proto2.util.equals(NodeAffinity, a, b);
  }
}

/**
 * NodeCondition contains condition information for a node.
 *
 * @generated from message k8s.io.api.core.v1.NodeCondition
 */
export class NodeCondition extends Message<NodeCondition> {
  /**
   * Type of node condition.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status of the condition, one of True, False, Unknown.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * Last time we got an update on a given condition.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastHeartbeatTime = 3;
   */
  lastHeartbeatTime?: Time;

  /**
   * Last time the condition transit from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * (brief) reason for the condition's last transition.
   * +optional
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * Human readable message indicating details about last transition.
   * +optional
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<NodeCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastHeartbeatTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeCondition {
    return new NodeCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeCondition {
    return new NodeCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeCondition {
    return new NodeCondition().fromJsonString(jsonString, options);
  }

  static equals(a: NodeCondition | PlainMessage<NodeCondition> | undefined, b: NodeCondition | PlainMessage<NodeCondition> | undefined): boolean {
    return proto2.util.equals(NodeCondition, a, b);
  }
}

/**
 * NodeConfigSource specifies a source of node configuration. Exactly one subfield (excluding metadata) must be non-nil.
 * This API is deprecated since 1.22
 *
 * @generated from message k8s.io.api.core.v1.NodeConfigSource
 */
export class NodeConfigSource extends Message<NodeConfigSource> {
  /**
   * ConfigMap is a reference to a Node's ConfigMap
   *
   * @generated from field: optional k8s.io.api.core.v1.ConfigMapNodeConfigSource configMap = 2;
   */
  configMap?: ConfigMapNodeConfigSource;

  constructor(data?: PartialMessage<NodeConfigSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeConfigSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 2, name: "configMap", kind: "message", T: ConfigMapNodeConfigSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeConfigSource {
    return new NodeConfigSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeConfigSource {
    return new NodeConfigSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeConfigSource {
    return new NodeConfigSource().fromJsonString(jsonString, options);
  }

  static equals(a: NodeConfigSource | PlainMessage<NodeConfigSource> | undefined, b: NodeConfigSource | PlainMessage<NodeConfigSource> | undefined): boolean {
    return proto2.util.equals(NodeConfigSource, a, b);
  }
}

/**
 * NodeConfigStatus describes the status of the config assigned by Node.Spec.ConfigSource.
 *
 * @generated from message k8s.io.api.core.v1.NodeConfigStatus
 */
export class NodeConfigStatus extends Message<NodeConfigStatus> {
  /**
   * Assigned reports the checkpointed config the node will try to use.
   * When Node.Spec.ConfigSource is updated, the node checkpoints the associated
   * config payload to local disk, along with a record indicating intended
   * config. The node refers to this record to choose its config checkpoint, and
   * reports this record in Assigned. Assigned only updates in the status after
   * the record has been checkpointed to disk. When the Kubelet is restarted,
   * it tries to make the Assigned config the Active config by loading and
   * validating the checkpointed payload identified by Assigned.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeConfigSource assigned = 1;
   */
  assigned?: NodeConfigSource;

  /**
   * Active reports the checkpointed config the node is actively using.
   * Active will represent either the current version of the Assigned config,
   * or the current LastKnownGood config, depending on whether attempting to use the
   * Assigned config results in an error.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeConfigSource active = 2;
   */
  active?: NodeConfigSource;

  /**
   * LastKnownGood reports the checkpointed config the node will fall back to
   * when it encounters an error attempting to use the Assigned config.
   * The Assigned config becomes the LastKnownGood config when the node determines
   * that the Assigned config is stable and correct.
   * This is currently implemented as a 10-minute soak period starting when the local
   * record of Assigned config is updated. If the Assigned config is Active at the end
   * of this period, it becomes the LastKnownGood. Note that if Spec.ConfigSource is
   * reset to nil (use local defaults), the LastKnownGood is also immediately reset to nil,
   * because the local default config is always assumed good.
   * You should not make assumptions about the node's method of determining config stability
   * and correctness, as this may change or become configurable in the future.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeConfigSource lastKnownGood = 3;
   */
  lastKnownGood?: NodeConfigSource;

  /**
   * Error describes any problems reconciling the Spec.ConfigSource to the Active config.
   * Errors may occur, for example, attempting to checkpoint Spec.ConfigSource to the local Assigned
   * record, attempting to checkpoint the payload associated with Spec.ConfigSource, attempting
   * to load or validate the Assigned config, etc.
   * Errors may occur at different points while syncing config. Earlier errors (e.g. download or
   * checkpointing errors) will not result in a rollback to LastKnownGood, and may resolve across
   * Kubelet retries. Later errors (e.g. loading or validating a checkpointed config) will result in
   * a rollback to LastKnownGood. In the latter case, it is usually possible to resolve the error
   * by fixing the config assigned in Spec.ConfigSource.
   * You can find additional information for debugging by searching the error message in the Kubelet log.
   * Error is a human-readable description of the error state; machines can check whether or not Error
   * is empty, but should not rely on the stability of the Error text across Kubelet versions.
   * +optional
   *
   * @generated from field: optional string error = 4;
   */
  error?: string;

  constructor(data?: PartialMessage<NodeConfigStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeConfigStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "assigned", kind: "message", T: NodeConfigSource, opt: true },
    { no: 2, name: "active", kind: "message", T: NodeConfigSource, opt: true },
    { no: 3, name: "lastKnownGood", kind: "message", T: NodeConfigSource, opt: true },
    { no: 4, name: "error", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeConfigStatus {
    return new NodeConfigStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeConfigStatus {
    return new NodeConfigStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeConfigStatus {
    return new NodeConfigStatus().fromJsonString(jsonString, options);
  }

  static equals(a: NodeConfigStatus | PlainMessage<NodeConfigStatus> | undefined, b: NodeConfigStatus | PlainMessage<NodeConfigStatus> | undefined): boolean {
    return proto2.util.equals(NodeConfigStatus, a, b);
  }
}

/**
 * NodeDaemonEndpoints lists ports opened by daemons running on the Node.
 *
 * @generated from message k8s.io.api.core.v1.NodeDaemonEndpoints
 */
export class NodeDaemonEndpoints extends Message<NodeDaemonEndpoints> {
  /**
   * Endpoint on which Kubelet is listening.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.DaemonEndpoint kubeletEndpoint = 1;
   */
  kubeletEndpoint?: DaemonEndpoint;

  constructor(data?: PartialMessage<NodeDaemonEndpoints>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeDaemonEndpoints";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "kubeletEndpoint", kind: "message", T: DaemonEndpoint, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeDaemonEndpoints {
    return new NodeDaemonEndpoints().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeDaemonEndpoints {
    return new NodeDaemonEndpoints().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeDaemonEndpoints {
    return new NodeDaemonEndpoints().fromJsonString(jsonString, options);
  }

  static equals(a: NodeDaemonEndpoints | PlainMessage<NodeDaemonEndpoints> | undefined, b: NodeDaemonEndpoints | PlainMessage<NodeDaemonEndpoints> | undefined): boolean {
    return proto2.util.equals(NodeDaemonEndpoints, a, b);
  }
}

/**
 * NodeFeatures describes the set of features implemented by the CRI implementation.
 * The features contained in the NodeFeatures should depend only on the cri implementation
 * independent of runtime handlers.
 *
 * @generated from message k8s.io.api.core.v1.NodeFeatures
 */
export class NodeFeatures extends Message<NodeFeatures> {
  /**
   * SupplementalGroupsPolicy is set to true if the runtime supports SupplementalGroupsPolicy and ContainerUser.
   * +optional
   *
   * @generated from field: optional bool supplementalGroupsPolicy = 1;
   */
  supplementalGroupsPolicy?: boolean;

  constructor(data?: PartialMessage<NodeFeatures>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeFeatures";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "supplementalGroupsPolicy", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeFeatures {
    return new NodeFeatures().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeFeatures {
    return new NodeFeatures().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeFeatures {
    return new NodeFeatures().fromJsonString(jsonString, options);
  }

  static equals(a: NodeFeatures | PlainMessage<NodeFeatures> | undefined, b: NodeFeatures | PlainMessage<NodeFeatures> | undefined): boolean {
    return proto2.util.equals(NodeFeatures, a, b);
  }
}

/**
 * NodeList is the whole list of all Nodes which have been registered with master.
 *
 * @generated from message k8s.io.api.core.v1.NodeList
 */
export class NodeList extends Message<NodeList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of nodes
   *
   * @generated from field: repeated k8s.io.api.core.v1.Node items = 2;
   */
  items: Node[] = [];

  constructor(data?: PartialMessage<NodeList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Node, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeList {
    return new NodeList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeList {
    return new NodeList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeList {
    return new NodeList().fromJsonString(jsonString, options);
  }

  static equals(a: NodeList | PlainMessage<NodeList> | undefined, b: NodeList | PlainMessage<NodeList> | undefined): boolean {
    return proto2.util.equals(NodeList, a, b);
  }
}

/**
 * NodeProxyOptions is the query options to a Node's proxy call.
 *
 * @generated from message k8s.io.api.core.v1.NodeProxyOptions
 */
export class NodeProxyOptions extends Message<NodeProxyOptions> {
  /**
   * Path is the URL path to use for the current proxy request to node.
   * +optional
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  constructor(data?: PartialMessage<NodeProxyOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeProxyOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeProxyOptions {
    return new NodeProxyOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeProxyOptions {
    return new NodeProxyOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeProxyOptions {
    return new NodeProxyOptions().fromJsonString(jsonString, options);
  }

  static equals(a: NodeProxyOptions | PlainMessage<NodeProxyOptions> | undefined, b: NodeProxyOptions | PlainMessage<NodeProxyOptions> | undefined): boolean {
    return proto2.util.equals(NodeProxyOptions, a, b);
  }
}

/**
 * NodeRuntimeHandler is a set of runtime handler information.
 *
 * @generated from message k8s.io.api.core.v1.NodeRuntimeHandler
 */
export class NodeRuntimeHandler extends Message<NodeRuntimeHandler> {
  /**
   * Runtime handler name.
   * Empty for the default runtime handler.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Supported features.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeRuntimeHandlerFeatures features = 2;
   */
  features?: NodeRuntimeHandlerFeatures;

  constructor(data?: PartialMessage<NodeRuntimeHandler>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeRuntimeHandler";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "features", kind: "message", T: NodeRuntimeHandlerFeatures, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeRuntimeHandler {
    return new NodeRuntimeHandler().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeRuntimeHandler {
    return new NodeRuntimeHandler().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeRuntimeHandler {
    return new NodeRuntimeHandler().fromJsonString(jsonString, options);
  }

  static equals(a: NodeRuntimeHandler | PlainMessage<NodeRuntimeHandler> | undefined, b: NodeRuntimeHandler | PlainMessage<NodeRuntimeHandler> | undefined): boolean {
    return proto2.util.equals(NodeRuntimeHandler, a, b);
  }
}

/**
 * NodeRuntimeHandlerFeatures is a set of features implemented by the runtime handler.
 *
 * @generated from message k8s.io.api.core.v1.NodeRuntimeHandlerFeatures
 */
export class NodeRuntimeHandlerFeatures extends Message<NodeRuntimeHandlerFeatures> {
  /**
   * RecursiveReadOnlyMounts is set to true if the runtime handler supports RecursiveReadOnlyMounts.
   * +featureGate=RecursiveReadOnlyMounts
   * +optional
   *
   * @generated from field: optional bool recursiveReadOnlyMounts = 1;
   */
  recursiveReadOnlyMounts?: boolean;

  /**
   * UserNamespaces is set to true if the runtime handler supports UserNamespaces, including for volumes.
   * +featureGate=UserNamespacesSupport
   * +optional
   *
   * @generated from field: optional bool userNamespaces = 2;
   */
  userNamespaces?: boolean;

  constructor(data?: PartialMessage<NodeRuntimeHandlerFeatures>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeRuntimeHandlerFeatures";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "recursiveReadOnlyMounts", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "userNamespaces", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeRuntimeHandlerFeatures {
    return new NodeRuntimeHandlerFeatures().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeRuntimeHandlerFeatures {
    return new NodeRuntimeHandlerFeatures().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeRuntimeHandlerFeatures {
    return new NodeRuntimeHandlerFeatures().fromJsonString(jsonString, options);
  }

  static equals(a: NodeRuntimeHandlerFeatures | PlainMessage<NodeRuntimeHandlerFeatures> | undefined, b: NodeRuntimeHandlerFeatures | PlainMessage<NodeRuntimeHandlerFeatures> | undefined): boolean {
    return proto2.util.equals(NodeRuntimeHandlerFeatures, a, b);
  }
}

/**
 * A node selector represents the union of the results of one or more label queries
 * over a set of nodes; that is, it represents the OR of the selectors represented
 * by the node selector terms.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.NodeSelector
 */
export class NodeSelector extends Message<NodeSelector> {
  /**
   * Required. A list of node selector terms. The terms are ORed.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeSelectorTerm nodeSelectorTerms = 1;
   */
  nodeSelectorTerms: NodeSelectorTerm[] = [];

  constructor(data?: PartialMessage<NodeSelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeSelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "nodeSelectorTerms", kind: "message", T: NodeSelectorTerm, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeSelector {
    return new NodeSelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeSelector {
    return new NodeSelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeSelector {
    return new NodeSelector().fromJsonString(jsonString, options);
  }

  static equals(a: NodeSelector | PlainMessage<NodeSelector> | undefined, b: NodeSelector | PlainMessage<NodeSelector> | undefined): boolean {
    return proto2.util.equals(NodeSelector, a, b);
  }
}

/**
 * A node selector requirement is a selector that contains values, a key, and an operator
 * that relates the key and values.
 *
 * @generated from message k8s.io.api.core.v1.NodeSelectorRequirement
 */
export class NodeSelectorRequirement extends Message<NodeSelectorRequirement> {
  /**
   * The label key that the selector applies to.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * Represents a key's relationship to a set of values.
   * Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * An array of string values. If the operator is In or NotIn,
   * the values array must be non-empty. If the operator is Exists or DoesNotExist,
   * the values array must be empty. If the operator is Gt or Lt, the values
   * array must have a single element, which will be interpreted as an integer.
   * This array is replaced during a strategic merge patch.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string values = 3;
   */
  values: string[] = [];

  constructor(data?: PartialMessage<NodeSelectorRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeSelectorRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "values", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeSelectorRequirement {
    return new NodeSelectorRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeSelectorRequirement {
    return new NodeSelectorRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeSelectorRequirement {
    return new NodeSelectorRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: NodeSelectorRequirement | PlainMessage<NodeSelectorRequirement> | undefined, b: NodeSelectorRequirement | PlainMessage<NodeSelectorRequirement> | undefined): boolean {
    return proto2.util.equals(NodeSelectorRequirement, a, b);
  }
}

/**
 * A null or empty node selector term matches no objects. The requirements of
 * them are ANDed.
 * The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.NodeSelectorTerm
 */
export class NodeSelectorTerm extends Message<NodeSelectorTerm> {
  /**
   * A list of node selector requirements by node's labels.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeSelectorRequirement matchExpressions = 1;
   */
  matchExpressions: NodeSelectorRequirement[] = [];

  /**
   * A list of node selector requirements by node's fields.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeSelectorRequirement matchFields = 2;
   */
  matchFields: NodeSelectorRequirement[] = [];

  constructor(data?: PartialMessage<NodeSelectorTerm>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeSelectorTerm";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "matchExpressions", kind: "message", T: NodeSelectorRequirement, repeated: true },
    { no: 2, name: "matchFields", kind: "message", T: NodeSelectorRequirement, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeSelectorTerm {
    return new NodeSelectorTerm().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeSelectorTerm {
    return new NodeSelectorTerm().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeSelectorTerm {
    return new NodeSelectorTerm().fromJsonString(jsonString, options);
  }

  static equals(a: NodeSelectorTerm | PlainMessage<NodeSelectorTerm> | undefined, b: NodeSelectorTerm | PlainMessage<NodeSelectorTerm> | undefined): boolean {
    return proto2.util.equals(NodeSelectorTerm, a, b);
  }
}

/**
 * NodeSpec describes the attributes that a node is created with.
 *
 * @generated from message k8s.io.api.core.v1.NodeSpec
 */
export class NodeSpec extends Message<NodeSpec> {
  /**
   * PodCIDR represents the pod IP range assigned to the node.
   * +optional
   *
   * @generated from field: optional string podCIDR = 1;
   */
  podCIDR?: string;

  /**
   * podCIDRs represents the IP ranges assigned to the node for usage by Pods on that node. If this
   * field is specified, the 0th entry must match the podCIDR field. It may contain at most 1 value for
   * each of IPv4 and IPv6.
   * +optional
   * +patchStrategy=merge
   * +listType=set
   *
   * @generated from field: repeated string podCIDRs = 7;
   */
  podCIDRs: string[] = [];

  /**
   * ID of the node assigned by the cloud provider in the format: <ProviderName>://<ProviderSpecificNodeID>
   * +optional
   *
   * @generated from field: optional string providerID = 3;
   */
  providerID?: string;

  /**
   * Unschedulable controls node schedulability of new pods. By default, node is schedulable.
   * More info: https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
   * +optional
   *
   * @generated from field: optional bool unschedulable = 4;
   */
  unschedulable?: boolean;

  /**
   * If specified, the node's taints.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.Taint taints = 5;
   */
  taints: Taint[] = [];

  /**
   * Deprecated: Previously used to specify the source of the node's configuration for the DynamicKubeletConfig feature. This feature is removed.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeConfigSource configSource = 6;
   */
  configSource?: NodeConfigSource;

  /**
   * Deprecated. Not all kubelets will set this field. Remove field after 1.13.
   * see: https://issues.k8s.io/61966
   * +optional
   *
   * @generated from field: optional string externalID = 2;
   */
  externalID?: string;

  constructor(data?: PartialMessage<NodeSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "podCIDR", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "podCIDRs", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "providerID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "unschedulable", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "taints", kind: "message", T: Taint, repeated: true },
    { no: 6, name: "configSource", kind: "message", T: NodeConfigSource, opt: true },
    { no: 2, name: "externalID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeSpec {
    return new NodeSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeSpec {
    return new NodeSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeSpec {
    return new NodeSpec().fromJsonString(jsonString, options);
  }

  static equals(a: NodeSpec | PlainMessage<NodeSpec> | undefined, b: NodeSpec | PlainMessage<NodeSpec> | undefined): boolean {
    return proto2.util.equals(NodeSpec, a, b);
  }
}

/**
 * NodeStatus is information about the current status of a node.
 *
 * @generated from message k8s.io.api.core.v1.NodeStatus
 */
export class NodeStatus extends Message<NodeStatus> {
  /**
   * Capacity represents the total resources of a node.
   * More info: https://kubernetes.io/docs/reference/node/node-status/#capacity
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> capacity = 1;
   */
  capacity: { [key: string]: Quantity } = {};

  /**
   * Allocatable represents the resources of a node that are available for scheduling.
   * Defaults to Capacity.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> allocatable = 2;
   */
  allocatable: { [key: string]: Quantity } = {};

  /**
   * NodePhase is the recently observed lifecycle phase of the node.
   * More info: https://kubernetes.io/docs/concepts/nodes/node/#phase
   * The field is never populated, and now is deprecated.
   * +optional
   *
   * @generated from field: optional string phase = 3;
   */
  phase?: string;

  /**
   * Conditions is an array of current observed node conditions.
   * More info: https://kubernetes.io/docs/concepts/nodes/node/#condition
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeCondition conditions = 4;
   */
  conditions: NodeCondition[] = [];

  /**
   * List of addresses reachable to the node.
   * Queried from cloud provider, if available.
   * More info: https://kubernetes.io/docs/concepts/nodes/node/#addresses
   * Note: This field is declared as mergeable, but the merge key is not sufficiently
   * unique, which can cause data corruption when it is merged. Callers should instead
   * use a full-replacement patch. See https://pr.k8s.io/79391 for an example.
   * Consumers should assume that addresses can change during the
   * lifetime of a Node. However, there are some exceptions where this may not
   * be possible, such as Pods that inherit a Node's address in its own status or
   * consumers of the downward API (status.hostIP).
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeAddress addresses = 5;
   */
  addresses: NodeAddress[] = [];

  /**
   * Endpoints of daemons running on the Node.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeDaemonEndpoints daemonEndpoints = 6;
   */
  daemonEndpoints?: NodeDaemonEndpoints;

  /**
   * Set of ids/uuids to uniquely identify the node.
   * More info: https://kubernetes.io/docs/concepts/nodes/node/#info
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeSystemInfo nodeInfo = 7;
   */
  nodeInfo?: NodeSystemInfo;

  /**
   * List of container images on this node
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerImage images = 8;
   */
  images: ContainerImage[] = [];

  /**
   * List of attachable volumes in use (mounted) by the node.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string volumesInUse = 9;
   */
  volumesInUse: string[] = [];

  /**
   * List of volumes that are attached to the node.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.AttachedVolume volumesAttached = 10;
   */
  volumesAttached: AttachedVolume[] = [];

  /**
   * Status of the config assigned to the node via the dynamic Kubelet config feature.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeConfigStatus config = 11;
   */
  config?: NodeConfigStatus;

  /**
   * The available runtime handlers.
   * +featureGate=RecursiveReadOnlyMounts
   * +featureGate=UserNamespacesSupport
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.NodeRuntimeHandler runtimeHandlers = 12;
   */
  runtimeHandlers: NodeRuntimeHandler[] = [];

  /**
   * Features describes the set of features implemented by the CRI implementation.
   * +featureGate=SupplementalGroupsPolicy
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeFeatures features = 13;
   */
  features?: NodeFeatures;

  constructor(data?: PartialMessage<NodeStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "capacity", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "allocatable", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 3, name: "phase", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "conditions", kind: "message", T: NodeCondition, repeated: true },
    { no: 5, name: "addresses", kind: "message", T: NodeAddress, repeated: true },
    { no: 6, name: "daemonEndpoints", kind: "message", T: NodeDaemonEndpoints, opt: true },
    { no: 7, name: "nodeInfo", kind: "message", T: NodeSystemInfo, opt: true },
    { no: 8, name: "images", kind: "message", T: ContainerImage, repeated: true },
    { no: 9, name: "volumesInUse", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 10, name: "volumesAttached", kind: "message", T: AttachedVolume, repeated: true },
    { no: 11, name: "config", kind: "message", T: NodeConfigStatus, opt: true },
    { no: 12, name: "runtimeHandlers", kind: "message", T: NodeRuntimeHandler, repeated: true },
    { no: 13, name: "features", kind: "message", T: NodeFeatures, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeStatus {
    return new NodeStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeStatus {
    return new NodeStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeStatus {
    return new NodeStatus().fromJsonString(jsonString, options);
  }

  static equals(a: NodeStatus | PlainMessage<NodeStatus> | undefined, b: NodeStatus | PlainMessage<NodeStatus> | undefined): boolean {
    return proto2.util.equals(NodeStatus, a, b);
  }
}

/**
 * NodeSystemInfo is a set of ids/uuids to uniquely identify the node.
 *
 * @generated from message k8s.io.api.core.v1.NodeSystemInfo
 */
export class NodeSystemInfo extends Message<NodeSystemInfo> {
  /**
   * MachineID reported by the node. For unique machine identification
   * in the cluster this field is preferred. Learn more from man(5)
   * machine-id: http://man7.org/linux/man-pages/man5/machine-id.5.html
   *
   * @generated from field: optional string machineID = 1;
   */
  machineID?: string;

  /**
   * SystemUUID reported by the node. For unique machine identification
   * MachineID is preferred. This field is specific to Red Hat hosts
   * https://access.redhat.com/documentation/en-us/red_hat_subscription_management/1/html/rhsm/uuid
   *
   * @generated from field: optional string systemUUID = 2;
   */
  systemUUID?: string;

  /**
   * Boot ID reported by the node.
   *
   * @generated from field: optional string bootID = 3;
   */
  bootID?: string;

  /**
   * Kernel Version reported by the node from 'uname -r' (e.g. 3.16.0-0.bpo.4-amd64).
   *
   * @generated from field: optional string kernelVersion = 4;
   */
  kernelVersion?: string;

  /**
   * OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7 (wheezy)).
   *
   * @generated from field: optional string osImage = 5;
   */
  osImage?: string;

  /**
   * ContainerRuntime Version reported by the node through runtime remote API (e.g. containerd://1.4.2).
   *
   * @generated from field: optional string containerRuntimeVersion = 6;
   */
  containerRuntimeVersion?: string;

  /**
   * Kubelet Version reported by the node.
   *
   * @generated from field: optional string kubeletVersion = 7;
   */
  kubeletVersion?: string;

  /**
   * Deprecated: KubeProxy Version reported by the node.
   *
   * @generated from field: optional string kubeProxyVersion = 8;
   */
  kubeProxyVersion?: string;

  /**
   * The Operating System reported by the node
   *
   * @generated from field: optional string operatingSystem = 9;
   */
  operatingSystem?: string;

  /**
   * The Architecture reported by the node
   *
   * @generated from field: optional string architecture = 10;
   */
  architecture?: string;

  constructor(data?: PartialMessage<NodeSystemInfo>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.NodeSystemInfo";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "machineID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "systemUUID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "bootID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "kernelVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "osImage", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "containerRuntimeVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "kubeletVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "kubeProxyVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "operatingSystem", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "architecture", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): NodeSystemInfo {
    return new NodeSystemInfo().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): NodeSystemInfo {
    return new NodeSystemInfo().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): NodeSystemInfo {
    return new NodeSystemInfo().fromJsonString(jsonString, options);
  }

  static equals(a: NodeSystemInfo | PlainMessage<NodeSystemInfo> | undefined, b: NodeSystemInfo | PlainMessage<NodeSystemInfo> | undefined): boolean {
    return proto2.util.equals(NodeSystemInfo, a, b);
  }
}

/**
 * ObjectFieldSelector selects an APIVersioned field of an object.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.ObjectFieldSelector
 */
export class ObjectFieldSelector extends Message<ObjectFieldSelector> {
  /**
   * Version of the schema the FieldPath is written in terms of, defaults to "v1".
   * +optional
   *
   * @generated from field: optional string apiVersion = 1;
   */
  apiVersion?: string;

  /**
   * Path of the field to select in the specified API version.
   *
   * @generated from field: optional string fieldPath = 2;
   */
  fieldPath?: string;

  constructor(data?: PartialMessage<ObjectFieldSelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ObjectFieldSelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "apiVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fieldPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ObjectFieldSelector {
    return new ObjectFieldSelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ObjectFieldSelector {
    return new ObjectFieldSelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ObjectFieldSelector {
    return new ObjectFieldSelector().fromJsonString(jsonString, options);
  }

  static equals(a: ObjectFieldSelector | PlainMessage<ObjectFieldSelector> | undefined, b: ObjectFieldSelector | PlainMessage<ObjectFieldSelector> | undefined): boolean {
    return proto2.util.equals(ObjectFieldSelector, a, b);
  }
}

/**
 * ObjectReference contains enough information to let you inspect or modify the referred object.
 * ---
 * New uses of this type are discouraged because of difficulty describing its usage when embedded in APIs.
 *  1. Ignored fields.  It includes many fields which are not generally honored.  For instance, ResourceVersion and FieldPath are both very rarely valid in actual usage.
 *  2. Invalid usage help.  It is impossible to add specific help for individual usage.  In most embedded usages, there are particular
 *     restrictions like, "must refer only to types A and B" or "UID not honored" or "name must be restricted".
 *     Those cannot be well described when embedded.
 *  3. Inconsistent validation.  Because the usages are different, the validation rules are different by usage, which makes it hard for users to predict what will happen.
 *  4. The fields are both imprecise and overly precise.  Kind is not a precise mapping to a URL. This can produce ambiguity
 *     during interpretation and require a REST mapping.  In most cases, the dependency is on the group,resource tuple
 *     and the version of the actual struct is irrelevant.
 *  5. We cannot easily change it.  Because this type is embedded in many locations, updates to this type
 *     will affect numerous schemas.  Don't make new APIs embed an underspecified API type they do not control.
 *
 * Instead of using this type, create a locally provided and used type that is well-focused on your reference.
 * For example, ServiceReferences for admission registration: https://github.com/kubernetes/api/blob/release-1.17/admissionregistration/v1/types.go#L533 .
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.ObjectReference
 */
export class ObjectReference extends Message<ObjectReference> {
  /**
   * Kind of the referent.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional string kind = 1;
   */
  kind?: string;

  /**
   * Namespace of the referent.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
   * +optional
   *
   * @generated from field: optional string namespace = 2;
   */
  namespace?: string;

  /**
   * Name of the referent.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
   * +optional
   *
   * @generated from field: optional string name = 3;
   */
  name?: string;

  /**
   * UID of the referent.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
   * +optional
   *
   * @generated from field: optional string uid = 4;
   */
  uid?: string;

  /**
   * API version of the referent.
   * +optional
   *
   * @generated from field: optional string apiVersion = 5;
   */
  apiVersion?: string;

  /**
   * Specific resourceVersion to which this reference is made, if any.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
   * +optional
   *
   * @generated from field: optional string resourceVersion = 6;
   */
  resourceVersion?: string;

  /**
   * If referring to a piece of an object instead of an entire object, this string
   * should contain a valid JSON/Go field access statement, such as desiredState.manifest.containers[2].
   * For example, if the object reference is to a container within a pod, this would take on a value like:
   * "spec.containers{name}" (where "name" refers to the name of the container that triggered
   * the event) or if no container name is specified "spec.containers[2]" (container with
   * index 2 in this pod). This syntax is chosen only to have some well-defined way of
   * referencing a part of an object.
   * TODO: this design is not final and this field is subject to change in the future.
   * +optional
   *
   * @generated from field: optional string fieldPath = 7;
   */
  fieldPath?: string;

  constructor(data?: PartialMessage<ObjectReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ObjectReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "apiVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "fieldPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ObjectReference {
    return new ObjectReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ObjectReference {
    return new ObjectReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ObjectReference {
    return new ObjectReference().fromJsonString(jsonString, options);
  }

  static equals(a: ObjectReference | PlainMessage<ObjectReference> | undefined, b: ObjectReference | PlainMessage<ObjectReference> | undefined): boolean {
    return proto2.util.equals(ObjectReference, a, b);
  }
}

/**
 * PersistentVolume (PV) is a storage resource provisioned by an administrator.
 * It is analogous to a node.
 * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolume
 */
export class PersistentVolume extends Message<PersistentVolume> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * spec defines a specification of a persistent volume owned by the cluster.
   * Provisioned by an administrator.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeSpec spec = 2;
   */
  spec?: PersistentVolumeSpec;

  /**
   * status represents the current information/status for the persistent volume.
   * Populated by the system.
   * Read-only.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeStatus status = 3;
   */
  status?: PersistentVolumeStatus;

  constructor(data?: PartialMessage<PersistentVolume>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolume";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: PersistentVolumeSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: PersistentVolumeStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolume {
    return new PersistentVolume().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolume {
    return new PersistentVolume().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolume {
    return new PersistentVolume().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolume | PlainMessage<PersistentVolume> | undefined, b: PersistentVolume | PlainMessage<PersistentVolume> | undefined): boolean {
    return proto2.util.equals(PersistentVolume, a, b);
  }
}

/**
 * PersistentVolumeClaim is a user's request for and claim to a persistent volume
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaim
 */
export class PersistentVolumeClaim extends Message<PersistentVolumeClaim> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * spec defines the desired characteristics of a volume requested by a pod author.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeClaimSpec spec = 2;
   */
  spec?: PersistentVolumeClaimSpec;

  /**
   * status represents the current information/status of a persistent volume claim.
   * Read-only.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeClaimStatus status = 3;
   */
  status?: PersistentVolumeClaimStatus;

  constructor(data?: PartialMessage<PersistentVolumeClaim>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaim";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: PersistentVolumeClaimSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: PersistentVolumeClaimStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaim {
    return new PersistentVolumeClaim().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaim {
    return new PersistentVolumeClaim().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaim {
    return new PersistentVolumeClaim().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaim | PlainMessage<PersistentVolumeClaim> | undefined, b: PersistentVolumeClaim | PlainMessage<PersistentVolumeClaim> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaim, a, b);
  }
}

/**
 * PersistentVolumeClaimCondition contains details about state of pvc
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimCondition
 */
export class PersistentVolumeClaimCondition extends Message<PersistentVolumeClaimCondition> {
  /**
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * lastProbeTime is the time we probed the condition.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastProbeTime = 3;
   */
  lastProbeTime?: Time;

  /**
   * lastTransitionTime is the time the condition transitioned from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * reason is a unique, this should be a short, machine understandable string that gives the reason
   * for condition's last transition. If it reports "Resizing" that means the underlying
   * persistent volume is being resized.
   * +optional
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * message is the human-readable message indicating details about last transition.
   * +optional
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<PersistentVolumeClaimCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastProbeTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimCondition {
    return new PersistentVolumeClaimCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimCondition {
    return new PersistentVolumeClaimCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimCondition {
    return new PersistentVolumeClaimCondition().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimCondition | PlainMessage<PersistentVolumeClaimCondition> | undefined, b: PersistentVolumeClaimCondition | PlainMessage<PersistentVolumeClaimCondition> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimCondition, a, b);
  }
}

/**
 * PersistentVolumeClaimList is a list of PersistentVolumeClaim items.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimList
 */
export class PersistentVolumeClaimList extends Message<PersistentVolumeClaimList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items is a list of persistent volume claims.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
   *
   * @generated from field: repeated k8s.io.api.core.v1.PersistentVolumeClaim items = 2;
   */
  items: PersistentVolumeClaim[] = [];

  constructor(data?: PartialMessage<PersistentVolumeClaimList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: PersistentVolumeClaim, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimList {
    return new PersistentVolumeClaimList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimList {
    return new PersistentVolumeClaimList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimList {
    return new PersistentVolumeClaimList().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimList | PlainMessage<PersistentVolumeClaimList> | undefined, b: PersistentVolumeClaimList | PlainMessage<PersistentVolumeClaimList> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimList, a, b);
  }
}

/**
 * PersistentVolumeClaimSpec describes the common attributes of storage devices
 * and allows a Source for provider-specific attributes
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimSpec
 */
export class PersistentVolumeClaimSpec extends Message<PersistentVolumeClaimSpec> {
  /**
   * accessModes contains the desired access modes the volume should have.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string accessModes = 1;
   */
  accessModes: string[] = [];

  /**
   * selector is a label query over volumes to consider for binding.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 4;
   */
  selector?: LabelSelector;

  /**
   * resources represents the minimum resources the volume should have.
   * If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements
   * that are lower than previous value but must still be higher than capacity recorded in the
   * status field of the claim.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.VolumeResourceRequirements resources = 2;
   */
  resources?: VolumeResourceRequirements;

  /**
   * volumeName is the binding reference to the PersistentVolume backing this claim.
   * +optional
   *
   * @generated from field: optional string volumeName = 3;
   */
  volumeName?: string;

  /**
   * storageClassName is the name of the StorageClass required by the claim.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
   * +optional
   *
   * @generated from field: optional string storageClassName = 5;
   */
  storageClassName?: string;

  /**
   * volumeMode defines what type of volume is required by the claim.
   * Value of Filesystem is implied when not included in claim spec.
   * +optional
   *
   * @generated from field: optional string volumeMode = 6;
   */
  volumeMode?: string;

  /**
   * dataSource field can be used to specify either:
   * * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot)
   * * An existing PVC (PersistentVolumeClaim)
   * If the provisioner or an external controller can support the specified data source,
   * it will create a new volume based on the contents of the specified data source.
   * When the AnyVolumeDataSource feature gate is enabled, dataSource contents will be copied to dataSourceRef,
   * and dataSourceRef contents will be copied to dataSource when dataSourceRef.namespace is not specified.
   * If the namespace is specified, then dataSourceRef will not be copied to dataSource.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.TypedLocalObjectReference dataSource = 7;
   */
  dataSource?: TypedLocalObjectReference;

  /**
   * dataSourceRef specifies the object from which to populate the volume with data, if a non-empty
   * volume is desired. This may be any object from a non-empty API group (non
   * core object) or a PersistentVolumeClaim object.
   * When this field is specified, volume binding will only succeed if the type of
   * the specified object matches some installed volume populator or dynamic
   * provisioner.
   * This field will replace the functionality of the dataSource field and as such
   * if both fields are non-empty, they must have the same value. For backwards
   * compatibility, when namespace isn't specified in dataSourceRef,
   * both fields (dataSource and dataSourceRef) will be set to the same
   * value automatically if one of them is empty and the other is non-empty.
   * When namespace is specified in dataSourceRef,
   * dataSource isn't set to the same value and must be empty.
   * There are three important differences between dataSource and dataSourceRef:
   * * While dataSource only allows two specific types of objects, dataSourceRef
   *   allows any non-core object, as well as PersistentVolumeClaim objects.
   * * While dataSource ignores disallowed values (dropping them), dataSourceRef
   *   preserves all values, and generates an error if a disallowed value is
   *   specified.
   * * While dataSource only allows local objects, dataSourceRef allows objects
   *   in any namespaces.
   * (Beta) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
   * (Alpha) Using the namespace field of dataSourceRef requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.TypedObjectReference dataSourceRef = 8;
   */
  dataSourceRef?: TypedObjectReference;

  /**
   * volumeAttributesClassName may be used to set the VolumeAttributesClass used by this claim.
   * If specified, the CSI driver will create or update the volume with the attributes defined
   * in the corresponding VolumeAttributesClass. This has a different purpose than storageClassName,
   * it can be changed after the claim is created. An empty string value means that no VolumeAttributesClass
   * will be applied to the claim but it's not allowed to reset this field to empty string once it is set.
   * If unspecified and the PersistentVolumeClaim is unbound, the default VolumeAttributesClass
   * will be set by the persistentvolume controller if it exists.
   * If the resource referred to by volumeAttributesClass does not exist, this PersistentVolumeClaim will be
   * set to a Pending state, as reflected by the modifyVolumeStatus field, until such as a resource
   * exists.
   * More info: https://kubernetes.io/docs/concepts/storage/volume-attributes-classes/
   * (Beta) Using this field requires the VolumeAttributesClass feature gate to be enabled (off by default).
   * +featureGate=VolumeAttributesClass
   * +optional
   *
   * @generated from field: optional string volumeAttributesClassName = 9;
   */
  volumeAttributesClassName?: string;

  constructor(data?: PartialMessage<PersistentVolumeClaimSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "accessModes", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "selector", kind: "message", T: LabelSelector, opt: true },
    { no: 2, name: "resources", kind: "message", T: VolumeResourceRequirements, opt: true },
    { no: 3, name: "volumeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "storageClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "volumeMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "dataSource", kind: "message", T: TypedLocalObjectReference, opt: true },
    { no: 8, name: "dataSourceRef", kind: "message", T: TypedObjectReference, opt: true },
    { no: 9, name: "volumeAttributesClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimSpec {
    return new PersistentVolumeClaimSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimSpec {
    return new PersistentVolumeClaimSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimSpec {
    return new PersistentVolumeClaimSpec().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimSpec | PlainMessage<PersistentVolumeClaimSpec> | undefined, b: PersistentVolumeClaimSpec | PlainMessage<PersistentVolumeClaimSpec> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimSpec, a, b);
  }
}

/**
 * PersistentVolumeClaimStatus is the current status of a persistent volume claim.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimStatus
 */
export class PersistentVolumeClaimStatus extends Message<PersistentVolumeClaimStatus> {
  /**
   * phase represents the current phase of PersistentVolumeClaim.
   * +optional
   *
   * @generated from field: optional string phase = 1;
   */
  phase?: string;

  /**
   * accessModes contains the actual access modes the volume backing the PVC has.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string accessModes = 2;
   */
  accessModes: string[] = [];

  /**
   * capacity represents the actual resources of the underlying volume.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> capacity = 3;
   */
  capacity: { [key: string]: Quantity } = {};

  /**
   * conditions is the current Condition of persistent volume claim. If underlying persistent volume is being
   * resized then the Condition will be set to 'Resizing'.
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.PersistentVolumeClaimCondition conditions = 4;
   */
  conditions: PersistentVolumeClaimCondition[] = [];

  /**
   * allocatedResources tracks the resources allocated to a PVC including its capacity.
   * Key names follow standard Kubernetes label syntax. Valid values are either:
   * 	* Un-prefixed keys:
   * 		- storage - the capacity of the volume.
   * 	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
   * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered
   * reserved and hence may not be used.
   *
   * Capacity reported here may be larger than the actual capacity when a volume expansion operation
   * is requested.
   * For storage quota, the larger value from allocatedResources and PVC.spec.resources is used.
   * If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation.
   * If a volume expansion capacity request is lowered, allocatedResources is only
   * lowered if there are no expansion operations in progress and if the actual volume capacity
   * is equal or lower than the requested capacity.
   *
   * A controller that receives PVC update with previously unknown resourceName
   * should ignore the update for the purpose it was designed. For example - a controller that
   * only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid
   * resources associated with PVC.
   *
   * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
   * +featureGate=RecoverVolumeExpansionFailure
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> allocatedResources = 5;
   */
  allocatedResources: { [key: string]: Quantity } = {};

  /**
   * allocatedResourceStatuses stores status of resource being resized for the given PVC.
   * Key names follow standard Kubernetes label syntax. Valid values are either:
   * 	* Un-prefixed keys:
   * 		- storage - the capacity of the volume.
   * 	* Custom resources must use implementation-defined prefixed names such as "example.com/my-custom-resource"
   * Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered
   * reserved and hence may not be used.
   *
   * ClaimResourceStatus can be in any of following states:
   * 	- ControllerResizeInProgress:
   * 		State set when resize controller starts resizing the volume in control-plane.
   * 	- ControllerResizeFailed:
   * 		State set when resize has failed in resize controller with a terminal error.
   * 	- NodeResizePending:
   * 		State set when resize controller has finished resizing the volume but further resizing of
   * 		volume is needed on the node.
   * 	- NodeResizeInProgress:
   * 		State set when kubelet starts resizing the volume.
   * 	- NodeResizeFailed:
   * 		State set when resizing has failed in kubelet with a terminal error. Transient errors don't set
   * 		NodeResizeFailed.
   * For example: if expanding a PVC for more capacity - this field can be one of the following states:
   * 	- pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeInProgress"
   *      - pvc.status.allocatedResourceStatus['storage'] = "ControllerResizeFailed"
   *      - pvc.status.allocatedResourceStatus['storage'] = "NodeResizePending"
   *      - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeInProgress"
   *      - pvc.status.allocatedResourceStatus['storage'] = "NodeResizeFailed"
   * When this field is not set, it means that no resize operation is in progress for the given PVC.
   *
   * A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus
   * should ignore the update for the purpose it was designed. For example - a controller that
   * only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid
   * resources associated with PVC.
   *
   * This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.
   * +featureGate=RecoverVolumeExpansionFailure
   * +mapType=granular
   * +optional
   *
   * @generated from field: map<string, string> allocatedResourceStatuses = 7;
   */
  allocatedResourceStatuses: { [key: string]: string } = {};

  /**
   * currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using.
   * When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim
   * This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
   * +featureGate=VolumeAttributesClass
   * +optional
   *
   * @generated from field: optional string currentVolumeAttributesClassName = 8;
   */
  currentVolumeAttributesClassName?: string;

  /**
   * ModifyVolumeStatus represents the status object of ControllerModifyVolume operation.
   * When this is unset, there is no ModifyVolume operation being attempted.
   * This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
   * +featureGate=VolumeAttributesClass
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ModifyVolumeStatus modifyVolumeStatus = 9;
   */
  modifyVolumeStatus?: ModifyVolumeStatus;

  constructor(data?: PartialMessage<PersistentVolumeClaimStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "phase", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "accessModes", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "capacity", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 4, name: "conditions", kind: "message", T: PersistentVolumeClaimCondition, repeated: true },
    { no: 5, name: "allocatedResources", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 7, name: "allocatedResourceStatuses", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 8, name: "currentVolumeAttributesClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "modifyVolumeStatus", kind: "message", T: ModifyVolumeStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimStatus {
    return new PersistentVolumeClaimStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimStatus {
    return new PersistentVolumeClaimStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimStatus {
    return new PersistentVolumeClaimStatus().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimStatus | PlainMessage<PersistentVolumeClaimStatus> | undefined, b: PersistentVolumeClaimStatus | PlainMessage<PersistentVolumeClaimStatus> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimStatus, a, b);
  }
}

/**
 * PersistentVolumeClaimTemplate is used to produce
 * PersistentVolumeClaim objects as part of an EphemeralVolumeSource.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimTemplate
 */
export class PersistentVolumeClaimTemplate extends Message<PersistentVolumeClaimTemplate> {
  /**
   * May contain labels and annotations that will be copied into the PVC
   * when creating it. No other fields are allowed and will be rejected during
   * validation.
   *
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * The specification for the PersistentVolumeClaim. The entire content is
   * copied unchanged into the PVC that gets created from this
   * template. The same fields as in a PersistentVolumeClaim
   * are also valid here.
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeClaimSpec spec = 2;
   */
  spec?: PersistentVolumeClaimSpec;

  constructor(data?: PartialMessage<PersistentVolumeClaimTemplate>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimTemplate";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: PersistentVolumeClaimSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimTemplate {
    return new PersistentVolumeClaimTemplate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimTemplate {
    return new PersistentVolumeClaimTemplate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimTemplate {
    return new PersistentVolumeClaimTemplate().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimTemplate | PlainMessage<PersistentVolumeClaimTemplate> | undefined, b: PersistentVolumeClaimTemplate | PlainMessage<PersistentVolumeClaimTemplate> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimTemplate, a, b);
  }
}

/**
 * PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace.
 * This volume finds the bound PV and mounts that volume for the pod. A
 * PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another
 * type of volume that is owned by someone else (the system).
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeClaimVolumeSource
 */
export class PersistentVolumeClaimVolumeSource extends Message<PersistentVolumeClaimVolumeSource> {
  /**
   * claimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
   *
   * @generated from field: optional string claimName = 1;
   */
  claimName?: string;

  /**
   * readOnly Will force the ReadOnly setting in VolumeMounts.
   * Default false.
   * +optional
   *
   * @generated from field: optional bool readOnly = 2;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<PersistentVolumeClaimVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeClaimVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "claimName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeClaimVolumeSource {
    return new PersistentVolumeClaimVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeClaimVolumeSource {
    return new PersistentVolumeClaimVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeClaimVolumeSource {
    return new PersistentVolumeClaimVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeClaimVolumeSource | PlainMessage<PersistentVolumeClaimVolumeSource> | undefined, b: PersistentVolumeClaimVolumeSource | PlainMessage<PersistentVolumeClaimVolumeSource> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeClaimVolumeSource, a, b);
  }
}

/**
 * PersistentVolumeList is a list of PersistentVolume items.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeList
 */
export class PersistentVolumeList extends Message<PersistentVolumeList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items is a list of persistent volumes.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes
   *
   * @generated from field: repeated k8s.io.api.core.v1.PersistentVolume items = 2;
   */
  items: PersistentVolume[] = [];

  constructor(data?: PartialMessage<PersistentVolumeList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: PersistentVolume, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeList {
    return new PersistentVolumeList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeList {
    return new PersistentVolumeList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeList {
    return new PersistentVolumeList().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeList | PlainMessage<PersistentVolumeList> | undefined, b: PersistentVolumeList | PlainMessage<PersistentVolumeList> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeList, a, b);
  }
}

/**
 * PersistentVolumeSource is similar to VolumeSource but meant for the
 * administrator who creates PVs. Exactly one of its members must be set.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeSource
 */
export class PersistentVolumeSource extends Message<PersistentVolumeSource> {
  /**
   * gcePersistentDisk represents a GCE Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod. Provisioned by an admin.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GCEPersistentDiskVolumeSource gcePersistentDisk = 1;
   */
  gcePersistentDisk?: GCEPersistentDiskVolumeSource;

  /**
   * awsElasticBlockStore represents an AWS Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource awsElasticBlockStore = 2;
   */
  awsElasticBlockStore?: AWSElasticBlockStoreVolumeSource;

  /**
   * hostPath represents a directory on the host.
   * Provisioned by a developer or tester.
   * This is useful for single-node development and testing only!
   * On-host storage is not supported in any way and WILL NOT WORK in a multi-node cluster.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.HostPathVolumeSource hostPath = 3;
   */
  hostPath?: HostPathVolumeSource;

  /**
   * glusterfs represents a Glusterfs volume that is attached to a host and
   * exposed to the pod. Provisioned by an admin.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GlusterfsPersistentVolumeSource glusterfs = 4;
   */
  glusterfs?: GlusterfsPersistentVolumeSource;

  /**
   * nfs represents an NFS mount on the host. Provisioned by an admin.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NFSVolumeSource nfs = 5;
   */
  nfs?: NFSVolumeSource;

  /**
   * rbd represents a Rados Block Device mount on the host that shares a pod's lifetime.
   * More info: https://examples.k8s.io/volumes/rbd/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.RBDPersistentVolumeSource rbd = 6;
   */
  rbd?: RBDPersistentVolumeSource;

  /**
   * iscsi represents an ISCSI Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod. Provisioned by an admin.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ISCSIPersistentVolumeSource iscsi = 7;
   */
  iscsi?: ISCSIPersistentVolumeSource;

  /**
   * cinder represents a cinder volume attached and mounted on kubelets host machine.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CinderPersistentVolumeSource cinder = 8;
   */
  cinder?: CinderPersistentVolumeSource;

  /**
   * cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CephFSPersistentVolumeSource cephfs = 9;
   */
  cephfs?: CephFSPersistentVolumeSource;

  /**
   * fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FCVolumeSource fc = 10;
   */
  fc?: FCVolumeSource;

  /**
   * flocker represents a Flocker volume attached to a kubelet's host machine and exposed to the pod for its usage. This depends on the Flocker control service being running
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FlockerVolumeSource flocker = 11;
   */
  flocker?: FlockerVolumeSource;

  /**
   * flexVolume represents a generic volume resource that is
   * provisioned/attached using an exec based plugin.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FlexPersistentVolumeSource flexVolume = 12;
   */
  flexVolume?: FlexPersistentVolumeSource;

  /**
   * azureFile represents an Azure File Service mount on the host and bind mount to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AzureFilePersistentVolumeSource azureFile = 13;
   */
  azureFile?: AzureFilePersistentVolumeSource;

  /**
   * vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource vsphereVolume = 14;
   */
  vsphereVolume?: VsphereVirtualDiskVolumeSource;

  /**
   * quobyte represents a Quobyte mount on the host that shares a pod's lifetime
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.QuobyteVolumeSource quobyte = 15;
   */
  quobyte?: QuobyteVolumeSource;

  /**
   * azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AzureDiskVolumeSource azureDisk = 16;
   */
  azureDisk?: AzureDiskVolumeSource;

  /**
   * photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
   *
   * @generated from field: optional k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource photonPersistentDisk = 17;
   */
  photonPersistentDisk?: PhotonPersistentDiskVolumeSource;

  /**
   * portworxVolume represents a portworx volume attached and mounted on kubelets host machine
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PortworxVolumeSource portworxVolume = 18;
   */
  portworxVolume?: PortworxVolumeSource;

  /**
   * scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ScaleIOPersistentVolumeSource scaleIO = 19;
   */
  scaleIO?: ScaleIOPersistentVolumeSource;

  /**
   * local represents directly-attached storage with node affinity
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalVolumeSource local = 20;
   */
  local?: LocalVolumeSource;

  /**
   * storageOS represents a StorageOS volume that is attached to the kubelet's host machine and mounted into the pod
   * More info: https://examples.k8s.io/volumes/storageos/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.StorageOSPersistentVolumeSource storageos = 21;
   */
  storageos?: StorageOSPersistentVolumeSource;

  /**
   * csi represents storage that is handled by an external CSI driver (Beta feature).
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CSIPersistentVolumeSource csi = 22;
   */
  csi?: CSIPersistentVolumeSource;

  constructor(data?: PartialMessage<PersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "gcePersistentDisk", kind: "message", T: GCEPersistentDiskVolumeSource, opt: true },
    { no: 2, name: "awsElasticBlockStore", kind: "message", T: AWSElasticBlockStoreVolumeSource, opt: true },
    { no: 3, name: "hostPath", kind: "message", T: HostPathVolumeSource, opt: true },
    { no: 4, name: "glusterfs", kind: "message", T: GlusterfsPersistentVolumeSource, opt: true },
    { no: 5, name: "nfs", kind: "message", T: NFSVolumeSource, opt: true },
    { no: 6, name: "rbd", kind: "message", T: RBDPersistentVolumeSource, opt: true },
    { no: 7, name: "iscsi", kind: "message", T: ISCSIPersistentVolumeSource, opt: true },
    { no: 8, name: "cinder", kind: "message", T: CinderPersistentVolumeSource, opt: true },
    { no: 9, name: "cephfs", kind: "message", T: CephFSPersistentVolumeSource, opt: true },
    { no: 10, name: "fc", kind: "message", T: FCVolumeSource, opt: true },
    { no: 11, name: "flocker", kind: "message", T: FlockerVolumeSource, opt: true },
    { no: 12, name: "flexVolume", kind: "message", T: FlexPersistentVolumeSource, opt: true },
    { no: 13, name: "azureFile", kind: "message", T: AzureFilePersistentVolumeSource, opt: true },
    { no: 14, name: "vsphereVolume", kind: "message", T: VsphereVirtualDiskVolumeSource, opt: true },
    { no: 15, name: "quobyte", kind: "message", T: QuobyteVolumeSource, opt: true },
    { no: 16, name: "azureDisk", kind: "message", T: AzureDiskVolumeSource, opt: true },
    { no: 17, name: "photonPersistentDisk", kind: "message", T: PhotonPersistentDiskVolumeSource, opt: true },
    { no: 18, name: "portworxVolume", kind: "message", T: PortworxVolumeSource, opt: true },
    { no: 19, name: "scaleIO", kind: "message", T: ScaleIOPersistentVolumeSource, opt: true },
    { no: 20, name: "local", kind: "message", T: LocalVolumeSource, opt: true },
    { no: 21, name: "storageos", kind: "message", T: StorageOSPersistentVolumeSource, opt: true },
    { no: 22, name: "csi", kind: "message", T: CSIPersistentVolumeSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeSource {
    return new PersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeSource {
    return new PersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeSource {
    return new PersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeSource | PlainMessage<PersistentVolumeSource> | undefined, b: PersistentVolumeSource | PlainMessage<PersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeSource, a, b);
  }
}

/**
 * PersistentVolumeSpec is the specification of a persistent volume.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeSpec
 */
export class PersistentVolumeSpec extends Message<PersistentVolumeSpec> {
  /**
   * capacity is the description of the persistent volume's resources and capacity.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> capacity = 1;
   */
  capacity: { [key: string]: Quantity } = {};

  /**
   * persistentVolumeSource is the actual volume backing the persistent volume.
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeSource persistentVolumeSource = 2;
   */
  persistentVolumeSource?: PersistentVolumeSource;

  /**
   * accessModes contains all ways the volume can be mounted.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string accessModes = 3;
   */
  accessModes: string[] = [];

  /**
   * claimRef is part of a bi-directional binding between PersistentVolume and PersistentVolumeClaim.
   * Expected to be non-nil when bound.
   * claim.VolumeName is the authoritative bind between PV and PVC.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
   * +optional
   * +structType=granular
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference claimRef = 4;
   */
  claimRef?: ObjectReference;

  /**
   * persistentVolumeReclaimPolicy defines what happens to a persistent volume when released from its claim.
   * Valid options are Retain (default for manually created PersistentVolumes), Delete (default
   * for dynamically provisioned PersistentVolumes), and Recycle (deprecated).
   * Recycle must be supported by the volume plugin underlying this PersistentVolume.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
   * +optional
   *
   * @generated from field: optional string persistentVolumeReclaimPolicy = 5;
   */
  persistentVolumeReclaimPolicy?: string;

  /**
   * storageClassName is the name of StorageClass to which this persistent volume belongs. Empty value
   * means that this volume does not belong to any StorageClass.
   * +optional
   *
   * @generated from field: optional string storageClassName = 6;
   */
  storageClassName?: string;

  /**
   * mountOptions is the list of mount options, e.g. ["ro", "soft"]. Not validated - mount will
   * simply fail if one is invalid.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string mountOptions = 7;
   */
  mountOptions: string[] = [];

  /**
   * volumeMode defines if a volume is intended to be used with a formatted filesystem
   * or to remain in raw block state. Value of Filesystem is implied when not included in spec.
   * +optional
   *
   * @generated from field: optional string volumeMode = 8;
   */
  volumeMode?: string;

  /**
   * nodeAffinity defines constraints that limit what nodes this volume can be accessed from.
   * This field influences the scheduling of pods that use this volume.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.VolumeNodeAffinity nodeAffinity = 9;
   */
  nodeAffinity?: VolumeNodeAffinity;

  /**
   * Name of VolumeAttributesClass to which this persistent volume belongs. Empty value
   * is not allowed. When this field is not set, it indicates that this volume does not belong to any
   * VolumeAttributesClass. This field is mutable and can be changed by the CSI driver
   * after a volume has been updated successfully to a new class.
   * For an unbound PersistentVolume, the volumeAttributesClassName will be matched with unbound
   * PersistentVolumeClaims during the binding process.
   * This is a beta field and requires enabling VolumeAttributesClass feature (off by default).
   * +featureGate=VolumeAttributesClass
   * +optional
   *
   * @generated from field: optional string volumeAttributesClassName = 10;
   */
  volumeAttributesClassName?: string;

  constructor(data?: PartialMessage<PersistentVolumeSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "capacity", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "persistentVolumeSource", kind: "message", T: PersistentVolumeSource, opt: true },
    { no: 3, name: "accessModes", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "claimRef", kind: "message", T: ObjectReference, opt: true },
    { no: 5, name: "persistentVolumeReclaimPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "storageClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "mountOptions", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 8, name: "volumeMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "nodeAffinity", kind: "message", T: VolumeNodeAffinity, opt: true },
    { no: 10, name: "volumeAttributesClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeSpec {
    return new PersistentVolumeSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeSpec {
    return new PersistentVolumeSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeSpec {
    return new PersistentVolumeSpec().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeSpec | PlainMessage<PersistentVolumeSpec> | undefined, b: PersistentVolumeSpec | PlainMessage<PersistentVolumeSpec> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeSpec, a, b);
  }
}

/**
 * PersistentVolumeStatus is the current status of a persistent volume.
 *
 * @generated from message k8s.io.api.core.v1.PersistentVolumeStatus
 */
export class PersistentVolumeStatus extends Message<PersistentVolumeStatus> {
  /**
   * phase indicates if a volume is available, bound to a claim, or released by a claim.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
   * +optional
   *
   * @generated from field: optional string phase = 1;
   */
  phase?: string;

  /**
   * message is a human-readable message indicating details about why the volume is in this state.
   * +optional
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  /**
   * reason is a brief CamelCase string that describes any failure and is meant
   * for machine parsing and tidy display in the CLI.
   * +optional
   *
   * @generated from field: optional string reason = 3;
   */
  reason?: string;

  /**
   * lastPhaseTransitionTime is the time the phase transitioned from one to another
   * and automatically resets to current time everytime a volume phase transitions.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastPhaseTransitionTime = 4;
   */
  lastPhaseTransitionTime?: Time;

  constructor(data?: PartialMessage<PersistentVolumeStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PersistentVolumeStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "phase", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "lastPhaseTransitionTime", kind: "message", T: Time, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PersistentVolumeStatus {
    return new PersistentVolumeStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PersistentVolumeStatus {
    return new PersistentVolumeStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PersistentVolumeStatus {
    return new PersistentVolumeStatus().fromJsonString(jsonString, options);
  }

  static equals(a: PersistentVolumeStatus | PlainMessage<PersistentVolumeStatus> | undefined, b: PersistentVolumeStatus | PlainMessage<PersistentVolumeStatus> | undefined): boolean {
    return proto2.util.equals(PersistentVolumeStatus, a, b);
  }
}

/**
 * Represents a Photon Controller persistent disk resource.
 *
 * @generated from message k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource
 */
export class PhotonPersistentDiskVolumeSource extends Message<PhotonPersistentDiskVolumeSource> {
  /**
   * pdID is the ID that identifies Photon Controller persistent disk
   *
   * @generated from field: optional string pdID = 1;
   */
  pdID?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  constructor(data?: PartialMessage<PhotonPersistentDiskVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "pdID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PhotonPersistentDiskVolumeSource {
    return new PhotonPersistentDiskVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PhotonPersistentDiskVolumeSource {
    return new PhotonPersistentDiskVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PhotonPersistentDiskVolumeSource {
    return new PhotonPersistentDiskVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: PhotonPersistentDiskVolumeSource | PlainMessage<PhotonPersistentDiskVolumeSource> | undefined, b: PhotonPersistentDiskVolumeSource | PlainMessage<PhotonPersistentDiskVolumeSource> | undefined): boolean {
    return proto2.util.equals(PhotonPersistentDiskVolumeSource, a, b);
  }
}

/**
 * Pod is a collection of containers that can run on a host. This resource is created
 * by clients and scheduled onto hosts.
 *
 * @generated from message k8s.io.api.core.v1.Pod
 */
export class Pod extends Message<Pod> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Specification of the desired behavior of the pod.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodSpec spec = 2;
   */
  spec?: PodSpec;

  /**
   * Most recently observed status of the pod.
   * This data may not be up to date.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodStatus status = 3;
   */
  status?: PodStatus;

  constructor(data?: PartialMessage<Pod>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Pod";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: PodSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: PodStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Pod {
    return new Pod().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Pod {
    return new Pod().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Pod {
    return new Pod().fromJsonString(jsonString, options);
  }

  static equals(a: Pod | PlainMessage<Pod> | undefined, b: Pod | PlainMessage<Pod> | undefined): boolean {
    return proto2.util.equals(Pod, a, b);
  }
}

/**
 * Pod affinity is a group of inter pod affinity scheduling rules.
 *
 * @generated from message k8s.io.api.core.v1.PodAffinity
 */
export class PodAffinity extends Message<PodAffinity> {
  /**
   * If the affinity requirements specified by this field are not met at
   * scheduling time, the pod will not be scheduled onto the node.
   * If the affinity requirements specified by this field cease to be met
   * at some point during pod execution (e.g. due to a pod label update), the
   * system may or may not try to eventually evict the pod from its node.
   * When there are multiple elements, the lists of nodes corresponding to each
   * podAffinityTerm are intersected, i.e. all terms must be satisfied.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodAffinityTerm requiredDuringSchedulingIgnoredDuringExecution = 1;
   */
  requiredDuringSchedulingIgnoredDuringExecution: PodAffinityTerm[] = [];

  /**
   * The scheduler will prefer to schedule pods to nodes that satisfy
   * the affinity expressions specified by this field, but it may choose
   * a node that violates one or more of the expressions. The node that is
   * most preferred is the one with the greatest sum of weights, i.e.
   * for each node that meets all of the scheduling requirements (resource
   * request, requiredDuringScheduling affinity expressions, etc.),
   * compute a sum by iterating through the elements of this field and adding
   * "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
   * node(s) with the highest sum are the most preferred.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.WeightedPodAffinityTerm preferredDuringSchedulingIgnoredDuringExecution = 2;
   */
  preferredDuringSchedulingIgnoredDuringExecution: WeightedPodAffinityTerm[] = [];

  constructor(data?: PartialMessage<PodAffinity>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodAffinity";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "requiredDuringSchedulingIgnoredDuringExecution", kind: "message", T: PodAffinityTerm, repeated: true },
    { no: 2, name: "preferredDuringSchedulingIgnoredDuringExecution", kind: "message", T: WeightedPodAffinityTerm, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodAffinity {
    return new PodAffinity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodAffinity {
    return new PodAffinity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodAffinity {
    return new PodAffinity().fromJsonString(jsonString, options);
  }

  static equals(a: PodAffinity | PlainMessage<PodAffinity> | undefined, b: PodAffinity | PlainMessage<PodAffinity> | undefined): boolean {
    return proto2.util.equals(PodAffinity, a, b);
  }
}

/**
 * Defines a set of pods (namely those matching the labelSelector
 * relative to the given namespace(s)) that this pod should be
 * co-located (affinity) or not co-located (anti-affinity) with,
 * where co-located is defined as running on a node whose value of
 * the label with key <topologyKey> matches that of any node on which
 * a pod of the set of pods is running
 *
 * @generated from message k8s.io.api.core.v1.PodAffinityTerm
 */
export class PodAffinityTerm extends Message<PodAffinityTerm> {
  /**
   * A label query over a set of resources, in this case pods.
   * If it's null, this PodAffinityTerm matches with no Pods.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector labelSelector = 1;
   */
  labelSelector?: LabelSelector;

  /**
   * namespaces specifies a static list of namespace names that the term applies to.
   * The term is applied to the union of the namespaces listed in this field
   * and the ones selected by namespaceSelector.
   * null or empty namespaces list and null namespaceSelector means "this pod's namespace".
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string namespaces = 2;
   */
  namespaces: string[] = [];

  /**
   * This pod should be co-located (affinity) or not co-located (anti-affinity) with the pods matching
   * the labelSelector in the specified namespaces, where co-located is defined as running on a node
   * whose value of the label with key topologyKey matches that of any node on which any of the
   * selected pods is running.
   * Empty topologyKey is not allowed.
   *
   * @generated from field: optional string topologyKey = 3;
   */
  topologyKey?: string;

  /**
   * A label query over the set of namespaces that the term applies to.
   * The term is applied to the union of the namespaces selected by this field
   * and the ones listed in the namespaces field.
   * null selector and null or empty namespaces list means "this pod's namespace".
   * An empty selector ({}) matches all namespaces.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 4;
   */
  namespaceSelector?: LabelSelector;

  /**
   * MatchLabelKeys is a set of pod label keys to select which pods will
   * be taken into consideration. The keys are used to lookup values from the
   * incoming pod labels, those key-value labels are merged with `labelSelector` as `key in (value)`
   * to select the group of existing pods which pods will be taken into consideration
   * for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
   * pod labels will be ignored. The default value is empty.
   * The same key is forbidden to exist in both matchLabelKeys and labelSelector.
   * Also, matchLabelKeys cannot be set when labelSelector isn't set.
   * This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
   *
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated string matchLabelKeys = 5;
   */
  matchLabelKeys: string[] = [];

  /**
   * MismatchLabelKeys is a set of pod label keys to select which pods will
   * be taken into consideration. The keys are used to lookup values from the
   * incoming pod labels, those key-value labels are merged with `labelSelector` as `key notin (value)`
   * to select the group of existing pods which pods will be taken into consideration
   * for the incoming pod's pod (anti) affinity. Keys that don't exist in the incoming
   * pod labels will be ignored. The default value is empty.
   * The same key is forbidden to exist in both mismatchLabelKeys and labelSelector.
   * Also, mismatchLabelKeys cannot be set when labelSelector isn't set.
   * This is a beta field and requires enabling MatchLabelKeysInPodAffinity feature gate (enabled by default).
   *
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated string mismatchLabelKeys = 6;
   */
  mismatchLabelKeys: string[] = [];

  constructor(data?: PartialMessage<PodAffinityTerm>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodAffinityTerm";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "labelSelector", kind: "message", T: LabelSelector, opt: true },
    { no: 2, name: "namespaces", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "topologyKey", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "namespaceSelector", kind: "message", T: LabelSelector, opt: true },
    { no: 5, name: "matchLabelKeys", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 6, name: "mismatchLabelKeys", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodAffinityTerm {
    return new PodAffinityTerm().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodAffinityTerm {
    return new PodAffinityTerm().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodAffinityTerm {
    return new PodAffinityTerm().fromJsonString(jsonString, options);
  }

  static equals(a: PodAffinityTerm | PlainMessage<PodAffinityTerm> | undefined, b: PodAffinityTerm | PlainMessage<PodAffinityTerm> | undefined): boolean {
    return proto2.util.equals(PodAffinityTerm, a, b);
  }
}

/**
 * Pod anti affinity is a group of inter pod anti affinity scheduling rules.
 *
 * @generated from message k8s.io.api.core.v1.PodAntiAffinity
 */
export class PodAntiAffinity extends Message<PodAntiAffinity> {
  /**
   * If the anti-affinity requirements specified by this field are not met at
   * scheduling time, the pod will not be scheduled onto the node.
   * If the anti-affinity requirements specified by this field cease to be met
   * at some point during pod execution (e.g. due to a pod label update), the
   * system may or may not try to eventually evict the pod from its node.
   * When there are multiple elements, the lists of nodes corresponding to each
   * podAffinityTerm are intersected, i.e. all terms must be satisfied.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodAffinityTerm requiredDuringSchedulingIgnoredDuringExecution = 1;
   */
  requiredDuringSchedulingIgnoredDuringExecution: PodAffinityTerm[] = [];

  /**
   * The scheduler will prefer to schedule pods to nodes that satisfy
   * the anti-affinity expressions specified by this field, but it may choose
   * a node that violates one or more of the expressions. The node that is
   * most preferred is the one with the greatest sum of weights, i.e.
   * for each node that meets all of the scheduling requirements (resource
   * request, requiredDuringScheduling anti-affinity expressions, etc.),
   * compute a sum by iterating through the elements of this field and adding
   * "weight" to the sum if the node has pods which matches the corresponding podAffinityTerm; the
   * node(s) with the highest sum are the most preferred.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.WeightedPodAffinityTerm preferredDuringSchedulingIgnoredDuringExecution = 2;
   */
  preferredDuringSchedulingIgnoredDuringExecution: WeightedPodAffinityTerm[] = [];

  constructor(data?: PartialMessage<PodAntiAffinity>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodAntiAffinity";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "requiredDuringSchedulingIgnoredDuringExecution", kind: "message", T: PodAffinityTerm, repeated: true },
    { no: 2, name: "preferredDuringSchedulingIgnoredDuringExecution", kind: "message", T: WeightedPodAffinityTerm, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodAntiAffinity {
    return new PodAntiAffinity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodAntiAffinity {
    return new PodAntiAffinity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodAntiAffinity {
    return new PodAntiAffinity().fromJsonString(jsonString, options);
  }

  static equals(a: PodAntiAffinity | PlainMessage<PodAntiAffinity> | undefined, b: PodAntiAffinity | PlainMessage<PodAntiAffinity> | undefined): boolean {
    return proto2.util.equals(PodAntiAffinity, a, b);
  }
}

/**
 * PodAttachOptions is the query options to a Pod's remote attach call.
 * ---
 * TODO: merge w/ PodExecOptions below for stdin, stdout, etc
 * and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
 *
 * @generated from message k8s.io.api.core.v1.PodAttachOptions
 */
export class PodAttachOptions extends Message<PodAttachOptions> {
  /**
   * Stdin if true, redirects the standard input stream of the pod for this call.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool stdin = 1;
   */
  stdin?: boolean;

  /**
   * Stdout if true indicates that stdout is to be redirected for the attach call.
   * Defaults to true.
   * +optional
   *
   * @generated from field: optional bool stdout = 2;
   */
  stdout?: boolean;

  /**
   * Stderr if true indicates that stderr is to be redirected for the attach call.
   * Defaults to true.
   * +optional
   *
   * @generated from field: optional bool stderr = 3;
   */
  stderr?: boolean;

  /**
   * TTY if true indicates that a tty will be allocated for the attach call.
   * This is passed through the container runtime so the tty
   * is allocated on the worker node by the container runtime.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool tty = 4;
   */
  tty?: boolean;

  /**
   * The container in which to execute the command.
   * Defaults to only container if there is only one container in the pod.
   * +optional
   *
   * @generated from field: optional string container = 5;
   */
  container?: string;

  constructor(data?: PartialMessage<PodAttachOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodAttachOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "stdin", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "stdout", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "stderr", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "tty", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "container", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodAttachOptions {
    return new PodAttachOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodAttachOptions {
    return new PodAttachOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodAttachOptions {
    return new PodAttachOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PodAttachOptions | PlainMessage<PodAttachOptions> | undefined, b: PodAttachOptions | PlainMessage<PodAttachOptions> | undefined): boolean {
    return proto2.util.equals(PodAttachOptions, a, b);
  }
}

/**
 * PodCondition contains details for the current condition of this pod.
 *
 * @generated from message k8s.io.api.core.v1.PodCondition
 */
export class PodCondition extends Message<PodCondition> {
  /**
   * Type is the type of the condition.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status is the status of the condition.
   * Can be True, False, Unknown.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * Last time we probed the condition.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastProbeTime = 3;
   */
  lastProbeTime?: Time;

  /**
   * Last time the condition transitioned from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * Unique, one-word, CamelCase reason for the condition's last transition.
   * +optional
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * Human-readable message indicating details about last transition.
   * +optional
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<PodCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastProbeTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodCondition {
    return new PodCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodCondition {
    return new PodCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodCondition {
    return new PodCondition().fromJsonString(jsonString, options);
  }

  static equals(a: PodCondition | PlainMessage<PodCondition> | undefined, b: PodCondition | PlainMessage<PodCondition> | undefined): boolean {
    return proto2.util.equals(PodCondition, a, b);
  }
}

/**
 * PodDNSConfig defines the DNS parameters of a pod in addition to
 * those generated from DNSPolicy.
 *
 * @generated from message k8s.io.api.core.v1.PodDNSConfig
 */
export class PodDNSConfig extends Message<PodDNSConfig> {
  /**
   * A list of DNS name server IP addresses.
   * This will be appended to the base nameservers generated from DNSPolicy.
   * Duplicated nameservers will be removed.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string nameservers = 1;
   */
  nameservers: string[] = [];

  /**
   * A list of DNS search domains for host-name lookup.
   * This will be appended to the base search paths generated from DNSPolicy.
   * Duplicated search paths will be removed.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string searches = 2;
   */
  searches: string[] = [];

  /**
   * A list of DNS resolver options.
   * This will be merged with the base options generated from DNSPolicy.
   * Duplicated entries will be removed. Resolution options given in Options
   * will override those that appear in the base DNSPolicy.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodDNSConfigOption options = 3;
   */
  options: PodDNSConfigOption[] = [];

  constructor(data?: PartialMessage<PodDNSConfig>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodDNSConfig";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "nameservers", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "searches", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "options", kind: "message", T: PodDNSConfigOption, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodDNSConfig {
    return new PodDNSConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodDNSConfig {
    return new PodDNSConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodDNSConfig {
    return new PodDNSConfig().fromJsonString(jsonString, options);
  }

  static equals(a: PodDNSConfig | PlainMessage<PodDNSConfig> | undefined, b: PodDNSConfig | PlainMessage<PodDNSConfig> | undefined): boolean {
    return proto2.util.equals(PodDNSConfig, a, b);
  }
}

/**
 * PodDNSConfigOption defines DNS resolver options of a pod.
 *
 * @generated from message k8s.io.api.core.v1.PodDNSConfigOption
 */
export class PodDNSConfigOption extends Message<PodDNSConfigOption> {
  /**
   * Required.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * +optional
   *
   * @generated from field: optional string value = 2;
   */
  value?: string;

  constructor(data?: PartialMessage<PodDNSConfigOption>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodDNSConfigOption";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodDNSConfigOption {
    return new PodDNSConfigOption().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodDNSConfigOption {
    return new PodDNSConfigOption().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodDNSConfigOption {
    return new PodDNSConfigOption().fromJsonString(jsonString, options);
  }

  static equals(a: PodDNSConfigOption | PlainMessage<PodDNSConfigOption> | undefined, b: PodDNSConfigOption | PlainMessage<PodDNSConfigOption> | undefined): boolean {
    return proto2.util.equals(PodDNSConfigOption, a, b);
  }
}

/**
 * PodExecOptions is the query options to a Pod's remote exec call.
 * ---
 * TODO: This is largely identical to PodAttachOptions above, make sure they stay in sync and see about merging
 * and also when we cut V2, we should export a "StreamOptions" or somesuch that contains Stdin, Stdout, Stder and TTY
 *
 * @generated from message k8s.io.api.core.v1.PodExecOptions
 */
export class PodExecOptions extends Message<PodExecOptions> {
  /**
   * Redirect the standard input stream of the pod for this call.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool stdin = 1;
   */
  stdin?: boolean;

  /**
   * Redirect the standard output stream of the pod for this call.
   * +optional
   *
   * @generated from field: optional bool stdout = 2;
   */
  stdout?: boolean;

  /**
   * Redirect the standard error stream of the pod for this call.
   * +optional
   *
   * @generated from field: optional bool stderr = 3;
   */
  stderr?: boolean;

  /**
   * TTY if true indicates that a tty will be allocated for the exec call.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool tty = 4;
   */
  tty?: boolean;

  /**
   * Container in which to execute the command.
   * Defaults to only container if there is only one container in the pod.
   * +optional
   *
   * @generated from field: optional string container = 5;
   */
  container?: string;

  /**
   * Command is the remote command to execute. argv array. Not executed within a shell.
   * +listType=atomic
   *
   * @generated from field: repeated string command = 6;
   */
  command: string[] = [];

  constructor(data?: PartialMessage<PodExecOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodExecOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "stdin", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "stdout", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "stderr", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "tty", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "container", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "command", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodExecOptions {
    return new PodExecOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodExecOptions {
    return new PodExecOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodExecOptions {
    return new PodExecOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PodExecOptions | PlainMessage<PodExecOptions> | undefined, b: PodExecOptions | PlainMessage<PodExecOptions> | undefined): boolean {
    return proto2.util.equals(PodExecOptions, a, b);
  }
}

/**
 * PodIP represents a single IP address allocated to the pod.
 *
 * @generated from message k8s.io.api.core.v1.PodIP
 */
export class PodIP extends Message<PodIP> {
  /**
   * IP is the IP address assigned to the pod
   * +required
   *
   * @generated from field: optional string ip = 1;
   */
  ip?: string;

  constructor(data?: PartialMessage<PodIP>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodIP";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ip", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodIP {
    return new PodIP().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodIP {
    return new PodIP().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodIP {
    return new PodIP().fromJsonString(jsonString, options);
  }

  static equals(a: PodIP | PlainMessage<PodIP> | undefined, b: PodIP | PlainMessage<PodIP> | undefined): boolean {
    return proto2.util.equals(PodIP, a, b);
  }
}

/**
 * PodList is a list of Pods.
 *
 * @generated from message k8s.io.api.core.v1.PodList
 */
export class PodList extends Message<PodList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of pods.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md
   *
   * @generated from field: repeated k8s.io.api.core.v1.Pod items = 2;
   */
  items: Pod[] = [];

  constructor(data?: PartialMessage<PodList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Pod, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodList {
    return new PodList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodList {
    return new PodList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodList {
    return new PodList().fromJsonString(jsonString, options);
  }

  static equals(a: PodList | PlainMessage<PodList> | undefined, b: PodList | PlainMessage<PodList> | undefined): boolean {
    return proto2.util.equals(PodList, a, b);
  }
}

/**
 * PodLogOptions is the query options for a Pod's logs REST call.
 *
 * @generated from message k8s.io.api.core.v1.PodLogOptions
 */
export class PodLogOptions extends Message<PodLogOptions> {
  /**
   * The container for which to stream logs. Defaults to only container if there is one container in the pod.
   * +optional
   *
   * @generated from field: optional string container = 1;
   */
  container?: string;

  /**
   * Follow the log stream of the pod. Defaults to false.
   * +optional
   *
   * @generated from field: optional bool follow = 2;
   */
  follow?: boolean;

  /**
   * Return previous terminated container logs. Defaults to false.
   * +optional
   *
   * @generated from field: optional bool previous = 3;
   */
  previous?: boolean;

  /**
   * A relative time in seconds before the current time from which to show logs. If this value
   * precedes the time a pod was started, only logs since the pod start will be returned.
   * If this value is in the future, no logs will be returned.
   * Only one of sinceSeconds or sinceTime may be specified.
   * +optional
   *
   * @generated from field: optional int64 sinceSeconds = 4;
   */
  sinceSeconds?: bigint;

  /**
   * An RFC3339 timestamp from which to show logs. If this value
   * precedes the time a pod was started, only logs since the pod start will be returned.
   * If this value is in the future, no logs will be returned.
   * Only one of sinceSeconds or sinceTime may be specified.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time sinceTime = 5;
   */
  sinceTime?: Time;

  /**
   * If true, add an RFC3339 or RFC3339Nano timestamp at the beginning of every line
   * of log output. Defaults to false.
   * +optional
   *
   * @generated from field: optional bool timestamps = 6;
   */
  timestamps?: boolean;

  /**
   * If set, the number of lines from the end of the logs to show. If not specified,
   * logs are shown from the creation of the container or sinceSeconds or sinceTime
   * +optional
   *
   * @generated from field: optional int64 tailLines = 7;
   */
  tailLines?: bigint;

  /**
   * If set, the number of bytes to read from the server before terminating the
   * log output. This may not display a complete final line of logging, and may return
   * slightly more or slightly less than the specified limit.
   * +optional
   *
   * @generated from field: optional int64 limitBytes = 8;
   */
  limitBytes?: bigint;

  /**
   * insecureSkipTLSVerifyBackend indicates that the apiserver should not confirm the validity of the
   * serving certificate of the backend it is connecting to.  This will make the HTTPS connection between the apiserver
   * and the backend insecure. This means the apiserver cannot verify the log data it is receiving came from the real
   * kubelet.  If the kubelet is configured to verify the apiserver's TLS credentials, it does not mean the
   * connection to the real kubelet is vulnerable to a man in the middle attack (e.g. an attacker could not intercept
   * the actual log data coming from the real kubelet).
   * +optional
   *
   * @generated from field: optional bool insecureSkipTLSVerifyBackend = 9;
   */
  insecureSkipTLSVerifyBackend?: boolean;

  constructor(data?: PartialMessage<PodLogOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodLogOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "container", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "follow", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "previous", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "sinceSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 5, name: "sinceTime", kind: "message", T: Time, opt: true },
    { no: 6, name: "timestamps", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "tailLines", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 8, name: "limitBytes", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 9, name: "insecureSkipTLSVerifyBackend", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodLogOptions {
    return new PodLogOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodLogOptions {
    return new PodLogOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodLogOptions {
    return new PodLogOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PodLogOptions | PlainMessage<PodLogOptions> | undefined, b: PodLogOptions | PlainMessage<PodLogOptions> | undefined): boolean {
    return proto2.util.equals(PodLogOptions, a, b);
  }
}

/**
 * PodOS defines the OS parameters of a pod.
 *
 * @generated from message k8s.io.api.core.v1.PodOS
 */
export class PodOS extends Message<PodOS> {
  /**
   * Name is the name of the operating system. The currently supported values are linux and windows.
   * Additional value may be defined in future and can be one of:
   * https://github.com/opencontainers/runtime-spec/blob/master/config.md#platform-specific-configuration
   * Clients should expect to handle additional values and treat unrecognized values in this field as os: null
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  constructor(data?: PartialMessage<PodOS>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodOS";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodOS {
    return new PodOS().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodOS {
    return new PodOS().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodOS {
    return new PodOS().fromJsonString(jsonString, options);
  }

  static equals(a: PodOS | PlainMessage<PodOS> | undefined, b: PodOS | PlainMessage<PodOS> | undefined): boolean {
    return proto2.util.equals(PodOS, a, b);
  }
}

/**
 * PodPortForwardOptions is the query options to a Pod's port forward call
 * when using WebSockets.
 * The `port` query parameter must specify the port or
 * ports (comma separated) to forward over.
 * Port forwarding over SPDY does not use these options. It requires the port
 * to be passed in the `port` header as part of request.
 *
 * @generated from message k8s.io.api.core.v1.PodPortForwardOptions
 */
export class PodPortForwardOptions extends Message<PodPortForwardOptions> {
  /**
   * List of ports to forward
   * Required when using WebSockets
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated int32 ports = 1;
   */
  ports: number[] = [];

  constructor(data?: PartialMessage<PodPortForwardOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodPortForwardOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ports", kind: "scalar", T: 5 /* ScalarType.INT32 */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodPortForwardOptions {
    return new PodPortForwardOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodPortForwardOptions {
    return new PodPortForwardOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodPortForwardOptions {
    return new PodPortForwardOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PodPortForwardOptions | PlainMessage<PodPortForwardOptions> | undefined, b: PodPortForwardOptions | PlainMessage<PodPortForwardOptions> | undefined): boolean {
    return proto2.util.equals(PodPortForwardOptions, a, b);
  }
}

/**
 * PodProxyOptions is the query options to a Pod's proxy call.
 *
 * @generated from message k8s.io.api.core.v1.PodProxyOptions
 */
export class PodProxyOptions extends Message<PodProxyOptions> {
  /**
   * Path is the URL path to use for the current proxy request to pod.
   * +optional
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  constructor(data?: PartialMessage<PodProxyOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodProxyOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodProxyOptions {
    return new PodProxyOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodProxyOptions {
    return new PodProxyOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodProxyOptions {
    return new PodProxyOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PodProxyOptions | PlainMessage<PodProxyOptions> | undefined, b: PodProxyOptions | PlainMessage<PodProxyOptions> | undefined): boolean {
    return proto2.util.equals(PodProxyOptions, a, b);
  }
}

/**
 * PodReadinessGate contains the reference to a pod condition
 *
 * @generated from message k8s.io.api.core.v1.PodReadinessGate
 */
export class PodReadinessGate extends Message<PodReadinessGate> {
  /**
   * ConditionType refers to a condition in the pod's condition list with matching type.
   *
   * @generated from field: optional string conditionType = 1;
   */
  conditionType?: string;

  constructor(data?: PartialMessage<PodReadinessGate>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodReadinessGate";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "conditionType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodReadinessGate {
    return new PodReadinessGate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodReadinessGate {
    return new PodReadinessGate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodReadinessGate {
    return new PodReadinessGate().fromJsonString(jsonString, options);
  }

  static equals(a: PodReadinessGate | PlainMessage<PodReadinessGate> | undefined, b: PodReadinessGate | PlainMessage<PodReadinessGate> | undefined): boolean {
    return proto2.util.equals(PodReadinessGate, a, b);
  }
}

/**
 * PodResourceClaim references exactly one ResourceClaim, either directly
 * or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim
 * for the pod.
 *
 * It adds a name to it that uniquely identifies the ResourceClaim inside the Pod.
 * Containers that need access to the ResourceClaim reference it with this name.
 *
 * @generated from message k8s.io.api.core.v1.PodResourceClaim
 */
export class PodResourceClaim extends Message<PodResourceClaim> {
  /**
   * Name uniquely identifies this resource claim inside the pod.
   * This must be a DNS_LABEL.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * ResourceClaimName is the name of a ResourceClaim object in the same
   * namespace as this pod.
   *
   * Exactly one of ResourceClaimName and ResourceClaimTemplateName must
   * be set.
   *
   * @generated from field: optional string resourceClaimName = 3;
   */
  resourceClaimName?: string;

  /**
   * ResourceClaimTemplateName is the name of a ResourceClaimTemplate
   * object in the same namespace as this pod.
   *
   * The template will be used to create a new ResourceClaim, which will
   * be bound to this pod. When this pod is deleted, the ResourceClaim
   * will also be deleted. The pod name and resource name, along with a
   * generated component, will be used to form a unique name for the
   * ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.
   *
   * This field is immutable and no changes will be made to the
   * corresponding ResourceClaim by the control plane after creating the
   * ResourceClaim.
   *
   * Exactly one of ResourceClaimName and ResourceClaimTemplateName must
   * be set.
   *
   * @generated from field: optional string resourceClaimTemplateName = 4;
   */
  resourceClaimTemplateName?: string;

  constructor(data?: PartialMessage<PodResourceClaim>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodResourceClaim";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "resourceClaimName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "resourceClaimTemplateName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodResourceClaim {
    return new PodResourceClaim().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodResourceClaim {
    return new PodResourceClaim().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodResourceClaim {
    return new PodResourceClaim().fromJsonString(jsonString, options);
  }

  static equals(a: PodResourceClaim | PlainMessage<PodResourceClaim> | undefined, b: PodResourceClaim | PlainMessage<PodResourceClaim> | undefined): boolean {
    return proto2.util.equals(PodResourceClaim, a, b);
  }
}

/**
 * PodResourceClaimStatus is stored in the PodStatus for each PodResourceClaim
 * which references a ResourceClaimTemplate. It stores the generated name for
 * the corresponding ResourceClaim.
 *
 * @generated from message k8s.io.api.core.v1.PodResourceClaimStatus
 */
export class PodResourceClaimStatus extends Message<PodResourceClaimStatus> {
  /**
   * Name uniquely identifies this resource claim inside the pod.
   * This must match the name of an entry in pod.spec.resourceClaims,
   * which implies that the string must be a DNS_LABEL.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * ResourceClaimName is the name of the ResourceClaim that was
   * generated for the Pod in the namespace of the Pod. If this is
   * unset, then generating a ResourceClaim was not necessary. The
   * pod.spec.resourceClaims entry can be ignored in this case.
   *
   * +optional
   *
   * @generated from field: optional string resourceClaimName = 2;
   */
  resourceClaimName?: string;

  constructor(data?: PartialMessage<PodResourceClaimStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodResourceClaimStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resourceClaimName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodResourceClaimStatus {
    return new PodResourceClaimStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodResourceClaimStatus {
    return new PodResourceClaimStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodResourceClaimStatus {
    return new PodResourceClaimStatus().fromJsonString(jsonString, options);
  }

  static equals(a: PodResourceClaimStatus | PlainMessage<PodResourceClaimStatus> | undefined, b: PodResourceClaimStatus | PlainMessage<PodResourceClaimStatus> | undefined): boolean {
    return proto2.util.equals(PodResourceClaimStatus, a, b);
  }
}

/**
 * PodSchedulingGate is associated to a Pod to guard its scheduling.
 *
 * @generated from message k8s.io.api.core.v1.PodSchedulingGate
 */
export class PodSchedulingGate extends Message<PodSchedulingGate> {
  /**
   * Name of the scheduling gate.
   * Each scheduling gate must have a unique name field.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  constructor(data?: PartialMessage<PodSchedulingGate>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodSchedulingGate";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodSchedulingGate {
    return new PodSchedulingGate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodSchedulingGate {
    return new PodSchedulingGate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodSchedulingGate {
    return new PodSchedulingGate().fromJsonString(jsonString, options);
  }

  static equals(a: PodSchedulingGate | PlainMessage<PodSchedulingGate> | undefined, b: PodSchedulingGate | PlainMessage<PodSchedulingGate> | undefined): boolean {
    return proto2.util.equals(PodSchedulingGate, a, b);
  }
}

/**
 * PodSecurityContext holds pod-level security attributes and common container settings.
 * Some fields are also present in container.securityContext.  Field values of
 * container.securityContext take precedence over field values of PodSecurityContext.
 *
 * @generated from message k8s.io.api.core.v1.PodSecurityContext
 */
export class PodSecurityContext extends Message<PodSecurityContext> {
  /**
   * The SELinux context to be applied to all containers.
   * If unspecified, the container runtime will allocate a random SELinux context for each
   * container.  May also be set in SecurityContext.  If set in
   * both SecurityContext and PodSecurityContext, the value specified in SecurityContext
   * takes precedence for that container.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SELinuxOptions seLinuxOptions = 1;
   */
  seLinuxOptions?: SELinuxOptions;

  /**
   * The Windows specific settings applied to all containers.
   * If unspecified, the options within a container's SecurityContext will be used.
   * If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
   * Note that this field cannot be set when spec.os.name is linux.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.WindowsSecurityContextOptions windowsOptions = 8;
   */
  windowsOptions?: WindowsSecurityContextOptions;

  /**
   * The UID to run the entrypoint of the container process.
   * Defaults to user specified in image metadata if unspecified.
   * May also be set in SecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence
   * for that container.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional int64 runAsUser = 2;
   */
  runAsUser?: bigint;

  /**
   * The GID to run the entrypoint of the container process.
   * Uses runtime default if unset.
   * May also be set in SecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence
   * for that container.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional int64 runAsGroup = 6;
   */
  runAsGroup?: bigint;

  /**
   * Indicates that the container must run as a non-root user.
   * If true, the Kubelet will validate the image at runtime to ensure that it
   * does not run as UID 0 (root) and fail to start the container if it does.
   * If unset or false, no such validation will be performed.
   * May also be set in SecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * +optional
   *
   * @generated from field: optional bool runAsNonRoot = 3;
   */
  runAsNonRoot?: boolean;

  /**
   * A list of groups applied to the first process run in each container, in
   * addition to the container's primary GID and fsGroup (if specified).  If
   * the SupplementalGroupsPolicy feature is enabled, the
   * supplementalGroupsPolicy field determines whether these are in addition
   * to or instead of any group memberships defined in the container image.
   * If unspecified, no additional groups are added, though group memberships
   * defined in the container image may still be used, depending on the
   * supplementalGroupsPolicy field.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated int64 supplementalGroups = 4;
   */
  supplementalGroups: bigint[] = [];

  /**
   * Defines how supplemental groups of the first container processes are calculated.
   * Valid values are "Merge" and "Strict". If not specified, "Merge" is used.
   * (Alpha) Using the field requires the SupplementalGroupsPolicy feature gate to be enabled
   * and the container runtime must implement support for this feature.
   * Note that this field cannot be set when spec.os.name is windows.
   * TODO: update the default value to "Merge" when spec.os.name is not windows in v1.34
   * +featureGate=SupplementalGroupsPolicy
   * +optional
   *
   * @generated from field: optional string supplementalGroupsPolicy = 12;
   */
  supplementalGroupsPolicy?: string;

  /**
   * A special supplemental group that applies to all containers in a pod.
   * Some volume types allow the Kubelet to change the ownership of that volume
   * to be owned by the pod:
   *
   * 1. The owning GID will be the FSGroup
   * 2. The setgid bit is set (new files created in the volume will be owned by FSGroup)
   * 3. The permission bits are OR'd with rw-rw----
   *
   * If unset, the Kubelet will not modify the ownership and permissions of any volume.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional int64 fsGroup = 5;
   */
  fsGroup?: bigint;

  /**
   * Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported
   * sysctls (by the container runtime) might fail to launch.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.Sysctl sysctls = 7;
   */
  sysctls: Sysctl[] = [];

  /**
   * fsGroupChangePolicy defines behavior of changing ownership and permission of the volume
   * before being exposed inside Pod. This field will only apply to
   * volume types which support fsGroup based ownership(and permissions).
   * It will have no effect on ephemeral volume types such as: secret, configmaps
   * and emptydir.
   * Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional string fsGroupChangePolicy = 9;
   */
  fsGroupChangePolicy?: string;

  /**
   * The seccomp options to use by the containers in this pod.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SeccompProfile seccompProfile = 10;
   */
  seccompProfile?: SeccompProfile;

  /**
   * appArmorProfile is the AppArmor options to use by the containers in this pod.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AppArmorProfile appArmorProfile = 11;
   */
  appArmorProfile?: AppArmorProfile;

  constructor(data?: PartialMessage<PodSecurityContext>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodSecurityContext";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "seLinuxOptions", kind: "message", T: SELinuxOptions, opt: true },
    { no: 8, name: "windowsOptions", kind: "message", T: WindowsSecurityContextOptions, opt: true },
    { no: 2, name: "runAsUser", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 6, name: "runAsGroup", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 3, name: "runAsNonRoot", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "supplementalGroups", kind: "scalar", T: 3 /* ScalarType.INT64 */, repeated: true },
    { no: 12, name: "supplementalGroupsPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "fsGroup", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 7, name: "sysctls", kind: "message", T: Sysctl, repeated: true },
    { no: 9, name: "fsGroupChangePolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "seccompProfile", kind: "message", T: SeccompProfile, opt: true },
    { no: 11, name: "appArmorProfile", kind: "message", T: AppArmorProfile, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodSecurityContext {
    return new PodSecurityContext().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodSecurityContext {
    return new PodSecurityContext().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodSecurityContext {
    return new PodSecurityContext().fromJsonString(jsonString, options);
  }

  static equals(a: PodSecurityContext | PlainMessage<PodSecurityContext> | undefined, b: PodSecurityContext | PlainMessage<PodSecurityContext> | undefined): boolean {
    return proto2.util.equals(PodSecurityContext, a, b);
  }
}

/**
 * Describes the class of pods that should avoid this node.
 * Exactly one field should be set.
 *
 * @generated from message k8s.io.api.core.v1.PodSignature
 */
export class PodSignature extends Message<PodSignature> {
  /**
   * Reference to controller whose pods should avoid this node.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.OwnerReference podController = 1;
   */
  podController?: OwnerReference;

  constructor(data?: PartialMessage<PodSignature>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodSignature";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "podController", kind: "message", T: OwnerReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodSignature {
    return new PodSignature().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodSignature {
    return new PodSignature().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodSignature {
    return new PodSignature().fromJsonString(jsonString, options);
  }

  static equals(a: PodSignature | PlainMessage<PodSignature> | undefined, b: PodSignature | PlainMessage<PodSignature> | undefined): boolean {
    return proto2.util.equals(PodSignature, a, b);
  }
}

/**
 * PodSpec is a description of a pod.
 *
 * @generated from message k8s.io.api.core.v1.PodSpec
 */
export class PodSpec extends Message<PodSpec> {
  /**
   * List of volumes that can be mounted by containers belonging to the pod.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge,retainKeys
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.Volume volumes = 1;
   */
  volumes: Volume[] = [];

  /**
   * List of initialization containers belonging to the pod.
   * Init containers are executed in order prior to containers being started. If any
   * init container fails, the pod is considered to have failed and is handled according
   * to its restartPolicy. The name for an init container or normal container must be
   * unique among all containers.
   * Init containers may not have Lifecycle actions, Readiness probes, Liveness probes, or Startup probes.
   * The resourceRequirements of an init container are taken into account during scheduling
   * by finding the highest request/limit for each resource type, and then using the max of
   * of that value or the sum of the normal containers. Limits are applied to init containers
   * in a similar fashion.
   * Init containers cannot currently be added or removed.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.Container initContainers = 20;
   */
  initContainers: Container[] = [];

  /**
   * List of containers belonging to the pod.
   * Containers cannot currently be added or removed.
   * There must be at least one container in a Pod.
   * Cannot be updated.
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.Container containers = 2;
   */
  containers: Container[] = [];

  /**
   * List of ephemeral containers run in this pod. Ephemeral containers may be run in an existing
   * pod to perform user-initiated actions such as debugging. This list cannot be specified when
   * creating a pod, and it cannot be modified by updating the pod spec. In order to add an
   * ephemeral container to an existing pod, use the pod's ephemeralcontainers subresource.
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.EphemeralContainer ephemeralContainers = 34;
   */
  ephemeralContainers: EphemeralContainer[] = [];

  /**
   * Restart policy for all containers within the pod.
   * One of Always, OnFailure, Never. In some contexts, only a subset of those values may be permitted.
   * Default to Always.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
   * +optional
   *
   * @generated from field: optional string restartPolicy = 3;
   */
  restartPolicy?: string;

  /**
   * Optional duration in seconds the pod needs to terminate gracefully. May be decreased in delete request.
   * Value must be non-negative integer. The value zero indicates stop immediately via
   * the kill signal (no opportunity to shut down).
   * If this value is nil, the default grace period will be used instead.
   * The grace period is the duration in seconds after the processes running in the pod are sent
   * a termination signal and the time when the processes are forcibly halted with a kill signal.
   * Set this value longer than the expected cleanup time for your process.
   * Defaults to 30 seconds.
   * +optional
   *
   * @generated from field: optional int64 terminationGracePeriodSeconds = 4;
   */
  terminationGracePeriodSeconds?: bigint;

  /**
   * Optional duration in seconds the pod may be active on the node relative to
   * StartTime before the system will actively try to mark it failed and kill associated containers.
   * Value must be a positive integer.
   * +optional
   *
   * @generated from field: optional int64 activeDeadlineSeconds = 5;
   */
  activeDeadlineSeconds?: bigint;

  /**
   * Set DNS policy for the pod.
   * Defaults to "ClusterFirst".
   * Valid values are 'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'.
   * DNS parameters given in DNSConfig will be merged with the policy selected with DNSPolicy.
   * To have DNS options set along with hostNetwork, you have to specify DNS policy
   * explicitly to 'ClusterFirstWithHostNet'.
   * +optional
   *
   * @generated from field: optional string dnsPolicy = 6;
   */
  dnsPolicy?: string;

  /**
   * NodeSelector is a selector which must be true for the pod to fit on a node.
   * Selector which must match a node's labels for the pod to be scheduled on that node.
   * More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
   * +optional
   * +mapType=atomic
   *
   * @generated from field: map<string, string> nodeSelector = 7;
   */
  nodeSelector: { [key: string]: string } = {};

  /**
   * ServiceAccountName is the name of the ServiceAccount to use to run this pod.
   * More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
   * +optional
   *
   * @generated from field: optional string serviceAccountName = 8;
   */
  serviceAccountName?: string;

  /**
   * DeprecatedServiceAccount is a deprecated alias for ServiceAccountName.
   * Deprecated: Use serviceAccountName instead.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional string serviceAccount = 9;
   */
  serviceAccount?: string;

  /**
   * AutomountServiceAccountToken indicates whether a service account token should be automatically mounted.
   * +optional
   *
   * @generated from field: optional bool automountServiceAccountToken = 21;
   */
  automountServiceAccountToken?: boolean;

  /**
   * NodeName indicates in which node this pod is scheduled.
   * If empty, this pod is a candidate for scheduling by the scheduler defined in schedulerName.
   * Once this field is set, the kubelet for this node becomes responsible for the lifecycle of this pod.
   * This field should not be used to express a desire for the pod to be scheduled on a specific node.
   * https://kubernetes.io/docs/concepts/scheduling-eviction/assign-pod-node/#nodename
   * +optional
   *
   * @generated from field: optional string nodeName = 10;
   */
  nodeName?: string;

  /**
   * Host networking requested for this pod. Use the host's network namespace.
   * If this option is set, the ports that will be used must be specified.
   * Default to false.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional bool hostNetwork = 11;
   */
  hostNetwork?: boolean;

  /**
   * Use the host's pid namespace.
   * Optional: Default to false.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional bool hostPID = 12;
   */
  hostPID?: boolean;

  /**
   * Use the host's ipc namespace.
   * Optional: Default to false.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional bool hostIPC = 13;
   */
  hostIPC?: boolean;

  /**
   * Share a single process namespace between all of the containers in a pod.
   * When this is set containers will be able to view and signal processes from other containers
   * in the same pod, and the first process in each container will not be assigned PID 1.
   * HostPID and ShareProcessNamespace cannot both be set.
   * Optional: Default to false.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional bool shareProcessNamespace = 27;
   */
  shareProcessNamespace?: boolean;

  /**
   * SecurityContext holds pod-level security attributes and common container settings.
   * Optional: Defaults to empty.  See type description for default values of each field.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodSecurityContext securityContext = 14;
   */
  securityContext?: PodSecurityContext;

  /**
   * ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec.
   * If specified, these secrets will be passed to individual puller implementations for them to use.
   * More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.LocalObjectReference imagePullSecrets = 15;
   */
  imagePullSecrets: LocalObjectReference[] = [];

  /**
   * Specifies the hostname of the Pod
   * If not specified, the pod's hostname will be set to a system-defined value.
   * +optional
   *
   * @generated from field: optional string hostname = 16;
   */
  hostname?: string;

  /**
   * If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
   * If not specified, the pod will not have a domainname at all.
   * +optional
   *
   * @generated from field: optional string subdomain = 17;
   */
  subdomain?: string;

  /**
   * If specified, the pod's scheduling constraints
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Affinity affinity = 18;
   */
  affinity?: Affinity;

  /**
   * If specified, the pod will be dispatched by specified scheduler.
   * If not specified, the pod will be dispatched by default scheduler.
   * +optional
   *
   * @generated from field: optional string schedulerName = 19;
   */
  schedulerName?: string;

  /**
   * If specified, the pod's tolerations.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.Toleration tolerations = 22;
   */
  tolerations: Toleration[] = [];

  /**
   * HostAliases is an optional list of hosts and IPs that will be injected into the pod's hosts
   * file if specified.
   * +optional
   * +patchMergeKey=ip
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=ip
   *
   * @generated from field: repeated k8s.io.api.core.v1.HostAlias hostAliases = 23;
   */
  hostAliases: HostAlias[] = [];

  /**
   * If specified, indicates the pod's priority. "system-node-critical" and
   * "system-cluster-critical" are two special keywords which indicate the
   * highest priorities with the former being the highest priority. Any other
   * name must be defined by creating a PriorityClass object with that name.
   * If not specified, the pod priority will be default or zero if there is no
   * default.
   * +optional
   *
   * @generated from field: optional string priorityClassName = 24;
   */
  priorityClassName?: string;

  /**
   * The priority value. Various system components use this field to find the
   * priority of the pod. When Priority Admission Controller is enabled, it
   * prevents users from setting this field. The admission controller populates
   * this field from PriorityClassName.
   * The higher the value, the higher the priority.
   * +optional
   *
   * @generated from field: optional int32 priority = 25;
   */
  priority?: number;

  /**
   * Specifies the DNS parameters of a pod.
   * Parameters specified here will be merged to the generated DNS
   * configuration based on DNSPolicy.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodDNSConfig dnsConfig = 26;
   */
  dnsConfig?: PodDNSConfig;

  /**
   * If specified, all readiness gates will be evaluated for pod readiness.
   * A pod is ready when all its containers are ready AND
   * all conditions specified in the readiness gates have status equal to "True"
   * More info: https://git.k8s.io/enhancements/keps/sig-network/580-pod-readiness-gates
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodReadinessGate readinessGates = 28;
   */
  readinessGates: PodReadinessGate[] = [];

  /**
   * RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group, which should be used
   * to run this pod.  If no RuntimeClass resource matches the named class, the pod will not be run.
   * If unset or empty, the "legacy" RuntimeClass will be used, which is an implicit class with an
   * empty definition that uses the default runtime handler.
   * More info: https://git.k8s.io/enhancements/keps/sig-node/585-runtime-class
   * +optional
   *
   * @generated from field: optional string runtimeClassName = 29;
   */
  runtimeClassName?: string;

  /**
   * EnableServiceLinks indicates whether information about services should be injected into pod's
   * environment variables, matching the syntax of Docker links.
   * Optional: Defaults to true.
   * +optional
   *
   * @generated from field: optional bool enableServiceLinks = 30;
   */
  enableServiceLinks?: boolean;

  /**
   * PreemptionPolicy is the Policy for preempting pods with lower priority.
   * One of Never, PreemptLowerPriority.
   * Defaults to PreemptLowerPriority if unset.
   * +optional
   *
   * @generated from field: optional string preemptionPolicy = 31;
   */
  preemptionPolicy?: string;

  /**
   * Overhead represents the resource overhead associated with running a pod for a given RuntimeClass.
   * This field will be autopopulated at admission time by the RuntimeClass admission controller. If
   * the RuntimeClass admission controller is enabled, overhead must not be set in Pod create requests.
   * The RuntimeClass admission controller will reject Pod create requests which have the overhead already
   * set. If RuntimeClass is configured and selected in the PodSpec, Overhead will be set to the value
   * defined in the corresponding RuntimeClass, otherwise it will remain unset and treated as zero.
   * More info: https://git.k8s.io/enhancements/keps/sig-node/688-pod-overhead/README.md
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> overhead = 32;
   */
  overhead: { [key: string]: Quantity } = {};

  /**
   * TopologySpreadConstraints describes how a group of pods ought to spread across topology
   * domains. Scheduler will schedule pods in a way which abides by the constraints.
   * All topologySpreadConstraints are ANDed.
   * +optional
   * +patchMergeKey=topologyKey
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=topologyKey
   * +listMapKey=whenUnsatisfiable
   *
   * @generated from field: repeated k8s.io.api.core.v1.TopologySpreadConstraint topologySpreadConstraints = 33;
   */
  topologySpreadConstraints: TopologySpreadConstraint[] = [];

  /**
   * If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).
   * In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
   * In Windows containers, this means setting the registry value of hostname for the registry key HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Services\\Tcpip\\Parameters to FQDN.
   * If a pod does not have FQDN, this has no effect.
   * Default to false.
   * +optional
   *
   * @generated from field: optional bool setHostnameAsFQDN = 35;
   */
  setHostnameAsFQDN?: boolean;

  /**
   * Specifies the OS of the containers in the pod.
   * Some pod and container fields are restricted if this is set.
   *
   * If the OS field is set to linux, the following fields must be unset:
   * -securityContext.windowsOptions
   *
   * If the OS field is set to windows, following fields must be unset:
   * - spec.hostPID
   * - spec.hostIPC
   * - spec.hostUsers
   * - spec.securityContext.appArmorProfile
   * - spec.securityContext.seLinuxOptions
   * - spec.securityContext.seccompProfile
   * - spec.securityContext.fsGroup
   * - spec.securityContext.fsGroupChangePolicy
   * - spec.securityContext.sysctls
   * - spec.shareProcessNamespace
   * - spec.securityContext.runAsUser
   * - spec.securityContext.runAsGroup
   * - spec.securityContext.supplementalGroups
   * - spec.securityContext.supplementalGroupsPolicy
   * - spec.containers[*].securityContext.appArmorProfile
   * - spec.containers[*].securityContext.seLinuxOptions
   * - spec.containers[*].securityContext.seccompProfile
   * - spec.containers[*].securityContext.capabilities
   * - spec.containers[*].securityContext.readOnlyRootFilesystem
   * - spec.containers[*].securityContext.privileged
   * - spec.containers[*].securityContext.allowPrivilegeEscalation
   * - spec.containers[*].securityContext.procMount
   * - spec.containers[*].securityContext.runAsUser
   * - spec.containers[*].securityContext.runAsGroup
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodOS os = 36;
   */
  os?: PodOS;

  /**
   * Use the host's user namespace.
   * Optional: Default to true.
   * If set to true or not present, the pod will be run in the host user namespace, useful
   * for when the pod needs a feature only available to the host user namespace, such as
   * loading a kernel module with CAP_SYS_MODULE.
   * When set to false, a new userns is created for the pod. Setting false is useful for
   * mitigating container breakout vulnerabilities even allowing users to run their
   * containers as root without actually having root privileges on the host.
   * This field is alpha-level and is only honored by servers that enable the UserNamespacesSupport feature.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional bool hostUsers = 37;
   */
  hostUsers?: boolean;

  /**
   * SchedulingGates is an opaque list of values that if specified will block scheduling the pod.
   * If schedulingGates is not empty, the pod will stay in the SchedulingGated state and the
   * scheduler will not attempt to schedule the pod.
   *
   * SchedulingGates can only be set at pod creation time, and be removed only afterwards.
   *
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodSchedulingGate schedulingGates = 38;
   */
  schedulingGates: PodSchedulingGate[] = [];

  /**
   * ResourceClaims defines which ResourceClaims must be allocated
   * and reserved before the Pod is allowed to start. The resources
   * will be made available to those containers which consume them
   * by name.
   *
   * This is an alpha field and requires enabling the
   * DynamicResourceAllocation feature gate.
   *
   * This field is immutable.
   *
   * +patchMergeKey=name
   * +patchStrategy=merge,retainKeys
   * +listType=map
   * +listMapKey=name
   * +featureGate=DynamicResourceAllocation
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodResourceClaim resourceClaims = 39;
   */
  resourceClaims: PodResourceClaim[] = [];

  constructor(data?: PartialMessage<PodSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumes", kind: "message", T: Volume, repeated: true },
    { no: 20, name: "initContainers", kind: "message", T: Container, repeated: true },
    { no: 2, name: "containers", kind: "message", T: Container, repeated: true },
    { no: 34, name: "ephemeralContainers", kind: "message", T: EphemeralContainer, repeated: true },
    { no: 3, name: "restartPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "terminationGracePeriodSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 5, name: "activeDeadlineSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 6, name: "dnsPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "nodeSelector", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 8, name: "serviceAccountName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "serviceAccount", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 21, name: "automountServiceAccountToken", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 10, name: "nodeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 11, name: "hostNetwork", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 12, name: "hostPID", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 13, name: "hostIPC", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 27, name: "shareProcessNamespace", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 14, name: "securityContext", kind: "message", T: PodSecurityContext, opt: true },
    { no: 15, name: "imagePullSecrets", kind: "message", T: LocalObjectReference, repeated: true },
    { no: 16, name: "hostname", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 17, name: "subdomain", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 18, name: "affinity", kind: "message", T: Affinity, opt: true },
    { no: 19, name: "schedulerName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 22, name: "tolerations", kind: "message", T: Toleration, repeated: true },
    { no: 23, name: "hostAliases", kind: "message", T: HostAlias, repeated: true },
    { no: 24, name: "priorityClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 25, name: "priority", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 26, name: "dnsConfig", kind: "message", T: PodDNSConfig, opt: true },
    { no: 28, name: "readinessGates", kind: "message", T: PodReadinessGate, repeated: true },
    { no: 29, name: "runtimeClassName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 30, name: "enableServiceLinks", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 31, name: "preemptionPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 32, name: "overhead", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 33, name: "topologySpreadConstraints", kind: "message", T: TopologySpreadConstraint, repeated: true },
    { no: 35, name: "setHostnameAsFQDN", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 36, name: "os", kind: "message", T: PodOS, opt: true },
    { no: 37, name: "hostUsers", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 38, name: "schedulingGates", kind: "message", T: PodSchedulingGate, repeated: true },
    { no: 39, name: "resourceClaims", kind: "message", T: PodResourceClaim, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodSpec {
    return new PodSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodSpec {
    return new PodSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodSpec {
    return new PodSpec().fromJsonString(jsonString, options);
  }

  static equals(a: PodSpec | PlainMessage<PodSpec> | undefined, b: PodSpec | PlainMessage<PodSpec> | undefined): boolean {
    return proto2.util.equals(PodSpec, a, b);
  }
}

/**
 * PodStatus represents information about the status of a pod. Status may trail the actual
 * state of a system, especially if the node that hosts the pod cannot contact the control
 * plane.
 *
 * @generated from message k8s.io.api.core.v1.PodStatus
 */
export class PodStatus extends Message<PodStatus> {
  /**
   * The phase of a Pod is a simple, high-level summary of where the Pod is in its lifecycle.
   * The conditions array, the reason and message fields, and the individual container status
   * arrays contain more detail about the pod's status.
   * There are five possible phase values:
   *
   * Pending: The pod has been accepted by the Kubernetes system, but one or more of the
   * container images has not been created. This includes time before being scheduled as
   * well as time spent downloading images over the network, which could take a while.
   * Running: The pod has been bound to a node, and all of the containers have been created.
   * At least one container is still running, or is in the process of starting or restarting.
   * Succeeded: All containers in the pod have terminated in success, and will not be restarted.
   * Failed: All containers in the pod have terminated, and at least one container has
   * terminated in failure. The container either exited with non-zero status or was terminated
   * by the system.
   * Unknown: For some reason the state of the pod could not be obtained, typically due to an
   * error in communicating with the host of the pod.
   *
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
   * +optional
   *
   * @generated from field: optional string phase = 1;
   */
  phase?: string;

  /**
   * Current service state of pod.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodCondition conditions = 2;
   */
  conditions: PodCondition[] = [];

  /**
   * A human readable message indicating details about why the pod is in this condition.
   * +optional
   *
   * @generated from field: optional string message = 3;
   */
  message?: string;

  /**
   * A brief CamelCase message indicating details about why the pod is in this state.
   * e.g. 'Evicted'
   * +optional
   *
   * @generated from field: optional string reason = 4;
   */
  reason?: string;

  /**
   * nominatedNodeName is set only when this pod preempts other pods on the node, but it cannot be
   * scheduled right away as preemption victims receive their graceful termination periods.
   * This field does not guarantee that the pod will be scheduled on this node. Scheduler may decide
   * to place the pod elsewhere if other nodes become available sooner. Scheduler may also decide to
   * give the resources on this node to a higher priority pod that is created after preemption.
   * As a result, this field may be different than PodSpec.nodeName when the pod is
   * scheduled.
   * +optional
   *
   * @generated from field: optional string nominatedNodeName = 11;
   */
  nominatedNodeName?: string;

  /**
   * hostIP holds the IP address of the host to which the pod is assigned. Empty if the pod has not started yet.
   * A pod can be assigned to a node that has a problem in kubelet which in turns mean that HostIP will
   * not be updated even if there is a node is assigned to pod
   * +optional
   *
   * @generated from field: optional string hostIP = 5;
   */
  hostIP?: string;

  /**
   * hostIPs holds the IP addresses allocated to the host. If this field is specified, the first entry must
   * match the hostIP field. This list is empty if the pod has not started yet.
   * A pod can be assigned to a node that has a problem in kubelet which in turns means that HostIPs will
   * not be updated even if there is a node is assigned to this pod.
   * +optional
   * +patchStrategy=merge
   * +patchMergeKey=ip
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.HostIP hostIPs = 16;
   */
  hostIPs: HostIP[] = [];

  /**
   * podIP address allocated to the pod. Routable at least within the cluster.
   * Empty if not yet allocated.
   * +optional
   *
   * @generated from field: optional string podIP = 6;
   */
  podIP?: string;

  /**
   * podIPs holds the IP addresses allocated to the pod. If this field is specified, the 0th entry must
   * match the podIP field. Pods may be allocated at most 1 value for each of IPv4 and IPv6. This list
   * is empty if no IPs have been allocated yet.
   * +optional
   * +patchStrategy=merge
   * +patchMergeKey=ip
   * +listType=map
   * +listMapKey=ip
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodIP podIPs = 12;
   */
  podIPs: PodIP[] = [];

  /**
   * RFC 3339 date and time at which the object was acknowledged by the Kubelet.
   * This is before the Kubelet pulled the container image(s) for the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time startTime = 7;
   */
  startTime?: Time;

  /**
   * The list has one entry per init container in the manifest. The most recent successful
   * init container will have ready = true, the most recently started container will have
   * startTime set.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerStatus initContainerStatuses = 10;
   */
  initContainerStatuses: ContainerStatus[] = [];

  /**
   * The list has one entry per container in the manifest.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerStatus containerStatuses = 8;
   */
  containerStatuses: ContainerStatus[] = [];

  /**
   * The Quality of Service (QOS) classification assigned to the pod based on resource requirements
   * See PodQOSClass type for available QOS classes
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-qos/#quality-of-service-classes
   * +optional
   *
   * @generated from field: optional string qosClass = 9;
   */
  qosClass?: string;

  /**
   * Status for any ephemeral containers that have run in this pod.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ContainerStatus ephemeralContainerStatuses = 13;
   */
  ephemeralContainerStatuses: ContainerStatus[] = [];

  /**
   * Status of resources resize desired for pod's containers.
   * It is empty if no resources resize is pending.
   * Any changes to container resources will automatically set this to "Proposed"
   * +featureGate=InPlacePodVerticalScaling
   * +optional
   *
   * @generated from field: optional string resize = 14;
   */
  resize?: string;

  /**
   * Status of resource claims.
   * +patchMergeKey=name
   * +patchStrategy=merge,retainKeys
   * +listType=map
   * +listMapKey=name
   * +featureGate=DynamicResourceAllocation
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodResourceClaimStatus resourceClaimStatuses = 15;
   */
  resourceClaimStatuses: PodResourceClaimStatus[] = [];

  constructor(data?: PartialMessage<PodStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "phase", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "conditions", kind: "message", T: PodCondition, repeated: true },
    { no: 3, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 11, name: "nominatedNodeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "hostIP", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 16, name: "hostIPs", kind: "message", T: HostIP, repeated: true },
    { no: 6, name: "podIP", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 12, name: "podIPs", kind: "message", T: PodIP, repeated: true },
    { no: 7, name: "startTime", kind: "message", T: Time, opt: true },
    { no: 10, name: "initContainerStatuses", kind: "message", T: ContainerStatus, repeated: true },
    { no: 8, name: "containerStatuses", kind: "message", T: ContainerStatus, repeated: true },
    { no: 9, name: "qosClass", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 13, name: "ephemeralContainerStatuses", kind: "message", T: ContainerStatus, repeated: true },
    { no: 14, name: "resize", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 15, name: "resourceClaimStatuses", kind: "message", T: PodResourceClaimStatus, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodStatus {
    return new PodStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodStatus {
    return new PodStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodStatus {
    return new PodStatus().fromJsonString(jsonString, options);
  }

  static equals(a: PodStatus | PlainMessage<PodStatus> | undefined, b: PodStatus | PlainMessage<PodStatus> | undefined): boolean {
    return proto2.util.equals(PodStatus, a, b);
  }
}

/**
 * PodStatusResult is a wrapper for PodStatus returned by kubelet that can be encode/decoded
 *
 * @generated from message k8s.io.api.core.v1.PodStatusResult
 */
export class PodStatusResult extends Message<PodStatusResult> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Most recently observed status of the pod.
   * This data may not be up to date.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodStatus status = 2;
   */
  status?: PodStatus;

  constructor(data?: PartialMessage<PodStatusResult>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodStatusResult";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "status", kind: "message", T: PodStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodStatusResult {
    return new PodStatusResult().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodStatusResult {
    return new PodStatusResult().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodStatusResult {
    return new PodStatusResult().fromJsonString(jsonString, options);
  }

  static equals(a: PodStatusResult | PlainMessage<PodStatusResult> | undefined, b: PodStatusResult | PlainMessage<PodStatusResult> | undefined): boolean {
    return proto2.util.equals(PodStatusResult, a, b);
  }
}

/**
 * PodTemplate describes a template for creating copies of a predefined pod.
 *
 * @generated from message k8s.io.api.core.v1.PodTemplate
 */
export class PodTemplate extends Message<PodTemplate> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Template defines the pods that will be created from this pod template.
   * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodTemplateSpec template = 2;
   */
  template?: PodTemplateSpec;

  constructor(data?: PartialMessage<PodTemplate>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodTemplate";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "template", kind: "message", T: PodTemplateSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodTemplate {
    return new PodTemplate().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodTemplate {
    return new PodTemplate().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodTemplate {
    return new PodTemplate().fromJsonString(jsonString, options);
  }

  static equals(a: PodTemplate | PlainMessage<PodTemplate> | undefined, b: PodTemplate | PlainMessage<PodTemplate> | undefined): boolean {
    return proto2.util.equals(PodTemplate, a, b);
  }
}

/**
 * PodTemplateList is a list of PodTemplates.
 *
 * @generated from message k8s.io.api.core.v1.PodTemplateList
 */
export class PodTemplateList extends Message<PodTemplateList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of pod templates
   *
   * @generated from field: repeated k8s.io.api.core.v1.PodTemplate items = 2;
   */
  items: PodTemplate[] = [];

  constructor(data?: PartialMessage<PodTemplateList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodTemplateList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: PodTemplate, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodTemplateList {
    return new PodTemplateList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodTemplateList {
    return new PodTemplateList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodTemplateList {
    return new PodTemplateList().fromJsonString(jsonString, options);
  }

  static equals(a: PodTemplateList | PlainMessage<PodTemplateList> | undefined, b: PodTemplateList | PlainMessage<PodTemplateList> | undefined): boolean {
    return proto2.util.equals(PodTemplateList, a, b);
  }
}

/**
 * PodTemplateSpec describes the data a pod should have when created from a template
 *
 * @generated from message k8s.io.api.core.v1.PodTemplateSpec
 */
export class PodTemplateSpec extends Message<PodTemplateSpec> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Specification of the desired behavior of the pod.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodSpec spec = 2;
   */
  spec?: PodSpec;

  constructor(data?: PartialMessage<PodTemplateSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PodTemplateSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: PodSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodTemplateSpec {
    return new PodTemplateSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodTemplateSpec {
    return new PodTemplateSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodTemplateSpec {
    return new PodTemplateSpec().fromJsonString(jsonString, options);
  }

  static equals(a: PodTemplateSpec | PlainMessage<PodTemplateSpec> | undefined, b: PodTemplateSpec | PlainMessage<PodTemplateSpec> | undefined): boolean {
    return proto2.util.equals(PodTemplateSpec, a, b);
  }
}

/**
 * @generated from message k8s.io.api.core.v1.PortStatus
 */
export class PortStatus extends Message<PortStatus> {
  /**
   * Port is the port number of the service port of which status is recorded here
   *
   * @generated from field: optional int32 port = 1;
   */
  port?: number;

  /**
   * Protocol is the protocol of the service port of which status is recorded here
   * The supported values are: "TCP", "UDP", "SCTP"
   *
   * @generated from field: optional string protocol = 2;
   */
  protocol?: string;

  /**
   * Error is to record the problem with the service port
   * The format of the error shall comply with the following rules:
   * - built-in error values shall be specified in this file and those shall use
   *   CamelCase names
   * - cloud provider specific error values must have names that comply with the
   *   format foo.example.com/CamelCase.
   * ---
   * The regex it matches is (dns1123SubdomainFmt/)?(qualifiedNameFmt)
   * +optional
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:Pattern=`^([a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*\/)?(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])$`
   * +kubebuilder:validation:MaxLength=316
   *
   * @generated from field: optional string error = 3;
   */
  error?: string;

  constructor(data?: PartialMessage<PortStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PortStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "protocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "error", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PortStatus {
    return new PortStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PortStatus {
    return new PortStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PortStatus {
    return new PortStatus().fromJsonString(jsonString, options);
  }

  static equals(a: PortStatus | PlainMessage<PortStatus> | undefined, b: PortStatus | PlainMessage<PortStatus> | undefined): boolean {
    return proto2.util.equals(PortStatus, a, b);
  }
}

/**
 * PortworxVolumeSource represents a Portworx volume resource.
 *
 * @generated from message k8s.io.api.core.v1.PortworxVolumeSource
 */
export class PortworxVolumeSource extends Message<PortworxVolumeSource> {
  /**
   * volumeID uniquely identifies a Portworx volume
   *
   * @generated from field: optional string volumeID = 1;
   */
  volumeID?: string;

  /**
   * fSType represents the filesystem type to mount
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<PortworxVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PortworxVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PortworxVolumeSource {
    return new PortworxVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PortworxVolumeSource {
    return new PortworxVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PortworxVolumeSource {
    return new PortworxVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: PortworxVolumeSource | PlainMessage<PortworxVolumeSource> | undefined, b: PortworxVolumeSource | PlainMessage<PortworxVolumeSource> | undefined): boolean {
    return proto2.util.equals(PortworxVolumeSource, a, b);
  }
}

/**
 * Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
 * +k8s:openapi-gen=false
 *
 * @generated from message k8s.io.api.core.v1.Preconditions
 */
export class Preconditions extends Message<Preconditions> {
  /**
   * Specifies the target UID.
   * +optional
   *
   * @generated from field: optional string uid = 1;
   */
  uid?: string;

  constructor(data?: PartialMessage<Preconditions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Preconditions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Preconditions {
    return new Preconditions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Preconditions {
    return new Preconditions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Preconditions {
    return new Preconditions().fromJsonString(jsonString, options);
  }

  static equals(a: Preconditions | PlainMessage<Preconditions> | undefined, b: Preconditions | PlainMessage<Preconditions> | undefined): boolean {
    return proto2.util.equals(Preconditions, a, b);
  }
}

/**
 * Describes a class of pods that should avoid this node.
 *
 * @generated from message k8s.io.api.core.v1.PreferAvoidPodsEntry
 */
export class PreferAvoidPodsEntry extends Message<PreferAvoidPodsEntry> {
  /**
   * The class of pods.
   *
   * @generated from field: optional k8s.io.api.core.v1.PodSignature podSignature = 1;
   */
  podSignature?: PodSignature;

  /**
   * Time at which this entry was added to the list.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time evictionTime = 2;
   */
  evictionTime?: Time;

  /**
   * (brief) reason why this entry was added to the list.
   * +optional
   *
   * @generated from field: optional string reason = 3;
   */
  reason?: string;

  /**
   * Human readable message indicating why this entry was added to the list.
   * +optional
   *
   * @generated from field: optional string message = 4;
   */
  message?: string;

  constructor(data?: PartialMessage<PreferAvoidPodsEntry>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PreferAvoidPodsEntry";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "podSignature", kind: "message", T: PodSignature, opt: true },
    { no: 2, name: "evictionTime", kind: "message", T: Time, opt: true },
    { no: 3, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PreferAvoidPodsEntry {
    return new PreferAvoidPodsEntry().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PreferAvoidPodsEntry {
    return new PreferAvoidPodsEntry().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PreferAvoidPodsEntry {
    return new PreferAvoidPodsEntry().fromJsonString(jsonString, options);
  }

  static equals(a: PreferAvoidPodsEntry | PlainMessage<PreferAvoidPodsEntry> | undefined, b: PreferAvoidPodsEntry | PlainMessage<PreferAvoidPodsEntry> | undefined): boolean {
    return proto2.util.equals(PreferAvoidPodsEntry, a, b);
  }
}

/**
 * An empty preferred scheduling term matches all objects with implicit weight 0
 * (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op).
 *
 * @generated from message k8s.io.api.core.v1.PreferredSchedulingTerm
 */
export class PreferredSchedulingTerm extends Message<PreferredSchedulingTerm> {
  /**
   * Weight associated with matching the corresponding nodeSelectorTerm, in the range 1-100.
   *
   * @generated from field: optional int32 weight = 1;
   */
  weight?: number;

  /**
   * A node selector term, associated with the corresponding weight.
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeSelectorTerm preference = 2;
   */
  preference?: NodeSelectorTerm;

  constructor(data?: PartialMessage<PreferredSchedulingTerm>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.PreferredSchedulingTerm";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "weight", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "preference", kind: "message", T: NodeSelectorTerm, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PreferredSchedulingTerm {
    return new PreferredSchedulingTerm().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PreferredSchedulingTerm {
    return new PreferredSchedulingTerm().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PreferredSchedulingTerm {
    return new PreferredSchedulingTerm().fromJsonString(jsonString, options);
  }

  static equals(a: PreferredSchedulingTerm | PlainMessage<PreferredSchedulingTerm> | undefined, b: PreferredSchedulingTerm | PlainMessage<PreferredSchedulingTerm> | undefined): boolean {
    return proto2.util.equals(PreferredSchedulingTerm, a, b);
  }
}

/**
 * Probe describes a health check to be performed against a container to determine whether it is
 * alive or ready to receive traffic.
 *
 * @generated from message k8s.io.api.core.v1.Probe
 */
export class Probe extends Message<Probe> {
  /**
   * The action taken to determine the health of a container
   *
   * @generated from field: optional k8s.io.api.core.v1.ProbeHandler handler = 1;
   */
  handler?: ProbeHandler;

  /**
   * Number of seconds after the container has started before liveness probes are initiated.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
   * +optional
   *
   * @generated from field: optional int32 initialDelaySeconds = 2;
   */
  initialDelaySeconds?: number;

  /**
   * Number of seconds after which the probe times out.
   * Defaults to 1 second. Minimum value is 1.
   * More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
   * +optional
   *
   * @generated from field: optional int32 timeoutSeconds = 3;
   */
  timeoutSeconds?: number;

  /**
   * How often (in seconds) to perform the probe.
   * Default to 10 seconds. Minimum value is 1.
   * +optional
   *
   * @generated from field: optional int32 periodSeconds = 4;
   */
  periodSeconds?: number;

  /**
   * Minimum consecutive successes for the probe to be considered successful after having failed.
   * Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
   * +optional
   *
   * @generated from field: optional int32 successThreshold = 5;
   */
  successThreshold?: number;

  /**
   * Minimum consecutive failures for the probe to be considered failed after having succeeded.
   * Defaults to 3. Minimum value is 1.
   * +optional
   *
   * @generated from field: optional int32 failureThreshold = 6;
   */
  failureThreshold?: number;

  /**
   * Optional duration in seconds the pod needs to terminate gracefully upon probe failure.
   * The grace period is the duration in seconds after the processes running in the pod are sent
   * a termination signal and the time when the processes are forcibly halted with a kill signal.
   * Set this value longer than the expected cleanup time for your process.
   * If this value is nil, the pod's terminationGracePeriodSeconds will be used. Otherwise, this
   * value overrides the value provided by the pod spec.
   * Value must be non-negative integer. The value zero indicates stop immediately via
   * the kill signal (no opportunity to shut down).
   * This is a beta field and requires enabling ProbeTerminationGracePeriod feature gate.
   * Minimum value is 1. spec.terminationGracePeriodSeconds is used if unset.
   * +optional
   *
   * @generated from field: optional int64 terminationGracePeriodSeconds = 7;
   */
  terminationGracePeriodSeconds?: bigint;

  constructor(data?: PartialMessage<Probe>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Probe";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "handler", kind: "message", T: ProbeHandler, opt: true },
    { no: 2, name: "initialDelaySeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "timeoutSeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "periodSeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 5, name: "successThreshold", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 6, name: "failureThreshold", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 7, name: "terminationGracePeriodSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Probe {
    return new Probe().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Probe {
    return new Probe().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Probe {
    return new Probe().fromJsonString(jsonString, options);
  }

  static equals(a: Probe | PlainMessage<Probe> | undefined, b: Probe | PlainMessage<Probe> | undefined): boolean {
    return proto2.util.equals(Probe, a, b);
  }
}

/**
 * ProbeHandler defines a specific action that should be taken in a probe.
 * One and only one of the fields must be specified.
 *
 * @generated from message k8s.io.api.core.v1.ProbeHandler
 */
export class ProbeHandler extends Message<ProbeHandler> {
  /**
   * Exec specifies the action to take.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ExecAction exec = 1;
   */
  exec?: ExecAction;

  /**
   * HTTPGet specifies the http request to perform.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.HTTPGetAction httpGet = 2;
   */
  httpGet?: HTTPGetAction;

  /**
   * TCPSocket specifies an action involving a TCP port.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.TCPSocketAction tcpSocket = 3;
   */
  tcpSocket?: TCPSocketAction;

  /**
   * GRPC specifies an action involving a GRPC port.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GRPCAction grpc = 4;
   */
  grpc?: GRPCAction;

  constructor(data?: PartialMessage<ProbeHandler>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ProbeHandler";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "exec", kind: "message", T: ExecAction, opt: true },
    { no: 2, name: "httpGet", kind: "message", T: HTTPGetAction, opt: true },
    { no: 3, name: "tcpSocket", kind: "message", T: TCPSocketAction, opt: true },
    { no: 4, name: "grpc", kind: "message", T: GRPCAction, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ProbeHandler {
    return new ProbeHandler().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ProbeHandler {
    return new ProbeHandler().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ProbeHandler {
    return new ProbeHandler().fromJsonString(jsonString, options);
  }

  static equals(a: ProbeHandler | PlainMessage<ProbeHandler> | undefined, b: ProbeHandler | PlainMessage<ProbeHandler> | undefined): boolean {
    return proto2.util.equals(ProbeHandler, a, b);
  }
}

/**
 * Represents a projected volume source
 *
 * @generated from message k8s.io.api.core.v1.ProjectedVolumeSource
 */
export class ProjectedVolumeSource extends Message<ProjectedVolumeSource> {
  /**
   * sources is the list of volume projections. Each entry in this list
   * handles one source.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.VolumeProjection sources = 1;
   */
  sources: VolumeProjection[] = [];

  /**
   * defaultMode are the mode bits used to set permissions on created files by default.
   * Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values for mode bits.
   * Directories within the path are not affected by this setting.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 defaultMode = 2;
   */
  defaultMode?: number;

  constructor(data?: PartialMessage<ProjectedVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ProjectedVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "sources", kind: "message", T: VolumeProjection, repeated: true },
    { no: 2, name: "defaultMode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ProjectedVolumeSource {
    return new ProjectedVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ProjectedVolumeSource {
    return new ProjectedVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ProjectedVolumeSource {
    return new ProjectedVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ProjectedVolumeSource | PlainMessage<ProjectedVolumeSource> | undefined, b: ProjectedVolumeSource | PlainMessage<ProjectedVolumeSource> | undefined): boolean {
    return proto2.util.equals(ProjectedVolumeSource, a, b);
  }
}

/**
 * Represents a Quobyte mount that lasts the lifetime of a pod.
 * Quobyte volumes do not support ownership management or SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.QuobyteVolumeSource
 */
export class QuobyteVolumeSource extends Message<QuobyteVolumeSource> {
  /**
   * registry represents a single or multiple Quobyte Registry services
   * specified as a string as host:port pair (multiple entries are separated with commas)
   * which acts as the central registry for volumes
   *
   * @generated from field: optional string registry = 1;
   */
  registry?: string;

  /**
   * volume is a string that references an already created Quobyte volume by name.
   *
   * @generated from field: optional string volume = 2;
   */
  volume?: string;

  /**
   * readOnly here will force the Quobyte volume to be mounted with read-only permissions.
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * user to map volume access to
   * Defaults to serivceaccount user
   * +optional
   *
   * @generated from field: optional string user = 4;
   */
  user?: string;

  /**
   * group to map volume access to
   * Default is no group
   * +optional
   *
   * @generated from field: optional string group = 5;
   */
  group?: string;

  /**
   * tenant owning the given Quobyte volume in the Backend
   * Used with dynamically provisioned Quobyte volumes, value is set by the plugin
   * +optional
   *
   * @generated from field: optional string tenant = 6;
   */
  tenant?: string;

  constructor(data?: PartialMessage<QuobyteVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.QuobyteVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "registry", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "volume", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "tenant", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): QuobyteVolumeSource {
    return new QuobyteVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): QuobyteVolumeSource {
    return new QuobyteVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): QuobyteVolumeSource {
    return new QuobyteVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: QuobyteVolumeSource | PlainMessage<QuobyteVolumeSource> | undefined, b: QuobyteVolumeSource | PlainMessage<QuobyteVolumeSource> | undefined): boolean {
    return proto2.util.equals(QuobyteVolumeSource, a, b);
  }
}

/**
 * Represents a Rados Block Device mount that lasts the lifetime of a pod.
 * RBD volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.RBDPersistentVolumeSource
 */
export class RBDPersistentVolumeSource extends Message<RBDPersistentVolumeSource> {
  /**
   * monitors is a collection of Ceph monitors.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +listType=atomic
   *
   * @generated from field: repeated string monitors = 1;
   */
  monitors: string[] = [];

  /**
   * image is the rados image name.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   *
   * @generated from field: optional string image = 2;
   */
  image?: string;

  /**
   * fsType is the filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * pool is the rados pool name.
   * Default is rbd.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="rbd"
   *
   * @generated from field: optional string pool = 4;
   */
  pool?: string;

  /**
   * user is the rados user name.
   * Default is admin.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="admin"
   *
   * @generated from field: optional string user = 5;
   */
  user?: string;

  /**
   * keyring is the path to key ring for RBDUser.
   * Default is /etc/ceph/keyring.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="/etc/ceph/keyring"
   *
   * @generated from field: optional string keyring = 6;
   */
  keyring?: string;

  /**
   * secretRef is name of the authentication secret for RBDUser. If provided
   * overrides keyring.
   * Default is nil.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 7;
   */
  secretRef?: SecretReference;

  /**
   * readOnly here will force the ReadOnly setting in VolumeMounts.
   * Defaults to false.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional bool readOnly = 8;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<RBDPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.RBDPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "monitors", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "pool", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "keyring", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "secretRef", kind: "message", T: SecretReference, opt: true },
    { no: 8, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RBDPersistentVolumeSource {
    return new RBDPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RBDPersistentVolumeSource {
    return new RBDPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RBDPersistentVolumeSource {
    return new RBDPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: RBDPersistentVolumeSource | PlainMessage<RBDPersistentVolumeSource> | undefined, b: RBDPersistentVolumeSource | PlainMessage<RBDPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(RBDPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a Rados Block Device mount that lasts the lifetime of a pod.
 * RBD volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.RBDVolumeSource
 */
export class RBDVolumeSource extends Message<RBDVolumeSource> {
  /**
   * monitors is a collection of Ceph monitors.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +listType=atomic
   *
   * @generated from field: repeated string monitors = 1;
   */
  monitors: string[] = [];

  /**
   * image is the rados image name.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   *
   * @generated from field: optional string image = 2;
   */
  image?: string;

  /**
   * fsType is the filesystem type of the volume that you want to mount.
   * Tip: Ensure that the filesystem type is supported by the host operating system.
   * Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd
   * TODO: how do we prevent errors in the filesystem from compromising the machine
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * pool is the rados pool name.
   * Default is rbd.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="rbd"
   *
   * @generated from field: optional string pool = 4;
   */
  pool?: string;

  /**
   * user is the rados user name.
   * Default is admin.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="admin"
   *
   * @generated from field: optional string user = 5;
   */
  user?: string;

  /**
   * keyring is the path to key ring for RBDUser.
   * Default is /etc/ceph/keyring.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   * +default="/etc/ceph/keyring"
   *
   * @generated from field: optional string keyring = 6;
   */
  keyring?: string;

  /**
   * secretRef is name of the authentication secret for RBDUser. If provided
   * overrides keyring.
   * Default is nil.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 7;
   */
  secretRef?: LocalObjectReference;

  /**
   * readOnly here will force the ReadOnly setting in VolumeMounts.
   * Defaults to false.
   * More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
   * +optional
   *
   * @generated from field: optional bool readOnly = 8;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<RBDVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.RBDVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "monitors", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "image", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "pool", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "keyring", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
    { no: 8, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RBDVolumeSource {
    return new RBDVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RBDVolumeSource {
    return new RBDVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RBDVolumeSource {
    return new RBDVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: RBDVolumeSource | PlainMessage<RBDVolumeSource> | undefined, b: RBDVolumeSource | PlainMessage<RBDVolumeSource> | undefined): boolean {
    return proto2.util.equals(RBDVolumeSource, a, b);
  }
}

/**
 * RangeAllocation is not a public type.
 *
 * @generated from message k8s.io.api.core.v1.RangeAllocation
 */
export class RangeAllocation extends Message<RangeAllocation> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Range is string that identifies the range represented by 'data'.
   *
   * @generated from field: optional string range = 2;
   */
  range?: string;

  /**
   * Data is a bit array containing all allocated addresses in the previous segment.
   *
   * @generated from field: optional bytes data = 3;
   */
  data?: Uint8Array;

  constructor(data?: PartialMessage<RangeAllocation>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.RangeAllocation";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "range", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "data", kind: "scalar", T: 12 /* ScalarType.BYTES */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RangeAllocation {
    return new RangeAllocation().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RangeAllocation {
    return new RangeAllocation().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RangeAllocation {
    return new RangeAllocation().fromJsonString(jsonString, options);
  }

  static equals(a: RangeAllocation | PlainMessage<RangeAllocation> | undefined, b: RangeAllocation | PlainMessage<RangeAllocation> | undefined): boolean {
    return proto2.util.equals(RangeAllocation, a, b);
  }
}

/**
 * ReplicationController represents the configuration of a replication controller.
 *
 * @generated from message k8s.io.api.core.v1.ReplicationController
 */
export class ReplicationController extends Message<ReplicationController> {
  /**
   * If the Labels of a ReplicationController are empty, they are defaulted to
   * be the same as the Pod(s) that the replication controller manages.
   * Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the specification of the desired behavior of the replication controller.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ReplicationControllerSpec spec = 2;
   */
  spec?: ReplicationControllerSpec;

  /**
   * Status is the most recently observed status of the replication controller.
   * This data may be out of date by some window of time.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ReplicationControllerStatus status = 3;
   */
  status?: ReplicationControllerStatus;

  constructor(data?: PartialMessage<ReplicationController>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ReplicationController";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: ReplicationControllerSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: ReplicationControllerStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReplicationController {
    return new ReplicationController().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReplicationController {
    return new ReplicationController().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReplicationController {
    return new ReplicationController().fromJsonString(jsonString, options);
  }

  static equals(a: ReplicationController | PlainMessage<ReplicationController> | undefined, b: ReplicationController | PlainMessage<ReplicationController> | undefined): boolean {
    return proto2.util.equals(ReplicationController, a, b);
  }
}

/**
 * ReplicationControllerCondition describes the state of a replication controller at a certain point.
 *
 * @generated from message k8s.io.api.core.v1.ReplicationControllerCondition
 */
export class ReplicationControllerCondition extends Message<ReplicationControllerCondition> {
  /**
   * Type of replication controller condition.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status of the condition, one of True, False, Unknown.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * The last time the condition transitioned from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;
   */
  lastTransitionTime?: Time;

  /**
   * The reason for the condition's last transition.
   * +optional
   *
   * @generated from field: optional string reason = 4;
   */
  reason?: string;

  /**
   * A human readable message indicating details about the transition.
   * +optional
   *
   * @generated from field: optional string message = 5;
   */
  message?: string;

  constructor(data?: PartialMessage<ReplicationControllerCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ReplicationControllerCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReplicationControllerCondition {
    return new ReplicationControllerCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReplicationControllerCondition {
    return new ReplicationControllerCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReplicationControllerCondition {
    return new ReplicationControllerCondition().fromJsonString(jsonString, options);
  }

  static equals(a: ReplicationControllerCondition | PlainMessage<ReplicationControllerCondition> | undefined, b: ReplicationControllerCondition | PlainMessage<ReplicationControllerCondition> | undefined): boolean {
    return proto2.util.equals(ReplicationControllerCondition, a, b);
  }
}

/**
 * ReplicationControllerList is a collection of replication controllers.
 *
 * @generated from message k8s.io.api.core.v1.ReplicationControllerList
 */
export class ReplicationControllerList extends Message<ReplicationControllerList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of replication controllers.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
   *
   * @generated from field: repeated k8s.io.api.core.v1.ReplicationController items = 2;
   */
  items: ReplicationController[] = [];

  constructor(data?: PartialMessage<ReplicationControllerList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ReplicationControllerList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: ReplicationController, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReplicationControllerList {
    return new ReplicationControllerList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReplicationControllerList {
    return new ReplicationControllerList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReplicationControllerList {
    return new ReplicationControllerList().fromJsonString(jsonString, options);
  }

  static equals(a: ReplicationControllerList | PlainMessage<ReplicationControllerList> | undefined, b: ReplicationControllerList | PlainMessage<ReplicationControllerList> | undefined): boolean {
    return proto2.util.equals(ReplicationControllerList, a, b);
  }
}

/**
 * ReplicationControllerSpec is the specification of a replication controller.
 *
 * @generated from message k8s.io.api.core.v1.ReplicationControllerSpec
 */
export class ReplicationControllerSpec extends Message<ReplicationControllerSpec> {
  /**
   * Replicas is the number of desired replicas.
   * This is a pointer to distinguish between explicit zero and unspecified.
   * Defaults to 1.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
   * +optional
   *
   * @generated from field: optional int32 replicas = 1;
   */
  replicas?: number;

  /**
   * Minimum number of seconds for which a newly created pod should be ready
   * without any of its container crashing, for it to be considered available.
   * Defaults to 0 (pod will be considered available as soon as it is ready)
   * +optional
   *
   * @generated from field: optional int32 minReadySeconds = 4;
   */
  minReadySeconds?: number;

  /**
   * Selector is a label query over pods that should match the Replicas count.
   * If Selector is empty, it is defaulted to the labels present on the Pod template.
   * Label keys and values that must match in order to be controlled by this replication
   * controller, if empty defaulted to labels on Pod template.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
   * +optional
   * +mapType=atomic
   *
   * @generated from field: map<string, string> selector = 2;
   */
  selector: { [key: string]: string } = {};

  /**
   * Template is the object that describes the pod that will be created if
   * insufficient replicas are detected. This takes precedence over a TemplateRef.
   * The only allowed template.spec.restartPolicy value is "Always".
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PodTemplateSpec template = 3;
   */
  template?: PodTemplateSpec;

  constructor(data?: PartialMessage<ReplicationControllerSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ReplicationControllerSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "replicas", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "minReadySeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "selector", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 3, name: "template", kind: "message", T: PodTemplateSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReplicationControllerSpec {
    return new ReplicationControllerSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReplicationControllerSpec {
    return new ReplicationControllerSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReplicationControllerSpec {
    return new ReplicationControllerSpec().fromJsonString(jsonString, options);
  }

  static equals(a: ReplicationControllerSpec | PlainMessage<ReplicationControllerSpec> | undefined, b: ReplicationControllerSpec | PlainMessage<ReplicationControllerSpec> | undefined): boolean {
    return proto2.util.equals(ReplicationControllerSpec, a, b);
  }
}

/**
 * ReplicationControllerStatus represents the current status of a replication
 * controller.
 *
 * @generated from message k8s.io.api.core.v1.ReplicationControllerStatus
 */
export class ReplicationControllerStatus extends Message<ReplicationControllerStatus> {
  /**
   * Replicas is the most recently observed number of replicas.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
   *
   * @generated from field: optional int32 replicas = 1;
   */
  replicas?: number;

  /**
   * The number of pods that have labels matching the labels of the pod template of the replication controller.
   * +optional
   *
   * @generated from field: optional int32 fullyLabeledReplicas = 2;
   */
  fullyLabeledReplicas?: number;

  /**
   * The number of ready replicas for this replication controller.
   * +optional
   *
   * @generated from field: optional int32 readyReplicas = 4;
   */
  readyReplicas?: number;

  /**
   * The number of available replicas (ready for at least minReadySeconds) for this replication controller.
   * +optional
   *
   * @generated from field: optional int32 availableReplicas = 5;
   */
  availableReplicas?: number;

  /**
   * ObservedGeneration reflects the generation of the most recently observed replication controller.
   * +optional
   *
   * @generated from field: optional int64 observedGeneration = 3;
   */
  observedGeneration?: bigint;

  /**
   * Represents the latest available observations of a replication controller's current state.
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.api.core.v1.ReplicationControllerCondition conditions = 6;
   */
  conditions: ReplicationControllerCondition[] = [];

  constructor(data?: PartialMessage<ReplicationControllerStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ReplicationControllerStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "replicas", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "fullyLabeledReplicas", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "readyReplicas", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 5, name: "availableReplicas", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "observedGeneration", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 6, name: "conditions", kind: "message", T: ReplicationControllerCondition, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ReplicationControllerStatus {
    return new ReplicationControllerStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ReplicationControllerStatus {
    return new ReplicationControllerStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ReplicationControllerStatus {
    return new ReplicationControllerStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ReplicationControllerStatus | PlainMessage<ReplicationControllerStatus> | undefined, b: ReplicationControllerStatus | PlainMessage<ReplicationControllerStatus> | undefined): boolean {
    return proto2.util.equals(ReplicationControllerStatus, a, b);
  }
}

/**
 * ResourceClaim references one entry in PodSpec.ResourceClaims.
 *
 * @generated from message k8s.io.api.core.v1.ResourceClaim
 */
export class ResourceClaim extends Message<ResourceClaim> {
  /**
   * Name must match the name of one entry in pod.spec.resourceClaims of
   * the Pod where this field is used. It makes that resource available
   * inside a container.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Request is the name chosen for a request in the referenced claim.
   * If empty, everything from the claim is made available, otherwise
   * only the result of this request.
   *
   * +optional
   *
   * @generated from field: optional string request = 2;
   */
  request?: string;

  constructor(data?: PartialMessage<ResourceClaim>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceClaim";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "request", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceClaim {
    return new ResourceClaim().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceClaim {
    return new ResourceClaim().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceClaim {
    return new ResourceClaim().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceClaim | PlainMessage<ResourceClaim> | undefined, b: ResourceClaim | PlainMessage<ResourceClaim> | undefined): boolean {
    return proto2.util.equals(ResourceClaim, a, b);
  }
}

/**
 * ResourceFieldSelector represents container resources (cpu, memory) and their output format
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.ResourceFieldSelector
 */
export class ResourceFieldSelector extends Message<ResourceFieldSelector> {
  /**
   * Container name: required for volumes, optional for env vars
   * +optional
   *
   * @generated from field: optional string containerName = 1;
   */
  containerName?: string;

  /**
   * Required: resource to select
   *
   * @generated from field: optional string resource = 2;
   */
  resource?: string;

  /**
   * Specifies the output format of the exposed resources, defaults to "1"
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.api.resource.Quantity divisor = 3;
   */
  divisor?: Quantity;

  constructor(data?: PartialMessage<ResourceFieldSelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceFieldSelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "containerName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resource", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "divisor", kind: "message", T: Quantity, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceFieldSelector {
    return new ResourceFieldSelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceFieldSelector {
    return new ResourceFieldSelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceFieldSelector {
    return new ResourceFieldSelector().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceFieldSelector | PlainMessage<ResourceFieldSelector> | undefined, b: ResourceFieldSelector | PlainMessage<ResourceFieldSelector> | undefined): boolean {
    return proto2.util.equals(ResourceFieldSelector, a, b);
  }
}

/**
 * ResourceHealth represents the health of a resource. It has the latest device health information.
 * This is a part of KEP https://kep.k8s.io/4680 and historical health changes are planned to be added in future iterations of a KEP.
 *
 * @generated from message k8s.io.api.core.v1.ResourceHealth
 */
export class ResourceHealth extends Message<ResourceHealth> {
  /**
   * ResourceID is the unique identifier of the resource. See the ResourceID type for more information.
   *
   * @generated from field: optional string resourceID = 1;
   */
  resourceID?: string;

  /**
   * Health of the resource.
   * can be one of:
   *  - Healthy: operates as normal
   *  - Unhealthy: reported unhealthy. We consider this a temporary health issue
   *               since we do not have a mechanism today to distinguish
   *               temporary and permanent issues.
   *  - Unknown: The status cannot be determined.
   *             For example, Device Plugin got unregistered and hasn't been re-registered since.
   *
   * In future we may want to introduce the PermanentlyUnhealthy Status.
   *
   * @generated from field: optional string health = 2;
   */
  health?: string;

  constructor(data?: PartialMessage<ResourceHealth>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceHealth";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "resourceID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "health", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceHealth {
    return new ResourceHealth().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceHealth {
    return new ResourceHealth().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceHealth {
    return new ResourceHealth().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceHealth | PlainMessage<ResourceHealth> | undefined, b: ResourceHealth | PlainMessage<ResourceHealth> | undefined): boolean {
    return proto2.util.equals(ResourceHealth, a, b);
  }
}

/**
 * ResourceQuota sets aggregate quota restrictions enforced per namespace
 *
 * @generated from message k8s.io.api.core.v1.ResourceQuota
 */
export class ResourceQuota extends Message<ResourceQuota> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the desired quota.
   * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceQuotaSpec spec = 2;
   */
  spec?: ResourceQuotaSpec;

  /**
   * Status defines the actual enforced quota and its current usage.
   * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ResourceQuotaStatus status = 3;
   */
  status?: ResourceQuotaStatus;

  constructor(data?: PartialMessage<ResourceQuota>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceQuota";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: ResourceQuotaSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: ResourceQuotaStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceQuota {
    return new ResourceQuota().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceQuota {
    return new ResourceQuota().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceQuota {
    return new ResourceQuota().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceQuota | PlainMessage<ResourceQuota> | undefined, b: ResourceQuota | PlainMessage<ResourceQuota> | undefined): boolean {
    return proto2.util.equals(ResourceQuota, a, b);
  }
}

/**
 * ResourceQuotaList is a list of ResourceQuota items.
 *
 * @generated from message k8s.io.api.core.v1.ResourceQuotaList
 */
export class ResourceQuotaList extends Message<ResourceQuotaList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Items is a list of ResourceQuota objects.
   * More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
   *
   * @generated from field: repeated k8s.io.api.core.v1.ResourceQuota items = 2;
   */
  items: ResourceQuota[] = [];

  constructor(data?: PartialMessage<ResourceQuotaList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceQuotaList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: ResourceQuota, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceQuotaList {
    return new ResourceQuotaList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceQuotaList {
    return new ResourceQuotaList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceQuotaList {
    return new ResourceQuotaList().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceQuotaList | PlainMessage<ResourceQuotaList> | undefined, b: ResourceQuotaList | PlainMessage<ResourceQuotaList> | undefined): boolean {
    return proto2.util.equals(ResourceQuotaList, a, b);
  }
}

/**
 * ResourceQuotaSpec defines the desired hard limits to enforce for Quota.
 *
 * @generated from message k8s.io.api.core.v1.ResourceQuotaSpec
 */
export class ResourceQuotaSpec extends Message<ResourceQuotaSpec> {
  /**
   * hard is the set of desired hard limits for each named resource.
   * More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> hard = 1;
   */
  hard: { [key: string]: Quantity } = {};

  /**
   * A collection of filters that must match each object tracked by a quota.
   * If not specified, the quota matches all objects.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string scopes = 2;
   */
  scopes: string[] = [];

  /**
   * scopeSelector is also a collection of filters like scopes that must match each object tracked by a quota
   * but expressed using ScopeSelectorOperator in combination with possible values.
   * For a resource to match, both scopes AND scopeSelector (if specified in spec), must be matched.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ScopeSelector scopeSelector = 3;
   */
  scopeSelector?: ScopeSelector;

  constructor(data?: PartialMessage<ResourceQuotaSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceQuotaSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "hard", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "scopes", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "scopeSelector", kind: "message", T: ScopeSelector, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceQuotaSpec {
    return new ResourceQuotaSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceQuotaSpec {
    return new ResourceQuotaSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceQuotaSpec {
    return new ResourceQuotaSpec().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceQuotaSpec | PlainMessage<ResourceQuotaSpec> | undefined, b: ResourceQuotaSpec | PlainMessage<ResourceQuotaSpec> | undefined): boolean {
    return proto2.util.equals(ResourceQuotaSpec, a, b);
  }
}

/**
 * ResourceQuotaStatus defines the enforced hard limits and observed use.
 *
 * @generated from message k8s.io.api.core.v1.ResourceQuotaStatus
 */
export class ResourceQuotaStatus extends Message<ResourceQuotaStatus> {
  /**
   * Hard is the set of enforced hard limits for each named resource.
   * More info: https://kubernetes.io/docs/concepts/policy/resource-quotas/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> hard = 1;
   */
  hard: { [key: string]: Quantity } = {};

  /**
   * Used is the current observed total usage of the resource in the namespace.
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> used = 2;
   */
  used: { [key: string]: Quantity } = {};

  constructor(data?: PartialMessage<ResourceQuotaStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceQuotaStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "hard", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "used", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceQuotaStatus {
    return new ResourceQuotaStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceQuotaStatus {
    return new ResourceQuotaStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceQuotaStatus {
    return new ResourceQuotaStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceQuotaStatus | PlainMessage<ResourceQuotaStatus> | undefined, b: ResourceQuotaStatus | PlainMessage<ResourceQuotaStatus> | undefined): boolean {
    return proto2.util.equals(ResourceQuotaStatus, a, b);
  }
}

/**
 * ResourceRequirements describes the compute resource requirements.
 *
 * @generated from message k8s.io.api.core.v1.ResourceRequirements
 */
export class ResourceRequirements extends Message<ResourceRequirements> {
  /**
   * Limits describes the maximum amount of compute resources allowed.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> limits = 1;
   */
  limits: { [key: string]: Quantity } = {};

  /**
   * Requests describes the minimum amount of compute resources required.
   * If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
   * otherwise to an implementation-defined value. Requests cannot exceed Limits.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> requests = 2;
   */
  requests: { [key: string]: Quantity } = {};

  /**
   * Claims lists the names of resources, defined in spec.resourceClaims,
   * that are used by this container.
   *
   * This is an alpha field and requires enabling the
   * DynamicResourceAllocation feature gate.
   *
   * This field is immutable. It can only be set for containers.
   *
   * +listType=map
   * +listMapKey=name
   * +featureGate=DynamicResourceAllocation
   * +optional
   *
   * @generated from field: repeated k8s.io.api.core.v1.ResourceClaim claims = 3;
   */
  claims: ResourceClaim[] = [];

  constructor(data?: PartialMessage<ResourceRequirements>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceRequirements";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "limits", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "requests", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 3, name: "claims", kind: "message", T: ResourceClaim, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceRequirements {
    return new ResourceRequirements().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceRequirements {
    return new ResourceRequirements().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceRequirements {
    return new ResourceRequirements().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceRequirements | PlainMessage<ResourceRequirements> | undefined, b: ResourceRequirements | PlainMessage<ResourceRequirements> | undefined): boolean {
    return proto2.util.equals(ResourceRequirements, a, b);
  }
}

/**
 * @generated from message k8s.io.api.core.v1.ResourceStatus
 */
export class ResourceStatus extends Message<ResourceStatus> {
  /**
   * Name of the resource. Must be unique within the pod and match one of the resources from the pod spec.
   * +required
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * List of unique Resources health. Each element in the list contains an unique resource ID and resource health.
   * At a minimum, ResourceID must uniquely identify the Resource
   * allocated to the Pod on the Node for the lifetime of a Pod.
   * See ResourceID type for it's definition.
   * +listType=map
   * +listMapKey=resourceID
   *
   * @generated from field: repeated k8s.io.api.core.v1.ResourceHealth resources = 2;
   */
  resources: ResourceHealth[] = [];

  constructor(data?: PartialMessage<ResourceStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ResourceStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resources", kind: "message", T: ResourceHealth, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ResourceStatus {
    return new ResourceStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ResourceStatus {
    return new ResourceStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ResourceStatus {
    return new ResourceStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ResourceStatus | PlainMessage<ResourceStatus> | undefined, b: ResourceStatus | PlainMessage<ResourceStatus> | undefined): boolean {
    return proto2.util.equals(ResourceStatus, a, b);
  }
}

/**
 * SELinuxOptions are the labels to be applied to the container
 *
 * @generated from message k8s.io.api.core.v1.SELinuxOptions
 */
export class SELinuxOptions extends Message<SELinuxOptions> {
  /**
   * User is a SELinux user label that applies to the container.
   * +optional
   *
   * @generated from field: optional string user = 1;
   */
  user?: string;

  /**
   * Role is a SELinux role label that applies to the container.
   * +optional
   *
   * @generated from field: optional string role = 2;
   */
  role?: string;

  /**
   * Type is a SELinux type label that applies to the container.
   * +optional
   *
   * @generated from field: optional string type = 3;
   */
  type?: string;

  /**
   * Level is SELinux level label that applies to the container.
   * +optional
   *
   * @generated from field: optional string level = 4;
   */
  level?: string;

  constructor(data?: PartialMessage<SELinuxOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SELinuxOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "user", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "role", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "level", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SELinuxOptions {
    return new SELinuxOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SELinuxOptions {
    return new SELinuxOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SELinuxOptions {
    return new SELinuxOptions().fromJsonString(jsonString, options);
  }

  static equals(a: SELinuxOptions | PlainMessage<SELinuxOptions> | undefined, b: SELinuxOptions | PlainMessage<SELinuxOptions> | undefined): boolean {
    return proto2.util.equals(SELinuxOptions, a, b);
  }
}

/**
 * ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume
 *
 * @generated from message k8s.io.api.core.v1.ScaleIOPersistentVolumeSource
 */
export class ScaleIOPersistentVolumeSource extends Message<ScaleIOPersistentVolumeSource> {
  /**
   * gateway is the host address of the ScaleIO API Gateway.
   *
   * @generated from field: optional string gateway = 1;
   */
  gateway?: string;

  /**
   * system is the name of the storage system as configured in ScaleIO.
   *
   * @generated from field: optional string system = 2;
   */
  system?: string;

  /**
   * secretRef references to the secret for ScaleIO user and other
   * sensitive information. If this is not provided, Login operation will fail.
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretReference secretRef = 3;
   */
  secretRef?: SecretReference;

  /**
   * sslEnabled is the flag to enable/disable SSL communication with Gateway, default false
   * +optional
   *
   * @generated from field: optional bool sslEnabled = 4;
   */
  sslEnabled?: boolean;

  /**
   * protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
   * +optional
   *
   * @generated from field: optional string protectionDomain = 5;
   */
  protectionDomain?: string;

  /**
   * storagePool is the ScaleIO Storage Pool associated with the protection domain.
   * +optional
   *
   * @generated from field: optional string storagePool = 6;
   */
  storagePool?: string;

  /**
   * storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
   * Default is ThinProvisioned.
   * +optional
   * +default="ThinProvisioned"
   *
   * @generated from field: optional string storageMode = 7;
   */
  storageMode?: string;

  /**
   * volumeName is the name of a volume already created in the ScaleIO system
   * that is associated with this volume source.
   *
   * @generated from field: optional string volumeName = 8;
   */
  volumeName?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs".
   * Default is "xfs"
   * +optional
   * +default="xfs"
   *
   * @generated from field: optional string fsType = 9;
   */
  fsType?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 10;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<ScaleIOPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ScaleIOPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "gateway", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "system", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "secretRef", kind: "message", T: SecretReference, opt: true },
    { no: 4, name: "sslEnabled", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "protectionDomain", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "storagePool", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "storageMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "volumeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ScaleIOPersistentVolumeSource {
    return new ScaleIOPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ScaleIOPersistentVolumeSource {
    return new ScaleIOPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ScaleIOPersistentVolumeSource {
    return new ScaleIOPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ScaleIOPersistentVolumeSource | PlainMessage<ScaleIOPersistentVolumeSource> | undefined, b: ScaleIOPersistentVolumeSource | PlainMessage<ScaleIOPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(ScaleIOPersistentVolumeSource, a, b);
  }
}

/**
 * ScaleIOVolumeSource represents a persistent ScaleIO volume
 *
 * @generated from message k8s.io.api.core.v1.ScaleIOVolumeSource
 */
export class ScaleIOVolumeSource extends Message<ScaleIOVolumeSource> {
  /**
   * gateway is the host address of the ScaleIO API Gateway.
   *
   * @generated from field: optional string gateway = 1;
   */
  gateway?: string;

  /**
   * system is the name of the storage system as configured in ScaleIO.
   *
   * @generated from field: optional string system = 2;
   */
  system?: string;

  /**
   * secretRef references to the secret for ScaleIO user and other
   * sensitive information. If this is not provided, Login operation will fail.
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 3;
   */
  secretRef?: LocalObjectReference;

  /**
   * sslEnabled Flag enable/disable SSL communication with Gateway, default false
   * +optional
   *
   * @generated from field: optional bool sslEnabled = 4;
   */
  sslEnabled?: boolean;

  /**
   * protectionDomain is the name of the ScaleIO Protection Domain for the configured storage.
   * +optional
   *
   * @generated from field: optional string protectionDomain = 5;
   */
  protectionDomain?: string;

  /**
   * storagePool is the ScaleIO Storage Pool associated with the protection domain.
   * +optional
   *
   * @generated from field: optional string storagePool = 6;
   */
  storagePool?: string;

  /**
   * storageMode indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned.
   * Default is ThinProvisioned.
   * +optional
   * +default="ThinProvisioned"
   *
   * @generated from field: optional string storageMode = 7;
   */
  storageMode?: string;

  /**
   * volumeName is the name of a volume already created in the ScaleIO system
   * that is associated with this volume source.
   *
   * @generated from field: optional string volumeName = 8;
   */
  volumeName?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs".
   * Default is "xfs".
   * +optional
   * +default="xfs"
   *
   * @generated from field: optional string fsType = 9;
   */
  fsType?: string;

  /**
   * readOnly Defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 10;
   */
  readOnly?: boolean;

  constructor(data?: PartialMessage<ScaleIOVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ScaleIOVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "gateway", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "system", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
    { no: 4, name: "sslEnabled", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "protectionDomain", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "storagePool", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "storageMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "volumeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ScaleIOVolumeSource {
    return new ScaleIOVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ScaleIOVolumeSource {
    return new ScaleIOVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ScaleIOVolumeSource {
    return new ScaleIOVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: ScaleIOVolumeSource | PlainMessage<ScaleIOVolumeSource> | undefined, b: ScaleIOVolumeSource | PlainMessage<ScaleIOVolumeSource> | undefined): boolean {
    return proto2.util.equals(ScaleIOVolumeSource, a, b);
  }
}

/**
 * A scope selector represents the AND of the selectors represented
 * by the scoped-resource selector requirements.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.ScopeSelector
 */
export class ScopeSelector extends Message<ScopeSelector> {
  /**
   * A list of scope selector requirements by scope of the resources.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ScopedResourceSelectorRequirement matchExpressions = 1;
   */
  matchExpressions: ScopedResourceSelectorRequirement[] = [];

  constructor(data?: PartialMessage<ScopeSelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ScopeSelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "matchExpressions", kind: "message", T: ScopedResourceSelectorRequirement, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ScopeSelector {
    return new ScopeSelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ScopeSelector {
    return new ScopeSelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ScopeSelector {
    return new ScopeSelector().fromJsonString(jsonString, options);
  }

  static equals(a: ScopeSelector | PlainMessage<ScopeSelector> | undefined, b: ScopeSelector | PlainMessage<ScopeSelector> | undefined): boolean {
    return proto2.util.equals(ScopeSelector, a, b);
  }
}

/**
 * A scoped-resource selector requirement is a selector that contains values, a scope name, and an operator
 * that relates the scope name and values.
 *
 * @generated from message k8s.io.api.core.v1.ScopedResourceSelectorRequirement
 */
export class ScopedResourceSelectorRequirement extends Message<ScopedResourceSelectorRequirement> {
  /**
   * The name of the scope that the selector applies to.
   *
   * @generated from field: optional string scopeName = 1;
   */
  scopeName?: string;

  /**
   * Represents a scope's relationship to a set of values.
   * Valid operators are In, NotIn, Exists, DoesNotExist.
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * An array of string values. If the operator is In or NotIn,
   * the values array must be non-empty. If the operator is Exists or DoesNotExist,
   * the values array must be empty.
   * This array is replaced during a strategic merge patch.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string values = 3;
   */
  values: string[] = [];

  constructor(data?: PartialMessage<ScopedResourceSelectorRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ScopedResourceSelectorRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "scopeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "values", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ScopedResourceSelectorRequirement {
    return new ScopedResourceSelectorRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ScopedResourceSelectorRequirement {
    return new ScopedResourceSelectorRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ScopedResourceSelectorRequirement {
    return new ScopedResourceSelectorRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: ScopedResourceSelectorRequirement | PlainMessage<ScopedResourceSelectorRequirement> | undefined, b: ScopedResourceSelectorRequirement | PlainMessage<ScopedResourceSelectorRequirement> | undefined): boolean {
    return proto2.util.equals(ScopedResourceSelectorRequirement, a, b);
  }
}

/**
 * SeccompProfile defines a pod/container's seccomp profile settings.
 * Only one profile source may be set.
 * +union
 *
 * @generated from message k8s.io.api.core.v1.SeccompProfile
 */
export class SeccompProfile extends Message<SeccompProfile> {
  /**
   * type indicates which kind of seccomp profile will be applied.
   * Valid options are:
   *
   * Localhost - a profile defined in a file on the node should be used.
   * RuntimeDefault - the container runtime default profile should be used.
   * Unconfined - no profile should be applied.
   * +unionDiscriminator
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * localhostProfile indicates a profile defined in a file on the node should be used.
   * The profile must be preconfigured on the node to work.
   * Must be a descending path, relative to the kubelet's configured seccomp profile location.
   * Must be set if type is "Localhost". Must NOT be set for any other type.
   * +optional
   *
   * @generated from field: optional string localhostProfile = 2;
   */
  localhostProfile?: string;

  constructor(data?: PartialMessage<SeccompProfile>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SeccompProfile";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "localhostProfile", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SeccompProfile {
    return new SeccompProfile().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SeccompProfile {
    return new SeccompProfile().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SeccompProfile {
    return new SeccompProfile().fromJsonString(jsonString, options);
  }

  static equals(a: SeccompProfile | PlainMessage<SeccompProfile> | undefined, b: SeccompProfile | PlainMessage<SeccompProfile> | undefined): boolean {
    return proto2.util.equals(SeccompProfile, a, b);
  }
}

/**
 * Secret holds secret data of a certain type. The total bytes of the values in
 * the Data field must be less than MaxSecretSize bytes.
 *
 * @generated from message k8s.io.api.core.v1.Secret
 */
export class Secret extends Message<Secret> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Immutable, if set to true, ensures that data stored in the Secret cannot
   * be updated (only object metadata can be modified).
   * If not set to true, the field can be modified at any time.
   * Defaulted to nil.
   * +optional
   *
   * @generated from field: optional bool immutable = 5;
   */
  immutable?: boolean;

  /**
   * Data contains the secret data. Each key must consist of alphanumeric
   * characters, '-', '_' or '.'. The serialized form of the secret data is a
   * base64 encoded string, representing the arbitrary (possibly non-string)
   * data value here. Described in https://tools.ietf.org/html/rfc4648#section-4
   * +optional
   *
   * @generated from field: map<string, bytes> data = 2;
   */
  data: { [key: string]: Uint8Array } = {};

  /**
   * stringData allows specifying non-binary secret data in string form.
   * It is provided as a write-only input field for convenience.
   * All keys and values are merged into the data field on write, overwriting any existing values.
   * The stringData field is never output when reading from the API.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: map<string, string> stringData = 4;
   */
  stringData: { [key: string]: string } = {};

  /**
   * Used to facilitate programmatic handling of secret data.
   * More info: https://kubernetes.io/docs/concepts/configuration/secret/#secret-types
   * +optional
   *
   * @generated from field: optional string type = 3;
   */
  type?: string;

  constructor(data?: PartialMessage<Secret>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Secret";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 5, name: "immutable", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 2, name: "data", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 12 /* ScalarType.BYTES */} },
    { no: 4, name: "stringData", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 3, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Secret {
    return new Secret().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Secret {
    return new Secret().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Secret {
    return new Secret().fromJsonString(jsonString, options);
  }

  static equals(a: Secret | PlainMessage<Secret> | undefined, b: Secret | PlainMessage<Secret> | undefined): boolean {
    return proto2.util.equals(Secret, a, b);
  }
}

/**
 * SecretEnvSource selects a Secret to populate the environment
 * variables with.
 *
 * The contents of the target Secret's Data field will represent the
 * key-value pairs as environment variables.
 *
 * @generated from message k8s.io.api.core.v1.SecretEnvSource
 */
export class SecretEnvSource extends Message<SecretEnvSource> {
  /**
   * The Secret to select from.
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * Specify whether the Secret must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 2;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<SecretEnvSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretEnvSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretEnvSource {
    return new SecretEnvSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretEnvSource {
    return new SecretEnvSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretEnvSource {
    return new SecretEnvSource().fromJsonString(jsonString, options);
  }

  static equals(a: SecretEnvSource | PlainMessage<SecretEnvSource> | undefined, b: SecretEnvSource | PlainMessage<SecretEnvSource> | undefined): boolean {
    return proto2.util.equals(SecretEnvSource, a, b);
  }
}

/**
 * SecretKeySelector selects a key of a Secret.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.SecretKeySelector
 */
export class SecretKeySelector extends Message<SecretKeySelector> {
  /**
   * The name of the secret in the pod's namespace to select from.
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * The key of the secret to select from.  Must be a valid secret key.
   *
   * @generated from field: optional string key = 2;
   */
  key?: string;

  /**
   * Specify whether the Secret or its key must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 3;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<SecretKeySelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretKeySelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretKeySelector {
    return new SecretKeySelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretKeySelector {
    return new SecretKeySelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretKeySelector {
    return new SecretKeySelector().fromJsonString(jsonString, options);
  }

  static equals(a: SecretKeySelector | PlainMessage<SecretKeySelector> | undefined, b: SecretKeySelector | PlainMessage<SecretKeySelector> | undefined): boolean {
    return proto2.util.equals(SecretKeySelector, a, b);
  }
}

/**
 * SecretList is a list of Secret.
 *
 * @generated from message k8s.io.api.core.v1.SecretList
 */
export class SecretList extends Message<SecretList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Items is a list of secret objects.
   * More info: https://kubernetes.io/docs/concepts/configuration/secret
   *
   * @generated from field: repeated k8s.io.api.core.v1.Secret items = 2;
   */
  items: Secret[] = [];

  constructor(data?: PartialMessage<SecretList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Secret, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretList {
    return new SecretList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretList {
    return new SecretList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretList {
    return new SecretList().fromJsonString(jsonString, options);
  }

  static equals(a: SecretList | PlainMessage<SecretList> | undefined, b: SecretList | PlainMessage<SecretList> | undefined): boolean {
    return proto2.util.equals(SecretList, a, b);
  }
}

/**
 * Adapts a secret into a projected volume.
 *
 * The contents of the target Secret's Data field will be presented in a
 * projected volume as files using the keys in the Data field as the file names.
 * Note that this is identical to a secret volume source without the default
 * mode.
 *
 * @generated from message k8s.io.api.core.v1.SecretProjection
 */
export class SecretProjection extends Message<SecretProjection> {
  /**
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference localObjectReference = 1;
   */
  localObjectReference?: LocalObjectReference;

  /**
   * items if unspecified, each key-value pair in the Data field of the referenced
   * Secret will be projected into the volume as a file whose name is the
   * key and content is the value. If specified, the listed keys will be
   * projected into the specified paths, and unlisted keys will not be
   * present. If a key is specified which is not present in the Secret,
   * the volume setup will error unless it is marked optional. Paths must be
   * relative and may not contain the '..' path or start with '..'.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.KeyToPath items = 2;
   */
  items: KeyToPath[] = [];

  /**
   * optional field specify whether the Secret or its key must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 4;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<SecretProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "localObjectReference", kind: "message", T: LocalObjectReference, opt: true },
    { no: 2, name: "items", kind: "message", T: KeyToPath, repeated: true },
    { no: 4, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretProjection {
    return new SecretProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretProjection {
    return new SecretProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretProjection {
    return new SecretProjection().fromJsonString(jsonString, options);
  }

  static equals(a: SecretProjection | PlainMessage<SecretProjection> | undefined, b: SecretProjection | PlainMessage<SecretProjection> | undefined): boolean {
    return proto2.util.equals(SecretProjection, a, b);
  }
}

/**
 * SecretReference represents a Secret Reference. It has enough information to retrieve secret
 * in any namespace
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.SecretReference
 */
export class SecretReference extends Message<SecretReference> {
  /**
   * name is unique within a namespace to reference a secret resource.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * namespace defines the space within which the secret name must be unique.
   * +optional
   *
   * @generated from field: optional string namespace = 2;
   */
  namespace?: string;

  constructor(data?: PartialMessage<SecretReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretReference {
    return new SecretReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretReference {
    return new SecretReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretReference {
    return new SecretReference().fromJsonString(jsonString, options);
  }

  static equals(a: SecretReference | PlainMessage<SecretReference> | undefined, b: SecretReference | PlainMessage<SecretReference> | undefined): boolean {
    return proto2.util.equals(SecretReference, a, b);
  }
}

/**
 * Adapts a Secret into a volume.
 *
 * The contents of the target Secret's Data field will be presented in a volume
 * as files using the keys in the Data field as the file names.
 * Secret volumes support ownership management and SELinux relabeling.
 *
 * @generated from message k8s.io.api.core.v1.SecretVolumeSource
 */
export class SecretVolumeSource extends Message<SecretVolumeSource> {
  /**
   * secretName is the name of the secret in the pod's namespace to use.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
   * +optional
   *
   * @generated from field: optional string secretName = 1;
   */
  secretName?: string;

  /**
   * items If unspecified, each key-value pair in the Data field of the referenced
   * Secret will be projected into the volume as a file whose name is the
   * key and content is the value. If specified, the listed keys will be
   * projected into the specified paths, and unlisted keys will not be
   * present. If a key is specified which is not present in the Secret,
   * the volume setup will error unless it is marked optional. Paths must be
   * relative and may not contain the '..' path or start with '..'.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.KeyToPath items = 2;
   */
  items: KeyToPath[] = [];

  /**
   * defaultMode is Optional: mode bits used to set permissions on created files by default.
   * Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511.
   * YAML accepts both octal and decimal values, JSON requires decimal values
   * for mode bits. Defaults to 0644.
   * Directories within the path are not affected by this setting.
   * This might be in conflict with other options that affect the file
   * mode, like fsGroup, and the result can be other mode bits set.
   * +optional
   *
   * @generated from field: optional int32 defaultMode = 3;
   */
  defaultMode?: number;

  /**
   * optional field specify whether the Secret or its keys must be defined
   * +optional
   *
   * @generated from field: optional bool optional = 4;
   */
  optional?: boolean;

  constructor(data?: PartialMessage<SecretVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecretVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "secretName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "items", kind: "message", T: KeyToPath, repeated: true },
    { no: 3, name: "defaultMode", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "optional", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecretVolumeSource {
    return new SecretVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecretVolumeSource {
    return new SecretVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecretVolumeSource {
    return new SecretVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: SecretVolumeSource | PlainMessage<SecretVolumeSource> | undefined, b: SecretVolumeSource | PlainMessage<SecretVolumeSource> | undefined): boolean {
    return proto2.util.equals(SecretVolumeSource, a, b);
  }
}

/**
 * SecurityContext holds security configuration that will be applied to a container.
 * Some fields are present in both SecurityContext and PodSecurityContext.  When both
 * are set, the values in SecurityContext take precedence.
 *
 * @generated from message k8s.io.api.core.v1.SecurityContext
 */
export class SecurityContext extends Message<SecurityContext> {
  /**
   * The capabilities to add/drop when running containers.
   * Defaults to the default set of capabilities granted by the container runtime.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.Capabilities capabilities = 1;
   */
  capabilities?: Capabilities;

  /**
   * Run container in privileged mode.
   * Processes in privileged containers are essentially equivalent to root on the host.
   * Defaults to false.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional bool privileged = 2;
   */
  privileged?: boolean;

  /**
   * The SELinux context to be applied to the container.
   * If unspecified, the container runtime will allocate a random SELinux context for each
   * container.  May also be set in PodSecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SELinuxOptions seLinuxOptions = 3;
   */
  seLinuxOptions?: SELinuxOptions;

  /**
   * The Windows specific settings applied to all containers.
   * If unspecified, the options from the PodSecurityContext will be used.
   * If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
   * Note that this field cannot be set when spec.os.name is linux.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.WindowsSecurityContextOptions windowsOptions = 10;
   */
  windowsOptions?: WindowsSecurityContextOptions;

  /**
   * The UID to run the entrypoint of the container process.
   * Defaults to user specified in image metadata if unspecified.
   * May also be set in PodSecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional int64 runAsUser = 4;
   */
  runAsUser?: bigint;

  /**
   * The GID to run the entrypoint of the container process.
   * Uses runtime default if unset.
   * May also be set in PodSecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional int64 runAsGroup = 8;
   */
  runAsGroup?: bigint;

  /**
   * Indicates that the container must run as a non-root user.
   * If true, the Kubelet will validate the image at runtime to ensure that it
   * does not run as UID 0 (root) and fail to start the container if it does.
   * If unset or false, no such validation will be performed.
   * May also be set in PodSecurityContext.  If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * +optional
   *
   * @generated from field: optional bool runAsNonRoot = 5;
   */
  runAsNonRoot?: boolean;

  /**
   * Whether this container has a read-only root filesystem.
   * Default is false.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional bool readOnlyRootFilesystem = 6;
   */
  readOnlyRootFilesystem?: boolean;

  /**
   * AllowPrivilegeEscalation controls whether a process can gain more
   * privileges than its parent process. This bool directly controls if
   * the no_new_privs flag will be set on the container process.
   * AllowPrivilegeEscalation is true always when the container is:
   * 1) run as Privileged
   * 2) has CAP_SYS_ADMIN
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional bool allowPrivilegeEscalation = 7;
   */
  allowPrivilegeEscalation?: boolean;

  /**
   * procMount denotes the type of proc mount to use for the containers.
   * The default value is Default which uses the container runtime defaults for
   * readonly paths and masked paths.
   * This requires the ProcMountType feature flag to be enabled.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional string procMount = 9;
   */
  procMount?: string;

  /**
   * The seccomp options to use by this container. If seccomp options are
   * provided at both the pod & container level, the container options
   * override the pod options.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SeccompProfile seccompProfile = 11;
   */
  seccompProfile?: SeccompProfile;

  /**
   * appArmorProfile is the AppArmor options to use by this container. If set, this profile
   * overrides the pod's appArmorProfile.
   * Note that this field cannot be set when spec.os.name is windows.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AppArmorProfile appArmorProfile = 12;
   */
  appArmorProfile?: AppArmorProfile;

  constructor(data?: PartialMessage<SecurityContext>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SecurityContext";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "capabilities", kind: "message", T: Capabilities, opt: true },
    { no: 2, name: "privileged", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "seLinuxOptions", kind: "message", T: SELinuxOptions, opt: true },
    { no: 10, name: "windowsOptions", kind: "message", T: WindowsSecurityContextOptions, opt: true },
    { no: 4, name: "runAsUser", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 8, name: "runAsGroup", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 5, name: "runAsNonRoot", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 6, name: "readOnlyRootFilesystem", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "allowPrivilegeEscalation", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 9, name: "procMount", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 11, name: "seccompProfile", kind: "message", T: SeccompProfile, opt: true },
    { no: 12, name: "appArmorProfile", kind: "message", T: AppArmorProfile, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SecurityContext {
    return new SecurityContext().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SecurityContext {
    return new SecurityContext().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SecurityContext {
    return new SecurityContext().fromJsonString(jsonString, options);
  }

  static equals(a: SecurityContext | PlainMessage<SecurityContext> | undefined, b: SecurityContext | PlainMessage<SecurityContext> | undefined): boolean {
    return proto2.util.equals(SecurityContext, a, b);
  }
}

/**
 * SerializedReference is a reference to serialized object.
 *
 * @generated from message k8s.io.api.core.v1.SerializedReference
 */
export class SerializedReference extends Message<SerializedReference> {
  /**
   * The reference to an object in the system.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference reference = 1;
   */
  reference?: ObjectReference;

  constructor(data?: PartialMessage<SerializedReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SerializedReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "reference", kind: "message", T: ObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SerializedReference {
    return new SerializedReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SerializedReference {
    return new SerializedReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SerializedReference {
    return new SerializedReference().fromJsonString(jsonString, options);
  }

  static equals(a: SerializedReference | PlainMessage<SerializedReference> | undefined, b: SerializedReference | PlainMessage<SerializedReference> | undefined): boolean {
    return proto2.util.equals(SerializedReference, a, b);
  }
}

/**
 * Service is a named abstraction of software service (for example, mysql) consisting of local port
 * (for example 3306) that the proxy listens on, and the selector that determines which pods
 * will answer requests sent through the proxy.
 *
 * @generated from message k8s.io.api.core.v1.Service
 */
export class Service extends Message<Service> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Spec defines the behavior of a service.
   * https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ServiceSpec spec = 2;
   */
  spec?: ServiceSpec;

  /**
   * Most recently observed status of the service.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ServiceStatus status = 3;
   */
  status?: ServiceStatus;

  constructor(data?: PartialMessage<Service>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Service";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: ServiceSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: ServiceStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Service {
    return new Service().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Service {
    return new Service().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Service {
    return new Service().fromJsonString(jsonString, options);
  }

  static equals(a: Service | PlainMessage<Service> | undefined, b: Service | PlainMessage<Service> | undefined): boolean {
    return proto2.util.equals(Service, a, b);
  }
}

/**
 * ServiceAccount binds together:
 * * a name, understood by users, and perhaps by peripheral systems, for an identity
 * * a principal that can be authenticated and authorized
 * * a set of secrets
 *
 * @generated from message k8s.io.api.core.v1.ServiceAccount
 */
export class ServiceAccount extends Message<ServiceAccount> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Secrets is a list of the secrets in the same namespace that pods running using this ServiceAccount are allowed to use.
   * Pods are only limited to this list if this service account has a "kubernetes.io/enforce-mountable-secrets" annotation set to "true".
   * This field should not be used to find auto-generated service account token secrets for use outside of pods.
   * Instead, tokens can be requested directly using the TokenRequest API, or service account token secrets can be manually created.
   * More info: https://kubernetes.io/docs/concepts/configuration/secret
   * +optional
   * +patchMergeKey=name
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=name
   *
   * @generated from field: repeated k8s.io.api.core.v1.ObjectReference secrets = 2;
   */
  secrets: ObjectReference[] = [];

  /**
   * ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images
   * in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets
   * can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet.
   * More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.LocalObjectReference imagePullSecrets = 3;
   */
  imagePullSecrets: LocalObjectReference[] = [];

  /**
   * AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted.
   * Can be overridden at the pod level.
   * +optional
   *
   * @generated from field: optional bool automountServiceAccountToken = 4;
   */
  automountServiceAccountToken?: boolean;

  constructor(data?: PartialMessage<ServiceAccount>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceAccount";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "secrets", kind: "message", T: ObjectReference, repeated: true },
    { no: 3, name: "imagePullSecrets", kind: "message", T: LocalObjectReference, repeated: true },
    { no: 4, name: "automountServiceAccountToken", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceAccount {
    return new ServiceAccount().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceAccount {
    return new ServiceAccount().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceAccount {
    return new ServiceAccount().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceAccount | PlainMessage<ServiceAccount> | undefined, b: ServiceAccount | PlainMessage<ServiceAccount> | undefined): boolean {
    return proto2.util.equals(ServiceAccount, a, b);
  }
}

/**
 * ServiceAccountList is a list of ServiceAccount objects
 *
 * @generated from message k8s.io.api.core.v1.ServiceAccountList
 */
export class ServiceAccountList extends Message<ServiceAccountList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of ServiceAccounts.
   * More info: https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
   *
   * @generated from field: repeated k8s.io.api.core.v1.ServiceAccount items = 2;
   */
  items: ServiceAccount[] = [];

  constructor(data?: PartialMessage<ServiceAccountList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceAccountList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: ServiceAccount, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceAccountList {
    return new ServiceAccountList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceAccountList {
    return new ServiceAccountList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceAccountList {
    return new ServiceAccountList().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceAccountList | PlainMessage<ServiceAccountList> | undefined, b: ServiceAccountList | PlainMessage<ServiceAccountList> | undefined): boolean {
    return proto2.util.equals(ServiceAccountList, a, b);
  }
}

/**
 * ServiceAccountTokenProjection represents a projected service account token
 * volume. This projection can be used to insert a service account token into
 * the pods runtime filesystem for use against APIs (Kubernetes API Server or
 * otherwise).
 *
 * @generated from message k8s.io.api.core.v1.ServiceAccountTokenProjection
 */
export class ServiceAccountTokenProjection extends Message<ServiceAccountTokenProjection> {
  /**
   * audience is the intended audience of the token. A recipient of a token
   * must identify itself with an identifier specified in the audience of the
   * token, and otherwise should reject the token. The audience defaults to the
   * identifier of the apiserver.
   * +optional
   *
   * @generated from field: optional string audience = 1;
   */
  audience?: string;

  /**
   * expirationSeconds is the requested duration of validity of the service
   * account token. As the token approaches expiration, the kubelet volume
   * plugin will proactively rotate the service account token. The kubelet will
   * start trying to rotate the token if the token is older than 80 percent of
   * its time to live or if the token is older than 24 hours.Defaults to 1 hour
   * and must be at least 10 minutes.
   * +optional
   *
   * @generated from field: optional int64 expirationSeconds = 2;
   */
  expirationSeconds?: bigint;

  /**
   * path is the path relative to the mount point of the file to project the
   * token into.
   *
   * @generated from field: optional string path = 3;
   */
  path?: string;

  constructor(data?: PartialMessage<ServiceAccountTokenProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceAccountTokenProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "audience", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "expirationSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 3, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceAccountTokenProjection {
    return new ServiceAccountTokenProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceAccountTokenProjection {
    return new ServiceAccountTokenProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceAccountTokenProjection {
    return new ServiceAccountTokenProjection().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceAccountTokenProjection | PlainMessage<ServiceAccountTokenProjection> | undefined, b: ServiceAccountTokenProjection | PlainMessage<ServiceAccountTokenProjection> | undefined): boolean {
    return proto2.util.equals(ServiceAccountTokenProjection, a, b);
  }
}

/**
 * ServiceList holds a list of services.
 *
 * @generated from message k8s.io.api.core.v1.ServiceList
 */
export class ServiceList extends Message<ServiceList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of services
   *
   * @generated from field: repeated k8s.io.api.core.v1.Service items = 2;
   */
  items: Service[] = [];

  constructor(data?: PartialMessage<ServiceList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Service, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceList {
    return new ServiceList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceList {
    return new ServiceList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceList {
    return new ServiceList().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceList | PlainMessage<ServiceList> | undefined, b: ServiceList | PlainMessage<ServiceList> | undefined): boolean {
    return proto2.util.equals(ServiceList, a, b);
  }
}

/**
 * ServicePort contains information on service's port.
 *
 * @generated from message k8s.io.api.core.v1.ServicePort
 */
export class ServicePort extends Message<ServicePort> {
  /**
   * The name of this port within the service. This must be a DNS_LABEL.
   * All ports within a ServiceSpec must have unique names. When considering
   * the endpoints for a Service, this must match the 'name' field in the
   * EndpointPort.
   * Optional if only one ServicePort is defined on this service.
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * The IP protocol for this port. Supports "TCP", "UDP", and "SCTP".
   * Default is TCP.
   * +default="TCP"
   * +optional
   *
   * @generated from field: optional string protocol = 2;
   */
  protocol?: string;

  /**
   * The application protocol for this port.
   * This is used as a hint for implementations to offer richer behavior for protocols that they understand.
   * This field follows standard Kubernetes label syntax.
   * Valid values are either:
   *
   * * Un-prefixed protocol names - reserved for IANA standard service names (as per
   * RFC-6335 and https://www.iana.org/assignments/service-names).
   *
   * * Kubernetes-defined prefixed names:
   *   * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described in https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
   *   * 'kubernetes.io/ws'  - WebSocket over cleartext as described in https://www.rfc-editor.org/rfc/rfc6455
   *   * 'kubernetes.io/wss' - WebSocket over TLS as described in https://www.rfc-editor.org/rfc/rfc6455
   *
   * * Other protocols should use implementation-defined prefixed names such as
   * mycompany.com/my-custom-protocol.
   * +optional
   *
   * @generated from field: optional string appProtocol = 6;
   */
  appProtocol?: string;

  /**
   * The port that will be exposed by this service.
   *
   * @generated from field: optional int32 port = 3;
   */
  port?: number;

  /**
   * Number or name of the port to access on the pods targeted by the service.
   * Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
   * If this is a string, it will be looked up as a named port in the
   * target Pod's container ports. If this is not specified, the value
   * of the 'port' field is used (an identity map).
   * This field is ignored for services with clusterIP=None, and should be
   * omitted or set equal to the 'port' field.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.util.intstr.IntOrString targetPort = 4;
   */
  targetPort?: IntOrString;

  /**
   * The port on each node on which this service is exposed when type is
   * NodePort or LoadBalancer.  Usually assigned by the system. If a value is
   * specified, in-range, and not in use it will be used, otherwise the
   * operation will fail.  If not specified, a port will be allocated if this
   * Service requires one.  If this field is specified when creating a
   * Service which does not need it, creation will fail. This field will be
   * wiped when updating a Service to no longer need it (e.g. changing type
   * from NodePort to ClusterIP).
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
   * +optional
   *
   * @generated from field: optional int32 nodePort = 5;
   */
  nodePort?: number;

  constructor(data?: PartialMessage<ServicePort>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServicePort";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "protocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "appProtocol", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "port", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "targetPort", kind: "message", T: IntOrString, opt: true },
    { no: 5, name: "nodePort", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServicePort {
    return new ServicePort().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServicePort {
    return new ServicePort().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServicePort {
    return new ServicePort().fromJsonString(jsonString, options);
  }

  static equals(a: ServicePort | PlainMessage<ServicePort> | undefined, b: ServicePort | PlainMessage<ServicePort> | undefined): boolean {
    return proto2.util.equals(ServicePort, a, b);
  }
}

/**
 * ServiceProxyOptions is the query options to a Service's proxy call.
 *
 * @generated from message k8s.io.api.core.v1.ServiceProxyOptions
 */
export class ServiceProxyOptions extends Message<ServiceProxyOptions> {
  /**
   * Path is the part of URLs that include service endpoints, suffixes,
   * and parameters to use for the current proxy request to service.
   * For example, the whole request URL is
   * http://localhost/api/v1/namespaces/kube-system/services/elasticsearch-logging/_search?q=user:kimchy.
   * Path is _search?q=user:kimchy.
   * +optional
   *
   * @generated from field: optional string path = 1;
   */
  path?: string;

  constructor(data?: PartialMessage<ServiceProxyOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceProxyOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "path", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceProxyOptions {
    return new ServiceProxyOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceProxyOptions {
    return new ServiceProxyOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceProxyOptions {
    return new ServiceProxyOptions().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceProxyOptions | PlainMessage<ServiceProxyOptions> | undefined, b: ServiceProxyOptions | PlainMessage<ServiceProxyOptions> | undefined): boolean {
    return proto2.util.equals(ServiceProxyOptions, a, b);
  }
}

/**
 * ServiceSpec describes the attributes that a user creates on a service.
 *
 * @generated from message k8s.io.api.core.v1.ServiceSpec
 */
export class ServiceSpec extends Message<ServiceSpec> {
  /**
   * The list of ports that are exposed by this service.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * +patchMergeKey=port
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=port
   * +listMapKey=protocol
   *
   * @generated from field: repeated k8s.io.api.core.v1.ServicePort ports = 1;
   */
  ports: ServicePort[] = [];

  /**
   * Route service traffic to pods with label keys and values matching this
   * selector. If empty or not present, the service is assumed to have an
   * external process managing its endpoints, which Kubernetes will not
   * modify. Only applies to types ClusterIP, NodePort, and LoadBalancer.
   * Ignored if type is ExternalName.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/
   * +optional
   * +mapType=atomic
   *
   * @generated from field: map<string, string> selector = 2;
   */
  selector: { [key: string]: string } = {};

  /**
   * clusterIP is the IP address of the service and is usually assigned
   * randomly. If an address is specified manually, is in-range (as per
   * system configuration), and is not in use, it will be allocated to the
   * service; otherwise creation of the service will fail. This field may not
   * be changed through updates unless the type field is also being changed
   * to ExternalName (which requires this field to be blank) or the type
   * field is being changed from ExternalName (in which case this field may
   * optionally be specified, as describe above).  Valid values are "None",
   * empty string (""), or a valid IP address. Setting this to "None" makes a
   * "headless service" (no virtual IP), which is useful when direct endpoint
   * connections are preferred and proxying is not required.  Only applies to
   * types ClusterIP, NodePort, and LoadBalancer. If this field is specified
   * when creating a Service of type ExternalName, creation will fail. This
   * field will be wiped when updating a Service to type ExternalName.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * +optional
   *
   * @generated from field: optional string clusterIP = 3;
   */
  clusterIP?: string;

  /**
   * ClusterIPs is a list of IP addresses assigned to this service, and are
   * usually assigned randomly.  If an address is specified manually, is
   * in-range (as per system configuration), and is not in use, it will be
   * allocated to the service; otherwise creation of the service will fail.
   * This field may not be changed through updates unless the type field is
   * also being changed to ExternalName (which requires this field to be
   * empty) or the type field is being changed from ExternalName (in which
   * case this field may optionally be specified, as describe above).  Valid
   * values are "None", empty string (""), or a valid IP address.  Setting
   * this to "None" makes a "headless service" (no virtual IP), which is
   * useful when direct endpoint connections are preferred and proxying is
   * not required.  Only applies to types ClusterIP, NodePort, and
   * LoadBalancer. If this field is specified when creating a Service of type
   * ExternalName, creation will fail. This field will be wiped when updating
   * a Service to type ExternalName.  If this field is not specified, it will
   * be initialized from the clusterIP field.  If this field is specified,
   * clients must ensure that clusterIPs[0] and clusterIP have the same
   * value.
   *
   * This field may hold a maximum of two entries (dual-stack IPs, in either order).
   * These IPs must correspond to the values of the ipFamilies field. Both
   * clusterIPs and ipFamilies are governed by the ipFamilyPolicy field.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated string clusterIPs = 18;
   */
  clusterIPs: string[] = [];

  /**
   * type determines how the Service is exposed. Defaults to ClusterIP. Valid
   * options are ExternalName, ClusterIP, NodePort, and LoadBalancer.
   * "ClusterIP" allocates a cluster-internal IP address for load-balancing
   * to endpoints. Endpoints are determined by the selector or if that is not
   * specified, by manual construction of an Endpoints object or
   * EndpointSlice objects. If clusterIP is "None", no virtual IP is
   * allocated and the endpoints are published as a set of endpoints rather
   * than a virtual IP.
   * "NodePort" builds on ClusterIP and allocates a port on every node which
   * routes to the same endpoints as the clusterIP.
   * "LoadBalancer" builds on NodePort and creates an external load-balancer
   * (if supported in the current cloud) which routes to the same endpoints
   * as the clusterIP.
   * "ExternalName" aliases this service to the specified externalName.
   * Several other fields do not apply to ExternalName services.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
   * +optional
   *
   * @generated from field: optional string type = 4;
   */
  type?: string;

  /**
   * externalIPs is a list of IP addresses for which nodes in the cluster
   * will also accept traffic for this service.  These IPs are not managed by
   * Kubernetes.  The user is responsible for ensuring that traffic arrives
   * at a node with this IP.  A common example is external load-balancers
   * that are not part of the Kubernetes system.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string externalIPs = 5;
   */
  externalIPs: string[] = [];

  /**
   * Supports "ClientIP" and "None". Used to maintain session affinity.
   * Enable client IP based session affinity.
   * Must be ClientIP or None.
   * Defaults to None.
   * More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
   * +optional
   *
   * @generated from field: optional string sessionAffinity = 7;
   */
  sessionAffinity?: string;

  /**
   * Only applies to Service Type: LoadBalancer.
   * This feature depends on whether the underlying cloud-provider supports specifying
   * the loadBalancerIP when a load balancer is created.
   * This field will be ignored if the cloud-provider does not support the feature.
   * Deprecated: This field was under-specified and its meaning varies across implementations.
   * Using it is non-portable and it may not support dual-stack.
   * Users are encouraged to use implementation-specific annotations when available.
   * +optional
   *
   * @generated from field: optional string loadBalancerIP = 8;
   */
  loadBalancerIP?: string;

  /**
   * If specified and supported by the platform, this will restrict traffic through the cloud-provider
   * load-balancer will be restricted to the specified client IPs. This field will be ignored if the
   * cloud-provider does not support the feature."
   * More info: https://kubernetes.io/docs/tasks/access-application-cluster/create-external-load-balancer/
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string loadBalancerSourceRanges = 9;
   */
  loadBalancerSourceRanges: string[] = [];

  /**
   * externalName is the external reference that discovery mechanisms will
   * return as an alias for this service (e.g. a DNS CNAME record). No
   * proxying will be involved.  Must be a lowercase RFC-1123 hostname
   * (https://tools.ietf.org/html/rfc1123) and requires `type` to be "ExternalName".
   * +optional
   *
   * @generated from field: optional string externalName = 10;
   */
  externalName?: string;

  /**
   * externalTrafficPolicy describes how nodes distribute service traffic they
   * receive on one of the Service's "externally-facing" addresses (NodePorts,
   * ExternalIPs, and LoadBalancer IPs). If set to "Local", the proxy will configure
   * the service in a way that assumes that external load balancers will take care
   * of balancing the service traffic between nodes, and so each node will deliver
   * traffic only to the node-local endpoints of the service, without masquerading
   * the client source IP. (Traffic mistakenly sent to a node with no endpoints will
   * be dropped.) The default value, "Cluster", uses the standard behavior of
   * routing to all endpoints evenly (possibly modified by topology and other
   * features). Note that traffic sent to an External IP or LoadBalancer IP from
   * within the cluster will always get "Cluster" semantics, but clients sending to
   * a NodePort from within the cluster may need to take traffic policy into account
   * when picking a node.
   * +optional
   *
   * @generated from field: optional string externalTrafficPolicy = 11;
   */
  externalTrafficPolicy?: string;

  /**
   * healthCheckNodePort specifies the healthcheck nodePort for the service.
   * This only applies when type is set to LoadBalancer and
   * externalTrafficPolicy is set to Local. If a value is specified, is
   * in-range, and is not in use, it will be used.  If not specified, a value
   * will be automatically allocated.  External systems (e.g. load-balancers)
   * can use this port to determine if a given node holds endpoints for this
   * service or not.  If this field is specified when creating a Service
   * which does not need it, creation will fail. This field will be wiped
   * when updating a Service to no longer need it (e.g. changing type).
   * This field cannot be updated once set.
   * +optional
   *
   * @generated from field: optional int32 healthCheckNodePort = 12;
   */
  healthCheckNodePort?: number;

  /**
   * publishNotReadyAddresses indicates that any agent which deals with endpoints for this
   * Service should disregard any indications of ready/not-ready.
   * The primary use case for setting this field is for a StatefulSet's Headless Service to
   * propagate SRV DNS records for its Pods for the purpose of peer discovery.
   * The Kubernetes controllers that generate Endpoints and EndpointSlice resources for
   * Services interpret this to mean that all endpoints are considered "ready" even if the
   * Pods themselves are not. Agents which consume only Kubernetes generated endpoints
   * through the Endpoints or EndpointSlice resources can safely assume this behavior.
   * +optional
   *
   * @generated from field: optional bool publishNotReadyAddresses = 13;
   */
  publishNotReadyAddresses?: boolean;

  /**
   * sessionAffinityConfig contains the configurations of session affinity.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SessionAffinityConfig sessionAffinityConfig = 14;
   */
  sessionAffinityConfig?: SessionAffinityConfig;

  /**
   * IPFamilies is a list of IP families (e.g. IPv4, IPv6) assigned to this
   * service. This field is usually assigned automatically based on cluster
   * configuration and the ipFamilyPolicy field. If this field is specified
   * manually, the requested family is available in the cluster,
   * and ipFamilyPolicy allows it, it will be used; otherwise creation of
   * the service will fail. This field is conditionally mutable: it allows
   * for adding or removing a secondary IP family, but it does not allow
   * changing the primary IP family of the Service. Valid values are "IPv4"
   * and "IPv6".  This field only applies to Services of types ClusterIP,
   * NodePort, and LoadBalancer, and does apply to "headless" services.
   * This field will be wiped when updating a Service to type ExternalName.
   *
   * This field may hold a maximum of two entries (dual-stack families, in
   * either order).  These families must correspond to the values of the
   * clusterIPs field, if specified. Both clusterIPs and ipFamilies are
   * governed by the ipFamilyPolicy field.
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated string ipFamilies = 19;
   */
  ipFamilies: string[] = [];

  /**
   * IPFamilyPolicy represents the dual-stack-ness requested or required by
   * this Service. If there is no value provided, then this field will be set
   * to SingleStack. Services can be "SingleStack" (a single IP family),
   * "PreferDualStack" (two IP families on dual-stack configured clusters or
   * a single IP family on single-stack clusters), or "RequireDualStack"
   * (two IP families on dual-stack configured clusters, otherwise fail). The
   * ipFamilies and clusterIPs fields depend on the value of this field. This
   * field will be wiped when updating a service to type ExternalName.
   * +optional
   *
   * @generated from field: optional string ipFamilyPolicy = 17;
   */
  ipFamilyPolicy?: string;

  /**
   * allocateLoadBalancerNodePorts defines if NodePorts will be automatically
   * allocated for services with type LoadBalancer.  Default is "true". It
   * may be set to "false" if the cluster load-balancer does not rely on
   * NodePorts.  If the caller requests specific NodePorts (by specifying a
   * value), those requests will be respected, regardless of this field.
   * This field may only be set for services with type LoadBalancer and will
   * be cleared if the type is changed to any other type.
   * +optional
   *
   * @generated from field: optional bool allocateLoadBalancerNodePorts = 20;
   */
  allocateLoadBalancerNodePorts?: boolean;

  /**
   * loadBalancerClass is the class of the load balancer implementation this Service belongs to.
   * If specified, the value of this field must be a label-style identifier, with an optional prefix,
   * e.g. "internal-vip" or "example.com/internal-vip". Unprefixed names are reserved for end-users.
   * This field can only be set when the Service type is 'LoadBalancer'. If not set, the default load
   * balancer implementation is used, today this is typically done through the cloud provider integration,
   * but should apply for any default implementation. If set, it is assumed that a load balancer
   * implementation is watching for Services with a matching class. Any default load balancer
   * implementation (e.g. cloud providers) should ignore Services that set this field.
   * This field can only be set when creating or updating a Service to type 'LoadBalancer'.
   * Once set, it can not be changed. This field will be wiped when a service is updated to a non 'LoadBalancer' type.
   * +optional
   *
   * @generated from field: optional string loadBalancerClass = 21;
   */
  loadBalancerClass?: string;

  /**
   * InternalTrafficPolicy describes how nodes distribute service traffic they
   * receive on the ClusterIP. If set to "Local", the proxy will assume that pods
   * only want to talk to endpoints of the service on the same node as the pod,
   * dropping the traffic if there are no local endpoints. The default value,
   * "Cluster", uses the standard behavior of routing to all endpoints evenly
   * (possibly modified by topology and other features).
   * +optional
   *
   * @generated from field: optional string internalTrafficPolicy = 22;
   */
  internalTrafficPolicy?: string;

  /**
   * TrafficDistribution offers a way to express preferences for how traffic is
   * distributed to Service endpoints. Implementations can use this field as a
   * hint, but are not required to guarantee strict adherence. If the field is
   * not set, the implementation will apply its default routing strategy. If set
   * to "PreferClose", implementations should prioritize endpoints that are
   * topologically close (e.g., same zone).
   * This is an alpha field and requires enabling ServiceTrafficDistribution feature.
   * +featureGate=ServiceTrafficDistribution
   * +optional
   *
   * @generated from field: optional string trafficDistribution = 23;
   */
  trafficDistribution?: string;

  constructor(data?: PartialMessage<ServiceSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "ports", kind: "message", T: ServicePort, repeated: true },
    { no: 2, name: "selector", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "scalar", T: 9 /* ScalarType.STRING */} },
    { no: 3, name: "clusterIP", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 18, name: "clusterIPs", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 4, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "externalIPs", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 7, name: "sessionAffinity", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "loadBalancerIP", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "loadBalancerSourceRanges", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 10, name: "externalName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 11, name: "externalTrafficPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 12, name: "healthCheckNodePort", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 13, name: "publishNotReadyAddresses", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 14, name: "sessionAffinityConfig", kind: "message", T: SessionAffinityConfig, opt: true },
    { no: 19, name: "ipFamilies", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 17, name: "ipFamilyPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 20, name: "allocateLoadBalancerNodePorts", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 21, name: "loadBalancerClass", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 22, name: "internalTrafficPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 23, name: "trafficDistribution", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceSpec {
    return new ServiceSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceSpec {
    return new ServiceSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceSpec {
    return new ServiceSpec().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceSpec | PlainMessage<ServiceSpec> | undefined, b: ServiceSpec | PlainMessage<ServiceSpec> | undefined): boolean {
    return proto2.util.equals(ServiceSpec, a, b);
  }
}

/**
 * ServiceStatus represents the current status of a service.
 *
 * @generated from message k8s.io.api.core.v1.ServiceStatus
 */
export class ServiceStatus extends Message<ServiceStatus> {
  /**
   * LoadBalancer contains the current status of the load-balancer,
   * if one is present.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;
   */
  loadBalancer?: LoadBalancerStatus;

  /**
   * Current service state
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=type
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.Condition conditions = 2;
   */
  conditions: Condition[] = [];

  constructor(data?: PartialMessage<ServiceStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.ServiceStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "loadBalancer", kind: "message", T: LoadBalancerStatus, opt: true },
    { no: 2, name: "conditions", kind: "message", T: Condition, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServiceStatus {
    return new ServiceStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServiceStatus {
    return new ServiceStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServiceStatus {
    return new ServiceStatus().fromJsonString(jsonString, options);
  }

  static equals(a: ServiceStatus | PlainMessage<ServiceStatus> | undefined, b: ServiceStatus | PlainMessage<ServiceStatus> | undefined): boolean {
    return proto2.util.equals(ServiceStatus, a, b);
  }
}

/**
 * SessionAffinityConfig represents the configurations of session affinity.
 *
 * @generated from message k8s.io.api.core.v1.SessionAffinityConfig
 */
export class SessionAffinityConfig extends Message<SessionAffinityConfig> {
  /**
   * clientIP contains the configurations of Client IP based session affinity.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ClientIPConfig clientIP = 1;
   */
  clientIP?: ClientIPConfig;

  constructor(data?: PartialMessage<SessionAffinityConfig>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SessionAffinityConfig";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "clientIP", kind: "message", T: ClientIPConfig, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SessionAffinityConfig {
    return new SessionAffinityConfig().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SessionAffinityConfig {
    return new SessionAffinityConfig().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SessionAffinityConfig {
    return new SessionAffinityConfig().fromJsonString(jsonString, options);
  }

  static equals(a: SessionAffinityConfig | PlainMessage<SessionAffinityConfig> | undefined, b: SessionAffinityConfig | PlainMessage<SessionAffinityConfig> | undefined): boolean {
    return proto2.util.equals(SessionAffinityConfig, a, b);
  }
}

/**
 * SleepAction describes a "sleep" action.
 *
 * @generated from message k8s.io.api.core.v1.SleepAction
 */
export class SleepAction extends Message<SleepAction> {
  /**
   * Seconds is the number of seconds to sleep.
   *
   * @generated from field: optional int64 seconds = 1;
   */
  seconds?: bigint;

  constructor(data?: PartialMessage<SleepAction>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.SleepAction";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "seconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SleepAction {
    return new SleepAction().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SleepAction {
    return new SleepAction().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SleepAction {
    return new SleepAction().fromJsonString(jsonString, options);
  }

  static equals(a: SleepAction | PlainMessage<SleepAction> | undefined, b: SleepAction | PlainMessage<SleepAction> | undefined): boolean {
    return proto2.util.equals(SleepAction, a, b);
  }
}

/**
 * Represents a StorageOS persistent volume resource.
 *
 * @generated from message k8s.io.api.core.v1.StorageOSPersistentVolumeSource
 */
export class StorageOSPersistentVolumeSource extends Message<StorageOSPersistentVolumeSource> {
  /**
   * volumeName is the human-readable name of the StorageOS volume.  Volume
   * names are only unique within a namespace.
   *
   * @generated from field: optional string volumeName = 1;
   */
  volumeName?: string;

  /**
   * volumeNamespace specifies the scope of the volume within StorageOS.  If no
   * namespace is specified then the Pod's namespace will be used.  This allows the
   * Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
   * Set VolumeName to any name to override the default behaviour.
   * Set to "default" if you are not using namespaces within StorageOS.
   * Namespaces that do not pre-exist within StorageOS will be created.
   * +optional
   *
   * @generated from field: optional string volumeNamespace = 2;
   */
  volumeNamespace?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  /**
   * secretRef specifies the secret to use for obtaining the StorageOS API
   * credentials.  If not specified, default values will be attempted.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ObjectReference secretRef = 5;
   */
  secretRef?: ObjectReference;

  constructor(data?: PartialMessage<StorageOSPersistentVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.StorageOSPersistentVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "volumeNamespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "secretRef", kind: "message", T: ObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StorageOSPersistentVolumeSource {
    return new StorageOSPersistentVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StorageOSPersistentVolumeSource {
    return new StorageOSPersistentVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StorageOSPersistentVolumeSource {
    return new StorageOSPersistentVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: StorageOSPersistentVolumeSource | PlainMessage<StorageOSPersistentVolumeSource> | undefined, b: StorageOSPersistentVolumeSource | PlainMessage<StorageOSPersistentVolumeSource> | undefined): boolean {
    return proto2.util.equals(StorageOSPersistentVolumeSource, a, b);
  }
}

/**
 * Represents a StorageOS persistent volume resource.
 *
 * @generated from message k8s.io.api.core.v1.StorageOSVolumeSource
 */
export class StorageOSVolumeSource extends Message<StorageOSVolumeSource> {
  /**
   * volumeName is the human-readable name of the StorageOS volume.  Volume
   * names are only unique within a namespace.
   *
   * @generated from field: optional string volumeName = 1;
   */
  volumeName?: string;

  /**
   * volumeNamespace specifies the scope of the volume within StorageOS.  If no
   * namespace is specified then the Pod's namespace will be used.  This allows the
   * Kubernetes name scoping to be mirrored within StorageOS for tighter integration.
   * Set VolumeName to any name to override the default behaviour.
   * Set to "default" if you are not using namespaces within StorageOS.
   * Namespaces that do not pre-exist within StorageOS will be created.
   * +optional
   *
   * @generated from field: optional string volumeNamespace = 2;
   */
  volumeNamespace?: string;

  /**
   * fsType is the filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * +optional
   *
   * @generated from field: optional string fsType = 3;
   */
  fsType?: string;

  /**
   * readOnly defaults to false (read/write). ReadOnly here will force
   * the ReadOnly setting in VolumeMounts.
   * +optional
   *
   * @generated from field: optional bool readOnly = 4;
   */
  readOnly?: boolean;

  /**
   * secretRef specifies the secret to use for obtaining the StorageOS API
   * credentials.  If not specified, default values will be attempted.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.LocalObjectReference secretRef = 5;
   */
  secretRef?: LocalObjectReference;

  constructor(data?: PartialMessage<StorageOSVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.StorageOSVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumeName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "volumeNamespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "secretRef", kind: "message", T: LocalObjectReference, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StorageOSVolumeSource {
    return new StorageOSVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StorageOSVolumeSource {
    return new StorageOSVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StorageOSVolumeSource {
    return new StorageOSVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: StorageOSVolumeSource | PlainMessage<StorageOSVolumeSource> | undefined, b: StorageOSVolumeSource | PlainMessage<StorageOSVolumeSource> | undefined): boolean {
    return proto2.util.equals(StorageOSVolumeSource, a, b);
  }
}

/**
 * Sysctl defines a kernel parameter to be set
 *
 * @generated from message k8s.io.api.core.v1.Sysctl
 */
export class Sysctl extends Message<Sysctl> {
  /**
   * Name of a property to set
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Value of a property to set
   *
   * @generated from field: optional string value = 2;
   */
  value?: string;

  constructor(data?: PartialMessage<Sysctl>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Sysctl";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Sysctl {
    return new Sysctl().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Sysctl {
    return new Sysctl().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Sysctl {
    return new Sysctl().fromJsonString(jsonString, options);
  }

  static equals(a: Sysctl | PlainMessage<Sysctl> | undefined, b: Sysctl | PlainMessage<Sysctl> | undefined): boolean {
    return proto2.util.equals(Sysctl, a, b);
  }
}

/**
 * TCPSocketAction describes an action based on opening a socket
 *
 * @generated from message k8s.io.api.core.v1.TCPSocketAction
 */
export class TCPSocketAction extends Message<TCPSocketAction> {
  /**
   * Number or name of the port to access on the container.
   * Number must be in the range 1 to 65535.
   * Name must be an IANA_SVC_NAME.
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.util.intstr.IntOrString port = 1;
   */
  port?: IntOrString;

  /**
   * Optional: Host name to connect to, defaults to the pod IP.
   * +optional
   *
   * @generated from field: optional string host = 2;
   */
  host?: string;

  constructor(data?: PartialMessage<TCPSocketAction>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TCPSocketAction";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "port", kind: "message", T: IntOrString, opt: true },
    { no: 2, name: "host", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TCPSocketAction {
    return new TCPSocketAction().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TCPSocketAction {
    return new TCPSocketAction().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TCPSocketAction {
    return new TCPSocketAction().fromJsonString(jsonString, options);
  }

  static equals(a: TCPSocketAction | PlainMessage<TCPSocketAction> | undefined, b: TCPSocketAction | PlainMessage<TCPSocketAction> | undefined): boolean {
    return proto2.util.equals(TCPSocketAction, a, b);
  }
}

/**
 * The node this Taint is attached to has the "effect" on
 * any pod that does not tolerate the Taint.
 *
 * @generated from message k8s.io.api.core.v1.Taint
 */
export class Taint extends Message<Taint> {
  /**
   * Required. The taint key to be applied to a node.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * The taint value corresponding to the taint key.
   * +optional
   *
   * @generated from field: optional string value = 2;
   */
  value?: string;

  /**
   * Required. The effect of the taint on pods
   * that do not tolerate the taint.
   * Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
   *
   * @generated from field: optional string effect = 3;
   */
  effect?: string;

  /**
   * TimeAdded represents the time at which the taint was added.
   * It is only written for NoExecute taints.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time timeAdded = 4;
   */
  timeAdded?: Time;

  constructor(data?: PartialMessage<Taint>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Taint";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "effect", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "timeAdded", kind: "message", T: Time, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Taint {
    return new Taint().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Taint {
    return new Taint().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Taint {
    return new Taint().fromJsonString(jsonString, options);
  }

  static equals(a: Taint | PlainMessage<Taint> | undefined, b: Taint | PlainMessage<Taint> | undefined): boolean {
    return proto2.util.equals(Taint, a, b);
  }
}

/**
 * The pod this Toleration is attached to tolerates any taint that matches
 * the triple <key,value,effect> using the matching operator <operator>.
 *
 * @generated from message k8s.io.api.core.v1.Toleration
 */
export class Toleration extends Message<Toleration> {
  /**
   * Key is the taint key that the toleration applies to. Empty means match all taint keys.
   * If the key is empty, operator must be Exists; this combination means to match all values and all keys.
   * +optional
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * Operator represents a key's relationship to the value.
   * Valid operators are Exists and Equal. Defaults to Equal.
   * Exists is equivalent to wildcard for value, so that a pod can
   * tolerate all taints of a particular category.
   * +optional
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * Value is the taint value the toleration matches to.
   * If the operator is Exists, the value should be empty, otherwise just a regular string.
   * +optional
   *
   * @generated from field: optional string value = 3;
   */
  value?: string;

  /**
   * Effect indicates the taint effect to match. Empty means match all taint effects.
   * When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
   * +optional
   *
   * @generated from field: optional string effect = 4;
   */
  effect?: string;

  /**
   * TolerationSeconds represents the period of time the toleration (which must be
   * of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,
   * it is not set, which means tolerate the taint forever (do not evict). Zero and
   * negative values will be treated as 0 (evict immediately) by the system.
   * +optional
   *
   * @generated from field: optional int64 tolerationSeconds = 5;
   */
  tolerationSeconds?: bigint;

  constructor(data?: PartialMessage<Toleration>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Toleration";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "value", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "effect", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "tolerationSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Toleration {
    return new Toleration().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Toleration {
    return new Toleration().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Toleration {
    return new Toleration().fromJsonString(jsonString, options);
  }

  static equals(a: Toleration | PlainMessage<Toleration> | undefined, b: Toleration | PlainMessage<Toleration> | undefined): boolean {
    return proto2.util.equals(Toleration, a, b);
  }
}

/**
 * A topology selector requirement is a selector that matches given label.
 * This is an alpha feature and may change in the future.
 *
 * @generated from message k8s.io.api.core.v1.TopologySelectorLabelRequirement
 */
export class TopologySelectorLabelRequirement extends Message<TopologySelectorLabelRequirement> {
  /**
   * The label key that the selector applies to.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * An array of string values. One value must match the label to be selected.
   * Each entry in Values is ORed.
   * +listType=atomic
   *
   * @generated from field: repeated string values = 2;
   */
  values: string[] = [];

  constructor(data?: PartialMessage<TopologySelectorLabelRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TopologySelectorLabelRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "values", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TopologySelectorLabelRequirement {
    return new TopologySelectorLabelRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TopologySelectorLabelRequirement {
    return new TopologySelectorLabelRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TopologySelectorLabelRequirement {
    return new TopologySelectorLabelRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: TopologySelectorLabelRequirement | PlainMessage<TopologySelectorLabelRequirement> | undefined, b: TopologySelectorLabelRequirement | PlainMessage<TopologySelectorLabelRequirement> | undefined): boolean {
    return proto2.util.equals(TopologySelectorLabelRequirement, a, b);
  }
}

/**
 * A topology selector term represents the result of label queries.
 * A null or empty topology selector term matches no objects.
 * The requirements of them are ANDed.
 * It provides a subset of functionality as NodeSelectorTerm.
 * This is an alpha feature and may change in the future.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.TopologySelectorTerm
 */
export class TopologySelectorTerm extends Message<TopologySelectorTerm> {
  /**
   * A list of topology selector requirements by labels.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.TopologySelectorLabelRequirement matchLabelExpressions = 1;
   */
  matchLabelExpressions: TopologySelectorLabelRequirement[] = [];

  constructor(data?: PartialMessage<TopologySelectorTerm>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TopologySelectorTerm";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "matchLabelExpressions", kind: "message", T: TopologySelectorLabelRequirement, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TopologySelectorTerm {
    return new TopologySelectorTerm().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TopologySelectorTerm {
    return new TopologySelectorTerm().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TopologySelectorTerm {
    return new TopologySelectorTerm().fromJsonString(jsonString, options);
  }

  static equals(a: TopologySelectorTerm | PlainMessage<TopologySelectorTerm> | undefined, b: TopologySelectorTerm | PlainMessage<TopologySelectorTerm> | undefined): boolean {
    return proto2.util.equals(TopologySelectorTerm, a, b);
  }
}

/**
 * TopologySpreadConstraint specifies how to spread matching pods among the given topology.
 *
 * @generated from message k8s.io.api.core.v1.TopologySpreadConstraint
 */
export class TopologySpreadConstraint extends Message<TopologySpreadConstraint> {
  /**
   * MaxSkew describes the degree to which pods may be unevenly distributed.
   * When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference
   * between the number of matching pods in the target topology and the global minimum.
   * The global minimum is the minimum number of matching pods in an eligible domain
   * or zero if the number of eligible domains is less than MinDomains.
   * For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
   * labelSelector spread as 2/2/1:
   * In this case, the global minimum is 1.
   * +-------+-------+-------+
   * | zone1 | zone2 | zone3 |
   * +-------+-------+-------+
   * |  P P  |  P P  |   P   |
   * +-------+-------+-------+
   * - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2;
   * scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2)
   * violate MaxSkew(1).
   * - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
   * When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence
   * to topologies that satisfy it.
   * It's a required field. Default value is 1 and 0 is not allowed.
   *
   * @generated from field: optional int32 maxSkew = 1;
   */
  maxSkew?: number;

  /**
   * TopologyKey is the key of node labels. Nodes that have a label with this key
   * and identical values are considered to be in the same topology.
   * We consider each <key, value> as a "bucket", and try to put balanced number
   * of pods into each bucket.
   * We define a domain as a particular instance of a topology.
   * Also, we define an eligible domain as a domain whose nodes meet the requirements of
   * nodeAffinityPolicy and nodeTaintsPolicy.
   * e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology.
   * And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology.
   * It's a required field.
   *
   * @generated from field: optional string topologyKey = 2;
   */
  topologyKey?: string;

  /**
   * WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy
   * the spread constraint.
   * - DoNotSchedule (default) tells the scheduler not to schedule it.
   * - ScheduleAnyway tells the scheduler to schedule the pod in any location,
   *   but giving higher precedence to topologies that would help reduce the
   *   skew.
   * A constraint is considered "Unsatisfiable" for an incoming pod
   * if and only if every possible node assignment for that pod would violate
   * "MaxSkew" on some topology.
   * For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
   * labelSelector spread as 3/1/1:
   * +-------+-------+-------+
   * | zone1 | zone2 | zone3 |
   * +-------+-------+-------+
   * | P P P |   P   |   P   |
   * +-------+-------+-------+
   * If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled
   * to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies
   * MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler
   * won't make it *more* imbalanced.
   * It's a required field.
   *
   * @generated from field: optional string whenUnsatisfiable = 3;
   */
  whenUnsatisfiable?: string;

  /**
   * LabelSelector is used to find matching pods.
   * Pods that match this label selector are counted to determine the number of pods
   * in their corresponding topology domain.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector labelSelector = 4;
   */
  labelSelector?: LabelSelector;

  /**
   * MinDomains indicates a minimum number of eligible domains.
   * When the number of eligible domains with matching topology keys is less than minDomains,
   * Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed.
   * And when the number of eligible domains with matching topology keys equals or greater than minDomains,
   * this value has no effect on scheduling.
   * As a result, when the number of eligible domains is less than minDomains,
   * scheduler won't schedule more than maxSkew Pods to those domains.
   * If value is nil, the constraint behaves as if MinDomains is equal to 1.
   * Valid values are integers greater than 0.
   * When value is not nil, WhenUnsatisfiable must be DoNotSchedule.
   *
   * For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same
   * labelSelector spread as 2/2/2:
   * +-------+-------+-------+
   * | zone1 | zone2 | zone3 |
   * +-------+-------+-------+
   * |  P P  |  P P  |  P P  |
   * +-------+-------+-------+
   * The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0.
   * In this situation, new pod with the same labelSelector cannot be scheduled,
   * because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones,
   * it will violate MaxSkew.
   * +optional
   *
   * @generated from field: optional int32 minDomains = 5;
   */
  minDomains?: number;

  /**
   * NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector
   * when calculating pod topology spread skew. Options are:
   * - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations.
   * - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.
   *
   * If this value is nil, the behavior is equivalent to the Honor policy.
   * This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
   * +optional
   *
   * @generated from field: optional string nodeAffinityPolicy = 6;
   */
  nodeAffinityPolicy?: string;

  /**
   * NodeTaintsPolicy indicates how we will treat node taints when calculating
   * pod topology spread skew. Options are:
   * - Honor: nodes without taints, along with tainted nodes for which the incoming pod
   * has a toleration, are included.
   * - Ignore: node taints are ignored. All nodes are included.
   *
   * If this value is nil, the behavior is equivalent to the Ignore policy.
   * This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
   * +optional
   *
   * @generated from field: optional string nodeTaintsPolicy = 7;
   */
  nodeTaintsPolicy?: string;

  /**
   * MatchLabelKeys is a set of pod label keys to select the pods over which
   * spreading will be calculated. The keys are used to lookup values from the
   * incoming pod labels, those key-value labels are ANDed with labelSelector
   * to select the group of existing pods over which spreading will be calculated
   * for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector.
   * MatchLabelKeys cannot be set when LabelSelector isn't set.
   * Keys that don't exist in the incoming pod labels will
   * be ignored. A null or empty list means only match against labelSelector.
   *
   * This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated string matchLabelKeys = 8;
   */
  matchLabelKeys: string[] = [];

  constructor(data?: PartialMessage<TopologySpreadConstraint>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TopologySpreadConstraint";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "maxSkew", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "topologyKey", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "whenUnsatisfiable", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "labelSelector", kind: "message", T: LabelSelector, opt: true },
    { no: 5, name: "minDomains", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 6, name: "nodeAffinityPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "nodeTaintsPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "matchLabelKeys", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TopologySpreadConstraint {
    return new TopologySpreadConstraint().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TopologySpreadConstraint {
    return new TopologySpreadConstraint().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TopologySpreadConstraint {
    return new TopologySpreadConstraint().fromJsonString(jsonString, options);
  }

  static equals(a: TopologySpreadConstraint | PlainMessage<TopologySpreadConstraint> | undefined, b: TopologySpreadConstraint | PlainMessage<TopologySpreadConstraint> | undefined): boolean {
    return proto2.util.equals(TopologySpreadConstraint, a, b);
  }
}

/**
 * TypedLocalObjectReference contains enough information to let you locate the
 * typed referenced object inside the same namespace.
 * +structType=atomic
 *
 * @generated from message k8s.io.api.core.v1.TypedLocalObjectReference
 */
export class TypedLocalObjectReference extends Message<TypedLocalObjectReference> {
  /**
   * APIGroup is the group for the resource being referenced.
   * If APIGroup is not specified, the specified Kind must be in the core API group.
   * For any other third-party types, APIGroup is required.
   * +optional
   *
   * @generated from field: optional string apiGroup = 1;
   */
  apiGroup?: string;

  /**
   * Kind is the type of resource being referenced
   *
   * @generated from field: optional string kind = 2;
   */
  kind?: string;

  /**
   * Name is the name of resource being referenced
   *
   * @generated from field: optional string name = 3;
   */
  name?: string;

  constructor(data?: PartialMessage<TypedLocalObjectReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TypedLocalObjectReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "apiGroup", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TypedLocalObjectReference {
    return new TypedLocalObjectReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TypedLocalObjectReference {
    return new TypedLocalObjectReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TypedLocalObjectReference {
    return new TypedLocalObjectReference().fromJsonString(jsonString, options);
  }

  static equals(a: TypedLocalObjectReference | PlainMessage<TypedLocalObjectReference> | undefined, b: TypedLocalObjectReference | PlainMessage<TypedLocalObjectReference> | undefined): boolean {
    return proto2.util.equals(TypedLocalObjectReference, a, b);
  }
}

/**
 * @generated from message k8s.io.api.core.v1.TypedObjectReference
 */
export class TypedObjectReference extends Message<TypedObjectReference> {
  /**
   * APIGroup is the group for the resource being referenced.
   * If APIGroup is not specified, the specified Kind must be in the core API group.
   * For any other third-party types, APIGroup is required.
   * +optional
   *
   * @generated from field: optional string apiGroup = 1;
   */
  apiGroup?: string;

  /**
   * Kind is the type of resource being referenced
   *
   * @generated from field: optional string kind = 2;
   */
  kind?: string;

  /**
   * Name is the name of resource being referenced
   *
   * @generated from field: optional string name = 3;
   */
  name?: string;

  /**
   * Namespace is the namespace of resource being referenced
   * Note that when a namespace is specified, a gateway.networking.k8s.io/ReferenceGrant object is required in the referent namespace to allow that namespace's owner to accept the reference. See the ReferenceGrant documentation for details.
   * (Alpha) This field requires the CrossNamespaceVolumeDataSource feature gate to be enabled.
   * +featureGate=CrossNamespaceVolumeDataSource
   * +optional
   *
   * @generated from field: optional string namespace = 4;
   */
  namespace?: string;

  constructor(data?: PartialMessage<TypedObjectReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.TypedObjectReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "apiGroup", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TypedObjectReference {
    return new TypedObjectReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TypedObjectReference {
    return new TypedObjectReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TypedObjectReference {
    return new TypedObjectReference().fromJsonString(jsonString, options);
  }

  static equals(a: TypedObjectReference | PlainMessage<TypedObjectReference> | undefined, b: TypedObjectReference | PlainMessage<TypedObjectReference> | undefined): boolean {
    return proto2.util.equals(TypedObjectReference, a, b);
  }
}

/**
 * Volume represents a named volume in a pod that may be accessed by any container in the pod.
 *
 * @generated from message k8s.io.api.core.v1.Volume
 */
export class Volume extends Message<Volume> {
  /**
   * name of the volume.
   * Must be a DNS_LABEL and unique within the pod.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * volumeSource represents the location and type of the mounted volume.
   * If not specified, the Volume is implied to be an EmptyDir.
   * This implied behavior is deprecated and will be removed in a future version.
   *
   * @generated from field: optional k8s.io.api.core.v1.VolumeSource volumeSource = 2;
   */
  volumeSource?: VolumeSource;

  constructor(data?: PartialMessage<Volume>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.Volume";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "volumeSource", kind: "message", T: VolumeSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Volume {
    return new Volume().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Volume {
    return new Volume().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Volume {
    return new Volume().fromJsonString(jsonString, options);
  }

  static equals(a: Volume | PlainMessage<Volume> | undefined, b: Volume | PlainMessage<Volume> | undefined): boolean {
    return proto2.util.equals(Volume, a, b);
  }
}

/**
 * volumeDevice describes a mapping of a raw block device within a container.
 *
 * @generated from message k8s.io.api.core.v1.VolumeDevice
 */
export class VolumeDevice extends Message<VolumeDevice> {
  /**
   * name must match the name of a persistentVolumeClaim in the pod
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * devicePath is the path inside of the container that the device will be mapped to.
   *
   * @generated from field: optional string devicePath = 2;
   */
  devicePath?: string;

  constructor(data?: PartialMessage<VolumeDevice>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeDevice";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "devicePath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeDevice {
    return new VolumeDevice().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeDevice {
    return new VolumeDevice().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeDevice {
    return new VolumeDevice().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeDevice | PlainMessage<VolumeDevice> | undefined, b: VolumeDevice | PlainMessage<VolumeDevice> | undefined): boolean {
    return proto2.util.equals(VolumeDevice, a, b);
  }
}

/**
 * VolumeMount describes a mounting of a Volume within a container.
 *
 * @generated from message k8s.io.api.core.v1.VolumeMount
 */
export class VolumeMount extends Message<VolumeMount> {
  /**
   * This must match the Name of a Volume.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * Mounted read-only if true, read-write otherwise (false or unspecified).
   * Defaults to false.
   * +optional
   *
   * @generated from field: optional bool readOnly = 2;
   */
  readOnly?: boolean;

  /**
   * RecursiveReadOnly specifies whether read-only mounts should be handled
   * recursively.
   *
   * If ReadOnly is false, this field has no meaning and must be unspecified.
   *
   * If ReadOnly is true, and this field is set to Disabled, the mount is not made
   * recursively read-only.  If this field is set to IfPossible, the mount is made
   * recursively read-only, if it is supported by the container runtime.  If this
   * field is set to Enabled, the mount is made recursively read-only if it is
   * supported by the container runtime, otherwise the pod will not be started and
   * an error will be generated to indicate the reason.
   *
   * If this field is set to IfPossible or Enabled, MountPropagation must be set to
   * None (or be unspecified, which defaults to None).
   *
   * If this field is not specified, it is treated as an equivalent of Disabled.
   *
   * +featureGate=RecursiveReadOnlyMounts
   * +optional
   *
   * @generated from field: optional string recursiveReadOnly = 7;
   */
  recursiveReadOnly?: string;

  /**
   * Path within the container at which the volume should be mounted.  Must
   * not contain ':'.
   *
   * @generated from field: optional string mountPath = 3;
   */
  mountPath?: string;

  /**
   * Path within the volume from which the container's volume should be mounted.
   * Defaults to "" (volume's root).
   * +optional
   *
   * @generated from field: optional string subPath = 4;
   */
  subPath?: string;

  /**
   * mountPropagation determines how mounts are propagated from the host
   * to container and the other way around.
   * When not set, MountPropagationNone is used.
   * This field is beta in 1.10.
   * When RecursiveReadOnly is set to IfPossible or to Enabled, MountPropagation must be None or unspecified
   * (which defaults to None).
   * +optional
   *
   * @generated from field: optional string mountPropagation = 5;
   */
  mountPropagation?: string;

  /**
   * Expanded path within the volume from which the container's volume should be mounted.
   * Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment.
   * Defaults to "" (volume's root).
   * SubPathExpr and SubPath are mutually exclusive.
   * +optional
   *
   * @generated from field: optional string subPathExpr = 6;
   */
  subPathExpr?: string;

  constructor(data?: PartialMessage<VolumeMount>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeMount";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "recursiveReadOnly", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "mountPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "subPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "mountPropagation", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "subPathExpr", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeMount {
    return new VolumeMount().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeMount {
    return new VolumeMount().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeMount {
    return new VolumeMount().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeMount | PlainMessage<VolumeMount> | undefined, b: VolumeMount | PlainMessage<VolumeMount> | undefined): boolean {
    return proto2.util.equals(VolumeMount, a, b);
  }
}

/**
 * VolumeMountStatus shows status of volume mounts.
 *
 * @generated from message k8s.io.api.core.v1.VolumeMountStatus
 */
export class VolumeMountStatus extends Message<VolumeMountStatus> {
  /**
   * Name corresponds to the name of the original VolumeMount.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * MountPath corresponds to the original VolumeMount.
   *
   * @generated from field: optional string mountPath = 2;
   */
  mountPath?: string;

  /**
   * ReadOnly corresponds to the original VolumeMount.
   * +optional
   *
   * @generated from field: optional bool readOnly = 3;
   */
  readOnly?: boolean;

  /**
   * RecursiveReadOnly must be set to Disabled, Enabled, or unspecified (for non-readonly mounts).
   * An IfPossible value in the original VolumeMount must be translated to Disabled or Enabled,
   * depending on the mount result.
   * +featureGate=RecursiveReadOnlyMounts
   * +optional
   *
   * @generated from field: optional string recursiveReadOnly = 4;
   */
  recursiveReadOnly?: string;

  constructor(data?: PartialMessage<VolumeMountStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeMountStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "mountPath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "readOnly", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "recursiveReadOnly", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeMountStatus {
    return new VolumeMountStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeMountStatus {
    return new VolumeMountStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeMountStatus {
    return new VolumeMountStatus().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeMountStatus | PlainMessage<VolumeMountStatus> | undefined, b: VolumeMountStatus | PlainMessage<VolumeMountStatus> | undefined): boolean {
    return proto2.util.equals(VolumeMountStatus, a, b);
  }
}

/**
 * VolumeNodeAffinity defines constraints that limit what nodes this volume can be accessed from.
 *
 * @generated from message k8s.io.api.core.v1.VolumeNodeAffinity
 */
export class VolumeNodeAffinity extends Message<VolumeNodeAffinity> {
  /**
   * required specifies hard node constraints that must be met.
   *
   * @generated from field: optional k8s.io.api.core.v1.NodeSelector required = 1;
   */
  required?: NodeSelector;

  constructor(data?: PartialMessage<VolumeNodeAffinity>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeNodeAffinity";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "required", kind: "message", T: NodeSelector, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeNodeAffinity {
    return new VolumeNodeAffinity().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeNodeAffinity {
    return new VolumeNodeAffinity().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeNodeAffinity {
    return new VolumeNodeAffinity().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeNodeAffinity | PlainMessage<VolumeNodeAffinity> | undefined, b: VolumeNodeAffinity | PlainMessage<VolumeNodeAffinity> | undefined): boolean {
    return proto2.util.equals(VolumeNodeAffinity, a, b);
  }
}

/**
 * Projection that may be projected along with other supported volume types.
 * Exactly one of these fields must be set.
 *
 * @generated from message k8s.io.api.core.v1.VolumeProjection
 */
export class VolumeProjection extends Message<VolumeProjection> {
  /**
   * secret information about the secret data to project
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretProjection secret = 1;
   */
  secret?: SecretProjection;

  /**
   * downwardAPI information about the downwardAPI data to project
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.DownwardAPIProjection downwardAPI = 2;
   */
  downwardAPI?: DownwardAPIProjection;

  /**
   * configMap information about the configMap data to project
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ConfigMapProjection configMap = 3;
   */
  configMap?: ConfigMapProjection;

  /**
   * serviceAccountToken is information about the serviceAccountToken data to project
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ServiceAccountTokenProjection serviceAccountToken = 4;
   */
  serviceAccountToken?: ServiceAccountTokenProjection;

  /**
   * ClusterTrustBundle allows a pod to access the `.spec.trustBundle` field
   * of ClusterTrustBundle objects in an auto-updating file.
   *
   * Alpha, gated by the ClusterTrustBundleProjection feature gate.
   *
   * ClusterTrustBundle objects can either be selected by name, or by the
   * combination of signer name and a label selector.
   *
   * Kubelet performs aggressive normalization of the PEM contents written
   * into the pod filesystem.  Esoteric PEM features such as inter-block
   * comments and block headers are stripped.  Certificates are deduplicated.
   * The ordering of certificates within the file is arbitrary, and Kubelet
   * may change the order over time.
   *
   * +featureGate=ClusterTrustBundleProjection
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ClusterTrustBundleProjection clusterTrustBundle = 5;
   */
  clusterTrustBundle?: ClusterTrustBundleProjection;

  constructor(data?: PartialMessage<VolumeProjection>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeProjection";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "secret", kind: "message", T: SecretProjection, opt: true },
    { no: 2, name: "downwardAPI", kind: "message", T: DownwardAPIProjection, opt: true },
    { no: 3, name: "configMap", kind: "message", T: ConfigMapProjection, opt: true },
    { no: 4, name: "serviceAccountToken", kind: "message", T: ServiceAccountTokenProjection, opt: true },
    { no: 5, name: "clusterTrustBundle", kind: "message", T: ClusterTrustBundleProjection, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeProjection {
    return new VolumeProjection().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeProjection {
    return new VolumeProjection().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeProjection {
    return new VolumeProjection().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeProjection | PlainMessage<VolumeProjection> | undefined, b: VolumeProjection | PlainMessage<VolumeProjection> | undefined): boolean {
    return proto2.util.equals(VolumeProjection, a, b);
  }
}

/**
 * VolumeResourceRequirements describes the storage resource requirements for a volume.
 *
 * @generated from message k8s.io.api.core.v1.VolumeResourceRequirements
 */
export class VolumeResourceRequirements extends Message<VolumeResourceRequirements> {
  /**
   * Limits describes the maximum amount of compute resources allowed.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> limits = 1;
   */
  limits: { [key: string]: Quantity } = {};

  /**
   * Requests describes the minimum amount of compute resources required.
   * If Requests is omitted for a container, it defaults to Limits if that is explicitly specified,
   * otherwise to an implementation-defined value. Requests cannot exceed Limits.
   * More info: https://kubernetes.io/docs/concepts/configuration/manage-resources-containers/
   * +optional
   *
   * @generated from field: map<string, k8s.io.apimachinery.pkg.api.resource.Quantity> requests = 2;
   */
  requests: { [key: string]: Quantity } = {};

  constructor(data?: PartialMessage<VolumeResourceRequirements>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeResourceRequirements";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "limits", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
    { no: 2, name: "requests", kind: "map", K: 9 /* ScalarType.STRING */, V: {kind: "message", T: Quantity} },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeResourceRequirements {
    return new VolumeResourceRequirements().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeResourceRequirements {
    return new VolumeResourceRequirements().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeResourceRequirements {
    return new VolumeResourceRequirements().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeResourceRequirements | PlainMessage<VolumeResourceRequirements> | undefined, b: VolumeResourceRequirements | PlainMessage<VolumeResourceRequirements> | undefined): boolean {
    return proto2.util.equals(VolumeResourceRequirements, a, b);
  }
}

/**
 * Represents the source of a volume to mount.
 * Only one of its members may be specified.
 *
 * @generated from message k8s.io.api.core.v1.VolumeSource
 */
export class VolumeSource extends Message<VolumeSource> {
  /**
   * hostPath represents a pre-existing file or directory on the host
   * machine that is directly exposed to the container. This is generally
   * used for system agents or other privileged things that are allowed
   * to see the host machine. Most containers will NOT need this.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
   * ---
   * TODO(jonesdl) We need to restrict who can use host directory mounts and who can/can not
   * mount host directories as read/write.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.HostPathVolumeSource hostPath = 1;
   */
  hostPath?: HostPathVolumeSource;

  /**
   * emptyDir represents a temporary directory that shares a pod's lifetime.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.EmptyDirVolumeSource emptyDir = 2;
   */
  emptyDir?: EmptyDirVolumeSource;

  /**
   * gcePersistentDisk represents a GCE Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GCEPersistentDiskVolumeSource gcePersistentDisk = 3;
   */
  gcePersistentDisk?: GCEPersistentDiskVolumeSource;

  /**
   * awsElasticBlockStore represents an AWS Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AWSElasticBlockStoreVolumeSource awsElasticBlockStore = 4;
   */
  awsElasticBlockStore?: AWSElasticBlockStoreVolumeSource;

  /**
   * gitRepo represents a git repository at a particular revision.
   * DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an
   * EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir
   * into the Pod's container.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GitRepoVolumeSource gitRepo = 5;
   */
  gitRepo?: GitRepoVolumeSource;

  /**
   * secret represents a secret that should populate this volume.
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.SecretVolumeSource secret = 6;
   */
  secret?: SecretVolumeSource;

  /**
   * nfs represents an NFS mount on the host that shares a pod's lifetime
   * More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.NFSVolumeSource nfs = 7;
   */
  nfs?: NFSVolumeSource;

  /**
   * iscsi represents an ISCSI Disk resource that is attached to a
   * kubelet's host machine and then exposed to the pod.
   * More info: https://examples.k8s.io/volumes/iscsi/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ISCSIVolumeSource iscsi = 8;
   */
  iscsi?: ISCSIVolumeSource;

  /**
   * glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime.
   * More info: https://examples.k8s.io/volumes/glusterfs/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.GlusterfsVolumeSource glusterfs = 9;
   */
  glusterfs?: GlusterfsVolumeSource;

  /**
   * persistentVolumeClaimVolumeSource represents a reference to a
   * PersistentVolumeClaim in the same namespace.
   * More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PersistentVolumeClaimVolumeSource persistentVolumeClaim = 10;
   */
  persistentVolumeClaim?: PersistentVolumeClaimVolumeSource;

  /**
   * rbd represents a Rados Block Device mount on the host that shares a pod's lifetime.
   * More info: https://examples.k8s.io/volumes/rbd/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.RBDVolumeSource rbd = 11;
   */
  rbd?: RBDVolumeSource;

  /**
   * flexVolume represents a generic volume resource that is
   * provisioned/attached using an exec based plugin.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FlexVolumeSource flexVolume = 12;
   */
  flexVolume?: FlexVolumeSource;

  /**
   * cinder represents a cinder volume attached and mounted on kubelets host machine.
   * More info: https://examples.k8s.io/mysql-cinder-pd/README.md
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CinderVolumeSource cinder = 13;
   */
  cinder?: CinderVolumeSource;

  /**
   * cephFS represents a Ceph FS mount on the host that shares a pod's lifetime
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CephFSVolumeSource cephfs = 14;
   */
  cephfs?: CephFSVolumeSource;

  /**
   * flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FlockerVolumeSource flocker = 15;
   */
  flocker?: FlockerVolumeSource;

  /**
   * downwardAPI represents downward API about the pod that should populate this volume
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.DownwardAPIVolumeSource downwardAPI = 16;
   */
  downwardAPI?: DownwardAPIVolumeSource;

  /**
   * fc represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.FCVolumeSource fc = 17;
   */
  fc?: FCVolumeSource;

  /**
   * azureFile represents an Azure File Service mount on the host and bind mount to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AzureFileVolumeSource azureFile = 18;
   */
  azureFile?: AzureFileVolumeSource;

  /**
   * configMap represents a configMap that should populate this volume
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ConfigMapVolumeSource configMap = 19;
   */
  configMap?: ConfigMapVolumeSource;

  /**
   * vsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource vsphereVolume = 20;
   */
  vsphereVolume?: VsphereVirtualDiskVolumeSource;

  /**
   * quobyte represents a Quobyte mount on the host that shares a pod's lifetime
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.QuobyteVolumeSource quobyte = 21;
   */
  quobyte?: QuobyteVolumeSource;

  /**
   * azureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.AzureDiskVolumeSource azureDisk = 22;
   */
  azureDisk?: AzureDiskVolumeSource;

  /**
   * photonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
   *
   * @generated from field: optional k8s.io.api.core.v1.PhotonPersistentDiskVolumeSource photonPersistentDisk = 23;
   */
  photonPersistentDisk?: PhotonPersistentDiskVolumeSource;

  /**
   * projected items for all in one resources secrets, configmaps, and downward API
   *
   * @generated from field: optional k8s.io.api.core.v1.ProjectedVolumeSource projected = 26;
   */
  projected?: ProjectedVolumeSource;

  /**
   * portworxVolume represents a portworx volume attached and mounted on kubelets host machine
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.PortworxVolumeSource portworxVolume = 24;
   */
  portworxVolume?: PortworxVolumeSource;

  /**
   * scaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ScaleIOVolumeSource scaleIO = 25;
   */
  scaleIO?: ScaleIOVolumeSource;

  /**
   * storageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.StorageOSVolumeSource storageos = 27;
   */
  storageos?: StorageOSVolumeSource;

  /**
   * csi (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.CSIVolumeSource csi = 28;
   */
  csi?: CSIVolumeSource;

  /**
   * ephemeral represents a volume that is handled by a cluster storage driver.
   * The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts,
   * and deleted when the pod is removed.
   *
   * Use this if:
   * a) the volume is only needed while the pod runs,
   * b) features of normal volumes like restoring from snapshot or capacity
   *    tracking are needed,
   * c) the storage driver is specified through a storage class, and
   * d) the storage driver supports dynamic volume provisioning through
   *    a PersistentVolumeClaim (see EphemeralVolumeSource for more
   *    information on the connection between this volume type
   *    and PersistentVolumeClaim).
   *
   * Use PersistentVolumeClaim or one of the vendor-specific
   * APIs for volumes that persist for longer than the lifecycle
   * of an individual pod.
   *
   * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to
   * be used that way - see the documentation of the driver for
   * more information.
   *
   * A pod can use both types of ephemeral volumes and
   * persistent volumes at the same time.
   *
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.EphemeralVolumeSource ephemeral = 29;
   */
  ephemeral?: EphemeralVolumeSource;

  /**
   * image represents an OCI object (a container image or artifact) pulled and mounted on the kubelet's host machine.
   * The volume is resolved at pod startup depending on which PullPolicy value is provided:
   *
   * - Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails.
   * - Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present.
   * - IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails.
   *
   * The volume gets re-resolved if the pod gets deleted and recreated, which means that new remote content will become available on pod recreation.
   * A failure to resolve or pull the image during pod startup will block containers from starting and may add significant latency. Failures will be retried using normal volume backoff and will be reported on the pod reason and message.
   * The types of objects that may be mounted by this volume are defined by the container runtime implementation on a host machine and at minimum must include all valid types supported by the container image field.
   * The OCI object gets mounted in a single directory (spec.containers[*].volumeMounts.mountPath) by merging the manifest layers in the same way as for container images.
   * The volume will be mounted read-only (ro) and non-executable files (noexec).
   * Sub path mounts for containers are not supported (spec.containers[*].volumeMounts.subpath).
   * The field spec.securityContext.fsGroupChangePolicy has no effect on this volume type.
   * +featureGate=ImageVolume
   * +optional
   *
   * @generated from field: optional k8s.io.api.core.v1.ImageVolumeSource image = 30;
   */
  image?: ImageVolumeSource;

  constructor(data?: PartialMessage<VolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "hostPath", kind: "message", T: HostPathVolumeSource, opt: true },
    { no: 2, name: "emptyDir", kind: "message", T: EmptyDirVolumeSource, opt: true },
    { no: 3, name: "gcePersistentDisk", kind: "message", T: GCEPersistentDiskVolumeSource, opt: true },
    { no: 4, name: "awsElasticBlockStore", kind: "message", T: AWSElasticBlockStoreVolumeSource, opt: true },
    { no: 5, name: "gitRepo", kind: "message", T: GitRepoVolumeSource, opt: true },
    { no: 6, name: "secret", kind: "message", T: SecretVolumeSource, opt: true },
    { no: 7, name: "nfs", kind: "message", T: NFSVolumeSource, opt: true },
    { no: 8, name: "iscsi", kind: "message", T: ISCSIVolumeSource, opt: true },
    { no: 9, name: "glusterfs", kind: "message", T: GlusterfsVolumeSource, opt: true },
    { no: 10, name: "persistentVolumeClaim", kind: "message", T: PersistentVolumeClaimVolumeSource, opt: true },
    { no: 11, name: "rbd", kind: "message", T: RBDVolumeSource, opt: true },
    { no: 12, name: "flexVolume", kind: "message", T: FlexVolumeSource, opt: true },
    { no: 13, name: "cinder", kind: "message", T: CinderVolumeSource, opt: true },
    { no: 14, name: "cephfs", kind: "message", T: CephFSVolumeSource, opt: true },
    { no: 15, name: "flocker", kind: "message", T: FlockerVolumeSource, opt: true },
    { no: 16, name: "downwardAPI", kind: "message", T: DownwardAPIVolumeSource, opt: true },
    { no: 17, name: "fc", kind: "message", T: FCVolumeSource, opt: true },
    { no: 18, name: "azureFile", kind: "message", T: AzureFileVolumeSource, opt: true },
    { no: 19, name: "configMap", kind: "message", T: ConfigMapVolumeSource, opt: true },
    { no: 20, name: "vsphereVolume", kind: "message", T: VsphereVirtualDiskVolumeSource, opt: true },
    { no: 21, name: "quobyte", kind: "message", T: QuobyteVolumeSource, opt: true },
    { no: 22, name: "azureDisk", kind: "message", T: AzureDiskVolumeSource, opt: true },
    { no: 23, name: "photonPersistentDisk", kind: "message", T: PhotonPersistentDiskVolumeSource, opt: true },
    { no: 26, name: "projected", kind: "message", T: ProjectedVolumeSource, opt: true },
    { no: 24, name: "portworxVolume", kind: "message", T: PortworxVolumeSource, opt: true },
    { no: 25, name: "scaleIO", kind: "message", T: ScaleIOVolumeSource, opt: true },
    { no: 27, name: "storageos", kind: "message", T: StorageOSVolumeSource, opt: true },
    { no: 28, name: "csi", kind: "message", T: CSIVolumeSource, opt: true },
    { no: 29, name: "ephemeral", kind: "message", T: EphemeralVolumeSource, opt: true },
    { no: 30, name: "image", kind: "message", T: ImageVolumeSource, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VolumeSource {
    return new VolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VolumeSource {
    return new VolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VolumeSource {
    return new VolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: VolumeSource | PlainMessage<VolumeSource> | undefined, b: VolumeSource | PlainMessage<VolumeSource> | undefined): boolean {
    return proto2.util.equals(VolumeSource, a, b);
  }
}

/**
 * Represents a vSphere volume resource.
 *
 * @generated from message k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource
 */
export class VsphereVirtualDiskVolumeSource extends Message<VsphereVirtualDiskVolumeSource> {
  /**
   * volumePath is the path that identifies vSphere volume vmdk
   *
   * @generated from field: optional string volumePath = 1;
   */
  volumePath?: string;

  /**
   * fsType is filesystem type to mount.
   * Must be a filesystem type supported by the host operating system.
   * Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
   * +optional
   *
   * @generated from field: optional string fsType = 2;
   */
  fsType?: string;

  /**
   * storagePolicyName is the storage Policy Based Management (SPBM) profile name.
   * +optional
   *
   * @generated from field: optional string storagePolicyName = 3;
   */
  storagePolicyName?: string;

  /**
   * storagePolicyID is the storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
   * +optional
   *
   * @generated from field: optional string storagePolicyID = 4;
   */
  storagePolicyID?: string;

  constructor(data?: PartialMessage<VsphereVirtualDiskVolumeSource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.VsphereVirtualDiskVolumeSource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "volumePath", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "storagePolicyName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "storagePolicyID", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): VsphereVirtualDiskVolumeSource {
    return new VsphereVirtualDiskVolumeSource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): VsphereVirtualDiskVolumeSource {
    return new VsphereVirtualDiskVolumeSource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): VsphereVirtualDiskVolumeSource {
    return new VsphereVirtualDiskVolumeSource().fromJsonString(jsonString, options);
  }

  static equals(a: VsphereVirtualDiskVolumeSource | PlainMessage<VsphereVirtualDiskVolumeSource> | undefined, b: VsphereVirtualDiskVolumeSource | PlainMessage<VsphereVirtualDiskVolumeSource> | undefined): boolean {
    return proto2.util.equals(VsphereVirtualDiskVolumeSource, a, b);
  }
}

/**
 * The weights of all of the matched WeightedPodAffinityTerm fields are added per-node to find the most preferred node(s)
 *
 * @generated from message k8s.io.api.core.v1.WeightedPodAffinityTerm
 */
export class WeightedPodAffinityTerm extends Message<WeightedPodAffinityTerm> {
  /**
   * weight associated with matching the corresponding podAffinityTerm,
   * in the range 1-100.
   *
   * @generated from field: optional int32 weight = 1;
   */
  weight?: number;

  /**
   * Required. A pod affinity term, associated with the corresponding weight.
   *
   * @generated from field: optional k8s.io.api.core.v1.PodAffinityTerm podAffinityTerm = 2;
   */
  podAffinityTerm?: PodAffinityTerm;

  constructor(data?: PartialMessage<WeightedPodAffinityTerm>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.WeightedPodAffinityTerm";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "weight", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "podAffinityTerm", kind: "message", T: PodAffinityTerm, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WeightedPodAffinityTerm {
    return new WeightedPodAffinityTerm().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WeightedPodAffinityTerm {
    return new WeightedPodAffinityTerm().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WeightedPodAffinityTerm {
    return new WeightedPodAffinityTerm().fromJsonString(jsonString, options);
  }

  static equals(a: WeightedPodAffinityTerm | PlainMessage<WeightedPodAffinityTerm> | undefined, b: WeightedPodAffinityTerm | PlainMessage<WeightedPodAffinityTerm> | undefined): boolean {
    return proto2.util.equals(WeightedPodAffinityTerm, a, b);
  }
}

/**
 * WindowsSecurityContextOptions contain Windows-specific options and credentials.
 *
 * @generated from message k8s.io.api.core.v1.WindowsSecurityContextOptions
 */
export class WindowsSecurityContextOptions extends Message<WindowsSecurityContextOptions> {
  /**
   * GMSACredentialSpecName is the name of the GMSA credential spec to use.
   * +optional
   *
   * @generated from field: optional string gmsaCredentialSpecName = 1;
   */
  gmsaCredentialSpecName?: string;

  /**
   * GMSACredentialSpec is where the GMSA admission webhook
   * (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the
   * GMSA credential spec named by the GMSACredentialSpecName field.
   * +optional
   *
   * @generated from field: optional string gmsaCredentialSpec = 2;
   */
  gmsaCredentialSpec?: string;

  /**
   * The UserName in Windows to run the entrypoint of the container process.
   * Defaults to the user specified in image metadata if unspecified.
   * May also be set in PodSecurityContext. If set in both SecurityContext and
   * PodSecurityContext, the value specified in SecurityContext takes precedence.
   * +optional
   *
   * @generated from field: optional string runAsUserName = 3;
   */
  runAsUserName?: string;

  /**
   * HostProcess determines if a container should be run as a 'Host Process' container.
   * All of a Pod's containers must have the same effective HostProcess value
   * (it is not allowed to have a mix of HostProcess containers and non-HostProcess containers).
   * In addition, if HostProcess is true then HostNetwork must also be set to true.
   * +optional
   *
   * @generated from field: optional bool hostProcess = 4;
   */
  hostProcess?: boolean;

  constructor(data?: PartialMessage<WindowsSecurityContextOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.core.v1.WindowsSecurityContextOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "gmsaCredentialSpecName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "gmsaCredentialSpec", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "runAsUserName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "hostProcess", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WindowsSecurityContextOptions {
    return new WindowsSecurityContextOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WindowsSecurityContextOptions {
    return new WindowsSecurityContextOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WindowsSecurityContextOptions {
    return new WindowsSecurityContextOptions().fromJsonString(jsonString, options);
  }

  static equals(a: WindowsSecurityContextOptions | PlainMessage<WindowsSecurityContextOptions> | undefined, b: WindowsSecurityContextOptions | PlainMessage<WindowsSecurityContextOptions> | undefined): boolean {
    return proto2.util.equals(WindowsSecurityContextOptions, a, b);
  }
}

