<!-- Everything below this point is automatically generated using https://github.com/bitnami-labs/readme-generator-for-helm. Any manual changes will be overwritten on the next release -->
<!-- To make changes to this file, modify the comments in the values.yaml file and re-run readme-generator-for-helm -->

## Parameters

### Global Parameters

| Name                     | Description                                                                | Value |
| ------------------------ | -------------------------------------------------------------------------- | ----- |
| `global.env`             | Environment variables to add to all Kargo pods.                            | `[]`  |
| `global.envFrom`         | Environment variables to add to all Kargo pods from ConfigMaps or Secrets. | `[]`  |
| `global.nodeSelector`    | Default node selector for all Kargo pods.                                  | `{}`  |
| `global.labels`          | Labels to add to all resources.                                            | `{}`  |
| `global.annotations`     | Annotations to add to all resources.                                       | `{}`  |
| `global.podLabels`       | Labels to add to all pods.                                                 | `{}`  |
| `global.podAnnotations`  | Annotations to add to pods.                                                | `{}`  |
| `global.tolerations`     | Default tolerations for all Kargo pods.                                    | `[]`  |
| `global.affinity`        | Default affinity for all Kargo pods.                                       | `{}`  |
| `global.securityContext` | Default security context for all Kargo pods.                               | `{}`  |

### Image Parameters

| Name                | Description                                                                  | Value                  |
| ------------------- | ---------------------------------------------------------------------------- | ---------------------- |
| `image.repository`  | Image repository of Kargo                                                    | `ghcr.io/akuity/kargo` |
| `image.tag`         | Overrides the image tag. The default tag is the value of `.Chart.AppVersion` | `""`                   |
| `image.pullPolicy`  | Image pull policy                                                            | `IfNotPresent`         |
| `image.pullSecrets` | List of imagePullSecrets.                                                    | `[]`                   |

### RBAC

| Name                              | Description                                             | Value  |
| --------------------------------- | ------------------------------------------------------- | ------ |
| `rbac.installClusterRoles`        | Indicates if `ClusterRoles` should be installed.        | `true` |
| `rbac.installClusterRoleBindings` | Indicates if `ClusterRoleBindings` should be installed. | `true` |

### CRDs

| Name           | Description                                                                                                                                                                        | Value  |
| -------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------ |
| `crds.install` | Indicates if Custom Resource Definitions should be installed and upgraded as part of the release. If set to `false`, the CRDs will only be installed if they do not already exist. | `true` |
| `crds.keep`    | Indicates if Custom Resource Definitions should be kept when a release is uninstalled.                                                                                             | `true` |

### KubeConfigs

Optionally point to Kubernetes Secrets containing kubeconfig for:

1. A remote cluster hosting Kargo resources

2. A remote cluster hosting Argo CD resources

3. A remote cluster that is running Argo Rollouts and is a suitable location
to execute user-defined verification processes in the form of Argo
Rollouts AnalysisRuns

This flexibility is useful for various advanced use cases -- especially
topologies where Kargo data may be sharded, with Kargo controllers distributed
across many clusters. Any two, or even all three, of these configurations may
be the same. In the average case, these should all be left unspecified. All
that are unspecified will default to configuration for the cluster in which
the Kargo controller is running.

| Name                       | Description                                                                                                                                 | Value       |
| -------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------- | ----------- |
| `kubeconfigSecrets.kargo`  | Kubernetes `Secret` name containing kubeconfig for a remote Kubernetes cluster hosting Kargo resources. Used by all Kargo components.       | `undefined` |
| `kubeconfigSecrets.argocd` | Kubernetes `Secret` name containing kubeconfig for a remote Kubernetes cluster hosting Argo CD resources. Used by Kargo controller(s) only. | `undefined` |

### API

| Name                                        | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Value                    |
| ------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------ |
| `api.enabled`                               | Whether the API server is enabled.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | `true`                   |
| `api.replicas`                              | The number of API server pods.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | `1`                      |
| `api.host`                                  | The domain name where Kargo's API server will be accessible. When applicable, this is used for generation of an Ingress resource, certificates, and the OpenID Connect issuer and callback URLs. Note: The value in this field MAY include a port number and MUST NOT specify the protocol (http vs https), which is automatically inferred from other configuration options.                                                                                                                                                   | `localhost`              |
| `api.logLevel`                              | The log level for the API server.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | `INFO`                   |
| `api.labels`                                | Labels to add to the api resources. Merges with `global.labels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                                                                                                                                                          | `{}`                     |
| `api.annotations`                           | Annotations to add to the api resources. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                           | `{}`                     |
| `api.podLabels`                             | Optional labels to add to pods. Merges with `global.podLabels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                                                                                                                                                           | `{}`                     |
| `api.podAnnotations`                        | Optional annotations to add to pods. Merges with `global.podAnnotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                            | `{}`                     |
| `api.secretManagementEnabled`               | Specifies whether Secret management is enabled. This affects the API server's ability to manage repository credentials and other Project-level Secrets, such as those used by AnalysisRuns for verification purposes. If using GitOps to manage Kargo Projects declaratively, the API's Secret management capabilities are not needed and can be disabled to effectively reduce the API server's attackable surface.                                                                                                            | `true`                   |
| `api.resources`                             | Resources limits and requests for the api containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | `{}`                     |
| `api.nodeSelector`                          | Node selector for api pods. Defaults to `global.nodeSelector`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | `{}`                     |
| `api.tolerations`                           | Tolerations for api pods. Defaults to `global.tolerations`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | `[]`                     |
| `api.affinity`                              | Specifies pod affinity for api pods. Defaults to `global.affinity`.                                                                                                                                                                                                                                                                                                                                                                                                                                                             | `{}`                     |
| `api.securityContext`                       | Security context for api pods. Defaults to `global.securityContext`.                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `{}`                     |
| `api.cabundle.configMapName`                | Specifies the name of an optional ConfigMap containing CA certs that is managed "out of band." Values in the ConfigMap named here should each contain a single PEM-encoded CA cert. If secretName is also defined, it will take precedence over this field.                                                                                                                                                                                                                                                                     | `""`                     |
| `api.cabundle.secretName`                   | Specifies the name of an optional Secret containing CA certs that is managed "out of band." Values in the Secret named here should each contain a single PEM-encoded CA cert. If defined, the value of this field takes precedence over any in configMapName.                                                                                                                                                                                                                                                                   | `""`                     |
| `api.env`                                   | Environment variables to add to API server pods.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | `[]`                     |
| `api.envFrom`                               | Environment variables to add to API server pods from ConfigMaps or Secrets.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | `[]`                     |
| `api.probes.enabled`                        | Whether liveness and readiness probes should be included in the API server deployment. It is sometimes advantageous to disable these during local development.                                                                                                                                                                                                                                                                                                                                                                  | `true`                   |
| `api.tls.enabled`                           | Whether to enable TLS directly on the API server. This is helpful if you do not intend to use an ingress controller or if you require TLS end-to-end. All other settings in this section will be ignored when this is set to `false`.                                                                                                                                                                                                                                                                                           | `true`                   |
| `api.tls.selfSignedCert`                    | Whether to generate a self-signed certificate for use by the API server. If `true`, `cert-manager` CRDs **must** be present in the cluster. Kargo will create and use its own namespaced issuer. If `false`, a cert secret named `kargo-api-cert` **must** be provided in the same namespace as Kargo.                                                                                                                                                                                                                          | `true`                   |
| `api.permissiveCORSPolicyEnabled`           | Whether to enable a permissive CORS (Cross Origin Resource Sharing) policy. This is sometimes advantageous during local development, but otherwise, should generally be left disabled.                                                                                                                                                                                                                                                                                                                                          | `false`                  |
| `api.ingress.enabled`                       | Whether to enable ingress. By default, this is disabled. Enabling ingress is advanced usage.                                                                                                                                                                                                                                                                                                                                                                                                                                    | `false`                  |
| `api.ingress.annotations`                   | Annotations specified by your ingress controller to customize the behavior of the ingress resource.                                                                                                                                                                                                                                                                                                                                                                                                                             | `{}`                     |
| `api.ingress.ingressClassName`              | From Kubernetes 1.18+, this field is supported if implemented by your ingress controller. When set, you do not need to add the ingress class as annotation.                                                                                                                                                                                                                                                                                                                                                                     | `nil`                    |
| `api.ingress.tls.enabled`                   | Whether to enable TLS for the ingress. All other settings in this section will be ignored when this is set to `false`.                                                                                                                                                                                                                                                                                                                                                                                                          | `true`                   |
| `api.ingress.tls.selfSignedCert`            | Whether to generate a self-signed certificate for use with the API server's Ingress resource. If `true`, `cert-manager` CRDs **must** be present in the cluster. Kargo will create and use its own namespaced issuer. If `false`, a cert secret named `kargo-api-ingress-cert` **must** be provided in the same namespace as Kargo.                                                                                                                                                                                             | `true`                   |
| `api.ingress.pathType`                      | You may want to use `Prefix` for some controllers (like AWS LoadBalancer Ingress controller), which don't support `/` as wildcard path when pathType is set to `ImplementationSpecific`                                                                                                                                                                                                                                                                                                                                         | `ImplementationSpecific` |
| `api.service.type`                          | If you're not going to use an ingress controller, you may want to change this value to `LoadBalancer` for production deployments. If running locally, you may want to change it to `NodePort` OR leave it as `ClusterIP` and use `kubectl port-forward` to map a port on the local network interface to the service.                                                                                                                                                                                                            | `ClusterIP`              |
| `api.service.nodePort`                      | Host port the `Service` will be mapped to when `type` is either `NodePort` or `LoadBalancer`. If not specified, Kubernetes chooses.                                                                                                                                                                                                                                                                                                                                                                                             | `undefined`              |
| `api.service.annotations`                   | Annotations to add to the API server's service. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                    | `{}`                     |
| `api.secret.name`                           | Specifies the name of an existing Secret which contains the `ADMIN_ACCOUNT_PASSWORD_HASH` and `ADMIN_ACCOUNT_TOKEN_SIGNING_KEY` values. By setting this, the Secret will **not** be generated by Helm.                                                                                                                                                                                                                                                                                                                          | `""`                     |
| `api.adminAccount.enabled`                  | Whether to enable the admin account.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `true`                   |
| `api.adminAccount.passwordHash`             | Bcrypt password hash for the admin account. A value **must** be provided for this field unless `api.secret.name` is specified.                                                                                                                                                                                                                                                                                                                                                                                                  | `""`                     |
| `api.adminAccount.tokenSigningKey`          | Key used to sign ID tokens (JWTs) for the admin account. It is suggested that you generate this using a password manager or a command like: `openssl rand -base64 29 \| tr -d "=+/" \| cut`. A value **must** be provided for this field, unless `api.secret.name` is specified.                                                                                                                                                                                                                                                | `""`                     |
| `api.adminAccount.tokenTTL`                 | Specifies how long ID tokens for the admin account are valid. (i.e. The expiry will be the time of issue plus this duration.)                                                                                                                                                                                                                                                                                                                                                                                                   | `24h`                    |
| `api.oidc.enabled`                          | Whether to enable authentication using Open ID Connect.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | `false`                  |
| `api.oidc.issuerURL`                        | The issuer URL for the identity provider. If Dex is enabled, this value will be ignored and the issuer URL will be automatically configured. If Dex is not enabled, this should be set to the issuer URL provided to you by your identity provider.                                                                                                                                                                                                                                                                             | `nil`                    |
| `api.oidc.clientID`                         | The client ID for the OIDC client. If Dex is enabled, this value will be ignored and the client ID will be automatically configured. If Dex is not enabled, this should be set to the client ID provided to you by your identity provider.                                                                                                                                                                                                                                                                                      | `nil`                    |
| `api.oidc.cliClientID`                      | The client ID for the OIDC client used by CLI (optional). Needed by some OIDC providers (such as Dex) that require a separate Client ID for web app login vs. CLI login (`http://localhost`). If Dex is enabled, this value will be ignored and cli client ID will be automatically configured. If Dex is not enabled, and a different client app is configured for localhost CLI login, this should be the client ID configured in the IdP.                                                                                    | `nil`                    |
| `api.oidc.additionalScopes`                 | The additional scopes to send to the OIDC provider. This should be set to the scopes you wish to be provided to your identity provider from clients of Kargo, the scopes openid, profile and email are always requested and don't need to be added, this value is intended for any additional ones you require.                                                                                                                                                                                                                 | `["groups"]`             |
| `api.oidc.admins.claims`                    | Subjects having any of these claims will automatically be Kargo admins.                                                                                                                                                                                                                                                                                                                                                                                                                                                         | `{}`                     |
| `api.oidc.viewers.claims`                   | Subjects having any of these claims will automatically receive read-only access to all Kargo resources.                                                                                                                                                                                                                                                                                                                                                                                                                         | `{}`                     |
| `api.oidc.globalServiceAccounts.namespaces` | List of namespaces to look for shared service accounts.                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | `[]`                     |
| `api.oidc.dex.enabled`                      | Whether to enable Dex as the identity provider. When set to true, the Kargo installation will include a Dex server and the Kargo API server will be configured to make the /dex endpoint a reverse proxy for the Dex server.                                                                                                                                                                                                                                                                                                    | `false`                  |
| `api.oidc.dex.image.repository`             | Image repository of Dex                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | `ghcr.io/dexidp/dex`     |
| `api.oidc.dex.image.tag`                    | Image tag for Dex.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | `v2.37.0`                |
| `api.oidc.dex.image.pullPolicy`             | Image pull policy for Dex.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | `IfNotPresent`           |
| `api.oidc.dex.image.pullSecrets`            | List of imagePullSecrets.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | `[]`                     |
| `api.oidc.dex.env`                          | Environment variables to add to Dex server pods. This is convenient for cases where api.oidc.dex.connectors needs to reference environment variables from a Secret that is managed "out of band" with a secret management solution such as Sealed Secrets.                                                                                                                                                                                                                                                                      | `[]`                     |
| `api.oidc.dex.envFrom`                      | Environment variables to add to Dex server pods from ConfigMaps or Secrets. This is especially convenient for cases where api.oidc.dex.connectors needs to reference environment variables from a Secret that is managed "out of band" with a secret management solution such as Sealed Secrets.                                                                                                                                                                                                                                | `[]`                     |
| `api.oidc.dex.volumes`                      | Add additional volumes to Dex pods. This is convenient for cases where api.oidc.dex.connectors needs to reference mounted data from a Secret that is managed "out of band" with a secret management solution such as Sealed Secrets.                                                                                                                                                                                                                                                                                            | `[]`                     |
| `api.oidc.dex.volumeMounts`                 | Add additional volume mounts to Dex pods. This is convenient for cases where api.oidc.dex.connectors needs to reference mounted data from a Secret that is managed "out of band" with a secret management solution such as Sealed Secrets.                                                                                                                                                                                                                                                                                      | `nil`                    |
| `api.oidc.dex.probes.enabled`               | Whether liveness and readiness probes should be included in the Dex server deployment. It is sometimes advantageous to disable these during local development.                                                                                                                                                                                                                                                                                                                                                                  | `true`                   |
| `api.oidc.dex.tls.selfSignedCert`           | Whether to generate a self-signed certificate for use with Dex. If `true`, `cert-manager` CRDs **must** be present in the cluster. Kargo will create and use its own namespaced issuer. If `false`, a cert secret named `kargo-dex-server-cert` **must** be provided in the same namespace as Kargo. There is no provision for running Dex without TLS.                                                                                                                                                                         | `true`                   |
| `api.oidc.dex.skipApprovalScreen`           | Whether to skip Dex's own approval screen. Since upstream identity providers will already request user consent, this second approval screen from Dex can be both superfluous and confusing.                                                                                                                                                                                                                                                                                                                                     | `true`                   |
| `api.oidc.dex.connectors`                   | Configure [Dex connectors](https://dexidp.io/docs/connectors/) to one or more upstream identity providers.                                                                                                                                                                                                                                                                                                                                                                                                                      | `[]`                     |
| `api.oidc.dex.resources`                    | Resources limits and requests for the Dex server containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | `{}`                     |
| `api.oidc.dex.nodeSelector`                 | Node selector for Dex server pods. Defaults to `global.nodeSelector`.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | `{}`                     |
| `api.oidc.dex.tolerations`                  | Tolerations for Dex server pods. Defaults to `global.tolerations`.                                                                                                                                                                                                                                                                                                                                                                                                                                                              | `[]`                     |
| `api.oidc.dex.affinity`                     | Specifies pod affinity for the Dex server pods. Defaults to `global.affinity`.                                                                                                                                                                                                                                                                                                                                                                                                                                                  | `{}`                     |
| `api.oidc.dex.annotations`                  | Annotations to add to the Dex server pods. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                         | `{}`                     |
| `api.oidc.dex.securityContext`              | Security context for Dex server pods. Defaults to `global.securityContext`.                                                                                                                                                                                                                                                                                                                                                                                                                                                     | `{}`                     |
| `api.argocd.urls`                           | Mapping of Argo CD shards names to URLs to support deep links to Argo CD URLs. If sharding is not used, map the empty string to the single Argo CD URL.                                                                                                                                                                                                                                                                                                                                                                         | `nil`                    |
| `api.rollouts.integrationEnabled`           | Specifies whether Argo Rollouts integration is enabled. When not enabled, the API server will not be capable of creating/updating/applying AnalysesTemplate resources in the Kargo control plane. When enabled, the API server will perform a sanity check at startup. If Argo Rollouts CRDs are not found, the API server will proceed as if this integration had been explicitly disabled. Explicitly disabling is still preferable if this integration is not desired, as it will grant fewer permissions to the API server. | `true`                   |

### Controller

| Name                                                               | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Value               |
| ------------------------------------------------------------------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------- |
| `controller.enabled`                                               | Whether the controller is enabled.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | `true`              |
| `controller.labels`                                                | Labels to add to the api resources. Merges with `global.labels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | `{}`                |
| `controller.annotations`                                           | Annotations to add to the api resources. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `{}`                |
| `controller.podLabels`                                             | Optional labels to add to pods. Merges with `global.podLabels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `{}`                |
| `controller.podAnnotations`                                        | Optional annotations to add to pods. Merges with `global.podAnnotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | `{}`                |
| `controller.serviceAccount.iamRole`                                | Specifies the ARN of an AWS IAM role to be used by the controller in an IRSA-enabled EKS cluster.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | `""`                |
| `controller.serviceAccount.clusterWideSecretReadingEnabled`        | Specifies whether the controller's ServiceAccount should be granted read permissions to Secrets CLUSTER-WIDE in the Kargo control plane's cluster. Enabling this is highly discouraged and you do so at your own peril. When this is NOT enabled, the Kargo management controller will dynamically expand and contract the controller's permissions to read Secrets on a Project-by-Project basis.                                                                                                                                                                                                                                                                                                                               | `false`             |
| `controller.globalCredentials.namespaces`                          | List of namespaces to look for shared credentials. Note that as of v1.0.0, the Kargo controller does not have cluster-wide access to Secrets. The controller receives read-only permission for Secrets on a per-Project basis as Projects are created. If you designate some namespaces as homes for "global" credentials, you will need to manually grant the controller permission to read Secrets in those namespaces.                                                                                                                                                                                                                                                                                                        | `[]`                |
| `controller.reconcilers.maxConcurrentReconciles`                   | specifies the maximum number of resources EACH of the controller's reconcilers can reconcile concurrently. This setting may also be overridden on a per-reconciler basis.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | `4`                 |
| `controller.reconcilers.controlFlowStages.maxConcurrentReconciles` | optionally overrides the maximum number of control flow Stage resources the controller can reconcile concurrently.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | `nil`               |
| `controller.reconcilers.promotions.maxConcurrentReconciles`        | optionally overrides the maximum number of Promotion resources the controller can reconcile concurrently.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | `nil`               |
| `controller.reconcilers.stages.maxConcurrentReconciles`            | optionally overrides the maximum number of (non-control flow) Stage resources the controller can reconcile concurrently.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | `nil`               |
| `controller.reconcilers.warehouses.maxConcurrentReconciles`        | optionally overrides the maximum number of Warehouse resources the controller can reconcile concurrently.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | `nil`               |
| `controller.gitClient.name`                                        | Specifies the name of the Kargo controller (used when authoring Git commits).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | `Kargo`             |
| `controller.gitClient.email`                                       | Specifies the email of the Kargo controller (used when authoring Git commits).                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | `no-reply@kargo.io` |
| `controller.gitClient.signingKeySecret.name`                       | Specifies the name of an existing `Secret` which contains the Git user's signing key. The value should be accessible under `.data.signingKey` in the same namespace as Kargo. When the signing key is a GPG key, the GPG key's name and email address identity must match the values defined for `controller.gitClient.name` and `controller.gitClient.email`.                                                                                                                                                                                                                                                                                                                                                                   | `""`                |
| `controller.gitClient.signingKeySecret.type`                       | Specifies the type of the signing key. The currently supported and default option is `gpg`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | `""`                |
| `controller.securityContext`                                       | Security context for controller pods. Defaults to `global.securityContext`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | `{}`                |
| `controller.cabundle.configMapName`                                | Specifies the name of an optional ConfigMap containing CA certs that is managed "out of band." Values in the ConfigMap named here should each contain a single PEM-encoded CA cert. If secretName is also defined, it will take precedence over this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | `""`                |
| `controller.cabundle.secretName`                                   | Specifies the name of an optional Secret containing CA certs that is managed "out of band." Values in the Secret named here should each contain a single PEM-encoded CA cert. If defined, the value of this field takes precedence over any in configMapName.                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | `""`                |
| `controller.shardName`                                             | Set a shard name only if you are running multiple controllers backed by a single underlying control plane. Setting a shard name will cause this controller to operate **only** on resources with a matching shard name. Leaving the shard name undefined will designate this controller as the default controller that is responsible exclusively for resources that are **not** assigned to a specific shard. Leaving this undefined is the correct choice when you are not using sharding at all. It is also the correct setting if you are using sharding and want to designate a controller as the default for handling resources not assigned to a specific shard. In most cases, this setting should simply be left alone. | `undefined`         |
| `controller.argocd.integrationEnabled`                             | Specifies whether Argo CD integration is enabled. When not enabled, the controller will not watch Argo CD Application resources or factor Application health and sync state into determinations of Stage health. Argo CD-based promotion mechanisms will also fail. When enabled, the controller will perform a sanity check at startup. If Argo CD CRDs are not found, the controller will proceed as if this integration had been explicitly disabled. Explicitly disabling is still preferable if this integration is not desired, as it will grant fewer permissions to the controller.                                                                                                                                      | `true`              |
| `controller.argocd.namespace`                                      | The namespace into which Argo CD is installed.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | `argocd`            |
| `controller.argocd.watchArgocdNamespaceOnly`                       | Specifies whether the reconciler that watches Argo CD Applications for the sake of forcing related Stages to reconcile should only watch Argo CD Application resources residing in Argo CD's own namespace. Note: Older versions of Argo CD only supported Argo CD Application resources in Argo CD's own namespace, but newer versions support Argo CD Application resources in any namespace. This should usually be left as `false`.                                                                                                                                                                                                                                                                                          | `false`             |
| `controller.rollouts.integrationEnabled`                           | Specifies whether Argo Rollouts integration is enabled. When not enabled, the controller will not reconcile Argo Rollouts AnalysisRun resources and attempts to verify Stages via Analysis will fail. When enabled, the controller will perform a sanity check at startup. If Argo Rollouts CRDs are not found, the controller will proceed as if this integration had been explicitly disabled. Explicitly disabling is still preferable if this integration is not desired, as it will grant fewer permissions to the controller.                                                                                                                                                                                              | `true`              |
| `controller.rollouts.controllerInstanceID`                         | Specifies a cluster on which Jobs corresponding to an AnalysisRun (used for Freight/Stage verification purposes) will be executed. This is useful in cases where the cluster hosting the Kargo control plane is not a suitable environment for executing user-defined logic. Kargo will use this as the value of the rgo-rollouts.argoproj.io/controller-instance-id label when creating AnalysisRuns. When this is left empty/undefined, no such label will be added to AnalysisRuns.                                                                                                                                                                                                                                           | `""`                |
| `controller.logLevel`                                              | The log level for the controller.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | `INFO`              |
| `controller.resources`                                             | Resources limits and requests for the controller containers.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | `{}`                |
| `controller.nodeSelector`                                          | Node selector for controller pods. Defaults to `global.nodeSelector`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | `{}`                |
| `controller.tolerations`                                           | Tolerations for controller pods. Defaults to `global.tolerations`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | `[]`                |
| `controller.affinity`                                              | Specifies pod affinity for controller pods. Defaults to `global.affinity`.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | `{}`                |
| `controller.env`                                                   | Environment variables to add to controller pods.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | `[]`                |
| `controller.envFrom`                                               | Environment variables to add to controller pods from ConfigMaps or Secrets.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | `[]`                |

### Management Controller

| Name                                                                       | Description                                                                                                                                                                          | Value  |
| -------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ | ------ |
| `managementController.enabled`                                             | Whether the management controller is enabled.                                                                                                                                        | `true` |
| `managementController.logLevel`                                            | The log level for the management controller.                                                                                                                                         | `INFO` |
| `managementController.labels`                                              | Labels to add to the api resources. Merges with `global.labels`, allowing you to override or add to the global labels.                                                               | `{}`   |
| `managementController.annotations`                                         | Annotations to add to the api resources. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                | `{}`   |
| `managementController.podLabels`                                           | Optional labels to add to pods. Merges with `global.podLabels`, allowing you to override or add to the global labels.                                                                | `{}`   |
| `managementController.podAnnotations`                                      | Optional annotations to add to pods. Merges with `global.podAnnotations`, allowing you to override or add to the global annotations.                                                 | `{}`   |
| `managementController.reconcilers.maxConcurrentReconciles`                 | specifies the maximum number of resources EACH of the management controller's reconcilers can reconcile concurrently. This setting may also be overridden on a per-reconciler basis. | `4`    |
| `managementController.reconcilers.namespaces.maxConcurrentReconciles`      | optionally overrides the maximum number of Namespace resources the management controller can reconcile concurrently.                                                                 | `nil`  |
| `managementController.reconcilers.projects.maxConcurrentReconciles`        | optionally overrides the maximum number of Project resources the management controller can reconcile concurrently.                                                                   | `nil`  |
| `managementController.reconcilers.serviceAccounts.maxConcurrentReconciles` | optionally overrides the maximum number of ServiceAccount resources the management controller can reconcile concurrently.                                                            | `nil`  |
| `managementController.securityContext`                                     | Security context for management controller pods. Defaults to `global.securityContext`.                                                                                               | `{}`   |
| `managementController.resources`                                           | Resources limits and requests for the management controller containers.                                                                                                              | `{}`   |
| `managementController.nodeSelector`                                        | Node selector for management controller pods. Defaults to `global.nodeSelector`.                                                                                                     | `{}`   |
| `managementController.tolerations`                                         | Tolerations for management controller pods. Defaults to `global.tolerations`.                                                                                                        | `[]`   |
| `managementController.affinity`                                            | Specifies pod affinity for management controller pods. Defaults to `global.affinity`.                                                                                                | `{}`   |
| `managementController.env`                                                 | Environment variables to add to management controller pods.                                                                                                                          | `[]`   |
| `managementController.envFrom`                                             | Environment variables to add to management controller pods from ConfigMaps or Secrets.                                                                                               | `[]`   |

### Webhooks

| Name                | Description                                                                                      | Value  |
| ------------------- | ------------------------------------------------------------------------------------------------ | ------ |
| `webhooks.register` | Whether to create `ValidatingWebhookConfiguration` and `MutatingWebhookConfiguration` resources. | `true` |

### Webhooks Server

| Name                                   | Description                                                                                                                                                                                                                                                                                                                                                                           | Value  |
| -------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------ |
| `webhooksServer.enabled`               | Whether the webhooks server is enabled.                                                                                                                                                                                                                                                                                                                                               | `true` |
| `webhooksServer.replicas`              | The number of webhooks server pods.                                                                                                                                                                                                                                                                                                                                                   | `1`    |
| `webhooksServer.logLevel`              | The log level for the webhooks server.                                                                                                                                                                                                                                                                                                                                                | `INFO` |
| `webhooksServer.controlplaneUserRegex` | Regular expression for matching controlplane users.                                                                                                                                                                                                                                                                                                                                   | `""`   |
| `webhooksServer.labels`                | Labels to add to the api resources. Merges with `global.labels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                | `{}`   |
| `webhooksServer.annotations`           | Annotations to add to the api resources. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                 | `{}`   |
| `webhooksServer.podLabels`             | Optional labels to add to pods. Merges with `global.podLabels`, allowing you to override or add to the global labels.                                                                                                                                                                                                                                                                 | `{}`   |
| `webhooksServer.podAnnotations`        | Optional annotations to add to pods. Merges with `global.podAnnotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                                                                                  | `{}`   |
| `webhooksServer.tls.selfSignedCert`    | Whether to generate a self-signed certificate for the controller's built-in webhook server. If `true`, `cert-manager` CRDs **must** be present in the cluster. Kargo will create and use its own namespaced issuer. If `false`, a cert secret named `kargo-webhooks-server-cert` **must** be provided in the same namespace as Kargo. There is no provision for webhooks without TLS. | `true` |
| `webhooksServer.resources`             | Resources limits and requests for the webhooks server containers.                                                                                                                                                                                                                                                                                                                     | `{}`   |
| `webhooksServer.nodeSelector`          | Node selector for the webhooks server pods. Defaults to `global.nodeSelector`.                                                                                                                                                                                                                                                                                                        | `{}`   |
| `webhooksServer.tolerations`           | Tolerations for the webhooks server pods. Defaults to `global.tolerations`.                                                                                                                                                                                                                                                                                                           | `[]`   |
| `webhooksServer.affinity`              | Specifies pod affinity for the webhooks server pods. Defaults to `global.affinity`.                                                                                                                                                                                                                                                                                                   | `{}`   |
| `webhooksServer.securityContext`       | Security context for webhooks server pods. Defaults to `global.securityContext`.                                                                                                                                                                                                                                                                                                      | `{}`   |
| `webhooksServer.env`                   | Environment variables to add to webhook server pods.                                                                                                                                                                                                                                                                                                                                  | `[]`   |
| `webhooksServer.envFrom`               | Environment variables to add to webhook server pods from ConfigMaps or Secrets.                                                                                                                                                                                                                                                                                                       | `[]`   |

### Garbage Collector

| Name                                       | Description                                                                                                                                                                                                                                                                                                               | Value       |
| ------------------------------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------- |
| `garbageCollector.enabled`                 | Whether the garbage collector is enabled.                                                                                                                                                                                                                                                                                 | `true`      |
| `garbageCollector.schedule`                | When to run the garbage collector.                                                                                                                                                                                                                                                                                        | `0 * * * *` |
| `garbageCollector.workers`                 | The number of concurrent workers to run. Tuning this too low will result in slow garbage collection. Tuning this too high will result in too many API calls and may result in throttling.                                                                                                                                 | `3`         |
| `garbageCollector.maxRetainedPromotions`   | The ideal maximum number of Promotions OLDER than the oldest Promotion in a non-terminal phase (for each Stage) that may be spared by the garbage collector. The ACTUAL number of older Promotions spared may exceed this ideal if some Promotions that would otherwise be deleted do not meet the minimum age criterion. | `20`        |
| `garbageCollector.minPromotionDeletionAge` | The minimum age a Promotion must be before considered eligible for garbage collection.                                                                                                                                                                                                                                    | `336h`      |
| `garbageCollector.maxRetainedFreight`      | The ideal maximum number of Freight OLDER than the oldest still in use (from each Warehouse) that may be spared by the garbage collector. The ACTUAL number of older Freight spared may exceed this ideal if some Freight that would otherwise be deleted do not meet the minimum age criterion.                          | `20`        |
| `garbageCollector.minFreightDeletionAge`   | The minimum age Freight must be before considered eligible for garbage collection.                                                                                                                                                                                                                                        | `336h`      |
| `garbageCollector.logLevel`                | The log level for the garbage collector.                                                                                                                                                                                                                                                                                  | `INFO`      |
| `garbageCollector.labels`                  | Labels to add to the api resources. Merges with `global.labels`, allowing you to override or add to the global labels.                                                                                                                                                                                                    | `{}`        |
| `garbageCollector.annotations`             | Annotations to add to the api resources. Merges with `global.annotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                     | `{}`        |
| `garbageCollector.podLabels`               | Optional labels to add to pods. Merges with `global.podLabels`, allowing you to override or add to the global labels.                                                                                                                                                                                                     | `{}`        |
| `garbageCollector.podAnnotations`          | Optional annotations to add to pods. Merges with `global.podAnnotations`, allowing you to override or add to the global annotations.                                                                                                                                                                                      | `{}`        |
| `garbageCollector.resources`               | Resources limits and requests for the garbage collector containers.                                                                                                                                                                                                                                                       | `{}`        |
| `garbageCollector.nodeSelector`            | Node selector for the garbage collector pods. Defaults to `global.nodeSelector`.                                                                                                                                                                                                                                          | `{}`        |
| `garbageCollector.tolerations`             | Tolerations for the garbage collector pods. Defaults to `global.tolerations`.                                                                                                                                                                                                                                             | `[]`        |
| `garbageCollector.affinity`                | Specifies pod affinity for the garbage collector pods. Defaults to `global.affinity`.                                                                                                                                                                                                                                     | `{}`        |
| `garbageCollector.securityContext`         | Security context for garbage collector pods. Defaults to `global.securityContext`.                                                                                                                                                                                                                                        | `{}`        |
| `garbageCollector.env`                     | Environment variables to add to garbage collector pods.                                                                                                                                                                                                                                                                   | `[]`        |
| `garbageCollector.envFrom`                 | Environment variables to add to garbage collector pods from ConfigMaps or Secrets.                                                                                                                                                                                                                                        | `[]`        |
