//
//Copyright The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file was autogenerated by go-to-protobuf. Do not edit it manually!

// @generated by protoc-gen-es v1.8.0 with parameter "target=ts"
// @generated from file k8s.io/api/batch/v1/generated.proto (package k8s.io.api.batch.v1, syntax proto2)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto2 } from "@bufbuild/protobuf";
import { LabelSelector, ListMeta, ObjectMeta, Time } from "../../../apimachinery/pkg/apis/meta/v1/generated_pb.js";
import { ObjectReference, PodTemplateSpec } from "../../core/v1/generated_pb.js";

/**
 * CronJob represents the configuration of a single cron job.
 *
 * @generated from message k8s.io.api.batch.v1.CronJob
 */
export class CronJob extends Message<CronJob> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Specification of the desired behavior of a cron job, including the schedule.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.CronJobSpec spec = 2;
   */
  spec?: CronJobSpec;

  /**
   * Current status of a cron job.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.CronJobStatus status = 3;
   */
  status?: CronJobStatus;

  constructor(data?: PartialMessage<CronJob>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.CronJob";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: CronJobSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: CronJobStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CronJob {
    return new CronJob().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CronJob {
    return new CronJob().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CronJob {
    return new CronJob().fromJsonString(jsonString, options);
  }

  static equals(a: CronJob | PlainMessage<CronJob> | undefined, b: CronJob | PlainMessage<CronJob> | undefined): boolean {
    return proto2.util.equals(CronJob, a, b);
  }
}

/**
 * CronJobList is a collection of cron jobs.
 *
 * @generated from message k8s.io.api.batch.v1.CronJobList
 */
export class CronJobList extends Message<CronJobList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items is the list of CronJobs.
   *
   * @generated from field: repeated k8s.io.api.batch.v1.CronJob items = 2;
   */
  items: CronJob[] = [];

  constructor(data?: PartialMessage<CronJobList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.CronJobList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: CronJob, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CronJobList {
    return new CronJobList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CronJobList {
    return new CronJobList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CronJobList {
    return new CronJobList().fromJsonString(jsonString, options);
  }

  static equals(a: CronJobList | PlainMessage<CronJobList> | undefined, b: CronJobList | PlainMessage<CronJobList> | undefined): boolean {
    return proto2.util.equals(CronJobList, a, b);
  }
}

/**
 * CronJobSpec describes how the job execution will look like and when it will actually run.
 *
 * @generated from message k8s.io.api.batch.v1.CronJobSpec
 */
export class CronJobSpec extends Message<CronJobSpec> {
  /**
   * The schedule in Cron format, see https://en.wikipedia.org/wiki/Cron.
   *
   * @generated from field: optional string schedule = 1;
   */
  schedule?: string;

  /**
   * The time zone name for the given schedule, see https://en.wikipedia.org/wiki/List_of_tz_database_time_zones.
   * If not specified, this will default to the time zone of the kube-controller-manager process.
   * The set of valid time zone names and the time zone offset is loaded from the system-wide time zone
   * database by the API server during CronJob validation and the controller manager during execution.
   * If no system-wide time zone database can be found a bundled version of the database is used instead.
   * If the time zone name becomes invalid during the lifetime of a CronJob or due to a change in host
   * configuration, the controller will stop creating new new Jobs and will create a system event with the
   * reason UnknownTimeZone.
   * More information can be found in https://kubernetes.io/docs/concepts/workloads/controllers/cron-jobs/#time-zones
   * +optional
   *
   * @generated from field: optional string timeZone = 8;
   */
  timeZone?: string;

  /**
   * Optional deadline in seconds for starting the job if it misses scheduled
   * time for any reason.  Missed jobs executions will be counted as failed ones.
   * +optional
   *
   * @generated from field: optional int64 startingDeadlineSeconds = 2;
   */
  startingDeadlineSeconds?: bigint;

  /**
   * Specifies how to treat concurrent executions of a Job.
   * Valid values are:
   *
   * - "Allow" (default): allows CronJobs to run concurrently;
   * - "Forbid": forbids concurrent runs, skipping next run if previous run hasn't finished yet;
   * - "Replace": cancels currently running job and replaces it with a new one
   * +optional
   *
   * @generated from field: optional string concurrencyPolicy = 3;
   */
  concurrencyPolicy?: string;

  /**
   * This flag tells the controller to suspend subsequent executions, it does
   * not apply to already started executions.  Defaults to false.
   * +optional
   *
   * @generated from field: optional bool suspend = 4;
   */
  suspend?: boolean;

  /**
   * Specifies the job that will be created when executing a CronJob.
   *
   * @generated from field: optional k8s.io.api.batch.v1.JobTemplateSpec jobTemplate = 5;
   */
  jobTemplate?: JobTemplateSpec;

  /**
   * The number of successful finished jobs to retain. Value must be non-negative integer.
   * Defaults to 3.
   * +optional
   *
   * @generated from field: optional int32 successfulJobsHistoryLimit = 6;
   */
  successfulJobsHistoryLimit?: number;

  /**
   * The number of failed finished jobs to retain. Value must be non-negative integer.
   * Defaults to 1.
   * +optional
   *
   * @generated from field: optional int32 failedJobsHistoryLimit = 7;
   */
  failedJobsHistoryLimit?: number;

  constructor(data?: PartialMessage<CronJobSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.CronJobSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "schedule", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "timeZone", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "startingDeadlineSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 3, name: "concurrencyPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "suspend", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 5, name: "jobTemplate", kind: "message", T: JobTemplateSpec, opt: true },
    { no: 6, name: "successfulJobsHistoryLimit", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 7, name: "failedJobsHistoryLimit", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CronJobSpec {
    return new CronJobSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CronJobSpec {
    return new CronJobSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CronJobSpec {
    return new CronJobSpec().fromJsonString(jsonString, options);
  }

  static equals(a: CronJobSpec | PlainMessage<CronJobSpec> | undefined, b: CronJobSpec | PlainMessage<CronJobSpec> | undefined): boolean {
    return proto2.util.equals(CronJobSpec, a, b);
  }
}

/**
 * CronJobStatus represents the current state of a cron job.
 *
 * @generated from message k8s.io.api.batch.v1.CronJobStatus
 */
export class CronJobStatus extends Message<CronJobStatus> {
  /**
   * A list of pointers to currently running jobs.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.core.v1.ObjectReference active = 1;
   */
  active: ObjectReference[] = [];

  /**
   * Information when was the last time the job was successfully scheduled.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastScheduleTime = 4;
   */
  lastScheduleTime?: Time;

  /**
   * Information when was the last time the job successfully completed.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastSuccessfulTime = 5;
   */
  lastSuccessfulTime?: Time;

  constructor(data?: PartialMessage<CronJobStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.CronJobStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "active", kind: "message", T: ObjectReference, repeated: true },
    { no: 4, name: "lastScheduleTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "lastSuccessfulTime", kind: "message", T: Time, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CronJobStatus {
    return new CronJobStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CronJobStatus {
    return new CronJobStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CronJobStatus {
    return new CronJobStatus().fromJsonString(jsonString, options);
  }

  static equals(a: CronJobStatus | PlainMessage<CronJobStatus> | undefined, b: CronJobStatus | PlainMessage<CronJobStatus> | undefined): boolean {
    return proto2.util.equals(CronJobStatus, a, b);
  }
}

/**
 * Job represents the configuration of a single job.
 *
 * @generated from message k8s.io.api.batch.v1.Job
 */
export class Job extends Message<Job> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Specification of the desired behavior of a job.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.JobSpec spec = 2;
   */
  spec?: JobSpec;

  /**
   * Current status of a job.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.JobStatus status = 3;
   */
  status?: JobStatus;

  constructor(data?: PartialMessage<Job>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.Job";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: JobSpec, opt: true },
    { no: 3, name: "status", kind: "message", T: JobStatus, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Job {
    return new Job().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Job {
    return new Job().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Job {
    return new Job().fromJsonString(jsonString, options);
  }

  static equals(a: Job | PlainMessage<Job> | undefined, b: Job | PlainMessage<Job> | undefined): boolean {
    return proto2.util.equals(Job, a, b);
  }
}

/**
 * JobCondition describes current state of a job.
 *
 * @generated from message k8s.io.api.batch.v1.JobCondition
 */
export class JobCondition extends Message<JobCondition> {
  /**
   * Type of job condition, Complete or Failed.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Status of the condition, one of True, False, Unknown.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * Last time the condition was checked.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastProbeTime = 3;
   */
  lastProbeTime?: Time;

  /**
   * Last time the condition transit from one status to another.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * (brief) reason for the condition's last transition.
   * +optional
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * Human readable message indicating details about last transition.
   * +optional
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<JobCondition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.JobCondition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "lastProbeTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobCondition {
    return new JobCondition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobCondition {
    return new JobCondition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobCondition {
    return new JobCondition().fromJsonString(jsonString, options);
  }

  static equals(a: JobCondition | PlainMessage<JobCondition> | undefined, b: JobCondition | PlainMessage<JobCondition> | undefined): boolean {
    return proto2.util.equals(JobCondition, a, b);
  }
}

/**
 * JobList is a collection of jobs.
 *
 * @generated from message k8s.io.api.batch.v1.JobList
 */
export class JobList extends Message<JobList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items is the list of Jobs.
   *
   * @generated from field: repeated k8s.io.api.batch.v1.Job items = 2;
   */
  items: Job[] = [];

  constructor(data?: PartialMessage<JobList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.JobList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: Job, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobList {
    return new JobList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobList {
    return new JobList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobList {
    return new JobList().fromJsonString(jsonString, options);
  }

  static equals(a: JobList | PlainMessage<JobList> | undefined, b: JobList | PlainMessage<JobList> | undefined): boolean {
    return proto2.util.equals(JobList, a, b);
  }
}

/**
 * JobSpec describes how the job execution will look like.
 *
 * @generated from message k8s.io.api.batch.v1.JobSpec
 */
export class JobSpec extends Message<JobSpec> {
  /**
   * Specifies the maximum desired number of pods the job should
   * run at any given time. The actual number of pods running in steady state will
   * be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism),
   * i.e. when the work left to do is less than max parallelism.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
   * +optional
   *
   * @generated from field: optional int32 parallelism = 1;
   */
  parallelism?: number;

  /**
   * Specifies the desired number of successfully finished pods the
   * job should be run with.  Setting to null means that the success of any
   * pod signals the success of all pods, and allows parallelism to have any positive
   * value.  Setting to 1 means that parallelism is limited to 1 and the success of that
   * pod signals the success of the job.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
   * +optional
   *
   * @generated from field: optional int32 completions = 2;
   */
  completions?: number;

  /**
   * Specifies the duration in seconds relative to the startTime that the job
   * may be continuously active before the system tries to terminate it; value
   * must be positive integer. If a Job is suspended (at creation or through an
   * update), this timer will effectively be stopped and reset when the Job is
   * resumed again.
   * +optional
   *
   * @generated from field: optional int64 activeDeadlineSeconds = 3;
   */
  activeDeadlineSeconds?: bigint;

  /**
   * Specifies the policy of handling failed pods. In particular, it allows to
   * specify the set of actions and conditions which need to be
   * satisfied to take the associated action.
   * If empty, the default behaviour applies - the counter of failed pods,
   * represented by the jobs's .status.failed field, is incremented and it is
   * checked against the backoffLimit. This field cannot be used in combination
   * with restartPolicy=OnFailure.
   *
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.PodFailurePolicy podFailurePolicy = 11;
   */
  podFailurePolicy?: PodFailurePolicy;

  /**
   * successPolicy specifies the policy when the Job can be declared as succeeded.
   * If empty, the default behavior applies - the Job is declared as succeeded
   * only when the number of succeeded pods equals to the completions.
   * When the field is specified, it must be immutable and works only for the Indexed Jobs.
   * Once the Job meets the SuccessPolicy, the lingering pods are terminated.
   *
   * This field is beta-level. To use this field, you must enable the
   * `JobSuccessPolicy` feature gate (enabled by default).
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.SuccessPolicy successPolicy = 16;
   */
  successPolicy?: SuccessPolicy;

  /**
   * Specifies the number of retries before marking this job failed.
   * Defaults to 6
   * +optional
   *
   * @generated from field: optional int32 backoffLimit = 7;
   */
  backoffLimit?: number;

  /**
   * Specifies the limit for the number of retries within an
   * index before marking this index as failed. When enabled the number of
   * failures per index is kept in the pod's
   * batch.kubernetes.io/job-index-failure-count annotation. It can only
   * be set when Job's completionMode=Indexed, and the Pod's restart
   * policy is Never. The field is immutable.
   * This field is beta-level. It can be used when the `JobBackoffLimitPerIndex`
   * feature gate is enabled (enabled by default).
   * +optional
   *
   * @generated from field: optional int32 backoffLimitPerIndex = 12;
   */
  backoffLimitPerIndex?: number;

  /**
   * Specifies the maximal number of failed indexes before marking the Job as
   * failed, when backoffLimitPerIndex is set. Once the number of failed
   * indexes exceeds this number the entire Job is marked as Failed and its
   * execution is terminated. When left as null the job continues execution of
   * all of its indexes and is marked with the `Complete` Job condition.
   * It can only be specified when backoffLimitPerIndex is set.
   * It can be null or up to completions. It is required and must be
   * less than or equal to 10^4 when is completions greater than 10^5.
   * This field is beta-level. It can be used when the `JobBackoffLimitPerIndex`
   * feature gate is enabled (enabled by default).
   * +optional
   *
   * @generated from field: optional int32 maxFailedIndexes = 13;
   */
  maxFailedIndexes?: number;

  /**
   * A label query over pods that should match the pod count.
   * Normally, the system sets this field for you.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 4;
   */
  selector?: LabelSelector;

  /**
   * manualSelector controls generation of pod labels and pod selectors.
   * Leave `manualSelector` unset unless you are certain what you are doing.
   * When false or unset, the system pick labels unique to this job
   * and appends those labels to the pod template.  When true,
   * the user is responsible for picking unique labels and specifying
   * the selector.  Failure to pick a unique label may cause this
   * and other jobs to not function correctly.  However, You may see
   * `manualSelector=true` in jobs that were created with the old `extensions/v1beta1`
   * API.
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/#specifying-your-own-pod-selector
   * +optional
   *
   * @generated from field: optional bool manualSelector = 5;
   */
  manualSelector?: boolean;

  /**
   * Describes the pod that will be created when executing a job.
   * The only allowed template.spec.restartPolicy values are "Never" or "OnFailure".
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
   *
   * @generated from field: optional k8s.io.api.core.v1.PodTemplateSpec template = 6;
   */
  template?: PodTemplateSpec;

  /**
   * ttlSecondsAfterFinished limits the lifetime of a Job that has finished
   * execution (either Complete or Failed). If this field is set,
   * ttlSecondsAfterFinished after the Job finishes, it is eligible to be
   * automatically deleted. When the Job is being deleted, its lifecycle
   * guarantees (e.g. finalizers) will be honored. If this field is unset,
   * the Job won't be automatically deleted. If this field is set to zero,
   * the Job becomes eligible to be deleted immediately after it finishes.
   * +optional
   *
   * @generated from field: optional int32 ttlSecondsAfterFinished = 8;
   */
  ttlSecondsAfterFinished?: number;

  /**
   * completionMode specifies how Pod completions are tracked. It can be
   * `NonIndexed` (default) or `Indexed`.
   *
   * `NonIndexed` means that the Job is considered complete when there have
   * been .spec.completions successfully completed Pods. Each Pod completion is
   * homologous to each other.
   *
   * `Indexed` means that the Pods of a
   * Job get an associated completion index from 0 to (.spec.completions - 1),
   * available in the annotation batch.kubernetes.io/job-completion-index.
   * The Job is considered complete when there is one successfully completed Pod
   * for each index.
   * When value is `Indexed`, .spec.completions must be specified and
   * `.spec.parallelism` must be less than or equal to 10^5.
   * In addition, The Pod name takes the form
   * `$(job-name)-$(index)-$(random-string)`,
   * the Pod hostname takes the form `$(job-name)-$(index)`.
   *
   * More completion modes can be added in the future.
   * If the Job controller observes a mode that it doesn't recognize, which
   * is possible during upgrades due to version skew, the controller
   * skips updates for the Job.
   * +optional
   *
   * @generated from field: optional string completionMode = 9;
   */
  completionMode?: string;

  /**
   * suspend specifies whether the Job controller should create Pods or not. If
   * a Job is created with suspend set to true, no Pods are created by the Job
   * controller. If a Job is suspended after creation (i.e. the flag goes from
   * false to true), the Job controller will delete all active Pods associated
   * with this Job. Users must design their workload to gracefully handle this.
   * Suspending a Job will reset the StartTime field of the Job, effectively
   * resetting the ActiveDeadlineSeconds timer too. Defaults to false.
   *
   * +optional
   *
   * @generated from field: optional bool suspend = 10;
   */
  suspend?: boolean;

  /**
   * podReplacementPolicy specifies when to create replacement Pods.
   * Possible values are:
   * - TerminatingOrFailed means that we recreate pods
   *   when they are terminating (has a metadata.deletionTimestamp) or failed.
   * - Failed means to wait until a previously created Pod is fully terminated (has phase
   *   Failed or Succeeded) before creating a replacement Pod.
   *
   * When using podFailurePolicy, Failed is the the only allowed value.
   * TerminatingOrFailed and Failed are allowed values when podFailurePolicy is not in use.
   * This is an beta field. To use this, enable the JobPodReplacementPolicy feature toggle.
   * This is on by default.
   * +optional
   *
   * @generated from field: optional string podReplacementPolicy = 14;
   */
  podReplacementPolicy?: string;

  /**
   * ManagedBy field indicates the controller that manages a Job. The k8s Job
   * controller reconciles jobs which don't have this field at all or the field
   * value is the reserved string `kubernetes.io/job-controller`, but skips
   * reconciling Jobs with a custom value for this field.
   * The value must be a valid domain-prefixed path (e.g. acme.io/foo) -
   * all characters before the first "/" must be a valid subdomain as defined
   * by RFC 1123. All characters trailing the first "/" must be valid HTTP Path
   * characters as defined by RFC 3986. The value cannot exceed 63 characters.
   * This field is immutable.
   *
   * This field is alpha-level. The job controller accepts setting the field
   * when the feature gate JobManagedBy is enabled (disabled by default).
   * +optional
   *
   * @generated from field: optional string managedBy = 15;
   */
  managedBy?: string;

  constructor(data?: PartialMessage<JobSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.JobSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "parallelism", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 2, name: "completions", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "activeDeadlineSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 11, name: "podFailurePolicy", kind: "message", T: PodFailurePolicy, opt: true },
    { no: 16, name: "successPolicy", kind: "message", T: SuccessPolicy, opt: true },
    { no: 7, name: "backoffLimit", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 12, name: "backoffLimitPerIndex", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 13, name: "maxFailedIndexes", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 4, name: "selector", kind: "message", T: LabelSelector, opt: true },
    { no: 5, name: "manualSelector", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 6, name: "template", kind: "message", T: PodTemplateSpec, opt: true },
    { no: 8, name: "ttlSecondsAfterFinished", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 9, name: "completionMode", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "suspend", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 14, name: "podReplacementPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 15, name: "managedBy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobSpec {
    return new JobSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobSpec {
    return new JobSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobSpec {
    return new JobSpec().fromJsonString(jsonString, options);
  }

  static equals(a: JobSpec | PlainMessage<JobSpec> | undefined, b: JobSpec | PlainMessage<JobSpec> | undefined): boolean {
    return proto2.util.equals(JobSpec, a, b);
  }
}

/**
 * JobStatus represents the current state of a Job.
 *
 * @generated from message k8s.io.api.batch.v1.JobStatus
 */
export class JobStatus extends Message<JobStatus> {
  /**
   * The latest available observations of an object's current state. When a Job
   * fails, one of the conditions will have type "Failed" and status true. When
   * a Job is suspended, one of the conditions will have type "Suspended" and
   * status true; when the Job is resumed, the status of this condition will
   * become false. When a Job is completed, one of the conditions will have
   * type "Complete" and status true.
   *
   * A job is considered finished when it is in a terminal condition, either
   * "Complete" or "Failed". A Job cannot have both the "Complete" and "Failed" conditions.
   * Additionally, it cannot be in the "Complete" and "FailureTarget" conditions.
   * The "Complete", "Failed" and "FailureTarget" conditions cannot be disabled.
   *
   * More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/
   * +optional
   * +patchMergeKey=type
   * +patchStrategy=merge
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.batch.v1.JobCondition conditions = 1;
   */
  conditions: JobCondition[] = [];

  /**
   * Represents time when the job controller started processing a job. When a
   * Job is created in the suspended state, this field is not set until the
   * first time it is resumed. This field is reset every time a Job is resumed
   * from suspension. It is represented in RFC3339 form and is in UTC.
   *
   * Once set, the field can only be removed when the job is suspended.
   * The field cannot be modified while the job is unsuspended or finished.
   *
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time startTime = 2;
   */
  startTime?: Time;

  /**
   * Represents time when the job was completed. It is not guaranteed to
   * be set in happens-before order across separate operations.
   * It is represented in RFC3339 form and is in UTC.
   * The completion time is set when the job finishes successfully, and only then.
   * The value cannot be updated or removed. The value indicates the same or
   * later point in time as the startTime field.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time completionTime = 3;
   */
  completionTime?: Time;

  /**
   * The number of pending and running pods which are not terminating (without
   * a deletionTimestamp).
   * The value is zero for finished jobs.
   * +optional
   *
   * @generated from field: optional int32 active = 4;
   */
  active?: number;

  /**
   * The number of pods which reached phase Succeeded.
   * The value increases monotonically for a given spec. However, it may
   * decrease in reaction to scale down of elastic indexed jobs.
   * +optional
   *
   * @generated from field: optional int32 succeeded = 5;
   */
  succeeded?: number;

  /**
   * The number of pods which reached phase Failed.
   * The value increases monotonically.
   * +optional
   *
   * @generated from field: optional int32 failed = 6;
   */
  failed?: number;

  /**
   * The number of pods which are terminating (in phase Pending or Running
   * and have a deletionTimestamp).
   *
   * This field is beta-level. The job controller populates the field when
   * the feature gate JobPodReplacementPolicy is enabled (enabled by default).
   * +optional
   *
   * @generated from field: optional int32 terminating = 11;
   */
  terminating?: number;

  /**
   * completedIndexes holds the completed indexes when .spec.completionMode =
   * "Indexed" in a text format. The indexes are represented as decimal integers
   * separated by commas. The numbers are listed in increasing order. Three or
   * more consecutive numbers are compressed and represented by the first and
   * last element of the series, separated by a hyphen.
   * For example, if the completed indexes are 1, 3, 4, 5 and 7, they are
   * represented as "1,3-5,7".
   * +optional
   *
   * @generated from field: optional string completedIndexes = 7;
   */
  completedIndexes?: string;

  /**
   * FailedIndexes holds the failed indexes when spec.backoffLimitPerIndex is set.
   * The indexes are represented in the text format analogous as for the
   * `completedIndexes` field, ie. they are kept as decimal integers
   * separated by commas. The numbers are listed in increasing order. Three or
   * more consecutive numbers are compressed and represented by the first and
   * last element of the series, separated by a hyphen.
   * For example, if the failed indexes are 1, 3, 4, 5 and 7, they are
   * represented as "1,3-5,7".
   * The set of failed indexes cannot overlap with the set of completed indexes.
   *
   * This field is beta-level. It can be used when the `JobBackoffLimitPerIndex`
   * feature gate is enabled (enabled by default).
   * +optional
   *
   * @generated from field: optional string failedIndexes = 10;
   */
  failedIndexes?: string;

  /**
   * uncountedTerminatedPods holds the UIDs of Pods that have terminated but
   * the job controller hasn't yet accounted for in the status counters.
   *
   * The job controller creates pods with a finalizer. When a pod terminates
   * (succeeded or failed), the controller does three steps to account for it
   * in the job status:
   *
   * 1. Add the pod UID to the arrays in this field.
   * 2. Remove the pod finalizer.
   * 3. Remove the pod UID from the arrays while increasing the corresponding
   *     counter.
   *
   * Old jobs might not be tracked using this field, in which case the field
   * remains null.
   * The structure is empty for finished jobs.
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.UncountedTerminatedPods uncountedTerminatedPods = 8;
   */
  uncountedTerminatedPods?: UncountedTerminatedPods;

  /**
   * The number of active pods which have a Ready condition and are not
   * terminating (without a deletionTimestamp).
   *
   * @generated from field: optional int32 ready = 9;
   */
  ready?: number;

  constructor(data?: PartialMessage<JobStatus>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.JobStatus";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "conditions", kind: "message", T: JobCondition, repeated: true },
    { no: 2, name: "startTime", kind: "message", T: Time, opt: true },
    { no: 3, name: "completionTime", kind: "message", T: Time, opt: true },
    { no: 4, name: "active", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 5, name: "succeeded", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 6, name: "failed", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 11, name: "terminating", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 7, name: "completedIndexes", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "failedIndexes", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 8, name: "uncountedTerminatedPods", kind: "message", T: UncountedTerminatedPods, opt: true },
    { no: 9, name: "ready", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobStatus {
    return new JobStatus().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobStatus {
    return new JobStatus().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobStatus {
    return new JobStatus().fromJsonString(jsonString, options);
  }

  static equals(a: JobStatus | PlainMessage<JobStatus> | undefined, b: JobStatus | PlainMessage<JobStatus> | undefined): boolean {
    return proto2.util.equals(JobStatus, a, b);
  }
}

/**
 * JobTemplateSpec describes the data a Job should have when created from a template
 *
 * @generated from message k8s.io.api.batch.v1.JobTemplateSpec
 */
export class JobTemplateSpec extends Message<JobTemplateSpec> {
  /**
   * Standard object's metadata of the jobs created from this template.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  /**
   * Specification of the desired behavior of the job.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.JobSpec spec = 2;
   */
  spec?: JobSpec;

  constructor(data?: PartialMessage<JobTemplateSpec>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.JobTemplateSpec";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
    { no: 2, name: "spec", kind: "message", T: JobSpec, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): JobTemplateSpec {
    return new JobTemplateSpec().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): JobTemplateSpec {
    return new JobTemplateSpec().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): JobTemplateSpec {
    return new JobTemplateSpec().fromJsonString(jsonString, options);
  }

  static equals(a: JobTemplateSpec | PlainMessage<JobTemplateSpec> | undefined, b: JobTemplateSpec | PlainMessage<JobTemplateSpec> | undefined): boolean {
    return proto2.util.equals(JobTemplateSpec, a, b);
  }
}

/**
 * PodFailurePolicy describes how failed pods influence the backoffLimit.
 *
 * @generated from message k8s.io.api.batch.v1.PodFailurePolicy
 */
export class PodFailurePolicy extends Message<PodFailurePolicy> {
  /**
   * A list of pod failure policy rules. The rules are evaluated in order.
   * Once a rule matches a Pod failure, the remaining of the rules are ignored.
   * When no rule matches the Pod failure, the default handling applies - the
   * counter of pod failures is incremented and it is checked against
   * the backoffLimit. At most 20 elements are allowed.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.batch.v1.PodFailurePolicyRule rules = 1;
   */
  rules: PodFailurePolicyRule[] = [];

  constructor(data?: PartialMessage<PodFailurePolicy>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.PodFailurePolicy";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "rules", kind: "message", T: PodFailurePolicyRule, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodFailurePolicy {
    return new PodFailurePolicy().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodFailurePolicy {
    return new PodFailurePolicy().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodFailurePolicy {
    return new PodFailurePolicy().fromJsonString(jsonString, options);
  }

  static equals(a: PodFailurePolicy | PlainMessage<PodFailurePolicy> | undefined, b: PodFailurePolicy | PlainMessage<PodFailurePolicy> | undefined): boolean {
    return proto2.util.equals(PodFailurePolicy, a, b);
  }
}

/**
 * PodFailurePolicyOnExitCodesRequirement describes the requirement for handling
 * a failed pod based on its container exit codes. In particular, it lookups the
 * .state.terminated.exitCode for each app container and init container status,
 * represented by the .status.containerStatuses and .status.initContainerStatuses
 * fields in the Pod status, respectively. Containers completed with success
 * (exit code 0) are excluded from the requirement check.
 *
 * @generated from message k8s.io.api.batch.v1.PodFailurePolicyOnExitCodesRequirement
 */
export class PodFailurePolicyOnExitCodesRequirement extends Message<PodFailurePolicyOnExitCodesRequirement> {
  /**
   * Restricts the check for exit codes to the container with the
   * specified name. When null, the rule applies to all containers.
   * When specified, it should match one the container or initContainer
   * names in the pod template.
   * +optional
   *
   * @generated from field: optional string containerName = 1;
   */
  containerName?: string;

  /**
   * Represents the relationship between the container exit code(s) and the
   * specified values. Containers completed with success (exit code 0) are
   * excluded from the requirement check. Possible values are:
   *
   * - In: the requirement is satisfied if at least one container exit code
   *   (might be multiple if there are multiple containers not restricted
   *   by the 'containerName' field) is in the set of specified values.
   * - NotIn: the requirement is satisfied if at least one container exit code
   *   (might be multiple if there are multiple containers not restricted
   *   by the 'containerName' field) is not in the set of specified values.
   * Additional values are considered to be added in the future. Clients should
   * react to an unknown operator by assuming the requirement is not satisfied.
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * Specifies the set of values. Each returned container exit code (might be
   * multiple in case of multiple containers) is checked against this set of
   * values with respect to the operator. The list of values must be ordered
   * and must not contain duplicates. Value '0' cannot be used for the In operator.
   * At least one element is required. At most 255 elements are allowed.
   * +listType=set
   *
   * @generated from field: repeated int32 values = 3;
   */
  values: number[] = [];

  constructor(data?: PartialMessage<PodFailurePolicyOnExitCodesRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.PodFailurePolicyOnExitCodesRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "containerName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "values", kind: "scalar", T: 5 /* ScalarType.INT32 */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodFailurePolicyOnExitCodesRequirement {
    return new PodFailurePolicyOnExitCodesRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodFailurePolicyOnExitCodesRequirement {
    return new PodFailurePolicyOnExitCodesRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodFailurePolicyOnExitCodesRequirement {
    return new PodFailurePolicyOnExitCodesRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: PodFailurePolicyOnExitCodesRequirement | PlainMessage<PodFailurePolicyOnExitCodesRequirement> | undefined, b: PodFailurePolicyOnExitCodesRequirement | PlainMessage<PodFailurePolicyOnExitCodesRequirement> | undefined): boolean {
    return proto2.util.equals(PodFailurePolicyOnExitCodesRequirement, a, b);
  }
}

/**
 * PodFailurePolicyOnPodConditionsPattern describes a pattern for matching
 * an actual pod condition type.
 *
 * @generated from message k8s.io.api.batch.v1.PodFailurePolicyOnPodConditionsPattern
 */
export class PodFailurePolicyOnPodConditionsPattern extends Message<PodFailurePolicyOnPodConditionsPattern> {
  /**
   * Specifies the required Pod condition type. To match a pod condition
   * it is required that specified type equals the pod condition type.
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Specifies the required Pod condition status. To match a pod condition
   * it is required that the specified status equals the pod condition status.
   * Defaults to True.
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  constructor(data?: PartialMessage<PodFailurePolicyOnPodConditionsPattern>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.PodFailurePolicyOnPodConditionsPattern";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodFailurePolicyOnPodConditionsPattern {
    return new PodFailurePolicyOnPodConditionsPattern().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodFailurePolicyOnPodConditionsPattern {
    return new PodFailurePolicyOnPodConditionsPattern().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodFailurePolicyOnPodConditionsPattern {
    return new PodFailurePolicyOnPodConditionsPattern().fromJsonString(jsonString, options);
  }

  static equals(a: PodFailurePolicyOnPodConditionsPattern | PlainMessage<PodFailurePolicyOnPodConditionsPattern> | undefined, b: PodFailurePolicyOnPodConditionsPattern | PlainMessage<PodFailurePolicyOnPodConditionsPattern> | undefined): boolean {
    return proto2.util.equals(PodFailurePolicyOnPodConditionsPattern, a, b);
  }
}

/**
 * PodFailurePolicyRule describes how a pod failure is handled when the requirements are met.
 * One of onExitCodes and onPodConditions, but not both, can be used in each rule.
 *
 * @generated from message k8s.io.api.batch.v1.PodFailurePolicyRule
 */
export class PodFailurePolicyRule extends Message<PodFailurePolicyRule> {
  /**
   * Specifies the action taken on a pod failure when the requirements are satisfied.
   * Possible values are:
   *
   * - FailJob: indicates that the pod's job is marked as Failed and all
   *   running pods are terminated.
   * - FailIndex: indicates that the pod's index is marked as Failed and will
   *   not be restarted.
   *   This value is beta-level. It can be used when the
   *   `JobBackoffLimitPerIndex` feature gate is enabled (enabled by default).
   * - Ignore: indicates that the counter towards the .backoffLimit is not
   *   incremented and a replacement pod is created.
   * - Count: indicates that the pod is handled in the default way - the
   *   counter towards the .backoffLimit is incremented.
   * Additional values are considered to be added in the future. Clients should
   * react to an unknown action by skipping the rule.
   *
   * @generated from field: optional string action = 1;
   */
  action?: string;

  /**
   * Represents the requirement on the container exit codes.
   * +optional
   *
   * @generated from field: optional k8s.io.api.batch.v1.PodFailurePolicyOnExitCodesRequirement onExitCodes = 2;
   */
  onExitCodes?: PodFailurePolicyOnExitCodesRequirement;

  /**
   * Represents the requirement on the pod conditions. The requirement is represented
   * as a list of pod condition patterns. The requirement is satisfied if at
   * least one pattern matches an actual pod condition. At most 20 elements are allowed.
   * +listType=atomic
   * +optional
   *
   * @generated from field: repeated k8s.io.api.batch.v1.PodFailurePolicyOnPodConditionsPattern onPodConditions = 3;
   */
  onPodConditions: PodFailurePolicyOnPodConditionsPattern[] = [];

  constructor(data?: PartialMessage<PodFailurePolicyRule>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.PodFailurePolicyRule";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "action", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "onExitCodes", kind: "message", T: PodFailurePolicyOnExitCodesRequirement, opt: true },
    { no: 3, name: "onPodConditions", kind: "message", T: PodFailurePolicyOnPodConditionsPattern, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PodFailurePolicyRule {
    return new PodFailurePolicyRule().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PodFailurePolicyRule {
    return new PodFailurePolicyRule().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PodFailurePolicyRule {
    return new PodFailurePolicyRule().fromJsonString(jsonString, options);
  }

  static equals(a: PodFailurePolicyRule | PlainMessage<PodFailurePolicyRule> | undefined, b: PodFailurePolicyRule | PlainMessage<PodFailurePolicyRule> | undefined): boolean {
    return proto2.util.equals(PodFailurePolicyRule, a, b);
  }
}

/**
 * SuccessPolicy describes when a Job can be declared as succeeded based on the success of some indexes.
 *
 * @generated from message k8s.io.api.batch.v1.SuccessPolicy
 */
export class SuccessPolicy extends Message<SuccessPolicy> {
  /**
   * rules represents the list of alternative rules for the declaring the Jobs
   * as successful before `.status.succeeded >= .spec.completions`. Once any of the rules are met,
   * the "SucceededCriteriaMet" condition is added, and the lingering pods are removed.
   * The terminal state for such a Job has the "Complete" condition.
   * Additionally, these rules are evaluated in order; Once the Job meets one of the rules,
   * other rules are ignored. At most 20 elements are allowed.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.api.batch.v1.SuccessPolicyRule rules = 1;
   */
  rules: SuccessPolicyRule[] = [];

  constructor(data?: PartialMessage<SuccessPolicy>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.SuccessPolicy";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "rules", kind: "message", T: SuccessPolicyRule, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SuccessPolicy {
    return new SuccessPolicy().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SuccessPolicy {
    return new SuccessPolicy().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SuccessPolicy {
    return new SuccessPolicy().fromJsonString(jsonString, options);
  }

  static equals(a: SuccessPolicy | PlainMessage<SuccessPolicy> | undefined, b: SuccessPolicy | PlainMessage<SuccessPolicy> | undefined): boolean {
    return proto2.util.equals(SuccessPolicy, a, b);
  }
}

/**
 * SuccessPolicyRule describes rule for declaring a Job as succeeded.
 * Each rule must have at least one of the "succeededIndexes" or "succeededCount" specified.
 *
 * @generated from message k8s.io.api.batch.v1.SuccessPolicyRule
 */
export class SuccessPolicyRule extends Message<SuccessPolicyRule> {
  /**
   * succeededIndexes specifies the set of indexes
   * which need to be contained in the actual set of the succeeded indexes for the Job.
   * The list of indexes must be within 0 to ".spec.completions-1" and
   * must not contain duplicates. At least one element is required.
   * The indexes are represented as intervals separated by commas.
   * The intervals can be a decimal integer or a pair of decimal integers separated by a hyphen.
   * The number are listed in represented by the first and last element of the series,
   * separated by a hyphen.
   * For example, if the completed indexes are 1, 3, 4, 5 and 7, they are
   * represented as "1,3-5,7".
   * When this field is null, this field doesn't default to any value
   * and is never evaluated at any time.
   *
   * +optional
   *
   * @generated from field: optional string succeededIndexes = 1;
   */
  succeededIndexes?: string;

  /**
   * succeededCount specifies the minimal required size of the actual set of the succeeded indexes
   * for the Job. When succeededCount is used along with succeededIndexes, the check is
   * constrained only to the set of indexes specified by succeededIndexes.
   * For example, given that succeededIndexes is "1-4", succeededCount is "3",
   * and completed indexes are "1", "3", and "5", the Job isn't declared as succeeded
   * because only "1" and "3" indexes are considered in that rules.
   * When this field is null, this doesn't default to any value and
   * is never evaluated at any time.
   * When specified it needs to be a positive integer.
   *
   * +optional
   *
   * @generated from field: optional int32 succeededCount = 2;
   */
  succeededCount?: number;

  constructor(data?: PartialMessage<SuccessPolicyRule>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.SuccessPolicyRule";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "succeededIndexes", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "succeededCount", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): SuccessPolicyRule {
    return new SuccessPolicyRule().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): SuccessPolicyRule {
    return new SuccessPolicyRule().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): SuccessPolicyRule {
    return new SuccessPolicyRule().fromJsonString(jsonString, options);
  }

  static equals(a: SuccessPolicyRule | PlainMessage<SuccessPolicyRule> | undefined, b: SuccessPolicyRule | PlainMessage<SuccessPolicyRule> | undefined): boolean {
    return proto2.util.equals(SuccessPolicyRule, a, b);
  }
}

/**
 * UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't
 * been accounted in Job status counters.
 *
 * @generated from message k8s.io.api.batch.v1.UncountedTerminatedPods
 */
export class UncountedTerminatedPods extends Message<UncountedTerminatedPods> {
  /**
   * succeeded holds UIDs of succeeded Pods.
   * +listType=set
   * +optional
   *
   * @generated from field: repeated string succeeded = 1;
   */
  succeeded: string[] = [];

  /**
   * failed holds UIDs of failed Pods.
   * +listType=set
   * +optional
   *
   * @generated from field: repeated string failed = 2;
   */
  failed: string[] = [];

  constructor(data?: PartialMessage<UncountedTerminatedPods>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.api.batch.v1.UncountedTerminatedPods";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "succeeded", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "failed", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UncountedTerminatedPods {
    return new UncountedTerminatedPods().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UncountedTerminatedPods {
    return new UncountedTerminatedPods().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UncountedTerminatedPods {
    return new UncountedTerminatedPods().fromJsonString(jsonString, options);
  }

  static equals(a: UncountedTerminatedPods | PlainMessage<UncountedTerminatedPods> | undefined, b: UncountedTerminatedPods | PlainMessage<UncountedTerminatedPods> | undefined): boolean {
    return proto2.util.equals(UncountedTerminatedPods, a, b);
  }
}

