//
//Copyright The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file was autogenerated by go-to-protobuf. Do not edit it manually!

// @generated by protoc-gen-es v1.8.0 with parameter "target=ts"
// @generated from file k8s.io/apimachinery/pkg/util/intstr/generated.proto (package k8s.io.apimachinery.pkg.util.intstr, syntax proto2)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto2 } from "@bufbuild/protobuf";

/**
 * IntOrString is a type that can hold an int32 or a string.  When used in
 * JSON or YAML marshalling and unmarshalling, it produces or consumes the
 * inner type.  This allows you to have, for example, a JSON field that can
 * accept a name or number.
 * TODO: Rename to Int32OrString
 *
 * +protobuf=true
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 * +k8s:openapi-gen=true
 *
 * @generated from message k8s.io.apimachinery.pkg.util.intstr.IntOrString
 */
export class IntOrString extends Message<IntOrString> {
  /**
   * @generated from field: optional int64 type = 1;
   */
  type?: bigint;

  /**
   * @generated from field: optional int32 intVal = 2;
   */
  intVal?: number;

  /**
   * @generated from field: optional string strVal = 3;
   */
  strVal?: string;

  constructor(data?: PartialMessage<IntOrString>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.util.intstr.IntOrString";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "intVal", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
    { no: 3, name: "strVal", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): IntOrString {
    return new IntOrString().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): IntOrString {
    return new IntOrString().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): IntOrString {
    return new IntOrString().fromJsonString(jsonString, options);
  }

  static equals(a: IntOrString | PlainMessage<IntOrString> | undefined, b: IntOrString | PlainMessage<IntOrString> | undefined): boolean {
    return proto2.util.equals(IntOrString, a, b);
  }

  static readonly TYPE_INT = BigInt(0);
  static readonly TYPE_STRING = BigInt(1);
  static readonly MAX_INT32 = 2147483647;
  static readonly MIN_INT32 = -2147483648;

  override fromJson(json: JsonValue, options?: Partial<JsonReadOptions>): this {
    if (json === null) {
      return this;
    }
    switch (typeof json) {
      case "string":
        this.type = IntOrString.TYPE_STRING;
        this.strVal = json;
        return this;
      case "number":
        if (!this.isInt32(json)) {
          throw new Error(`value is not an Int32: ${proto.json.debug(json)}`);
        }
        this.type = IntOrString.TYPE_INT;
        this.intVal = json;
        return this;
      default:
        throw new Error(`cannot decode ${IntOrString.typeName} from JSON: ${proto.json.debug(json)}`);
    }
  }

  override toJson(options?: Partial<JsonWriteOptions>): JsonValue {
    if (this.type === IntOrString.TYPE_STRING) {
      return this.strVal;
    }
    if (this.type === IntOrString.TYPE_INT) {
      if (!this.intVal) {
        return null;
      } else if (!this.isInt32(this.intVal)) {
        throw new Error(`value is not an Int32: ${this.intVal}`);
      }
      return this.intVal;
    }
    return null;
  }

  isInt32(value: number): boolean {
    return Number.isInteger(value) &&
      IntOrString.MIN_INT32 <= value &&
      value <= IntOrString.MAX_INT32;
  }
}

