//
//Copyright The Kubernetes Authors.
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// This file was autogenerated by go-to-protobuf. Do not edit it manually!

// @generated by protoc-gen-es v1.8.0 with parameter "target=ts"
// @generated from file k8s.io/apimachinery/pkg/apis/meta/v1/generated.proto (package k8s.io.apimachinery.pkg.apis.meta.v1, syntax proto2)
/* eslint-disable */
// @ts-nocheck

import type { BinaryReadOptions, FieldList, JsonReadOptions, JsonValue, PartialMessage, PlainMessage } from "@bufbuild/protobuf";
import { Message, proto2, protoInt64 } from "@bufbuild/protobuf";
import { RawExtension } from "../../../runtime/generated_pb.js";

/**
 * APIGroup contains the name, the supported versions, and the preferred version
 * of a group.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.APIGroup
 */
export class APIGroup extends Message<APIGroup> {
  /**
   * name is the name of the group.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * versions are the versions supported in this group.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery versions = 2;
   */
  versions: GroupVersionForDiscovery[] = [];

  /**
   * preferredVersion is the version preferred by the API server, which
   * probably is the storage version.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery preferredVersion = 3;
   */
  preferredVersion?: GroupVersionForDiscovery;

  /**
   * a map of client CIDR to server address that is serving this group.
   * This is to help clients reach servers in the most network-efficient way possible.
   * Clients can use the appropriate server address as per the CIDR that they match.
   * In case of multiple matches, clients should use the longest matching CIDR.
   * The server returns only those CIDRs that it thinks that the client can match.
   * For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP.
   * Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR serverAddressByClientCIDRs = 4;
   */
  serverAddressByClientCIDRs: ServerAddressByClientCIDR[] = [];

  constructor(data?: PartialMessage<APIGroup>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.APIGroup";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "versions", kind: "message", T: GroupVersionForDiscovery, repeated: true },
    { no: 3, name: "preferredVersion", kind: "message", T: GroupVersionForDiscovery, opt: true },
    { no: 4, name: "serverAddressByClientCIDRs", kind: "message", T: ServerAddressByClientCIDR, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): APIGroup {
    return new APIGroup().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): APIGroup {
    return new APIGroup().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): APIGroup {
    return new APIGroup().fromJsonString(jsonString, options);
  }

  static equals(a: APIGroup | PlainMessage<APIGroup> | undefined, b: APIGroup | PlainMessage<APIGroup> | undefined): boolean {
    return proto2.util.equals(APIGroup, a, b);
  }
}

/**
 * APIGroupList is a list of APIGroup, to allow clients to discover the API at
 * /apis.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.APIGroupList
 */
export class APIGroupList extends Message<APIGroupList> {
  /**
   * groups is a list of APIGroup.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.APIGroup groups = 1;
   */
  groups: APIGroup[] = [];

  constructor(data?: PartialMessage<APIGroupList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.APIGroupList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "groups", kind: "message", T: APIGroup, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): APIGroupList {
    return new APIGroupList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): APIGroupList {
    return new APIGroupList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): APIGroupList {
    return new APIGroupList().fromJsonString(jsonString, options);
  }

  static equals(a: APIGroupList | PlainMessage<APIGroupList> | undefined, b: APIGroupList | PlainMessage<APIGroupList> | undefined): boolean {
    return proto2.util.equals(APIGroupList, a, b);
  }
}

/**
 * APIResource specifies the name of a resource and whether it is namespaced.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.APIResource
 */
export class APIResource extends Message<APIResource> {
  /**
   * name is the plural name of the resource.
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * singularName is the singular name of the resource.  This allows clients to handle plural and singular opaquely.
   * The singularName is more correct for reporting status on a single item and both singular and plural are allowed
   * from the kubectl CLI interface.
   *
   * @generated from field: optional string singularName = 6;
   */
  singularName?: string;

  /**
   * namespaced indicates if a resource is namespaced or not.
   *
   * @generated from field: optional bool namespaced = 2;
   */
  namespaced?: boolean;

  /**
   * group is the preferred group of the resource.  Empty implies the group of the containing resource list.
   * For subresources, this may have a different value, for example: Scale".
   *
   * @generated from field: optional string group = 8;
   */
  group?: string;

  /**
   * version is the preferred version of the resource.  Empty implies the version of the containing resource list
   * For subresources, this may have a different value, for example: v1 (while inside a v1beta1 version of the core resource's group)".
   *
   * @generated from field: optional string version = 9;
   */
  version?: string;

  /**
   * kind is the kind for the resource (e.g. 'Foo' is the kind for a resource 'foo')
   *
   * @generated from field: optional string kind = 3;
   */
  kind?: string;

  /**
   * verbs is a list of supported kube verbs (this includes get, list, watch, create,
   * update, patch, delete, deletecollection, and proxy)
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Verbs verbs = 4;
   */
  verbs?: Verbs;

  /**
   * shortNames is a list of suggested short names of the resource.
   * +listType=atomic
   *
   * @generated from field: repeated string shortNames = 5;
   */
  shortNames: string[] = [];

  /**
   * categories is a list of the grouped resources this resource belongs to (e.g. 'all')
   * +listType=atomic
   *
   * @generated from field: repeated string categories = 7;
   */
  categories: string[] = [];

  /**
   * The hash value of the storage version, the version this resource is
   * converted to when written to the data store. Value must be treated
   * as opaque by clients. Only equality comparison on the value is valid.
   * This is an alpha feature and may change or be removed in the future.
   * The field is populated by the apiserver only if the
   * StorageVersionHash feature gate is enabled.
   * This field will remain optional even if it graduates.
   * +optional
   *
   * @generated from field: optional string storageVersionHash = 10;
   */
  storageVersionHash?: string;

  constructor(data?: PartialMessage<APIResource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.APIResource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "singularName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "namespaced", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 8, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 9, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "verbs", kind: "message", T: Verbs, opt: true },
    { no: 5, name: "shortNames", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 7, name: "categories", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 10, name: "storageVersionHash", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): APIResource {
    return new APIResource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): APIResource {
    return new APIResource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): APIResource {
    return new APIResource().fromJsonString(jsonString, options);
  }

  static equals(a: APIResource | PlainMessage<APIResource> | undefined, b: APIResource | PlainMessage<APIResource> | undefined): boolean {
    return proto2.util.equals(APIResource, a, b);
  }
}

/**
 * APIResourceList is a list of APIResource, it is used to expose the name of the
 * resources supported in a specific group and version, and if the resource
 * is namespaced.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.APIResourceList
 */
export class APIResourceList extends Message<APIResourceList> {
  /**
   * groupVersion is the group and version this APIResourceList is for.
   *
   * @generated from field: optional string groupVersion = 1;
   */
  groupVersion?: string;

  /**
   * resources contains the name of the resources and if they are namespaced.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.APIResource resources = 2;
   */
  resources: APIResource[] = [];

  constructor(data?: PartialMessage<APIResourceList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.APIResourceList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "groupVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resources", kind: "message", T: APIResource, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): APIResourceList {
    return new APIResourceList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): APIResourceList {
    return new APIResourceList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): APIResourceList {
    return new APIResourceList().fromJsonString(jsonString, options);
  }

  static equals(a: APIResourceList | PlainMessage<APIResourceList> | undefined, b: APIResourceList | PlainMessage<APIResourceList> | undefined): boolean {
    return proto2.util.equals(APIResourceList, a, b);
  }
}

/**
 * APIVersions lists the versions that are available, to allow clients to
 * discover the API at /api, which is the root path of the legacy v1 API.
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.APIVersions
 */
export class APIVersions extends Message<APIVersions> {
  /**
   * versions are the api versions that are available.
   * +listType=atomic
   *
   * @generated from field: repeated string versions = 1;
   */
  versions: string[] = [];

  /**
   * a map of client CIDR to server address that is serving this group.
   * This is to help clients reach servers in the most network-efficient way possible.
   * Clients can use the appropriate server address as per the CIDR that they match.
   * In case of multiple matches, clients should use the longest matching CIDR.
   * The server returns only those CIDRs that it thinks that the client can match.
   * For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP.
   * Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR serverAddressByClientCIDRs = 2;
   */
  serverAddressByClientCIDRs: ServerAddressByClientCIDR[] = [];

  constructor(data?: PartialMessage<APIVersions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.APIVersions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "versions", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "serverAddressByClientCIDRs", kind: "message", T: ServerAddressByClientCIDR, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): APIVersions {
    return new APIVersions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): APIVersions {
    return new APIVersions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): APIVersions {
    return new APIVersions().fromJsonString(jsonString, options);
  }

  static equals(a: APIVersions | PlainMessage<APIVersions> | undefined, b: APIVersions | PlainMessage<APIVersions> | undefined): boolean {
    return proto2.util.equals(APIVersions, a, b);
  }
}

/**
 * ApplyOptions may be provided when applying an API object.
 * FieldManager is required for apply requests.
 * ApplyOptions is equivalent to PatchOptions. It is provided as a convenience with documentation
 * that speaks specifically to how the options fields relate to apply.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ApplyOptions
 */
export class ApplyOptions extends Message<ApplyOptions> {
  /**
   * When present, indicates that modifications should not be
   * persisted. An invalid or unrecognized dryRun directive will
   * result in an error response and no further processing of the
   * request. Valid values are:
   * - All: all dry run stages will be processed
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string dryRun = 1;
   */
  dryRun: string[] = [];

  /**
   * Force is going to "force" Apply requests. It means user will
   * re-acquire conflicting fields owned by other people.
   *
   * @generated from field: optional bool force = 2;
   */
  force?: boolean;

  /**
   * fieldManager is a name associated with the actor or entity
   * that is making these changes. The value must be less than or
   * 128 characters long, and only contain printable characters,
   * as defined by https://golang.org/pkg/unicode/#IsPrint. This
   * field is required.
   *
   * @generated from field: optional string fieldManager = 3;
   */
  fieldManager?: string;

  constructor(data?: PartialMessage<ApplyOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ApplyOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "dryRun", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "force", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "fieldManager", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ApplyOptions {
    return new ApplyOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ApplyOptions {
    return new ApplyOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ApplyOptions {
    return new ApplyOptions().fromJsonString(jsonString, options);
  }

  static equals(a: ApplyOptions | PlainMessage<ApplyOptions> | undefined, b: ApplyOptions | PlainMessage<ApplyOptions> | undefined): boolean {
    return proto2.util.equals(ApplyOptions, a, b);
  }
}

/**
 * Condition contains details for one aspect of the current state of this API Resource.
 * ---
 * This struct is intended for direct use as an array at the field path .status.conditions.  For example,
 *
 * 	type FooStatus struct{
 * 	    // Represents the observations of a foo's current state.
 * 	    // Known .status.conditions.type are: "Available", "Progressing", and "Degraded"
 * 	    // +patchMergeKey=type
 * 	    // +patchStrategy=merge
 * 	    // +listType=map
 * 	    // +listMapKey=type
 * 	    Conditions []metav1.Condition `json:"conditions,omitempty" patchStrategy:"merge" patchMergeKey:"type" protobuf:"bytes,1,rep,name=conditions"`
 *
 * 	    // other fields
 * 	}
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Condition
 */
export class Condition extends Message<Condition> {
  /**
   * type of condition in CamelCase or in foo.example.com/CamelCase.
   * ---
   * Many .condition.type values are consistent across resources like Available, but because arbitrary conditions can be
   * useful (see .node.status.conditions), the ability to deconflict is important.
   * The regex it matches is (dns1123SubdomainFmt/)?(qualifiedNameFmt)
   * +required
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:Pattern=`^([a-z0-9]([-a-z0-9]*[a-z0-9])?(\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*\/)?(([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9])$`
   * +kubebuilder:validation:MaxLength=316
   *
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * status of the condition, one of True, False, Unknown.
   * +required
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:Enum=True;False;Unknown
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * observedGeneration represents the .metadata.generation that the condition was set based upon.
   * For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date
   * with respect to the current state of the instance.
   * +optional
   * +kubebuilder:validation:Minimum=0
   *
   * @generated from field: optional int64 observedGeneration = 3;
   */
  observedGeneration?: bigint;

  /**
   * lastTransitionTime is the last time the condition transitioned from one status to another.
   * This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.
   * +required
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:Type=string
   * +kubebuilder:validation:Format=date-time
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 4;
   */
  lastTransitionTime?: Time;

  /**
   * reason contains a programmatic identifier indicating the reason for the condition's last transition.
   * Producers of specific condition types may define expected values and meanings for this field,
   * and whether the values are considered a guaranteed API.
   * The value should be a CamelCase string.
   * This field may not be empty.
   * +required
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:MaxLength=1024
   * +kubebuilder:validation:MinLength=1
   * +kubebuilder:validation:Pattern=`^[A-Za-z]([A-Za-z0-9_,:]*[A-Za-z0-9_])?$`
   *
   * @generated from field: optional string reason = 5;
   */
  reason?: string;

  /**
   * message is a human readable message indicating details about the transition.
   * This may be an empty string.
   * +required
   * +kubebuilder:validation:Required
   * +kubebuilder:validation:MaxLength=32768
   *
   * @generated from field: optional string message = 6;
   */
  message?: string;

  constructor(data?: PartialMessage<Condition>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Condition";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "observedGeneration", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 4, name: "lastTransitionTime", kind: "message", T: Time, opt: true },
    { no: 5, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Condition {
    return new Condition().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Condition {
    return new Condition().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Condition {
    return new Condition().fromJsonString(jsonString, options);
  }

  static equals(a: Condition | PlainMessage<Condition> | undefined, b: Condition | PlainMessage<Condition> | undefined): boolean {
    return proto2.util.equals(Condition, a, b);
  }
}

/**
 * CreateOptions may be provided when creating an API object.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.CreateOptions
 */
export class CreateOptions extends Message<CreateOptions> {
  /**
   * When present, indicates that modifications should not be
   * persisted. An invalid or unrecognized dryRun directive will
   * result in an error response and no further processing of the
   * request. Valid values are:
   * - All: all dry run stages will be processed
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string dryRun = 1;
   */
  dryRun: string[] = [];

  /**
   * fieldManager is a name associated with the actor or entity
   * that is making these changes. The value must be less than or
   * 128 characters long, and only contain printable characters,
   * as defined by https://golang.org/pkg/unicode/#IsPrint.
   * +optional
   *
   * @generated from field: optional string fieldManager = 3;
   */
  fieldManager?: string;

  /**
   * fieldValidation instructs the server on how to handle
   * objects in the request (POST/PUT/PATCH) containing unknown
   * or duplicate fields. Valid values are:
   * - Ignore: This will ignore any unknown fields that are silently
   * dropped from the object, and will ignore all but the last duplicate
   * field that the decoder encounters. This is the default behavior
   * prior to v1.23.
   * - Warn: This will send a warning via the standard warning response
   * header for each unknown field that is dropped from the object, and
   * for each duplicate field that is encountered. The request will
   * still succeed if there are no other errors, and will only persist
   * the last of any duplicate fields. This is the default in v1.23+
   * - Strict: This will fail the request with a BadRequest error if
   * any unknown fields would be dropped from the object, or if any
   * duplicate fields are present. The error returned from the server
   * will contain all unknown and duplicate fields encountered.
   * +optional
   *
   * @generated from field: optional string fieldValidation = 4;
   */
  fieldValidation?: string;

  constructor(data?: PartialMessage<CreateOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.CreateOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "dryRun", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 3, name: "fieldManager", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "fieldValidation", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): CreateOptions {
    return new CreateOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): CreateOptions {
    return new CreateOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): CreateOptions {
    return new CreateOptions().fromJsonString(jsonString, options);
  }

  static equals(a: CreateOptions | PlainMessage<CreateOptions> | undefined, b: CreateOptions | PlainMessage<CreateOptions> | undefined): boolean {
    return proto2.util.equals(CreateOptions, a, b);
  }
}

/**
 * DeleteOptions may be provided when deleting an API object.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.DeleteOptions
 */
export class DeleteOptions extends Message<DeleteOptions> {
  /**
   * The duration in seconds before the object should be deleted. Value must be non-negative integer.
   * The value zero indicates delete immediately. If this value is nil, the default grace period for the
   * specified type will be used.
   * Defaults to a per object value if not specified. zero means delete immediately.
   * +optional
   *
   * @generated from field: optional int64 gracePeriodSeconds = 1;
   */
  gracePeriodSeconds?: bigint;

  /**
   * Must be fulfilled before a deletion is carried out. If not possible, a 409 Conflict status will be
   * returned.
   * +k8s:conversion-gen=false
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Preconditions preconditions = 2;
   */
  preconditions?: Preconditions;

  /**
   * Deprecated: please use the PropagationPolicy, this field will be deprecated in 1.7.
   * Should the dependent objects be orphaned. If true/false, the "orphan"
   * finalizer will be added to/removed from the object's finalizers list.
   * Either this field or PropagationPolicy may be set, but not both.
   * +optional
   *
   * @generated from field: optional bool orphanDependents = 3;
   */
  orphanDependents?: boolean;

  /**
   * Whether and how garbage collection will be performed.
   * Either this field or OrphanDependents may be set, but not both.
   * The default policy is decided by the existing finalizer set in the
   * metadata.finalizers and the resource-specific default policy.
   * Acceptable values are: 'Orphan' - orphan the dependents; 'Background' -
   * allow the garbage collector to delete the dependents in the background;
   * 'Foreground' - a cascading policy that deletes all dependents in the
   * foreground.
   * +optional
   *
   * @generated from field: optional string propagationPolicy = 4;
   */
  propagationPolicy?: string;

  /**
   * When present, indicates that modifications should not be
   * persisted. An invalid or unrecognized dryRun directive will
   * result in an error response and no further processing of the
   * request. Valid values are:
   * - All: all dry run stages will be processed
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string dryRun = 5;
   */
  dryRun: string[] = [];

  constructor(data?: PartialMessage<DeleteOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.DeleteOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "gracePeriodSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "preconditions", kind: "message", T: Preconditions, opt: true },
    { no: 3, name: "orphanDependents", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "propagationPolicy", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "dryRun", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): DeleteOptions {
    return new DeleteOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): DeleteOptions {
    return new DeleteOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): DeleteOptions {
    return new DeleteOptions().fromJsonString(jsonString, options);
  }

  static equals(a: DeleteOptions | PlainMessage<DeleteOptions> | undefined, b: DeleteOptions | PlainMessage<DeleteOptions> | undefined): boolean {
    return proto2.util.equals(DeleteOptions, a, b);
  }
}

/**
 * Duration is a wrapper around time.Duration which supports correct
 * marshaling to YAML and JSON. In particular, it marshals into strings, which
 * can be used as map keys in json.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Duration
 */
export class Duration extends Message<Duration> {
  /**
   * @generated from field: optional int64 duration = 1;
   */
  duration?: bigint;

  constructor(data?: PartialMessage<Duration>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Duration";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "duration", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Duration {
    return new Duration().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Duration {
    return new Duration().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Duration {
    return new Duration().fromJsonString(jsonString, options);
  }

  static equals(a: Duration | PlainMessage<Duration> | undefined, b: Duration | PlainMessage<Duration> | undefined): boolean {
    return proto2.util.equals(Duration, a, b);
  }
}

/**
 * FieldSelectorRequirement is a selector that contains values, a key, and an operator that
 * relates the key and values.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.FieldSelectorRequirement
 */
export class FieldSelectorRequirement extends Message<FieldSelectorRequirement> {
  /**
   * key is the field selector key that the requirement applies to.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * operator represents a key's relationship to a set of values.
   * Valid operators are In, NotIn, Exists, DoesNotExist.
   * The list of operators may grow in the future.
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * values is an array of string values.
   * If the operator is In or NotIn, the values array must be non-empty.
   * If the operator is Exists or DoesNotExist, the values array must be empty.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string values = 3;
   */
  values: string[] = [];

  constructor(data?: PartialMessage<FieldSelectorRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.FieldSelectorRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "values", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FieldSelectorRequirement {
    return new FieldSelectorRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FieldSelectorRequirement {
    return new FieldSelectorRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FieldSelectorRequirement {
    return new FieldSelectorRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: FieldSelectorRequirement | PlainMessage<FieldSelectorRequirement> | undefined, b: FieldSelectorRequirement | PlainMessage<FieldSelectorRequirement> | undefined): boolean {
    return proto2.util.equals(FieldSelectorRequirement, a, b);
  }
}

/**
 * FieldsV1 stores a set of fields in a data structure like a Trie, in JSON format.
 *
 * Each key is either a '.' representing the field itself, and will always map to an empty set,
 * or a string representing a sub-field or item. The string will follow one of these four formats:
 * 'f:<name>', where <name> is the name of a field in a struct, or key in a map
 * 'v:<value>', where <value> is the exact json formatted value of a list item
 * 'i:<index>', where <index> is position of a item in a list
 * 'k:<keys>', where <keys> is a map of  a list item's key fields to their unique values
 * If a key maps to an empty Fields value, the field that key represents is part of the set.
 *
 * The exact format is defined in sigs.k8s.io/structured-merge-diff
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.FieldsV1
 */
export class FieldsV1 extends Message<FieldsV1> {
  /**
   * Raw is the underlying serialization of this object.
   *
   * @generated from field: optional bytes Raw = 1;
   */
  Raw?: Uint8Array;

  constructor(data?: PartialMessage<FieldsV1>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.FieldsV1";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "Raw", kind: "scalar", T: 12 /* ScalarType.BYTES */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): FieldsV1 {
    return new FieldsV1().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): FieldsV1 {
    return new FieldsV1().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): FieldsV1 {
    return new FieldsV1().fromJsonString(jsonString, options);
  }

  static equals(a: FieldsV1 | PlainMessage<FieldsV1> | undefined, b: FieldsV1 | PlainMessage<FieldsV1> | undefined): boolean {
    return proto2.util.equals(FieldsV1, a, b);
  }
}

/**
 * GetOptions is the standard query options to the standard REST get call.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GetOptions
 */
export class GetOptions extends Message<GetOptions> {
  /**
   * resourceVersion sets a constraint on what resource versions a request may be served from.
   * See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
   * details.
   *
   * Defaults to unset
   * +optional
   *
   * @generated from field: optional string resourceVersion = 1;
   */
  resourceVersion?: string;

  constructor(data?: PartialMessage<GetOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GetOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GetOptions {
    return new GetOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GetOptions {
    return new GetOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GetOptions {
    return new GetOptions().fromJsonString(jsonString, options);
  }

  static equals(a: GetOptions | PlainMessage<GetOptions> | undefined, b: GetOptions | PlainMessage<GetOptions> | undefined): boolean {
    return proto2.util.equals(GetOptions, a, b);
  }
}

/**
 * GroupKind specifies a Group and a Kind, but does not force a version.  This is useful for identifying
 * concepts during lookup stages without having partially valid types
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupKind
 */
export class GroupKind extends Message<GroupKind> {
  /**
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * @generated from field: optional string kind = 2;
   */
  kind?: string;

  constructor(data?: PartialMessage<GroupKind>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupKind";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupKind {
    return new GroupKind().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupKind {
    return new GroupKind().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupKind {
    return new GroupKind().fromJsonString(jsonString, options);
  }

  static equals(a: GroupKind | PlainMessage<GroupKind> | undefined, b: GroupKind | PlainMessage<GroupKind> | undefined): boolean {
    return proto2.util.equals(GroupKind, a, b);
  }
}

/**
 * GroupResource specifies a Group and a Resource, but does not force a version.  This is useful for identifying
 * concepts during lookup stages without having partially valid types
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupResource
 */
export class GroupResource extends Message<GroupResource> {
  /**
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * @generated from field: optional string resource = 2;
   */
  resource?: string;

  constructor(data?: PartialMessage<GroupResource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupResource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resource", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupResource {
    return new GroupResource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupResource {
    return new GroupResource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupResource {
    return new GroupResource().fromJsonString(jsonString, options);
  }

  static equals(a: GroupResource | PlainMessage<GroupResource> | undefined, b: GroupResource | PlainMessage<GroupResource> | undefined): boolean {
    return proto2.util.equals(GroupResource, a, b);
  }
}

/**
 * GroupVersion contains the "group" and the "version", which uniquely identifies the API.
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersion
 */
export class GroupVersion extends Message<GroupVersion> {
  /**
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * @generated from field: optional string version = 2;
   */
  version?: string;

  constructor(data?: PartialMessage<GroupVersion>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersion";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupVersion {
    return new GroupVersion().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupVersion {
    return new GroupVersion().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupVersion {
    return new GroupVersion().fromJsonString(jsonString, options);
  }

  static equals(a: GroupVersion | PlainMessage<GroupVersion> | undefined, b: GroupVersion | PlainMessage<GroupVersion> | undefined): boolean {
    return proto2.util.equals(GroupVersion, a, b);
  }
}

/**
 * GroupVersion contains the "group/version" and "version" string of a version.
 * It is made a struct to keep extensibility.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery
 */
export class GroupVersionForDiscovery extends Message<GroupVersionForDiscovery> {
  /**
   * groupVersion specifies the API group and version in the form "group/version"
   *
   * @generated from field: optional string groupVersion = 1;
   */
  groupVersion?: string;

  /**
   * version specifies the version in the form of "version". This is to save
   * the clients the trouble of splitting the GroupVersion.
   *
   * @generated from field: optional string version = 2;
   */
  version?: string;

  constructor(data?: PartialMessage<GroupVersionForDiscovery>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionForDiscovery";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "groupVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupVersionForDiscovery {
    return new GroupVersionForDiscovery().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupVersionForDiscovery {
    return new GroupVersionForDiscovery().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupVersionForDiscovery {
    return new GroupVersionForDiscovery().fromJsonString(jsonString, options);
  }

  static equals(a: GroupVersionForDiscovery | PlainMessage<GroupVersionForDiscovery> | undefined, b: GroupVersionForDiscovery | PlainMessage<GroupVersionForDiscovery> | undefined): boolean {
    return proto2.util.equals(GroupVersionForDiscovery, a, b);
  }
}

/**
 * GroupVersionKind unambiguously identifies a kind.  It doesn't anonymously include GroupVersion
 * to avoid automatic coercion.  It doesn't use a GroupVersion to avoid custom marshalling
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionKind
 */
export class GroupVersionKind extends Message<GroupVersionKind> {
  /**
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * @generated from field: optional string version = 2;
   */
  version?: string;

  /**
   * @generated from field: optional string kind = 3;
   */
  kind?: string;

  constructor(data?: PartialMessage<GroupVersionKind>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionKind";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupVersionKind {
    return new GroupVersionKind().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupVersionKind {
    return new GroupVersionKind().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupVersionKind {
    return new GroupVersionKind().fromJsonString(jsonString, options);
  }

  static equals(a: GroupVersionKind | PlainMessage<GroupVersionKind> | undefined, b: GroupVersionKind | PlainMessage<GroupVersionKind> | undefined): boolean {
    return proto2.util.equals(GroupVersionKind, a, b);
  }
}

/**
 * GroupVersionResource unambiguously identifies a resource.  It doesn't anonymously include GroupVersion
 * to avoid automatic coercion.  It doesn't use a GroupVersion to avoid custom marshalling
 *
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionResource
 */
export class GroupVersionResource extends Message<GroupVersionResource> {
  /**
   * @generated from field: optional string group = 1;
   */
  group?: string;

  /**
   * @generated from field: optional string version = 2;
   */
  version?: string;

  /**
   * @generated from field: optional string resource = 3;
   */
  resource?: string;

  constructor(data?: PartialMessage<GroupVersionResource>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.GroupVersionResource";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "version", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "resource", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): GroupVersionResource {
    return new GroupVersionResource().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): GroupVersionResource {
    return new GroupVersionResource().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): GroupVersionResource {
    return new GroupVersionResource().fromJsonString(jsonString, options);
  }

  static equals(a: GroupVersionResource | PlainMessage<GroupVersionResource> | undefined, b: GroupVersionResource | PlainMessage<GroupVersionResource> | undefined): boolean {
    return proto2.util.equals(GroupVersionResource, a, b);
  }
}

/**
 * A label selector is a label query over a set of resources. The result of matchLabels and
 * matchExpressions are ANDed. An empty label selector matches all objects. A null
 * label selector matches no objects.
 * +structType=atomic
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector
 */
export class LabelSelector extends Message<LabelSelector> {
  /**
   * matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels
   * map is equivalent to an element of matchExpressions, whose key field is "key", the
   * operator is "In", and the values array contains only "value". The requirements are ANDed.
   * +optional
   *
   * @generated from field: map<string, string> matchLabels = 1;
   */
  matchLabels: { [key: string]: string } = {};

  /**
   * matchExpressions is a list of label selector requirements. The requirements are ANDed.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement matchExpressions = 2;
   */
  matchExpressions: LabelSelectorRequirement[] = [];

  constructor(data?: PartialMessage<LabelSelector>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "matchLabels", kind: "map", K: 9 /* ScalarType.STRING */, V: { kind: "scalar", T: 9 /* ScalarType.STRING */ } },
    { no: 2, name: "matchExpressions", kind: "message", T: LabelSelectorRequirement, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LabelSelector {
    return new LabelSelector().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LabelSelector {
    return new LabelSelector().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LabelSelector {
    return new LabelSelector().fromJsonString(jsonString, options);
  }

  static equals(a: LabelSelector | PlainMessage<LabelSelector> | undefined, b: LabelSelector | PlainMessage<LabelSelector> | undefined): boolean {
    return proto2.util.equals(LabelSelector, a, b);
  }
}

/**
 * A label selector requirement is a selector that contains values, a key, and an operator that
 * relates the key and values.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement
 */
export class LabelSelectorRequirement extends Message<LabelSelectorRequirement> {
  /**
   * key is the label key that the selector applies to.
   *
   * @generated from field: optional string key = 1;
   */
  key?: string;

  /**
   * operator represents a key's relationship to a set of values.
   * Valid operators are In, NotIn, Exists and DoesNotExist.
   *
   * @generated from field: optional string operator = 2;
   */
  operator?: string;

  /**
   * values is an array of string values. If the operator is In or NotIn,
   * the values array must be non-empty. If the operator is Exists or DoesNotExist,
   * the values array must be empty. This array is replaced during a strategic
   * merge patch.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string values = 3;
   */
  values: string[] = [];

  constructor(data?: PartialMessage<LabelSelectorRequirement>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelectorRequirement";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "key", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operator", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "values", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): LabelSelectorRequirement {
    return new LabelSelectorRequirement().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): LabelSelectorRequirement {
    return new LabelSelectorRequirement().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): LabelSelectorRequirement {
    return new LabelSelectorRequirement().fromJsonString(jsonString, options);
  }

  static equals(a: LabelSelectorRequirement | PlainMessage<LabelSelectorRequirement> | undefined, b: LabelSelectorRequirement | PlainMessage<LabelSelectorRequirement> | undefined): boolean {
    return proto2.util.equals(LabelSelectorRequirement, a, b);
  }
}

/**
 * List holds a list of objects, which may not be known by the server.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.List
 */
export class List extends Message<List> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * List of objects
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.runtime.RawExtension items = 2;
   */
  items: RawExtension[] = [];

  constructor(data?: PartialMessage<List>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.List";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: RawExtension, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): List {
    return new List().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): List {
    return new List().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): List {
    return new List().fromJsonString(jsonString, options);
  }

  static equals(a: List | PlainMessage<List> | undefined, b: List | PlainMessage<List> | undefined): boolean {
    return proto2.util.equals(List, a, b);
  }
}

/**
 * ListMeta describes metadata that synthetic resources must have, including lists and
 * various status objects. A resource may have only one of {ObjectMeta, ListMeta}.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta
 */
export class ListMeta extends Message<ListMeta> {
  /**
   * Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
   * +optional
   *
   * @generated from field: optional string selfLink = 1;
   */
  selfLink?: string;

  /**
   * String that identifies the server's internal version of this object that
   * can be used by clients to determine when objects have changed.
   * Value must be treated as opaque by clients and passed unmodified back to the server.
   * Populated by the system.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
   * +optional
   *
   * @generated from field: optional string resourceVersion = 2;
   */
  resourceVersion?: string;

  /**
   * continue may be set if the user set a limit on the number of items returned, and indicates that
   * the server has more data available. The value is opaque and may be used to issue another request
   * to the endpoint that served this list to retrieve the next set of available objects. Continuing a
   * consistent list may not be possible if the server configuration has changed or more than a few
   * minutes have passed. The resourceVersion field returned when using this continue value will be
   * identical to the value in the first response, unless you have received this token from an error
   * message.
   *
   * @generated from field: optional string continue = 3;
   */
  continue?: string;

  /**
   * remainingItemCount is the number of subsequent items in the list which are not included in this
   * list response. If the list request contained label or field selectors, then the number of
   * remaining items is unknown and the field will be left unset and omitted during serialization.
   * If the list is complete (either because it is not chunking or because this is the last chunk),
   * then there are no more remaining items and this field will be left unset and omitted during
   * serialization.
   * Servers older than v1.15 do not set this field.
   * The intended use of the remainingItemCount is *estimating* the size of a collection. Clients
   * should not rely on the remainingItemCount to be set or to be exact.
   * +optional
   *
   * @generated from field: optional int64 remainingItemCount = 4;
   */
  remainingItemCount?: bigint;

  constructor(data?: PartialMessage<ListMeta>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "selfLink", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "continue", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "remainingItemCount", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListMeta {
    return new ListMeta().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListMeta {
    return new ListMeta().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListMeta {
    return new ListMeta().fromJsonString(jsonString, options);
  }

  static equals(a: ListMeta | PlainMessage<ListMeta> | undefined, b: ListMeta | PlainMessage<ListMeta> | undefined): boolean {
    return proto2.util.equals(ListMeta, a, b);
  }
}

/**
 * ListOptions is the query options to a standard REST list call.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ListOptions
 */
export class ListOptions extends Message<ListOptions> {
  /**
   * A selector to restrict the list of returned objects by their labels.
   * Defaults to everything.
   * +optional
   *
   * @generated from field: optional string labelSelector = 1;
   */
  labelSelector?: string;

  /**
   * A selector to restrict the list of returned objects by their fields.
   * Defaults to everything.
   * +optional
   *
   * @generated from field: optional string fieldSelector = 2;
   */
  fieldSelector?: string;

  /**
   * Watch for changes to the described resources and return them as a stream of
   * add, update, and remove notifications. Specify resourceVersion.
   * +optional
   *
   * @generated from field: optional bool watch = 3;
   */
  watch?: boolean;

  /**
   * allowWatchBookmarks requests watch events with type "BOOKMARK".
   * Servers that do not implement bookmarks may ignore this flag and
   * bookmarks are sent at the server's discretion. Clients should not
   * assume bookmarks are returned at any specific interval, nor may they
   * assume the server will send any BOOKMARK event during a session.
   * If this is not a watch, this field is ignored.
   * +optional
   *
   * @generated from field: optional bool allowWatchBookmarks = 9;
   */
  allowWatchBookmarks?: boolean;

  /**
   * resourceVersion sets a constraint on what resource versions a request may be served from.
   * See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
   * details.
   *
   * Defaults to unset
   * +optional
   *
   * @generated from field: optional string resourceVersion = 4;
   */
  resourceVersion?: string;

  /**
   * resourceVersionMatch determines how resourceVersion is applied to list calls.
   * It is highly recommended that resourceVersionMatch be set for list calls where
   * resourceVersion is set
   * See https://kubernetes.io/docs/reference/using-api/api-concepts/#resource-versions for
   * details.
   *
   * Defaults to unset
   * +optional
   *
   * @generated from field: optional string resourceVersionMatch = 10;
   */
  resourceVersionMatch?: string;

  /**
   * Timeout for the list/watch call.
   * This limits the duration of the call, regardless of any activity or inactivity.
   * +optional
   *
   * @generated from field: optional int64 timeoutSeconds = 5;
   */
  timeoutSeconds?: bigint;

  /**
   * limit is a maximum number of responses to return for a list call. If more items exist, the
   * server will set the `continue` field on the list metadata to a value that can be used with the
   * same initial query to retrieve the next set of results. Setting a limit may return fewer than
   * the requested amount of items (up to zero items) in the event all requested objects are
   * filtered out and clients should only use the presence of the continue field to determine whether
   * more results are available. Servers may choose not to support the limit argument and will return
   * all of the available results. If limit is specified and the continue field is empty, clients may
   * assume that no more results are available. This field is not supported if watch is true.
   *
   * The server guarantees that the objects returned when using continue will be identical to issuing
   * a single list call without a limit - that is, no objects created, modified, or deleted after the
   * first request is issued will be included in any subsequent continued requests. This is sometimes
   * referred to as a consistent snapshot, and ensures that a client that is using limit to receive
   * smaller chunks of a very large result can ensure they see all possible objects. If objects are
   * updated during a chunked list the version of the object that was present at the time the first list
   * result was calculated is returned.
   *
   * @generated from field: optional int64 limit = 7;
   */
  limit?: bigint;

  /**
   * The continue option should be set when retrieving more results from the server. Since this value is
   * server defined, clients may only use the continue value from a previous query result with identical
   * query parameters (except for the value of continue) and the server may reject a continue value it
   * does not recognize. If the specified continue value is no longer valid whether due to expiration
   * (generally five to fifteen minutes) or a configuration change on the server, the server will
   * respond with a 410 ResourceExpired error together with a continue token. If the client needs a
   * consistent list, it must restart their list without the continue field. Otherwise, the client may
   * send another list request with the token received with the 410 error, the server will respond with
   * a list starting from the next key, but from the latest snapshot, which is inconsistent from the
   * previous list results - objects that are created, modified, or deleted after the first list request
   * will be included in the response, as long as their keys are after the "next key".
   *
   * This field is not supported when watch is true. Clients may start a watch from the last
   * resourceVersion value returned by the server and not miss any modifications.
   *
   * @generated from field: optional string continue = 8;
   */
  continue?: string;

  /**
   * `sendInitialEvents=true` may be set together with `watch=true`.
   * In that case, the watch stream will begin with synthetic events to
   * produce the current state of objects in the collection. Once all such
   * events have been sent, a synthetic "Bookmark" event  will be sent.
   * The bookmark will report the ResourceVersion (RV) corresponding to the
   * set of objects, and be marked with `"k8s.io/initial-events-end": "true"` annotation.
   * Afterwards, the watch stream will proceed as usual, sending watch events
   * corresponding to changes (subsequent to the RV) to objects watched.
   *
   * When `sendInitialEvents` option is set, we require `resourceVersionMatch`
   * option to also be set. The semantic of the watch request is as following:
   * - `resourceVersionMatch` = NotOlderThan
   *   is interpreted as "data at least as new as the provided `resourceVersion`"
   *   and the bookmark event is send when the state is synced
   *   to a `resourceVersion` at least as fresh as the one provided by the ListOptions.
   *   If `resourceVersion` is unset, this is interpreted as "consistent read" and the
   *   bookmark event is send when the state is synced at least to the moment
   *   when request started being processed.
   * - `resourceVersionMatch` set to any other value or unset
   *   Invalid error is returned.
   *
   * Defaults to true if `resourceVersion=""` or `resourceVersion="0"` (for backward
   * compatibility reasons) and to false otherwise.
   * +optional
   *
   * @generated from field: optional bool sendInitialEvents = 11;
   */
  sendInitialEvents?: boolean;

  constructor(data?: PartialMessage<ListOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ListOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "labelSelector", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "fieldSelector", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "watch", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 9, name: "allowWatchBookmarks", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 4, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 10, name: "resourceVersionMatch", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "timeoutSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 7, name: "limit", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 8, name: "continue", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 11, name: "sendInitialEvents", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ListOptions {
    return new ListOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ListOptions {
    return new ListOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ListOptions {
    return new ListOptions().fromJsonString(jsonString, options);
  }

  static equals(a: ListOptions | PlainMessage<ListOptions> | undefined, b: ListOptions | PlainMessage<ListOptions> | undefined): boolean {
    return proto2.util.equals(ListOptions, a, b);
  }
}

/**
 * ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the resource
 * that the fieldset applies to.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry
 */
export class ManagedFieldsEntry extends Message<ManagedFieldsEntry> {
  /**
   * Manager is an identifier of the workflow managing these fields.
   *
   * @generated from field: optional string manager = 1;
   */
  manager?: string;

  /**
   * Operation is the type of operation which lead to this ManagedFieldsEntry being created.
   * The only valid values for this field are 'Apply' and 'Update'.
   *
   * @generated from field: optional string operation = 2;
   */
  operation?: string;

  /**
   * APIVersion defines the version of this resource that this field set
   * applies to. The format is "group/version" just like the top-level
   * APIVersion field. It is necessary to track the version of a field
   * set because it cannot be automatically converted.
   *
   * @generated from field: optional string apiVersion = 3;
   */
  apiVersion?: string;

  /**
   * Time is the timestamp of when the ManagedFields entry was added. The
   * timestamp will also be updated if a field is added, the manager
   * changes any of the owned fields value or removes a field. The
   * timestamp does not update when a field is removed from the entry
   * because another manager took it over.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time time = 4;
   */
  time?: Time;

  /**
   * FieldsType is the discriminator for the different fields format and version.
   * There is currently only one possible value: "FieldsV1"
   *
   * @generated from field: optional string fieldsType = 6;
   */
  fieldsType?: string;

  /**
   * FieldsV1 holds the first JSON version format as described in the "FieldsV1" type.
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.FieldsV1 fieldsV1 = 7;
   */
  fieldsV1?: FieldsV1;

  /**
   * Subresource is the name of the subresource used to update that object, or
   * empty string if the object was updated through the main resource. The
   * value of this field is used to distinguish between managers, even if they
   * share the same name. For example, a status update will be distinct from a
   * regular update using the same manager name.
   * Note that the APIVersion field is not related to the Subresource field and
   * it always corresponds to the version of the main resource.
   *
   * @generated from field: optional string subresource = 8;
   */
  subresource?: string;

  constructor(data?: PartialMessage<ManagedFieldsEntry>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "manager", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "operation", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "apiVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "time", kind: "message", T: Time, opt: true },
    { no: 6, name: "fieldsType", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "fieldsV1", kind: "message", T: FieldsV1, opt: true },
    { no: 8, name: "subresource", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ManagedFieldsEntry {
    return new ManagedFieldsEntry().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ManagedFieldsEntry {
    return new ManagedFieldsEntry().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ManagedFieldsEntry {
    return new ManagedFieldsEntry().fromJsonString(jsonString, options);
  }

  static equals(a: ManagedFieldsEntry | PlainMessage<ManagedFieldsEntry> | undefined, b: ManagedFieldsEntry | PlainMessage<ManagedFieldsEntry> | undefined): boolean {
    return proto2.util.equals(ManagedFieldsEntry, a, b);
  }
}

/**
 * MicroTime is version of Time with microsecond level precision.
 *
 * +protobuf.options.marshal=false
 * +protobuf.as=Timestamp
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.MicroTime
 */
export class MicroTime extends Message<MicroTime> {
  /**
   * Represents seconds of UTC time since Unix epoch
   * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
   * 9999-12-31T23:59:59Z inclusive.
   *
   * @generated from field: optional int64 seconds = 1;
   */
  seconds?: bigint;

  /**
   * Non-negative fractions of a second at nanosecond resolution. Negative
   * second values with fractions must still have non-negative nanos values
   * that count forward in time. Must be from 0 to 999,999,999
   * inclusive. This field may be limited in precision depending on context.
   *
   * @generated from field: optional int32 nanos = 2;
   */
  nanos?: number;

  constructor(data?: PartialMessage<MicroTime>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.MicroTime";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "seconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "nanos", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): MicroTime {
    return new MicroTime().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): MicroTime {
    return new MicroTime().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): MicroTime {
    return new MicroTime().fromJsonString(jsonString, options);
  }

  static equals(a: MicroTime | PlainMessage<MicroTime> | undefined, b: MicroTime | PlainMessage<MicroTime> | undefined): boolean {
    return proto2.util.equals(MicroTime, a, b);
  }
}

/**
 * ObjectMeta is metadata that all persisted resources must have, which includes all objects
 * users must create.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta
 */
export class ObjectMeta extends Message<ObjectMeta> {
  /**
   * Name must be unique within a namespace. Is required when creating resources, although
   * some resources may allow a client to request the generation of an appropriate name
   * automatically. Name is primarily intended for creation idempotence and configuration
   * definition.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * GenerateName is an optional prefix, used by the server, to generate a unique
   * name ONLY IF the Name field has not been provided.
   * If this field is used, the name returned to the client will be different
   * than the name passed. This value will also be combined with a unique suffix.
   * The provided value has the same validation rules as the Name field,
   * and may be truncated by the length of the suffix required to make the value
   * unique on the server.
   *
   * If this field is specified and the generated name exists, the server will return a 409.
   *
   * Applied only if Name is not specified.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
   * +optional
   *
   * @generated from field: optional string generateName = 2;
   */
  generateName?: string;

  /**
   * Namespace defines the space within which each name must be unique. An empty namespace is
   * equivalent to the "default" namespace, but "default" is the canonical representation.
   * Not all objects are required to be scoped to a namespace - the value of this field for
   * those objects will be empty.
   *
   * Must be a DNS_LABEL.
   * Cannot be updated.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces
   * +optional
   *
   * @generated from field: optional string namespace = 3;
   */
  namespace?: string;

  /**
   * Deprecated: selfLink is a legacy read-only field that is no longer populated by the system.
   * +optional
   *
   * @generated from field: optional string selfLink = 4;
   */
  selfLink?: string;

  /**
   * UID is the unique in time and space value for this object. It is typically generated by
   * the server on successful creation of a resource and is not allowed to change on PUT
   * operations.
   *
   * Populated by the system.
   * Read-only.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
   * +optional
   *
   * @generated from field: optional string uid = 5;
   */
  uid?: string;

  /**
   * An opaque value that represents the internal version of this object that can
   * be used by clients to determine when objects have changed. May be used for optimistic
   * concurrency, change detection, and the watch operation on a resource or set of resources.
   * Clients must treat these values as opaque and passed unmodified back to the server.
   * They may only be valid for a particular resource or set of resources.
   *
   * Populated by the system.
   * Read-only.
   * Value must be treated as opaque by clients and .
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
   * +optional
   *
   * @generated from field: optional string resourceVersion = 6;
   */
  resourceVersion?: string;

  /**
   * A sequence number representing a specific generation of the desired state.
   * Populated by the system. Read-only.
   * +optional
   *
   * @generated from field: optional int64 generation = 7;
   */
  generation?: bigint;

  /**
   * CreationTimestamp is a timestamp representing the server time when this object was
   * created. It is not guaranteed to be set in happens-before order across separate operations.
   * Clients may not set this value. It is represented in RFC3339 form and is in UTC.
   *
   * Populated by the system.
   * Read-only.
   * Null for lists.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time creationTimestamp = 8;
   */
  creationTimestamp?: Time;

  /**
   * DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This
   * field is set by the server when a graceful deletion is requested by the user, and is not
   * directly settable by a client. The resource is expected to be deleted (no longer visible
   * from resource lists, and not reachable by name) after the time in this field, once the
   * finalizers list is empty. As long as the finalizers list contains items, deletion is blocked.
   * Once the deletionTimestamp is set, this value may not be unset or be set further into the
   * future, although it may be shortened or the resource may be deleted prior to this time.
   * For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react
   * by sending a graceful termination signal to the containers in the pod. After that 30 seconds,
   * the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup,
   * remove the pod from the API. In the presence of network partitions, this object may still
   * exist after this timestamp, until an administrator or automated process can determine the
   * resource is fully terminated.
   * If not set, graceful deletion of the object has not been requested.
   *
   * Populated by the system when a graceful deletion is requested.
   * Read-only.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.Time deletionTimestamp = 9;
   */
  deletionTimestamp?: Time;

  /**
   * Number of seconds allowed for this object to gracefully terminate before
   * it will be removed from the system. Only set when deletionTimestamp is also set.
   * May only be shortened.
   * Read-only.
   * +optional
   *
   * @generated from field: optional int64 deletionGracePeriodSeconds = 10;
   */
  deletionGracePeriodSeconds?: bigint;

  /**
   * Map of string keys and values that can be used to organize and categorize
   * (scope and select) objects. May match selectors of replication controllers
   * and services.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels
   * +optional
   *
   * @generated from field: map<string, string> labels = 11;
   */
  labels: { [key: string]: string } = {};

  /**
   * Annotations is an unstructured key value map stored with a resource that may be
   * set by external tools to store and retrieve arbitrary metadata. They are not
   * queryable and should be preserved when modifying objects.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations
   * +optional
   *
   * @generated from field: map<string, string> annotations = 12;
   */
  annotations: { [key: string]: string } = {};

  /**
   * List of objects depended by this object. If ALL objects in the list have
   * been deleted, this object will be garbage collected. If this object is managed by a controller,
   * then an entry in this list will point to this controller, with the controller field set to true.
   * There cannot be more than one managing controller.
   * +optional
   * +patchMergeKey=uid
   * +patchStrategy=merge
   * +listType=map
   * +listMapKey=uid
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.OwnerReference ownerReferences = 13;
   */
  ownerReferences: OwnerReference[] = [];

  /**
   * Must be empty before the object is deleted from the registry. Each entry
   * is an identifier for the responsible component that will remove the entry
   * from the list. If the deletionTimestamp of the object is non-nil, entries
   * in this list can only be removed.
   * Finalizers may be processed and removed in any order.  Order is NOT enforced
   * because it introduces significant risk of stuck finalizers.
   * finalizers is a shared field, any actor with permission can reorder it.
   * If the finalizer list is processed in order, then this can lead to a situation
   * in which the component responsible for the first finalizer in the list is
   * waiting for a signal (field value, external system, or other) produced by a
   * component responsible for a finalizer later in the list, resulting in a deadlock.
   * Without enforced ordering finalizers are free to order amongst themselves and
   * are not vulnerable to ordering changes in the list.
   * +optional
   * +patchStrategy=merge
   * +listType=set
   *
   * @generated from field: repeated string finalizers = 14;
   */
  finalizers: string[] = [];

  /**
   * ManagedFields maps workflow-id and version to the set of fields
   * that are managed by that workflow. This is mostly for internal
   * housekeeping, and users typically shouldn't need to set or
   * understand this field. A workflow can be the user's name, a
   * controller's name, or the name of a specific apply path like
   * "ci-cd". The set of fields is always in the version that the
   * workflow used when modifying the object.
   *
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.ManagedFieldsEntry managedFields = 17;
   */
  managedFields: ManagedFieldsEntry[] = [];

  constructor(data?: PartialMessage<ObjectMeta>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "generateName", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "namespace", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "selfLink", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 7, name: "generation", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 8, name: "creationTimestamp", kind: "message", T: Time, opt: true },
    { no: 9, name: "deletionTimestamp", kind: "message", T: Time, opt: true },
    { no: 10, name: "deletionGracePeriodSeconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 11, name: "labels", kind: "map", K: 9 /* ScalarType.STRING */, V: { kind: "scalar", T: 9 /* ScalarType.STRING */ } },
    { no: 12, name: "annotations", kind: "map", K: 9 /* ScalarType.STRING */, V: { kind: "scalar", T: 9 /* ScalarType.STRING */ } },
    { no: 13, name: "ownerReferences", kind: "message", T: OwnerReference, repeated: true },
    { no: 14, name: "finalizers", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 17, name: "managedFields", kind: "message", T: ManagedFieldsEntry, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ObjectMeta {
    return new ObjectMeta().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ObjectMeta {
    return new ObjectMeta().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ObjectMeta {
    return new ObjectMeta().fromJsonString(jsonString, options);
  }

  static equals(a: ObjectMeta | PlainMessage<ObjectMeta> | undefined, b: ObjectMeta | PlainMessage<ObjectMeta> | undefined): boolean {
    return proto2.util.equals(ObjectMeta, a, b);
  }
}

/**
 * OwnerReference contains enough information to let you identify an owning
 * object. An owning object must be in the same namespace as the dependent, or
 * be cluster-scoped, so there is no namespace field.
 * +structType=atomic
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.OwnerReference
 */
export class OwnerReference extends Message<OwnerReference> {
  /**
   * API version of the referent.
   *
   * @generated from field: optional string apiVersion = 5;
   */
  apiVersion?: string;

  /**
   * Kind of the referent.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   *
   * @generated from field: optional string kind = 1;
   */
  kind?: string;

  /**
   * Name of the referent.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#names
   *
   * @generated from field: optional string name = 3;
   */
  name?: string;

  /**
   * UID of the referent.
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
   *
   * @generated from field: optional string uid = 4;
   */
  uid?: string;

  /**
   * If true, this reference points to the managing controller.
   * +optional
   *
   * @generated from field: optional bool controller = 6;
   */
  controller?: boolean;

  /**
   * If true, AND if the owner has the "foregroundDeletion" finalizer, then
   * the owner cannot be deleted from the key-value store until this
   * reference is removed.
   * See https://kubernetes.io/docs/concepts/architecture/garbage-collection/#foreground-deletion
   * for how the garbage collector interacts with this field and enforces the foreground deletion.
   * Defaults to false.
   * To set this field, a user needs "delete" permission of the owner,
   * otherwise 422 (Unprocessable Entity) will be returned.
   * +optional
   *
   * @generated from field: optional bool blockOwnerDeletion = 7;
   */
  blockOwnerDeletion?: boolean;

  constructor(data?: PartialMessage<OwnerReference>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.OwnerReference";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 5, name: "apiVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 1, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "controller", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 7, name: "blockOwnerDeletion", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): OwnerReference {
    return new OwnerReference().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): OwnerReference {
    return new OwnerReference().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): OwnerReference {
    return new OwnerReference().fromJsonString(jsonString, options);
  }

  static equals(a: OwnerReference | PlainMessage<OwnerReference> | undefined, b: OwnerReference | PlainMessage<OwnerReference> | undefined): boolean {
    return proto2.util.equals(OwnerReference, a, b);
  }
}

/**
 * PartialObjectMetadata is a generic representation of any object with ObjectMeta. It allows clients
 * to get access to a particular ObjectMeta schema without knowing the details of the version.
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.PartialObjectMetadata
 */
export class PartialObjectMetadata extends Message<PartialObjectMetadata> {
  /**
   * Standard object's metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;
   */
  metadata?: ObjectMeta;

  constructor(data?: PartialMessage<PartialObjectMetadata>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.PartialObjectMetadata";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ObjectMeta, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PartialObjectMetadata {
    return new PartialObjectMetadata().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PartialObjectMetadata {
    return new PartialObjectMetadata().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PartialObjectMetadata {
    return new PartialObjectMetadata().fromJsonString(jsonString, options);
  }

  static equals(a: PartialObjectMetadata | PlainMessage<PartialObjectMetadata> | undefined, b: PartialObjectMetadata | PlainMessage<PartialObjectMetadata> | undefined): boolean {
    return proto2.util.equals(PartialObjectMetadata, a, b);
  }
}

/**
 * PartialObjectMetadataList contains a list of objects containing only their metadata
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.PartialObjectMetadataList
 */
export class PartialObjectMetadataList extends Message<PartialObjectMetadataList> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * items contains each of the included items.
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.PartialObjectMetadata items = 2;
   */
  items: PartialObjectMetadata[] = [];

  constructor(data?: PartialMessage<PartialObjectMetadataList>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.PartialObjectMetadataList";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "items", kind: "message", T: PartialObjectMetadata, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PartialObjectMetadataList {
    return new PartialObjectMetadataList().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PartialObjectMetadataList {
    return new PartialObjectMetadataList().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PartialObjectMetadataList {
    return new PartialObjectMetadataList().fromJsonString(jsonString, options);
  }

  static equals(a: PartialObjectMetadataList | PlainMessage<PartialObjectMetadataList> | undefined, b: PartialObjectMetadataList | PlainMessage<PartialObjectMetadataList> | undefined): boolean {
    return proto2.util.equals(PartialObjectMetadataList, a, b);
  }
}

/**
 * Patch is provided to give a concrete name and type to the Kubernetes PATCH request body.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Patch
 */
export class Patch extends Message<Patch> {
  constructor(data?: PartialMessage<Patch>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Patch";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Patch {
    return new Patch().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Patch {
    return new Patch().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Patch {
    return new Patch().fromJsonString(jsonString, options);
  }

  static equals(a: Patch | PlainMessage<Patch> | undefined, b: Patch | PlainMessage<Patch> | undefined): boolean {
    return proto2.util.equals(Patch, a, b);
  }
}

/**
 * PatchOptions may be provided when patching an API object.
 * PatchOptions is meant to be a superset of UpdateOptions.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.PatchOptions
 */
export class PatchOptions extends Message<PatchOptions> {
  /**
   * When present, indicates that modifications should not be
   * persisted. An invalid or unrecognized dryRun directive will
   * result in an error response and no further processing of the
   * request. Valid values are:
   * - All: all dry run stages will be processed
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string dryRun = 1;
   */
  dryRun: string[] = [];

  /**
   * Force is going to "force" Apply requests. It means user will
   * re-acquire conflicting fields owned by other people. Force
   * flag must be unset for non-apply patch requests.
   * +optional
   *
   * @generated from field: optional bool force = 2;
   */
  force?: boolean;

  /**
   * fieldManager is a name associated with the actor or entity
   * that is making these changes. The value must be less than or
   * 128 characters long, and only contain printable characters,
   * as defined by https://golang.org/pkg/unicode/#IsPrint. This
   * field is required for apply requests
   * (application/apply-patch) but optional for non-apply patch
   * types (JsonPatch, MergePatch, StrategicMergePatch).
   * +optional
   *
   * @generated from field: optional string fieldManager = 3;
   */
  fieldManager?: string;

  /**
   * fieldValidation instructs the server on how to handle
   * objects in the request (POST/PUT/PATCH) containing unknown
   * or duplicate fields. Valid values are:
   * - Ignore: This will ignore any unknown fields that are silently
   * dropped from the object, and will ignore all but the last duplicate
   * field that the decoder encounters. This is the default behavior
   * prior to v1.23.
   * - Warn: This will send a warning via the standard warning response
   * header for each unknown field that is dropped from the object, and
   * for each duplicate field that is encountered. The request will
   * still succeed if there are no other errors, and will only persist
   * the last of any duplicate fields. This is the default in v1.23+
   * - Strict: This will fail the request with a BadRequest error if
   * any unknown fields would be dropped from the object, or if any
   * duplicate fields are present. The error returned from the server
   * will contain all unknown and duplicate fields encountered.
   * +optional
   *
   * @generated from field: optional string fieldValidation = 4;
   */
  fieldValidation?: string;

  constructor(data?: PartialMessage<PatchOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.PatchOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "dryRun", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "force", kind: "scalar", T: 8 /* ScalarType.BOOL */, opt: true },
    { no: 3, name: "fieldManager", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "fieldValidation", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): PatchOptions {
    return new PatchOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): PatchOptions {
    return new PatchOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): PatchOptions {
    return new PatchOptions().fromJsonString(jsonString, options);
  }

  static equals(a: PatchOptions | PlainMessage<PatchOptions> | undefined, b: PatchOptions | PlainMessage<PatchOptions> | undefined): boolean {
    return proto2.util.equals(PatchOptions, a, b);
  }
}

/**
 * Preconditions must be fulfilled before an operation (update, delete, etc.) is carried out.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Preconditions
 */
export class Preconditions extends Message<Preconditions> {
  /**
   * Specifies the target UID.
   * +optional
   *
   * @generated from field: optional string uid = 1;
   */
  uid?: string;

  /**
   * Specifies the target ResourceVersion
   * +optional
   *
   * @generated from field: optional string resourceVersion = 2;
   */
  resourceVersion?: string;

  constructor(data?: PartialMessage<Preconditions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Preconditions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "resourceVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Preconditions {
    return new Preconditions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Preconditions {
    return new Preconditions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Preconditions {
    return new Preconditions().fromJsonString(jsonString, options);
  }

  static equals(a: Preconditions | PlainMessage<Preconditions> | undefined, b: Preconditions | PlainMessage<Preconditions> | undefined): boolean {
    return proto2.util.equals(Preconditions, a, b);
  }
}

/**
 * RootPaths lists the paths available at root.
 * For example: "/healthz", "/apis".
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.RootPaths
 */
export class RootPaths extends Message<RootPaths> {
  /**
   * paths are the paths available at root.
   * +listType=atomic
   *
   * @generated from field: repeated string paths = 1;
   */
  paths: string[] = [];

  constructor(data?: PartialMessage<RootPaths>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.RootPaths";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "paths", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): RootPaths {
    return new RootPaths().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): RootPaths {
    return new RootPaths().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): RootPaths {
    return new RootPaths().fromJsonString(jsonString, options);
  }

  static equals(a: RootPaths | PlainMessage<RootPaths> | undefined, b: RootPaths | PlainMessage<RootPaths> | undefined): boolean {
    return proto2.util.equals(RootPaths, a, b);
  }
}

/**
 * ServerAddressByClientCIDR helps the client to determine the server address that they should use, depending on the clientCIDR that they match.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR
 */
export class ServerAddressByClientCIDR extends Message<ServerAddressByClientCIDR> {
  /**
   * The CIDR with which clients can match their IP to figure out the server address that they should use.
   *
   * @generated from field: optional string clientCIDR = 1;
   */
  clientCIDR?: string;

  /**
   * Address of this server, suitable for a client that matches the above CIDR.
   * This can be a hostname, hostname:port, IP or IP:port.
   *
   * @generated from field: optional string serverAddress = 2;
   */
  serverAddress?: string;

  constructor(data?: PartialMessage<ServerAddressByClientCIDR>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.ServerAddressByClientCIDR";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "clientCIDR", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "serverAddress", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): ServerAddressByClientCIDR {
    return new ServerAddressByClientCIDR().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): ServerAddressByClientCIDR {
    return new ServerAddressByClientCIDR().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): ServerAddressByClientCIDR {
    return new ServerAddressByClientCIDR().fromJsonString(jsonString, options);
  }

  static equals(a: ServerAddressByClientCIDR | PlainMessage<ServerAddressByClientCIDR> | undefined, b: ServerAddressByClientCIDR | PlainMessage<ServerAddressByClientCIDR> | undefined): boolean {
    return proto2.util.equals(ServerAddressByClientCIDR, a, b);
  }
}

/**
 * Status is a return value for calls that don't return other objects.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Status
 */
export class Status extends Message<Status> {
  /**
   * Standard list metadata.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;
   */
  metadata?: ListMeta;

  /**
   * Status of the operation.
   * One of: "Success" or "Failure".
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
   * +optional
   *
   * @generated from field: optional string status = 2;
   */
  status?: string;

  /**
   * A human-readable description of the status of this operation.
   * +optional
   *
   * @generated from field: optional string message = 3;
   */
  message?: string;

  /**
   * A machine-readable description of why this operation is in the
   * "Failure" status. If this value is empty there
   * is no information available. A Reason clarifies an HTTP status
   * code but does not override it.
   * +optional
   *
   * @generated from field: optional string reason = 4;
   */
  reason?: string;

  /**
   * Extended data associated with the reason.  Each reason may define its
   * own extended details. This field is optional and the data returned
   * is not guaranteed to conform to any schema except that defined by
   * the reason type.
   * +optional
   * +listType=atomic
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.apis.meta.v1.StatusDetails details = 5;
   */
  details?: StatusDetails;

  /**
   * Suggested HTTP return code for this status, 0 if not set.
   * +optional
   *
   * @generated from field: optional int32 code = 6;
   */
  code?: number;

  constructor(data?: PartialMessage<Status>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Status";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "metadata", kind: "message", T: ListMeta, opt: true },
    { no: 2, name: "status", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 5, name: "details", kind: "message", T: StatusDetails, opt: true },
    { no: 6, name: "code", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Status {
    return new Status().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Status {
    return new Status().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Status {
    return new Status().fromJsonString(jsonString, options);
  }

  static equals(a: Status | PlainMessage<Status> | undefined, b: Status | PlainMessage<Status> | undefined): boolean {
    return proto2.util.equals(Status, a, b);
  }
}

/**
 * StatusCause provides more information about an api.Status failure, including
 * cases when multiple errors are encountered.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.StatusCause
 */
export class StatusCause extends Message<StatusCause> {
  /**
   * A machine-readable description of the cause of the error. If this value is
   * empty there is no information available.
   * +optional
   *
   * @generated from field: optional string reason = 1;
   */
  reason?: string;

  /**
   * A human-readable description of the cause of the error.  This field may be
   * presented as-is to a reader.
   * +optional
   *
   * @generated from field: optional string message = 2;
   */
  message?: string;

  /**
   * The field of the resource that has caused this error, as named by its JSON
   * serialization. May include dot and postfix notation for nested attributes.
   * Arrays are zero-indexed.  Fields may appear more than once in an array of
   * causes due to fields having multiple errors.
   * Optional.
   *
   * Examples:
   *   "name" - the field "name" on the current resource
   *   "items[0].name" - the field "name" on the first array entry in "items"
   * +optional
   *
   * @generated from field: optional string field = 3;
   */
  field?: string;

  constructor(data?: PartialMessage<StatusCause>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.StatusCause";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "reason", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "message", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "field", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StatusCause {
    return new StatusCause().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StatusCause {
    return new StatusCause().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StatusCause {
    return new StatusCause().fromJsonString(jsonString, options);
  }

  static equals(a: StatusCause | PlainMessage<StatusCause> | undefined, b: StatusCause | PlainMessage<StatusCause> | undefined): boolean {
    return proto2.util.equals(StatusCause, a, b);
  }
}

/**
 * StatusDetails is a set of additional properties that MAY be set by the
 * server to provide additional information about a response. The Reason
 * field of a Status object defines what attributes will be set. Clients
 * must ignore fields that do not match the defined type of each attribute,
 * and should assume that any attribute may be empty, invalid, or under
 * defined.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.StatusDetails
 */
export class StatusDetails extends Message<StatusDetails> {
  /**
   * The name attribute of the resource associated with the status StatusReason
   * (when there is a single name which can be described).
   * +optional
   *
   * @generated from field: optional string name = 1;
   */
  name?: string;

  /**
   * The group attribute of the resource associated with the status StatusReason.
   * +optional
   *
   * @generated from field: optional string group = 2;
   */
  group?: string;

  /**
   * The kind attribute of the resource associated with the status StatusReason.
   * On some operations may differ from the requested resource Kind.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional string kind = 3;
   */
  kind?: string;

  /**
   * UID of the resource.
   * (when there is a single resource which can be described).
   * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names#uids
   * +optional
   *
   * @generated from field: optional string uid = 6;
   */
  uid?: string;

  /**
   * The Causes array includes more details associated with the StatusReason
   * failure. Not all StatusReasons may provide detailed causes.
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated k8s.io.apimachinery.pkg.apis.meta.v1.StatusCause causes = 4;
   */
  causes: StatusCause[] = [];

  /**
   * If specified, the time in seconds before the operation should be retried. Some errors may indicate
   * the client must take an alternate action - for those errors this field may indicate how long to wait
   * before taking the alternate action.
   * +optional
   *
   * @generated from field: optional int32 retryAfterSeconds = 5;
   */
  retryAfterSeconds?: number;

  constructor(data?: PartialMessage<StatusDetails>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.StatusDetails";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "name", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "group", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 6, name: "uid", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 4, name: "causes", kind: "message", T: StatusCause, repeated: true },
    { no: 5, name: "retryAfterSeconds", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): StatusDetails {
    return new StatusDetails().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): StatusDetails {
    return new StatusDetails().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): StatusDetails {
    return new StatusDetails().fromJsonString(jsonString, options);
  }

  static equals(a: StatusDetails | PlainMessage<StatusDetails> | undefined, b: StatusDetails | PlainMessage<StatusDetails> | undefined): boolean {
    return proto2.util.equals(StatusDetails, a, b);
  }
}

/**
 * TableOptions are used when a Table is requested by the caller.
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.TableOptions
 */
export class TableOptions extends Message<TableOptions> {
  /**
   * includeObject decides whether to include each object along with its columnar information.
   * Specifying "None" will return no object, specifying "Object" will return the full object contents, and
   * specifying "Metadata" (the default) will return the object's metadata in the PartialObjectMetadata kind
   * in version v1beta1 of the meta.k8s.io API group.
   *
   * @generated from field: optional string includeObject = 1;
   */
  includeObject?: string;

  constructor(data?: PartialMessage<TableOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.TableOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "includeObject", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TableOptions {
    return new TableOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TableOptions {
    return new TableOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TableOptions {
    return new TableOptions().fromJsonString(jsonString, options);
  }

  static equals(a: TableOptions | PlainMessage<TableOptions> | undefined, b: TableOptions | PlainMessage<TableOptions> | undefined): boolean {
    return proto2.util.equals(TableOptions, a, b);
  }
}

/**
 * Time is a wrapper around time.Time which supports correct
 * marshaling to YAML and JSON.  Wrappers are provided for many
 * of the factory methods that the time package offers.
 *
 * +protobuf.options.marshal=false
 * +protobuf.as=Timestamp
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Time
 */
export class Time extends Message<Time> {
  /**
   * Represents seconds of UTC time since Unix epoch
   * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
   * 9999-12-31T23:59:59Z inclusive.
   *
   * @generated from field: optional int64 seconds = 1;
   */
  seconds?: bigint = protoInt64.zero;

  /**
   * Non-negative fractions of a second at nanosecond resolution. Negative
   * second values with fractions must still have non-negative nanos values
   * that count forward in time. Must be from 0 to 999,999,999
   * inclusive. This field may be limited in precision depending on context.
   *
   * @generated from field: optional int32 nanos = 2;
   */
  nanos?: number = 0;

  constructor(data?: PartialMessage<Time>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Time";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "seconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "nanos", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Time {
    return new Time().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Time {
    return new Time().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Time {
    return new Time().fromJsonString(jsonString, options);
  }

  static equals(a: Time | PlainMessage<Time> | undefined, b: Time | PlainMessage<Time> | undefined): boolean {
    return proto2.util.equals(Time, a, b);
  }

  override fromJson(json: JsonValue, options?: Partial<JsonReadOptions>): this {
    if (typeof json !== "string") {
      throw new Error(`cannot decode google.protobuf.Timestamp from JSON: ${proto.json.debug(json)}`);
    }
    const matches = json.match(/^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2}):([0-9]{2})(?:Z|\.([0-9]{3,9})Z|([+-][0-9][0-9]:[0-9][0-9]))$/);
    if (!matches) {
      throw new Error(`cannot decode google.protobuf.Timestamp from JSON: invalid RFC 3339 string`);
    }
    const ms = Date.parse(matches[1] + "-" + matches[2] + "-" + matches[3] + "T" + matches[4] + ":" + matches[5] + ":" + matches[6] + (matches[8] ? matches[8] : "Z"));
    if (Number.isNaN(ms)) {
      throw new Error(`cannot decode google.protobuf.Timestamp from JSON: invalid RFC 3339 string`);
    }
    if (ms < Date.parse("0001-01-01T00:00:00Z") || ms > Date.parse("9999-12-31T23:59:59Z")) {
      throw new Error(`cannot decode message google.protobuf.Timestamp from JSON: must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive`);
    }
    this.seconds = protoInt64.parse(ms / 1000);
    this.nanos = 0;
    if (matches[7]) {
      this.nanos = (parseInt("1" + matches[7] + "0".repeat(9 - matches[7].length)) - 1000000000);
    }
    return this;
  }

  override toJson(options?: Partial<JsonWriteOptions>): JsonValue {
    // Return null if the value of both `seconds` and `nanos` 
    // are zero to behave identically with metav1.Time implementation in Go.
    if ((!this.seconds || this.seconds === 0) && (!this.nanos || this.nanos === 0)) {
      return null;
    }
    const ms = Number(this.seconds) * 1000;
    if (ms < Date.parse("0001-01-01T00:00:00Z") || ms > Date.parse("9999-12-31T23:59:59Z")) {
      throw new Error(`cannot encode google.protobuf.Timestamp to JSON: must be from 0001-01-01T00:00:00Z to 9999-12-31T23:59:59Z inclusive`);
    }
    if (this.nanos < 0) {
      throw new Error(`cannot encode google.protobuf.Timestamp to JSON: nanos must not be negative`);
    }
    let z = "Z";
    if (this.nanos > 0) {
      const nanosStr = (this.nanos + 1000000000).toString().substring(1);
      if (nanosStr.substring(3) === "000000") {
        z = "." + nanosStr.substring(0, 3) + "Z";
      } else if (nanosStr.substring(6) === "000") {
        z = "." + nanosStr.substring(0, 6) + "Z";
      } else {
        z = "." + nanosStr + "Z";
      }
    }
    return new Date(ms).toISOString().replace(".000Z", z);
  }

  toDate(): Date {
    return new Date(Number(this.seconds) * 1000 + Math.ceil(this.nanos / 1000000));
  }

  static fromDate(date: Date): Time {
    const ms = date.getTime();
    return new Time({
      seconds: protoInt64.parse(Math.floor(ms / 1000)),
      nanos: (ms % 1000) * 1000000,
    });
  }

  static now(): Time {
    return Time.fromDate(new Date())
  }
}

/**
 * Timestamp is a struct that is equivalent to Time, but intended for
 * protobuf marshalling/unmarshalling. It is generated into a serialization
 * that matches Time. Do not use in Go structs.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Timestamp
 */
export class Timestamp extends Message<Timestamp> {
  /**
   * Represents seconds of UTC time since Unix epoch
   * 1970-01-01T00:00:00Z. Must be from 0001-01-01T00:00:00Z to
   * 9999-12-31T23:59:59Z inclusive.
   *
   * @generated from field: optional int64 seconds = 1;
   */
  seconds?: bigint;

  /**
   * Non-negative fractions of a second at nanosecond resolution. Negative
   * second values with fractions must still have non-negative nanos values
   * that count forward in time. Must be from 0 to 999,999,999
   * inclusive. This field may be limited in precision depending on context.
   *
   * @generated from field: optional int32 nanos = 2;
   */
  nanos?: number;

  constructor(data?: PartialMessage<Timestamp>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Timestamp";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "seconds", kind: "scalar", T: 3 /* ScalarType.INT64 */, opt: true },
    { no: 2, name: "nanos", kind: "scalar", T: 5 /* ScalarType.INT32 */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Timestamp {
    return new Timestamp().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Timestamp {
    return new Timestamp().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Timestamp {
    return new Timestamp().fromJsonString(jsonString, options);
  }

  static equals(a: Timestamp | PlainMessage<Timestamp> | undefined, b: Timestamp | PlainMessage<Timestamp> | undefined): boolean {
    return proto2.util.equals(Timestamp, a, b);
  }
}

/**
 * TypeMeta describes an individual object in an API response or request
 * with strings representing the type of the object and its API schema version.
 * Structures that are versioned or persisted should inline TypeMeta.
 *
 * +k8s:deepcopy-gen=false
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.TypeMeta
 */
export class TypeMeta extends Message<TypeMeta> {
  /**
   * Kind is a string value representing the REST resource this object represents.
   * Servers may infer this from the endpoint the client submits requests to.
   * Cannot be updated.
   * In CamelCase.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
   * +optional
   *
   * @generated from field: optional string kind = 1;
   */
  kind?: string;

  /**
   * APIVersion defines the versioned schema of this representation of an object.
   * Servers should convert recognized schemas to the latest internal value, and
   * may reject unrecognized values.
   * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
   * +optional
   *
   * @generated from field: optional string apiVersion = 2;
   */
  apiVersion?: string;

  constructor(data?: PartialMessage<TypeMeta>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.TypeMeta";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "kind", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "apiVersion", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): TypeMeta {
    return new TypeMeta().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): TypeMeta {
    return new TypeMeta().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): TypeMeta {
    return new TypeMeta().fromJsonString(jsonString, options);
  }

  static equals(a: TypeMeta | PlainMessage<TypeMeta> | undefined, b: TypeMeta | PlainMessage<TypeMeta> | undefined): boolean {
    return proto2.util.equals(TypeMeta, a, b);
  }
}

/**
 * UpdateOptions may be provided when updating an API object.
 * All fields in UpdateOptions should also be present in PatchOptions.
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.UpdateOptions
 */
export class UpdateOptions extends Message<UpdateOptions> {
  /**
   * When present, indicates that modifications should not be
   * persisted. An invalid or unrecognized dryRun directive will
   * result in an error response and no further processing of the
   * request. Valid values are:
   * - All: all dry run stages will be processed
   * +optional
   * +listType=atomic
   *
   * @generated from field: repeated string dryRun = 1;
   */
  dryRun: string[] = [];

  /**
   * fieldManager is a name associated with the actor or entity
   * that is making these changes. The value must be less than or
   * 128 characters long, and only contain printable characters,
   * as defined by https://golang.org/pkg/unicode/#IsPrint.
   * +optional
   *
   * @generated from field: optional string fieldManager = 2;
   */
  fieldManager?: string;

  /**
   * fieldValidation instructs the server on how to handle
   * objects in the request (POST/PUT/PATCH) containing unknown
   * or duplicate fields. Valid values are:
   * - Ignore: This will ignore any unknown fields that are silently
   * dropped from the object, and will ignore all but the last duplicate
   * field that the decoder encounters. This is the default behavior
   * prior to v1.23.
   * - Warn: This will send a warning via the standard warning response
   * header for each unknown field that is dropped from the object, and
   * for each duplicate field that is encountered. The request will
   * still succeed if there are no other errors, and will only persist
   * the last of any duplicate fields. This is the default in v1.23+
   * - Strict: This will fail the request with a BadRequest error if
   * any unknown fields would be dropped from the object, or if any
   * duplicate fields are present. The error returned from the server
   * will contain all unknown and duplicate fields encountered.
   * +optional
   *
   * @generated from field: optional string fieldValidation = 3;
   */
  fieldValidation?: string;

  constructor(data?: PartialMessage<UpdateOptions>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.UpdateOptions";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "dryRun", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
    { no: 2, name: "fieldManager", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 3, name: "fieldValidation", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): UpdateOptions {
    return new UpdateOptions().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): UpdateOptions {
    return new UpdateOptions().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): UpdateOptions {
    return new UpdateOptions().fromJsonString(jsonString, options);
  }

  static equals(a: UpdateOptions | PlainMessage<UpdateOptions> | undefined, b: UpdateOptions | PlainMessage<UpdateOptions> | undefined): boolean {
    return proto2.util.equals(UpdateOptions, a, b);
  }
}

/**
 * Verbs masks the value so protobuf can generate
 *
 * +protobuf.nullable=true
 * +protobuf.options.(gogoproto.goproto_stringer)=false
 *
 * items, if empty, will result in an empty slice
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.Verbs
 */
export class Verbs extends Message<Verbs> {
  /**
   * @generated from field: repeated string items = 1;
   */
  items: string[] = [];

  constructor(data?: PartialMessage<Verbs>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.Verbs";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "items", kind: "scalar", T: 9 /* ScalarType.STRING */, repeated: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): Verbs {
    return new Verbs().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): Verbs {
    return new Verbs().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): Verbs {
    return new Verbs().fromJsonString(jsonString, options);
  }

  static equals(a: Verbs | PlainMessage<Verbs> | undefined, b: Verbs | PlainMessage<Verbs> | undefined): boolean {
    return proto2.util.equals(Verbs, a, b);
  }
}

/**
 * Event represents a single event to a watched resource.
 *
 * +protobuf=true
 * +k8s:deepcopy-gen=true
 * +k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object
 *
 * @generated from message k8s.io.apimachinery.pkg.apis.meta.v1.WatchEvent
 */
export class WatchEvent extends Message<WatchEvent> {
  /**
   * @generated from field: optional string type = 1;
   */
  type?: string;

  /**
   * Object is:
   *  * If Type is Added or Modified: the new state of the object.
   *  * If Type is Deleted: the state of the object immediately before deletion.
   *  * If Type is Error: *Status is recommended; other types may make sense
   *    depending on context.
   *
   * @generated from field: optional k8s.io.apimachinery.pkg.runtime.RawExtension object = 2;
   */
  object?: RawExtension;

  constructor(data?: PartialMessage<WatchEvent>) {
    super();
    proto2.util.initPartial(data, this);
  }

  static readonly runtime: typeof proto2 = proto2;
  static readonly typeName = "k8s.io.apimachinery.pkg.apis.meta.v1.WatchEvent";
  static readonly fields: FieldList = proto2.util.newFieldList(() => [
    { no: 1, name: "type", kind: "scalar", T: 9 /* ScalarType.STRING */, opt: true },
    { no: 2, name: "object", kind: "message", T: RawExtension, opt: true },
  ]);

  static fromBinary(bytes: Uint8Array, options?: Partial<BinaryReadOptions>): WatchEvent {
    return new WatchEvent().fromBinary(bytes, options);
  }

  static fromJson(jsonValue: JsonValue, options?: Partial<JsonReadOptions>): WatchEvent {
    return new WatchEvent().fromJson(jsonValue, options);
  }

  static fromJsonString(jsonString: string, options?: Partial<JsonReadOptions>): WatchEvent {
    return new WatchEvent().fromJsonString(jsonString, options);
  }

  static equals(a: WatchEvent | PlainMessage<WatchEvent> | undefined, b: WatchEvent | PlainMessage<WatchEvent> | undefined): boolean {
    return proto2.util.equals(WatchEvent, a, b);
  }
}

