# gpscan

<a href="https://grandperspectiv.sourceforge.net/"><img src="https://grandperspectiv.sourceforge.net/Images/GrandPerspectiveLogoWithShadow.png" width="120" height="120" align="right"></a>

[![Cargo Build & Test](https://github.com/kojix2/gpscan/actions/workflows/ci.yml/badge.svg)](https://github.com/kojix2/gpscan/actions/workflows/ci.yml)
[![Crates.io](https://img.shields.io/crates/v/gpscan?link=https%3A%2F%2Fcrates.io%2Fcrates%2Fgpscan)](https://crates.io/crates/gpscan)
[![Crates.io](https://img.shields.io/crates/l/gpscan?link=https%3A%2F%2Fgithub.com%2Fgpscan-community%2Fgpscan%2Fblob%2Fmain%2FLICENCE)](LICENSE)
[![Lines of Code](https://img.shields.io/endpoint?url=https%3A%2F%2Ftokei.kojix2.net%2Fbadge%2Fgithub%2Fkojix2%2Fgpscan%2Flines)](https://tokei.kojix2.net/github/kojix2/gpscan)

Scan your filesystem and get an XML file compatible with [GrandPerspective](https://grandperspectiv.sourceforge.net/) on macOS to visualize disk usage.

- Recursively scans directories and files
- Generates XML output compatible with GrandPerspective
- Skips symbolic links to prevent infinite loops
- Handles file permissions and errors

## Installation

### Downloading

You can download prebuilt binaries in the [GitHub Releases](https://github.com/kojix2/gpscan/releases).

### Building

```sh
cargo install gpscan
```

## Usage

### Basic usage

```
gpscan [OPTIONS] <directory>
```

Typical commands:

```sh
# File output (gzip by default, .gpscan is auto-appended)
gpscan . -o result

# Plain text file output (no gzip)
gpscan . -o result --no-gzip

# Gzip to stdout (useful for piping/redirect)
gpscan . -z > result.gpscan
```

Then open the generated file in [GrandPerspective](https://grandperspectiv.sourceforge.net/).

Notes:

- File output (-o) defaults to gzip and adds the .gpscan suffix automatically.
- When the target file already exists: in TTY, a prompt asks to overwrite; in non-interactive mode, use `--force`.

### Options

```
  -o, --output <FILE>            Output file (gzip by default, adds .gpscan)
  -A, --apparent-size            Use apparent size instead of disk usage
  -m, --mounts                   Cross filesystem boundaries during scan
  -Z, --zero-files               Include zero-byte files in scan
  -E, --empty-folders            Include empty folders in scan
  -q, --quiet                    Suppress all informational messages
  -z, --gzip                     Gzip-compress stdout (file output is gzip by default)
      --compression-level <0-9>  Gzip level for output (default: 6)
      --no-gzip                  Disable gzip for file output
  -f, --force                    Overwrite output file without prompt
  -h, --help                     Print help
  -V, --version                  Print version
```

### Environment Variables

- `RUST_LOG`: Set logging level (e.g., `RUST_LOG=debug gpscan /path`)

## Platform Notes

- Windows: Physical file size calculation uses estimated 4KB cluster size
- Linux/macOS: Uses actual filesystem block information for accurate physical sizes

## Development

```sh
git clone https://github.com/kojix2/gpscan.git
cd gpscan
cargo build --release
```

## License

[MIT](LICENSE)

This project includes code generated by AI tools.
