module RDF
  ##
  # Exchangeable Image File Format (EXIF) vocabulary.
  #
  # @see http://www.w3.org/2003/12/exif/
  class EXIF < Vocabulary("http://www.w3.org/2003/12/exif/ns#")
    property :_unknown
    property :apertureValue
    property :artist
    property :bitsPerSample
    property :brightnessValue
    property :cfaPattern
    property :colorSpace
    property :componentsConfiguration
    property :compressedBitsPerPixel
    property :compression
    property :contrast
    property :copyright
    property :customRendered
    property :datatype
    property :date
    property :dateAndOrTime
    property :dateTime
    property :dateTimeDigitized
    property :dateTimeOriginal
    property :deviceSettingDescription
    property :digitalZoomRatio
    property :exifAttribute
    property :exifVersion
    property :exif_IFD_Pointer
    property :exifdata
    property :exposureBiasValue
    property :exposureIndex
    property :exposureMode
    property :exposureProgram
    property :exposureTime
    property :fNumber
    property :fileSource
    property :flash
    property :flashEnergy
    property :flashpixVersion
    property :focalLength
    property :focalLengthIn35mmFilm
    property :focalPlaneResolutionUnit
    property :focalPlaneXResolution
    property :focalPlaneYResolution
    property :gainControl
    property :geo
    property :gpsAltitude
    property :gpsAltitudeRef
    property :gpsAreaInformation
    property :gpsDOP
    property :gpsDateStamp
    property :gpsDestBearing
    property :gpsDestBearingRef
    property :gpsDestDistance
    property :gpsDestDistanceRef
    property :gpsDestLatitude
    property :gpsDestLatitudeRef
    property :gpsDestLongitude
    property :gpsDestLongitudeRef
    property :gpsDifferential
    property :gpsImgDirection
    property :gpsImgDirectionRef
    property :gpsInfo
    property :gpsInfo_IFD_Pointer
    property :gpsLatitude
    property :gpsLatitudeRef
    property :gpsLongitude
    property :gpsLongitudeRef
    property :gpsMapDatum
    property :gpsMeasureMode
    property :gpsProcessingMethod
    property :gpsSatellites
    property :gpsSpeed
    property :gpsSpeedRef
    property :gpsStatus
    property :gpsTimeStamp
    property :gpsTrack
    property :gpsTrackRef
    property :gpsVersionID
    property :height
    property :ifdPointer
    property :imageConfig
    property :imageDataCharacter
    property :imageDataStruct
    property :imageDescription
    property :imageLength
    property :imageUniqueID
    property :imageWidth
    property :interopInfo
    property :interoperabilityIndex
    property :interoperabilityVersion
    property :interoperability_IFD_Pointer
    property :isoSpeedRatings
    property :jpegInterchangeFormat
    property :jpegInterchangeFormatLength
    property :length
    property :lightSource
    property :make
    property :makerNote
    property :maxApertureValue
    property :meter
    property :meteringMode
    property :mm
    property :model
    property :oecf
    property :orientation
    property :photometricInterpretation
    property :pictTaking
    property :pimBrightness
    property :pimColorBalance
    property :pimContrast
    property :pimInfo
    property :pimSaturation
    property :pimSharpness
    property :pixelXDimension
    property :pixelYDimension
    property :planarConfiguration
    property :primaryChromaticities
    property :printImageMatching_IFD_Pointer
    property :recOffset
    property :referenceBlackWhite
    property :relatedFile
    property :relatedImageFileFormat
    property :relatedImageLength
    property :relatedImageWidth
    property :relatedSoundFile
    property :resolution
    property :resolutionUnit
    property :rowsPerStrip
    property :samplesPerPixel
    property :saturation
    property :sceneCaptureType
    property :sceneType
    property :seconds
    property :sensingMethod
    property :sharpness
    property :shutterSpeedValue
    property :software
    property :spatialFrequencyResponse
    property :spectralSensitivity
    property :stripByteCounts
    property :stripOffsets
    property :subSecTime
    property :subSecTimeDigitized
    property :subSecTimeOriginal
    property :subjectArea
    property :subjectDistance
    property :subjectDistanceRange
    property :subjectLocation
    property :subseconds
    property :tag_number
    property :tagid
    property :transferFunction
    property :userComment
    property :userInfo
    property :versionInfo
    property :whiteBalance
    property :whitePoint
    property :width
    property :xResolution
    property :yCbCrCoefficients
    property :yCbCrPositioning
    property :yCbCrSubSampling
    property :yResolution
  end
end
