# Contributing to Taskbook

Thank you for taking the time to contribute to Taskbook!

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

## How to contribute

### Improve documentation

Typo corrections, error fixes, better explanations, more examples etc. Open an issue regarding anything that you think it could be improved! You can use the [`docs` label](https://github.com/klauscfhq/taskbook/labels/docs) to find out what others have suggested!

### Improve issues

Sometimes reported issues lack information, are not reproducible, or are even plain invalid. Help us out to make them easier to resolve. Handling issues takes a lot of time that we could rather spend on fixing bugs and adding features.

### Give feedback on issues

We're always looking for more opinions on discussions in the issue tracker. It's a good opportunity to influence the future direction of the project.

The [`question` label](https://github.com/klauscfhq/taskbook/labels/question) is a good place to find ongoing discussions.

### Write code

You can use issue labels to discover issues you could help us out with!

- [`feature request` issues](https://github.com/klauscfhq/taskbook/labels/feature%20request) are features we are open to including
- [`bug` issues](https://github.com/klauscfhq/taskbook/labels/bug) are known bugs we would like to fix
- [`future` issues](https://github.com/klauscfhq/taskbook/labels/future) are those that we'd like to get to, but not anytime soon. Please check before working on these since we may not yet want to take on the burden of supporting those features
- on the [`help wanted`](https://github.com/klauscfhq/taskbook/labels/help%20wanted) label you can always find something exciting going on

You may find an issue is assigned, or has the [`assigned` label](https://github.com/klauscfhq/taskbook/labels/assigned). Please double-check before starting on this issue because somebody else is likely already working on it

### Say hi

Come over and say hi anytime you feel like on [Gitter](https://gitter.im/klauscfhq/taskbook).

### Translating Documentation

- Ensure that the document is not already translated in your target language.
- Add the name of the language to the document as an extension, e.g: `readme.JP.md`
- Create a Pull Request including the language in the title, e.g: `Readme: Japanese Translation`

### Submitting an issue

- Search the issue tracker before opening an issue
- Ensure you're using the latest version of Taskbook
- Use a descriptive title
- Include as much information as possible;
  - Steps to reproduce the issue
  - Error message
  - Taskbook version
  - Operating system **etc**

### Submitting a pull request

- Non-trivial changes are often best discussed in an issue first, to prevent you from doing unnecessary work
- Try making the pull request from a [topic branch](https://github.com/dchelimsky/rspec/wiki/Topic-Branches) if it is of crucial importance
- Use a descriptive title for the pull request and commits
- You might be asked to do changes to your pull request, you can do that by just [updating the existing one](https://github.com/RichardLitt/docs/blob/master/amending-a-commit-guide.md)

> Inspired by project [AVA](https://github.com/avajs/ava/blob/master/contributing.md)'s contributing.md
