// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/keycloak/keycloak-operator/pkg/apis/keycloak/v1alpha1"
	scheme "github.com/keycloak/keycloak-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KeycloakUsersGetter has a method to return a KeycloakUserInterface.
// A group's client should implement this interface.
type KeycloakUsersGetter interface {
	KeycloakUsers(namespace string) KeycloakUserInterface
}

// KeycloakUserInterface has methods to work with KeycloakUser resources.
type KeycloakUserInterface interface {
	Create(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.CreateOptions) (*v1alpha1.KeycloakUser, error)
	Update(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.UpdateOptions) (*v1alpha1.KeycloakUser, error)
	UpdateStatus(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.UpdateOptions) (*v1alpha1.KeycloakUser, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.KeycloakUser, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.KeycloakUserList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakUser, err error)
	KeycloakUserExpansion
}

// keycloakUsers implements KeycloakUserInterface
type keycloakUsers struct {
	client rest.Interface
	ns     string
}

// newKeycloakUsers returns a KeycloakUsers
func newKeycloakUsers(c *KeycloakV1alpha1Client, namespace string) *keycloakUsers {
	return &keycloakUsers{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the keycloakUser, and returns the corresponding keycloakUser object, and an error if there is any.
func (c *keycloakUsers) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KeycloakUser, err error) {
	result = &v1alpha1.KeycloakUser{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakusers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KeycloakUsers that match those selectors.
func (c *keycloakUsers) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KeycloakUserList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KeycloakUserList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakusers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested keycloakUsers.
func (c *keycloakUsers) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("keycloakusers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a keycloakUser and creates it.  Returns the server's representation of the keycloakUser, and an error, if there is any.
func (c *keycloakUsers) Create(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.CreateOptions) (result *v1alpha1.KeycloakUser, err error) {
	result = &v1alpha1.KeycloakUser{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("keycloakusers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakUser).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a keycloakUser and updates it. Returns the server's representation of the keycloakUser, and an error, if there is any.
func (c *keycloakUsers) Update(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.UpdateOptions) (result *v1alpha1.KeycloakUser, err error) {
	result = &v1alpha1.KeycloakUser{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakusers").
		Name(keycloakUser.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakUser).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *keycloakUsers) UpdateStatus(ctx context.Context, keycloakUser *v1alpha1.KeycloakUser, opts v1.UpdateOptions) (result *v1alpha1.KeycloakUser, err error) {
	result = &v1alpha1.KeycloakUser{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakusers").
		Name(keycloakUser.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakUser).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the keycloakUser and deletes it. Returns an error if one occurs.
func (c *keycloakUsers) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakusers").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *keycloakUsers) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakusers").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched keycloakUser.
func (c *keycloakUsers) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakUser, err error) {
	result = &v1alpha1.KeycloakUser{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("keycloakusers").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
