// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1alpha1 "github.com/keycloak/keycloak-operator/pkg/apis/keycloak/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeKeycloaks implements KeycloakInterface
type FakeKeycloaks struct {
	Fake *FakeKeycloakV1alpha1
	ns   string
}

var keycloaksResource = schema.GroupVersionResource{Group: "keycloak.org", Version: "v1alpha1", Resource: "keycloaks"}

var keycloaksKind = schema.GroupVersionKind{Group: "keycloak.org", Version: "v1alpha1", Kind: "Keycloak"}

// Get takes name of the keycloak, and returns the corresponding keycloak object, and an error if there is any.
func (c *FakeKeycloaks) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.Keycloak, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(keycloaksResource, c.ns, name), &v1alpha1.Keycloak{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Keycloak), err
}

// List takes label and field selectors, and returns the list of Keycloaks that match those selectors.
func (c *FakeKeycloaks) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KeycloakList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(keycloaksResource, keycloaksKind, c.ns, opts), &v1alpha1.KeycloakList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1alpha1.KeycloakList{ListMeta: obj.(*v1alpha1.KeycloakList).ListMeta}
	for _, item := range obj.(*v1alpha1.KeycloakList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested keycloaks.
func (c *FakeKeycloaks) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(keycloaksResource, c.ns, opts))

}

// Create takes the representation of a keycloak and creates it.  Returns the server's representation of the keycloak, and an error, if there is any.
func (c *FakeKeycloaks) Create(ctx context.Context, keycloak *v1alpha1.Keycloak, opts v1.CreateOptions) (result *v1alpha1.Keycloak, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(keycloaksResource, c.ns, keycloak), &v1alpha1.Keycloak{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Keycloak), err
}

// Update takes the representation of a keycloak and updates it. Returns the server's representation of the keycloak, and an error, if there is any.
func (c *FakeKeycloaks) Update(ctx context.Context, keycloak *v1alpha1.Keycloak, opts v1.UpdateOptions) (result *v1alpha1.Keycloak, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(keycloaksResource, c.ns, keycloak), &v1alpha1.Keycloak{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Keycloak), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKeycloaks) UpdateStatus(ctx context.Context, keycloak *v1alpha1.Keycloak, opts v1.UpdateOptions) (*v1alpha1.Keycloak, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(keycloaksResource, "status", c.ns, keycloak), &v1alpha1.Keycloak{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Keycloak), err
}

// Delete takes name of the keycloak and deletes it. Returns an error if one occurs.
func (c *FakeKeycloaks) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(keycloaksResource, c.ns, name), &v1alpha1.Keycloak{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKeycloaks) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(keycloaksResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1alpha1.KeycloakList{})
	return err
}

// Patch applies the patch and returns the patched keycloak.
func (c *FakeKeycloaks) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.Keycloak, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(keycloaksResource, c.ns, name, pt, data, subresources...), &v1alpha1.Keycloak{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1alpha1.Keycloak), err
}
