/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt;

import java.io.UnsupportedEncodingException;

public class Hex {
    private static final char[] HEXTABLE = "0123456789abcdef".toCharArray();
    private static final byte[] HEXTABLEINV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15};

    private Hex() {
    }

    public static byte[] encode(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (bytes.length > 0x3FFFFFFF) {
            throw new IllegalArgumentException("Too many bytes");
        }
        byte[] ret = new byte[2 * bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            ret[i * 2] = (byte)HEXTABLE[(b & 0xF0) >> 4];
            ret[i * 2 + 1] = (byte)HEXTABLE[b & 0xF];
        }
        return ret;
    }

    public static byte[] decode(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (bytes.length % 2 != 0) {
            throw new IllegalArgumentException("Hex data length must be a multiple of 2");
        }
        int retlen = bytes.length / 2;
        byte[] ret = new byte[retlen];
        int i = 0;
        while (i < retlen) {
            byte c = bytes[i * 2];
            byte d = bytes[i * 2 + 1];
            if (c < 0 || d < 0 || c > HEXTABLEINV.length || d > HEXTABLEINV.length) {
                throw new IllegalArgumentException("Data contains invalid hex character");
            }
            byte b = HEXTABLEINV[c];
            if (b < 0) {
                throw new IllegalArgumentException("Data contains invalid hex character");
            }
            ret[i] = (byte)(b << 4);
            b = HEXTABLEINV[d];
            if (b < 0) {
                throw new IllegalArgumentException("Data contains invalid hex character");
            }
            int n = i++;
            ret[n] = (byte)(ret[n] | b);
        }
        return ret;
    }

    public static byte[] decodeString(String hex) {
        try {
            return Hex.decode(hex.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

