/*
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.*;
import com.oracle.truffle.api.frame.*;
import com.oracle.truffle.api.nodes.*;
import org.jruby.truffle.nodes.*;
import org.jruby.truffle.runtime.*;
import org.jruby.truffle.runtime.core.*;

@NodeInfo(shortName = "write-class-variable")
public class WriteClassVariableNode extends RubyNode {

    private final String name;
    @Child protected RubyNode module;
    @Child protected RubyNode rhs;

    public WriteClassVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode module, RubyNode rhs) {
        super(context, sourceSection);
        this.name = name;
        this.module = module;
        this.rhs = rhs;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        notDesignedForCompilation();

        // TODO(CS): can module ever not evaluate to a RubyModule?

        final RubyModule moduleObject = (RubyModule) module.execute(frame);

        final Object rhsValue = rhs.execute(frame);

        moduleObject.setClassVariable(name, rhsValue);

        return rhsValue;
    }

}
