/*
 * Copyright (c) 2013 Oracle and/or its affiliates. All rights reserved. This
 * code is released under a tri EPL/GPL/LGPL license. You can use it,
 * redistribute it and/or modify it under the terms of the:
 *
 * Eclipse Public License version 1.0
 * GNU General Public License version 2
 * GNU Lesser General Public License version 2.1
 */
package org.jruby.truffle.nodes.core;

import java.lang.annotation.*;

import org.jruby.runtime.Visibility;
import org.jruby.truffle.runtime.methods.*;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface CoreMethod {

    String[] names();

    Visibility visibility() default Visibility.PUBLIC;

    boolean isModuleMethod() default false;

    boolean needsSelf() default true;

    boolean isSplatted() default false;

    boolean needsBlock() default false;

    int minArgs() default Arity.NO_MINIMUM;

    int maxArgs() default Arity.NO_MAXIMUM;

    boolean lowerFixnumSelf() default false;

    int[] lowerFixnumParameters() default {};

}
