package org.jruby.parser;

public class RubyYyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           96,  391,  208,  208,  244,  247,  344,  431,  284,  537, 
          287,  638,  281,  221,  207,  452,  296,  286,  250,  663, 
          267,  267,  223,  208,  267,  108,  610,  680,  317,  603, 
          680,  732,  669,  221,  271,  271,   83,   83,  271,  601, 
          601,  681,  223,  588,  651,  302,  306,  246,  208,  589, 
          313,  283,  590,  593,  599,  637,  533,  401,  606,  341, 
          323,  533,  905,  297,  382,  283,  304,  307,  487,  601, 
          590,  488,  831,    8,  660,  246,  681,  725,  727,  632, 
          364,  601,  963,    8,  246,  542,  565,  537,  674,  601, 
          533,  394,  296,   82,  125,  125,  245,  396,  593,  599, 
          280,  741,  690,  847,  125,  533,  602,  601,   88,   88, 
          126,  126,  632,  250,   88,  238,  238,  238,  601,  542, 
          254,  238,  238,  370,  245,  238,   85,  833,  721,  364, 
          601,  405,    8,  245,  542,  565,  338,  744,  246,  125, 
          338,  285,  702,   71,   82,   72,  632,  340,  484,  484, 
          283,   88,  238,  395,  978,  311,  601,  238,  270,  270, 
          276,  102,  270,  503,  293,  506,  632,  509,  596,  963, 
          770,  527,  370,  509,  385,  860,  703,  541,  623,  552, 
          560,  865,  483,  486,  994,  706,  596,  245,  601,  125, 
          303,  385,  280,  793,  350,  351,   70,  722,  537,  905, 
          279,  340,  646,  601,  452,  311,  923,  800,  287,  527, 
          102,  541,  491,  552,  560,  357,  419,  339,  550,  601, 
          736,  339,  350,   73,  534,  238,  541,   88,  552,  560, 
          601,  978,  432,  769,   74,  809,  355,  601,  250,  397, 
          527,  477,  579,  512,  775,  436,  437,  251,   80,  279, 
          715,  465,  550,  737,  250,  320,  831,   85,  534,  283, 
          472,  414,  540,  680,  680,  565,  296,  550,  601,  253, 
          463,  734,  831,  534,   71,  681,  778,  458,  420,  601, 
          252,  267,  358,  267,  267,   74,  479,  289,  481,  794, 
          853,  353,  512,  402,  527,  271,  540,  271,  764,   80, 
          328,  380,  356,  330,  320,  351,  354,  352,  381,  590, 
           17,  540,  294,  297,  565,  833,  537,  527,  466,  467, 
          601,  601,  601,  601,  919,  650,  590,  433,  601,   53, 
          601,  927,  422,   88,   88,  617,  931,  334,  601,  556, 
          557,  558,  559,  527,  636,  350,  351,  336,  707,  831, 
          399,  590,  590,  386,  400,  666,  387,  238,  238,   17, 
          296,   71,   82,  607,  388,  611,  527,  909,  773,  621, 
          625,  913,  915,  601,  917,  378,  918,  601,  392,  601, 
          458,  282,  238,  560,  238,  238,  707,  267,  238,  393, 
          238,  619,  601,  403,  654,   88,  898,  282,  491,  610, 
          125,   88,  662,  601,  533,  588,  458,  297,  413,  629, 
          408,  589,   78,  267,  649,  652,  311,  627,  102,  270, 
           18,  270,  601,  803,   82,  458,  416,  797,  364,   83, 
          418,  579,  267,  542,  565,    8,  601,  602,  601,  458, 
          602,  682,  601,  668,  668,  873,  267,  601,  428,  686, 
          687,  238,  238,  238,  238,   88,  238,  238,  688,  595, 
          807,  104, 1007,   78,  208,  694,  421,  679,  695,   96, 
          601,  370,  285,  601,  221,  560,   72,  942,  680,  579, 
          125,  305,  952,  223,  429,  595,  579,  601,  238,  681, 
          601,  579,  238,  458,  238,   88,  311,  427,  238,  238, 
          267,   88,  696,   74,  595,   83,  996,  998,  999, 1000, 
          104,  560,  579,  550,  238,   88,  238,   80,  595,  534, 
          491, 1014,  950,  497,  498,  541,   88,  552,  560,   88, 
          500,  616,  430,  238,  601,  616,  433,   88,  512,  287, 
          527,  441,  580,  888,  560,  983,  357,  238,  803,  550, 
          740,  740,  595,  350,   73,  534,  537,  540,  601,  616, 
          565, 1024,   17,   17,   17,   74,  550,  355,   17,   17, 
          743,   17,  595,  435,  512,  238,  664,   88,  251,   80, 
          442,  251,  550,  438,  748,  756,  125,  740,  534,  447, 
          754,  750,  448,  540,  988,  451,  565,  757,  427,  808, 
          253,  238,  311,  253,  750,  763,  352,  512,  817,  497, 
          498,  252,  476,  358,  252,  829,  500,  832,  632,  756, 
          478,  782,  353,  471,  768,  527,  540,  772,  839,  565, 
          750,   75,   83,  356,  777,  767,  351,  354,  352,  208, 
          208,   17,  756,   96,  786,  650,  781,  406,  774,  785, 
          221,  776,  652,  949,  407,  475,  756,   68,   68,  223, 
          652,  489,   17,   68,   68,   68,   68,  491,  601,  801, 
           68,   68,  747,   96,   68,  810,  482,  805,  753,   83, 
          383,   78,   75,   83,  756,  747,  495,  384,  947,  490, 
          869,  408,  827,  828,  443,  444,  445,  822,  446,   76, 
           68,   68,  820,  804,   81,  496,   68,  507,  125,  511, 
          851,  747,  852,  546,  753,  855,  549,  601,  104,  822, 
          290,  528,  856,  858,  311,   98,  554,  352,  861,  863, 
          512,  580,  525,  526,  425,  513,  238,   88,  611,   79, 
          740,  426,   77,   78,  550,  497,  498,  620,   88,  551, 
           76,   88,  500,  902,  889,   81,   88,  505,  367,  420, 
          420,  878,  369,  370,  421,  420,  452,  469,  895,  896, 
          897,  452,  282,  650,   68,  876,   68,  601,  439,  580, 
          890,  238,   92,  246,  454,  440,  580,  125,  655,  454, 
           79,  580,  645,   77,   92,   92,  127,  127,  264,  528, 
           92,  601,  601,  311,  901,  965,  255,  665,  668,  683, 
           88,  691,  580,  421,   93,  972,   92,  796,  684,  976, 
          685,  614,  822,  697,  936,  624,  601,   88,   88,  185, 
          290,  708,  245,   92,  717,  473,  716,   92,  718,  957, 
          719,  312,  474,  939,  724,   88,  726,   88,   93,  647, 
           88,  238,  238,  728,  731,  125,  730,  238,  238,  948, 
          735,  745,  746,  411,  290,   93,  614,  238,  583,  125, 
          514,  311,  515,  516,  517,  518,  751,  752,  185,  290, 
          676,  678,   68,   68,  305,  883,  761,  811,  812,   88, 
          813,  312,  238,  652,  992,  579, 1021,  762,  765,  771, 
           75,   83,  583,   88,   88,   88,   68,   68,  105,  711, 
          528,  290,  779,   92,  783,  789,  678,  583,   16,  305, 
          990,  601,  601,  493,  790,  945,  991,   92,  406, 1017, 
          494,   68,  946,   68,   68,  980,  791,   68,  792,   68, 
          125,  795,  601,  995,   68,  458,  105,  806,   98,  583, 
           68,  819,  267,  854,   59,   60,  933,  290,  867,   88, 
          107,  866,   75,   83,  290,  107,  601,   16,   76,  580, 
          756,  877,  238,   81,  411,  879,  601,  881,  733,  891, 
          892,   88,   98,  893,  899,  236,  236,  236,  652,  268, 
          274,  903,  900,  275,   88,  105,  907,  906,  908,   98, 
           68,   68,   68,   68,   68,   68,   68,  910,   79,  282, 
          125,   77,  911,  912,  107,  601,  282,  914,  283,   92, 
           92,  421,  299,  103,  595,  916,  968,  290,  528,  282, 
           76,  601,  497,  498,  499,   81,  601,   68,  601,  500, 
          422,   68,  759,   68,   68,  921,  282,   68,   68,   88, 
           68,   92,  411,  238,   90,   88,  103,  103,  128,  128, 
          128,   88,  103,   68,   68,   68,  920,  924,  259,  926, 
           79,  928,  103,   77,  930,   68,  934,  956,   68,  935, 
          938,   92,   68,   93,  579,  352,   68,   92,   61,   62, 
           63,   64,  421,  944,  953,  398,   68,  711,  818,  103, 
          411,  495,  312,  314,  583,  954,  971,  411,  101,  981, 
          802,  979,  528,   92,  528,  982,  367,  678,  305,  993, 
          369,  370,  371,  372,   68,  185,   68,  185,  185,  185, 
          185,  185,  579,  411,  997, 1001,  185, 1013,  583,  579, 
         1003,   92, 1016, 1005,  579,   93, 1008,  489,  290,  823, 
           68, 1026,  588,  314,  489,  290,  601,  101,  185,  185, 
          580,  601,  101,  411,  590,  579,  185,  185,  185,  185, 
           16,   16,   16,  589,  590,  103,   16,   16,  290,   16, 
          594,   92,  312,  497,  498,  502,  583,   92,  594,  411, 
          500,  596,  590,  583,  590,  872,  601,  412,  579,  343, 
          326,   92,  548,  105,  185,  711,  130,  711,  653, 1015, 
          210,  411,   92,  758,  943,   92,  583,   98,  411,  583, 
          601,  830,  107,   92,  601,  601,   99,  236,  236,  894, 
          842,  104,  104,  129,  129,  129,  835,  104,  497,  498, 
          504,   95,   95,  260,  411,  500,  868,   95,  974,   16, 
          453,  973,  456,  256,  100,  497,  498,  508,  462,  106, 
          464,  257,  500,   92,  290,   93,  282,  816,  528,  989, 
           16,  290, 1018,  282,  104,   99,  580,    0,  315,   98, 
          103,  103,  103,  282,   95,   68,   68,    0,  312,   99, 
          282,  711,  959,  583,    0,    0,  519,   68,    0,    0, 
           68,  520,  528,  100,  941,   68,    0,  495,  106,    0, 
            0,    0,  579,    0,  838,    0,  515,  516,  517,  518, 
          519,  236,  236,  236,  236,  520,  561,  562,  315,    0, 
           68,    0,  305,  525,  526,  496,    0,    0,  495,    0, 
          291,  583,    0,  103,  711,  495,  711,  521,  583,  103, 
          104,   95,    0,  579,    0,  523,  524,  525,  526,   68, 
           95,  497,  498,  547,  314,  101,    0,    0,  500,  527, 
            0,    0,  825,   91,  583,    0,   68,   68,  411,  834, 
            0,  711,   97,    0,    0,   95,  639,    0,    0,    0, 
          841,  178,    0,  527,   68,    0,   68,    0,    0,   68, 
           68,   68,   95,  103,    0,    0,   68,   68,    0,    0, 
          312,    0,    0,    0,   94,    0,   68,  458,  458,  458, 
          496,  102,  102,   92,  458,    0,  411,  102,   90,  291, 
            0,    0,  580,  411,   92,    0,   91,   92,   68,    0, 
          178,   68,   92,  103,  314,  689,    0,    0,   94,  103, 
            0,    0,   68,   68,   68,    0,  104,  104,    0,  411, 
            0,    0,   90,  103,  102,   94,   95,   95,    0,    0, 
           91,   96,    0,    0,  103,    0,    0,  103,    0,   90, 
            0,   97,    0,   99,    0,  103,    0,   91,   95,  312, 
            0,  440,  440,  440,    0,  583,   92,  815,  440,    0, 
          102,  579,    0,    0,    0,   96,    0,    0,   68,  495, 
          352,  100,    0,   92,   92,   97,  106,  496,  104,    0, 
            0,   68,   96,    0,  104,  103,  365,  366,   95,    0, 
           68,   92,   97,   92,   95,  580,   92,    0,   94,  315, 
          102,  367,    0,   68,  495,  369,  370,  371,  372,  579, 
          314,  495,  290,  446,  446,  446,  579,  312,    0,    0, 
          446,  579,  291,    0,    0,  964,    0,  966,    0,  967, 
            0,  884,  496,  601,  969,   92,    0,  291,  104,  496, 
            0,  977,  579,    0,  291,  583,    0,    0,   95,   92, 
           92,   92,  958,  345,  346,  347,  348,  349,   68,    0, 
            0,    0,   68,    0,   68,    0,  236,    0,  100,    0, 
           68,  514,    0,  515,  516,  517,  518,  106,  104,  315, 
           95,  580,  601,    0,  104,    0,    0,  615,   95,  850, 
            0,    0,    0,    0,   95,    0,    0,    0,  104,    0, 
            0,    0,  127,    0,  709,   92,  102,  102,   95,  104, 
         1019,  236,  104,    0,    0,    0, 1020,  496, 1022,   95, 
          104, 1023,   95,    0,  496,    0,  291,   92,    0,  580, 
           95,    0,  314,  291,    0,    0,  580,    0,    0, 1030, 
           92,  580,   95,   94,  583,  103,    0,  178,    0,  178, 
          178,  178,  178,  178,    0,    0,  103,   90,  178,  103, 
          104,    0,  580,    0,  103,   91,    0,    0,  102,  488, 
           95,    0,  127,    0,  102,    0,  488,    0,    0,    0, 
          178,  178,    0,  104,  580,  315,    0,    0,  178,  178, 
          178,  178,  583,  188,    0,   92,    0,    0,    0,  583, 
           96,   92,    0,    0,  579,   94,  495,   92,    0,    0, 
           97,  314,    0,  495,  496,    0,    0,    0,  103,   90, 
            0,  496,  236,    0,    0,  583,  178,   91,  102,  837, 
            0,    0,  580,  103,  583,  103,  103,    0,  849,  580, 
            0,    0,  188,    0,  580,  588,  588,  588,    0,  290, 
            0,  588,  588,  103,  588,  103,  290,    0,  103,  291, 
            0,  580,   96,    0,    0,  580,  291,    0,  102,    0, 
            0,    0,   97,  850,  102,    0,  850,    0,  850,  314, 
          850,  836,  583,    0,  836,  601,  601,  601,  102,  583, 
          846,    0,  601,  886,  579,    0,    0,  103,    0,  102, 
            0,  960,  102,  515,  516,  517,  518,  315,    0,    0, 
          102,  103,  103,  103,  514,  583,  515,  516,  517,  518, 
          104,    0,    0,    0,  588,    0,  589,  589,  589,    0, 
           95,  104,  589,  589,  104,  589,    0,    0,    0,  104, 
            0,   95,    0,    0,   95,  588,    0,  266,  266,   95, 
          102,  266,    0,  850,    0,  850,    0,  850,    0,  352, 
          850,    0,    0,    0,  128,    0,  514,  103,  515,  516, 
          517,  518,    0,  290,  292,  365,  366,    0,  850,  266, 
          266,    0,  316,  318,    0,    0,  315,    0,    0,  103, 
          367,    0,  368,  104,  369,  370,  371,  372,    0,  709, 
            0,    0,  103,   95,    0,  589,    0,  710,    0,    0, 
          104,  104,  514,    0,  515,  516,  517,  518,    0,    0, 
           95,   95,  849,    0,    0,  849,  589,  975,  104,  849, 
          104,    0,    0,  104,  128,  925,    0,    0,   95,  929, 
           95,    0,    0,   95,    0,  709,    0,    0,  602,    0, 
            0,    0,    0,  904,  315,    0,    0,  103,  602,    0, 
          615,    0,    0,  103,    0,    0,    0,    0,  887,  103, 
            0,    0,  104,    0,  846,    0,    0,  846,  885,  836, 
            0,  846,   95,    0,    0,    0,  104,  104,  104,  188, 
            0,  188,  188,  188,  188,  188,   95,   95,   95,    0, 
          188,    0,  849,    0,  849,    0,  849,  602,    0,  849, 
          102,  490,    0,    0,    0,    0,    0,    0,  490,    0, 
            0,  102,  188,  188,  102,    0,    0,  849,    0,  102, 
          188,  188,  188,  188,    0,    0,    0,    0,    0,  129, 
            0,    0,  104,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   95,    0,  846,    0,  846,    0,  846,    0, 
            0,  846,    0, 1002,  104,    0, 1004, 1006,  188,    0, 
         1009, 1010,    0,    0,   95,    0,    0,  104,    0,  846, 
            0,    0,    0,  102,    0,    0,    0,   95,    0,  283, 
            0,    0,    0,  266,  266,  266,  318,  266,    0,    0, 
          102,  102,    0,    0,    0,    0,    0,    0,  266,  129, 
          266,  266,    0,    0, 1025, 1027, 1028, 1029,  102,  470, 
          102,    0,    0,  102, 1031,    0,    0,    0,    0,    0, 
          352,    0,  104,    0,    0,  357,  358,    0,  104,    0, 
            0,    0,   95,    0,  104,    0,  365,  366,   95,    0, 
            0,    0,    0,    0,   95,    0,    0,    0,    0,    0, 
            0,  367,  102,  368,    0,  369,  370,  371,  372,  373, 
          374,  375,    0,  376,  173,    0,  102,  102,  102,    0, 
            0,    0,    0,    0,  563,  564,  565,  566,  567,  568, 
          569,  570,  571,  572,  573,  574,  575,  576,  577,  578, 
          579,  580,  581,  582,  583,  584,  585,  586,  587,  588, 
          602,  602,  602,    0,  266,  602,  602,  602,  608,  602, 
          612,    0,    0,  173,  266,  626,    0,  155,    0,  602, 
          602,    0,  102,    0,    0,    0,    0,    0,  602,  602, 
          266,  602,  602,  602,  602,  602,    0,    0,  266,    0, 
            0,    0,    0,    0,  102,    0,    0,    0,    0,  266, 
          608,  661,  626,    0,    0,  266,    0,  102,  352,    0, 
            0,    0,    0,  266,    0,    0,  155,    0,    0,  266, 
          266,    0,    0,  266,  365,  366,    0,    0,    0,  602, 
            0,    0,  602,    0,  602,    0,    0,    0,    0,  367, 
            0,  368,    0,  369,  370,  371,  372,  692,  693,  375, 
          602,  376,    0,    0,    0,  266,    0,    0,  266,    0, 
            0,    0,  102,    0,    0,    0,    0,  266,  102,    0, 
            0,    0,    0,    0,  102,  156,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,  114,    0,    0,    0,    0,    0,  266,   28,    0, 
            0,   31,   32,   33,  156,   34,   35,   36,   37,   38, 
           39,  261,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,    0,  515,  516, 
          517,  518,  519,    0,    0,  235,    0,  520,  121,    0, 
            0,   46,   47,    0,   48,    0,  262,    0,  263,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  264,  521, 
            0,  266,    0,   52,   53,   54,   55,   56,   57,  525, 
          526,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,  265,    0,    0,    0,    0,    0, 
          173,    0,  173,  173,  173,  173,  173,    0,  483,    0, 
            0,  173,    0,    0,    0,  527,    0,    0,  483,    0, 
            0,    0,  491,    0,    0,    0,    0,    0,    0,  491, 
            0,    0,    0,  173,  173,    0,    0,    0,    0,  266, 
            0,  173,  173,  173,  173,    0,  266,  266,    0,    0, 
            0,    0,  483,  155,    0,  155,  155,  155,  155,  155, 
            0,    0,    0,    0,  155,    0,  483,  483,    0,  483, 
            0,  483,    0,    0,    0,  493,    0,    0,  266,  173, 
            0,    0,  493,    0,    0,    0,  155,  155,    0,    0, 
            0,    0,    0,    0,  155,  155,  155,  155,    0,  483, 
          514,    0,  515,  516,  517,  518,  519,  857,  859,    0, 
            0,  520,    0,  862,  864,    0,    0,    0,    0,    0, 
            0,    0,  870,  661,  266,    0,    0,    0,  874,    0, 
            0,    0,  155,  521,  522,    0,    0,    0,  486,    0, 
            0,  523,  524,  525,  526,    0,    0,    0,  486,    0, 
            0,  857,  859,  862,  864,    0,    0,    0,  266,    0, 
            0,  156,    0,  156,  156,  156,  156,  156,    0,    0, 
            0,    0,  156,    0,    0,    0,    0,    0,    0,  527, 
            0,    0,  486,  492,    0,    0,    0,    0,    0,    0, 
          492,    0,    0,    0,  156,  156,  486,  486,    0,  486, 
            0,  486,  156,  156,  156,  156,    0,    0,  352,  353, 
          354,  355,  356,  357,  358,  359,  937,  361,  362,    0, 
            0,    0,    0,    0,  365,  366,    0,    0,  940,  486, 
            0,    0,    0,  266,    0,    0,    0,    0,    0,  367, 
          156,  368,    0,  369,  370,  371,  372,  373,  374,  375, 
            0,  376,    0,    0,  940,    0,    0,  157,    0,    0, 
            0,  266,    0,    0,    0,  576,  576,  576,    0,  576, 
          483,  483,  483,  576,  576,  483,  483,  483,  576,  483, 
          576,  576,  576,  576,  576,  576,  576,  483,  576,  483, 
          483,  576,  576,  576,  576,  576,  576,  576,  483,  483, 
          576,  483,  483,  483,  483,  483,  157,  576,    0,  266, 
          576,  576,  576,  483,  576,  576,  576,  576,  576,  576, 
          576,  576,  576,  576,  576,  483,  483,  483,  483,  483, 
          483,  483,  483,  483,  483,  483,  483,  483,  483,    0, 
            0,  483,  483,  483,  576,  483,  483,  576,  576,  483, 
          576,  576,  483,  576,  483,  576,  483,  576,  483,  576, 
          483,  483,  483,  483,  483,  483,  483,  576,  483,  576, 
          483,    0,  576,  576,  576,  576,  576,  576,    0,    0, 
            0,  576,  483,  576,  576,    0,  576,  576,  576,  576, 
            0,  576,  576,  576,    0,  577,  577,  577,    0,  577, 
          486,  486,  486,  577,  577,  486,  486,  486,  577,  486, 
          577,  577,  577,  577,  577,  577,  577,  486,  577,  486, 
          486,  577,  577,  577,  577,  577,  577,  577,  486,  486, 
          577,  486,  486,  486,  486,  486,    0,  577,    0,    0, 
          577,  577,  577,  486,  577,  577,  577,  577,  577,  577, 
          577,  577,  577,  577,  577,  486,  486,  486,  486,  486, 
          486,  486,  486,  486,  486,  486,  486,  486,  486,    0, 
            0,  486,  486,  486,  577,  486,  486,  577,  577,  486, 
          577,  577,  486,  577,  486,  577,  486,  577,  486,  577, 
          486,  486,  486,  486,  486,  486,  486,  577,  486,  577, 
          486,    0,  577,  577,  577,  577,  577,  577,    0,    0, 
          579,  577,  486,  577,  577,    0,  577,  577,  577,  577, 
          579,  577,  577,  577,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  514,    0,  515, 
          516,  517,  518,  519,    0,    0,    0,    0,  520,    0, 
            0,    0,    0,  157,  579,  157,  157,  157,  157,  157, 
            0,    0,    0,    0,  157,    0,    0,    0,  579,  579, 
          521,  102,    0,  579,    0,  494,    0,    0,  523,  524, 
          525,  526,  494,    0,    0,    0,  157,  157,    0,    0, 
            0,    0,    0,    0,  157,  157,  157,  157,    0,    0, 
            0,  579,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  527,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,  157,    9,   10,    0,    0,    0,   11,  580, 
           12,   13,   14,  109,  110,   17,   18,    0,    0,  580, 
            0,  111,  112,  113,   22,   23,   24,   25,    0,    0, 
          114,    0,    0,    0,    0,    0,    0,  115,    0,    0, 
           31,   32,   33,    0,  116,   35,   36,   37,  117,   39, 
            0,   40,    0,  580,  118,  514,    0,  515,  516,  517, 
          518,  519,    0,    0,    0,    0,  520,  580,  580,    0, 
          104,  119,  580,    0,  120,    0,    0,  121,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,  521,  640, 
            0,    0,    0,    0,    0,    0,  523,  524,  525,  526, 
          580,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    0,    0,    0,    0,    0,    0,    0, 
            0,  113,    0,    0,  527,    0,    0,  579,  579,  579, 
            0,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,    0, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,    0,  579, 
          113,    0,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,    0,    0,  579,  579,  579,  579,    0,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,    0,  579,  579,  579,  579,  579,  579, 
            0,    0,    0,  579,  579,  579,  579,    0,  579,  579, 
          579,  579,    0,  579,  579,  579,  580,  580,  580,    0, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,    0,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,    0,  580,    0, 
            0,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
            0,    0,  580,  580,  580,  580,    0,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,    0,  580,  580,  580,  580,  580,  580,    0, 
            0,  583,  580,  580,  580,  580,    0,  580,  580,  580, 
          580,  583,  580,  580,  580,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  838,    0,  515,  516,  517,  518, 
          519,    0,    0,    0,    0,  520,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  583,    0,  113,    0,  113, 
          113,  113,  113,  113,    0,    0,    0,  521,  113,  583, 
          583,    0,  103,    0,  583,  523,  524,  525,  526,  483, 
            0,    0,    0,    0,    0,    0,  483,    0,    0,    0, 
          113,  113,    0,    0,    0,    0,    0,    0,  113,  113, 
          113,  113,  583,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  527,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,  113,    0,    0,   11, 
          283,   12,   13,   14,  109,  110,   17,   18,    0,    0, 
          283,    0,  111,  112,  113,   22,   23,   24,   25,    0, 
            0,  114,    0,    0,    0,    0,    0,    0,  115,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,  283,  118,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  283,  283, 
            0,    0,    0,  283,    0,  253,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  283,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,   65,   66,    0,    0,    0,    0,    0,    0, 
            0,    0,  114,    0,    0,    0,    0,    0,  579,  579, 
          579,    0,  579,  583,  583,  583,  579,  579,  583,  583, 
          583,  579,  583,  579,  579,  579,  579,  579,  579,  579, 
            0,  583,  583,  583,  579,  579,  579,  579,  579,  579, 
          579,  583,  583,  579,  583,  583,  583,  583,  583,    0, 
          579,  114,    0,  579,  579,  579,  583,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  583,  583, 
          583,  583,  583,  583,  583,  583,  583,  583,  583,  583, 
          583,  583,    0,    0,  583,  583,  583,  579,    0,  583, 
          579,  579,  583,  579,  579,  583,  579,  583,  579,  583, 
          579,  583,  579,  583,  583,  583,  583,  583,  583,  583, 
          579,  583,  583,  583,    0,  579,  579,  579,  579,  579, 
          579,    0,    0,    0,  579,  583,  579,  579,    0,  579, 
          579,  579,  579,    0,  579,  579,  579,  578,  578,  578, 
            0,  578,  283,  283,  283,  578,  578,  283,  283,  283, 
          578,  283,  578,  578,  578,  578,  578,  578,  578,    0, 
          578,  283,  283,  578,  578,  578,  578,  578,  578,  578, 
          283,  283,  578,  283,  283,  283,  283,  283,    0,  578, 
            0,    0,  578,  578,  578,  283,  578,  578,  578,  578, 
          578,  578,  578,  578,  578,  578,  578,  283,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,    0,    0,  283,  283,  283,  578,    0,  283,  578, 
          578,  283,  578,  578,  283,  578,  283,  578,  283,  578, 
          283,  578,  283,  283,  283,  283,  283,  283,  283,  578, 
          283,  578,  283,    0,  578,  578,  578,  578,  578,  578, 
            0,    0,  584,  578,  283,  578,  578,    0,  578,  578, 
          578,  578,  584,  578,  578,  578,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  584,    0,  114,    0, 
          114,  114,  114,  114,  114,    0,    0,    0,    0,  114, 
          584,  584,    0,    0,    0,  584,    0,    0,    0,    0, 
          486,    0,    0,    0,    0,    0,    0,  486,    0,    0, 
            0,  114,  114,    0,    0,    0,    0,    0,    0,  114, 
          114,  114,  114,  584,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,  114,    0,    0, 
           11,  585,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,  585,    0,  111,  112,  113,   22,   23,   24,   25, 
            0,    0,  114,    0,    0,    0,    0,    0,    0,  115, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,    0,  585,  118,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  585, 
          585,    0,    0,    0,  585,    0,  309,    0,    0,  389, 
            0,    0,   46,   47,    0,   48,    0,  390,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  585,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  581, 
          581,  581,    0,  581,  584,  584,  584,  581,  581,  584, 
          584,  584,  581,  584,  581,  581,  581,  581,  581,  581, 
          581,    0,  584,  584,  584,  581,  581,  581,  581,  581, 
          581,  581,  584,  584,  581,  584,  584,  584,  584,  584, 
            0,  581,    0,    0,  581,  581,  581,  584,  581,  581, 
          581,  581,  581,  581,  581,  581,  581,  581,  581,  584, 
          584,  584,  584,  584,  584,  584,  584,  584,  584,  584, 
          584,  584,  584,    0,    0,  584,  584,  584,  581,    0, 
          584,  581,  581,  584,  581,  581,  584,  581,  584,  581, 
          584,  581,  584,  581,  584,  584,  584,  584,  584,  584, 
          584,  581,  584,  584,  584,    0,  581,  581,  581,  581, 
          581,  581,    0,    0,    0,  581,  584,  581,  581,    0, 
          581,  581,  581,  581,    0,  581,  581,  581,  582,  582, 
          582,    0,  582,  585,  585,  585,  582,  582,  585,  585, 
          585,  582,  585,  582,  582,  582,  582,  582,  582,  582, 
            0,  585,  585,  585,  582,  582,  582,  582,  582,  582, 
          582,  585,  585,  582,  585,  585,  585,  585,  585,    0, 
          582,    0,    0,  582,  582,  582,  585,  582,  582,  582, 
          582,  582,  582,  582,  582,  582,  582,  582,  585,  585, 
          585,  585,  585,  585,  585,  585,  585,  585,  585,  585, 
          585,  585,    0,    0,  585,  585,  585,  582,    0,  585, 
          582,  582,  585,  582,  582,  585,  582,  585,  582,  585, 
          582,  585,  582,  585,  585,  585,  585,  585,  585,  585, 
          582,  585,  585,  585,    0,  582,  582,  582,  582,  582, 
          582,    0,    0,  290,  582,  585,  582,  582,    0,  582, 
          582,  582,  582,  290,  582,  582,  582,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  590, 
          591,    0,    0,  592,    0,    0,    0,  176,  177,    0, 
          178,  179,  180,  181,  182,  183,  184,  290,    0,  185, 
          186,    0,    0,    0,  187,  188,  189,  190,    0,    0, 
            0,  290,  290,  279,  105,    0,  290,    0,    0,    0, 
          192,  193,    0,  194,  195,  196,  197,  198,  199,  200, 
          201,  202,  203,  204,    0,    0,  205,    0,    0,    0, 
            0,    0,    0,    0,  290,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,  206,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,  410,  114,    0,    0,    0,    0,    0,    0, 
           28,    0,  410,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  261,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  410,  235,    0,    0, 
          121,    0,    0,   46,   47,    0,   48,    0,  262,    0, 
          263,  410,   50,    0,    0,  410,    0,    0,    0,    0, 
          264,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,  410,   65,   66,  265,    0,    0,    0, 
          283,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          580,  580,  580,    0,  580,  290,  290,  290,  580,  580, 
          290,  290,  290,  580,  290,  580,  580,  580,  580,  580, 
          580,  580,    0,  377,  290,  290,  580,  580,  580,  580, 
          580,  580,  580,  290,  290,  580,  290,  290,  290,  290, 
          290,    0,  580,    0,    0,  580,  580,  580,  290,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,    0,    0,  290,  290,  290,  580, 
            0,  290,  580,  580,  290,  580,  580,  290,  580,  290, 
          580,  290,  580,  290,  580,  290,  290,  290,  290,  290, 
          290,  290,  580,  290,    0,  290,    0,  580,  580,  580, 
          580,  580,  580,    0,    0,    0,  580,  290,  580,  580, 
            0,  580,  580,  580,  580,    0,  580,  580,  580,  259, 
          259,  259,    0,  259,  410,  410,  410,  259,  259,  410, 
          410,  410,  259,  410,  259,  259,  259,  259,  259,  259, 
          259,  435,  410,  410,  410,  259,  259,  259,  259,  259, 
          259,  259,  410,  410,  259,  410,  410,  410,  410,  410, 
            0,  259,    0,    0,  259,  259,  259,    0,  259,  259, 
          259,  259,  259,  259,  259,  259,  259,  259,  259,  410, 
          410,  410,  410,  410,  410,  410,  410,  410,  410,  410, 
          410,  410,  410,    0,    0,  410,  410,  410,  259,    0, 
          410,  259,    0,  410,  259,  259,  410, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          259,  410,  259,  410,  259,  410,  259,  410,  410,  410, 
          410,  410,  410,  410,  259,  410,  410,  410,    0,  259, 
          259,  259,  259,  259,  259,    0,    0,  601,  259,    0, 
          259,  259,    0,  259,  259,  259,  259,  601,  259,  259, 
          259,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  601,  363,  364,    0,    0,  365,  366,    0,    0, 
            0,    0,    0,    0,    0,    0,  601,    0,    0,    0, 
          601,  367,    0,  368,    0,  369,  370,  371,  372,  373, 
          374,  375,    0,  376,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  601,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,  297,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,  297,   26,    0,    0, 
            0,    0,    0,   27,   28,   29,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
          297,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,  297,    0,   46,   47,  297, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,  297,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,  259,  259,    0,  259,  601, 
          601,  601,  259,  259,  601,  601,  601,  259,  601,  259, 
          259,  259,  259,  259,  259,  259,    0,  601,  601,  601, 
          259,  259,  259,  259,  259,  259,  259,  601,  601,  259, 
          601,  601,  601,  601,  601,    0,  259,    0,    0,  259, 
          259,  259,    0,  259,  259,  259,  259,  259,  259,  259, 
          259,  259,  259,  259,  601,  601,  601,  601,  601,  601, 
          601,  601,  601,  601,  601,  601,  601,  601,    0,    0, 
          601,  601,  601,  259,    0,  601,  259,    0,  601,  259, 
          259,  601,  259,  601,  259,  601,  259,  601,  259,  601, 
          601,  601,  601,  601,  601,  601,  259,  601,  601,  601, 
            0,  259,  259,  259,  259,  259,  259,    0,    0,  310, 
          259,    0,  259,  259,    0,  259,  259,  259,  259,    0, 
          259,  259,  259,  259,  259,  259,    0,  259,  297,  297, 
          297,  259,  259,  297,  297,  297,  259,  297,  259,  259, 
          259,  259,  259,  259,  259,    0,    0,  297,  297,  259, 
          259,  259,  259,  259,  259,  259,  297,  297,  259,  297, 
          297,  297,  297,  297,    0,  259,    0,    0,  259,  259, 
          259,    0,  259,  259,  259,  259,  259,  259,  259,  259, 
          259,  259,  259,  297,  297,  297,  297,  297,  297,  297, 
          297,  297,  297,  297,  297,  297,  297,    0,    0,  297, 
          297,  297,  259,    0,  297,  259,    0,  297,  259,  259, 
          297,  259,  297,  259,  297,  259,  297,  259,  297,  297, 
          297,  297,  297,  297,  297,  259,  297,  579,  297,    0, 
          259,  259,  259,  259,  259,  259,    0,  579,    0,  259, 
            0,  259,  259,    0,  259,  259,  259,  259,    0,  259, 
          259,  259,    0,  596,  597,    0,    0,  598,    0,    0, 
            0,  176,  177,    0,  178,  179,  180,  181,  182,  183, 
          184,   93,    0,  185,  186,    0,    0,    0,  187,  188, 
          189,  190,    0,    0,    0,    0,  579,  279,  102,    0, 
          579,    0,    0,    0,  192,  193,    0,  194,  195,  196, 
          197,  198,  199,  200,  201,  202,  203,  204,    0,    0, 
          205,    0,    0,    0,    0,    0,    0,    0,  579,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,  206,    0,    0,   11,    0,   12,   13,   14, 
          109,  110,   17,   18,    0,    0,    0,    0,  111,  112, 
          113,   22,   23,   24,   25,    0,  580,  114,    0,    0, 
            0,    0,    0,    0,  115,    0,  580,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,    0, 
            0,  118,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           95,  309,    0,    0,  121,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,  580,    0,  104,    0,  580, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,  580,   65,   66, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  579,  579,  579,    0,  579,  579, 
          579,  579,  579,  579,    0,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,    0,  579,    0,    0, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,    0,  579,    0,    0,  579, 
          579,  579,    0,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,    0,    0, 
          579,  579,  579,  579,    0,    0,  579,  579,  579,  579, 
          579,  377,  579,    0,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  579,  579,  579,  579,  579, 
            0,  579,  579,  579,  579,  579,  579,    0,    0,    0, 
          579,    0,  579,  579,    0,  579,  579,  579,  579,    0, 
          579,  579,  579,  580,  580,  580,    0,  580,  580,  580, 
          580,  580,  580,    0,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,    0,  580,    0,    0,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,    0,  580,    0,    0,  580,  580, 
          580,    0,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,    0,    0,  580, 
          580,  580,  580,    0,    0,  580,  580,  580,  580,  580, 
            0,  580,    0,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  580,  580,  580,  580,  580,    0, 
          580,  580,  580,  580,  580,  580,    0,    0,  583,  580, 
            0,  580,  580,    0,  580,  580,  580,  580,  583,  580, 
          580,  580,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,    0,    0,    0,    0,    0,  365,  366, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   94,  367,    0,  368,    0,  369,  370,  371, 
          372,  373,  374,  375,    0,  376,    0,  583,    0,  103, 
            0,  583,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  760,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  583, 
            0,    0,    0,    0,    0,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,    0,  363,  364,    0, 
            0,  365,  366,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  367,  290,  368,    0, 
          369,  370,  371,  372,  373,  374,  375,  290,  376,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  604,  591,    0,    0,  605,    0,    0, 
            0,  176,  177,    0,  178,  179,  180,  181,  182,  183, 
          184,   96,    0,  185,  186,    0,    0,    0,  187,  188, 
          189,  190,    0,    0,    0,    0,  290,  279,  105,    0, 
          290,    0,    0,    0,  192,  193,    0,  194,  195,  196, 
          197,  198,  199,  200,  201,  202,  203,  204,    0,    0, 
          205,  352,  353,  354,  355,  356,  357,  358,  290,    0, 
          361,  362,    0,    0,    0,    0,    0,  365,  366,    0, 
            0,    0,  206,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  367,    0,  368,    0,  369,  370,  371,  372, 
          373,  374,  375,    0,  376,  579,  579,  579,    0,  579, 
          583,  583,  583,  579,  579,    0,  583,  583,  579,  583, 
          579,  579,  579,  579,  579,  579,  579,  283,  583,    0, 
            0,  579,  579,  579,  579,  579,  579,  579,  583,  583, 
          579,  583,  583,  583,  583,  583,    0,  579,    0,    0, 
          579,  579,  579,    0,  579,  579,  579,  579,  579,  579, 
          579,  579,  579,  579,  579,  583,  583,  583,  583,  583, 
          583,  583,  583,  583,  583,  583,  583,  583,  583,    0, 
            0,  583,  583,  583,  579,    0,    0,  579,  579,  583, 
          579,  579,    0,  579,    0,  579,  583,  579,  583,  579, 
          583,  583,  583,  583,  583,  583,  583,  579,  583,  583, 
          583,    0,  579,  579,  579,  579,  579,  579,    0,    0, 
            0,  579,    0,  579,  579,    0,  579,  579,  579,  579, 
            0,  579,  579,  579,  580,  580,  580,    0,  580,  290, 
          290,  290,  580,  580,    0,  290,  290,  580,  290,  580, 
          580,  580,  580,  580,  580,  580,    0,    0,    0,    0, 
          580,  580,  580,  580,  580,  580,  580,  290,  290,  580, 
          290,  290,  290,  290,  290,  377,  580,    0,    0,  580, 
          580,  580,    0,  580,  580,  580,  580,  580,  580,  580, 
          580,  580,  580,  580,  290,  290,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,    0,    0, 
          290,  290,  290,  580,    0,    0,  580,  580,  290,  580, 
          580,    0,  580,    0,  580,  290,  580,  290,  580,  290, 
          290,  290,  290,  290,  290,  290,  580,  290,  601,  290, 
            0,  580,  580,  580,  580,  580,  580,    0,  601,    0, 
          580,    0,  580,  580,    0,  580,  580,  580,  580,    0, 
          580,  580,  580,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,  601,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,    0,    0,  121,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,  108,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,    0,    0,    0,    0,    0,    0,    0,  766, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  108,    0,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
            0,  363,  364,    0,    0,  365,  366,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  483, 
          367,    0,  368,    0,  369,  370,  371,  372,  373,  374, 
          375,    0,  376,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  259,  259,  259,    0,  259, 
          601,  601,  601,  259,  259,  601,  601,  601,  259,  601, 
          259,  259,  259,  259,  259,  259,  259,    0,  601,  601, 
          109,  259,  259,  259,  259,  259,  259,  259,  601,  601, 
          259,  601,  601,  601,  601,  601,    0,  259,    0,    0, 
          259,  259,  259,    0,  259,  259,  259,  259,  259,  259, 
          259,  259,  259,  259,  259,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  601,    0,    0,  109, 
            0,    0,    0,  601,  259,    0,    0,  259,    0,  601, 
          259,  259,    0,  259,    0,  259,    0,  259,    0,  259, 
            0,    0,    0,    0,    0,    0,    0,  259,    0,  601, 
          601,  486,  259,  259,  259,  259,  259,  259,    0,    0, 
            0,  259,    0,  259,  259,    0,  259,  259,  259,  259, 
            0,  259,  259,  259,  108,  108,  108,  108,  108,  108, 
          108,  108,  108,  108,  108,    0,    0,  108,  108,    0, 
          108,  108,  108,  108,  108,  108,  108,    0,  576,  108, 
            0,  108,  108,  108,  108,  108,  108,  108,    0,    0, 
          108,    0,    0,    0,    0,    0,  108,  108,    0,  108, 
          108,  108,  108,    0,  108,  108,  108,  108,  108,  108, 
            0,  108,  108,  108,  108,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  483,    0,  108,    0, 
            0,    0,    0,  483,  108,    0,    0,  108,  576,    0, 
          108,  108,    0,  108,    0,  108,    0,    0,    0,  108, 
            0,    0,    0,    0,  108,    0,    0,  108,    0,  576, 
          583,    0,  108,  108,  108,  108,  108,  108,    0,    0, 
            0,  108,    0,  108,  108,    0,  108,  108,  108,  108, 
            0,  108,  108,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  109,  109,  109,  109, 
          109,  109,  109,  109,  109,  109,  109,    0,  109,  109, 
          109,    0,  109,  109,  109,  109,  109,  109,  109,    0, 
          577,    0,    0,  109,  109,  109,  109,  109,  109,  109, 
            0,    0,  109,    0,    0,    0,    0,    0,  109,  109, 
            0,  109,  109,  109,  109,    0,  109,  109,  109,  109, 
          109,  109,    0,  109,  109,  109,  109,  109,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  486,    0, 
            0,    0,    0,    0,    0,  486,  109,    0,    0,  109, 
          577,    0,  109,  109,    0,  109,    0,  109,    0,  290, 
            0,  109,    0,    0,    0,    0,  109,    0,    0,  109, 
            0,  577,    0,    0,  109,  109,  109,  109,  109,  109, 
            0,    0,    0,  109,    0,  109,  109,    0,  109,  109, 
          109,  109,    0,  109,  109,  108,  108,  108,  108,  108, 
          108,  108,  108,  108,  108,  108,    0,  109,  108,  108, 
            0,  108,  108,  108,  108,  108,  108,  108,    0,  583, 
            0,    0,  108,  108,  108,  108,  108,  108,  108,    0, 
            0,  108,    0,    0,    0,    0,    0,  108,  108,    0, 
          108,  108,  108,  108,    0,  108,  108,  108,  108,  108, 
          108,    0,  108,  108,  108,  108,  109,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  583,    0,    0, 
            0,    0,    0,    0,  583,  108,    0,    0,  108,  579, 
            0,  108,  108,    0,  108,    0,  108,    0,  291,    0, 
          108,    0,    0,    0,    0,  108,    0,    0,  108,    0, 
          583,    0,    0,  108,  108,  108,  108,  108,  108,    0, 
            0,    0,  108,    0,  108,  108,    0,  108,  108,  108, 
          108,    0,  108,  108,  109,  109,  109,  109,  109,  109, 
          109,  109,  109,  109,  109,    0,  335,  109,  109,    0, 
          109,  109,  109,  109,  109,  109,  109,    0,    0,    0, 
            0,  109,  109,  109,  109,  109,  109,  109,    0,    0, 
          109,    0,    0,    0,    0,    0,  109,  109,    0,  109, 
          109,  109,  109,    0,  109,  109,  109,  109,  109,  109, 
            0,  109,  109,  109,  109,  335,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,    0,    0,    0, 
            0,    0,    0,  290,  109,    0,    0,  109,  580,    0, 
          109,  109,    0,  109,    0,  109,    0,    0,    0,  109, 
            0,    0,    0,    0,  109,    0,    0,  109,    0,    0, 
            0,    0,  109,  109,  109,  109,  109,  109,    0,    0, 
            0,  109,    0,  109,  109,    0,  109,  109,  109,  109, 
            0,  109,  109,  109,  109,  109,  109,  109,  109,  109, 
          109,  109,  109,  109,    0,  601,  109,  109,    0,  109, 
          109,  109,  109,  109,  109,  109,    0,    0,    0,    0, 
          109,  109,  109,  109,  109,  109,  109,    0,    0,  109, 
            0,    0,    0,    0,    0,  109,  109,    0,  109,  109, 
          109,  109,    0,  109,  109,  109,  109,  109,  109,    0, 
          109,  109,  109,  109,  601,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  291,    0,    0,    0,    0, 
            0,    0,  291,  109,    0,    0,  109,    0,    0,  109, 
          109,    0,  109,    0,  109,    0,    0,    0,  109,    0, 
            0,    0,    0,  109,    0,    0,  109,    0,    0,    0, 
            0,  109,  109,  109,  109,  109,  109,    0,    0,    0, 
          109,    0,  109,  109,    0,  109,  109,  109,  109,    0, 
          109,  109,  335,  335,  335,  335,  335,  335,  335,  335, 
          335,  335,  335,    0,  335,  335,  335,  335,  335,  335, 
          335,  335,  335,  335,  335,  601,    0,    0,    0,  335, 
          335,  335,  335,  335,  335,  335,    0,    0,  335,    0, 
            0,    0,    0,    0,  335,  335,    0,  335,  335,  335, 
          335,    0,  335,  335,  335,  335,  335,  335,    0,  335, 
          335,  335,  335,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  601,    0,    0,    0,    0,    0, 
            0,    0,  335,    0,    0,  335,    0,    0,  335,  335, 
            0,  335,    0,  335,    0,    0,    0,  335,    0,    0, 
            0,    0,    0,    0,    0,  335,    0,    0,    0,    0, 
          335,  335,  335,  335,  335,  335,    0,    0,    0,  335, 
            0,  335,  335,    0,  335,  335,  335,  335,    0,  335, 
          335,  601,  601,  601,  601,  601,  601,    0,    0,  601, 
          601,  601,    0,    0,    0,  601,    0,  601,  601,  601, 
          601,  601,  601,  601,  246,    0,    0,    0,  601,  601, 
          601,  601,  601,  601,  601,    0,    0,  601,    0,    0, 
            0,    0,    0,  601,  601,    0,  601,  601,  601,  601, 
            0,  601,  601,  601,  601,  601,  601,    0,  601,  601, 
          601,  601,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  245,    0,    0,    0,    0,    0,    0, 
            0,  601,    0,    0,  601,    0,    0,  601,  601,    0, 
          601,    0,  601,    0,    0,    0,  601,    0,    0,    0, 
            0,    0,    0,    0,  601,    0,    0,    0,    0,  601, 
          601,  601,  601,  601,  601,    0,    0,    0,  601,    0, 
          601,  601,    0,  601,  601,  601,  601,    0,  601,  601, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  601,  601,  601,  601,  601,  601,    0,    0,    0, 
          601,  601,    0,    0,    0,  601,    0,  601,  601,  601, 
          601,  601,  601,  601,    0,    0,  241,    0,  601,  601, 
          601,  601,  601,  601,  601,    0,  241,  601,    0,    0, 
            0,    0,    0,  601,  601,    0,  601,  601,  601,  601, 
            0,  601,  601,  601,  601,  601,  601,    0,  601,  601, 
          601,  601,    0,    0,    0,    0,    0,    0,    0,    0, 
          241,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  601,    0,    0,  601,  241,    0,  601,  601,    0, 
          601,    0,  601,    0,    0,    0,  601,    0,    0,    0, 
            0,    0,    0,    0,  601,    0,    0,  601,    0,  601, 
          601,  601,  601,  601,  601,    0,    0,    0,  601,    0, 
          601,  601,    0,  601,  601,  601,  601,    0,  601,  601, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,  411,   26,    0,    0,    0, 
            0,    0,    0,   28,    0,  411,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  411, 
          235,    0,    0,  121,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,  411,  411,   50,  101,    0,  411,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,  411,   65,   66,    0, 
            0,    0,    0,    0,    0,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  410,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  241,  241, 
          241,    0,    0,  241,  241,  241,    0,  241,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  241,  241,    0, 
          410,    0,    0,    0,    0,    0,  241,  241,    0,  241, 
          241,  241,  241,  241,  410,  410,    0,    0,    0,  410, 
            0,  241,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  410,    0,    0, 
            0,    0,    0,    0,  241,    0,    0,  241,    0,    0, 
          241,    0,  241,    0,    0,    0,    0,    0,    0,    0, 
          495,    0,    0,    0,    0,    0,    0,    0,  241,    0, 
          495,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          241,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  495,    0,    0,  411,  411,  411, 
            0,    0,  411,  411,  411,    0,  411,    0,  495,  495, 
            0,   99,    0,  495,    0,  411,  411,  411,    0,    0, 
            0,    0,    0,    0,    0,  411,  411,    0,  411,  411, 
          411,  411,  411,    0,    0,    0,    0,    0,    0,    0, 
          411,  495,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  411,  411,  411,  411,  411,  411,  411,  411, 
          411,  411,  411,  411,  411,  411,    0,    0,  411,  411, 
          411,    0,    0,  411,    0,    0,  411,    0,    0,  411, 
            0,  411,    0,  411,  496,  411,    0,  411,  411,  411, 
          411,  411,  411,  411,  496,  411,  411,  411,  410,  410, 
          410,    0,    0,  410,  410,  410,    0,  410,    0,  411, 
            0,    0,    0,    0,    0,    0,  410,  410,  410,    0, 
            0,    0,    0,    0,    0,    0,  410,  410,  496,  410, 
          410,  410,  410,  410,    0,    0,    0,    0,    0,    0, 
            0,  410,  496,  496,    0,  100,    0,  496,    0,    0, 
            0,    0,    0,  410,  410,  410,  410,  410,  410,  410, 
          410,  410,  410,  410,  410,  410,  410,    0,    0,  410, 
          410,  410,    0,    0,  410,  496,    0,  410,    0,    0, 
          410,    0,  410,    0,  410,    0,  410,    0,  410,  410, 
          410,  410,  410,  410,  410,    0,  410,  410,  410,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          410,    0,  495,  495,  495,    0,    0,  495,  495,  495, 
            0,  495,    0,    0,    0,    0,  377,    0,    0,    0, 
            0,  495,  495,    0,    0,    0,    0,    0,    0,    0, 
          495,  495,    0,  495,  495,  495,  495,  495,    0,    0, 
            0,    0,    0,    0,    0,  495,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  495,  495,  495, 
          495,  495,  495,  495,  495,  495,  495,  495,  495,  495, 
          495,    0,  601,  495,  495,  495,    0,  497,  495,    0, 
            0,  495,  601,    0,  495,    0,  495,    0,  495,    0, 
          495,    0,  495,  495,  495,  495,  495,  495,  495,    0, 
          495,    0,  495,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  495,    0,  601,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          601,  601,    0,    0,    0,  601,  496,  496,  496,    0, 
            0,  496,  496,  496,    0,  496,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  496,  496,    0,    0,    0, 
            0,    0,    0,  601,  496,  496,    0,  496,  496,  496, 
          496,  496,    0,    0,    0,    0,    0,    0,    0,  496, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,  496,  496,    0,  282,  496,  496,  496, 
            0,  498,  496,    0,    0,  496,  282,    0,  496,    0, 
          496,    0,  496,    0,  496,    0,  496,  496,  496,  496, 
          496,  496,  496,    0,  496,    0,  496,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  496,    0, 
          282,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  282,  282,    0,  107,    0,  282, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,    0,  363,  364,    0,    0,  365,  366,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  282,    0,    0, 
            0,  367,    0,  368,    0,  369,  370,  371,  372,  373, 
          374,  375,    0,  376,    0,    0,    0,    0,    0,    0, 
          291,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          291,    0,    0,    0,  601,  601,  601,    0,    0,  601, 
          601,  601,    0,  601,    0,    0,    0,    0,    0,    0, 
            0,    0,  601,  601,  601,    0,    0,    0,    0,    0, 
            0,    0,  601,  601,  291,  601,  601,  601,  601,  601, 
            0,    0,    0,    0,    0,    0,    0,  601,  291,  291, 
            0,  106,    0,  291,    0,    0,    0,    0,    0,  601, 
          601,  601,  601,  601,  601,  601,  601,  601,  601,  601, 
          601,  601,  601,    0,    0,  601,  601,  601,    0,    0, 
          601,  291,    0,  601,    0,    0,  601,    0,  601,    0, 
          601,  431,  601,    0,  601,  601,  601,  601,  601,  601, 
          601,  431,  601,  601,  601,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  601,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  431,    0,    0,  282,  282, 
          282,    0,    0,  282,  282,  282,    0,  282,    0,  431, 
          431,    0,    0,    0,  431,    0,    0,  282,  282,    0, 
            0,    0,    0,    0,    0,    0,  282,  282,    0,  282, 
          282,  282,  282,  282,    0,    0,    0,    0,    0,    0, 
            0,  282,  431,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,    0,    0,  282, 
          282,  282,    0,    0,  282,    0,    0,  282,    0,    0, 
          282,    0,  282,    0,  282,    0,  282,    0,  282,  282, 
          282,  282,  282,  282,  282,  302,  282,    0,  282,    0, 
            0,    0,    0,    0,    0,  302,    0,    0,    0,    0, 
          282,    0,  291,  291,  291,    0,    0,  291,  291,  291, 
            0,  291,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  291,  291,    0,    0,    0,    0,    0,    0,  302, 
          291,  291,    0,  291,  291,  291,  291,  291,    0,    0, 
            0,    0,    0,  302,  302,  291,    0,    0,  302,    0, 
            0,    0,    0,    0,    0,    0,    0,  291,  291,  291, 
          291,  291,  291,  291,  291,  291,  291,  291,  291,  291, 
          291,    0,    0,  291,  291,  291,  302,    0,  291,    0, 
            0,  291,    0,    0,  291,    0,  291,    0,  291,  240, 
          291,    0,  291,  291,  291,  291,  291,  291,  291,  240, 
          291,    0,  291,  431,  431,  431,    0,    0,  431,  431, 
          431,    0,  431,    0,  291,    0,    0,    0,    0,    0, 
            0,    0,  431,  431,    0,    0,    0,    0,    0,    0, 
            0,  431,  431,  240,  431,  431,  431,  431,  431,    0, 
            0,    0,    0,    0,    0,    0,  431,  240,  240,    0, 
            0,    0,  240,    0,    0,    0,    0,    0,  431,  431, 
          431,  431,  431,  431,  431,  431,  431,  431,  431,  431, 
          431,  431,    0,    0,  431,  431,  431,    0,    0,  431, 
          334,    0,  431,    0,    0,  431,    0,  431,    0,  431, 
            0,  431,    0,  431,  431,  431,  431,  431,  431,  431, 
            0,  431,  297,  431,    0,    0,    0,    0,    0,    0, 
            0,    0,  297,    0,    0,  431,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  297,  302,  302,  302, 
            0,    0,  302,  302,  302,    0,  302,    0,    0,    0, 
          297,  297,    0,    0,    0,  297,  302,  302,    0,    0, 
            0,    0,    0,    0,    0,  302,  302,    0,  302,  302, 
          302,  302,  302,    0,    0,    0,    0,    0,    0,    0, 
          302,    0,    0,  297,    0,    0,    0,    0,    0,    0, 
            0,    0,  302,  302,  302,  302,  302,  302,  302,  302, 
          302,  302,  302,  302,  302,  302,    0,    0,  302,  302, 
          302,    0,    0,  302,    0,    0,  302,    0,    0,  302, 
            0,  302,    0,  302,  478,  302,    0,  302,  302,  302, 
          302,  302,  302,  302,  478,  302,    0,  302,    0,    0, 
            0,  240,  240,  240,    0,    0,  240,  240,  240,  302, 
          240,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          240,  240,    0,    0,    0,    0,    0,    0,  478,  240, 
          240,    0,  240,  240,  240,  240,  240,    0,    0,    0, 
            0,    0,  478,  478,  240,    0,    0,  478,    0,    0, 
            0,    0,    0,    0,    0,    0,  240,  240,  240,  240, 
          240,  240,  240,  240,  240,  240,  240,  334,  240,  240, 
            0,    0,  240,  240,  334,  478,    0,  240,    0,    0, 
          240,    0,    0,  240,    0,  240,    0,  240,    0,  240, 
            0,  240,  240,  240,  240,  240,  240,  240,    0,  240, 
          218,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
          218,    0,    0,  240,  297,  297,  297,    0,    0,  297, 
          297,  297,    0,  297,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  297,  297,    0,    0,    0,    0,    0, 
            0,    0,  297,  297,  218,  297,  297,  297,  297,  297, 
            0,    0,    0,    0,    0,    0,    0,  297,  218,  218, 
            0,    0,    0,  218,    0,    0,    0,    0,    0,  297, 
          297,  297,  297,  297,  297,  297,  297,  297,  297,  297, 
          297,  297,  297,    0,    0,  297,  297,  297,    0,    0, 
          297,    0,    0,  297,    0,    0,  297,    0,  297,    0, 
          297,  215,  297,    0,  297,  297,  297,  297,  297,  297, 
          297,  215,  297,    0,  297,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  297,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  215,  478,  478,  478,    0, 
            0,  478,  478,  478,    0,  478,    0,    0,    0,  215, 
          215,    0,    0,    0,  215,  478,  478,    0,    0,    0, 
            0,    0,    0,    0,  478,  478,    0,  478,  478,  478, 
          478,  478,    0,    0,    0,    0,    0,    0,    0,  478, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  478,  478,  478,  478,  478,  478,  478,  478, 
          478,  478,  478,  478,  478,    0,  212,  478,  478,  478, 
            0,    0,  478,    0,    0,  478,  212,    0,  478,    0, 
          478,    0,  478,    0,  478,    0,  478,  478,  478,  478, 
          478,  478,  478,    0,  478,    0,  478,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  478,    0, 
          212,    0,  218,  218,  218,    0,    0,  218,  218,  218, 
            0,  218,    0,    0,  212,  212,    0,    0,    0,  212, 
            0,  218,  218,    0,    0,    0,    0,    0,    0,    0, 
          218,  218,    0,  218,  218,  218,  218,  218,    0,    0, 
            0,    0,    0,    0,    0,  218,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  218,  218, 
          218,  218,  218,  218,  218,  218,  218,  218,    0,  218, 
          218,    0,    0,  218,  218,    0,    0,    0,  218,    0, 
            0,  218,    0,    0,  218,    0,  218,    0,  218,  214, 
          218,    0,  218,  218,  218,  218,  218,  218,  218,  214, 
          218,    0,  218,  215,  215,  215,    0,    0,  215,  215, 
          215,    0,  215,    0,  218,    0,    0,    0,    0,    0, 
            0,    0,  215,  215,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,  214,  215,  215,  215,  215,  215,    0, 
            0,    0,    0,    0,    0,    0,  215,  214,  214,    0, 
            0,    0,  214,    0,    0,    0,    0,    0,    0,  215, 
          215,  215,  215,  215,  215,  215,  215,  215,  215,    0, 
          215,  215,    0,    0,  215,  215,    0,    0,    0,  215, 
            0,    0,  215,    0,    0,  215,    0,  215,    0,  215, 
            0,  215,    0,  215,  215,  215,  215,  215,  215,  215, 
            0,  215,    0,  215,  213,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  213,  215,    0,    0,  212,  212, 
          212,    0,    0,  212,  212,  212,    0,  212,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,    0, 
            0,    0,    0,    0,    0,    0,  212, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          212,  213,  212,  212,  212,  212,  212,    0,    0,    0, 
            0,    0,    0,    0,  212,  213,  213,    0,    0,    0, 
          213,    0,    0,    0,    0,    0,    0,  212,  212,  212, 
          212,  212,  212,  212,  212,  212,  212,    0,  212,  212, 
            0,    0,  212,  212,    0,    0,    0,  212,    0,    0, 
          212,    0,    0,  212,    0,  212,    0,  212,  216,  212, 
            0,  212,  212,  212,  212,  212,  212,  212,  216,  212, 
            0,  212,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  216,    0,  214,  214,  214,    0,    0,  214, 
          214,  214,    0,  214,    0,    0,  216,  216,    0,    0, 
            0,  216,    0,  214,  214,    0,    0,    0,    0,    0, 
            0,    0,  214,  214,    0,  214,  214,  214,  214,  214, 
            0,    0,    0,    0,    0,    0,    0,  214,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          214,  214,  214,  214,  214,  214,  214,  214,  214,  214, 
            0,  214,  214,    0,  210,  214,  214,    0,    0,    0, 
          214,    0,    0,  214,  210,    0,  214,    0,  214,    0, 
          214,    0,  214,    0,  214,  214,  214,  214,  214,  214, 
          214,    0,  214,    0,  214,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  214,    0,  210,  213, 
          213,  213,    0,    0,  213,  213,  213,    0,  213,    0, 
            0,    0,  210,  210,    0,    0,    0,  210,  213,  213, 
            0,    0,    0,    0,    0,    0,    0,  213,  213,    0, 
          213,  213,  213,  213,  213,    0,    0,    0,    0,    0, 
            0,    0,  213,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  213,  213,  213,  213,  213, 
          213,  213,  213,  213,  213,    0,  213,  213,    0,    0, 
          213,  213,    0,    0,    0,  213,    0,    0,  213,    0, 
            0,  213,    0,  213,    0,  213,  211,  213,    0,  213, 
          213,  213,  213,  213,  213,  213,  211,  213,    0,  213, 
          216,  216,  216,    0,    0,  216,  216,  216,    0,  216, 
            0,  213,    0,    0,    0,    0,    0,    0,    0,  216, 
          216,    0,    0,    0,    0,    0,    0,    0,  216,  216, 
          211,  216,  216,  216,  216,  216,    0,    0,    0,    0, 
            0,    0,    0,  216,  211,  211,    0,    0,    0,  211, 
            0,    0,    0,    0,    0,    0,  216,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,    0,  216,  216,    0, 
            0,  216,  216,    0,    0,    0,  216,    0,    0,  216, 
            0,    0,  216,    0,  216,    0,  216,    0,  216,    0, 
          216,  216,  216,  216,  216,  216,  216,    0,  216,  234, 
          216,    0,    0,    0,    0,    0,    0,    0,    0,  234, 
            0,    0,  216,    0,    0,    0,  210,  210,  210,    0, 
            0,  210,  210,  210,    0,  210,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  210,  210,    0,    0,    0, 
            0,    0,    0,  234,  210,  210,    0,  210,  210,  210, 
          210,  210,    0,    0,    0,    0,    0,  234,  234,  210, 
            0,    0,  234,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  210,  210,  210,  210,  210,  210,  210,  210, 
          210,  210,    0,  210,  210,    0,    0,  210,  210,    0, 
            0,    0,  210,    0,    0,  210,    0,    0,  210,    0, 
          210,    0,    0,  235,  210,    0,    0,    0,  210,  210, 
          210,  210,  210,  235,  210,    0,  210,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  210,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,  211,  211, 
          211,    0,    0,  211,  211,  211,    0,  211,    0,    0, 
            0,  235,  235,    0,    0,    0,  235,  211,  211,    0, 
            0,    0,    0,    0,    0,    0,  211,  211,    0,  211, 
          211,  211,  211,  211,    0,    0,    0,    0,    0,    0, 
            0,  211,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  211,  211,  211,  211,  211,  211, 
          211,  211,  211,  211,    0,  211,  211,    0,    0,  211, 
          211,    0,    0,    0,  211,  221,    0,  211,    0,    0, 
          211,    0,  211,    0,    0,  221,  211,    0,    0,    0, 
          211,  211,  211,  211,  211,    0,  211,    0,  211,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          211,  234,  234,  234,    0,    0,  234,  234,  234,  221, 
          234,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          234,  234,    0,  221,  221,    0,    0,    0,  221,  234, 
          234,    0,  234,  234,  234,  234,  234,    0,    0,    0, 
            0,    0,    0,    0,  234,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,  234, 
          234,  234,  234,  234,  234,  234,  234,    0,  234,  234, 
            0,    0,  234,  234,    0,    0,    0,  234,    0,    0, 
          234,    0,    0,  234,  219,  234,    0,    0,    0,  234, 
            0,    0,    0,    0,  219,  234,  234,  234,    0,  234, 
            0,  234,    0,    0,    0,  235,  235,  235,    0,    0, 
          235,  235,  235,  234,  235,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,    0,    0,  219,    0, 
            0,    0,    0,  235,  235,    0,  235,  235,  235,  235, 
          235,    0,  219,  219,    0,    0,    0,  219,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  235,  235,  235,  235,  235,  235,  235,  235,  235, 
          235,    0,  235,  235,    0,    0,  235,  235,    0,    0, 
            0,  235,    0,    0,  235,    0,  220,  235,    0,  235, 
            0,    0,    0,  235,    0,    0,  220,    0,    0,  235, 
          235,  235,    0,  235,    0,  235,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  221,  221,  221, 
          220,    0,  221,  221,  221,    0,  221,    0,    0,    0, 
            0,    0,    0,    0,  220,  220,  221,  221,    0,  220, 
            0,    0,    0,    0,    0,  221,  221,    0,  221,  221, 
          221,  221,  221,    0,    0,    0,    0,    0,    0,    0, 
          221,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  221,  221,  221,  221,  221,  221,  221, 
          221,  221,  221,    0,  221,  221,    0,    0,    0,    0, 
          224,    0,    0,  221,    0,    0,  221,    0,    0,  221, 
          224,  221,    0,    0,    0,  221,    0,    0,    0,    0, 
            0,  221,  221,  221,    0,  221,    0,  221,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  221, 
            0,    0,    0,    0,  224,    0,  219,  219,  219,    0, 
            0,  219,  219,  219,    0,  219,    0,    0,  224,  224, 
            0,    0,    0,  224,    0,  219,  219,    0,    0,    0, 
            0,    0,    0,    0,  219,  219,    0,  219,  219,  219, 
          219,  219,    0,    0,    0,    0,    0,    0,    0,  219, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  219,  219,  219,  219,  219,  219,  219,  219, 
          219,  219,    0,  219,  219,    0,    0,    0,    0,    0, 
            0,    0,  219,    0,    0,  219,  226,    0,  219,    0, 
          219,    0,    0,    0,    0,    0,  226,    0,    0,    0, 
          219,  219,  219,    0,  219,    0,  219,    0,  220,  220, 
          220,    0,    0,  220,  220,  220,    0,  220,  219,    0, 
            0,    0,    0,    0,    0,    0,    0,  220,  220,    0, 
          226,    0,    0,    0,    0,    0,  220,  220,    0,  220, 
          220,  220,  220,  220,  226,  226,    0,    0,    0,  226, 
            0,  220,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,  220,  220,  220,  220,  220, 
          220,  220,  220,  220,    0,  220,  220,    0,    0,    0, 
            0,    0,    0,    0,  220,    0,    0,  220,    0,    0, 
          220,    0,  220,    0,    0,    0,    0,    0,    0,    0, 
          225,    0,  220,  220,  220,    0,  220,    0,  220,    0, 
          225,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          220,    0,  224,  224,  224,    0,    0,  224,  224,  224, 
            0,  224,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  224,  224,    0,  225,    0,    0,    0,    0,    0, 
          224,  224,    0,  224,  224,  224,  224,  224,  225,  225, 
            0,    0,    0,  225,    0,  224,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
          224,  224,  224,  224,  224,  224,  224,  224,    0,  224, 
          224,    0,    0,    0,    0,    0,    0,    0,  224,    0, 
            0,  224,  223,    0,  224,    0,  224,    0,    0,    0, 
            0,    0,  223,    0,    0,    0,  224,  224,    0,    0, 
            0,    0,  224,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  224,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,  226,  226, 
          226,    0,    0,  226,  226,  226,    0,  226,    0,    0, 
          223,  223,    0,    0,    0,  223,    0,  226,  226,    0, 
            0,    0,    0,    0,    0,    0,  226,  226,    0,  226, 
          226,  226,  226,  226,    0,    0,    0,    0,    0,    0, 
            0,  226,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  226,  226,  226,  226,  226,  226, 
          226,  226,  226,  226,    0,  226,  226,    0,    0,    0, 
            0,  222,    0,    0,  226,    0,    0,  226,    0,    0, 
          226,  222,  226,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  226,  226,    0,    0,    0,    0,  226,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          226,    0,  225,  225,  225,  222,    0,  225,  225,  225, 
            0,  225,    0,    0,    0,    0,    0,    0,    0,  222, 
          222,  225,  225,    0,  222,    0,    0,    0,    0,    0, 
          225,  225,    0,  225,  225,  225,  225,  225,    0,    0, 
            0,    0,    0,    0,    0,  225,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  225,  225, 
          225,  225,  225,  225,  225,  225,  225,  225,    0,  225, 
          225,    0,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,  225,  227,    0,  225,    0,  225,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,  225,  225,  272,    0, 
            0,    0,  225,    0,  223,  223,  223,    0,  272,  223, 
          223,  223,    0,  223,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,  223,    0,  227,    0,    0,    0, 
            0,    0,  223,  223,    0,  223,  223,  223,  223,  223, 
          227,  227,  265,    0,    0,  227,    0,  223,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  272,    0,    0, 
          223,  223,  223,  223,  223,  223,  223,  223,  223,  223, 
            0,  223,  223,    0,    0,    0,    0,    0,    0,    0, 
          223,    0,    0,  223,    0,    0,  223,    0,  223,    0, 
          228,    0,    0,    0,    0,    0,    0,    0,  223,  223, 
          228,    0,    0,    0,  223,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,    0,    0, 
            0,    0,    0,  222,  222,  222,    0,    0,  222,  222, 
          222,    0,  222,    0,  228,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,    0,    0,    0,    0,  228,  228, 
            0,  222,  222,  228,  222,  222,  222,  222,  222,    0, 
            0,    0,    0,    0,    0,    0,  222,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  229,    0, 
            0,    0,    0,    0,    0,  222,  222,    0,  229,    0, 
          222,  222,    0,    0,    0,    0,    0,    0,    0,  222, 
            0,    0,  222,    0,    0,  222,    0,  222,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  229,  222,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  222,  229,  229,    0,    0, 
            0,  229,    0,    0,  227,  227,  227,    0,    0,  227, 
          227,  227,    0,  227,    0,    0,    0,    0,    0,    0, 
          272,  272,  272,  227,  227,  272,  272,  272,    0,  272, 
            0,    0,  227,  227,  236,  227,  227,  227,  227,  227, 
            0,    0,    0,    0,  236,    0,    0,  227,    0,    0, 
            0,  272,  272,  272,  272,  272,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,  227,    0,    0, 
            0,  227,  227,    0,    0,    0,    0,    0,  236,    0, 
          227,    0,    0,  227,    0,    0,  227,    0,  227,    0, 
            0,    0,  236,  236,    0,    0,  272,  236,    0,  272, 
            0,    0,    0,    0,  227,    0,    0,    0,    0,    0, 
            0,    0,  228,  228,  228,    0,  227,  228,  228,  228, 
          272,  228,    0,  230,    0,    0,    0,    0,    0,    0, 
            0,  228,  228,  230,    0,    0,    0,    0,    0,    0, 
          228,  228,    0,  228,  228,  228,  228,  228,    0,    0, 
            0,    0,    0,    0,    0,  228,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,    0,    0, 
            0,    0,    0,    0,  228,  228,    0,    0,    0,  228, 
          228,  230,  230,    0,    0,    0,  230,    0,  228,    0, 
            0,  228,    0,    0,  228,    0,  228,    0,    0,    0, 
          229,  229,  229,    0,    0,  229,  229,  229,    0,  229, 
            0,  231,  228,    0,    0,    0,    0,    0,    0,  229, 
          229,  231,    0,    0,  228,    0,    0,    0,  229,  229, 
            0,  229,  229,  229,  229,  229,    0,    0,    0,    0, 
            0,    0,    0,  229,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  231,    0,    0,    0,    0, 
            0,    0,  229,  229,    0,    0,    0,  229,  229,  231, 
          231,    0,    0,    0,  231,    0,  229,    0,    0,  229, 
            0,    0,  229,    0,  229,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,  236,  236,    0, 
          229,  236,  236,  236,    0,  236,    0,  237,    0,    0, 
            0,    0,  229,    0,    0,  236,  236,  237,    0,    0, 
            0,    0,    0,    0,  236,  236,    0,  236,  236,  236, 
          236,  236,    0,    0,    0,    0,    0,    0,    0,  236, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  237,    0,    0,    0,    0,    0,    0,  236,  236, 
            0,    0,    0,  236,  236,  237,  237,    0,    0,    0, 
          237,    0,  236,    0,    0,  236,    0,    0,  236,    0, 
          236,    0,    0,    0,    0,  230,  230,  230,    0,    0, 
          230,  230,  230,    0,  230,    0,  236,  208,    0,    0, 
            0,    0,    0,    0,  230,  230,    0,  208,  236,    0, 
            0,    0,    0,  230,  230,    0,  230,  230,  230,  230, 
          230,    0,    0,    0,    0,    0,    0,    0,  230,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  208,    0,    0,    0,    0,    0,  230,  230,    0, 
            0,    0,  230,  230,    0,  208,  208,    0,    0,    0, 
          208,  230,    0,    0,  230,    0,    0,  230,    0,  230, 
            0,    0,    0,  231,  231,  231,    0,    0,  231,  231, 
          231,    0,  231,    0,  209,  230,    0,    0,    0,    0, 
            0,    0,  231,  231,  209,    0,    0,  230,    0,    0, 
            0,  231,  231,    0,  231,  231,  231,  231,  231,    0, 
            0,    0,    0,    0,    0,    0,  231,    0,    0,    0, 
            0,    0,    0,    0,  238,    0,    0,    0,  209,    0, 
            0,    0,    0,    0,  238,  231,  231,    0,    0,    0, 
          231,  231,  209,  209,    0,    0,    0,  209,    0,  231, 
            0,    0,  231,    0,    0,  231,    0,  231,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,  237, 
          237,  237,    0,  231,  237,  237,  237,    0,  237,    0, 
            0,    0,  238,  238,    0,  231,    0,    0,  237,  237, 
            0,    0,    0,    0,    0,    0,    0,  237,  237,    0, 
          237,  237,  237,  237,  237,    0,    0,    0,    0,    0, 
            0,    0,  237,  207,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  207,    0,    0,    0,    0,    0,    0, 
            0,    0,  237,    0,    0,    0,  237,  237,    0,    0, 
            0,    0,    0,    0,    0,  237,    0,    0,  237,    0, 
            0,  237,    0,  237,    0,    0,    0,  207,    0,  208, 
          208,  208,    0,    0,  208,  208,  208,    0,  208,  237, 
            0,  207,  207,    0,  206,    0,    0,    0,  208,  208, 
            0,  237,    0,    0,  206,    0,    0,  208,  208,    0, 
          208,  208,  208,  208,  208,    0,    0,    0,    0,    0, 
            0,    0,  208,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  202,    0,    0,    0,  206,    0, 
            0,    0,    0,    0,  202,    0,    0,    0,    0,    0, 
            0,    0,  206,  206,    0,  208,    0,    0,  208,    0, 
            0,  208,    0,  208,    0,    0,  209,  209,  209,    0, 
            0,  209,  209,  209,    0,  209,    0,    0,  202,  208, 
            0,    0,    0,    0,    0,  209,  209,    0,    0,    0, 
            0,  208,  202,  202,  209,  209,    0,  209,  209,  209, 
          209,  209,    0,    0,    0,    0,  238,  238,  238,  209, 
            0,  238,  238,  238,    0,  238,    0,    0,    0,    0, 
            0,  203,    0,    0,    0,  238,  238,    0,    0,    0, 
            0,  203,    0,    0,  238,  238,    0,  238,  238,  238, 
          238,  238,  209,    0,    0,  209,    0,    0,  209,  238, 
          209,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  204,    0,    0,    0,  203,  209,    0,    0,    0, 
            0,  204,    0,    0,    0,    0,    0,    0,  209,  203, 
          203,    0,  238,    0,    0,  238,    0,    0,  238,    0, 
          238,    0,    0,    0,    0,  207,  207,  207,    0,    0, 
          207,  207,  207,    0,  207,  204,  238,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,    0,    0,  238,  204, 
          204,    0,  205,  207,  207,    0,  207,  207,  207,  207, 
          207,    0,  205,    0,    0,    0,    0,    0,  207,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  206,  206,  206,    0, 
            0,  206,  206,  206,    0,  206,  205,    0,    0,    0, 
            0,  207,    0,    0,  207,  206,  206,  207,    0,  207, 
          205,  205,    0,    0,  206,  206,    0,  206,  206,  206, 
          206,  206,    0,    0,    0,  207,  202,  202,  202,  206, 
            0,  202,  202,  202,    0,  202,    0,  207,  198,    0, 
            0,    0,    0,    0,    0,  202,  202,    0,  198,    0, 
            0,    0,    0,    0,  202,  202,    0,  202,  202,  202, 
          202,  202,  206,    0,    0,  206,    0,    0,  206,  202, 
          206,    0,    0,    0,    0,    0,    0,    0,   59,    0, 
            0,    0,  198,    0,    0,    0,  206,    0,   59,    0, 
            0,    0,    0,    0,    0,    0,  198,  198,  206,    0, 
            0,    0,  202,    0,    0,  202,    0,    0,  202,    0, 
          202,    0,    0,  203,  203,  203,    0,    0,  203,  203, 
          203,    0,  203,    0,    0,    0,  202,    0,    0,    0, 
            0,    0,  203,  203,    0,    0,    0,   59,  202,    0, 
            0,  203,  203,    0,  203,  203,  203,  203,  203,    0, 
            0,    0,    0,  204,  204,  204,  203,    0,  204,  204, 
          204,    0,  204,    0,    0,    0,    0,    0,  200,    0, 
            0,    0,  204,  204,    0,    0,    0,    0,  200,    0, 
            0,  204,  204,    0,  204,  204,  204,  204,  204,  203, 
            0,    0,  203,    0,    0,  203,  204,  203,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,    0, 
            0,    0,  200,  203,  205,  205,  205,    0,  239,  205, 
          205,  205,    0,  205,    0,  203,  200,  200,    0,  204, 
            0,    0,  204,  205,  205,  204,    0,  204,    0,    0, 
            0,    0,  205,  205,    0,  205,  205,  205,  205,  205, 
            0,    0,  239,  204,    0,    0,    0,  205,    0,    0, 
            0,    0,    0,    0,    0,  204,  239,  239,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          205,    0,    0,  205,  201,    0,  205,    0,  205,    0, 
          198,  198,  198,    0,  201,  198,  198,  198,    0,  198, 
            0,    0,    0,    0,  205,    0,    0,    0,    0,  198, 
          198,    0,    0,    0,    0,    0,  205,    0,  198,  198, 
            0,  198,  198,  198,  198,  198,    0,    0,  201,    0, 
           59,   59,   59,  198,    0,   59,   59,   59,    0,   59, 
            0,    0,  201,  201,    0,  199,    0,    0,    0,   59, 
           59,    0,    0,    0,    0,  199,    0,    0,   59,   59, 
            0,   59,   59,   59,   59,   59,  198,    0,    0,  198, 
            0,    0,  198,    0,  198,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  199, 
          198,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,  199,  199,    0,    0,    0,    0,   59, 
            0,    0,   59,    0,    0,    0,    0,    0,    0,    0, 
          200,  200,  200,    0,    0,  200,  200,  200,    0,  200, 
           59,    0,    0,    0,    0,    0,    0,    0,    0,  200, 
          200,    0,    0,    0,    0,    0,    0,   43,  200,  200, 
            0,  200,  200,  200,  200,  200,    0,   43,    0,    0, 
          239,  239,  239,  200,  197,  239,  239,  239,    0,  239, 
            0,    0,    0,    0,  197,    0,    0,    0,    0,  239, 
          239,    0,    0,    0,    0,    0,    0,    0,  239,  239, 
            0,  239,  239,  239,  239,  239,  200,    0,    0,  200, 
            0,    0,  200,  239,  200,    0,   43,    0,  197,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          200,    0,  197,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,  200,    0,    0,    0,  239,    0,    0,  239, 
            0,    0,  239,    0,  239,    0,  201,  201,  201,    0, 
            0,  201,  201,  201,    0,  201,    0,    0,    0,    0, 
          239,  330,    0,    0,    0,  201,  201,    0,    0,    0, 
            0,  330,  239,    0,  201,  201,    0,  201,  201,  201, 
          201,  201,    0,    0,    0,    0,    0,    0,    0,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  330,    0,  199,  199,  199, 
            0,    0,  199,  199,  199,    0,  199,    0,    0,    0, 
          330,    0,  201,    0,  330,  201,  199,  199,  201,    0, 
          201,    0,    0,    0,    0,  199,  199,    0,  199,  199, 
          199,  199,    0,    0,    0,    0,  201,    0,    0,    0, 
          199,    0,  330,    0,    0,    0,    0,    0,  201,    0, 
            0,    0,  331,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  331,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  199,    0,    0,  199,    0,    0,  199, 
            0,  199,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  331,  199,    0,   43, 
           43,   43,    0,    0,    0,   43,   43,    0,   43,  199, 
            0,  331,    0,    0,    0,  331,  197,  197,  197,    0, 
            0,  197,  197,  197,    0,  197,    0,    0,    0,    0, 
           43,   43,   43,   43,   43,  197,  197,    0,    0,    0, 
            0,    0,    0,  331,  197,  197,    0,  197,  197,  197, 
          197,    0,    0,    0,    0,    0,    0,    0,  294,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,  294,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  197,    0,    0,  197,    0,    0,  197,   43, 
          197,    0,  294,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  330,  330,  330,  197,  294,  330,  330, 
          330,  294,  330,    0,    0,    0,    0,    0,  197,    0, 
            0,    0,  330,  330,    0,    0,    0,    0,    0,    0, 
            0,  330,  330,    0,  330,  330,  330,  330,  330,  294, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  330,  330, 
          330,  330,  330,  330,  330,  330,  330,  330,  330,  330, 
          330,  330,    0,    0,  330,  330,  330,    0,    0,  330, 
            0,    0,  330,    0,    0,  330,    0,  330,    0,  330, 
          411,  330,    0,  330,  330,  330,  330,  330,  330,  330, 
          411,  330,    0,  330,  331,  331,  331,    0,    0,  331, 
          331,  331,    0,  331,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  331,  331,    0,    0,    0,    0,    0, 
            0,    0,  331,  331,   92,  331,  331,  331,  331,  331, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  411, 
            0,  101,    0,  411,    0,    0,    0,    0,    0,  331, 
          331,  331,  331,  331,  331,  331,  331,  331,  331,  331, 
          331,  331,  331,    0,    0,  331,  331,  331,    0,    0, 
          331,  411,    0,  331,    0,    0,  331,    0,  331,    0, 
          331,    0,  331,  495,  331,  331,  331,  331,  331,  331, 
          331,    0,  331,  495,  331,    0,    0,    0,    0,    0, 
          294,  294,  294,    0,    0,  294,  294,  294,    0,  294, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  294, 
          294,    0,    0,    0,    0,    0,    0,   90,  294,  294, 
            0,  294,  294,  294,  294,  294,    0,    0,    0,    0, 
            0,    0,  495,    0,   99,    0,  495,    0,    0,    0, 
            0,    0,    0,    0,    0,  294,  294,  294,  294,  294, 
          294,  294,  294,  294,  294,  294,  294,  294,  294,    0, 
            0,  294,  294,  294,  495,    0,  294,    0,    0,  294, 
            0,    0,  294,    0,  294,    0,  294,    0,  294,    0, 
          294,  294,  294,  294,  294,  294,  294,    0,  294,    0, 
          294,    0,  496,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  496,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  411,  411,  411,    0,   91,    0,  411,  411, 
            0,  411,    0,    0,    0,    0,    0,    0,    0,    0, 
          411,  496,    0,  100,    0,  496,    0,    0,    0,    0, 
          411,  411,    0,  411,  411,  411,  411,  411,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  496,    0,    0,    0,  411,  411,  411, 
          411,  411,  411,  411,  411,  411,  411,  411,  411,  411, 
          411,    0,    0,  411,  411,  411,    0,    0,    0,    0, 
            0,  411,    0,    0,    0,    0,    0,    0,  411,    0, 
          411,    0,  411,  411,  411,  411,  411,  411,  411,    0, 
          411,  411,  411,    0,    0,  495,  495,  495,    0,    0, 
            0,  495,  495,    0,  495,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  282,    0,  495,  495,    0,  495,  495,  495,  495, 
          495,  282,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          495,  495,  495,  495,  495,  495,  495,  495,  495,  495, 
          495,  495,  495,  495,    0,   98,  495,  495,  495,    0, 
          497,    0,    0,    0,  495,    0,    0,    0,    0,    0, 
          282,  495,  107,  495,  282,  495,  495,  495,  495,  495, 
          495,  495,    0,  495,    0,  495,    0,  291,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  291,    0,    0, 
            0,    0,  282,    0,  496,  496,  496,    0,    0,    0, 
          496,  496,    0,  496,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          270,   97,  496,  496,    0,  496,  496,  496,  496,  496, 
          270,    0,    0,    0,    0,    0,  291,    0,  106,    0, 
          291,    0,    0,    0,    0,    0,    0,    0,    0,  496, 
          496,  496,  496,  496,  496,  496,  496,  496,  496,  496, 
          496,  496,  496,    0,  266,  496,  496,  496,  291,  498, 
            0,    0,    0,  496,    0,    0,    0,    0,    0,  270, 
          496,  264,  496,    0,  496,  496,  496,  496,  496,  496, 
          496,  264,  496,    0,  496,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  266,    0,    0, 
            0,    0,    0,    0,    0,  264,    0,  266,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          264,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  266,    0,  282,  282,  282,    0,    0,    0,  282, 
          282,    0,  282,    0,    0,    0,  266,    0,   61,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   61,    0, 
            0,  282,  282,    0,  282,  282,  282,  282,  282,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  282,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,    0,   63,  282,  282,  282,   61,    0,  291, 
          291,  291,  282,   63,    0,  291,  291,    0,  291,  282, 
            0,  282,    0,  282,  282,  282,  282,  282,  282,  282, 
            0,  282,    0,  282,    0,    0,    0,  291,  291,    0, 
          291,  291,  291,  291,  291,    0,    0,    0,    0,    0, 
            0,    0,  270,  270,  270,    0,    0,  270,  270,  270, 
            0,  270,   63,    0,  291,  291,  291,  291,  291,  291, 
          291,  291,  291,  291,  291,  291,  291,  291,    0,    0, 
          291,  291,  291,  270,  270,  270,  270,  270,  291,    0, 
            0,    0,    0,    0,    0,  291,    0,  291,    0,  291, 
          291,  291,  291,  291,  291,  291,  400,  291,    0,  291, 
            0,    0,    0,  264,  264,  264,  400,   51,  264,  264, 
          264,    0,  264,    0,    0,    0,    0,   51,  270,    0, 
            0,  270,  264,  264,    0,    0,    0,    0,    0,    0, 
            0,  264,  264,    0,  264,  264,  264,  264,  264,  266, 
          266,  266,  270,    0,  266,  266,  266,    0,  266,    0, 
            0,    0,    0,    0,    0,  400,    0,    0,  266,  266, 
            0,    0,    0,    0,    0,    0,   51,  266,  266,    0, 
          266,  266,  266,  266,  266,    0,    0,    0,    0,    0, 
            0,    0,  264,   53,    0,  264,    0,  264,    0,    0, 
            0,    0,    0,   53,    0,    0,    0,    0,    0,    0, 
           61,   61,   61,  264,    0,   61,   61,   61,    0,   61, 
            0,    0,    0,    0,    0,    0,    0,    0,  266,   61, 
           61,  266,    0,  266,    0,    0,   55,    0,   61,   61, 
            0,   61,   61,   61,   61,   61,   55,   56,    0,  266, 
            0,    0,   53,    0,    0,    0,    0,   56,    0,    0, 
            0,    0,    0,    0,    0,   63,   63,   63,    0,    0, 
           63,   63,   63,    0,   63,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   63,   63,    0,    0,    0,   61, 
            0,    0,   61,   63,   63,   55,   63,   63,   63,   63, 
           63,    0,    0,    0,    0,    0,   56,  271,    0,    0, 
           61,    0,    0,    0,    0,    0,    0,  271,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   63,    0,    0,   63,    0,    0, 
            0,  267,    0,    0,    0,    0,    0,   52,    0,    0, 
            0,    0,    0,    0,    0,   63,  271,   52,  400,  400, 
          400,    0,    0,  400,  400,  400,    0,  400,    0,   51, 
           51,   51,    0,    0,   51,   51,   51,  400,   51,    0, 
            0,    0,    0,    0,  197,    0,  400,  400,   51,  400, 
          400,  400,  400,  400,  197,    0,    0,   51,   51,    0, 
           51,   51,   51,   51,   51,    0,   52,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  269,    0,  400,    0,    0,    0,  241,    0, 
            0,  400,  269,    0,    0,    0,    0,  400,    0,   25, 
            0,    0,    0,  197,    0,   53,   53,   53,   51,   25, 
           53,   53,   53,    0,   53,    0,    0,    0,  400,    0, 
            0,    0,    0,    0,   53,    0,  264,    0,    0,   51, 
            0,    0,    0,   53,   53,    0,   53,   53,   53,   53, 
           53,  269,    0,    0,    0,    0,    0,    0,   55,   55, 
           55,    0,    0,   55,   55,   55,    0,   55,   25,   56, 
           56,   56,    0,    0,   56,   56,   56,   55,   56,    0, 
            0,    0,    0,    0,    0,    0,   55,   55,   56,   55, 
           55,   55,   55,   55,   53,    0,    0,   56,   56,    0, 
           56,   56,   56,   56,   56,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   53,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  271, 
          271,  271,    0,    0,  271,  271,  271,   55,  271,    0, 
            0,    0,    0,    0,  618,    0,    0, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,   56,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   55,    0,  271,  271,  271,  271,  271,    0,    0, 
            0,    0,   56,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   52,   52,    0,    0,   52,   52,   52, 
            0,   52,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   52,    0,    0,    0,    0,    0,    0,  271,    0, 
            0,  271,    0,   52,   52,   52,   52,   52,    0,  197, 
          197,  197,    0,    0,    0,  197,  197,    0,  197,    0, 
            0,    0,  271,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  197,  197,    0, 
          197,  197,  197,  197,    0,    0,    0,  269,  269,  269, 
            0,   52,    0,  269,  269,    0,  269,    0,    0,    0, 
            0,    0,    0,    0,   25,   25,   25,    0,    0,    0, 
           25,   25,   52,   25,    0,    0,    0,    0,  269,  269, 
          269,  269,  269,  435,    0,    0,    0,    0,  197,    0, 
            0,    0,    0,    0,    0,   25,   25,   25,   25,   25, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  197, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  269,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   25,    0,    0,    0,  269,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,   25,   12,   13,   14,  109,  110, 
           17,   18,    0,    0,    0,    0,  111,  112,  113,   22, 
           23,   24,   25,    0,    0,  114,    0,    0,    0,    0, 
            0,    0,  115,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,    0,    0,  118, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  309, 
            0,    0,  121,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,    0,    0, 
            0,    4,    5,    6,    7,  228,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,    0,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  131, 
          132,  133,  134,  135,  136,  137,  138,    0,    0,  139, 
          140,  141,  142,  143,    0,    0,  144,  145,  146,  147, 
          148,  149,  150,    0,    0,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,  161,  162,  163,  164,  165, 
          166,  167,  168,  169,  170,  171,  172,    0,  173,  174, 
           36,   37,  175,   39,    0,    0,  176,  177,    0,  178, 
          179,  180,  181,  182,  183,  184,    0,    0,  185,  186, 
            0,    0,    0,  187,  188,  189,  190,    0,    0,    0, 
            0,    0,  191,    0,    0,    0,    0,    0,    0,  192, 
          193,    0,  194,  195,  196,  197,  198,  199,  200,  201, 
          202,  203,  204,    0,    0,  205,    0,    0,    0,    0, 
            0,  131,  132,  133,  134,  135,  136,  137,  138,    0, 
            0,  139,  140,  141,  142,  143,    0,  206,  144,  145, 
          146,  147,  148,  149,  150,    0,    0,  151,  152,  153, 
          212,  213,  214,  215,  158,  159,  160,  161,  162,  163, 
          164,  165,  166,  167,  168,  169,  216,  217,  218,    0, 
          219,  174,  319,  320,  220,  321,    0,    0,  176,  177, 
            0,  178,  179,  180,  181,  182,  183,  184,    0,    0, 
          185,  186,    0,    0,    0,  187,  188,  189,  190,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  192,  193,    0,  194,  195,  196,  197,  198,  199, 
          200,  201,  202,  203,  204,    0,    0,  205,    0,    0, 
            0,    0,    0,  131,  132,  133,  134,  135,  136,  137, 
          138,    0,    0,  139,  140,  141,  142,  143,    0,  206, 
          144,  145,  146,  147,  148,  149,  150,    0,    0,  151, 
          152,  153,  212,  213,  214,  215,  158,  159,  160,  161, 
          162,  163,  164,  165,  166,  167,  168,  169,  216,  217, 
          218,    0,  219,  174,  285,    0,  220,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,    0,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,    0,    0,  205, 
           52,    0,    0,    0,    0,  131,  132,  133,  134,  135, 
          136,  137,  138,    0,    0,  139,  140,  141,  142,  143, 
            0,  206,  144,  145,  146,  147,  148,  149,  150,    0, 
            0,  151,  152,  153,  212,  213,  214,  215,  158,  159, 
          160,  161,  162,  163,  164,  165,  166,  167,  168,  169, 
          216,  217,  218,    0,  219,  174,    0,    0,  220,    0, 
            0,    0,  176,  177,    0,  178,  179,  180,  181,  182, 
          183,  184,    0,    0,  185,  186,    0,    0,    0,  187, 
          188,  189,  190,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  192,  193,    0,  194,  195, 
          196,  197,  198,  199,  200,  201,  202,  203,  204,    0, 
            0,  205,   52,    0,    0,    0,    0,  131,  132,  133, 
          134,  135,  136,  137,  138,    0,    0,  139,  140,  141, 
          142,  143,    0,  206,  144,  145,  146,  147,  148,  149, 
          150,    0,    0,  151,  152,  153,  212,  213,  214,  215, 
          158,  159,  160,  161,  162,  163,  164,  165,  166,  167, 
          168,  169,  216,  217,  218,    0,  219,  174,    0,    0, 
          220,    0,    0,    0,  176,  177,    0,  178,  179,  180, 
          181,  182,  183,  184,    0,    0,  185,  186,    0,    0, 
            0,  187,  188,  189,  190,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  192,  193,    0, 
          194,  195,  196,  197,  198,  199,  200,  201,  202,  203, 
          204,    0,    0,  205,    0,    0,    0,    0,    0,    0, 
            3,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,  206,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,  227, 
            4,    5,    6,    7,  228,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,    0, 
            0,   27,   28,    0,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,   65,   66,  227,    4, 
            5,    6,    7,  228,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,  295,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,    0,    0,  111,  112,  113,   22,   23,   24,   25, 
            0,    0,  114,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  261,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,    0,    0,  121, 
            0,    0,   46,   47,    0,   48,    0,  677,    0,  263, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  264, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,  265,  259,  259,  259,    0, 
          259,    0,    0,    0,  259,  259,    0,    0,    0,  259, 
            0,  259,  259,  259,  259,  259,  259,  259,    0,    0, 
            0,    0,  259,  259,  259,  259,  259,  259,  259,    0, 
            0,  259,    0,    0,    0,    0,    0,    0,  259,    0, 
            0,  259,  259,  259,    0,  259,  259,  259,  259,  259, 
          259,  259,  259,  259,  259,  259,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  259,    0,    0,  259,    0, 
            0,  259,  259,    0,  259,    0,  259,    0,  259,    0, 
          259,    0,    0,    0,    0,    0,    0,    0,  259,    0, 
            0,    0,    0,  259,  259,  259,  259,  259,  259,    0, 
            0,    0,  259,    0,  259,  259,    0,  259,  259,  259, 
          259,    0,  259,  259,  259,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  109,  110,   17,   18,    0,    0,    0, 
            0,  111,  112,  113,   22,   23,   24,   25,    0,    0, 
          114,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          261,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  235,    0,    0,  121,    0,    0, 
           46,   47,    0,   48,    0,  262,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,  265,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  109,  110,   17,   18,    0,    0,    0,    0, 
          111,  112,  113,   22,   23,   24,   25,    0,    0,  114, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  261, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  235,    0,    0,  121,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,  263,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  264,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
           65,   66,  265,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,   22,   23,   24,   25,    0,    0,  114,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,  261,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,    0,    0,  121,    0,    0,   46,   47, 
            0,   48,    0,  677,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  264,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,  265,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          109,  110,   17,   18,    0,    0,    0,    0,  111,  112, 
          113,   22,   23,   24,   25,    0,    0,  114,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,  261,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  235,    0,    0,  121,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  264,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,   65,   66, 
          265,    4,    5,    6,    7,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
           22,   23,   24,   25,    0,    0,   26,    0,    0,    0, 
            0,    0,   27,   28,   29,   30,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           44,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,   51,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,    0,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,    0,    0,  111,  112,  113,   22,   23,   24,   25, 
            0,    0,  114,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,    0,    0,  121, 
          469,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  264, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
          114,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  235,    0,    0,  121,    0,    0, 
           46,   47,    0,   48,    0,  609,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,   22,   23,   24,   25,    0,    0,  114,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,    0,    0,  121,    0,    0,   46,   47, 
            0,   48,    0,  609,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  264,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
           22,   23,   24,   25,    0,    0,  114,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,    0,    0,  121,    0,    0,   46,   47,    0,   48, 
            0,  262,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  109,  110,   17, 
           18,    0,    0,    0,    0,  111,  112,  113,   22,   23, 
           24,   25,    0,    0,  114,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,  121,    0,    0,   46,   47,    0,   48,    0,  871, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  264,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  109,  110,   17,   18,    0, 
            0,    0,    0,  111,  112,  113,   22,   23,   24,   25, 
            0,    0,  114,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  235,    0,    0,  121, 
            0,    0,   46,   47,    0,   48,    0,  677,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  264, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,   65,   66,  590,  590,  590,    0,  590, 
            0,    0,    0,  590,  590,    0,    0,    0,  590,    0, 
          590,  590,  590,  590,  590,  590,  590,    0,    0,    0, 
            0,  590,  590,  590,  590,  590,  590,  590,    0,    0, 
          590,    0,    0,    0,    0,    0,    0,  590,    0,    0, 
          590,  590,  590,    0,  590,  590,  590,  590,  590,  590, 
            0,  590,  590,  590,  590,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  590,    0,    0,  590,  590,    0, 
          590,  590,    0,  590,    0,    0,    0,    0,    0,  590, 
            0,    0,    0,    0,    0,    0,    0,  590,    0,    0, 
            0,    0,  590,  590,  590,  590,  590,  590,    0,    0, 
            0,  590,    0,  590,  590,    0,  590,  590,  590,  590, 
            0,  590,  590,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  235,    0,    0,  121,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
           22,   23,   24,   25,    0,    0,  114,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,    0,    0,  121,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,  114,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,    0, 
            0,  121,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  264,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  590,  590,  590, 
            0,  590,    0,    0,    0,  590,  590,    0,    0,    0, 
          590,    0,  590,  590,  590,  590,  590,  590,  590,    0, 
            0,    0,    0,  590,  590,  590,  590,  590,  590,  590, 
            0,    0,  590,    0,    0,    0,    0,    0,    0,  590, 
            0,    0,  590,  590,  590,    0,  590,  590,  590,  590, 
          590,  590,    0,  590,  590,  590,  590,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  590,    0,    0,  590, 
            0,    0,  590,  590,    0,  590,    0,    0,    0,    0, 
            0,  590,    0,    0,    0,    0,    0,    0,    0,  590, 
            0,    0,    0,    0,  590,  590,  590,  590,  590,  590, 
            0,    0,    0,  590,    0,  590,  590,    0,  590,  590, 
          590,  590,    0,  590,  590,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  109,  110,   17,   18,    0,    0,    0, 
            0,  111,  112,  113,   22,   23,   24,   25,    0,    0, 
          114,    0,    0,    0,    0,    0,    0,  115,    0,    0, 
           31,   32,   33,    0,  116,   35,   36,   37,  117,   39, 
            0,   40,    0,    0,  118,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  120,    0,    0,  121,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,   65,   66,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  109,  110,   17,   18,    0,    0,    0,    0,  111, 
          112,  113,   22,   23,   24,   25,    0,    0,  114,    0, 
            0,    0,    0,    0,    0,  115,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
            0,    0,  118,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  309,    0,    0,  389,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,   65, 
           66,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  109, 
          110,   17,   18,    0,    0,    0,    0,  111,  112,  113, 
           22,   23,   24,   25,    0,    0,  114,    0,    0,    0, 
            0,    0,    0,  115,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          118,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          882,    0,    0,  121,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,   65,   66,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  109,  110,   17, 
           18,    0,    0,    0,    0,  111,  112,  113,   22,   23, 
           24,   25,    0,    0,  114,    0,    0,    0,    0,    0, 
            0,  115,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,    0,    0,  118,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  932,    0, 
            0,  121,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,   65,   66,  633,  597,    0, 
            0,  634,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,    0,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204,  656,  591,  205,    0,  657,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,  206,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,  279,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,  658,  597,  205, 
            0,  659,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,  206,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204,  670,  591,  205,    0,  671,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,  206,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,  279,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,  672,  597,  205, 
            0,  673,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,  206,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204,  698,  591,  205,    0,  699,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,  206,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,  279,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,  700,  597,  205, 
            0,  701,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,  206,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204,  984,  591,  205,    0,  985,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,  206,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,  279,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,  986,  597,  205, 
            0,  987,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,  206,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,  279,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204, 1011,  597,  205,    0, 1012,    0,    0,    0, 
          176,  177,    0,  178,  179,  180,  181,  182,  183,  184, 
            0,    0,  185,  186,    0,    0,  206,  187,  188,  189, 
          190,    0,    0,    0,    0,    0,  279,    0,    0,    0, 
            0,    0,    0,  192,  193,    0,  194,  195,  196,  197, 
          198,  199,  200,  201,  202,  203,  204,  604,  591,  205, 
            0,  605,    0,    0,    0,  176,  177,    0,  178,  179, 
          180,  181,  182,  183,  184,    0,    0,  185,  186,    0, 
            0,  206,  187,  188,  189,  190,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  192,  193, 
            0,  194,  195,  196,  197,  198,  199,  200,  201,  202, 
          203,  204,    0,    0,  205,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  206, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,   99,    6,    7,   10,   11,   74,  244,   26,  333, 
           28,  409,   21,    7,    6,  271,   45,   27,   11,  432, 
           15,   16,    7,   27,   19,    3,  388,  448,   51,  382, 
          451,  544,  437,   27,   15,   16,    2,    3,   19,   10, 
           10,  451,   27,    0,  417,   47,   48,   10,   52,    0, 
           49,   10,   59,  380,  381,  408,   10,  120,  385,   68, 
           52,  333,  819,   45,   91,   10,   47,   48,  304,   10, 
           59,  307,  724,    0,  427,   10,  486,  535,  536,  406, 
           10,   10,  907,   10,   10,   10,   10,  411,  441,   59, 
           44,  106,  121,   10,    4,    5,   59,  115,  425,  426, 
           21,  553,  471,  737,   14,   59,   10,   10,    2,    3, 
            4,    5,  439,  106,    8,    9,   10,   11,   59,   44, 
           14,   15,   16,   10,   59,   19,   44,  726,  305,   59, 
           59,  124,   59,   59,   59,   59,  280,  589,   10,   49, 
          280,   10,  495,   61,   61,   10,  473,   68,   10,   10, 
           10,   45,   46,  106,  928,   49,   59,   51,   15,   16, 
          340,   10,   19,  325,   43,  327,  493,  329,  344,  994, 
          637,  305,   59,  335,  341,  748,  496,   10,  392,   10, 
           10,  754,   44,   44,   44,   32,  362,   59,   10,   99, 
           47,  358,  113,  660,  290,  291,   61,  374,  522,  956, 
          340,  122,  416,   10,  460,   99,  840,  674,   10,   10, 
           59,   44,  310,   44,   44,   10,  231,  361,   10,   10, 
          325,  361,   10,   10,   10,  119,   59,  121,   59,   59, 
           10, 1005,  247,  631,   10,  702,   10,   59,  231,  118, 
          374,  295,   91,   10,  642,  251,  252,   10,   10,  340, 
          522,  308,   44,  358,  247,   10,  908,   44,   44,   10, 
          289,  227,   10,  684,  685,   10,  295,   59,   59,   10, 
          282,   32,  924,   59,   61,  685,  645,  279,  231,   59, 
           10,  276,   10,  278,  279,   61,  298,  361,  300,  662, 
          742,   10,   59,  256,   10,  276,   44,  278,  618,   61, 
           32,  328,   10,   32,   59,   10,   10,   10,  335,  341, 
           10,   59,  310,  295,   59,  914,  640,   10,  375,  376, 
            0,  262,  263,  264,  837,  269,  358,  271,  269,  365, 
           10,  844,  267,  227,  228,  389,  849,   32,  267,  345, 
          346,  347,  348,   59,  407,  290,  291,   32,  510, 1001, 
          306,  358,  341,  337,  310,  281,   44,  251,  252,   59, 
          389,  279,  279,  386,   61,  388,   59,  825,  640,  392, 
          393,  829,  830,  344,  832,  282,  834,  381,   61,   59, 
          382,  340,  276,  349,  278,  279,  548,  382,  282,  337, 
          284,  390,  362,  356,  423,  289,  801,  340,  496,  761, 
          310,  295,  431,  407,  358,  362,  408,  389,   44,  402, 
           91,  362,   10,  408,  416,  417,  310,  395,  267,  276, 
          361,  278,  426,  679,  341,  427,  262,  664,  358,  395, 
          264,  280,  427,  358,  358,  362,  440,  341,  341,  441, 
          344,  453,  264,  436,  437,  765,  441,  269,  337,  461, 
          462,  345,  346,  347,  348,  349,  350,  351,  468,  380, 
          696,   10,  975,   61,  468,  477,  310,  448,  480,  471, 
          474,  358,  341,  264,  468,  305,  341,  875,  899,  328, 
          390,   48,  895,  468,   61,  406,  335,  267,  382,  899, 
          494,  340,  386,  495,  388,  389,  390,   91,  392,  393, 
          495,  395,  483,  279,  425,  471,  964,  965,  966,  967, 
           59,  341,  361,  305,  408,  409,  410,  279,  439,  305, 
          618,  988,  895,  370,  371,  358,  420,  358,  358,  423, 
          377,  388,  337,  427,  341,  392,  271,  431,  305,  341, 
          341,   91,   91,  780,  374,  943,  341,  441,  804,  341, 
          552,  553,  473,  341,  341,  341,  880,  305,  338,  416, 
          305, 1019,  262,  263,  264,  341,  358,  341,  268,  269, 
          588,  271,  493,   59,  341,  469,  433,  471,  341,  341, 
          279,  344,  374,  310,  593,  603,  496,  589,  374,  338, 
          599,  593,   44,  341,  947,   44,  341,  606,   91,  697, 
          341,  495,  496,  344,  606,  617,  317,  374,   44,  370, 
          371,  341,  337,  341,  344,  724,  377,  726,  945,  637, 
          341,  650,  341,  361,  630,  341,  374,  639,  737,  374, 
          632,   10,   10,  341,  644,  628,  341,  341,  341,  643, 
          644,  341,  660,  645,  268,  269,  648,  328,  641,  651, 
          644,  643,  654,  890,  335,  317,  674,    2,    3,  644, 
          662,  362,  362,    8,    9,   10,   11,  765,   10,  675, 
           15,   16,  593,   44,   19,  704,  344,  689,  599,  645, 
          328,  279,   61,   61,  702,  606,   91,  335,   91,  310, 
          758,   91,  721,  722,  261,  262,  263,  715,  265,   10, 
           45,   46,  714,  684,   10,   44,   51,  372,  618,  372, 
          739,  632,  741,  372,  635,  744,  372,   59,  267,  737, 
           91,  333,  745,  746,  618,   44,  346,  317,  751,  752, 
          372,  280,  349,  350,  328,  377,  630,  631,  761,   10, 
          742,  335,   10,  341,  372,  370,  371,   44,  642,  377, 
           61,  645,  377,  817,  783,   61,  650,  382,  348,  263, 
          264,  773,  352,  353,   10,  269,  372,  340,  797,  798, 
          799,  377,   91,  269,  119,  768,  121,   10,  328,  328, 
          786,  675,   10,   10,  372,  335,  335,  697,  267,  377, 
           61,  340,  361,   61,    2,    3,    4,    5,   44,  411, 
            8,  263,  264,  697,  816,  914,   14,  264,  801,  341, 
          704,  362,  361,   59,   10,  924,   44,   44,   44,  928, 
           44,  388,  840,   44,  853,  392,   59,  721,  722,   10, 
           10,   32,   59,   61,  306,  328,   61,   45,  306,  903, 
           44,   49,  335,  866,   44,  739,   44,  741,   44,  416, 
          744,  745,  746,   44,   44,  765,  306,  751,  752,  888, 
           32,  337,  337,   91,   44,   61,  433,  761,   10,  779, 
          306,  765,  308,  309,  310,  311,  337,  337,   59,   59, 
          447,  448,  227,  228,  451,  779,   61,  308,  309,  783, 
          311,   99,  786,  895,  958,   91, 1005,   44,   44,  264, 
          279,  279,   44,  797,  798,  799,  251,  252,  279,  521, 
          522,   91,  338,  121,  263,  337,  483,   59,   10,  486, 
          949,  263,  264,  328,  337,  328,  955,   44,  328,  993, 
          335,  276,  335,  278,  279,  335,  337,  282,  337,  284, 
          850,  264,  946,  961,  289,  947,   10,  362,   10,   91, 
          295,   44,  947,   58,  375,  376,  850,  328,  344,  853, 
          279,  337,  341,  341,  335,   10,   10,   59,  279,  340, 
          988,  264,  866,  279,   91,  264,  980,  362,  545,  264, 
          337,  875,   44,  264,   44,    9,   10,   11,  990,   15, 
           16,   44,  362,   19,  888,   59,   59,  341,   44,   61, 
          345,  346,  347,  348,  349,  350,  351,  264,  279,  328, 
          920,  279,  362,   44,   59,   59,  335,   44,   10,  227, 
          228,  267,   46,   10,  945,   44,  920,   91,  640,   91, 
          341,  264,  370,  371,  372,  341,  269,  382,  271,  377, 
          267,  386,  609,  388,  389,   44,   91,  392,  393,  943, 
          395,  279,  280,  947,   44,  949,    2,    3,    4,    5, 
            6,  955,    8,  408,  409,  410,   61,   44,   14,   44, 
          341,   44,   59,  341,  358,  420,  264,   44,  423,  362, 
          264,  289,  427,  279,  280,  317,  431,  295,  378,  379, 
          380,  381,  338,  310,  264,  119,  441,  709,  710,   45, 
          328,   91,  310,   49,   91,  264,  358,  335,   10,  362, 
          677,  310,  724,  341,  726,  264,  348,  684,  685,   44, 
          352,  353,  354,  355,  469,  306,  471,  308,  309,  310, 
          311,  312,  328,  361,   44,   44,  317,  264,  280,  335, 
           44,  349,  264,   44,  340,  341,   44,  328,  328,  716, 
          495,   44,  271,   99,  335,  335,  362,   59,  339,  340, 
          340,  344,  279,  280,  340,  361,  347,  348,  349,  350, 
          262,  263,  264,  271,  341,  121,  268,  269,  358,  271, 
          344,  389,  390,  370,  371,  372,  328,  395,  362,   91, 
          377,  344,  344,  335,   58,  762,  264,  209,  340,   70, 
           54,  409,  335,  267,  385,  817,    5,  819,  420,  990, 
            6,  328,  420,  606,  880,  423,  358,  279,  335,  361, 
          264,  724,  267,  431,  268,  269,   10,  251,  252,  796, 
          737,    2,    3,    4,    5,    6,  728,    8,  370,  371, 
          372,    2,    3,   14,  361,  377,  757,    8,  926,  341, 
          276,  924,  278,   14,   10,  370,  371,  372,  282,   10, 
          284,   14,  377,  471,  328,   44,  328,  709,  880,  948, 
          362,  335,  994,  335,   45,   59,  340,   -1,   49,  341, 
          267,  227,  228,  328,   45,  630,  631,   -1,  496,  279, 
          335,  903,  904,  280,   -1,   -1,  312,  642,   -1,   -1, 
          645,  317,  914,   59,  871,  650,   -1,   91,   59,   -1, 
           -1,   -1,   91,   -1,  306,   -1,  308,  309,  310,  311, 
          312,  345,  346,  347,  348,  317,  350,  351,   99,   -1, 
          675,   -1,  899,  349,  350,   91,   -1,   -1,  328,   -1, 
           91,  328,   -1,  289,  956,  335,  958,  339,  335,  295, 
          121,   10,   -1,  340,   -1,  347,  348,  349,  350,  704, 
          121,  370,  371,  372,  310,  267,   -1,   -1,  377,  385, 
           -1,   -1,  719,   44,  361,   -1,  721,  722,  280,  726, 
           -1,  993,   44,   -1,   -1,   44,  410,   -1,   -1,   -1, 
          737,   10,   -1,  385,  739,   -1,  741,   -1,   -1,  744, 
          745,  746,   61,  349,   -1,   -1,  751,  752,   -1,   -1, 
          618,   -1,   -1,   -1,   10,   -1,  761,  370,  371,  372, 
           91,    2,    3,  631,  377,   -1,  328,    8,   10,   91, 
           -1,   -1,   91,  335,  642,   -1,   10,  645,  783,   -1, 
           59,  786,  650,  389,  390,  469,   -1,   -1,   44,  395, 
           -1,   -1,  797,  798,  799,   -1,  227,  228,   -1,  361, 
           -1,   -1,   44,  409,   45,   61,  227,  228,   -1,   -1, 
           44,   10,   -1,   -1,  420,   -1,   -1,  423,   -1,   61, 
           -1,   10,   -1,  267,   -1,  431,   -1,   61,   44,  697, 
           -1,  370,  371,  372,   -1,   91,  704,  705,  377,   -1, 
          279,  280,   -1,   -1,   -1,   44,   -1,   -1,  853,   91, 
          317,  267,   -1,  721,  722,   44,  267,   91,  289,   -1, 
           -1,  866,   61,   -1,  295,  471,  333,  334,  289,   -1, 
          875,  739,   61,  741,  295,   91,  744,   -1,   44,  310, 
          121,  348,   -1,  888,  328,  352,  353,  354,  355,  328, 
          496,  335,   91,  370,  371,  372,  335,  765,   -1,   -1, 
          377,  340,   91,   -1,   -1,  912,   -1,  914,   -1,  916, 
           -1,  779,  328,   10,  921,  783,   -1,  328,  349,  335, 
           -1,  928,  361,   -1,  335,   91,   -1,   -1,  349,  797, 
          798,  799,   44,  293,  294,  295,  296,  297,  943,   -1, 
           -1,   -1,  947,   -1,  949,   -1,  630,   -1,  279,   -1, 
          955,  306,   -1,  308,  309,  310,  311,  279,  389,  390, 
          279,  280,   59,   -1,  395,   -1,   -1,  388,  389,  737, 
           -1,   -1,   -1,   -1,  395,   -1,   -1,   -1,  409,   -1, 
           -1,   -1,  850,   -1,  339,  853,  227,  228,  409,  420, 
          997,  675,  423,   -1,   -1,   -1, 1003,  328, 1005,  420, 
          431, 1008,  423,   -1,  335,   -1,  328,  875,   -1,  328, 
          431,   -1,  618,  335,   -1,   -1,  335,   -1,   -1, 1026, 
          888,  340,  341,  279,  280,  631,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,  642,  279,  317,  645, 
          471,   -1,  361,   -1,  650,  279,   -1,   -1,  289,  328, 
          471,   -1,  920,   -1,  295,   -1,  335,   -1,   -1,   -1, 
          339,  340,   -1,  279,  280,  496,   -1,   -1,  347,  348, 
          349,  350,  328,   10,   -1,  943,   -1,   -1,   -1,  335, 
          279,  949,   -1,   -1,  340,  341,  328,  955,   -1,   -1, 
          279,  697,   -1,  335,  328,   -1,   -1,   -1,  704,  341, 
           -1,  335,  786,   -1,   -1,  361,  385,  341,  349,  728, 
           -1,   -1,  328,  279,  280,  721,  722,   -1,  737,  335, 
           -1,   -1,   59,   -1,  340,  262,  263,  264,   -1,  328, 
           -1,  268,  269,  739,  271,  741,  335,   -1,  744,  328, 
           -1,  340,  341,   -1,   -1,  361,  335,   -1,  389,   -1, 
           -1,   -1,  341,  921,  395,   -1,  924,   -1,  926,  765, 
          928,  728,  328,   -1,  731,  262,  263,  264,  409,  335, 
          737,   -1,  269,  779,  340,   -1,   -1,  783,   -1,  420, 
           -1,  306,  423,  308,  309,  310,  311,  618,   -1,   -1, 
          431,  797,  798,  799,  306,  361,  308,  309,  310,  311, 
          631,   -1,   -1,   -1,  341,   -1,  262,  263,  264,   -1, 
          631,  642,  268,  269,  645,  271,   -1,   -1,   -1,  650, 
           -1,  642,   -1,   -1,  645,  362,   -1,   15,   16,  650, 
          471,   19,   -1, 1001,   -1, 1003,   -1, 1005,   -1,  317, 
         1008,   -1,   -1,   -1,  850,   -1,  306,  853,  308,  309, 
          310,  311,   -1,   41,   42,  333,  334,   -1, 1026,   47, 
           48,   -1,   50,   51,   -1,   -1,  697,   -1,   -1,  875, 
          348,   -1,  350,  704,  352,  353,  354,  355,   -1,  339, 
           -1,   -1,  888,  704,   -1,  341,   -1,  347,   -1,   -1, 
          721,  722,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
          721,  722,  921,   -1,   -1,  924,  362,  926,  739,  928, 
          741,   -1,   -1,  744,  920,  841,   -1,   -1,  739,  845, 
          741,   -1,   -1,  744,   -1,  339,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,  347,  765,   -1,   -1,  943,   10,   -1, 
          761,   -1,   -1,  949,   -1,   -1,   -1,   -1,  779,  955, 
           -1,   -1,  783,   -1,  921,   -1,   -1,  924,  779,  926, 
           -1,  928,  783,   -1,   -1,   -1,  797,  798,  799,  306, 
           -1,  308,  309,  310,  311,  312,  797,  798,  799,   -1, 
          317,   -1, 1001,   -1, 1003,   -1, 1005,   59,   -1, 1008, 
          631,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1, 
           -1,  642,  339,  340,  645,   -1,   -1, 1026,   -1,  650, 
          347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1,  850, 
           -1,   -1,  853,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  853,   -1, 1001,   -1, 1003,   -1, 1005,   -1, 
           -1, 1008,   -1,  969,  875,   -1,  972,  973,  385,   -1, 
          976,  977,   -1,   -1,  875,   -1,   -1,  888,   -1, 1026, 
           -1,   -1,   -1,  704,   -1,   -1,   -1,  888,   -1,   10, 
           -1,   -1,   -1,  261,  262,  263,  264,  265,   -1,   -1, 
          721,  722,   -1,   -1,   -1,   -1,   -1,   -1,  276,  920, 
          278,  279,   -1,   -1, 1020, 1021, 1022, 1023,  739,  287, 
          741,   -1,   -1,  744, 1030,   -1,   -1,   -1,   -1,   -1, 
          317,   -1,  943,   -1,   -1,  322,  323,   -1,  949,   -1, 
           -1,   -1,  943,   -1,  955,   -1,  333,  334,  949,   -1, 
           -1,   -1,   -1,   -1,  955,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  783,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   10,   -1,  797,  798,  799,   -1, 
           -1,   -1,   -1,   -1,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,  364,  365,  366,  367, 
          368,  369,  370,  371,  372,  373,  374,  375,  376,  377, 
          262,  263,  264,   -1,  382,  267,  268,  269,  386,  271, 
          388,   -1,   -1,   59,  392,  393,   -1,   10,   -1,  281, 
          282,   -1,  853,   -1,   -1,   -1,   -1,   -1,  290,  291, 
          408,  293,  294,  295,  296,  297,   -1,   -1,  416,   -1, 
           -1,   -1,   -1,   -1,  875,   -1,   -1,   -1,   -1,  427, 
          428,  429,  430,   -1,   -1,  433,   -1,  888,  317,   -1, 
           -1,   -1,   -1,  441,   -1,   -1,   59,   -1,   -1,  447, 
          448,   -1,   -1,  451,  333,  334,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  475,  476,  358, 
          362,  360,   -1,   -1,   -1,  483,   -1,   -1,  486,   -1, 
           -1,   -1,  943,   -1,   -1,   -1,   -1,  495,  949,   -1, 
           -1,   -1,   -1,   -1,  955,   10,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  545,  299,   -1, 
           -1,  302,  303,  304,   59,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,  336,   -1,  317,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,  339, 
           -1,  609,   -1,  364,  365,  366,  367,  368,  369,  349, 
          350,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  385,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   -1,    0,   -1, 
           -1,  317,   -1,   -1,   -1,  385,   -1,   -1,   10,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,  677, 
           -1,  347,  348,  349,  350,   -1,  684,  685,   -1,   -1, 
           -1,   -1,   44,  306,   -1,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,  328,   -1,   -1,  716,  385, 
           -1,   -1,  335,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   91, 
          306,   -1,  308,  309,  310,  311,  312,  745,  746,   -1, 
           -1,  317,   -1,  751,  752,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  760,  761,  762,   -1,   -1,   -1,  766,   -1, 
           -1,   -1,  385,  339,  340,   -1,   -1,   -1,    0,   -1, 
           -1,  347,  348,  349,  350,   -1,   -1,   -1,   10,   -1, 
           -1,  789,  790,  791,  792,   -1,   -1,   -1,  796,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,  312,   -1,   -1, 
           -1,   -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,  385, 
           -1,   -1,   44,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,   -1,   -1,   -1,  339,  340,   58,   59,   -1,   61, 
           -1,   63,  347,  348,  349,  350,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  854,  326,  327,   -1, 
           -1,   -1,   -1,   -1,  333,  334,   -1,   -1,  866,   91, 
           -1,   -1,   -1,  871,   -1,   -1,   -1,   -1,   -1,  348, 
          385,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,  892,   -1,   -1,   10,   -1,   -1, 
           -1,  899,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   59,  299,   -1,  947, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,  279,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,  337,  338,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
            0,  373,  374,  375,  376,   -1,  378,  379,  380,  381, 
           10,  383,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1, 
           -1,   -1,   -1,  306,   44,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   58,   59, 
          339,   61,   -1,   63,   -1,  328,   -1,   -1,  347,  348, 
          349,  350,  335,   -1,   -1,   -1,  339,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  385,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,  385,  265,  266,   -1,   -1,   -1,  270,    0, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   44,  316,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   58,   59,   -1, 
           61,  333,   63,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,  339,  340, 
           -1,   -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350, 
           91,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  385,   -1,   -1,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,  374,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  385,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,    0,  373,  374,  375,  376,   -1,  378,  379,  380, 
          381,   10,  383,  384,  385,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  306,   -1,  308, 
          309,  310,  311,  312,   -1,   -1,   -1,  339,  317,   58, 
           59,   -1,   61,   -1,   63,  347,  348,  349,  350,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  385,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,  385,   -1,   -1,  270, 
            0,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           10,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   44,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   59,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,  374,  375,  376,   -1,  378, 
          379,  380,  381,   -1,  383,  384,  385,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,  338,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,    0,  373,  374,  375,  376,   -1,  378,  379, 
          380,  381,   10,  383,  384,  385,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   -1,   -1,  317, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,   -1,   -1, 
           -1,  339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,  349,  350,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,  385,   -1,   -1, 
          270,    0,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   10,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   44,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  385,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   -1,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,    0,  373,  374,  375,  376,   -1,  378, 
          379,  380,  381,   10,  383,  384,  385,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306, 
          307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   44,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   58,   59,  340,   61,   -1,   63,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,  385,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,    0,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   10,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   59,  351,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  380,  381,   91,  383,  384,  385,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   63,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,  374,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  385,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   59,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,  341,  342,  343,  344, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,    0,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   10,  383,  384, 
          385,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   44,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1, 
           63,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,    0,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   10,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   59,   -1,  342,  343,   63, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   91,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   44, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   44,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   59,  340,   61,   -1, 
           63,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,  385,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,    0,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   10,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   91,  383,  384, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   63,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,  340,  341,  342,  343, 
           -1,  345,   -1,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,    0,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   10,  383, 
          384,  385,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   44,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   59,  340,   61,   -1, 
           63,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,  317,  318,  319,  320,  321,  322,  323,   91,   -1, 
          326,  327,   -1,   -1,   -1,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   10,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,  340,  341, 
          342,  343,   -1,  345,   -1,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   63,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,    0,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   10,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   59,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   10,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
           10,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   59, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,   -1,  341, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,  361, 
          362,   91,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   -1,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   10, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   59,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361, 
           91,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   10,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   91, 
           -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359, 
           -1,  361,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  256,  257,  258,  259,  260,  261, 
          262,  263,  264,  265,  266,   -1,   10,  269,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   10,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  256,  257,  258,  259,  260,  261,   -1,   -1,  264, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,    0,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   10,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   59,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,    0,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   10,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   58,   59,  351,   61,   -1,   63,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   91,  383,  384,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   58,   59, 
           -1,   61,   -1,   63,   -1,  280,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,  361,  362,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  374, 
           -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   58,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   91,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,   -1,  360,  361,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,    0,  333,  334,  335,   -1,  337,  338,   -1, 
           -1,  341,   10,   -1,  344,   -1,  346,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,    0,  333,  334,  335, 
           -1,  337,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   61,   -1,   63, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   91,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,  361,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,  348,   -1,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,    0,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          374,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   91,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           91,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,  374,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  348,    0,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   10,  360,   -1,  362,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,  374, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   91,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  374,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59, 
           -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   58, 
           59,   -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,    0,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   10,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           44,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   58,   59,   -1,   -1,   -1,   63, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   44,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  374,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,    0,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,   -1, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,    0,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   10,  360,   -1,  362, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,    0, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,  374,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   58,   59,  305, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,    0,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,  338,    0,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   10,  350,   -1,   -1,   -1, 
          354,  355,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,  262,  263,  264,   -1,   -1,  267,  268,  269,   44, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   58,   59,   -1,   -1,   -1,   63,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,    0,  346,   -1,   -1,   -1,  350, 
           -1,   -1,   -1,   -1,   10,  356,  357,  358,   -1,  360, 
           -1,  362,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  374,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   58,   59,   -1,   -1,   -1,   63,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,    0,  344,   -1,  346, 
           -1,   -1,   -1,  350,   -1,   -1,   10,   -1,   -1,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  281,  282,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           10,  346,   -1,   -1,   -1,  350,   -1,   -1,   -1,   -1, 
           -1,  356,  357,  358,   -1,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374, 
           -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,    0,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          356,  357,  358,   -1,  360,   -1,  362,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,  356,  357,  358,   -1,  360,   -1,  362,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   58,   59, 
           -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,    0,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  356,  357,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           58,   59,   -1,   -1,   -1,   63,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   10,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  356,  357,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          374,   -1,  262,  263,  264,   44,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  281,  282,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,    0,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,  356,  357,    0,   -1, 
           -1,   -1,  362,   -1,  262,  263,  264,   -1,   10,  267, 
          268,  269,   -1,  271,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   44,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           10,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  290,  291,   63,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   10,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  281,  282,  267,  268,  269,   -1,  271, 
           -1,   -1,  290,  291,    0,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  305,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
           -1,   -1,   58,   59,   -1,   -1,  338,   63,   -1,  341, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  374,  267,  268,  269, 
          362,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,    0,  362,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   10,   -1,   -1,  374,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330,   58, 
           59,   -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          362,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  362,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   10,  374,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1, 
           -1,   -1,  329,  330,   -1,   58,   59,   -1,   -1,   -1, 
           63,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,    0,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   10,   -1,   -1,  374,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   10,  324,  325,   -1,   -1,   -1, 
          329,  330,   58,   59,   -1,   -1,   -1,   63,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,  262, 
          263,  264,   -1,  362,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   58,   59,   -1,  374,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  362, 
           -1,   58,   59,   -1,    0,   -1,   -1,   -1,  281,  282, 
           -1,  374,   -1,   -1,   10,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   44,  362, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,  374,   58,   59,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,  262,  263,  264,  305, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  338,   -1,   -1,  341,   -1,   -1,  344,  305, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   44,  362,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,  374,   58, 
           59,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   44,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,  374,   58, 
           59,   -1,    0,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   10,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   44,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,  281,  282,  344,   -1,  346, 
           58,   59,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,  362,  262,  263,  264,  305, 
           -1,  267,  268,  269,   -1,  271,   -1,  374,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,  338,   -1,   -1,  341,   -1,   -1,  344,  305, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,  362,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,  374,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   59,  374,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,  262,  263,  264,  305,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  338, 
           -1,   -1,  341,   -1,   -1,  344,  305,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   44,  362,  262,  263,  264,   -1,   10,  267, 
          268,  269,   -1,  271,   -1,  374,   58,   59,   -1,  338, 
           -1,   -1,  341,  281,  282,  344,   -1,  346,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   44,  362,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1, 
          262,  263,  264,   -1,   10,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   44,   -1, 
          262,  263,  264,  305,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   58,   59,   -1,    0,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   10,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   58,   59,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,    0,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   10,   -1,   -1, 
          262,  263,  264,  305,    0,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  338,   -1,   -1,  341, 
           -1,   -1,  344,  305,  346,   -1,   59,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
          362,    0,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   10,  374,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           59,   -1,  338,   -1,   63,  341,  281,  282,  344,   -1, 
          346,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          305,   -1,   91,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  362,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,  374, 
           -1,   59,   -1,   -1,   -1,   63,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,  290,  291,   -1,  293,  294,  295, 
          296,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,  362, 
          346,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,  362,   59,  267,  268, 
          269,   63,  271,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,   -1,   -1,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348, 
            0,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           10,  360,   -1,  362,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   44,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
          338,   91,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   91,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   44,   -1,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,   59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   -1, 
          360,  361,  362,   -1,   -1,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   44,  333,  334,  335,   -1, 
          337,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           59,  348,   61,  350,   63,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   91,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   44,  290,  291,   -1,  293,  294,  295,  296,  297, 
           10,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   44,  333,  334,  335,   91,  337, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   59, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,  262,  263,  264,   -1,   -1,   -1,  268, 
          269,   -1,  271,   -1,   -1,   -1,   59,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,    0,  333,  334,  335,   59,   -1,  262, 
          263,  264,  341,   10,   -1,  268,  269,   -1,  271,  348, 
           -1,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   59,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  293,  294,  295,  296,  297,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,    0,  360,   -1,  362, 
           -1,   -1,   -1,  262,  263,  264,   10,    0,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   10,  338,   -1, 
           -1,  341,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,  262, 
          263,  264,  362,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,    0,   -1,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  362,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341,  281, 
          282,  344,   -1,  346,   -1,   -1,    0,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   10,    0,   -1,  362, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,  341, 
           -1,   -1,  344,  290,  291,   59,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   59,    0,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,  344,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   59,   10,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  281,  271,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,  290,  291,  281,  293, 
          294,  295,  296,  297,   10,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,  328,   -1,   -1,   -1,   44,   -1, 
           -1,  335,   10,   -1,   -1,   -1,   -1,  341,   -1,    0, 
           -1,   -1,   -1,   59,   -1,  262,  263,  264,  341,   10, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   44,   -1,   -1,  362, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   59,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   59,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  281,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  281,  293, 
          294,  295,  296,  297,  341,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  341,  271,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  362,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   -1,   -1,   -1,  262,  263,  264, 
           -1,  341,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,  362,  271,   -1,   -1,   -1,   -1,  293,  294, 
          295,  296,  297,   59,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,  362,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,  362,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,   -1,   -1, 
           -1,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,  260,  261,  262,  263,  264,   -1,   -1,  267, 
          268,  269,  270,  271,   -1,   -1,  274,  275,  276,  277, 
          278,  279,  280,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,  257,  258,  259,  260,  261,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  270,  271,   -1,  385,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  270,  271,   -1,  385, 
          274,  275,  276,  277,  278,  279,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  298,  299,  300,  301,  302,  303, 
          304,   -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
          364,   -1,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  270,  271, 
           -1,  385,  274,  275,  276,  277,  278,  279,  280,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,   -1,   -1,  310,   -1, 
           -1,   -1,  314,  315,   -1,  317,  318,  319,  320,  321, 
          322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331, 
          332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,   -1, 
           -1,  363,  364,   -1,   -1,   -1,   -1,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,  385,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,  385,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  256, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  380,  381,   -1,  383,  384,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  385,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,  349,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  380, 
          381,   -1,  383,  384,  385,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  385,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  380,  381,   -1, 
          383,  384,  385,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  385,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  380,  381,   -1,  383,  384, 
          385,  257,  258,  259,  260,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
          340,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          380,  381,   -1,  383,  384,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  380,  381, 
           -1,  383,  384,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
           -1,   -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  380,  381,   -1,  383, 
          384,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  380,  381,   -1,  383,  384,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  380,  381,   -1,  383,  384,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  385,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  385,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  385,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  385,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  385,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  385,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  385,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  385,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  306,  307,  363,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,  385,  331,  332,  333, 
          334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  306,  307,  363, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,  385,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  385, 
      };
   }

}
