/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.concurrent.util;

import co.paralleluniverse.common.reflection.GetAccessDeclaredField;
import java.lang.ref.Reference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;

public final class ThreadUtil {
    private static final Field threadLocalsField;
    private static final Field inheritableThreadLocalsField;
    private static final Field threadLocalMapTableField;
    private static final Field threadLocalMapEntryValueField;

    public static void dumpThreads() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Thread thread : threads.keySet()) {
            System.out.println((thread.isDaemon() ? "DAEMON  " : "        ") + thread.getName());
        }
    }

    public static void dumpThreadLocals() {
        try {
            Object threadLocals = threadLocalsField.get(Thread.currentThread());
            System.out.println(ThreadUtil.getThreadLocalsString(threadLocals));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void dumpInheritableThreadLocals() {
        try {
            Object threadLocals = inheritableThreadLocalsField.get(Thread.currentThread());
            System.out.println(ThreadUtil.getThreadLocalsString(threadLocals));
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getThreadLocalsString() {
        try {
            Object threadLocals = threadLocalsField.get(Thread.currentThread());
            return ThreadUtil.getThreadLocalsString(threadLocals);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getInheritableThreadLocalsString() {
        try {
            Object threadLocals = inheritableThreadLocalsField.get(Thread.currentThread());
            return ThreadUtil.getThreadLocalsString(threadLocals);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getThreadLocalsString(Object threadLocals) {
        try {
            if (threadLocals == null) {
                return "null";
            }
            Object table = threadLocalMapTableField.get(threadLocals);
            int threadLocalCount = Array.getLength(table);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < threadLocalCount; ++i) {
                Object entry = Array.get(table, i);
                if (entry == null) continue;
                Object value = threadLocalMapEntryValueField.get(entry);
                sb.append(((Reference)entry).get()).append(": ");
                sb.append(value != null ? value : "null");
                sb.append(", ");
            }
            return sb.toString();
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private ThreadUtil() {
    }

    static {
        try {
            threadLocalsField = AccessController.doPrivileged(new GetAccessDeclaredField(Thread.class, "threadLocals"));
            inheritableThreadLocalsField = AccessController.doPrivileged(new GetAccessDeclaredField(Thread.class, "inheritableThreadLocals"));
            Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            threadLocalMapTableField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapClass, "table"));
            Class<?> threadLocalMapEntryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
            threadLocalMapEntryValueField = AccessController.doPrivileged(new GetAccessDeclaredField(threadLocalMapEntryClass, "value"));
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError((Object)e.getCause());
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

