/*
 * Copyright (c) 2012 Karol Bucek
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kares.jruby;

import java.io.IOException;
import java.io.InputStream;

import javax.servlet.ServletContext;

/**
 * A manager implementation for a Servlet environment.
 * 
 * @author kares <self_AT_kares_DOT_org>
 */
public abstract class ServletWorkerManager extends WorkerManager {

    private final ServletContext context;
    
    public ServletWorkerManager(ServletContext context) {
        if (context == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = context;
        setThreadPrefix(context.getServletContextName());
    }

    public ServletContext getServletContext() {
        return context;
    }
    
    @Override
    public String getParameter(String key) {
        String val = context.getInitParameter(key);
        if (val == null) {
            val = super.getParameter(key);
        }
        return val;
    }
    
    @Override
    protected InputStream openPath(String path) throws IOException {
        return context.getResourceAsStream(path);
    }
    
    @Override
    protected void log(String message) {
        context.log(message);
    }

    @Override
    protected void log(String message, Exception e) {
        context.log(message, e);
    }
    
}
