/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt.asn1;

import impl.krypt.asn1.pem.PemInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.krypt.Errors;
import org.jruby.ext.krypt.Streams;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyPem {
    private RubyPem() {
    }

    private static void yieldToBlock(ThreadContext ctx, IRubyObject current, String jname, int ji, Block block) {
        RubyString name = ctx.getRuntime().newString(jname);
        RubyNumeric i = RubyNumeric.int2fix((Ruby)ctx.getRuntime(), (long)ji);
        block.yieldSpecific(ctx, current, (IRubyObject)name, (IRubyObject)i);
    }

    private static IRubyObject decodeAry(ThreadContext ctx, PemInputStream pem, Block block) throws IOException {
        byte[] bytes;
        Ruby runtime = ctx.getRuntime();
        ArrayList<RubyString> ary = new ArrayList<RubyString>();
        int i = 0;
        while ((bytes = Streams.consume(pem)) != null) {
            RubyString current = runtime.newString(new ByteList(bytes, false));
            if (block.isGiven()) {
                RubyPem.yieldToBlock(ctx, (IRubyObject)current, pem.getCurrentName(), i, block);
            }
            ++i;
            ary.add(current);
            pem.continueStream();
        }
        return runtime.newArray(ary);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject decode(ThreadContext ctx, IRubyObject recv, IRubyObject value, Block block) {
        try {
            Ruby rt = ctx.getRuntime();
            InputStream in = value.respondsTo("read") ? Streams.tryWrapAsInputStream(rt, value) : new ByteArrayInputStream(RubyPem.toPemIfPossible(value).convertToString().getBytes());
            PemInputStream pemin = new PemInputStream(in);
            return RubyPem.decodeAry(ctx, pemin, block);
        }
        catch (Exception e) {
            throw Errors.newPEMError(ctx.getRuntime(), e.getMessage());
        }
    }

    public static IRubyObject toPem(IRubyObject obj) {
        return obj.callMethod(obj.getRuntime().getCurrentContext(), "to_pem");
    }

    public static IRubyObject toPemIfPossible(IRubyObject asn1) {
        if (asn1.respondsTo("to_pem")) {
            return RubyPem.toPem(asn1);
        }
        return asn1;
    }

    public static void createPem(Ruby runtime, RubyModule krypt, RubyClass kryptError) {
        RubyModule mPEM = runtime.defineModuleUnder("PEM", krypt);
        mPEM.defineClassUnder("PEMError", kryptError, kryptError.getAllocator());
        mPEM.defineAnnotatedMethods(RubyPem.class);
    }
}

