/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.krypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.IOInputStream;
import org.jruby.util.IOOutputStream;

public class Streams {
    private Streams() {
    }

    public static InputStream tryWrapAsInputStream(Ruby runtime, IRubyObject io) {
        try {
            return new IOInputStream(io);
        }
        catch (IllegalArgumentException ex) {
            throw runtime.newArgumentError(ex.getMessage());
        }
    }

    public static OutputStream tryWrapAsOuputStream(Ruby runtime, IRubyObject io) {
        try {
            return new IOOutputStream(io);
        }
        catch (IllegalArgumentException ex) {
            throw runtime.newArgumentError(ex.getMessage());
        }
    }

    public static InputStream asInputStreamDer(Ruby runtime, IRubyObject value) {
        if (value.respondsTo("read")) {
            return Streams.tryWrapAsInputStream(runtime, value);
        }
        return new ByteArrayInputStream(Streams.toDerIfPossible(value).convertToString().getBytes());
    }

    public static InputStream asInputStreamPem(Ruby runtime, IRubyObject value) {
        if (value.respondsTo("read")) {
            return Streams.tryWrapAsInputStream(runtime, value);
        }
        return new ByteArrayInputStream(Streams.toPemIfPossible(value).convertToString().getBytes());
    }

    private static IRubyObject convertData(IRubyObject obj, String convertMeth) {
        return obj.callMethod(obj.getRuntime().getCurrentContext(), convertMeth);
    }

    private static IRubyObject convertDataIfPossible(IRubyObject data, String convertMeth) {
        if (data.respondsTo(convertMeth)) {
            return Streams.convertData(data, convertMeth);
        }
        return data;
    }

    public static IRubyObject toDer(IRubyObject obj) {
        return Streams.convertData(obj, "to_der");
    }

    public static IRubyObject toDerIfPossible(IRubyObject der) {
        return Streams.convertDataIfPossible(der, "to_der");
    }

    public static IRubyObject toPem(IRubyObject obj) {
        return Streams.convertData(obj, "to_pem");
    }

    public static IRubyObject toPemIfPossible(IRubyObject pem) {
        return Streams.convertDataIfPossible(pem, "to_pem");
    }

    public static void tryClose(Ruby runtime, InputStream in) {
        try {
            in.close();
        }
        catch (IOException ex) {
            throw runtime.newRuntimeError(ex.getMessage());
        }
    }

    public static void tryClose(Ruby runtime, OutputStream out) {
        try {
            out.close();
        }
        catch (IOException ex) {
            throw runtime.newRuntimeError(ex.getMessage());
        }
    }

    public static byte[] consume(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer)) != -1) {
            baos.write(buffer, 0, read);
        }
        if (baos.size() == 0) {
            return null;
        }
        return baos.toByteArray();
    }

    public static boolean isConsumed(InputStream in) {
        try {
            return in.read() == -1;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

